'******************************************************************************
'                       BCX - The Basic To C/C++ Translator
'            Copyright 1999-2025 Kevin Diggins  (All Rights Reserved)
'           Significant contributors to the BCX project have included:
' (Devs) Robert Wishlaw, Mike Henning, Wayne Halsdorf (RIP), Ljubisa Knezevic
' (Hosting)     Jeff Shollenberger, Fernando Ortiz (RIP), Dave Navarro
'******************************************************************************
'      BCX is distributed under the general conditions of the MIT License.
'                https://en.wikipedia.org/wiki/MIT_License
'******************************************************************************
' Permission is hereby granted, free of charge, to any person obtaining a copy
' of this software and associated documentation files (the "Software"), to deal
' in the Software without restriction, including without limitation the rights
' to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
' copies of the Software, and to permit persons to whom the Software is
' furnished to do so, subject to the following conditions:
'
' The above copyright notice and this permission notice shall be included in all
' copies or substantial portions of the Software.
'
' THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
' OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
' FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
' AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
' LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
' FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
' IN THE SOFTWARE.
'******************************************************************************

$NOINI                                   ' Do not use BCX.ini, if one exists
$GENFREE                                 ' Emit code that frees dynamic vars
$IPRINT_OFF                              ' Disable "\" to "\\" conversions
$WARNINGS_ON                             ' Enable compiler warnings
$NO_VKKEYS                               ' Do not output VKKEY definitions
'*******************************************************************************
MACRO __BCX__    = TRUE                  ' Tell BCX we are translating BC.bas
MACRO BCX_COLORS = TRUE                  ' Colorize (or not) BCX's output
MACRO BCXSTRINGS = 2048                  ' Default size for static string vars
MACRO VERSION$   = "8.2.8 (08/29/2025)"  ' Embed this into the executable
'*******************************************************************************
'  These BCX_STR equates are to remind BCX code maintainers from accidently
'  changing certain output lines of code that are used for $PROJECT SUPPORT.
'*******************************************************************************
MACRO BCX_STR_RUNTIME     = "Runtime Functions"
MACRO BCX_STR_VBS_STRUCTS = "VBScript Support Structures"
MACRO BCX_STR_USR_CONST   = "User Defined Macros"
MACRO BCX_STR_SYS_CONST   = "System Defined Macros"
MACRO BCX_STR_STD_PROTOS  = "Standard Prototypes"
MACRO BCX_STR_SYS_VARS    = "System Variables"
MACRO BCX_STR_USR_VARS    = "User's Global Variables"
MACRO BCX_STR_STD_MACROS  = "Standard Macros"
MACRO BCX_STR_MAIN_PROG   = "Main Program"
MACRO BCX_STR_USR_PROCS   = "User's Subs and Functions"
MACRO BCX_STR_USR_PROTOS  = "User's Prototypes"
MACRO BCX_STR_USR_TYPES   = "User Defined Types And Unions"
'*******************************************************************************
'           An assortment of macros used throughout the translator
'*******************************************************************************
MACRO IAm(X)               = ((X)<>1)
MACRO IAmNot(X)            = ((X)==0)
MACRO IDont(X)             = ((X)==0)
MACRO GetAsPosF(S, E)      = GetAsPos((S), (E), (1))
MACRO GetAsPosB(S, E)      = GetAsPos((S), (E), (-1))
MACRO iMatchLft(A, B)      = iMatch((A), (B), (0))
MACRO iMatchWrd(A, B)      = iMatch((A), (B), (1))
MACRO iMatchRgt(A, B)      = iMatch((A), (B), (2))
MACRO WordsInTable(A)      = (SIZEOF(A)/SIZEOF(A[0]))
MACRO GetBrkPairPos(S, E)  = GetBracketPair((S), (E), (1))
MACRO IVAL(A)              = atol((PCHAR)(A))
MACRO fprintf              = ReDirectFPrint
MACRO PADSIZE              = 1    '  Spacing after DIM datatypes
'*******************************************************************************
'                           User Defined Type Support
'*******************************************************************************
MACRO MaxTypes            =  2048 ' Max UDTS
MACRO MaxElements         =    64 ' Max UDT-Members
MACRO MaxLocalVars        = 16384 ' Max LOCALS
MACRO MaxGlobalVars       = 16384 ' Max GLOBALS
MACRO MaxLib              =    64 ' Max LIBRARIES
'*******************************************************************************
'                               Bracket Handling
'*******************************************************************************
MACRO c_SglQt             =   39
MACRO c_DblQt             =   34
MACRO c_LPar              =   40
MACRO c_RPar              =   41
MACRO c_Comma             =   44
MACRO c_LtBkt             =   91
MACRO c_RtBkt             =   93
'*******************************************************************************
ENUM
    vt_UNKNOWN             '  Not a Variable
    vt_STRLIT              '  "Quoted String Literal"
    vt_INTEGER             '  Integer%
    vt_SINGLE              '  Single!
    vt_DOUBLE              '  Double#
    vt_LDOUBLE             '  Long Double`
    vt_LLONG               '  Long Long
    vt_STRVAR              '  StringVariable$
    vt_DECFUNC             '  Translated Decimal Func: Strlen,Asin
    vt_NUMBER              '  A Pure Literal Number
    vt_FILEPTR             '  @ FILE*
    vt_UDT                 '  User ( or Windows ) Defined Type
    vt_STRUCT              '  Structures
    vt_UNION               '  Unions
    vt_LPSTR               '  Pointer to string
    vt_BOOL                '  Bool
    vt_CHAR                '  8-bit unsigned char
    vt_SCHAR               '  8-bit signed char
    vt_LPSTRPTR            '  pointer to string array
    vt_PCHAR               '  pointer to char
    vt_CHARPTR             '  pointer to char
    vt_VOID                '  null
    vt_LONG                '  32-bit signed integer
    vt_WORD                '  16-bit unsigned integer
    vt_DWORD               '  32-bit unsigned integer
    vt_FARPROC             '  Pointer to a function
    vt_LPBYTE              '  pointer to a byte
    vt_LRESULT             '  32/64-bit signed integer
    vt_BYTE                '  byte
    vt_SHORT               '  16-bit signed integer
    vt_SSHORT              '  16-bit signed short
    vt_USHORT              '  16-bit unsigned integer
    vt_UINT                '  unsigned 32-bit integer
    vt_ULONG               '  unsigned 32-bit integer
    vt_ULONGLONG           '  unsigned 64-bit integer
    vt_HWND                '  32/64-bit pointer
    vt_HDC                 '  32/64-bit pointer
    vt_COLORREF            '  32-bit unsigned integer
    vt_HANDLE              '  32/64-bit pointer
    vt_HINSTANCE           '  32/64-bit pointer
    vt_BITMAPINFO          '  32/64-bit Windows handle
    vt_HBITMAP             '  32/64-bit Windows handle
    vt_WNDCLASSEX          '  32/64-bit pointer
    vt_HFONT               '  32/64-bit pointer
    vt_CONSTRDESTR         '  BCX identifier for CONSTRUCTOR/DESTRUCTOR
    vt_VARIANT_BOOL        '  Bool types identifier
    vt__VARIANT_BOOL       '  Bool values identifier
    vt_SCODE               '  unsigned 32-bit integer
    vt_CY                  '  signed 64-bit integer representing a currency value
    vt_DATE                '  32-bit composite variable representing a date and time
    vt_BSTR                '  32-bit composite variable representing an OLE  string
    vt_IUnknown            '  32/64-bit pointer to an IUnknown interface pointer
    vt_IDispatch           '  32/64-bit pointer to an IDispatch pointer
    vt_SAFEARRAY           '  32/64-bit pointer to a SAFEARRAY structure
    vt_PVOID               '  32/64-bit void pointer
    vt_DECIMAL             '  32/64-bit pointer to a DECIMAL member of a VARIANT structure
    vt_DOCINFO             '  32/64-bit pointer to a DOCINFO structure
    vt_LOGFONT             '  32/64-bit pointer
    vt_TEXTMETRIC          '  32/64-bit pointer to a TEXTMETRIC structure
    vt_WINBOOL             '  Alias for BOOL
    vt_VARIANT             '  32/64-bit pointer to a VARIANT structure
END ENUM

'*******************************************************************************
MACRO vt_VarMin = 2
MACRO vt_VarMax = vt_VARIANT
'*******************************************************************************

ENUM                      ' OSVersion return values
    OSUnknown = (-2)
    OSError   = (-1)
    OS_3x                  ' 0
    OS_95                  ' 1
    OS_98                  ' 2
    OS_ME                  ' 3
    OS_NT3                 ' 4
    OS_2000                ' 5
    OS_XP                  ' 6
    OS_XP_Pro_x64          ' 7
    OS_Server_2003         ' 8
    OS_Home_Server         ' 9
    OS_Server_2003_R2      ' 10
    OS_Vista               ' 11
    OS_Server_2008         ' 12
    OS_Server_2008_R2      ' 13
    OS_Win_7               ' 14
    OS_Server_2012         ' 15
    OS_Win_8               ' 16
    OS_Win_81              ' 17
    OS_Server_2012_R2      ' 18
    OS_Win_10              ' 19
    OS_Server_2016         ' 20
    OS_Win_11              ' 21
    OS_Server_2019         ' 22
    OS_Server_2022         ' 23
END ENUM

'*******************************************************************************
ENUM  ' InFunction types
    eFunctionType = (1)
    eSubType
END ENUM
'*******************************************************************************

ENUM  ' SUB EmitIfCond types
    ePart
    eFull
    eStringPart
    eStringFull
END ENUM

'*******************************************************************************

ENUM                        '***** MEMSET/STATIC Truth Table ******
    ImDim       = 0x0001    '  DIM         A        MEMSET  STATIC
    ImLocal     = 0x0002    '  LOCAL       B        MEMSET  STATIC
    ImRaw       = 0x0004    '  RAW         C
    ImStatic    = 0x0008    '  STATIC      D                STATIC
    ImAuto      = 0x0010    '  AUTO        E        MEMSET
    ImRegister  = 0x0020    '  REGISTER    F
    ImCPPPrvDim = 0x0040    '  ImCPPPrvDim
END  ENUM

'*******************************************************************************

ENUM
    mt_ProcessSetCommand
    mt_FuncSubDecC_Dec
    mt_FuncSubDecC_DecAParam
    mt_FuncSubDecC_DecNoParam
    mt_Opts
    mt_OptsAParam
    mt_OptsNoParam
    mt_OverLoad
    mt_OverLoadAParam
    mt_OverLoadNoParam
    mt_ConsDes
    mt_ConsDesAParam
    mt_ConsDesNoParam
END ENUM


ENUM
    eDoNothing
    eStartSysVariables
    eDoSysVariables
    eStartUserVariables
    eDoUserVariables
    eStartMacros
    eDoMacros
    eStartStdProtos
    eDoStdProtos
    eStartUserProtos
    eDoUserProtos
    eStartUserConst
    eDoUserConst
    eStartSysConst
    eDoSysConst
    eDoMainProgram
    eDoUserProcs
    eStartUserTypes
    eDoUserTypes
END ENUM


'*******************************************************************************
'                  Variable types for COM, OLE and VARIANT
'*******************************************************************************
ENUM
    comvt_BAD = (-1)
    comvt_TRUE
    comvt_FALSE
    comvt_BOOL
    comvt__VARIANT_BOOL
    comvt_BSTR
    comvt_STRVAR
    comvt_R4
    comvt_R8
    comvt_R8_LITERAL
    comvt_CY
    comvt_DATE
    comvt_DISPATCH
    comvt_PVOID
    comvt_ERROR
    comvt_VARIANT
    comvt_UNKNOWN
    comvt_DECIMAL
    comvt_I1
    comvt_UI1
    comvt_I2
    comvt_UI2
    comvt_I4
    comvt_I4_LITERAL
    comvt_UI4
    comvt_I8
    comvt_UI8
    comvt_INT
    comvt_UINT
    comvt_VOID
    comvt_OBJECT
    comvt_EMPTY
    comvt_NULL
    comvt_HRESULT
    comvt_PTR
    comvt_SAFEARRAY
    comvt_CARRAY
    comvt_USERDEFINED
    comvt_LPSTR
    comvt_LPWSTR
    comvt_RECORD
    comvt_INT_PTR
    comvt_UINT_PTR
    comvt_FILETIME
    comvt_BLOB
    comvt_STREAM
    comvt_STORAGE
    comvt_STREAMED_OBJECT
    comvt_STORED_OBJECT
    comvt_BLOB_OBJECT
    comvt_CF
    comvt_CLSID
    comvt_VERSIONED_STREAM
    comvt_BSTR_BLOB
    comvt_NAMED_ARGUMENT
    comvt_CAST
    comvt_DEFAULT
    comvt_VECTOR   = 0x1000  ' unused
    comvt_ARRAY    = 0x2000
    comvt_BYREF    = 0x4000
    comvt_TYPEMASK = 0x0FFF
    comvt_ILLEGAL  = 0xFFFF  ' unused
END ENUM


'*******************************************************************************
'              LATE BINDING COM SUPPORT by Ljubisa Knezevic, et al
'*******************************************************************************

TYPE COM_NAMES_STORAGE       ' Used for COM variables
    com_VarName[cSizeOfName] AS CHAR
    initialized              AS BOOL
END TYPE

MACRO cMaxComStk       = 256
MACRO cMaxParamToken   = 64
MACRO cSizeOfName      = 64
MACRO COM_STACK_SIZE   = 64  ' number of chained dispatch objects.
MACRO COM_Max_Gl_Objs  = 64  ' max allowable GLOBAL COM objects
MACRO COM_Max_Lc_Objs  = 64  ' max allowable LOCAL  COM objects (SUBs and FUNCs)
MACRO COM_Max_Withs    = 32  ' max allowable nested (WITH-END WITH) constructions

GLOBAL ComNdx
GLOBAL ComStk$     [cMaxComStk]
GLOBAL ParamToken$ [cMaxParamToken]

'**************************************************************
'             END OF LATE BINDING COM SUPPORT
'**************************************************************

MACRO cCommaPos = 128
TYPE FUNCPARSE
    NumArgs
    CommaPos [cCommaPos]
END TYPE

'**************************************************************
'              These need to always stay in sync
'**************************************************************

MACRO VARTYPES$ = "%$#!@`"
SET VarTypeLookup[] AS PCHAR
    "int", "int", "char *", "double", "float", "FILE *", "long double"
END SET

'**************************************************************
'    Used to keep track of status of a SELECT structure
'**************************************************************

TYPE SELECT_INFO
    CaseStk        AS STRING
    CaseElseFlag   AS INTEGER
    CaseFlag       AS INTEGER
    iStartCase     AS INTEGER
    NoBreak        AS INTEGER
    iJumpTo        AS INTEGER
END TYPE

MACRO cMaxNestedSelects = 32
GLOBAL SelectState[cMaxNestedSelects] AS SELECT_INFO

'**************************************************************
' Structure used in Emitter's findword - Lookup done on pszWord
'**************************************************************

MACRO NOTFOUND = (-1)
TYPE WORDS
    pszWord AS PCHAR
    iType   AS INTEGER
    FUNCTION Emitter(Lookup$, FuncRetnFlag AS PINT) AS INTEGER
END TYPE


TYPE ARGTYPE
    Arg     AS STRING
    ArgType AS INTEGER
END TYPE


MACRO cMAXProtoType    = 8192
MACRO cSizeOfCondition =  512
TYPE PROTOSTORE
    Condition[cSizeOfCondition]      AS CHAR
    CondLevel                        AS INTEGER
    Prototype                        AS STRING
END TYPE


MACRO cSizeOfElementName = 64
TYPE ELEMENT
    ElementType                      AS INTEGER
    ElementID                        AS INTEGER
    ElementDynaPtr                   AS INTEGER
    ElementName$[cSizeOfElementName] AS CHAR
END TYPE


MACRO cSizeOfVarName = 64
TYPE USERTYPEDEF
    VarName[cSizeOfVarName]          AS CHAR
    TypeofDef                        AS INTEGER
    EleCnt                           AS INTEGER
    Elements[MaxElements]            AS ELEMENT
END TYPE


MACRO cSizeOfLabel = 10
TYPE LOOPSTORE
    iLoopType                        AS INTEGER
    iLoopLine                        AS INTEGER
    iJumpTo                          AS INTEGER
    szUseNeedLabel [cSizeOfLabel]    AS CHAR
END TYPE


MACRO cSizeOfVarDim     = 128
MACRO cSizeOfVarCondDef = 128
MACRO cSizeOfVarModule  = 300
TYPE VARINFO
    VarLine                          AS INTEGER
    VarType                          AS INTEGER
    VarDef                           AS INTEGER
    VarPntr                          AS INTEGER
    VarSF                            AS INTEGER
    VarExtn                          AS INTEGER
    VarCondLevel                     AS INTEGER
    VarEmitFlag                      AS INTEGER
    VarConstant                      AS INTEGER
    VarName    [cSizeOfVarName]      AS CHAR
    VarDim     [cSizeOfVarDim]       AS CHAR
    VarModule  [cSizeOfVarModule]    AS CHAR
    VarCondDef [cSizeOfVarCondDef]   AS CHAR
END TYPE


TYPE VARCODE
    VarNo                            AS INTEGER
    Methd                            AS INTEGER
    IsPtrFlag                        AS INTEGER
    IsExported                       AS INTEGER
    UseInLine                        AS INTEGER
    Header                           AS STRING
    Proto                            AS STRING
    Functype                         AS STRING
    StaticOut                        AS STRING
    Token                            AS STRING
    AsToken                          AS STRING
END TYPE


' Types used in LoopType
ENUM
    ePrinterGroup   = 0x0001
    eFontGroup      = 0x0002
    eClassName      = 0x0004
    eBCX_hInstance  = 0x0008
END ENUM


ENUM   ' Types used in LoopType
    lt_DOLOOP = 1
    lt_DOWHILELOOP
    lt_DOUNTILLOOP
    lt_WHILEWEND
    lt_FORNEXT
    lt_SELECT
    lt_FORXNEXT
END ENUM


ENUM
    eExitingMoreThan1Loop = 1
END ENUM


TYPE VARIANTNAMES
    sNAME AS PCHAR
    iTYPE AS INTEGER
    iPTRS AS INTEGER
END TYPE


SET VariantList[] AS VARIANTNAMES
    { "bVal"      , vt_BYTE           , 0 },
    { "bool"      , vt__VARIANT_BOOL  , 0 },
    { "boolVal"   , vt_VARIANT_BOOL   , 0 },
    { "bstrVal"   , vt_BSTR           , 0 },
    { "byref"     , vt_PVOID          , 0 },
    { "cVal"      , vt_CHAR           , 0 },
    { "cyVal"     , vt_CY             , 0 },
    { "date"      , vt_DATE           , 0 },
    { "dblVal"    , vt_DOUBLE         , 0 },
    { "fltVal"    , vt_SINGLE         , 0 },
    { "iVal"      , vt_SHORT          , 0 },
    { "intVal"    , vt_INTEGER        , 0 },
    { "lVal"      , vt_LONG           , 0 },
    { "llVal"     , vt_LLONG          , 0 },
    { "parray"    , vt_SAFEARRAY      , 1 },
    { "pbVal"     , vt_BYTE           , 1 },
    { "pbool"     , vt__VARIANT_BOOL  , 1 },
    { "pboolVal"  , vt_VARIANT_BOOL   , 1 },
    { "pbstrVal"  , vt_BSTR           , 1 },
    { "pcVal"     , vt_CHAR           , 1 },
    { "pcyVal"    , vt_CY             , 1 },
    { "pdate"     , vt_DATE           , 1 },
    { "pdblVal"   , vt_DOUBLE         , 1 },
    { "pdecVal"   , vt_DECIMAL        , 1 },
    { "pdispVal"  , vt_IDispatch      , 1 },
    { "pfltVal"   , vt_SINGLE         , 1 },
    { "piVal"     , vt_SHORT          , 1 },
    { "pintVal"   , vt_INTEGER        , 1 },
    { "plVal"     , vt_LONG           , 1 },
    { "pllVal"    , vt_LLONG          , 1 },
    { "pparray"   , vt_SAFEARRAY      , 2 },
    { "ppdispVal" , vt_IDispatch      , 2 },
    { "ppunkVal"  , vt_IUnknown       , 2 },
    { "pscode"    , vt_SCODE          , 1 },
    { "puiVal"    , vt_USHORT         , 1 },
    { "pulVal"    , vt_ULONG          , 1 },
    { "pullVal"   , vt_ULONGLONG      , 1 },
    { "punkVal"   , vt_IUnknown       , 1 },
    { "pvarVal"   , vt_VARIANT        , 1 },
    { "scode"     , vt_SCODE          , 0 },
    { "uiVal"     , vt_USHORT         , 0 },
    { "uintVal"   , vt_UINT           , 0 },
    { "ulVal"     , vt_ULONG          , 0 },
    { "ullVal"    , vt_ULONGLONG      , 0 },
    { NULL        , 0                 , 0 }
END SET


TYPE VTCASTS
    pszCAST AS PCHAR
    iCASTID AS INTEGER
END TYPE


SET ptVCasts[] AS VTCASTS
    { "VT_BOOL"    , comvt_BOOL },
    { "VT_BSTR"    , comvt_BSTR },
    { "VT_CY"      , comvt_CY },
    { "VT_DATE"    , comvt_DATE },
    { "VT_DECIMAL" , comvt_DECIMAL },
    { "VT_DISPATCH", comvt_DISPATCH },
    { "VT_ERROR"   , comvt_ERROR },
    { "VT_I1"      , comvt_I1 },
    { "VT_I2"      , comvt_I2 },
    { "VT_I4"      , comvt_I4 },
    { "VT_I8"      , comvt_I8 },
    { "VT_INT"     , comvt_INT },
    { "VT_R4"      , comvt_R4 },
    { "VT_R8"      , comvt_R8 },
    { "VT_UI1"     , comvt_UI1 },
    { "VT_UI2"     , comvt_UI2 },
    { "VT_UI4"     , comvt_UI4 },
    { "VT_UI8"     , comvt_UI8 },
    { "VT_UINT"    , comvt_UINT },
    { "VT_UNKNOWN" , comvt_UNKNOWN },
    { NULL         , 0 }
END SET


TYPE CASTS
    pszCAST AS PCHAR
    pszVAL AS PCHAR
END TYPE


SET ptCCasts[] AS CASTS
    { "BYTE"     , "bVal" },
    { "CHAR"     , "cVal" },
    { "DOUBLE"   , "dblVal" },
    { "FLOAT"    , "fltVal" },
    { "IDispatch", "pdispVal" },
    { "INT"      , "intVal" },
    { "IUnknown" , "punkVal" },
    { "LONG"     , "lVal" },
    { "LONGLONG" , "llVal" },
    { "PVOID"    , "byref" },
    { "SHORT"    , "iVal" },
    { "UINT"     , "uintVal" },
    { "ULONG"    , "ulVal" },
    { "ULONGLONG", "ullVal" },
    { "USHORT"   , "uiVal" },
    { NULL       , NULL }
END SET


SET ConstTypes$[]
    '-----------------------------------------
    ' MrBcx 828 (refactored) - These support:
    ' CONST [type] Variable_Name = SomeValue
    ' ex: CONST LONG EndGame = 1234567890
    ' EndGame is an immutable variable object.
    '-----------------------------------------
    "byte",
    "char",
    "double",
    "dword",
    "float",
    "int",
    "integer",
    "llong",
    "long",
    "longlong",
    "sbyte",
    "short",
    "single",
    "ubyte",
    "uchar",
    "uint",
    "uint64",
    "ulong",
    "ulonglong",
    "ushort"
END SET


SET tBcxWords[] AS WORDS
    ' Must be in lower case and in alphabetical order
    { "_ftelli64"        , vt_LLONG   , NULL },
    { "abs"              , vt_DOUBLE  , NULL },
    { "acos"             , vt_DOUBLE  , NULL },
    { "acosh"            , vt_DOUBLE  , NULL },
    { "acosl"            , vt_LDOUBLE , NULL },
    { "asin"             , vt_DOUBLE  , NULL },
    { "asinh"            , vt_DOUBLE  , NULL },
    { "asinl"            , vt_LDOUBLE , NULL },
    { "atan"             , vt_DOUBLE  , NULL },
    { "atan2"            , vt_DOUBLE  , NULL },
    { "atanh"            , vt_DOUBLE  , NULL },
    { "atanl"            , vt_LDOUBLE , NULL },
    { "band"             , vt_DECFUNC , NULL },
    { "bin2dec"          , vt_INTEGER , NULL },
    { "bor"              , vt_DECFUNC , NULL },
    { "cos"              , vt_DOUBLE  , NULL },
    { "cosh"             , vt_DOUBLE  , NULL },
    { "cosl"             , vt_LDOUBLE , NULL },
    { "csrlin"           , vt_DECFUNC , NULL },
    { "cursorx"          , vt_DECFUNC , NULL },
    { "cursory"          , vt_DECFUNC , NULL },
    { "cvd"              , vt_DOUBLE  , NULL },
    { "cvld"             , vt_LDOUBLE , NULL },
    { "cvs"              , vt_SINGLE  , NULL },
    { "degtorad"         , vt_DOUBLE  , NULL },
    { "dsplit"           , vt_DECFUNC , NULL },
    { "exist"            , vt_DECFUNC , NULL },
    { "exp"              , vt_DOUBLE  , NULL },
    { "expl"             , vt_LDOUBLE , NULL },
    { "fabs"             , vt_DOUBLE  , NULL },
    { "fabsf"            , vt_SINGLE  , NULL },
    { "fabsl"            , vt_LDOUBLE , NULL },
    { "findfirstinstance", vt_DECFUNC , NULL },
    { "fint"             , vt_INTEGER , NULL },
    { "fix"              , vt_DECFUNC , NULL },
    { "frac"             , vt_DOUBLE  , NULL },
    { "fracl"            , vt_LDOUBLE , NULL },
    { "freefile"         , vt_FILEPTR , NULL },
    { "getattr"          , vt_DECFUNC , NULL },
    { "hex2dec"          , vt_INTEGER , NULL },
    { "hypot"            , vt_DOUBLE  , NULL },
    { "hypotl"           , vt_LDOUBLE , NULL },
    { "iif"              , vt_DOUBLE  , NULL },
    { "iinstr"           , vt_DECFUNC , NULL },
    { "inchr"            , vt_DECFUNC , NULL },
    { "instr"            , vt_DECFUNC , NULL },
    { "instrany"         , vt_DECFUNC , NULL },
    { "instrrev"         , vt_DECFUNC , NULL },
    { "isfile"           , vt_INTEGER , NULL },
    { "isfolder"         , vt_INTEGER , NULL },
    { "ishidden"         , vt_INTEGER , NULL },
    { "isreadonly"       , vt_INTEGER , NULL },
    { "issystem"         , vt_INTEGER , NULL },
    { "kbhit"            , vt_DECFUNC , NULL },
    { "keypress()"       , vt_DECFUNC , NULL },
    { "labs"             , vt_LONG    , NULL },
    { "llabs"            , vt_LLONG   , NULL },
    { "lof"              , vt_DOUBLE  , NULL },
    { "log"              , vt_DOUBLE  , NULL },
    { "log10"            , vt_DOUBLE  , NULL },
    { "log10l"           , vt_LDOUBLE , NULL },
    { "logl"             , vt_LDOUBLE , NULL },
    { "max"              , vt_DOUBLE  , NULL },
    { "min"              , vt_DOUBLE  , NULL },
    { "msgbox"           , vt_DECFUNC , NULL },
    { "pi"               , vt_DOUBLE  , NULL },
    { "pos"              , vt_DECFUNC , NULL },
    { "pow"              , vt_DOUBLE  , NULL },
    { "powl"             , vt_LDOUBLE , NULL },
    { "qbcolor"          , vt_DECFUNC , NULL },
    { "radtodeg"         , vt_DOUBLE  , NULL },
    { "rnd"              , vt_SINGLE  , NULL },
    { "rnd2"             , vt_DOUBLE  , NULL },
    { "round"            , vt_DOUBLE  , NULL },
    { "screen"           , vt_DECFUNC , NULL },
    { "sgn"              , vt_DECFUNC , NULL },
    { "sin"              , vt_DOUBLE  , NULL },
    { "sinh"             , vt_DOUBLE  , NULL },
    { "sinl"             , vt_LDOUBLE , NULL },
    { "sizeof"           , vt_DECFUNC , NULL },
    { "split"            , vt_DECFUNC , NULL },
    { "sqrt"             , vt_DOUBLE  , NULL },
    { "sqrtl"            , vt_LDOUBLE , NULL },
    { "strlen"           , vt_DECFUNC , NULL },
    { "tally"            , vt_DECFUNC , NULL },
    { "tan"              , vt_DOUBLE  , NULL },
    { "tanh"             , vt_DOUBLE  , NULL },
    { "tanl"             , vt_LDOUBLE , NULL },
    { "textmode"         , vt_DOUBLE  , NULL },
    { "timer"            , vt_SINGLE  , NULL },
    { "tix_now"          , vt_DOUBLE  , NULL },
    { "val"              , vt_DOUBLE  , NULL },
    { "vall"             , vt_LDOUBLE , NULL }
END SET


SET tTypes[] AS WORDS
    '*************************************************
    ' Must be in lower case and in alphabetical order
    '*************************************************
    { "bitmapinfo" , vt_BITMAPINFO  , NULL },
    { "bool"       , vt_BOOL        , NULL },
    { "boolean"    , vt_BOOL        , NULL },
    { "bstr"       , vt_BSTR        , NULL },
    { "byte"       , vt_BYTE        , NULL },
    { "char"       , vt_CHAR        , NULL },
    { "colorref"   , vt_COLORREF    , NULL },
    { "double"     , vt_DOUBLE      , NULL },
    { "dword"      , vt_DWORD       , NULL },
    { "farproc"    , vt_FARPROC     , NULL },
    { "file"       , vt_FILEPTR     , NULL },
    { "float"      , vt_SINGLE      , NULL },
    { "handle"     , vt_HANDLE      , NULL },
    { "hbitmap"    , vt_HBITMAP     , NULL },
    { "hdc"        , vt_HDC         , NULL },
    { "hfont"      , vt_HFONT       , NULL },
    { "hwnd"       , vt_HWND        , NULL },
    { "int"        , vt_INTEGER     , NULL },
    { "ldouble"    , vt_LDOUBLE     , NULL },
    { "llong"      , vt_LLONG       , NULL },
    { "long"       , vt_LONG        , NULL },
    { "longlong"   , vt_LLONG       , NULL },
    { "lpbyte"     , vt_LPBYTE      , NULL },
    { "lpstr"      , vt_LPSTR       , NULL },
    { "lresult"    , vt_LRESULT     , NULL },
    { "pchar"      , vt_PCHAR       , NULL },
    { "schar"      , vt_SCHAR       , NULL },
    { "short"      , vt_SHORT       , NULL },
    { "sshort"     , vt_SSHORT      , NULL },
    { "string"     , vt_STRVAR      , NULL },
    { "uint"       , vt_UINT        , NULL },
    { "uint64"     , vt_ULONGLONG   , NULL },
    { "ulong"      , vt_ULONG       , NULL },
    { "ulonglong"  , vt_ULONGLONG   , NULL },
    { "ushort"     , vt_USHORT      , NULL },
    { "variant"    , vt_VARIANT     , NULL },
    { "void"       , vt_VOID        , NULL },
    { "winbool"    , vt_WINBOOL     , NULL },
    { "wndclassex" , vt_WNDCLASSEX  , NULL }
END SET


SET atEmitWords[] AS WORDS
    '*************************************************
    ' Must be in lower case and in alphabetical order
    '*************************************************
    { "_chdir"              , 0, Emit_FolderDriveProcs },
    { "_mkdir"              , 0, Emit_FolderDriveProcs },
    { "_rmdir"              , 0, Emit_FolderDriveProcs },
    { "asm"                 , 0, Emit_CPP_Asm },
    { "auto"                , 0, Emit_Auto },
    { "bcx_set_edit_color"  , 0, Emit_BcxSetEditColor },
    { "bcx_set_font"        , 0, Emit_BcxSetFont },
    { "bcx_set_label_color" , 0, Emit_BcxSetLabelColor },
    { "beginblock"          , 0, Emit_ControlFlow },
    { "call"                , 0, Emit_ControlFlow },
    { "case"                , 0, Emit_ControlFlow },
    { "caseelse"            , 0, Emit_ControlFlow },
    { "catch"               , 0, Emit_CPP_Catch },
    { "chdir"               , 0, Emit_FolderDriveProcs },
    { "class"               , 0, Emit_CPP_Class },
    { "clear"               , 0, Emit_Clear },
    { "close"               , 0, Emit_FileIO },
    { "cls"                 , 0, Emit_ConsoleOnlyProcs },
    { "color"               , 0, Emit_ConsoleOnlyProcs },
    { "const"               , 0, Emit_Const },
    { "constructor"         , 0, Emit_ConDes },
    { "continue"            , 0, Emit_ControlFlow },
    { "copyfile"            , 0, Emit_FileManagementProcs },
    { "data"                , 0, Emit_Data },
    { "declare"             , 0, Emit_Declare },
    { "decr"                , 0, Emit_MathProcs },
    { "delay"               , 0, Emit_ConsoleOnlyProcs },
    { "delete"              , 0, Emit_CPP_Delete },
    { "destructor"          , 0, Emit_ConDes },
    { "dialogbox"           , 0, Emit_DialogBox },
    { "dim"                 , 0, Emit_Dim },
    { "do"                  , 0, Emit_ControlFlow },
    { "dynamic"             , 0, Emit_Dynamic },
    { "ejectpage"           , 0, Emit_PrinterProcs },
    { "else"                , 0, Emit_ControlFlow },
    { "elseif"              , 0, Emit_ControlFlow },
    { "end"                 , 0, Emit_ControlFlow },
    { "endblock"            , 0, Emit_ControlFlow },
    { "endclass"            , 0, Emit_CPP_EndClass },
    { "endconstructor"      , 0, Emit_ConDes },
    { "enddestructor"       , 0, Emit_ConDes },
    { "endfunction"         , 0, Emit_EndFuncSub },
    { "endif"               , 0, Emit_ControlFlow },
    { "endnamespace"        , 0, Emit_CPP_EndNamespace },
    { "endpptype"           , 0, Emit_PPType },
    { "endprepend"          , 0, Emit_ControlFlow },
    { "endprogram"          , 0, Emit_ControlFlow },
    { "endrepeat"           , 0, Emit_ControlFlow },
    { "endselect"           , 0, Emit_ControlFlow },
    { "endsub"              , 0, Emit_EndFuncSub },
    { "endtemplate"         , 0, Emit_template },
    { "endtry"              , 0, Emit_CPP_EndTry },
    { "endtype"             , 0, Emit_Type },
    { "endunion"            , 0, Emit_Union },
    { "endwhile"            , 0, Emit_ControlFlow },
    { "endwith"             , 0, Emit_ControlFlow },
    { "exit"                , 0, Emit_ControlFlow },
    { "extern"              , 0, Emit_Extern },
    { "fallthrough"         , 0, Emit_ControlFlow },
    { "finput"              , 0, Emit_FinputProcs },
    { "flush"               , 0, Emit_FileIO },
    { "for"                 , 0, Emit_ControlFlow },
    { "fprint"              , 0, Emit_FprintProcs },
    { "free"                , 0, Emit_Free },
    { "function"            , 0, Emit_FuncSub },
    { "functionreturn"      , 0, Emit_FunctionReturn },
    { "fwrite"              , 0, Emit_FwriteProcs },
    { "global"              , 0, Emit_Shared_Global },
    { "gosub"               , 0, Emit_ControlFlow },
    { "goto"                , 0, Emit_ControlFlow },
    { "gui"                 , 0, Emit_MdiGuiProcs },
    { "if"                  , 0, Emit_ControlFlow },
    { "impfunction"         , 0, Emit_Implied },
    { "incr"                , 0, Emit_MathProcs },
    { "input"               , 0, Emit_KeyboardProcs },
    { "insertmenu"          , 0, Emit_InsertMenuProc },
    { "kill"                , 0, Emit_FileManagementProcs },
    { "lineinput"           , 0, Emit_LineInputProcs },
    { "local"               , 0, Emit_Local },
    { "locate"              , 0, Emit_ConsoleOnlyProcs },
    { "loop"                , 0, Emit_ControlFlow },
    { "lprint"              , 0, Emit_PrinterProcs },
    { "mdigui"              , 0, Emit_MdiGuiProcs },
    { "midstr"              , 0, Emit_StringProcs },
    { "mkdir"               , 0, Emit_FolderDriveProcs },
    { "msgbox"              , 0, Emit_Msgbox },
    { "namespace"           , 0, Emit_CPP_Namespace },
    { "next"                , 0, Emit_ControlFlow },
    { "open"                , 0, Emit_FileIO },
    { "optfunction"         , 0, Emit_OptFuncSub },
    { "optsub"              , 0, Emit_OptFuncSub },
    { "overloadedfunction"  , 0, Emit_OverLoadFuncSub },
    { "overloadedsub"       , 0, Emit_OverLoadFuncSub },
    { "panel"               , 0, Emit_ConsoleOnlyProcs },
    { "pptype"              , 0, Emit_PPType },
    { "prepend"             , 0, Emit_ControlFlow },
    { "print"               , 0, Emit_ConsoleOnlyProcs },
    { "printerclose"        , 0, Emit_PrinterProcs },
    { "printeropen"         , 0, Emit_PrinterProcs },
    { "private"             , 0, Emit_CPP_Private },
    { "privatedim"          , 0, Emit_PrivateDim },
    { "privatefunction"     , 0, Emit_FuncSub },
    { "privatesub"          , 0, Emit_FuncSub },
    { "protected"           , 0, Emit_CPP_Protected },
    { "public"              , 0, Emit_CPP_Public },
    { "publicfunction"      , 0, Emit_FuncSub },
    { "publicsub"           , 0, Emit_FuncSub },
    { "qsort"               , 0, Emit_QsortProcs },
    { "qsortidx"            , 0, Emit_QsortIdxProcs },
    { "raw"                 , 0, Emit_Raw },
    { "record"              , 0, Emit_FileIO },
    { "redim"               , 0, Emit_Redim },
    { "register"            , 0, Emit_Register },
    { "rename"              , 0, Emit_FileManagementProcs },
    { "repeat"              , 0, Emit_ControlFlow },
    { "return"              , 0, Emit_ControlFlow },
    { "rmdir"               , 0, Emit_FolderDriveProcs },
    { "run"                 , 0, Emit_Run },
    { "seek"                , 0, Emit_SeekProcs },
    { "select"              , 0, Emit_ControlFlow },
    { "seteof"              , 0, Emit_SetEofProcs },
    { "shared"              , 0, Emit_Shared_Global },
    { "shell"               , 0, Emit_Shell },
    { "sprint"              , 0, Emit_PrinterProcs },
    { "static"              , 0, Emit_Static },
    { "sub"                 , 0, Emit_FuncSub },
    { "swap"                , 0, Emit_Swap },
    { "template"            , 0, Emit_template },
    { "textmode"            , 0, Emit_ConsoleOnlyProcs },
    { "throw"               , 0, Emit_CPP_Throw },
    { "try"                 , 0, Emit_CPP_Try },
    { "type"                , 0, Emit_Type },
    { "union"               , 0, Emit_Union },
    { "wend"                , 0, Emit_ControlFlow },
    { "while"               , 0, Emit_ControlFlow },
    { "with"                , 0, Emit_ControlFlow },
    { "write"               , 0, Emit_ConsoleOnlyProcs },
    { "xfor"                , 0, Emit_ControlFlow },
    { "xnext"               , 0, Emit_ControlFlow },
    { "~else"               , 0, Emit_ConditionalCompilation },
    { "~elseif"             , 0, Emit_ConditionalCompilation },
    { "~endif"              , 0, Emit_ConditionalCompilation },
    { "~get"                , 0, Emit_GetProcs },
    { "~hscroll"            , 0, Emit_Hscroll },
    { "~if"                 , 0, Emit_ConditionalCompilation },
    { "~ifdef"              , 0, Emit_ConditionalCompilation },
    { "~ifndef"             , 0, Emit_ConditionalCompilation },
    { "~pragmaoptimizeoff"  , 0, Emit_ConditionalCompilation },
    { "~pragmaoptimizeon"   , 0, Emit_ConditionalCompilation },
    { "~put"                , 0, Emit_PutProcs },
    { "~vscroll"            , 0, Emit_Vscroll }
END SET



SET tDirectives[] AS WORDS
    '*************************************************
    ' Must be in lower case and in alphabetical order
    '*************************************************
    { "#include"            , 0, Doinclude     },
    { "$accelerator"        , 0, Doaccelerator },
    { "$asm"                , 0, Doasm         },
    { "$bcx_resource"       , 0, Dobcx_resource },
    { "$bcxstrsize"         , 0, DoBcxStrSize  },
    { "$bcxversion"         , 0, Dobcxversion  },
    { "$case_off"           , 0, DoCase_offon  },
    { "$case_on"            , 0, DoCase_offon  },
    { "$ccode"              , 0, Doccode       },
    { "$com_off"            , 0, Docom_op      },
    { "$com_on"             , 0, Docom_op      },
    { "$com_trace"          , 0, Docom_op      },
    { "$comment"            , 0, Docomment     },
    { "$compiler"           , 0, Docompiler    },
    { "$cpp"                , 0, Docpp         },
    { "$cpphdr"             , 0, Docpphdr      },
    { "$cproto"             , 0, Docproto      },
    { "$define"             , 0, Dodefine      },
    { "$dll"                , 0, Dodll         },
    { "$filetest"           , 0, Dofiletest    },
    { "$fill"               , 0, Dofillstring  },
    { "$fsstatic"           , 0, Dofsstatic    },
    { "$genfree"            , 0, Dogenfree     },
    { "$header"             , 0, Doheader      },
    { "$include"            , 0, Doinclude     },
    { "$interface"          , 0, Dointerface   },
    { "$iprint_off"         , 0, Doiprint      },
    { "$iprint_on"          , 0, Doiprint      },
    { "$leanandmean"        , 0, Doleanandmean },
    { "$liberror"           , 0, Doliberror    },
    { "$library"            , 0, Dolibrary     },
    { "$linker"             , 0, Dolinker      },
    { "$mt"                 , 0, Domultithread },
    { "$multi"              , 0, Domultithread },
    { "$no_borland"         , 0, DoNoBorland   },
    { "$no_gcc_clang"       , 0, DoNoGccClang  },
    { "$no_lccwin"          , 0, DoNoLccwin    },
    { "$no_libs"            , 0, DoNoLibs      },
    { "$no_msvc"            , 0, DoNoMsvc      },
    { "$no_pelles"          , 0, DoNoPelles    },
    { "$no_vkkeys"          , 0, DoNoVkkeys    },
    { "$nodllmain"          , 0, Dodll         },
    { "$noini"              , 0, Donoini       },
    { "$noio"               , 0, Donoio        },
    { "$nolibrary"          , 0, Doremovelib   },
    { "$nomain"             , 0, Donomain      },
    { "$nowin"              , 0, Donowin       },
    { "$onentry"            , 0, Doonentry     },
    { "$onexit"             , 0, Doonexit      },
    { "$optimizer"          , 0, Dooptimizer   },
    { "$pack"               , 0, Dopack        },
    { "$pp"                 , 0, Dopp          },
    { "$prj"                , 0, Doprj         },
    { "$prjuse"             , 0, Doprj         },
    { "$project"            , 0, Doproject     },
    { "$rems"               , 0, Dorems        },
    { "$resource"           , 0, Doresource    },
    { "$source"             , 0, Dosource      },
    { "$stdcall"            , 0, Dostdcall     },
    { "$test"               , 0, Dotest        },
    { "$trace"              , 0, Dotrace       },
    { "$typedef"            , 0, Dotypedef     },
    { "$warnings"           , 0, DoWarningsOn  },
    { "$warnings_off"       , 0, DoWarningsOff },
    { "$warnings_on"        , 0, DoWarningsOn  },
    { "$zap"                , 0, DoZap         }
END SET
'***************************************************
$TYPEDEF UINT_PTR (CALLBACK *CPP_FARPROC)(PCHAR)
'***************************************************
'     GLOBAL CONSTANTS AND RELATED VARIABLES
'***************************************************
MACRO   cMaxStk       = 8192
MACRO   cMaxByref     =  128
MACRO   cMaxDLLDecl   = 1024
MACRO   cMaxLoopLocal =  512
MACRO   cMaxFiles     =  512
MACRO   cMaxMacros    = 2048
'***************************************************
GLOBAL  ConstMacro$ [cMaxMacros]
GLOBAL  ByrefVars$  [cMaxByref]
GLOBAL  LoopLocalVar [cMaxLoopLocal]
GLOBAL  LoopType [cMaxLoopLocal] AS LOOPSTORE
GLOBAL  LinesWritten    AS INTEGER
GLOBAL  DebugModeOff    AS INTEGER
GLOBAL  MacroCount      AS INTEGER
GLOBAL  ByrefCnt        AS INTEGER
GLOBAL  LoopLocalCnt    AS INTEGER
GLOBAL  LoopTypeCnt     AS INTEGER
GLOBAL  FileNdx         AS INTEGER  ' Index of source files
GLOBAL  FPtr[cMaxFiles] AS FILE     ' Controls $Include Files
GLOBAL  FileNames$ [cMaxFiles]      ' Array of source filenames
GLOBAL  LineNum    [cMaxFiles]      ' Line # in source files, also uses FileNdx
'***************************************************
MACRO   cMaxBaseTypeDefs = 16
GLOBAL  BaseTypeDefsCnt  [cMaxBaseTypeDefs]
GLOBAL  TypeDefName$     [cMaxBaseTypeDefs]
GLOBAL  FP_WRITE AS FILE ' Controls whether code is emitted to main()/winmain() or functions
GLOBAL  iDoWhile
GLOBAL  iLoopCond
GLOBAL  GlobalVarCnt
GLOBAL  TypeDefsCnt
GLOBAL  GlobalDynaCnt
GLOBAL  LocalVarCnt
GLOBAL  LocalDynArrCnt                           ' Local Dynamic String Array Stack Counter
GLOBAL  LocalDynaCnt                             ' Queue Stack Counter
GLOBAL  CombineRes                               ' Join generated rc file with existing rc file
GLOBAL  UserResFile$                             ' holds name of user's *.rc file
GLOBAL  ResCompiler$                             ' resource compiler, lrc.exe
GLOBAL  FPtrNdx                                  ' Controls $Include Files
GLOBAL  Stk$ [cMaxStk]                           ' Parse array
GLOBAL  ProtoType [cMAXProtoType] AS PROTOSTORE  ' C prototype declarations of user's func's
MACRO   cMaxSingleLineIFLines = 256
GLOBAL  SrcStk$ [cMaxSingleLineIFLines]          ' used in parsing single line if-THEN-else
MACRO   cMaxSplitLines = 256
GLOBAL  SplitStk$ [cMaxSplitLines]               ' used in parsing ":" separated lines
GLOBAL  SplitCnt
GLOBAL  SplitCur
GLOBAL  SrcTmp$                                  ' used for storing string to use as parameter to Parse()
MACRO   cMaxOnEntry = 256
GLOBAL  Entry$ [cMaxOnEntry]                     ' Controls the $OnEntry
MACRO   cMaxOnExit = 256
GLOBAL  Xit$ [cMaxOnExit]                        ' Controls the $OnExit
MACRO   cMaxLocalDynArr = 256
GLOBAL  LocalDynArrName$ [cMaxLocalDynArr]       ' Queues LOCAL dynamic string arrays
MACRO   cMaxGlobalDyna = 256
GLOBAL  GlobalDynaStr$   [cMaxGlobalDyna]
MACRO   cMaxDynaStr = 256
GLOBAL  DynaStr$         [cMaxDynaStr]           ' Queues Dynamic strings in SUBS/FUNCTIONS
MACRO   cMaxStartSub = 32
GLOBAL  StartSub$        [cMaxStartSub]          ' user's startup code subs
GLOBAL  StartNdx                                 ' index for StartSub$
MACRO   cMaxExitSub = 32
GLOBAL  ExitSub$         [cMaxExitSub]           ' user's exit code subs
GLOBAL  ExitNdx                                  ' index for ExitSub$
GLOBAL  Library$         [MaxLib]                ' stores libraries to used
GLOBAL  GlobalVarHash    [MaxGlobalVars]
GLOBAL  GlobalVars       [MaxGlobalVars] AS VARINFO
GLOBAL  LocalVars        [MaxLocalVars]  AS VARINFO
GLOBAL  TypeDefs         [MaxTypes]      AS USERTYPEDEF
GLOBAL  UmQt                                     ' Handles quoted lines split with a contination _

'***************************************
' GLOBALS for parsing C++ statements
'***************************************

GLOBAL  UseCpp
GLOBAL  UseCpphdr
GLOBAL  UseIO
GLOBAL  InNameSpace
GLOBAL  InClass
GLOBAL  InCppTypeDef
GLOBAL  InClassName$
GLOBAL  iClassCnt
MACRO   cMaxClassNames = 1024
GLOBAL  ClassNames$[cMaxClassNames]
GLOBAL  InClassPP$
GLOBAL  IsVirtual
GLOBAL  szVirtual$
GLOBAL  UsingTemplate
GLOBAL  WasAClass
GLOBAL  HasVector

'**********************************************************************

GLOBAL  UseInLine
GLOBAL  Accelerator$
GLOBAL  CallBackFlag
GLOBAL  CallType$              ' Calling convention cdecl, stdcall
GLOBAL  LabelGenerator = 1000
GLOBAL  CaseVar$
GLOBAL  Cmd$
GLOBAL  Comma
GLOBAL  Compiler$
GLOBAL  CmdLineConst$
GLOBAL  CmdLineFileOut$
GLOBAL  CurrentFuncType
GLOBAL  DoCountLines
GLOBAL  DimType$
MACRO   cSizeOfDllDecl = 512
GLOBAL  DllDecl$ [cMaxDLLDecl][cSizeOfDllDecl] AS CHAR
GLOBAL  DllCnt
MACRO   cSizeOfLoadlibs = 512
MACRO   cMaxLoadlibs = 128
GLOBAL  Loadlibs$ [cMaxLoadlibs][cSizeOfLoadlibs] AS CHAR
GLOBAL  LoadLibsCnt
GLOBAL  Elapsed AS SINGLE
GLOBAL  EndOfProgram
GLOBAL  EntryCnt
GLOBAL  ErrFile
GLOBAL  ExitSubFunc
GLOBAL  szFile$
GLOBAL  Filnam$
GLOBAL  ForceMainToFunc
GLOBAL  FunctionName$
GLOBAL  szFileHandle$
GLOBAL  HFileCnt
MACRO   MaxHFiles = 128
GLOBAL  HFiles$[MaxHFiles]
GLOBAL  HFile$
GLOBAL  InBlock
GLOBAL  InConditional
GLOBAL  Indent
GLOBAL  InDialogEvt
GLOBAL  InfoBoxWarn
GLOBAL  InFunction
GLOBAL  InIfDef$
GLOBAL  Inject_Local_Bcx_RetVal
GLOBAL  InMain
GLOBAL  InWinMain
GLOBAL  IsCallBack
GLOBAL  ModDialogEvt
GLOBAL  UseCProto
GLOBAL  UseFileTest = TRUE
MACRO   cMaxLocalInBlocks = 16
GLOBAL  LocalInBlock[cMaxLocalInBlocks]
GLOBAL  InTypeDef
GLOBAL  NoTypeDeclare
GLOBAL  InsertComments
'************************ <Variable_Storage_Type>
GLOBAL  IsAuto
GLOBAL  IsDim
GLOBAL  IsLocal
GLOBAL  IsRaw
GLOBAL  IsRegister
GLOBAL  IsStatic
'************************ <Variable_Storage_Type>
GLOBAL  IsStdFunc
GLOBAL  KillCFile
GLOBAL  Keyword1$
GLOBAL  LastCmd
GLOBAL  LinesRead
GLOBAL  Linker$
GLOBAL  MakeDLL
GLOBAL  Ndx
GLOBAL  NoMain AS BOOL
GLOBAL  NoDllMain AS BOOL
GLOBAL  OkayToSend AS BOOL
GLOBAL  OptimizerEnabled AS BOOL
GLOBAL  OptimizerFirstSetting AS BOOL
GLOBAL  OptionBase
GLOBAL  PassOne AS BOOL
GLOBAL  Project$
GLOBAL  ProtoCnt
GLOBAL  StateIdx
GLOBAL  PPFlag AS BOOL
GLOBAL  PPDLL_HANDLE AS HINSTANCE
GLOBAL  PPProc AS CPP_FARPROC
GLOBAL  Use_LoadLibraryError        ' Use error routine when loading libraries
GLOBAL  LibraryErrorLog$            ' [Path\][Name] of error log for loading libraries
GLOBAL  Use_Project AS BOOL         ' Vic McClung for $PROJECT Support
GLOBAL  Gen_Header AS BOOL          ' Vic McClung for $PROJECT Support
GLOBAL  Project_Main$               ' main file in $PROJECT
GLOBAL  Project_List$               ' list of files in project
GLOBAL  Project_Path$               ' path for project output files, i.e. .h;.c;.cpp
GLOBAL  NoRT AS BOOL                ' Emit all c\c++ code -EXCEPT- BCX runtime c\c++ code
GLOBAL  Quiet AS BOOL               ' no output to screen, for use with BCX Builder
GLOBAL  WarningFlag AS BOOL
GLOBAL  ZapFlag AS BOOL             ' remove default libs and headers [-z]
GLOBAL  ReDirect AS BOOL
GLOBAL  SaveFP_WRITENum AS FILE
GLOBAL  Scoot$
GLOBAL  ShowStatus
GLOBAL  SrcCnt
GLOBAL  SrcFlag
GLOBAL  TraceFlag
GLOBAL  TestForBcxIni AS BOOL
GLOBAL  FileIn$
GLOBAL  FileOut$
GLOBAL  FileOutCopy$
GLOBAL  FileErr$
GLOBAL  iEmitVarGroup
GLOBAL  Res_File$
GLOBAL  ResFileOut$
GLOBAL  For_Next_Error_Detected
GLOBAL  Statements
GLOBAL  IgnoreStrCase               ' TRUE | FALSE depending on $CASE_ON | $CASE_OFF
GLOBAL  TestState
GLOBAL  gszType$
GLOBAL  TranslateSlash
GLOBAL  Use_BcxTempStr
GLOBAL  Use_BCX_stricmp
GLOBAL  UseStdCall
GLOBAL  UseImportExport
GLOBAL  Use_LCaseTbl
GLOBAL  Use_UCaseTbl
GLOBAL  WinHeaders
GLOBAL  Var$
GLOBAL  XitCount
GLOBAL  ConstLastDef$
GLOBAL  UserBcxStrSize$  ' $BCXSTRSIZE support
'**********************************************************************
'   Use_ Vars control and limit the runtime functions that BCX emits
'**********************************************************************
GLOBAL  Use_GUINoMain
GLOBAL  Use_MDIGUINoMain
GLOBAL  GUIIcon$
GLOBAL  GUIMetric$
GLOBAL  Use_Wingui
GLOBAL  Use_MainEvent
GLOBAL  Use_Mdigui
GLOBAL  Use_ShowModal
GLOBAL  Use_EndModal
GLOBAL  Use_BCX_MsgPump
GLOBAL  Use_BCX_MDI_MsgPump
GLOBAL  Use_BCX_Wnd
GLOBAL  Use_BCX_FrameWnd
GLOBAL  Use_BCX_SetBkGrdBrush
GLOBAL  Use_BCX_SetClassStyle
GLOBAL  Use_BCX_SetIcon
GLOBAL  Use_BCX_SetIconSm
GLOBAL  Use_BCX_SetMetric
GLOBAL  Use_BCX_InitGUI
GLOBAL  Use_BCX_RegWnd
GLOBAL  Use_BCX_SetCursor
GLOBAL  Use_AnsiToWide
GLOBAL  Use_Asinh
GLOBAL  Use_Acosh
GLOBAL  Use_AppActivate
GLOBAL  Use_Atanh
GLOBAL  Use_Asc
GLOBAL  Use_AppExeName
GLOBAL  Use_AppExePath
GLOBAL  Use_Bff
GLOBAL  Use_Boolstr
GLOBAL  Use_Bnot
GLOBAL  Use_BCX_Blit
GLOBAL  Use_BCX_Blit_Stretch
GLOBAL  Use_BCX_Blit_Sprite
GLOBAL  Use_BCX_Buffer
GLOBAL  Use_BCX_BmpWidth
GLOBAL  Use_BCX_BmpHeight
GLOBAL  Use_BCX_Class_Info
GLOBAL  Use_BCX_LoadBMP
GLOBAL  Use_BCX_LoadImage
GLOBAL  Use_BCX_Control
GLOBAL  Use_BCX_Colordlg
GLOBAL  Use_BCX_Cursor
GLOBAL  Use_BCX_Fontdlg
GLOBAL  Use_BCX_Floodfill
GLOBAL  Use_BCX_Get
GLOBAL  Use_BCX_Get_Window_Width
GLOBAL  Use_BCX_Get_Window_Height
GLOBAL  Use_BcxSplitPath
GLOBAL  Use_BCX_Path
GLOBAL  Use_BCX_Put
GLOBAL  Use_BCX_Preset
GLOBAL  Use_BCX_Pset
GLOBAL  Use_BCX_Polar_Pset
GLOBAL  Use_BCX_Line
GLOBAL  Use_BCX_Polar_Line
GLOBAL  Use_BCX_Lineto
GLOBAL  Use_BCX_Circle
GLOBAL  Use_BCX_Triangle
GLOBAL  Use_BCX_Gradient
GLOBAL  Use_BCX_Ellipse
GLOBAL  Use_BCX_Rectangle
GLOBAL  Use_BCX_Resize
GLOBAL  Use_BCX_Roundrect
GLOBAL  Use_BCX_Getpixel
GLOBAL  Use_BCX_Arc
GLOBAL  Use_BCX_OlePicture
GLOBAL  Use_BCX_Pie
GLOBAL  Use_BCX_Polygon
GLOBAL  Use_BCX_PolyBezier
GLOBAL  Use_BCX_Polyline
GLOBAL  Use_BCX_Print
GLOBAL  Use_BCX_Printex
GLOBAL  Use_BCX_Tile
GLOBAL  Use_BCX_Slider
GLOBAL  Use_BCX_Splitter
GLOBAL  Use_BCX_Tab
GLOBAL  Use_BCX_Toolbar
GLOBAL  Use_BCX_UpDown
GLOBAL  Use_BCX_Get_UpDown
GLOBAL  Use_Bin
GLOBAL  Use_Bin2dec
GLOBAL  Use_ByteAt
GLOBAL  Use_Cast
GLOBAL  Use_Cvd
GLOBAL  Use_Cvld
GLOBAL  Use_Cvi
GLOBAL  Use_Cvl
GLOBAL  Use_Cvs
GLOBAL  Use_Cdbl
GLOBAL  Use_Cldbl
GLOBAL  Use_Csng
GLOBAL  Use_Clear
GLOBAL  Use_Clip_Getbitmap
GLOBAL  Use_Clip_Setbitmap
GLOBAL  Use_Clip_Gettext
GLOBAL  Use_Clip_Gettextsize
GLOBAL  Use_Clip_Reset
GLOBAL  Use_Clip_Settext
GLOBAL  Use_Chr
GLOBAL  Use_Chrtoutf8
GLOBAL  Use_Cbool
GLOBAL  Use_Cint
GLOBAL  Use_Clng
GLOBAL  Use_Cls
GLOBAL  Use_Color
GLOBAL  Use_Command
GLOBAL  Use_ComboBoxLoadFile
GLOBAL  Use_Console
GLOBAL  Use_Consolesize
GLOBAL  Use_ContainedIn
GLOBAL  Use_Cpad
GLOBAL  Use_Static
GLOBAL  Use_CreateRegInt
GLOBAL  Use_CreateRegString
GLOBAL  Use_Crlf
GLOBAL  Use_Csrlin
GLOBAL  Use_Curdir
GLOBAL  Use_Cursor
GLOBAL  Use_Date
GLOBAL  Use_DrawStr
GLOBAL  Use_IsoDate
GLOBAL  Use_Datacount
GLOBAL  Use_Del
GLOBAL  Use_DeleteRegKey
GLOBAL  Use_Diskfree
GLOBAL  Use_Diskused
GLOBAL  Use_Disksize
GLOBAL  Use_Doevents
GLOBAL  Use_Download
GLOBAL  Use_Downloadtostr
GLOBAL  Use_Draw
GLOBAL  Use_Dynacall
GLOBAL  Use_DynacallA
GLOBAL  Use_DynacallCommon
GLOBAL  Use_DynamicA
GLOBAL  Use_DrawTransBMP
GLOBAL  Use_Elf
GLOBAL  Use_Enclose
GLOBAL  Use_Environ
GLOBAL  Use_EnumFile
GLOBAL  Use_Eof
GLOBAL  Use_EqualTo
GLOBAL  Use_Exist
GLOBAL  Use_ExitCode
GLOBAL  Use_Extract
GLOBAL  Use_ExtractAny
GLOBAL  Use_LeanAndMean
GLOBAL  Use_Lclick
GLOBAL  Use_LoadFile
GLOBAL  Use_ForEach
GLOBAL  Use_FillArray
GLOBAL  Use_FirstInstance
GLOBAL  Use_Findfirst
GLOBAL  Use_Findnext
GLOBAL  Use_Lookahead
GLOBAL  Use_FindInType
GLOBAL  Use_Fix
GLOBAL  Use_FileLocked
GLOBAL  Use_Frac
GLOBAL  Use_Fracl
GLOBAL  Use_Freefile
GLOBAL  Use_Get
GLOBAL  Use_GetBmp
GLOBAL  Use_Gethttpfilesize
GLOBAL  Use_SetDimension
GLOBAL  Use_GetDimension
GLOBAL  Use_Getdrive
GLOBAL  Use_Getfilename
GLOBAL  Use_GetSaveAsFilename
GLOBAL  Use_Getattr
GLOBAL  Use_GetResource
GLOBAL  Use_GetSpecialFolder
GLOBAL  Use_GetSpecialFolderex
GLOBAL  Use_GetTextSize
GLOBAL  Use_GenFree
GLOBAL  Use_GoSub
GLOBAL  Use_Hex
GLOBAL  Use_Hex2Dec
GLOBAL  Use_Hook
GLOBAL  Use_Iif
GLOBAL  Use_Inputbuffer
GLOBAL  Use_Inkey
GLOBAL  Use_InkeyD
GLOBAL  Use_Inputbox
GLOBAL  Use_Infobox
GLOBAL  Use_BoxCommon
GLOBAL  Use_Isptr
GLOBAL  Use_Ins
GLOBAL  Use_Instr
GLOBAL  Use_IInstr
GLOBAL  Use_InstrAny
GLOBAL  Use_IInstrAny
GLOBAL  Use_Like_Instr
GLOBAL  Use_Inchr
GLOBAL  Use_iReplace
GLOBAL  Use_IReplaceAny
GLOBAL  Use_IRemove
GLOBAL  Use_IRemoveAny
GLOBAL  Use_Instrrev
GLOBAL  Use_Imod
GLOBAL  Use_Istrue
GLOBAL  Use_Isfalse
GLOBAL  Use_Isnull
GLOBAL  Use_Notnull
GLOBAL  Use_Iszero
GLOBAL  Use_Issystem
GLOBAL  Use_Ishidden
GLOBAL  Use_Isreadonly
GLOBAL  Use_Isfolder
GLOBAL  Use_Isfile
GLOBAL  Use_Join
GLOBAL  Use_Keypress
GLOBAL  Use_KBinput
GLOBAL  Use_Lcase
GLOBAL  Use_LccPath
GLOBAL  Use_PellesPath
GLOBAL  Use_Ldouble
GLOBAL  Use_Left
GLOBAL  Use_LeftStr
GLOBAL  Use_Like
GLOBAL  Use_LineinputKB
GLOBAL  Use_ListBoxLoadFile
GLOBAL  Use_Loc
GLOBAL  Use_Longestline
GLOBAL  Use_Locate
GLOBAL  Use_Lof
GLOBAL  Use_Lpad
GLOBAL  Use_Ltrim
GLOBAL  Use_Mcase
GLOBAL  Use_Mid
GLOBAL  Use_Midstr
GLOBAL  Use_Msgbox
GLOBAL  Use_Mkd
GLOBAL  Use_Mkld
GLOBAL  Use_Mki
GLOBAL  Use_Mkl
GLOBAL  Use_Mks
GLOBAL  Use_Mkpath
GLOBAL  Use_Min
GLOBAL  Use_Modstyle
GLOBAL  Use_Max
GLOBAL  Use_Mouse_sx
GLOBAL  Use_Mouse_sy
GLOBAL  Use_Mouse_cx
GLOBAL  Use_Mouse_cy
GLOBAL  Use_NamePathFromFP
GLOBAL  Use_Nextlinelen
GLOBAL  Use_Now
GLOBAL  Use_Notzero
GLOBAL  Use_NotEqualTo
GLOBAL  Use_Numqsortdint
GLOBAL  Use_Numqsortaint
GLOBAL  Use_Numqsortdfloat
GLOBAL  Use_Numqsortafloat
GLOBAL  Use_Numqsortddouble
GLOBAL  Use_Numqsortadouble
GLOBAL  Use_Idxqsort
GLOBAL  Use_IdxqsortSt
GLOBAL  Use_PtrqsortSt
GLOBAL  Use_PushPopColors
GLOBAL  Use_Oct
GLOBAL  Use_Overloaded
GLOBAL  Use_OSVersion
GLOBAL  Use_Panel
GLOBAL  Use_Pause
GLOBAL  Use_PeekStr
GLOBAL  Use_Pos
GLOBAL  Use_Printer
GLOBAL  Use_ProgressBar
GLOBAL  Use_Proto
GLOBAL  Use_Put
GLOBAL  Use_QBColor
GLOBAL  Use_DegToRad
GLOBAL  Use_RadToDeg
GLOBAL  Use_Randomize
GLOBAL  Use_Read
GLOBAL  Use_Readnum
GLOBAL  Use_Rec
GLOBAL  Use_RecCount
GLOBAL  Use_Remain
GLOBAL  Use_Remove
GLOBAL  Use_Repeat
GLOBAL  Use_Replace
GLOBAL  Use_ReplaceAny
GLOBAL  Use_RemoveAny
GLOBAL  Use_Reverse
GLOBAL  Use_Right
GLOBAL  Use_RightStr
GLOBAL  Use_Rpad
GLOBAL  Use_Rclick
GLOBAL  Use_Rnd
GLOBAL  Use_Rnd2
GLOBAL  Use_Exp
GLOBAL  Use_Retain
GLOBAL  Use_Round
GLOBAL  Use_Rtrim
GLOBAL  Use_Run
GLOBAL  Use_SaveBmp
GLOBAL  Use_Scan
GLOBAL  Use_Screen
GLOBAL  Use_Setattr
GLOBAL  Use_Seteof
GLOBAL  Use_SearchPath
GLOBAL  Use_Set_BCX_Bitmap
GLOBAL  Use_Set_BCX_Bitmap2
GLOBAL  Use_Set_BCX_BmpButton
GLOBAL  Use_Set_BCX_Icon
GLOBAL  Use_Sgn
GLOBAL  Use_SingleFile AS BOOL
GLOBAL  Use_Sleep
GLOBAL  Use_Sound
GLOBAL  Use_Space
GLOBAL  Use_Split
GLOBAL  Use_DSplit
GLOBAL  Use_StartupCode
GLOBAL  Use_Stristr
GLOBAL  Use_Str
GLOBAL  Use_Strl
GLOBAL  Use_Strim
GLOBAL  Use_String
GLOBAL  Use_Strptr
GLOBAL  Use_Strqsorta
GLOBAL  Use_Strqsortas
GLOBAL  Use_Strqsortd
GLOBAL  Use_Strqsortds
GLOBAL  Use_Strqsorts
GLOBAL  Use_Strtoken
GLOBAL  Use_DynStrqsorta
GLOBAL  Use_DynStrqsortas
GLOBAL  Use_DynStrqsortd
GLOBAL  Use_DynStrqsortds
GLOBAL  Use_DynAlphaNumericA
GLOBAL  Use_DynAlphaNumericD
GLOBAL  Use_AlphaNumericA
GLOBAL  Use_AlphaNumericD
GLOBAL  Use_AlphaNumeric
GLOBAL  Use_RegExist
GLOBAL  Use_RegInt
GLOBAL  Use_RegString
GLOBAL  Use_Resource
GLOBAL  Use_GenResFile
GLOBAL  Use_Swap
GLOBAL  Use_Sysdir
GLOBAL  Use_SysMacros
GLOBAL  Use_SysStr
GLOBAL  Use_sziif
GLOBAL  Use_Tally
GLOBAL  Use_Tempdir
GLOBAL  Use_TempFileName
GLOBAL  Use_Textmode
GLOBAL  Use_Threads
GLOBAL  Use_Time
GLOBAL  Use_Timer
GLOBAL  Use_Tix
GLOBAL  Use_Treeview
GLOBAL  Use_Trim
GLOBAL  Use_Ucase
GLOBAL  Use_Using
GLOBAL  Use_Ubound
GLOBAL  Use_Utf8tochr
GLOBAL  Use_Unwrap
GLOBAL  Use_VChr
GLOBAL  Use_VBS
GLOBAL  Use_Verify
GLOBAL  Use_Val
GLOBAL  Use_Vall
GLOBAL  Use_WideToAnsi
GLOBAL  Use_Vscroll
GLOBAL  Use_Hscroll
GLOBAL  Use_Newbmp
GLOBAL  Use_Makebmp
GLOBAL  Use_Makehdc
GLOBAL  Use_Windir
GLOBAL  Use_Wrap

'*******************

GLOBAL  Use_BCX_Input
GLOBAL  Use_BCX_ToolTip
GLOBAL  Use_Bitmap
GLOBAL  Use_Blackrect
GLOBAL  Use_BmpButton
GLOBAL  Use_Button
GLOBAL  Use_Center
GLOBAL  Use_Checkbox
GLOBAL  Use_Combobox
GLOBAL  Use_Datepick
GLOBAL  Use_Edit
GLOBAL  Use_BCXMDialog
GLOBAL  Use_BCXDialog
GLOBAL  Use_BCXDialogCommon
GLOBAL  Use_Form
GLOBAL  Use_GetText
GLOBAL  Use_Grayrect
GLOBAL  Use_Group
GLOBAL  Use_Hide
GLOBAL  Use_Icon
GLOBAL  Use_Label
GLOBAL  Use_Listbox
GLOBAL  Use_Listview
GLOBAL  Use_PlayWav
GLOBAL  Use_Radio
GLOBAL  Use_Refresh
GLOBAL  Use_Richedit
GLOBAL  Use_SetColor
GLOBAL  Use_Setclientsize
GLOBAL  Use_SetFont
GLOBAL  Use_SetFormColor
GLOBAL  Use_SetText
GLOBAL  Use_Show
GLOBAL  Use_Status
GLOBAL  Use_Whiterect

'********************************
' PB Compatible String Constants
'********************************

GLOBAL  Use_BEL
GLOBAL  Use_BS
GLOBAL  Use_CR
GLOBAL  Use_DDQ
GLOBAL  Use_DQ
GLOBAL  Use_EF
GLOBAL  Use_ESC
GLOBAL  Use_FF
GLOBAL  Use_LF
GLOBAL  Use_NUL
GLOBAL  Use_SPC
GLOBAL  Use_TAB
GLOBAL  Use_VT

'**************************************************************

GLOBAL  cppFile$       ' C/C++ file
GLOBAL  prcFile$       ' translated subs and functions
GLOBAL  udtFile$       ' translated User Defined Types
GLOBAL  datFile$       ' translated DATA statements
GLOBAL  UsrFile$       ' User's translated CONSTants
GLOBAL  SysFile$       ' system translated CONSTants
GLOBAL  ovrFile$       ' translated overloaded subs and functions
GLOBAL  hdrFile$       ' user specified .h directives
GLOBAL  setFile$       ' translated GLOBAL set statements
GLOBAL  resFile$       ' user specified .rc directives
GLOBAL  enuFile$       ' user's GLOBAL enum blocks
GLOBAL  defFile$       ' user's $DEFINE statements
'*************************************************************************
'               GLOBAL VARIABLES FOR LATE BINDING COM SUPPORT
'*************************************************************************

GLOBAL  ComSwitchON = FALSE          ' flag indicating use of COM in source
GLOBAL  ProcessingCOM_Set
GLOBAL  COM_gl_names [COM_Max_Gl_Objs+1] AS COM_NAMES_STORAGE  ' COM objects GLOBAL names
GLOBAL  COM_lc_names [COM_Max_Lc_Objs+1] AS COM_NAMES_STORAGE  ' COM objects LOCAL  names (SUBs and FUNCs)
GLOBAL  COM_gl_names_index%          ' count of com objects used as GLOBAL variables
GLOBAL  COM_lc_names_index%          ' count of com objects used as LOCAL variables (SUBs and FUNCs)
GLOBAL  COM_gl_names_free_index%     ' pointer to a free space in COM_gl_names[]
GLOBAL  COM_lc_names_free_index%     ' pointer to a free space in COM_lc_names[]
GLOBAL  COM_build_trace_code
GLOBAL  COM_with_temp_str_name$
GLOBAL  COM_open_WITH_statement
GLOBAL  COM_FOREACH_enumerator       ' temp variable used in (for each ...) constructions
GLOBAL  Use_COM                      ' COM is used in project, so emit COM functions.
GLOBAL  Use_COM_CLSID
GLOBAL  Use_COM_CreateObject
GLOBAL  Use_COM_DispatchObject
GLOBAL  Use_COM_GetObject
GLOBAL  Use_COM_GetProperty
GLOBAL  Use_COM_InvokeMethod
GLOBAL  Use_COM_SetProperty
GLOBAL  Use_COM_SafeArray
GLOBAL  Use_COM_UsesConversion
GLOBAL  Use_COM_Collections          ' for unicode support
GLOBAL  Use_UNICODE                  ' for unicode support
GLOBAL  Use_MULTITHREADED_SW         ' for multithreaded applications
GLOBAL  Use_SafeArrays

'*************************************************************************
'           END GLOBAL VARIABLES FOR LATE BINDING COM SUPPORT
'*************************************************************************

SET VarConst[2][8] AS CHAR
    "",
    "const "
END SET

SET VarStorage[6][18] AS CHAR
    "static ",
    "extern ",
    "",
    "static volatile ",
    "extern volatile ",
    "volatile "
END SET


'*************************************************************************
' For information on reserved words, currently how to translate
' Additional information may be added in the future.
'*************************************************************************
' Current information on reserved word, table is in alpabetical order
' Wayne Halsdorf
'*************************************************************************

ENUM
    eWI_CPPWord       = 0x0001
    eWI_ReplaceWord   = 0x0002
    eWI_NoFixup       = 0x0004
    eWI_Directive     = 0x0008
    eWI_Transform     = 0x0010
    eWI_Position1     = 0x0020
    eWI_Reserve10     = 0x0040
    eWI_Reserve09     = 0x0080
    eWI_Reserve08     = 0x0100
    eWI_Reserve07     = 0x0200
    eWI_Reserve06     = 0x0400
    eWI_Reserve05     = 0x0800
    eWI_Reserve04     = 0x1000
    eWI_Reserve03     = 0x2000
    eWI_Reserve02     = 0x4000
    eWI_Reserve01     = 0x8000
END ENUM

TYPE TOKSUBFUNC
    iTRAN_FLAG        AS INTEGER    ' Where translations are legal
    pszFunctionName   AS PCHAR      ' BCX word
    pszFunctionXName  AS PCHAR      ' if eWI_ReplaceWord set directly replace with this
    iWordInfo         AS INTEGER    ' See ENUM above
    iCOM              AS INTEGER    ' if can be used in directly with COM
END TYPE

GLOBAL iRIndex[97][2] AS INTEGER    ' Low to High Lookup table for BCXWords[] - Reduces lookup size

SET BCXWords[] AS TOKSUBFUNC
    { 1, "#include"               , "#include"                      , 8, comvt_BAD },
    { 1, "$accelerator"           , ""                              , 8, comvt_BAD },
    { 1, "$asm"                   , ""                              , 8, comvt_BAD },
    { 1, "$bcx_resource"          , ""                              , 8, comvt_BAD },
    { 1, "$bcxstrsize"            , ""                              , 8, comvt_BAD },
    { 1, "$bcxversion"            , ""                              , 8, comvt_BAD },
    { 1, "$case_off"              , ""                              , 8, comvt_BAD },
    { 1, "$case_on"               , ""                              , 8, comvt_BAD },
    { 1, "$ccode"                 , ""                              , 8, comvt_BAD },
    { 1, "$com_off"               , ""                              , 8, comvt_BAD },
    { 1, "$com_on"                , ""                              , 8, comvt_BAD },
    { 1, "$com_trace"             , ""                              , 8, comvt_BAD },
    { 1, "$comment"               , ""                              , 8, comvt_BAD },
    { 1, "$compiler"              , ""                              , 8, comvt_BAD },
    { 1, "$cpp"                   , ""                              , 8, comvt_BAD },
    { 1, "$cpphdr"                , ""                              , 8, comvt_BAD },
    { 1, "$cproto"                , ""                              , 8, comvt_BAD },
    { 1, "$debug"                 , ""                              , 8, comvt_BAD },
    { 1, "$define"                , ""                              , 8, comvt_BAD },
    { 1, "$dll"                   , ""                              , 8, comvt_BAD },
    { 1, "$else"                  , "~else"                         , 2, comvt_BAD },
    { 1, "$elseif"                , "~elseif"                       , 2, comvt_BAD },
    { 1, "$endif"                 , ""                              , 0, comvt_BAD },
    { 1, "$filetest"              , ""                              , 8, comvt_BAD },
    { 1, "$fill"                  , ""                              , 8, comvt_BAD },
    { 1, "$fsstatic"              , ""                              , 8, comvt_BAD },
    { 1, "$genfree"               , ""                              , 8, comvt_BAD },
    { 1, "$header"                , ""                              , 8, comvt_BAD },
    { 1, "$hscroll"               , "~hscroll"                      , 2, comvt_BAD },
    { 1, "$if"                    , ""                              , 0, comvt_BAD },
    { 1, "$ifdef"                 , ""                              , 0, comvt_BAD },
    { 1, "$ifndef"                , ""                              , 0, comvt_BAD },
    { 1, "$include"               , ""                              , 8, comvt_BAD },
    { 1, "$interface"             , ""                              , 8, comvt_BAD },
    { 1, "$iprint_off"            , ""                              , 8, comvt_BAD },
    { 1, "$iprint_on"             , ""                              , 8, comvt_BAD },
    { 1, "$lcc$"                  , "$LCC$"                         , 2, comvt_BAD },
    { 1, "$leanandmean"           , ""                              , 8, comvt_BAD },
    { 1, "$liberror"              , ""                              , 8, comvt_BAD },
    { 1, "$library"               , ""                              , 8, comvt_BAD },
    { 1, "$linker"                , ""                              , 8, comvt_BAD },
    { 1, "$mt"                    , ""                              , 8, comvt_BAD },
    { 1, "$multi"                 , ""                              , 8, comvt_BAD },
    { 1, "$no_borland"            , ""                              , 8, comvt_BAD },
    { 1, "$no_gcc_clang"          , ""                              , 8, comvt_BAD },
    { 1, "$no_lccwin"             , ""                              , 8, comvt_BAD },
    { 1, "$no_libs"               , ""                              , 8, comvt_BAD },
    { 1, "$no_msvc"               , ""                              , 8, comvt_BAD },
    { 1, "$no_pelles"             , ""                              , 8, comvt_BAD },
    { 1, "$no_vkkeys"             , ""                              , 8, comvt_BAD },
    { 1, "$nodllmain"             , ""                              , 8, comvt_BAD },
    { 1, "$noini"                 , ""                              , 8, comvt_BAD },
    { 1, "$noio"                  , ""                              , 8, comvt_BAD },
    { 1, "$nolibrary"             , ""                              , 8, comvt_BAD },
    { 1, "$nomain"                , ""                              , 8, comvt_BAD },
    { 1, "$nowin"                 , ""                              , 8, comvt_BAD },
    { 1, "$onentry"               , ""                              , 8, comvt_BAD },
    { 1, "$onexit"                , ""                              , 8, comvt_BAD },
    { 1, "$optimizer"             , ""                              , 8, comvt_BAD },
    { 1, "$pack"                  , ""                              , 8, comvt_BAD },
    { 1, "$pp"                    , ""                              , 8, comvt_BAD },
    { 1, "$prj"                   , ""                              , 8, comvt_BAD },
    { 1, "$prjuse"                , ""                              , 8, comvt_BAD },
    { 1, "$project"               , ""                              , 8, comvt_BAD },
    { 1, "$rems"                  , ""                              , 8, comvt_BAD },
    { 1, "$resource"              , ""                              , 8, comvt_BAD },
    { 1, "$source"                , ""                              , 8, comvt_BAD },
    { 1, "$stdcall"               , ""                              , 8, comvt_BAD },
    { 1, "$test"                  , ""                              , 8, comvt_BAD },
    { 1, "$trace"                 , ""                              , 8, comvt_BAD },
    { 1, "$typedef"               , ""                              , 8, comvt_BAD },
    { 1, "$vscroll"               , "~vscroll"                      , 2, comvt_BAD },
    { 1, "$warnings"              , ""                              , 8, comvt_BAD },
    { 1, "$warnings_off"          , ""                              , 8, comvt_BAD },
    { 1, "$warnings_on"           , ""                              , 8, comvt_BAD },
    { 1, "$zap"                   , ""                              , 8, comvt_BAD },
    { 1, "_asm"                   , "_asm"                          , 2, comvt_BAD },
    { 1, "_bool"                  , "_Bool"                         , 2, comvt_BAD },
    { 1, "abs"                    , "fabs"                          , 2, comvt_R8  },
    { 1, "acos"                   , "acos"                          , 2, comvt_R8  },
    { 1, "acosh"                  , "acosh"                         , 2, comvt_R8  },
    { 1, "acosl"                  , "acosl"                         , 2, comvt_BAD },
    { 1, "addressof"              , ""                              , 0, comvt_BAD },
    { 1, "alias"                  , "alias"                         , 2, comvt_BAD },
    { 1, "and"                    , ""                              , 0, comvt_BAD },
    { 1, "andalso"                , ""                              , 0, comvt_BAD },
    { 1, "ansitowide"             , ""                              , 0, comvt_BAD },
    { 1, "appactivate"            , ""                              , 0, comvt_BAD },
    { 1, "append"                 , ""                              , 0, comvt_BAD },
    { 1, "appexename$"            , ""                              , 0, comvt_BAD },
    { 1, "appexepath$"            , ""                              , 0, comvt_BAD },
    { 1, "argc"                   , "argc"                          , 2, comvt_BAD },
    { 1, "argv"                   , "argv"                          , 2, comvt_BAD },
    { 1, "argv$"                  , "argv$"                         , 2, comvt_BAD },
    { 1, "arraygetelement"        , ""                              , 0, comvt_BAD },
    { 1, "arrayputelement"        , ""                              , 0, comvt_BAD },
    { 1, "as"                     , ""                              , 0, comvt_BAD },
    { 3, "asc"                    , ""                              , 0, comvt_BAD },
    { 1, "ascending"              , ""                              , 0, comvt_BAD },
    { 1, "asciiz"                 , "string"                        , 2, comvt_BAD },
    { 1, "asin"                   , "asin"                          , 2, comvt_R8  },
    { 1, "asinh"                  , "asinh"                         , 2, comvt_R8  },
    { 1, "asinl"                  , "asinl"                         , 2, comvt_BAD },
    { 1, "asm"                    , ""                              , 1, comvt_BAD },
    { 1, "atan"                   , "atan"                          , 2, comvt_R8  },
    { 1, "atan2"                  , "atan2"                         , 2, comvt_R8  },
    { 1, "atanh"                  , "atanh"                         , 2, comvt_R8  },
    { 1, "atanl"                  , "atanl"                         , 2, comvt_R8  },
    { 1, "atn"                    , "atan"                          , 2, comvt_R8  },
    { 1, "atn2"                   , "atan2"                         , 2, comvt_R8  },
    { 1, "atnl"                   , "atanl"                         , 2, comvt_R8  },
    { 1, "auto"                   , "auto"                          , 2, comvt_BAD },
    { 3, "band"                   , ""                              , 0, comvt_BAD },
    { 1, "base"                   , "base"                          , 2, comvt_BAD },
    { 1, "bcopy"                  , ""                              , 0, comvt_BAD },
    { 1, "bcx_addtab"             , "BCX_AddTab"                    , 2, comvt_BAD },
    { 1, "bcx_arc"                , ""                              , 0, comvt_BAD },
    { 1, "bcx_bitmap"             , ""                              , 0, comvt_BAD },
    { 1, "bcx_blackrect"          , ""                              , 0, comvt_BAD },
    { 1, "bcx_bmpbutton"          , ""                              , 0, comvt_BAD },
    { 1, "bcx_bmpheight"          , ""                              , 0, comvt_BAD },
    { 1, "bcx_bmpwidth"           , ""                              , 0, comvt_BAD },
    { 1, "bcx_buffer_start"       , ""                              , 0, comvt_BAD },
    { 1, "bcx_buffer_stop"        , ""                              , 0, comvt_BAD },
    { 1, "bcx_button"             , ""                              , 0, comvt_BAD },
    { 1, "bcx_checkbox"           , ""                              , 0, comvt_BAD },
    { 1, "bcx_circle"             , ""                              , 0, comvt_BAD },
    { 1, "bcx_classname$"         , "BCX_ClassName$"                , 2, comvt_BAD },
    { 1, "bcx_clsid$"             , ""                              , 0, comvt_BAD },
    { 1, "bcx_colordlg"           , ""                              , 0, comvt_BAD },
    { 1, "bcx_combobox"           , ""                              , 0, comvt_BAD },
    { 1, "bcx_console"            , ""                              , 0, comvt_BAD },
    { 1, "bcx_control"            , ""                              , 0, comvt_BAD },
    { 1, "bcx_cursor"             , ""                              , 0, comvt_BAD },
    { 1, "bcx_datepick"           , ""                              , 0, comvt_BAD },
    { 1, "bcx_dialog"             , ""                              , 0, comvt_BAD },
    { 1, "bcx_dispatchobject"     , ""                              , 0, comvt_BAD },
    { 1, "bcx_edit"               , ""                              , 0, comvt_BAD },
    { 1, "bcx_ellipse"            , ""                              , 0, comvt_BAD },
    { 1, "bcx_floodfill"          , ""                              , 0, comvt_BAD },
    { 1, "bcx_font"               , ""                              , 0, comvt_BAD },
    { 1, "bcx_fontdlg"            , ""                              , 0, comvt_BAD },
    { 1, "bcx_form"               , ""                              , 0, comvt_BAD },
    { 1, "bcx_framewnd"           , ""                              , 0, comvt_BAD },
    { 1, "bcx_get"                , ""                              , 0, comvt_BAD },
    { 1, "bcx_get_com_error_code" , ""                              , 0, comvt_BAD },
    { 1, "bcx_get_com_error_desc$", "BCX_GET_COM_ERROR_DESC()"      , 2, comvt_BAD },
    { 1, "bcx_get_com_status"     , "BCX_GET_COM_STATUS"            , 2, comvt_BAD },
    { 1, "bcx_get_com_success"    , "BCX_GET_COM_SUCCESS()"         , 2, comvt_BAD },
    { 1, "bcx_get_text$"          , ""                              , 0, comvt_BAD },
    { 1, "bcx_get_updown"         , ""                              , 0, comvt_BAD },
    { 1, "bcx_get_window_height"  , ""                              , 0, comvt_BAD },
    { 1, "bcx_get_window_width"   , ""                              , 0, comvt_BAD },
    { 1, "bcx_getpixel"           , ""                              , 0, comvt_BAD },
    { 1, "bcx_gradient"           , ""                              , 0, comvt_BAD },
    { 1, "bcx_grayrect"           , ""                              , 0, comvt_BAD },
    { 1, "bcx_group"              , ""                              , 0, comvt_BAD },
    { 1, "bcx_hinstance"          , "BCX_hInstance"                 , 2, comvt_BAD },
    { 1, "bcx_icon"               , ""                              , 0, comvt_BAD },
    { 1, "bcx_initgui"            , ""                              , 0, comvt_BAD },
    { 1, "bcx_input"              , ""                              , 0, comvt_BAD },
    { 1, "bcx_label"              , ""                              , 0, comvt_BAD },
    { 1, "bcx_line"               , ""                              , 0, comvt_BAD },
    { 1, "bcx_lineto"             , ""                              , 0, comvt_BAD },
    { 1, "bcx_listbox"            , ""                              , 0, comvt_BAD },
    { 1, "bcx_listview"           , ""                              , 0, comvt_BAD },
    { 1, "bcx_loadbmp"            , ""                              , 0, comvt_BAD },
    { 1, "bcx_loadimage"          , ""                              , 0, comvt_BAD },
    { 1, "bcx_mdi_msgpump"        , ""                              , 0, comvt_BAD },
    { 1, "bcx_mdialog"            , ""                              , 0, comvt_BAD },
    { 1, "bcx_mdichild"           , "BCX_MDICHILD"                  , 2, comvt_BAD },
    { 1, "bcx_mdiclass"           , "BCX_MDICLASS"                  , 2, comvt_BAD },
    { 1, "bcx_mdiclient"          , "BCX_MDICLIENT"                 , 2, comvt_BAD },
    { 1, "bcx_msgpump"            , ""                              , 0, comvt_BAD },
    { 1, "bcx_ole_height"         , ""                              , 0, comvt_BAD },
    { 1, "bcx_ole_width"          , ""                              , 0, comvt_BAD },
    { 1, "bcx_olepicture"         , ""                              , 0, comvt_BAD },
    { 1, "bcx_pensize"            , ""                              , 0, comvt_BAD },
    { 1, "bcx_penstyle"           , ""                              , 0, comvt_BAD },
    { 1, "bcx_pie"                , ""                              , 0, comvt_BAD },
    { 1, "bcx_polar_line"         , ""                              , 0, comvt_BAD },
    { 1, "bcx_polar_pset"         , ""                              , 0, comvt_BAD },
    { 1, "bcx_polybezier"         , ""                              , 0, comvt_BAD },
    { 1, "bcx_polygon"            , ""                              , 0, comvt_BAD },
    { 1, "bcx_polyline"           , ""                              , 0, comvt_BAD },
    { 1, "bcx_popconsolesize"     , ""                              , 0, comvt_BAD },
    { 1, "bcx_preset"             , ""                              , 0, comvt_BAD },
    { 1, "bcx_print"              , ""                              , 0, comvt_BAD },
    { 1, "bcx_printex"            , ""                              , 0, comvt_BAD },
    { 1, "bcx_progressbar"        , ""                              , 0, comvt_BAD },
    { 1, "bcx_pset"               , ""                              , 0, comvt_BAD },
    { 1, "bcx_pushconsolesize"    , ""                              , 0, comvt_BAD },
    { 1, "bcx_put"                , ""                              , 0, comvt_BAD },
    { 1, "bcx_radio"              , ""                              , 0, comvt_BAD },
    { 1, "bcx_rectangle"          , ""                              , 0, comvt_BAD },
    { 1, "bcx_regwnd"             , ""                              , 0, comvt_BAD },
    { 1, "bcx_remtab"             , "BCX_RemTab"                    , 2, comvt_BAD },
    { 1, "bcx_resource"           , ""                              , 0, comvt_BAD },
    { 1, "bcx_richedit"           , ""                              , 0, comvt_BAD },
    { 1, "bcx_roundrect"          , ""                              , 0, comvt_BAD },
    { 1, "bcx_scalex"             , "BCX_ScaleX"                    , 2, comvt_BAD },
    { 1, "bcx_scaley"             , "BCX_ScaleY"                    , 2, comvt_BAD },
    { 1, "bcx_set_edit_color"     , ""                              , 0, comvt_BAD },
    { 1, "bcx_set_font"           , ""                              , 0, comvt_BAD },
    { 1, "bcx_set_form_color"     , ""                              , 0, comvt_BAD },
    { 1, "bcx_set_label_color"    , ""                              , 0, comvt_BAD },
    { 1, "bcx_set_text"           , ""                              , 0, comvt_BAD },
    { 1, "bcx_setbkgrdbrush"      , ""                              , 0, comvt_BAD },
    { 1, "bcx_setclassstyle"      , ""                              , 0, comvt_BAD },
    { 1, "bcx_setcolor"           , ""                              , 0, comvt_BAD },
    { 1, "bcx_setconsolesize"     , ""                              , 0, comvt_BAD },
    { 1, "bcx_setcursor"          , ""                              , 0, comvt_BAD },
    { 1, "bcx_seticon"            , ""                              , 0, comvt_BAD },
    { 1, "bcx_seticonsm"          , ""                              , 0, comvt_BAD },
    { 1, "bcx_setmetric"          , ""                              , 0, comvt_BAD },
    { 1, "bcx_setsplitpos"        , ""                              , 0, comvt_BAD },
    { 1, "bcx_show_com_errors"    , "BCX_SHOW_COM_ERRORS"           , 2, comvt_BAD },
    { 1, "bcx_slider"             , ""                              , 0, comvt_BAD },
    { 1, "bcx_splitter"           , ""                              , 0, comvt_BAD },
    { 1, "bcx_status"             , ""                              , 0, comvt_BAD },
    { 1, "bcx_stricmp"            , ""                              , 0, comvt_BAD },
    { 1, "bcx_tab"                , ""                              , 0, comvt_BAD },
    { 1, "bcx_tabselect"          , ""                              , 0, comvt_BAD },
    { 1, "bcx_tempstr"            , "BCX_TempStr"                   , 2, comvt_BAD },
    { 1, "bcx_thread"             , ""                              , 0, comvt_BAD },
    { 1, "bcx_threadend"          , ""                              , 0, comvt_BAD },
    { 1, "bcx_threadkill"         , ""                              , 0, comvt_BAD },
    { 1, "bcx_threadresume"       , ""                              , 0, comvt_BAD },
    { 1, "bcx_threadsuspend"      , ""                              , 0, comvt_BAD },
    { 1, "bcx_threadwait"         , ""                              , 0, comvt_BAD },
    { 1, "bcx_tile"               , ""                              , 0, comvt_BAD },
    { 1, "bcx_toolbar"            , ""                              , 0, comvt_BAD },
    { 1, "bcx_tooltip"            , ""                              , 0, comvt_BAD },
    { 1, "bcx_treeview"           , ""                              , 0, comvt_BAD },
    { 1, "bcx_updown"             , ""                              , 0, comvt_BAD },
    { 1, "bcx_version$"           , ""                              , 0, comvt_BAD },
    { 1, "bcx_whiterect"          , ""                              , 0, comvt_BAD },
    { 1, "bcx_wnd"                , ""                              , 0, comvt_BAD },
    { 1, "bcx_wndclass"           , ""                              , 0, comvt_BAD },
    { 1, "bcxfont"                , "BcxFont"                       , 2, comvt_BAD },
    { 1, "bcxlib"                 , "BCXLIB"                        , 2, comvt_BAD },
    { 1, "bcxpath$"               , ""                              , 0, comvt_BAD },
    { 1, "bcxsplitpath$"          , ""                              , 0, comvt_BAD },
    { 1, "bcxstrsize"             , "BCXSTRSIZE"                    , 0, comvt_BAD },
    { 1, "beep"                   , "Beep"                          , 2, comvt_BAD },
    { 1, "begin"                  , ""                              , 0, comvt_BAD },
    { 1, "bel$"                   , ""                              , 0, comvt_BAD },
    { 1, "bff$"                   , ""                              , 0, comvt_BAD },
    { 1, "bin$"                   , ""                              , 0, comvt_BAD },
    { 1, "bin2dec"                , ""                              , 0, comvt_I4  },
    { 1, "binary"                 , ""                              , 0, comvt_BAD },
    { 3, "bnot"                   , ""                              , 0, comvt_BAD },
    { 1, "bool"                   , ""                              , 0, comvt_BAD },
    { 1, "bool$"                  , ""                              , 0, comvt_BAD },
    { 1, "boolean"                , ""                              , 0, comvt_BAD },
    { 3, "bor"                    , ""                              , 0, comvt_BAD },
    { 1, "bs$"                    , ""                              , 0, comvt_BAD },
    { 1, "byref"                  , ""                              , 0, comvt_BAD },
    { 1, "byte"                   , "unsigned char"                 , 2, comvt_BAD },
    { 1, "byte_at"                , ""                              , 0, comvt_BAD },
    { 1, "c_declare"              , ""                              , 0, comvt_BAD },
    { 1, "call"                   , ""                              , 0, comvt_BAD },
    { 1, "callback"               , ""                              , 0, comvt_BAD },
    { 1, "callwindowproc"         , ""                              , 0, comvt_BAD },
    { 1, "case"                   , ""                              , 0, comvt_BAD },
    { 1, "catch"                  , "catch"                         , 3, comvt_BAD },
    { 1, "cbctl"                  , "LOWORD(wParam)"                , 2, comvt_BAD },
    { 1, "cbctlmsg"               , "HIWORD(wParam)"                , 2, comvt_BAD },
    { 1, "cbhndl"                 , "hWnd"                          , 2, comvt_BAD },
    { 1, "cbhwnd"                 , "hWnd"                          , 2, comvt_BAD },
    { 1, "cblparam"               , "lParam"                        , 2, comvt_BAD },
    { 1, "cbmsg"                  , "Msg"                           , 2, comvt_BAD },
    { 1, "cbnmcode"               , "((LPNMHDR)lParam)->code"       , 2, comvt_BAD },
    { 1, "cbnmhwnd"               , "((LPNMHDR)lParam)->hwndFrom"   , 2, comvt_BAD },
    { 1, "cbnmid"                 , "((LPNMHDR)lParam)->idFrom"     , 2, comvt_BAD },
    { 1, "cbool"                  , ""                              , 0, comvt_BAD },
    { 1, "cbwparam"               , "wParam"                        , 2, comvt_BAD },
    { 1, "cdbl"                   , ""                              , 0, comvt_BAD },
    { 1, "ceil"                   , "ceil"                          , 2, comvt_BAD },
    { 1, "center"                 , ""                              , 0, comvt_BAD },
    { 1, "char"                   , "char"                          , 2, comvt_BAD },
    { 1, "chdir"                  , "_chdir"                        , 2, comvt_BAD },
    { 1, "chdrive"                , "_chdir"                        , 2, comvt_BAD },
    { 1, "chr$"                   , ""                              , 0, comvt_BAD },
    { 1, "chrtoutf8$"             , ""                              , 0, comvt_BAD },
    { 1, "cint"                   , ""                              , 0, comvt_BAD },
    { 1, "class"                  , "class"                         , 3, comvt_BAD },
    { 1, "cldbl"                  , ""                              , 0, comvt_BAD },
    { 1, "clear"                  , ""                              , 0, comvt_BAD },
    { 1, "clipboard_getbitmap"    , ""                              , 0, comvt_BAD },
    { 1, "clipboard_gettext"      , ""                              , 0, comvt_BAD },
    { 1, "clipboard_gettextsize"  , ""                              , 0, comvt_BAD },
    { 1, "clipboard_reset"        , ""                              , 0, comvt_BAD },
    { 1, "clipboard_setbitmap"    , ""                              , 0, comvt_BAD },
    { 1, "clipboard_settext"      , ""                              , 0, comvt_BAD },
    { 1, "clng"                   , ""                              , 0, comvt_BAD },
    { 1, "close"                  , ""                              , 0, comvt_BAD },
    { 1, "close#"                 , "close"                         , 2, comvt_BAD },
    { 1, "closedialog"            , ""                              , 0, comvt_BAD },
    { 1, "cls"                    , ""                              , 0, comvt_BAD },
    { 1, "color"                  , ""                              , 0, comvt_BAD },
    { 1, "color_bg"               , ""                              , 0, comvt_BAD },
    { 1, "color_fg"               , ""                              , 0, comvt_BAD },
    { 1, "colorref"               , "COLORREF"                      , 2, comvt_BAD },
    { 1, "com"                    , "COM"                           , 2, comvt_BAD },
    { 1, "comboboxloadfile"       , ""                              , 0, comvt_BAD },
    { 1, "command$"               , ""                              , 0, comvt_BAD },
    { 1, "concat"                 , ""                              , 0, comvt_BAD },
    { 1, "const"                  , "const"                         , 2, comvt_BAD },
    { 1, "const_cast"             , "const_cast"                    , 3, comvt_BAD },
    { 1, "constructor"            , ""                              , 1, comvt_BAD },
    { 1, "containedin"            , ""                              , 0, comvt_BAD },
    { 1, "continue"               , "continue"                      , 2, comvt_BAD },
    { 1, "control"                , "HWND"                          , 2, comvt_BAD },
    { 1, "conwin"                 , "GetConsoleWindow()"            , 2, comvt_BAD },
    { 1, "copyfile"               , "copyfile"                      , 2, comvt_BAD },
    { 1, "cos"                    , "cos"                           , 2, comvt_R8  },
    { 1, "cosh"                   , "cosh"                          , 2, comvt_R8  },
    { 1, "cosl"                   , "cosl"                          , 2, comvt_BAD },
    { 1, "cpad$"                  , ""                              , 0, comvt_BAD },
    { 1, "cr$"                    , ""                              , 0, comvt_BAD },
    { 1, "createobject"           , ""                              , 0, comvt_BAD },
    { 1, "createregint"           , ""                              , 0, comvt_BAD },
    { 1, "createregstring"        , ""                              , 0, comvt_BAD },
    { 1, "crlf$"                  , ""                              , 0, comvt_BAD },
    { 1, "csng"                   , ""                              , 0, comvt_BAD },
    { 1, "csrlin"                 , ""                              , 0, comvt_BAD },
    { 1, "curdir$"                , ""                              , 0, comvt_BAD },
    { 1, "currency"               , "CURRENCY"                      , 2, comvt_BAD },
    { 1, "cursorx"                , ""                              , 0, comvt_BAD },
    { 1, "cursory"                , ""                              , 0, comvt_BAD },
    { 1, "cvd"                    , ""                              , 0, comvt_BAD },
    { 1, "cvi"                    , ""                              , 0, comvt_BAD },
    { 1, "cvl"                    , ""                              , 0, comvt_BAD },
    { 1, "cvld"                   , ""                              , 0, comvt_BAD },
    { 1, "cvs"                    , ""                              , 0, comvt_BAD },
    { 1, "data"                   , ""                              , 0, comvt_BAD },
    { 1, "data$"                  , "DATA$"                         , 2, comvt_BAD },
    { 1, "date$"                  , ""                              , 0, comvt_BAD },
    { 1, "ddq$"                   , ""                              , 0, comvt_BAD },
    { 1, "declare"                , ""                              , 16, comvt_BAD },
    { 1, "decr"                   , "decr"                          , 2, comvt_BAD },
    { 1, "degtorad"               , ""                              , 0, comvt_BAD },
    { 1, "del$"                   , ""                              , 0, comvt_BAD },
    { 1, "delay"                  , "delay"                         , 2, comvt_BAD },
    { 1, "delete"                 , "delete"                        , 3, comvt_BAD },
    { 1, "deleteregkey"           , ""                              , 0, comvt_BAD },
    { 1, "descending"             , ""                              , 0, comvt_BAD },
    { 1, "destroysafearray"       , "DestroySafeArray"              , 0, comvt_BAD },
    { 1, "destructor"             , ""                              , 1, comvt_BAD },
    { 1, "dialog"                 , ""                              , 0, comvt_BAD },
    { 1, "dialogbox"              , "DialogBox"                     , 2, comvt_BAD },
    { 1, "dim"                    , "dim"                           , 2, comvt_BAD },
    { 1, "diskfree"               , "DiskFree"                      , 0, comvt_BAD },
    { 1, "disksize"               , "DiskSize"                      , 0, comvt_BAD },
    { 1, "diskused"               , "DiskUsed"                      , 0, comvt_BAD },
    { 1, "do"                     , "do"                            , 2, comvt_BAD },
    { 1, "doevents"               , ""                              , 0, comvt_BAD },
    { 1, "double"                 , "double"                        , 2, comvt_BAD },
    { 1, "download"               , ""                              , 0, comvt_BAD },
    { 1, "downloadtostr"          , ""                              , 0, comvt_BAD },
    { 1, "dpi"                    , "dpi"                           , 2, comvt_BAD },
    { 1, "dq$"                    , ""                              , 0, comvt_BAD },
    { 1, "draw"                   , ""                              , 0, comvt_BAD },
    { 1, "drawtransbmp"           , ""                              , 0, comvt_BAD },
    { 1, "dsplit"                 , ""                              , 0, comvt_BAD },
    { 1, "dwl_dlgproc"            , "DWLP_DLGPROC"                  , 2, comvt_BAD },
    { 1, "dwl_msgresult"          , "DWLP_MSGRESULT"                , 2, comvt_BAD },
    { 1, "dwl_user"               , "DWLP_USER"                     , 2, comvt_BAD },
    { 1, "dword"                  , "ULONG"                         , 2, comvt_BAD },
    { 1, "dynamic"                , "dynamic"                       , 2, comvt_BAD },
    { 1, "dynamic_cast"           , "dynamic_cast"                  , 3, comvt_BAD },
    { 1, "editloadfile"           , ""                              , 0, comvt_BAD },
    { 1, "ejectpage"              , "ejectpage"                     , 2, comvt_BAD },
    { 1, "else"                   , "else"                          , 2, comvt_BAD },
    { 1, "elseif"                 , ""                              , 0, comvt_BAD },
    { 1, "enc$"                   , ""                              , 0, comvt_BAD },
    { 1, "end"                    , ""                              , 0, comvt_BAD },
    { 1, "enddraw"                , ""                              , 0, comvt_BAD },
    { 1, "endif"                  , "endif"                         , 2, comvt_BAD },
    { 1, "endmodal"               , ""                              , 0, comvt_BAD },
    { 1, "enum"                   , ""                              , 0, comvt_BAD },
    { 1, "environ$"               , ""                              , 0, comvt_BAD },
    { 1, "eof"                    , ""                              , 0, comvt_BAD },
    { 1, "eof$"                   , ""                              , 0, comvt_BAD },
    { 1, "equalto"                , ""                              , 0, comvt_BAD },
    { 1, "esc$"                   , ""                              , 0, comvt_BAD },
    { 1, "events"                 , "events"                        , 0, comvt_BAD },
    { 1, "exist"                  , ""                              , 0, comvt_BAD },
    { 1, "exit"                   , "exit"                          , 2, comvt_BAD },
    { 1, "exit_each"              , "EXIT_EACH"                     , 2, comvt_BAD },
    { 1, "exp"                    , ""                              , 0, comvt_R8  },
    { 1, "explicit"               , "explicit"                      , 3, comvt_BAD },
    { 1, "export"                 , "export"                        , 2, comvt_BAD },
    { 1, "extern"                 , "extern"                        , 2, comvt_BAD },
    { 1, "extract$"               , ""                              , 0, comvt_BAD },
    { 1, "extractany$"            , ""                              , 0, comvt_BAD },
    { 1, "fallthrough"            , "fallthrough"                   , 2, comvt_BAD },
    { 1, "false"                  , ""                              , 0, comvt_BAD },
    { 1, "farproc"                , "FARPROC"                       , 2, comvt_BAD },
    { 1, "ff$"                    , ""                              , 0, comvt_BAD },
    { 1, "file"                   , "FILE"                          , 2, comvt_BAD },
    { 1, "filecopy"               , "copyfile"                      , 2, comvt_BAD },
    { 1, "filelocked"             , ""                              , 0, comvt_BAD },
    { 1, "fillarray"              , ""                              , 0, comvt_BAD },
    { 1, "findfirst$"             , ""                              , 0, comvt_BAD },
    { 1, "findfirstinstance"      , ""                              , 0, comvt_BAD },
    { 1, "findintype"             , ""                              , 0, comvt_BAD },
    { 1, "findnext$"              , ""                              , 0, comvt_BAD },
    { 1, "finput"                 , "finput"                        , 2, comvt_BAD },
    { 1, "fint"                   , ""                              , 0, comvt_INT },
    { 1, "fix"                    , ""                              , 0, comvt_R4  },
    { 1, "float"                  , "float"                         , 2, comvt_BAD },
    { 1, "floor"                  , "floor"                         , 2, comvt_BAD },
    { 1, "flush"                  , "flush"                         , 2, comvt_BAD },
    { 1, "for"                    , ""                              , 0, comvt_BAD },
    { 1, "for_each"               , ""                              , 0, comvt_BAD },
    { 1, "formload"               , "FormLoad"                      , 2, comvt_BAD },
    { 1, "fprint"                 , "fprint"                        , 2, comvt_BAD },
    { 1, "frac"                   , ""                              , 0, comvt_R8  },
    { 1, "fracl"                  , ""                              , 0, comvt_BAD },
    { 1, "free"                   , "free"                          , 2, comvt_BAD },
    { 1, "freefile"               , ""                              , 0, comvt_BAD },
    { 1, "freeglobals"            , "FreeGlobals"                   , 2, comvt_BAD },
    { 1, "freelibrary"            , "FreeLibrary"                   , 2, comvt_BAD },
    { 1, "friend"                 , ""                              , 1, comvt_BAD },
    { 1, "from"                   , "from"                          , 2, comvt_BAD },
    { 1, "funcname$"              , "__func__$"                     , 2, comvt_BAD },
    { 1, "function"               , ""                              , 0, comvt_BAD },
    { 1, "fwrite"                 , "fwrite"                        , 2, comvt_BAD },
    { 1, "gcl_hbrbackground"      , "GCLP_HBRBACKGROUND"            , 2, comvt_BAD },
    { 1, "gcl_hcursor"            , "GCLP_HCURSOR"                  , 2, comvt_BAD },
    { 1, "gcl_hicon"              , "GCLP_HICON"                    , 2, comvt_BAD },
    { 1, "gcl_hiconsm"            , "GCLP_HICONSM"                  , 2, comvt_BAD },
    { 1, "gcl_hmodule"            , "GCLP_HMODULE"                  , 2, comvt_BAD },
    { 1, "gcl_menuname"           , "GCLP_MENUNAME"                 , 2, comvt_BAD },
    { 1, "gcl_wndproc"            , "GCLP_WNDPROC"                  , 2, comvt_BAD },
    { 1, "get"                    , "~get"                          , 2, comvt_BAD },
    { 1, "get$"                   , "~get"                          , 2, comvt_BAD },
    { 1, "getattr"                , ""                              , 0, comvt_BAD },
    { 1, "getbmp"                 , ""                              , 0, comvt_BAD },
    { 1, "getbvalue"              , "GetBValue"                     , 2, comvt_BAD },
    { 1, "getch"                  , "_getch"                        , 2, comvt_BAD },
    { 1, "getdimension"           , ""                              , 0, comvt_BAD },
    { 1, "getdlgitem"             , "GetDlgItem"                    , 2, comvt_BAD },
    { 1, "getdrive"               , ""                              , 0, comvt_BAD },
    { 1, "getfilename$"           , ""                              , 0, comvt_BAD },
    { 1, "getgvalue"              , "GetGValue"                     , 2, comvt_BAD },
    { 1, "gethttpfilesize"        , ""                              , 0, comvt_BAD },
    { 1, "getobject"              , ""                              , 0, comvt_BAD },
    { 1, "getprocaddress"         , ""                              , 0, comvt_BAD },
    { 1, "getresource"            , ""                              , 0, comvt_BAD },
    { 1, "getrvalue"              , "GetRValue"                     , 2, comvt_BAD },
    { 1, "getsaveasfilename"      , ""                              , 0, comvt_BAD },
    { 1, "getspecialfolder"       , ""                              , 0, comvt_BAD },
    { 1, "getspecialfolder$"      , ""                              , 0, comvt_BAD },
    { 1, "getspecialfolderex$"    , ""                              , 0, comvt_BAD },
    { 1, "gettextsize"            , ""                              , 0, comvt_BAD },
    { 1, "getwindowlong"          , "GetWindowLongPtr"              , 2, comvt_BAD },
    { 1, "global"                 , "global"                        , 2, comvt_BAD },
    { 1, "gosub"                  , "gosub"                         , 2, comvt_BAD },
    { 1, "goto"                   , "goto"                          , 2, comvt_BAD },
    { 1, "gui"                    , "gui"                           , 2, comvt_BAD },
    { 1, "gwl_hinstance"          , "GWLP_HINSTANCE"                , 2, comvt_BAD },
    { 1, "gwl_hwndparent"         , "GWLP_HWNDPARENT"               , 2, comvt_BAD },
    { 1, "gwl_id"                 , "GWLP_ID"                       , 2, comvt_BAD },
    { 1, "gwl_userdata"           , "GWLP_USERDATA"                 , 2, comvt_BAD },
    { 1, "gwl_wndproc"            , "GWLP_WNDPROC"                  , 2, comvt_BAD },
    { 1, "hex$"                   , ""                              , 0, comvt_BAD },
    { 1, "hex2dec"                , ""                              , 0, comvt_I4  },
    { 1, "hibyte"                 , "HIBYTE"                        , 2, comvt_BAD },
    { 1, "hide"                   , ""                              , 0, comvt_BAD },
    { 1, "hiword"                 , "HIWORD"                        , 2, comvt_BAD },
    { 1, "hypot"                  , "hypot"                         , 2, comvt_R8  },
    { 1, "hypotl"                 , "hypotl"                        , 2, comvt_R8  },
    { 1, "iabs"                   , "abs"                           , 2, comvt_BAD },
    { 1, "icompare"               , ""                              , 0, comvt_BAD },
    { 1, "icon"                   , "icon"                          , 2, comvt_BAD },
    { 1, "if"                     , "if"                            , 16, comvt_BAD },
    { 1, "iif"                    , ""                              , 0, comvt_R8  },
    { 1, "iif$"                   , ""                              , 0, comvt_BAD },
    { 1, "iinstr"                 , ""                              , 0, comvt_BAD },
    { 1, "iinstrany"              , ""                              , 0, comvt_BAD },
    { 1, "imod"                   , ""                              , 0, comvt_BAD },
    { 1, "impfunction"            , "impfunction"                   , 3, comvt_BAD },
    { 1, "in"                     , "in"                            , 0, comvt_BAD },
    { 1, "inchr"                  , ""                              , 0, comvt_R4  },
    { 1, "incr"                   , "incr"                          , 2, comvt_BAD },
    { 1, "infobox"                , ""                              , 0, comvt_BAD },
    { 1, "initsafearray"          , "InitSafeArray"                 , 0, comvt_BAD },
    { 1, "inkey"                  , ""                              , 0, comvt_BAD },
    { 1, "inkey$"                 , ""                              , 0, comvt_BAD },
    { 1, "inline"                 , ""                              , 1, comvt_BAD },
    { 1, "inp"                    , ""                              , 0, comvt_BAD },
    { 1, "input"                  , ""                              , 0, comvt_BAD },
    { 1, "inputbox$"              , ""                              , 0, comvt_BAD },
    { 1, "inputbuffer$"           , "InputBuffer$"                  , 0, comvt_BAD },
    { 1, "ins$"                   , ""                              , 0, comvt_BAD },
    { 1, "instat"                 , "_kbhit()"                      , 2, comvt_BAD },
    { 1, "instr"                  , ""                              , 0, comvt_R4  },
    { 1, "instrany"               , ""                              , 0, comvt_BAD },
    { 1, "instrrev"               , ""                              , 0, comvt_R4  },
    { 1, "int"                    , "int"                           , 2, comvt_BAD },
    { 1, "integer"                , "int"                           , 2, comvt_BAD },
    { 1, "iremove"                , ""                              , 16, comvt_BAD },
    { 1, "iremove$"               , ""                              , 0, comvt_BAD },
    { 1, "iremoveany$"            , ""                              , 0, comvt_BAD },
    { 1, "ireplace"               , ""                              , 16, comvt_BAD },
    { 1, "ireplace$"              , ""                              , 0, comvt_BAD },
    { 1, "ireplaceany$"           , ""                              , 0, comvt_BAD },
    { 1, "is"                     , "is"                            , 2, comvt_BAD },
    { 1, "isdigit"                , "isdigit"                       , 2, comvt_BAD },
    { 1, "isobject"               , "ISOBJECT"                      , 2, comvt_BAD },
    { 1, "isodate"                , ""                              , 0, comvt_BAD },
    { 1, "isptr"                  , ""                              , 0, comvt_BAD },
    { 1, "ispunct"                , "ispunct"                       , 2, comvt_BAD },
    { 1, "iswxdigit"              , "iswxdigit"                     , 2, comvt_BAD },
    { 1, "iterate"                , "continue"                      , 2, comvt_BAD },
    { 1, "join$"                  , ""                              , 0, comvt_BAD },
    { 1, "keypress"               , ""                              , 0, comvt_BAD },
    { 1, "kill"                   , "kill"                          , 2, comvt_BAD },
    { 1, "labs"                   , "labs"                          , 2, comvt_BAD },
    { 1, "land"                   , ""                              , 0, comvt_BAD },
    { 3, "lcase$"                 , ""                              , 0, comvt_BAD },
    { 1, "lccpath$"               , ""                              , 0, comvt_BAD },
    { 1, "ldouble"                , ""                              , 0, comvt_BAD },
    { 1, "left$"                  , ""                              , 0, comvt_BAD },
    { 1, "leftstr"                , ""                              , 0, comvt_BAD },
    { 1, "len"                    , "(int)strlen"                   , 2, comvt_R4  },
    { 1, "lf$"                    , ""                              , 0, comvt_BAD },
    { 1, "lib"                    , "lib"                           , 2, comvt_BAD },
    { 1, "libmain"                , "dllmain"                       , 2, comvt_BAD },
    { 1, "like"                   , ""                              , 0, comvt_BAD },
    { 1, "like_instr"             , ""                              , 0, comvt_BAD },
    { 1, "line"                   , ""                              , 0, comvt_BAD },
    { 1, "listboxloadfile"        , ""                              , 0, comvt_BAD },
    { 1, "llabs"                  , "llabs"                         , 2, comvt_BAD },
    { 1, "load_dll"               , "LoadLibrary"                   , 2, comvt_BAD },
    { 1, "loadfile$"              , ""                              , 0, comvt_BAD },
    { 1, "loadlibrary"            , "LoadLibrary"                   , 2, comvt_BAD },
    { 1, "lobyte"                 , "LOBYTE"                        , 2, comvt_BAD },
    { 1, "loc"                    , ""                              , 0, comvt_BAD },
    { 1, "local"                  , ""                              , 0, comvt_BAD },
    { 1, "locate"                 , ""                              , 0, comvt_BAD },
    { 1, "lof"                    , ""                              , 0, comvt_R8  },
    { 1, "log"                    , "log"                           , 2, comvt_R8  },
    { 1, "log10"                  , "log10"                         , 2, comvt_R8  },
    { 1, "log10l"                 , "log10l"                        , 2, comvt_BAD },
    { 1, "logl"                   , "logl"                          , 2, comvt_BAD },
    { 1, "long"                   , "long"                          , 2, comvt_BAD },
    { 1, "longest"                , ""                              , 0, comvt_BAD },
    { 1, "longlong"               , "LONGLONG"                      , 2, comvt_BAD },
    { 1, "lookahead"              , ""                              , 0, comvt_BAD },
    { 1, "loop"                   , "loop"                          , 2, comvt_BAD },
    { 1, "lor"                    , ""                              , 0, comvt_BAD },
    { 1, "loword"                 , "LOWORD"                        , 2, comvt_BAD },
    { 1, "lpad$"                  , ""                              , 0, comvt_BAD },
    { 1, "lpbyte"                 , "LPBYTE"                        , 2, comvt_BAD },
    { 1, "lprint"                 , ""                              , 0, comvt_BAD },
    { 1, "lpstr"                  , "PSTR"                          , 2, comvt_BAD },
    { 1, "lresult"                , "LRESULT"                       , 2, comvt_BAD },
    { 1, "ltoa"                   , "_ltoa"                         , 2, comvt_BAD },
    { 1, "ltrim$"                 , ""                              , 0, comvt_BAD },
    { 1, "macro"                  , "const"                         , 2, comvt_BAD },
    { 1, "main"                   , "main"                          , 2, comvt_BAD },
    { 1, "makedword"              , "MAKELONG"                      , 2, comvt_BAD },
    { 1, "makeintresource"        , "MAKEINTRESOURCE"               , 2, comvt_BAD },
    { 1, "makelong"               , "MAKELONG"                      , 2, comvt_BAD },
    { 1, "makeword"               , "MAKEWORD"                      , 2, comvt_BAD },
    { 1, "max"                    , ""                              , 0, comvt_R8  },
    { 3, "mcase$"                 , ""                              , 0, comvt_BAD },
    { 1, "mdigui"                 , "mdigui"                        , 2, comvt_BAD },
    { 1, "me"                     , ""                              , 0, comvt_BAD },
    { 1, "memicmp"                , "_memicmp"                      , 2, comvt_BAD },
    { 1, "memsize"                , "_msize"                        , 2, comvt_BAD },
    { 1, "mid$"                   , ""                              , 0, comvt_BAD },
    { 1, "min"                    , ""                              , 0, comvt_R8  },
    { 1, "mkd$"                   , ""                              , 0, comvt_BAD },
    { 1, "mkdir"                  , "_mkdir"                        , 2, comvt_BAD },
    { 1, "mki$"                   , ""                              , 0, comvt_BAD },
    { 1, "mkl$"                   , ""                              , 0, comvt_BAD },
    { 1, "mkld$"                  , ""                              , 0, comvt_BAD },
    { 1, "mks$"                   , ""                              , 0, comvt_BAD },
    { 1, "mod"                    , "fmod"                          , 2, comvt_BAD },
    { 1, "modstyle"               , ""                              , 0, comvt_BAD },
    { 1, "mouse_cx"               , ""                              , 0, comvt_BAD },
    { 1, "mouse_cy"               , ""                              , 0, comvt_BAD },
    { 1, "mouse_sx"               , ""                              , 0, comvt_BAD },
    { 1, "mouse_sy"               , ""                              , 0, comvt_BAD },
    { 1, "msgbox"                 , ""                              , 0, comvt_BAD },
    { 1, "namespace"              , "namespace"                     , 3, comvt_BAD },
    { 1, "nest"                   , "nest"                          , 2, comvt_BAD },
    { 1, "new"                    , ""                              , 1, comvt_BAD },
    { 1, "newbmp"                 , ""                              , 0, comvt_BAD },
    { 1, "next"                   , "next"                          , 34, comvt_BAD },
    { 1, "next_each"              , ""                              , 0, comvt_BAD },
    { 1, "nextlinelen"            , ""                              , 0, comvt_BAD },
    { 1, "nosort"                 , "WS_CHILD|WS_VISIBLE|WS_VSCROLL", 2, comvt_BAD },
    { 1, "not"                    , ""                              , 0, comvt_BAD },
    { 1, "notequalto"             , ""                              , 0, comvt_BAD },
    { 1, "nothing"                , ""                              , 0, comvt_BAD },
    { 1, "now$"                   , ""                              , 0, comvt_BAD },
    { 1, "nul$"                   , ""                              , 0, comvt_BAD },
    { 1, "null"                   , "NULL"                          , 2, comvt_BAD },
    { 1, "object"                 , ""                              , 0, comvt_BAD },
    { 1, "oct$"                   , ""                              , 0, comvt_BAD },
    { 1, "on"                     , "on"                            , 0, comvt_BAD },
    { 1, "open"                   , ""                              , 0, comvt_BAD },
    { 1, "operator"               , ""                              , 0, comvt_BAD },
    { 1, "option"                 , "option"                        , 2, comvt_BAD },
    { 1, "optional"               , "optional"                      , 2, comvt_BAD },
    { 1, "or"                     , ""                              , 0, comvt_BAD },
    { 1, "orelse"                 , ""                              , 0, comvt_BAD },
    { 1, "osversion"              , ""                              , 0, comvt_BAD },
    { 1, "outp"                   , ""                              , 0, comvt_BAD },
    { 1, "output"                 , ""                              , 0, comvt_BAD },
    { 1, "outpw"                  , ""                              , 0, comvt_BAD },
    { 1, "overloaded"             , ""                              , 0, comvt_BAD },
    { 1, "panel"                  , ""                              , 0, comvt_BAD },
    { 1, "pause"                  , ""                              , 0, comvt_BAD },
    { 1, "pchar"                  , "PCHAR"                         , 2, comvt_BAD },
    { 1, "peek$"                  , ""                              , 0, comvt_BAD },
    { 1, "pellespath$"            , ""                              , 0, comvt_BAD },
    { 1, "pi"                     , ""                              , 0, comvt_BAD },
    { 1, "pixels"                 , "pixels"                        , 2, comvt_BAD },
    { 1, "playwav"                , ""                              , 0, comvt_BAD },
    { 1, "poke"                   , "memcpy"                        , 2, comvt_BAD },
    { 1, "popcolors"              , ""                              , 0, comvt_BAD },
    { 1, "pos"                    , ""                              , 0, comvt_R4  },
    { 1, "pow"                    , "pow"                           , 2, comvt_R8  },
    { 1, "powl"                   , "powl"                          , 2, comvt_BAD },
    { 1, "pptype"                 , "pptype"                        , 2, comvt_BAD },
    { 1, "prepend"                , "prepend"                       , 2, comvt_BAD },
    { 1, "preserve"               , "PRESERVE"                      , 2, comvt_BAD },
    { 1, "print"                  , ""                              , 0, comvt_BAD },
    { 1, "print#"                 , "fprint"                        , 2, comvt_BAD },
    { 1, "printer"                , ""                              , 0, comvt_BAD },
    { 1, "private"                , ""                              , 1, comvt_BAD },
    { 1, "program"                , "program"                       , 2, comvt_BAD },
    { 1, "property"               , "property"                      , 3, comvt_BAD },
    { 1, "protected"              , ""                              , 1, comvt_BAD },
    { 1, "ps_dash"                , "PS_DASH"                       , 2, comvt_BAD },
    { 1, "ps_dashdot"             , "PS_DASHDOT"                    , 2, comvt_BAD },
    { 1, "ps_dashdotdot"          , "PS_DASHDOTDOT"                 , 2, comvt_BAD },
    { 1, "ps_dot"                 , "PS_DOT"                        , 2, comvt_BAD },
    { 1, "ps_solid"               , "PS_SOLID"                      , 2, comvt_BAD },
    { 1, "pstr"                   , "PSTR"                          , 2, comvt_BAD },
    { 1, "ptr"                    , ""                              , 0, comvt_BAD },
    { 1, "public"                 , ""                              , 1, comvt_BAD },
    { 1, "pushcolors"             , ""                              , 0, comvt_BAD },
    { 1, "put"                    , "~put"                          , 2, comvt_BAD },
    { 1, "put$"                   , "~put"                          , 2, comvt_BAD },
    { 1, "qbcolor"                , ""                              , 0, comvt_BAD },
    { 1, "qsort"                  , "qsort"                         , 2, comvt_BAD },
    { 1, "qsortidx"               , "qsortidx"                      , 2, comvt_BAD },
    { 1, "radtodeg"               , ""                              , 0, comvt_BAD },
    { 1, "randomize"              , ""                              , 0, comvt_BAD },
    { 1, "raw"                    , "raw"                           , 2, comvt_BAD },
    { 1, "read"                   , ""                              , 0, comvt_BAD },
    { 1, "read$"                  , ""                              , 0, comvt_BAD },
    { 1, "rec"                    , ""                              , 0, comvt_BAD },
    { 1, "reccount"               , ""                              , 0, comvt_BAD },
    { 1, "reclen"                 , "reclen"                        , 2, comvt_BAD },
    { 1, "record"                 , "record"                        , 2, comvt_BAD },
    { 1, "redim"                  , "redim"                         , 2, comvt_BAD },
    { 1, "refresh"                , ""                              , 0, comvt_BAD },
    { 1, "regexist"               , ""                              , 0, comvt_BAD },
    { 1, "regint"                 , ""                              , 0, comvt_BAD },
    { 1, "register"               , "register"                      , 2, comvt_BAD },
    { 1, "regstring$"             , ""                              , 0, comvt_BAD },
    { 1, "reinterpret_cast"       , "reinterpret_cast"              , 3, comvt_BAD },
    { 1, "release"                , ""                              , 0, comvt_BAD },
    { 1, "rem"                    , "rem"                           , 0, comvt_BAD },
    { 1, "remain$"                , ""                              , 0, comvt_BAD },
    { 1, "remove"                 , "remove"                        , 18, comvt_BAD },
    { 1, "remove$"                , ""                              , 0, comvt_BAD },
    { 1, "removeany$"             , ""                              , 0, comvt_BAD },
    { 1, "rename"                 , "rename"                        , 2, comvt_BAD },
    { 1, "repeat"                 , "repeat"                        , 0, comvt_BAD },
    { 1, "repeat$"                , ""                              , 0, comvt_BAD },
    { 1, "replace"                , "replace"                       , 18, comvt_BAD },
    { 1, "replace$"               , ""                              , 0, comvt_BAD },
    { 1, "replaceany$"            , ""                              , 0, comvt_BAD },
    { 1, "resume"                 , ""                              , 0, comvt_BAD },
    { 1, "retain$"                , ""                              , 0, comvt_BAD },
    { 1, "return"                 , "return"                        , 2, comvt_BAD },
    { 1, "reverse$"               , ""                              , 0, comvt_BAD },
    { 1, "rewind"                 , ""                              , 0, comvt_BAD },
    { 1, "right$"                 , ""                              , 0, comvt_BAD },
    { 1, "rightstr"               , ""                              , 0, comvt_BAD },
    { 1, "rmdir"                  , "_rmdir"                        , 2, comvt_BAD },
    { 1, "rnd"                    , ""                              , 0, comvt_R4  },
    { 1, "rnd2"                   , ""                              , 0, comvt_R4  },
    { 1, "round"                  , ""                              , 0, comvt_R8  },
    { 1, "rpad$"                  , ""                              , 0, comvt_BAD },
    { 1, "rtrim$"                 , ""                              , 0, comvt_BAD },
    { 1, "run"                    , ""                              , 0, comvt_BAD },
    { 1, "savebmp"                , ""                              , 0, comvt_BAD },
    { 1, "scanerror"              , "ScanError"                     , 2, comvt_BAD }, ' For access to input Error Code
    { 1, "schar"                  , "signed char"                   , 2, comvt_BAD },
    { 1, "screen"                 , ""                              , 0, comvt_BAD },
    { 1, "searchpath$"            , ""                              , 0, comvt_BAD },
    { 1, "seek"                   , "seek"                          , 2, comvt_BAD },
    { 1, "select"                 , "select"                        , 2, comvt_BAD },
    { 1, "sendmessage"            , ""                              , 0, comvt_BAD },
    { 1, "set"                    , ""                              , 0, comvt_BAD },
    { 1, "set_bcx_bitmap"         , ""                              , 0, comvt_BAD },
    { 1, "set_bcx_bitmap2"        , ""                              , 0, comvt_BAD },
    { 1, "set_bcx_bmpbutton"      , ""                              , 0, comvt_BAD },
    { 1, "set_bcx_icon"           , ""                              , 0, comvt_BAD },
    { 1, "setattr"                , ""                              , 0, comvt_BAD },
    { 1, "setdimension"           , ""                              , 0, comvt_BAD },
    { 1, "seteof"                 , "SetEof"                        , 2, comvt_BAD },
    { 1, "setmode"                , "_setmode"                      , 2, comvt_BAD },
    { 1, "setwindowlong"          , "SetWindowLongPtr"              , 2, comvt_BAD },
    { 1, "setwindowrtftext"       , ""                              , 0, comvt_BAD },
    { 1, "sgn"                    , ""                              , 0, comvt_R4  },
    { 1, "shared"                 , "shared"                        , 2, comvt_BAD },
    { 1, "shell"                  , "shell"                         , 2, comvt_BAD },
    { 1, "shl"                    , ""                              , 0, comvt_BAD },
    { 1, "short"                  , "short"                         , 2, comvt_BAD },
    { 1, "show"                   , ""                              , 0, comvt_BAD },
    { 1, "showmodal"              , ""                              , 0, comvt_BAD },
    { 1, "shr"                    , ""                              , 0, comvt_BAD },
    { 1, "sin"                    , "sin"                           , 2, comvt_R8  },
    { 1, "single"                 , "float"                         , 2, comvt_BAD },
    { 1, "sinh"                   , "sinh"                          , 2, comvt_R8  },
    { 1, "sinl"                   , "sinl"                          , 2, comvt_BAD },
    { 1, "size_t"                 , "size_t"                        , 2, comvt_R4  },
    { 1, "sizeof"                 , "sizeof"                        , 2, comvt_R4  },
    { 1, "sleep"                  , ""                              , 0, comvt_BAD },
    { 1, "sndmsg"                 , ""                              , 0, comvt_BAD },
    { 1, "sound"                  , ""                              , 0, comvt_BAD },
    { 1, "space$"                 , ""                              , 0, comvt_BAD },
    { 1, "spc$"                   , ""                              , 0, comvt_BAD },
    { 1, "split"                  , ""                              , 0, comvt_BAD },
    { 1, "splitbarbg"             , "SplitBarBG"                    , 2, comvt_BAD },
    { 1, "splitbarfg"             , "SplitBarFG"                    , 2, comvt_BAD },
    { 1, "sprint"                 , "sprint"                        , 2, comvt_BAD },
    { 1, "sqr"                    , "sqrt"                          , 2, comvt_R8  },
    { 1, "sqrl"                   , "sqrtl"                         , 2, comvt_BAD },
    { 1, "sqrt"                   , "sqrt"                          , 2, comvt_R8  },
    { 1, "sqrtl"                  , "sqrtl"                         , 2, comvt_BAD },
    { 1, "sshort"                 , "signed short"                  , 2, comvt_BAD },
    { 1, "startdraw"              , ""                              , 0, comvt_BAD },
    { 1, "static"                 , "static"                        , 2, comvt_BAD },
    { 1, "static_cast"            , "static_cast"                   , 3, comvt_BAD },
    { 1, "stdcall"                , ""                              , 0, comvt_BAD },
    { 1, "step"                   , ""                              , 0, comvt_BAD },
    { 1, "str$"                   , ""                              , 0, comvt_BAD },
    { 1, "str2variant"            , ""                              , 0, comvt_BAD },
    { 1, "strarray"               , "PSTR*"                        , 2, comvt_BAD },
    { 1, "strim$"                 , ""                              , 0, comvt_BAD },
    { 1, "string"                 , "string"                        , 2, comvt_BAD },
    { 1, "string$"                , ""                              , 0, comvt_BAD },
    { 1, "strl$"                  , ""                              , 0, comvt_BAD },
    { 1, "strptr"                 , ""                              , 0, comvt_BAD },
    { 1, "strtoken$"              , ""                              , 0, comvt_BAD },
    { 1, "struct"                 , "struct"                        , 0, comvt_BAD },
    { 1, "sub"                    , "sub"                           , 0, comvt_BAD },
    { 1, "swap"                   , ""                              , 0, comvt_BAD },
    { 1, "sysdir$"                , ""                              , 0, comvt_BAD },
    { 1, "sysstr"                 , ""                              , 0, comvt_BAD },
    { 1, "tab$"                   , ""                              , 0, comvt_BAD },
    { 1, "tally"                  , ""                              , 0, comvt_R4  },
    { 1, "tan"                    , "tan"                           , 2, comvt_R8  },
    { 1, "tanh"                   , "tanh"                          , 2, comvt_R8  },
    { 1, "tanl"                   , "tanl"                          , 2, comvt_BAD },
    { 1, "tempdir$"               , ""                              , 0, comvt_BAD },
    { 1, "tempfilename$"          , ""                              , 0, comvt_BAD },
    { 1, "template"               , "template"                      , 2, comvt_BAD },
    { 1, "textmode"               , ""                              , 0, comvt_BAD },
    { 1, "then"                   , ""                              , 0, comvt_BAD },
    { 1, "this"                   , "this"                          , 3, comvt_BAD },
    { 1, "throw"                  , "throw"                         , 3, comvt_BAD },
    { 1, "time$"                  , ""                              , 0, comvt_BAD },
    { 1, "timer"                  , ""                              , 0, comvt_R4  },
    { 1, "to"                     , "to"                            , 0, comvt_BAD },
    { 1, "trim$"                  , ""                              , 0, comvt_BAD },
    { 1, "true"                   , ""                              , 0, comvt_BAD },
    { 1, "try"                    , "try"                           , 3, comvt_BAD },
    { 1, "type"                   , "type"                          , 2, comvt_BAD },
    { 1, "typeid"                 , "typeid$"                       , 3, comvt_BAD },
    { 1, "typename"               , ""                              , 1, comvt_BAD },
    { 1, "ubound"                 , ""                              , 0, comvt_BAD },
    { 1, "ubound_d"               , ""                              , 0, comvt_BAD },
    { 1, "ubound_s"               , ""                              , 0, comvt_BAD },
    { 1, "ubyte"                  , "unsigned char"                 , 2, comvt_BAD },
    { 3, "ucase$"                 , ""                              , 0, comvt_BAD },
    { 1, "uchar"                  , "UCHAR"                         , 2, comvt_BAD },
    { 1, "uint"                   , "UINT"                          , 2, comvt_BAD },
    { 1, "uint64"                 , "UINT64"                        , 2, comvt_BAD },
    { 1, "ulong"                  , "ULONG"                         , 2, comvt_BAD },
    { 1, "ulonglong"              , "ULONGLONG"                     , 2, comvt_BAD },
    { 1, "uncom"                  , "UNCOM"                         , 0, comvt_BAD },
    { 1, "union"                  , "union"                         , 2, comvt_BAD },
    { 1, "until"                  , ""                              , 0, comvt_BAD },
    { 1, "unwrap$"                , ""                              , 0, comvt_BAD },
    { 1, "ushort"                 , "USHORT"                        , 2, comvt_BAD },
    { 1, "using"                  , "using"                         , 3, comvt_BAD },
    { 1, "using$"                 , ""                              , 0, comvt_BAD },
    { 1, "utf8tochr"              , ""                              , 0, comvt_BAD },
    { 1, "val"                    , ""                              , 0, comvt_R8  },
    { 1, "vall"                   , ""                              , 0, comvt_BAD },
    { 1, "variant"                , "VARIANT"                       , 2, comvt_BAD },
    { 1, "variant2str"            , ""                              , 0, comvt_BAD },
    { 1, "vbs_addcode"            , ""                              , 0, comvt_BAD },
    { 1, "vbs_error$"             , ""                              , 0, comvt_BAD },
    { 1, "vbs_eval_num"           , ""                              , 0, comvt_BAD },
    { 1, "vbs_eval_num#"          , ""                              , 0, comvt_BAD },
    { 1, "vbs_eval_str$"          , ""                              , 0, comvt_BAD },
    { 1, "vbs_reset"              , ""                              , 0, comvt_BAD },
    { 1, "vbs_run_script"         , ""                              , 0, comvt_BAD },
    { 1, "vbs_start"              , ""                              , 0, comvt_BAD },
    { 1, "vbs_stop"               , ""                              , 0, comvt_BAD },
    { 1, "vchr$"                  , ""                              , 0, comvt_BAD },
    { 1, "vector"                 , ""                              , 0, comvt_BAD },
    { 1, "verify"                 , ""                              , 0, comvt_BAD },
    { 1, "virtual"                , ""                              , 1, comvt_BAD },
    { 1, "vt$"                    , ""                              , 0, comvt_BAD },
    { 1, "wchar"                  , "WCHAR"                         , 2, comvt_BAD },
    { 1, "wend"                   , "wend"                          , 2, comvt_BAD },
    { 1, "while"                  , ""                              , 0, comvt_BAD },
    { 1, "widetoansi$"            , ""                              , 0, comvt_BAD },
    { 1, "winbool"                , "winbool"                       , 2, comvt_BAD },
    { 1, "windir$"                , ""                              , 0, comvt_BAD },
    { 1, "winmain"                , ""                              , 0, comvt_BAD },
    { 1, "with"                   , ""                              , 0, comvt_BAD },
    { 1, "wndproc"                , ""                              , 0, comvt_BAD },
    { 1, "word"                   , "WORD"                          , 2, comvt_BAD },
    { 1, "wrap$"                  , ""                              , 0, comvt_BAD },
    { 1, "write"                  , "write"                         , 2, comvt_BAD },
    { 1, "wstring"                , "PWSTR"                         , 2, comvt_BAD },   ' 827 MrBcx -- changed from BSTR
    { 3, "xor"                    , ""                              , 0, comvt_BAD },
    { 1, "zzzz"                   , "zzzz"                          , 0, comvt_BAD }
END SET

'*************************************************************************
'                              CODE BEGINS
'*************************************************************************

MACRO cMaxSrcLen = 0x100000    ' = 1 megabyte

FUNCTION MAIN(ARGC AS INTEGER, ARGV[] AS PCHAR)
    GLOBAL FuncStrNames$ * cMaxSrcLen
    GLOBAL FuncSglNames$ * cMaxSrcLen
    GLOBAL FuncDblNames$ * cMaxSrcLen
    GLOBAL CurLine$      * cMaxSrcLen
    GLOBAL gTmpStr$      * cMaxSrcLen
    GLOBAL Src$          * cMaxSrcLen
    GLOBAL AbortSrc$     * cMaxSrcLen
    GLOBAL WarnMsg$      * 32767
    GLOBAL RmLibs$       * 32767          ' List of libraries to remove
    GLOBAL Version$
    GLOBAL Copyright$
    GLOBAL IF_Stmt_Buffer$ * cMaxSrcLen   '  "??" operator support
    '*******************************************************
    Version$ += SPC$ + ENC$(ISODATE$, 40, 41)
    REPLACE "-" WITH "/" IN Version$
    '*******************************************************
    Copyright$ = "BCX BASIC to C/C++ Translator (c) 1999-" + RIGHT$(DATE$, 4) + " by Kevin Diggins"
    '*******************************************************
    CALL InitReservedWordsLookup
    '*******************************************************
    WarningFlag            =  FALSE
    DebugModeOff           =  TRUE
    '*******************************************************
    CmdLineConst$          =  ""
    CmdLineFileOut$        =  ""
    ExitNdx                =  0
    Gen_Header             =  FALSE
    HFile$                 =  ""
    InMain                 =  TRUE
    InNameSpace            =  0
    InsertComments         =  FALSE
    NoRT                   =  FALSE
    OkayToSend             =  TRUE
    OptimizerEnabled       =  TRUE
    OptimizerFirstSetting  =  TRUE
    Project_List$          =  ""
    Project_Main$          =  ""
    ProtoCnt               =  0        ' Prototypes counter
    Quiet                  =  FALSE
    StartNdx               =  0
    TestState              =  FALSE
    TranslateSlash         =  TRUE     ' Change "\" to "\\"
    Use_ExitCode           =  FALSE
    Use_LeanAndMean        =  FALSE
    Use_Project            =  FALSE
    Use_SingleFile         =  TRUE
    Use_StartupCode        =  FALSE
    WinHeaders             =  TRUE     ' Include Win specific headers (*.h)
    '**************************************************************************
    '                     Some helper / formatting strings
    '**************************************************************************
    GLOBAL BKSLASH1$ : BKSLASH1$ = CHR$(92)                         ' \
    GLOBAL BKSLASH2$ : BKSLASH2$ = CHR$(92, 92)                     ' \\
    GLOBAL BKSLASH4$ : BKSLASH4$ = CHR$(92, 92, 92, 92)             ' \\\\

    GLOBAL DQUOT$    : DQUOT$    = CHR$(34, 34, 34)                 ' """
    GLOBAL DDQUOT$   : DDQUOT$   = CHR$(34, 34, 34, 34)             ' """"
    '**************************************************************************
    PPFlag = FALSE           ' Initialize User-Defined PreProcessor
    PPProc = NULL
    PPDLL_HANDLE = NULL
    '**************************************************************************
    IF INSTR(COMMAND$, "-v") OR INSTR(COMMAND$, "-V") THEN
        PRINT
        PRINT Copyright$
        CALL Display_Version_and_Compiler
        END
    END IF
    '**************************************************************************
    '      Checks whether Bc.exe was started in Explorer or File Manager.
    '**************************************************************************
    IF CURSORX = 1 AND CURSORY = 1 AND ISNULL(COMMAND$) THEN
        HIDE (CONWIN)
        Copyright$ += CRLF$ + CRLF$ + CPAD$("Version " + VERSION$, 100)
        MSGBOX (SPACE$(10) + Copyright$ + CRLF$ + CRLF$ + SPACE$(12) + LTRIM$(Compiler_Used$()))
        END
    END IF
    '**************************************************************************
    IF ISNULL(COMMAND$) THEN
        PRINT
        PRINT Copyright$
        CALL  Display_Version_and_Compiler
        PRINT
        PRINT " Usage: BC infile [.bas] [options]"
        PRINT " [-b]   Build using user-defined bat file .. ex -b:c:\\bat\\pw.bat"
        PRINT " [-cpp] Generate C++ compatible code with .cpp extension"
        PRINT " [-d]   DEFINE a constant ... ex. BC MyFile -D:MyConst[=SomeValue]"
        PRINT " [-e]   Write ERRORS to BCX.ERR file"
        PRINT " [-f]   Output FILENAME... ex. BC MyFile -f:C:\\MyFiles\\MyFile.c"
        PRINT " [-i]   Send Warnings and Errors to INFOBOX"
        PRINT " [-k]   KILL the generated BCX generated 'C' file"
        PRINT " [-m]   Enable eMbedded BCX code in the C translation"
        PRINT " [-n]   Enable NO RUNTIME Code Generation"
        PRINT " [-o]   OUTPUT a copy of the generated C file to STDOUT"
        PRINT " [-q]   QUIET - No output to screen during translation"
        PRINT " [-r]   Update BCX Path variable in the Windows REGISTRY"
        PRINT " [-s]   Show STATUS of translation by line number"
        PRINT " [-u]   Turn UNICODE Support ON"
        PRINT " [-v]   Show BCX version and build information"
        PRINT " [-w]   Enable BCX WARNINGS during translation and all compiler warnings."
        PRINT " [-x]   EXCLUDE Win32 Headers from the resulting C file"
        PRINT " [-z]   ZAP (remove DEFAULT headers and libraries from the resulting C file"

        CALL FREEGLOBALS
        END                '     <<<- Nothing to translate, so we END
    END IF
    '****************************************************************************************************
    IF COMMAND$ ?? "-r" THEN
        CREATEREGSTRING (HKEY_LOCAL_MACHINE, "Software\\Bcx-32\\Bcx\\Settings", "Path", APPEXEPATH$)
        CREATEREGSTRING (HKEY_CURRENT_USER, "Software\\Bcx-32\\Bcx\\Settings", "Path", APPEXEPATH$)
        PRINT "      BCX Path set to ", BCXPATH$
        END
    END IF
    '****************************************************************************************************
    '                       Detect and setup any other command line switches
    '****************************************************************************************************

    FOR INT i = 2 TO ARGC-1
        gTmpStr$ = LCASE$(ARGV$[i])

        IF INSTR(gTmpStr$, "-b") THEN
            IF cMaxOnExit = XitCount THEN
                CALL Abort("Maximum $OnExit exceeded.")
            END IF
            INCR XitCount
            Xit$[XitCount]= MID$(ARGV$[i], 4) + SPC$ + ENC$(EXTRACT$(COMMAND$(1), "."))
        END IF

        IF gTmpStr$ = "-cpp" THEN UseCpp      = TRUE
        IF gTmpStr$ = "-c"   THEN UseCpp      = TRUE
        IF gTmpStr$ = "-e"   THEN ErrFile     = TRUE
        IF gTmpStr$ = "-h"   THEN Gen_Header  = TRUE
        IF gTmpStr$ = "-i"   THEN InfoBoxWarn = TRUE
        IF gTmpStr$ = "-q"   THEN Quiet       = TRUE
        IF gTmpStr$ = "-k"   THEN KillCFile   = TRUE
        IF gTmpStr$ = "-m"   THEN SrcFlag     = TRUE
        IF gTmpStr$ = "-n"   THEN NoRT        = TRUE
        IF gTmpStr$ = "-o"   THEN ReDirect    = TRUE
        IF gTmpStr$ = "-s"   THEN ShowStatus  = TRUE
        IF gTmpStr$ = "-u"   THEN Use_UNICODE = TRUE
        IF gTmpStr$ = "-z"   THEN ZapFlag     = TRUE
        IF gTmpStr$ = "-w"   THEN TestState   = TRUE : WarningFlag = TRUE
        IF gTmpStr$ = "-x"   THEN WinHeaders  = FALSE

        IF iMatchLft(gTmpStr$, "-f:") THEN CmdLineFileOut$ = MID$(ARGV$[i], 4)
        IF iMatchLft(gTmpStr$, "-d:") THEN CmdLineConst$  += MID$(ARGV$[i], 4) + CHR$(1)
    NEXT

    '****************************************************************************
    '                           [ Announce Program ]
    '****************************************************************************

    IF ShowStatus THEN CLS

    IF NOT Quiet THEN
        IF BCX_COLORS THEN PUSHCOLORS
        IF BCX_COLORS THEN COLOR 11, 0
        PRINT
        PRINT Copyright$
        CALL Display_Version_and_Compiler
        IF BCX_COLORS THEN POPCOLORS
    END IF

    '****************************************************************************

    IF INCHR(COMMAND$(1), ".") THEN
        Cmd$ = COMMAND$(1)                          ' Allow ANY extension
    ELSE
        Cmd$ = EXTRACT$(COMMAND$(1), ".") + ".bas"  ' Assume implicit .bas
    END IF

    Cmd$ = FINDFIRST$(Cmd$)                         ' Retain the spelling

    IF INCHR(Cmd$, "*") OR INCHR(Cmd$, "?") THEN Cmd$ = FINDFIRST$(Cmd$)

    FileIn$ = Cmd$

    IF ISNULL(CmdLineFileOut$) THEN
        FileOut$ = LEFT$(Cmd$, INSTRREV(Cmd$, ".", 0)-1) + ".out"
    ELSE
        FileOut$ = CmdLineFileOut$
    END IF

    FileErr$ = LEFT$(Cmd$, INSTRREV(Cmd$, ".", 0)-1) + ".err"

    IF EXIST(FileErr$) THEN
        SHELL "DEL " + FileErr$
    END IF

    '*******************************************************

    IF DebugModeOff THEN
        gTmpStr$ = TEMPDIR$
        cppFile$ = TEMPFILENAME$(gTmpStr$, "ccode")
        prcFile$ = TEMPFILENAME$(gTmpStr$, "prc")
        udtFile$ = TEMPFILENAME$(gTmpStr$, "udt")
        datFile$ = TEMPFILENAME$(gTmpStr$, "dat")
        UsrFile$ = TEMPFILENAME$(gTmpStr$, "cst")     ' User's MACRO's
        SysFile$ = TEMPFILENAME$(gTmpStr$, "syscst")  ' System MACRO's
        ovrFile$ = TEMPFILENAME$(gTmpStr$, "ovr")
        hdrFile$ = TEMPFILENAME$(gTmpStr$, "hdr")
        setFile$ = TEMPFILENAME$(gTmpStr$, "set")
        resFile$ = TEMPFILENAME$(gTmpStr$, "res")
        enuFile$ = TEMPFILENAME$(gTmpStr$, "enu")
        defFile$ = TEMPFILENAME$(gTmpStr$, "def")
    ELSE
        gTmpStr$ = APPEXEPATH$
        cppFile$ = gTmpStr$ + "ccode_debug.txt"
        prcFile$ = gTmpStr$ + "prc_debug.txt"
        udtFile$ = gTmpStr$ + "udt_debug.txt"
        datFile$ = gTmpStr$ + "dat_debug.txt"
        UsrFile$ = gTmpStr$ + "cst_debug.txt"
        SysFile$ = gTmpStr$ + "syscst_debug.txt"
        ovrFile$ = gTmpStr$ + "ovr_debug.txt"
        hdrFile$ = gTmpStr$ + "hdr_debug.txt"
        setFile$ = gTmpStr$ + "set_debug.txt"
        resFile$ = gTmpStr$ + "res_debug.txt"
        enuFile$ = gTmpStr$ + "enu_debug.txt"
        defFile$ = gTmpStr$ + "def_debug.txt"
    END IF
    '**************************************************************************
    ' Find and Scan Main File and all $INCLUDED files        by MrBcx in 8.1.2
    '**************************************************************************
    CALL FindIncludeFiles (FileIn$)

    FOR INT j = 0 TO FilesFound
        CALL ScanFunctionNames (IncludeFileNames$[j]) '[0] is always FileIn$
    NEXT
    '**************************************************************************
    OPEN FileIn$  FOR INPUT  AS SourceFile
    OPEN FileOut$ FOR OUTPUT AS FP2        ' <<<<<<<<   THE FINAL C/C++ FILE
    '**************************************************************************
    FP_WRITE = FP2          ' FP_WRITE = FP3 when in a SUB or FUNCTION
    '**************************************************************************

    OPEN cppFile$ FOR OUTPUT AS FP_CCODE   ' Temp file FOR CCODE
    OPEN SysFile$ FOR OUTPUT AS FP_SYSCST  ' Temp File FOR SYSTEM CONSTs
    OPEN prcFile$ FOR OUTPUT AS FP3        ' Temp File FOR User's Functions
    OPEN udtFile$ FOR OUTPUT AS FP_UDT     ' Temp File FOR User's Def Types
    OPEN datFile$ FOR OUTPUT AS FP_DAT     ' Temp File FOR User's Data statements
    OPEN UsrFile$ FOR OUTPUT AS FP_CST     ' Temp File FOR User's MACRO
    OPEN hdrFile$ FOR OUTPUT AS FP_HDR     ' Temp File FOR User's .h files
    OPEN resFile$ FOR OUTPUT AS FP_RES     ' Temp File FOR User's .rc files
    OPEN enuFile$ FOR OUTPUT AS FP_ENU     ' Temp File FOR User's GLOBAL ENUMs
    OPEN ovrFile$ FOR OUTPUT AS FP_OVR     ' Temp File FOR User's OVERLOADED subs & functions
    OPEN setFile$ FOR OUTPUT AS FP_SET     ' Temp File FOR User's SET Vars
    OPEN defFile$ FOR OUTPUT AS FP_DEF     ' Temp File FOR User's $DEFINE statements

    '**************************************************************************
    CALL ExportStringConst
    FileNdx = 1
    FileNames$[FileNdx] = FileIn$          ' Store the current module filename
    LineNum[FileNdx] = 0
    '**************************************************************************
    IF NoRT = TRUE THEN CALL EnableProject

    CALL BeginMain
    CALL ClearIfThenStacks

    IF UseCpp = TRUE THEN
        DIM RAW iTmp
        Docpp("", ADDRESSOF(iTmp))    ' Treats -c switch as $CPP directive
    END IF

    '*********************************************************************
    '                            The Main LOOP
    '*********************************************************************
    ReadSrcLine:
    '*********************************************************************
    DO WHILE NOT EOF(SourceFile) OR SplitCnt
        IF SplitCnt = 0 THEN             ' Process separated lines before
            LINE INPUT SourceFile, Src$  ' getting next line from file.
            INCR LineNum[FileNdx]
            '*************************************************************
            Src$ = LTRIM$(Src$)
            IF ISNULL(Src$) THEN ITERATE
            '*************************************************************
            '            Change BASIC remarks to C/C++ remarks
            '*************************************************************
            IF InFunction THEN          ' Only output comments that exist
                IF InsertComments THEN  ' in a Sub, Function, Main/Winmain
                    IF *Src$ = c_SglQt THEN
                        FPRINT FP_WRITE, Scoot$, "//", (PCHAR)(Src+1)
                        Src$ = ""
                        ITERATE
                    END IF
                    IF iMatchLft(Src$, "rem ") THEN
                        FPRINT FP_WRITE, Scoot$, "//", (PCHAR)(Src+3)
                        Src$ = ""
                        ITERATE
                    END IF
                END IF
            END IF
            '***************************************************
            CALL StripCode(Src$)                                    ' Remove spaces, tabs, comments
            IF ISNULL(Src$) THEN ITERATE                            ' Skip over blank lines
            IF JoinLines(Src$) THEN ITERATE                         ' Join continuation lines " _"
            IF INCHR(Src$, "[") THEN CALL BracketHandler(Src$, 0)   ' Fix Brackets
            '***************************************************    '
            IF PPFlag THEN                                          ' PreProcess the line  ($PP detected)
                GLOBAL ppret AS LONG
                ppret = CAST(LONG, PPProc(Src$))                    ' Error in $PP returns error message in Src$
                IF ppret = 0 THEN
                    CALL Abort(Src$)
                END IF
            END IF

            '***************************************************
            IF ISFALSE MacroCheck() THEN
                IF SplitLines(Src$) THEN                            ' Split statements separated by
                    Src$ = LTRIM$(SplitStk$[++SplitCur])            ' colons and single line if/then
                END IF
            END IF
        ELSE
            Src$ = LTRIM$(SplitStk$[++SplitCur])
        END IF


        '*******************************************************
        CALL Early_Transforms  ' Special Replacement heuristics     ' 826 MrBcx relocated call to here
        '*******************************************************    ' to remove the colon "+=" limitation

        IF SplitCur = SplitCnt THEN SplitCur = SplitCnt = 0

        '*********************************************************************
        ' After translation, tokens displayed when an error occurs may
        ' not resemble the original tokens that are copied to AbortSrc$.
        '*********************************************************************

        AbortSrc$ = Src$

        '*********************************************************************
        ' No testing on inline c
        ' If you're using inline c then you should know what you are doing
        '*********************************************************************
        IF *Src$ = ASC("!") THEN   ' Test for inline C
            IF InFunction OR InClass OR InNameSpace OR InTypeDef THEN
                FPRINT FP_WRITE, MID$(Src$, 2)
            ELSE
                IF InMain THEN
                    FPRINT FP2, MID$(Src$, 2)
                ELSE
                    FPRINT FP_CST, MID$(Src$, 2)
                END IF
            END IF
            ITERATE
        END IF

        CALL VerifyMatchedPairs

        IF (TraceFlag AND InFunction) OR (SrcFlag) OR (ShowStatus) THEN
            CALL ActivityFlags
        END IF

        IF ISNULL(Src$) THEN ITERATE


        '/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\
        CALL Translate              '  Okay, let's translate!
        '\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/


        '**************************************************************
        ' 828 MrBcx - Enables automatic dynamic array cleanup
        '**************************************************************
        IF UseCpp = FALSE THEN
            IF DoInjection THEN
                PassOne = TRUE
                Inject (Injection$)
                PassOne = TRUE
            END IF
            DoInjection = FALSE
            Injection$ = ""
        END IF
        '**************************************************************
        ' The following is needed for the BEGIN MODAL DIALOG procs
        '**************************************************************
        IF Inject_Local_Bcx_RetVal = TRUE THEN
            PassOne = TRUE
            Inject("LOCAL Bcx_RetVal AS INTEGER")
            PassOne = TRUE
            Inject_Local_Bcx_RetVal = FALSE
        END IF
        '**************************************************************
    LOOP

    FLUSH(FP_WRITE)            '*************************************
    IF FPtrNdx THEN            '  Pop out the $Include File Handles
        CALL PopFileIO         '  and close them in sequence until
        GOTO ReadSrcLine       '  we end up back in the main file
    END IF                     '*************************************

    '****************************************************************
    '        END OF MAIN LOOP -- All Source code has been read
    '****************************************************************
    '        Everything below must not process more than once
    '****************************************************************

    CALL Emit_CompilerDefines

    IF TestForBcxIni = FALSE THEN
        TestForBcxIni = TRUE
        szFile$ = CURDIR$ + "\\bcx.ini"

        IF NOT EXIST(szFile$) THEN
            szFile$ = APPEXEPATH$ + "bcx.ini"
        END IF

        IF EXIST(szFile$) THEN
            CALL PushFileIO
            OPEN szFile$ FOR INPUT AS SourceFile

            IF FileNdx = cMaxFiles-1 THEN
                CALL Abort("Maximum Include Files exceeded.")
            END IF

            FileNames$[++FileNdx] = szFile$
            LineNum[FileNdx] = 0
            GOTO ReadSrcLine
        END IF
    END IF

    '***************************************************************
    '      Check for unbalanced LOOPS and IF-THEN errors
    '***************************************************************

    IF LoopTypeCnt THEN
        CALL LoopErrorMsg
    END IF

    IF Indent THEN
        PRINT REPEAT$(80, "_")
        PRINT "Possible missing END IF before END of program"
        PRINT REPEAT$(80, "_")
    END IF

    '***************************************************************

    IF Use_VBS THEN
        CALL Emit_VBScript_Support     ' Writes to FP_HDR
    END IF

    IF NO_LIBS = FALSE THEN
        IF ZapFlag = FALSE THEN
            IF Use_Project = FALSE THEN
                DIM STATIC Pass_1
                IF Pass_1 = FALSE THEN
                    INCR Pass_1
                    AddLibrary("kernel32.lib")
                    AddLibrary("user32.lib")
                    AddLibrary("gdi32.lib")
                    AddLibrary("comctl32.lib")
                    AddLibrary("advapi32.lib")
                    AddLibrary("winspool.lib")
                    AddLibrary("shell32.lib")
                    AddLibrary("Msimg32.lib")
                    AddLibrary("ole32.lib")
                    AddLibrary("oleaut32.lib")
                    AddLibrary("uuid.lib")
                    AddLibrary("odbc32.lib")
                    AddLibrary("odbccp32.lib")
                    AddLibrary("winmm.lib")
                    AddLibrary("comdlg32.lib")
                    AddLibrary("imagehlp.lib")
                    AddLibrary("version.lib")
                    AddLibrary("wininet.lib")
                    AddLibrary("urlmon.lib")
                END IF
            END IF ' Use_Project = FALSE
        END IF ' ZapFlag
    END IF ' NO_LIBS

    '***************************************************************
    IF Use_GenFree AND GlobalDynaCnt THEN
        CALL MakeFreeGlobals               ' Writes to FP_WRITE
    END IF

    CALL Emit_Libs                         ' Writes to FP_HDR
    CALL ExportInternalConst               ' Writes to FP_CST
    CALL Emit_Epilog                       ' Writes to FP_WRITE
    CALL CloseAll                          ' Close all files
    CALL AssembleParts                     ' Build final C/C++
    CALL CreateUserResourceFile            ' Build User's .RC file

    '***************************************************************
    IF ShowStatus THEN CLS
    '***************************************************************

    IF NOT Quiet THEN

        INCR LinesRead, LineNum[1]
        Elapsed! = (FLOAT)clock()/(FLOAT)CLOCKS_PER_SEC

        IF BCX_COLORS THEN COLOR 11, 0
        PRINT "[Lines In:"             ; ' Suppress CRLF
        IF BCX_COLORS THEN COLOR 14, 0
        PRINT   LinesRead              ; ' Suppress CRLF
        IF BCX_COLORS THEN COLOR 11, 0
        PRINT  "] [Lines Out:"         ; ' Suppress CRLF
        IF BCX_COLORS THEN COLOR 14, 0
        PRINT    LinesWritten          ; ' Suppress CRLF
        IF BCX_COLORS THEN COLOR 11, 0
        PRINT  "] "                    ; ' Suppress CRLF
        PRINT "[Statements:"           ; ' Suppress CRLF
        IF BCX_COLORS THEN COLOR 14, 0
        PRINT  Statements              ; ' Suppress CRLF
        IF BCX_COLORS THEN COLOR 11, 0
        PRINT "] [Time: "              ; ' Suppress CRLF
        IF BCX_COLORS THEN COLOR 14, 0
        PRINT USING$("#.##", Elapsed!);  ' Suppress CRLF
        IF BCX_COLORS THEN COLOR 11, 0
        PRINT " Sec's]"

        LOCAL Tmp$
        Tmp$  = "BCX translated [" + REMOVE$(MCASE$(FileIn$), SPC$)
        Tmp$ += "] to ["   + REMOVE$(MCASE$(FileOut$), SPC$) + "]"

        IF UseCpp THEN
            Tmp$ += " for a C++ Compiler"
        ELSE
            Tmp$ += " for a C Compiler"
        END IF

        IF Use_Project THEN
            Tmp$ += " with No Runtime"
        END IF

        IF BCX_COLORS THEN COLOR 10, 0
        PRINT Tmp$
        PRINT
        IF BCX_COLORS THEN POPCOLORS
    END IF

    IF Use_Project AND Gen_Header THEN
        CALL Project_Support
    END IF

    IF WarnMsg$ <> "" THEN
        IF InfoBoxWarn THEN
            INFOBOX("Warnings! :" , WarnMsg$, _
            GetSystemMetrics(SM_CXSCREEN)/4, _
            GetSystemMetrics(SM_CYSCREEN)/4)
        ELSE
            PRINT "Warnings! :", CRLF$, WarnMsg$
        END IF
    END IF

    '**********************************************
    ' It's time to make some final tweaks to the
    ' C/C++ output file before ending    - MrBcx
    '**********************************************
    CALL Final_Transforms                             ' This revised order of calls
    CALL PostProcess                                  ' fixes 0xf bug in "::" lines
    '*********************************************************************************
    IF KillCFile THEN KILL FileOut$                   ' -kill switch?
    CALL KillFiles
    CALL FREEGLOBALS
    '*********************************************************************************
    RETURN  EXIT_SUCCESS
END FUNCTION  ' Function main



'*************************************************************************************
'*                                                                                   *
'*                                                                                   *
'*                                                                                   *
'*                                                                                   *
'*                        End of BCX Translator Main Function                        *
'*                                                                                   *
'*                                                                                   *
'*                                                                                   *
'*                                                                                   *
'*************************************************************************************



SUB Early_Transforms
    '*********************************************************************************
    ' 828 MrBcx - Pre-process user functions, enables LOCAL dynamic array cleanup
    ' Only for plain c mode -- does not alter code that only compiles in c++ mode
    '*********************************************************************************


    IF UseCpp = FALSE THEN
        IF UCASE$(LEFT$(Src$, 8)) = "FUNCTION" OR UCASE$(LEFT$(Src$, 10)) = "OVERLOADED" OR UCASE$(LEFT$(Src$, 8)) = "CALLBACK" THEN
            IF NOT InTypeDef AND NOT InCppTypeDef THEN
                GLOBAL DoInjection, Injection$

                DoInjection = FALSE
                Injection$ = ""
                Src$ = TRIM$(Src$)

                CALL ScanFuncNamesTypes(Src$)
                IF LEN(FunctionNameType.FunctionName$) AND UCASE$(FunctionNameType.FunctionType$) <> "STRING" THEN
                    DoInjection = TRUE
                    Injection$ = "DIM Bcx_RetVal AS "  ' <<<-- this is intentional
                    CONCAT(Injection$, FunctionNameType.FunctionType$)
                END IF
            END IF
        END IF
    END IF

    '*********************************************************************************
    '                  Detect and process += concat operations first
    '*********************************************************************************

    IF iMatchNQ(Src$, "=+") AND NOT iMatchNQ(Src$, "=++") THEN Abort("'=+' looks like a typo.")

    IF iMatchNQ(Src$, "+=") THEN
        DIM AS STRING LeftSide, RightSide
        DIM AS INT i, j

        FastLexer(Src$, SPC$, "=&()[]{}',+-*/<>?;.|:^")

        IF Stk$[1] = "!" THEN EXIT SUB  ' Skip over inline C/C++

        IF Stk$[1] ?? "if" THEN
            FOR i = 2 TO Ndx
                IF Stk$[i] ?? "then" THEN EXIT FOR
            NEXT
            FOR j = 1 TO i
                LeftSide += SPC$ + Stk$[j]
            NEXT
            FOR j = i+1 TO Ndx
                RightSide = RightSide + Stk$[j]
            NEXT
            FastLexer(RightSide, SPC$, "=&()[]{}',+-*/<>?;.|:^")
        END IF

        CALL TransformStringConcat

        Src$ = SPC$
        FOR i = 1 TO Ndx
            Src$ += Stk$[i] + SPC$
        NEXT

        IF LeftSide > "" THEN Src$ = TRIM$(LeftSide + SPC$ + Src$)
    END IF

    Src$ = SPC$ + Src$

    '*********************************************************************************
    '                             Detect Cpp keywords
    '*********************************************************************************

    IF UseCpp = FALSE THEN

        IF iMatchNQ(Src$, "<iostream>")  THEN UseCpp = TRUE
        IF iMatchNQ(Src$, " delete ")    THEN UseCpp = TRUE
        IF iMatchNQ(Src$, " std::cout ") THEN UseCpp = TRUE
        IF iMatchNQ(Src$, " std::cin ")  THEN UseCpp = TRUE
        IF iMatchNQ(Src$, " class ")     THEN UseCpp = TRUE
        IF iMatchNQ(Src$, " interface ") THEN UseCpp = TRUE

        IF iMatchNQ(Src$, " inline ")    THEN
            IF LIKE (Src$, "*inline*function*") OR LIKE (Src$, "*inline*sub*") THEN UseCpp = TRUE
        END IF

        IF LIKE (Src$, "*HANDLE_MSG*") THEN   ' 8.1.2 Added by MrBcx ( this might cause problems )
            UseCpp = FALSE
            UseInLine = FALSE
        END IF

        IF iMatchNQ(Src$, " namespace ") THEN UseCpp = TRUE
        IF iMatchNQ(Src$, " template ")  THEN UseCpp = TRUE
        IF iMatchNQ(Src$, " pptype ")    THEN UseCpp = TRUE
        IF iMatchNQ(Src$, " operator ")  THEN
            IF LIKE(Src$, "*function*operator*") THEN UseCpp = TRUE
        END IF
        IF NOT iMatchNQ(Src$, " binary ") THEN
            IF iMatchNQ(Src$, " new ")    THEN UseCpp = TRUE
        END IF
    END IF
    '*********************************************************************************
    '          Transform METHOD, PROPERTY, PROPSET, and PROPGET -  MrBcx
    '*********************************************************************************
    IF UseCpp = TRUE THEN
        IF iMatchNQ(Src$, "propget")  THEN Src$ = iReplace_NQ$ (Src$, "propget", "FUNCTION")
        IF iMatchNQ(Src$, "propset")  THEN Src$ = iReplace_NQ$ (Src$, "propset", "SUB")
        IF iMatchNQ(Src$, "property") THEN
            DIM szTmp$
            szTmp$ = SPC$ + Src$ + SPC$
            IF IINSTR(szTmp$, " property ") THEN
                Src$ = iReplace_NQ$ (Src$, "property", "SUB")
            END IF
        END IF
        IF iMatchNQ(Src$, "method") THEN
            DIM szTmp$
            szTmp$ = SPC$ + Src$ + SPC$
            IF IINSTR(szTmp$, " method ") OR IINSTR(szTmp$, " method=") THEN
                Src$ = iReplace_NQ$ (Src$, "method", "FUNCTION")
            END IF
        END IF
    END IF
    '*********************************************************************************
    '                      Enable range-based FOR-NEXT loops
    '*********************************************************************************
    IF UseCpp = TRUE THEN
        IF iMatchNQ(Src$, "rbfor") OR iMatchNQ(Src$, "rbnext") OR iMatchNQ(Src$, "rbexit") THEN
            CALL RBForTransform
        END IF
    END IF
    '*********************************************************************************
    IF iMatchNQ(Src$, "band") THEN
        IF LIKE(Src$, "*select*case*band*") THEN
            DIM szTmp$
            szTmp$ = TRIM$(STRIM$(Src$))
            IF LIKE(szTmp$, "select case band*") THEN
                Src$ = iReplace_NQ$ (Src$, " band ", SPC$)
                Src$ += SPC$ + "&&"
            END IF
        END IF
    END IF
    '*********************************************************************************
    '             Improve processing of "DIM AS CONST" brackets -  MrBcx
    '*********************************************************************************
    IF iMatchNQ (Src$, "const") THEN
        IF LIKE(Src$, "*dim*as*const*") THEN
            FastLexer(Src$, SPC$, "=&()[]{}',+-*/<>?;.|:^")
            IF Stk$[1] ?? "dim" AND _
                Stk$[2] ?? "as"  AND _
                Stk$[3] ?? "const" THEN
                REPLACE " [" WITH "[" IN Src$
                REPLACE " ]" WITH "]" IN Src$
            END IF
        END IF
    END IF
    '*********************************************************************************
    '          MrBcx 817 - Added support for CONST  [type] VarName = value
    '                      to create "DIM AS CONST" [type] VarName = value
    '*********************************************************************************
    IF iMatchNQ (Src$, "const") THEN
        FastLexer(Src$, SPC$, "=&()[]{}',+-*/<>?;.|:^")
        IF Stk$[1] ?? "const" THEN

            FOR_EACH(i, ConstTypes$)
                IF Stk$[2] ?? ConstTypes$[i] THEN ' ?? is a case-insensitve comparison
                    Src$ = "DIM AS " + Src$
                    EXIT_EACH
                END IF
            NEXT_EACH

        END IF
    END IF
    '*********************************************************************************
    '                Enable traditional file i/o statements
    '    Converts INPUT #1 -to- FINPUT #1 and PRINT #1 -to- FPRINT #1
    '                                MrBcx
    '*********************************************************************************
    IF iMatchTwoNQ (Src$, "input ", " #") = TRUE  THEN
        IF iMatchNQ (Src$, "line ")       = FALSE THEN
            IF iMatchNQ (Src$, "open ")   = FALSE THEN
                IF iMatchNQ (Src$, "as ") = FALSE THEN
                    Src$ = iReplace_NQ$ (Src$, " input ", " finput ")
                END IF
            END IF
        END IF
    END IF

    IF iMatchTwoNQ(Src$, "print ", " #") = TRUE  THEN
        IF iMatchNQ(Src$, "using$")  = FALSE THEN      ' 826 MrBcx - added new filter
            IF iMatchNQ(Src$, "lprint")  = FALSE THEN
                Src$ = iReplace_NQ$ (Src$, " print ", " fprint ")
            END IF
        END IF
    END IF

    IF iMatchNQ(Src$, "print") THEN
        FastLexer(Src$, SPC$, "=&()[]{}',+-*/<>?;.|:^")
        FOR INT i = 1 TO Ndx
            IF Stk$[i] ?? "print" THEN
                IF CheckType(Stk$[i+1]) = vt_FILEPTR THEN
                    Src$ = iReplace_NQ$ (Src$, " print ", " fprint ")
                END IF
            END IF
        NEXT
    END IF
    '*********************************************************************************
    IF iMatchNQ(Src$, " comset ") THEN
        IREPLACE " comset " WITH " SET " IN Src$
    END IF
    '*********************************************************************************
    IF iMatchNQ(Src$, "asciiz") THEN
        IREPLACE "asciiz" WITH "string" IN Src$
    END IF
    '*********************************************************************************
    IF INSTR(Src$, DDQUOT$) THEN                   '  """"
        Use_DDQ = TRUE
        REPLACE DDQUOT$ WITH " DDQ$ " IN Src$
    END IF

    IF INSTR(Src$, DQUOT$) THEN
        Use_DQ = TRUE
        REPLACE DQUOT$ WITH " DQ$ " IN Src$        ' """
    END IF
    '*********************************************************************************
    IF iMatchNQ(Src$, " $pragma ")   THEN
        Src$ = iReplace_NQ$ (Src$, "$pragma ", "!#pragma ")
    END IF
    '*********************************************************************************
    '                             Added in 8.1.3 by MrBcx
    '          Process the statements that are affected by the "ANY" keyword
    ' The order and masking are critical to defeat issue transforming similar keywords
    '*********************************************************************************
    IF iMatchNQ(Src$, " ANY ") THEN  ' ANY is a new BCX reserved keyword in BCX 8.1.3

        IF iMatchNQ(Src$, "EXTRACT$")   THEN
            IREPLACE "EXTRACT$" WITH "$TCARTXE" IN Src$   ' 8.2.8 MrBcx - New
            Src$ = Replace_ANY_Keyword$(Src$, "$TCARTXE")
            IREPLACE "$TCARTXEANY" WITH " EXTRACTANY$ " IN Src$
            Use_ExtractAny = Use_BcxTempStr = TRUE
        END IF

        IF iMatchNQ(Src$, "IINSTR")   THEN
            IREPLACE "IINSTR" WITH "II2NSTR" IN Src$      ' 8.1.3 MrBcx - I know, it looks wacky
            Src$ = Replace_ANY_Keyword$(Src$, "II2NSTR")
            IREPLACE "II2NSTRANY" WITH " IINSTRANY " IN Src$
            Use_IInstrAny = Use_IInstr = TRUE
        END IF

        IF iMatchNQ(Src$, "INSTR")    THEN Src$ = Replace_ANY_Keyword$(Src$, "INSTR")
        IF iMatchNQ(Src$, "IREMOVE$") THEN
            IREPLACE "IREMOVE$" WITH "REMOVEI$" IN Src$   ' 8.1.3 MrBcx - I know, it looks wacky
            Src$ = Replace_ANY_Keyword$(Src$, "REMOVEI$")
            IREPLACE "REMOVEI$ANY"  WITH " IREMOVEANY$ " IN Src$
            Use_IRemoveAny = Use_BcxTempStr = TRUE
        END IF

        IF iMatchNQ(Src$, "IREPLACE$") THEN
            IREPLACE "IREPLACE$" WITH "REPLACEI$" IN Src$  ' 8.1.3 MrBcx - I know, it looks wacky
            Src$ = Replace_ANY_Keyword$(Src$, "REPLACEI$")
            IREPLACE "REPLACEI$ANY"  WITH " IREPLACEANY$ " IN Src$
            Use_IReplaceAny = Use_BcxTempStr = TRUE
        END IF

        IF iMatchNQ(Src$, "REMOVE$")  THEN Src$ = Replace_ANY_Keyword$(Src$, "REMOVE$")
        IF iMatchNQ(Src$, "REPLACE$") THEN Src$ = Replace_ANY_Keyword$(Src$, "REPLACE$")

        IREPLACE "REMOVE$ANY"   WITH " REMOVEANY$ "   IN Src$
        IREPLACE "REPLACE$ANY"  WITH " REPLACEANY$ "  IN Src$
        IREPLACE "INSTRANY"     WITH " INSTRANY "     IN Src$
        IREPLACE "EXTRACT$ANY"  WITH " EXTRACTANY$ "  IN Src$
    END IF
    '*********************************************************************************
    Src$ = TRIM$(Src$)
END SUB  ' Early_Transforms







SUB Final_Transforms
    DIM RAW Source$
    '**********************************************************************************
    DIM RAW Dll_Orig$                 '  C_EXPORT int __stdcall DllMain
    Dll_Orig$ = VCHR$(30, 67, 95, 69, 88, 80, 79, 82, 84, 32, 105, 110, 116, _
    32, 95, 95, 115, 116, 100, 99, 97, 108, 108, 32, 68, 108, 108, 77, 97, 105, 110)
    '**********************************************************************************
    DIM RAW Dll_Repl$                 ' __declspec(dllexport) BOOL WINAPI DllMain
    Dll_Repl$ = VCHR$(41, 95, 95, 100, 101, 99, 108, 115, 112, 101, 99, 40, _
    100, 108, 108, 101, 120, 112, 111, 114, 116, 41, 32, 66, 79, 79, 76, 32, 87, 73, _
    78, 65, 80, 73, 32, 68, 108, 108, 77, 97, 105, 110)
    '**********************************************************************************
    DIM RAW QQF$, QQR$                ' change "char*  = DQ$" to "char*  = DQ"
    QQF$ = CHR$(99, 104, 97, 114, 42, 32, 32, 61, 32, 68, 81, 36)
    QQR$ = CHR$(99, 104, 97, 114, 42, 32, 32, 61, 32, 68, 81)
    '**********************************************************************************
    DIM RAW BandAid$ : BandAid$ = CHR$(38, 38, 61, 61)  ' Bugfix for SELECT CASE BAND
    '**********************************************************************************
    CALL StripExtraDefWndProcs
    '**********************************************************************************
    '            Determine if "#define BCXSTRSIZE 2048" can be removed
    '**********************************************************************************
    DIM AS ULONG ZapBCXSTRSIZE
    DIM AS ULONGLONG filesize : filesize = LOF(FileOut$) : DIM Buffer$ * filesize
    OPEN FileOut$ FOR BINARY READ AS FP1 : GET$ FP1, Buffer$, filesize : CLOSE FP1
    IF TALLY(Buffer$, "BCXSTRSIZE") = 1 THEN ZapBCXSTRSIZE = TRUE
    '**********************************************************************************
    OPEN FileOut$ FOR INPUT AS FP1
    OPEN "$Bcx$Temp$File$" FOR OUTPUT AS FP2
    '**********************************************************************************
    DO WHILE NOT EOF(FP1)
        LINE INPUT FP1, Source$

        '==================================================================
        ' Special hand-holding for one of the many ways BCX emits WndProc
        '==================================================================
        IF LEFTSTR(Source$, "LRESULT CALLBACK WndProc (HWND hWnd,") THEN
            FPRINT FP2, Source$
            LINE INPUT FP1, Source$    '  {
            FPRINT FP2, Source$
            LINE INPUT FP1, Source$
            IF INSTR(Source$, "Bcx_RetVal") = 0 THEN
                FPRINT FP2, "  LRESULT Bcx_RetVal={0};"
                FPRINT FP2, Source$
                Source$ = SPC$
            END IF
        END IF
        '==================================================================

        '******************************************************************************
        IF INSTR(Source$, "BCXSTRSIZE") AND ZapBCXSTRSIZE THEN ITERATE
        '******************************************************************************
        '               Do Some quick beautification of the output
        '******************************************************************************
        IF LTRIM$(Source$) = "" AND LTRIM$(LOOKAHEAD$(FP1)) = "" THEN ITERATE
        IF LTRIM$(Source$) = "" AND LTRIM$(LOOKAHEAD$(FP1)) = "#endif" THEN ITERATE
        '******************************************************************************

        REPLACE CHR$(15)  WITH  ":"       IN Source$  ' Fix recently detected mystery
        REPLACE QQF$      WITH  QQR$      IN Source$  ' Delete the $ from certain DQ$
        REPLACE Dll_Orig$ WITH  Dll_Repl$ IN Source$  ' Enforce MS DllMain definition
        '******************************************************************************
        IF LEFTSTR(Source$, "#define 3.14") THEN
            PRINT "CONST PI was detected in your program."
            PRINT "PI is a BCX reserved word and cannot be re-defined."
            PRINT "You must update your source code to remove this error."
            END
        END IF
        '******************************************************************************
        IF UserBcxStrSize$ > "" AND LEFTSTR(Source$, "#define BCXSTRSIZE") THEN
            Source$ = "#define BCXSTRSIZE " + UserBcxStrSize$
        END IF
        '******************************************************************************
        IF iMatchNQ (Source$, "BCXSTRSIZE") THEN
            IF LIKE(Source$, "*=*[BCXSTRSIZE];*") THEN
                CALL AllowLoadedStrings (Source$)
            END IF
        END IF
        '*************************************************************  Make ULEX happy
        REPLACE CHR$(61, 45, 32) WITH CHR$(32, 61, 32, 45) IN Source$ ' Before: =-[space]
        REPLACE CHR$(32, 45, 62) WITH CHR$(45, 62)         IN Source$ ' Before: [space]->
        '********************************************************************************
        IF iMatchNQ(Source$, BandAid$) THEN
            IF LIKE(Source$, "*if(*") THEN
                REPLACE BandAid$ WITH " & " IN Source$                ' Part 2/2 fixing
            END IF                                                    ' SELECT CASE BAND
        END IF
        '********************************************************************************
        '                                                             '    ()() -> ()
        REPLACE CHR$(40, 41, 40, 41) WITH CHR$(40, 40) IN Source$
        '********************************************************************************
        REPLACE CHR$(70, 73, 76, 69, 32, 32, 32, 42, 32, 32) WITH "FILE   *" IN Source$
        '********************************************************************************
        '                        Cosmetic fixups by MrBcx
        '********************************************************************************
        IF INSTR (Source$, "char*") THEN REPLACE "char* ," WITH "char*," IN Source$
        IF INCHR (Source$, "(") THEN
            Source$ = iReplace_NQ$ (Source$, "( ", "(")
        END IF
        '*********************************************************************************
        '                             Added in 8.2.5 by MrBcx
        '      If Use_Sound = TRUE then we need to emit the MIDI shutdown code
        '       -> everywhere <- that we find a PostQuitMessage(0) statement
        '*********************************************************************************
        IF iMatchNQ(Source$, "PostQuitMessage(0);") AND Use_Sound THEN
            Source$ = "       midiOutClose (hMidi);" + LF$ + Source$
        END IF
        '********************************************************************************
        FPRINT FP2, Source$
    LOOP
    CLOSE
    KILL FileOut$
    RENAME "$Bcx$Temp$File$", FileOut$
END SUB  ' Final_Transforms


SUB TransformStringConcat
    '***************************************************************************************
    ' This SUB transforms instances of the += operator (used for string concatenation)
    ' into an equivalent form: variable = variable + arglist. It ensures transformations
    ' occurs only outside string literals and processes the first occurrence per call.
    ' Stk$[] is modified and the token count [Ndx] is updated accordingly.
    ' It is called from the beginning of SUB Early_Transforms
    '***************************************************************************************
    DIM j AS INT
    DIM InString AS INT                 ' Track if we're inside a string literal
    DIM QuoteChar$                      ' Track which quote character is being used
    DIM Tmp$
    DIM ParenDepth AS INT               ' Track parenthesis nesting level
    FOR INT i = 2 TO Ndx - 1
        IF Stk$[i] = DQ$ THEN           ' Check for string literal boundaries
            IF InString = FALSE THEN
                InString = TRUE
                QuoteChar = Stk$[i]
            ELSEIF Stk$[i] = DQ$ THEN
                InString = FALSE
            END IF
        END IF
        IF InString = FALSE THEN
            IF Stk$[i] = "+" AND Stk$[i + 1] = "=" THEN
                Tmp$ = ""  ' Reset Tmp$ to store the full left-hand variable.
                ParenDepth = 0  ' Reset parenthesis depth counter
                '            Capture the full variable including array index, if present
                j = i - 1
                WHILE j > 0
                    ' Check for expression terminators, but handle parentheses specially
                    IF Stk$[j] = ")" THEN
                        ParenDepth = ParenDepth + 1
                        Tmp$ = Stk$[j] + Tmp$
                    ELSEIF Stk$[j] = "(" THEN
                        ParenDepth = ParenDepth - 1
                        Tmp$ = Stk$[j] + Tmp$
                        ' If we've closed all parentheses and this is a standalone opening paren
                        ' (not part of a function call), check if we should stop
                        IF ParenDepth < 0 THEN
                            ' This opening paren doesn't have a matching closing paren in our expression
                            ' so it's likely a statement delimiter - stop here and remove it
                            Tmp$ = MID$(Tmp$, 2)  ' Remove the opening paren we just added
                            EXIT WHILE
                        END IF
                    ELSEIF ParenDepth = 0 AND (Stk$[j] = SPC$ OR Stk$[j] = "," OR Stk$[j] = "=") THEN
                        ' Only stop for these delimiters when not inside parentheses
                        EXIT WHILE
                    ELSE
                        Tmp$ = Stk$[j] + Tmp$
                    END IF
                    j = j - 1
                WEND
                ' Shift tokens right
                FOR j = Ndx TO i + 1 STEP -1
                    Stk$[j + 1] = Stk$[j]
                NEXT
                ' Modify the stack
                Stk$[i] = "="       ' Convert "+=" into "="
                Stk$[i + 1] = Tmp$  ' Insert the full variable name
                Stk$[i + 2] = "+"   ' Keep "+"
                Ndx = Ndx + 1       ' Update token count
                EXIT FOR            ' Process only the first occurrence per call
            END IF
        END IF
    NEXT
END SUB



SUB RBForTransform
    '********************************************************************
    '  777 -  James Fuller's pre-translation FOR-NEXT transform
    '                for C++11 Range Based FOR-NEXT loops
    '                 Keywords:  RBFOR,  RBEXIT,  RBNEXT
    '*********************************************************************
    DIM RAW Kopy$
    Kopy$ = TRIM$(Src$)

    IF LEFTSTR(Kopy$, "rbfor", 1) THEN
        Src$ = iReplace_NQ$(Src$, "AUTO", "auto")
        Src$ = iReplace_NQ$(Src$, "rbfor", "! for ")
        Src$ += " { "
    END IF

    IF LEFTSTR(Kopy$, "rbnext", 1) THEN
        Src$ = "}"
    END IF

    IF LEFTSTR(Kopy$, "rbexit", 1) THEN
        Src$ = "break"
    END IF
END SUB  ' RBForTransform



SUB StripExtraDefWndProcs
    '*********************************************************************
    ' This subroutine reads lines from FileOut$, strips unnecessary
    ' consecutive "return DefWindowProc" lines, writes the cleaned lines
    ' to a temporary file which is renamed and replaces the original file.
    '*********************************************************************
    DIM RAW Source$
    DIM RAW CurrLin$
    DIM RAW PrevLin$
    '****************************************
    OPEN FileOut$          FOR INPUT  AS FP1
    OPEN "$Bcx$Temp$File$" FOR OUTPUT AS FP2
    '****************************************
    DO WHILE NOT EOF(FP1)
        LINE INPUT FP1, Source$
        CurrLin$ = LEFT$(LTRIM$(Source$), 20)

        IF CurrLin$ <> "return DefWindowProc" THEN
            FPRINT FP2, Source$
            PrevLin$ = LEFT$(LTRIM$(Source$), 7)  ' Warning:  Don't assume this = "return "
            ITERATE
        END IF

        IF CurrLin$ = "return DefWindowProc" AND PrevLin$ <> "return " THEN
            FPRINT FP2, Source$
        END IF

        PrevLin$ = LEFT$(LTRIM$(Source$), 7)      ' Warning:  Don't assume this = "return "
    LOOP

    CLOSE FP1, FP2
    KILL FileOut$
    RENAME "$Bcx$Temp$File$", FileOut$
END SUB  ' StripExtraDefWndProcs



SUB AllowLoadedStrings(szSrc$)
    '********************************************************************************
    ' This allows static string initializations using DIM and DIM RAW.  This only
    ' works in SUBS and FUNCTIONS (including FUNCTION MAIN, if $NOMAIN is used).
    ' Example 1:  DIM A$ = "This is handy!"
    ' Example 2:  DIM RAW A$ = "This works too!"
    ' Example 3:  LOCAL A$ = "This works too!"
    '********************************************************************************
    MACRO CommaEq$ = ",="
    DIM RAW i
    DIM RAW Varname$
    DIM RAW Literal$
    DIM RAW Target$

    Target$ = DQ$ + "[BCXSTRSIZE];"
    i = INSTR (szSrc$, Target$)

    IF i > 0 THEN
        Literal$ = MID$(szSrc$, 1 + INCHR(szSrc$, "="))
        REMOVE "[BCXSTRSIZE];" FROM Literal$
        Varname$ = EXTRACT$ (szSrc$, "=")
        Varname$ = STRIM$(Varname$)
        szSrc$   = Varname$ + "[BCXSTRSIZE];  strcpy("
        Varname$ = TRIM$(MID$(Varname$, INCHR(Varname$, SPC$)))
        szSrc$   = szSrc$ + Varname$ + "," + Literal$ + ");"
        szSrc$   = iReplace_NQ$ (szSrc$, CommaEq$, ",")
        szSrc$   = SPACE$(3) + szSrc$
    END IF
END SUB  ' AllowLoadedStrings




FUNCTION iMatch(Arg$ AS LPCTSTR, MatchStr$ AS LPCTSTR, mt)
    '****************************************************
    ' Case insensitive comparison - MatchStr$ to Arg$
    ' mt = 0, 1 or 2 Match left, whole word, right
    '****************************************************
    DIM RAW L1 AS INTEGER
    DIM RAW L2 AS INTEGER
    IF mt = 2 THEN
        L1 = LEN(Arg$)
        L2 = LEN(MatchStr$)
        IF L1 < L2 THEN RETURN  FALSE
        Arg = (Arg + L1) - L2
    END IF
    DO WHILE *MatchStr
        IF ISNULL(Arg) THEN RETURN FALSE                          ' If we run out string, return no match
        IF (*Arg BOR 32) <> (*MatchStr BOR 32) THEN RETURN FALSE  ' bit ORing with 32 produces lower case
        INCR Arg
        INCR MatchStr
    LOOP
    IF mt AND NOTNULL(Arg$) THEN
        RETURN FALSE
    ELSE
        RETURN TRUE
    END IF
END FUNCTION ' iMatch



FUNCTION iMatchNQ (Arg$, MatchStr$)
    '****************************************************
    ' Returns the position of the first occurrence
    ' of MatchStr$ in Arg$ that isn't in quotes.
    '****************************************************
    DIM RAW mi
    DIM RAW a AS PCHAR
    mi = 0
    a = Arg
    DO WHILE MatchStr[mi]
        IF *a = c_DblQt THEN
            mi = 0
            DO WHILE *(++a) <> c_DblQt
                IF *a = 0 THEN RETURN 0
            LOOP
        END IF
        IF a[mi] = 0 THEN RETURN 0                   ' If we run out string, return no match
        IF (a[mi] BOR 32) <> (MatchStr[mi] BOR 32) THEN  ' bit ORing with 32 produces lower case
            INCR a
            mi = (-1)
        END IF
        INCR mi
    LOOP
    RETURN CAST(INT, (a-Arg) + 1)  ' We have a match
END FUNCTION  ' iMatchNQ




FUNCTION GetBracketPair(iStart AS INTEGER, iEnd AS INTEGER, iDir AS INTEGER)
    '****************************************************************************
    ' This function searches for a pair of consecutive brackets ("[") and ("]")
    ' in the Stk$ array, starting from the index iStart to iEnd in the direction
    ' specified by iDir.  If found, it returns the index of the opening bracket;
    ' otherwise, it returns 0.
    '****************************************************************************
    FOR INT i = iStart TO iEnd STEP iDir
        IF *Stk$[i] = ASC("[") AND *Stk$[i+1] = ASC("]") THEN
            RETURN i
        END IF
    NEXT
    RETURN 0
END FUNCTION ' GetBracketPair





FUNCTION GetAsPos(iStart AS INTEGER, iEnd AS INTEGER, iDir AS INTEGER)
    '****************************************************************************
    ' This function searches for the word "as" in the Stk$ array,
    ' starting from the index iStart to iEnd in the direction specified by iDir.
    ' If found, it returns the index of the occurrence; otherwise, it returns 0.
    '****************************************************************************
    FOR INT i = iStart TO iEnd STEP iDir
        IF iMatchWrd(Stk$[i], "as") THEN
            RETURN i
        END IF
    NEXT
    RETURN 0
END FUNCTION  ' GetAsPos





SUB BuildStr(iStart, iEnd, szBuild$)
    '******************************************************************
    ' This subroutine concatenates the elements of the Stk$ array
    ' from index iStart to iEnd into the szBuild$ string, effectively
    ' building a single string from the specified range.
    '******************************************************************
    szBuild$ = ""
    FOR INT i = iStart TO iEnd
        szBuild$ += Stk$[i]
    NEXT
END SUB ' BuildStr




FUNCTION Clean$(StringArg AS STRING)
    '*************************************************
    ' Carefully removes sigils (%$#!@`) from StringArg
    '*************************************************
    DIM RAW LTmp$
    IF INCHR(StringArg, "%") THEN
        IF TRIM$(StringArg) = "%" THEN RETURN " % "
    END IF
    IF iMatchNQ(StringArg, "!=") THEN RETURN StringArg
    LTmp$ = StringArg
    RemoveAll(LTmp$, VARTYPES$, 1)   ' 1 = ignore anything in quotes
    RETURN LTmp$
END FUNCTION ' Clean$




SUB BuildDelimStr(iStart, iEnd, szBuild$)
    '*******************************************************************
    ' This SUB's purpose is to construct a delimited string from an
    ' array of strings (Stk$). It iterates through a specified range
    ' (iStart to iEnd), appending each string to szBuild$ with specific
    ' formatting rules, including handling special characters like
    ' "!", "_", and punctuation. The function ensures appropriate
    ' spacing and punctuation placement within the resulting string.
    '*******************************************************************
    DIM RAW pszStk AS PCHAR
    szBuild$ = ""
    FOR INT i = iStart TO iEnd
        pszStk = CAST(PCHAR, ADDRESSOF(Stk$[i]))
        IF NOTNULL(pszStk) THEN
            IF pszStk$ = "!" THEN
                szBuild$ += " ! "
            ELSE
                IF *pszStk$ = ASC("_") THEN
                    szBuild$ += SPC$
                    szBuild$ += pszStk$
                ELSE
                    szBuild$ += pszStk$
                    IF ispunct(*pszStk) THEN
                        IF ISNULL (pszStk+1) THEN ITERATE
                    END IF
                END IF
                IF i < iEnd AND (ISFALSE ispunct(*Stk$[i+1]) OR NOTZERO Stk[i+1][1]) THEN
                    IF *Stk$[2] <> ASC("=") THEN
                        szBuild$ += SPC$
                    END IF
                END IF
            END IF
        END IF
    NEXT
END SUB ' BuildDelimStr




SUB BuildCleanStr(iStart, iEnd, szBuild$)
    '************************************************************************
    ' This SUB constructs a delimited string from an array of strings and
    ' then removes specific sigils and unwanted chars from the final string.
    '************************************************************************
    CALL BuildDelimStr(iStart, iEnd, szBuild$)
    szBuild$ = Clean$(szBuild$)
END SUB ' BuildCleanStr




SUB WriteCleanTokens(iStart, iEnd)
    '***************************************************************
    ' This SUB constructs a cleaned, delimited string from an array
    ' of strings and writes the resulting string to the output file.
    '***************************************************************
    DIM RAW LTmp$
    CALL BuildCleanStr(iStart, iEnd, LTmp$)
    FPRINT FP_WRITE, LTmp$
END SUB ' WriteCleanTokens




FUNCTION HasThisToken(sToken$)
    '*****************************************************************************
    ' This function checks if the sToken$ string is present in the Stk$ array.
    ' It returns a non-zero value if the token is found; otherwise, it returns 0.
    '*****************************************************************************
    DIM RAW ThisToken = 0
    XFOR INT j = 1 WHILE j <= Ndx AND IAmNot(ThisToken) BY j++
        ThisToken = iMatchWrd(Stk$[j], sToken$)
    XNEXT
    RETURN ThisToken
END FUNCTION

'************************************************************************************************
'                                 Expand the Built-in BCX Macros
'************************************************************************************************


FUNCTION MacroCheck
    '********************************************************************************************
    ' This function checks if the source code string (Src$) contains certain macro commands
    ' (e.g., handle_msg, handle_cmd, bcx_resource, msghandler, cmdhandler, end) and processes
    ' them accordingly. If a recognized macro is found, the function executes the appropriate
    ' SUB to handle the macro, sets IsMacro to TRUE, and clears the source string (Src$).
    ' The function returns TRUE if a macro was found and processed, otherwise it returns FALSE.
    '********************************************************************************************
    DIM RAW szMacroCheck$
    DIM RAW IsMacro = FALSE
    FastLexer(Src$, " (", "")
    szMacroCheck$ = LCASE$(Stk$[1])

    IF iMatchNQ ("handle_msg handle_cmd bcx_resource msghandler cmdhandler end", szMacroCheck$) THEN
        SELECT CASE szMacroCheck$
            CASE "handle_msg"     ' handle_msg handler
            CALL VerifyMatchedPairs
            CALL ProcessMsgCracker
            IsMacro = TRUE

            CASE "handle_cmd"
            CALL VerifyMatchedPairs
            CALL ProcessCmdHandler
            IsMacro = TRUE

            CASE "bcx_resource"
            Use_GenResFile = TRUE
            FPRINT FP_RES, MID$(Src$, 14)
            IsMacro = TRUE

            CASE "msghandler", "cmdhandler"
            Inject_Local_Bcx_RetVal = TRUE
            CALL VerifyMatchedPairs
            CALL ProcessMsgHandler
            IsMacro = TRUE

            CASE "end"
            IF ISTRUE (iMatchWrd(Stk$[2], "handler")) THEN
                CALL VerifyMatchedPairs
                CALL ProcessMsgHandlerEnd
                IsMacro = TRUE
            END IF
        END SELECT
    END IF
    IF IsMacro = TRUE THEN Src$ = ""
    RETURN IsMacro
END FUNCTION





SUB Process_ASC_Function (St_idx)
    '*************************************************************************************************************
    ' This parses an "ASC" function starting at the given index (St_idx) in the Stk$ array.
    ' It detects if the function argument is a double quote and handles the function conversion accordingly.
    ' If the argument is a double quote, it sets the stack entry to "asc" and updates Use_Asc and Use_Proto flags.
    ' If the argument is not a double quote, it converts the character to its ASCII value or sets the
    ' entry to "0". For other cases, it handles arguments and sets the stack entry for further processing.
    '**************************************************************************************************************
    DIM RAW i
    DIM RAW j
    j = GetNumArgs(St_idx + 2, ADDRESSOF(i))
    IF *Stk$[St_idx + 2] = *DQ$ THEN
        IF j OR *Stk$[St_idx + 3] <> ASC(")") THEN
            Stk$[St_idx] = "asc"
            Use_Asc = Use_Proto = TRUE
        ELSE
            IF Stk$[St_idx + 2] = DDQ$ THEN
                Stk$[St_idx] = "0"
            ELSE
                Stk$[St_idx] = STR$(CAST(DOUBLE, ASC(Stk$[St_idx + 2], 1)), TRUE)
            END IF
            Stk$[St_idx + 1] = ""
            Stk$[St_idx + 2] = ""
            Stk$[St_idx + 3] = ""
        END IF
    ELSE
        IF j > 0 THEN Stk$[i] = "+"
        Stk$[St_idx] = "(UCHAR)*"
    END IF
END SUB




SUB ActivityFlags
    '********************************************************************************************************
    ' This subroutine manages activity flags for tracing and source output.
    ' If ShowStatus is true, it calls DisplayStatus.
    ' If TraceFlag and InFunction are true and the current line is not a trace or end statement,
    ' it logs the current source line with file name and line number, and adds a printf statement.
    ' If SrcFlag is true and the current line is not a source directive or comment, it logs the source line.
    '*********************************************************************************************************
    IF ShowStatus THEN CALL DisplayStatus
    '*******************************************
    IF ISTRUE (TraceFlag AND InFunction) THEN
        IF ISFALSE(iMatchLft(Src$, "$trace")) THEN
            IF ISFALSE(iMatchLft(Src$, "end ")) AND ISZERO (iMatchNQ(Src$, "function")) THEN
                FPRINT FP_WRITE, "// [", TRIM$(FileNames$[FileNdx]), " - ", TRIM$(STR$(LineNum[FileNdx])), "] ", Src$
                LOCAL Tmp$
                Tmp$ = TRIM$(FileNames$[FileNdx])
                Tmp$ = REPLACE$(Tmp$, BKSLASH1$, BKSLASH2$)
                Tmp$ = SPC$ + Tmp$ + " - " + STR$(LineNum[FileNdx]) + " \\n"
                Tmp$ = "printf(" + ENC$(Tmp$) + ");"
                FPRINT FP_WRITE, Tmp$
            END IF
        END IF
    END IF
    '*****************************************
    IF SrcFlag THEN
        IF ISFALSE (iMatchLft(Src$, "$sourc")) AND *Src <> ASC("!") THEN
            FPRINT FP_WRITE, "// [", TRIM$(FileNames$[FileNdx]), " - ", TRIM$(STR$(LineNum[FileNdx])), "] ", Src$
        END IF
    END IF
END SUB



SUB DisplayStatus
    '**************************************************************************
    ' The purpose of this SUB is to update and display the current processing
    ' status on the screen. It shows the module being processed, the current
    ' line number, and any abort source message. Additionally, it provides an
    ' option to cancel the operation by pressing any key, which then removes
    ' unfinished translation files and notifies the user of the cancellation.
    ' The function also manages screen colors, if BCX_COLORS is enabled.
    '**************************************************************************
    LOCATE 5, 1, 0
    PRINT "Processing Module: ", TRIM$(FileNames$[FileNdx]), " - Line:", LineNum[FileNdx]
    LOCATE 6, 1, 0
    PRINT SPACE$ (1000)
    IF BCX_COLORS THEN COLOR 10, 0
    LOCATE 6, 1, 0
    PRINT STRIM$ (AbortSrc$)
    IF BCX_COLORS THEN COLOR 13, 0
    LOCATE 10, 1, 0
    PRINT "Press any key to cancel"
    SLEEP (100)
    IF INSTAT THEN
        CLOSE
        SLEEP (100)
        KILL "BC.out"
        KILL "BC.c"
        KILL "BC.cpp"
        POPCOLORS
        PRINT "Cancelled by user. Unfinished translation files removed."
        END
    END IF
    POPCOLORS
END SUB



FUNCTION GetVarTypeName$ (i)
    DIM RAW A$
    SELECT CASE i
        CASE vt_INTEGER    :    A$ = "int"
        CASE vt_STRVAR     :    A$ = "char *"
        CASE vt_STRLIT     :    A$ = "STRLIT"
        CASE vt_UNKNOWN    :    A$ = "UNKNOWN"
        CASE vt_SINGLE     :    A$ = "float"
        CASE vt_DOUBLE     :    A$ = "double"
        CASE vt_LDOUBLE    :    A$ = "LDOUBLE"
        CASE vt_DECFUNC    :    A$ = "DECFUNC"
        CASE vt_NUMBER     :    A$ = "NUMBER"
        CASE vt_FILEPTR    :    A$ = "FILE*"
        CASE vt_UDT        :    A$ = "struct"
        CASE vt_STRUCT     :    A$ = "struct"
        CASE vt_UNION      :    A$ = "union"
        CASE vt_LPSTR      :    A$ = "PSTR"
        CASE vt_BSTR       :    A$ = "BSTR"
        CASE vt_BOOL       :    A$ = "BOOL"     ' When UseCpp THEN A$ = "bool" ELSE A$ = "BOOL"
        CASE vt_CHAR       :    A$ = "char"
        CASE vt_SCHAR      :    A$ = "signed char"
        CASE vt_LPSTRPTR   :    A$ = "PSTR *"
        CASE vt_CHARPTR    :    A$ = "char"     ' Default String - 2048
        CASE vt_PCHAR      :    A$ = "PCHAR"
        CASE vt_VOID       :    A$ = "void"
        CASE vt_LONG       :    A$ = "long"
        CASE vt_DWORD      :    A$ = "ULONG"
        CASE vt_FARPROC    :    A$ = "FARPROC"
        CASE vt_LPBYTE     :    A$ = "LPBYTE"
        CASE vt_LRESULT    :    A$ = "LRESULT"
        CASE vt_BYTE       :    A$ = "BYTE"
        CASE vt_SHORT      :    A$ = "short"
        CASE vt_USHORT     :    A$ = "USHORT"
        CASE vt_SSHORT     :    A$ = "signed short"
        CASE vt_COLORREF   :    A$ = "COLORREF"
        CASE vt_UINT       :    A$ = "UINT"
        CASE vt_ULONG      :    A$ = "ULONG"
        CASE vt_ULONGLONG  :    A$ = "ULONGLONG"
        CASE vt_LLONG      :    A$ = "long long"
        CASE vt_HWND       :    A$ = "HWND"
        CASE vt_HANDLE     :    A$ = "HANDLE"
        CASE vt_HINSTANCE  :    A$ = "HINSTANCE"
        CASE vt_HDC        :    A$ = "HDC"
        CASE vt_SAFEARRAY  :    A$ = "SAFEARRAY"
        CASE vt_VARIANT    :    A$ = "VARIANT"
        CASE vt_WNDCLASSEX :    A$ = "WNDCLASSEX"
        CASE vt_HFONT      :    A$ = "HFONT"
        CASE vt_DOCINFO    :    A$ = "DOCINFO"
        CASE vt_LOGFONT    :    A$ = "LOGFONT"
        CASE vt_TEXTMETRIC :    A$ = "TEXTMETRIC"
        CASE vt_WINBOOL    :    A$ = "BOOL"
        CASE vt_BITMAPINFO :    A$ = "BITMAPINFO"
        CASE vt_HBITMAP    :    A$ = "HBITMAP"
        CASE ELSE          :    A$ = ""  ' Assume the programmer has a brain
    END SELECT
    RETURN A$
END FUNCTION ' GetVarTypeName$




SUB LoopErrorMsg
    '***************************************************************************
    ' This subroutine constructs and displays an error message for loop errors.
    ' It handles different types of loop errors and specifies the line number
    ' where the error occurred.  If multiple loop errors are detected, it
    ' indicates that the innermost loop error is being reported.
    '****************************************************************************
    DIM RAW sError$
    IF LoopTypeCnt > 1 THEN
        sError$ = "Multiple loop errors, innermost starting at"
    ELSE
        sError$ = "Loop error starting at"
    END IF

    sError$ += STR$(LoopType[LoopTypeCnt].iLoopLine) + SPC$

    SELECT CASE LoopType[LoopTypeCnt].iLoopType

        CASE lt_DOLOOP
        sError$ += "DO without LOOP"

        CASE lt_DOWHILELOOP, lt_DOUNTILLOOP
        sError$ += "DO CONDITION without LOOP"

        CASE lt_WHILEWEND
        sError$ += "WHILE without WEND"

        CASE lt_FORNEXT
        sError$ += "FOR without NEXT"

        CASE lt_SELECT
        sError$ += "SELECT without END SELECT"

        CASE lt_FORXNEXT
        sError$ += "XFOR without XNEXT"
    END SELECT
    CALL Abort(sError$)
END SUB




FUNCTION LoopTypeName$(iLoopType AS INTEGER)
    '*******************************************
    '  Used to get loop type for Error Message
    '*******************************************
    DIM sLoopType$

    SELECT CASE iLoopType

        CASE lt_DOLOOP
        sLoopType$ = "DO"

        CASE  lt_DOWHILELOOP, lt_DOUNTILLOOP
        sLoopType$ = "DO CONDITION"

        CASE lt_WHILEWEND
        sLoopType$ = "WHILE"

        CASE lt_FORNEXT
        sLoopType$ = "FOR"

        CASE lt_SELECT
        sLoopType$ = "SELECT"

        CASE lt_FORXNEXT
        sLoopType$ = "XFOR"
    END SELECT
    RETURN sLoopType$
END FUNCTION ' LoopTypeName$



SUB Emit_CompilerDefines
    DIM STATIC BeenHere
    IF BeenHere THEN EXIT SUB
    BeenHere = TRUE
    FPRINT FP_HDR, ""
    FPRINT FP_HDR, "// *************************************************"
    FPRINT FP_HDR, "//                  Compiler Macros"
    FPRINT FP_HDR, "// *************************************************"
    FPRINT FP_HDR, ""

    IF UseImportExport THEN
        FPRINT FP_HDR, "#if defined(__cplusplus)"
        FPRINT FP_HDR, "  #define C_EXPORT EXTERN_C __declspec(dllexport)"
        FPRINT FP_HDR, "  #define C_IMPORT EXTERN_C __declspec(dllimport)"
        FPRINT FP_HDR, "#else"
        FPRINT FP_HDR, "  #define C_EXPORT __declspec(dllexport)"
        FPRINT FP_HDR, "  #define C_IMPORT __declspec(dllimport)"
        FPRINT FP_HDR, "#endif"
        FPRINT FP_HDR, ""
    END IF


    IF NO_VKKEYS = FALSE AND ZapFlag = FALSE THEN
        FPRINT FP_HDR, "#ifndef    VK_0"        ' LccWin32 and Pelles include these, MSVC and MINGW do not!
        FPRINT FP_HDR, "   #define VK_0  0x30"
        FPRINT FP_HDR, "   #define VK_1  0x31"
        FPRINT FP_HDR, "   #define VK_2  0x32"
        FPRINT FP_HDR, "   #define VK_3  0x33"
        FPRINT FP_HDR, "   #define VK_4  0x34"
        FPRINT FP_HDR, "   #define VK_5  0x35"
        FPRINT FP_HDR, "   #define VK_6  0x36"
        FPRINT FP_HDR, "   #define VK_7  0x37"
        FPRINT FP_HDR, "   #define VK_8  0x38"
        FPRINT FP_HDR, "   #define VK_9  0x39"
        FPRINT FP_HDR, "   #define VK_A  0x41"
        FPRINT FP_HDR, "   #define VK_B  0x42"
        FPRINT FP_HDR, "   #define VK_C  0x43"
        FPRINT FP_HDR, "   #define VK_D  0x44"
        FPRINT FP_HDR, "   #define VK_E  0x45"
        FPRINT FP_HDR, "   #define VK_F  0x46"
        FPRINT FP_HDR, "   #define VK_G  0x47"
        FPRINT FP_HDR, "   #define VK_H  0x48"
        FPRINT FP_HDR, "   #define VK_I  0x49"
        FPRINT FP_HDR, "   #define VK_J  0x4A"
        FPRINT FP_HDR, "   #define VK_K  0x4B"
        FPRINT FP_HDR, "   #define VK_L  0x4C"
        FPRINT FP_HDR, "   #define VK_M  0x4D"
        FPRINT FP_HDR, "   #define VK_N  0x4E"
        FPRINT FP_HDR, "   #define VK_O  0x4F"
        FPRINT FP_HDR, "   #define VK_P  0x50"
        FPRINT FP_HDR, "   #define VK_Q  0x51"
        FPRINT FP_HDR, "   #define VK_R  0x52"
        FPRINT FP_HDR, "   #define VK_S  0x53"
        FPRINT FP_HDR, "   #define VK_T  0x54"
        FPRINT FP_HDR, "   #define VK_U  0x55"
        FPRINT FP_HDR, "   #define VK_V  0x56"
        FPRINT FP_HDR, "   #define VK_W  0x57"
        FPRINT FP_HDR, "   #define VK_X  0x58"
        FPRINT FP_HDR, "   #define VK_Y  0x59"
        FPRINT FP_HDR, "   #define VK_Z  0x5A"
        FPRINT FP_HDR, "#endif "
        FPRINT FP_HDR, ""
    END IF

    IF ZapFlag = FALSE THEN
        IF NO_MSVC = FALSE THEN
            FPRINT FP_HDR, "// *************************************************"
            FPRINT FP_HDR, "//                   Microsoft VC++"
            FPRINT FP_HDR, "// *************************************************"
            FPRINT FP_HDR, ""
            FPRINT FP_HDR, "#ifndef DECLSPEC_UUID"
            FPRINT FP_HDR, "  #if(_MSC_VER >= 1100) && defined(__cplusplus)"
            FPRINT FP_HDR, "    #define DECLSPEC_UUID(x)  __declspec(uuid(x))"
            FPRINT FP_HDR, "  #else"
            FPRINT FP_HDR, "    #define DECLSPEC_UUID(x)"
            FPRINT FP_HDR, "  #endif"
            FPRINT FP_HDR, "#endif"
            FPRINT FP_HDR, "#if (_MSC_VER >= 1900)            // earlier versions untested"
            FPRINT FP_HDR, "   #include <intrin.h>"
            FPRINT FP_HDR, "      #ifndef _rdtsc"
            FPRINT FP_HDR, "         #define _rdtsc __rdtsc   // MSVC uses 2 underscores"
            FPRINT FP_HDR, "      #endif"
            IF WarningFlag = FALSE THEN
                FPRINT FP_HDR, "   #pragma warning(disable: 4018) // signed/unsigned mismatch warnings"
                FPRINT FP_HDR, "   #pragma warning(disable: 4100) // unreferenced argument warnings"
                FPRINT FP_HDR, "   #pragma warning(disable: 4459) // local hides global declaration"
                FPRINT FP_HDR, "   #pragma warning(disable: 4267) // conversion from type1 to type2 warnings"
                FPRINT FP_HDR, "   #pragma warning(disable: 4305) // truncation from double to float warnings"
                FPRINT FP_HDR, "   #pragma warning(disable: 4459) // hides global declaration warnings"
                FPRINT FP_HDR, "   #pragma warning(disable: 4800) // forcing value to bool warnings"
                FPRINT FP_HDR, "   #pragma warning(disable: 4838) // conversion from type1 to type2 warnings"
                FPRINT FP_HDR, "   #pragma warning(disable: 4244) // conversion from type1 to type2 warnings"
                FPRINT FP_HDR, "   #pragma warning(disable: 4245) // conversion from type1 to type2 warnings"
                FPRINT FP_HDR, "   #pragma warning(disable: 4554) // use parentheses to clarify precedence"
                FPRINT FP_HDR, "   #pragma warning(disable: 4389) // conversion from signed to unsigned warnings"
            END IF
            FPRINT FP_HDR, "#endif"
            FPRINT FP_HDR, ""
        END IF

        IF NO_GCCCLANG = FALSE THEN
            FPRINT FP_HDR, ""
            FPRINT FP_HDR, "// *************************************************"
            FPRINT FP_HDR, "//                  GCC and CLANG"
            FPRINT FP_HDR, "// *************************************************"
            FPRINT FP_HDR, ""
            FPRINT FP_HDR, "#if defined(__GNUC__) || defined(__clang__)"
            FPRINT FP_HDR, "   #ifndef __BCPLUSPLUS__"
            FPRINT FP_HDR, "      #include <x86intrin.h>"
            FPRINT FP_HDR, "   #endif"

            IF WarningFlag = FALSE THEN
                FPRINT FP_HDR, "   #pragma GCC diagnostic ignored ", ENC$("-Wwrite-strings")
                FPRINT FP_HDR, "   #pragma GCC diagnostic ignored ", ENC$("-Wunused-parameter")
                FPRINT FP_HDR, "   #pragma GCC diagnostic ignored ", ENC$("-Wunknown-pragmas")
                FPRINT FP_HDR, "   #pragma GCC diagnostic ignored ", ENC$("-Wdangling-else")
                FPRINT FP_HDR, "   #pragma GCC diagnostic ignored ", ENC$("-Wdeprecated")
                FPRINT FP_HDR, "   #pragma GCC diagnostic ignored ", ENC$("-Wsizeof-pointer-div") ' MrBcx _msize warnings
            END IF
            FPRINT FP_HDR, "#endif"
            FPRINT FP_HDR, ""
        END IF

        IF NO_BORLAND = FALSE THEN
            FPRINT FP_HDR, ""
            FPRINT FP_HDR, "// *************************************************"
            FPRINT FP_HDR, "//                  Embarcadero C++"
            FPRINT FP_HDR, "// *************************************************"
            FPRINT FP_HDR, ""
            FPRINT FP_HDR, "#if defined(__BCPLUSPLUS__)"
            FPRINT FP_HDR, "      #include<malloc.h>"
            FPRINT FP_HDR, "      #if defined (_clang__)"
            FPRINT FP_HDR, "          #include <mmintrin.h>"
            FPRINT FP_HDR, "      #endif"
            FPRINT FP_HDR, "      #define _kbhit kbhit"
            FPRINT FP_HDR, "      #ifndef _rdtsc"
            FPRINT FP_HDR, "         #define _rdtsc __rdtsc  // Uses 2 underscores"
            FPRINT FP_HDR, "      #endif"
            FPRINT FP_HDR, "#endif"
            FPRINT FP_HDR, ""
        END IF

        IF ISFALSE UseCpp AND NO_LCCWIN = FALSE THEN
            FPRINT FP_HDR, ""
            FPRINT FP_HDR, "// *************************************************"
            FPRINT FP_HDR, "//                     Lcc-Win32"
            FPRINT FP_HDR, "// *************************************************"
            FPRINT FP_HDR, ""
            FPRINT FP_HDR, "#if defined(__LCC__)"
            FPRINT FP_HDR, "    #define _strdup    strdup"
            FPRINT FP_HDR, "    #define _fseeki64  fseek"
            FPRINT FP_HDR, "    #define _ftelli64  ftell"
            FPRINT FP_HDR, "    #define _stricmp   stricmp"
            FPRINT FP_HDR, "    #define _strnicmp  strnicmp"
            FPRINT FP_HDR, "    #define _itoa      itoa"
            FPRINT FP_HDR, "    #define _ltoa      ltoa"
            FPRINT FP_HDR, "    #include <intrinsics.h>"
            FPRINT FP_HDR, "    #include <malloc.h>  // for _msize"
            FPRINT FP_HDR, "    #if defined(__windows_h__)"
            FPRINT FP_HDR, "       #define COMPILE_MULTIMON_STUBS"
            FPRINT FP_HDR, "       #include <multimon.h>"
            FPRINT FP_HDR, "       #include <iehelper.h>"
            FPRINT FP_HDR, "       #include <exdisp.h>"
            FPRINT FP_HDR, "    #endif"
            FPRINT FP_HDR, "#endif"
            FPRINT FP_HDR, ""
        END IF

        IF Use_Overloaded_Macro THEN
            FPRINT FP_HDR, "#if !defined(__LCC__)"
            FPRINT FP_HDR, "    #define overloaded"
            FPRINT FP_HDR, "#else"
            FPRINT FP_HDR, "    #define overloaded overloaded"
            FPRINT FP_HDR, "#endif"
            FPRINT FP_HDR, ""
        END IF

        IF ISFALSE UseCpp AND NO_PELLES = FALSE THEN
            FPRINT FP_HDR, "// *************************************************"
            FPRINT FP_HDR, "//                     Pelles C"
            FPRINT FP_HDR, "// *************************************************"
            FPRINT FP_HDR, ""
            FPRINT FP_HDR, "#if defined(__POCC__)"
            FPRINT FP_HDR, "    #include <intrin.h>"
            FPRINT FP_HDR, "    #pragma pack_stack(off)"

            IF WarningFlag = FALSE THEN
                FPRINT FP_HDR, "    #pragma warn(disable: 2006)    // Non-portable conversion int to const char*"
                FPRINT FP_HDR, "    #pragma warn(disable: 2007)    // Non-portable inline code"
                FPRINT FP_HDR, "    #pragma warn(disable: 2027)    // Missing prototype"
                FPRINT FP_HDR, "    #pragma warn(disable: 2073)    // Loss of precision float to int"
                FPRINT FP_HDR, "    #pragma warn(disable: 2115)    // Initialized but not used warnings"
                FPRINT FP_HDR, "    #pragma warn(disable: 2118)    // Unreferenced argument warnings"
                FPRINT FP_HDR, "    #pragma warn(disable: 2130)    // Usually flawed reporting"
                FPRINT FP_HDR, "    #pragma warn(disable: 2134)    // Possible infinite loop"
                FPRINT FP_HDR, "    #pragma warn(disable: 2154)    // Buggy unreachable code warning using sizeof"
                FPRINT FP_HDR, "    #pragma warn(disable: 2197)    // Unsigned long int not a std bit-field type"
                FPRINT FP_HDR, "    #pragma warn(disable: 2215)    // Conversion from type1 to type2 warnings"
                FPRINT FP_HDR, "    #pragma warn(disable: 2218)    // Unreferenced parameter"
                FPRINT FP_HDR, "    #pragma warn(disable: 2230)    // Incomplete struct declarations (vbs support)"
                FPRINT FP_HDR, "    #pragma warn(disable: 2232)    // Unable to check variable arguments"
                FPRINT FP_HDR, "    #pragma warn(disable: 2235)    // Not all control paths return a value"
                FPRINT FP_HDR, "    #pragma warn(disable: 2241)    // Function marked for deprecation"
                FPRINT FP_HDR, "    #pragma warn(disable: 2243)    // Use parentheses to clarify"
                FPRINT FP_HDR, "    #pragma warn(disable: 2248)    // Non-portable use of extension"
                FPRINT FP_HDR, "    #pragma warn(disable: 2251)    // Types with different signedness"
                FPRINT FP_HDR, "    #pragma warn(disable: 2804)    // Consider changing type to size_t warnings"
                FPRINT FP_HDR, "    #pragma warn(disable: 2805)    // Possible anti-aliasing violation warnings"
                FPRINT FP_HDR, "    #pragma warn(disable: 2808)    // Unsequenced assignment warnings"
                FPRINT FP_HDR, "    #pragma warn(disable: 2810)    // Potential realloc warnings"
                FPRINT FP_HDR, "    #pragma warn(disable: 2812)    // Attempt to read from non-readable location"
                FPRINT FP_HDR, "    #pragma warn(disable: 2813)    // Possible out-of-bounds warning (caused by CAST)"
            END IF

            FPRINT FP_HDR, "#endif"
            FPRINT FP_HDR, ""
        END IF
    END IF
END SUB ' Emit_CompilerDefines



SUB MakeFreeGlobals
    '********************************************************************************************
    ' This subroutine generates and injects code to free global dynamic variables.
    ' It writes SUB FreeGlobals procedure with statements to free each global dynamic variable.
    ' The loop iterates through the GlobalDynaStr$ array, decrementing the GlobalDynaCnt.
    ' Finally, it closes the procedure with an END SUB statement.
    '********************************************************************************************
    Src$ = "SUB FreeGlobals"
    PassOne = TRUE
    Inject(Src$)
    DO WHILE GlobalDynaCnt
        FPRINT FP_WRITE, SPC$, SPC$, GlobalDynaStr$[GlobalDynaCnt]
        DECR GlobalDynaCnt
    LOOP
    Src$ = "END SUB"
    PassOne = TRUE
    Inject(Src$)
END SUB ' MakeFreeGlobals




SUB ProcessSetCommand(GS)
    '*******************************************************************************
    ' This subroutine processes a "SET" command, generating the appropriate code
    ' for setting variables. It determines the context (CPP, global, or function)
    ' and handles variable declarations and initializations. The subroutine adjusts
    ' the source code by including necessary type information and handles special
    ' cases like strings. It injects the processed code into the output file and
    ' handles token substitutions and additional parsing.
    '*******************************************************************************
    DIM RAW VarCode AS VARCODE
    DIM RAW id
    DIM RAW ii
    DIM RAW iIsConst
    DIM RAW IsPointer
    DIM RAW iThisToken
    DIM RAW iFoundEqual
    DIM RAW SetString
    DIM RAW vt1
    DIM RAW szIsConst$
    DIM RAW LTmp$
    DIM RAW CVar$
    DIM RAW L_DimType$
    DIM RAW SaveFP  AS FILE

    VarCode.UseInLine = UseInLine
    VarCode.IsPtrFlag = 0
    SaveFP = FP_WRITE
    SetString = 0

    IF InNameSpace OR InClass THEN
        FP_WRITE = FP_UDT     ' CPP context
    ELSEIF InFunction = FALSE THEN
        FP_WRITE = FP_SET     ' Global context
    END IF

    IF INCHR(Src$, "$") AND TALLY(Src$, "[") >1 THEN
        Src$ = STRIM$(Src$)
        IREMOVE "as string" FROM Src$
        IREMOVE "as char"   FROM Src$
        Src$ += " AS char"
    END IF

    Src$ += "="
    PassOne = TRUE
    CALL XParse(Src$)
    CALL FixUps
    gszType$ = ""
    szIsConst$ = ""
    iThisToken = GetAsPosF(1, Ndx)
    IF iThisToken THEN
        Stk$[iThisToken++] = ""
        gszType$ = Stk$[iThisToken]
        IF iMatchWrd(gszType$, "const") THEN
            szIsConst$ = "const "
            Stk$[iThisToken++] = ""
            gszType$ = Stk$[iThisToken]
        END IF
        Stk$[iThisToken] = ""
    END IF

    IF ISNULL(gszType$) THEN
        gTmpStr$ = Stk$[2]
        SetString = DataType(gTmpStr$)
        VarCode.Methd% = mt_ProcessSetCommand
        VarCode.Token$ = gTmpStr$
        VarCode.VarNo% = SetString
        CALL GetVarCode(ADDRESSOF(VarCode), "set command")
        IF GS THEN
            FPRINT FP_WRITE, Scoot$, REMOVE$(VarCode.StaticOut$, "static "); ' Suppress CRLF
        ELSE
            FPRINT FP_WRITE, Scoot$, VarCode.StaticOut$; ' Suppress CRLF
        END IF

        LTmp$ = ""
        CVar$ = Clean$(Stk$[2])
        CALL ValidateVarName(CVar$)
        vt1 = DataType(Stk$[2])
        CALL BuildStr(3, Ndx, LTmp$)
        IF vt1 = vt_STRVAR AND NOTNULL(LTmp$) THEN
            LTmp$ += "[BCXSTRSIZE]"
        END IF
        IF InFunction = FALSE THEN
            CALL AddGlobal(CVar$, vt1, 0, LTmp$, 0, 0, 0, 1)
        ELSE
            CALL AddLocal(CVar$, vt1, 0, LTmp$, 0, 0, 1)
        END IF
    ELSE
        CVar$ = Clean$(Stk$[2])
        IF GS THEN
            FPRINT FP_WRITE, Scoot$, szIsConst$, gszType$, SPC$, CVar$; ' Suppress CRLF
        ELSE
            FPRINT FP_WRITE, Scoot$, "static ", szIsConst$, gszType$, SPC$, CVar$; ' Suppress CRLF
        END IF

        IF *szIsConst$ THEN iIsConst = 1 ELSE iIsConst = 0

        L_DimType$ = REMOVE$(gszType$, "*")
        CALL GetTypeInfo(gszType$, ADDRESSOF(IsPointer), &id, &vt1)

        IF vt1 = vt_STRVAR THEN
            L_DimType$ += "[BCXSTRSIZE]"
        END IF

        IF InFunction = FALSE THEN
            CALL AddGlobal(CVar$, vt1, id, L_DimType$, IsPointer, 0, 0, 1, iIsConst)
        ELSE
            CALL AddLocal(CVar$, vt1, id, L_DimType$, IsPointer, 0, 1, iIsConst)
        END IF
    END IF

    iThisToken = 2
    iFoundEqual = FALSE
    DO
        INCR iThisToken
        IF *Stk$[iThisToken] = ASC("=") THEN iFoundEqual = TRUE
        IF SetString = vt_STRVAR AND iFoundEqual THEN
            FPRINT FP_WRITE, "[BCXSTRSIZE]="; ' Suppress CRLF
        ELSE
            FPRINT FP_WRITE, Stk$[iThisToken]; ' Suppress CRLF
        END IF
        IF *Stk$[iThisToken] = ASC("=") THEN EXIT DO
        IF iThisToken = Ndx THEN EXIT DO
    LOOP

    FPRINT FP_WRITE, ""
    FPRINT FP_WRITE, "  {"

    DO WHILE NOT EOF(SourceFile)
        LINE INPUT SourceFile, Src$
        INCR LineNum[FileNdx]
        CALL StripCode(Src$)
        IF JoinLines(Src$) THEN ITERATE
        PassOne = TRUE
        CALL XParse(Src$)
        PassOne = FALSE
        IF iMatchWrd(Src$, "endset") THEN EXIT DO
        CALL TokenSubstitutions(2)
        IF *Src$ THEN
            FPRINT FP_WRITE, SPC$; ' Suppress CRLF
            FOR ii = 1 TO Ndx
                FPRINT FP_WRITE, Clean$(Stk$[ii]); ' Suppress CRLF
            NEXT
            FPRINT FP_WRITE, ""
        END IF
    LOOP
    FPRINT FP_WRITE, "};"
    FPRINT FP_WRITE, ""
    Src$ = ""
    FP_WRITE = SaveFP
END SUB ' ProcessSetCommand




SUB Emit_Optimize (Str1$, Str2$, Str3 = "" AS LPCTSTR)
    IF OptimizerEnabled THEN
        FPRINT FP_WRITE, "#if defined (__POCC__) && !defined(__cplusplus)"
        FPRINT FP_WRITE, "  #pragma optimize(", Str1$, ")", Str3$
        FPRINT FP_WRITE, "#elif !defined (__cplusplus)"
        FPRINT FP_WRITE, "  #pragma optimize(", Str2$, ")", Str3$
        FPRINT FP_WRITE, "#endif"
    END IF
END SUB ' Emit_Optimize





SUB EnableProject
    '*******************************************************************************************
    ' This subroutine enables a project by setting up necessary configurations and defines.
    ' It extracts the project main file name from the source code and command line arguments.
    ' The subroutine checks if the project has a path and extracts the file name and extension
    ' accordingly. It then prints a header define statement based on the project file name.
    '*******************************************************************************************
    DIM STATIC iWasHere
    IF iWasHere THEN EXIT SUB
    DIM RAW cHFn$
    INCR iWasHere
    Project_Main$ = TRIM$(REMOVE$(MID$(Src$, 9), DQ$))
    Project_Main$ = EXTRACT$(Project_Main$, "'")     ' allow comments
    Project_Main$ = EXTRACT$(Project_Main$, ".")
    Use_Project = TRUE
    IF INCHR(COMMAND$(1), "\") THEN ' has a path
        cHFn$ = MID$(COMMAND$(1), INSTRREV(COMMAND$(1), "\", 0) + 1)
    ELSE
        cHFn$ = COMMAND$(1)
    END IF
    IF INCHR(cHFn$, ".") THEN                        ' has an extension
        cHFn$ = MID$(cHFn$, 1, INSTRREV(cHFn$, ".", 0) -1)
    END IF
    FPRINT FP_HDR, "#define __BCX_HEADER_", UCASE$(cHFn$), "__"
END SUB ' EnableProject





FUNCTION SubVarType(TokenNum)
    '*****************************************************************************************
    ' This function determines the variable type based on the given token number.
    ' It checks if the variable is local, global, or unknown and adjusts the type accordingly.
    ' The function also ensures correct suffixes ($) for strings and (%) for integers.
    '*****************************************************************************************
    DIM RAW iVarType
    DIM RAW j = 0

    iVarType = CheckLocal(Stk$[TokenNum], ADDRESSOF(j))
    IF iVarType = vt_CHAR OR iVarType = vt_SCHAR THEN
        IF *LocalVars[j].VarDim$ <> ASC("[") AND LocalVars[j].VarPntr = 0 THEN
            iVarType = vt_INTEGER
        END IF
    ELSE
        IF iVarType = vt_UNKNOWN THEN
            iVarType = CheckGlobal(Stk$[TokenNum], ADDRESSOF(j))
            IF iVarType = vt_CHAR OR iVarType = vt_SCHAR THEN
                IF *GlobalVars[j].VarDim$ <> ASC("[") AND GlobalVars[j].VarPntr = 0 THEN
                    iVarType = vt_INTEGER
                END IF
            END IF
        END IF
    END IF

    j = ASC(RIGHT$(Stk$[TokenNum], 1))

    SELECT CASE iVarType

        CASE vt_STRVAR, vt_CHAR, vt_SCHAR
        IF j <> ASC("$") THEN
            Stk$[TokenNum] += "$"
        END IF

        CASE vt_INTEGER
        IF j <> ASC("%") THEN
            Stk$[TokenNum] += "%"
        END IF

        CASE vt_SINGLE
        IF j <> ASC("!") THEN
            Stk$[TokenNum] += "!"
        END IF

        CASE vt_DOUBLE
        IF j <> ASC("#") THEN
            Stk$[TokenNum] += "#"
        END IF

        CASE vt_LDOUBLE
        IF j <> ASC("`") THEN
            Stk$[TokenNum] += "`"
        END IF

    END SELECT
    RETURN iVarType
END FUNCTION ' SubVarType



FUNCTION PrintWriteFormat$ (DoWrite)
    '*********************************************************************************
    ' This function generates a printf format string and argument list for PRINT and
    ' WRITE statements based on the function argument. It analyses Stk$[] and builds
    ' the format string and argument list for the resulting printf statement.
    '*********************************************************************************
    DIM RAW Arg$
    DIM RAW Argcount
    DIM RAW Frmat$
    DIM RAW iThisToken
    DIM RAW iVarType
    DIM RAW LZZ$
    DIM RAW SuppressCRLF
    DIM RAW NextArgcount
    DIM RAW PWF_Cast$
    DIM RAW TmpClean$
    DIM RAW Stak[128] AS ARGTYPE
    DIM RAW x

    SuppressCRLF =  FALSE
    NextArgcount =  1
    Argcount     =  0
    Frmat$       =  ""
    Arg$         =  ""
    LZZ$         =  ""

    IF Stk$[Ndx] = ";" THEN
        SuppressCRLF = TRUE
        DECR Ndx
    END IF

    IF Ndx = 1 THEN GOTO PrintWriteLabel

    Stak[1].ArgType = (-1)
    iThisToken = 2

    '***********************************************************
    FOR INT i = 1 TO Ndx
        IF Stk$[i] = "(int)strlen" THEN Stk$[i] =  "strlen"
    NEXT
    '***********************************************************
    FOR INT i = 2 TO Ndx
        IF Im_UDT_String (Stk$[i]) THEN Stk$[i] += "$"
        IF Im_UDT_Single (Stk$[i]) THEN Stk$[i] += "!"
        IF Im_UDT_Double (Stk$[i]) THEN Stk$[i] += "#"
    NEXT
    '***********************************************************
    FOR INT i = 2 TO Ndx
        x = CheckType (Stk$[i])
        SELECT CASE x
            CASE vt_STRVAR, vt_PCHAR, vt_CHARPTR
            Stk$[i] += "$"

            CASE vt_SINGLE
            Stk$[i] += "!"

            CASE vt_DOUBLE
            Stk$[i] += "#"

            CASE vt_LDOUBLE
            Stk$[i] += "`"
        END SELECT
    NEXT
    '***********************************************************
    DIM RAW Testing$, Dot

    FOR INT i = 2 TO Ndx
        Testing$ = SPC$ + Clean$(Stk$[i]) + "$" + SPC$
        Dot = iMatchNQ (Stk$[i], ".")
        IF Dot THEN Testing$ = SPC$ + MID$(Testing$, Dot + 2)
        IF INSTR (FuncStrNames$, Testing$) THEN  ' Look for STRINGS
            IF NOT INCHR(Stk$[i], "$") THEN Stk$[i] += "$"
        END IF
    NEXT

    FOR INT i = 2 TO Ndx
        Testing$ = SPC$ + Clean$(Stk$[i]) + "!" + SPC$
        Dot = iMatchNQ (Stk$[i], ".")
        IF Dot THEN Testing$ = SPC$ + MID$(Testing$, Dot + 2)
        IF INSTR (FuncSglNames$, Testing$) THEN  ' Look for SINGLES
            IF NOT INCHR(Stk$[i], "!") THEN  Stk$[i] += "!"
        END IF
    NEXT

    FOR INT i = 2 TO Ndx
        Testing$ = SPC$ + Clean$(Stk$[i]) + "#" + SPC$
        Dot = iMatchNQ (Stk$[i], ".")
        IF Dot THEN Testing$ = SPC$ + MID$(Testing$, Dot + 2)
        IF INSTR (FuncDblNames$, Testing$) THEN  ' Look for DOUBLES
            IF NOT INCHR(Stk$[i], "#") THEN  Stk$[i] += "#"
        END IF
    NEXT

    '*********************************************************************************
    '                               End of Transforms
    '*********************************************************************************

    DO WHILE iThisToken <= Ndx
        TmpClean$ = Clean$(Stk$[iThisToken])
        IF TmpClean$ <> "BCX_DynaCallA" AND TmpClean$ <> "BCX_DynaCallB" THEN
            iVarType = SubVarType(iThisToken)
            IF Stak[NextArgcount].ArgType = (-1) THEN
                SELECT CASE iVarType
                    CASE vt_CHAR, vt_SCHAR, vt_STRVAR, vt_INTEGER, vt_SINGLE, vt_DOUBLE, vt_LDOUBLE
                    Stak[NextArgcount].ArgType = iVarType
                END SELECT
            END IF

            IF *Stk$[iThisToken] = ASC("(") THEN
                DIM RAW iCnt = 0
                DO
                    IF *Stk$[iThisToken] = ASC("(") THEN INCR iCnt
                    IF *Stk$[iThisToken] = ASC(")") THEN DECR iCnt
                    Arg$ += Stk$[iThisToken]
                    INCR iThisToken
                LOOP UNTIL iCnt <= 0 OR iThisToken >= Ndx
            END IF

            IF *Stk$[iThisToken] = ASC("[") THEN
                DIM RAW iCnt = 0
                DO
                    IF *Stk$[iThisToken] = ASC("[") THEN INCR iCnt
                    IF *Stk$[iThisToken] = ASC("]") THEN DECR iCnt
                    Arg$ += Stk$[iThisToken]
                    INCR iThisToken
                    IF *Stk$[iThisToken] = ASC("[") AND iCnt = 0 THEN ITERATE
                LOOP UNTIL iCnt <= 0 OR iThisToken >= Ndx
            END IF

            IF *Stk$[iThisToken] = ASC(";")    _
                OR *Stk$[iThisToken] = ASC(",") _
                OR *Stk$[iThisToken] = ASC("&") THEN
                INCR Argcount
                INCR NextArgcount
                Stak[Argcount].Arg$ = Arg$
                Stak[NextArgcount].ArgType = (-1)
                Arg$ = ""
                INCR iThisToken
            ELSE
                Arg$ += Stk$[iThisToken]
                INCR iThisToken
            END IF
        ELSE
            Arg$ += Stk$[iThisToken]
            INCR iThisToken
        END IF
    LOOP

    INCR Argcount
    INCR NextArgcount
    Stak[Argcount].Arg$ = Arg$
    Arg$ = ""

    FOR iThisToken = 1 TO Argcount

        iVarType = Stak[iThisToken].ArgType
        IF iVarType = (-1) THEN
            LZZ$ = EXTRACT$ (Stak[iThisToken].Arg$, "(")
            iVarType = DataType(LZZ$)
        END IF

        IF iVarType = vt_INTEGER THEN
            DIM RAW A, indx
            A = CheckLocal (LZZ$, ADDRESSOF(indx))

            IF A = vt_UNKNOWN THEN
                A = CheckGlobal (LZZ$, ADDRESSOF(indx))
                IF A <> vt_UNKNOWN THEN
                    iVarType = GlobalVars[indx].VarType
                END IF
            ELSE
                iVarType = LocalVars[indx].VarType
            END IF

        END IF

        SELECT CASE iVarType

            CASE vt_STRLIT, vt_STRVAR, vt_CHAR, vt_SCHAR
            IF DoWrite THEN
                Frmat$ += "\\" + DQ$ + "%s" + "\\" + DQ$ + ","
            ELSE
                Frmat$ += "%s"
            END IF
            IF LEFTSTR(LZZ$, "BCX_DynaCall") THEN
                Arg$ += ",(char*)" + Stak[iThisToken].Arg$
            ELSE
                Arg$ += "," + Stak[iThisToken].Arg$
            END IF

            '*******************************************************************************************
            CASE vt_DOUBLE, vt_NUMBER, vt_INTEGER, vt_DECFUNC     ' MrBcx 817  added: vt_INTEGER, vt_DECFUNC
            IF DoWrite THEN
                Frmat$ += "%.15G ,"
            ELSE
                Frmat$ += "% .15G "
            END IF
            Arg$ += ",(double)" + Stak[iThisToken].Arg$
            '*******************************************************************************************

            CASE vt_LLONG
            IF DoWrite THEN
                Frmat$ += "%lli,"
            ELSE
                Frmat$ += "% lli"
            END IF
            Arg$ += ",(long long)" + Stak[iThisToken].Arg$

            CASE vt_ULONGLONG
            IF DoWrite THEN
                Frmat$ += "%llu,"
            ELSE
                Frmat$ += "% llu"
            END IF
            Arg$ += ",(unsigned long long)" + Stak[iThisToken].Arg$

            CASE vt_SINGLE
            IF DoWrite THEN
                Frmat$ += "%.7G,"
            ELSE
                Frmat$ += "% .7G"
            END IF
            Arg$ += ",(float)" + Stak[iThisToken].Arg$


            CASE vt_LDOUBLE
            IF DoWrite THEN
                Frmat$ += "%.19LG,"
            ELSE
                Frmat$ += "% .19LG"
            END IF
            Use_Ldouble = TRUE
            Arg$ += ",(LDOUBLE)" + Stak[iThisToken].Arg$

            CASE ELSE

            IF ASC(Stak[iThisToken].Arg$) = ASC("(") THEN
                LZZ$ = ""
                Arg$ += ","

                DO
                    DIM RAW iParentheses = INCHR(Stak[iThisToken].Arg$, ")")
                    PWF_Cast$ = MID$(Stak[iThisToken].Arg$, 1, iParentheses++)
                    Stak[iThisToken].Arg$ = TRIM$(MID$(Stak[iThisToken].Arg$, iParentheses))

                    IREPLACE "char*"      WITH  "char *"             IN PWF_Cast$
                    IREPLACE "lpstr"      WITH  "char *"             IN PWF_Cast$
                    IREPLACE "integer"    WITH  "int"                IN PWF_Cast$
                    IREPLACE "single"     WITH  "float"              IN PWF_Cast$
                    IREPLACE "ldouble"    WITH  "LDOUBLE"            IN PWF_Cast$
                    IREPLACE "ulonglong"  WITH  "unsigned long long" IN PWF_Cast$
                    IREPLACE "longlong"   WITH  "long long"          IN PWF_Cast$
                    IREPLACE "llong"      WITH  "long long"          IN PWF_Cast$
                    IREPLACE "long long"  WITH  "long long"          IN PWF_Cast$

                    IF ISNULL(LZZ$) THEN
                        IF iMatchNQ("(char *)(int)(float)(double)(LDOUBLE)(long long)(unsigned long long)", PWF_Cast$) THEN
                            LZZ$ = PWF_Cast$
                        ELSE
                            LZZ$ = "(double)"
                            PWF_Cast$ = LZZ$ + PWF_Cast$
                        END IF
                        RemoveAll(LZZ$, "()")
                        IREPLACE "char *"             WITH "%s"       IN  LZZ$
                        IREPLACE "int"                WITH "% d "     IN  LZZ$
                        IREPLACE "float"              WITH "% .7G "   IN  LZZ$
                        IREPLACE "ldouble"            WITH "% .19LG " IN  LZZ$
                        IREPLACE "double"             WITH "% .15G "  IN  LZZ$
                        IREPLACE "long long"          WITH "% lli "   IN  LZZ$
                        IREPLACE "unsigned long long" WITH "% llu "   IN  LZZ$
                    END IF

                    Arg$ += PWF_Cast$
                LOOP WHILE ASC(Stak[iThisToken].Arg$) = c_LPar

                Arg$ += Stak[iThisToken].Arg$
                Frmat$ += LZZ$

                IF DoWrite THEN Frmat$ += ","
            ELSE
                IF DoWrite THEN
                    Frmat$ += "%G,"
                ELSE
                    Frmat$ += "% G"
                    Arg$ += ",(float)" + Stak[iThisToken].Arg$
                END IF
            END IF

        END SELECT
    NEXT

    IF DoWrite THEN Frmat$ = LEFT$(Frmat$, LEN(Frmat$)-1)

    '*********************
    PrintWriteLabel:
    '*********************

    IF SuppressCRLF = FALSE THEN
        Frmat$ += "\\n"
    END IF
    RETURN "printf(" + ENC$(Frmat$) + Clean$(Arg$) + ");"
END FUNCTION ' PrintWriteFormat$





SUB InputBufferFlags
    '*********************************************************************
    ' Called by
    '   "finput" - Emit_FileInputCode - InputBufferFlags
    '   "input"  - Emit_InputCode     - CommonInputCode  - InputBufferFlags
    '*********************************************************************
    IF NOT Use_Inputbuffer THEN
        Use_Inputbuffer = TRUE
        Use_BcxTempStr  = TRUE
        Use_Scan        = TRUE
        Use_Proto       = TRUE
        Use_Split       = TRUE
        Use_Replace     = TRUE
        Use_Remove      = TRUE
        Use_Mid         = TRUE
        Use_Left        = TRUE
        Use_Instr       = TRUE
        Use_Stristr     = TRUE
        Use_UCaseTbl    = TRUE
    END IF
END SUB ' InputBufferFlags




SUB CommonInputCode (Frmat$, Arg$)
    '**************************************************************************************
    ' This SUB generates code for common input operations based on the provided arguments.
    ' It constructs the format string and argument list for input operations such as scanf.
    ' The subroutine handles various data types and formats them appropriately for input.
    '**************************************************************************************
    DIM RAW Argcount = 0
    DIM RAW iThisToken
    DIM RAW iVarType
    DIM RAW szParamToken$
    DIM RAW Stak$[128]  : CLEAR(Stak$)  ' Silence Gcc/Clang missing-braces warning

    CALL InputBufferFlags

    Arg$   = ""
    Frmat$ = ""
    iThisToken = 1

    DO WHILE iThisToken <= Ndx
        IF Stk$[iThisToken] = "," THEN
            INCR Argcount
            Stak$[Argcount]= Arg$
            Arg$ = ""
            INCR iThisToken
        ELSE
            Arg$ += Stk$[iThisToken]
            INCR iThisToken
            IF iThisToken < Ndx THEN
                DIM RAW iCnt = TALLY(Arg$, "[") - TALLY(Arg$, "]")
                DO WHILE iCnt
                    Arg$ += Stk$[iThisToken]
                    INCR iThisToken
                    iCnt = TALLY(Arg$, "[") - TALLY(Arg$, "]")
                LOOP
            END IF
        END IF
    LOOP

    INCR Argcount
    Stak$[Argcount] = Arg$
    Arg$ = ""

    FPRINT FP_WRITE, Scoot$; ' Suppress CRLF

    FOR iThisToken = 1 TO Argcount
        szParamToken$ = Stak$[iThisToken]
        iVarType = CheckType(szParamToken$)

        IF iVarType = vt_UDT OR iVarType = vt_STRUCT OR iVarType = vt_UNION THEN
            iVarType = DataType(szParamToken$)
        ELSE
            DIM RAW iCnt = INCHR(szParamToken$, "[")
            IF iCnt THEN *(--iCnt+szParamToken) = 0
            iVarType = DataType(szParamToken$)
        END IF

        szParamToken$ = Clean$(Stak$[iThisToken])

        IF Im_UDT_String(szParamToken$) THEN iVarType = vt_STRVAR
        IF Im_UDT_Single(szParamToken$) THEN iVarType = vt_SINGLE
        IF Im_UDT_Double(szParamToken$) THEN iVarType = vt_DOUBLE

        DIM x
        FOR INT i = 2 TO Ndx
            x = CheckType (szParamToken$)
            SELECT CASE x
                CASE vt_STRVAR  : iVarType = vt_STRVAR
                CASE vt_PCHAR   : iVarType = vt_STRVAR
                CASE vt_LPSTR   : iVarType = vt_STRVAR
                CASE vt_CHARPTR : iVarType = vt_STRVAR
                CASE vt_SINGLE  : iVarType = vt_SINGLE
                CASE vt_DOUBLE  : iVarType = vt_DOUBLE
                CASE vt_LDOUBLE : iVarType = vt_LDOUBLE
            END SELECT
        NEXT


        SELECT CASE iVarType
            CASE vt_STRVAR
            Frmat$ += "%s"
            Arg$ += "," + szParamToken$
            FPRINT FP_WRITE, "*", TRIM$(szParamToken$), "=0, "; ' Suppress CRLF

            CASE vt_INTEGER
            Frmat$ += "%d"
            Arg$ += ",&" + szParamToken$
            FPRINT FP_WRITE, szParamToken$, "=0, "; ' Suppress CRLF

            CASE vt_SINGLE
            Frmat$ += "%g"
            Arg$ += ",&" + szParamToken$
            FPRINT FP_WRITE, szParamToken$, "=0, "; ' Suppress CRLF

            CASE vt_DOUBLE
            Frmat$ += "%lG"
            Arg$ += ",&" + szParamToken$
            FPRINT FP_WRITE, szParamToken$, "=0, "; ' Suppress CRLF

            CASE vt_LDOUBLE
            Frmat$ += "%lG"
            Arg$ += ",&" + szParamToken$
            FPRINT FP_WRITE, szParamToken$, "=0, "; ' Suppress CRLF

            CASE ELSE
            Frmat$ += "%d"
            Arg$ += ",&" + szParamToken$
            FPRINT FP_WRITE, szParamToken$, "=0, "; ' Suppress CRLF

        END SELECT

    NEXT
END SUB ' CommonInputCode




SUB Emit_InputCode
    '*********************************************************************************************
    ' This SUB emits code for input operations, such as reading input from the keyboard.
    ' It builds the format string and argument list for scanf-like input operations based on the
    ' provided arguments. It handles various data types and formats them appropriately for input.
    '*********************************************************************************************
    DIM RAW Frmat$
    DIM RAW Arg$
    DIM RAW szWrk$
    DIM RAW TestType
    DIM RAW iThisToken = 2

    IF DataType(Stk$[iThisToken]) = vt_STRLIT THEN
        IF Stk$[iThisToken+1] = "," THEN
            FPRINT FP_WRITE, Scoot$, "printf(", Clean$(Stk$[iThisToken]), "), "; ' Suppress CRLF
            '                         ^^^ this is for:   "prompt" comma var               MrBcx 819
        ELSE
            FPRINT FP_WRITE, Scoot$, "printf(", ENC$("%s? "), ",", Clean$(Stk$[iThisToken]), "), "; ' Suppress CRLF
            '                         ^^^  this is for:  "prompt" semicolon  var          MrBcx 819
        END IF
        iThisToken = 4
    END IF

    FOR INT i = 1 TO Ndx
        IF Im_UDT_String(Stk$[i]) THEN Stk$[i] += "$"
        IF Im_UDT_Single(Stk$[i]) THEN Stk$[i] += "!"
        IF Im_UDT_Double(Stk$[i]) THEN Stk$[i] += "#"

        TestType = CheckType (Stk$[i])

        IF TestType = vt_STRVAR THEN Stk$[i] += "$"
        IF TestType = vt_SINGLE THEN Stk$[i] += "!"
        IF TestType = vt_DOUBLE THEN Stk$[i] += "#"
        IF TestType = vt_LDOUBLE THEN Stk$[i] += "#"
    NEXT

    CALL BuildStr(iThisToken, Ndx, szWrk$)
    FastLexer(szWrk$, "", ",")
    CALL CommonInputCode(Frmat$, Arg$)

    Use_KBinput = Use_Scan = TRUE
    FPRINT FP_WRITE, Scoot$, "KBinput(),"; ' Suppress CRLF
    FPRINT FP_WRITE, Scoot$, "ScanError=scan(InputBuffer,", ENC$(Frmat$), Arg$, ");"
END SUB ' Emit_InputCode




SUB Emit_FileInputCode
    '*******************************************************************************
    ' This SUB emits code for file input operations, such as reading from a file.
    ' It builds the format string and argument list for scanf-like input operations
    ' based on the contents found in the Stk$[] array. It handles various data types
    ' and formats them appropriately for input from the file.
    '*******************************************************************************
    DIM Arg$
    DIM Frmat$
    DIM szWrk$
    DIM iThisToken
    DIM FHandle$

    CALL InputBufferFlags

    FOR INT Tmp = 2 TO Ndx
        IF *Stk$[Tmp] = ASC("#") THEN REMOVE "#" FROM Stk$[Tmp]
    NEXT
    IF DataType (Stk$[2])= vt_NUMBER THEN
        Stk$[2] = "FP" + Stk$[2]
    END IF

    iThisToken = 4                                                     ' Extract the file handle
    FOR j AS INT = 2 TO Ndx
        IF *Stk$[j] = ASC(",") THEN
            iThisToken = j+1
            EXIT FOR
        END IF
        FHandle$ += Stk$[j]
    NEXT

    FOR INT i = 1 TO Ndx
        IF Im_UDT_String (Stk$[i]) THEN Stk$[i] += "$"
        IF Im_UDT_Single (Stk$[i]) THEN Stk$[i] += "!"
        IF Im_UDT_Double (Stk$[i]) THEN Stk$[i] += "#"

        IF CheckType (Stk$[i]) = vt_STRVAR THEN Stk$[i] += "$"
        IF CheckType (Stk$[i]) = vt_SINGLE THEN Stk$[i] += "!"
        IF CheckType (Stk$[i]) = vt_DOUBLE THEN Stk$[i] += "#"
        IF CheckType (Stk$[i]) = vt_LDOUBLE THEN Stk$[i] += "#"
    NEXT

    CALL BuildStr (iThisToken, Ndx, szWrk$) ' build the variable list
    FastLexer (szWrk$, "", ",")
    CALL CommonInputCode (Frmat$, Arg$)

    FPRINT FP_WRITE, "fgets(InputBuffer, 0x100000, ", FHandle$, ");"
    FPRINT FP_WRITE, Scoot$, "InputBuffer[strcspn(InputBuffer, ", ENC$("\\r\\n"), ")] = 0;"
    FPRINT FP_WRITE, Scoot$, "ScanError = scan(InputBuffer,", ENC$(Frmat$), Arg$, ");"
    FPRINT FP_WRITE, Scoot$, "*InputBuffer=0;"
END SUB ' Emit_FileInputCode




SUB FinishingTouches
    IF Use_Project = FALSE THEN
        DIM  Accum= Use_BCXMDialog
        INCR Accum, Use_BCXDialog
        INCR Accum, Use_Form
        INCR Accum, Use_Button
        INCR Accum, Use_BmpButton
        INCR Accum, Use_Edit
        INCR Accum, Use_BCX_Input
        INCR Accum, Use_Label
        INCR Accum, Use_Group
        INCR Accum, Use_Checkbox
        INCR Accum, Use_Radio
        INCR Accum, Use_Combobox
        INCR Accum, Use_Listbox
        INCR Accum, Use_Treeview
        INCR Accum, Use_Blackrect
        INCR Accum, Use_Whiterect
        INCR Accum, Use_Grayrect
        INCR Accum, Use_Datepick
        INCR Accum, Use_Richedit
        INCR Accum, Use_Bitmap
        INCR Accum, Use_BCX_OlePicture
        INCR Accum, Use_Icon
        INCR Accum, Use_Listview
        INCR Accum, Use_BCX_Control
        INCR Accum, Use_ProgressBar
        INCR Accum, Use_BCX_Slider
        INCR Accum, Use_BCX_Splitter
        INCR Accum, Use_BCX_Tab
        INCR Accum, Use_BCX_Toolbar
        INCR Accum, Use_BCX_UpDown
        INCR Accum, Use_Set_BCX_Icon
        INCR Accum, Use_BCX_FrameWnd
        INCR Accum, Use_BCX_Wnd
        INCR Accum, Use_BCX_SetIcon
        INCR Accum, Use_BCX_SetIconSm
        INCR Accum, Use_BCX_SetCursor
        INCR Accum, Use_BCX_RegWnd
        INCR Accum, Use_BCX_InitGUI
        IF Accum THEN
            CALL AddBCX_hInstance
            CALL AddFontVariables
        END IF
    END IF
END SUB




SUB AssembleParts
    '**********************************************************************************************
    ' This SUB assembles various parts of the processed code into a single file. It processes the
    ' C/C++ prolog, command-line defines, constants, directives, UDTs, and global variables.  It
    ' It includes any user C/C++ code, translated SUBS and FUNCTIONS, and main program output.
    ' It performs the necessary file operations and writes the assembled code to the output file.
    '**********************************************************************************************
    DIM RAW LTmp1$
    DIM P1$, P2$, P3$, P4$, P5$, P6$, P7$, P8$

    DoCountLines = TRUE

    CALL FinishingTouches

    IF EXIST("$WRK$.TXT") THEN KILL "$WRK$.TXT"
    RENAME FileOut$, "$WRK$.TXT"

    IF ISNULL(CmdLineFileOut$) THEN
        IF UseCpp THEN
            gTmpStr$ = EXTRACT$(FileOut$, ".") + ".cpp"
            KILL gTmpStr$
            FileOut$ = gTmpStr$
        ELSE
            gTmpStr$ = EXTRACT$(FileOut$, ".") + ".c"
            KILL gTmpStr$
            FileOut$ = gTmpStr$
        END IF
    END IF

    OPEN FileOut$ FOR OUTPUT AS FP_W
    CALL Emit_Prolog(FP_W)
    CALL Commandline_Defines(FP_W)
    CALL System_Defined_Constants(FP_W)
    CALL User_Defined_Constants(FP_W)
    CALL Emit_UserDirectives(FP_W)
    CALL User_Global_Enum_Blocks(FP_W)

    IF Use_Project = FALSE THEN
        IF Use_SingleFile = FALSE THEN
            OPEN HFile$ FOR OUTPUT AS FP_HeaderFile
        END IF
    END IF

    '*********************************************************************************************
    CALL StdProtos(FP_W)                       ' MrBcx  - I swapped the order to enable the
    CALL User_Defined_Types_And_Unions(FP_W)   ' use of BASIC runtime library inside a C++ CLASS.
    '*********************************************************************************************

    CALL System_Vars(FP_W)

    IF Use_COM THEN
        Emit_COM_SupportTypes(FP_W)
    END IF

    CALL User_Global_Variables(FP_W)
    CALL User_Data_Statements(FP_W)
    CALL AddMacros(FP_W)
    CALL User_Prototypes(FP_W)
    CALL User_Global_Initialized_Arrays(FP_W)
    CALL User_Overloaded_SubsFunctions(FP_W)
    CALL User_Global_Set_Statements(FP_W)

    IF Use_SingleFile = FALSE THEN
        CLOSE FP_HeaderFile
    END IF

    IF Use_SingleFile = TRUE AND Use_Project = FALSE THEN
        CALL RunTimeFunctions(FP_W)
    ELSE
        IF Use_Project = FALSE THEN
            CALL SetFlags      ' Write to Project$
        END IF
    END IF

    '***************************************************************
    DIM RAW bMain = (Use_Wingui + MakeDLL + NoMain) AS BOOL
    DIM RAW bMainOut = FALSE  AS BOOL
    '***************************************************************

    IF LOF(cppFile$) THEN
        FPRINT FP_W, ""
        FPRINT FP_W, "// *************************************************"
        FPRINT FP_W, "//                   User's C code"
        FPRINT FP_W, "// *************************************************"
        FPRINT FP_W, ""

        OPEN cppFile$ FOR INPUT AS FP_R

        DO WHILE NOT EOF(FP_R)
            LINE INPUT FP_R, LTmp1$
            FPRINT FP_W, LTmp1$
        LOOP

        CLOSE FP_R
    END IF


    IF EXIST(prcFile$) AND LOF(prcFile$)>2 THEN
        FPRINT FP_W, "// *************************************************"
        FPRINT FP_W, "//            User's Subs and Functions"
        FPRINT FP_W, "// *************************************************"
        FPRINT FP_W, ""

        '***************************************************
        IF UseCpp THEN
            P1$ = CHR$(99, 111, 117, 116, 60, 60)                   '   "cout<<"
            P2$ = CHR$(99, 111, 117, 116, 32, 60, 60, 32)           '   "cout << "
            P3$ = CHR$(99, 105, 110, 60, 60)                        '   "cin<<"
            P4$ = CHR$(99, 105, 110, 32, 60, 60, 32)                '   "cin << "
            P5$ = CHR$(60, 60, 115, 116, 100, 58, 58)               '   "<<std::"
            P6$ = CHR$(32, 60, 60, 32, 115, 116, 100, 58, 58)       '   " << std::"
            P7$ = CHR$(60, 60, 101, 110, 100, 108)                  '   "<<endl"
            P8$ = CHR$(32, 60, 60, 32, 101, 110, 100, 108)          '   " << endl"
        END IF
        '***************************************************

        OPEN prcFile$ FOR INPUT AS FP_R       ' translated subs and functions

        DO WHILE NOT EOF(FP_R)
            LINE INPUT FP_R, LTmp1$
            '***************************************************
            ' Simple patch to support Unicode Lexer (ULEX.exe)
            '***************************************************
            IF UseCpp THEN
                REPLACE P1$ WITH P2$ IN LTmp1$
                REPLACE P3$ WITH P4$ IN LTmp1$
                REPLACE P5$ WITH P6$ IN LTmp1$
                REPLACE P7$ WITH P8$ IN LTmp1$
            END IF
            '***************************************************
            FPRINT FP_W, LTmp1$
            IF bMainOut THEN ITERATE
            bMainOut = CheckForMain(LTmp1$, bMain)
        LOOP
        CLOSE FP_R
    END IF

    IF Use_Wingui = FALSE AND NoMain = FALSE THEN
        FPRINT FP_W, ""
        FPRINT FP_W, "// *************************************************"
        FPRINT FP_W, "//                  ", BCX_STR_MAIN_PROG$
        FPRINT FP_W, "// *************************************************"
        FPRINT FP_W, ""
    END IF

    OPEN "$WRK$.TXT" FOR INPUT AS FP_R

    DO WHILE NOT EOF(FP_R)
        LINE INPUT FP_R, LTmp1$
        IF iMatchNQ (LTmp1$, "int main") THEN
            IF bMain THEN
                ITERATE
            END IF
        END IF
        FPRINT FP_W, Scoot$, LTmp1$
        IF bMainOut THEN ITERATE
        bMainOut = CheckForMain(LTmp1$, bMain)
    LOOP

    CLOSE FP_R
    KILL "$WRK$.TXT"

    CLOSE FP_W
    DoCountLines = FALSE
END SUB ' AssembleParts




FUNCTION CheckForMain (ArgStr$, bMain AS BOOL)
    '***********************************************************************************
    ' This function checks if ArgStr$ contains the keyword "main" and performs specific
    ' actions if it does. It handles these cases:
    '
    '      int main ...
    '      int WINAPI WinMain  ...
    '      __declspec(dllexport) BOOL WINAPI DllMain  ...
    '      __stdcall*DllMain*(HINSTANCE *,* ...
    '
    ' Depending on the context, it emits certain code related to console handling,
    ' startup and exit code, case tables, DLL declarations, etc.  The function returns
    ' a boolean value indicating whether the main program output has been handled.
    '***********************************************************************************
    DIM RAW bMainOut = FALSE
    DIM RAW LTmp1$
    DIM RAW LZZ$

    IF iMatchNQ (ArgStr$, "main") THEN
        LZZ$ = LTRIM$(ArgStr$)
        Scoot$ = SPACE$(2)

        IF LEFTSTR(LZZ$, "int main") _
            OR LEFTSTR(LZZ$, "int WINAPI WinMain") _
            OR LEFTSTR(LZZ$, "__declspec(dllexport) BOOL WINAPI DllMain") _
            OR LIKE (LZZ$, "*__stdcall*DllMain*(HINSTANCE *,*") THEN

            IF bMain = FALSE THEN
                FPRINT FP_W, "{"        ' OPEN the main FUNCTION
            END IF

            IF bMain THEN
                LINE INPUT FP_R, LTmp1$
                FPRINT FP_W, LTmp1$
            END IF

            IF Use_Console THEN
                FPRINT FP_W, Scoot$, "hConsole=GetStdHandle(STD_OUTPUT_HANDLE);"
            END IF

            IF Use_StartupCode THEN
                FPRINT FP_W, Scoot$, "int BCX_SUCode=BCX_StartupCode_();  // execute user's startup code"
            END IF

            IF Use_ExitCode THEN
                FPRINT FP_W, Scoot$, "int BCX_EXCode=BCX_ExitCode_();     // Prepare for user's exit code"
            END IF

            IF Use_LCaseTbl THEN
                FPRINT FP_W, Scoot$, "LowCase = MakeLCaseTbl();"          ' 828 MrBcx changed - calloc was unnecessary
            END IF

            IF Use_UCaseTbl THEN
                FPRINT FP_W, Scoot$, "UprCase = MakeUCaseTbl();"          ' 828 MrBcx changed - calloc was unnecessary
            END IF

            IF DllCnt THEN
                LOCAL szLoadLibHandle$
                LOCAL LTmp$
                LOCAL i

                FPRINT FP_W, Scoot$, ""
                FPRINT FP_W, Scoot$, "// **********[ DLL Declarations ]**********"
                FPRINT FP_W, Scoot$, ""

                ' ------------------------------------------------------------------------
                ' Emit LoadLibrary assignments
                ' HMODULE  H_DLLNAME = LoadLibrary("DLLNAME.DLL");
                ' Todo: Add a check for H_DLLNAME = NULL in case of failure to load the DLL.
                ' ------------------------------------------------------------------------

                IF Use_LoadLibraryError THEN
                    FPRINT FP_W, Scoot$, "FILE   *FPLoadLibraryErrorLog;"
                    DIM RAW Op$
                    Op$ = ENC$("w")
                    IF UseFileTest THEN
                        FPRINT FP_W, Scoot$, "if((FPLoadLibraryErrorLog=fopen(", LibraryErrorLog$, ", ", Op$, "))==0)"
                        FPRINT FP_W, Scoot$, " {"
                        LTmp$ = ENC$("Error: Cannot Access File or File Not Found. %s\\n")
                        FPRINT FP_W, Scoot$, "fprintf(stderr, ", LTmp$, ", ", LibraryErrorLog$, "); exit(1);"
                        FPRINT FP_W, Scoot$, " }"
                    ELSE
                        FPRINT FP_W, Scoot$, "FPLoadLibraryErrorLog = fopen(", ENC$(LibraryErrorLog$), ", ", Op$, ");"
                    END IF
                END IF

                LTmp$ = ENC$("[%s %s] Failed to load %s\\n")

                FOR i = 1 TO LoadLibsCnt
                    szLoadLibHandle$ = "H_" + UCASE$(RemoveExtension$(Loadlibs$[i]))

                    IF (INCHR(szLoadLibHandle$, "-")) OR (INCHR(szLoadLibHandle$, ".")) THEN
                        szLoadLibHandle$ = REPLACE$(szLoadLibHandle$, "-.", "_")
                        szLoadLibHandle$ = REPLACE$(szLoadLibHandle$, "-", "_")
                    END IF

                    FPRINT FP_W, Scoot$, "HMODULE  ", szLoadLibHandle$, " = LoadLibrary(", ENC$(Loadlibs$[i]), ");"

                    IF Use_LoadLibraryError THEN
                        FPRINT FP_W, Scoot$, "if(", szLoadLibHandle$, "==NULL) {"
                        FPRINT FP_W, Scoot$, "  fprintf(FPLoadLibraryErrorLog, ", LTmp$, ", date(), timef(0,0), ", ENC$(Loadlibs$[i]), ");"
                        FPRINT FP_W, Scoot$, "  }"
                    END IF
                NEXT

                LTmp$ = ENC$("[%s %s] Failed to find process %s\\n")

                FOR i = 1 TO DllCnt
                    FPRINT FP_W, Scoot$, DllDecl$[i]    ' Emit the user's DLL Declarations
                    IF Use_LoadLibraryError THEN
                        DIM RAW iEQ
                        DIM RAW szProcAddress$
                        iEQ = INCHR(DllDecl$[i], "=")-1
                        szProcAddress$ = LEFT$(DllDecl$[i], iEQ)
                        FPRINT FP_W, Scoot$, "if(", szProcAddress$, "==NULL) {"
                        FPRINT FP_W, Scoot$, "  fprintf(FPLoadLibraryErrorLog, ", LTmp$, ",date(),timef(0,0),", ENC$(szProcAddress$), ");"
                        FPRINT FP_W, Scoot$, "  }"
                    END IF
                NEXT

                IF Use_LoadLibraryError THEN
                    FPRINT FP_W, Scoot$, "fclose(FPLoadLibraryErrorLog);"
                END IF

                FPRINT FP_W, Scoot$, ""
                FPRINT FP_W, Scoot$, "// ****************************************"
                FPRINT FP_W, Scoot$, ""
            END IF
            bMainOut = TRUE
        END IF
    END IF
    RETURN bMainOut
END FUNCTION  ' CheckForMain



FUNCTION RemoveExtension(f AS STRING) AS STRING
    '****************************************************************************
    ' This function removes the file extension from a given filename string.
    ' It searches for the last occurrence of the dot (".") character and returns
    ' the substring of the filename before that dot.
    ' If no dot is found, it returns the original filename.
    '****************************************************************************
    DIM i AS INTEGER
    DIM RAW dotPosition AS INTEGER
    dotPosition = INCHR(f$, ".")
    IF dotPosition THEN
        i = INSTRREV(f$, ".", 0) - 1
    ELSE
        i = LEN(f$)
    END IF
    RETURN LEFT$(f$, i)
END FUNCTION



FUNCTION CheckGlobal(szVariable$, BYREF varidx)
    '************************************************************************
    ' This function checks if a global variable exists and returns its type.
    '************************************************************************
    DIM RAW iHasValue AS ULONGLONG
    DIM RAW iTokenLoc
    DIM RAW szTemp$
    DIM RAW iBrack

    szTemp$ = szVariable$
    RemoveAll(szTemp$, "%$#!@`&*( )", 1)
    iBrack = INCHR(szTemp$, "[")
    IF iBrack THEN *(--iBrack + szTemp) = 0  ' This cleverly trims (everything) starting at the first "["
    iHasValue = HashNumber(szTemp$)
    DO WHILE GlobalVarHash[iHasValue]
        iTokenLoc = GlobalVarHash[iHasValue]
        IF szTemp$ = GlobalVars[iTokenLoc].VarName$ THEN
            varidx = iTokenLoc
            RETURN GlobalVars[iTokenLoc].VarType
        END IF
        INCR iHasValue
        iHasValue = IMOD(iHasValue, MaxGlobalVars)
    LOOP
    RETURN vt_UNKNOWN
END FUNCTION ' CheckGlobal



FUNCTION CheckLocal(szVariable$, BYREF varidx)
    '***********************************************************************
    ' This function checks if a local variable exists and returns its type.
    '***********************************************************************
    DIM RAW szTemp$
    DIM RAW iBrack
    DIM RAW iTokenLoc

    IF LocalVarCnt THEN
        szTemp$ = szVariable$
        RemoveAll(szTemp$, "%$#!@`&*( )", 1)
        iBrack = INCHR(szTemp$, "[")
        IF iBrack THEN *(--iBrack + szTemp) = 0
        FOR iTokenLoc = LocalVarCnt TO 1 STEP -1
            IF szTemp$ = LocalVars[iTokenLoc].VarName$ THEN
                varidx = iTokenLoc
                RETURN LocalVars[iTokenLoc].VarType
            END IF
        NEXT
    END IF
    RETURN vt_UNKNOWN
END FUNCTION ' CheckLocal



FUNCTION CheckType(ParamStr$)
    '******************************************************
    ' This function checks the type of its string argument.
    '******************************************************
    DIM RAW Keyword$
    DIM RAW varid
    DIM RAW i

    Keyword$ = TRIM$(LCASE$(ParamStr$))
    i = FindWord (Keyword$, tTypes, WordsInTable(tTypes))
    IF i <> NOTFOUND THEN RETURN tTypes[i].iType
    i = CheckLocal(ParamStr$, ADDRESSOF(varid))
    IF i = vt_UNKNOWN THEN
        i = CheckGlobal(ParamStr$, ADDRESSOF(varid))
        IF i = vt_UNKNOWN THEN
            i = CheckTypeDefs(ParamStr$)
            IF i THEN i = TypeDefs[i].TypeofDef
        END IF
    END IF
    RETURN i
END FUNCTION ' CheckType



SUB ExportStringConst
    DIM RAW FP_SAVE AS FILE
    FP_SAVE = FP_CST
    FP_CST  = FP_SYSCST
    Src$ = "MACRO BCXSTRSIZE=" + STR$ (BCXSTRINGS)
    PassOne = TRUE
    Inject(Src$)
    FP_CST = FP_SAVE
END SUB



SUB ExportInternalConst
    IF Use_FillArray THEN
        DIM RAW FP_SAVE AS FILE
        FP_SAVE = FP_CST
        FP_CST = FP_SYSCST
        Src$ = "MACRO vt_INTEGER =  2"
        PassOne = TRUE
        Inject(Src$)
        Src$ = "MACRO vt_SINGLE  =  3"
        PassOne = TRUE
        Inject(Src$)
        Src$ = "MACRO vt_DOUBLE  =  4"
        PassOne = TRUE
        Inject(Src$)
        Src$ = "MACRO vt_LDOUBLE =  5"
        PassOne = TRUE
        Inject(Src$)
        FP_CST = FP_SAVE
    END IF
END SUB ' ExportInternalConst



FUNCTION RestrictedWords(ParamStr$ AS STRING) AS INTEGER
    SELECT CASE ParamStr$
        CASE "CmdLine", "CmdShow", "hInst", "hPrev", "hWnd", "lParam", "Msg", _
        "wParam", "vt_INTEGER", "vt_SINGLE", "vt_DOUBLE", "vt_LDOUBLE"
        RETURN 1
        CASE ELSE
        RETURN 0
    END SELECT
END FUNCTION




FUNCTION DataType(ParamStr AS STRING)
    '*********************************************************************
    ' The purpose of the DataType function is to determine and return
    ' the data type of a given string (ParamStr). It identifies various
    ' types such as string literals, variables, numbers, and specific
    ' type indicators (e.g., integer, single, double) by examining the
    ' string's content and attributes. If no specific type is matched,
    ' it defaults to returning vt_UNKNOWN.
    '*********************************************************************
    DIM RAW Keyword$
    DIM RAW i

    IF ParamStr[0] = c_DblQt THEN
        RETURN vt_STRLIT
    END IF

    IF INCHR(ParamStr$, "$") THEN
        RETURN vt_STRVAR
    END IF

    IF IsDecimalNumber(ParamStr$) THEN
        RETURN vt_NUMBER
    END IF

    i = CheckTypeDefs(ParamStr$)
    IF i THEN
        RETURN TypeDefs[i].TypeofDef
    END IF

    '****************
    '   Functions
    '****************

    Keyword$ = LCASE$(ParamStr$)
    i = FindWord(Keyword$, tBcxWords, WordsInTable(tBcxWords))
    IF i <> NOTFOUND THEN RETURN tBcxWords[i].iType

    IF INCHR(ParamStr$, "%") THEN
        RETURN vt_INTEGER
    END IF

    IF INCHR(ParamStr$, "!") THEN
        RETURN vt_SINGLE
    END IF

    IF INCHR(ParamStr$, "#") THEN
        RETURN vt_DOUBLE
    END IF

    IF INCHR(ParamStr$, "^") THEN
        RETURN vt_DOUBLE
    END IF

    IF INCHR(ParamStr$, "`") THEN
        RETURN vt_LDOUBLE
    END IF

    IF iMatchRgt(ParamStr$, "@") THEN
        RETURN vt_FILEPTR
    END IF

    IF INCHR(ParamStr$, SPC$) THEN
        RETURN vt_UDT
    END IF

    IF iMatchLft(ParamStr$, "_") THEN
        RETURN vt_INTEGER
    END IF

    IF isalpha(ParamStr[0]) THEN
        RETURN vt_INTEGER
    END IF

    IF CAST(UINT, ParamStr[0]) > 127 THEN
        RETURN vt_INTEGER
    END IF

    RETURN vt_UNKNOWN
END FUNCTION ' DataType



SUB CloseAll
    IF PPDLL_HANDLE THEN
        FreeLibrary(PPDLL_HANDLE)
        PPDLL_HANDLE = NULL
        PPProc = NULL
    END IF
    CLOSE ' Flush and Close all open files
END SUB   ' CloseAll






SUB RemoveAll (Haystack$, Needles AS LPCTSTR, qtflag = 0)
    '*************************************************************************
    ' This SUB removes all occurrences of specified characters from a string.
    ' If qtflag is set to 1, it ignores characters inside double quotes.
    '*************************************************************************
    DIM RAW C   = Haystack AS PCHAR
    DIM RAW pmc = NULL     AS PCHAR
    DO WHILE NOTNULL(Haystack$)
        IF qtflag THEN                   ' qtflag = 1 means ignore anything in quotes
            IF *Haystack = c_DblQt THEN
                *(C++) = *Haystack
                DO WHILE *(++Haystack) <> c_DblQt
                    *(C++) = *Haystack
                    IF ISNULL(Haystack$) THEN EXIT SUB
                LOOP
                *(C++) = *(Haystack++)
                ITERATE
            END IF
        END IF
        pmc = CAST(PCHAR, Needles)
        DO WHILE *pmc
            IF *(pmc++) = *Haystack THEN GOTO SKIP
        LOOP
        *(C++) = *Haystack

        SKIP:
        INCR Haystack
    LOOP
    *C = 0
END SUB



SUB Warning_ID (iWarning, WarnLvl = 0)
    SELECT CASE iWarning
        CASE eExitingMoreThan1Loop
        CALL Warning("Exiting more than one loop", WarnLvl)
    END SELECT
END SUB  ' Warning_ID



SUB Warning (ParmStr$, WarnLvl = 0)
    LOCAL fErr AS FILE
    IF WarnLvl THEN
        WarnMsg$ += " Line" + STR$(LineNum[FileNdx]) + " in Module: " +  TRIM$(FileNames$[FileNdx]) + " - " + ParmStr$
    ELSE
        WarnMsg$ += ParmStr$
    END IF
    WarnMsg$ += CRLF$ + CRLF$
    IF ErrFile THEN
        OPEN FileErr$ FOR APPEND AS fErr
        FPRINT fErr, "WARNING ", ParmStr$
        CLOSE fErr
    END IF
END SUB ' Warnings




FUNCTION HashNumber(Str2Hash$) AS ULONGLONG
    '******************************************************
    ' This function generates a hash number from a string.
    ' Daniel J. Bernstein designed the DJB2 algorithm.
    ' MrBcx modified it to return 64-bit ULONGLONG values
    ' which -should- produce fewer collisions than DJB2
    '******************************************************
    DIM StrgPtr AS PCHAR
    DIM c AS UCHAR
    DIM hash AS ULONGLONG
    hash = 5381ULL        ' Use 64-bit literal
    StrgPtr = Str2Hash
    WHILE *StrgPtr
        c = *StrgPtr
        hash = ((hash SHL 5) + hash) + c
        StrgPtr++
    WEND
    RETURN CAST(ULONGLONG, IMOD(hash, MaxGlobalVars))
END FUNCTION



SUB AddLibrary (LibName$)
    '*******************************************************
    ' This SUB adds a C/C++ library to a list of libraries
    '*******************************************************
    DIM STATIC nTimes
    LOCAL nLibNdx
    LOCAL TempLibName$

    TempLibName$ = LCASE$(LibName$)

    IF NOT INCHR(TempLibName$, DQ$) AND NOT INCHR(TempLibName$, "<") THEN
        TempLibName$ = ENC$(TempLibName$, 60, 62)
    END IF

    IF nTimes = 0 THEN
        FOR INT i = 0 TO MaxLib - 1
            Library$[i] = ""
        NEXT
        INCR nTimes
        Library$[0] = TempLibName$
        EXIT SUB
    END IF

    nLibNdx = 0
    DO WHILE NOTNULL(Library$[nLibNdx])
        IF Library$[nLibNdx] = TempLibName$ THEN EXIT SUB
        INCR nLibNdx
    LOOP

    IF nLibNdx < MaxLib - 1 THEN
        Library$[nLibNdx] = TempLibName$
    ELSE
        CALL Abort("Max libraries exceeded. Currently MaxLib set to" + STR$(MaxLib))
    END IF
END SUB ' AddLibrary





SUB RemoveLibrary (LibName$)
    '*************************************************************
    ' This SUB removes a C/C++ library from the list of libraries
    '*************************************************************
    IF NOT INSTR (RmLibs$, LibName$, 1, 1) THEN
        RmLibs$ += "," + LCASE$(LibName$)
    END IF
END SUB ' RemoveLibrary





SUB Emit_Libs
    '***********************************************
    ' This SUB emits codes that instructs the
    ' linker to search for object/import libraries.
    '***********************************************
    DIM STATIC IWasHere  ' Must remain static
    DIM STATIC nCount    ' Must remain static
    LOCAL  LTmp$

    IF IWasHere THEN EXIT SUB
    INCR IWasHere
    IF Library$[0] = "" THEN EXIT SUB

    IF NO_LIBS = FALSE THEN
        XFOR INT i = 0 WHILE i < MaxLib AND NOTNULL(Library[i]) BY i++
            LTmp$ = Library$[i]
            RemoveAll(LTmp$, "<>" + DQ$)
            IF INSTR(RmLibs$, LTmp$) THEN ITERATE ' skip libraries that have been removed
            IF nCount = 0 THEN
                INCR nCount
                FPRINT FP_HDR, ""
                FPRINT FP_HDR, "// *************************************************"
                FPRINT FP_HDR, "// Instruct Linker to Search Object/Import Libraries"
                FPRINT FP_HDR, "// *************************************************"
                FPRINT FP_HDR, ""
                FPRINT FP_HDR, "#if !defined(__GNUC__) && !defined(__TINYC__)"
                FPRINT FP_HDR, "   #if !(defined(__BCPLUSPLUS__) && defined(_WIN64))"
                IF ISFALSE UseCpp THEN
                    FPRINT FP_HDR, "      #if !defined(__LCC__)"
                END IF
            END IF
            FPRINT FP_HDR, "    #pragma comment(lib,", ENC$(LTmp$), ")"
        XNEXT

        IF ISFALSE UseCpp THEN
            FPRINT FP_HDR, "  #else"
            '***************************************************************************************
            ' add lccwin32's default libraries to the remove library list, so they won't be emitted
            '***************************************************************************************
            RmLibs$ += ",<libc.lib>,<kernel32.lib>,<comdlg32.lib>,<user32.lib>,"
            RmLibs$ += "<gdi32.lib>,<advapi32.lib>,<comctl32.lib>,<crtdll.lib>,<Msimg32.lib>"

            XFOR INT i = 0 WHILE i < MaxLib AND NOTNULL(Library[i]) BY i++
                IF INSTR(RmLibs$, Library$[i]) THEN ITERATE ' skip libraries that have been removed
                IF nCount = 0 THEN
                    INCR nCount
                    FPRINT FP_HDR, "  #if !defined(__LCC__)"
                END IF
                FPRINT FP_HDR, "    #pragma lib ", Library$[i]
            XNEXT
        END IF

        IF NOTZERO (nCount) THEN
            IF ISFALSE UseCpp THEN
                FPRINT FP_HDR, "     #endif"
            END IF
            FPRINT FP_HDR, "  #endif"
            FPRINT FP_HDR, "#endif"
        END IF
    END IF
END SUB ' Emit_Libs





SUB AddGlobal(GlobalName$, GlobalType, GlobalDef = 0, GlobalDim$ = "", GlobalPtr = 0, GlobalFS = 0, GlobalExtn = 0, iEmitted = 0, iConst = 0)
    '***************************************************************************************************
    ' This sub adds a global variable with its details such as name, type, definition, dimensions, etc.
    '***************************************************************************************************
    DIM RAW FirstVar$
    DIM RAW SecondVar$
    DIM RAW Warn$
    DIM RAW GlobalNameHash AS ULONGLONG
    DIM RAW ptGlobal AS VARINFO PTR
    DIM RAW s

    IF Use_Project = TRUE THEN
        IF GlobalExtn = 0 THEN
            GlobalExtn = 2
        END IF
    END IF

    IF RestrictedWords(GlobalName$) AND TestState THEN
        Warn$ = "Restricted Word " + GlobalName$ + " on Line"
        Warn$ += STR$(LineNum[FileNdx]) + " in Module: " + TRIM$(FileNames$[FileNdx])
        CALL Warning(Warn$)
    END IF

    GlobalNameHash = HashNumber(GlobalName$)

    DO WHILE GlobalVarHash[GlobalNameHash]
        s = GlobalVarHash[GlobalNameHash]
        ptGlobal = ADDRESSOF(GlobalVars[s])
        IF GlobalName$ = ptGlobal->VarName$ THEN
            IF InConditional = 0 OR (InConditional > 0 AND InIfDef$ = ptGlobal->VarCondDef$) THEN
                IF ptGlobal->VarType <> GlobalType OR _
                    GlobalDim$ <> ptGlobal->VarDim$ OR _
                    ptGlobal->VarDef <> GlobalDef THEN

                    FirstVar$  = ""
                    FirstVar$ += "Line" + STR$(LineNum[FileNdx]) + " in Module: "
                    FirstVar$ += TRIM$(FileNames$[FileNdx]) + " : " + GlobalName$
                    FirstVar$ += GlobalDim$ + " as " + GetVarTypeName$(GlobalType)
                    FirstVar$ += SPC$ + TypeDefs[GlobalDef].VarName$

                    SecondVar$  = ""
                    SecondVar$ += "Line" + STR$(ptGlobal->VarLine) + " in Module: "
                    SecondVar$ += ptGlobal->VarModule$ + " : " + GlobalName$
                    SecondVar$ += ptGlobal->VarDim$ + " as " + GetVarTypeName$(ptGlobal->VarType)
                    SecondVar$ += SPC$ + TypeDefs[ptGlobal->VarDef].VarName$

                    Warn$ = "Two Variables " + FirstVar$ + " previously defined at " + SecondVar$
                    CALL Warning(Warn$)
                END IF
                EXIT SUB
            END IF
        END IF
        GlobalNameHash = IMOD(GlobalNameHash + 1, MaxGlobalVars)
    LOOP

    INCR GlobalVarCnt

    IF GlobalVarCnt = MaxGlobalVars THEN
        CALL Abort("Maximum Global Variables reached.")
    END IF

    ptGlobal = ADDRESSOF(GlobalVars[GlobalVarCnt])
    ptGlobal->VarName$     =  GlobalName$
    ptGlobal->VarType      =  GlobalType
    ptGlobal->VarDef       =  GlobalDef
    ptGlobal->VarDim$      =  GlobalDim$
    ptGlobal->VarLine      =  LineNum[FileNdx]
    ptGlobal->VarPntr      =  GlobalPtr
    ptGlobal->VarSF        =  GlobalFS
    ptGlobal->VarEmitFlag  =  iEmitted
    ptGlobal->VarModule$   =  TRIM$(FileNames$[FileNdx])
    ptGlobal->VarExtn      =  GlobalExtn
    ptGlobal->VarCondLevel =  InConditional
    ptGlobal->VarConstant  =  iConst
    ptGlobal->VarCondDef$  =  InIfDef$
    GlobalVarHash[GlobalNameHash] = GlobalVarCnt
END SUB ' AddGlobal




SUB AddLocal(LocalName$, LocalType, LocalDef = 0, LocalDim$ = "", LocalPtr = 0, LocalFS = 0, iEmitted = 0, iConst = 0)
    '***************************************************************************************************
    ' This sub adds a LOCAL variable with its details such as name, type, definition, dimensions, etc.
    '***************************************************************************************************
    DIM RAW varid = 0
    DIM RAW FirstVar$
    DIM RAW SecondVar$
    DIM RAW Warn$
    DIM RAW s

    IF LocalVarCnt AND TestState THEN
        IF CheckGlobal(LocalName$, ADDRESSOF(varid)) <> vt_UNKNOWN THEN

            IF LocalDef THEN
                FirstVar$  = ""
                FirstVar$ += "Line" + STR$(LineNum[FileNdx])
                FirstVar$ += " in Module: " + TRIM$(FileNames$[FileNdx])
                FirstVar$ += " : " + LocalName$ + LocalDim$ + " as "
                FirstVar$ += TypeDefs[LocalDef].VarName$
            ELSE
                FirstVar$ = ""
                FirstVar$ += "Line" + STR$(LineNum[FileNdx])
                FirstVar$ += " in Module: " + TRIM$(FileNames$[FileNdx])
                FirstVar$ += " : " + LocalName$ + LocalDim$ + " as "
                FirstVar$ += GetVarTypeName$(LocalType)
            END IF

            IF GlobalVars[varid].VarDef THEN
                SecondVar$ = ""
                SecondVar$ +=      "Line" + STR$(GlobalVars[varid].VarLine)
                SecondVar$ += " in Module: " + GlobalVars[varid].VarModule$
                SecondVar$ += " : " + LocalName$ + GlobalVars[varid].VarDim$
                SecondVar$ +=  " as " + TypeDefs[GlobalVars[varid].VarDef].VarName$
            ELSE
                SecondVar$ = ""
                SecondVar$ +=   "Line" + STR$(GlobalVars[varid].VarLine)
                SecondVar$ +=  " in Module: " + GlobalVars[varid].VarModule$
                SecondVar$ +=  " : " + LocalName$ + GlobalVars[varid].VarDim$
                SecondVar$ +=   " as " + GetVarTypeName$(GlobalVars[varid].VarType)
            END IF
            Warn$ = "Local Variable " + FirstVar$ + CRLF$ + "Has Same Name as Global " + SecondVar$
            CALL Warning(Warn$)
        END IF

        FOR s = 1 TO LocalVarCnt
            IF LocalName$ = LocalVars[s].VarName$ THEN
                IF LocalVars[s].VarType <> LocalType         _
                    OR LocalDim$ <> LocalVars[s].VarDim$      _
                    OR LocalVars[s].VarDef <> LocalDef THEN

                    FirstVar$  = ""
                    FirstVar$ += "Line" + STR$(LineNum[FileNdx])
                    FirstVar$ += " in Module: " + TRIM$(FileNames$[FileNdx])
                    FirstVar$ += " : " + LocalName$ + LocalDim$ + " as "
                    FirstVar$ += GetVarTypeName$(LocalType) + SPC$
                    FirstVar$ += TypeDefs[LocalDef].VarName$

                    SecondVar$  = ""
                    SecondVar$ += "Line" + STR$(LocalVars[s].VarLine) + " in Module: "
                    SecondVar$ += LocalVars[s].VarModule$ + " : " + LocalName$
                    SecondVar$ += LocalVars[s].VarDim$ + " as "
                    SecondVar$ += GetVarTypeName$(LocalVars[s].VarType) + SPC$
                    SecondVar$ += TypeDefs[LocalVars[s].VarDef].VarName$

                    Warn$ = "Two Variables " + FirstVar$ + " previously defined at " + SecondVar$
                    CALL Warning(Warn$)
                END IF
                EXIT SUB
            END IF
        NEXT
    END IF

    INCR LocalVarCnt

    IF LocalVarCnt = MaxLocalVars THEN
        Warn$ = "Maximum Local Variables reached."
        CALL Abort(Warn$)
    END IF

    LocalVars[LocalVarCnt].VarName$     =  LocalName$
    LocalVars[LocalVarCnt].VarType      =  LocalType
    LocalVars[LocalVarCnt].VarDef       =  LocalDef
    LocalVars[LocalVarCnt].VarDim$      =  LocalDim$
    LocalVars[LocalVarCnt].VarLine      =  LineNum[FileNdx]
    LocalVars[LocalVarCnt].VarPntr      =  LocalPtr
    LocalVars[LocalVarCnt].VarSF        =  LocalFS
    LocalVars[LocalVarCnt].VarEmitFlag  =  iEmitted
    LocalVars[LocalVarCnt].VarConstant  =  iConst
    LocalVars[LocalVarCnt].VarModule$   =  TRIM$(FileNames$[FileNdx])
END SUB ' AddLocal




FUNCTION IsDecimalNumber (szNumber AS STRING) AS BOOLEAN
    '******************************************************************
    '            Updated and renamed in 8.2.6 by MrBcx
    ' This function checks if the string argument is a valid DECIMAL
    ' or SCIENTIFIC NOTATION number according to my detection rules.
    '******************************************************************
    DIM i AS INTEGER
    DIM HasDigit AS INTEGER
    DIM HasE AS INTEGER
    DIM HasMinus AS INTEGER
    DIM HasPlus AS INTEGER
    DIM HasDecimal AS INTEGER
    DIM digitAfterE AS BOOLEAN
    DIM prevWasE AS BOOLEAN

    IF ISNULL(szNumber) THEN RETURN FALSE         ' Handle null argument
    IF INSTR(szNumber, SPC$) THEN RETURN FALSE    ' No SPACES allowed

    '***********************************************************
    ' Rules for this function
    '   Can only have these characters: -+.0123456789eELl
    '   Must have at least 1 digit
    '   Only 1 "E" or "e" (case insensitive)
    '   No more than 2 plus signs, cannot end in a plus sign
    '   No more than 2 minus signs, cannot end in a minus sign
    '   No more than 1 decimal point
    '
    ' Rules of scientific notation:
    '   The base is always 10
    '   The exponent is a non-zero integer
    '   The coefficient carries the sign (+ or -)
    '   The mantissa carries the significant digits
    '***********************************************************

    ' Check for leading + or -
    IF szNumber[0] = 43 THEN      ' +
        INCR HasPlus
        INCR i
    ELSEIF szNumber[0] = 45 THEN  ' -
        INCR HasMinus
        INCR i
    END IF

    DO WHILE szNumber[i]    ' Check for valid characters
        IF szNumber[i] >= 48 AND szNumber[i] <= 57 THEN  '  0 to 9
            INCR HasDigit
            IF HasE > 0 THEN
                digitAfterE = TRUE
            END IF
            prevWasE = FALSE

        ELSEIF szNumber[i] = 46 THEN  ' .
            INCR HasDecimal
            IF HasDecimal > 1 OR HasE > 0 THEN RETURN FALSE  ' Only one decimal point allowed, none after E
            prevWasE = FALSE

        ELSEIF szNumber[i] = 69 OR szNumber[i] = 101 THEN  ' E or e
            INCR HasE
            IF HasE > 1 OR HasDigit = 0 THEN RETURN FALSE  ' Only one E allowed, must have digits before E
            prevWasE = TRUE

        ELSEIF szNumber[i] = 43 THEN  ' +
            INCR HasPlus
            ' Plus sign is only valid at the start (already checked) or right after E
            IF NOT prevWasE AND i > 0 THEN RETURN FALSE
            IF HasPlus > 2 THEN RETURN FALSE
            prevWasE = FALSE

        ELSEIF szNumber[i] = 45 THEN  ' -
            INCR HasMinus
            ' Minus sign is only valid at the start (already checked) or right after E
            IF NOT prevWasE AND i > 0 THEN RETURN FALSE
            IF HasMinus > 2 THEN RETURN FALSE
            prevWasE = FALSE

        ELSEIF (szNumber[i] = 76 OR szNumber[i] = 108) AND szNumber[i+1] = 0 THEN  ' L or l at the end and
            prevWasE = FALSE                                                       ' can only be the final char
        ELSE
            RETURN FALSE                          ' found an invalid character
        END IF

        INCR i
    LOOP

    IF i = 0 THEN RETURN FALSE                    ' No characters found

    DECR i                                        ' Move index to the final character
    '                                             ' Check final character
    IF szNumber[i] = 43 OR szNumber[i] = 45 THEN  ' + or -
        RETURN FALSE                              ' Cannot end with + or -
    END IF

    ' Final validation
    IF HasDigit = 0 THEN RETURN FALSE                  ' Must have at least one digit
    IF HasE > 0 AND NOT digitAfterE THEN RETURN FALSE  ' Must have digits after E

    RETURN TRUE
END FUNCTION ' IsDecimalNumber




FUNCTION IsHexNumber(szArg$) AS BOOLEAN        ' 821  MrBcx replaced the previous version
    '***************************************************************************************
    ' Purpose: Validates if a string represents a valid hexadecimal number
    ' Input:   szArg$ - String to validate
    ' Returns: TRUE if string is a valid hex number (0x... or &h... format), FALSE otherwise
    '***************************************************************************************
    IF ISNULL(szArg$) THEN EXIT FUNCTION       ' Handle null argument   - 826 MrBcx
    IF INSTR(szArg$, SPC$) THEN EXIT FUNCTION  ' No SPACES allowed      - 826 MrBcx

    IF LEN(szArg$) < 3 THEN
        RETURN  FALSE
    END IF

    DIM inputStr AS STRING
    inputStr = LCASE$(szArg$)

    ' Check for hex number prefix
    DIM prefix$
    prefix$ = LEFT$(inputStr, 2)

    IF prefix$ <> "0x" AND prefix$ <> "&h" THEN
        RETURN  FALSE
    END IF

    ' Remove prefix for validation
    DIM hexDigits$
    hexDigits$ = MID$(inputStr, 3)

    ' Validate each character is a valid hex digit

    FOR INT i = 1 TO LEN(hexDigits$)
        DIM currentChar$
        currentChar = MID$(hexDigits$, i, 1)

        ' Check if character is 0-9 or a-f
        IF NOT ((currentChar$ >= "0" AND currentChar$ <= "9") OR _
            (currentChar$ >= "a" AND currentChar$ <= "f")) THEN
            RETURN FALSE
        END IF
    NEXT
    RETURN TRUE  ' If we get here, validation passed
END FUNCTION



SUB StripTabs
    '****************************************************
    ' This SUB removes tabs from the global "Src" string,
    ' except when the tabs are inside double quotes.
    '****************************************************
    DIM RAW pszSrc AS PCHAR
    DIM RAW iQuoteFlag
    pszSrc = Src
    iQuoteFlag = 0
    DO WHILE *pszSrc
        IF *pszSrc = c_DblQt THEN iQuoteFlag = iQuoteFlag XOR 1
        IF *pszSrc = 9 AND NOT iQuoteFlag THEN *pszSrc = 32
        INCR pszSrc
    LOOP
END SUB



SUB PushFileIO
    '********************************************************************
    ' This SUB saves the current source file pointer by pushing
    ' it onto a stack (FPtr) and increments the stack index (FPtrNdx).
    '********************************************************************
    FPtr[++FPtrNdx] = SourceFile
END SUB




SUB PopFileIO
    '********************************************************************
    ' This SUB restores the most recently saved source file pointer from
    ' the stack, if the stack is not empty, updates the line count, and
    ' decrements the stack index (FPtrNdx).
    '********************************************************************
    IF FPtrNdx > 0 THEN
        CLOSE SourceFile
        INCR LinesRead, LineNum[FileNdx--]
        SourceFile = FPtr[FPtrNdx--]
    END IF
END SUB



SUB VerifyMatchedPairs
    '********************************************************************
    ' This function ensures that all parentheses, square brackets, and
    ' double quotes in the input string are properly matched, aborting
    ' execution with an error message if they are not.
    '********************************************************************
    DIM RAW CountR : CountR = 0             ' Round  bracket counter
    DIM RAW CountS : CountS = 0             ' Square bracket counter
    DIM RAW DoCount AS BOOL  : DoCount = TRUE
    DIM RAW pszSrc  AS PCHAR : pszSrc  = Src

    DO WHILE *pszSrc
        IF *pszSrc = c_DblQt THEN
            DoCount = NOT DoCount
        END IF
        IF DoCount THEN
            SELECT CASE *pszSrc
                CASE c_LPar  : INCR CountR
                CASE c_RPar  : DECR CountR
                CASE c_LtBkt : INCR CountS
                CASE c_RtBkt : DECR CountS
            END SELECT
        END IF
        INCR pszSrc
    LOOP
    IF NOT DoCount THEN CALL Abort ("Unmatched Quotes")
    IF CountS THEN CALL Abort ("Unmatched []")
    IF CountR THEN CALL Abort ("Unmatched ()")
END SUB ' VerifyMatchedPairs



SUB ClearIfThenStacks
    '****************************************************
    ' This SUB clears the SrcStk$ stack up to a maximum
    ' defined limit (cMaxSingleLineIFLines) and resets
    ' the source count index (SrcCnt) to zero.
    '****************************************************
    LOCAL i AS LONG
    WHILE *SrcStk$[i] AND i < cMaxSingleLineIFLines
        SrcStk$[i++] = ""
    WEND
    SrcCnt = 0
END SUB



SUB AddExpressionToStack(szAssembledExpression$)
    IF SrcCnt = cMaxSingleLineIFLines-1 THEN
        CALL Abort("Single line conversion to multi-line stack exceeds limit.")
    END IF
    SrcStk$[++SrcCnt] = szAssembledExpression$      ' Assemble our expression
END SUB



SUB Add2SplitLines(szSplitLine$)
    IF SplitCnt = cMaxSplitLines-1 THEN
        CALL Abort("Maximum line splitting exceeded.")
    END IF
    SplitStk$[++SplitCnt] = szSplitLine$
END SUB





SUB PostProcess
    '*************************************************
    ' This subroutine performs post-processing tasks
    ' such as shell commands and string replacements.
    '*************************************************
    IF ReDirect = TRUE THEN
        DIM RAW LTmp1$
        OPEN FileOut$ FOR INPUT AS FP1
        DO WHILE NOT EOF(FP1)
            LINE INPUT FP1, LTmp1$
            PRINT LTmp1$
        LOOP
        CALL CloseAll
    END IF
    '**************************
    FileOutCopy$ = FileOut$
    FileOutCopy$ = EXTRACT$(FileOutCopy$, ".")

    FOR INT A = 1 TO EntryCnt
        Cmd$ = REMOVE$(Entry$[A], DQ$)
        REPLACE BKSLASH4$     WITH BKSLASH2$    IN Cmd$
        IREPLACE "$FILE$"     WITH FileOutCopy$ IN Cmd$
        IREPLACE "$PELLES$\\" WITH PELLESPATH$  IN Cmd$
        IREPLACE "$PELLES$"   WITH PELLESPATH$  IN Cmd$
        IREPLACE "$LCC$\\"    WITH LCCPATH$     IN Cmd$
        IREPLACE "$LCC$"      WITH LCCPATH$     IN Cmd$
        IREPLACE "$BCX$\\"    WITH BCXPATH$     IN Cmd$
        IREPLACE "$BCX$"      WITH BCXPATH$     IN Cmd$
        PRINT "Shelling Out To:", Cmd$
        SHELL Cmd$
    NEXT

    IF NOTNULL(Compiler$) THEN
        Compiler$ = TRIM$(REMOVE$(Compiler$, DQ$))
        IF INCHR(Compiler$, SPC$) THEN
            Compiler$ = ENC$(EXTRACT$(Compiler$, SPC$)) + SPC$ + REMAIN$(Compiler$, SPC$)
        ELSE
            Compiler$ = ENC$(Compiler$)
        END IF
        REPLACE BKSLASH4$     WITH BKSLASH2$    IN Compiler$
        IREPLACE "$FILE$"     WITH FileOutCopy$ IN Compiler$
        IREPLACE "$PELLES$\\" WITH PELLESPATH$  IN Compiler$
        IREPLACE "$PELLES$"   WITH PELLESPATH$  IN Compiler$
        IREPLACE "$LCC$\\"    WITH LCCPATH$     IN Compiler$
        IREPLACE "$LCC$"      WITH LCCPATH$     IN Compiler$
        REPLACE DDQ$          WITH DQ$          IN Compiler$
        PRINT "Shelling Out To:", Compiler$
        SHELL Compiler$
    END IF
    '**************************
    IF NOTNULL(ResCompiler$) THEN
        ResCompiler$ = ENC$(ResCompiler$)
        ResCompiler$ += SPC$ + Res_File$
        IREPLACE "$PELLES$\\" WITH PELLESPATH$  IN ResCompiler$
        IREPLACE "$PELLES$"   WITH PELLESPATH$  IN ResCompiler$
        IREPLACE "$LCC$\\"    WITH LCCPATH$     IN ResCompiler$
        IREPLACE "$LCC$"      WITH LCCPATH$     IN ResCompiler$
        IREPLACE "$FILE$"     WITH FileOutCopy$ IN ResCompiler$
        REPLACE BKSLASH4$     WITH BKSLASH2$    IN ResCompiler$
        REPLACE DDQ$          WITH DQ$          IN ResCompiler$
        PRINT "Shelling Out To:", ResCompiler$
        SHELL ResCompiler$
    END IF
    '**************************
    IF NOTNULL(Linker$) THEN
        Linker$ = TRIM$(REMOVE$(Linker$, DQ$))
        IF INCHR(Linker$, SPC$) THEN
            Linker$ = DQ$ + EXTRACT$(Linker$, SPC$) + DQ$ + SPC$ + REMAIN$(Linker$, SPC$)
        ELSE
            Linker$ = ENC$(Linker$)
        END IF
        IREPLACE "$PELLES$\\" WITH PELLESPATH$  IN Linker$
        IREPLACE "$PELLES$"   WITH PELLESPATH$  IN Linker$
        IREPLACE "$LCC$\\"    WITH LCCPATH$     IN Linker$
        IREPLACE "$LCC$"      WITH LCCPATH$     IN Linker$
        IREPLACE "$FILE$"     WITH FileOutCopy$ IN Linker$
        REPLACE   BKSLASH4$   WITH BKSLASH2$    IN Linker$
        REPLACE   DDQ$        WITH DQ$          IN Linker$
        IF Use_Resource THEN
            ResFileOut$ = EXTRACT$(Res_File$, ".") + ".res"
            Linker$ += SPC$ + ResFileOut$
        END IF
        PRINT "Shelling Out To:", Linker$
        SHELL Linker$
    END IF
    '**************************
    DIM szSave$
    szSave$ = FileOut$
    FileOut$ = EXTRACT$(FileOut$, ".")

    FOR INT A = 1 TO XitCount
        Cmd$ = REMOVE$(Xit$[A], DQ$)
        IREPLACE "$FILE$" WITH FileOutCopy$    IN Cmd$
        IREPLACE "$PELLES$\\" WITH PELLESPATH$ IN Cmd$
        IREPLACE "$PELLES$"   WITH PELLESPATH$ IN Cmd$
        IREPLACE "$LCC$\\"    WITH LCCPATH$    IN Cmd$
        IREPLACE "$LCC$"      WITH LCCPATH$    IN Cmd$
        IREPLACE "$BCX$\\"    WITH BCXPATH$    IN Cmd$
        IREPLACE "$BCX$"      WITH BCXPATH$    IN Cmd$
        REPLACE    BKSLASH4$  WITH BKSLASH2$   IN Cmd$
        REPLACE    DDQ$       WITH DQ$         IN Cmd$
        PRINT "Shelling Out To:", Cmd$
        SHELL Cmd$
    NEXT
    FileOut$ = szSave$
END SUB ' PostProcess





SUB Inject (szLine$)
    CALL XParse(szLine$)
    CALL FixUps
    CALL Emit_Main
END SUB





FUNCTION Convert2SimpleFunction(Tmp AS INTEGER)
    '*****************************************************************
    ' This function removes parentheses if they encapsulate nothing.
    '*****************************************************************
    DIM RAW iNextToken = (++Tmp + 1)
    DIM RAW iRetVal = 0
    IF Stk$[Tmp]= "(" AND Stk$[iNextToken]= ")" THEN
        Stk$[Tmp] = ""
        Stk$[iNextToken] = ""
        INCR iRetVal
    END IF
    RETURN iRetVal
END FUNCTION



SUB XParse(Statement$)
    DIM i
    DIM j
    DIM InIF
    DIM InXFOR
    DIM Gapflag
    DIM LTmp$
    '*************
    IF Statement$ = "" THEN
        Ndx = 0
        EXIT SUB
    END IF

    '===================================================
    '  Introduce "&H" handler in version 798 -- MrBcx
    '===================================================
    DIM RAW HexFlag = FALSE

    FastLexer(Statement$, "", " =()[]{}',+-*/<>?;.|:^")  ' leave ampersand out of it - MrBcx

    FOR INT ii = 1 TO Ndx
        IF IsHexNumber(Stk$[ii]) THEN
            HexFlag = TRUE
            IREPLACE "&h" WITH "0x" IN Stk$[ii]
        END IF
    NEXT

    IF HexFlag = TRUE THEN
        Statement$ = ""
        FOR INT ii = 1 TO Ndx
            Statement$ += Stk$[ii]
        NEXT
    END IF

    '***************************************************

    FastLexer(Statement$, SPC$, "=&()[]{}',+-*/<>?;.|:^")

    '***************************************************
    '                   Pre-Parse
    '***************************************************

    DO WHILE ++i < 20
        Stk$[i+Ndx] = ""
    LOOP

    FOR INT ii = 1 TO Ndx
        IF *Stk$[ii] = ASC("&") AND *Stk$[ii+1] = ASC("&") THEN
            Stk$[ii] = "and"
            LShiftStk (ii+1)
        END IF
    NEXT

    IF iMatchWrd(Stk$[1], "end") THEN
        LTmp$ = ENC$(LCASE$(Stk$[2]), ASC(SPC$))
        IF iMatchNQ(" events , mdievents , mdichildevents ", LTmp$) THEN
            Stk$[1] += LCASE$(Stk$[2])
            IF iMatchWrd(Stk$[3], "main") THEN Use_MainEvent = TRUE
            Ndx = 1
            Src$ = Stk$[1]
            EXIT SUB
        END IF
        IF Stk$[2] <> "=" AND Ndx = 2 THEN
            IF iMatchWrd(Stk$[2], "dialog") THEN Stk$[2] = "function"
            Stk$[1] = "end" + LCASE$(Stk$[2])
            Ndx = 1
            Src$ = Stk$[1]
            EXIT SUB
        END IF
    END IF

    IF iMatchWrd(Stk$[1], "end") AND iMatchWrd(Stk$[2], "prepend") THEN
        Stk$[1] = "endprepend"
        Src$ = Stk$[1]
        Ndx = 1
        EXIT SUB
    END IF

    IF iMatchWrd(Stk$[1], "end") AND iMatchWrd(Stk$[2], "with") THEN
        Stk$[1] = "endwith"
        Src$ = Stk$[1]
        Ndx = 1
        EXIT SUB
    END IF

    DIM RAW iP = 1

    IF iMatchWrd(Stk$[iP], "public") OR iMatchWrd(Stk$[iP], "private") THEN INCR iP

    IF (iMatchWrd(Stk$[iP], "function")   OR  _
        iMatchWrd(Stk$[iP], "catch")      OR  _
        iMatchWrd(Stk$[iP], "sub"))       AND _
        INCHR(Statement$, "*")             THEN

        XFOR INT ii = 2, INTEGER jjj = 1 WHILE ii < Ndx-1 AND jjj BY ii++
            jjj = GetAsPosF(ii, Ndx-2)
            IF jjj THEN
                ii = jjj
                IF iMatchWrd(Stk$[ii+1], "const") THEN INCR ii
                DO WHILE Stk$[ii+2] = "*"
                    Stk$[ii+2] = "PTR"
                    INCR ii
                LOOP
            END IF
        XNEXT

        CALL BuildDelimStr(1, Ndx, Src$)
        FastLexer(Src$, SPC$, "=&()[]{}',+-*/<>?;.|:^")
        Statement$ = Src$
    END IF

    Gapflag = FALSE
    FOR i = 1 TO Ndx
        IF IsDecimalNumber(Stk$[i]) AND BYTE_AT(Stk[i][1]) THEN
            Keyword1$ = RIGHT$(Stk$[i], 1)
            IF *Keyword1$ = ASC("E") OR *Keyword1$ = ASC("e") THEN
                Stk$[i] += Stk$[i+1]
                Stk$[i] += Stk$[i+2]
                Stk$[i+1] = ""
                Stk$[i+2] = ""

                IF Stk$[i-1] = "-" THEN
                    Stk$[i-1] += Stk$[i]
                    Stk$[i] = ""
                END IF
                Gapflag = TRUE
            END IF
        END IF
    NEXT

    IF Gapflag = TRUE THEN CALL RemEmptyTokens

    FOR i = 1 TO Ndx
        Keyword1$ = LCASE$(Stk$[i])

        IF Keyword1[1] THEN
            SELECT CASE Keyword1$

                CASE "not"  : Stk$[i] = "!"
                CASE "is"   : Stk$[i] = "="
                CASE "xor"  : Stk$[i] = "xor"

                CASE "if", "iif", "iif$", "case", "elseif", "while"
                InIF = 1
                IF Keyword1$ = "case" AND iMatchWrd(Stk$[i+1], "else") THEN
                    Stk$[i] = "caseelse"
                    Stk$[i+1] = ""
                    Gapflag = TRUE
                ELSE
                    Stk$[i] = Keyword1$
                END IF

                CASE "$if", "$ifdef"   ' Tells "OR" to be Boolean in an $IF/$IFDEF statement
                InIF = 1

                CASE "$endif"          ' "OR" is free to change again
                InIF = 0

                CASE "xfor"
                InXFOR = 1

                CASE "until"
                InIF = InXFOR
                InXFOR = 0

                CASE "by"
                InIF = 0

                CASE "then"
                InIF = 0

                CASE "byval", "let"
                Stk$[i] = ""
                Gapflag = TRUE

                CASE "shl"
                Stk$[i] = "<<"

                CASE "shr"
                Stk$[i] = ">>"

                CASE "byref"
                IF NOT iMatchWrd(Stk$[1], "declare") AND NOT iMatchWrd(Stk$[1], "c_declare") THEN
                    IF ByrefCnt = cMaxByref-1 THEN
                        CALL Abort("Maxium number of BYREFs reached.")
                    END IF
                    ByrefVars$[++ByrefCnt] = Stk$[i+1]
                END IF

                DIM RAW iDontHaveAs = TRUE

                FOR j = i TO Ndx
                    IF iMatchWrd(Stk$[j], "as") THEN iDontHaveAs = FALSE
                    IF Stk$[j+1] = "," OR Stk$[j+1] = ")" THEN
                        Stk$[j] = "PTR"
                        IF iDontHaveAs THEN
                            InsertTokens(j-1, 2, "as", VarTypeLookup$[ INCHR(VARTYPES$, RIGHT$(ByrefVars$[ByrefCnt], 1)) ])
                        END IF
                        EXIT FOR
                    END IF
                    Stk$[j] = Stk$[j+1]
                NEXT

                CASE "and"
                IF InIF THEN
                    Stk$[i] = "&&"
                ELSE
                    Stk$[i] = "&"
                END IF

                CASE "or"
                IF InIF THEN
                    Stk$[i] = "||"
                ELSE
                    Stk$[i] = "|"
                END IF

                CASE "procedure"
                Stk$[i] = "sub"

                CASE ELSE
                IF PassOne THEN
                    IF Keyword1$ = ENC$(CHR$(92)) THEN
                        IF *Stk$[i+1] <> c_DblQt THEN
                            Stk$[i] = "chr$"
                            InsertTokens(i, 3, "(", "92", ")")
                            INCR i, 3
                        ELSE
                            Stk$[i] += Stk$[i+1]
                            Stk$[i+1] = ""
                            Gapflag = TRUE
                        END IF
                    ELSE
                        IF TranslateSlash THEN
                            REPLACE BKSLASH1$ WITH BKSLASH2$ IN Stk$[i]
                        END IF
                    END IF
                END IF
            END SELECT

        ELSE

            SELECT CASE ASC(Keyword1$)

                '**************
                CASE ASC("&")                                            ' Connect AddressOf operator
                '**************

                IF INCHR("+&,(=", Stk$[i-1]) AND *Stk$[i+1] <> ASC(".") THEN
                    Stk$[i+1] = " &" + Stk$[i+1]
                    Stk$[i] = ""
                    Gapflag = TRUE
                END IF

                '**************
                CASE ASC ("?")                                           ' Multiple contexts
                '**************

                '***********************************************************************************
                IF Stk$[1] ?? "IF" THEN EXIT SELECT                      ' Found an "??" operator
                '***********************************************************************************

                IF Use_GUINoMain OR Use_MDIGUINoMain OR Use_Wingui THEN  ' Added in 752
                    Stk$[i] = "msgbox"                                   ' ? is translated to MsgBox
                    IF Stk$[i+1] = "" THEN
                        Stk$[i+1] = ENC$("")                             ' Allow an empty msgbox
                        INCR Ndx
                    END IF
                ELSE                                                     ' ? full console mode
                    IF i = 1 OR (i > 1 AND Stk$[i-1] = ":") THEN
                        Stk$[i] = "print"                                ' ? is a traditional PRINT convenience
                    END IF
                END IF

                '**************
                CASE ASC ("-")
                '**************

                IF ASC(Stk$[i+1]) = ASC(">") THEN
                    Stk$[i] = "->" + Stk$[i+2]
                    Stk$[++i] = ""
                    Stk$[++i] = ""
                    Gapflag = TRUE
                END IF

                '**************
                CASE ASC (".")
                '**************

                IF ASC(Stk$[i+1]) = 46 AND ASC(Stk$[i+2]) = 46 THEN   ' ...
                    Stk$[i] = "..."
                    Stk$[i+1] = ""
                    Stk$[i+2] = ""
                    Gapflag = TRUE
                END IF
                IF IsDecimalNumber(Stk$[i-1]) THEN
                    Stk$[i] = Stk$[i-1] + "."
                    Stk$[i-1] = ""
                    Gapflag = TRUE
                END IF
                IF NOT INCHR( ",)=<>*/+-^", Stk$[i+1]) THEN
                    Stk$[i] += Stk$[i+1]
                    Stk$[++i] = ""
                    Gapflag = TRUE
                END IF

            END SELECT
        END IF
    NEXT

    IF Gapflag = TRUE THEN CALL RemEmptyTokens

    '*******************************************************************
    ' Special Case Handler: BYREF - BCX prepends * to BYREF'd Variables
    '*******************************************************************

    IF PassOne = TRUE THEN
        DIM RAW lszTmp$ = ""
        IF InFunction THEN            ' Must be in a SUB or FUNCTION
            FOR i = 1 TO Ndx
                FOR j = 1 TO ByrefCnt
                    IF iMatchLft(Stk$[i], " &") THEN lszTmp$ = Stk$[i] + 2 ELSE lszTmp$ = Stk$[i]
                    IF Clean$(lszTmp$) = Clean$(ByrefVars[j]) THEN

                        IF i > 2 THEN
                            IF INCHR("+-^%*/|&<=>,", Stk$[i-2]) AND Stk$[i-1] = "*" THEN
                                Stk$[i-1] = ""
                                Gapflag = TRUE
                            END IF
                            IF iMatchLft(Stk$[i], " &") THEN
                                Stk$[i] = Stk$[i] + 2
                                EXIT FOR
                            END IF
                        ELSEIF i = 2 THEN
                            IF Stk$[i-1] = "*" THEN
                                Stk$[i-1] = ""
                                Gapflag = 1
                            END IF
                        END IF
                        Stk$[i] = "*" + Stk$[i]
                        IF Stk$[i-1] <> "(" OR Stk$[i+1] <> ")" THEN
                            Stk$[i] = ENC$(Stk$[i], ASC("("), ASC(")"))
                        END IF
                        EXIT FOR
                    END IF

                NEXT
            NEXT
        END IF
        IF Gapflag = TRUE THEN CALL RemEmptyTokens
    END IF

    '*******************************************************************
    ' Special Case Handler: DIM BLAHBLAH[22][33] AS STATIC INTEGER
    '*******************************************************************

    IF iMatchWrd(Stk$[1], "dim") THEN
        IF iMatchWrd(Stk$[Ndx-1], "static") THEN
            Stk$[1] = "static"
            Stk$[Ndx-1] = Stk$[Ndx]
            DECR Ndx
        END IF
    END IF

    '***********************************
    ' Used in special case handlers.
    '***********************************
    Keyword1$ = LCASE$(Stk$[1])

    '***************************************************************************
    ' Special Case Handler: In the contexts of UDT's this handler transforms:
    ' FUNCTION Foo (a as integer) AS INTEGER         to:
    ' DIM FUNCTION Foo (a as integer) AS INTEGER
    ' Change "as string" to "as char *" for UDTs and Declarations
    '***************************************************************************

    IF InTypeDef AND NOT InClass THEN
        DIM RAW lsz$ = ""
        lsz$ =  ENC$(Keyword1$, ASC(SPC$))
        IF iMatchNQ(" end dim declare type union ", lsz$) = 0 THEN
            DIM RAW iCnt = 0
            DIM RAW iFnd = 0
            IF MacroCount THEN
                XFOR iCnt = 0 WHILE iCnt < MacroCount BY iCnt++
                    IF Stk$[1] = ConstMacro$[iCnt] THEN iFnd = TRUE
                XNEXT
            END IF
            IF iFnd = FALSE THEN InsertTokens(0, 1, "dim")
        END IF
    END IF

    '******************************

    IF NOT InTypeDef AND NOT InCppTypeDef THEN
        DIM Res
        DIM lsz$
        DIM Storage$

        Storage$ = " dim local global raw static shared dynamic auto register extern "

        lsz$ = ENC$(Keyword1$, ASC(SPC$))

        IF iMatchNQ(Storage$, lsz$) THEN
            Res = 1
        END IF

        lsz$ =  ENC$(LCASE$(Stk$[2]), ASC(SPC$))

        IF iMatchNQ(Storage$, lsz$) THEN
            Res = 2
        END IF

        IF Res > 0 THEN
            i = Ndx
            DO WHILE i > 1 AND Stk$[i] <> ")"
                IF iMatchWrd(Stk$[i], "as") THEN
                    IF iMatchWrd(Stk$[i+1], "function") THEN
                        IF i+1 = Ndx THEN Stk$[i] = ""  ' remove "as"
                        Stk$[i+1] = ""
                        InsertTokens(Res, 1, "function")
                    ELSEIF iMatchWrd(Stk$[i+1], "sub") THEN
                        IF i+1 = Ndx THEN Stk$[i] = ""  ' remove "as"
                        Stk$[i+1] = ""
                        InsertTokens(Res, 1, "sub")
                    END IF
                    CALL RemEmptyTokens
                    EXIT DO
                END IF
                DECR i
            LOOP
        END IF
    END IF

    IF InTypeDef OR iMatchWrd(Stk$[1], "declare") OR iMatchWrd(Stk$[1], "c_declare") THEN
        IF iMatchWrd(Stk$[2], "sub") OR iMatchWrd(Stk$[2], "function") THEN
            FOR INT mm = 2 TO Ndx
                IF iMatchLft(Stk$[mm], "as") AND iMatchWrd(Stk$[mm+1], "string") THEN
                    IF *Stk$[mm+2] <> ASC("*") THEN Stk$[mm+1] = "char *"
                END IF
            NEXT
        END IF
    END IF
END SUB ' XParse





SUB FuncSubTemplate(Tmp AS INTEGER)
    DIM RAW iConc = ++Tmp AS INTEGER
    IF Stk$[++Tmp] <> "<" THEN EXIT SUB
    XFOR INTEGER i = Tmp, INTEGER NotFnd = TRUE WHILE NotFnd = TRUE AND i<= Ndx BY i++
        IF Stk$[i] = "(" THEN
            NotFnd = FALSE
        ELSE
            IF Stk$[i] = "," THEN Stk$[i] = CHR$(18)
            Stk$[iConc] += Stk$[i]
            Stk$[i] = ""
        END IF
    XNEXT
    CALL RemEmptyTokens
END SUB




SUB TokenSubstitutions(iSubLoc AS INTEGER)
    '********************************
    ' Start Doing Text Substitutions
    '********************************
    DIM RAW A AS INTEGER
    DIM RAW a AS INTEGER
    DIM RAW i AS INTEGER
    DIM RAW j AS INTEGER
    DIM RAW Tmp AS INTEGER
    DIM RAW Keyword$
    DIM RAW CompToken                ' flag that STRUCT, UDT, OR UNION can be handled
    DIM RAW NoTrans                  ' flag don't substitute tokens in DATA statements
    DIM RAW tpBCX AS TOKSUBFUNC PTR  ' points to structure holding information
    '                                ' about any word in the BCXWords dictionary
    '******************************************************************************************
    ' Following block added in 4.13 --  Dim XXX as string * 12345
    ' Works in  UDT, GLOBALS, LOCALS, and RAW
    '******************************************************************************************

    i = GetAsPosF(1, Ndx)
    IF i THEN
        IF iMatchWrd(Stk$[i+1], "string") THEN
            IF Stk$[i+2] = "*" THEN
                Stk$[i]   = "["
                Stk$[i+1] = Stk$[i+3]
                Stk$[i+2] = "]"
                Stk$[i+3] = "as"
                INCR Ndx
                Stk$[Ndx] = "char"
            END IF
        END IF
    END IF

    '******************************************************************************************
    '                                  Check for needed transforms
    '******************************************************************************************

    IF InFunction = FALSE THEN
        FOR i = 1 TO Ndx
            IF iMatchWrd(Stk$[i], "global") THEN Stk$[i] = "dim"
        NEXT
    END IF

    A = FALSE
    IF iMatchWrd(Stk$[1], "pptype") = 0 THEN
        FOR Tmp = 1 TO Ndx
            IF *Stk$[Tmp] = ASC("0") AND NOT _
                iMatchWrd(MID$(Stk$[Tmp], 2, 1), "b") AND NOT _
                iMatchWrd(MID$(Stk$[Tmp], 2, 1), "x") AND NOT _
                iMatchWrd(MID$(Stk$[Tmp], 2, 1), ".") AND NOT _
                iMatchWrd(MID$(Stk$[Tmp], 2, 1), "l") THEN
                Stk$[Tmp] = LTRIM$(Stk$[Tmp], 48)   ' allow leading zero's in numbers
                IF ISNULL(Stk$[Tmp]) THEN Stk$[Tmp] = "0"
            END IF

            IF iMatchWrd(Stk$[Tmp], "xor") THEN
                Stk$[Tmp] = "^"
            ELSE

                SELECT CASE Stk$[Tmp]
                    CASE "="
                    IF *Stk$[Tmp+1]= ASC(">") THEN
                        Stk$[Tmp]   = ">"
                        Stk$[Tmp+1] = "="
                    END IF
                    IF *Stk$[Tmp+1]= ASC("<") THEN
                        Stk$[Tmp]   = "<"
                        Stk$[Tmp+1] = "="
                    END IF
                    CASE "<"
                    IF *Stk$[Tmp+1]= ASC(">") THEN
                        Stk$[Tmp]   = "!="
                        Stk$[Tmp+1] = ""
                        A = TRUE
                    END IF
                    CASE ">"
                    IF *Stk$[Tmp+1]= ASC("<") THEN
                        Stk$[Tmp]   = "!="
                        Stk$[Tmp+1] = ""
                        A = TRUE
                    END IF
                    CASE "!"
                    IF *Stk$[Tmp+1]= ASC("=") THEN
                        Stk$[Tmp]   = "!="
                        Stk$[Tmp+1] = ""
                        A = TRUE
                    END IF
                END SELECT

            END IF
        NEXT
    END IF

    IF A = TRUE THEN CALL RemEmptyTokens

    '*************************************************************************
    ' Needed when recursively calling parse() after <> has already translated
    ' to != Otherwise, on pass 2, it emits as !== which is NOT desired.
    '*************************************************************************

    CompToken = 0

    FOR Tmp = 1 TO Ndx
        A = CheckLocal(Stk$[Tmp], ADDRESSOF(i))
        IF A = vt_UNKNOWN THEN A = CheckGlobal(Stk$[Tmp], ADDRESSOF(i))
        IF A = vt_STRUCT OR A = vt_UDT OR A = vt_UNION THEN
            CompToken = 1
        END IF

        IF iMatchWrd(Stk$[Tmp], "int") AND Stk$[Tmp+1] = "(" THEN Stk$[Tmp] = "int"

        IF iMatchWrd(Stk$[Tmp], "int") AND Stk$[Tmp+1] = "("  AND Stk$[Tmp+2] <> ")"  THEN
            Stk$[Tmp] = "floor"
        ELSEIF iMatchWrd(Stk$[Tmp], "integer") THEN
            Stk$[Tmp] = "int"
        ELSE
            IF iMatchWrd(Stk$[Tmp], "fint") AND Stk$[Tmp+1]= ")" THEN    ' "fint" is temporary, only used for parsing
                Stk$[Tmp] = "int"
            END IF
        END IF
    NEXT

    '*****************************

    NoTrans = 0

    FOR Tmp = 1 TO Ndx
        IF NoTrans = 1 THEN EXIT FOR
        Keyword$ = LCASE$(Stk$[Tmp])
        tpBCX = GetWordInfo(Keyword$)
        IF tpBCX THEN

            IF (tpBCX->iTRAN_FLAG BAND iSubLoc) <> iSubLoc THEN
                ITERATE
            END IF
            IF (tpBCX->iWordInfo BAND eWI_ReplaceWord) THEN ' just substitute
                IF (tpBCX->iWordInfo BAND eWI_Position1) = 0 THEN
                    Stk$[Tmp] = tpBCX->pszFunctionXName$
                    ITERATE
                ELSEIF Tmp = 1 THEN
                    Stk$[Tmp] = tpBCX->pszFunctionXName$
                    ITERATE
                END IF
            END IF
        END IF

        '*********************************************************************************
        ' This is where we can modify the input stream of tokens that have been parsed.
        ' We can do simple text substitutions, add missing arguments, add casting, set
        ' conditionals, and practically anything else that might be needed.
        '*********************************************************************************

        a = INCHR("abcdefghijklmnopqrstuvwxyz$", Keyword$)

        SELECT CASE a
            CASE 1
            SELECT CASE Keyword$

                CASE "acosh"
                Stk$[Tmp] = "acosh"
                Use_Acosh = Use_Proto = TRUE

                CASE "addressof"
                Stk$[Tmp+1] = "&" + Stk$[Tmp+1]
                Stk$[Tmp] = ""

                CASE "appactivate"
                Stk$[Tmp] = "AppActivate"
                Use_AppActivate = Use_BcxTempStr = Use_Instr = Use_Stristr = TRUE
                Use_Lcase = Use_Left = Use_UCaseTbl = TRUE

                CASE "appexename$"
                Stk$[Tmp] = "AppExeName$()"
                Use_AppExeName = Use_BcxTempStr = TRUE

                CASE "appexepath$"
                Stk$[Tmp] = "AppExePath$()"
                Convert2SimpleFunction(Tmp)
                Use_AppExePath = Use_BcxTempStr = TRUE

                CASE "ansitowide", "ansitowide$", "a2w$", "a2w"
                Stk$[Tmp] = "AnsiToWide"
                Use_AnsiToWide = Use_BcxTempStr = TRUE

                CASE "andalso"                  ' AND can be Boolean or bitwise
                Stk$[Tmp] = " &&"               ' but ANDALSO is ALWAYS boolean

                CASE "asc"
                CALL Process_ASC_Function (Tmp)

                CASE "arrayputelement"
                ' INPUT:
                ' ArrayPutElement(psA,lComVariant,2,0,iCol)
                ' TRANSFORMS TO:
                ' BEGINBLOCK
                ' RAW indicies[2] = {0,iCol} AS long
                ' SafeArrayPutElement(psA,indicies, (void *)&lComVariant)
                ' ENDBLOCK
                DIM RAW sTmp$
                CALL Add2SplitLines("BEGINBLOCK")   ' EMITS {
                sTmp$ = "DIM RAW lIndex[" + Stk$[Tmp+6] + "] = {"
                FOR i = Tmp+8 TO Ndx-1
                    sTmp$ += Stk$[i]
                NEXT
                CALL Add2SplitLines(sTmp$ + "} AS long")
                Stk$[Tmp] = "SafeArrayPutElement"
                sTmp$ = ""
                FOR i = 1 TO Tmp+3
                    sTmp$ += Stk$[i]
                NEXT
                CALL Add2SplitLines(sTmp$ + "lIndex,(void *)&" + Stk$[Tmp+4] + ")")
                CALL Add2SplitLines("ENDBLOCK")      ' EMITS }
                Ndx = 0

                CASE "arraygetelement"
                DIM RAW sTmp$
                CALL Add2SplitLines("BEGINBLOCK")
                sTmp$ = "DIM RAW lIndex[" + Stk$[Tmp+6] + "] = {"
                FOR i = Tmp+8 TO Ndx-1
                    sTmp$ += Clean$(Stk$[i])
                NEXT
                CALL Add2SplitLines(sTmp$ + "} AS long")
                Stk$[Tmp] = "SafeArrayGetElement"
                sTmp$ = ""
                FOR i = 1 TO Tmp+3
                    sTmp$ += Clean$(Stk$[i])
                NEXT
                CALL Add2SplitLines(sTmp$ + "lIndex,(void *)&" + Clean$(Stk$[Tmp+4]) + ")")
                CALL Add2SplitLines("ENDBLOCK")
                Ndx = 0

                CASE "asinh"
                Stk$[Tmp] = "asinh"
                Use_Asinh = Use_Proto = TRUE

                CASE "atanh"
                Stk$[Tmp] = "atanh"
                Use_Atanh = Use_Proto = TRUE

                CASE "auto"
                IF iMatchWrd(Stk$[Tmp+1], "local") THEN
                    Stk$[Tmp] = "dim"
                    Stk$[Tmp+1] = "raw"
                ELSE
                    Stk$[Tmp] = "auto"
                END IF

                CASE  "acode$", "acode"
                Stk$[Tmp] = "$$WideToAnsi$"
                Use_WideToAnsi = Use_BcxTempStr = TRUE

            END SELECT

            CASE  2
            SELECT CASE Keyword$

                CASE "bcopy"
                Stk$[1] = ""
                FOR i = Tmp+1 TO Ndx
                    IF iMatchWrd(Stk$[i], "to") THEN EXIT FOR
                    Stk$[1] += Stk$[i]  ' Source
                    Stk$[1] += CHR$(1)
                NEXT
                Stk$[2] = ""
                FOR i = i+1 TO Ndx
                    Stk$[2] += Stk$[i]  ' Destination
                    Stk$[2] += CHR$(1)
                NEXT

                '*****************************************************************************
                ' Ian Casey requested the following casts in memmove to support UNICODE
                '           Tested and working with all compilers - MrBcx --     7.6.6
                '*****************************************************************************
                Src$  = ""
                Src$ += "memmove" + CHR$(1)          + "((char*)" + CHR$(1) + "&"     + CHR$(1)
                Src$ += Stk$[2]   + ",(const char*)" + CHR$(1)    + "&"     + CHR$(1)
                Src$ += Stk$[1]   + "," + CHR$(1)    + "sizeof"   + CHR$(1) + "("     + CHR$(1)
                Src$ += Stk$[2]   + ")" + CHR$(1)    + ")"
                '
                '*****************************************************************************
                REMOVE "&*" FROM Src$
                CALL FastLexer(Src$, CHR$(1), "")

                CASE "begin"
                Inject_Local_Bcx_RetVal = TRUE
                IF iMatchWrd(Stk$[Tmp+1], "events") OR iMatchWrd(Stk$[Tmp+1], "mdievents") OR iMatchWrd(Stk$[Tmp+1], "mdichildevents") THEN
                    IF Indent THEN
                        PRINT REPEAT$(80, "_")
                        PRINT "Possible missing END IF before start of BEGIN"
                        PRINT REPEAT$(80, "_")
                    END IF
                    IF Ndx = 3 THEN
                        Src$ = "FUNCTION|" + Stk$[Tmp+2] + "(hWnd|AS|HWND,Msg|AS|UINT,wParam|AS|WPARAM,lParam|AS|LPARAM)|AS|LRESULT|CALLBACK"
                    ELSE
                        Src$ = "FUNCTION|WndProc(hWnd|AS|HWND,Msg|AS|UINT,wParam|AS|WPARAM,lParam|AS|LPARAM)|AS|LRESULT|CALLBACK"
                    END IF
                    FastLexer(Src$, "|", ",()")
                    Use_Wingui = TRUE
                    EXIT SUB
                END IF

                CASE "bel$"
                Stk$[Tmp] = "BEL$"
                Use_BEL = Use_BcxTempStr = TRUE

                CASE "bs$"
                Stk$[Tmp] = "BS$"
                Use_BS = Use_BcxTempStr = TRUE

                CASE "bcxstrsize"
                Stk$[Tmp] = "BCXSTRSIZE"

                CASE "bcx_dynacall"
                Stk$[Tmp] = "BCX_DynaCallA"
                Use_DynacallCommon = Use_DynacallA = Use_Proto = TRUE

                '*******************************************************************
                ' Special Case Handler: Maintain case sensitivity for this structure
                '*******************************************************************

                CASE "bcx_font"
                Stk$[Tmp] = UCASE$(Stk$[Tmp])
                DIM RAW temp$
                DIM RAW iNextToken = Tmp + 1
                Stk$[iNextToken] = Clean$(Stk$[iNextToken])
                temp$ = UCASE$(Stk$[iNextToken])

                SELECT CASE temp$
                    CASE ".NAME"         : Stk$[iNextToken] = ".lf.lfFaceName$"
                    CASE ".BOLD"         : Stk$[iNextToken] = ".lf.lfWeight"
                    CASE ".UNDERLINE"    : Stk$[iNextToken] = ".lf.lfUnderline"
                    CASE ".STRIKEOUT"    : Stk$[iNextToken] = ".lf.lfStrikeOut"
                    CASE ".ITALIC"       : Stk$[iNextToken] = ".lf.lfItalic"
                    CASE ".CHARSET"      : Stk$[iNextToken] = ".lf.lfCharSet"
                    CASE ".SIZE", ".RGB" : Stk$[iNextToken] = temp$
                END SELECT

                CASE "bcx_setcursor"
                Stk$[Tmp] = "BCX_SetCursor"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)  ' Allow unparenthesized expressions
                END IF
                Use_BCX_SetCursor = Use_BCX_InitGUI = TRUE
                CALL AddGUIGlobals

                CASE "bcx_msgpump"
                Stk$[Tmp] = "BCX_MsgPump"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)  ' Allow unparenthesized expressions
                END IF
                Use_BCX_MsgPump = TRUE
                CALL AddGUIGlobals

                CASE "bcx_wnd"
                Stk$[Tmp] = "BCX_Wnd"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)  ' Allow unparenthesized expressions
                END IF
                Use_BCX_Wnd = Use_BCX_InitGUI = Use_BCX_SetMetric = Use_BCX_RegWnd = TRUE
                CALL AddGUIGlobals

                CASE "bcx_framewnd"
                Stk$[Tmp] = "BCX_FrameWnd"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)  ' Allow unparenthesized expressions
                END IF
                Use_BCX_FrameWnd = Use_BCX_RegWnd = Use_BCX_InitGUI = Use_BCX_SetMetric = TRUE
                CALL AddGUIGlobals

                CASE "bcx_setbkgrdbrush"
                Stk$[Tmp] = "BCX_SetBkGrdBrush"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)  ' Allow unparenthesized expressions
                END IF
                Use_BCX_SetBkGrdBrush = Use_BCX_InitGUI = TRUE
                CALL AddGUIGlobals

                CASE "bcx_setclassstyle"
                Stk$[Tmp] = "BCX_SetClassStyle"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)  ' Allow unparenthesized expressions
                END IF
                Use_BCX_SetClassStyle = Use_BCX_InitGUI = TRUE
                CALL AddGUIGlobals

                CASE "bcx_seticon"
                Stk$[Tmp] = "BCX_SetIcon"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)  ' Allow unparenthesized expressions
                END IF
                Use_BCX_SetIcon = Use_BCX_InitGUI = TRUE
                CALL AddGUIGlobals

                CASE "bcx_seticonsm"
                Stk$[Tmp] = "BCX_SetIconSm"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)  ' Allow unparenthesized expressions
                END IF
                Use_BCX_SetIconSm = Use_BCX_InitGUI = TRUE
                CALL AddGUIGlobals

                CASE "bcx_setmetric"
                Stk$[Tmp] = "BCX_SetMetric"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)  ' Allow unparenthesized expressions
                END IF
                Use_BCX_SetMetric = Use_BCX_InitGUI = TRUE
                CALL AddGUIGlobals

                CASE "bcx_initgui"
                Stk$[Tmp] = "BCX_InitGUI"
                Use_BCX_InitGUI = TRUE
                CALL AddGUIGlobals

                CASE "bcx_regwnd"
                Stk$[Tmp] = "BCX_RegWnd"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)  ' Allow unparenthesized expressions
                END IF
                Use_BCX_RegWnd = Use_BCX_InitGUI = Use_BCX_SetMetric = TRUE
                CALL AddGUIGlobals

                CASE "bcx_mdi_msgpump"
                Stk$[Tmp] = "BCX_MDI_MsgPump"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)  ' Allow unparenthesized expressions
                END IF
                Use_BCX_MDI_MsgPump = TRUE
                CALL AddGUIGlobals

                CASE "bcx_wndclass"
                Stk$[Tmp] = "BCX_WndClass"
                CALL AddGUIGlobals

                CASE "bcxsplitpath$"
                Stk$[Tmp] = "$$BcxSplitPath$"
                Use_BcxSplitPath = Use_BcxTempStr = TRUE
                Use_SysMacros = Use_Proto = TRUE

                CASE "bcxpath$"
                Stk$[Tmp] = "BcxPath$()"
                Convert2SimpleFunction(Tmp)
                Use_BCX_Path = Use_RegString = TRUE
                Use_BcxTempStr = TRUE

                CASE "bcx_pensize"
                Stk$[Tmp] = "BCX_Pensize"
                CALL AddPenSizeVariables

                CASE "bcx_penstyle"
                Stk$[Tmp] = "BCX_Penstyle"
                CALL AddPenSizeVariables

                CASE "bcx_arc"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Arc"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_Arc = Use_Proto = TRUE
                CALL AddPenSizeVariables

                CASE "bcx_pie"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Pie"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_Pie = Use_Proto = TRUE
                CALL AddPenSizeVariables

                CASE "bcx_bitmap"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Bitmap"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Bitmap = Use_Proto = TRUE

                CASE "bcx_blit"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Blit"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_Blit = Use_Proto =TRUE

                CASE "bcx_blit_stretch"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Blit_Stretch"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_Blit_Stretch = Use_Proto =TRUE

                CASE "bcx_blit_sprite"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Blit_Sprite"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_Blit_Sprite = Use_Proto = TRUE

                CASE "bcx_buffer"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_BUFFER"
                Use_BCX_Buffer = Use_Proto = TRUE
                CALL AddGrafixVariables

                CASE "bcx_buffer_start"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_BUFFER_START"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_Buffer = Use_Proto = TRUE
                CALL AddGrafixVariables

                CASE "bcx_buffer_stop"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_BUFFER_STOP"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_Buffer = Use_Proto= TRUE
                CALL AddGrafixVariables

                CASE "bcx_olepicture"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_OlePicture"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)          ' Allow unparenthesized expressions
                END IF
                Use_BCX_OlePicture = Use_GetResource = Use_Proto = TRUE

                CASE "bcx_ole_width"
                Stk$[Tmp] = "BCX_OLE_WIDTH"
                Use_SysMacros = TRUE

                CASE "bcx_ole_height"
                Stk$[Tmp] = "BCX_OLE_HEIGHT"
                Use_SysMacros = TRUE

                CASE "bcx_blackrect"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_BlackRect"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Blackrect = Use_Proto = TRUE

                CASE "bcx_button"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Button"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Button = Use_GetTextSize = Use_Proto = TRUE

                CASE "bcx_bmpbutton"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_BmpButton"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BmpButton = Use_Proto = TRUE

                CASE "bcx_bmpwidth"
                Stk$[Tmp] = "BCX_BmpWidth"
                Use_BCX_BmpWidth = Use_Proto = TRUE

                CASE "bcx_bmpheight"
                Stk$[Tmp] = "BCX_BmpHeight"
                Use_BCX_BmpHeight = Use_Proto = TRUE

                CASE "bcx_checkbox"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Checkbox"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Checkbox = Use_GetTextSize = Use_Proto = TRUE

                CASE "bcx_combobox"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Combobox"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Combobox = Use_Proto = TRUE

                CASE "bcx_console"
                Stk$[Tmp] = "hConsole"
                Use_Console = Use_Proto = TRUE

                CASE "bcx_com_error"
                Stk$[Tmp] = "COM_BCX_ERROR"
                ComSwitchON = Use_COM = TRUE

                CASE "bcx_control"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Control"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_Control = Use_Proto = TRUE

                CASE "bcx_colordlg"
                Stk$[Tmp] = "BCX_ColorDlg"
                IF NOT INCHR(Src$, "(") THEN Stk$[Tmp] = Stk$[Tmp] + "()"
                Use_BCX_Colordlg = Use_Hook = Use_BcxTempStr = Use_Proto = TRUE

                CASE "bcx_cursor"
                Stk$[Tmp] = "BCX_Cursor"
                Use_BCX_Cursor = Use_SysMacros = TRUE

                CASE "bcx_datepick"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_DatePick"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Datepick = Use_Proto = TRUE

                CASE "bcx_edit"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Edit"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Edit = Use_Proto = TRUE

                CASE "bcx_circle"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Circle"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_Circle = Use_Proto = TRUE
                CALL AddPenSizeVariables

                CASE "bcx_ellipse"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Ellipse"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_Ellipse = Use_Proto = TRUE
                CALL AddPenSizeVariables

                CASE "bcx_mdialog"
                CALL AddBcxFontVar
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                IF InWinMain AND NOT Use_BCXMDialog THEN
                    FPRINT FP_WRITE, Scoot$, "BCX_hInstance = hInst;"
                    iEmitVarGroup = iEmitVarGroup BOR (eFontGroup BOR eBCX_hInstance)
                END IF
                Stk$[Tmp] = "BCX_MDialog"
                IF Tmp = 3 THEN Stk$[Tmp+1] = "((DLGPROC)"
                Use_BCXDialogCommon = Use_BCXMDialog = Use_Proto = TRUE

                CASE "bcx_dialog"
                CALL AddBcxFontVar
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Stk$[Tmp] = "BCX_Dialog"
                IF Tmp = 3 THEN Stk$[Tmp+1] = "((DLGPROC)"
                Use_BCXDialogCommon = Use_BCXDialog = Use_Proto = TRUE

                CASE "bcx_form"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Form"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Form = Use_Proto = Use_MainEvent = TRUE

                IF NOT Use_BCX_Class_Info THEN
                    Use_BCX_Class_Info = TRUE
                    iEmitVarGroup = iEmitVarGroup BOR (eFontGroup BOR eClassName)
                END IF

                CASE "bcx_fontdlg"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_FontDlg"
                IF Tmp = Ndx THEN  Stk$[Tmp] += "()"
                Use_BCX_Fontdlg = TRUE
                Use_Hook = Use_BcxTempStr = Use_Proto = TRUE

                CASE "bcx_floodfill"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_FloodFill"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_Floodfill = Use_Proto = TRUE
                CALL AddPenSizeVariables

                CASE "bcx_get"
                Stk$[Tmp] = "BCX_Get"
                Use_BCX_Get = Use_Proto = TRUE

                CASE "bcx_get_window_height"
                Stk$[Tmp] = "BCX_Get_Window_Height"
                Use_BCX_Get_Window_Height = Use_Proto = TRUE

                CASE "bcx_get_window_width"
                Stk$[Tmp] = "BCX_Get_Window_Width"
                Use_BCX_Get_Window_Width = Use_Proto = TRUE

                CASE "bcx_get_text$"
                Stk$[Tmp] = "$$BCX_Get_Text$"
                Use_GetText = Use_BcxTempStr = TRUE

                CASE "bcx_getpixel"
                Stk$[Tmp] = "BCX_Getpixel"
                Use_BCX_Getpixel = Use_BcxTempStr = TRUE

                CASE "bcx_gradient"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Gradient"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_Gradient = Use_Proto = TRUE


                CASE "bcx_grayrect"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_GrayRect"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Grayrect = Use_Proto = TRUE

                CASE "bcx_group"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Group"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Group = Use_Proto = TRUE

                CASE "bcx_icon"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Icon"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Icon = Use_GetResource = Use_Proto = TRUE

                CASE "bcx_input"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Input"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_Input = Use_Proto = TRUE

                CASE "bcx_label"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Label"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Label = Use_GetTextSize = Use_Proto = TRUE

                CASE "bcx_line"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Line"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_Line = Use_Proto = TRUE
                CALL AddPenSizeVariables

                CASE "bcx_polar_line"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Polar_Line"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_Line = Use_Proto = TRUE
                Use_BCX_Polar_Line = TRUE
                CALL AddPenSizeVariables

                CASE "bcx_lineto"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Lineto"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_Lineto = Use_Proto = TRUE
                CALL AddPenSizeVariables


                CASE "bcx_triangle"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Triangle"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_Triangle = Use_Proto = TRUE
                CALL AddPenSizeVariables

                CASE "bcx_listbox"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Listbox"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Listbox = Use_Proto = TRUE

                CASE "bcx_listview"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_ListView"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Listview = Use_Proto = TRUE

                CASE  "bcx_loadbmp"
                Stk$[Tmp] = "BCX_LoadBMP"
                Use_BCX_LoadBMP = Use_Proto = TRUE

                CASE  "bcx_loadimage"
                Stk$[Tmp] = "BCX_LoadImage"
                Use_BCX_LoadImage = Use_GetResource = Use_Proto = TRUE

                CASE "bcx_print"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Print"
                Use_BCX_Print = Use_Proto = TRUE

                CASE "bcx_printex"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Printex"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_Printex = Use_Proto = TRUE

                CASE "bcx_polygon"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Polygon"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_Polygon = Use_Proto = TRUE
                CALL AddPenSizeVariables

                CASE "bcx_polybezier"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_PolyBezier"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_PolyBezier = Use_Proto = TRUE
                CALL AddPenSizeVariables

                CASE "bcx_polyline"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Polyline"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_Polyline = Use_Proto = TRUE
                CALL AddPenSizeVariables

                CASE "bcx_preset"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Preset"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_Preset = Use_Proto = TRUE

                CASE "bcx_pset"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Pset"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_Pset = Use_Proto = TRUE
                CALL AddPenSizeVariables

                CASE "bcx_polar_pset"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Polar_Pset"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_Pset = Use_Proto = TRUE
                Use_BCX_Polar_Pset = TRUE
                CALL AddPenSizeVariables

                CASE "bcx_polar_line"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Polar_Line"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_Line = Use_Proto = TRUE
                Use_BCX_Polar_Line = TRUE
                CALL AddPenSizeVariables

                CASE "bcx_progressbar"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_ProgressBar"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_ProgressBar = Use_Proto = TRUE

                CASE "bcx_put"
                Stk$[Tmp] = "BCX_Put"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_Put = Use_Proto = TRUE

                CASE "bcx_radio"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Radio"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Radio = Use_GetTextSize = Use_Proto = TRUE

                CASE "bcx_rectangle"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Rectangle"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_Rectangle = Use_BcxTempStr = TRUE
                CALL AddPenSizeVariables

                CASE "bcx_resize"
                Stk$[Tmp] = "BCX_RESIZE"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_Resize = Use_SysMacros = TRUE

                CASE "bcx_richedit"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_RichEdit"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Richedit = Use_Proto = TRUE

                CASE "bcx_roundrect"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Roundrect"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_Roundrect = Use_Proto = TRUE
                CALL AddPenSizeVariables

                CASE "bcx_slider"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Slider"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_Slider = Use_Label = Use_GetTextSize = Use_Proto = TRUE

                CASE "bcx_splitter"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Splitter"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_Splitter = Use_Proto = Use_Modstyle = TRUE

                CASE "bcx_setsplitpos"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_SetSplitPos"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_Splitter = Use_Proto = Use_Modstyle = TRUE

                CASE "bcx_tab"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Tab"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_Tab = Use_Proto = TRUE

                CASE "bcx_toolbar"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Toolbar"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_Toolbar = Use_Proto = TRUE

                CASE "bcx_updown"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_UpDown"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_UpDown = Use_Proto = TRUE

                CASE "bcx_version$"
                Stk$[Tmp] = ENC$(Version$)

                CASE "bcx_get_updown"
                Stk$[Tmp] = "BCX_Get_UpDown"
                Use_BCX_Get_UpDown = Use_Proto = Use_BcxTempStr = TRUE

                CASE "bcx_set_form_color"
                Stk$[Tmp] = "BCX_Set_Form_Color"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_SetFormColor = Use_Proto = TRUE


                CASE "bcx_setclientsize"
                Use_Setclientsize = Use_Proto = TRUE
                Stk$[Tmp] = "BCX_SetClientSize"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF

                CASE "bcx_set_font"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Set_Font"
                Use_SetFont = Use_Proto = TRUE
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF

                CASE "bcx_setcolor"
                Stk$[Tmp] = "Set_Color"
                DIM RAW iPCnt = GetNumArgs(Tmp+2)

                IF iPCnt = 1 THEN
                    InsertTokens(Ndx-1, 4, ",", "(HDC)wParam", ",", "(HWND)lParam")
                ELSEIF iPCnt = 2 THEN
                    InsertTokens(Ndx-1, 2, ",", "(HWND)lParam")
                END IF
                Use_SetColor = Use_Proto = TRUE

                CASE "bcx_set_text"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Set_Text"
                Use_SetText = Use_Proto = TRUE
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF

                CASE "bcx_status"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Status"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Status = Use_Proto = TRUE

                CASE "bcx_stricmp"
                Stk$[Tmp] = "bcx_stricmp"
                Use_BCX_stricmp = TRUE

                CASE "bcx_setconsolesize"
                Stk$[Tmp] = "BCX_SetConsoleSize"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Consolesize = Use_Console = Use_Proto = TRUE

                CASE "bcx_pushconsolesize"
                IF Stk$[Tmp+1] <> "(" THEN Stk$[Tmp] = "BCX_PushConsoleSize()"
                Use_Consolesize = Use_Console = Use_Proto = TRUE

                CASE "bcx_popconsolesize"
                IF Stk$[Tmp+1] <> "(" THEN Stk$[Tmp] = "BCX_PopConsoleSize()"
                Use_Consolesize = Use_Console = Use_Proto = TRUE

                CASE "bcx_tabselect"
                Stk$[Tmp] = "BCX_TabSelect(hWnd, lParam)"
                Use_BCX_Tab = Use_Proto = TRUE

                CASE "bcx_tile"
                Use_BCX_Tile = Use_Proto = TRUE
                Stk$[Tmp] = "BCX_Tile"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF

                CASE "bcx_thread", "bcx_threadwait", "bcx_threadsuspend", "bcx_threadresume", "bcx_threadkill", "bcx_threadend"
                Stk$[Tmp] = UCASE$(Stk$[Tmp])
                Use_Threads = Use_SysMacros = TRUE

                CASE "bcx_tooltip"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_ToolTip"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BCX_ToolTip = Use_Proto = TRUE
                CALL AddGlobal("BCX_hWnd_ToolTip", vt_HWND)

                CASE "bcx_tempstr"
                Stk$[Tmp] = "BCX_TempStr"
                Use_BcxTempStr = TRUE

                CASE "bcx_treeview"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_Treeview"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Treeview = Use_Proto = TRUE

                CASE "bcx_whiterect"
                CALL AddBcxFontVar
                Stk$[Tmp] = "BCX_WhiteRect"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Whiterect = Use_Proto = TRUE

                CASE "bcx_clsid$"
                Stk$[Tmp] = "BCX_CLSID$"
                Use_Proto = Use_BcxTempStr = TRUE
                Use_COM_CLSID = Use_AnsiToWide = Use_WideToAnsi = TRUE


                CASE "bcx_dispatchobject"
                ' x = DispatchObject(unknown,tf)
                ' BCX_DispatchObject (unknown, &x, tf)
                Use_BcxTempStr = TRUE
                ComSwitchON = Use_COM  = TRUE
                Use_COM_CreateObject   = TRUE
                Use_COM_DispatchObject = TRUE
                Use_COM_GetObject      = TRUE
                Use_COM_GetProperty    = TRUE
                Use_COM_InvokeMethod   = TRUE
                Use_COM_SafeArray      = TRUE
                Use_COM_SetProperty    = TRUE
                Use_COM_UsesConversion = TRUE

                DIM szObj$ = "&"
                DIM szUnknown$
                DIM szRelease$
                DIM RAW iTobj AS INTEGER

                iTobj = 1
                DO WHILE Stk$[iTobj] <> "="
                    szObj$ += Stk$[iTobj]
                    INCR iTobj
                LOOP
                iTobj = Tmp+2
                DO WHILE Stk$[iTobj] <> "," AND Stk$[iTobj] <> ")"
                    szUnknown$ += Stk$[iTobj]
                    INCR iTobj
                LOOP
                IF Stk$[iTobj] = ")" THEN
                    szRelease$ = "TRUE"
                ELSE
                    szRelease$ = Stk$[iTobj+1]
                END IF

                Stk$[1] = "BCX_DispatchObject"
                Stk$[2] = "("
                Stk$[3] = szUnknown$
                Stk$[4] = ","
                Stk$[5] = szObj$
                Stk$[6] = ","
                Stk$[7] = szRelease$
                Stk$[8] = ")"
                Ndx = 8

                CASE "bff$"
                Stk$[Tmp] = "$$BFF$"
                Use_Bff = Use_BcxTempStr = TRUE

                CASE "bin$"
                Stk$[Tmp] = "$$Bin$"
                Use_Bin = Use_BcxTempStr = TRUE

                CASE "bin2dec"
                Stk$[Tmp] = "Bin2Dec"
                Use_Bin2dec = Use_Proto = TRUE

                CASE "bool$"
                Stk$[Tmp] = "$$BoolStr$"
                Use_Boolstr = Use_BcxTempStr = TRUE

                CASE "bool"
                Stk$[Tmp] = "BOOL"

                CASE "boolean"
                Stk$[Tmp] = "BOOLEAN"

                CASE "band"
                IF *Stk$[Tmp+1] = ASC("=") THEN
                    Stk$[Tmp+1] = "&="
                    Stk$[Tmp] = ""
                ELSE
                    Stk$[Tmp] = " & "
                END IF

                CASE "bnot"
                Stk$[Tmp] = " BNOT "
                Use_Bnot  = Use_SysMacros = TRUE


                CASE "byte_at"   ' Helps BCX translate statements like: IF a$[1][2] then ...
                Stk$[Tmp] = "BYTE_AT"
                Use_ByteAt = Use_SysMacros = TRUE


                CASE "bor"
                IF *Stk$[Tmp+1] = ASC("=") THEN
                    Stk$[Tmp+1] = "|="
                    Stk$[Tmp] = ""
                ELSE
                    Stk$[Tmp] = "|"
                END IF

            END SELECT

            CASE 3
            SELECT CASE Keyword$

                CASE "case"
                DIM RAW nBrace
                DIM RAW CntMarker

                nBrace = 0
                CntMarker = 2
                j = 0
                FOR i = 2 TO Ndx
                    IF INCHR("([", Stk$[i]) THEN INCR nBrace
                    IF INCHR(")]", Stk$[i]) THEN DECR nBrace
                    IF Stk$[i] = ","  THEN
                        IF nBrace = 0 THEN CntMarker = i + 1
                    END IF
                    IF iMatchWrd(Stk$[i], "to") THEN
                        j = 1
                        Stk$[i] = "&&" + CHR$(1) + "<="
                        Stk$[CntMarker] = ">=" + CHR$(1) + Stk$[CntMarker]
                    END IF
                NEXT

                IF j = 1 THEN
                    Src$ = ""
                    FOR i = 1 TO Ndx
                        Src$ += Stk$[i] + CHR$(1)
                    NEXT
                    CALL FastLexer(Src$, CHR$(1), "")
                END IF

                CASE "cast"
                Stk$[Tmp] = " CAST "
                Use_Cast = Use_SysMacros = TRUE



                CASE "callback"
                Stk$[Tmp] = "CALLBACK"
                IF Tmp = 1 THEN
                    IF Ndx > 5 THEN Warning("Extra Callback code truncated", 1)
                    Src$ = "FUNCTION|" + Stk$[3] + "(hWnd|AS|HWND,Msg|AS|UINT,wParam|AS|WPARAM,lParam|AS|LPARAM)|AS|LRESULT|CALLBACK"
                    FastLexer(Src$, "|", ",()")
                    CallBackFlag = TRUE
                END IF

                CASE "callwindowproc"
                '*****************************
                '    CallWindowProc HELPER
                '*****************************
                Stk$[Tmp] = "CallWindowProc"
                IF Stk$[Tmp+3] <> "WNDPROC" THEN InsertTokens(Tmp+1, 3, "(", "WNDPROC", ")")


                CASE "com"
                Stk$[Tmp] = "COM"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                ComSwitchON = Use_COM = TRUE
                Use_COM_CreateObject   = TRUE
                Use_COM_DispatchObject = TRUE
                Use_COM_GetObject      = TRUE
                Use_COM_GetProperty    = TRUE
                Use_COM_InvokeMethod   = TRUE
                Use_COM_SafeArray      = TRUE
                Use_COM_SetProperty    = TRUE
                Use_COM_UsesConversion = TRUE


                CASE "createobject"
                ComSwitchON = Use_COM_UsesConversion = Use_COM_CreateObject = Use_COM = TRUE
                IF Stk$[2] = "[" THEN
                    ' object from an array of objects
                    ' SET oObj [ iii ] = createobject ("Excel.Application")
                    ' BCX_CreateObject ("Excel.Application", & oTmp[iii]);
                    DIM RAW iii
                    iii = 2
                    DO WHILE Stk$[iii] <> "="
                        Stk$[1] += Stk$[iii]
                        *Stk$[iii] = 0
                        INCR iii
                    LOOP
                    CALL RemEmptyTokens
                END IF
                Stk$[3] = Stk$[5]
                sprintf(Stk[5], "&%s", Stk[1])
                Stk$[1] = "BCX_CreateObject"
                Stk$[2] = "("
                Stk$[4] = ","

                CASE "concat"
                Stk$[Tmp] = "strcat"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF

                CASE "containedin"
                Stk$[Tmp] = "containedin"
                Use_ContainedIn = Use_BCX_stricmp = TRUE

                CASE "cr$"
                Stk$[Tmp] = "CR$"
                Use_CR = Use_BcxTempStr = TRUE

                CASE "close"
                DIM RAW iNextToken = Tmp + 1
                IF *Stk$[iNextToken] = ASC("#") THEN
                    Stk$[iNextToken] = MID$(Stk$[iNextToken], 2)
                END IF

                CASE "closedialog"
                Ndx = 1
                IF ModDialogEvt THEN
                    Stk$[Ndx] = "EndDialog(hWnd,0)"
                ELSE
                    Stk$[Ndx] = "DestroyWindow(hWnd)"
                END IF

                CASE "cvd"
                Stk$[Tmp] ="CVD"
                Use_Cvd = Use_Proto = TRUE

                CASE "cvi"
                Stk$[Tmp] ="CVI"
                Use_Cvi = Use_Proto = TRUE

                CASE "cvl"
                Stk$[Tmp] ="CVL"
                Use_Cvl = Use_Proto = TRUE

                CASE "cvld"
                Stk$[Tmp] ="CVLD"
                Use_Cvld = Use_Proto = TRUE

                CASE "cvs"
                Stk$[Tmp] ="CVS"
                Use_Cvs = Use_Proto = TRUE

                CASE "chr$"
                Stk$[Tmp] = "$$chr$"
                Use_Chr = Use_BcxTempStr = TRUE

                CASE "chrtoutf8$"
                Stk$[Tmp] = "ChrToUtf8$"
                Use_Chrtoutf8 = Use_BcxTempStr = TRUE

                CASE "crlf$"
                Stk$[Tmp] = "CRLF$"
                Use_Crlf = Use_BcxTempStr = TRUE

                CASE "createregstring"
                Stk$[Tmp] = "CreateRegString"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_CreateRegString = Use_BcxTempStr = TRUE

                CASE "createregint"
                Stk$[Tmp] = "CreateRegInt"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_CreateRegInt = Use_BcxTempStr = TRUE

                CASE "cdbl"
                Stk$[Tmp] = "CDBL"
                Use_Cdbl = Use_SysMacros = TRUE

                CASE "center"
                Stk$[Tmp] = "Center"
                Use_Center = Use_Proto = TRUE
                IF Ndx >= 2 AND Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF

                CASE "cint"
                Stk$[Tmp] = "Cint"
                Use_Cint = Use_Proto = TRUE

                CASE "cldbl"
                Stk$[Tmp] = "CLDBL"
                Use_Cldbl = Use_SysMacros = TRUE

                CASE "clng"
                Stk$[Tmp] = "CLNG"
                Use_Clng = Use_Proto = TRUE

                CASE "clipboard_gettext", "clipboard_gettext$"
                Stk$[Tmp] = "Clipboard_GetText$()"
                Convert2SimpleFunction(Tmp)
                Use_Clip_Gettext = Use_BcxTempStr = TRUE

                CASE "clipboard_getbitmap"
                Stk$[Tmp] = "Clipboard_GetBitmap()"
                Convert2SimpleFunction(Tmp)
                Use_Clip_Getbitmap = TRUE

                CASE "clipboard_gettextsize"
                Stk$[Tmp] = "Clipboard_GetTextSize()"
                Convert2SimpleFunction(Tmp)
                Use_Clip_Gettextsize = Use_Proto = TRUE

                CASE "clipboard_settext"
                Stk$[Tmp] = "Clipboard_SetText"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Clip_Settext = TRUE

                CASE "clipboard_setbitmap"
                Stk$[Tmp] = "Clipboard_SetBitmap"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Clip_Setbitmap = TRUE

                CASE "clipboard_reset"
                Stk$[Tmp] = "Clipboard_Reset"
                Use_Clip_Reset = Use_SysMacros = TRUE

                CASE "cls"
                Stk$[Tmp] = "cls"
                Use_Cls = TRUE
                Use_Locate = Use_Console = Use_Proto = Use_Cursor = TRUE

                CASE "color", "color_fg", "color_bg"
                Stk$[Tmp] = LCASE$(Stk$[Tmp])
                Use_Color = Use_Console = Use_Proto = TRUE

                CASE "command$"
                Use_Command = Use_BcxTempStr = TRUE
                Stk$[Tmp] = "command$(-1)"
                IF Stk$ [Tmp+1] = "(" THEN
                    Stk$ [Tmp]= "command$"
                END IF

                CASE "comboboxloadfile"
                Stk$[Tmp] = "ComboBoxLoadFile"
                Use_ComboBoxLoadFile = TRUE
                Use_BcxTempStr = TRUE
                Use_Proto = TRUE
                Use_Trim  = TRUE



                CASE "cbool"
                Stk$[Tmp] = "CBOOL"
                Use_Cbool = Use_SysMacros = TRUE
                LOCAL iii, t, expos = 0
                DIM RAW fp AS FUNCPARSE
                CLEAR(fp)
                IF SepFuncArgs(Tmp+1, ADDRESSOF(fp), TRUE) = 0 THEN
                    CALL Abort("No argument specified in CBOOL")
                END IF

                FOR iii = fp.CommaPos[0] TO fp.CommaPos[1]
                    t = INCHR("!<>=", Stk$[iii])
                    IF t THEN
                        IF t < 4 THEN
                            IF Stk$[iii+1] = "=" THEN
                                Stk$[iii] = Stk$[iii] + Stk$[iii+1]
                                Stk$[iii+1] = ""
                            ELSEIF t = 1 AND Stk$[iii] <> "!=" THEN
                                ITERATE
                            END IF
                        ELSE
                            IF Stk$[iii+1] <> "=" THEN Stk$[iii] = "=="
                        END IF
                        expos = iii
                        EXIT FOR
                    END IF
                NEXT

                t = DataType(Stk$[expos-1])
                IF t = vt_STRLIT OR t = vt_STRVAR THEN
                    IF expos THEN
                        Stk$[Tmp+1] += "strcmp("
                        Stk$[fp.CommaPos[1]] = ")" + Stk$[expos] + "0)"
                        Stk$[expos] = ","
                        Src$ = ""
                        FOR iii = 1 TO Ndx
                            Src$ += Stk$[iii]
                            Src$ += SPC$
                        NEXT
                        FastLexer(Src$, SPC$, "(),")
                    END IF
                END IF

                CASE "csng"
                Stk$[Tmp] = "CSNG"
                Use_Csng = Use_SysMacros = TRUE

                CASE "cpad$"
                Stk$[Tmp] = "cpad$"
                Use_Cpad = Use_Join = Use_BcxTempStr = TRUE

                CASE "cursorx"
                Stk$[Tmp] = "Pos()"
                Use_Pos = Use_Proto = TRUE

                CASE "csrlin", "cursory"
                Stk$[Tmp]  = "Csrlin()"
                Use_Csrlin = Use_Proto  = TRUE

                CASE "curdir$"
                Stk$[Tmp] = "curdir$()"
                Convert2SimpleFunction(Tmp)
                Use_Curdir = Use_BcxTempStr = TRUE

                CASE "c_declare"
                CallType$ = "__cdecl "
                Stk$[Tmp] = "declare"
                IF iMatchWrd(Stk$[4], "lib") THEN
                    NoTypeDeclare = FALSE
                ELSE
                    NoTypeDeclare = TRUE
                END IF

            END SELECT

            CASE 4
            SELECT CASE Keyword$

                CASE "datacount"
                Stk$[Tmp] = "DATACOUNT"
                Use_Datacount = Use_SysMacros = TRUE

                CASE "declare"
                CallType$ = "__stdcall "
                Stk$[Tmp] = "declare"
                IF NOT iMatchWrd(Stk$[4], "lib") THEN
                    NoTypeDeclare = TRUE
                ELSE
                    NoTypeDeclare = FALSE
                END IF

                CASE "degtorad"
                Stk$[Tmp] = "DegToRad"
                Use_DegToRad = Use_SysMacros = TRUE

                CASE "dq$"
                Stk$[Tmp] = "DQ$"
                Use_DQ = Use_BcxTempStr = TRUE

                CASE "ddq$"
                Stk$[Tmp] = "DDQ$"
                Use_DDQ = Use_BcxTempStr = TRUE

                CASE "data"
                NoTrans = 1

                CASE "date$"
                IF Stk$[Tmp+1] <> "(" THEN
                    Stk$[Tmp] = "date$()"
                ELSE
                    Stk$[Tmp] = "date$"
                END IF
                Use_Date = Use_BcxTempStr = TRUE

                CASE "del$"
                Stk$[Tmp] = "del$"
                Use_Del = Use_BcxTempStr = Use_Proto = TRUE

                CASE "deleteregkey"
                Stk$[Tmp] = "DeleteRegKey"
                Use_DeleteRegKey = Use_BcxTempStr = TRUE

                CASE "diskfree"
                Stk$[Tmp] = "(UINT64) DiskFree"
                Use_Diskfree = Use_Proto = TRUE

                CASE "diskused"
                Stk$[Tmp] = "(UINT64) DiskUsed"
                Use_Diskused = Use_Proto = TRUE

                CASE "disksize"
                Stk$[Tmp] = "(UINT64) DiskSize"
                Use_Disksize = Use_Proto = TRUE

                CASE "dialog"
                Inject_Local_Bcx_RetVal = TRUE

                IF iMatchWrd(Stk$[1], "begin") THEN
                    IF Ndx = 4 AND iMatchWrd(Stk$[3], "as") THEN
                        InDialogEvt = TRUE
                    ELSEIF Ndx = 5 AND iMatchWrd(Stk$[4], "as") THEN
                        ' BEGIN MODAL DIALOG AS DialogOne
                        ' function 'Stk$[Ndx]' (hWnd AS HWND, Msg AS UINT, wParam AS WPARAM, lParam AS LPARAM) AS INT_PTR CALLBACK
                        ' INT_PTR CALLBACK DialogOne (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam)
                        ModDialogEvt = TRUE
                    ELSE
                        CALL Abort("Malformed Begin Dialog")
                    END IF
                    Src$ = "function " + Stk$[Ndx] + "(hWnd AS HWND,Msg AS UINT,wParam AS WPARAM,lParam AS LPARAM) AS INT_PTR CALLBACK"
                    FastLexer(Src$, SPC$, "(),")
                END IF

                CASE "destroysafearray"
                Stk$[Tmp] = "DestroySafeArray"
                Use_SafeArrays = TRUE

                CASE "doevents"
                Stk$[Tmp] = "DoEvents()"
                Convert2SimpleFunction(Tmp)
                Use_Doevents = Use_Proto = TRUE

                CASE "drawtransbmp"
                Stk$[Tmp] = "DrawTransBMP"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_DrawTransBMP = Use_Proto = TRUE


                CASE "draw"
                Stk$[Tmp] = "Draw"
                IF Tmp = Ndx THEN Abort ("DRAW command expects a string argument")
                CALL AddPenSizeVariables
                Use_BCX_Floodfill = Use_BCX_Line = Use_BCX_Lineto = Use_BCX_Preset = TRUE
                Use_BcxTempStr = Use_Bitmap = Use_DSplit = Use_Draw = Use_DrawStr = TRUE
                Use_DynamicA = Use_Instr = Use_Left = Use_Mid = Use_Proto = Use_QBColor = TRUE
                Use_Remove = Use_Replace = Use_Stristr = Use_UCaseTbl = Use_Ucase = Use_Val = TRUE
                Use_SysMacros = Use_Val = TRUE

                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF

                CASE "download"
                IF Tmp = Ndx THEN Abort ("DOWNLOAD command expects two string arguments")
                Stk$[Tmp] = "Download"
                Use_Download = Use_Proto = TRUE


                CASE "downloadtostr", "downloadtostr$"
                IF Tmp = Ndx THEN Abort ("DOWNLOADTOSTR command expects one string arguments")
                Stk$[Tmp] = "DownloadToStr"
                Use_Downloadtostr = Use_Download = TRUE
                Use_LoadFile = Use_BcxTempStr = Use_Lof = TRUE
                Use_Exist = Use_TempFileName = TRUE
                Use_LoadFile = Use_Get = Use_Tempdir = TRUE
                Use_SysMacros = Use_Proto = TRUE


                CASE "dsplit"
                Stk$[Tmp] = "DSplit"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BcxTempStr = TRUE
                Use_UCaseTbl = TRUE
                Use_Stristr = TRUE
                Use_Proto  = TRUE
                Use_DSplit = TRUE
                Use_Remove = TRUE
                Use_Mid    = TRUE
                Use_Left   = TRUE
                Use_Instr  = TRUE
                Use_Replace = TRUE

            END SELECT

            CASE  5
            SELECT CASE Keyword$

                CASE "enddraw"
                Stk$[Tmp] = "EndDraw"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Draw = TRUE

                CASE "endmodal"
                Stk$[Tmp] = "EndModal"
                Use_Show = Use_SysMacros = Use_ShowModal = Use_EndModal = TRUE

                CASE "editloadfile"
                Stk$[Tmp] = "EditLoadFile"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BcxTempStr = TRUE
                Use_SysMacros = TRUE
                Use_Elf     = TRUE
                Use_Exist   = TRUE
                Use_Get     = TRUE
                Use_Lof     = TRUE
                Use_Proto   = TRUE
                Use_Join    = TRUE


                CASE "enc$"
                Stk$[Tmp] = "$$enc$"
                Use_Enclose = Use_BcxTempStr = TRUE

                CASE "extract$"
                Stk$[Tmp] = "$$extract$"
                Use_Extract = Use_BcxTempStr = TRUE

                CASE "extractany$"
                Stk$[Tmp] = "$$extractany$"
                Use_ExtractAny = Use_BcxTempStr = TRUE

                CASE "eof$"
                Stk$[Tmp] = "EF$"
                Use_EF = Use_BcxTempStr = TRUE

                CASE "eof"
                Stk$[Tmp] = "EoF"
                Use_Eof = Use_BcxTempStr = TRUE
                REMOVE "#" FROM Stk$[Tmp+2]
                IF Stk$[Tmp+2] = "" THEN CALL Abort ("Bad EOF Argument")
                IF DataType(Stk$[Tmp+2]) = vt_NUMBER THEN
                    Stk$[Tmp+2]= "FP" + Stk$[Tmp+2]
                END IF


                CASE "equalto"
                Stk$[Tmp] = " EqualTo "
                Use_EqualTo = Use_SysMacros = TRUE


                CASE "esc$"
                Stk$[Tmp] = "ESC$"
                Use_ESC = Use_BcxTempStr = TRUE

                CASE "enum"
                DIM RAW iNamedEnum = 0
                IF Tmp = 3 THEN
                    iNamedEnum = iMatchWrd(Stk$[Tmp-1], "as")
                ELSE
                    IF Ndx = 3 THEN
                        iNamedEnum = iMatchWrd(Stk$[Tmp+1], "as")
                    END IF
                END IF
                IF Ndx = 1 OR iNamedEnum THEN
                    Use_EnumFile = TRUE
                    DIM RAW szNameOfEnum$
                    '******************************************************
                    '     We're dealing with a ENUM - END ENUM block
                    '******************************************************
                    DIM RAW EnumFlag = FALSE
                    FPRINT FP_ENU, ""
                    IF iNamedEnum THEN
                        IF Tmp = 3 THEN
                            szNameOfEnum$ = Stk$[Tmp-2]
                            FPRINT FP_ENU, "typedef enum _", szNameOfEnum$
                        ELSE
                            szNameOfEnum$ = Stk$[Tmp+2]
                            FPRINT FP_ENU, "typedef enum _", szNameOfEnum$
                        END IF
                        szNameOfEnum$ = SPC$ + szNameOfEnum$
                    ELSE
                        szNameOfEnum$ = ""
                        FPRINT FP_ENU, "enum"
                    END IF
                    FPRINT FP_ENU, "  {"
                    Src$ = ""
                    DO WHILE NOT iMatchLft(Src$, "end ")

                        IF EOF(SourceFile) THEN
                            CALL Abort ("Unbalanced ENUM")
                        END IF

                        LINE INPUT SourceFile, Src$
                        INCR LineNum[FileNdx]
                        CALL StripCode(Src$)
                        IF iMatchLft(Src$, "$comme") THEN
                            DIM RAW ccc
                            CALL Docomment(Src$, ADDRESSOF(ccc))
                            ITERATE
                        END IF
                        Src$ = TRIM$(Src$)
                        IF ISNULL(Src$) THEN ITERATE ' line starts with comment
                        IF LEFTSTR(Src$ + SPC$, "end ", TRUE) THEN
                            EXIT DO
                        ELSE
                            IF EnumFlag = FALSE THEN
                                EnumFlag = TRUE
                            ELSE
                                FPRINT FP_ENU, ","
                            END IF
                        END IF
                        FPRINT FP_ENU, "    ", RTRIM$(Src$); ' Suppress CRLF
                    LOOP
                    Src$ = ""
                    Ndx = 0
                    FPRINT FP_ENU, ""
                    FPRINT FP_ENU, "  }", szNameOfEnum$, ";\n"
                    EXIT SUB
                END IF
                DIM RAW iEquallLoc = Tmp+2
                IF Stk$[iEquallLoc] = "=" THEN
                    ' enum ONE=3
                    ' enum ONE{ONE=3};
                    Stk$[Tmp] = "enum "
                    CALL InsertTokens(iEquallLoc-1, 2, "{", Stk$[Tmp+1])
                    Stk$[++Ndx] = "}"
                    EXIT SUB
                END IF

                '*************************************************************
                '  We're dealing with a smaller, single line ENUM statement
                '*************************************************************

                Stk$[1] = "enum {"
                FOR j = 2 TO Ndx
                    Stk$[1] += Stk$[j]
                NEXT
                Stk$[1] += "}"
                Ndx = 1

                CASE "environ$"
                Stk$[Tmp] = "Environ$"
                Use_Environ = Use_BcxTempStr = TRUE

                CASE "exist"
                Stk$[Tmp] = "Exist"
                Use_Exist = Use_Proto = Use_BcxTempStr = TRUE

                CASE "exp"
                Stk$[Tmp] = "Exp"
                Use_Exp = Use_Proto = TRUE

            END SELECT


            CASE  6
            SELECT CASE Keyword$

                CASE "for_each"
                Stk$[Tmp] = "FOR_EACH"
                Use_ForEach = Use_SysMacros = TRUE

                CASE "ff$"
                Stk$[Tmp] = "FF$"
                Use_FF = Use_BcxTempStr = TRUE

                CASE "function"
                IF Stk$[Tmp+1] = "=" THEN
                    IF Stk$[Tmp+2] = DDQ$ THEN Stk$[Tmp+2] = "NUL$"
                    Stk$[Tmp] = "functionreturn"
                ELSE
                    Stk$[Tmp] = "function"
                    IF UseCpp OR UseCpphdr THEN CALL FuncSubTemplate(Tmp)
                END IF

                CASE "false"
                Stk$[Tmp] = "FALSE"

                CASE "findintype"
                ' Convert this :FindInType(char *Token, Type.member, int c)
                ' To this      :FindInType(char *Token, Stptr + offsetof(Type,member), sizeof(Type), int c)

                Stk$[Tmp] = "FindInType"
                Use_FindInType = Use_Proto = Use_BCX_stricmp = TRUE

                DIM RAW StMem$, StName$, VarName$
                DIM RAW fp AS FUNCPARSE
                CLEAR(fp)
                CALL SepFuncArgs(Tmp, ADDRESSOF(fp), TRUE)

                StMem$   = REMAIN$(Clean$(GetArg$(2, ADDRESSOF(fp))), ".")
                VarName$ = EXTRACT$(Clean$(GetArg$(2, ADDRESSOF(fp))), ".")

                FOR j = fp.CommaPos[1] + 1 TO fp.CommaPos[2] - 1
                    Stk$[j] = ""
                NEXT

                IF CheckLocal(VarName$, ADDRESSOF(i)) <> vt_UNKNOWN THEN
                    StName$ = TypeDefs[LocalVars[i].VarDef].VarName$
                ELSEIF CheckGlobal(VarName$, ADDRESSOF(i)) <> vt_UNKNOWN THEN
                    StName$ = TypeDefs[GlobalVars[i].VarDef].VarName$
                END IF

                j = fp.CommaPos[1] + 1
                Stk$[j] =  "(char*)" + VarName$ + " + offsetof(" + StName$ + "," + StMem$ + "), sizeof(" + StName$ + ")"

                CASE "fillarray"
                Stk$[Tmp] = "fillarray"
                Use_FillArray = TRUE
                Use_Proto = TRUE

                CASE "findfirst$"
                Stk$[Tmp] = "findfirst$"
                Use_Findfirst = Use_BcxTempStr = TRUE

                CASE "findfirstinstance"
                Stk$[Tmp] = "FindFirstInstance"
                Use_FirstInstance = TRUE

                CASE "findnext$"
                Stk$[Tmp] = "findnext$()"
                Convert2SimpleFunction(Tmp)
                Use_Findnext = Use_BcxTempStr = TRUE

                CASE "fint"
                Stk$[Tmp] = "FINT"    ' fint is temporary, only used for parsing

                CASE "fix"
                Stk$[Tmp] = "FIX"
                Use_Fix = Use_SysMacros = TRUE

                CASE "filelocked"
                Stk$[Tmp] = "FileLocked"
                Use_FileLocked = Use_Proto = TRUE

                CASE "ftell"      ' Typical FTELL usage:  int = ftell (FILE*)
                Stk$[Tmp] = "_ftelli64"
                FOR INT f = Tmp + 1 TO Ndx
                    REMOVE "#" FROM Stk$[f]
                    IF ISNULL(Stk$[f]) THEN CALL Abort ("Bad or Missing FTELL Argument")
                    IF DataType(Stk$[f]) = vt_NUMBER THEN
                        Stk$[f]= "FP" + Stk$[f]
                        IF CheckLocal(Stk$[f], ADDRESSOF(f)) = vt_UNKNOWN THEN
                            IF CheckGlobal(Stk$[f], ADDRESSOF(f)) = vt_UNKNOWN THEN
                                CALL AddGlobal(Stk$[f], vt_FILEPTR)
                                EXIT SELECT
                            END IF
                        END IF
                    END IF
                NEXT

                CASE "frac"
                Stk$[Tmp] = "FRAC"
                Use_Fix = Use_Frac = Use_SysMacros = TRUE

                CASE "fracl"
                Stk$[Tmp] = "FRACL"
                Use_Fix = Use_Fracl = Use_SysMacros = TRUE


                CASE "freefile"
                Stk$[Tmp] = "FreeFile()"
                Use_Freefile = Use_Proto = TRUE

                CASE "function"
                IF Stk$[2] ?? "main" THEN
                    NoMain = TRUE
                END IF
            END SELECT

            CASE  7
            SELECT CASE Keyword$

                CASE "getdimension"
                Stk$[Tmp] = "GetDimension"
                Use_GetDimension = Use_Proto = TRUE


                CASE "getobject"
                ' COM version of getobject uses only one param,
                ' while Windows API has three params:  Ndx > 6.

                IF Ndx < 7 THEN
                    ComSwitchON            = TRUE
                    Use_COM                = TRUE
                    Use_COM_CreateObject   = TRUE
                    Use_COM_DispatchObject = TRUE
                    Use_COM_GetObject      = TRUE
                    Use_COM_GetProperty    = TRUE
                    Use_COM_InvokeMethod   = TRUE
                    Use_COM_SafeArray      = TRUE
                    Use_COM_SetProperty    = TRUE
                    Use_COM_UsesConversion = TRUE

                    Stk$[3] = Stk$[5]
                    sprintf(Stk[5], "&%s", Stk[1])
                    Stk$[1] = "BCX_GetObject"
                    Stk$[2] = "("
                    Stk$[4] = ","
                END IF

                CASE "getprocaddress"
                LOCAL GlobalName$
                LOCAL s
                LOCAL GlobalNameHash AS ULONGLONG
                LOCAL Atemp$
                GlobalName$ = Stk$[Tmp-2]
                GlobalNameHash = HashNumber(GlobalName$)

                DO WHILE GlobalVarHash[GlobalNameHash]
                    s = GlobalVarHash[GlobalNameHash]
                    DIM RAW ptGlobal AS VARINFO PTR
                    ptGlobal = ADDRESSOF(GlobalVars[s])
                    IF GlobalName$ = ptGlobal->VarName$ THEN
                        Atemp$ = TypeDefs[ptGlobal->VarDef].VarName$
                        IF ptGlobal->VarPntr THEN
                            Atemp$ += " *"
                        END IF
                    END IF
                    GlobalNameHash = IMOD(GlobalNameHash + 1, MaxGlobalVars)
                LOOP

                IF Atemp$ = "" THEN
                    LOCAL LocalName$
                    LocalName$ = Stk$[Tmp-2]
                    IF LocalVarCnt THEN
                        FOR INT yy = 1 TO LocalVarCnt
                            IF LocalName$ = LocalVars[yy].VarName$ THEN
                                Atemp$ = TypeDefs[LocalVars[yy].VarDef].VarName$
                                IF LocalVars[yy].VarPntr THEN
                                    Atemp$ += " *"
                                END IF
                                EXIT FOR
                            END IF
                        NEXT
                    END IF
                END IF

                IF Atemp$ <> "" THEN
                    Stk$[Tmp] = "(" + Atemp$ + ")GetProcAddress"
                ELSE
                    Stk$[Tmp] = "GetProcAddress"
                END IF

                CASE "getattr"
                Stk$[Tmp] = "GETATTR"
                Use_Getattr = Use_SysMacros = TRUE


                CASE "gethttpfilesize"
                Stk$[Tmp] = "GetHttpFileSize"
                Use_Gethttpfilesize = TRUE


                CASE "gettextsize"
                Stk$[Tmp] = "GetTextSize"
                Use_GetTextSize = Use_Proto = TRUE


                CASE "getc"
                Stk$[Tmp] = "getc"
                REMOVE "#" FROM Stk$[Tmp+2]
                IF DataType(Stk$[Tmp+2]) = vt_NUMBER THEN
                    Stk$[Tmp+2]= "FP" + Stk$[Tmp+2]
                END IF

                CASE "getbmp"
                Stk$[Tmp] = "GetBmp"
                Use_GetBmp = Use_Proto = Use_BcxTempStr = TRUE

                CASE "getdrive"
                Stk$[Tmp] = "_getdrive()"
                Convert2SimpleFunction(Tmp)
                Use_Getdrive = Use_Proto = TRUE

                CASE "getfilename$"
                Stk$[Tmp] = "$$GetFileName$"
                Use_Getfilename = Use_Hook = TRUE

                CASE "getsaveasfilename$"
                Stk$[Tmp] = "GetSaveAsFileName$"
                Use_GetSaveAsFilename = TRUE

                CASE "getresource"
                Stk$[Tmp] = "GetResource"
                Use_GetResource = Use_Proto = TRUE

                CASE "getspecialfolder$", "getspecialfolder"
                Stk$[Tmp] = "$$GetSpecialFolder$"
                Use_GetSpecialFolder = TRUE
                Use_Proto = Use_BcxTempStr = TRUE

                CASE "getspecialfolderex$"
                Stk$[Tmp] = "GetSpecialFolderEx$"
                Use_GetSpecialFolderex = TRUE
                Use_Proto = Use_BcxTempStr = TRUE
                Use_WideToAnsi = TRUE

            END SELECT

            CASE  8
            SELECT CASE Keyword$
                CASE "hex$"
                Stk$[Tmp] = "hex$"
                Use_Hex = Use_BcxTempStr = TRUE

                CASE "hex2dec"
                Stk$[Tmp] = "Hex2Dec"
                Use_Hex2Dec = Use_Proto = TRUE

                CASE "hide"
                Stk$[Tmp] = "HIDEHWND"
                Use_Hide = Use_SysMacros = TRUE
                IF Ndx >= 2 AND Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)     ' Allow unparenthesized expressions
                END IF

            END SELECT

            CASE  9
            SELECT CASE Keyword$

                CASE "icompare"
                Stk$[Tmp] = "bcx_stricmp"
                Use_BCX_stricmp = TRUE

                CASE "instr"
                Stk$[Tmp] = "instr"
                Use_Instr = Use_Proto = TRUE
                Use_Stristr = Use_UCaseTbl = TRUE

                CASE "iinstr"
                Stk$[Tmp] = "iinstr"
                Use_IInstr = Use_Proto = TRUE
                Use_Stristr = Use_UCaseTbl = TRUE


                CASE "instrany"
                Stk$[Tmp] = "InstrAny"
                Use_InstrAny = Use_Instr = Use_Proto = TRUE
                Use_Mid = Use_BcxTempStr = Use_Stristr = Use_UCaseTbl = TRUE

                CASE "iinstrany"
                Stk$[Tmp] = "IInstrAny"
                Use_IInstrAny = Use_IInstr = Use_Proto = TRUE
                Use_Mid = Use_BcxTempStr = Use_Stristr = Use_UCaseTbl = TRUE

                CASE "inchr"
                Stk$[Tmp] = "inchr"
                Use_Inchr = Use_Proto = TRUE

                CASE "imod"
                Stk$[Tmp] = "imod"
                Use_Imod = Use_SysMacros = TRUE

                CASE "iif"
                Stk$[Tmp] = "iif"
                Use_Iif = Use_Proto = TRUE
                FOR i = Tmp+1 TO Ndx
                    IF Stk$[i] = "=" THEN
                        IF Stk$[i-1] <> "<" AND Stk$[i-1] <> ">" THEN
                            Stk$[i] = "=="
                        END IF
                    END IF
                NEXT

                CASE "iif$"
                Stk$[Tmp] = "sziif$"
                Use_sziif = Use_Proto = TRUE
                FOR i = Tmp+1 TO Ndx
                    IF Stk$[i] = "=" THEN
                        IF Stk$[i-1] <> "<" AND Stk$[i-1] <> ">" THEN
                            Stk$[i] = "=="
                        END IF
                    END IF
                NEXT

                CASE "initsafearray"
                Stk$[Tmp] = "InitSafeArray"
                Use_SafeArrays = TRUE
                Stk$[Tmp+2] = "&" + Stk$[Tmp+2]


                CASE "inkey"
                Use_BcxTempStr = Use_Proto = Use_InkeyD = TRUE
                Stk$[Tmp] = "inkeyd()"
                Convert2SimpleFunction(Tmp)

                CASE "inkey$"
                Use_BcxTempStr = Use_Proto = Use_Inkey = TRUE
                Stk$[Tmp] = "inkey$()"
                Convert2SimpleFunction(Tmp)

                CASE "inline"
                IF Tmp = 1 THEN
                    Stk$[1] = ""
                    UseInLine = TRUE
                    CALL RemEmptyTokens
                    DECR Tmp
                END IF

                CASE "inputbox$"
                Stk$[Tmp] = "InputBox$"
                Use_BoxCommon = Use_Inputbox = Use_BcxTempStr = TRUE

                CASE "infobox"
                Stk$[Tmp] = "InfoBox"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_BoxCommon = Use_Infobox = Use_BcxTempStr = TRUE

                CASE "ins$"
                Stk$[Tmp] = "ins$"
                Use_Ins = Use_Proto = Use_BcxTempStr = TRUE

                CASE "instrrev"
                Stk$[Tmp] = "InstrRev"
                Use_Instrrev = Use_Proto = TRUE

                CASE "isodate$"
                IF Stk$[Tmp+1] <> "(" THEN
                    Stk$[Tmp] = "isodate$()"
                ELSE
                    Stk$[Tmp] = "isodate$"
                END IF
                Use_IsoDate = Use_BcxTempStr = TRUE

                CASE "isptr"
                Stk$[Tmp] = "IsPtr"
                Use_Isptr = Use_SysMacros = TRUE

                CASE "istrue"
                Stk$[Tmp] = "ISTRUE"
                Use_Istrue = Use_SysMacros = TRUE

                CASE "isfalse"
                Stk$[Tmp] = "ISFALSE"
                Use_Isfalse = Use_SysMacros = TRUE

                CASE "iszero"
                Stk$[Tmp] = "ISZERO"
                Use_Iszero = Use_SysMacros = TRUE

                CASE "isnull"
                Stk$[Tmp] = "ISNULL"
                Use_Isnull = Use_SysMacros = TRUE

                CASE "issystem"
                Stk$[Tmp] = "issystem"
                Use_Issystem = Use_BcxTempStr = TRUE

                CASE "ishidden"
                Stk$[Tmp] = "ishidden"
                Use_Ishidden = Use_BcxTempStr = TRUE

                CASE "isreadonly"
                Stk$[Tmp] = "isreadonly"
                Use_Isreadonly = Use_BcxTempStr = TRUE

                CASE "isfile"
                Stk$[Tmp] = "isfile"
                Use_Isfile = Use_BcxTempStr = TRUE

                CASE "isfolder"
                Stk$[Tmp] = "isfolder"
                Use_Isfolder = Use_BcxTempStr = TRUE

                CASE "ireplace$"
                Stk$[Tmp] = "iReplace$"
                Use_iReplace = Use_Stristr = Use_BcxTempStr = TRUE
                Use_UCaseTbl = TRUE

                CASE "ireplaceany$"
                Stk$[Tmp] = "IReplaceAny$"
                Use_IReplaceAny = Use_BcxTempStr = TRUE

                CASE "iremove$"
                Stk$[Tmp] = "IRemoveStr$"
                Use_IRemove = Use_BcxTempStr = TRUE
                Use_Stristr = Use_UCaseTbl = TRUE

                CASE "iremoveany$"
                Stk$[Tmp] = "IRemoveAny$"
                Use_IRemoveAny = Use_BcxTempStr = TRUE

            END SELECT

            CASE  10
            SELECT CASE Keyword$
                CASE "join$"
                Stk$[Tmp] = "$$join$"
                Use_Join = Use_BcxTempStr = TRUE
            END SELECT

            CASE  11
            SELECT CASE Keyword$
                CASE "keypress"
                Stk$[Tmp] = "keypress()"
                Convert2SimpleFunction(Tmp)
                Use_Keypress = Use_Proto = TRUE
            END SELECT

            CASE  12
            SELECT CASE Keyword$

                CASE "land"
                Stk$[Tmp] = " &&"

                CASE "lor"
                Stk$[Tmp] = " ||"

                CASE "local"
                IF iMatchWrd(Stk$[Tmp+1], "dynamic") THEN
                    Stk$[Tmp] = "dim"
                END IF

                CASE "lccpath$"
                Stk$[Tmp] = "LccPath$()"
                Convert2SimpleFunction(Tmp)

                Use_LccPath = Use_RegString = Use_Instrrev = TRUE
                Use_Left = Use_BcxTempStr = TRUE

                CASE "loadfile$"
                Stk$[Tmp] = "$$LoadFile$"
                Use_LoadFile = Use_Get = Use_BcxTempStr = TRUE
                Use_SysMacros = Use_Exist = Use_Lof = TRUE

                CASE "listboxloadfile"
                Stk$[Tmp] = "ListBoxLoadFile"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_ListBoxLoadFile = TRUE
                Use_GetTextSize     = TRUE
                Use_Proto           = TRUE
                Use_Trim            = TRUE
                Use_String          = TRUE
                Use_BcxTempStr       = TRUE
                Use_Eof = TRUE

                CASE "lf$"
                Stk$[Tmp] = "LF$"
                Use_LF = Use_BcxTempStr = TRUE

                CASE "line"
                IF iMatchWrd(Stk$[Tmp+1], "input") THEN
                    Stk$[Tmp] = "lineinput"
                    j = Tmp + 4
                    Stk$[Tmp+1] = ""      ' Extract the file handle
                    FOR i = Tmp+2 TO Ndx
                        IF *Stk$[i] = ASC(",") THEN j = i+1 : EXIT FOR
                        Stk$[Tmp+1] = Stk$[Tmp+1] + Stk$[i]
                        Stk$[i] = ""
                    NEXT j

                    FOR i = j TO Ndx
                        Stk$[Tmp+2]= Stk$[Tmp+2] + Stk$[i]
                    NEXT
                END IF

                CASE "lcase$"
                IF iSubLoc = 2 THEN
                    IF Stk$[Tmp+1] = "(" THEN
                        Abort("'lcase' can only be used as a Function Pointer when in a SET")
                    END IF
                    Stk$[Tmp] = "lcase"
                ELSE
                    Stk$[Tmp] = "$$lcase$"
                END IF
                Use_Lcase = Use_BcxTempStr = TRUE

                CASE "ldouble"
                Stk$[Tmp] = "LDOUBLE"
                Use_Ldouble = Use_BcxTempStr = TRUE

                CASE "left$"
                Stk$[Tmp] = "$$left$"
                Use_Left = Use_BcxTempStr = TRUE

                CASE "leftstr"
                Stk$[Tmp] = "LeftStr"
                Use_LeftStr = Use_Left = Use_Lcase = Use_BcxTempStr = TRUE

                CASE "lprint"
                Stk$[Tmp] = "lprint"
                IF Tmp = Ndx THEN
                    INCR Ndx
                    Stk$[Ndx] = ENC$ ("")  ' Allow LPRINT with no args
                END IF

                CASE "lpad$"
                Stk$[Tmp] = "$$lpad$"
                Use_Lpad = Use_BcxTempStr = TRUE

                CASE "ltrim$"
                Stk$[Tmp] = "$$ltrim$"
                Use_Ltrim = Use_BcxTempStr = TRUE

                CASE "lof"
                Stk$[Tmp] = "lof"
                Use_Lof = Use_Proto = TRUE

                CASE "like"
                Stk$[Tmp] = "like"
                Use_Like  = Use_Proto = TRUE


                CASE "lclick"
                Stk$[Tmp] = "lClick()"
                Convert2SimpleFunction(Tmp)
                Use_Lclick = Use_Proto = TRUE


                CASE "like_instr"
                Stk$[Tmp] = "Like_Instr"
                Use_Like_Instr = Use_Ucase = Use_BcxTempStr = Use_Proto = Use_Mid = TRUE

                CASE "loc"
                DIM RAW Tmp2 = Tmp + 2
                IF DataType(Stk$[Tmp2]) = vt_NUMBER THEN
                    Stk$[Tmp2] = "FP" + Stk$[Tmp2]
                END IF
                REMOVE "#" FROM Stk$[Tmp2]
                Stk$[Tmp] = "loc(" + Stk$[Tmp2] + "," + Stk$[Tmp2] + "len)"
                Stk$[Tmp + 1] = ""
                Stk$[Tmp2] = ""
                Stk$[Tmp + 3] = ""
                Use_Loc = TRUE

                CASE "locate"
                Stk$[Tmp] = "locate"
                Use_Locate = Use_Console = Use_Proto = Use_Cursor = TRUE

                CASE "longestline"
                Stk$[Tmp] = "LongestLine"
                Use_Longestline = Use_Eof = Use_Proto = TRUE


                CASE "lookahead$"
                Stk$[Tmp] = "LookAhead$"
                REMOVE "#" FROM Stk$[Tmp+2]
                IF DataType(Stk$[Tmp+2]) = vt_NUMBER THEN
                    Stk$[Tmp+2]= "FP" + Stk$[Tmp+2]
                END IF
                Use_Lookahead = Use_NamePathFromFP = Use_Eof = Use_Proto = Use_BcxTempStr =  TRUE

            END SELECT

            CASE  13
            SELECT CASE Keyword$

                CASE "makebmp"
                Stk$[Tmp] = "MakeBmp"
                Use_Makebmp = Use_Proto = TRUE

                CASE "makehdc"
                Stk$[Tmp] = "MakeHdc"
                Use_Makehdc = Use_Proto = TRUE

                '*********************************************************
                ' Special Case Handler: Substitute "Me." with "Me->"
                '*********************************************************

                CASE "me"
                Stk$[Tmp] = "Me"
                DIM RAW Tmp1 = Tmp + 1
                IF *Stk$[Tmp1] = ASC(".") THEN
                    IF InFunction THEN Stk$[Tmp1] = "->" + MID$(Stk$[Tmp1], 2)
                END IF

                CASE "mkd$"
                IF Tmp > 2 THEN
                    IF INCHR(Stk$[Tmp-2], "$") AND *Stk$[Tmp-1] = ASC("=") THEN
                        Stk$[1] = "memcpy(" + Stk$[1]
                        Stk$[Tmp-1] = ","
                        Stk$[++Ndx] = ",9)"
                    END IF
                END IF
                Stk$[Tmp] ="MKD"
                Use_Mkd = Use_BcxTempStr = TRUE

                CASE "mki$"
                IF Tmp > 2 THEN
                    IF INCHR(Stk$[Tmp-2], "$") AND *Stk$[Tmp-1] = ASC("=") THEN
                        Stk$[1] = "memcpy(" + Stk$[1]
                        Stk$[Tmp-1] = ","
                        Stk$[++Ndx] = ",3)"
                    END IF
                END IF
                Stk$[Tmp] ="MKI"
                Use_Mki = Use_BcxTempStr = TRUE

                CASE "mkl$"
                IF Tmp > 2 THEN
                    IF INCHR(Stk$[Tmp-2], "$") AND *Stk$[Tmp-1] = ASC("=") THEN
                        Stk$[1] = "memcpy(" + Stk$[1]
                        Stk$[Tmp-1] = ","
                        Stk$[++Ndx] = ",5)"
                    END IF
                END IF
                Stk$[Tmp] ="MKL"
                Use_Mkl = Use_BcxTempStr = TRUE

                CASE "mkld$"
                IF Tmp > 2 THEN
                    IF INCHR(Stk$[Tmp-2], "$") AND *Stk$[Tmp-1] = ASC("=") THEN
                        Stk$[1] = "memcpy(" + Stk$[1]
                        Stk$[Tmp-1] = ","
                        Stk$[++Ndx] = ",11)"
                    END IF
                END IF
                Stk$[Tmp] ="MKLD"
                Use_Mkld = Use_BcxTempStr = TRUE

                CASE "mks$"
                IF Tmp > 2 THEN
                    IF INCHR(Stk$[Tmp-2], "$") AND *Stk$[Tmp-1] = ASC("=") THEN
                        Stk$[1] = "memcpy(" + Stk$[1]
                        Stk$[Tmp-1] = ","
                        Stk$[++Ndx] = ",5)"
                    END IF
                END IF
                Stk$[Tmp] ="MKS"
                Use_Mks = Use_BcxTempStr = TRUE

                CASE "mid$"
                IF Tmp > 1 THEN
                    Stk$[Tmp] = "$$mid$"
                    Use_Mid = Use_BcxTempStr = TRUE
                ELSE
                    Stk$[Tmp] = "midstr"
                    Use_Midstr = TRUE
                END IF

                CASE "min"
                Stk$[Tmp] = "MIN"
                Use_Min = Use_Proto = TRUE

                CASE "max"
                Stk$[Tmp] = "MAX"
                Use_Max = Use_Proto = TRUE

                CASE "mcase$"
                IF iSubLoc = 2 THEN
                    IF Stk$[Tmp+1] = "(" THEN
                        Abort("'mcase' can only be used as a Function Pointer when in a SET")
                    END IF
                    Stk$[Tmp] = "mcase"
                ELSE
                    Stk$[Tmp] = "$$mcase$"
                END IF
                Use_Mcase = Use_BcxTempStr = TRUE

                CASE "mkpath"
                Stk$[Tmp] = "MkPath"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Mkpath = Use_Chr = Use_Instr = Use_Mid =TRUE
                Use_Join = Use_Split = Use_Replace = Use_UCaseTbl = TRUE
                Use_Proto = Use_Remove = Use_BcxTempStr = Use_Stristr = TRUE

                CASE "modstyle"
                Stk$[Tmp] = "ModStyle"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Modstyle = Use_Proto = TRUE

                CASE "mouse_sx"
                Stk$[Tmp] = "MOUSE_SX"
                Use_Mouse_sx = Use_Proto = TRUE

                CASE "mouse_sy"
                Stk$[Tmp] = "MOUSE_SY"
                Use_Mouse_sy = Use_Proto = TRUE

                CASE "mouse_cx"
                Stk$[Tmp] = "MOUSE_CX"
                Use_Mouse_cx = Use_Proto = TRUE

                CASE "mouse_cy"
                Stk$[Tmp] = "MOUSE_CY"
                Use_Mouse_cy = Use_Proto = TRUE

                CASE "msgbox"
                DIM RAW Tmm1 = Tmp - 1
                IF Stk$[Tmm1]= "=" OR iMatchWrd(Stk$[Tmm1], "if") OR iMatchWrd(Stk$[Tmm1], "elseif") THEN
                    Stk$[Tmp] = "MsgBox"
                    Use_Msgbox = Use_Proto = TRUE
                END IF
            END SELECT

            CASE  14
            SELECT CASE Keyword$

                CASE "next_each"
                Use_ForEach = Use_SysMacros = TRUE
                Stk$[Tmp] = "NEXT_EACH"

                IF Stk$ [Tmp+1] <> "(" THEN EXIT SELECT ' No argument was passed
                INCR Tmp
                ' Remove the unneeded argument, example: NEXT_EACH (ii)
                DO UNTIL Tmp > Ndx
                    Stk$[Tmp] = ""
                    INCR Tmp
                LOOP

                CASE "new"
                IF iMatchWrd(Stk$[Tmp-1], "binary") THEN EXIT SELECT
                UseCpp = TRUE
                Stk$[Tmp] = "new "

                CASE "newbmp"
                Stk$[Tmp] = "NewBmp()"
                Use_Newbmp = Use_Proto = TRUE

                CASE "nextlinelen"
                Stk$[Tmp] = "NextLineLen"
                Use_Nextlinelen = Use_Proto = TRUE

                ' For compatibility with VB code, See CreateObject for more details what I'm doin' here

                CASE "nothing"
                ComSwitchON = Use_COM = TRUE

                ' Next line should be called only if NOT inside (IF...END IF)
                ' BCX_Remove_COM_Object(Stk$[1]) '  disabled until I figure out is it called from (IF...END IF)

                DIM RAW sObj$
                DIM RAW ii = 2
                sObj$ = "&" + Stk$[1]
                DO WHILE Stk$[ii] <> "="
                    sObj$ += Stk$[ii]
                    INCR ii
                LOOP

                Stk$[1] = "BCX_SetNothing"
                Stk$[2] = "("
                Stk$[3] = sObj$
                Stk$[4] = ")"
                Ndx = 4

                CASE "notzero"
                Stk$[Tmp] = "NOTZERO"
                Use_Notzero = Use_SysMacros = TRUE

                CASE "notnull"
                Stk$[Tmp] = "NOTNULL"
                Use_Notnull = Use_SysMacros = TRUE

                CASE "notequalto"
                Stk$[Tmp] = " NotEqualTo "
                Use_NotEqualTo = Use_SysMacros = TRUE

                CASE "nul$"
                Stk$[Tmp] = "NUL$"
                Use_NUL = Use_BcxTempStr = TRUE

                CASE "now$"
                IF Stk$[Tmp+1]<> "(" THEN
                    Stk$[Tmp] = "now$()"
                ELSE
                    Stk$[Tmp] = "now$"
                END IF
                Use_Now = Use_BcxTempStr = TRUE
            END SELECT

            CASE  15
            SELECT CASE Keyword$

                CASE "object"
                ComSwitchON = Use_COM = Use_BcxTempStr = TRUE
                Stk$[Tmp] = "OBJECT"

                CASE "open"
                FOR A = Tmp + 1 TO Ndx
                    IF *Stk$[A] = ASC("#") THEN
                        Stk$[A] = MID$(Stk$[A], 2)
                        EXIT FOR
                    END IF
                NEXT

                CASE "oct$"
                Stk$[Tmp] = "oct$"
                Use_Oct = Use_BcxTempStr = TRUE

                CASE "or", "orelse"                  ' OR can be Boolean or bitwise
                Stk$[Tmp] = " || "               ' but ORELSE is ALWAYS Boolean

                CASE "osversion"
                Stk$[Tmp] = "OSVersion()"
                Convert2SimpleFunction(Tmp)
                CALL Emit_OSVersionEnum
                Use_OSVersion = Use_Proto = TRUE

            END SELECT

            CASE  16
            SELECT CASE Keyword$

                CASE "pellespath$"
                Stk$[Tmp] = "PellesPath$()"
                Convert2SimpleFunction(Tmp)
                Use_PellesPath = Use_RegString = Use_Instrrev = TRUE
                Use_Left = Use_BcxTempStr = TRUE


                CASE "putc"                                  ' MrBcx 819 (New)
                Stk$[Tmp] = "putc"                           ' MrBcx 819 (New)

                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)         ' Allow unparenthesized expressions
                END IF


                REMOVE "#" FROM Stk$[Tmp + 2]                ' MrBcx 819 (New)
                IF DataType(Stk$[Tmp + 2]) = vt_NUMBER THEN  ' MrBcx 819 (New)
                    Stk$[Tmp + 2] = "FP" + Stk$[Tmp + 2]     ' MrBcx 819 (New)
                END IF                                       ' MrBcx 819 (New)
                '                                            ' MrBcx 819 (New)  Rearrange: putc ( fp# ,  byte-expreession )
                '                                            ' MrBcx 819 (New)         to: putc ( byte-expression, fp# )
                DIM fp$                                      ' MrBcx 819 (New)
                fp$ = Stk$[Tmp + 2]                          ' MrBcx 819 (New)
                LShiftStk(Tmp + 2)                           ' MrBcx 819 (New)
                LShiftStk(Tmp + 2)                           ' MrBcx 819 (New)
                Stk$[Ndx] = ","                              ' MrBcx 819 (New)
                INCR Ndx                                     ' MrBcx 819 (New)
                Stk$[Ndx] = fp$                              ' MrBcx 819 (New)
                INCR Ndx                                     ' MrBcx 819 (New)
                Stk$[Ndx] = ")"                              ' MrBcx 819 (New)


                CASE "printer"
                DIM RAW Tmp1 = Tmp+1
                IF *Stk$[Tmp1] THEN
                    IF iMatchWrd(Stk$[Tmp1], "open")      THEN Stk$[Tmp] = "printeropen"
                    IF iMatchWrd(Stk$[Tmp1], "ejectpage") THEN Stk$[Tmp] = "ejectpage"
                    IF iMatchWrd(Stk$[Tmp1], "close")     THEN Stk$[Tmp] = "printerclose"

                    IF iMatchWrd(Stk$[Tmp], "printer")    THEN
                        CALL Abort ("Unknown word '" + Stk$[Tmp1] + "' with printer")
                    END IF

                    LShiftStk(Tmp1)
                ELSE
                    Ndx = 0
                END IF
                Use_Printer = Use_Proto = TRUE
                iEmitVarGroup = iEmitVarGroup BOR ePrinterGroup
                Use_Mid = Use_Left = TRUE
                Use_Extract = Use_Str = Use_BcxTempStr = TRUE

                CASE "print"
                IF *Stk$[Tmp+1] = ASC("#") THEN
                    Stk$[Tmp] = "fprint"
                    Stk$[Tmp+1] = MID$(Stk$[Tmp+1], 2)
                END IF

                CASE "ptr"
                Stk$[Tmp-1] += "*"
                Stk$[Tmp] = ""
                IF Tmp = Ndx THEN
                    DECR Ndx
                    DO WHILE TALLY(Stk$[Ndx], "*") = LEN(Stk$[Ndx])
                        Stk$[Ndx-1] += Stk$[Ndx]
                        Stk$[Ndx] = ""
                        DECR Ndx
                    LOOP
                ELSE
                    i = Tmp-1
                    DO WHILE TALLY(Stk$[i], "*") = LEN(Stk$[i])
                        Stk$[i-1] += Stk$[i]
                        Stk$[i--] = ""
                    LOOP
                END IF

                CASE "panel"
                Stk$[Tmp] = "panel"
                Use_Panel = Use_Console = Use_Proto = Use_Cursor = TRUE

                CASE "pause"
                Stk$[Tmp] = "Pause()"
                Convert2SimpleFunction(Tmp)
                Use_Pause = Use_Proto = TRUE

                CASE "peek$"
                Stk$[Tmp] = "$$peekstr$"
                Use_PeekStr = Use_BcxTempStr = TRUE

                CASE "pi"
                Stk$[Tmp] = "3.141592653589793"

                CASE "playwav"
                Stk$[Tmp] = "PlayWav"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_PlayWav = Use_GetResource = Use_Proto = TRUE

                CASE "pos"
                Stk$[Tmp] = "Pos()"
                Use_Pos   = Use_Proto = TRUE

                CASE "pushcolors"
                Stk$[Tmp] = "PushColors()"
                Use_PushPopColors = Use_Color = Use_Console = Use_Proto = TRUE

                CASE "popcolors"
                Stk$[Tmp] = "PopColors()"
                Use_PushPopColors = Use_Color = Use_Console = Use_Proto = TRUE


                CASE "private"
                IF iMatchWrd(Stk$[Tmp+1], "const") THEN
                    Stk$[Tmp] = "enum "
                    Stk$[Tmp+1]= Stk$[Tmp+2] + "{"
                    INCR Ndx
                    Stk$[Ndx]= "}"
                ELSE
                    Stk$[1] = "private"
                END IF
            END SELECT

            CASE  17
            SELECT CASE Keyword$
                CASE "qbcolor"
                Stk$[Tmp] = "qbcolor"
                Use_QBColor = Use_Proto = TRUE
            END SELECT

            CASE  18
            SELECT CASE Keyword$
                CASE "rgb"
                Stk$[Tmp] = "RGB"

                CASE "read"
                Stk$[Tmp] = "READNUM"
                Use_Readnum = Use_SysMacros = Use_Proto = TRUE

                CASE "read$"
                Stk$[Tmp] = "READ$"
                Use_Read = Use_SysMacros = Use_Proto = TRUE

                CASE "rewind"
                Stk$[Tmp] = "rewind"
                DIM RAW Tmp2 = Tmp + 2
                IF DataType(Stk$[Tmp2]) = vt_NUMBER THEN
                    Stk$[Tmp2] = "FP" + Stk$[Tmp2]
                END IF

                CASE "remove$"
                Stk$[Tmp] = "$$RemoveStr$"
                Use_Remove = Use_BcxTempStr = TRUE

                CASE "replace$"
                Stk$[Tmp] = "$$replace$"
                Use_Replace = Use_BcxTempStr = TRUE

                CASE "replaceany$"
                Stk$[Tmp] = "ReplaceAny$"
                Use_ReplaceAny = Use_BcxTempStr = TRUE

                CASE "removeany$"
                Stk$[Tmp] = "RemoveAny$"
                Use_RemoveAny = Use_BcxTempStr = TRUE

                CASE "right$"
                Stk$[Tmp] = "$$right$"
                Use_Right = Use_BcxTempStr = TRUE

                CASE "rightstr"
                Stk$[Tmp] = "RightStr"
                Use_RightStr = Use_Right = Use_Lcase = Use_BcxTempStr = TRUE

                CASE "rclick"
                Stk$[Tmp] = "rClick()"
                Convert2SimpleFunction(Tmp)
                Use_Rclick = Use_Proto = TRUE

                CASE "randomize"
                Stk$[Tmp] = "randomize"
                Use_Randomize = TRUE
                Use_Proto = TRUE
                IF Ndx = 1 THEN
                    Use_Timer = TRUE
                    Stk$[1] ="randomize(timer())"
                END IF
                IF Ndx = 2 AND Stk$[2] ?? "timer" THEN
                    Use_Timer = TRUE
                    Ndx = 1
                    Stk$[1] ="randomize(timer())"
                END IF
                IF Ndx >= 2 AND Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)  ' Allow unparenthesized expressions
                END IF

                CASE "rec"
                DIM RAW Tmp2 = Tmp + 2
                IF DataType(Stk$[Tmp2]) = vt_NUMBER THEN
                    Stk$[Tmp2] = "FP" + Stk$[Tmp2]
                END IF
                REMOVE "#" FROM Stk$[Tmp2]
                Stk$[Tmp] = "rec(" + Stk$[Tmp2] + "," + Stk$[Tmp2] + "len)"
                Stk$[Tmp + 1] = ""
                Stk$[Tmp2] = ""
                Stk$[Tmp + 3] = ""
                Use_Rec = Use_Proto = TRUE

                CASE "reccount"
                DIM RAW length$
                DIM RAW Tmp2 = Tmp + 2
                IF DataType(Stk$[Tmp2]) = vt_NUMBER THEN
                    Stk$[Tmp2] = "FP" + Stk$[Tmp2]
                END IF
                REMOVE "#" FROM Stk$[Tmp2]
                Stk$[Tmp] = "reccount"
                length$ = Stk$[Tmp2] + "len)"

                FOR i = Tmp+1 TO Ndx
                    IF *Stk$[i] = ASC(")") THEN
                        Stk$[i] = ""
                        EXIT FOR
                    END IF
                    Stk$[Tmp] += Stk$[i]
                    Stk$[i] = ""
                NEXT

                Stk$[Tmp] += "," + length$
                Use_RecCount = Use_Proto = TRUE

                CASE "refresh"
                Stk$[Tmp] = "Refresh"
                Use_Refresh = Use_SysMacros = TRUE

                CASE "radtodeg"
                Stk$[Tmp] = "RadToDeg"
                Use_RadToDeg = Use_SysMacros = TRUE

                CASE "regstring$"
                Stk$[Tmp] = "$$RegString$"
                Convert2SimpleFunction(Tmp)
                Use_RegString = Use_BcxTempStr = TRUE

                CASE "regexist"
                Stk$[Tmp] = "RegExist"
                Convert2SimpleFunction(Tmp)
                Use_RegExist = Use_BcxTempStr = TRUE

                CASE "regint"
                Stk$[Tmp] = "RegInt"
                Convert2SimpleFunction(Tmp)
                Use_RegInt = Use_BcxTempStr = TRUE

                CASE "remain$"
                Stk$[Tmp] = "$$remain$"
                Use_Remain = Use_BcxTempStr = TRUE

                CASE "retain$"
                Stk$[Tmp] = "$$Retain$"
                Use_Retain = Use_BcxTempStr = TRUE

                CASE "repeat$"
                Stk$[Tmp] = "$$repeat$"
                Use_Repeat = Use_BcxTempStr = TRUE

                CASE "reverse$"
                Stk$[Tmp] = "$$reverse$"
                Use_Reverse = Use_BcxTempStr = TRUE

                CASE "rnd"
                Stk$[Tmp] = "rnd()"
                Convert2SimpleFunction(Tmp)
                Use_Rnd = Use_Proto = TRUE

                CASE "rnd2"
                Stk$[Tmp] = "rnd2"
                Use_Rnd2 = Use_Proto = TRUE

                CASE "round"
                Stk$[Tmp] = "Round"
                Use_Round = Use_Proto = TRUE

                CASE "rpad$"
                Stk$[Tmp] = "$$rpad$"
                Use_Rpad = Use_BcxTempStr = TRUE

                CASE "rtrim$"
                Stk$[Tmp] = "$$rtrim$"
                Use_Rtrim = Use_BcxTempStr = TRUE

                CASE "run"
                Stk$[Tmp] = "Run"
                Use_Run = Use_Proto = TRUE
            END SELECT


            CASE  19
            SELECT CASE Keyword$

                CASE "setdimension"
                Stk$[Tmp] = "SetDimension"
                Use_SetDimension = Use_Proto = TRUE

                CASE "spc$"
                Stk$[Tmp] = "SPC$"
                Use_SPC = Use_BcxTempStr = TRUE

                CASE "startdraw"
                Stk$[Tmp] = "StartDraw"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Draw = TRUE

                CASE "str$"
                Stk$[Tmp] = "$$str$"
                Use_Str = Use_BcxTempStr = TRUE

                CASE "strl$"
                Stk$[Tmp] = "$$strl$"
                Use_Strl = Use_BcxTempStr = TRUE

                CASE "str2variant"
                ' INPUT:
                ' str2variant(string,variant)
                ' TRANSFORMS TO
                ' COM_AS2WS(sBuf)
                ' lComVariant.vt = VT_BSTR
                ' lComVariant.bstrVal = SysAllocString(COM_LPWSTR_temp)
                CALL Add2SplitLines("COM_AS2WS(" + Stk$[Tmp+2] + ")")
                CALL Add2SplitLines(Stk$[Tmp+4] + ".vt = VT_BSTR")
                CALL Add2SplitLines(Stk$[Tmp+4] + ".bstrVal = SysAllocString(COM_LPWSTR_temp)")
                Ndx = 0


                CASE "searchpath$"
                Stk$[Tmp] = "$$SEARCHPATH$"
                Use_SearchPath = Use_BcxTempStr = TRUE

                CASE "sendmessage", "sndmsg"
                '*****************************
                '    SendMessage HELPER
                '*****************************
                IF NOT iMatchWrd(Stk$[1], "const") THEN

                    IF Stk$[Tmp+1] <> "(" THEN
                        CALL InsertOptionalParens(Tmp+1)       ' Allow unparenthesized expressions
                    END IF

                    Stk$[Tmp] = "SendMessage"
                    Comma = i = 0
                    A = Tmp+1

                    DO

                        IF A > Ndx THEN
                            CALL Abort("Malformed SendMessage")
                        END IF

                        INCR A
                        IF INCHR("([{", Stk$[A]) THEN INCR i
                        IF INCHR(")]}", Stk$[A]) THEN DECR i
                        IF NOTZERO(i) THEN ITERATE

                        IF *Stk$[A] = ASC(",") THEN
                            IF Comma = 0 THEN
                                IF ISFALSE(iMatchWrd(Stk$[A+2], "UINT")) THEN
                                    InsertTokens(A, 3, "(", "UINT", ")")
                                END IF
                            ELSEIF Comma = 1 THEN
                                IF ISFALSE(iMatchWrd(Stk$[A+2], "WPARAM")) THEN
                                    InsertTokens(A, 3, "(", "WPARAM", ")")
                                END IF
                            ELSEIF Comma = 2 THEN
                                IF ISFALSE(iMatchWrd(Stk$[A+2], "LPARAM")) THEN
                                    InsertTokens(A, 3, "(", "LPARAM", ")")
                                END IF
                                EXIT DO
                            END IF
                            INCR Comma
                        END IF    ' Is a comma
                    LOOP
                END IF

                CASE "savebmp"
                Stk$[Tmp] = "SaveBmp"
                Use_SaveBmp = Use_Proto = Use_BcxTempStr = TRUE

                CASE "set_bcx_bitmap"
                Stk$[Tmp] = "Set_BCX_Bitmap"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Set_BCX_Bitmap = Use_BcxTempStr = TRUE

                CASE "set_bcx_bitmap2"
                Stk$[Tmp] = "Set_BCX_Bitmap2"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Set_BCX_Bitmap2 = Use_BcxTempStr = TRUE

                CASE "set_bcx_bmpbutton"
                Stk$[Tmp] = "Set_BCX_BmpButton"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Set_BCX_BmpButton = Use_BcxTempStr = TRUE

                CASE "set_bcx_icon"
                Stk$[Tmp] = "Set_BCX_Icon"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Proto = TRUE
                Use_Set_BCX_Icon = Use_GetResource = TRUE

                CASE "screen"
                Stk$[Tmp] = "Screen"
                Use_Screen = Use_Proto = TRUE

                CASE "setattr"
                Stk$[Tmp] = "SETATTR"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Setattr = Use_SysMacros = TRUE

                CASE "setwindowrtftext"
                Stk$[Tmp] = "SetWindowRTFText"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Richedit = Use_BcxTempStr = TRUE

                CASE "sgn"
                Stk$[Tmp] = "sgn"
                Use_Sgn = Use_Proto = TRUE

                CASE "show"
                Stk$[Tmp] = "SHOWHWND"
                Use_Show = Use_SysMacros = TRUE
                IF Ndx >= 2 AND Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)  ' Allow unparenthesized expressions
                END IF

                CASE "sleep"
                Use_Sleep = TRUE
                Stk$[Tmp] = "BCX_Sleep"
                IF Ndx >= 2 AND Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)  ' Allow unparenthesized expressions
                END IF

                CASE "showmodal"
                Stk$[Tmp] = "ShowModal"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Show = Use_SysMacros = Use_ShowModal = Use_EndModal = TRUE

                CASE "space$"
                Stk$[Tmp] = "$$space$"
                Use_Space = Use_BcxTempStr = TRUE

                CASE "sound"
                Stk$[Tmp] = "Sound"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Sound = Use_Round = Use_Str = Use_BcxTempStr = TRUE

                CASE "split"
                Stk$[Tmp] = "Split"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Proto = TRUE
                Use_BcxTempStr = TRUE
                Use_UCaseTbl = TRUE
                Use_Stristr = TRUE
                Use_Split = TRUE
                Use_Remove= TRUE
                Use_Mid   = TRUE
                Use_Left  = TRUE
                Use_Instr = TRUE
                Use_Replace = TRUE

                CASE "strim$"
                Stk$[Tmp] = "$$strim$"
                Use_Strim = Use_BcxTempStr = TRUE

                CASE "string$"
                Stk$[Tmp] = "$$stringx$"
                Use_String = Use_BcxTempStr = TRUE

                CASE "strptr"
                Stk$[Tmp] = "STRPTR"
                Use_Strptr = Use_SysMacros = TRUE

                CASE "strtoken$"
                Stk$[Tmp] = "StrToken$"
                Use_Strtoken = Use_BcxTempStr = Use_Mid = Use_Left = Use_Extract = TRUE
                Use_Instr = Use_Instrrev = Use_Stristr = Use_Tally = Use_Remove = TRUE
                Use_UCaseTbl = TRUE

                CASE "sub"
                IF Stk$[2] ?? "main" THEN
                    NoMain = TRUE
                    Stk$[1] = "function"
                END IF

                CASE "swap"
                Stk$[Tmp] = "swap"
                Use_Swap = Use_Proto = TRUE

                CASE "sysdir$"
                Stk$[Tmp] = "$$sysdir$()"
                Convert2SimpleFunction(Tmp)
                Use_Sysdir = Use_BcxTempStr = TRUE

                CASE "sysstr"
                Stk$[Tmp] = "SysStr"
                Use_SysStr = Use_Proto = TRUE

            END SELECT

            CASE  20
            SELECT CASE Keyword$

                CASE "tab$"
                Stk$[Tmp] = "TAB$"
                Use_TAB = Use_BcxTempStr = TRUE

                CASE "true"
                Stk$[Tmp] = "TRUE"

                CASE "trim$"
                Stk$[Tmp] = "$$trim$"
                Use_Trim = Use_BcxTempStr = TRUE

                CASE "tally"
                Stk$[Tmp] = "tally"
                Use_Tally = Use_UCaseTbl = Use_Stristr = Use_Proto = TRUE

                CASE "tempdir$"
                Stk$[Tmp] = "$$tempdir$()"
                Convert2SimpleFunction(Tmp)
                Use_Tempdir = Use_BcxTempStr = TRUE

                CASE "tempfilename$"
                Stk$[Tmp] = "$$TempFileName$"
                Use_TempFileName = Use_BcxTempStr = TRUE

                CASE "textmode"
                Stk$[Tmp] = "TextMode"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                Use_Textmode = Use_Proto = TRUE

                CASE "time$"
                IF Stk$[Tmp+1] <> "("  THEN
                    Stk$[Tmp] = "$$timef$()"
                ELSE
                    Stk$[Tmp] = "$$timef$"
                END IF
                Convert2SimpleFunction(Tmp)
                Use_Time = Use_BcxTempStr = TRUE

                CASE "timer"
                Stk$[Tmp] = "timer()"
                Convert2SimpleFunction(Tmp)
                Use_Timer = Use_Proto = TRUE

                CASE "tix_start"
                Stk$[Tmp] = "TIX_START()"
                Convert2SimpleFunction(Tmp)
                Use_Tix = Use_Proto = TRUE

                CASE "tix_now"
                Stk$[Tmp] = "TIX_NOW()"
                Convert2SimpleFunction(Tmp)
                Use_Tix = Use_Proto = TRUE

            END SELECT

            CASE  21
            SELECT CASE Keyword$

                CASE "ucase$"
                IF iSubLoc = 2 THEN
                    IF Stk$[Tmp+1] = "(" THEN
                        Abort("'ucase' can only be used as a Function Pointer when in a SET")
                    END IF
                    Stk$[Tmp] = "ucase"
                ELSE
                    Stk$[Tmp] = "$$ucase$"
                END IF
                Use_Ucase = Use_BcxTempStr = TRUE

                CASE "unwrap$"
                Stk$[Tmp] = "$$unwrap$"
                Use_Unwrap = Use_BcxTempStr = Use_Left = Use_Right = TRUE

                CASE "ubound"
                Stk$[Tmp] = "ubound"
                Use_Ubound = Use_SysMacros = TRUE

                CASE "ubound_d"
                Stk$[Tmp] = "ubound_d"
                Use_Ubound = Use_SysMacros = TRUE

                CASE "ubound_s"
                Stk$[Tmp] = "ubound_s"
                Use_Ubound = Use_SysMacros = TRUE

                CASE  "ucode$", "ucode"
                Stk$[Tmp] = "$$AnsiToWide$"
                Use_AnsiToWide = Use_BcxTempStr = TRUE

                CASE "utf8tochr$"
                Stk$[Tmp] = "UTF8toCHR$"
                Use_Utf8tochr = Use_BcxTempStr = TRUE


                CASE "uncom"
                Use_AnsiToWide = Use_WideToAnsi = Use_BcxTempStr = TRUE
                Stk$[Tmp] = "UNCOM"
                IF Stk$[Tmp+1] <> "(" THEN
                    CALL InsertOptionalParens(Tmp+1)           ' Allow unparenthesized expressions
                END IF
                ComSwitchON = TRUE
                Use_COM = TRUE
                Use_COM_CreateObject   = TRUE
                Use_COM_DispatchObject = TRUE
                Use_COM_GetObject      = TRUE
                Use_COM_GetProperty    = TRUE
                Use_COM_InvokeMethod   = TRUE
                Use_COM_SafeArray      = TRUE
                Use_COM_SetProperty    = TRUE
                Use_COM_UsesConversion = TRUE

                CASE "using$"
                Stk$[Tmp] = "$$Using$"
                Use_Using = Use_Instr = Use_Stristr = Use_Replace = Use_BcxTempStr = Use_UCaseTbl = Use_LCaseTbl = TRUE

            END SELECT

            CASE  22
            SELECT CASE Keyword$

                CASE "val"
                Stk$[Tmp] = "VAL"
                Use_Val = Use_SysMacros = TRUE

                CASE "vall"
                Stk$[Tmp] = "VALL"
                Use_Vall = Use_SysMacros = TRUE

                CASE "variant2str"
                ' INPUT:
                ' variant2str(variant, string)
                ' TRANSFORMS TO
                ' BEGINBLOCK
                ' RAW sBuf[wlen(variant.bstrVal)+2] AS char
                ' wstrcpy(sBuf, lComVariant.bstrVal)
                ' COM_WS2AS(sBuf)
                ' string = COM_psz_tmp$
                ' ENDBLOCK
                CALL Add2SplitLines("BEGINBLOCK")
                CALL Add2SplitLines("DIM RAW sBuf[wlen(" + Stk$[Tmp+2] + ".bstrVal)+2] AS char")
                CALL Add2SplitLines("wstrcpy(sBuf," + Stk$[Tmp+2] + ".bstrVal)")
                CALL Add2SplitLines("COM_WS2AS(sBuf)")
                CALL Add2SplitLines(Stk$[Tmp+4] + " = COM_psz_tmp$")
                CALL Add2SplitLines("ENDBLOCK")
                Ndx = 0
                Use_COM_UsesConversion = TRUE

                CASE "varptr"
                Stk$[Tmp] = "&"

                CASE "vchr$"
                Stk$[Tmp] = "$$vchr$"
                Use_VChr = Use_BcxTempStr = TRUE

                CASE "vt$"
                Stk$[Tmp] = "VT$"
                Use_VT = Use_BcxTempStr = TRUE

                CASE "virtual"
                IF Tmp = 1 THEN
                    Stk$[Tmp] = "dim"
                    IsVirtual = TRUE

                    DIM RAW ii = Ndx
                    DO WHILE Stk$[ii] <> ")"
                        DECR ii
                    LOOP
                    INCR ii
                    IF iMatchWrd(Stk$[Ndx], "stdcall") THEN
                        DIM RAW iNdx = Ndx-1
                        IF iMatchWrd(Stk$[iNdx], "as") THEN DECR iNdx
                        IF ii <= iNdx THEN
                            CALL BuildDelimStr(ii, iNdx, szVirtual$)
                        ELSE
                            szVirtual$ = ""
                        END IF
                    ELSE
                        IF ii <= Ndx THEN
                            CALL BuildDelimStr(ii, Ndx, szVirtual$)
                        ELSE
                            szVirtual$ = ""
                        END IF
                    END IF
                END IF

                CASE "vector"
                IF Stk$[Tmp+1] = "<" THEN
                    Stk$[Tmp] = "vector"
                    HasVector = TRUE
                END IF

                CASE "verify"
                Stk$[Tmp] = "Verify"
                Use_Verify = Use_Mid = Use_BcxTempStr = TRUE

                CASE "vbs_addcode", "vbs_run_script", "vbs_eval_str$"
                Stk$[Tmp] = UCASE$(Stk$[Tmp])
                Use_VBS = Use_BcxTempStr = TRUE

                CASE "vbs_eval_num", "vbs_eval_num#"
                Stk$[Tmp] = "VBS_EVAL_NUM#"
                Use_VBS = Use_BcxTempStr = TRUE

                CASE "vbs_start", "vbs_stop", "vbs_reset", "vbs_error$"
                Use_VBS = Use_BcxTempStr = TRUE
                Stk$[Tmp] = UCASE$(Stk$[Tmp]) + "()"
                Convert2SimpleFunction(Tmp)

            END SELECT

            CASE  23
            SELECT CASE Keyword$

                CASE "wrap$"
                Stk$[Tmp] = "$$wrap$"
                Use_Wrap = Use_BcxTempStr = TRUE

                CASE "widetoansi$", "widetoansi", "w2a$", "w2a"
                Stk$[Tmp] = "$$WideToAnsi$"
                Use_WideToAnsi = Use_BcxTempStr = TRUE


                CASE "windir$"
                Stk$[Tmp] = "$$windir$()"
                Convert2SimpleFunction(Tmp)
                Use_Windir = Use_BcxTempStr = TRUE

                CASE "wndproc"
                IF Tmp = 2 AND Ndx < 6 THEN
                    Src$ = "FUNCTION|WndProc(hWnd|AS|HWND,Msg|AS|UINT,wParam|AS|WPARAM,lParam|AS|LPARAM)|AS|CALLBACK|LRESULT"
                    FastLexer(Src$, "|", ",()")
                    Use_Wingui = TRUE
                    CallBackFlag= TRUE
                END IF

                CASE "winmain"
                Use_Wingui = InWinMain = TRUE
                IF Tmp = 2 AND Ndx < 6 THEN
                    Src$ = "FUNCTION|WinMain(hInst|AS|HINSTANCE,hPrev|AS|HINSTANCE,CmdLine|AS|PSTR,CmdShow|AS|int)AS|int WINAPI"
                    FastLexer(Src$, "|", ",()")
                ELSE
                    Stk$[Tmp] = "WinMain"
                END IF

            END SELECT

            CASE  26
            SELECT CASE Keyword$

                CASE "zstring"
                IF iMatchWrd(Stk$[Tmp+1], "ptr") THEN
                    Stk$[Tmp] = "char"
                    INCR Tmp
                    Stk$[Tmp-1] = Stk$[Tmp-1] + "*"
                    Stk$[Tmp] = ""
                    IF Tmp = Ndx THEN
                        DECR Ndx
                        DO WHILE TALLY(Stk$[Ndx], "*") = LEN(Stk$[Ndx])
                            Stk$[Ndx-1] += Stk$[Ndx]
                            Stk$[Ndx] = ""
                            DECR Ndx
                        LOOP
                    ELSE
                        i = Tmp-1
                        DO WHILE TALLY(Stk$[i], "*") = LEN(Stk$[i])
                            Stk$[i-1] += Stk$[i]
                            Stk$[i] = ""
                            DECR i
                        LOOP
                    END IF
                END IF
                Stk$[Tmp] = "string"
            END SELECT

            CASE 27
            SELECT CASE Keyword$
                CASE "$ifndef"
                Stk$[Tmp] = "~ifndef"
                INCR InConditional

                CASE "$ifdef"
                Stk$[Tmp] = "~ifdef"
                INCR InConditional

                CASE "$if"
                Stk$[Tmp] = "~if"
                INCR InConditional

                CASE "$endif"
                Stk$[Tmp] = "~endif"
                DECR InConditional
                IF InConditional < 0 THEN       ' simple check to see if conditionals are balanced
                    Abort("Too many $ENDIFs")
                END IF
            END SELECT
        END SELECT
    NEXT

    CALL RemEmptyTokens
    '************************************************************
    ' Moved the WITH/END WITH handling here from the Emit sub
    ' The ill formed variables would cause conflict with the new
    ' AsmUnKnown structs function.
    '************************************************************
    IF PrependCnt THEN
        i = PrependCnt
        DO WHILE i
            IF NOT iMatchWrd(Stk$[1], "with") AND NOT iMatchWrd(Stk$[1], "prepend") AND NOT iMatchWrd(Stk$[1], "endwith") AND NOT iMatchWrd(Stk$[1], "endprepend") THEN
                CALL InsertTokens(0, 1, PrependVar$[i])
            END IF
            DECR i
        LOOP
    END IF

    IF WithCnt THEN
        LOCAL WithVarPositions[32]                                          ' More improvements - 826 MrBcx
        FOR i = 1 TO Ndx                                                    ' Map the cells that contain the
            IF Stk$[i] = WithVar$[WithCnt] THEN WithVarPositions[i] = TRUE  ' WithVar$[WithCnt] variable name, so
        NEXT                                                                ' we can restore them before leaving
        i = Ndx
        DO WHILE i
            IF LEFTSTR(Stk$[i], "->") OR (*Stk$[i] = ASC(".") AND NOT IsDecimalNumber(Stk$[i]+1)) THEN
                IF WithVar$[WithCnt] = "Me" AND *Stk$[i] = ASC(".") THEN
                    IF InFunction THEN  Stk$[i] = "->" + MID$(Stk$[i], 2)
                END IF
                Stk$[i] = WithVar$[WithCnt] + Stk$[i]
            END IF
            DECR i
        LOOP
        '**************************************************************
        ' 825 The following code by MrBcx to improve "WITH" handling
        '**************************************************************
        DIM t
        FOR i = 1 TO Ndx
            IF INSTR(Stk$[i], WithVar$[WithCnt]) THEN t++
            IF INSTR(Stk$[i], WithVar$[WithCnt]) AND t > 1 AND WithVar$[WithCnt] <> "Me" THEN ' 826 MrBcx added missing "Me" test
                REMOVE WithVar$[WithCnt] FROM Stk$[i]
            END IF
        NEXT
        '**************************************************
        FOR i = 1 TO Ndx                                                    ' 826 MrBcx - More improvements
            IF WithVarPositions[i] = TRUE THEN Stk$[i] = WithVar$[WithCnt]  ' Restore any WithVar[WithCnt] cells
        NEXT                                                                ' that existed before translation
    END IF

    IF PrependCnt THEN
        CALL BuildDelimStr(1, Ndx, Src$)
        CALL XParse(Src$)
    END IF

    '************************************************************
    ' handle programming style global and locals using same name
    '************************************************************

    IF CompToken = 1 THEN

        Keyword$ = LCASE$(Stk$[1])

        SELECT CASE Keyword$
            CASE "dim"         :  CompToken = 0
            CASE "local"       :  CompToken = 0
            CASE "global"      :  CompToken = 0
            CASE "static"      :  CompToken = 0
            CASE "shared"      :  CompToken = 0
            CASE "raw"         :  CompToken = 0
            CASE "dynamic"     :  CompToken = 0
            CASE "free"        :  CompToken = 0
            CASE "redim"       :  CompToken = 0
            CASE "sub"         :  CompToken = 0
            CASE "function"    :  CompToken = 0
            CASE "overloaded"  :  CompToken = 0
            CASE "callback"    :  CompToken = 0
            CASE "public"      :  CompToken = 0
            CASE "declare"     :  CompToken = 0
            CASE "c_declare"   :  CompToken = 0
            CASE "auto"        :  CompToken = 0
            CASE "register"    :  CompToken = 0
            CASE "extern"      :  CompToken = 0
            CASE ELSE          :  CALL AsmUnknownStructs(1)
        END SELECT

    END IF
END SUB ' TokenSubstitutions


SUB LShiftStk (ToCell)
    DIM RAW i
    DECR Ndx                                ' Adjust Ndx
    FOR i = ToCell TO Ndx                   ' Shift contents left, From Ndx ending at ToCell
        Stk$[i] = Stk$[i+1]
    NEXT
    Stk$[Ndx+1] = ""                        ' Erase Stk$ [FromCell]
END SUB


SUB RShiftStk (FromCell)
    DIM RAW i
    INCR Ndx                                ' Bump Ndx by 1
    FOR i = Ndx TO FromCell STEP -1         ' Shift contents right, starting at FromCell
        Stk$[i] = Stk$[i-1]
    NEXT
    Stk$[FromCell] = ""                     ' Erase Stk$ [FromCell]
END SUB


SUB InsertOptionalParens (StartCell)
    CALL RShiftStk (StartCell)              ' Allow unparenthesized expressions
    Stk$[StartCell] = "("                   ' Only use this SUB for simple instances
    INCR Ndx
    Stk$[Ndx] = ")"
END SUB


SUB JoinStrings(iThisToken, inIF)           ' NOTE: This is a recursive SUB
    '================================================================================
    ' The JoinStrings subroutine processes a tokenized line of code (Stk$[]) and
    ' rewrites sequences of string expressions joined by & into a single join$()
    ' call for cleaner output. It tracks context using flags like OnlyPara, InBrace,
    ' and inIF to avoid transforming code inside parameter lists, brackets, or
    ' conditional expressions. It handles nested expressions recursively by calling
    ' itself when encountering a "(" token, and merges the tokens into the correct
    ' string structure as it backtracks. This function ensures that concatenated
    ' strings are joined efficiently and consistently in transformed BCX BASIC code.
    '================================================================================
    DIM RAW sj       = iThisToken
    DIM RAW DoJoin   = 0
    DIM RAW InBrace  = 0
    DIM RAW OnlyPara = 0
    DIM RAW j        = 0
    DIM RAW vt       = 0
    DIM RAW szToken$ = ""

    DO WHILE iThisToken <= Ndx
        szToken$ = Stk$[iThisToken]

        IF NOT j AND NOT OnlyPara AND NOT InBrace THEN
            vt = DataType(szToken$)
            IF vt = vt_INTEGER THEN vt = GetNextVarType(iThisToken)
            IF vt = vt_STRVAR OR vt = vt_STRLIT THEN
                sj = iThisToken
                INCR iThisToken
                ITERATE
            END IF
        END IF

        szToken$ = LCASE$(szToken$)

        SELECT CASE szToken$

            CASE "&"
            IF OnlyPara THEN EXIT SELECT
            vt = DataType(Stk$[iThisToken+1])

            IF vt = vt_INTEGER THEN vt = GetNextVarType(iThisToken+1)

            IF vt <> vt_STRVAR AND vt <> vt_STRLIT THEN
                vt = DataType(Stk$[iThisToken-1])
                IF vt = vt_INTEGER THEN vt = GetPrevVarType(iThisToken-1, 1)
            END IF

            IF vt = vt_STRVAR OR vt = vt_STRLIT THEN
                INCR j
                Stk$[iThisToken] = ","
                szToken$ = ""
            END IF

            CASE "["
            INCR InBrace

            CASE "]"
            DECR InBrace

            CASE "("
            IF Stk$[iThisToken+1] <> "*" THEN
                CALL JoinStrings(iThisToken+1, inIF)
                DIM RAW iBuildHere = iThisToken-1
                DO WHILE Stk$[iThisToken] <> ")"
                    Stk$[iBuildHere] += Stk$[iThisToken] + SPC$
                    Stk$[iThisToken] = ""
                    INCR iThisToken
                LOOP
                Stk$[iBuildHere] += Stk$[iThisToken]
                Stk$[iThisToken] = ""
            END IF

            CASE ")"
            IF j THEN
                Stk$[sj] = "join$(" + STR$(j+1, TRUE) + "," + Stk$[sj]
                j = sj
                DO WHILE ++j < iThisToken
                    Stk$[sj] += Stk$[j]
                    Stk$[j] = ""
                LOOP
                Stk$[sj] += ")"
            END IF
            EXIT SUB

            CASE "||"
            Stk$[iThisToken] = "or"
            DoJoin = TRUE

            CASE "&&"
            Stk$[iThisToken] = "and"
            DoJoin = TRUE

            CASE "then", "for", "xfor"
            DoJoin = TRUE

            CASE "="
            IF NOT inIF THEN
                OnlyPara = TRUE
            ELSE
                DoJoin = TRUE
            END IF

            CASE "if", "elseif", "while"
            inIF = TRUE
            sj = iThisToken + 1

            CASE "sprint", "lprint", "fprint", "fprintf", "print", "print#"
            OnlyPara = TRUE

            CASE ELSE
            IF LEFTSTR(Stk$[iThisToken], "].") OR LEFTSTR(Stk$[iThisToken], "]->") THEN
                DECR InBrace
            END IF

        END SELECT

        IF (DoJoin OR INCHR(",+-*/^;:<>~|&", szToken$)) AND NOT OnlyPara AND NOT InBrace THEN
            DoJoin = 0
            IF j THEN
                Stk$[sj] = "join$(" + STR$(j+1, 1) + "," + Stk$[sj]
                j = sj

                DO WHILE ++j < iThisToken
                    Stk$[sj] += Stk$[j]
                    Stk$[j] = ""
                LOOP

                Stk$[sj] += ")"
            END IF

            j = 0
            sj = iThisToken + 1
        END IF
        INCR iThisToken
    LOOP

    IF j THEN
        Stk$[sj] = "join$(" + STR$(j+1, 1) + "," + TRIM$(Stk$[sj])
        j = sj
        DO WHILE ++j <= iThisToken
            Stk$[sj] += TRIM$(Stk$[j])
            Stk$[j] = ""
        LOOP
        Stk$[sj] += ")"
    END IF

END SUB ' JoinStrings



SUB Transforms
    DIM RAW a
    DIM RAW i
    DIM RAW Keyword$
    DIM RAW LTmp$
    DIM RAW tpBCX AS TOKSUBFUNC PTR

    Keyword$ = LCASE$(Stk$[1])
    tpBCX = GetWordInfo(Keyword$)

    IF tpBCX THEN
        IF (tpBCX->iWordInfo BAND eWI_Transform) = 0 THEN
            EXIT SUB
        END IF
    ELSE
        EXIT SUB
    END IF

    LTmp$  = ""
    a = INCHR("abcdefghijklmnopqrstuvwxyz$", Keyword$)
    SELECT CASE a
        CASE 4

        '**************************************************************************
        ' The following code introduces the following DLL declarations to BCX
        '**************************************************************************
        '  DECLARE FUNCTION Foo LIB "FOO.DLL" ALIAS "FooA" (A$)
        '                     OR
        '  DECLARE FUNCTION Foo LIB "FOO.DLL" (A$) - Alias will default to "FOO"
        '  [5.08.1102] Foo = (BCXFPROTx)GetProcAddress(H_FOO, "FooA");
        '**************************************************************************

        IF Keyword$ = "declare" AND iMatchWrd(Stk$[4], "lib") THEN
            DIM RAW szAlias$, kk, idx = -1

            REMOVE DQ$ FROM Stk$[5]
            FOR kk = 1 TO LoadLibsCnt
                IF Stk$[5] = Loadlibs$[kk] THEN
                    idx = kk
                    EXIT FOR
                END IF
            NEXT
            IF idx < 0 THEN

                IF cMaxLoadlibs = ++LoadLibsCnt THEN
                    CALL Abort("Maximum number of LIBs that can be loaded exceeded.")
                END IF

                Loadlibs$[LoadLibsCnt] = Stk$[5]
            END IF

            IF iMatchWrd(Stk$[6], "alias") THEN
                szAlias$ = Stk$[7]
                Stk$[6] = ""
                Stk$[7] = ""
            ELSE
                szAlias$ = ENC$(UCASE$(Stk$[3]))
            END IF

            INCR DllCnt

            IF DllCnt >= cMaxDLLDecl THEN
                CALL Abort("Maximum number of declarations exceeded.")
            END IF

            DIM mod_name$
            mod_name$ = UCASE$(RemoveExtension$(Stk$[5]))

            IF INCHR(mod_name$, "-") OR INCHR(mod_name$, ".") THEN
                mod_name$ = REPLACE$ (mod_name$, "-.", "_")
                mod_name$ = REPLACE$ (mod_name$, "-", "_")
            END IF

            DllDecl$[DllCnt]  = ""
            DllDecl$[DllCnt] += Clean$(Stk$[3])   + "=(BCXFPROT"
            DllDecl$[DllCnt] += STR$(DllCnt, TRUE) + ")GetProcAddress(H_"
            DllDecl$[DllCnt] += mod_name$ + ", "  + szAlias$ + ");"

            Stk$[4] = ""
            Stk$[5] = ""
        END IF
        EXIT SUB


        CASE 9

        IF Keyword$ = "iremove" THEN
            '***********************************************************
            '  Translate   IREMOVE UCASE$("aaa") FROM LTRIM$(RTRIM$(A$))
            '  into   A$ = IREMOVE$(LTRIM$(RTRIM$(A$)),UCASE$("aaa"))
            '***********************************************************
            DIM RAW Mat$, Fat$

            FOR i = 2 TO Ndx
                IF iMatchWrd(Stk$[i], "from") THEN
                    Stk$[i] = ""
                    EXIT FOR
                END IF
            NEXT

            CALL BuildStr(2, i, Mat$)      ' build match string
            CALL BuildStr(i, Ndx, Fat$)    ' build fat source

            IF INCHR(Fat$, "$") = 0 THEN Fat$ += "$"
            IF INCHR(Mat$, "$") = 0 THEN Mat$ += "$"

            LTmp$ = "=iremove$(" + Fat$ + "," + Mat$ + ")"
            FastLexer(Fat$, " ()", "")
            LTmp$ = Stk$[Ndx] + LTmp$
            CALL XParse(LTmp$)
            CALL TokenSubstitutions(1)
            CALL Emit_Main
            Ndx = 0
            EXIT SUB
        END IF

        IF Keyword$ = "ireplace" THEN
            '**********************************************************
            '  IREPLACE "this" WITH "that" IN A$ is transformed into
            '  A$ = ireplace$ (A$, "this", "that")
            '  BCX 3.73 introduces CASE INSENSITIVE REPLACE
            '**********************************************************

            IF Ndx < 6 THEN
                CALL Abort("Problem with IREPLACE statement")
            END IF

            DIM RAW W, I, VV$, RR$, WW$

            FOR W = 2 TO Ndx
                IF iMatchWrd(Stk$[W], "with") THEN
                    Stk$[W]= ""
                    EXIT FOR
                END IF
            NEXT

            FOR I = 2 TO Ndx
                IF iMatchWrd(Stk$[I], "in") THEN
                    Stk$[I]= ""
                    EXIT FOR
                END IF
            NEXT

            CALL BuildStr(I+1, Ndx, VV$)
            CALL BuildStr(2, W, RR$)
            CALL BuildStr(W+1, I, WW$)

            IF INCHR(VV$, "$") = 0 THEN VV$ += "$"
            IF INCHR(RR$, "$") = 0 THEN RR$ += "$"
            IF INCHR(WW$, "$") = 0 THEN WW$ += "$"

            LTmp$ = "=ireplace$(" + VV$ + "," + RR$ + "," + WW$ + ")"
            FastLexer(VV$, " ()", "")
            LTmp$ = Stk$[Ndx] + LTmp$
            CALL XParse(LTmp$)
            CALL TokenSubstitutions(1)
            CALL Emit_Main
            Ndx = 0
        END IF
        EXIT SUB

        CASE 18
        IF Keyword$ = "remove" THEN
            '***********************************************************
            '  Translate   REMOVE UCASE$("aaa") FROM LTRIM$(RTRIM$(A$))
            '  into   A$ = REMOVE$(LTRIM$(RTRIM$(A$)),UCASE$("aaa"))
            '***********************************************************
            DIM RAW Mat$, Fat$

            XFOR i = 2 WHILE i <= Ndx AND NOT iMatchWrd(Stk$[i], "from") BY i++
            XNEXT

            IF i > Ndx THEN
                CALL Abort("Malformed REMOVE statement.")
            END IF

            CALL BuildStr(2, i-1, Mat$)     ' build match string
            CALL BuildStr(i+1, Ndx, Fat$)   ' build fat source

            IF INCHR(Fat$, "$") = 0 THEN Fat$ += "$"
            IF INCHR(Mat$, "$") = 0 THEN Mat$ += "$"

            LTmp$ = "=remove$(" + Fat$ + "," + Mat$ + ")"

            FastLexer(Fat$, " ()", "")
            LTmp$ = Stk$[Ndx] + LTmp$
            CALL XParse(LTmp$)
            CALL TokenSubstitutions(1)
            CALL Emit_Main
            Ndx = 0
            EXIT SUB
        END IF

        IF Keyword$ = "replace" THEN
            '*******************************************************
            '  REPLACE "this" WITH "that" IN A$ is transformed into
            '  A$ = replace$ (A$, "this", "that")
            '  BCX 2.93 allows expressions and arrays to be used
            '*******************************************************

            IF Ndx < 6 THEN
                CALL Abort("Problem with REPLACE statement")
            END IF

            DIM RAW W, I, VV$, RR$, WW$

            FOR W = 2 TO Ndx
                IF iMatchWrd(Stk$[W], "with") THEN
                    Stk$[W]= ""
                    EXIT FOR
                END IF
            NEXT

            FOR I = 2 TO Ndx
                IF iMatchWrd(Stk$[I], "in") THEN
                    Stk$[I] = ""
                    EXIT FOR
                END IF
            NEXT

            IF I < W OR W = 0 THEN
                CALL Abort("Malformed REPLACE statement")
            END IF

            CALL BuildStr(I+1, Ndx, VV$)
            CALL BuildStr(2, W, RR$)
            CALL BuildStr(W+1, I, WW$)

            IF INCHR(VV$, "$") = 0 THEN VV$ += "$"
            IF INCHR(RR$, "$") = 0 THEN RR$ += "$"
            IF INCHR(WW$, "$") = 0 THEN WW$ += "$"

            LTmp$ = VV$ + "=replace$(" + VV$ + "," + RR$ + "," + WW$ + ")"
            CALL XParse(LTmp$)
            CALL TokenSubstitutions(1)
            CALL Emit_Main
            Ndx = 0
        END IF
        EXIT SUB
    END SELECT
END SUB ' Transforms



FUNCTION LocateJoiner(iStart AS INTEGER)
    DO WHILE iStart < Ndx
        IF (Stk$[iStart] = "&") OR ((Stk$[iStart] = "+") AND (Stk$[iStart+1] <> "+")) THEN RETURN iStart
        '  ^^^  DO NOT OPTIMIZE THE ABOVE LINE WITH POINTERS.  There's no benefit.  ~ MrBcx ~    ^^^
        ' More specifically, it is easily confused with continued lines and other ambiguities.
        INCR iStart
    LOOP
    RETURN 0
END FUNCTION ' LocateJoiner



FUNCTION GetNextVarType(iLoc AS INTEGER) AS INTEGER
    DIM RAW vt1 AS INTEGER
    DIM RAW cvt1 AS INTEGER
    DIM RAW Tmp AS INTEGER
    DIM RAW k AS INTEGER

    cvt1 = CheckType(Stk$[iLoc])
    IF cvt1 = 0 THEN
        vt1 = DataType(Stk$[iLoc])
    ELSE
        IF cvt1 = vt_UDT OR cvt1 = vt_STRUCT THEN
            IF *Stk$[iLoc+1] = ASC("[") THEN
                XFOR Tmp = iLoc+2, k = 1 WHILE Tmp <= Ndx AND k BY Tmp++
                    IF *Stk$[Tmp] = ASC("[") THEN INCR k
                    IF *Stk$[Tmp] = ASC("]") THEN DECR k
                XNEXT
                vt1 = DataType(Stk$[Tmp])
            ELSE
                vt1 = DataType(Stk$[iLoc+1])
            END IF
        ELSE
            IF cvt1 = vt_CHAR OR cvt1 = vt_SCHAR THEN
                DIM RAW i, varid
                DIM RAW vi AS VARINFO PTR
                vi = NULL
                i = CheckLocal(Stk$[iLoc], ADDRESSOF(varid))
                IF i THEN vi = ADDRESSOF(LocalVars[varid])
                IF i = vt_UNKNOWN THEN
                    i = CheckGlobal(Stk$[iLoc], ADDRESSOF(varid))
                    IF i THEN vi = ADDRESSOF(GlobalVars[varid])
                END IF
                IF vi THEN
                    IF *(vi->VarDim$) THEN
                        cvt1 = vt_STRVAR
                    ELSE
                        cvt1 = DataType(Stk$[iLoc])
                    END IF
                ELSE
                    cvt1 = DataType(Stk$[iLoc])
                END IF
            END IF
            vt1 = cvt1
        END IF
    END IF

    RETURN vt1
END FUNCTION  ' GetNextVarType



FUNCTION GetPrevVarType(iLoc AS INTEGER, iEarly AS INTEGER) AS INTEGER
    DIM RAW vt AS INTEGER
    DIM RAW Tmp AS INTEGER
    DIM RAW k AS INTEGER

    IF Stk$[iLoc] = ")" OR Stk$[iLoc] = "]" THEN
        XFOR Tmp = iLoc-1, k = 1 WHILE Tmp >= iEarly AND k BY Tmp--
            IF *Stk$[Tmp] = ASC(")") THEN INCR k
            IF *Stk$[Tmp] = ASC("]") THEN INCR k
            IF *Stk$[Tmp] = ASC("(") THEN DECR k
            IF *Stk$[Tmp] = ASC("[") THEN DECR k
        XNEXT
        vt = DataType(Stk$[Tmp])
    ELSE
        vt = DataType(Stk$[iLoc])
        IF vt = vt_INTEGER THEN vt = CheckType(Stk$[iLoc])
        IF vt = vt_CHAR OR vt = vt_SCHAR THEN
            DIM RAW i, varid
            DIM RAW vi AS VARINFO PTR
            vi = NULL
            i = CheckLocal(Stk$[iLoc], ADDRESSOF(varid))
            IF i THEN vi = ADDRESSOF(LocalVars[varid])
            IF i = vt_UNKNOWN THEN
                i = CheckGlobal(Stk$[iLoc], ADDRESSOF(varid))
                IF i THEN vi = ADDRESSOF(GlobalVars[varid])
            END IF
            IF vi THEN
                IF *(vi->VarDim$) THEN vt = vt_STRVAR
            END IF
        END IF
    END IF

    RETURN vt
END FUNCTION  ' GetPrevVarType




FUNCTION JoinStrTest(iStart AS INTEGER, iEarly AS INTEGER)  ' This is a recursive function
    DIM RAW Plus2Amp, vtLeft, vtRight, iJoiner, iDoJoin
    iDoJoin = 0
    Plus2Amp = iMatchNQ(Stk$[iStart++], "&")

    iJoiner = LocateJoiner(iStart)
    IF iJoiner = 0 THEN RETURN iDoJoin
    vtLeft = GetPrevVarType(iJoiner-1, iEarly)
    vtRight = GetNextVarType(iJoiner+1)

    SELECT CASE vtLeft
        CASE vt_STRVAR, vt_STRLIT, vt_LPSTR, vt_LPSTRPTR, vt_PCHAR
        vtLeft = 1
        CASE ELSE
        vtLeft = 0
    END SELECT

    SELECT CASE vtRight
        CASE vt_STRVAR, vt_STRLIT, vt_LPSTR, vt_LPSTRPTR, vt_PCHAR
        vtRight = 1
        CASE ELSE
        vtRight = 0
    END SELECT

    IF vtLeft AND vtRight THEN
        Stk$[iJoiner] = "&"
        Plus2Amp = TRUE
        iEarly = iJoiner+1
    END IF

    iStart = iJoiner+1

    IF iStart < Ndx THEN
        iDoJoin = JoinStrTest(iStart, iEarly) BOR Plus2Amp
    ELSE
        iDoJoin = Plus2Amp
    END IF

    RETURN iDoJoin
END FUNCTION ' JoinStrTest



SUB FixUps
    DIM RAW A
    DIM RAW B
    DIM RAW i
    DIM RAW j
    DIM RAW CommaCnt
    DIM RAW AmpCnt
    DIM RAW LTmp$  = ""
    DIM RAW LStk1$ = ""
    DIM RAW LStk2$ = ""
    DIM RAW Var1$  = ""

    PassOne = FALSE

    '***********************************************************
    ' Join strings using Join(StringCount, string1, string2, ...)
    '***********************************************************
    IF NOT iMatchWrd(Stk$[1], "function")  THEN
        IF JoinStrTest(1, 1) THEN
            DIM RAW k, Tmp
            j = 0
            k = 0
            AmpCnt = 0

            XFOR Tmp = 1 WHILE Tmp < Ndx AND (j = 0 OR k = 0) BY Tmp++
                IF Stk$[Tmp] = "&" THEN
                    A = GetNextVarType(Tmp+1)
                    IF A = vt_STRVAR OR A = vt_STRLIT THEN
                        INCR AmpCnt
                        IF ISZERO(k) THEN k = Tmp
                    END IF
                ELSE
                    A = CheckLocal(Stk$[Tmp], ADDRESSOF(i))
                    IF A = vt_UNKNOWN THEN A = CheckGlobal(Stk$[Tmp], ADDRESSOF(i))
                    IF A = vt_STRUCT OR A = vt_UDT OR A = vt_UNION THEN
                        j = 1
                    END IF
                END IF
            XNEXT

            IF AmpCnt > 1 THEN
                Use_Join = Use_BcxTempStr = TRUE
            END IF

            IF k THEN
                IF j THEN CALL AsmUnknownStructs(0)
                CALL JoinStrings(1, 0)
                CALL BuildDelimStr(1, Ndx, Src$)
                CALL XParse(Src$)
            END IF
        END IF
    END IF

    '***********************************************************
    ' Moved here by Mike H. Was being applied too early.
    ' causing lines with multiple statements to not receive the
    ' conversion. i.e. sp->lpVtbl->Release(sp) : sp = NULL
    '***********************************************************

    IF UseCpp THEN
        IF iMatchNQ(Src$, "->lpVtbl") THEN
            FOR INT tt= 1 TO Ndx
                IF iMatchRgt(Stk$[tt], "->lpVtbl") THEN
                    Stk$[tt] = EXTRACT$(Stk$[tt], "->lpVtbl")
                    IF (Stk$[tt+3] = Stk$[tt-1] OR Stk$[tt+3] = Stk$[tt]) AND Stk$[tt+3] <> ")" THEN
                        Stk$[tt+3] = ""
                        IF Stk$[tt+4] = "," THEN Stk$[tt+4] = ""
                    END IF
                END IF
            NEXT
            CALL RemEmptyTokens
        END IF
    END IF

    '********************************************************************
    '  At this point we have a fresh set of Stk$[] values, totaling Ndx
    '                Start handling some unique situations
    '********************************************************************

    ' This block helps Im_UDT_String() distinguish pointer expressions from string expressions
    IF InTypeDef THEN
        FOR INT tt = 1 TO Ndx
            IF Stk$[tt] ?? "PSTR" THEN Stk$[tt] = "PTCHAR"
        NEXT
        FOR INT tt = 1 TO Ndx
            IF Stk$[tt] ?? "PCHAR" THEN Stk$[tt] = "PTCHAR"
        NEXT
        FOR INT tt = 1 TO Ndx-1
            IF Stk$[tt] ?? "CHAR" AND _
                Stk$[tt+1] ?? "PTR" THEN
                Stk$[tt] = "PTCHAR"
                LShiftStk(tt+1)
            END IF
        NEXT
    END IF

    '********************************************************************
    '                      [ Exponent  Operator Handler ]
    '********************************************************************

    IF HasThisToken("^") THEN
        DIM RAW lp = 0
        DIM RAW rp = 0
        DIM RAW Insert1
        DIM RAW Insert2

        FOR i = 1 TO Ndx
            IF Stk$[i] = "^" THEN
                IF Stk$[i+1] = "-" THEN
                    InsertTokens(i, 1, "(")
                    B = i + 3
                    IF *Stk$[B] = ASC("(") THEN
                        lp = 0
                        rp = 0
                        DO
                            IF *Stk$[B] = ASC("(") THEN INCR lp
                            IF *Stk$[B] = ASC(")") THEN INCR rp
                            INCR B
                        LOOP UNTIL lp = rp
                        InsertTokens(B, 1, ")")
                    ELSE
                        B = i + 4
                        IF INCHR("[", Stk$[B]) THEN
                            DO
                                INCR B
                            LOOP UNTIL INCHR("]", Stk$[B])
                            INCR Ndx
                            InsertTokens(B, 1, ")")
                        ELSE
                            IF INCHR("(", Stk$[B]) THEN
                                DO
                                    INCR B
                                LOOP UNTIL INCHR(")", Stk$[B])
                                InsertTokens(B, 1, ")")
                            ELSE
                                InsertTokens(B, 1, ")")
                            END IF
                        END IF
                    END IF
                END IF
                Insert1 = i - 1
                B = 0

                DO WHILE Stk$[Insert1] <> "="
                    IF *Stk$[Insert1] = ASC("]") THEN INCR B
                    IF *Stk$[Insert1] = ASC(")") THEN INCR B
                    IF *Stk$[Insert1] = ASC("[") THEN DECR B
                    IF *Stk$[Insert1] = ASC("(") THEN DECR B
                    IF B = 0 THEN EXIT DO
                    DECR Insert1
                LOOP

                IF *Stk$[Insert1] = ASC("[") THEN DECR Insert1
                IF *Stk$[Insert1] = ASC("=") THEN INCR Insert1

                IF *Stk$[Insert1] = ASC("(") THEN
                    B = DataType(Stk$[Insert1-1])        ' check if it's a function
                    IF B = vt_INTEGER OR B = vt_SINGLE OR B = vt_DOUBLE  THEN
                        IF ISFALSE(iMatchWrd(Stk$[Insert1-1], "print")) THEN DECR Insert1
                    END IF
                END IF

                DECR Insert1
                Stk$[i] = ","
                Insert2 = i + 1

                B = DataType(Stk$[Insert2])

                IF B = vt_INTEGER OR B = vt_SINGLE OR B = vt_DOUBLE THEN
                    IF *Stk$[Insert2 + 1] = ASC("(") OR *Stk$[Insert2 + 1] = ASC("[") THEN INCR Insert2
                END IF

                B = 0

                DO WHILE Insert2 <= Ndx
                    IF *Stk$[Insert2] = ASC("[") THEN INCR B
                    IF *Stk$[Insert2] = ASC("(") THEN INCR B
                    IF *Stk$[Insert2] = ASC("]") THEN DECR B
                    IF *Stk$[Insert2] = ASC(")") THEN DECR B
                    IF ISZERO(B) THEN EXIT DO
                    INCR Insert2
                LOOP

                ' Insert the tokens in reverse order
                InsertTokens(Insert2, 1, ")")
                InsertTokens(Insert1, 2, "pow", "(")
            END IF
        NEXT
    END IF

    '********************************************************************
    '                      [ MOD Operator Handler ]                        ' MrBcx 817 (added)
    '********************************************************************

    IF HasThisToken("mod") THEN

        DIM RAW lp = 0
        DIM RAW rp = 0
        DIM RAW Insert1
        DIM RAW Insert2

        FOR i = 1 TO Ndx
            '*****************************************************
            ' Exclude "a = MOD(b, c)" FUNCTION calls
            '*****************************************************
            IF Stk$[i] ?? "MOD" THEN Stk$[i] = "mod"               ' MrBcx 818 - A necessary addition
            IF Stk$[i] = "mod" AND Stk$[i+1] <> "(" AND Stk$ [i-1] <> "=" THEN
                IF Stk$[i+1] = "-" THEN
                    InsertTokens(i, 1, "(")
                    B = i + 3
                    IF *Stk$[B] = ASC("(") THEN
                        lp = 0
                        rp = 0
                        DO
                            IF *Stk$[B] = ASC("(") THEN INCR lp
                            IF *Stk$[B] = ASC(")") THEN INCR rp
                            INCR B
                        LOOP UNTIL lp = rp
                        InsertTokens(B, 1, ")")
                    ELSE
                        B = i + 4
                        IF INCHR("[", Stk$[B]) THEN
                            DO
                                INCR B
                            LOOP UNTIL INCHR("]", Stk$[B])
                            INCR Ndx
                            InsertTokens(B, 1, ")")
                        ELSE
                            IF INCHR("(", Stk$[B]) THEN
                                DO
                                    INCR B
                                LOOP UNTIL INCHR(")", Stk$[B])
                                InsertTokens(B, 1, ")")
                            ELSE
                                InsertTokens(B, 1, ")")
                            END IF
                        END IF
                    END IF
                END IF
                Insert1 = i - 1
                B = 0

                DO WHILE Stk$[Insert1] <> "="
                    IF *Stk$[Insert1] = ASC("]") THEN INCR B
                    IF *Stk$[Insert1] = ASC(")") THEN INCR B
                    IF *Stk$[Insert1] = ASC("[") THEN DECR B
                    IF *Stk$[Insert1] = ASC("(") THEN DECR B
                    IF B = 0 THEN EXIT DO
                    DECR Insert1
                LOOP

                IF *Stk$[Insert1] = ASC("[") THEN DECR Insert1
                IF *Stk$[Insert1] = ASC("=") THEN INCR Insert1

                IF *Stk$[Insert1] = ASC("(") THEN
                    B = DataType(Stk$[Insert1-1])        ' check if it's a function
                    IF B = vt_INTEGER OR B = vt_SINGLE OR B = vt_DOUBLE  THEN
                        IF ISFALSE(iMatchWrd(Stk$[Insert1-1], "print")) THEN DECR Insert1
                    END IF
                END IF

                DECR Insert1
                Stk$[i] = ","
                Insert2 = i + 1

                B = DataType(Stk$[Insert2])

                IF B = vt_INTEGER OR B = vt_SINGLE OR B = vt_DOUBLE THEN
                    IF *Stk$[Insert2 + 1] = ASC("(") OR *Stk$[Insert2 + 1] = ASC("[") THEN INCR Insert2
                END IF

                B = 0

                DO WHILE Insert2 <= Ndx
                    IF *Stk$[Insert2] = ASC("[") THEN INCR B
                    IF *Stk$[Insert2] = ASC("(") THEN INCR B
                    IF *Stk$[Insert2] = ASC("]") THEN DECR B
                    IF *Stk$[Insert2] = ASC(")") THEN DECR B
                    IF ISZERO(B) THEN EXIT DO
                    INCR Insert2
                LOOP

                ' Insert the tokens in reverse order
                InsertTokens(Insert2, 1, ")")
                InsertTokens(Insert1, 2, "mod", "(")
            END IF
        NEXT
    END IF


    '******************************
    CALL TokenSubstitutions(1)
    IF Ndx = 0 THEN EXIT SUB
    '******************************

    IF Ndx = 3 AND ISZERO(WithCnt) THEN
        IF *Stk$[2] = ASC("+") AND *Stk$[3] = ASC("+") THEN
            FPRINT FP_WRITE, Scoot$, Clean$(Stk$[1]), "++;"
            Ndx = 0
            INCR Statements
            EXIT SUB
        END IF
        IF *Stk$[2] = ASC("-") AND *Stk$[3] = ASC("-") THEN
            FPRINT FP_WRITE, Scoot$, Clean$(Stk$[1]), "--;"
            Ndx = 0
            INCR Statements
            EXIT SUB
        END IF
        IF *Stk$[1] = ASC("+") AND *Stk$[2] = ASC("+") THEN
            FPRINT FP_WRITE, Scoot$, "++", Clean$(Stk$[3]), ";"
            Ndx = 0
            INCR Statements
            EXIT SUB
        END IF
        IF *Stk$[1] = ASC("-") AND *Stk$[2] = ASC("-") THEN
            FPRINT FP_WRITE, Scoot$, "--", Clean$(Stk$[3]), ";"
            Ndx = 0
            INCR Statements
            EXIT SUB
        END IF
    END IF

    '******************************
    IsCallBack = 0
    IF iMatchWrd(Stk$[Ndx], "callback") THEN
        IsCallBack = 1
        Stk$[Ndx--] = ""
    END IF
    '******************************

    CALL Transforms

    IF Ndx = 0 THEN EXIT SUB

    '********************************************************************
    '          Modification to allow 2 names as function types
    '********************************************************************

    IF iMatchWrd(Stk$[1], "function") OR iMatchWrd(Stk$[1], "impfunction") THEN
        IF iMatchWrd(Stk$[Ndx-2], "as") AND Stk$[Ndx] <> ")" THEN
            IF ISFALSE(iMatchWrd(Stk$[Ndx], "export")) AND _
                ISFALSE(iMatchWrd(Stk$[Ndx], "stdcall")) THEN
                Stk$[Ndx-1] += SPC$ + Stk$[Ndx]
                DECR Ndx
            END IF
        END IF
    END IF

    '********************************************************************
    ' Modification to allow 2 names as argument types in sub or function
    '********************************************************************
    DIM RAW iP = 1

    IF iMatchLft(Stk$[1], "public") OR iMatchLft(Stk$[1], "private") THEN INCR iP

    IF iMatchWrd(Stk$[iP], "function") OR iMatchWrd(Stk$[iP], "sub") THEN
        DIM RAW offset
        DIM RAW LastBrk = Ndx - 2

        FOR i = Ndx TO 3 STEP -1
            IF *Stk$[i] = ASC(")") THEN
                LastBrk = i
                EXIT FOR
            END IF
        NEXT

        XFOR i = 3, INTEGER jjj = 1 WHILE i <= LastBrk AND jjj BY i++
            offset = 2
            jjj = GetAsPosF(i, LastBrk)
            IF jjj THEN
                i = jjj
                IF (i < LastBrk) AND Stk$[i + offset] <> "=" THEN
                    IF iMatchWrd(Stk$[i+1], "function") THEN offset = 3
                    IF ISFALSE(INCHR(Stk$[i + offset], ")")) AND _
                        ISFALSE(INCHR(Stk$[i + offset], ",")) THEN
                        IF NOTZERO(LEN(Stk$[i + offset])) AND _
                            ISFALSE(iMatchWrd(Stk$[i + 3], "as")) THEN
                            Stk$[i+offset-1] += SPC$ + Stk$[i+offset]
                            Stk$[i + offset] = ""
                        END IF
                    END IF
                END IF
            END IF
        XNEXT

    END IF
    '***********************************************************
    '                      DynaCall Handler
    '***********************************************************

    IF ISFALSE(iMatchWrd(Stk$[1], "declare")) THEN
        FOR i = 1 TO Ndx
            IF iMatchWrd(Stk$[i], "lib") THEN
                IF Stk$[i-1] = "(" AND (DataType(Stk$[i+1]) = vt_STRLIT OR DataType(Stk$[i+1]) = vt_STRVAR) THEN
                    j = GetNumArgs(i+2)
                    LTmp$ = "BCX_DynaCallB"
                    IF ISFALSE(iMatchWrd(Stk$[1], "print")) THEN  ' print does its own casting
                        IF DataType(Stk$[i-2]) = vt_STRVAR OR DataType(Stk$[1]) = vt_STRVAR THEN
                            LTmp$ = "(char*)" + LTmp$
                        END IF
                    END IF
                    Var1$ = RIGHT$(Stk$[i-2], 1)
                    IF INCHR (VARTYPES$, Var1$) THEN
                        LTmp$ += Var1$
                        Stk$[i] = ENC$(LEFT$(Stk$[i-2], LEN(Stk$[i-2]) - 1))
                    ELSE
                        Stk$[i] = ENC$(Stk$[i-2])
                    END IF
                    Stk$[i-2] = LTmp$
                    FOR B = Ndx+3 TO i+3 STEP -1
                        Stk$[B] = Stk$[B-3]
                    NEXT
                    Stk$[i+2] = Stk$[i+1]
                    Stk$[i+1] = ","
                    Stk$[i+3] = ","
                    Stk$[i+4] = STR$(j, 1)
                    Stk$[i+5] = IIF$(j, ",", ")")
                    INCR Ndx, 3
                    Use_DynacallCommon = Use_Dynacall = Use_BcxTempStr = Use_Proto = TRUE
                END IF
            END IF
        NEXT
    END IF

    '*****************************************************
    LStk1$ = LCASE$(Stk$[1])   ' Performance Optimizer
    LStk2$ = LCASE$(Stk$[2])   ' Performance Optimizer
    '*****************************************************


    '*****************************************************
    ' We're looking for a OPEN "name" AS BINARY ... clause
    '*****************************************************

    IF LStk1$ = "open" THEN

        FOR A = 2 TO Ndx
            IF iMatchWrd(Stk$[A], "binary") THEN
                EXIT FOR
            END IF
        NEXT

        IF A = Ndx THEN EXIT SUB  ' This is not a "BINARY" clause OPEN statement

        IF A < Ndx THEN
            INCR A
            Var1$ = LCASE$(Stk$[A])

            IF Var1$ = "new" THEN
                Stk$[A-1]= "binarynew"
                LShiftStk(A)
                EXIT SUB
            END IF

            IF Var1$ = "append" THEN
                Stk$[A-1]= "binaryappend"
                LShiftStk(A)
                EXIT SUB
            END IF

            IF Var1$ = "input" THEN
                Stk$[A-1]= "binaryinput"
                LShiftStk(A)
                EXIT SUB
            END IF

            IF Var1$ = "output" THEN
                Stk$[A-1]= "binaryoutput"
                LShiftStk(A)
                EXIT SUB
            END IF
        END IF
    END IF

    '******************************

    IF LStk1$ = "option" THEN
        IF LStk2$ = "base" THEN
            OptionBase = IVAL (Stk$[3])
            Ndx = 0
            EXIT SUB
        END IF
    END IF

    '******************************

    IF LStk1$ = "dim"  THEN
        LTmp$ = ENC$(LStk2$, ASC(SPC$))
        IF iMatchNQ (" shared , dynamic , raw , local , auto , register , static ", LTmp$) THEN
            Stk$[1] = LStk2$
            LStk1$ = LStk2$
            LShiftStk(2)
        END IF
        EXIT SUB
    END IF

    '******************************

    IF LStk1$ = "public" THEN
        IF LStk2$ = "function" OR LStk2$ = "sub" THEN
            IF InClass THEN
                LStk1$ += LStk2$
                Stk$[1] = LStk1$
            ELSE
                Stk$[1] = LStk2$
            END IF
            LShiftStk(2)
        END IF
        EXIT SUB
    END IF

    '******************************

    ' creates a static function for use in $PROJECTs
    IF LStk1$ = "private" THEN
        IF LStk2$ = "function" OR LStk2$ = "sub" THEN
            IF InClass THEN
                LStk1$ += LStk2$
                Stk$[1] = LStk1$
            ELSE
                Use_Static = TRUE
                Stk$[1] = LStk2$
            END IF
            LShiftStk(2)
        END IF
        EXIT SUB
    END IF

    '******************************

    IF LStk1$ = "onexit" THEN
        IF LStk2$ = "sub" THEN
            Use_ExitCode = Use_Proto = TRUE

            IF cMaxExitSub = ++ExitNdx THEN
                CALL Abort("Maximum number of exit calls exceeded.")
            END IF

            ExitSub$[ExitNdx] = Stk$[3]
            Stk$[1] = LStk2$
            LStk1$ = LStk2$
            LShiftStk(2)
        END IF
        EXIT SUB
    END IF

    '******************************

    IF LStk1$ = "onstart" THEN
        IF LStk2$ = "sub" THEN
            Use_StartupCode = Use_Proto = TRUE

            IF cMaxStartSub = ++StartNdx THEN
                CALL Abort("Maximum number of startup calls exceeded.")
            END IF

            StartSub$[StartNdx] = Stk$[3]
            Stk$[1] = LStk2$
            LStk1$ = LStk2$
            LShiftStk(2)
            EXIT SUB
        END IF
        CALL Abort("ONSTART syntax error, can only be used with a SUB.")
    END IF

    '******************************

    IF LStk1$ = "overloaded" THEN
        IF LStk2$ = "function" THEN
            Stk$[1] = "overloadedfunction"
            LStk1$ = "overloadedfunction"
            LShiftStk(2)
            IF Stk$[2] <> "=" THEN
                OkayToSend = TRUE
            END IF
            EXIT SUB
        END IF

        IF LStk2$ = "sub" THEN
            Stk$[1]= "overloadedsub"
            LShiftStk(2)
            EXIT SUB
        END IF
    END IF

    '******************************

    IF LStk1$ = "function" THEN
        IF iMatchWrd(Stk$[3], "optional") THEN
            Stk$[1]= "optfunction"
            LStk1$ = "optfunction"
            LShiftStk(3)
            IF Stk$[2] <> "=" THEN
                OkayToSend = TRUE
            END IF
            EXIT SUB
        END IF
    END IF

    IF UseCpp = FALSE THEN           ' C++ doesn't need the OPTIONAL keyword
        IF LStk1$ = "function" THEN  ' Bcx 772 detects OPTIONAL without keyword
            IF Stk$[2] <> "=" THEN
                FOR INT ij = 3 TO Ndx
                    IF Stk$[ij] = "=" THEN
                        Stk$[1]= "optfunction"
                        LStk1$ = "optfunction"
                        EXIT SUB
                    END IF
                NEXT
            END IF
        END IF
    END IF

    '******************************

    IF LStk1$ = "sub" THEN
        IF iMatchWrd(Stk$[3], "optional") THEN
            LStk1$ = "optsub"
            Stk$[1]= "optsub"
            LShiftStk(3)
            EXIT SUB
        END IF
    END IF

    IF UseCpp = FALSE THEN        ' C++ doesn't need the OPTIONAL keyword
        IF LStk1$ = "sub" THEN    ' Bcx 772 detects OPTIONAL without keyword
            FOR INT ij = 2 TO Ndx
                IF Stk$[ij] = "=" THEN
                    Stk$[1]= "optsub"
                    LStk1$ = "optsub"
                    EXIT SUB
                END IF
            NEXT
        END IF
    END IF

    '******************************

    IF LStk1$ = "end" THEN
        IF Stk$[2] <> "=" THEN
            Stk$[1]= LStk1$ + LStk2$
            IF Ndx = 2 THEN
                Ndx = 1
                EXIT SUB
            ELSE
                IF iMatchWrd(Stk$[3], "as") THEN
                    Stk$[2] = ""
                    CALL RemEmptyTokens
                    EXIT SUB
                END IF
            END IF
        END IF
    END IF

    '******************************

    IF LStk1$ = "function" THEN
        IF Stk$[2] <> "=" THEN
            OkayToSend = TRUE
        END IF
    END IF

    '******************************

    IF LStk1$ = "midstr"  THEN

        IF INCHR(Stk$[3], DQ$) THEN
            CALL Abort ("MID$ statement string argument cannot be a literal")
        END IF

        CommaCnt = 0

        FOR i = 1 TO Ndx
            IF *Stk$[i] = ASC(",") THEN
                INCR CommaCnt
            ELSEIF Stk$[i]= "=" THEN
                IF CommaCnt < 2 THEN
                    Stk$[i] = "-1,"
                ELSE
                    Stk$[i]= ""
                END IF
                Stk$[i-1]= ","
                INCR Ndx
                Stk$[Ndx]= ")"
                EXIT FOR
            END IF
        NEXT
    END IF

    '******************************

    IF LStk1$ = "endevents" OR LStk1$ = "endmdievents" OR LStk1$ = "endmdichildevents" THEN
        DIM RAW szError$

        IF Use_Vscroll OR Use_Hscroll THEN
            Use_Max = Use_Min = TRUE

            Src$ = "GLOBAL BCX_siX AS SCROLLINFO"      : CALL Inject (Src$)
            Src$ = "GLOBAL BCX_siY AS SCROLLINFO"      : CALL Inject (Src$)
            Src$ = "GLOBAL BCX_DynaScroll AS INT"      : CALL Inject (Src$)

            FPRINT FP_WRITE, "static  int BCX_ViewWidth =", Use_Hscroll, ";"
            FPRINT FP_WRITE, "static  int BCX_ViewHeight =", Use_Vscroll, ";"
            FPRINT FP_WRITE, "static  int BCX_SmallChangeX;"
            FPRINT FP_WRITE, "static  int BCX_SmallChangeY;"
            FPRINT FP_WRITE, "static  int BCX_LargeChangeX;"
            FPRINT FP_WRITE, "static  int BCX_LargeChangeY;"
            FPRINT FP_WRITE, "static  int BCX_ScrollInit;"
            FPRINT FP_WRITE, ""
            FPRINT FP_WRITE, "  if(!BCX_ScrollInit)"
            FPRINT FP_WRITE, "   {"
            FPRINT FP_WRITE, "     BCX_siY.cbSize=sizeof(BCX_siY);"
            FPRINT FP_WRITE, "     BCX_siX.cbSize=sizeof(BCX_siX);"
            FPRINT FP_WRITE, "     BCX_siY.fMask=SIF_ALL;"
            FPRINT FP_WRITE, "     BCX_siX.fMask=SIF_ALL;"
            FPRINT FP_WRITE, "     BCX_siX.nMax=BCX_ViewWidth;"
            FPRINT FP_WRITE, "     BCX_siY.nMax=BCX_ViewHeight;"
            FPRINT FP_WRITE, "     BCX_SmallChangeX=1;"
            FPRINT FP_WRITE, "     BCX_LargeChangeX=20;"
            FPRINT FP_WRITE, "     BCX_SmallChangeY=1;"
            FPRINT FP_WRITE, "     BCX_LargeChangeY=20;"
            FPRINT FP_WRITE, "     BCX_siY.nPage=1;"
            FPRINT FP_WRITE, "     BCX_siX.nPage=1;"
            FPRINT FP_WRITE, "     SetScrollInfo(hWnd,SB_VERT,&BCX_siY,TRUE);"
            FPRINT FP_WRITE, "     SetScrollInfo(hWnd,SB_HORZ,&BCX_siX,TRUE);"
            FPRINT FP_WRITE, "     BCX_DynaScroll=TRUE;"
            FPRINT FP_WRITE, "     BCX_ScrollInit=TRUE;"
            FPRINT FP_WRITE, "   }"
            FPRINT FP_WRITE, " if(Msg==WM_HSCROLL||Msg==WM_VSCROLL||Msg==WM_SIZE)"
            FPRINT FP_WRITE, "   {"
            FPRINT FP_WRITE, "     BCX_Scroll(hWnd,Msg,wParam,lParam,BCX_LargeChangeX,"
            FPRINT FP_WRITE, "     BCX_LargeChangeY,BCX_SmallChangeX,BCX_SmallChangeY,"
            FPRINT FP_WRITE, "     BCX_ViewWidth,BCX_ViewHeight,BCX_DynaScroll);"
            FPRINT FP_WRITE, "   }"
        END IF

        IF ISFALSE(Use_BCX_Class_Info) THEN
            Use_BCX_Class_Info = TRUE
            iEmitVarGroup = iEmitVarGroup BOR (eFontGroup BOR eClassName)
        END IF

        IF LStk1$ <> "endmdichildevents" AND Use_MainEvent THEN
            Use_MainEvent = FALSE
            FPRINT FP_WRITE, "  if(Msg==WM_DESTROY)"
            FPRINT FP_WRITE, "    {"
            FPRINT FP_WRITE, "       OleUninitialize();"
            FPRINT FP_WRITE, "       CoUninitialize();"
            FPRINT FP_WRITE, "       PostQuitMessage(0);"
            FPRINT FP_WRITE, "       return EXIT_SUCCESS;"
            FPRINT FP_WRITE, "    }"
        END IF

        IF LStk1$ = "endevents" THEN
            FPRINT FP_WRITE, "Bcx_RetVal = DefWindowProc(hWnd,Msg,wParam,lParam);"
            FPRINT FP_WRITE, "return Bcx_RetVal; // endevents"

        ELSEIF LStk1$ = "endmdievents" THEN
            FPRINT FP_WRITE, "Bcx_RetVal = DefFrameProc(hWnd,BCX_hwndMDIClient,Msg,wParam,lParam);"
            FPRINT FP_WRITE, "return Bcx_RetVal;"

        ELSEIF LStk1$ = "endmdichildevents" THEN
            FPRINT FP_WRITE, "Bcx_RetVal = DefMDIChildProc(hWnd,Msg,wParam,lParam);"
            FPRINT FP_WRITE, "return Bcx_RetVal;"
        END IF

        FPRINT FP_WRITE, "}\n\n"
        sprintf(szError, "Too many unindents for END %s", UCASE$(LStk1+3))
        CALL BumpDown(szError$)

        IF Indent THEN
            PRINT REPEAT$(80, "_")
            PRINT "Possible missing END IF before END " + UCASE$(MID$(LStk1$, 4))
            PRINT REPEAT$(80, "_")
        END IF

        Ndx = 0
        InFunction = FALSE
        EXIT SUB
    END IF

    '******************************

    IF Stk$[2]= ":" THEN
        IF Ndx = 2 THEN
            LTmp$ = ENC$(LStk1$, ASC(SPC$))
            IF iMatchNQ(" public , private , protected ", LTmp$) = 0 THEN
                Stk$[1]= UCASE$(Stk$[1]) + ":"    ' preserve the GOTO labels
                Ndx = 1
            END IF
            EXIT SUB
        END IF
    END IF

    '******************************
    IF iMatchWrd(Stk$[3], "createwindow") THEN    ' HELPER
        Comma = 0
        FOR A = 4 TO Ndx
            IF Stk$[A]= "," THEN INCR Comma
            IF Stk$[A]= "," THEN
                IF Comma = 8 THEN
                    Stk$[A]= ",(HMENU)(UINT_PTR)"
                    INCR Comma
                END IF
            END IF
        NEXT
    END IF

    '******************************

    IF iMatchWrd(Stk$[3], "createwindowex") THEN
        Comma = 0
        FOR A = 4 TO Ndx
            IF Stk$[A]= "," THEN INCR Comma
            IF Stk$[A]= "," THEN
                IF Comma = 9 THEN       ' BEWARE - if any args contains commas, this helper blows up
                    Stk$[A]= ",(HMENU)(UINT_PTR)"
                    INCR Comma
                END IF
            END IF
        NEXT
    END IF

    '******************************

    IF *Stk$[Ndx]= ASC("*") THEN
        Stk$[Ndx-1] += "*"
        DECR Ndx
    END IF

    '******************************

    IF iMatchWrd(Stk$[3], "setwindowlong") OR iMatchWrd(Stk$[3], "setwindowlongptr") THEN    ' HELPER
        Comma = 0
        Stk$[3]= "(WNDPROC)(LONG_PTR)SetWindowLongPtr"
        FOR A = 4 TO Ndx
            IF Stk$[A]= "," THEN INCR Comma
            IF Stk$[A]= "," THEN
                IF Comma = 2 THEN
                    Stk$[A]= ",(LONG_PTR)"
                    INCR Comma
                END IF
            END IF
        NEXT
        EXIT SUB
    END IF

    IF TestState = TRUE THEN
        LOCAL Tmp$
        IF LastCmd = 0 THEN
            IF *Stk$[1] = ASC("*") THEN
                Tmp$ = Clean$(Stk$[2])
            ELSE
                Tmp$ = Clean$(Stk$[1])
            END IF
            IF LEFTSTR(Tmp$, "*") THEN Tmp$ = MID$(Tmp$, 2)
            i = INCHR(Tmp$, ".")
            IF i = 0 THEN i = iMatchNQ (Tmp$, "->")
            IF i > 0 THEN
                IF WithCnt THEN
                    Tmp$ = WithVar$[WithCnt]
                ELSE
                    Tmp$ = LEFT$(Tmp$, i - 1)
                END IF
            END IF
            IF INCHR(Tmp$, "[") THEN Tmp$ = EXTRACT$(Tmp$, "[")
            IF CheckLocal(Tmp$, ADDRESSOF(j)) = vt_UNKNOWN THEN
                IF CheckGlobal(Tmp$, ADDRESSOF(j)) = vt_UNKNOWN THEN
                    Tmp$ = LCASE$(Tmp$)

                    IF Stk$[2] = "=" AND IsAllowedContext(Tmp$) AND iMatchNQ(Src$, "->") = 0 THEN  ' MrBcx 827 - Refactored
                        Warning("Assignment before Declaration in Line " + STR$(LineNum[FileNdx]) + " in Module: " + TRIM$(FileNames$[FileNdx]) + ": " + Src$)
                    END IF

                END IF
            END IF
        END IF
    END IF
END SUB ' FixUps



FUNCTION IsAllowedContext(Tmp$) AS INT                         ' MrBcx 827 -  New
    IF Tmp$ = "functionreturn" THEN RETURN FALSE
    IF Tmp$ = "bcx_retstr" THEN RETURN FALSE
    IF Tmp$ = "end" THEN RETURN FALSE
    RETURN TRUE
END FUNCTION



SUB RemEmptyTokens
    '********************************************
    ' This SUB removes empty tokens from Stk$[].
    '********************************************
    DIM RAW i, j
    FOR i = 1 TO Ndx
        IF ISNULL(Stk$[i]) THEN
            j = i
            DO WHILE ISNULL(Stk$[j]) AND (j < Ndx)
                INCR j
            LOOP
            IF ISNULL(Stk$[j]) THEN EXIT FOR
            Stk$[i] = Stk$[j]
            Stk$[j] = ""
        END IF
    NEXT i
    Ndx = i-1
END SUB



SUB FuncSubDecs1(s$, iStart AS INTEGER, iEnd AS INTEGER, ptVar AS VARCODE PTR)
    '*****************
    DIM RAW iBrktPairLoc, iEmpty
    '*****************
    IF iMatchRgt(Stk$[iStart], s$) THEN
        IF DataType(Stk$[iStart+1]) = vt_STRVAR THEN
            Abort("Invalid " + s$ + " name")
        END IF
    END IF

    XFOR iEmpty = FALSE, iBrktPairLoc = GetBrkPairPos(iStart, iEnd) WHILE iBrktPairLoc _
        BY iBrktPairLoc = GetBrkPairPos(iBrktPairLoc, iEnd)
        DIM RAW iVarLoc = iBrktPairLoc - 1
        IF iMatchWrd(Stk$[iBrktPairLoc+2], "as") THEN
            Stk$[iBrktPairLoc+3] = Stk$[iBrktPairLoc+3] + "*"
            Stk$[iBrktPairLoc++] = "" : Stk$[iBrktPairLoc] = ""
            iEmpty = TRUE
        ELSEIF Stk$[iBrktPairLoc+2] = "[" THEN
            DO WHILE iBrktPairLoc <= iEnd
                IF iMatchWrd(Stk$[iBrktPairLoc], "as") THEN EXIT DO
                IF iMatchRgt(Stk$[iVarLoc], "]") AND INCHR(",)=", Stk$[iBrktPairLoc]) THEN EXIT DO
                Stk$[iVarLoc] += Stk$[iBrktPairLoc]
                Stk$[iBrktPairLoc++] = ""
                iEmpty = TRUE
            LOOP
        ELSE
            DIM RAW iDataType = DataType(Stk$[iVarLoc])
            Stk$[iVarLoc] = Clean$(Stk$[iVarLoc])
            IF iDataType = vt_STRVAR THEN
                CALL InsertTokens(iBrktPairLoc+1, 5, "[", "BCXSTRSIZE", "]", "as", "char")
                INCR iEnd, 5
            ELSE
                Stk$[iBrktPairLoc++] = "as"
                Stk$[iBrktPairLoc] = GetVarTypeName$(iDataType) + "*"
            END IF
        END IF
    XNEXT

    IF iMatchWrd(Stk$[iEnd], "export") THEN
        DECR Ndx
        ptVar->IsExported = TRUE
        IF UseStdCall THEN
            CallType$ = "__stdcall "
        ELSE
            CallType$ = "__cdecl "
        END IF
    END IF

    IF iEmpty THEN
        CALL RemEmptyTokens
    END IF
END SUB ' FuncSubDecs1



SUB FuncSubDecs2(s$, methd, VarCode AS VARCODE PTR, iFirstToken AS INTEGER, iLastToken AS INTEGER PTR)
    IF iMatchRgt(Stk$[iFirstToken], s$) THEN
        IF iMatchWrd(Stk$[*iLastToken-1], "as") THEN              ' SUB Foo () AS NOT_ALLOWED_DATATYPE
            CALL Abort("Attempted type assignment to " + s$)
        END IF
        VarCode->IsPtrFlag = 0
        CurrentFuncType = vt_VOID
    ELSE
        IF iMatchWrd(Stk$[(*iLastToken)-1], "as") THEN
            CurrentFuncType   = CheckType(Stk$[*iLastToken])
            VarCode->Token$   = Stk$[iFirstToken+1]
            VarCode->AsToken$ = Stk$[*iLastToken]
            VarCode->IsPtrFlag = TALLY(Stk$[*iLastToken], "*")
            Stk$[(*iLastToken)--] = ""
            Stk$[(*iLastToken)--] = ""
        ELSE
            ' Check if Constructor/Destructor
            IF Ctor_Dtor_Detected(1) THEN
                CurrentFuncType = vt_CONSTRDESTR
            ELSE
                CurrentFuncType = DataType(Stk$[iFirstToken+1])
            END IF
            VarCode->Token$ = Stk$[iFirstToken+1]
            VarCode->IsPtrFlag = TALLY(Stk$[iFirstToken+1], "*")
            VarCode->AsToken$ = ""
        END IF
    END IF
    VarCode->Proto$    = " ("
    VarCode->Header$   = " ("
    VarCode->Functype$ = ""
    VarCode->Methd%    = methd
    VarCode->VarNo%    = CurrentFuncType
    CALL GetVarCode(VarCode, "FuncSubDecs2")
END SUB ' FuncSubDecs2



SUB FuncSubDecs3(varcode AS VARCODE PTR, iLast AS INTEGER, iExtended AS INTEGER)
    '*****************************************************************************
    ' This function processes and formats the header and prototype strings for
    ' functions and subs in a specific programming context. It adjusts the header
    ' based on various conditions such as the presence of a period, whether C++ is
    ' used, and if the function accepts variant args. It also handles special cases
    ' for method prototypes, inline functions, and exported functions, ensuring
    ' that the correct syntax is applied for each scenario.
    '*****************************************************************************

    IF *Stk$[iLast-1] = ASC(".") THEN                      ' Allow Functions | Subs with one or
        Stk$[iLast-1] = "..."
        ' varcode->Header$ = varcode->Header$  +  "..."    ' more "." TO produce the "..." needed
    END IF

    varcode->Header$ = RTRIM$(varcode->Header$)
    varcode->Header$ += ")"

    IF UseCpp = FALSE THEN
        REPLACE "()" WITH "(void)" IN varcode->Header$
    END IF

    IF iExtended THEN
        varcode->Header$ = varcode->Functype$ + "(*" + varcode->Token$ + ")" + varcode->Header$
    ELSE
        varcode->Header$ = varcode->Functype$ + varcode->Token$ + varcode->Header$
    END IF

    IF varcode->Methd% = 2 THEN
        varcode->Proto$ = RTRIM$(varcode->Proto$)
        IF iMatchRgt(varcode->Proto$, ",")  THEN
            MID$(varcode->Proto$, LEN(varcode->Proto$)) = ")"
        ELSE
            varcode->Proto$ += ")"
        END IF

        REPLACE "()" WITH "(void)" IN varcode->Proto$
        IF iExtended THEN
            varcode->Proto$ = varcode->Functype$ + "(*)" + varcode->Proto$
        ELSE
            varcode->Proto$ = varcode->Functype$ + varcode->Token$ + varcode->Proto$ + ";"
        END IF
    END IF

    IF varcode->UseInLine THEN
        varcode->Header$ = "inline " + varcode->Header$
        varcode->Proto$  = "inline " + varcode->Proto$
    END IF
    UseInLine = FALSE

    IF varcode->IsExported THEN
        UseImportExport = TRUE
        varcode->Proto$  = "C_EXPORT " + varcode->Proto$
        varcode->Header$ = "C_EXPORT " + varcode->Header$
    END IF

    REPLACE " . " WITH "." IN varcode->Proto$           ' 8.1.1 MrBcx  - Fix bug with opt arg with decimal values
    REPLACE " . " WITH "." IN varcode->Header$          '                          Ditto
END SUB ' FuncSubDecs3



SUB AddTypeDefs(sTypeDefName$, TDef)
    '*************************************************************
    ' This SUB adds a new type definition to the TypeDefs array.
    '*************************************************************
    INCR TypeDefsCnt
    IF TypeDefsCnt = MaxTypes THEN
        CALL Abort("Exceeded TYPE Limits.")
    END IF
    TypeDefs[TypeDefsCnt].VarName$ = sTypeDefName$
    TypeDefs[TypeDefsCnt].TypeofDef = TDef
    TypeDefs[TypeDefsCnt].EleCnt = 0
END SUB ' AddTypeDefs



FUNCTION CheckTypeDefs(ParmStr AS STRING)
    '****************************************************************************
    ' This function searches for a given parameter name (ParmStr) in a list
    ' of type definitions.  If (ParmStr) is found, it returns the index
    ' of the matching type definition; otherwise, it returns 0.
    '****************************************************************************
    IF TypeDefsCnt > 0 THEN
        FOR INT i = 1 TO TypeDefsCnt
            IF ParmStr$ = TypeDefs[i].VarName$ THEN
                RETURN i
            END IF
        NEXT
    END IF
    RETURN 0
END FUNCTION ' CheckTypeDefs



SUB GetTypeInfo(szArg$, BYREF IsPointer, BYREF UdtIdx, BYREF vtCode)
    '**********************************************************************
    ' This SUB extracts information about a given type specified by szArg$.
    ' It determines whether the type is a pointer, searches for user-defined
    ' types (UDTs), and identifies the type code.
    ' Parameters:
    '   - szArg$: The string representing the type.
    '   - IsPointer: A variable to store whether the type is a pointer.
    '   - UdtIdx: A variable to store the index of the UDT, if applicable.
    '   - vtCode: A variable to store the type code.
    '**********************************************************************
    DIM RAW Var1$
    IsPointer = TALLY(szArg$, "*")
    Var1$     = TRIM$(REMOVE$(szArg$, "*"))

    IF RIGHTSTR (Var1$, "_CLASS") THEN Var1$ = LEFT$(Var1$, LEN(Var1$)-6)
    vtCode = CheckType(Var1$)

    IF vtCode = vt_UNKNOWN THEN
        CALL AddTypeDefs(Var1$, vt_UDT)    ' Assume its a WinApi type
        vtCode = vt_UDT
    END IF
    UdtIdx = 0
    IF vtCode = vt_STRUCT OR vtCode = vt_UNION OR vtCode = vt_UDT THEN
        UdtIdx = CheckTypeDefs(Var1$)
    END IF
END SUB ' GetTypeInfo



SUB AddTypedefElement(WorkingTypeDefsCnt, ElType, EName$, EType$, EPtr = 0)
    '****************************************************************************
    ' This SUB adds an element to a UDT.
    ' Parameters:
    '   - WorkingTypeDefsCnt: The index of the UDT in the TypeDefs array.
    '   - ElType: The type of the element to be added.
    '   - EName$: The name of the element.
    '   - EType$: The type of the element (if ElType is a UDT).
    '   - EPtr: Indicates whether the element is a pointer (default is 0).
    '****************************************************************************
    DIM RAW TD AS USERTYPEDEF PTR
    TD = ADDRESSOF((TypeDefs[WorkingTypeDefsCnt]))

    IF TD->EleCnt = MaxElements THEN
        CALL Abort("Exceeded TYPE Element Limits.")
    END IF

    TD->Elements[TD->EleCnt].ElementType    = ElType
    TD->Elements[TD->EleCnt].ElementDynaPtr = EPtr
    IF ElType = vt_STRUCT OR ElType = vt_UNION OR ElType = vt_UDT THEN
        TD->Elements[TD->EleCnt].ElementID = CheckTypeDefs(EType$)
    ELSE
        TD->Elements[TD->EleCnt].ElementID = 0
    END IF
    TD->Elements[TD->EleCnt].ElementName$ = EName$
    TD->EleCnt = 1 + TD->EleCnt
END SUB ' AddTypedefElement



FUNCTION GetElement$(StartStk, BYREF vt, BYREF dms, id)
    '*********************************************************************
    ' This function extracts and returns the name of an element
    ' starting from StartStk, identifying its type and dimensions.
    ' It handles nested structures and unions, modifying vt, dms, and
    ' id as it processes array brackets and struct/union access operators.
    '*********************************************************************
    DIM RAW BC = 0, i, LZZ$

    FOR i = StartStk+1 TO Ndx
        IF *Stk$[i] = ASC("[") THEN
            INCR BC
        ELSEIF *Stk$[i] = ASC("]") THEN
            DECR BC
        ELSE
            IF BC = 0 THEN
                IF iMatchLft(Stk$[i], "->") OR *Stk$[i] = ASC(".") THEN
                    LZZ$ = Stk$[i]
                    RemoveAll(LZZ$, "%$#!@`.->( *)", 1)
                    vt = GetElementInfo(ADDRESSOF(id), ADDRESSOF(dms), LZZ$)
                    IF vt <> vt_STRUCT AND vt <> vt_UNION THEN EXIT FOR
                END IF
            END IF
        END IF
    NEXT

    IF vt = vt_UDT OR vt = vt_UNION OR vt = vt_STRUCT THEN
        LZZ$ = TypeDefs[id].VarName$
    ELSE
        LZZ$ = GetVarTypeName$(vt)
    END IF
    RETURN LZZ$
END FUNCTION



FUNCTION GetElementInfo(BYREF DefID, BYREF EPtr, Elename$)
    '***************************************************************
    ' This function retrieves and returns the type of an element
    ' identified by Elename$ within a user-defined type. It updates
    ' DefID and EPtr with the element's ID and dynamic pointer,
    ' respectively, or returns 0 if the element is not found.
    '***************************************************************
    DIM RAW id
    id = DefID
    FOR INT i = 0 TO TypeDefs[id].EleCnt - 1
        IF Elename$ = TypeDefs[id].Elements[i].ElementName$ THEN
            DefID = TypeDefs[id].Elements[i].ElementID
            EPtr  = TypeDefs[id].Elements[i].ElementDynaPtr
            RETURN TypeDefs[id].Elements[i].ElementType
        END IF
    NEXT
    RETURN 0
END FUNCTION



SUB Process_Option_Base
    FOR INT i = 1 TO Ndx
        '*********************************************************************
        ' Tolerate nonsense like >> DIM A% as DOUBLE << by removing the sigil
        IF iMatchWrd(Stk$[i], "as") THEN Stk$[i-1] = Clean$(Stk$[i-1])
        '*********************************************************************
        ' Added code to prevent OPTION BASE errors                  MrBcx 818
        '      I observed, when using OPTION BASE 1, statements like this:
        '    DIM AS DOUBLE dx = BulletX [ BulletIndex ] - AsteroidX [ i ]
        '                  would be erroneously translated to:
        '     double dx = BulletX [ 1 + BulletIndex] - AsteroidX [ 1 + i];
        '          which is a complete disaster waiting to happen.
        '*********************************************************************
        IF Stk$[i] = "=" THEN EXIT SUB     ' Such an easy fix!      MrBcx 818
        '*********************************************************************
        '        This was the easiest way I could see to do this.
        '                           Improved by MrBcx
        '*********************************************************************
        IF OptionBase THEN
            '*****************************************************************
            ' Guard against statements like DIM RAW A[] = { ..      821 MrBcx
            '*****************************************************************
            IF *Stk$[i] = ASC("[") AND *Stk$[i+1] = ASC("]") THEN ITERATE
            '*****************************************************************

            IF *Stk$[i] = ASC("[") AND *Stk$[i+1] <> ASC("]")THEN
                IF DataType(Stk$[i+1]) = vt_NUMBER THEN
                    Stk$[i+1] = STR$(OptionBase + VAL(Stk$[i+1]), 1)
                ELSE
                    Stk$[i+1] = STR$(OptionBase, TRUE) + "+" + Stk$[i+1]
                END IF
            END IF
        END IF
    NEXT
END SUB ' Process_Option_Base



FUNCTION IsValidName(szArg$)
    '*******************************************************************************************
    ' This function checks if a given string is a valid identifier name according to BCX rules.
    ' Modified by Robert Wishlaw to support UNICODE identifiers in BCX 7.9.9
    '*******************************************************************************************
    IF NOT isalpha(*szArg$) AND *szArg$ <> ASC("_") AND NOT ((unsigned CHAR)*szArg$ > 192) THEN
        IF NOT iMatchLft(szArg$, "(*") AND szArg$ <> "&" THEN  ' Allow byref format (*A).xxx
            RETURN FALSE
        END IF
    END IF
    RETURN TRUE
END FUNCTION



SUB ValidateVarName(v$)
    '************************************************************************
    ' This subroutine checks the validity of a variable name, ensuring
    ' it conforms to BCX naming rules and is not a restricted word.
    ' Modified by Robert Wishlaw to support UNICODE identifiers in BCX 7.9.9
    '************************************************************************
    DIM RAW LZZ$

    IF LEFTSTR(v$, "3.14") THEN Abort ("PI is predefined in BCX.  You cannot DIM PI ...")

    IF NOT isalpha(*v$) AND *v$ <> ASC("_") AND NOT ((unsigned CHAR)*v$ > 192) THEN
        IF NOT iMatchLft(v$, "(*") AND v$ <> "&" THEN  ' Allow byref format (*A).xxx
            Abort("Invalid String Variable Name")
        END IF
    END IF

    IF RestrictedWords(v$) AND TestState THEN
        LZZ$ = "Variable " + v$ + " on line"
        LZZ$ += STR$(LineNum[FileNdx]) + " in Module: " + TRIM$(FileNames$[FileNdx]) + " is a Restricted Word"
        CALL Warning(LZZ$)
    END IF
END SUB ' ValidateVarName




SUB PointerFix
    '*******************************************************
    ' This subroutine concatenates consecutive stack tokens
    ' containing only asterisks (*) into a single token,
    ' effectively merging pointer declarations.
    '*******************************************************
    Stk$[Ndx-1] += Stk$[Ndx]
    Stk$[Ndx] = ""
    DECR Ndx
    DO WHILE TALLY(Stk$[Ndx], "*") = LEN(Stk$[Ndx])
        Stk$[Ndx-1] += Stk$[Ndx]
        Stk$[Ndx] = ""
        DECR Ndx
    LOOP
END SUB ' PointerFix



SUB DimDynaString(SVar$, DG, s)
    DIM RAW DS$

    DS$ = "if (" + SVar$ + ") {free(" + SVar$ + "); " + SVar$ + " = NULL;}"
    IF InFunction AND (IsLocal OR IsDim OR IsRaw OR IsAuto OR IsRegister) AND DG = 0 THEN

        IF cMaxDynaStr = ++LocalDynaCnt THEN
            CALL Abort("Maximum number of local dynamic allocations exceeded.")
        END IF

        DynaStr$[LocalDynaCnt] = DS$

        IF IsAuto THEN
            FPRINT FP_WRITE, Scoot$, "char *", SVar$, ";"
        ELSEIF IsRegister THEN
            FPRINT FP_WRITE, Scoot$, "char *", SVar$, ";"
        ELSE
            FPRINT FP_WRITE, Scoot$, "char *", SVar$, ";"
        END IF
        CALL AddLocal(SVar$, vt_CHAR, 0, "", 1)
    ELSE
        IF Use_GenFree THEN
            CALL AddDynamicGlobal(DS$)
        END IF
        IF DG = 2 THEN
            CALL AddGlobal(SVar$, vt_CHAR, 0, "", 1, 0, 1)
        ELSE
            IF s THEN
                CALL AddGlobal(SVar$, vt_CHAR, 0, "", 1, 0, 2)
            ELSE
                CALL AddGlobal(SVar$, vt_CHAR, 0, "", 1)
            END IF
        END IF
    END IF
    IF DG <> 2 THEN
        FPRINT FP_WRITE, Scoot$, SVar$ , "=(char*)calloc(";
        Stk$[++Ndx] = ",1);"
        CALL WriteCleanTokens(4, Ndx)
    END IF
END SUB ' DimDynaString



SUB AddDynamicGlobal(szGlobalStr AS PCHAR)
    INCR GlobalDynaCnt
    IF cMaxGlobalDyna = GlobalDynaCnt THEN
        CALL Abort("Maximum number of global dynamic arrays exceeded.")
    END IF
    GlobalDynaStr$[GlobalDynaCnt] = szGlobalStr$
END SUB



FUNCTION SubFuncTest
    IF iMatchWrd(Stk$[2], "function") OR iMatchWrd(Stk$[2], "sub") THEN
        RETURN 1
    END IF
    RETURN 0
END FUNCTION ' SubFuncTest



FUNCTION Ctor_Dtor_Detected(iTokenLoc AS INTEGER)
    IF iMatchWrd(Stk$[iTokenLoc], "constructor") OR iMatchWrd(Stk$[iTokenLoc], "destructor") THEN
        RETURN 1
    END IF
    RETURN 0
END FUNCTION ' Ctor_Dtor_Detected



FUNCTION DimSubFunc(iMethod)
    '********************************************************************************
    ' This function processes function declarations and initializes data if present.
    ' iMethod specifies whether the function is a method (1 for method, 0 otherwise).
    '********************************************************************************
    GLOBAL SFPOINTER
    DIM RAW bOppFound AS BOOL
    DIM RAW Funptr = 0
    DIM RAW i
    DIM RAW id
    DIM RAW iEqualLoc
    DIM RAW LTmp$ = ""
    DIM RAW StartPoint = 3
    DIM RAW szInit$
    DIM RAW szIsConst$
    DIM RAW szStatic$
    DIM RAW szV$
    DIM RAW szWrk$
    DIM RAW vt
    DIM RAW w
    DIM RAW FP AS FUNCPARSE
    CLEAR(FP)

    IF iMatchWrd(Stk$[Ndx], "stdcall") THEN
        CallType$ = "__stdcall "
        Stk$[Ndx--] = ""
        IsStdFunc = TRUE
    ELSE
        IF InClass OR InCppTypeDef THEN
            CallType$ = ""
        ELSE
            CallType$ = "__cdecl "    ' Default calling convention
        END IF
        IsStdFunc = FALSE
    END IF

    IF iMatchWrd(Stk$[3], "operator") THEN
        XFOR i = 4, bOppFound = FALSE WHILE NOT bOppFound BY i++
            IF Stk$[i] = "(" THEN
                IF Stk$[i+1] <> ")" AND Stk$[i+2] <> "(" THEN bOppFound = TRUE
                IF Stk$[i+1] = ")" AND i > 4 THEN bOppFound = TRUE
            END IF
            IF NOT bOppFound THEN
                Stk$[3] += Stk$[i]
                Stk$[i] = ""
            END IF
        XNEXT
    END IF

    szWrk$ = Clean$(Stk$[Ndx])

    IF *szWrk$ THEN
        GetTypeInfo(szWrk$, ADDRESSOF(w), ADDRESSOF(id), ADDRESSOF(vt))
        IF vt = vt_WINBOOL THEN
            IREPLACE "WINBOOL" WITH "BOOL" IN Stk$[Ndx]
        END IF
    END IF

    ' ------------------------------------------------------
    '  Find start of function body (...)
    ' ------------------------------------------------------

    CALL SepFuncArgs(3, ADDRESSOF(FP), TRUE)

    StartPoint = IMAX(FP.CommaPos[0], 3)

    IF NOT InTypeDef AND NOT InCppTypeDef AND NOT InClass THEN
        SFPOINTER = TRUE
        ' ------------------------------------------------------
        '  Get intialized data  " = xxx" or "= {xxx,xxx}"
        ' ------------------------------------------------------
        IF FP.NumArgs = 0 THEN
            i = IMIN(FP.CommaPos[1]+1, Ndx)
        ELSE
            i = IMIN(FP.CommaPos[FP.NumArgs]+1, Ndx)
        END IF

        IF Stk$[i] = "=" THEN
            Stk$[i++] = ""
            DO WHILE NOT iMatchWrd(Stk$[i], "as") AND i <= Ndx
                LTmp$ += Stk$[i]
                Stk$[i++] = ""
            LOOP
            RemoveAll(LTmp$, "{}", 1)
            IF LTmp$ <> "" THEN CALL RemEmptyTokens
        END IF
        ' ------------------------------------------------------

        FPRINT FP_UDT, Scoot$, MakeDecProto$(ADDRESSOF(FP)), ";"

        SFPOINTER = FALSE

        Ndx = StartPoint
        Stk$[2] = ""

        IF LTmp$ <> "" THEN
            Stk$[Ndx++] = "="
            Stk$[Ndx++] = "{"
            Stk$[Ndx++] = Clean$(LTmp$)
            Stk$[Ndx++] = "}"
        END IF

        Stk$[Ndx++] = "as"
        Stk$[Ndx] = Clean$(Stk$[3]) + "_TYPE" + STRING$(Funptr, ASC("*"))

        CALL RemEmptyTokens
        RETURN FALSE

    ELSE    ' C++
        szV$       = ""
        szWrk$     = ""
        szStatic$  = ""
        szIsConst$ = ""
        szInit$    = ""
        iEqualLoc  = Ndx

        IF IsVirtual THEN
            szV$ = "virtual "
            IsVirtual = FALSE
        ELSE
            szV$ = ""
        END IF

        DO WHILE Stk$[iEqualLoc] <> "=" AND iEqualLoc
            IF Stk$[iEqualLoc] = ")" THEN EXIT DO
            DECR iEqualLoc
        LOOP

        IF Stk$[iEqualLoc] = "=" THEN
            szInit$ = Stk$[iEqualLoc++]
            szInit$ += Stk$[iEqualLoc++]
        END IF

        IF iMatchWrd(Stk$[Ndx], "const") THEN
            szIsConst$ = "const"
        ELSE
            szIsConst$ = ""
        END IF

        IF iMatchWrd(Stk$[1], "static") THEN
            szStatic$ = "static "
        ELSE
            szStatic$ = ""
        END IF

        szWrk$ = MakeDecProto$(ADDRESSOF(FP))

        IF iMethod THEN
            szWrk$ = TRIM$(MID$(szWrk$, INCHR(szWrk$, SPC$)))
        END IF

        IF szVirtual$ = szInit$ THEN
            szInit$ = ""
        END IF

        FPRINT FP_UDT, Scoot$, szV$, szStatic$, szWrk$, szVirtual$, szInit$, szIsConst$, ";"
        szVirtual$ = ""
    END IF

    RETURN TRUE
END FUNCTION ' DimSubFunc



SUB InBlockReSet
    LocalVarCnt = LocalInBlock[InBlock]
    DECR InBlock
    IF InBlock < 0 THEN
        Abort("Too many END BLOCKS")
    END IF
END SUB



SUB InBlockSet
    INCR InBlock

    IF InBlock = cMaxLocalInBlocks THEN
        CALL Abort("Too many nested BEGINBLOCK/ENDBLOCKs")
    END IF

    LocalInBlock[InBlock] = LocalVarCnt
END SUB




SUB AddSpace(i AS INTEGER)
    IF IsValidName(Stk$[i]) AND IsValidName(Stk$[i+1]) THEN
        Stk$[i] += SPC$
    END IF
END SUB





SUB Emit_Old(FuncRetnFlag AS INTEGER PTR)
    '********************************
    LOCAL strtest, varid, vi AS VARINFO PTR, vr$, brcnt, LTmp$
    LOCAL eo_H, eo_I, eo_J, eo_K
    LOCAL HasStorage
    DIM RAW Arg$
    DIM RAW EqlSgnPos

    IF Ndx = 0 THEN EXIT SUB

    '**********************************************************************
    ' "="  We MUST be processing an assignment statement if we arrive here!
    '      or perhaps calling a SUB without using the CALL keyword
    '**********************************************************************

    FOR INT i = 1 TO Ndx
        IF Im_UDT_String (Stk$[i]) THEN Stk$[i] += "$"
        IF Im_UDT_Single (Stk$[i]) THEN Stk$[i] += "!"
        IF Im_UDT_Double (Stk$[i]) THEN Stk$[i] += "#"
    NEXT

    FOR EqlSgnPos = 1 TO Ndx
        IF *Stk$[EqlSgnPos] = ASC("=") THEN
            '********************************
            IF NOT(*Stk$[EqlSgnPos-1] = ASC("<") OR _   ' This IF block restored from 759.
                *Stk$[EqlSgnPos-1] = ASC(">")    OR _   ' 760 through 781 had a flaw that
                *Stk$[EqlSgnPos-1] = ASC("+")    OR _   ' revealed itself in a very old
                *Stk$[EqlSgnPos-1] = ASC("-")    OR _   ' SEMI-OOP demo.
                *Stk$[EqlSgnPos-1] = ASC("/")    OR _   ' I renamed the variable "B" to the
                *Stk$[EqlSgnPos-1] = ASC("*"))   THEN   ' more useful "EqlSgnPos" (MrBcx)
                EXIT FOR
            END IF
            '********************************
        END IF
    NEXT

    '*************************************************************************
    ' There's no "=" so we're either calling a SUB or this is a FUNCTION RETURN
    '*************************************************************************

    IF EqlSgnPos - 1 = Ndx THEN
        CALL BuildCleanStr(1, Ndx, LTmp$)
        LTmp$ += ";"
        IF *FuncRetnFlag = 2 THEN
            FPRINT FP_WRITE, LTmp$
        ELSE
            FPRINT FP_WRITE, Scoot$, LTmp$
        END IF
        IF *FuncRetnFlag = 2 THEN
            *FuncRetnFlag = 0
            Stk$[1] = ""
            EXIT SUB
        END IF
        EXIT SUB
    END IF

    '*************************************************************************
    '      It can only be one thing now -- a normal assignment statement
    '*************************************************************************

    FOR eo_I = 2 TO EqlSgnPos-1
        Stk$[1] += Stk$[eo_I]          ' If present, build the Array Variable
    NEXT

    '*************************  825 New Block added by MrBcx  ****************

    IF Im_UDT_String(Stk$[1]) THEN
        Stk$[1] += "$"                            ' strengthen sigil-less UDT member use
        FOR INT i = EqlSgnPos + 1 TO Ndx          '                and
            IF Stk$[i] = "+" THEN                 ' detect string concatenations
                IF Stk$[i+1] = "+" THEN EXIT FOR  ' Preserve "++" operators
                Stk$[i] = "&"                     ' strengthen string concat detection
                EXIT FOR                          ' We only need to change the 1st one
            END IF
        NEXT
    END IF

    '*************************************************************************

    eo_H = INCHR(Stk$[1], "*")
    IF eo_H THEN
        IF NOT (INCHR(Stk$[1], "$") AND eo_H > 1) THEN ' Exclude strings BYREF
            RemoveAll(Stk$[1], "$")
            GOTO ProcessNumeric
        END IF
    END IF

    '*************************************************************************
    '                    ' Process a string expression
    '*************************************************************************

    strtest = DataType(Stk$[1])

    IF *Stk$[1] <> ASC("(") THEN
        IF strtest = vt_UNKNOWN THEN
            Stk$[1] += "$"
            strtest = vt_STRVAR
        END IF
    END IF

    IF strtest = vt_INTEGER THEN
        brcnt = TALLY(Stk$[1], "[")
        vr$ = EXTRACT$(Stk$[1], "[")
        strtest = CheckLocal(vr$, ADDRESSOF(varid))

        IF strtest = vt_UNKNOWN THEN
            strtest = CheckGlobal(vr$, ADDRESSOF(varid))
            vi = ADDRESSOF((GlobalVars[varid]))
        ELSE
            vi = ADDRESSOF((LocalVars[varid]))
        END IF

        IF strtest = vt_CHAR OR strtest = vt_SCHAR THEN
            strtest = vt_STRVAR
        END IF

        IF strtest = vt_STRVAR THEN
            IF NOTZERO (vi->VarPntr) THEN
                ' string pointer
                GOTO ProcessNumeric
            END IF
            IF TALLY(vi->VarDim, "[") = brcnt THEN
                ' the character within string
                GOTO ProcessNumeric
            END IF
            IF TALLY(vi->VarDim, "[") <> brcnt + 1 THEN
                ' string pointer
                GOTO ProcessNumeric
            END IF
        END IF
    END IF

    '*************************************************************************
    '       NOTE: Do not relocate this UDT-CHECK block         - MrBcx
    '*************************************************************************

    IF strtest = vt_UNKNOWN THEN
        IF NOT INCHR(Stk$[1], "$") THEN
            IF Im_UDT_String (Stk$[1]) THEN
                Stk$[1] += "$"
                strtest = vt_STRVAR
            END IF
        END IF
    END IF

    IF strtest = vt_UNKNOWN THEN
        IF NOT INCHR(Stk$[1], "!") THEN
            IF Im_UDT_Single (Stk$[1]) THEN
                Stk$[1] += "!"
                strtest = vt_SINGLE
            END IF
        END IF
    END IF

    IF strtest = vt_UNKNOWN THEN
        IF NOT INCHR(Stk$[1], "#") THEN
            IF Im_UDT_Double (Stk$[1]) THEN
                Stk$[1] += "#"
                strtest = vt_DOUBLE
            END IF
        END IF
    END IF

    '****************************************************************************
    '           This is where we assign a value to a string variable
    '****************************************************************************

    IF strtest = vt_STRVAR THEN

        IF EqlSgnPos + 1 = Ndx THEN
            IF Stk$[Ndx] = DDQ$ THEN
                FPRINT FP_WRITE, Scoot$, "*", Clean$(Stk$[1]), "=0;"
                GOTO StringExit
            END IF
        END IF

        ' [ Speedup No. 1 ] *****************************************************

        IF Ndx = 3 THEN
            Stk$[1] = Clean$(Stk$[1])
            Stk$[3] = Clean$(Stk$[3])
            IF Stk$[1] = "BCX_RetStr" THEN
                FPRINT FP_WRITE, Scoot$, "BCX_RetStr = BCX_TempStr(strlen(", Stk$[3], "));"
            END IF
            FPRINT FP_WRITE, Scoot$, "strcpy(", Stk$[1], ",", Stk$[3], ");"
            GOTO StringExit
        END IF

        '***********************
        Arg$  = ""
        LTmp$ = ""
        eo_J = eo_K = 0
        '***********************

        IF iMatchLft(Stk$[3], "$$") THEN HasStorage = TRUE

        Var$ = Clean$(Stk$[1])

        IF Clean$(Stk$[EqlSgnPos+1]) = Var$ THEN
            eo_K = TRUE
        END IF

        FOR eo_H = EqlSgnPos+1 TO Ndx
            IF Stk$[eo_H]= "&" AND Stk$[eo_H-1] <> "," AND Stk$[eo_H-1] <> "(" THEN
                INCR eo_J
                Arg$ += LTmp$
                LTmp$ = ","
            ELSE
                LTmp$ += Clean$(Stk$[eo_H])
            END IF
        NEXT

        IF NOTNULL (LTmp$) AND LTmp$ <> "," THEN
            Arg$ += LTmp$
        END IF

        '*************************************************************************
        '               String Assignment Construction Rules
        '*************************************************************************
        '           IF eo_J = 0 & K = ANY       THEN use strcpy
        '           IF eo_J = 1 & K = TRUE      THEN use strcat
        '           Everything else             THEN use join
        '*************************************************************************

        RemoveAll(Var$, SPC$)

        IF eo_J = 0 THEN
            IF Var$ = "BCX_RetStr" THEN
                IF HasStorage THEN
                    FPRINT FP_WRITE, Scoot$, "BCX_RetStr=", Arg$, ";"
                    GOTO StringExit
                ELSE
                    FPRINT FP_WRITE, Scoot$, "BCX_RetStr = BCX_TempStr(strlen(", Arg$, "));"
                END IF
            END IF
            '*********************************************************************
            IF RIGHT$(Var$, 3) = "[0]" AND Arg$ = "0" THEN           ' MrBcx 827 -- handle edge case
                FPRINT FP_WRITE, Scoot$, Var$, " = 0;"
            ELSE
                FPRINT FP_WRITE, Scoot$, "strcpy(", Var$ , "," , Arg$, ");"
            END IF
            GOTO StringExit
        END IF

        ' If we make it here then we should have 2 or more string expressions

        IF eo_K = TRUE AND eo_J = 1 THEN
            FPRINT FP_WRITE, Scoot$, "strcat(", Arg$ , ");"
            GOTO StringExit
        END IF

        ' STR$ has an opt argument.  FALSE is the default and TRUE means
        ' omit the space on the result, eliminating the need for LTRIM$

        LTmp$ = STR$(++eo_J, 1)
        Use_Join = Use_BcxTempStr = TRUE

        IF Var$ = "BCX_RetStr" THEN
            FPRINT FP_WRITE, Scoot$, "BCX_RetStr=join(" , LTmp$ , "," , Arg$, ");"
        ELSE
            FPRINT FP_WRITE, Scoot$, "strcpy(", Var$, ", join(" , LTmp$ , "," , Arg$, "));"
        END IF

        StringExit:
        EXIT SUB
        '***********************

    ELSE

        '***********************
        ProcessNumeric:
        '***********************

        FOR INT i = 1 TO Ndx
            IF Stk$[i] = "!=" THEN Stk$[i] = CHR$(198, 230)     ' 8.1.1 (MrBcx) Prevent <> and != truncation
        NEXT

        FOR eo_I = 2 TO EqlSgnPos
            Stk$[eo_I] = ""
        NEXT

        Stk$[EqlSgnPos] = "="    ' This is necessary

        ' change x = x ? c to x ?= c

        IF Stk$[EqlSgnPos+1] = Stk$[1] AND Ndx = 5 THEN
            IF INSTR(Stk$[EqlSgnPos+2], ANY "+-*/") AND Stk$[EqlSgnPos+3] <> ">" THEN   ' MrBcx 819 updated code
                Stk$[EqlSgnPos] = Stk$[EqlSgnPos+2] + Stk$[EqlSgnPos]
                Stk$[EqlSgnPos+1] = ""
                Stk$[EqlSgnPos+2] = ""
            END IF
        END IF

        FOR eo_H = 2 TO Ndx
            IF isdigit(*Stk$[eo_H]) AND iMatchRgt(Stk$[eo_H], "E") THEN
                Stk$[eo_H] += Stk$[eo_H+1]
                IF *Stk$[eo_H+1] = ASC("-") THEN
                    Stk$[eo_H] += Stk$[eo_H+2]
                    Stk$[eo_H+2] = ""
                END IF
                Stk$[eo_H+1] = ""
            END IF
        NEXT

        FPRINT FP_WRITE, Scoot$, Clean$(Stk$[1]);                          ' Suppress CRLF
        LOCAL eo_FoundEql
        '**************************************************************************************
        FOR INT A = 2 TO Ndx
            IF *Stk$[A] = ASC("=") THEN eo_FoundEql = TRUE
            IF *Stk$[A] = ASC("!") THEN
                FPRINT FP_WRITE, "!";                                      ' Suppress CRLF
                IF eo_FoundEql = FALSE THEN
                    IF *Stk$[A-1] <> ASC("=") THEN
                        REPLACE CHR$(198, 230) WITH "!=" IN Stk$[A-1]      ' 8.1.1 (MrBcx) Prevent <> and != truncation
                        FPRINT FP_WRITE, "=";
                    END IF
                END IF
            ELSE
                Stk$[A] = Clean$(Stk$[A])
                REPLACE CHR$(198, 230) WITH "!=" IN Stk$[A]                ' 8.1.1 (MrBcx) Prevent <> and != truncation
                FPRINT FP_WRITE,  Stk$[A];                                 ' Suppress CRLF
            END IF
            IF A < Ndx THEN
                IF ISFALSE(ispunct(*Stk$[A+1])) THEN FPRINT FP_WRITE, "";  ' Suppress CRLF
            END IF
        NEXT
        '**************************************************************************************
        FPRINT FP_WRITE, ";"
    END IF
END SUB ' Emit_Old



SUB Display_Version_and_Compiler
    IF BCX_COLORS THEN COLOR 10, 0
    PRINT "Version ", VERSION$, Compiler_Used$()
    POPCOLORS
END SUB



FUNCTION Compiler_Used$
    DIM RAW Buff$ =  " Compiled using "
    $IFDEF __BCPLUSPLUS__
        Buff$ += "Embarcadero C++"
    $ELSEIF __INTEL_LLVM_COMPILER               ' MrBcx 826  Intel OneAPI 64-bit c++ compiler
        Buff$ += "Intel C++ Compiler"
    $ELSEIF __BORLANDC__
        Buff$ += "Embarcadero C++"
    $ELSEIF __DMC__
        Buff$ += "Digital Mars C/C++"
    $ELSEIF __POCC__
        Buff$ += "Pelles C"
    $ELSEIF __LCC__
        Buff$ += "Lcc-Win32"
    $ELSEIF __clang__ AND __MINGW64__
        Buff$ += "LLVM-MinGW64 ("
        Buff$ += __VERSION__$
        Buff$ += ")"
    $ELSEIF __MINGW64__
        Buff$ += "MinGW64 C++ ("
        Buff$ += __VERSION__$
        Buff$ += ")"
    $ELSEIF __MINGW32__
        Buff$ += "MinGW32 C++ ("
        Buff$ += __VERSION__$
        Buff$ += ")"
    $ELSEIF __clang__
        Buff$ += "LLVM-Clang ("
        Buff$ += STR$(__clang_major__, 1)
        Buff$ += "."
        Buff$ += STR$(__clang_minor__, 1)
        Buff$ += "."
        Buff$ += STR$(__clang_patchlevel__, 1)
        Buff$ += ")"
    $ELSEIF _MSC_VER
        Buff$ += "MS Visual C++ ("
        Buff$ += STR$(_MSC_FULL_VER, 1)
        Buff$ += ")"
    $ELSE
        Buff$ += "Unknown Compiler"
    $ENDIF
    $IFDEF _WIN64
        Buff$ += " for 64-bit Windows"
    $ELSE
        Buff$ += " for 32-bit Windows"
    $ENDIF
    RETURN Buff$
END SUB




SUB KillFiles
    IF DebugModeOff THEN
        KILL hdrFile$
        KILL enuFile$
        KILL SysFile$
        KILL UsrFile$
        KILL udtFile$
        KILL setFile$
        KILL cppFile$
        KILL prcFile$
        KILL ovrFile$
        KILL datFile$
        KILL resFile$
    END IF
END SUB



SUB Abort(AbortStr$)
    LOCAL i AS INTEGER
    LOCAL j AS INTEGER
    LOCAL k AS INTEGER
    LOCAL t$
    LOCAL varnum
    LOCAL frmt$

    WarnMsg$ = ""

    IF LEFTSTR(AbortSrc$, "$BCXVERSION") THEN
        WarnMsg$ += AbortStr$
    ELSE
        WarnMsg$ += AbortStr$ + " at line" + STR$(LineNum[FileNdx])
        WarnMsg$ += " in Module: " + TRIM$(FileNames$[FileNdx]) + CRLF$
        WarnMsg$ += "Original line" + CRLF$
        WarnMsg$ +=  AbortSrc$ + CRLF$
        WarnMsg$ += "==============" + CRLF$
        WarnMsg$ += "Current Tokens" + CRLF$
        WarnMsg$ += "==============" + CRLF$

        FOR k = 1 TO Ndx
            j = LEN(Stk$[k])

            IF j < 40 THEN
                j = 40 - j
            ELSE
                j = 8 - IMOD(j, 8)
            END IF

            frmt$ = LPAD$(STR$(k), 3)

            WarnMsg$ += frmt$ + SPC$ + Stk$[k] + STRING$(j, 32) + CRLF$

            t$ = Clean$(Stk$[k])
            i = CheckLocal(t$, ADDRESSOF(varnum))

            IF i <> vt_UNKNOWN THEN
                WarnMsg$ = TRIM$(WarnMsg$)
                WarnMsg$ += " is a LOCAL defined at line" + STR$(LocalVars[varnum].VarLine)
                WarnMsg$ += " in Module: " + LocalVars[varnum].VarModule$ + CRLF$
            ELSE
                i = CheckGlobal(t$, ADDRESSOF(varnum))
                IF i <> vt_UNKNOWN THEN
                    WarnMsg$ = TRIM$(WarnMsg$)
                    WarnMsg$ += " is a GLOBAL defined at line" + STR$(GlobalVars[varnum].VarLine)
                    WarnMsg$ += " in Module: " + GlobalVars[varnum].VarModule$
                    WarnMsg$ += SPC$ + Stk$[k] + GlobalVars[varnum].VarDim$ + " as "
                    IF GlobalVars[varnum].VarDef THEN
                        WarnMsg$ += TRIM$(TypeDefs[GlobalVars[varnum].VarDef].VarName$) + CRLF$
                    ELSE
                        WarnMsg$ += TRIM$(GetVarTypeName$(GlobalVars[varnum].VarType)) + CRLF$
                    END IF
                ELSE
                    IF *Stk$[k] = c_DblQt THEN
                        WarnMsg$ = TRIM$(WarnMsg$)
                        WarnMsg$ += " is a string literal" + CRLF$
                    END IF
                END IF
            END IF
        NEXT

        WarnMsg$ += "===============" + CRLF$
        WarnMsg$ += "Original Tokens" + CRLF$
        WarnMsg$ += "===============" + CRLF$

        CALL XParse(AbortSrc$)

        FOR k = 1 TO Ndx
            j = LEN(Stk$[k])
            IF j < 40 THEN
                j = 40 - j
            ELSE
                j = 8 - IMOD(j, 8)
            END IF

            frmt$ = LPAD$(STR$(k), 3)

            WarnMsg$ += frmt$ + SPC$ + Stk$[k] + STRING$(j, 32) + CRLF$

            t$ = Clean$(Stk$[k])
            i = CheckLocal(t$, ADDRESSOF(varnum))

            IF i <> vt_UNKNOWN THEN
                WarnMsg$ = TRIM$(WarnMsg$)
                WarnMsg$ += " is a LOCAL defined at line" + STR$(LocalVars[varnum].VarLine)
                WarnMsg$ += " in Module: " + LocalVars[varnum].VarModule$ + CRLF$
            ELSE
                i = CheckGlobal(t$, ADDRESSOF(varnum))
                IF i <> vt_UNKNOWN THEN
                    WarnMsg$ = TRIM$(WarnMsg$)
                    WarnMsg$ += " is a GLOBAL defined at line" + STR$(GlobalVars[varnum].VarLine)
                    WarnMsg$ += " in Module: " + GlobalVars[varnum].VarModule$
                    WarnMsg$ += SPC$ + Stk$[k] + GlobalVars[varnum].VarDim$ + " as "
                    IF GlobalVars[varnum].VarDef THEN
                        WarnMsg$ += TypeDefs[GlobalVars[varnum].VarDef].VarName$ + CRLF$
                    ELSE
                        WarnMsg$ += GetVarTypeName$(GlobalVars[varnum].VarType) + CRLF$
                    END IF
                ELSE
                    IF *Stk$[k] = c_DblQt THEN
                        WarnMsg$ = TRIM$(WarnMsg$)
                        WarnMsg$ += " is a string literal" + CRLF$
                    END IF
                END IF
            END IF
        NEXT
    END IF

    WarnMsg$ += CRLF$

    CALL CloseAll
    CALL KillFiles
    KILL "$WRK$.TXT"
    KILL FileOut$
    KILL "$t$e$m$p"

    IF ErrFile THEN
        OPEN FileErr$ FOR APPEND AS fpErr
        FPRINT fpErr, AbortStr$ , " at line" , LineNum[FileNdx] , " in Module: ", TRIM$(FileNames$[FileNdx]) ' LinesRead
        CLOSE fpErr
    END IF

    IF InfoBoxWarn THEN
        INFOBOX("Warnings! :" , WarnMsg$, GetSystemMetrics(SM_CXSCREEN)/4, GetSystemMetrics(SM_CYSCREEN)/4)
    ELSE
        PRINT "Error!", CRLF$, FileIn$, CRLF$, WarnMsg$
    END IF
    CALL FREEGLOBALS
    END = 1
END SUB ' Abort



SUB BumpDown(szErr$)
    '********************************************************
    ' Decreases the indentation level by 2 spaces and aborts
    ' with an error message if indentation goes below 0
    '********************************************************
    DECR Indent, 2
    IF Indent < 0 THEN
        IF ISNULL(szErr$) THEN
            CALL Abort("Unknown Error")
        ELSE
            CALL Abort(szErr$)
        END IF
    END IF
    Scoot$ = SPACE$(Indent)
END SUB ' BumpDown


SUB BumpUp
    '********************************************************
    ' Increases the indentation level by 2 spaces,
    ' resetting it to 0 if it was negative
    '********************************************************
    IF Indent < 0 THEN Indent = 0
    INCR Indent, 2
    Scoot$ = SPACE$(Indent)
END SUB ' BumpUp



FUNCTION BracketHandler  (Source$, l)   AS PCHAR  ' Warning!  This is a recursive function
    '**************************************************************************************
    ' This function recursively processes Source$ (a string argument) to handle nested
    ' brackets and parentheses. It differentiates between double quotes, angle brackets
    ' <> and parentheses (). The function replaces commas within angle brackets
    ' with a placeholder and ultimately replaces the placeholder with "][".
    '**************************************************************************************
    DIM RAW s AS PCHAR
    s = Source$

    SELECT CASE l
        CASE 0
        DO
            IF *s = 0 THEN EXIT DO
            IF *s = c_DblQt THEN
                INCR s
                DO WHILE *s <> c_DblQt
                    IF *s = 0 THEN EXIT DO
                    INCR s
                LOOP
            END IF

            IF *s = c_LtBkt THEN
                INCR s
                s = BracketHandler(s, 1)
            END IF
            IF *s = c_LPar THEN
                INCR s
                s = BracketHandler(s, 2)
            END IF
            INCR s
        LOOP

        CASE 1
        DO WHILE *s <> c_RtBkt
            IF *s = c_DblQt THEN
                INCR s
                DO WHILE *s <> c_DblQt
                    IF *s = 0 THEN EXIT DO
                    INCR s
                LOOP
            END IF

            IF *s = c_LtBkt THEN
                INCR s
                s = BracketHandler(s, 1)
            END IF

            IF *s = c_LPar THEN
                INCR s
                s = BracketHandler(s, 2)
            END IF
            IF *s = 0 THEN EXIT DO
            IF *s = c_Comma THEN *s = 1
            INCR s
        LOOP

        CASE 2
        DO WHILE *s <> c_RPar
            IF *s = c_DblQt THEN
                INCR s
                DO WHILE *s <> c_DblQt
                    IF *s = 0 THEN EXIT DO
                    INCR s
                LOOP
            END IF

            IF *s = c_LtBkt THEN
                INCR s
                s = BracketHandler(s, 1)
            END IF

            IF *s = c_LPar THEN
                INCR s
                s = BracketHandler(s, 2)
            END IF
            IF *s = 0 THEN EXIT DO
            INCR s
        LOOP
    END SELECT

    IF l = 0 THEN
        REPLACE CHR$(1) WITH "][" IN Source$
        RETURN Source$
    END IF

    RETURN s
END FUNCTION ' BracketHandler



SUB PushSelectState(SelState$)
    '**************************************************************************************
    ' This SUB increments the state index and saves the current SELECT state (SelState$)
    ' onto a stack (SelectState). If the maximum number of nested SELECT/END SELECT blocks
    ' is reached, it aborts the process with an error message.
    '**************************************************************************************
    INCR StateIdx
    IF cMaxNestedSelects = StateIdx THEN
        CALL Abort("Maximum nested SELECT/END SELECT reached.")
    END IF
    SelectState[StateIdx].CaseStk$= SelState$
END SUB ' PushSelectState




SUB PopSelectState(SelState$)
    '***************************************************************************
    ' This SUB decrements the state index and retrieves the most recently
    ' saved SELECT state from the stack (SelectState), storing it in SelState$.
    '***************************************************************************
    SelState$ = SelectState[--StateIdx].CaseStk$
END SUB ' PopSelectState



SUB Emit_Epilog
    IF Use_Wingui + MakeDLL + NoMain + EndOfProgram = 0 THEN
        IF Use_Sound THEN
            FPRINT FP_WRITE, Scoot$, "midiOutClose (hMidi);"  ' Added by MrBcx 825
        END IF
        FPRINT FP_WRITE, "return EXIT_SUCCESS;   // End of main program"
        FPRINT FP_WRITE, "}"
        FLUSH(FP_WRITE)
    END IF
END SUB ' Emit_Epilog



SUB Emit_Prolog(FP_OUTPUT AS FILE)
    FPRINT FP_OUTPUT, "// *************************************************"
    FPRINT FP_OUTPUT, "//      Made with BCX BASIC To C/C++ Translator"
    FPRINT FP_OUTPUT, "//            Version ", VERSION$
    FPRINT FP_OUTPUT, "// *************************************************"
    FPRINT FP_OUTPUT, "//    Translated for compiling with a ";

    IF UseCpp THEN
        FPRINT FP_OUTPUT, "C++ Compiler"
    ELSE
        FPRINT FP_OUTPUT, "C Compiler"
    END IF

    FPRINT FP_OUTPUT, "// *************************************************"

    IF UseCpp THEN
        FPRINT FP_OUTPUT, ""
        FPRINT FP_OUTPUT, "#ifndef __cplusplus"
        FPRINT FP_OUTPUT, "  #error A C++ compiler is required"
        FPRINT FP_OUTPUT, "#endif"
        FPRINT FP_OUTPUT, ""
    END IF

    IF NO_MSVC = FALSE THEN
        FPRINT FP_OUTPUT, "#ifdef _MSC_VER"
        FPRINT FP_OUTPUT, "  #ifndef _CRT_SECURE_NO_WARNINGS"
        FPRINT FP_OUTPUT, "    #define _CRT_SECURE_NO_WARNINGS"
        FPRINT FP_OUTPUT, "  #endif"
        FPRINT FP_OUTPUT, "#endif"
    END IF

    IF Use_LeanAndMean = TRUE THEN
        FPRINT FP_OUTPUT, "#define  WIN32_LEAN_AND_MEAN"
    END IF

    IF Use_MULTITHREADED_SW THEN
        FPRINT FP_OUTPUT, "#define __BCX_MULTITHREADED__"
    END IF

    IF Use_COM OR Use_VBS THEN
        FPRINT FP_OUTPUT, ""
        FPRINT FP_OUTPUT, "#ifndef _WIN32_DCOM"
        FPRINT FP_OUTPUT, "  #define _WIN32_DCOM"
        FPRINT FP_OUTPUT, "#endif"
    END IF

    IF Use_UNICODE THEN
        ' this should be emitted before any other windows header
        FPRINT FP_OUTPUT, ""
        FPRINT FP_OUTPUT, "#ifndef UNICODE"
        FPRINT FP_OUTPUT, "  #define UNICODE   // used by Windows headers"
        FPRINT FP_OUTPUT, "#endif"
        FPRINT FP_OUTPUT, ""
        FPRINT FP_OUTPUT, "#ifndef _UNICODE"
        FPRINT FP_OUTPUT, "  #define _UNICODE  // used by CRT headers"
        FPRINT FP_OUTPUT, "#endif"
        FPRINT FP_OUTPUT, ""
    END IF

    IF UseCpp AND UseCpphdr THEN
        FPRINT FP_OUTPUT, ""
        FPRINT FP_OUTPUT, "#if defined(__cplusplus)"
        IF UseIO THEN
            FPRINT FP_OUTPUT, "  #include <iostream>"
        END IF
        FPRINT FP_OUTPUT, "  #include <fstream>"
        FPRINT FP_OUTPUT, "  #include <sstream>"
        FPRINT FP_OUTPUT, "  #include <iomanip>"
        FPRINT FP_OUTPUT, "  typedef std::string stdstr;"
        FPRINT FP_OUTPUT, "#endif"
        FPRINT FP_OUTPUT, ""
    END IF

    IF LOF(defFile$) > 7 THEN            ' Q. Why 7? ... A. "#define"
        OPEN defFile$ FOR INPUT AS FP99
        DO WHILE NOT EOF(FP99)
            LINE INPUT FP99, Src$
            FPRINT FP_OUTPUT, Src$
        LOOP
        CLOSE FP99
        FPRINT FP_OUTPUT, ""
    END IF

    IF ZapFlag = FALSE THEN

        IF WinHeaders = TRUE OR Use_Project = TRUE THEN
            FPRINT FP_OUTPUT, ""
            FPRINT FP_OUTPUT, "// Windows API headers"
            FPRINT FP_OUTPUT, "#include <windows.h>    // Core Windows API"
            FPRINT FP_OUTPUT, "#include <windowsx.h>   // Windows API macros and functions"
            FPRINT FP_OUTPUT, "#include <commctrl.h>   // Common Controls"
            FPRINT FP_OUTPUT, "#include <commdlg.h>    // Common Dialogs"
            FPRINT FP_OUTPUT, "#include <direct.h>     // Directory handling"
            FPRINT FP_OUTPUT, "#include <locale.h>     // Locale handling"
            FPRINT FP_OUTPUT, "#include <mmsystem.h>   // Multimedia"
            FPRINT FP_OUTPUT, "#include <oaidl.h>      // OLE Automation"
            FPRINT FP_OUTPUT, "#include <objbase.h>    // Component Object Model (COM)"
            FPRINT FP_OUTPUT, "#include <ocidl.h>      // OLE Control interfaces"
            FPRINT FP_OUTPUT, "#include <ole2.h>       // OLE 2.0 functionality"
            FPRINT FP_OUTPUT, "#include <oleauto.h>    // OLE Automation"
            FPRINT FP_OUTPUT, "#include <olectl.h>     // OLE Controls"
            FPRINT FP_OUTPUT, "#include <richedit.h>   // Rich Edit Control"
            FPRINT FP_OUTPUT, "#include <shellapi.h>   // Shell API"
            FPRINT FP_OUTPUT, "#include <shlobj.h>     // Shell Objects"
            FPRINT FP_OUTPUT, "#include <urlmon.h>     // URL Monikers"
            FPRINT FP_OUTPUT, "#include <wchar.h>      // Wide character support (also in ISO C)"
            FPRINT FP_OUTPUT, "#include <wctype.h>     // Wide character classification (also in ISO C)"
            FPRINT FP_OUTPUT, "#include <tchar.h>      // Unicode/ANSI character mapping"
            FPRINT FP_OUTPUT, "#include <unknwn.h>     // COM base interfaces"
            FPRINT FP_OUTPUT, "#include <wingdi.h>     // GDI"
            FPRINT FP_OUTPUT, "#include <wininet.h>    // Internet"
            FPRINT FP_OUTPUT, "#include <winsock.h>    // Windows Sockets"
            FPRINT FP_OUTPUT, "#include <winuser.h>    // User Interface"
            FPRINT FP_OUTPUT, ""
        END IF

        FPRINT FP_OUTPUT, "// ISO C Standard Library headers"
        FPRINT FP_OUTPUT, "#include <ctype.h>      // Character classification"
        FPRINT FP_OUTPUT, "#include <math.h>       // Mathematical functions"
        FPRINT FP_OUTPUT, "#include <setjmp.h>     // Non-local jumps"
        FPRINT FP_OUTPUT, "#include <stdarg.h>     // Variable arguments"
        FPRINT FP_OUTPUT, "#include <stddef.h>     // Common definitions"
        FPRINT FP_OUTPUT, "#include <stdio.h>      // Input/output"
        FPRINT FP_OUTPUT, "#include <stdlib.h>     // General utilities"
        FPRINT FP_OUTPUT, "#include <string.h>     // String handling"
        FPRINT FP_OUTPUT, "#include <time.h>       // Date and time"
        FPRINT FP_OUTPUT, "#include <errno.h>      // Error numbers (also POSIX)"
        FPRINT FP_OUTPUT, ""
        FPRINT FP_OUTPUT, "// C99 Standard headers"
        FPRINT FP_OUTPUT, "#include <stdbool.h>    // Boolean type"
        FPRINT FP_OUTPUT, "#include <inttypes.h>   // Integer types"
        FPRINT FP_OUTPUT, ""
        FPRINT FP_OUTPUT, "// POSIX headers"
        FPRINT FP_OUTPUT, "#include <fcntl.h>      // File control options"
        FPRINT FP_OUTPUT, ""
        FPRINT FP_OUTPUT, "// Windows-specific headers"
        FPRINT FP_OUTPUT, "#include <process.h>    // Process control functions"
        FPRINT FP_OUTPUT, "#include <io.h>         // Low-level I/O (Windows POSIX subset)"
        FPRINT FP_OUTPUT, "#include <conio.h>      // Console I/O (Windows-specific)"
    END IF
    FPRINT FP_OUTPUT, ""
END SUB ' Emit_Prolog



SUB Commandline_Defines(FP_OUTPUT AS FILE)
    '****************************************************************************************
    ' This SUB outputs commandline #defines to a given file (FP_OUTPUT).  If CmdLineConst$
    ' is not empty, it writes header and footer comments to the file, then processes each
    ' command line constant, converting them into MACRO definitions and directing the
    ' output to the specified file. It temporarily changes the file pointer for this output.
    '****************************************************************************************
    IF CmdLineConst$ <> "" THEN
        DIM RAW Ftmp AS FILE
        DIM RAW LTmp1$

        FPRINT FP_OUTPUT, ""
        FPRINT FP_OUTPUT, "// ***************************************************"
        FPRINT FP_OUTPUT, "//                 Command line Defines"
        FPRINT FP_OUTPUT, "// ***************************************************"
        FPRINT FP_OUTPUT, ""

        Ftmp   = FP_CST     ' Save FILE Ptr to SourceFile
        FP_CST = FP_OUTPUT   ' Direct output to HeaderFile

        FOR INT i = 1 TO TALLY(CmdLineConst$, CHR$(1))
            LTmp1$ = STRTOKEN$(CmdLineConst$, CHR$(1), i)
            IF ISNULL(LTmp1$) THEN EXIT FOR
            LTmp1$ = "MACRO " + LTmp1$ ' CmdLineConst$
            Inject(LTmp1$)
        NEXT

        FP_CST = Ftmp    ' Restore Ptr to SourceFile

        FPRINT FP_OUTPUT, ""
        FPRINT FP_OUTPUT, "// ***************************************************"
        FPRINT FP_OUTPUT, "//              End of Command Line Defines"
        FPRINT FP_OUTPUT, "// ***************************************************"
        FPRINT FP_OUTPUT, ""
    END IF
END SUB ' Commandline_Defines



SUB Emit_UserDirectives(FP_OUTPUT AS FILE)
    '*********************************************************************************
    ' This SUB outputs user-specified directives from a file (hdrFile$) to a
    ' given file stream (FP_OUTPUT). If the header file exists, it opens it for
    ' input, reads each line, writes it to the output file, then closes the file.
    '*********************************************************************************
    IF EXIST(hdrFile$) THEN
        DIM RAW LTmp1$
        DIM RAW LFP1 AS FILE
        OPEN hdrFile$ FOR INPUT AS LFP1     ' user specified .h directives
        DO WHILE NOT EOF(LFP1)
            LINE INPUT LFP1, LTmp1$
            FPRINT FP_OUTPUT, LTmp1$
        LOOP
        CLOSE LFP1
    END IF
END SUB ' Emit_UserDirectives



SUB User_Global_Enum_Blocks(FP_OUTPUT AS FILE)
    '*****************************************************************************************
    ' This SUB processes user-defined global enumerations stored inside (enuFile$) and writes
    ' them to a given file stream (FP_OUTPUT). If the enumeration file exists and has a size
    ' greater than 2 bytes, it opens the file, reads each line, and writes it to the output
    ' file. It then closes the enumeration file.
    '*****************************************************************************************
    DIM RAW LTmp1$
    DIM RAW LFP1 AS FILE

    IF EXIST(enuFile$) AND LOF(enuFile$) > 2 THEN
        FPRINT FP_OUTPUT, ""
        FPRINT FP_OUTPUT, "// *************************************************"
        FPRINT FP_OUTPUT, "//           User's GLOBAL Enumerations"
        FPRINT FP_OUTPUT, "// *************************************************"
        OPEN enuFile$ FOR INPUT AS LFP1      ' user's GLOBAL enum blocks
        DO WHILE NOT EOF(LFP1)
            LINE INPUT LFP1, LTmp1$
            FPRINT FP_OUTPUT, LTmp1$
        LOOP
        CLOSE LFP1
    END IF
END SUB ' User_Global_Enum_Blocks



SUB System_Defined_Constants(FP_OUTPUT AS FILE)
    '*********************************************************************************
    ' This SUB processes system-defined macros stored inside the file (SysFile$) and
    ' writes them to a given file stream (FP_OUTPUT). If the system file exists and has
    ' a size greater than 2 bytes, it opens the file, reads each line, trims leading
    ' and trailing whitespace, and writes non-empty lines to the output file.
    '*********************************************************************************
    DIM RAW LTmp1$
    DIM RAW LFP1 AS FILE

    IF EXIST(SysFile$) AND LOF(SysFile$) > 2 THEN
        FPRINT FP_OUTPUT, ""
        FPRINT FP_OUTPUT, "// *************************************************"
        FPRINT FP_OUTPUT, "//            System Defined Macros"
        FPRINT FP_OUTPUT, "// *************************************************"
        FPRINT FP_OUTPUT, ""
        OPEN SysFile$ FOR INPUT AS LFP1     ' SysFile$    ' System translated CONSTants
        DO WHILE NOT EOF(LFP1)
            LINE INPUT LFP1, LTmp1$
            LTmp1$ = TRIM$(LTmp1$)
            IF LTmp1$ > "" THEN FPRINT FP_OUTPUT, LTmp1$
        LOOP
        CLOSE LFP1
    END IF
END SUB ' System_Defined_Constants



SUB User_Defined_Constants(FP_OUTPUT AS FILE)
    '***************************************************************************************
    ' This SUB processes user-defined macros stored in the file (UsrFile$) and writes them
    ' to a given file stream (FP_OUTPUT). If the user file exists and has a size greater than
    ' 2 bytes, it opens the file, reads each line, trims leading whitespace, and writes the
    ' lines to the output file. It then closes the user file.
    '***************************************************************************************
    DIM RAW LTmp1$
    DIM RAW LFP1 AS FILE

    IF EXIST(UsrFile$) AND LOF(UsrFile$)>2 THEN
        FPRINT FP_OUTPUT, ""
        FPRINT FP_OUTPUT, "// *************************************************"
        FPRINT FP_OUTPUT, "//             User Defined Macros"
        FPRINT FP_OUTPUT, "// *************************************************"
        FPRINT FP_OUTPUT, ""
        OPEN UsrFile$ FOR INPUT AS LFP1     ' UsrConstFile$      ' user translated CONSTants
        DO WHILE NOT EOF(LFP1)
            LINE INPUT LFP1, LTmp1$
            FPRINT FP_OUTPUT, LTRIM$(LTmp1$)
        LOOP
        CLOSE LFP1
    END IF
END SUB ' User_Defined_Constants



SUB User_Defined_Types_And_Unions(FP_OUTPUT AS FILE)
    '**************************************************************************
    ' This SUB processes UDTs and unions stored inside file (udtFile$) and
    ' writes them to a given file stream (FP_OUTPUT). If the UDT file exists
    ' and has a size greater than 2 bytes, it opens the file, reads each line,
    ' and writes it to the output file. It then closes the UDT file.
    '**************************************************************************
    DIM RAW LTmp1$
    DIM RAW LFP1 AS FILE

    IF EXIST(udtFile$) AND LOF(udtFile$) > 2 THEN
        FPRINT FP_OUTPUT, ""
        FPRINT FP_OUTPUT, "// *************************************************"
        FPRINT FP_OUTPUT, "//          User Defined Types And Unions"
        FPRINT FP_OUTPUT, "// *************************************************"

        OPEN udtFile$ FOR INPUT AS LFP1       '  translated User Defined Types
        DO WHILE NOT EOF(LFP1)
            LINE INPUT LFP1, LTmp1$
            FPRINT FP_OUTPUT, LTmp1$
        LOOP
        CLOSE LFP1
    END IF
END SUB ' User_Defined_Types_And_Unions







SUB User_Data_Statements(FP_OUTPUT AS FILE)
    '*********************************************************************************
    ' This SUB processes user-defined data statements stored in file (datFile$) and
    ' writes them to a given file stream (FP_OUTPUT) as a C-style array of strings.
    ' If the data file exists and has a size greater than 0 bytes, it opens the file,
    ' reads each line, constructs the array in the output file, then closes the file.
    '*********************************************************************************
    DIM RAW LTmp1$
    DIM RAW LFP1 AS FILE
    '********************************
    ' Read In The Data Statement File
    '********************************
    IF LOF(datFile$) > 0 THEN
        OPEN datFile$ FOR INPUT AS LFP1
        FPRINT FP_OUTPUT, ""
        FPRINT FP_OUTPUT, "// *************************************************"
        FPRINT FP_OUTPUT, "//              User's Data Statements"
        FPRINT FP_OUTPUT, "// *************************************************"
        FPRINT FP_OUTPUT, ""
        FPRINT FP_OUTPUT, "char * DATA[] ="
        FPRINT FP_OUTPUT, "{"
        DO WHILE NOT EOF(LFP1)
            LINE INPUT LFP1, LTmp1$
            FPRINT FP_OUTPUT, LTmp1$; ' Suppress CRLF
            IF NOT EOF(LFP1) THEN FPRINT FP_OUTPUT, ","
        LOOP
        CLOSE LFP1
        FPRINT FP_OUTPUT, "\n};"
    END IF
END SUB ' User_Data_Statements



SUB BeginMain
    FPRINT FP_WRITE, "int main(int argc, char *argv[])"
    '*****************************************************************************
    '         int main is conditionally removed later IN SUB AssembleParts
    '*****************************************************************************
    FLUSH (FP_WRITE)
END SUB ' BeginMain



SUB User_Global_Variables(FP_OUTPUT AS FILE)
    '***********************************************************************************
    ' This SUB declares user-defined global variables and arrays stored in various data
    ' structures. It writes them to file stream (FP_OUTPUT) with proper formatting based
    ' on their attributes such as type, storage class, dimensionality, and directives.
    '***********************************************************************************
    DIM RAW i, VarName$, Storage$, VarDim$, A, P$

    IF GlobalVarCnt OR DllCnt THEN
        FPRINT FP_W, ""
        FPRINT FP_W, "// *************************************************"
        FPRINT FP_W, "//            ", BCX_STR_USR_VARS$
        FPRINT FP_W, "// *************************************************"
        FPRINT FP_W, ""
    END IF

    '*************************************
    ' Declare the DLL Variables
    '*************************************

    IF DllCnt THEN
        FOR INT iii = 1 TO DllCnt
            FPRINT FP_W, "static BCXFPROT", LTRIM$(STR$(iii)), SPC$, EXTRACT$(DllDecl$[iii], "="), ";"
        NEXT
    END IF

    '*************************************
    ' Declare the simple Variables
    '*************************************

    FOR i = 1 TO GlobalVarCnt
        IF GlobalVars[i].VarEmitFlag THEN ITERATE
        IF "" = GlobalVars[i].VarDim$ AND GlobalVars[i].VarCondLevel = 0 THEN
            P$ = ""
            IF GlobalVars[i].VarPntr THEN P$ = STRING$(GlobalVars[i].VarPntr, 42)
            A = GlobalVars[i].VarType
            IF GlobalVars[i].VarSF THEN
                VarName$ = "(*" + GlobalVars[i].VarName$ + ")"
            ELSE
                VarName$ = GlobalVars[i].VarName$
            END IF
            Storage$ = VarStorage$[GlobalVars[i].VarExtn] + VarConst$[GlobalVars[i].VarConstant]
            VarDim$ = GlobalVars[i].VarDim$
            CALL PrintGlobal(FP_OUTPUT, A, i, Storage$, P$, VarName$, VarDim$)
        END IF
    NEXT

    '   Next, we declare the Arrays

    FOR i = 1 TO GlobalVarCnt
        IF GlobalVars[i].VarEmitFlag THEN ITERATE
        IF "" <> GlobalVars[i].VarDim$ AND GlobalVars[i].VarCondLevel = 0 THEN
            IF INCHR(GlobalVars[i].VarDim, "{") = 0 THEN     ' do uninitialized global arrays
                P$ = ""
                IF GlobalVars[i].VarPntr THEN P$ = STRING$(GlobalVars[i].VarPntr, 42)
                A = GlobalVars[i].VarType
                IF GlobalVars[i].VarSF THEN
                    VarName$ = "(*" + GlobalVars[i].VarName$ + EXTRACT$(GlobalVars[i].VarDim, "(") + ")"
                    VarDim$ = MID$(GlobalVars[i].VarDim, INCHR(GlobalVars[i].VarDim, "("))
                ELSE
                    VarName$ = GlobalVars[i].VarName$
                    VarDim$ = GlobalVars[i].VarDim$
                END IF
                Storage$ = VarStorage$[GlobalVars[i].VarExtn] + VarConst$[GlobalVars[i].VarConstant]
                CALL PrintGlobal(FP_OUTPUT, A, i, Storage$, P$, VarName$, VarDim$)
            END IF
        END IF
    NEXT

    DIM RAW LastDef$  = ""
    DIM RAW LastLevel = 1

    FOR i = 1 TO GlobalVarCnt
        IF GlobalVars[i].VarEmitFlag THEN ITERATE
        IF GlobalVars[i].VarCondLevel THEN
            IF ISNULL(LastDef$) THEN
                LastDef$ = GlobalVars[i].VarCondDef$
                LastLevel = GlobalVars[i].VarCondLevel
                FPRINT FP_OUTPUT, LastDef$
            END IF
            IF LastDef$ <> GlobalVars[i].VarCondDef$ THEN
                IF GlobalVars[i].VarCondDef$ = "#else" THEN
                    DO WHILE LastLevel > GlobalVars[i].VarCondLevel
                        FPRINT FP_OUTPUT, "#endif"
                        DECR LastLevel
                    LOOP
                    FPRINT FP_OUTPUT, "#else"
                    LastDef$ = GlobalVars[i].VarCondDef$
                ELSE
                    DO WHILE LastLevel => GlobalVars[i].VarCondLevel
                        FPRINT FP_OUTPUT, "#endif"
                        DECR LastLevel
                    LOOP
                    LastDef$ = GlobalVars[i].VarCondDef$
                    LastLevel = GlobalVars[i].VarCondLevel
                    FPRINT FP_OUTPUT, LastDef$
                END IF
            END IF
            P$ = ""
            IF GlobalVars[i].VarPntr THEN P$ = STRING$(GlobalVars[i].VarPntr, 42)
            A = GlobalVars[i].VarType
            IF GlobalVars[i].VarSF THEN
                VarName$ = "(*" + GlobalVars[i].VarName$ + ")"
            ELSE
                VarName$ = GlobalVars[i].VarName$
            END IF
            VarDim$ = GlobalVars[i].VarDim
            Storage$ = VarStorage$[GlobalVars[i].VarExtn] + VarConst$[GlobalVars[i].VarConstant]
            CALL PrintGlobal(FP_OUTPUT, A, i, Storage$, P$, VarName$, VarDim$)

        END IF
    NEXT

    IF *LastDef$ THEN
        DO WHILE LastLevel
            FPRINT FP_OUTPUT, "#endif"
            DECR LastLevel
        LOOP
    END IF
END SUB ' User_Global_Variables



SUB System_Vars(FP_OUTPUT AS FILE)
    IF Use_Console       OR _
        Use_Findfirst    OR _
        Use_Findnext     OR _
        Use_GoSub        OR _
        Use_BcxTempStr   OR _
        Use_Ldouble      OR _
        Use_Crlf         OR _
        Use_Inputbox     OR _
        Use_Infobox      OR _
        Use_Inputbuffer  OR _
        Use_BCX_Splitter OR _
        Use_Dynacall     OR _
        Use_DynacallA    OR _
        Use_LCaseTbl     OR _
        Use_UCaseTbl     THEN

        FPRINT FP_OUTPUT, ""
        FPRINT FP_OUTPUT, "// *************************************************"
        FPRINT FP_OUTPUT, "//                " + BCX_STR_SYS_VARS$
        FPRINT FP_OUTPUT, "// *************************************************"
        FPRINT FP_OUTPUT, ""
    END IF


    IF Use_BCX_Splitter THEN
        FPRINT FP_OUTPUT, "static ULONG SplitBarFG=RGB(0,0,255);"
        FPRINT FP_OUTPUT, "static ULONG SplitBarBG=RGB(212,212,212);"
        FPRINT FP_OUTPUT, "#define SPLITBAR_SIZE 2"
        FPRINT FP_OUTPUT, "#define MIN_PANESIZE 4"
        FPRINT FP_OUTPUT, ""
        FPRINT FP_OUTPUT, "typedef struct _SPLITTERINFO{"
        FPRINT FP_OUTPUT, "  int   swsStyle;"
        FPRINT FP_OUTPUT, "  int   splittype;"
        FPRINT FP_OUTPUT, "  HCURSOR  hCursor;"
        FPRINT FP_OUTPUT, "  HWND  hwPane1;"
        FPRINT FP_OUTPUT, "  HWND  hwPane2;"
        FPRINT FP_OUTPUT, "  BOOL  fMovingBar;"
        FPRINT FP_OUTPUT, "  int   percent;"
        FPRINT FP_OUTPUT, "}SPLITTERINFO, *LPSPLITTERINFO;"
        FPRINT FP_OUTPUT, ""
    END IF

    IF Use_Ldouble THEN
        FPRINT FP_OUTPUT, "#define LDOUBLE long double"
    END IF

    IF Use_Idxqsort THEN
        FPRINT FP_OUTPUT, "char*** pppStr;"
    END IF

    IF Use_Idxqsort OR Use_IdxqsortSt OR Use_PtrqsortSt THEN
        FPRINT FP_OUTPUT, "int     Key;"
    END IF

    IF Use_IdxqsortSt THEN
        FPRINT FP_OUTPUT, "char*   cmp1;"
        FPRINT FP_OUTPUT, "int     StructSize;"
    END IF

    IF Use_PtrqsortSt THEN
        FPRINT FP_OUTPUT, "int     OffSet;"
    END IF

    IF Use_Sound THEN
        FPRINT FP_OUTPUT, ""
        FPRINT FP_OUTPUT, "#define SNDQUE 10000"
        FPRINT FP_OUTPUT, ""
        FPRINT FP_OUTPUT, "typedef struct _soundtype {"
        FPRINT FP_OUTPUT, "  float  Freq;"
        FPRINT FP_OUTPUT, "  int    Dura;"
        FPRINT FP_OUTPUT, "  int    Vol;"
        FPRINT FP_OUTPUT, "  int    Voice;"
        FPRINT FP_OUTPUT, "  float  Tempo;"
        FPRINT FP_OUTPUT, "  int    sndTid;"
        FPRINT FP_OUTPUT, "} soundtype, *LPSOUNDTYPE;"
        FPRINT FP_OUTPUT, ""
        FPRINT FP_OUTPUT, "static soundtype  SndPmtr[SNDQUE+1];"
        FPRINT FP_OUTPUT, "static UINT       gTenter;"
        FPRINT FP_OUTPUT, "static UINT       gTwait;"
        FPRINT FP_OUTPUT, "static UINT       gTexit;"
        FPRINT FP_OUTPUT, "static UINT       gTarray;"
        FPRINT FP_OUTPUT, "static BOOL       gTsig;"
        FPRINT FP_OUTPUT, "static HANDLE     gSThread=NULL;"
        FPRINT FP_OUTPUT, "static HMIDIOUT   hMidi;"
        FPRINT FP_OUTPUT, ""
    END IF

    IF Use_BCX_Fontdlg THEN
        FPRINT FP_OUTPUT, ""
        FPRINT FP_OUTPUT, "typedef struct _BCX_FONT_TYPE {"
        FPRINT FP_OUTPUT, "  LOGFONT lf;"
        FPRINT FP_OUTPUT, "  int  SIZE;"
        FPRINT FP_OUTPUT, "  int  RGB;"
        FPRINT FP_OUTPUT, "} BCX_FONT_TYPE;"
        FPRINT FP_OUTPUT, ""
        FPRINT FP_OUTPUT, "BCX_FONT_TYPE BCX_FONT;"
        FPRINT FP_OUTPUT, ""
    END IF

    '************************************************************************

    IF Use_NUL THEN
        FPRINT FP_OUTPUT, "static char    NUL [1]={0};       // Null"
    END IF

    IF Use_BEL THEN
        FPRINT FP_OUTPUT, "static char    BEL [2]={7,0};     // Bell"
    END IF

    IF Use_BS THEN
        FPRINT FP_OUTPUT, "static char    BS  [2]={8,0};     // Back Space"
    END IF

    IF Use_TAB THEN
        FPRINT FP_OUTPUT, "static char    TAB [2]={9,0};     // Horz Tab"
    END IF

    IF Use_LF THEN
        FPRINT FP_OUTPUT, "static char    LF  [2]={10,0};    // Line Feed"
    END IF

    IF Use_VT THEN
        FPRINT FP_OUTPUT, "static char    VT  [2]={11,0};    // Vert Tab"
    END IF

    IF Use_FF THEN
        FPRINT FP_OUTPUT, "static char    FF  [2]={12,0};    // Form Feed"
    END IF

    IF Use_CR THEN
        FPRINT FP_OUTPUT, "static char    CR  [2]={13,0};    // Carr Rtn"
    END IF

    IF Use_EF THEN
        FPRINT FP_OUTPUT, "static char    EF  [2]={26,0};    // End-of-File"
    END IF

    IF Use_ESC THEN
        FPRINT FP_OUTPUT, "static char    ESC [2]={27,0};    // Escape"
    END IF

    IF Use_SPC THEN
        FPRINT FP_OUTPUT, "static char    SPC [2]={32,0};    // Space"
    END IF

    IF Use_DQ THEN
        FPRINT FP_OUTPUT, "static char    DQ  [2]={34,0};    // Double-Quote"
    END IF

    IF Use_DDQ THEN
        FPRINT FP_OUTPUT, "static char    DDQ [3]={34,34,0}; // Double-Double-Quote"
    END IF

    IF Use_Crlf THEN
        FPRINT FP_OUTPUT, "static char    CRLF[3]={13,10,0}; // Carr Rtn & Line Feed"
    END IF

    '****************************************************************************

    IF Use_Inputbox THEN
        FPRINT FP_OUTPUT, "char   BCX_INPUTBOX_VAL[BCXSTRSIZE];"
    END IF

    IF Use_Cursor THEN
        FPRINT FP_OUTPUT, "static COORD   cursor;             // holds coordinates of cursor"
    END IF

    IF Use_Console THEN
        FPRINT FP_OUTPUT, "static HANDLE  hConsole;           // handle of console window"
    END IF

    IF Use_Cls OR Use_Color THEN
        FPRINT FP_OUTPUT, "static int     color_fg = 7;       // forground color set to default"
        FPRINT FP_OUTPUT, "static int     color_bg = 0;       // background color set to default"
    END IF

    IF Use_Consolesize THEN
        FPRINT FP_OUTPUT, "static int     BcxSaveConX;"
        FPRINT FP_OUTPUT, "static int     BcxSaveConY;"
    END IF

    IF Use_PushPopColors THEN
        FPRINT FP_OUTPUT, "static int     color_pshpop;       // Push / Pop Color storage"
    END IF


    IF Use_Scan THEN
        FPRINT FP_OUTPUT, "static int     ScanError;          // holds last error from scan function"
    END IF


    IF Use_Inputbuffer THEN
        FPRINT FP_OUTPUT, "static char    InputBuffer[1048577];"   ' 1MB + 1 byte
    END IF


    IF Use_Hook THEN
        FPRINT FP_OUTPUT, "static HHOOK   CmDlgHook;"
    END IF


    IF Use_GoSub THEN
        FPRINT FP_OUTPUT, "static jmp_buf GosubStack[32];"
        FPRINT FP_OUTPUT, "static int     GosubNdx;"
    END IF


    IF Use_LCaseTbl THEN
        FPRINT FP_OUTPUT, "static unsigned char*  LowCase;"
    END IF

    IF Use_UCaseTbl THEN
        FPRINT FP_OUTPUT, "static unsigned char*  UprCase;"
    END IF

    IF Use_Findfirst OR Use_Findnext THEN
        FPRINT FP_OUTPUT, "static HANDLE  fffn_FileHandle;"
        FPRINT FP_OUTPUT, "static WIN32_FIND_DATA fffn_FindData;"
    END IF

    IF Use_DynacallCommon THEN
        FPRINT FP_OUTPUT, "static  HINSTANCE BCX_DllStore[256];"
    END IF

    FPRINT FP_OUTPUT, ""
END SUB ' System_Vars



SUB PreParse(Arg$)
    '********************************************
    ' Stk$[) AND Ndx must be declared GLOBAL
    ' and are re-initialized WITH each invocation
    '*********************************************
    DIM RAW Anyword$ = ""
    DIM RAW szChar$  = ""
    DIM RAW Strlit$  = ""
    DIM RAW Arglen  AS INTEGER
    DIM RAW Counter AS INTEGER
    DIM RAW TT      AS INTEGER
    DIM RAW Tmp     AS INTEGER
    DIM RAW A       AS INTEGER
    DIM RAW j       AS INTEGER

    Ndx = 0
    Arg$ = LTRIM$(Arg$)
    IF ISNULL(Arg$) THEN
        Ndx = 0
        EXIT SUB
    END IF
    '********************
    FOR Tmp = 0 TO 31
        Stk$[Tmp] = ""
    NEXT
    '********************
    Arglen = LEN(Arg$)
    Counter = 0

    DO WHILE Counter <= Arglen

        IF Ndx => cMaxStk THEN
            CALL Abort("Overflowed Parse Stack")
        END IF

        INCR Counter
        szChar[0] = Arg[Counter-1]              ' This eliminates using MID$
        szChar[1] = 0                           ' Remember to null terminate

        TT = ASC(szChar$)
        '***************************************
        SELECT CASE TT
            '***************************************
            CASE c_DblQt   ' Identify string literals
            '***************************************
            Strlit$ = szChar$
            szChar$ = ""
            DO
                IF szChar$ = DQ$ THEN EXIT DO
                INCR Counter
                IF Counter = Arglen THEN
                    szChar[0] = Arg[Counter-1]        ' This eliminates using MID$
                    szChar[1] = 0                     ' Remember to null terminate
                    Strlit$ += szChar$
                    EXIT DO
                END IF
                szChar[0] = Arg[Counter-1]           ' This eliminates using MID$
                szChar[1] = 0                        ' Remember to null terminate
                Strlit$ += szChar$
            LOOP
            INCR Ndx
            Stk$[Ndx] = Strlit$
            '***************
            CASE 32 ' SPACE
            '***************
            IF *Anyword$ THEN
                INCR Ndx
                Stk$[Ndx] = Anyword$
                Anyword$ = ""
            END IF
            '***************************************************************************
            ' =   &  (   )   [   ]   '   ,   +   -   *   /   ?   <   >   ;   |    :   ^
            CASE 61, 38, 40, 41, 91, 93, 39, 44, 43, 45, 42, 47, 63, 60, 62, 59, 124, 58, 94
            '****************************************************************************
            IF *Anyword$ THEN
                INCR Ndx
                Stk$[Ndx] = Anyword$
                Anyword$  = ""
            END IF
            INCR Ndx
            Stk$[Ndx]= szChar$
            '*****************
            CASE ELSE
            '*****************
            A = LEN(Anyword$)
            Anyword[A]   = Arg[Counter-1]
            Anyword[A+1] = 0
            '*****************
        END SELECT
        '*****************
    LOOP
    IF *Anyword$ THEN
        INCR Ndx
        Stk$[Ndx]= Anyword$
    END IF
    FOR j = 1 TO Ndx
        Anyword$ = LCASE$(Stk$[j])
        SELECT CASE Anyword$
            CASE "bor"
            Stk$[j] = "|"
            CASE "band"
            Stk$[j] = "&"
        END SELECT
    NEXT
END SUB ' PreParse



FUNCTION GetNumArgs (Strt, NdxPos AS INTEGER PTR = NULL)
    DIM RAW CountR = 0  ' () counter
    DIM RAW CountS = 0  ' [] counter
    DIM RAW i           ' loop counter
    DIM RAW j = 0       ' comma counter
    DIM RAW k = 1       ' function end flag

    FOR i = Strt TO Ndx
        SELECT CASE *Stk$[i]

            CASE ASC("(")
            INCR CountR
            INCR k

            CASE ASC(")")
            DECR CountR
            DECR k
            IF k = 0 THEN EXIT SELECT, FOR

            CASE ASC("[")
            INCR CountS

            CASE ASC("]")
            DECR CountS

            CASE ASC(",")
            IF CountR = 0 AND CountS = 0 THEN
                INCR j
                IF NdxPos THEN *NdxPos = i
            END IF

        END SELECT
    NEXT
    RETURN j   ' No. of commas = No. of args
END FUNCTION ' GetNumArgs



SUB GetVarCode(varcode AS VARCODE PTR, szWhere AS PCHAR)
    UNREFERENCED_PARAMETER(szWhere)
    DIM RAW CB$, PT$, PTH$, VAR$, vn, RF$, bRemoveSplat AS BOOL

    IF varcode->Methd% = mt_ConsDesNoParam OR varcode->Methd% = mt_FuncSubDecC_DecNoParam OR varcode->Methd% = mt_OverLoadNoParam THEN
        varcode->Proto$ += varcode->Token$
        varcode->Header$ += varcode->Token$
        EXIT SUB
    END IF

    IF varcode->Methd% = mt_OptsNoParam THEN
        varcode->Proto$ += varcode->Token$
        IF varcode->Token$ = "," OR InClass OR varcode->Token$ = "..." THEN
            varcode->Header$ += varcode->Token$
        END IF
        EXIT SUB
    END IF

    IF IsCallBack THEN
        CB$ = "CALLBACK "
    ELSE
        CB$ = ""
    END IF

    IF varcode->Methd = mt_ConsDesAParam THEN
        DIM RAW iSplat = INCHR(varcode->AsToken$, "*")
        DIM RAW iLT = INCHR(varcode->AsToken$, "<")
        DIM RAW iGT = INCHR(varcode->AsToken$, ">")
        IF iSplat > iLT AND iSplat < iGT THEN
            bRemoveSplat = FALSE
        ELSE
            bRemoveSplat =TRUE
        END IF
    ELSE
        bRemoveSplat = TRUE
    END IF

    IF ((INCHR(varcode->Token$, "*") OR INCHR(varcode->AsToken$, "*")) AND bRemoveSplat) OR varcode->IsPtrFlag THEN
        RemoveAll(varcode->Token$, "*")
        RemoveAll(varcode->AsToken$, "*")
        PT$  = STRING$(varcode->IsPtrFlag, ASC("*")) + SPC$
        PTH$ = PT$
    ELSE
        PTH$ = SPC$
        PT$ = ""
    END IF

    IF INCHR(varcode->Token$, "&") THEN
        RF$ = " &"
    ELSE
        RF$ = ""
    END IF

    vn = varcode->VarNo%
    VAR$ = GetVarTypeName$(vn)

    DIM RAW pszHead$
    DIM RAW pszProto$

    pszHead$ = Clean$(varcode->Token$)
    pszProto$ = pszHead$

    IF INCHR(pszProto$, "[") THEN
        pszProto$ = MID$(pszProto$, INCHR(pszProto$, "["))
    ELSE
        pszProto$ = ""
    END IF

    SELECT CASE vn
        '************************************************************************
        CASE vt_STRVAR
        '************************************************************************

        SELECT CASE varcode->Methd%

            CASE mt_ProcessSetCommand
            varcode->StaticOut$ = "static char   " + pszHead$

            CASE mt_FuncSubDecC_Dec
            varcode->Functype$ = "char * " + CB$

            CASE mt_FuncSubDecC_DecAParam
            IF NOT INCHR(varcode->Token$, "[") THEN
                varcode->Header$ = varcode->Header$  +  "char *" + pszHead$
                varcode->Proto$  = varcode->Proto$   +  "char *"
            ELSE
                varcode->Header$ = varcode->Header$  +  "char " + REMOVE$(pszHead$, "*")
                varcode->Proto$  = varcode->Proto$   +  "char[][BCXSTRSIZE]"
            END IF

            CASE mt_Opts
            varcode->Functype$ = "char *"

            CASE mt_ConsDesAParam
            varcode->Header$ = varcode->Header$  + "char *"  +  pszHead$
            varcode->Proto$  = varcode->Proto$   + "char *"  +  pszHead$

            CASE mt_OptsAParam
            varcode->Header$ = varcode->Header$  + "char *"  +  pszHead$
            varcode->Proto$  = varcode->Proto$   + "char *"

            CASE mt_OverLoad
            varcode->Functype$ = "char *"

            CASE mt_OverLoadAParam
            varcode->Header$ = varcode->Header$ + "char *" + pszHead$

        END SELECT

        '************************************************************************
        CASE vt_BOOL, vt_BYTE, vt_COLORREF, vt_DOUBLE, vt_DWORD, vt_FARPROC, vt_HDC, _
        vt_HANDLE, vt_HINSTANCE, vt_HWND, vt_HBITMAP, vt_INTEGER, vt_PCHAR, vt_LONG, vt_LPBYTE, vt_LRESULT, _
        vt_SHORT, vt_SINGLE, vt_UINT, vt_ULONG, vt_USHORT, vt_SAFEARRAY, vt_VARIANT, vt_VOID, vt_LDOUBLE, _
        vt_SSHORT, vt_SCHAR, vt_DWORD, vt_WORD, vt_WINBOOL, vt_BSTR
        '************************************************************************

        SELECT CASE varcode->Methd%

            CASE mt_ProcessSetCommand
            varcode->StaticOut$ = "static " + VAR$ + SPC$ + pszHead$

            CASE mt_FuncSubDecC_Dec
            varcode->Functype$ = VAR$ + PTH$ + CB$

            CASE mt_FuncSubDecC_DecAParam
            varcode->Header$ = varcode->Header$  +  VAR$ + PTH$ + pszHead$
            varcode->Proto$  = varcode->Proto$   +  VAR$ + RF$ + PT$

            CASE mt_Opts
            varcode->Functype$ = VAR$ + PTH$

            CASE mt_OptsAParam
            varcode->Header$ = varcode->Header$  +  VAR$ + PTH$ + pszHead$
            varcode->Proto$  = varcode->Proto$   +  VAR$ + RF$ + PT$

            CASE mt_ConsDesAParam
            varcode->Header$ = varcode->Header$  +  VAR$ + PTH$ + pszHead$
            varcode->Proto$  = varcode->Proto$   +  VAR$ + PTH$ + pszHead$

            CASE mt_OverLoad
            varcode->Functype$ = VAR$ + SPC$

            CASE mt_OverLoadAParam
            varcode->Header$ = varcode->Header$ + VAR$ + PTH$ + pszHead$

        END SELECT

        '************************************************************************
        CASE vt_FILEPTR
        '************************************************************************

        SELECT CASE varcode->Methd%

            CASE mt_FuncSubDecC_Dec
            varcode->Functype$ = VAR$ + PTH$ + CB$

            CASE mt_FuncSubDecC_DecAParam
            varcode->Header$ = varcode->Header$   +  VAR$ + PTH$ + pszHead$
            IF INCHR(varcode->Token$, "[") THEN
                varcode->Proto$  = varcode->Proto$ +  VAR$ + PT$ + SPC$ + pszHead$
            ELSE
                varcode->Proto$  = varcode->Proto$ +  VAR$ + PT$
            END IF

            CASE mt_Opts
            varcode->Functype$ = VAR$ + PTH$

            CASE mt_OptsAParam                     ' y
            varcode->Header$ = varcode->Header$  +  VAR$ + PTH$  +  pszHead$
            varcode->Proto$  = varcode->Proto$   +  VAR$ + PT$

            CASE mt_ConsDesAParam
            varcode->Header$ = varcode->Header$  +  VAR$ + PTH$  +  pszHead$
            varcode->Proto$  = varcode->Proto$   +  VAR$ + PTH$  +  pszHead$

            CASE mt_OverLoad
            varcode->Functype$ = VAR$ + SPC$

            CASE mt_OverLoadAParam
            varcode->Header$ = varcode->Header$ + VAR$ + PTH$ + pszHead$

        END SELECT

        '************************************************************************
        CASE vt_CHAR, vt_SCHAR
        '************************************************************************

        SELECT CASE varcode->Methd%

            CASE mt_FuncSubDecC_Dec
            varcode->Functype$ = VAR$ + PTH$ + CB$

            CASE mt_FuncSubDecC_DecAParam
            varcode->Header$ = varcode->Header$  +  VAR$ + PTH$ + pszHead$
            varcode->Proto$  = varcode->Proto$   +  VAR$ + PT$ + SPC$ + pszProto$

            CASE mt_Opts
            varcode->Functype$ = VAR$ + PTH$

            CASE mt_OptsAParam
            varcode->Header$ = varcode->Header$  +  VAR$ + PTH$  +  pszHead$
            varcode->Proto$  = varcode->Proto$   +  VAR$ + PT$ + SPC$ + pszProto$

            CASE mt_ConsDesAParam
            varcode->Header$ = varcode->Header$  +  VAR$ + PTH$  +  pszHead$
            varcode->Proto$  = varcode->Proto$   +  VAR$ + PTH$  + SPC$ + pszProto$

            CASE mt_OverLoad
            varcode->Functype$ = VAR$ + SPC$

            CASE mt_OverLoadAParam
            varcode->Header$ = varcode->Header$ + VAR$ + PTH$ + pszHead$

        END SELECT

        '************************************************************************
        CASE vt_UDT, vt_STRUCT, vt_UNION
        '************************************************************************

        SELECT CASE varcode->Methd%

            CASE mt_ProcessSetCommand
            IF vn = vt_UNION THEN
                varcode->StaticOut$ = "static union  " + pszHead$
            ELSE
                varcode->StaticOut$ = "static struct _" + pszHead$ + SPC$
            END IF

            CASE mt_FuncSubDecC_Dec
            varcode->Functype$ = varcode->AsToken$ + PTH$ + CB$

            CASE mt_FuncSubDecC_DecAParam
            varcode->Header$ = varcode->Header$  +  varcode->AsToken$ + PTH$ +  pszHead$
            varcode->Proto$  = varcode->Proto$   +  varcode->AsToken$ + RF$ + PT$

            CASE mt_Opts
            varcode->Functype$ = varcode->AsToken$ + PTH$

            CASE mt_OptsAParam
            varcode->Header$ = varcode->Header$ + Clean$(varcode->AsToken$) + PTH$ + SPC$ + pszHead$
            varcode->Proto$ = varcode->Proto$   + Clean$(varcode->AsToken$) + RF$ + PT$

            CASE mt_ConsDesAParam
            varcode->Header$ = varcode->Header$ + Clean$(varcode->AsToken$) + PTH$ + SPC$ + pszHead$
            varcode->Proto$ = varcode->Proto$   + Clean$(varcode->AsToken$) + PTH$ + SPC$ + pszHead$

            CASE mt_OverLoad
            varcode->Functype$ = VAR$ + SPC$

            CASE mt_OverLoadAParam
            varcode->Header$ = varcode->Header$ + varcode->AsToken$ + PTH$ + pszHead$

        END SELECT

        CASE vt_CONSTRDESTR
        SELECT CASE varcode->Methd%
            CASE mt_ConsDes
            varcode->Functype$ = VAR$ + PTH$ + CB$
        END SELECT

        '************************************************************************
        CASE ELSE
        '************************************************************************

        SELECT CASE varcode->Methd%

            CASE mt_FuncSubDecC_Dec
            varcode->Functype$ = varcode->AsToken$ + PTH$ + CB$

            CASE mt_FuncSubDecC_DecAParam
            varcode->Header$ = varcode->Header$  +  varcode->AsToken$ + PTH$ +  pszHead$
            varcode->Proto$ = varcode->Proto$    +  varcode->AsToken$ + RF$ + PT$

            CASE mt_Opts
            varcode->Functype$ = varcode->AsToken$ + PTH$

            CASE mt_OptsAParam
            varcode->Header$ = varcode->Header$ + Clean$(varcode->AsToken$) + PTH$ + SPC$ + pszHead$
            varcode->Proto$  = varcode->Proto$  + Clean$(varcode->AsToken$) + RF$ + PT$

            CASE mt_ConsDesAParam
            varcode->Header$ = varcode->Header$ + Clean$(varcode->AsToken$) + SPC$ + pszHead$
            varcode->Proto$  = varcode->Proto$  + Clean$(varcode->AsToken$) + SPC$ + pszHead$

        END SELECT
    END SELECT
END SUB ' GetVarCode




SUB User_Global_Initialized_Arrays(FP_OUTPUT AS FILE)
    DIM STATIC Banner_Printed    ' Must remain static
    DIM RAW Banner$
    DIM RAW P$, i, A
    DIM RAW VarName$
    DIM RAW VarDim$
    DIM RAW Storage$
    DIM RAW VAR$

    IF Banner_Printed = FALSE THEN
        Banner$  = ""
        Banner$ += ""                                                     + LF$
        Banner$ += "// *************************************************" + LF$
        Banner$ += "//            User's Global Initialized Arrays"       + LF$
        Banner$ += "// *************************************************" + LF$
        Banner_Printed = TRUE
        FPRINT FP_OUTPUT, Banner$
    END IF


    FOR i = 1 TO GlobalVarCnt
        IF GlobalVars[i].VarEmitFlag THEN ITERATE
        IF "" <> GlobalVars[i].VarDim$ AND GlobalVars[i].VarCondLevel = 0 THEN
            IF INCHR(GlobalVars[i].VarDim, "{") THEN

                P$ = ""
                IF GlobalVars[i].VarPntr THEN P$ = STRING$(GlobalVars[i].VarPntr, 42)

                A = GlobalVars[i].VarType

                IF GlobalVars[i].VarSF THEN
                    VarName$ = "(*" + GlobalVars[i].VarName$ + EXTRACT$(GlobalVars[i].VarDim, "(") + ")"
                    VarDim$ = MID$(GlobalVars[i].VarDim, INCHR(GlobalVars[i].VarDim, "("))
                ELSE
                    VarName$ = GlobalVars[i].VarName$
                    VarDim$ = GlobalVars[i].VarDim
                END IF

                Storage$ = VarStorage$[GlobalVars[i].VarExtn] + VarConst$[GlobalVars[i].VarConstant]

                SELECT CASE A
                    ' handle exceptions

                    CASE vt_STRVAR
                    FPRINT FP_OUTPUT, Storage$, "char    ", VarName$, VarDim$, ";"

                    CASE vt_FILEPTR
                    REMOVE "@" FROM GlobalVars[i].VarName$
                    FPRINT FP_OUTPUT, Storage$, "FILE    *", VarName$, VarDim$, ";"

                    CASE vt_LPSTR
                    FPRINT FP_OUTPUT, Storage$, "PSTR   ", P$, VarName$, VarDim$, ";"

                    CASE vt_UDT, vt_STRUCT, vt_UNION
                    VAR$ = TypeDefs[GlobalVars[i].VarDef].VarName$
                    VAR$ = RPAD$(VAR$, PADSIZE)
                    FPRINT FP_OUTPUT, Storage$, VAR$, SPC$, P$, VarName$, VarDim$, ";"

                    ' handle normal

                    CASE vt_VarMin TO vt_VarMax
                    VAR$ = GetVarTypeName$(GlobalVars[i].VarType)
                    VAR$ = RPAD$(VAR$, PADSIZE)
                    FPRINT FP_OUTPUT, Storage$, VAR$, SPC$, P$, VarName$, VarDim$, ";"

                END SELECT
            END IF
        END IF
    NEXT
END SUB ' User_Global_Initialized_Arrays



SUB User_Overloaded_SubsFunctions(FP_OUTPUT AS FILE)
    DIM RAW LZZ$
    DIM RAW FP_OVR_IN AS FILE

    IF Use_Overloaded THEN
        FPRINT FP_OUTPUT, "// *************************************************"
        FPRINT FP_OUTPUT, "//        User's Overloaded Subs/Functions          "
        FPRINT FP_OUTPUT, "// *************************************************"

        OPEN ovrFile$ FOR INPUT AS FP_OVR_IN

        DO WHILE NOT EOF(FP_OVR_IN)
            LINE INPUT FP_OVR_IN, LZZ$
            IF iMatchNQ (LZZ$, "overloaded") THEN
                FPRINT FP_OUTPUT, "\n"
            END IF
            FPRINT FP_OUTPUT, LZZ$
        LOOP

        CLOSE FP_OVR_IN
        FPRINT FP_OUTPUT, "\n\n"
    END IF
END SUB ' User_Overloaded_SubsFunctions



SUB User_Global_Set_Statements(FP_OUTPUT AS FILE)
    DIM RAW LTmp1$
    DIM RAW LFP1 AS FILE

    IF LOF(setFile$) > 0 THEN
        OPEN setFile$ FOR INPUT AS LFP1
        FPRINT FP_OUTPUT, ""
        FPRINT FP_OUTPUT, "// *************************************************"
        FPRINT FP_OUTPUT, "//              User's GLOBAL SET Statements"
        FPRINT FP_OUTPUT, "// *************************************************"
        FPRINT FP_OUTPUT, ""
        DO WHILE NOT EOF(LFP1)
            LINE INPUT LFP1, LTmp1$
            FPRINT FP_OUTPUT, LTmp1$
        LOOP
        FPRINT FP_OUTPUT, ""
        CLOSE LFP1
    END IF
END SUB ' User_Global_Set_Statements



SUB User_Prototypes(FP_OUTPUT AS FILE)
    DIM RAW LastDef$
    DIM RAW LastLevel
    DIM RAW A

    IF ProtoCnt THEN
        FPRINT FP_OUTPUT, ""
        FPRINT FP_OUTPUT, "// *************************************************"
        FPRINT FP_OUTPUT, "//               ", BCX_STR_USR_PROTOS$
        FPRINT FP_OUTPUT, "// *************************************************"
        FPRINT FP_OUTPUT, ""

        LastDef$ = ""                                 ' f.e.: LastDef$ = ProtoType[A].Condition$
        LastLevel = 1

        FOR A = 1 TO ProtoCnt

            IF LastDef$ = "" THEN
                LastDef$ = ProtoType[A].Condition$    ' f.e.: .Condition$ = "#else"
                LastLevel = ProtoType[A].CondLevel    ' f.e.: .CondLevel = InConditional ... or zero
                IF Use_SingleFile = FALSE THEN
                    IF LastDef$ <> "" THEN FPRINT FP_HeaderFile, LastDef$
                END IF
                IF LastDef$ <> "" THEN FPRINT FP_OUTPUT, LastDef$
            END IF

            IF LastDef$ <> ProtoType[A].Condition$ THEN
                IF ProtoType[A].Condition$ = "#else" THEN
                    DO WHILE LastLevel > ProtoType[A].CondLevel
                        IF Use_SingleFile = FALSE THEN
                            FPRINT FP_HeaderFile, "#endif"
                        END IF
                        FPRINT FP_OUTPUT, "#endif"
                        DECR LastLevel
                    LOOP
                    IF Use_SingleFile = FALSE THEN
                        FPRINT FP_HeaderFile, "#else"
                    END IF
                    FPRINT FP_OUTPUT, "#else"
                    LastDef$ = ProtoType[A].Condition$
                    LastLevel = ProtoType[A].CondLevel

                ELSE

                    ' DO WHILE LastLevel > ProtoType[A].CondLevel
                    DO WHILE LastLevel >= ProtoType[A].CondLevel  ' MrBcx 812 Changed in support of $IFDEF enhancement
                        IF Use_SingleFile = FALSE THEN
                            FPRINT FP_HeaderFile, "#endif"
                        END IF
                        FPRINT FP_OUTPUT, "#endif"
                        DECR LastLevel
                    LOOP
                    LastDef$ = ProtoType[A].Condition$
                    LastLevel = ProtoType[A].CondLevel
                    IF Use_SingleFile = FALSE THEN
                        IF LastDef$ <> "" THEN FPRINT FP_HeaderFile, LastDef$
                    END IF
                    IF LastDef$ <> "" THEN FPRINT FP_OUTPUT, LastDef$
                END IF
            END IF

            IF UseStdCall AND UseCpp THEN
                IF LEFTSTR(ProtoType[A].Prototype$, "C_EXPORT ") THEN
                    Emit_ExportDef(ProtoType[A].Prototype$)
                    UseImportExport = TRUE
                END IF
            END IF

            DIM RAW T$
            T$ = EXTRACT$(ProtoType[A].Prototype$, SPC$)
            T$ = RPAD$(T$, PADSIZE) + SPC$
            ProtoType[A].Prototype$ = T$ + REMAIN$(ProtoType[A].Prototype$, SPC$)

            REPLACE "char*  ,"   WITH "char*,"   IN ProtoType[A].Prototype$
            REPLACE "char    * " WITH "char*   " IN ProtoType[A].Prototype$

            IF Use_SingleFile = FALSE THEN
                FPRINT FP_HeaderFile, ProtoType[A].Prototype$
            END IF

            FPRINT FP_OUTPUT, ProtoType[A].Prototype$

        NEXT ' A 'ProtoCnt

        IF FPDEF THEN CLOSE FPDEF

        IF *LastDef$ THEN
            DO WHILE LastLevel > 0
                IF Use_SingleFile = FALSE THEN
                    FPRINT FP_HeaderFile, "#endif"
                END IF
                FPRINT FP_OUTPUT, "#endif"
                DECR LastLevel
            LOOP
        END IF
    END IF
END SUB ' User_Prototypes




SUB Emit_OSVersionEnum
    DIM STATIC BeenHereDoneThat
    IF BeenHereDoneThat = TRUE THEN EXIT SUB
    BeenHereDoneThat = TRUE
    FPRINT FP_ENU, ""
    FPRINT FP_ENU, "enum"
    FPRINT FP_ENU, "  {"
    FPRINT FP_ENU, "  OSUnknown = -2,"
    FPRINT FP_ENU, "  OSError = -1,"
    FPRINT FP_ENU, "  OS_3x,"
    FPRINT FP_ENU, "  OS_95,"
    FPRINT FP_ENU, "  OS_98,"
    FPRINT FP_ENU, "  OS_ME,"
    FPRINT FP_ENU, "  OS_NT3,"
    FPRINT FP_ENU, "  OS_2000,"
    FPRINT FP_ENU, "  OS_XP,"
    FPRINT FP_ENU, "  OS_XP_Pro_x64,"
    FPRINT FP_ENU, "  OS_Server_2003,"
    FPRINT FP_ENU, "  OS_Home_Server,"
    FPRINT FP_ENU, "  OS_Server_2003_R2,"
    FPRINT FP_ENU, "  OS_Vista,"
    FPRINT FP_ENU, "  OS_Server_2008,"
    FPRINT FP_ENU, "  OS_Server_2008_R2,"
    FPRINT FP_ENU, "  OS_Win_7,"
    FPRINT FP_ENU, "  OS_Server_2012,"
    FPRINT FP_ENU, "  OS_Win_8,"
    FPRINT FP_ENU, "  OS_Win_81,"
    FPRINT FP_ENU, "  OS_Server_2012_R2,"
    FPRINT FP_ENU, "  OS_Win_10,"
    FPRINT FP_ENU, "  OS_Server_2016,"
    FPRINT FP_ENU, "  OS_Win_11,"
    FPRINT FP_ENU, "  OS_Server_2019,"
    FPRINT FP_ENU, "  OS_Server_2022"
    FPRINT FP_ENU, "  };"
    FPRINT FP_ENU, ""
END SUB



SUB AddMacros(FP_OUTPUT AS FILE)

    IF Use_SysMacros OR Use_Wingui THEN
        FPRINT FP_OUTPUT, ""
        FPRINT FP_OUTPUT, "// *************************************************"
        FPRINT FP_OUTPUT, "//               " + $BCX_STR_STD_MACROS
        FPRINT FP_OUTPUT, "// *************************************************"
        FPRINT FP_OUTPUT, ""
    END IF

    DIM  Accum= Use_Form
    INCR Accum, Use_Button
    INCR Accum, Use_BmpButton
    INCR Accum, Use_Edit
    INCR Accum, Use_BCX_Input
    INCR Accum, Use_Label
    INCR Accum, Use_Group
    INCR Accum, Use_Checkbox
    INCR Accum, Use_Radio
    INCR Accum, Use_Combobox
    INCR Accum, Use_Listbox
    INCR Accum, Use_Treeview
    INCR Accum, Use_Blackrect
    INCR Accum, Use_Whiterect
    INCR Accum, Use_Grayrect
    INCR Accum, Use_Datepick
    INCR Accum, Use_Listview
    INCR Accum, Use_BCX_Control
    INCR Accum, Use_BCX_Slider
    INCR Accum, Use_BCX_Tab
    INCR Accum, Use_BCX_Toolbar
    INCR Accum, Use_BCX_UpDown
    INCR Accum, Use_BCX_FrameWnd
    INCR Accum, Use_BCX_Wnd

    IF Accum THEN
        IF NOT Use_Project THEN
            FPRINT FP_OUTPUT, "#define DefFont ((BcxFont!=0)?BcxFont:(HFONT)SNDMSG(hWnd, WM_GETFONT, 0, 0))"
            FPRINT FP_OUTPUT, "#define DefaultFont ((DefFont==0)?GetStockObject(DEFAULT_GUI_FONT):DefFont)"
        ELSE
            FPRINT FP_OUTPUT, "#ifndef __BCXFONT_DEFINED__"
            FPRINT FP_OUTPUT, "  #define __BCXFONT_DEFINED__"
            FPRINT FP_OUTPUT, "  #define DefFont ((BcxFont!=0)?BcxFont:(HFONT)SNDMSG(hWnd, WM_GETFONT, 0, 0))"
            FPRINT FP_OUTPUT, "  #define DefaultFont ((DefFont==0)?GetStockObject(DEFAULT_GUI_FONT):DefFont)"
            FPRINT FP_OUTPUT, "#endif"
        END IF
        CALL AddBcxFontVar
    END IF

    '=======================================================================================================

    IF Use_SysMacros THEN

        IF Use_ForEach THEN
            FPRINT FP_OUTPUT, "#define FOR_EACH(i, a) {for(UINT i=0; i<sizeof(a)/sizeof((a)[0]); i++){"
            FPRINT FP_OUTPUT, "#define NEXT_EACH }}"
            FPRINT FP_OUTPUT, "#define EXIT_EACH break;"
        END IF

        IF Use_Clip_Reset THEN
            FPRINT FP_OUTPUT, "#define Clipboard_Reset OpenClipboard(NULL),EmptyClipboard(),CloseClipboard();"
        END IF

        IF Use_Cast THEN
            FPRINT FP_OUTPUT, "#define CAST(to_type,old_obj) ((to_type)(old_obj))"
        END IF

        IF Use_Read THEN
            FPRINT FP_OUTPUT, "#define READ(a) DATA[(a)-1]"
        END IF

        IF Use_Readnum THEN
            FPRINT FP_OUTPUT, "#define READNUM(a) (double)atof((DATA[(a)-1]))"
        END IF

        IF Use_EqualTo THEN
            FPRINT FP_OUTPUT, "#define EqualTo =="
        END IF

        IF Use_NotEqualTo THEN
            FPRINT FP_OUTPUT, "#define NotEqualTo !="
        END IF

        IF Use_BcxSplitPath THEN
            FPRINT FP_OUTPUT, "#define FDRV   2"
            FPRINT FP_OUTPUT, "#define FPATH  4"
            FPRINT FP_OUTPUT, "#define FNAME  8"
            FPRINT FP_OUTPUT, "#define FEXT  16"
        END IF

        IF Use_Cbool THEN
            FPRINT FP_OUTPUT, "#define CBOOL(A)((A)!=0)?1:0"
        END IF

        IF Use_Istrue THEN
            FPRINT FP_OUTPUT, "#define ISTRUE 0!="
        END IF

        IF Use_Notzero THEN
            FPRINT FP_OUTPUT, "#define NOTZERO 0!="
        END IF

        IF Use_Notnull THEN
            FPRINT FP_OUTPUT, "#define NOTNULL(A)(*(A)!= 0)"
        END IF

        IF Use_Isnull THEN
            FPRINT FP_OUTPUT, "#define ISNULL(A)(*(A)== 0)"
        END IF

        IF Use_Isfalse THEN
            FPRINT FP_OUTPUT, "#define ISFALSE 0=="
        END IF

        IF Use_Iszero THEN
            FPRINT FP_OUTPUT, "#define ISZERO 0=="
        END IF

        IF Use_Isptr THEN
            FPRINT FP_OUTPUT, "#define IsPtr(a)((ULONG_PTR)(a))"
        END IF

        IF Use_ByteAt THEN
            FPRINT FP_OUTPUT, "#define BYTE_AT(B) (B)"
        END IF

        IF Use_Bnot THEN
            FPRINT FP_OUTPUT, "#define BNOT ~(int)"
        END IF

        IF Use_Datacount THEN
            FPRINT FP_OUTPUT, "#define DATACOUNT (int)(sizeof((DATA))/sizeof((DATA[0])))"
        END IF

        IF Use_Ubound THEN
            FPRINT FP_OUTPUT, "#define ubound_s(t)(int)(sizeof((t))/sizeof((t[0]))-1)"
            FPRINT FP_OUTPUT, "#define ubound_d(i)(int)(_msize((i))/sizeof(i[0])-3)"
            FPRINT FP_OUTPUT, "#define ubound(x)((int)ubound_s(x)<2?ubound_d(x):ubound_s(x))"
        END IF

        IF Use_Clear THEN
            FPRINT FP_OUTPUT, "#define Clear(arg)memset(&arg,0,sizeof(arg))"
        END IF

        IF Use_Imod THEN
            FPRINT FP_OUTPUT, "#define imod(a,b)((a)%(b))"
        END IF

        IF Use_BCX_OlePicture THEN
            FPRINT FP_OUTPUT, "#define BCX_OLE_WIDTH(H)  LOWORD(PtrToUlong(GetWindowLongPtr(H,GWLP_USERDATA)))"
            FPRINT FP_OUTPUT, "#define BCX_OLE_HEIGHT(H) HIWORD(PtrToUlong(GetWindowLongPtr(H,GWLP_USERDATA)))"
        END IF

        IF Use_BCX_Resize THEN
            FPRINT FP_OUTPUT, "#define BCX_RESIZE(hwnd,cx,cy) SetWindowPos (hwnd,NULL,0,0,(cx),(cy),SWP_NOMOVE|SWP_NOREPOSITION|SWP_NOZORDER|SWP_FRAMECHANGED)"
        END IF

        IF Use_BCX_Cursor THEN
            FPRINT FP_OUTPUT, "#define BCX_Cursor(x)SetCursor(LoadCursor(NULL,x))"
        END IF

        IF Use_Refresh THEN
            FPRINT FP_OUTPUT, "#define Refresh(A) RedrawWindow(A,NULL,NULL,RDW_ERASE|RDW_INVALIDATE|RDW_ALLCHILDREN|RDW_UPDATENOW);"
        END IF

        IF Use_ShowModal THEN
            FPRINT FP_OUTPUT, "#define ShowModal(Window)EnableWindow(GetWindow(Window,GW_OWNER),FALSE);SHOWHWNDWindow);"
        END IF

        IF Use_EndModal THEN
            FPRINT FP_OUTPUT, "#define EndModal(Window)EnableWindow(GetWindow(Window,GW_OWNER),TRUE);DestroyWindow(Window);"
        END IF

        IF Use_Show THEN
            FPRINT FP_OUTPUT, "#define SHOWHWND(Window)RedrawWindow(Window,0,0,0);ShowWindow(Window,SW_SHOW);"
        END IF

        IF Use_Hide THEN
            FPRINT FP_OUTPUT, "#define HIDEHWND(Window)ShowWindow(Window,SW_HIDE)"
        END IF

        IF Use_Get THEN
            FPRINT FP_OUTPUT, "#define GET(A,B,C)fread((B),1,(C),(A))"
        END IF

        IF Use_Put THEN
            FPRINT FP_OUTPUT, "#define PUT(A,B,C)fwrite((B),1,(C),(A))"
        END IF

        IF Use_Seteof THEN
            FPRINT FP_OUTPUT, "#define SetEof(A) SetEndOfFile((HANDLE)_get_osfhandle(_fileno((A))))"
        END IF

        IF Use_Strptr THEN
            FPRINT FP_OUTPUT, "#define STRPTR(A)(char*)&((A))"
        END IF

        IF Use_Val THEN
            FPRINT FP_OUTPUT, "#define VAL(a)(double)atof((a))"
        END IF

        IF Use_Vall THEN
            FPRINT FP_OUTPUT, "#if defined(__LCC__)||defined(__POCC__)||defined(__MINGW32__)||defined(__MINGW64__)"
            FPRINT FP_OUTPUT, "  #define VALL(a) (long double)strtold((a),(char**)NULL)"
            FPRINT FP_OUTPUT, "#elif defined(__BCPLUSPLUS__)"
            FPRINT FP_OUTPUT, "  #define VALL(a) (long double)_strtold((a),(char**)NULL)"
            FPRINT FP_OUTPUT, "#else"
            FPRINT FP_OUTPUT, "  #define VALL(a) (long double)strtod((a),(char**)NULL)"
            FPRINT FP_OUTPUT, "#endif"
        END IF

        IF Use_Getattr THEN
            FPRINT FP_OUTPUT, "#define GETATTR(a)(ULONG)GetFileAttributes((a))"
        END IF

        IF Use_Setattr THEN
            FPRINT FP_OUTPUT, "#define SETATTR(a,b)(ULONG)SetFileAttributes((a),(b))"
        END IF

        IF Use_Frac THEN
            FPRINT FP_OUTPUT, "#define FRAC(a)(double)(((a))-FIX((a)))"
            Use_Fix = TRUE
        END IF

        IF Use_Fracl THEN
            FPRINT FP_OUTPUT, "#define FRACL(a)(long double)((a)-FIX((a)))"
            Use_Fix = TRUE
        END IF

        IF Use_Fix THEN
            FPRINT FP_OUTPUT, "#define FIX(a)(int)((a))"
        END IF

        IF Use_Csng THEN
            FPRINT FP_OUTPUT, "#define CSNG(a)(float)((a))"
        END IF

        IF Use_Cdbl THEN
            FPRINT FP_OUTPUT, "#define CDBL(a)(double)((a))"
        END IF

        IF Use_Cldbl THEN
            FPRINT FP_OUTPUT, "#define CLDBL(a)(long double)((a))"
        END IF

        IF Use_DegToRad THEN
            FPRINT FP_OUTPUT, "#define DegToRad(Degrees)((Degrees)*0.017453292519943)"
        END IF

        IF Use_RadToDeg THEN
            FPRINT FP_OUTPUT, "#define RadToDeg(Radians)((Radians)*57.29577951308232)"
        END IF

        IF Use_Threads THEN
            FPRINT FP_OUTPUT, ""
            FPRINT FP_OUTPUT, "#define BCX_THREAD(a)        (HANDLE)_beginthreadex(0,0,(unsigned int (__stdcall *)(void *))a,0,0,(unsigned int *)&BCX_Thread_ID)"
            FPRINT FP_OUTPUT, "#define BCX_THREADWAIT(a)    while(WaitForSingleObject(((void *)a),0)==WAIT_TIMEOUT){}CloseHandle(((void *)a))"
            FPRINT FP_OUTPUT, "#define BCX_THREADSUSPEND(a) SuspendThread((void *)a)"
            FPRINT FP_OUTPUT, "#define BCX_THREADRESUME(a)  ResumeThread((void *)a)"
            FPRINT FP_OUTPUT, "#define BCX_THREADKILL(a)    TerminateThread((void *)a,0); CloseHandle((void *)a)"
            FPRINT FP_OUTPUT, "#define BCX_THREADEND        _endthreadex(0)"
            FPRINT FP_OUTPUT, "ULONG   BCX_Thread_ID = 0;"
            FPRINT FP_OUTPUT, ""
        END IF

        IF Use_LineinputKB THEN
            FPRINT FP_OUTPUT, "#define mIsDynaString(v)(sizeof((v))==4||sizeof((v))==8)?1:0"
            FPRINT FP_OUTPUT, ""
            FPRINT FP_OUTPUT, "#define mLineInputKB(p,v)\\"
            FPRINT FP_OUTPUT, "{\\"
            FPRINT FP_OUTPUT, "  printf(", ENC$("%s"), ",(p));\\"
            FPRINT FP_OUTPUT, "  if(mIsDynaString(v))\\"
            FPRINT FP_OUTPUT, "     fgets((v), _msize((v)), stdin);\\"
            FPRINT FP_OUTPUT, "   else \\"
            FPRINT FP_OUTPUT, "     fgets((v), sizeof((v)), stdin);\\"
            FPRINT FP_OUTPUT, "  (v)[strlen((v))-1]=0;\\"
            FPRINT FP_OUTPUT, "}"
            FPRINT FP_OUTPUT, ""
        END IF
    END IF
END SUB ' AddMacros



SUB Emit_MDI_MsgPump
    IF LEN(Accelerator$) THEN
        FPRINT FP_WRITE, "  if(!BCX_hwndMDIClient)"
        FPRINT FP_WRITE, "    {"
        FPRINT FP_WRITE, "      return FALSE;"
        FPRINT FP_WRITE, "    }"
        FPRINT FP_WRITE, "  while((GetMessage(&Msg,NULL,0,0)))"
        FPRINT FP_WRITE, "    {"
        FPRINT FP_WRITE, "      HWND hActiveWindow=GetActiveWindow();"
        FPRINT FP_WRITE, "      if((!TranslateMDISysAccel(BCX_hwndMDIClient,&Msg)))"
        FPRINT FP_WRITE, "        {"
        FPRINT FP_WRITE, "          if((!TranslateAccelerator(hActiveWindow,", Accelerator$, ",&Msg)))"
        FPRINT FP_WRITE, "            {"
        FPRINT FP_WRITE, "              TranslateMessage(&Msg);"
        FPRINT FP_WRITE, "              DispatchMessage(&Msg);"
        FPRINT FP_WRITE, "            }"
        FPRINT FP_WRITE, "        }"
        FPRINT FP_WRITE, "    }"
        FPRINT FP_WRITE, "  return Msg.wParam;"
        FPRINT FP_WRITE, "}\n"
    ELSE
        FPRINT FP_WRITE, " if(!BCX_hwndMDIClient)"
        FPRINT FP_WRITE, " {"
        FPRINT FP_WRITE, "   return FALSE;"
        FPRINT FP_WRITE, " }"
        FPRINT FP_WRITE, " while((GetMessage(&Msg,NULL,0,0)))"
        FPRINT FP_WRITE, "   {"
        FPRINT FP_WRITE, "   if((!TranslateMDISysAccel(BCX_hwndMDIClient,&Msg)))"
        FPRINT FP_WRITE, "     {"
        FPRINT FP_WRITE, "       TranslateMessage(&Msg);"
        FPRINT FP_WRITE, "       DispatchMessage(&Msg);"
        FPRINT FP_WRITE, "     }"
        FPRINT FP_WRITE, "   }"
        FPRINT FP_WRITE, "return Msg.wParam;"
        FPRINT FP_WRITE, "}\n"
    END IF
END SUB ' Emit_MDI_MsgPump



SUB Emit_GUI_MsgPump
    IF LEN(Accelerator$) THEN
        FPRINT FP_WRITE, " while(GetMessage(&Msg,NULL,0,0))"
        FPRINT FP_WRITE, "   {"
        FPRINT FP_WRITE, "    HWND hActiveWindow = GetActiveWindow();"
        FPRINT FP_WRITE, "    if(!TranslateAccelerator(hActiveWindow,", Accelerator$, ",&Msg) &&"
        FPRINT FP_WRITE, "       ((!IsDialogMessage(hActiveWindow,&Msg)) || (!IsWindow(hActiveWindow))))"
        FPRINT FP_WRITE, "      {"
        FPRINT FP_WRITE, "        TranslateMessage(&Msg);"
        FPRINT FP_WRITE, "        DispatchMessage(&Msg);"
        FPRINT FP_WRITE, "      }"
        FPRINT FP_WRITE, "   }"
        FPRINT FP_WRITE, " return Msg.wParam;"
        FPRINT FP_WRITE, "}\n"
    ELSE
        FPRINT FP_WRITE, " while(GetMessage(&Msg,NULL,0,0))"
        FPRINT FP_WRITE, "   {"
        FPRINT FP_WRITE, "    HWND hActiveWindow = GetActiveWindow();"
        FPRINT FP_WRITE, "    if((!IsWindow(hActiveWindow)) || (!IsDialogMessage(hActiveWindow,&Msg)))"
        FPRINT FP_WRITE, "      {"
        FPRINT FP_WRITE, "        TranslateMessage(&Msg);"
        FPRINT FP_WRITE, "        DispatchMessage(&Msg);"
        FPRINT FP_WRITE, "      }"
        FPRINT FP_WRITE, "    }"
        FPRINT FP_WRITE, " return Msg.wParam;"
        FPRINT FP_WRITE, "}\n"
    END IF
END SUB



SUB Emit_WinGUIMain(classname$, metric$, icon$)
    FPRINT FP_WRITE, ""
    FPRINT FP_WRITE, "int WINAPI WinMain(HINSTANCE hInst,HINSTANCE hPrev,PSTR CmdLine,int CmdShow) {"
    FPRINT FP_WRITE, "    MSG  Msg;"
    FPRINT FP_WRITE, "  strcpy(BCX_ClassName," ; classname$; ");"
    FPRINT FP_WRITE, "  BCX_SetMetric(";ENC$(metric$);");"
    FPRINT FP_WRITE, "  BCX_InitGUI();"
    FPRINT FP_WRITE, "  BCX_hInstance       =  hInst;"
    FPRINT FP_WRITE, "  BCX_WndClass.hIcon  = " ; icon$
    FPRINT FP_WRITE, "  BCX_RegWnd(BCX_ClassName, WndProc);"
    FPRINT FP_WRITE, ""
    FPRINT FP_WRITE, "  // ******************************************"
    FPRINT FP_WRITE, "                    FormLoad();"
    FPRINT FP_WRITE, "  // ******************************************"
END SUB



SUB Emit_MDICode(FP_OUTPUT AS FILE)
    FPRINT FP_OUTPUT, "HWND BCX_MDICHILD (LPCTSTR title, LPCTSTR MdiClassName,int x,int y,int cx,int cy,ULONG style,LPARAM lParam) {"
    FPRINT FP_OUTPUT, "  HWND  hwndChild;"
    FPRINT FP_OUTPUT, "  char rgch";"[BCXSTRSIZE]={0};"
    FPRINT FP_OUTPUT, "  static int cUntitled=1;"
    FPRINT FP_OUTPUT, "  if(title[0]==0)"
    FPRINT FP_OUTPUT, "    {"
    FPRINT FP_OUTPUT, "      sprintf(rgch," , ENC$("%s%i") , "," , ENC$("Untitled") , ",cUntitled++);"
    FPRINT FP_OUTPUT, "    }"
    FPRINT FP_OUTPUT, "  else"
    FPRINT FP_OUTPUT, "    {"
    FPRINT FP_OUTPUT, "      strcpy(rgch,title);"
    FPRINT FP_OUTPUT, "    }"
    FPRINT FP_OUTPUT, "  //  Create the MDI child window"
    FPRINT FP_OUTPUT, "  hwndChild = CreateMDIWindow(MdiClassName, rgch, style, x, y,"
    FPRINT FP_OUTPUT, "              cx, cy, BCX_hwndMDIClient, BCX_hInstance, lParam);"
    FPRINT FP_OUTPUT, "  return hwndChild;"
    FPRINT FP_OUTPUT, "}\n\n"

    FPRINT FP_OUTPUT, "void BCX_MDICLASS (WNDPROC MCWP, PCHAR ClassName) {"
    FPRINT FP_OUTPUT, "  WNDCLASS wc={0};"
    FPRINT FP_OUTPUT, "  wc.style=0;"
    FPRINT FP_OUTPUT, "  wc.lpfnWndProc=(WNDPROC)MCWP;"
    FPRINT FP_OUTPUT, "  wc.cbClsExtra=0;"
    FPRINT FP_OUTPUT, "  wc.cbWndExtra=20;"
    FPRINT FP_OUTPUT, "  wc.hInstance=BCX_hInstance;"
    FPRINT FP_OUTPUT, "  wc.hIcon= ", GUIIcon$
    FPRINT FP_OUTPUT, "  wc.hCursor=LoadCursor(NULL,IDC_ARROW);"
    FPRINT FP_OUTPUT, "  wc.hbrBackground=(HBRUSH)(COLOR_WINDOW+1);"
    FPRINT FP_OUTPUT, "  wc.lpszMenuName=NULL;"
    FPRINT FP_OUTPUT, "  wc.lpszClassName=ClassName;"
    FPRINT FP_OUTPUT, "  RegisterClass((LPWNDCLASS)&wc);"
    FPRINT FP_OUTPUT, "}\n\n"


    FPRINT FP_OUTPUT, "HWND BCX_MDICLIENT (HWND hwndparent, int icount) {"
    FPRINT FP_OUTPUT, "  CLIENTCREATESTRUCT ccs={0,1};"
    FPRINT FP_OUTPUT, "  //  Find window menu where children will be listed"
    FPRINT FP_OUTPUT, "  ccs.hWindowMenu=GetSubMenu(GetMenu(hwndparent),icount-1);"
    FPRINT FP_OUTPUT, "  //  Create the MDI client filling the client area"
    FPRINT FP_OUTPUT, "  BCX_hwndMDIClient=CreateWindow(", ENC$("MDICLIENT"), ",NULL, WS_CHILD | WS_CLIPCHILDREN | WS_VISIBLE | WS_VSCROLL | WS_HSCROLL,"
    FPRINT FP_OUTPUT, "                                 0,0,0,0,hwndparent,(HMENU)(UINT_PTR)NULL,BCX_hInstance,(PVOID)&ccs);"
    FPRINT FP_OUTPUT, "  return BCX_hwndMDIClient;"
    FPRINT FP_OUTPUT, "}\n\n"
END SUB      ' Emit_MDICode



FUNCTION JoinLines(Arg$)
    Arg$ = RTRIM$(Arg$)
    IF     iMatchRgt(Arg$, " _") _
        OR iMatchRgt(Arg$, ",_") _
        OR iMatchRgt(Arg$, ";_") _
        OR iMatchRgt(Arg$, ":_") _
        OR iMatchRgt(Arg$, ")_") _
        OR iMatchRgt(Arg$, "]_") _
        OR iMatchRgt(Arg$, "}_") _
        OR iMatchRgt(Arg$, ">_") _
        OR iMatchRgt(Arg$, "$_") _
        OR iMatchRgt(Arg$, DQ$ + "_") _
        THEN
        Arg[LEN(Arg)-1] = 0
        CurLine$ += Arg$
        RETURN TRUE
    END IF

    IF NOTNULL(CurLine$) THEN
        Arg$ = CurLine$ + Arg$
        CurLine$ = ""
    END IF
    UmQt = FALSE
    RETURN FALSE
END FUNCTION



SUB StripCode(Arg$)
    DIM RAW p AS PCHAR
    DIM RAW p2 = Arg AS PCHAR
    DIM RAW asmFlag = 0
    DIM RAW eStr = 0
    DIM RAW sub_$

    DO WHILE (*p2 >8 AND *p2 < 13) OR *p2 = 32      ' Trim leading space
        INCR p2
    LOOP

    IF *p2 = ASC("!") THEN asmFlag = NOT UmQt       ' Handle "!" Asm lines
    p = p2
    DO WHILE *p
        IF *p = 9 THEN *p = 32
        IF *p = c_DblQt THEN             ' ignore anything in string literal
            IF *(p-1) = 69 THEN          ' we're in an extended string: E"\qABCD\n"
                *(p-1) = 1               ' chr$(1) will be deleted
                eStr = TRUE
            END IF
            DO WHILE *(++p) <> c_DblQt
                IF *p = 92 AND eStr THEN ' look for a \0, \t, \n, \r, \q, \\
                    *p = 2
                    SELECT CASE *(p+1)
                        CASE 48  ' 0
                        *(p+1) = 3
                        CASE 116 ' t
                        *(p+1) = 4
                        CASE 110 ' n
                        *(p+1) = 5
                        CASE 114 ' r
                        *(p+1) = 6
                        CASE 113 ' q
                        *(p+1) = 7
                        CASE 92 ' \
                        *(p+1) = 8
                    END SELECT
                    INCR p
                END IF
                IF *p = 0 THEN
                    UmQt = NOT UmQt
                    EXIT DO
                END IF
            LOOP
        END IF

        ' If we're in a quoted continuation line then ignore comments

        IF NOT UmQt AND NOT asmFlag THEN
            IF (*p BOR 32) = ASC("r") THEN   ' Remove REM's
                IF _
                    (*(p+1) BOR 32) = ASC("e") AND _
                    (*(p+2) BOR 32) = ASC("m") AND _
                    (*(p+3) = 32 OR *(p+3) = 0) THEN
                    IF p = p2 OR *(p-1) = ASC(":") OR *(p-1) = 32 THEN
                        *p = 0
                        EXIT DO
                    END IF
                END IF
            END IF
            ' check for single quote comment marker and // C++ style comments
            IF *p = ASC("'") OR (*p = ASC("/") AND *(p+1) = ASC("/")) THEN
                *p = 0
                EXIT DO
            END IF
        END IF
        INCR p
    LOOP

    DO WHILE p2 < p
        ' Trim trailing space
        DO WHILE (*(p-1) >8 AND *(p-1) < 13) OR *(p-1) = 32
            *(--p) = 0
        LOOP

        IF UmQt OR asmFlag THEN EXIT DO

        ' Strip dangling colons
        IF *(p-1) = ASC(":") AND *(p-2) = 32 THEN
            DECR p
        ELSE
            EXIT DO
        END IF
    LOOP

    IF eStr THEN
        REMOVE CHR$(1) FROM p2$            ' E
        REMOVE CHR$(2) FROM p2$            ' \ first backslash
        sub_$ = ENC$("+CHR$(0)+" )
        REPLACE CHR$(3) WITH sub_$ IN p2$  ' 0
        sub_$ = ENC$("+CHR$(9)+" )
        REPLACE CHR$(4) WITH sub_$ IN p2$  ' t
        sub_$ = ENC$("+CHR$(10)+" )
        REPLACE CHR$(5) WITH sub_$ IN p2$  ' n
        sub_$ = ENC$("+CHR$(13)+" )
        REPLACE CHR$(6) WITH sub_$ IN p2$  ' r
        sub_$ = ENC$("+CHR$(34)+" )
        REPLACE CHR$(7) WITH sub_$ IN p2$  ' q
        sub_$ = ENC$("+CHR$(92)+" )
        REPLACE CHR$(8) WITH sub_$ IN p2$  ' \
        REMOVE  CHR$(c_DblQt, c_DblQt, 43) FROM  p2$
        REMOVE  CHR$(43, c_DblQt, c_DblQt) FROM  p2$
    END IF
    Arg$ = p2$
END SUB



SUB ProcSingleLineIf(BYREF ifFlag)
    DIM RAW Tmp$, ifp, NdIfs
    DIM STATIC EFlag

    IF ifFlag = 0 THEN EFlag = 0

    REDO:

    IF SplitCnt = cMaxSplitLines THEN
        CALL Abort("Stack Overflow - Too many statements on one line")
    END IF

    Tmp$ = SplitStk$[SplitCnt] + SPC$

    IF iMatchLft(Tmp$, "if ") THEN
        ifp = iMatchNQ(Tmp$, " then ")
        IF ifp THEN

            IF SplitCnt = cMaxSplitLines-1 THEN
                CALL Abort("Stack Overflow - Too many statements on one line")
            END IF

            SplitStk$[SplitCnt++] = LEFT$(Tmp$, ifp+4)
            SplitStk$[SplitCnt] = LTRIM$(Tmp+ifp+4)
            EFlag = IMAX(0, EFlag-1)
            INCR (ifFlag)
            GOTO REDO
        END IF

    ELSE
        IF (ifFlag) THEN
            IF iMatchLft(Tmp$, "else ") THEN   ' "else xxx"

                LftLse:

                IF ++EFlag > 1 THEN
                    NdIfs = IMAX(1, (ifFlag)-1) : (ifFlag) = 1 : EFlag = 0
                    IF iMatchWrd(SplitStk$[SplitCnt-1], "else") THEN DECR SplitCnt

                    IF SplitCnt = cMaxSplitLines-1 THEN
                        CALL Abort("Stack Overflow - Too many statements on one line")
                    END IF

                    REPEAT NdIfs
                        SplitStk$[SplitCnt++] = "END IF"
                    END REPEAT
                END IF

                IF SplitCnt = cMaxSplitLines-1 THEN
                    CALL Abort("Stack Overflow - Too many statements on one line")
                END IF

                SplitStk$[SplitCnt++] = "ELSE"
                SplitStk$[SplitCnt] = TRIM$(Tmp+4)
                GOTO REDO
            ELSE
                ifp = iMatchNQ(Tmp$, " else ")
                IF ifp THEN                      ' "xxx else xxx"

                    IF SplitCnt = cMaxSplitLines-1 THEN
                        CALL Abort("Stack Overflow - Too many statements on one line")
                    END IF

                    SplitStk$[SplitCnt++] = RTRIM$(LEFT$(Tmp$, ifp-1))
                    Tmp$ = MID$(Tmp$, ifp+1)
                    GOTO LftLse
                END IF
            END IF
        END IF
    END IF         ' process "if/then/else"
END SUB



FUNCTION SplitLines(Arg$)
    DIM RAW p  = Arg AS PCHAR
    DIM RAW st = Arg AS PCHAR
    DIM i, IfFlag, SpcolonFlag, ParaCnt

    IF *p = ASC("!") OR *p = ASC("$") THEN EXIT FUNCTION

    DO WHILE *p
        IF *p = 32 THEN SpcolonFlag = 1
        IF *p = c_DblQt THEN    ' ignore anything in string literal
            DO WHILE *(++p) <> c_DblQt
                IF *p = 0 THEN RETURN SplitCnt
            LOOP
        END IF

        IF *p = c_LPar THEN INCR ParaCnt
        IF *p = c_RPar THEN DECR ParaCnt

        IF *p = ASC(":") THEN
            IF *(p+1) = ASC(":") THEN
                *p = 15
                *(p+1) = 15
            ELSE
                IF NOTNULL((p+1)) OR ISTRUE(SpcolonFlag) THEN

                    DO WHILE *st = 32
                        INCR st
                    LOOP         ' Forward past leading spaces

                    INCR SplitCnt

                    IF SplitCnt = cMaxSplitLines THEN
                        CALL Abort("Stack Overflow - Too many statements on one line")
                    END IF

                    DO WHILE st < p                         ' Copy new string
                        SplitStk[SplitCnt][i++] = *(st++)
                    LOOP

                    SplitStk$[SplitCnt] = TRIM$(SplitStk$[SplitCnt])

                    SplitStk[SplitCnt][i] = 0               ' Add a string terminator
                    IF ParaCnt = 0 THEN
                        i = 0
                        INCR st                             ' advance to next start position
                        ProcSingleLineIf(ADDRESSOF(IfFlag))
                    ELSE
                        DECR SplitCnt
                    END IF
                END IF                                      ' if NOT End of line
            END IF
        END IF                                              ' if :
        INCR p
    LOOP

    ' Add the last string
    IF SplitCnt > 0 THEN
        DO WHILE *st = 32
            INCR st
        LOOP  ' Forward past leading spaces
        INCR SplitCnt

        IF SplitCnt = cMaxSplitLines THEN
            CALL Abort("Stack Overflow - Too many statements on one line")
        END IF

        DO WHILE *st
            SplitStk[SplitCnt][i++] = *(st++)
        LOOP
        SplitStk[SplitCnt][i] = 0
        ProcSingleLineIf(ADDRESSOF(IfFlag))
        ' Process single line if/thens that don't contain colon separated statements
    ELSE
        IF iMatchLft(Arg$, "if ") AND NOT iMatchRgt(Arg$, " then") THEN
            CALL Add2SplitLines(Arg$)
            ProcSingleLineIf(ADDRESSOF(IfFlag))
        END IF
    END IF

    ' If we processed single line "if/then" then close it up
    IF IfFlag THEN
        DO WHILE IfFlag
            CALL Add2SplitLines("END IF")
            DECR IfFlag
        LOOP
    END IF

    RETURN SplitCnt
END FUNCTION ' SplitLines



FUNCTION SpecialCaseHandler(Param$)
    DIM RAW i, j, k, iSrcStkIndex
    DIM RAW lsz$
    '******************************************************************************
    ' The following 783 transform helps overcome a parsing issue involving spaces
    ' in and around dimensional brackets, as in the following exaggerated example:
    '
    '                  DIM AS INTEGER TheArray [  1  +  1  ,  1  +  4  ]
    '
    ' which enters this function in Param$ as:       TheArray [  1+1  ][  1+4  ]
    ' The ver. 783 transform corrects this to the following:
    '                                                TheArray [1+1][1+4]
    '******************************************************************************
    DIM RAW Arg$
    Arg$ = Param$

    IF INCHR(Param$, "[") OR INCHR(Param$, "]") THEN
        REPEAT 2
            REPLACE "[ " WITH "[" IN Arg$
            REPLACE " [" WITH "[" IN Arg$
            REPLACE "] " WITH "]" IN Arg$
            REPLACE " ]" WITH "]" IN Arg$
        END REPEAT
    END IF
    '******************************************************************************

    IF iMatchNQ(Arg$, " sub ") OR iMatchNQ(Arg$, " function ") THEN RETURN FALSE

    '******************************************************************************
    ' Handle Multiple Dim's, Locals, Globals, Shared etc.
    ' Example: DIM a, b!, c$, d$*1000, q[100] AS ULONG
    ' Forward propagation of a type
    ' DIM AS INTEGER a, b[10], c, d[20]
    '******************************************************************************
    lsz$ =  SPC$ + EXTRACT$(Arg$, SPC$) + SPC$

    IF iMatchNQ(" dim , local , global , raw , static , shared , dynamic , auto , register , extern ", lsz$) THEN
        CALL FastLexer(Arg$, SPC$, ",&(){}=")
        IF iMatchWrd("as", Stk$[3]) THEN
            lsz$ =  SPC$ + LCASE$(Stk$[2]) + SPC$
            IF iMatchNQ(" local , raw , static , shared , dynamic , auto , register ", lsz$) THEN
                Stk$[1] = Stk$[2]
                LShiftStk(2)
            END IF
        END IF

        '******************************************************************************
        ' Begin forward propagation of a type
        '******************************************************************************

        IF iMatchWrd("as", Stk$[2]) THEN
            DIM RAW szWrk$
            DIM RAW FirstComma, Ignore, b, EqualAt
            DIM RAW Tmp$[8]
            DIM iFUNC
            CALL BuildDelimStr(1, Ndx, szWrk$)
            CALL FastLexer(szWrk$, SPC$, ",&(){}=")

            XFOR i = 3, Ignore = 0, FirstComma = 0, EqualAt = 0 WHILE i <= Ndx AND FirstComma = 0 BY i++
                IF *Stk$[i] = ASC("=") AND Ignore = 0 THEN EqualAt = i
                IF *Stk$[i] = ASC("{") THEN INCR Ignore
                IF *Stk$[i] = ASC("(") THEN INCR Ignore : IF iFUNC = 0 THEN iFUNC = i
                IF *Stk$[i] = ASC(")") THEN DECR Ignore
                IF *Stk$[i] = ASC("}") THEN DECR Ignore
                IF *Stk$[i] = ASC(",") AND  Ignore = 0 THEN FirstComma = i
            XNEXT

            IF FirstComma = 0 THEN FirstComma = Ndx+1
            IF iFUNC THEN i = iFUNC
            IF i > EqualAt AND EqualAt THEN i = EqualAt
            b = 0
            DO
                DECR i
                IF *Stk$[i] = ASC("}") THEN INCR b
                IF *Stk$[i] = ASC(")") THEN INCR b
                IF *Stk$[i] = ASC("(") THEN DECR b
                IF *Stk$[i] = ASC("{") THEN DECR b
            LOOP WHILE b

            IF *Stk$[i] = ASC("=") THEN DECR i
            IF *Stk$[i] = ASC("(") THEN DECR i
            IF *Stk$[i] = ASC("{") THEN DECR i
            IF *Stk$[i] = ASC(",") THEN DECR i

            DIM RAW iVecCheck
            XFOR j = 0, k = 2, iVecCheck = 0 WHILE k < i BY j++, k++
                IF INCHR(Stk$[k], CHR$(15)) THEN iVecCheck = 1
                IF iVecCheck THEN REPLACE "<" WITH CHR$(16) IN Stk$[k]
                IF iVecCheck THEN REPLACE "," WITH CHR$(18) IN Stk$[k]
                IF iVecCheck THEN REPLACE ">" WITH CHR$(17) IN Stk$[k]
                Tmp$[j] = Stk$[k]
                Stk$[k] = ""
            XNEXT

            k = Ndx
            Tmp$[0] = SPC$ + Tmp$[0]

            InsertTokens(Ndx, j, Tmp$[0], Tmp$[1], Tmp$[2], Tmp$[3], Tmp$[4], Tmp$[5], Tmp$[6], Tmp$[7])
            Ignore = 0

            DO WHILE k >= FirstComma
                IF *Stk$[k] = ASC("}") THEN INCR Ignore
                IF *Stk$[k] = ASC(")") THEN INCR Ignore
                IF *Stk$[k] = ASC("(") THEN DECR Ignore
                IF *Stk$[k] = ASC("{") THEN DECR Ignore
                IF *Stk$[k] = ASC(",") AND NOT Ignore THEN
                    InsertTokens(k-1, j, Tmp$[0], Tmp$[1], Tmp$[2], Tmp$[3], Tmp$[4], Tmp$[5], Tmp$[6], Tmp$[7])
                END IF
                DECR k
            LOOP

            CALL RemEmptyTokens
            CALL BuildDelimStr(1, Ndx, Arg$)

            IF InFunction = FALSE AND UseCpp = FALSE THEN
                IF LEFTSTR(Arg$, "RAW ", 1) THEN Arg$ = "STATIC " + MID$(Arg$, 4)
            END IF

            CALL FastLexer(Arg$, SPC$, ",(){}=")
        ELSE
            XFOR i = 1, INTEGER t = 1, INTEGER iVecCheck = 0 WHILE i < Ndx AND t BY i++
                t = GetAsPosF(i, Ndx)
                IF t THEN
                    INCR t
                    XFOR iVecCheck = 0 WHILE t <= Ndx BY t++
                        IF *Stk$[t] = ASC(",") AND iVecCheck = 0 THEN EXIT XFOR
                        IF INCHR(Stk$[t], CHR$(15)) THEN iVecCheck = 1
                        IF iVecCheck THEN REPLACE "<" WITH CHR$(16) IN Stk$[t]
                        IF iVecCheck THEN REPLACE "," WITH CHR$(18) IN Stk$[t]
                        IF iVecCheck THEN REPLACE ">" WITH CHR$(17) IN Stk$[t]
                    XNEXT
                END IF
            XNEXT
        END IF                   ' End forward propagation of a type

        '******************************************************************************

        ' tolerate nonsense like >> DIM A% as DOUBLE << by removing the sigil

        XFOR i = 1, INTEGER t = 1 WHILE i < Ndx AND t BY i++
            t = GetAsPosF(i, Ndx)
            IF t THEN
                i = t
                Stk$[i-1] = Clean$(Stk$[i-1])
            END IF
        XNEXT

        Stk$[2] = SPC$ + Stk$[2] + SPC$
        IF iMatchNQ (" raw , local , dynamic , register , static , shared , auto ", Stk$[2]) THEN
            Stk$[1] = Stk$[1] + Stk$[2]
            Stk$[2] = ""
        END IF
        INCR SrcCnt
        j = 0
        FOR i = 1 TO Ndx
            IF *Stk$[i] = ASC("(") THEN INCR j
            IF *Stk$[i] = ASC("{") THEN INCR j
            IF *Stk$[i] = ASC(")") THEN DECR j
            IF *Stk$[i] = ASC("}") THEN DECR j
            IF *Stk$[i] = ASC(",") AND NOT j THEN
                Stk$[i]  = Stk$[1]
                INCR SrcCnt
            END IF

            IF SrcCnt = cMaxSingleLineIFLines THEN
                CALL Abort("Single line conversion to multi-line exceeds limit.")
            END IF

            SrcStk$[SrcCnt] = SrcStk$[SrcCnt] + Stk$[i] + SPC$
        NEXT
        GOTO ProcessNew
    END IF
    IF InDialogEvt OR ModDialogEvt THEN
        IF iMatchNQ(Arg$, "WM_INITDIALOG") THEN
            CALL AddExpressionToStack(Arg$)
            CALL AddExpressionToStack("SetDialogScale(hWnd,0)")
            GOTO ProcessNew
        END IF
    END IF

    SELECT CASE TRUE

        '******************************
        CASE iMatchLft(Arg$, "on ")     ' on expression gosub | goto | call  label1,label2,Sub...
        '******************************
        DIM RAW Target = 0
        j = 0
        CALL FastLexer(Arg$, SPC$, ",")

        FOR i = 1 TO Ndx
            IF iMatchLft(Stk$[i], "gosub") OR _
                iMatchLft(Stk$[i], "goto") OR _
                iMatchLft(Stk$[i], "call") THEN
                Target = i+1
                EXIT FOR
            END IF
        NEXT

        IF Target = 0 THEN
            CALL Abort("Malformed ON/GOSUB,GOTO,CALL.")
        END IF

        CALL AddExpressionToStack("select case ")        ' Assemble our expression
        FOR i = 2 TO Target - 2
            SrcStk$[SrcCnt] = SrcStk$[SrcCnt] + SPC$ + Stk$[i]
        NEXT

        FOR i = Target TO Ndx
            IF *Stk$[i] = ASC(",") THEN ITERATE
            INCR j
            CALL AddExpressionToStack("case" + STR$(j))
            CALL AddExpressionToStack(Stk$[Target-1] + SPC$ + Stk$[i])
        NEXT
        CALL AddExpressionToStack("end select")

        GOTO ProcessNew

        '******************************
        CASE iMatchLft(Arg$, "loop ")
        '******************************
        CALL FastLexer(Arg$, SPC$, ",()")

        IF iMatchLft(Stk$[2], "until") THEN
            CALL AddExpressionToStack("if ")
            FOR i = 3 TO Ndx
                SrcStk$[SrcCnt] = SrcStk$[SrcCnt] + Stk$[i] + SPC$
            NEXT
            SrcStk$[SrcCnt] = SrcStk$[SrcCnt] + " then"
            CALL AddExpressionToStack("exit do")
            CALL AddExpressionToStack("end if")
            CALL AddExpressionToStack("loop")
            iLoopCond = 1
            GOTO ProcessNew

        ELSEIF iMatchLft(Stk$[2], "while") THEN
            CALL AddExpressionToStack("if NOT (")
            FOR i = 3 TO Ndx
                SrcStk$[SrcCnt] = SrcStk$[SrcCnt] + Stk$[i] + SPC$
            NEXT
            SrcStk$[SrcCnt] = SrcStk$[SrcCnt] + ") then"
            CALL AddExpressionToStack("exit do")
            CALL AddExpressionToStack("end if")
            CALL AddExpressionToStack("loop")
            iLoopCond = 1
            GOTO ProcessNew
        ELSE
            IF Ndx > 1 THEN
                Abort("UNKNOWN Word " + Stk$[2] + " After LOOP")
            END IF
        END IF

        '******************************
        CASE iMatchLft(Arg$, "do ")
        '******************************
        CALL FastLexer(Arg$, SPC$, ",()")

        IF iMatchLft(Stk$[2], "until") THEN
            CALL AddExpressionToStack("do")
            CALL AddExpressionToStack("if ")
            FOR i = 3 TO Ndx
                SrcStk$[SrcCnt] = SrcStk$[SrcCnt] + Stk$[i] + SPC$
            NEXT
            SrcStk$[SrcCnt] = SrcStk$[SrcCnt] + "then"
            CALL AddExpressionToStack("exit do")
            CALL AddExpressionToStack("end if")
            iDoWhile = lt_DOUNTILLOOP
            GOTO ProcessNew
        ELSEIF iMatchLft(Stk$[2], "while") THEN
            CALL AddExpressionToStack("while ")
            iDoWhile = lt_DOWHILELOOP
            FOR i = 3 TO Ndx
                SrcStk$[SrcCnt] = SrcStk$[SrcCnt] + Stk$[i] + SPC$
            NEXT
            GOTO ProcessNew
        ELSE
            IF Ndx > 1 THEN
                Abort("UNKNOWN Word " + Stk$[2] + " After DO")
            END IF
        END IF
    END SELECT

    RETURN FALSE

    ProcessNew:

    Ndx = iSrcStkIndex = 0
    DO WHILE SrcCnt
        Arg$ = SrcStk$[++iSrcStkIndex]
        SrcStk$[iSrcStkIndex] = ""
        DECR SrcCnt
        PassOne = TRUE
        CALL XParse(Arg$)
        PassOne = FALSE
        CALL FixUps
        IF Ndx THEN CALL Emit_Main
    LOOP
    RETURN TRUE
END FUNCTION ' SpecialCaseHandler




SUB FastLexer (Arg$ AS LPCTSTR, delim1$ AS LPCTSTR, delim2$ AS LPCTSTR, TokQuote = 1)
    '**********************************************************************************
    ' delim1$ = delimiters to remove
    ' delim2$ = delimiters to keep
    '
    ' When TokQuote = 1: Quoted strings are treated as individual tokens.
    ' Each quoted string is processed separately, terminated, and stored
    ' in the token stack as a distinct token.
    '
    ' When TokQuote = 0: Quoted strings are not treated as separate tokens.
    ' They are included as part of larger tokens, potentially concatenated
    ' with other characters outside the quotes.
    '
    ' Stk$[] and Ndx are GLOBAL
    ' As long as Ndx is honored, Stk$[] does not need to be initialized
    '**********************************************************************************
    DIM RAW pd1 AS PCHAR
    DIM RAW pd2 AS PCHAR
    DIM RAW cnt1, cnt2
    cnt1 = cnt2 = 0
    Ndx  = 1

    DO WHILE Arg[cnt1]

        IF Arg[cnt1] = c_DblQt THEN    ' quotes - string literals

            IF cnt2 AND TokQuote THEN
                Stk[Ndx++][cnt2] = 0
                cnt2 = 0
            END IF

            Stk[Ndx][cnt2] = c_DblQt

            DO WHILE Arg[++cnt1] <> c_DblQt
                Stk[Ndx][++cnt2] = Arg[cnt1]
                IF Arg[cnt1] = 0 THEN EXIT SUB
            LOOP

            Stk[Ndx][++cnt2] = Arg[cnt1]

            IF TokQuote THEN
                Stk[Ndx++][++cnt2] = 0
                cnt2 = 0
                GOTO again
            END IF

        END IF

        pd1 = CAST(PCHAR, delim1)

        DO WHILE *pd1
            IF *(pd1++) = Arg[cnt1] THEN
                IF cnt2 THEN
                    Stk[Ndx++][cnt2] = 0
                    cnt2 = 0
                END IF
                GOTO again
            END IF
        LOOP

        pd2 = CAST(PCHAR, delim2)

        DO WHILE *pd2
            IF *(pd2++) = Arg[cnt1] THEN
                IF cnt2 THEN Stk[Ndx++][cnt2] = 0
                Stk[Ndx][0] = Arg[cnt1]
                Stk[Ndx++][1] = 0
                cnt2 = 0
                GOTO again
            END IF
        LOOP

        Stk[Ndx][cnt2++] = Arg[cnt1]

        again:

        INCR cnt1
    LOOP
    Stk[Ndx][cnt2] = 0
    IF cnt2 = 0 THEN DECR Ndx
END SUB ' FastLexer



SUB InsertTokens(PosAfter, NumTokens, ...)
    DIM RAW ap AS va_list, i
    FOR i = Ndx TO PosAfter + 1 STEP -1
        Stk$[i + NumTokens] = Stk$[i]
    NEXT

    va_start(ap, NumTokens)
    FOR i = PosAfter + 1 TO PosAfter+NumTokens
        Stk$[i] = va_arg(ap, CHAR*)
    NEXT
    va_end(ap)
    INCR Ndx, NumTokens
    Stk$[Ndx + 1] = ""
END SUB ' InsertTokens



SUB AppendTokens(NumTokens, ...)
    DIM RAW ap AS va_list
    va_start(ap, NumTokens)
    FOR INT i = Ndx + 1 TO Ndx+NumTokens
        Stk$[i] = va_arg(ap, CHAR*)
    NEXT
    va_end(ap)
    INCR Ndx, NumTokens
    Stk$[Ndx + 1] = ""
END SUB ' AppendTokens



SUB Emit_ExportDef(fs$)
    DIM STATIC BeenHere
    DIM STATIC fname$, Private_FunctionName$
    DIM RAW i, st = 1, sz = 0
    fname$ = EXTRACT$(FileIn$, ".") + ".def"

    IF NOT BeenHere THEN
        OPEN fname$ FOR OUTPUT AS FPDEF
        _splitpath(FileIn$, NULL, NULL, fname$, NULL)
        FPRINT FPDEF, "LIBRARY ", ENC$(fname$)
        FPRINT FPDEF, "EXPORTS"
        BeenHere = TRUE
    END IF

    FastLexer(fs$, "", "(,)")

    DO WHILE *Stk$[st] <> ASC("(")
        INCR st
    LOOP

    FOR i = st+1 TO Ndx
        IF *Stk$[i] = ASC(")") THEN EXIT FOR
        IF *Stk$[i] <> ASC(",") THEN
            IF INCHR(Stk$[i], "*") THEN
                INCR sz, 4
                ITERATE
            END IF

            IF iMatchNQ(Stk$[i], "longlong") OR _
                iMatchNQ(Stk$[i], "double")   OR _
                iMatchNQ(Stk$[i], "long long") THEN
                INCR sz, 8
                ITERATE
            END IF
            IF NOT INCHR(Stk$[i], "void") THEN INCR sz, 4
        END IF
    NEXT
    Stk$[1] = TRIM$(Stk$[1])
    Private_FunctionName$ = MID$(Stk$[1], INSTRREV(Stk$[1], SPC$) + 1)
    FPRINT FPDEF, Private_FunctionName$, " = _", Private_FunctionName$, "@", LTRIM$(STR$(sz))
END SUB ' Emit_ExportDef




FUNCTION GetArg$(ArgNum, fp AS FUNCPARSE PTR)
    '*********************************************************************************************
    ' This function retrieves the argument at the specified index from a FUNCPARSE structure.
    ' Parameters:
    '   - ArgNum: The index of the argument to retrieve.
    '   - fp: Pointer to a FUNCPARSE structure containing information about the function.
    ' Returns:
    '   - The argument retrieved from the FUNCPARSE structure.
    '*********************************************************************************************
    DIM RAW RetArg$  = ""
    DIM RAW ArgEnd   = fp->CommaPos[ArgNum] - 1
    DIM RAW ArgStart = fp->CommaPos[ArgNum - 1] + 1

    IF ArgNum >= fp->NumArgs THEN ArgEnd = Ndx

    FOR INT i = ArgStart TO ArgEnd
        RetArg$ += Stk$[i]
    NEXT

    RETURN RetArg$
END FUNCTION ' GetArg



FUNCTION SepFuncArgs(Strt, fp AS FUNCPARSE PTR, functionflag AS INTEGER)
    '***************************************************************************************
    ' This function parses the function arguments from a given starting position (Strt)
    ' in the Stk$ array.  It identifies and counts the number of arguments, considering
    ' nested parentheses and brackets. The function updates the FUNCPARSE structure (fp)
    ' with the positions of the arguments commas and returns the number of arguments.
    '***************************************************************************************
    DIM RAW CountR = 0   ' () [] counter
    DIM RAW i = Strt     ' loop counter

    IF functionflag THEN
        DO WHILE i <= Ndx
            IF *Stk$[i] = ASC("(") THEN EXIT DO
            INCR i
        LOOP
        Strt = i + 1

        fp->NumArgs = 0 ' comma counter
        fp->CommaPos[0] = i ' Strt-1
        IF Strt > Ndx THEN
            RETURN 0
        END IF
    ELSE
        Strt = 2
        fp->CommaPos[0] = 1
    END IF

    IF *Stk$[Strt] = ASC(")") THEN
        fp->CommaPos[1] = Strt
        RETURN 0
    END IF
    fp->NumArgs = 1

    FOR i = Strt TO Ndx
        IF *Stk$[i] = ASC("(") OR *Stk$[i] = ASC("[") THEN
            INCR CountR
        ELSEIF *Stk$[i] = ASC(")") OR *Stk$[i] = ASC("]") THEN
            IF CountR = 0 THEN
                fp->CommaPos[fp->NumArgs] = i
                EXIT FOR
            END IF
            DECR CountR
        ELSEIF *Stk$[i] = ASC(",") AND CountR = 0 THEN
            fp->CommaPos[fp->NumArgs] = i
            INCR fp->NumArgs

            IF fp->NumArgs = cCommaPos THEN
                CALL Abort("Number of arguments exceeds 127")
            END IF

        END IF
    NEXT
    IF functionflag = 0 THEN fp->CommaPos[fp->NumArgs] = Ndx

    RETURN fp->NumArgs ' Number of commas + 1 = Number of arguments
END FUNCTION ' SepFuncArgs



FUNCTION MakeDecProto (fp AS FUNCPARSE PTR, iStart = 2 AS INT, iEnd = Ndx AS INT, iNoTypeDef = FALSE AS INT) AS PSTR
    '*************************************************************************
    '                    This is a recursive function
    '*************************************************************************
    ' This function generates a C-style FUNCTION DECLARATION PROTOTYPE string
    ' based on the parsed function information.  It constructs the prototype
    ' string by determining the return type, calling convention, and argument
    ' types, including handling pointers and default values.  The function
    ' supports C++ method declarations, typedefs, and function pointers,
    ' updating a static string to hold the resulting prototype.
    '*************************************************************************
    LOCAL OptFlag
    LOCAL pointer

    DIM STATIC Proto$      ' Must remain static
    DIM STATIC SubFunPtr   ' Must remain static
    DIM STATIC FunType$    ' Must remain static

    DIM RAW i, ii
    DIM RAW AsType$
    DIM RAW OptValue$
    DIM RAW AsArrys$
    DIM RAW FoundAs
    DIM RAW fpp AS FUNCPARSE
    CLEAR(fpp)

    IF SubFunPtr THEN GOTO argparse

    Proto$   = ""
    FunType$ = ""
    ' ------------------------
    ' Determine function type
    ' ------------------------
    ' constructor/destructor
    IF Ctor_Dtor_Detected(1) THEN
        FunType$ = ""
    ELSE
        IF iMatchWrd(Stk$[iStart], "sub") THEN
            FunType$ = "void"
        ELSEIF *Stk$[iEnd] = ASC(")") THEN
            ' check for type identifier suffix   ( aka, sigil )
            ' if unknown, then integer will default
            FunType$ = VarTypeLookup$[ INCHR(VARTYPES$, RIGHT$(Stk$[iStart+1], 1)) ]
        ELSE
            FOR i = iEnd TO fp->CommaPos[fp->NumArgs]+1 STEP -1
                IF iMatchWrd(Stk$[i], "ptr") OR *Stk$[i] = ASC("*") THEN
                    INCR pointer
                ELSEIF iMatchWrd(Stk$[i], "as") THEN
                    EXIT FOR
                ELSE
                    IF Stk$[i] <> "" THEN FunType$ = Stk$[i] + SPC$ + FunType$
                END IF
            NEXT
            FunType$ = TRIM$(FunType$)
        END IF
    END IF

    IF ISNULL(FunType$) THEN
        Proto$ = Stk$[iStart] + "("
    ELSE
        IF InTypeDef THEN
            DIM RAW L_Var$
            DIM RAW w
            DIM RAW id
            DIM RAW vt

            Proto$ = FunType$ + SPACE$(2) + STRING$(pointer, ASC("*")) + " ("
            Proto$ = Proto$ + CallType$ + "*" + Clean$(Stk$[iStart+1]) + ")("

            L_Var$ = FunType$ + STRING$(pointer, ASC("*"))
            GetTypeInfo(L_Var$, ADDRESSOF(w), ADDRESSOF(id), ADDRESSOF(vt))
            AddTypedefElement(BaseTypeDefsCnt[InTypeDef], vt, Clean$(Stk$[iStart+1]), FunType$)
        ELSEIF SFPOINTER THEN
            IF iNoTypeDef THEN
                Proto$ = FunType$ + " (" + CallType$ + "*" + Clean$(Stk$[iStart+1]) + ")("
            ELSE
                Proto$ = "typedef " + FunType$ + " (" + CallType$
                Proto$ += "*" + Clean$(Stk$[iStart+1]) + "_TYPE)("
            END IF
        ELSEIF NOT NoTypeDeclare AND NOT InClass AND NOT InCppTypeDef THEN
            Proto$ = "typedef " + FunType$ + " (" + CallType$
            Proto$ += "*BCXFPROT" + LTRIM$(STR$(DllCnt)) + ")("
        ELSE
            IF UseCProto OR InClass OR InCppTypeDef THEN
                UseCProto = FALSE
                Proto$ = FunType$ + SPC$ + STRING$(pointer, ASC("*")) + SPC$
                Proto$ += CallType$ + Clean$(Stk$[iStart+1]) + "("
            ELSE
                Proto$ = "C_IMPORT " + FunType$ + SPACE$(2) + STRING$(pointer, ASC("*"))
                Proto$ += SPC$ + CallType$ + Clean$(Stk$[iStart+1]) + "("
                UseImportExport = TRUE
            END IF
        END IF
    END IF

    ' -----------------------------------------------------
    argparse:
    ' -----------------------------------------------------
    ' Determine argument types
    ' -----------------------------------------------------
    IF fp->NumArgs = 0 THEN
        IF FunType$ <> ""  THEN
            Proto$ += "void)"
        ELSE
            Proto$ += ")"
        END IF
    ELSE
        FOR ii = 0 TO fp->NumArgs - 1

            OptValue$ = ""
            AsType$   = ""
            AsArrys$  = ""
            pointer   = 0
            FoundAs   = 0

            DIM RAW FirstToken  = fp->CommaPos[ii] + 1
            DIM RAW LastToken   = fp->CommaPos[ii+1] - 1
            DIM RAW NumOfTokens = (LastToken - FirstToken) + 1

            i = INCHR(Stk$[FirstToken], "[")
            IF i THEN
                AsArrys$ = MID$(Stk$[FirstToken], i)
                Stk[FirstToken][i-1] = 0
            END IF

            IF NumOfTokens = 1 THEN
                ' --------------------------------------------------------
                ' The bracket handling should be handled better.
                ' currently using the preprocessing of FunSubDecs1
                ' which converts A![] to *A! and A$[] to *A$[][2048]
                ' and A[] as xxx to A as xxx*
                ' --------------------------------------------------------
                AsType$ = VarTypeLookup$[ INCHR(VARTYPES$, RIGHT$(Stk$[FirstToken], 1)) ]
                IF *AsArrys$ THEN
                    REMOVE "*" FROM AsType$
                ELSE
                    pointer = TALLY(Stk$[FirstToken], "*")
                END IF
                ' --------------------------------------------------------
                FoundAs = TRUE
            ELSE

                FOR i = LastToken TO FirstToken STEP -1
                    IF iMatchWrd(Stk$[i], "ptr") OR *Stk$[i] = ASC("*") THEN
                        INCR pointer

                    ELSEIF iMatchWrd(Stk$[i], "sub") THEN
                        SepFuncArgs(fp->CommaPos[ii]+2, ADDRESSOF(fpp), TRUE)
                        Proto$ += "void (*)("
                        SubFunPtr = FoundAs = TRUE
                        MakeDecProto(ADDRESSOF(fpp))
                        SubFunPtr = FALSE
                        EXIT FOR

                    ELSEIF iMatchWrd(Stk$[i], "function") THEN
                        SepFuncArgs(fp->CommaPos[ii]+2, ADDRESSOF(fpp), TRUE)
                        IF ISNULL(AsType$) THEN
                            AsType$ = VarTypeLookup$[ INCHR(VARTYPES$, RIGHT$(Stk$[FirstToken], 1)) ]
                        END IF
                        Proto$ += RTRIM$(AsType$) + STRING$(pointer, ASC("*")) + " (*)("
                        pointer = 0
                        AsType$ = ""
                        SubFunPtr = FoundAs = TRUE
                        MakeDecProto(ADDRESSOF(fpp))
                        SubFunPtr = FALSE
                        EXIT FOR

                    ELSEIF iMatchWrd(Stk$[i], "as") THEN

                        IF ISNULL(AsType$) THEN
                            CALL Abort("No type specified for argument" + STR$(ii+1))
                        END IF

                        FoundAs = TRUE
                        EXIT FOR

                    ELSEIF *Stk$[i] = ASC("=") THEN
                        OptFlag = FoundAs = TRUE
                        OptValue$ = " =" + AsType$
                        AsType$ = ""
                        IF i = FirstToken + 1 THEN
                            AsType$ = VarTypeLookup$[ INCHR(VARTYPES$, RIGHT$(Stk$[FirstToken], 1)) ]
                            IF *AsArrys$ THEN
                                REMOVE "*" FROM AsType$
                            ELSE
                                pointer = TALLY(Stk$[FirstToken], "*")
                            END IF
                            EXIT FOR
                        END IF
                    ELSE
                        IF *Stk$[i] <> ASC(".") THEN
                            AsType$ = Stk$[i] + SPC$ + AsType$
                        ELSE
                            IF *Stk$[i-1] = ASC(".") THEN

                                IF OptFlag THEN
                                    CALL Abort("Default value not allowed when using variable arguments")
                                END IF

                                IF ii <> (fp->NumArgs-1) THEN
                                    CALL Abort("Variable argument must be the last parameter")
                                END IF

                                IF fp->NumArgs = 1 THEN
                                    CALL Abort("Variable argument must be preceded by at least one other parameter")
                                END IF

                                FoundAs = TRUE
                            END IF
                            AsType$ = Stk$[i] + AsType$
                        END IF
                    END IF
                NEXT i
            END IF

            IF NOT FoundAs THEN
                CALL Abort("Malformed argument type in parameter" + STR$(ii + 1))
            END IF

            IF ii <> fp->NumArgs AND OptFlag AND ISNULL(OptValue$) THEN
                CALL Warning("No default value specified for parameter" + STR$(ii + 1), 1)
            END IF

            Proto$ += RTRIM$(AsType$) + AsArrys$ + STRING$(pointer, ASC("*")) + OptValue$ + Stk$[fp->CommaPos[ii+1]]
        NEXT ii
        ' -----------------------------------------------------
    END IF

    RETURN Proto
END SUB ' MakeDecProto



SUB AsmUnknownStructs(CompArrays)
    '*****************************************************************************
    ' This SUB processes and assembles incomplete array and structure declarations
    ' in a tokenized code string. It concatenates array declarations split across
    ' multiple tokens and handles unknown struct member accesses by merging them
    ' into a single token.  The SUB ensures that the processed tokens are cleaned
    ' up and any empty tokens are removed.
    '*****************************************************************************
    DIM InBrace, InStruct, i
    DIM LTmp$

    FOR i = 2 TO Ndx
        ' --------------------------------
        ' Complete arrays
        ' --------------------------------
        IF CompArrays THEN
            IF *Stk$[i] = ASC("[") THEN
                LTmp$ = Stk$[i-1]
                Stk$[i-1] = ""
                DO
                    LTmp$ += Stk$[i]
                    IF *Stk$[i] = ASC("]") THEN DECR InBrace
                    IF *Stk$[i] = ASC("[") THEN INCR InBrace
                    Stk$[i] = ""
                    INCR i
                LOOP WHILE InBrace > 0 AND i <= Ndx
                Stk$[--i] = LTmp$
            END IF
        END IF
        ' --------------------------------
        ' Complete unknown struct members
        ' --------------------------------
        IF LEN(Stk$[i]) > 1 AND NOT IsDecimalNumber(Stk$[i]+1) THEN
            IF *Stk$[i] = ASC(".") OR iMatchLft(Stk$[i], "->") THEN
                IF InStruct = 0 THEN
                    Stk$[i] = Stk$[i-1] + Stk$[i]
                    Stk$[i-1] = ""
                    InStruct = i
                ELSE
                    Stk$[InStruct] += Stk$[i]
                    Stk$[i] = ""
                END IF
                ITERATE
            END IF
        END IF

        IF NOTNULL(Stk$[i]) AND InStruct THEN
            InStruct = 0
        END IF
    NEXT

    CALL RemEmptyTokens
END SUB ' AsmUnknownStructs



SUB CheckForASC
    '**************************************************************************
    ' This SUB scans a list of tokens for the "ASC()" function, processes each
    ' occurrence by calling Process_ASC_Function, and removes any empty tokens.
    '**************************************************************************
    DIM RAW Tmp
    DIM RAW iEmp
    iEmp = 0
    FOR Tmp = 1 TO Ndx
        IF iMatchWrd(Stk$[Tmp], "asc") THEN
            iEmp = 1
            CALL Process_ASC_Function (Tmp)
        END IF
    NEXT
    IF iEmp THEN CALL RemEmptyTokens
END SUB ' CheckForASC




SUB Make_Stricmp_Map
    '******************************************************************
    ' This supports the BCX 757 "??" operator (case-insensitivity)
    ' For each IF statement, BCX will emit one or more strcmp calls.
    ' This sub helps identify which of those needs to be changed to
    ' bcx_stricmp.  It does that by building a map of which strcmp
    ' is affected by the ?? operator.  The map will contain values
    ' 1 (insensitive) or 2 (normal) that are used in: SUB Emit_IfCond
    '*******************************************************************
    GLOBAL  MSMap[128]  ' 128 strcmp/bcx_stricmp's per IF statement
    DIM RAW MSM_Ndx     ' seems unlikely to ever be exceeded
    DIM RAW i

    MSM_Ndx = 0         '
    FOR i = 0 TO 127    ' zero things out each invocation
        MSMap[i] = 0     '
    NEXT

    ' -------------------------------------------------------------------
    ' We need to filter string arrays undergoing byte-level comparisons
    ' so that "strcmp" is not erroneously emitted.  This was insanely
    ' tricky to sort out and it will probably fail in some scenarios.
    ' -------------------------------------------------------------------

    FOR i = 2 TO Ndx
        IF RIGHTSTR(Stk$[i], "$") = FALSE THEN
            IF Im_Multi_Dim_StrVar (Stk$[i]) THEN  ' Found a multi-dim Var$ .. ex: "Dict[10,10]"
                Stk$[i] += "$"                     ' Convert Dict[10,10] into Dict$[10,10]
            END IF
        END IF
    NEXT

    DIM szExamine$
    FOR i = 2 TO Ndx
        szExamine$ += SPC$ + Stk$[i]
    NEXT

    FOR i = 2 TO Ndx                              ' This is an ugly hack that works on BC.Bas
        IF Im_Single_Dim_StrVar (Stk$[i]) AND TALLY(szExamine$, "[") > 0 THEN
            REMOVE "$" FROM Stk$[i]
        END IF
    NEXT


    FOR i = 1 TO Ndx
        IF (*Stk$[i] = ASC("?") AND *Stk$[i+1] = ASC("?") AND *Stk$[i+2] = ASC("=")) OR _
            (*Stk$[i] = ASC("=") AND *Stk$[i+1] = ASC("?") AND *Stk$[i+2] = ASC("?")) OR _
            (*Stk$[i] = ASC("?") AND *Stk$[i+1] = ASC("=") AND *Stk$[i+2] = ASC("?")) THEN
            CALL Abort("Combining string operators '?' and '=' is ambiguous")
        END IF
    NEXT

    FOR i = 1 TO Ndx
        IF *Stk$[i] = ASC("=") AND *Stk$[i+1] = ASC("=") THEN
            Stk$[i] = "=="
            LShiftStk (i+1)
        END IF
    NEXT

    FOR i = 1 TO Ndx
        IF *Stk$[i] = ASC("?") AND *Stk$[i+1] = ASC("?") THEN
            Stk$[i] = "??"
            LShiftStk (i+1)
        END IF
    NEXT

    FOR i = 1 TO Ndx
        IF (*Stk$[i] = ASC("<")  AND  Stk$[i+1] = "??" AND *Stk$[i+2] = ASC(">"))  OR _
            (*Stk$[i] =  ASC("<") AND *Stk$[i+1] = ASC(">") AND  Stk$[i+2] = "??")  OR _
            (*Stk$[i] =  ASC(">") AND  Stk$[i+1] = "??" AND *Stk$[i+2] = ASC("<"))  THEN
            Stk$[i] = "!??"
            LShiftStk (i+1)
            LShiftStk (i+1)
        END IF
    NEXT

    FOR i = 1 TO Ndx
        IF (*Stk$[i] = ASC("!") AND Stk$[i+1] = "??") OR (Stk$[i] = "??" AND *Stk$[i+1] = ASC("!")) THEN
            Stk$[i] = "!??"
            LShiftStk (i+1)
        END IF
    NEXT

    FOR i = 1 TO Ndx
        IF (Stk$[i] = "??" AND *Stk$[i+1] = ASC(">")) OR (*Stk$[i] = ASC(">") AND Stk$[i+1] = "??") THEN
            Stk$[i] = ">??"
            LShiftStk (i+1)
        END IF
    NEXT

    FOR i = 1 TO Ndx
        IF (Stk$[i] = "??" AND *Stk$[i+1] = ASC("<")) OR (*Stk$[i] = ASC("<") AND Stk$[i+1] = "??") THEN
            Stk$[i] = "<??"
            LShiftStk (i+1)
        END IF
    NEXT

    FOR i = 1 TO Ndx
        IF (*Stk$[i] = ASC("<") AND *Stk$[i+1] = ASC("=")) OR (*Stk$[i] = ASC("=") AND *Stk$[i+1] = ASC("<")) THEN
            Stk$[i] = "<="
            LShiftStk (i+1)
        END IF
    NEXT

    FOR i = 1 TO Ndx
        IF (*Stk$[i] = ASC(">") AND *Stk$[i+1] = ASC("=")) OR (*Stk$[i] = ASC("=") AND *Stk$[i+1] = ASC(">")) THEN
            Stk$[i] = ">="
            LShiftStk (i+1)
        END IF
    NEXT

    FOR i = 1 TO Ndx
        IF (*Stk$[i] = ASC("!") AND *Stk$[i+1] = ASC("=")) THEN
            Stk$[i] = "!="
            LShiftStk (i+1)
        END IF
    NEXT

    '*******************************************************************************
    '                        Here is where we build the map
    '                        One "IF" statement at a time
    '*******************************************************************************

    FOR i = 1 TO Ndx
        SELECT CASE Stk$[i]

            CASE "??"
            Stk$[i] = "="
            MSMap [++MSM_Ndx] = 1   ' SUB Emit_IfCond will emit bcx_stricmp's

            CASE "<??"
            Stk$[i] = "<"
            MSMap [++MSM_Ndx] = 1   '                 Ditto

            CASE ">??"
            Stk$[i] = ">"
            MSMap [++MSM_Ndx] = 1   '                 Ditto

            CASE "!??"
            Stk$[i] = "!="
            MSMap [++MSM_Ndx] = 1   '                 Ditto

            CASE "=", "<", ">", "<=", ">=", "!=", "!"
            MSMap [++MSM_Ndx] = 2                      ' SUB Emit_IfCond will RETAIN the strcmp's

        END SELECT
    NEXT
END SUB


FUNCTION Im_A_String_Var(A$)
    DIM RAW idx
    IF CheckLocal  (A$, ADDRESSOF(idx)) = vt_SCHAR  THEN RETURN TRUE
    IF CheckLocal  (A$, ADDRESSOF(idx)) = vt_CHAR   THEN RETURN TRUE
    IF CheckGlobal (A$, ADDRESSOF(idx)) = vt_CHAR   THEN RETURN TRUE
    IF CheckGlobal (A$, ADDRESSOF(idx)) = vt_SCHAR  THEN RETURN TRUE
    IF CheckLocal  (A$, ADDRESSOF(idx)) = vt_STRVAR THEN RETURN TRUE
    IF CheckGlobal (A$, ADDRESSOF(idx)) = vt_STRVAR THEN RETURN TRUE
    RETURN FALSE
END FUNCTION



SUB Emit_IfCond (CondType$, iOutputMethod, ArgOut = "" AS LPCTSTR)
    '*************************************************************************************
    ' Speedup/Optimize for statements like --->  if a$    = ""  THEN
    '               AND                    --->  if a$[1] = ""  THEN
    '               AND                    --->  while x = ASC("x")
    '*************************************************************************************
    DIM IsWhile
    DIM RAW A, B, TestString, ParCnt, Tmp
    DIM RAW szTest$
    DIM RAW szOut$
    '*************************************************************************************
    ' The code below allows a char[] array to be treated like a STRVAR in an IF statement.
    '*************************************************************************************
    IF Im_A_String_Var (Stk$[2]) THEN
        DIM ii
        IF *Stk$[3] <> ASC("[") THEN ii = TRUE
        IF ii = TRUE AND INCHR(Stk$[2], "$") = FALSE THEN
            Stk$[2] += "$"
        END IF
    END IF
    '*************************************************************************************
    szOut$ = ArgOut$

    CALL CheckForASC

    IF iOutputMethod = eStringPart OR iOutputMethod = eStringFull THEN szOut$ = ""

    TestString = DataType(Stk$[2])
    IF TestString = vt_STRVAR OR TestString = vt_CHAR OR TestString = vt_SCHAR THEN
        IF Stk$[4] = DDQ$ THEN
            Stk$[2] = Clean$(Stk$[2]) + "[0]"
            Stk$[4] = "0"
        ELSE
            IF Stk$[3] = "[" AND Stk$[7] = DDQ$ THEN
                Stk$[2] = "*" + Clean$(Stk$[2])
                Stk$[7] = "0"
            END IF
        END IF
    END IF

    IF CondType$ = "while" THEN IsWhile = TRUE

    '********************   If Handler, ElseIf Handler, & While Handler   *********************
    '
    '   At this stage, an IF statement has been lexed and is ready to be parsed from Stk$[]
    '******************************************************************************************
    IF_Stmt_Buffer$ = ""               ' GLOBAL 1MB string
    CALL  Make_Stricmp_Map
    '******************************************************************************************

    IF iOutputMethod = eFull THEN
        IF_Stmt_Buffer$ = Scoot$ + CondType$ + "("
    END IF

    IF iOutputMethod = eStringFull THEN
        szOut$ = CondType$ + "("
    END IF

    Tmp = 2
    DO WHILE Stk$[Tmp] = "(" OR Stk$[Tmp] = "!"  ' <<-- DO NOT OPTIMIZE THIS LINE WITH POINTERS - MrBcx
        IF iOutputMethod = ePart OR iOutputMethod = eFull THEN
            IF_Stmt_Buffer$ += Stk$[Tmp]
        ELSE
            szOut$ += Stk$[Tmp]
        END IF
        INCR Tmp
    LOOP

    TestString = FALSE

    A = DataType(Stk$[Tmp])
    IF A = vt_STRLIT OR A = vt_STRVAR THEN
        IF Stk$[Tmp + 1] <> ")" AND ISFALSE (iMatchWrd(Stk$[Tmp+1], "then")) THEN
            TestString  = TRUE
            IF iOutputMethod = ePart OR iOutputMethod = eFull THEN
                IF_Stmt_Buffer$ += "strcmp("
            ELSE
                szOut$ += Stk$[Tmp]
            END IF
        END IF
    END IF

    szTest$ = ""
    ParCnt  = 0

    DO
        IF TestString THEN
            SELECT CASE Stk$[Tmp]

                CASE "="
                Stk$[Tmp] = ","
                szTest$   = ")==0"
                ParCnt    =  0

                CASE "!="
                Stk$[Tmp] = ","
                szTest$   = ")!=0"
                ParCnt    = 0

                CASE ">"
                IF Stk$[Tmp + 1] = "=" THEN
                    Stk$[Tmp] = ","
                    szTest$   = ")>=0"
                    Stk$[Tmp + 1] = ""
                ELSE
                    Stk$[Tmp] = ","
                    szTest$   = ")==1"
                END IF
                ParCnt = 0

                CASE "<"
                IF Stk$[Tmp + 1] = "=" THEN
                    Stk$[Tmp] = ","
                    szTest$   = ")<=0"
                    Stk$[Tmp + 1] = ""
                ELSE
                    Stk$[Tmp] = ","
                    szTest$   = ")==-1"
                END IF
                ParCnt = 0

                '************************************************
                CASE ">="
                Stk$[Tmp] = ","
                szTest$   = ")>=0"
                ParCnt = 0

                CASE "<="
                Stk$[Tmp] = ","
                szTest$   = ")<=0"
                ParCnt = 0
                '************************************************

                CASE "("
                INCR ParCnt

                CASE ")"
                DECR ParCnt
            END SELECT

            IF Stk$[Tmp] = ")" AND szTest$ <> "" AND ParCnt < 0 THEN
                IF iOutputMethod = ePart OR iOutputMethod = eFull THEN
                    IF_Stmt_Buffer$ = IF_Stmt_Buffer$ +  szTest$ +  Stk$[Tmp]
                ELSE
                    szOut$ += szTest$
                    szOut$ += Stk$[Tmp]
                END IF
                szTest$ = ""
            ELSE
                IF Stk$[Tmp] = "||" OR Stk$[Tmp] = "&&" THEN
                    Stk$[Tmp] = szTest$ + SPC$ + Stk$[Tmp] + SPC$
                    szTest$ = ""
                    B = 1

                    DO WHILE Stk$[Tmp + B] = "("
                        Stk$[Tmp] += "("
                        Stk$[Tmp + B] = ""
                        INCR B
                    LOOP

                    A = DataType(Stk$[Tmp+B])      ' look ahead
                    IF (A = vt_STRLIT OR A = vt_STRVAR) AND Stk$[Tmp+B+1] <> ")" THEN
                        Stk$[Tmp] += " strcmp("
                    ELSE
                        IF iOutputMethod = ePart OR iOutputMethod = eFull THEN
                            IF_Stmt_Buffer$ += Clean$(Stk$[Tmp])
                        ELSE
                            szOut$ += Clean$(Stk$[Tmp])
                        END IF
                        TestString = FALSE
                        GOTO NxtToken
                    END IF
                END IF
                IF iOutputMethod = ePart OR iOutputMethod = eFull THEN
                    IF_Stmt_Buffer$ += Clean$(Stk$[Tmp])
                ELSE
                    szOut$ += Clean$(Stk$[Tmp])
                END IF
            END IF
        ELSE  ' Not TestString
            IF Stk$[Tmp] = "||" OR Stk$[Tmp] = "&&" THEN
                B = 1
                DO WHILE Stk$[Tmp + B] = "("
                    Stk$[Tmp] += "("
                    Stk$[Tmp + B] = ""
                    INCR B
                LOOP

                A = DataType(Stk$[Tmp+B])                ' look ahead
                IF (A = vt_STRLIT OR A = vt_STRVAR) AND Stk$[Tmp+B+1] <> ")" THEN
                    Stk$[Tmp] += " strcmp("
                    TestString  = TRUE
                    szTest$     = ""
                    ParCnt      = 0
                    IF iOutputMethod = ePart OR iOutputMethod = eFull THEN
                        IF_Stmt_Buffer$ += Clean$(Stk$[Tmp])
                    ELSE
                        szOut$ += Clean$(Stk$[Tmp])
                    END IF
                    GOTO NxtToken
                END IF
            END IF

            IF Stk$[Tmp] = "!" THEN
                IF iOutputMethod = ePart OR iOutputMethod = eFull THEN
                    IF_Stmt_Buffer$ += Stk$[Tmp]
                ELSE
                    szOut$ += Stk$[Tmp]
                END IF
            ELSE
                IF iOutputMethod = ePart OR iOutputMethod = eFull THEN
                    IF_Stmt_Buffer$ += Clean$(Stk$[Tmp])
                ELSE
                    szOut$ += Clean$(Stk$[Tmp])
                END IF
                IF NOT ispunct(*Stk$[Tmp]) THEN
                    IF Tmp < Ndx AND NOT ispunct(*Stk$[Tmp+1]) THEN
                        IF iOutputMethod = ePart OR iOutputMethod = eFull THEN
                            IF_Stmt_Buffer$ += SPC$
                        ELSE
                            szOut$ += SPC$
                        END IF
                    END IF
                END IF
            END IF
            IF Stk$[Tmp] = "=" THEN
                IF Stk$[Tmp-1] <> "<" AND Stk$[Tmp-1] <> ">" THEN
                    IF Stk$[Tmp+1] <> ">" AND Stk$[Tmp+1] <> "<" THEN
                        IF iOutputMethod = ePart OR iOutputMethod = eFull THEN
                            IF_Stmt_Buffer$ += "="
                        ELSE
                            szOut$ += "="
                        END IF
                    END IF
                END IF
            END IF
        END IF

        NxtToken:

        INCR Tmp
        IF NOT IsWhile THEN
            IF iMatchWrd(Stk$[Tmp], "then") THEN
                EXIT DO
            ELSEIF Tmp > Ndx THEN
                Abort("If Without THEN")
            END IF
        END IF
    LOOP UNTIL Tmp > Ndx


    SELECT CASE iOutputMethod
        CASE   eFull
        IF_Stmt_Buffer$ = IF_Stmt_Buffer$ +szTest$ +  ")"

        CALL BumpUp
        IF_Stmt_Buffer$ += "{"
        CALL BumpUp

        CASE ePart
        IF_Stmt_Buffer$ += szTest$

        CASE eStringPart
        szOut$ += szTest$
        CASE eStringFull
        szOut$ += szTest$
        szOut$ += ")"
    END SELECT

    '***************************************************************************************

    FastLexer(IF_Stmt_Buffer$, "", " =&()[]{}',+-*/<>?;.|:^")

    FOR INT ii = 1 TO Ndx
        IF *Stk$[ii] = ASC("=") AND *Stk$[ii+1] = ASC("=") THEN
            Stk$[ii] = "=="
            LShiftStk(ii+1)
        END IF
    NEXT

    FOR INT ii = 1 TO Ndx
        IF *Stk$[ii] = ASC(">") AND *Stk$[ii+1] = ASC("=") THEN
            Stk$[ii] = ">="
            LShiftStk(ii+1)
        END IF
    NEXT

    FOR INT ii = 1 TO Ndx
        IF Stk$[ii] = "<=" AND *Stk$[ii+1] = ASC("=") THEN
            Stk$[ii] = "<="
            LShiftStk(ii+1)
        END IF
    NEXT

    FOR INT ii = 1 TO Ndx
        IF *Stk$[ii] = ASC("!") AND *Stk$[ii+1] = ASC("=") THEN
            Stk$[ii] = "!="
            LShiftStk(ii+1)
        END IF
    NEXT

    FOR INT ii = 1 TO Ndx
        IF *Stk$[ii] = ASC("&") AND *Stk$[ii+1] = ASC("&") THEN
            Stk$[ii] = "&&"
            LShiftStk(ii+1)
        END IF
    NEXT

    FOR INT ii = 1 TO Ndx
        IF *Stk$[ii] = ASC("|") AND *Stk$[ii+1] = ASC("|") THEN
            Stk$[ii] = "||"
            LShiftStk(ii+1)
        END IF
    NEXT

    '******************
    LOCAL Map_Idx
    '******************

    FOR INT ii = 1  TO Ndx
        IF Stk$[ii] = "strcmp" THEN
            IF MSMap[++Map_Idx] = 1 THEN
                Stk$[ii] = "bcx_stricmp"
                Use_BCX_stricmp = TRUE
            END IF
        END IF
    NEXT

    IF_Stmt_Buffer$ = ""

    FOR INT ii = 1  TO Ndx
        IF_Stmt_Buffer$ += Stk$[ii]
    NEXT

    IF IgnoreStrCase = TRUE THEN
        REPLACE "strcmp" WITH "bcx_stricmp" IN IF_Stmt_Buffer$
        Use_BCX_stricmp = TRUE
    END IF

    '******************************************************************************************
    '         These replacements improve the code formatting inside the c/c++ file
    '******************************************************************************************
    REPLACE " ) {"           WITH  ") {"        IN IF_Stmt_Buffer$

    IF iMatchNQ (IF_Stmt_Buffer$, "cmp") THEN
        REPLACE "||  strcmp"  WITH  "|| strcmp"  IN IF_Stmt_Buffer$
        REPLACE "&&  strcmp"  WITH  "&& strcmp"  IN IF_Stmt_Buffer$
        REPLACE "||  stricmp" WITH  "|| stricmp" IN IF_Stmt_Buffer$
        REPLACE "&&  stricmp" WITH  "&& stricmp" IN IF_Stmt_Buffer$
        REPLACE "( strcmp"    WITH  "(strcmp"    IN IF_Stmt_Buffer$
        REPLACE "( stricmp"   WITH  "(stricmp"   IN IF_Stmt_Buffer$
    END IF

    IF ISFALSE iMatchNQ (IF_Stmt_Buffer$, " || ") THEN
        REPLACE "|| " WITH  " || " IN IF_Stmt_Buffer$
    END IF

    IF ISFALSE iMatchNQ (IF_Stmt_Buffer$, " && ") THEN
        REPLACE "&& " WITH  " && " IN IF_Stmt_Buffer$
    END IF
    '******************************************************************************************
    IF iOutputMethod = ePart THEN
        FPRINT FP_WRITE, IF_Stmt_Buffer$; ' Suppress CRLF
    ELSE
        FPRINT FP_WRITE, IF_Stmt_Buffer$
    END IF

END SUB ' Emit_IfCond




SUB PrintGlobal(FP_OUTPUT AS FILE, A, idx, Storage$, P$, VarName$, VarDim$)
    DIM RAW L_Var$
    SELECT CASE A
        ' handle exceptions
        CASE vt_FILEPTR
        REMOVE "@" FROM VarName$
        FPRINT FP_OUTPUT, Storage$, "FILE    *", P$; VarName$, VarDim$, ";"

        CASE vt_UDT, vt_STRUCT, vt_UNION
        L_Var$ = TypeDefs[GlobalVars[idx].VarDef].VarName$
        L_Var$ = RPAD$(L_Var$, PADSIZE)
        FPRINT FP_OUTPUT, Storage$, L_Var$, SPC$, P$, VarName$, VarDim$, ";"

        CASE vt_LPSTR
        FPRINT FP_OUTPUT, Storage$, "PSTR  ", P$, VarName$, VarDim$, ";"

        CASE vt_STRVAR
        IF ISNULL(VarDim$) THEN VarDim$ = "[BCXSTRSIZE]"
        FPRINT FP_OUTPUT, Storage$, "char    ", P$, VarName$, VarDim$, ";"

        ' handle normal

        CASE vt_VarMin TO vt_VarMax
        L_Var$ = GetVarTypeName$(GlobalVars[idx].VarType)
        L_Var$ = RPAD$(L_Var$, PADSIZE)
        FPRINT FP_OUTPUT, Storage$, L_Var$, SPC$, P$, VarName$, VarDim$, ";"
    END SELECT
END SUB



SUB ReDirectFPrint(TgtFile AS FILE, pat$, ...)
    ' Used primarily to bump LinesWritten
    DIM RAW ap AS va_list

    IF DoCountLines AND TgtFile = FP_W THEN
        INCR LinesWritten
    END IF

    va_start(ap, pat$)
    vfprintf(TgtFile, pat$, ap)
    va_end(ap)
END SUB



SUB InitReservedWordsLookup
    DIM MaxReservedWords AS INTEGER
    DIM sL$
    DIM iC AS INTEGER
    DIM iD AS INTEGER

    MaxReservedWords = WordsInTable(BCXWords) ' How many reserved words

    FOR iC = 0 TO 96
        iRIndex[iC][0] = MaxReservedWords-1
        iRIndex[iC][1] = 0
    NEXT

    FOR iC = 0 TO MaxReservedWords-1

        IF sL$ > BCXWords[iC].pszFunctionName$ THEN
            CALL Abort ("Error in BCXWords[], Names out of order" + _
            CRLF$ + sL$ + " comes after " + BCXWords[iC].pszFunctionName$ + _
            CRLF$ + "Correct and recompile")
        END IF

        sL$ = BCXWords[iC].pszFunctionName$

        iD = ASC(sL$)-32
        IF iD < 0 THEN iD = 0
        IF iD > 96 THEN iD = 96
        IF iRIndex[iD][0] > iC THEN iRIndex[iD][0] = iC
        IF iRIndex[iD][1] < iC THEN iRIndex[iD][1] = iC
    NEXT

    FOR iC = 0 TO 96
        IF iRIndex[iC][0] > iRIndex[iC][1] THEN iRIndex[iC][0] = iRIndex[iC][1]
        iRIndex[iC][1]++
    NEXT

    DIM RAW iChk AS INTEGER
    DIM RAW iSize AS INTEGER
    iSize = WordsInTable(tBcxWords)-2
    FOR iChk = 0 TO iSize
        IF tBcxWords[iChk].pszWord$ > tBcxWords[iChk+1].pszWord$ THEN
            CALL Abort("Error in SET tBcxWords: " + tBcxWords[iChk].pszWord$ + _
            " comes after " + tBcxWords[iChk+1].pszWord$)
        END IF
    NEXT

    iSize = WordsInTable(tTypes)-2
    FOR iChk = 0 TO iSize
        IF tTypes[iChk].pszWord$ > tTypes[iChk+1].pszWord$ THEN
            CALL Abort("Error in SET tTypes: " + tTypes[iChk].pszWord$ + _
            " comes after " + tTypes[iChk+1].pszWord$)
        END IF
    NEXT

    iSize = WordsInTable(atEmitWords)-2
    FOR iChk = 0 TO iSize
        IF atEmitWords[iChk].pszWord$ > atEmitWords[iChk+1].pszWord$ THEN
            CALL Abort("Error in SET atEmitWords: " + atEmitWords[iChk].pszWord$ + _
            " comes after " + atEmitWords[iChk+1].pszWord$)
        END IF
    NEXT

    iSize = WordsInTable(tDirectives)-2
    FOR iChk = 0 TO iSize
        IF tDirectives[iChk].pszWord$ > tDirectives[iChk+1].pszWord$ THEN
            CALL Abort("Error in SET tDirectives: " + tDirectives[iChk].pszWord$ + _
            " comes after " + tDirectives[iChk+1].pszWord$)
        END IF
    NEXT

    iSize = WordsInTable(VariantList)-3
    FOR iChk = 0 TO iSize
        IF VariantList[iChk].sNAME$ > VariantList[iChk+1].sNAME$ THEN
            CALL Abort("Error in SET VariantList: " + VariantList[iChk].sNAME$ + _
            " comes after " + VariantList[iChk+1].sNAME$)
        END IF
    NEXT

    iSize = WordsInTable(ptVCasts)-3
    FOR iChk = 0 TO iSize
        IF ptVCasts[iChk].pszCAST$ > ptVCasts[iChk+1].pszCAST$ THEN
            CALL Abort("Error in SET ptVCasts: " + ptVCasts[iChk].pszCAST$ + _
            " comes after " + ptVCasts[iChk+1].pszCAST$)
        END IF
    NEXT

    iSize = WordsInTable(ptCCasts)-3
    FOR iChk = 0 TO iSize
        IF ptCCasts[iChk].pszCAST$ > ptCCasts[iChk+1].pszCAST$ THEN
            CALL Abort("Error in SET ptCCasts: " + ptCCasts[iChk].pszCAST$ + _
            " comes after " + ptCCasts[iChk+1].pszCAST$)
        END IF
    NEXT
END SUB ' InitReservedWordsLookup




FUNCTION GetWordInfo(sWord$) AS TOKSUBFUNC PTR
    '************************************************************************
    ' This function performs a binary search on a list of BCX words to find
    ' a specific word (sWord$) and returns a pointer to the corresponding
    ' TOKSUBFUNC structure if found, or NULL if not found.
    '************************************************************************
    DIM RAW iH
    DIM RAW iL
    DIM RAW iM
    DIM RAW iV

    iM = ASC(sWord$)-32
    IF iM < 0 THEN iM = 0
    IF iM > 96 THEN iM = 96
    iL = iRIndex[iM][0]
    iH = iRIndex[iM][1]

    DO
        ' middle = low + ((high - low) / 2)
        iM = (iH + iL) SHR 1
        iV = strcmp(BCXWords[iM].pszFunctionName, sWord)
        SELECT CASE iV
            CASE -1
            IF iL <> iH THEN
                IF iL = iM THEN
                    INCR iL
                ELSE
                    iL = iM
                END IF
            END IF
            CASE 0
            RETURN ADDRESSOF(BCXWords[iM])
            CASE 1
            IF iL <> iH THEN
                iH = iM
            END IF
        END SELECT
    LOOP UNTIL iL = iH
    RETURN NULL
END FUNCTION ' GetWordInfo



FUNCTION FindWord(sWord$, tWordList AS WORDS PTR, iWordsInTable AS INTEGER) AS INTEGER
    '***************************************************************************
    ' The FindWord function searches for a word in a list of words.
    ' Parameters:
    '   - sWord$: The word to search for.
    '   - tWordList: Pointer to the list of words.
    '   - iWordsInTable: Number of words in the table.
    ' Returns:
    '   - The index of the found word in the list, or -1 if the word is not found.
    '***************************************************************************
    DIM RAW iH AS INTEGER
    DIM RAW iL AS INTEGER
    DIM RAW iM AS INTEGER
    DIM RAW iV AS INTEGER
    iL = 0
    iH = iWordsInTable ' How many reserved words
    DO WHILE iL <> iH
        iM = (iH + iL) SHR 1
        iV = strcmp(tWordList[iM].pszWord, sWord)
        SELECT CASE iV
            CASE -1
            IF iL = iM THEN RETURN (-1)
            iL = iM
            CASE 0
            RETURN iM
            CASE 1
            IF iL = iM THEN RETURN (-1)
            iH = iM
        END SELECT
    LOOP
    RETURN (-1)
END FUNCTION ' FindWord



SUB FixAnyArrays(Arg$)
    '************************************************************************
    ' This SUB processes and fixes any array definitions in the argument
    ' string (Arg$) by identifying and reformatting vector types, replacing
    ' angle brackets and commas with custom tokens. If any changes are made,
    ' it reconstructs the argument string.
    '************************************************************************
    DIM RAW iMakeNewArg AS INTEGER
    DIM RAW iAttach AS INTEGER
    iMakeNewArg = 0
    FOR INT i = 1 TO Ndx
        IF iMatchWrd(Stk$[i], "as") THEN
            INCR i
            iAttach = 0
            IF iMatchWrd(Stk$[i], "vector") THEN
                INCR i
                IF *Stk$[i] = ASC("<") THEN
                    iAttach = i-1
                END IF
            ELSE
                IF iMatchWrd(Stk$[i+1], "vector") THEN
                    INCR i, 2
                    IF *Stk$[i] = ASC("<") THEN
                        iAttach = i-1
                    END IF
                END IF
            END IF
            IF iAttach > 0 THEN
                iMakeNewArg = 1
                FOR INT j = iAttach+1 TO Ndx
                    IF Stk$[j] = "<" THEN
                        Stk$[iAttach] += CHR$(16)
                        Stk$[j] = ""
                        XFOR INT k = j+1, INTEGER iV = 1 WHILE k<= Ndx AND iV > 0 BY k++
                            SELECT CASE Stk$[k]
                                CASE ">"
                                DECR iV
                                Stk$[iAttach] += CHR$(17)
                                Stk$[k] = ""
                                CASE "<"
                                INCR iV
                                Stk$[iAttach] += CHR$(16)
                                Stk$[k] = ""
                                CASE ","
                                Stk$[iAttach] += CHR$(18)
                                Stk$[k] = ""
                                CASE ELSE
                                Stk$[iAttach] += Stk$[k]
                                Stk$[k] = ""
                            END SELECT
                        XNEXT
                    END IF
                NEXT
            END IF
        END IF
    NEXT
    IF iMakeNewArg THEN
        DIM RAW szNewArg$
        szNewArg$ = ""
        CALL RemEmptyTokens
        FOR INT i = 1 TO Ndx
            szNewArg$ += Stk$[i]
            szNewArg$ += SPC$
        NEXT
        Arg$ = szNewArg$
    END IF
END SUB ' FixAnyArrays



SUB Translate
    DIM ptW AS TOKSUBFUNC PTR
    DIM szWord$
    DIM Scratch$
    DIM iEmitID
    DIM iDoFixup

    ' Handle SET
    IF iMatchLft(Src$, "set ") THEN
        IF ComSwitchON = TRUE THEN
            IF INCHR(Src$, "=") THEN
                Use_COM = Use_BcxTempStr = TRUE
            ELSE
                CALL ProcessSetCommand(0)
                EXIT SUB
            END IF
        ELSE
            CALL ProcessSetCommand(0)
            EXIT SUB
        END IF
    END IF

    IF iMatchLft(Src$, "sharedset ") THEN
        CALL ProcessSetCommand(1)
        EXIT SUB
    END IF

    PassOne = TRUE
    CALL XParse(Src$)
    PassOne = FALSE

    IF Ndx = 0 THEN EXIT SUB

    '******************************************************************
    ' The following tests support PRINTING sigil-less user-functions
    '******************************************************************

    IF Stk$[1] ?? "FUNCTION" AND Stk$[2] <> "=" THEN

        IF Stk$[Ndx] ?? "FLOAT" AND Stk$[Ndx-1] ?? "AS" THEN
            Stk$[2] += "!"
            DECR Ndx, 2
        END IF

        IF Stk$[Ndx] ?? "SINGLE" AND Stk$[Ndx-1] ?? "AS" THEN
            Stk$[2] += "!"
            DECR Ndx, 2
        END IF

        IF Stk$[Ndx] ?? "DOUBLE" AND Stk$[Ndx-1] ?? "AS" THEN
            Stk$[2] += "#"
            DECR Ndx, 2
        END IF

        IF Stk$[Ndx] ?? "STRING" AND Stk$[Ndx-1] ?? "AS" THEN
            Stk$[2] += "$"
            DECR Ndx, 2
        END IF

    END IF

    '*************************************************************************************
    ' 775  MrBcx -- I discovered that SUB/FUNCTION arguments, declared using the ! and #
    ' sigils for single and double precisions, were being translated as integers which
    ' would result in type conflicts when attempting to compile.  This bug was introduced
    ' in BCX 650 ( circa 2010 ) and has existed ever since.  How was this never noticed?
    ' The code below seems to adequately overcome those problems.
    '*************************************************************************************
    GLOBAL TransformSigil
    LOCAL  ArgsFound

    IF UseCpp = FALSE THEN      ' This "fix" would break some C++ code
        TransformSigil = FALSE
        IF iMatchWrd(Stk$[1]    , "SUB")                             _
            OR (iMatchWrd(Stk$[1], "FUNCTION") AND Stk$[2] <> "=")   _
            OR iMatchWrd(Stk$[1], "DECLARE")                         _
            OR iMatchWrd(Stk$[1], "C_DECLARE")                       _
            OR iMatchWrd(Stk$[1], "PUBLIC")                          _
            OR iMatchWrd(Stk$[1], "PRIVATE") THEN
            FOR INT zz = 1 TO Ndx
                IF Stk$[zz] = "(" THEN ArgsFound = TRUE
                IF ArgsFound THEN
                    IF RIGHTSTR(Stk$[zz], "#")  THEN
                        REPLACE "#" WITH " AS DOUBLE " IN Stk$[zz]
                        TransformSigil = TRUE
                    END IF
                END IF
                IF ArgsFound THEN
                    IF RIGHTSTR(Stk$[zz], "!")  THEN
                        REPLACE "!" WITH " AS SINGLE " IN Stk$[zz]
                        TransformSigil = TRUE
                    END IF
                END IF
                IF ArgsFound THEN
                    IF TransformSigil THEN
                        FOR INT yy = 1 TO Ndx
                            IF Stk$[yy]  = "["  AND Stk$[zz+1] = "]" THEN
                                Stk$[yy]   = "*"
                                Stk$[yy+1] = ""
                            END IF
                        NEXT
                    END IF
                END IF
            NEXT
        END IF

        IF TransformSigil THEN
            Scratch$ = ""
            FOR INT zz = 1 TO Ndx
                Scratch$ += Stk$[zz]
                Scratch$ += SPC$
            NEXT
            REPLACE "DOUBLE  as double" WITH "DOUBLE" IN Scratch$ ' <-  BYREF causes this mess
            REPLACE "SINGLE  as single" WITH "SINGLE" IN Scratch$ ' <-  BYREF causes this mess
            CALL FastLexer(Scratch$, SPC$, "=&()[]{}',+-*/<>?;.|:^") ' Rebuild Stk$[]
        END IF
    END IF

    '********************************************************************************
    '    Try to stop users from using the word 'DATA' in ways that are not allowed.
    '********************************************************************************
    FOR INT i = 1 TO Ndx
        IF Stk$[i] ?? "data" AND Stk$[i+1] ?? "as" THEN
            CALL Abort("DATA is a reserved word ")
        END IF
    NEXT
    '********************************************************************************

    IF UseCpp OR UseCpphdr THEN CALL FixAnyArrays(Src$)

    IF ComSwitchON = TRUE THEN
        DIM RAW i, j
        XFOR i = 1, j = COM_open_WITH_statement WHILE i<= Ndx AND j = 0 BY i++
            IF IsVariableComObject(Stk$[i]) THEN j = 1
        XNEXT
        IF j THEN
            IF Find_COM_statement(Src$) = TRUE THEN EXIT SUB
        END IF
    END IF

    IF SpecialCaseHandler(Src$) THEN EXIT SUB

    iDoFixup = TRUE
    szWord$ = LCASE$(Stk$[1])
    ptW = GetWordInfo(szWord$)
    IF ptW THEN
        IF (ptW->iWordInfo BAND eWI_Directive) THEN
            iEmitID = FindWord(szWord$, tDirectives, WordsInTable(tDirectives))
            IF iEmitID <> NOTFOUND THEN
                DIM FuncRetnFlag
                IF tDirectives[iEmitID].Emitter(szWord$, ADDRESSOF(FuncRetnFlag)) = 0 THEN EXIT SUB
            END IF
        END IF
        IF (ptW->iWordInfo BAND eWI_NoFixup) THEN
            iDoFixup = FALSE
        END IF
    END IF

    IF iDoFixup THEN
        CALL FixUps
        PassOne = FALSE
    END IF

    IF Ndx THEN
        CALL Emit_Main
        IF iEmitVarGroup THEN CALL Emit_BCXVariables
    END IF
END SUB  ' Translate



SUB FixVector
    '***********************************************
    ' This SUB fixes vector declarations by joining
    ' their elements into a single string.
    '***********************************************
    DIM RAW Tmp, j, k
    FOR Tmp = 2 TO Ndx
        IF iMatchWrd(Stk$[Tmp], "as") THEN
            IF Stk$[Tmp+1] = "vector" THEN
                INCR Tmp
                k = Tmp
                j = 0
                DO
                    Stk$[k] += Stk$[++Tmp]
                    IF Stk$[Tmp] = ">" THEN INCR j
                    Stk$[Tmp] = ""
                LOOP UNTIL j
            END IF
        END IF
    NEXT
    CALL RemEmptyTokens
END SUB



SUB Emit_Main
    '******************************************************
    ' This SUB emits code for the main function, handling
    ' labels, special characters, and function returns.
    '******************************************************
    DIM RAW EmitAgain = TRUE
    DIM RAW FuncRetnFlag = 0
    DIM RAW iEmitID
    DIM RAW Lookup$

    IF HasVector THEN
        CALL FixVector
        HasVector = FALSE
    END IF

    Lookup$ = LCASE$(Stk$[1])

    IF SelectState[StateIdx].NoBreak AND NOT iMatchLft(Lookup$, "case") AND NOT iMatchWrd(Lookup$, "endselect") THEN
        SelectState[StateIdx].NoBreak = 0
    END IF

    FOR INT i = 1 TO Ndx
        IF INCHR(Stk$[i], CHR$(15)) THEN REPLACE CHR$(15) WITH ":" IN Stk$[i]
        IF INCHR(Stk$[i], CHR$(16)) THEN REPLACE CHR$(16) WITH "<" IN Stk$[i]
        IF INCHR(Stk$[i], CHR$(17)) THEN REPLACE CHR$(17) WITH ">" IN Stk$[i]
        IF INCHR(Stk$[i], CHR$(18)) THEN REPLACE CHR$(18) WITH "," IN Stk$[i]
    NEXT

    IF iMatchRgt(Stk$[1], ":") THEN    ' This Must Be A Label
        FPRINT FP_WRITE, ""
        FPRINT FP_WRITE, UCASE$(Stk$[1]), ";"
        EXIT SUB
    END IF

    DO WHILE EmitAgain AND Ndx > 0
        INCR Statements
        IF CurrentFuncType = vt_STRVAR AND (InFunction OR InCppTypeDef) AND OkayToSend THEN
            FPRINT FP_WRITE, Scoot$, "char   *BCX_RetStr={0};"
            OkayToSend = FALSE
        END IF
        Lookup$ = LCASE$(Stk$[1])
        iEmitID = FindWord(Lookup$, atEmitWords, WordsInTable(atEmitWords))
        IF iEmitID = NOTFOUND THEN
            Emit_Old(ADDRESSOF(FuncRetnFlag))
            EmitAgain = FALSE
        ELSE
            EmitAgain = atEmitWords[iEmitID].Emitter(Lookup$, ADDRESSOF(FuncRetnFlag))
        END IF
    LOOP

    IF FuncRetnFlag = 1 THEN
        IF NOTZERO (LocalDynaCnt) THEN
            FOR INT j = 1 TO LocalDynaCnt
                FPRINT FP_WRITE, Scoot$, DynaStr$[j]
            NEXT
        END IF


        '================  828 MrBcx - prevents heap leaks in LOCAL string arrays  ================
        IF AuxLocalDynArrayCount > 0 THEN
            FPRINT FP_WRITE, ""
            WHILE AuxLocalDynArrayCount > 0
                FPRINT FP_WRITE, Scoot$, AuxLocalDynArray$[AuxLocalDynArrayCount]
                AuxLocalDynArray$[AuxLocalDynArrayCount] = ""
                DECR AuxLocalDynArrayCount
            WEND
            FPRINT FP_WRITE, ""
        END IF
        '================  828 MrBcx - prevents heap leaks in LOCAL string arrays  ================



        FPRINT FP_WRITE, Scoot$, "return BCX_RetStr;"  ' $ FUNCTION Return
        '******************************************************************
    END IF
    ExitSubFunc = FALSE
    IF iMatchWrd(Stk$[1], "exit") THEN
        IF iMatchWrd(Stk$[2], "sub") OR iMatchWrd(Stk$[2], "function") THEN
            ExitSubFunc = TRUE
        END IF
    END IF
END SUB ' Emit_Main



FUNCTION Emit_FolderDriveProcs(Lookup$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    ' "chdir", "_chdir", "rmdir", "_rmdir", "mkdir", "_mkdir"
    FPRINT FP_WRITE, Scoot$, Lookup$, " ("; ' Suppress CRLF
    Stk$[++Ndx] = ");"
    CALL WriteCleanTokens(2, Ndx)
    RETURN 0
END FUNCTION ' Emit_FolderDriveProcs



FUNCTION Emit_FunctionReturn(Lookup$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(Lookup$)

    IF UseCpp = FALSE THEN
        '======================================================================================================================
        DIM LTmp$

        IF SelectState[StateIdx].CaseFlag THEN SelectState[StateIdx].NoBreak = TRUE

        FOR INT i = 1 TO Ndx
            IF LEN(Stk$[i]) > 1 AND RIGHT$(Stk$[i], 1) = "!" THEN REMOVE "!" FROM Stk$[i]
            IF LEN(Stk$[i]) > 1 AND RIGHT$(Stk$[i], 1) = "%" THEN REMOVE "%" FROM Stk$[i]
            IF LEN(Stk$[i]) > 1 AND RIGHT$(Stk$[i], 1) = "#" THEN REMOVE "#" FROM Stk$[i]
        NEXT

        FOR INT i = 3 TO Ndx
            LTmp$ += Stk$[i] + SPC$                        ' This is the FUNCTION return VALUE (string, number, whatever)
        NEXT

        LTmp$ = CleanCodeLine (TRIM$(LTmp$))

        IF RIGHTSTR(LTmp$, " export", 1) THEN IREMOVE "export" FROM LTmp$

        IF CurrentFuncType = vt_STRVAR THEN
            LTmp$ = "BCX_RetStr$ = " + LTmp$
            *FuncRetnFlag = 1    ' 1 = return a string
            Use_BcxTempStr = TRUE
        ELSE
            LTmp$ = "Bcx_RetVal = " + LTmp$             ' 828 MrBcx - enables my Dynamic Array Release bug fix
            Stk$[1] = "Bcx_RetVal"
            CALL JoinStrings(1, 0)

            LTmp$ = ""
            FOR INT i = 1 TO Ndx
                ' LTmp$ = LTmp$ + Stk$[i]    '  + " "   ' 828 MrBcx JBK's sci notation bug report
                LTmp$ = LTmp$ + Stk$[i]      '            828 MrBcx JB bug report -FIXED-
            NEXT

            LTmp$ = TRIM$(LTmp$)
            LTmp$ = Clean$(LTmp$)
            LTmp$ = CleanCodeLine(LTmp$)
            *FuncRetnFlag = 2    ' 2 = return a number
        END IF

        IF *FuncRetnFlag = 2 THEN
            FPRINT FP_WRITE, Scoot$, LTmp$, ";"         ' 828 MrBcx - enables my Dynamic Array Release bug fix
        END IF

        IF *FuncRetnFlag = 2 THEN
            '*********************************
            '    Clean up dynamic strings
            '*********************************
            IF NOTZERO (LocalDynaCnt) THEN
                FOR INT j = 1 TO LocalDynaCnt
                    FPRINT FP_WRITE, Scoot$, DynaStr$[j]
                NEXT
            END IF
            '*********************************
            ' Clean up dynamic strings arrays
            '*********************************
            IF NOTZERO (LocalDynArrCnt) THEN
                FOR INT i = 1 TO LocalDynArrCnt
                    FPRINT FP_WRITE, Scoot$, LocalDynArrName$[i]
                NEXT
            END IF
            '*********************************
            IF *FuncRetnFlag = 2 THEN
                FPRINT FP_WRITE, Scoot$, "return ", TRIM$(EXTRACT$(LTmp$, "=")), ";"  ' 828 MrBcx - enables my Dynamic Array Release bug fix
                LTmp$ = ""
            END IF
            LastCmd = 2
        END IF

        CALL XParse(LTmp$)
        CALL FixUps
        LastCmd = 2
    ELSE    '======================================================================================================================
        DIM LTmp$
        IF SelectState[StateIdx].CaseFlag THEN SelectState[StateIdx].NoBreak = TRUE

        FOR INT iA = 3 TO Ndx
            LTmp$ = LTmp$ + Stk$[iA] + SPC$
        NEXT

        IF CurrentFuncType = vt_STRVAR THEN
            LTmp$ = "BCX_RetStr$ = " + LTmp$
            *FuncRetnFlag = 1    ' 1 = return a string
            Use_BcxTempStr = TRUE
        ELSE
            *FuncRetnFlag = 2    ' 2 = return a number
        END IF

        IF *FuncRetnFlag = 2 THEN
            '*********************************
            '    Clean up dynamic strings
            '*********************************
            IF NOTZERO (LocalDynaCnt) THEN
                FOR INT j = 1 TO LocalDynaCnt
                    FPRINT FP_WRITE, Scoot$, DynaStr$[j]
                NEXT
            END IF
            '*********************************
            ' Clean up dynamic strings arrays
            '*********************************
            IF NOTZERO (LocalDynArrCnt) THEN
                FOR INT i = 1 TO LocalDynArrCnt
                    FPRINT FP_WRITE, Scoot$, LocalDynArrName$[i]
                NEXT
            END IF
            '*********************************
            FPRINT FP_WRITE, Scoot$, "return "; ' Suppress CRLF
            LastCmd = 2
        END IF
        CALL XParse(LTmp$)
        CALL FixUps
        LastCmd = 0
    END IF
    '======================================================================================================================
    RETURN 1
END FUNCTION ' Emit_FunctionReturn




FUNCTION Emit_Msgbox(sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    UNREFERENCED_PARAMETER(sWord$)
    ' MsgBox Msg$,Title$,button
    DIM RAW i, j, k
    j = 0
    k = 0
    FOR i = 2 TO Ndx
        IF Stk$[i] = "[" THEN
            INCR j
        ELSEIF Stk$[i] = "]" THEN
            DECR j
        ELSEIF Stk$[i] = "(" THEN
            INCR j
        ELSEIF Stk$[i] = ")" THEN
            DECR j
        END IF
        IF j = 0 AND Stk$[i] = "," THEN INCR k
    NEXT
    IF k = 0 THEN
        INCR Ndx
        Stk$[Ndx]= ","
        INCR Ndx
        Stk$[Ndx]= DDQ$
        k = 1
    END IF

    IF k = 1 THEN
        INCR Ndx
        Stk$[Ndx]= ","
        INCR Ndx
        '  Stk$[Ndx]= "0"                          ' 820 and all previous versions
        '  Stk$[Ndx]= "MB_TOPMOST|MB_SYSTEMMODAL"  ' 821 MrBcx changed to this.
        Stk$[Ndx]= "MB_SYSTEMMODAL"                ' 828 Robert Wishlaw changed to this.
    END IF

    FPRINT FP_WRITE, Scoot$, "MessageBox (GetActiveWindow(),"; ' Suppress CRLF
    Stk$[++Ndx] = ");"
    CALL WriteCleanTokens(2, Ndx)
    RETURN 0
END FUNCTION ' Emit_Msgbox




FUNCTION Emit_BcxSetFont (sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    UNREFERENCED_PARAMETER(sWord$)
    Use_SetFont = TRUE
    Use_Proto = TRUE
    IF Stk$[2] = "(" THEN
        LShiftStk(2)
        DECR Ndx
    END IF
    FPRINT FP_WRITE, Scoot$, "SendMessage("; ' Suppress CRLF
    DIM RAW i
    i = 2
    DO
        FPRINT FP_WRITE, Clean$(Stk$[i]); ' Suppress CRLF
        INCR i
        IF Stk$[i] = "," THEN EXIT DO
        IF i > Ndx THEN
            CALL Abort ("Malformed BCX_SET_FONT")
        END IF
    LOOP
    INCR i
    FPRINT FP_WRITE, ",(UINT_PTR)WM_SETFONT,"; ' Suppress CRLF
    FPRINT FP_WRITE, "(WPARAM)BCX_Set_Font("; ' Suppress CRLF
    Stk$[++Ndx] = "),1);"
    CALL WriteCleanTokens(i, Ndx)
    RETURN FALSE
END FUNCTION  ' Emit_BcxSetFont




FUNCTION Emit_BcxSetLabelColor (sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    UNREFERENCED_PARAMETER(sWord$)
    ' These statements must appear in the EVENTS LOOP

    Use_SetColor = Use_Proto = TRUE

    IF Stk$[2] = "(" THEN
        LShiftStk(2)
        DECR Ndx
    END IF

    gTmpStr$ = ""
    DIM RAW i
    FOR i = 2 TO Ndx
        IF Stk$[i] = "," THEN EXIT FOR
        gTmpStr$ += Stk$[i]
    NEXT

    FPRINT FP_WRITE, Scoot$, "if((HWND)lParam==", gTmpStr$, " && Msg==WM_CTLCOLORSTATIC)"
    FPRINT FP_WRITE, Scoot$, "return Set_Color("; ' Suppress CRLF
    Stk$[++Ndx] = ",(HDC)(UINT_PTR)wParam,(HWND)lParam);"
    CALL WriteCleanTokens(i+1, Ndx)

    RETURN FALSE
END FUNCTION  ' Emit_BcxSetLabelColor



FUNCTION Emit_BcxSetEditColor (sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    UNREFERENCED_PARAMETER(sWord$)
    Use_SetColor = Use_Proto = TRUE

    IF Stk$[2] = "(" THEN
        LShiftStk(2)
        DECR Ndx
    END IF

    gTmpStr$ = ""

    DIM RAW iii
    FOR iii = 2 TO Ndx
        IF Stk$[iii] = "," THEN EXIT FOR
        gTmpStr$ += Stk$[iii]
    NEXT

    FPRINT FP_WRITE, Scoot$, "if((HWND)lParam==", gTmpStr$, " && Msg==WM_CTLCOLOREDIT)"
    FPRINT FP_WRITE, Scoot$, "return Set_Color("; ' Suppress CRLF
    Stk$[++Ndx] = ",(HDC)(UINT_PTR)wParam,(HWND)lParam);"
    CALL WriteCleanTokens(iii+1, Ndx)

    RETURN FALSE
END FUNCTION  ' Emit_BcxSetEditColor



FUNCTION Emit_Hscroll (sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    UNREFERENCED_PARAMETER(sWord$)
    Use_Hscroll = IVAL (Stk$[2])
    IF Use_Hscroll = 0 THEN Use_Hscroll = TRUE
    RETURN FALSE
END FUNCTION  ' Emit_Hscroll



FUNCTION Emit_Vscroll (sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    UNREFERENCED_PARAMETER(sWord$)
    Use_Vscroll = IVAL (Stk$[2])
    IF Use_Vscroll = 0 THEN Use_Vscroll = TRUE
    RETURN FALSE
END FUNCTION  ' Emit_Vscroll



FUNCTION Emit_InsertMenuProc (sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    UNREFERENCED_PARAMETER(sWord$)
    DIM RAW L_Comma
    L_Comma = 0
    FPRINT FP_WRITE, Scoot$, "InsertMenu";

    FOR INT A = 2 TO Ndx
        IF Stk$[A] = "," THEN INCR L_Comma
        IF Stk$[A] = "," THEN
            IF L_Comma = 3 THEN
                Stk$[A] = ",(UINT_PTR)"
            END IF
        END IF
        FPRINT FP_WRITE, Clean$(Stk$[A]); ' Suppress CRLF
    NEXT
    FPRINT FP_WRITE, ";"

    RETURN FALSE
END FUNCTION  ' Emit_InsertMenuProc




FUNCTION Emit_MdiGuiProcs (sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(FuncRetnFlag)

    IF Ndx < 2 THEN
        CALL Abort("Not Enough Parameters with " + UCASE$(sWord$) + " Statement!")
    END IF

    IF iMatchWrd(Stk$[2], "nomain") THEN

        Use_Wingui    = TRUE
        NoMain        = TRUE
        Use_GUINoMain = TRUE

        IF iMatchWrd(Stk$[4], "pixels") THEN
            GUIMetric$ = "pixels"
        END IF

        IF iMatchWrd(Stk$[4], "dpi") THEN
            GUIMetric$ = "dpi"
        END IF

        IF iMatchWrd(Stk$[4], "icon") AND Stk$[6] <> "" THEN
            GUIIcon$ = " LoadIcon(BCX_hInstance,MAKEINTRESOURCE(" + Stk$[6] + "));"
        ELSEIF iMatchWrd(Stk$[6], "icon") AND Stk$[8] <> "" THEN
            GUIIcon$ = " LoadIcon(BCX_hInstance,MAKEINTRESOURCE(" + Stk$[8] + "));"
        ELSE
            GUIIcon$ = " LoadIcon(NULL,IDI_WINLOGO);"
        END IF

        IF sWord$ = "mdigui" THEN
            Use_Mdigui       = TRUE
            CALL Emit_MDICode(FP_WRITE)
            Use_MDIGUINoMain = TRUE
            Use_GUINoMain    = FALSE
        END IF

    ELSE '  Old GUI code before GUI NOMAIN

        Use_Wingui = TRUE

        DIM classname$
        DIM metric$

        classname$ = Stk$[2]

        IF iMatchWrd(Stk$[4], "pixels") THEN
            metric$ = "pixels"
            GUIMetric$ = "pixels"
        END IF

        IF iMatchWrd(Stk$[4], "dpi") THEN
            metric$ = "dpi"
            GUIMetric$ = "dpi"
        END IF

        IF iMatchWrd(Stk$[4], "icon") AND Stk$[6] <> "" THEN
            GUIIcon$ = " LoadIcon(BCX_hInstance,MAKEINTRESOURCE(" + Stk$[6] + "));"
        ELSEIF iMatchWrd(Stk$[6], "icon") AND Stk$[8] <> "" THEN
            GUIIcon$ = " LoadIcon(BCX_hInstance,MAKEINTRESOURCE(" + Stk$[8] + "));"
        ELSE
            GUIIcon$ = " LoadIcon(NULL,IDI_WINLOGO);"
        END IF

        Use_BCX_SetMetric = Use_BCX_InitGUI = Use_BCX_RegWnd = TRUE
        Emit_WinGUIMain(classname$, metric$, GUIIcon$)

        IF sWord$ = "mdigui" THEN
            Use_Mdigui = TRUE
            CALL Emit_MDI_MsgPump
            CALL Emit_MDICode(FP_WRITE)
        ELSE
            CALL Emit_GUI_MsgPump
        END IF ' sWord$ = "mdigui"

    END IF

    CALL AddGUIGlobals
    IF NOT Use_BCX_Class_Info THEN
        Use_BCX_Class_Info = TRUE
        iEmitVarGroup = iEmitVarGroup BOR (eFontGroup BOR eClassName)
    END IF

    RETURN FALSE
END FUNCTION  ' Emit_MdiGuiProcs




FUNCTION Emit_FileIO(sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    SELECT CASE sWord$
        '*************************************************************************
        CASE "flush"                  ' FLUSH handle
        '*************************************************************************
        FOR INT i = 2 TO Ndx
            REMOVE "#" FROM Stk$[i]
            IF ISNULL(Stk$[i]) THEN CALL Abort ("Bad FLUSH Argument")
            IF DataType(Stk$[i]) = vt_NUMBER THEN Stk$[i]= "FP" + Stk$[i]
        NEXT
        IF Stk$[2] = "(" THEN  LShiftStk(2) : DECR Ndx ' Eliminate superflous ()
        DIM  i
        IF CheckLocal(Stk$[2], ADDRESSOF(i)) = vt_UNKNOWN THEN
            IF CheckGlobal(Stk$[2], ADDRESSOF(i)) = vt_UNKNOWN THEN
                CALL AddGlobal(Stk$[2], vt_FILEPTR)
            END IF
        END IF
        szFileHandle$ = ""
        FOR INT j = 2 TO Ndx
            szFileHandle$ += Stk$[j]
        NEXT
        FPRINT FP_WRITE, Scoot$, "   fflush(";szFileHandle$;");"

        '*************************************************************************
        CASE "close"                   ' CLOSE handle
        '*************************************************************************
        IF Ndx = 1 THEN
            FPRINT FP_WRITE, Scoot$, "_fcloseall();"
            EXIT SELECT
        END IF
        '*************************************************************************
        ' CLOSE multiple handles in one go:  CLOSE, #1, #2, FP3
        '*************************************************************************
        ' The basic idea here is to re-create Src$ with colon-separated CLOSE
        ' statements and then re-parse Stk$[].  Maybe useful for other things?
        '*************************************************************************
        DIM Redo                           '

        FOR INT i = 1 TO Ndx
            IF Stk$[i] = "," THEN
                Stk$[i] = " : close "
                Redo = TRUE
            END IF
        NEXT

        IF Redo THEN
            Src$ = ""
            FOR INT i = 1 TO Ndx
                Src$ += Stk$[i]
                Src$ += SPC$
            NEXT
            SplitLines(Src$)
            Src$ = LTRIM$(SplitStk$[++SplitCur])                ' Put remaining FP's in the pipeline
            CALL FastLexer(Src, SPC$, "=&()[]{}',+-*/<>?;.|:^") ' Rebuild Stk$[]
        END IF

        FOR INT i = 2 TO Ndx
            REMOVE "#" FROM Stk$[i]
            IF Stk$[i] = "" THEN CALL Abort ("Bad CLOSE Argument")
            IF DataType(Stk$[i]) = vt_NUMBER THEN Stk$[i]= "FP" + Stk$[i]
        NEXT

        IF Stk$[2] = "(" THEN LShiftStk(2) : DECR Ndx ' 7.63  Eliminate superflous ()

        DIM RAW i
        IF CheckLocal(Stk$[2], ADDRESSOF(i)) = vt_UNKNOWN THEN
            IF CheckGlobal(Stk$[2], ADDRESSOF(i)) = vt_UNKNOWN THEN
                CALL AddGlobal(Stk$[2], vt_FILEPTR)
            END IF
        END IF

        szFileHandle$ = ""
        FOR INT j = 2 TO Ndx
            szFileHandle$ += Stk$[j]
        NEXT

        IF UseFileTest THEN
            FPRINT FP_WRITE, Scoot$, "if(", szFileHandle$, ")"
            FPRINT FP_WRITE, Scoot$, " {"
            FPRINT FP_WRITE, Scoot$, "   fclose(", szFileHandle$, ");"
            FPRINT FP_WRITE, Scoot$, "   ", szFileHandle$, "=NULL;"
            FPRINT FP_WRITE, Scoot$, " }"
        ELSE
            FPRINT FP_WRITE, Scoot$, "fclose(", szFileHandle$, ");"
        END IF

        '*************************************************************************
        CASE "open"    ' OPEN filename$ FOR INPUT | OUTPUT | APPEND AS handle
        '*************************************************************************
        DIM RAW Keyword$, LTmp$, Op$, HaveFOR, HaveAS

        HaveFOR = FALSE
        HaveAS = FALSE
        Op$ = ""
        FOR INT iA = 1 TO Ndx
            Keyword$ = LCASE$(Stk$[iA])

            SELECT CASE Keyword$
                CASE "open"
                Stk$[iA] = ""

                CASE "for"
                Stk$[iA] = ""
                CALL BuildCleanStr(2, iA-1, Filnam$)
                HaveFOR = TRUE

                CASE "as"
                Stk$[iA] = ""
                IF DataType(Stk$[iA + 1]) = vt_NUMBER THEN
                    Stk$[iA + 1] = "FP" + Stk$[iA + 1]
                END IF
                HaveAS = TRUE

                DIM RAW i
                IF CheckLocal(Stk$[iA + 1], ADDRESSOF(i)) = vt_UNKNOWN THEN
                    IF CheckGlobal(Stk$[iA + 1], ADDRESSOF(i)) = vt_UNKNOWN THEN
                        CALL AddGlobal(Stk$[iA + 1], vt_FILEPTR)
                    END IF
                END IF

                Var$ = ""
                FOR INT j = iA+1 TO Ndx
                    IF iMatchWrd(Stk$[j], "reclen") THEN EXIT FOR
                    Var$ += Stk$[j]
                    Stk$[j] = ""
                NEXT
                szFileHandle$ = Var$ + "@"

                CASE "input"
                ' Op$ = ENC$("r")  ' Defeating a Pelles bug with fseeki64 / ftelli64
                Op$ = ENC$("rb")   ' MrBcx 816 changed to "rb" from "r"
                Stk$[iA] = ""      ' proven to prevent the bug when using BCX file i/o

                CASE "output"
                Op$ = ENC$("w")
                Stk$[iA] = ""

                CASE "append"
                Op$ = ENC$("a")
                Stk$[iA] = ""

                CASE "binary"
                Op$ = ENC$("rb+")
                Stk$[iA] = ""

                CASE "binaryappend"
                Op$ = ENC$("ab+")
                Stk$[iA] = ""

                CASE "binarynew"
                Op$ = ENC$("wb+")
                Stk$[iA] = ""

                CASE "binaryinput"
                Op$ = ENC$("rb")
                Stk$[iA] = ""

                CASE "binaryoutput"
                Op$ = ENC$("rb+")
                Stk$[iA] = ""

                CASE "reclen"
                IF Stk$[iA+1] = "=" THEN
                    FOR INT j = iA+2 TO Ndx
                        Stk$[j-1] = Stk$[j]
                    NEXT
                    DECR Ndx
                END IF

                Var$ = EXTRACT$(Clean$(szFileHandle$), "[") + "len"

                DIM RAW i, j, LZZ$

                IF CheckLocal(Var$, ADDRESSOF(i)) = vt_UNKNOWN THEN
                    CALL AddGlobal(Var$, vt_INTEGER)
                ELSE
                    IF CheckLocal(Var$, ADDRESSOF(i)) = vt_UNKNOWN THEN
                        CALL AddLocal(Var$, vt_INTEGER)
                        Var$ = "int " + Var$
                    END IF
                END IF

                i = CheckType(Stk$[iA+1])
                LZZ$ = LCASE$(Stk$[iA+1])
                j = FindWord(LZZ$, tTypes, WordsInTable(tTypes))
                IF i = vt_STRUCT OR i = vt_UNION OR j = vt_BOOL OR j = vt_BYTE OR _
                    j = vt_CHAR OR j = vt_SCHAR OR j = vt_COLORREF OR j = vt_DOUBLE OR j = vt_DWORD OR _
                    j = vt_SINGLE OR j = vt_INTEGER OR j = vt_LDOUBLE OR j = vt_LLONG OR j = vt_SSHORT OR _
                    j = vt_LONG OR j = vt_SHORT OR j = vt_UINT OR j = vt_ULONG OR _
                    j = vt_ULONGLONG OR j = vt_USHORT OR j = vt_VARIANT OR j = vt_WINBOOL THEN
                    FPRINT FP_WRITE, Scoot$, Var$, " = sizeof(", Stk$[iA+1], ");"
                ELSE
                    FPRINT FP_WRITE, Scoot$, Var$, " = ", Clean$(Stk$[iA+1]), ";"
                END IF
                Stk$[iA] = ""
                Stk$[iA+1] = ""
            END SELECT
        NEXT

        IF ISNULL(Op$)    THEN CALL Abort("Syntax Error: Missing FOR in OPEN statement")
        IF IDont(HaveFOR) THEN CALL Abort("Syntax Error: Missing FOR in OPEN statement")
        IF IDont(HaveAS)  THEN CALL Abort("Syntax Error: Missing AS  in OPEN statement")

        IF UseFileTest THEN
            FPRINT FP_WRITE, Scoot$, "if((", Clean$(szFileHandle$), "=fopen(", Filnam$, ", ", Op$, "))==0)"
            FPRINT FP_WRITE, Scoot$, " {"
            LTmp$ = ENC$("Error: Cannot Access File or File Not Found. %s\\n")
            FPRINT FP_WRITE, Scoot$, "fprintf(stderr, ", LTmp$, ", ", Filnam$, "); exit(1);"
            FPRINT FP_WRITE, Scoot$, " }"
        ELSE
            FPRINT FP_WRITE, Scoot$, Clean$(szFileHandle$), "=fopen(", Filnam$, ", ", Op$, ");"
        END IF

        '*************************************************************************
        ' Statement  RECORD [#] filenumber,recordnumber [,location in record]
        ' Definition:          Position the file pointer anywhere in a file.
        ' filenumber           Filenumber from  1 to 99
        ' record number        RECORD number to point to. Default first record
        ' location in record   Optional location in RECORD. Default is Zero
        ' RECORD fp1, 6[, 10]
        '*************************************************************************

            CASE "record"

        LOCAL numargs
        DIM RAW ffp AS FUNCPARSE
        CLEAR(ffp)

        IF DataType(Stk$[2]) = vt_NUMBER THEN
            Stk$[2]= "FP" + Stk$[2]
        END IF

        IF Ndx > 1 THEN numargs = SepFuncArgs(1, ADDRESSOF(ffp), FALSE)
        IF numargs < 1 THEN Abort("Missing required arguments to RECORD")
        IF numargs > 4 THEN Abort("Too many arguments to RECORD")

        IF numargs = 3 THEN
            FPRINT FP_WRITE, Scoot$, "_fseeki64 (", GetArg$(1, ADDRESSOF(ffp)), ",(", GetArg$(2, ADDRESSOF(ffp)), "-1)*", Stk$[2], "len+", GetArg$(3, ADDRESSOF(ffp)), ",SEEK_SET);"
        ELSEIF numargs = 2 THEN
            FPRINT FP_WRITE, Scoot$, "_fseeki64 (", GetArg$(1, ADDRESSOF(ffp)), ",(", GetArg$(2, ADDRESSOF(ffp)), "-1)*", Stk$[2], "len,SEEK_SET);"
        ELSE
            FPRINT FP_WRITE, Scoot$, "_fseeki64 (", GetArg$(1, ADDRESSOF(ffp)), ",0,SEEK_SET);"
        END IF
    END SELECT

    RETURN 0
END FUNCTION ' Emit_FileIO



FUNCTION Emit_FileManagementProcs(sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    SELECT CASE sWord$

        CASE "copyfile"
        FPRINT FP_WRITE, Scoot$, "CopyFile ("; ' Suppress CRLF
        DIM RAW szUS$
        szUS$ = UCASE$(Stk$[Ndx])
        SELECT CASE Stk$[Ndx]

            CASE "1", "0"
            Stk$[++Ndx] = ");"
            CASE "TRUE", "FALSE"
            IF UseCpp THEN
                Stk$[Ndx] = LCASE$(Stk$[Ndx]) + ");"
            ELSE
                Stk$[Ndx] = szUS$ + ");"
            END IF

            CASE ELSE
            IF UseCpp THEN
                Stk$[++Ndx] = ",false);"
            ELSE
                Stk$[++Ndx] = ",FALSE);"
            END IF
        END SELECT
        CALL WriteCleanTokens(2, Ndx)


        '***********************
        CASE "kill"
        '***********************
        FPRINT FP_WRITE, Scoot$, "DeleteFile ("; ' Suppress CRLF
        IF Ndx >= 2 AND Stk$[2] <> "(" THEN
            CALL InsertOptionalParens(2)
        END IF
        Stk$[++Ndx] = ");"
        CALL WriteCleanTokens(2, Ndx)

        '***********************
        CASE "rename"
        '***********************
        FPRINT FP_WRITE, Scoot$, "MoveFile ("; ' Suppress CRLF
        Stk$[++Ndx] = ");"
        CALL WriteCleanTokens(2, Ndx)

    END SELECT
    RETURN 0
END FUNCTION ' Emit_FileManagementProcs



FUNCTION Emit_LineInputProcs (sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    UNREFERENCED_PARAMETER(sWord$)

    DIM RAW Var1$
    DIM RAW Var2$
    DIM RAW CVar$
    DIM RAW L_Handle$
    DIM RAW i = DataType(Stk$[2])              ' Test for keyboard version of LINE INPUT
    '*************************************************************************************************
    IF i = vt_STRLIT OR i = vt_STRVAR THEN
        IF i <> vt_STRLIT THEN Stk$[2] = Clean$(Stk$[2])
        DIM RAW sC_Stk3$
        sC_Stk3$ = Clean$(Stk$[3])
        '****************************************  7.54 LINE INPUT allows static and dynamic strings
        Use_LineinputKB = Use_SysMacros = TRUE
        FPRINT FP_WRITE, Scoot$, "mLineInputKB (", Stk$[2], ", " , sC_Stk3$, ");"
        EXIT FUNCTION
    END IF

    '**************************************************************************************************
    '                        Okay, we're dealing with the file form of LINE INPUT
    '**************************************************************************************************

    Use_NamePathFromFP = Use_BcxTempStr = TRUE

    REMOVE "#" FROM Stk$[2]
    IF ISNULL(Stk$[2]) THEN CALL Abort ("Bad LINE INPUT File Handle")
    IF DataType(Stk$[2])= vt_NUMBER THEN
        Stk$[2]= "FP" + Stk$[2]
    END IF

    L_Handle$ = EXTRACT$(Stk$[2], "[")

    IF CheckLocal(L_Handle$, ADDRESSOF(i)) = vt_UNKNOWN THEN
        IF CheckGlobal(L_Handle$, ADDRESSOF(i)) = vt_UNKNOWN THEN
            CALL AddGlobal(L_Handle$, vt_FILEPTR)
        END IF
    END IF

    Var1$ = Clean$(Stk$[3])
    Var2$ = ""
    CVar$ = Var1$

    '********************************************************************
    DIM Optional_Limit$
    Optional_Limit$ = MID$ (Var1$, INSTRREV(Var1$, ","))
    REMOVE Optional_Limit$ FROM Var1$
    REMOVE Optional_Limit$ FROM CVar$
    Optional_Limit$ = TRIM$(MID$(Optional_Limit$, 2))
    '********************************************************************

    IF INCHR(Var1$, "[") AND INCHR(Var1$, "]") THEN
        IF iMatchNQ(Var1$, "[++") THEN
            REMOVE "++" FROM CVar$
        END IF
        IF iMatchNQ(Var1$, "[--") THEN
            REMOVE "--" FROM CVar$
        END IF
        IF iMatchNQ(Var1$, "++]") THEN
            REMOVE "++" FROM CVar$
            Var2$ = MID$(Var1$, INCHR(Var1$, "[")+1)
            Var2$ = EXTRACT$(Var2$, "]")
            Var1$ = CVar$
        END IF
        IF iMatchNQ(Var1$, "--]") THEN
            REMOVE "--" FROM CVar$
            Var2$ = MID$(Var1$, INCHR(Var1$, "[")+1)
            Var2$ = EXTRACT$(Var2$, "]")
            Var1$ = CVar$
        END IF
    END IF

    FPRINT FP_WRITE, Scoot$, Var1$, "[0]=0;"
    '*******************************************************************************
    REMOVE "--" FROM Var1$   ' without this, a receiving array variable
    REMOVE "++" FROM Var1$   ' index is twice incremented or decremented
    '*******************************************************************************

    IF Optional_Limit$ > "" THEN
        FPRINT FP_WRITE, Scoot$, "fgets(", Var1$, ", ", Optional_Limit$, ", ", Clean$(Stk$[2]), ");"
    ELSE
        FPRINT FP_WRITE, Scoot$, "fgets(", Var1$, ",", BCXSTRSIZE, ", ", Clean$(Stk$[2]), ");"
    END IF

    FPRINT FP_WRITE, Scoot$, "  if(feof(", Clean$(Stk$[2]), ") || (", Var1$, "[strlen(", Var1$, ")-1]==10))"
    FPRINT FP_WRITE, Scoot$, "    {"
    FPRINT FP_WRITE, Scoot$, "     ", Var1$, "[strcspn(", Var1$, ",", ENC$("\\r\\n"), ")] = 0;"
    FPRINT FP_WRITE, Scoot$, "    }"
    FPRINT FP_WRITE, Scoot$, "   else"
    FPRINT FP_WRITE, Scoot$, "    {"
    FPRINT FP_WRITE, Scoot$, "      printf(", ENC$("%s%d while reading file: %s\\n"), "," , _
    ENC$("Error! - LINE INPUT truncation detected at PROGRAM line: "), ",__LINE__-7, NamePathFromFP(", Clean$(Stk$[2]), "));"
    FPRINT FP_WRITE, Scoot$, "      printf(", ENC$("%s\\n"), ",", ENC$("The actual truncated line of text:"), ");"
    FPRINT FP_WRITE, Scoot$, "      printf(", ENC$("%s"), ",", Var1$, ");"
    FPRINT FP_WRITE, Scoot$, "      exit(1);"
    FPRINT FP_WRITE, Scoot$, "    }"

    IF Var2$ <> "" THEN
        FPRINT FP_WRITE, Var2$, ";"
    END IF

    RETURN 0
END FUNCTION ' Emit_LineInputProcs


FUNCTION Emit_FinputProcs(sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    UNREFERENCED_PARAMETER(sWord$)
    CALL Emit_FileInputCode
    RETURN 0
END FUNCTION  ' Emit_FinputProcs


FUNCTION Emit_GetProcs(sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    UNREFERENCED_PARAMETER(sWord$)
    DIM RAW i
    Use_Get = TRUE
    Use_SysMacros = TRUE
    REMOVE "#" FROM Stk$[2]
    IF ISNULL(Stk$[2]) THEN CALL Abort ("Bad GET$ Argument")
    IF DataType(Stk$[2])= vt_NUMBER THEN
        Stk$[2]= "FP" + Stk$[2]
    END IF
    IF CheckLocal(Stk$[2], ADDRESSOF(i)) = vt_UNKNOWN THEN
        IF CheckGlobal(Stk$[2], ADDRESSOF(i)) = vt_UNKNOWN THEN
            CALL AddGlobal(Stk$[2], vt_FILEPTR)
        END IF
    END IF
    FPRINT FP_WRITE, Scoot$, "GET("; ' Suppress CRLF
    Stk$[++Ndx] = ");"
    CALL WriteCleanTokens(2, Ndx)
    RETURN 0
END FUNCTION  ' Emit_GetProcs


FUNCTION Emit_PutProcs(sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    UNREFERENCED_PARAMETER(sWord$)
    DIM RAW i
    Use_Put = TRUE
    Use_SysMacros = TRUE
    REMOVE "#" FROM Stk$[2]
    IF ISNULL(Stk$[2]) THEN CALL Abort ("Bad PUT$ Argument")
    IF DataType(Stk$[2])= vt_NUMBER THEN
        Stk$[2]= "FP" + Stk$[2]
    END IF
    IF CheckLocal(Stk$[2], ADDRESSOF(i)) = vt_UNKNOWN THEN
        IF CheckGlobal(Stk$[2], ADDRESSOF(i)) = vt_UNKNOWN THEN
            CALL AddGlobal(Stk$[2], vt_FILEPTR)
        END IF
    END IF
    FPRINT FP_WRITE, Scoot$, "PUT("; ' Suppress CRLF
    Stk$[++Ndx] = ");"
    CALL WriteCleanTokens(2, Ndx)
    RETURN 0
END FUNCTION  ' Emit_PutProcs



FUNCTION Emit_FprintProcs(sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    UNREFERENCED_PARAMETER(sWord$)
    DIM STATIC i
    DIM STATIC j
    DIM STATIC LZZ$
    DIM RAW L_Handle$
    REMOVE "#" FROM Stk$[2]
    IF ISNULL(Stk$[2]) THEN CALL Abort ("Bad FPRINT Argument")
    IF DataType(Stk$[2])= vt_NUMBER THEN
        Stk$[2]= "FP" + Stk$[2]
    END IF
    IF iMatchWrd(Stk$[2], "stderr") THEN
        L_Handle$ = "stderr"
    ELSE
        IF CheckLocal(Stk$[2], ADDRESSOF(i)) = vt_UNKNOWN THEN
            IF CheckGlobal(Stk$[2], ADDRESSOF(i)) = vt_UNKNOWN THEN
                CALL AddGlobal(Stk$[2], vt_FILEPTR)
            END IF
        END IF
        L_Handle$ = ""
        FOR j = 2 TO Ndx
            IF *Stk$[j] = ASC(",") OR *Stk$[j] = ASC(";") THEN
                Stk$[j] = ""
                EXIT FOR
            END IF
            L_Handle$ += Stk$[j]
            Stk$[j] = ""
        NEXT
        L_Handle$ += "@"
    END IF
    Stk$[2] = ""  ' remove the handle
    Stk$[3] = ""  ' remove the Comma
    LZZ$ = "f" + PrintWriteFormat$(0)
    LZZ$ = LEFT$(LZZ$, 8) + REMOVE$(L_Handle$, "@") + "," + MID$(LZZ$, 9)
    FPRINT FP_WRITE, Scoot$, LZZ$
    RETURN 0
END FUNCTION  ' Emit_FprintProcs


FUNCTION Emit_SeekProcs(sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    UNREFERENCED_PARAMETER(sWord$)

    REMOVE "#" FROM Stk$[2]
    IF ISNULL(Stk$[2]) THEN CALL Abort ("Bad SEEK Argument")
    '***************************************************************************
    ' Example:  SEEK FP1, 8192 [, SEEK_CUR ]               ' MrBcx 817 - Added
    '***************************************************************************
    DIM Origin$                                            ' MrBcx 817 - Added
    SELECT CASE UCASE$(Stk$[Ndx])                          ' MrBcx 817 - Added
        CASE "SEEK_CUR", "SEEK_END", "SEEK_SET"            ' MrBcx 817 - Added
        Origin$ = UCASE$(Stk$[Ndx])                        ' MrBcx 817 - Added
        DECR Ndx, 2                   ' Adjust the stack   ' MrBcx 817 - Added
        CASE ELSE                                          ' MrBcx 817 - Added
        Origin$ = "SEEK_SET"                               ' MrBcx 817 - Added
    END SELECT                                             ' MrBcx 817 - Added
    '***************************************************************************
    IF DataType(Stk$[2])= vt_NUMBER THEN
        Stk$[2]= "FP" + Stk$[2]
    END IF

    DIM i
    IF CheckLocal(Stk$[2], ADDRESSOF(i)) = vt_UNKNOWN THEN
        CALL AddGlobal(Stk$[2], vt_FILEPTR)
    END IF

    FPRINT FP_WRITE, Scoot$, "_fseeki64("; ' Suppress CRLF
    Stk$[++Ndx] = "," + Origin$ + ");"                     ' MrBcx 817 - Modified

    CALL WriteCleanTokens(2, Ndx)
    RETURN 0
END FUNCTION  ' Emit_SeekProcs




FUNCTION Emit_SetEofProcs(sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    UNREFERENCED_PARAMETER(sWord$)
    Use_SysMacros = Use_Seteof = TRUE
    DIM RAW i
    FOR i = 2 TO Ndx
        REMOVE "#" FROM Stk$[i]
    NEXT
    IF Stk$[2] = "(" THEN Stk$[2] = Stk$[3]  ' Allow SETEOF (FP1) -and-  SETEOF FP1
    IF DataType(Stk$[2])= vt_NUMBER THEN
        Stk$[2]= "FP" + Stk$[2]
    END IF
    IF CheckLocal(Stk$[2], ADDRESSOF(i)) = vt_UNKNOWN THEN
        CALL AddGlobal(Stk$[2], vt_FILEPTR)
    END IF
    FPRINT FP_WRITE, Scoot$, "SetEof(", Stk$[2], ");"
    RETURN 0
END FUNCTION  ' Emit_SetEofProcs



FUNCTION Emit_FwriteProcs(sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    UNREFERENCED_PARAMETER(sWord$)
    DIM RAW i
    DIM RAW LZZ$
    DIM RAW L_Handle$

    REMOVE "#" FROM Stk$[2]
    IF ISNULL(Stk$[2]) THEN CALL Abort ("Bad WRITE Argument")
    IF DataType(Stk$[2])= vt_NUMBER THEN
        Stk$[2]= "FP" + Stk$[2]
    END IF

    IF CheckLocal(Stk$[2], ADDRESSOF(i)) = vt_UNKNOWN THEN
        CALL AddGlobal(Stk$[2], vt_FILEPTR)
    END IF
    L_Handle$ = ""
    FOR INT j = 2 TO Ndx
        IF iMatchWrd(Stk$[j], ",") OR iMatchWrd(Stk$[j], ";") THEN
            Stk$[j] = ""              ' remove the Comma
            EXIT FOR
        END IF
        L_Handle$ += Stk$[j]
        Stk$[j] = ""                  ' remove the handle
    NEXT j
    L_Handle$ += "@"
    LZZ$ = "f" + PrintWriteFormat$(1)
    LZZ$ = LEFT$(LZZ$, 8)  +  Clean$(L_Handle$)  +  ","  +  MID$(LZZ$, 9)
    FPRINT FP_WRITE, Scoot$, LZZ$

    RETURN 0
END FUNCTION  ' Emit_FwriteProcs




FUNCTION Emit_StringProcs(sWord$, FuncRetnFlag AS PINT)
    SELECT CASE sWord$

        CASE "midstr"    ' alias for MID$ statement (not the MID$ function)
        Src$ = ""
        FOR INT A = 1 TO Ndx
            Src$ += Clean$(Stk$[A])
        NEXT
        FPRINT FP_WRITE, Scoot$, TRIM$(Src$), ";"

        CASE ELSE
        CALL Emit_Old(FuncRetnFlag)

    END SELECT
    RETURN 0
END FUNCTION ' Emit_StringProcs



FUNCTION Emit_MathProcs(sWord$, FuncRetnFlag AS PINT)
    SELECT CASE sWord$

        CASE "incr"
        DIM j
        FPRINT FP_WRITE, Scoot$; ' Suppress CRLF
        FOR INT i = 2 TO Ndx
            IF *Stk$[i] = ASC(",") THEN
                FPRINT FP_WRITE, "+=("; ' Suppress CRLF
                j = TRUE
            ELSE
                FPRINT FP_WRITE, Clean$(Stk$[i]); ' Suppress CRLF
            END IF
        NEXT
        FPRINT FP_WRITE, IIF$(j, ");", "++;")

        CASE "decr"
        DIM j
        FPRINT FP_WRITE, Scoot$; ' Suppress CRLF
        FOR INT i = 2 TO Ndx
            IF *Stk$[i] = ASC(",") THEN
                FPRINT FP_WRITE, "-=("; ' Suppress CRLF
                j = TRUE
            ELSE
                FPRINT FP_WRITE, Clean$(Stk$[i]); ' Suppress CRLF
            END IF
        NEXT
        FPRINT FP_WRITE, IIF$(j, ");", "--;")

        CASE ELSE
        CALL Emit_Old(FuncRetnFlag)
    END SELECT
    RETURN 0
END FUNCTION ' Emit_MathProcs



FUNCTION Emit_ConsoleOnlyProcs(sWord$, FuncRetnFlag AS PINT)
    SELECT CASE sWord$

        CASE "print"
        FPRINT FP_WRITE, Scoot$, PrintWriteFormat$(0)

        CASE "locate"
        IF NoMain = TRUE OR MakeDLL = TRUE THEN
            Use_Console = TRUE
        END IF

        FPRINT FP_WRITE, Scoot$, "locate ("; ' Suppress CRLF
        Stk$[++Ndx] = ");"
        CALL WriteCleanTokens(2, Ndx)

        CASE "panel"
        IF NoMain = TRUE OR MakeDLL = TRUE THEN
            Use_Console = TRUE
        END IF

        FPRINT FP_WRITE, Scoot$, "panel ("; ' Suppress CRLF
        Stk$[++Ndx] = ");"
        CALL WriteCleanTokens(2, Ndx)

        CASE "cls"
        IF NoMain = TRUE OR MakeDLL = TRUE THEN
            Use_Console = TRUE
        END IF

        FPRINT FP_WRITE, Scoot$, "cls();"

        CASE "color"
        IF NoMain = TRUE OR MakeDLL = TRUE THEN
            Use_Console = TRUE
        END IF

        FPRINT FP_WRITE, Scoot$, "color ("; ' Suppress CRLF
        Stk$[++Ndx] = ");"
        CALL WriteCleanTokens(2, Ndx)

        CASE "textmode"
        DIM RAW LTmp$
        CALL BuildCleanStr(2, Ndx, LTmp$)                 ' Allow size to be an expression
        FPRINT FP_WRITE, Scoot$, "TextMode(", LTmp$, ");"

        CASE "delay"
        DIM RAW LTmp$
        CALL BuildCleanStr(2, Ndx, LTmp$)                 ' Allow size to be an expression
        FPRINT FP_WRITE, Scoot$, "Sleep(1000*", LTmp$, ");"

        CASE "write"
        FPRINT FP_WRITE, Scoot$, PrintWriteFormat$(1)

        CASE ELSE
        CALL Emit_Old(FuncRetnFlag)
    END SELECT
    RETURN 0
END FUNCTION ' Emit_ConsoleOnlyProcs



FUNCTION ValidExitStatement
    DIM RightTerm$
    RightTerm$ = LCASE$(Stk$[2])
    SELECT CASE RightTerm$
        CASE "sub", "function", "for", "xfor", "do", "while", "select", "nest", "loop", "repeat"
        RETURN TRUE
    END SELECT
    RETURN FALSE
END FUNCTION



FUNCTION IsQuoted(A AS STRING) AS INTEGER
    DIM ArgLen = LEN(A)
    IF ArgLen < 2 THEN
        RETURN 0
    END IF
    IF A[0] = 34 AND A[ArgLen-1] = 34 THEN
        RETURN 1
    ELSE
        RETURN 0
    END IF
END FUNCTION



FUNCTION Emit_ControlFlow(sWord$, FuncRetnFlag AS PINT)
    DIM STATIC iFallThrough AS INTEGER

    SELECT CASE sWord$

        CASE "exit"

        IF ValidExitStatement() = FALSE THEN
            CALL Abort("Expected to find EXIT: sub|function|for|xfor|do|while|select|nest|loop|repeat")
        END IF

        IF SelectState[StateIdx].CaseFlag THEN SelectState[StateIdx].NoBreak = TRUE

        DIM szL_Stk2$
        DIM iLoops1
        DIM iLoops2

        FOR iLoops1 = 2 TO Ndx
            IF *Stk$[iLoops1] = ASC(",") THEN ITERATE
            szL_Stk2$ = LCASE$(Stk$[iLoops1])

            SELECT CASE szL_Stk2$
                CASE "sub"
                IF COM_lc_names_index > 0 THEN          ' cleaning local COM objects if user forgot to
                    CALL BCX_FreeLocalCOMObjects(FALSE)  ' call xxx = Nothing for each declared object
                END IF
                IF NOTZERO (LocalDynaCnt) THEN          ' Clean up dynamic strings
                    FOR INT j = 1 TO LocalDynaCnt
                        FPRINT FP_WRITE, Scoot$, DynaStr$[j]
                    NEXT
                END IF
                IF NOTZERO (LocalDynArrCnt) THEN        ' Clean up dynamic strings arrays
                    FOR INT i = 1 TO LocalDynArrCnt
                        FPRINT FP_WRITE, Scoot$, LocalDynArrName$[i]
                    NEXT
                END IF
                FPRINT FP_WRITE, Scoot$, "return;"


                CASE "function"
                IF NOTZERO(LocalDynaCnt) THEN ' Clean up dynamic strings
                    FOR INT j = 1 TO LocalDynaCnt
                        FPRINT FP_WRITE, Scoot$, DynaStr$[j]
                    NEXT
                END IF
                IF NOTZERO(LocalDynArrCnt) THEN ' Clean up dynamic strings arrays
                    FOR INT i = 1 TO LocalDynArrCnt
                        FPRINT FP_WRITE, Scoot$, LocalDynArrName$[i]
                    NEXT
                END IF
                FPRINT FP_WRITE, Scoot$, "return 0;"


                CASE "for"
                DIM STATIC LszTmp$
                DIM STATIC i

                XFOR i = LoopTypeCnt-iLoops2 _
                    UNTIL LoopType[i].iLoopType = lt_FORNEXT OR i = 0 BY i--
                XNEXT

                IF i THEN
                    IF i <> LoopTypeCnt-iLoops2 THEN
                        IF TestState THEN CALL Warning_ID(eExitingMoreThan1Loop, 1)
                    END IF
                    iLoops2 = LoopTypeCnt - i + 1
                    IF iLoops1 = Ndx THEN CALL DoGoto(i, 1)
                ELSE
                    LszTmp$ = "No FOR to exit from. Inner most loop is "
                    LszTmp$ += LoopTypeName$(LoopType[LoopTypeCnt].iLoopType)
                    CALL Abort(LszTmp$)
                END IF

                CASE "xfor"
                DIM STATIC LszTmp$
                DIM STATIC i

                XFOR i = LoopTypeCnt-iLoops2 _
                    UNTIL LoopType[i].iLoopType = lt_FORXNEXT OR i = 0 BY i--
                XNEXT

                IF i THEN
                    IF i <> LoopTypeCnt-iLoops2 THEN
                        IF TestState THEN CALL Warning_ID(eExitingMoreThan1Loop, 1)
                    END IF
                    iLoops2 = LoopTypeCnt - i + 1
                    IF iLoops1 = Ndx THEN CALL DoGoto(i, 1)
                ELSE
                    LszTmp$ = "No XFOR to exit from. Inner most loop is "
                    LszTmp$ += LoopTypeName$(LoopType[LoopTypeCnt].iLoopType)
                    CALL Abort(LszTmp$)
                END IF

                CASE "do"
                DIM STATIC LszTmp$
                DIM STATIC i

                XFOR i = LoopTypeCnt-iLoops2 _
                    UNTIL LoopType[i].iLoopType = lt_DOLOOP OR _
                    LoopType[i].iLoopType = lt_DOUNTILLOOP  OR _
                    LoopType[i].iLoopType = lt_DOWHILELOOP  OR i = 0 BY i--
                XNEXT

                IF i THEN
                    IF i <> LoopTypeCnt-iLoops2 THEN
                        IF TestState THEN CALL Warning_ID(eExitingMoreThan1Loop, 1)
                    END IF
                    iLoops2 = LoopTypeCnt - i + 1
                    IF iLoops1 = Ndx THEN CALL DoGoto(i, 1)
                ELSE
                    LszTmp$ = "No DO to exit from. Inner most loop is "
                    LszTmp$ += LoopTypeName$(LoopType[LoopTypeCnt].iLoopType)
                    CALL Abort(LszTmp$)
                END IF

                CASE "while"
                DIM STATIC LszTmp$
                DIM STATIC i

                XFOR i = LoopTypeCnt-iLoops2 _
                    UNTIL LoopType[i].iLoopType = lt_WHILEWEND OR i = 0 BY i--
                XNEXT

                IF i THEN
                    IF i <> LoopTypeCnt-iLoops2 THEN
                        IF TestState THEN CALL Warning_ID(eExitingMoreThan1Loop, 1)
                    END IF
                    iLoops2 = LoopTypeCnt - i + 1
                    IF iLoops1 = Ndx THEN CALL DoGoto(i, 1)
                ELSE
                    LszTmp$ = "No WHILE to exit from. Inner most loop is "
                    LszTmp$ += LoopTypeName$(LoopType[LoopTypeCnt].iLoopType)
                    CALL Abort(LszTmp$)
                END IF

                CASE "select"
                DIM STATIC LszTmp$
                DIM STATIC i

                XFOR i = LoopTypeCnt-iLoops2 _
                    UNTIL LoopType[i].iLoopType = lt_SELECT OR i = 0 BY i--
                XNEXT

                IF i THEN
                    IF i <> LoopTypeCnt-iLoops2 THEN
                        IF TestState THEN CALL Warning_ID(eExitingMoreThan1Loop, 1)
                    END IF
                    iLoops2 = LoopTypeCnt - i + 1
                    IF iLoops1 = Ndx THEN
                        CALL DoGoto(i, 1)
                        SelectState[StateIdx].CaseFlag++
                    END IF
                ELSE
                    LszTmp$ = "No SELECT to exit from. Inner most loop is "
                    LszTmp$ += LoopTypeName$(LoopType[LoopTypeCnt].iLoopType)
                    CALL Abort(LszTmp$)
                END IF

                CASE "nest"
                DIM STATIC LszTmp$
                DIM STATIC i
                IF LoopTypeCnt = 0 THEN
                    CALL Abort("Too many end loops")
                END IF

                XFOR i = LoopTypeCnt-iLoops2 _
                    UNTIL LoopType[i].iLoopType <> LoopType[LoopTypeCnt-iLoops2].iLoopType BY i--
                XNEXT

                LszTmp$ = "Exiting from nested control loops. Outer to inner control loops are "
                LszTmp$ += LoopTypeName$(LoopType[LoopTypeCnt].iLoopType)

                IF TestState THEN CALL Warning(LszTmp$, 1)
                INCR i
                iLoops2 = LoopTypeCnt - i + 1
                IF iLoops1 = Ndx THEN CALL DoGoto(i, 1)

                CASE ELSE
                DIM STATIC LszTmp$
                LszTmp$ = "Exiting from a misnamed or unnamed control loop.  Expected: EXIT "
                LszTmp$ += LoopTypeName$(LoopType[LoopTypeCnt].iLoopType)

                IF TestState THEN CALL Warning(LszTmp$, 1)
                IF iLoops1 = Ndx THEN CALL DoGoto(LoopTypeCnt-iLoops2, 1)
                INCR iLoops2
            END SELECT
        NEXT

            CASE "repeat"
        DIM LTmp$

        FOR INT i = 2 TO Ndx
            LTmp$ += Stk$[i]
        NEXT
        LTmp$ = Clean$(LTmp$)
        CALL BumpUp
        IF INCHR(Stk$[2], "-") THEN
            IF LEFTSTR(LTmp$, "-") THEN LTmp$ = MID$(LTmp$, 2)
            FPRINT FP_WRITE, Scoot$, "for(int BCX_REPEAT = ", LTmp$, "; BCX_REPEAT >= 1; BCX_REPEAT--)"
            FPRINT FP_WRITE, Scoot$, "{"
        ELSE
            FPRINT FP_WRITE, Scoot$, "for(int BCX_REPEAT = 1; BCX_REPEAT <= ", LTmp$, "; BCX_REPEAT++)"
            FPRINT FP_WRITE, Scoot$, "{"
        END IF
        CALL BumpUp

            CASE "endrepeat"
        CALL BumpDown("Too many unindents in REPEAT/END REPEAT")
        FPRINT FP_WRITE, Scoot$, "}"
        CALL BumpDown("Too many unindents in REPEAT/END REPEAT")

            CASE "while"
        CALL Emit_IfCond("while", eFull)
        IF iDoWhile THEN
            LoopType[++LoopTypeCnt].iLoopType = iDoWhile
        ELSE
            LoopType[++LoopTypeCnt].iLoopType = lt_WHILEWEND
        END IF
        LoopType[LoopTypeCnt].iJumpTo = LabelGenerator++
        LoopType[LoopTypeCnt].szUseNeedLabel$ = ""
        iDoWhile = 0
        LoopType[LoopTypeCnt].iLoopLine = LineNum[FileNdx]
        CALL InBlockSet

            CASE "wend", "endwhile"
        CALL InBlockReSet
        IF LoopTypeCnt = 0 THEN
            CALL Abort("Too many end loops")
        END IF
        IF LoopType[LoopTypeCnt].iLoopType <> lt_WHILEWEND THEN
            DIM RAW sErr$
            sErr$ = LoopTypeName$(LoopType[LoopTypeCnt].iLoopType) + " at" + STR$(LoopType[LoopTypeCnt].iLoopLine) + " closed with WEND"
            CALL Abort(sErr$)
        END IF
        CALL BumpDown("Error in Emit_ControlFlow() CASE wend, endwhile")
        FPRINT FP_WRITE, Scoot$, "}"
        IF LoopType[LoopTypeCnt].szUseNeedLabel$ > "" THEN
            FPRINT FP_WRITE, LoopType[LoopTypeCnt].szUseNeedLabel$
        END IF
        DECR LoopTypeCnt
        CALL BumpDown("Unbalanced LOOP")

            CASE "prepend"
        MACRO cPrependVarSize = 8
        GLOBAL PrependVar$[cPrependVarSize]
        GLOBAL PrependCnt
        INCR PrependCnt

        IF PrependCnt = cPrependVarSize THEN
            CALL Abort("Prepend depth exceeded")
        END IF

        CALL BuildDelimStr(2, Ndx, PrependVar$[PrependCnt])

            CASE "endprepend"
        DECR PrependCnt

        IF PrependCnt < 0 THEN
            CALL Abort("Too many END PREPENDs.")
        END IF

            CASE "with"
        MACRO cWithVarSize = 8
        GLOBAL WithVar$[cWithVarSize]
        GLOBAL WithCnt

        INCR WithCnt

        IF WithCnt = cWithVarSize THEN
            CALL Abort("[With] depth exceeded")
        END IF

        CALL BuildStr(2, Ndx, WithVar$[WithCnt])

            CASE "endwith"
        IF COM_open_WITH_statement THEN
            IF COM_open_WITH_statement > 1 THEN
                FPRINT FP_WRITE, Scoot$, "COM_dispatch_storage_index--;"
                FPRINT FP_WRITE, Scoot$, "COM_dispatch_at_offset = COM_dispatch_storage[COM_dispatch_storage_index];"
            ELSE
                FPRINT FP_WRITE, Scoot$, "COM_dispatch_at_offset = 0;"
                FPRINT FP_WRITE, Scoot$, "COM_dispatch_storage_index = 0;"
            END IF
            FPRINT FP_WRITE, Scoot$, "COM_reset_disp_chain(&", COM_with_temp_str_name$, ");"
            DECR COM_open_WITH_statement
        ELSE
            DECR WithCnt
        END IF

            CASE "goto"
        IF SelectState[StateIdx].CaseFlag THEN SelectState[StateIdx].NoBreak = TRUE
        FPRINT FP_WRITE, Scoot$, "goto ", UCASE$(Stk$[2]), ";"

            CASE "gosub"
        Use_GoSub = TRUE
        FPRINT FP_WRITE, Scoot$, "if (setjmp(GosubStack[GosubNdx++])==0)"; ' Suppress CRLF
        FPRINT FP_WRITE, " goto ", UCASE$(Stk$[2]), ";"

            CASE "return"
        IF Ndx > 1 THEN
            DIM Convert$
            Convert$ = "FUNCTION = "
            FOR INT i = 2 TO Ndx
                Convert$ += Stk$[i]
                Convert$ += SPC$
            NEXT
            Inject(Convert$)
            EXIT FUNCTION
        ELSE
            Use_GoSub = TRUE
            FPRINT FP_WRITE, Scoot$, "longjmp (GosubStack [--GosubNdx],1);"
            FPRINT FP_WRITE, ""
        END IF

            CASE "fallthrough"
        iFallThrough = TRUE

            CASE "case"
        IF SelectState[StateIdx].iStartCase = 0 THEN
            CALL InBlockReSet
        END IF
        SelectState[StateIdx].iStartCase = 0
        CALL InBlockSet
        FOR INT i = 2 TO Ndx
            IF  Stk$[i] = "!=" THEN Stk$[i]   = "<>"
            IF *Stk$[i] = ASC("%")  THEN Stk$[i]   = " % "
            IF *Stk$[i] = ASC("!")  AND  *Stk$[i+1] = ASC("=") THEN Stk$[i] = "<>" : Stk$[i+1] = ""
            IF *Stk$[i] = ASC("<")  AND  *Stk$[i+1] = ASC(">") THEN Stk$[i] = "<>" : Stk$[i+1] = ""
            IF *Stk$[i] = ASC("=")  AND  *Stk$[i+1] = ASC("<") THEN Stk$[i] = "<=" : Stk$[i+1] = ""
            IF *Stk$[i] = ASC("<")  AND  *Stk$[i+1] = ASC("=") THEN Stk$[i] = "<=" : Stk$[i+1] = ""
            IF *Stk$[i] = ASC("=")  AND  *Stk$[i+1] = ASC(">") THEN Stk$[i] = ">=" : Stk$[i+1] = ""
            IF *Stk$[i] = ASC(">")  AND  *Stk$[i+1] = ASC("=") THEN Stk$[i] = ">=" : Stk$[i+1] = ""
            IF isalpha(*Stk$[i]) THEN
                Stk$[i] += SPC$
            END IF
        NEXT

        gTmpStr$ = ""
        For_Next_Error_Detected = FALSE

        IF DataType(CaseVar$) = vt_STRVAR THEN For_Next_Error_Detected = TRUE

        '************************************************************************************
        '  MrBcx added the following to allow "Var AS STRING" in SELECT CASE statements
        '***********************************************************************************
        DIM ss, idx
        IF CheckLocal  (CaseVar$, ADDRESSOF(idx)) = vt_CHAR   THEN ss = TRUE
        IF CheckLocal  (CaseVar$, ADDRESSOF(idx)) = vt_SCHAR  THEN ss = TRUE
        IF CheckGlobal (CaseVar$, ADDRESSOF(idx)) = vt_CHAR   THEN ss = TRUE
        IF CheckGlobal (CaseVar$, ADDRESSOF(idx)) = vt_SCHAR  THEN ss = TRUE
        IF CheckLocal  (CaseVar$, ADDRESSOF(idx)) = vt_STRVAR THEN ss = TRUE
        IF CheckGlobal (CaseVar$, ADDRESSOF(idx)) = vt_STRVAR THEN ss = TRUE
        IF ss = TRUE THEN CaseVar$ += "$"
        '************************************************************************************

        DIM i
        FOR INT A = 2 TO Ndx
            IF INCHR("([", Stk$[A]) THEN INCR i
            IF INCHR(")]", Stk$[A]) THEN DECR i
            IF i THEN
                gTmpStr$ += Stk$[A]
                ITERATE
            END IF

            IF Stk$[A] = "," THEN   ' comma
                IF NOT INCHR("<>=", Stk$[A+1]) THEN
                    gTmpStr$ += " or " + CaseVar$ + "="
                ELSE
                    gTmpStr$ += " or " + CaseVar$
                END IF
                Stk$[A] = ""
                ITERATE
            END IF

            IF Stk$[A] = "&&" THEN
                gTmpStr$ += " and " + CaseVar$
                Stk$[A] = ""
            ELSEIF Stk$[A] = "||" THEN
                gTmpStr$ +=  " or "  + CaseVar$
                Stk$[A] = ""
            ELSE
                gTmpStr$ += Stk$[A]
            END IF
        NEXT
        DIM szDrop$
        IF SelectState[StateIdx].CaseFlag = 0 THEN SelectState[StateIdx].NoBreak = 0
        IF SelectState[StateIdx].CaseFlag THEN
            DIM LszTmp$
            IF iFallThrough = FALSE THEN
                SelectState[StateIdx].CaseFlag--
                IF SelectState[StateIdx].NoBreak = 0 THEN
                    IF SelectState[StateIdx].NoBreak = 0 THEN
                        SelectState[StateIdx].CaseFlag++
                        sprintf(LszTmp, "goto L%i;", SelectState[StateIdx].iJumpTo)
                        FPRINT FP_WRITE, Scoot$, LszTmp$
                    END IF
                END IF
            ELSE
                sprintf(szDrop, "L%i", LabelGenerator)
                sprintf(LszTmp, "goto L%i;", LabelGenerator++)
                szDrop$ += ":"
                FPRINT FP_WRITE, Scoot$, LszTmp$
                SelectState[StateIdx].CaseFlag--
            END IF
            CALL BumpDown("Unbalanced SELECT")
            FPRINT FP_WRITE, Scoot$, "}"
            CALL BumpDown("Unbalanced SELECT")
        END IF

        SelectState[StateIdx].CaseFlag++

        IF iMatchLft(CaseVar$, " BAND ") THEN
            SelectState[StateIdx].NoBreak = 1
            Src$ = "IF " + gTmpStr$ + CaseVar$ + " Then "
        ELSE
            IF INCHR("<>=", gTmpStr$) AND NOT IsQuoted(gTmpStr$) THEN
                Src$ = "IF " + CaseVar$ + gTmpStr$ + " Then "
            ELSE
                Src$ = "IF " + CaseVar$ + " = " + gTmpStr$ + " Then "
            END IF
        END IF

        Inject(Src$)
        IF iFallThrough THEN Inject(szDrop$)
        iFallThrough = FALSE

            CASE "select"
        LoopType[++LoopTypeCnt].iLoopType = lt_SELECT
        LoopType[LoopTypeCnt].iJumpTo = LabelGenerator++
        CALL DoGoto(LoopTypeCnt, 0)
        LoopType[LoopTypeCnt].iLoopLine = LineNum[FileNdx]
        CALL BuildStr(3, Ndx, CaseVar$)
        CALL PushSelectState(CaseVar$)
        SelectState[StateIdx].iStartCase = 1
        SelectState[StateIdx].CaseFlag = 0
        SelectState[StateIdx].iJumpTo = LoopType[LoopTypeCnt].iJumpTo
        iFallThrough = FALSE

            CASE "caseelse"
        IF SelectState[StateIdx].iStartCase = 0 THEN
            CALL InBlockReSet
        END IF

        CALL InBlockSet
        SelectState[StateIdx].iStartCase = 0
        SelectState[StateIdx].CaseElseFlag = TRUE
        IF SelectState[StateIdx].CaseFlag THEN
            CALL BumpDown("Unbalanced SELECT")
            FPRINT FP_WRITE, Scoot$, "}"
            CALL BumpDown("Unbalanced SELECT")
            FPRINT FP_WRITE, Scoot$, "else"
            CALL BumpUp
            FPRINT FP_WRITE, Scoot$, "{"
            CALL BumpUp
        END IF

            CASE "endselect"
        IF SelectState[StateIdx].iStartCase = 0 THEN
            CALL InBlockReSet
        END IF

        IF LoopTypeCnt = 0 THEN
            Abort("Too many end loops")
        END IF

        IF LoopType[LoopTypeCnt--].iLoopType <> lt_SELECT THEN
            DIM STATIC sErr$

            sErr$ = LoopTypeName$(LoopType[LoopTypeCnt+1].iLoopType) + " at" + STR$(LoopType[LoopTypeCnt+1].iLoopLine) + " closed with END SELECT"
            Abort(sErr$)
        END IF

        IF SelectState[StateIdx].CaseFlag = 0 THEN
            IF SelectState[StateIdx].CaseElseFlag = 0 THEN
                CALL Abort("Missing case statement before select end")
            ELSE
                CALL Abort("Missing case statement before case else")
            END IF
        END IF

        CALL BumpDown("Unbalanced SELECT")
        FPRINT FP_WRITE, Scoot$, "}"
        CALL BumpDown("Unbalanced SELECT")

        IF SelectState[StateIdx].CaseFlag > 1 THEN
            DIM STATIC LszTmp$
            sprintf(LszTmp, "L%i:;", SelectState[StateIdx].iJumpTo)
            FPRINT FP_WRITE, LszTmp$
        END IF

        SelectState[StateIdx].NoBreak = SelectState[StateIdx].CaseElseFlag = 0
        CALL PopSelectState(CaseVar$)

            CASE "for"
        IF iMatchWrd(Stk$[2], "each") THEN  ' "each" becomes reserved keyword
            ' beginning of for each - collections support
            DIM RAW foreachlocal$
            DIM RAW temp_parms$
            DIM RAW ComVar$

            ComVar$ = Stk$[3]
            Use_COM_Collections = Use_COM = ComSwitchON = TRUE
            FPRINT FP_WRITE, Scoot$, " VariantClear(&COM_ack_var);"
            FPRINT FP_WRITE, Scoot$, " COM_enum_var = NULL;"
            FPRINT FP_WRITE, Scoot$, " COM_long_coll = 0;"
            IF NOT IsVariableComObject(ComVar$) THEN FPRINT FP_WRITE, Scoot$, "OBJECT ", ComVar$, ";"
            FPRINT FP_WRITE, Scoot$, "ZeroMemory((PVOID)&", ComVar$, ",sizeof(OBJECT));"
            LoopLocalVar[LoopLocalCnt++] = 0
            COM_FOREACH_enumerator = TRUE
            foreachlocal$ = MID$(Src$, INSTR(Src$, " in ", 1, 1) + 3)
            IF NOT IsVariableComObject(ComVar$) THEN Add_COM_Local_Variable(ComVar$)

            IF INCHR(foreachlocal$, ".") THEN
                COM_Parse_GetProperty("COM_ack_var", foreachlocal$)
                temp_parms$ = TRIM$(EXTRACT$(foreachlocal$, "."))
            ELSE
                temp_parms$ = TRIM$(foreachlocal$)
            END IF

            COM_FOREACH_enumerator = FALSE

            FPRINT FP_WRITE, Scoot$, "COM_GetEnum_iface = TRUE;"
            FPRINT FP_WRITE, Scoot$, "COM_invoke(&", temp_parms$, ", L", DDQ$, ","
            FPRINT FP_WRITE, Scoot$, "DISPATCH_PROPERTYGET|DISPATCH_METHOD, &COM_ack_var);"
            FPRINT FP_WRITE, Scoot$, "COM_reset_disp_chain(&", temp_parms$ , ");"
            FPRINT FP_WRITE, Scoot$, "COM_GetEnum_iface = FALSE;\n"

            FPRINT FP_WRITE, Scoot$, "for(;;) { // for each construction ..."
            CALL BumpUp
            FPRINT FP_WRITE, Scoot$, "if (FAILED(COM_last_HR)) {"
            FPRINT FP_WRITE, Scoot$, "  COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("Get object enumerator: No Collections!"), "));"
            FPRINT FP_WRITE, Scoot$, "  break;"
            FPRINT FP_WRITE, Scoot$, "} "

            FPRINT FP_WRITE, Scoot$, "if (COM_ack_var.vt != VT_DISPATCH && COM_ack_var.vt != VT_UNKNOWN) {"
            FPRINT FP_WRITE, Scoot$, "  COM_last_HR = E_NOINTERFACE;"
            FPRINT FP_WRITE, Scoot$, "  COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("Enum interface not available! Collections unavailable!"), "));"
            FPRINT FP_WRITE, Scoot$, "  VariantClear(&COM_ack_var);"
            FPRINT FP_WRITE, Scoot$, "  break;"
            FPRINT FP_WRITE, Scoot$, "} "

            FPRINT FP_WRITE, Scoot$, "if (COM_ack_var.vt == VT_DISPATCH) {"

            CALL BumpUp

            FPRINT FP_WRITE, Scoot$, "  #ifdef __cplusplus"
            FPRINT FP_WRITE, Scoot$, "  COM_last_HR = COM_ack_var.pdispVal"
            FPRINT FP_WRITE, Scoot$, "  ->QueryInterface(IID_IEnumVARIANT, (void **)&COM_enum_var);"
            FPRINT FP_WRITE, Scoot$, "  #else"
            FPRINT FP_WRITE, Scoot$, "   COM_last_HR = COM_ack_var.pdispVal->lpVtbl"
            FPRINT FP_WRITE, Scoot$, "   ->QueryInterface(COM_ack_var.pdispVal,"
            FPRINT FP_WRITE, Scoot$, "   &IID_IEnumVARIANT, (void **)&COM_enum_var);"
            FPRINT FP_WRITE, Scoot$, "#endif\n"
            FPRINT FP_WRITE, Scoot$, "if (FAILED(COM_last_HR)) {"
            FPRINT FP_WRITE, Scoot$, "   COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("QueryInterface: Get enum variant: No Collections!"), "));"
            FPRINT FP_WRITE, Scoot$, "   VariantClear(&COM_ack_var);"
            FPRINT FP_WRITE, Scoot$, "   break;"
            FPRINT FP_WRITE, Scoot$, "} "

            CALL BumpDown("")

            FPRINT FP_WRITE, Scoot$, "} else if (COM_ack_var.vt == VT_UNKNOWN) {"

            CALL BumpUp

            FPRINT FP_WRITE, Scoot$, "  #ifdef __cplusplus"
            FPRINT FP_WRITE, Scoot$, "    COM_last_HR = COM_ack_var.punkVal"
            FPRINT FP_WRITE, Scoot$, "     ->QueryInterface(IID_IEnumVARIANT, (void **)&COM_enum_var);"
            FPRINT FP_WRITE, Scoot$, "  #else"
            FPRINT FP_WRITE, Scoot$, "    COM_last_HR = COM_ack_var.punkVal->lpVtbl"
            FPRINT FP_WRITE, Scoot$, "    ->QueryInterface(COM_ack_var.punkVal, "
            FPRINT FP_WRITE, Scoot$, "    &IID_IEnumVARIANT, (void **)&COM_enum_var);"
            FPRINT FP_WRITE, Scoot$, "#endif\n"
            FPRINT FP_WRITE, Scoot$, "if (FAILED(COM_last_HR)) {"
            FPRINT FP_WRITE, Scoot$, "  COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("QueryInterface: Get enum variant: No Collections!"), "));"
            FPRINT FP_WRITE, Scoot$, "  VariantClear(&COM_ack_var);"
            FPRINT FP_WRITE, Scoot$, "  break;"
            FPRINT FP_WRITE, Scoot$, "} "

            CALL BumpDown("")

            FPRINT FP_WRITE, Scoot$, "} "
            FPRINT FP_WRITE, Scoot$, "VariantClear(&COM_ack_var);"
            FPRINT FP_WRITE, Scoot$, "break;"
            FPRINT FP_WRITE, Scoot$, "}\n"

            FPRINT FP_WRITE, Scoot$, "  while(COM_enum_var) {"
            FPRINT FP_WRITE, Scoot$, "    BCX_SetNothing(&", ComVar$, ");"
            FPRINT FP_WRITE, Scoot$, "    #ifdef __cplusplus"
            FPRINT FP_WRITE, Scoot$, "      COM_last_HR = COM_enum_var"
            FPRINT FP_WRITE, Scoot$, "     ->Next(1, &", ComVar$, ".pObjects[0], &COM_long_coll);"
            FPRINT FP_WRITE, Scoot$, "    #else"
            FPRINT FP_WRITE, Scoot$, "      COM_last_HR = COM_enum_var->lpVtbl"
            FPRINT FP_WRITE, Scoot$, "     ->Next(COM_enum_var, 1, &", ComVar$, ".pObjects[0], &COM_long_coll);"
            FPRINT FP_WRITE, Scoot$, "    #endif"
            FPRINT FP_WRITE, Scoot$, "    if (FAILED(COM_last_HR)) {"
            FPRINT FP_WRITE, Scoot$, "      COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("Enumeration failed! No Collections!"), "));"
            FPRINT FP_WRITE, Scoot$, "    #ifdef __cplusplus"
            FPRINT FP_WRITE, Scoot$, "       if(COM_enum_var) COM_enum_var->Release();"
            FPRINT FP_WRITE, Scoot$, "    #else"
            FPRINT FP_WRITE, Scoot$, "       if(COM_enum_var) COM_enum_var->lpVtbl"
            FPRINT FP_WRITE, Scoot$, "       ->Release(COM_enum_var);"
            FPRINT FP_WRITE, Scoot$, "    #endif"
            FPRINT FP_WRITE, Scoot$, "    COM_enum_var = NULL;"
            FPRINT FP_WRITE, Scoot$, "    break;"
            FPRINT FP_WRITE, Scoot$, "  } "

            FPRINT FP_WRITE, Scoot$, "  if (", ComVar$, ".pObjects[0].vt != VT_DISPATCH)"
            FPRINT FP_WRITE, Scoot$, "    {"
            FPRINT FP_WRITE, Scoot$, "      VariantClear(&", ComVar$, ".pObjects[0]);"
            FPRINT FP_WRITE, Scoot$, "      COM_long_coll = 0;"
            FPRINT FP_WRITE, Scoot$, "    }"
            FPRINT FP_WRITE, Scoot$, "  else"
            FPRINT FP_WRITE, Scoot$, "    { "
            FPRINT FP_WRITE, Scoot$, "      ", ComVar$, ".pStatus = TRUE;"
            FPRINT FP_WRITE, Scoot$, "      ", ComVar$, ".ipointer = 0;"
            FPRINT FP_WRITE, Scoot$, "      COM_objects_cnt++;"
            FPRINT FP_WRITE, Scoot$, "    }"

            FPRINT FP_WRITE, Scoot$, "  if (0 == COM_long_coll) {"
            FPRINT FP_WRITE, Scoot$, "  #ifdef __cplusplus"
            FPRINT FP_WRITE, Scoot$, "     if(COM_enum_var) COM_enum_var->Release();"
            FPRINT FP_WRITE, Scoot$, "  #else"
            FPRINT FP_WRITE, Scoot$, "     if(COM_enum_var) COM_enum_var->lpVtbl"
            FPRINT FP_WRITE, Scoot$, "     ->Release(COM_enum_var);"
            FPRINT FP_WRITE, Scoot$, "  #endif"
            FPRINT FP_WRITE, Scoot$, "  BCX_SetNothing(&", ComVar$, ");"
            FPRINT FP_WRITE, Scoot$, "  COM_enum_var = NULL;"
            FPRINT FP_WRITE, Scoot$, "  break;"
            FPRINT FP_WRITE, Scoot$, "  }"
            CALL BumpUp
            '******************************************************
        ELSE '        this is a NORMAL For-Next Loop
            '******************************************************
            DIM FFlg
            DIM For1
            DIM For2
            DIM For3
            DIM For4
            DIM Reg$
            DIM xxx$
            DIM yyy$
            DIM zzz$
            DIM qqq$
            DIM Lvar$

            '=============================================================
            '     Allow FreeBasic style: "FOR i AS datatype = 1 TO 10"
            '       Implemented by MrBcx June 2025 in version 828
            '=============================================================
            DIM Scratch$
            Scratch$ = ""
            FOR zz AS LONG = 1 TO Ndx
                Scratch$ += SPC$ + Stk$[zz]
            NEXT
            Scratch$ = FB2BCX(Scratch$)
            FastLexer(Scratch$, SPC$, "=&()[]{}',+-*/<>?;.|:^")
            '=============================================================


            '******************************************************
            FOR INT i = Ndx TO 1 STEP -1
                IF iMatchWrd(Stk$[i], "step") THEN
                    FFlg = TRUE
                    EXIT FOR
                END IF
            NEXT

            IF NOT FFlg THEN
                INCR Ndx
                Stk$[Ndx] = "step"
                INCR Ndx
                Stk$[Ndx] = "1"
            END IF
            '******************************************************
            For_Next_Error_Detected = FALSE

            FOR INT i = 1 TO Ndx
                IF *Stk$[i] = ASC("=") THEN For_Next_Error_Detected = TRUE
            NEXT

            IF For_Next_Error_Detected = FALSE THEN Abort("Missing =")
            '******************************************************
            For_Next_Error_Detected = FALSE

            FOR INT i = 1 TO Ndx
                IF iMatchWrd(Stk$[i], "to") THEN For_Next_Error_Detected = TRUE
            NEXT

            IF For_Next_Error_Detected = FALSE THEN Abort("Missing TO")
            '******************************************************

            Reg$ = LCASE$(Stk$[2])

            SELECT CASE Reg$

                CASE "char", "sbyte"
                Reg$ = SPC$
                LoopLocalVar[LoopLocalCnt++] = 1
                Lvar$ = "signed char "

                CASE "uchar", "ubyte", "byte"
                Reg$ = SPC$
                LoopLocalVar[LoopLocalCnt++] = 1
                Lvar$ = "unsigned char "

                CASE "int", "fint"
                Reg$ = SPC$
                LoopLocalVar[LoopLocalCnt++] = 1
                Lvar$ = "int "

                CASE  "uint"
                Reg$ = SPC$
                LoopLocalVar[LoopLocalCnt++] = 1
                Lvar$ = "unsigned int "

                CASE  "long"
                Reg$ = SPC$
                LoopLocalVar[LoopLocalCnt++] = 1
                Lvar$ = "long "

                CASE "ulong"
                Reg$ = SPC$
                LoopLocalVar[LoopLocalCnt++] = 1
                Lvar$ = "unsigned long "

                CASE "llong", "longlong"
                Reg$ = SPC$
                LoopLocalVar[LoopLocalCnt++] = 1
                Lvar$ = "long long "

                CASE "ulonglong", "uint64"
                Reg$ = SPC$
                LoopLocalVar[LoopLocalCnt++] = 1
                Lvar$ = "unsigned long long "

                CASE "short"
                Reg$ = SPC$
                LoopLocalVar[LoopLocalCnt++] = 1
                Lvar$ = "short "

                CASE "ushort"
                Reg$ = SPC$
                LoopLocalVar[LoopLocalCnt++] = 1
                Lvar$ = "unsigned short "

                CASE "single", "float"
                Reg$ = SPC$
                LoopLocalVar[LoopLocalCnt++] = 1
                Lvar$ = "float "

                CASE "size_t"
                Reg$ = SPC$
                LoopLocalVar[LoopLocalCnt++] = 1
                Lvar$ = "size_t "

                CASE "ssize_t"
                Reg$ = SPC$
                LoopLocalVar[LoopLocalCnt++] = 1
                Lvar$ = "SSIZE_T"

                CASE "int8_t"
                Reg$ = SPC$
                LoopLocalVar[LoopLocalCnt++] = 1
                Lvar$ = "int8_t "

                CASE "int16_t"
                Reg$ = SPC$
                LoopLocalVar[LoopLocalCnt++] = 1
                Lvar$ = "int16_t "

                CASE "int32_t"
                Reg$ = SPC$
                LoopLocalVar[LoopLocalCnt++] = 1
                Lvar$ = "int32_t "

                CASE "int64_t"
                Reg$ = SPC$
                LoopLocalVar[LoopLocalCnt++] = 1
                Lvar$ = "int64_t "

                CASE "uint8_t"
                Reg$ = SPC$
                LoopLocalVar[LoopLocalCnt++] = 1
                Lvar$ = "uint8_t "

                CASE "uint16_t"
                Reg$ = SPC$
                LoopLocalVar[LoopLocalCnt++] = 1
                Lvar$ = "uint16_t "

                CASE "uint32_t"
                Reg$ = SPC$
                LoopLocalVar[LoopLocalCnt++] = 1
                Lvar$ = "uint32_t "

                CASE "uint64_t"
                Reg$ = SPC$
                LoopLocalVar[LoopLocalCnt++] = 1
                Lvar$ = "uint64_t "

                CASE "double"
                Reg$ = SPC$
                LoopLocalVar[LoopLocalCnt++] = 1
                Lvar$ = "double "

                CASE "ldouble"
                Reg$ = SPC$
                LoopLocalVar[LoopLocalCnt++] = 1
                Lvar$ = "long double "
                Use_Ldouble = TRUE

                CASE ELSE
                Reg$ = ""
                LoopLocalVar[LoopLocalCnt++] = 0
            END SELECT

            IF *Reg$ THEN
                FOR INT j = 3 TO Ndx
                    Stk$[j-1] = Stk$[j]
                NEXT
                DECR Ndx
            END IF

            '******************************************************
            ' Every statement now conforms to the following:
            ' FOR xxx = yyy TO zzz STEP qqq
            '******************************************************

            FOR INT i = 2 TO Ndx
                IF Stk$[i] = "=" THEN
                    For1 = i-1       ' xxx spans from Stk$[2] to Stk$[For1]
                    EXIT FOR
                END IF
            NEXT

            FOR INT i = For1 + 2 TO Ndx
                IF iMatchWrd(Stk$[i], "to") THEN
                    For2 = i-1       ' yyy spans from Stk$[For1+2] to Stk$[For2]
                    EXIT FOR
                END IF
            NEXT

            FOR INT i = For2 + 2 TO Ndx
                IF iMatchWrd(Stk$[i], "step") THEN
                    For3 = i-1       ' zzz spans from Stk$[For2+2] to Stk$[For3]
                    EXIT FOR
                END IF
            NEXT

            For4 = For3 + 2          ' qqq spans from Stk$[For4] to Stk$[Ndx]

            CALL BuildCleanStr(2, For1, xxx$)
            CALL BuildCleanStr(For1+2, For2, yyy$)
            CALL BuildCleanStr(For2+2, For3, zzz$)
            CALL BuildCleanStr(For4, Ndx, qqq$)

            Reg$ = Lvar$

            IF IsDecimalNumber (qqq$) THEN
                IF LEFTSTR(qqq$, "-") THEN
                    IF qqq$ = "1" THEN
                        FPRINT FP_WRITE, Scoot$, "for(", Reg$, xxx$, "=", yyy$, "; ", xxx$, ">=" , zzz$, "; " , xxx$, "++)"
                    ELSE
                        IF qqq$ = "1" THEN
                            FPRINT FP_WRITE, Scoot$, "for(", Reg$, xxx$, "=", yyy$, "; ", xxx$, ">=" , zzz$, "; " , xxx$, "++)"
                        ELSE
                            FPRINT FP_WRITE, Scoot$, "for(", Reg$, xxx$, "=", yyy$, "; ", xxx$, ">=" , zzz$, "; " , xxx$, "+=" , qqq$, ")"
                        END IF
                    END IF
                ELSE
                    IF qqq$ = "1" THEN
                        FPRINT FP_WRITE, Scoot$, "for(", Reg$, xxx$, "=", yyy$, "; ", xxx$, "<=" , zzz$, "; " , xxx$, "++)"
                    ELSE
                        FPRINT FP_WRITE, Scoot$, "for(", Reg$, xxx$, "=", yyy$, "; ", xxx$, "<=" , zzz$, "; " , xxx$, "+=" , qqq$, ")"
                    END IF
                END IF
            ELSE
                FPRINT FP_WRITE, Scoot$, "for(", Reg$, xxx$, "=", yyy$, "; (", qqq$, ">=0 ? ", xxx$, "<=" , zzz$, " : ", xxx$, ">=", zzz$, "); " , xxx$, "+=" , qqq$, ")"
            END IF

            CALL BumpUp
            FPRINT FP_WRITE, Scoot$, "{"
            CALL BumpUp
        END IF

        LoopType[++LoopTypeCnt].iLoopType = lt_FORNEXT
        LoopType[LoopTypeCnt].iJumpTo = LabelGenerator++
        LoopType[LoopTypeCnt].szUseNeedLabel$ = ""
        LoopType[LoopTypeCnt].iLoopLine = LineNum[FileNdx]

        CALL InBlockSet

            CASE "next"
        CALL InBlockReSet

        IF LoopTypeCnt = 0 THEN
            CALL Abort("Too many end loops")
        END IF

        IF LoopType[LoopTypeCnt].iLoopType <> lt_FORNEXT THEN
            DIM RAW sErr$
            sErr$ = LoopTypeName$(LoopType[LoopTypeCnt].iLoopType) + " at" + STR$(LoopType[LoopTypeCnt].iLoopLine) + " closed with NEXT"
            CALL Abort(sErr$)
        END IF

        CALL BumpDown("Unbalanced FOR/NEXT")
        FPRINT FP_WRITE, Scoot$, "}"
        DECR LoopLocalVar[LoopLocalCnt]

        IF LoopType[LoopTypeCnt].szUseNeedLabel$ > "" THEN
            FPRINT FP_WRITE, LoopType[LoopTypeCnt].szUseNeedLabel$
        END IF

        DECR LoopTypeCnt
        IF LoopLocalCnt < 0 THEN Abort ("Next without For")
        CALL BumpDown("Unbalanced FOR/NEXT")

            CASE "beginblock"
        CALL InBlockSet
        FPRINT FP_WRITE, Scoot$, "{"
        CALL BumpUp

            CASE "endblock"
        CALL InBlockReSet
        CALL BumpDown("Unbalanced BLOCK/END BLOCK")
        FPRINT FP_WRITE, Scoot$, "}"

            CASE "call"
        DIM STATIC LTmp$
        BuildCleanStr(2, Ndx, LTmp$)
        IF NOT iMatchRgt(LTmp$, ")") THEN
            LTmp$ += "()"
        END IF
        LTmp$ += ";"
        FPRINT FP_WRITE, Scoot$, LTmp$

            CASE "continue"
        FPRINT FP_WRITE, Scoot$, "continue;"

            CASE "end"
        IF Ndx = 1 THEN
            InsertTokens(1, 2, "=", "0")
        END IF

        IF Stk$[2] = "=" THEN
            IF Use_Wingui = FALSE THEN
                FPRINT FP_WRITE, Scoot$, "fflush(stdout);"
            END IF
            FPRINT FP_WRITE, Scoot$, "ExitProcess("; ' Suppress CRLF
            Stk$[++Ndx] = ");"
            CALL WriteCleanTokens(3, Ndx)
            EXIT SELECT
        END IF

        IF iMatchWrd(Stk$[2], "if") THEN
            CALL BumpDown("Unbalanced IF/END IF")
            FPRINT FP_WRITE, Scoot$, "}"
            CALL BumpDown("Unbalanced IF/END IF")
            EXIT SELECT
        END IF

            CASE "endif"
        CALL BumpDown("Extra unindents at ENDIF")
        FPRINT FP_WRITE, Scoot$, "}"
        CALL BumpDown("Extra unindents at ENDIF")

            CASE "endprogram"               ' Force END of main- allow inclusions outside of main
        FPRINT FP_WRITE, ""
        IF Use_Sound THEN
            FPRINT FP_WRITE, Scoot$, "midiOutClose (hMidi);"  ' Added by MrBcx 825
        END IF
        FPRINT FP_WRITE, "return EXIT_SUCCESS;    // End of main program"
        FPRINT FP_WRITE, "}\n\n"
        EndOfProgram = 1

            CASE "if"
        CALL Emit_IfCond("if", eFull)

            CASE "else"
        CALL BumpDown("Unbalanced IF/END IF")
        FPRINT FP_WRITE, Scoot$, "}"
        CALL BumpDown("Unbalanced IF/END IF")
        FPRINT FP_WRITE, Scoot$, "else"
        CALL BumpUp
        FPRINT FP_WRITE, Scoot$, "{"
        CALL BumpUp

            CASE "elseif"
        CALL BumpDown("Unbalanced IF/END IF")
        FPRINT FP_WRITE, Scoot$, "}"
        CALL BumpDown("Unbalanced IF/END IF")
        CALL Emit_IfCond("else if", eFull)

            CASE "xfor"    ' XFOR ... WHILE/UNTIL ... BY ...
        DIM iBy
        DIM iUntil
        DIM iWhile
        DIM STATIC Ndx2
        DIM STATIC iPB
        DIM STATIC iLast
        DIM STATIC Stak$[128]
        DIM STATIC sClose$
        DIM STATIC lszType$

        ' Basic syntax check
        FOR INT ii = 2 TO Ndx
            IF iMatchWrd(Stk$[ii], "while") THEN iWhile = ii
            IF iMatchWrd(Stk$[ii], "until") THEN iUntil = ii
            IF iMatchWrd(Stk$[ii], "by") THEN iBy = ii
        NEXT

        IF iWhile = 0 AND iUntil = 0 THEN CALL Abort("Missing WHILE or UNTIL in XFOR")
        IF iWhile AND iUntil THEN CALL Abort("Can't have both WHILE and UNTIL in XFOR")
        IF iBy = 0 THEN CALL Abort("Missing BY in XFOR")

        iLast = iWhile + iUntil
        lszType$ = ""
        IF iLast > 2 THEN   ' Have initializers
            DIM RAW i = 2
            DIM RAW j = 3
            DO
                DO WHILE Stk$[j] <> "="
                    INCR j
                LOOP
                IF j - i > 1 THEN
                    IF lszType$ <> "" THEN lszType$ += ": RAW "
                    lszType$ += Stk$[j-1]
                    lszType$ += " AS"
                    DO WHILE i < j-1
                        lszType$ += SPC$
                        lszType$ += Stk$[i]
                        Stk$[i++] = ""
                    LOOP
                END IF
                i = j + 1

                iPB = 0
                DO WHILE i <= iLast
                    IF *Stk$[i] = ASC("(") THEN INCR iPB
                    IF *Stk$[i] = ASC(")") THEN DECR iPB
                    IF *Stk$[i] = ASC("[") THEN INCR iPB
                    IF *Stk$[i] = ASC("]") THEN DECR iPB
                    IF iPB = 0 AND Stk$[i] = "," THEN EXIT DO
                    INCR i
                LOOP
                INCR i
                j = i + 1
            LOOP UNTIL i >= iLast
        END IF
        Stak$[1] = "for("
        sClose$ = "; "

        DIM RAW jj = 2
        DIM RAW ii = 2

        DO WHILE ii <= Ndx
            IF Stk$[ii] <> "" THEN
                IF iMatchWrd(Stk$[ii], "while") THEN
                    Stk$[ii] = "; "
                    iLast = jj
                END IF
                IF iMatchWrd(Stk$[ii], "until") THEN
                    Stk$[ii] = "; !("
                    sClose$ = ");"
                    iLast = jj
                END IF
                IF iMatchWrd(Stk$[ii], "by")    THEN
                    Stk$[ii] = sClose$
                    iBy = jj
                END IF
                Stak$[jj] = Stk$[ii]
                INCR jj
            END IF
            INCR ii
        LOOP
        Ndx2 = jj-1
        IF NOTNULL(lszType$) THEN
            CALL BumpUp
            FPRINT FP_WRITE, Scoot$, "{"
            CALL InBlockSet
            lszType$ = "RAW " + lszType$
            LoopLocalVar[LoopLocalCnt++] = 1
            ii = iMatchNQ (lszType$, ": RAW ")
            DO WHILE ii
                Src$ = LEFT$(lszType$, ii-1)
                lszType$ = MID$(lszType$, ii+2)
                PassOne = TRUE
                Inject(Src$)
                ii = iMatchNQ (lszType$, ": RAW ")
            LOOP
            Src$ = lszType$
            PassOne = TRUE
            Inject(Src$)
        ELSE
            LoopLocalVar[LoopLocalCnt++] = 0
        END IF

        Stk$[1] = "while"
        FOR INT k = iLast+1 TO iBy-1
            Stk$[k-iLast+1] = Stak$[k]
        NEXT

        Ndx = iBy-iLast
        Stk$[Ndx+1] = ""

        FOR INT m = 1 TO Ndx
            IF Stk$[m] = "&&" THEN Stk$[m] = "&& "
        NEXT

        FPRINT FP_WRITE, Scoot$;               ' Suppress CRLF
        FOR INT k = 1 TO Ndx2
            IF k <= iLast OR k >= iBy THEN
                FPRINT FP_WRITE, Stak$[k];     ' Suppress CRLF
            END IF
            IF k = iLast THEN
                CALL Emit_IfCond("while", ePart)
            END IF
        NEXT

        FPRINT FP_WRITE, ")"
        CALL BumpUp
        FPRINT FP_WRITE, Scoot$, "{"
        CALL BumpUp
        LoopType[++LoopTypeCnt].iLoopType = lt_FORXNEXT
        LoopType[LoopTypeCnt].iJumpTo = LabelGenerator++
        LoopType[LoopTypeCnt].szUseNeedLabel$ = ""
        LoopType[LoopTypeCnt].iLoopLine = LineNum[FileNdx]
        CALL InBlockSet

            CASE "xnext"
        CALL InBlockReSet

        IF LoopTypeCnt = 0 THEN
            Abort("Too many end loops")
        END IF

        IF LoopType[LoopTypeCnt].iLoopType <> lt_FORXNEXT THEN
            DIM RAW sErr$
            sErr$ = LoopTypeName$(LoopType[LoopTypeCnt].iLoopType) + " at" + _
            STR$(LoopType[LoopTypeCnt].iLoopLine) + " closed with NEXT"
            Abort(sErr$)
        END IF

        CALL BumpDown("Unbalanced XFOR/XNEXT")
        FPRINT FP_WRITE, Scoot$, "}"

        IF NOTZERO(LoopLocalVar[--LoopLocalCnt]) THEN
            CALL InBlockReSet
            FPRINT FP_WRITE, Scoot$, "}"
            CALL BumpDown("Unbalanced XFOR/XNEXT")
        END IF

        IF LoopType[LoopTypeCnt].szUseNeedLabel$ > "" THEN
            FPRINT FP_WRITE, LoopType[LoopTypeCnt].szUseNeedLabel$
        END IF

        DECR LoopTypeCnt
        IF LoopLocalCnt < 0 THEN Abort ("XNEXT without XFOR")
        CALL BumpDown("Unbalanced XFOR/XNEXT")

            CASE "do"
        CALL InBlockSet

        IF iDoWhile THEN
            LoopType[++LoopTypeCnt].iLoopType = iDoWhile
        ELSE
            LoopType[++LoopTypeCnt].iLoopType = lt_DOLOOP
        END IF
        LoopType[LoopTypeCnt].iJumpTo = LabelGenerator++
        LoopType[LoopTypeCnt].szUseNeedLabel$ = ""
        iDoWhile = 0

        LoopType[LoopTypeCnt].iLoopLine = LineNum[FileNdx]
        FPRINT FP_WRITE, Scoot$, "for(;;)"
        CALL BumpUp
        FPRINT FP_WRITE, Scoot$, "{"
        CALL BumpUp

            CASE "loop"
        CALL InBlockReSet

        IF LoopTypeCnt = 0 THEN
            Abort("Too many end loops")
        END IF

        IF iLoopCond THEN
            IF LoopType[LoopTypeCnt].iLoopType <> lt_DOLOOP THEN
                DIM RAW sErr$
                sErr$ = LoopTypeName$(LoopType[LoopTypeCnt].iLoopType) + " at" + _
                STR$(LoopType[LoopTypeCnt].iLoopLine) + " closed with LOOP CONDITION"
                CALL Abort(sErr$)
            END IF
        END IF

        iLoopCond = 0

        CALL BumpDown("Unbalanced DO/LOOP")
        FPRINT FP_WRITE, Scoot$, "}"

        IF LoopType[LoopTypeCnt].szUseNeedLabel$ > "" THEN
            FPRINT FP_WRITE, LoopType[LoopTypeCnt].szUseNeedLabel$
        END IF

        DECR LoopTypeCnt
        CALL BumpDown("Unbalanced DO/LOOP")

            CASE ELSE
        CALL Emit_Old(FuncRetnFlag)
    END SELECT
    RETURN 0
END FUNCTION ' Emit_ControlFlow



FUNCTION Emit_KeyboardProcs(sWord$, FuncRetnFlag AS PINT)
    SELECT CASE sWord$

        CASE "input"
        CALL Emit_InputCode

        CASE ELSE
        CALL Emit_Old(FuncRetnFlag)

    END SELECT
    RETURN 0
END FUNCTION ' Emit_KeyboardProcs




FUNCTION Emit_QsortIdxProcs(sWord$, FuncRetnFlag AS PINT)
    ' qsortidx idx, size_of_array, A$, key
    UNREFERENCED_PARAMETER(sWord)
    UNREFERENCED_PARAMETER(FuncRetnFlag)

    DIM i
    DIM LTmp$, Stptr$, StMem$, StName$
    Use_BcxTempStr = TRUE
    Var$ = Clean$(Stk$[2])             ' index array
    BuildCleanStr(4, Ndx-4, LTmp$)     ' allow size to be an expression

    FPRINT FP_WRITE, Scoot$, "Key = ", Stk[Ndx], ";"

    IF Var$ <> "0" THEN
        FPRINT FP_WRITE, Scoot$, "int iDx;"
        FPRINT FP_WRITE, Scoot$, "for(iDx=0; iDx<", LTmp$, "; iDx += 1) ";
        FPRINT FP_WRITE, Var$, "[iDx]=iDx;"
    END IF

    IF NOT INCHR(Stk$[Ndx-2], ".") THEN   ' Check if this is a struct sort
        Use_Idxqsort = Use_BCX_stricmp = TRUE
        FPRINT FP_WRITE, Scoot$, "pppStr = ", Clean$(Stk[Ndx-2]), ";"
        FPRINT FP_WRITE, Scoot$, "qsort(", Var$, ",", LTmp$, ",sizeof(int), IdxCompare);"
    ELSE
        StMem$ = REMAIN$(Clean$(Stk$[Ndx-2]), ".")
        Stptr$ = EXTRACT$(Stk$[Ndx-2], ".")

        IF CheckLocal(Stptr, ADDRESSOF(i)) <> vt_UNKNOWN THEN
            StName$ = TypeDefs[LocalVars[i].VarDef].VarName$
        ELSE
            IF CheckGlobal(Stptr, ADDRESSOF(i)) <> vt_UNKNOWN THEN
                StName$ = TypeDefs[GlobalVars[i].VarDef].VarName$
            END IF
        END IF

        IF Var$ <> "0" THEN
            Use_IdxqsortSt = Use_BCX_stricmp = TRUE
            FPRINT FP_WRITE, Scoot$, "cmp1 =(char*)(", Stptr$ , ") + offsetof(", StName$, ",", StMem$, ");"
            FPRINT FP_WRITE, Scoot$, "StructSize = sizeof(", StName$, ");"
            FPRINT FP_WRITE, Scoot$, "qsort(", Var$, ",", LTmp$, ", sizeof(int), IdxCompareSt);"
        ELSE
            Use_PtrqsortSt = Use_BCX_stricmp = TRUE
            FPRINT FP_WRITE, Scoot$, "OffSet = offsetof(", StName$, ",", StMem$, ");"
            FPRINT FP_WRITE, Scoot$, "qsort(", Stptr$, ",", LTmp$, ", sizeof(", StName$, "), PtrCompareSt);"
        END IF
    END IF
    RETURN 0
END FUNCTION ' Emit_QsortIdxProcs


FUNCTION Emit_QsortProcs(sWord$, FuncRetnFlag AS PINT)
    ' qsort [dynamic] A$,size_of_array[,ascending|descending][,NATURAL]
    UNREFERENCED_PARAMETER(sWord)
    UNREFERENCED_PARAMETER(FuncRetnFlag)

    DIM RAW iAlphaNumeric = FALSE
    DIM RAW LTmp$
    DIM RAW order = 0
    DIM RAW QST = 0
    DIM RAW vt

    Use_BcxTempStr = TRUE

    IF iMatchWrd(Stk$[Ndx], "sensitive") THEN
        Use_Strqsorts = TRUE
        DECR Ndx, 2
    END IF

    IF iMatchWrd(Stk$[2], "dynamic") THEN
        QST = TRUE
        LShiftStk(2)
    END IF

    IF iMatchWrd(Stk$[Ndx], "natural") THEN
        iAlphaNumeric = Use_AlphaNumeric = TRUE
        DECR Ndx, 2
    END IF

    IF iMatchWrd(Stk$[Ndx], "ascending")  THEN
        order = 2
        DECR Ndx, 2
    END IF

    IF iMatchWrd(Stk$[Ndx], "descending") THEN
        order = 1
        DECR Ndx, 2
    END IF

    IF order = 0 THEN order = 2      ' default to ascending
    CALL BuildStr(4, Ndx, LTmp$)     ' allow size to be an expression
    Var$ = Clean$(Stk$[2])
    vt = DataType(Stk$[2])

    IF vt <> vt_STRVAR AND vt <> vt_INTEGER AND vt <> vt_SINGLE AND vt <> vt_DOUBLE THEN
        vt = CheckType(Stk$[2])
    END IF

    FPRINT FP_WRITE, Scoot$, "qsort(", Var$, ",", Clean$(LTmp$); ' Suppress CRLF

    SELECT CASE vt

        CASE vt_STRVAR
        IF NOT QST THEN
            IF order = 1 THEN
                IF iAlphaNumeric THEN
                    FPRINT FP_WRITE, ",sizeof(", Var$, "[0]),AlphaNumericD);"
                    Use_AlphaNumericD = TRUE
                ELSE
                    IF Use_Strqsorts = TRUE THEN
                        FPRINT FP_WRITE, ",sizeof(", Var$, "[0]),StrCompareDs);"
                        Use_Strqsortds = TRUE
                        Use_Strqsorts = FALSE
                    ELSE
                        FPRINT FP_WRITE, ",sizeof(", Var$, "[0]),StrCompareD);"
                        Use_Strqsortd = Use_BCX_stricmp = TRUE
                    END IF
                END IF
            ELSE
                IF iAlphaNumeric THEN
                    FPRINT FP_WRITE, ",sizeof(", Var$, "[0]),AlphaNumericA);"
                    Use_AlphaNumericA = TRUE
                ELSE
                    IF Use_Strqsorts = TRUE THEN
                        FPRINT FP_WRITE, ",sizeof(", Var$, "[0]),StrCompareAs);"
                        Use_Strqsortas = TRUE
                        Use_Strqsorts = FALSE
                    ELSE
                        FPRINT FP_WRITE, ",sizeof(", Var$, "[0]),StrCompareA);"
                        Use_Strqsorta = Use_BCX_stricmp = TRUE
                    END IF
                END IF
            END IF
        ELSE
            IF order = 1 THEN
                IF iAlphaNumeric THEN
                    FPRINT FP_WRITE, ",sizeof(", Var$, "[0]),DynAlphaNumericD);"
                    Use_DynAlphaNumericD = TRUE
                ELSE
                    IF Use_Strqsorts = TRUE THEN
                        FPRINT FP_WRITE, ",sizeof(", Var$, "[0]),DynStrCompareDs);"
                        Use_DynStrqsortds = TRUE
                        Use_Strqsorts = FALSE
                    ELSE
                        FPRINT FP_WRITE, ",sizeof(", Var$, "[0]),DynStrCompareD);"
                        Use_DynStrqsortd = Use_BCX_stricmp = TRUE
                    END IF
                END IF
            ELSE
                IF iAlphaNumeric THEN
                    FPRINT FP_WRITE, ",sizeof(", Var$, "[0]),DynAlphaNumericA);"
                    Use_DynAlphaNumericA = TRUE
                ELSE
                    IF Use_Strqsorts = TRUE THEN
                        FPRINT FP_WRITE, ",sizeof(", Var$, "[0]),DynStrCompareAs);"
                        Use_DynStrqsortas = TRUE
                        Use_Strqsorts = FALSE
                    ELSE
                        FPRINT FP_WRITE, ",sizeof(", Var$, "[0]),DynStrCompareA);"
                        Use_DynStrqsorta = Use_BCX_stricmp = TRUE
                    END IF
                END IF
            END IF
        END IF

        CASE vt_INTEGER
        IF order = 1 THEN
            FPRINT FP_WRITE, ",sizeof(int), NumCompareDint);"
            Use_Numqsortdint = TRUE
        ELSE
            FPRINT FP_WRITE, ",sizeof(int), NumCompareAint);"
            Use_Numqsortaint = TRUE
        END IF

        CASE vt_SINGLE
        IF order = 1 THEN
            FPRINT FP_WRITE, ",sizeof(float), NumCompareDfloat);"
            Use_Numqsortdfloat = TRUE
        ELSE
            FPRINT FP_WRITE, ",sizeof(float), NumCompareAfloat);"
            Use_Numqsortafloat = TRUE
        END IF

        CASE vt_DOUBLE
        IF order = 1 THEN
            FPRINT FP_WRITE, ",sizeof(double), NumCompareDdouble);"
            Use_Numqsortddouble = TRUE
        ELSE
            FPRINT FP_WRITE, ",sizeof(double), NumCompareAdouble);"
            Use_Numqsortadouble = TRUE
        END IF

        CASE ELSE
        IF order = 1 THEN
            FPRINT FP_WRITE, ",sizeof(int), NumCompareDint);"
            Use_Numqsortdint = TRUE
        ELSE
            FPRINT FP_WRITE, ",sizeof(int), NumCompareAint);"
            Use_Numqsortaint = TRUE
        END IF
    END SELECT
    RETURN 0
END FUNCTION ' Emit_QsortProcs



FUNCTION Emit_template(sWord$, FuncRetnFlag AS PINT)
    SELECT CASE sWord$
        CASE "template"
        ' template <typename Container, typename ValueType, int nPropType> class property
        DIM RAW LTmp$
        UsingTemplate = TRUE
        CALL BuildDelimStr(1, Ndx, LTmp$)
        FPRINT FP_UDT, LTmp$
        FP_WRITE = FP_UDT

        CASE "endtemplate"
        UsingTemplate = FALSE
    END SELECT
    *FuncRetnFlag = 0
    RETURN 0
END FUNCTION




SUB AddProto(szProto$)
    IF UsingTemplate = FALSE THEN
        INCR ProtoCnt

        IF ProtoCnt = cMAXProtoType THEN
            CALL Abort("Maximum Prototypes Exceeded.")
        END IF

        ProtoType[ProtoCnt].Prototype$ = szProto$
    END IF
END SUB ' AddProto



FUNCTION Emit_Const (sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(sWord$)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    DIM STATIC i
    DIM STATIC Buffer$
    Buffer$ = ""
    IF InClass THEN
        FOR i = 1 TO Ndx
            IF IsValidName(Stk$[i]) AND IsValidName(Stk$[i+1]) THEN Stk$[i] += SPC$
            Buffer$ += Stk$[i]
        NEXT
        FPRINT FP_UDT, Scoot$, Buffer$, ";"
    ELSE
        Stk$[1] = ""
        IF Stk$[3] = "(" THEN
            IF cMaxMacros = MacroCount THEN
                CALL Abort("Max Const Macros exceeded.")
            END IF
            ConstMacro$[MacroCount++] = Stk$[2]
        END IF
        FOR i = 2 TO Ndx
            IF *Stk$[i] = ASC("=") THEN
                INCR i
                EXIT FOR
            ELSE
                IF IsDecimalNumber(Stk$[i]) THEN Stk$[1] += SPC$
                Stk$[1] += Stk$[i]
            END IF
        NEXT
        Stk$[1] = "#define " + Clean$(Stk$[1]) + SPC$
        FOR INT j = i TO Ndx
            IF NOT IsQuoted(Stk$[j]) THEN REMOVE "$" FROM Stk$[j]
            IF (IsValidName(Stk$[j]) AND IsValidName(Stk$[j+1])) OR _
            IsDecimalNumber(Stk$[j+1]) THEN Stk$[j] += SPC$
            Buffer$ += Stk$[j]
        NEXT
        Buffer$ = Stk$[1] + Buffer$
        REPLACE "( " WITH "(" IN Buffer$
        IF InConditional THEN
            IF InFunction THEN
                FPRINT FP_WRITE, Buffer$
            ELSE
                IF ConstLastDef$ <> "FP_CST" THEN
                    FPRINT FP_CST, InIfDef$, "// FP_CST"
                    ConstLastDef$ = "FP_CST"
                END IF
                FPRINT FP_CST, Buffer$
            END IF
        ELSE
            FPRINT FP_CST, Buffer$
        END IF
    END IF
    RETURN 0
END FUNCTION ' Emit_Const




FUNCTION Emit_Redim (sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(sWord$)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    '*******************************
    ' EXAMPLES
    ' REDIM b$ * 14
    ' REDIM PRESERVE b$ * 20
    ' REDIM a$[10]
    ' REDIM PRESERVE a$[20]
    '*******************************
    LOCAL VarDataType
    LOCAL IsAsterisk
    LOCAL BC
    LOCAL VI AS VARINFO PTR
    LOCAL vt, id, dms, i
    LOCAL IsPreserve, LoIndex, HiIndex
    LOCAL szVarName$, Tmpz$, SOF$

    CALL Process_Option_Base

    IsPreserve = iMatchWrd(Stk$[2], "preserve")
    LoIndex = 2 + IsPreserve

    VarDataType = DataType(Stk$[LoIndex])
    szVarName$ = Clean$(Stk$[LoIndex])
    IsAsterisk = iMatchWrd(Stk$[LoIndex + 1], "*")

    CALL ValidateVarName(szVarName$)

    HiIndex = GetAsPosB(Ndx, 1) - 1
    IF HiIndex < 1 THEN HiIndex = Ndx

    DO WHILE HiIndex > LoIndex
        IF Stk$[HiIndex] = "[" THEN
            DECR BC
        ELSEIF Stk$[HiIndex] = "]" THEN
            INCR BC
            IF BC = 1 THEN
                DECR HiIndex
                ITERATE
            END IF
        END IF
        IF BC = 0 THEN
            IF Stk$[HiIndex-1] <> "]" THEN EXIT DO
            Tmpz$ = "," + Tmpz$
        ELSE
            Tmpz$ = Stk$[HiIndex] + Tmpz$
        END IF
        DECR HiIndex
    LOOP

    vt = CheckLocal(szVarName$, ADDRESSOF(id))

    IF vt = vt_UNKNOWN THEN
        vt = CheckGlobal(szVarName$, ADDRESSOF(id))

        IF vt = vt_UNKNOWN THEN
            '*******************************************
            ' MrBcx 827 - added REDIM without prior DIM
            '*******************************************
            '   Abort("Can not REDIM " + szVarName$ + " not previously dimensioned")
            DIM szTmp$
            DIM startNdx

            IF Stk$[3] = "*" OR Stk$[5] = "*" THEN ' Redim SomeString$ * 100 / REDIM somestring AS STRING * 100
                szTmp$ = "DIM "
                FOR INT j = 2 TO Ndx
                    szTmp$ += Stk$[j] + SPC$
                NEXT
                Inject(szTmp$)
                EXIT FUNCTION
            END IF

            IF Stk$[2] ?? "PRESERVE" THEN startNdx = 3 ELSE startNdx = 2
            FOR INT j = startNdx TO Ndx
                szTmp$ += Stk$[j] + SPC$
            NEXT
            IF InWinMain OR InMain = TRUE THEN
                Inject ("GLOBAL dynamic " + szTmp$ )
            ELSE
                Inject ("LOCAL dynamic " + szTmp$)
            END IF
            EXIT FUNCTION
            '*******************************************
        END IF

        VI = ADDRESSOF(GlobalVars[id])
    ELSE
        VI = ADDRESSOF(LocalVars[id])
    END IF

    dms = VI->VarPntr

    IF vt = vt_STRUCT OR vt = vt_UDT OR vt = vt_UNION THEN
        SOF$ = GetElement$(LoIndex, ADDRESSOF(vt), ADDRESSOF(dms), VI->VarDef)
        i = Ndx
        Ndx = HiIndex-1
        CALL AsmUnknownStructs(1)
        Ndx = i
        CALL RemEmptyTokens
        szVarName$   = Clean$(Stk$[LoIndex])
        IsAsterisk = iMatchWrd(Stk$[LoIndex + 1], "*")
    ELSE
        SOF$ = GetVarTypeName$(vt)
    END IF

    '****************************************************************************************************************
    IF TRIM$(SOF$) <> "" THEN   ' 812  MrBcx added this new opening "IF" to patch the UDT [] argument bug
        '                       ' GetVarTypeName$() returns "" when the REDIM "variable" is a SUB/FUNCTION argument.
        '************************************************************************************************************
        IF iMatchWrd(Stk$[Ndx-1], "as") THEN
            IF SOF$ <> Stk$[Ndx] AND NOT iMatchWrd(Stk$[Ndx], "string") THEN
                CALL Abort("Can not change types for variable " + szVarName$ + _
                " previously defined as " + SOF$ + " on line" + STR$(VI->VarLine))
            END IF
            IF iMatchWrd(Stk$[Ndx], "string") THEN
                DECR Ndx
                CALL AppendTokens(3, "[", "BCXSTRSIZE", "]")
            ELSE
                DECR Ndx, 2
            END IF
        ELSE
            IF ( (vt = vt_CHAR OR vt = vt_SCHAR) AND VarDataType = vt_STRVAR AND IsAsterisk = 0) OR vt = vt_CHARPTR THEN
                CALL AppendTokens(3, "[", "BCXSTRSIZE", "]")
            END IF
        END IF
    END IF

    '****************************************************************************************************************
    IF SOF$ = "" THEN SOF$ = Stk$[Ndx]   ' MrBcx 812  UDT arg bug patch - I force SOF$ to be the "AS" datatype
    '****************************************************************************************************************

    IF Stk$[3 + IsPreserve] = "[" THEN
        IF IsPreserve THEN
            LoIndex = 4
        ELSE
            FPRINT FP_WRITE, Scoot$, "if (", szVarName$ + ") { DestroyArr((void **)", szVarName$ + ",", STR$(dms) + ", 1); ", szVarName$ + "=NULL; }"
            LoIndex = 3
        END IF
        Use_DynamicA = Use_BcxTempStr =TRUE
        Tmpz$ = ""
        FOR i = LoIndex TO Ndx
            IF *Stk$[i] = ASC("[") THEN
                INCR i
                BC = 1
                DO WHILE BC > 0
                    IF *Stk$[i] = ASC("[") THEN
                        INCR BC
                        Tmpz$ += Stk$[i]
                    ELSE
                        IF *Stk$[i] = ASC("]") THEN
                            DECR BC
                            IF BC = 0 AND i < Ndx THEN
                                Tmpz$ += ","
                            END IF
                            IF BC THEN
                                Tmpz$ += Stk$[i]
                            END IF
                        ELSE
                            Tmpz$ += Stk$[i]
                        END IF
                    END IF
                    INCR i
                LOOP
                DECR i
            END IF
        NEXT

        Tmpz$ = Clean$(Tmpz$)

        IF vt = vt_STRLIT OR vt = vt_DECFUNC OR vt = vt_NUMBER OR (vt = vt_VOID AND INCHR(Stk$[Ndx], "*") = 0) THEN
            CALL Abort(Stk$[Ndx] + " is not a valid type")
        END IF

        IF vt = vt_STRVAR THEN
            SOF$ = "char"
            Tmpz$ += ","
            Tmpz$ += "BCXSTRSIZE"
        END IF

        REPLACE "," WITH ", (size_t)" IN Tmpz$
        FPRINT FP_WRITE, Scoot$, "{"
        '**************************************************************************************************************************************
        ' 812 UDT argument bug patch by MrBcx
        ' Emits a corrupt: "size_t dimensions[1] = {(size_t)ub+1};" --AS--  "size_t dimensions[1] = {(size_t)ub+1, (size_t)};"
        ' My patch below involves buffering that line and then sanitizing it.
        '**************************************************************************************************************************************
        LOCAL szTmp$                                                                                      ' 812 UDT augument bug patch MrBcx
        szTmp$ = "size_t dimensions[" + TRIM$(STR$(dms)) + "] = {(size_t)" + Tmpz$ +  "};"           ' 812 UDT augument bug patch MrBcx
        REPLACE ", (size_t)};"  WITH "};" IN szTmp$                                                       ' 812 UDT augument bug patch MrBcx
        FPRINT FP_WRITE, Scoot$, szTmp$                                                                   ' 812 UDT augument bug patch MrBcx
        '**************************************************************************************************************************************
        ' FPRINT FP_WRITE, Scoot$, "size_t dimensions[", TRIM$(STR$(dms)), "] = {(size_t)", Tmpz$, "};"   ' 812 MrBcx - Replaced w/ above ^^
        '  ^^^  this is the distinction

        IF LEFTSTR(szVarName$, "(*") THEN        ' 827 MrBcx replaced the following line to enable REDIM arrays of UDT by reference in SUBS/FUNCTIONS:
            ' FPRINT FP_WRITE, Scoot$, szVarName$, "= (", SOF$, STRING$(dms-1, 42), ")CreateArr (", szVarName$, ", sizeof(", SOF$, "), ", STR$(IsPreserve, 1), ", ", STR$(dms, 1), ", dimensions);"
            FPRINT FP_WRITE, Scoot$, szVarName$, "= (", SOF$, STRING$(dms-1, 42), ")CreateArr (", szVarName$, ", sizeof(", SOF$, "), ", STR$(IsPreserve, 1), ", ", STR$(dms-1, 1), ", dimensions);"
        ELSE
            FPRINT FP_WRITE, Scoot$, szVarName$, "= (", SOF$, STRING$(dms, 42), ")CreateArr (", szVarName$, ", sizeof(", SOF$, "), ", STR$(IsPreserve, 1), ", ", STR$(dms, 1), ", dimensions);"
        END IF

        FPRINT FP_WRITE, Scoot$, "}"
        GOTO Redim_Exit
    END IF

    IF Stk$[3]= "*" OR (IsPreserve AND Stk$[4]= "*") THEN                             ' DIM MySTRING$ * NumBytes
        IF IsPreserve THEN
            FPRINT FP_WRITE, Scoot$, szVarName$, "=(char*)realloc(", szVarName$, ","; ' Suppress CRLF
            i = 5
        ELSE
            FPRINT FP_WRITE, Scoot$, "free(", szVarName$, ");"
            FPRINT FP_WRITE, Scoot$, szVarName$, "=(char*)calloc(";                   ' Suppress CRLF
            i = 4
        END IF
        IF IsPreserve THEN
            Stk$[++Ndx] = ");"
        ELSE
            Stk$[++Ndx] = ",1);"
        END IF
        CALL WriteCleanTokens(i, Ndx)
        GOTO Redim_Exit FUNCTION
    END IF

    CALL Abort("Invalid REDIM statement")

    Redim_Exit:
    RETURN 0
END FUNCTION ' Emit_Redim




FUNCTION Emit_Extern (sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(sWord$)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    DIM RAW IsVolatile
    DIM RAW IsSubOrFuncPtr
    DIM RAW CVar$
    DIM RAW IsPointer, id, vt
    DIM RAW L_DimType$

    IsSubOrFuncPtr = SubFuncTest()
    CALL Process_Option_Base
    IsVolatile = iMatchWrd(Stk$[2], "volatile")
    CVar$ = Clean$(Stk$[2+IsVolatile])
    CALL ValidateVarName(CVar$)

    IF Stk$[Ndx] = "*" THEN CALL PointerFix
    IF Stk$[Ndx] = "&" THEN
        Stk$[Ndx--] = ""
        Stk$[Ndx] += "&"
    END IF

    IF Stk$[3+IsVolatile] = "*" THEN
        IF IsVolatile THEN
            CALL Abort("volatile dynamic strings not supported")
        END IF
        CALL DimDynaString(CVar$, 2, 0)
        EXIT FUNCTION
    END IF

    IF IsSubOrFuncPtr THEN
        IF IsVolatile THEN
            CALL Abort("volatile SUB/FUNCTION pointers not supported")
        END IF
        IF DimSubFunc(0) THEN EXIT FUNCTION
    END IF

    Var$ = Clean$(Stk$[2+IsVolatile])
    CALL ValidateVarName(Var$)

    IsPointer = 0
    L_DimType$  = ""

    IF iMatchWrd(Stk$[Ndx-1], "as") THEN
        GetTypeInfo(Stk$[Ndx], ADDRESSOF(IsPointer), ADDRESSOF(id), ADDRESSOF(vt))
        Stk$[Ndx] = REMOVE$(Stk$[Ndx], "*")
        CALL BuildStr(3+IsVolatile, Ndx-2, L_DimType$)
    ELSE
        CALL BuildStr(3+IsVolatile, Ndx, L_DimType$)
        vt = DataType(Stk$[2+IsVolatile])
        id = 0
    END IF

    IF vt = vt_STRVAR THEN
        L_DimType$ += "[BCXSTRSIZE]"
    END IF

    IF IsVolatile THEN
        CALL AddGlobal(Var$, vt, id, L_DimType$, IsPointer, 0, 4)
    ELSE
        CALL AddGlobal(Var$, vt, id, L_DimType$, IsPointer, 0, 1)
    END IF
    RETURN 0
END FUNCTION  ' Emit_Extern



FUNCTION Emit_Run(sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(sWord$)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    FPRINT FP_WRITE, Scoot$, "Run ("; ' Suppress CRLF
    Stk$[++Ndx] = ");"
    CALL WriteCleanTokens(2, Ndx)
    RETURN 0
END FUNCTION  ' Emit_Run



FUNCTION Emit_Shell(sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(sWord$)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    DIM RAW LZZ$
    CALL BuildDelimStr(2, Ndx, LZZ$)
    IF ISNULL(LZZ$) THEN LZZ$ = DDQ$
    FPRINT FP_WRITE, Scoot$, "system(", Clean$(LZZ$), ");"
    RETURN 0
END FUNCTION  ' Emit_Shell



FUNCTION Emit_Data(sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(sWord$)
    UNREFERENCED_PARAMETER(FuncRetnFlag)

    FOR INT A = 2 TO Ndx                  ' *******************************
        IF Stk$[A] = "-" THEN             '
            Stk$[A] = "-" + Stk$[A+1]     '
            Stk$[A+1] = ""                '  825 New Block added by MrBcx
            LShiftStk (A +1)              '
        END IF                            '
    NEXT                                  ' *******************************

    FOR INT A = 2 TO Ndx
        IF INCHR(Stk$[A], DQ$) = 0 AND Stk$[A] <> "," THEN
            Stk$[A] = ENC$(Stk$[A])  ' Allow unquoted text
        END IF
        FPRINT FP_DAT, Stk$[A];      ' Suppress CRLF
    NEXT
    FPRINT FP_DAT, ""
    RETURN 0
END FUNCTION ' Emit_Data



FUNCTION Emit_Declare(sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(sWord$)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    DIM RAW TempProto$
    DIM RAW Varcode AS VARCODE
    DIM RAW FP AS FUNCPARSE
    Varcode.IsExported = FALSE
    Varcode.UseInLine = UseInLine
    CALL FuncSubDecs1("sub", 1, Ndx, ADDRESSOF(Varcode)) ' convert [] to pointer * and $[] to [][2048]
    CALL SepFuncArgs(3, ADDRESSOF(FP), TRUE)
    TempProto$ = MakeDecProto$(ADDRESSOF(FP))
    IF NOT NoTypeDeclare THEN
        FPRINT FP_UDT, TempProto$, ";"
    ELSE
        CALL AddProto(TempProto$ + ";")
    END IF
    RETURN 0
END FUNCTION ' Emit_Declare


FUNCTION Emit_Auto (sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(sWord$)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    CALL DimVar(ImAuto)
    RETURN 0
END FUNCTION ' Emit_Auto


FUNCTION Emit_Dim (sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(sWord$)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    CALL DimVar(ImDim)
    RETURN 0
END FUNCTION ' Emit_Dim


FUNCTION Emit_Local (sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(sWord$)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    CALL DimVar(ImLocal)
    RETURN 0
END FUNCTION ' Emit_Local



FUNCTION Emit_PrivateDim (sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(sWord$)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    CALL DimVar(ImCPPPrvDim)
    RETURN 0
END FUNCTION ' Emit_PrivateDim


FUNCTION Emit_Raw (sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(sWord$)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    CALL DimVar(ImRaw)
    RETURN 0
END FUNCTION ' Emit_Raw


FUNCTION Emit_Register (sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(sWord$)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    CALL DimVar(ImRegister)
    RETURN 0
END FUNCTION ' Emit_Register


FUNCTION Emit_Static (sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(sWord$)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    CALL DimVar(ImStatic)
    RETURN 0
END FUNCTION ' Emit_Static



FUNCTION Emit_Clear (sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(sWord$)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    Use_Clear = Use_SysMacros = TRUE
    FPRINT FP_WRITE, Scoot$, "Clear"; ' Suppress CRLF
    IF Stk$[2] <> "(" THEN
        FPRINT FP_WRITE, "("; ' Suppress CRLF
    END IF
    FOR INT i = 2 TO Ndx
        FPRINT FP_WRITE, Clean$(Stk$[i]); ' Suppress CRLF
    NEXT
    IF Stk$[Ndx] <> ")" THEN FPRINT FP_WRITE, ")"; ' Suppress CRLF
    FPRINT FP_WRITE, ";"
    RETURN 0
END FUNCTION ' Emit_Clear


FUNCTION Emit_Swap(sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(sWord$)
    UNREFERENCED_PARAMETER(FuncRetnFlag)

    DIM RAW VI1 AS VARINFO PTR
    DIM RAW VI2 AS VARINFO PTR
    DIM RAW indx AS INTEGER
    DIM RAW A, i, j
    DIM RAW ThirdArgExists AS BOOLEAN

    Use_BcxTempStr = TRUE

    ' Determine if there is a third argument (number of bytes to be swapped)
    ThirdArgExists = FALSE
    FOR i = 2 TO Ndx
        IF *Stk$[i] = ASC(",") THEN
            IF i < Ndx THEN
                FOR j = i + 1 TO Ndx
                    IF *Stk$[j] = ASC(",") THEN
                        ThirdArgExists = TRUE
                        EXIT FOR
                    END IF
                NEXT
            END IF
            EXIT FOR
        END IF
    NEXT

    IF ThirdArgExists THEN
        ' Emit C99 code for swap with an explicit third argument
        FPRINT FP_WRITE, Scoot$, "swap ("; ' Suppress CRLF
        FOR i = 2 TO Ndx
            IF *Stk$[i] = ASC(",") THEN
                FPRINT FP_WRITE, ", "; ' Emit first comma between x and y
            ELSE
                FPRINT FP_WRITE, Clean$(Stk$[i]); ' Emit argument without a comma
            END IF
        NEXT
        FPRINT FP_WRITE, ");" ' Close the swap statement
    ELSE
        ' Emit C99 code for swap without explicit third argument (using sizeof)
        FPRINT FP_WRITE, Scoot$, "swap ((byte*)&"; ' Suppress CRLF
        FOR i = 2 TO Ndx
            IF *Stk$[i] = ASC(",") THEN EXIT FOR
            FPRINT FP_WRITE, Clean$(Stk$[i]); ' Suppress CRLF
        NEXT

        A = CheckLocal(Stk$[2], ADDRESSOF(indx))
        IF A = vt_UNKNOWN THEN
            A = CheckGlobal(Stk$[2], ADDRESSOF(indx))
            IF A = vt_UNKNOWN THEN
                CALL Abort("Variable '" + Stk$[2] + "' in swap statement unknown")
            END IF
            VI1 = ADDRESSOF(GlobalVars[indx])
        ELSE
            VI1 = ADDRESSOF(LocalVars[indx])
        END IF

        IF RIGHTSTR(Stk$[i-1], "]") THEN
            IF VI1->VarType = vt_CHAR  AND VI1->VarPntr = 1 THEN FPRINT FP_WRITE, "[0]"; ' Suppress CRLF
            IF VI1->VarType = vt_SCHAR AND VI1->VarPntr = 1 THEN FPRINT FP_WRITE, "[0]"; ' Suppress CRLF
        END IF

        FPRINT FP_WRITE, ",(byte*)&"; ' Suppress CRLF

        INCR i

        FOR j = i TO Ndx
            FPRINT FP_WRITE, Clean$(Stk$[j]); ' Suppress CRLF
        NEXT

        A = CheckLocal(Stk$[i], ADDRESSOF(indx))
        IF A = vt_UNKNOWN THEN
            A = CheckGlobal(Stk$[i], ADDRESSOF(indx))
            IF A = vt_UNKNOWN THEN
                CALL Abort("Variable '"+Stk$[i] + "' in swap statement unknown")
            END IF
            VI2 = ADDRESSOF(GlobalVars[indx])
        ELSE
            VI2 = ADDRESSOF(LocalVars[indx])
        END IF

        IF RIGHTSTR(Stk$[j-1], "]") THEN
            IF VI2->VarType = vt_CHAR  AND VI2->VarPntr = 1 THEN FPRINT FP_WRITE, "[0]"; ' Suppress CRLF
            IF VI2->VarType = vt_SCHAR AND VI2->VarPntr = 1 THEN FPRINT FP_WRITE, "[0]"; ' Suppress CRLF
        END IF

        IF VI1->VarType <> VI2->VarType THEN
            Warning("Possible size error in swap statement")
        END IF

        IF VI2->VarType = vt_STRVAR OR VI2->VarType = vt_CHAR OR VI2->VarType = vt_SCHAR THEN
            FPRINT FP_WRITE, ",strlen("; ' Suppress CRLF
        ELSE
            FPRINT FP_WRITE, ",sizeof("; ' Suppress CRLF
        END IF

        Stk$[++Ndx] = "));"
        CALL WriteCleanTokens(i, Ndx)
    END IF

    RETURN 0
END FUNCTION ' Emit_Swap




FUNCTION Emit_PrinterProcs(sWord$, FuncRetnFlag AS PINT)
    SELECT CASE sWord$

        CASE "ejectpage"
        FPRINT FP_WRITE, Scoot$, "EjectPage();"

        CASE "printerclose"
        FPRINT FP_WRITE, Scoot$, "PrinterClose();"

        CASE "printeropen"
        IF Ndx = 1 THEN
            FPRINT FP_WRITE, Scoot$, "PrinterOpen();"
        ELSE
            DIM RAW szPrinterParameters$
            CALL BuildStr(2, Ndx, szPrinterParameters$)
            FPRINT FP_WRITE, Scoot$, "PrinterOpen(", szPrinterParameters$, ");"
        END IF

        CASE "lprint", "sprint"  ' LPRINT & FPRINT  handle,{list}
        DIM RAW IsLprint = FALSE
        DIM RAW IsSprint = FALSE

        IF iMatchWrd(Stk$[1], "lprint") THEN
            Use_Proto = IsLprint = IsSprint = TRUE
            Stk$[1] = "sprint"
            InsertTokens(1, 2, "BcxPtr_Buffer", ",")
        END IF

        IF iMatchWrd(Stk$[1], "sprint") THEN
            IsSprint = TRUE
        END IF

        IF IsDecimalNumber(Stk$[2]) THEN
            Stk$[2] = "FP" + Stk$[2]
        END IF

        IF IsSprint THEN
            szFileHandle$ = Clean$(Stk$[2])
        ELSE
            IF iMatchWrd(Stk$[2], "stderr") THEN
                szFileHandle$ = "stderr"
            ELSE
                DIM STATIC i
                IF CheckLocal(Stk$[2], ADDRESSOF(i)) = vt_UNKNOWN THEN
                    IF CheckGlobal(Stk$[2], ADDRESSOF(i)) = vt_UNKNOWN THEN
                        CALL AddGlobal(Stk$[2], vt_FILEPTR)
                    END IF
                END IF

                szFileHandle$ = ""

                FOR INT iii = 2 TO Ndx
                    IF *Stk$[iii] = ASC(",") OR *Stk$[iii] = ASC(";") THEN
                        Stk$[iii] = ""
                        EXIT FOR
                    END IF
                    szFileHandle$ += Stk$[iii]
                    Stk$[iii] = ""
                NEXT

                szFileHandle$ += "@"
            END IF
        END IF

        Stk$[2] = ""  ' remove the handle
        Stk$[3] = ""  ' remove the Comma

        DIM STATIC LZZ$

        IF IsSprint THEN
            LZZ$ = "s" + PrintWriteFormat$(0)
            REMOVE "\\n" FROM LZZ$
        ELSE
            LZZ$ = "f" + PrintWriteFormat$(0)
        END IF

        LZZ$ = LEFT$(LZZ$, 8) + REMOVE$(szFileHandle$, "@") + "," + MID$(LZZ$, 9)

        IF IsLprint THEN
            FPRINT FP_WRITE, Scoot$, LZZ$
            FPRINT FP_WRITE, Scoot$, "PrinterWrite(BcxPtr_Buffer);"
            IF NOT Use_Printer THEN
                SrcTmp$ = "printer"
                CALL Inject (SrcTmp$)   ' Force printer globals declarations
            END IF
        ELSE
            FPRINT FP_WRITE, Scoot$, LZZ$
        END IF

        CASE ELSE
        CALL Emit_Old(FuncRetnFlag)
    END SELECT
    RETURN 0
END FUNCTION ' Emit_PrinterProcs




FUNCTION Emit_Free(sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(sWord)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    DIM RAW VI AS VARINFO PTR
    DIM RAW A, vt, id, dms
    DIM RAW CVar$
    LOCAL IsDynVar

    A = 2
    IF iMatchWrd(Stk$[2], "dynamic") THEN
        IsDynVar = TRUE
        A = 3
    END IF

    IF Stk$[A] = "(" THEN
        INCR A
        DECR Ndx
    END IF

    CVar$ = Clean$(Stk$[A])
    vt = CheckLocal(CVar$, ADDRESSOF(id))

    IF vt = vt_UNKNOWN THEN
        vt = CheckGlobal(CVar$, ADDRESSOF(id))
        IF vt = vt_UNKNOWN THEN
            Abort("Can not REDIM " + CVar$ + " not previously dimensioned")
        END IF
        VI = ADDRESSOF(GlobalVars[id])
    ELSE
        VI = ADDRESSOF(LocalVars[id])
        IF IsDynVar THEN
            Warning("Local dynamic variables are automatically freed.", 1)
        END IF
    END IF

    CALL BuildStr(A, Ndx, CVar$)

    CVar$ = TRIM$(Clean$(CVar$))

    IF vt = vt_STRUCT OR vt = vt_UNION THEN
        GetElement$(2, ADDRESSOF(vt), ADDRESSOF(dms), VI->VarDef)
        IF vt <> vt_UNKNOWN AND dms > 0 THEN
            Use_BcxTempStr = Use_DynamicA = TRUE
            FPRINT FP_WRITE, Scoot$, "if (", CVar$; ' Suppress CRLF
            FPRINT FP_WRITE, ") { DestroyArr((void **)", CVar$, ",", dms, ", 1); "; ' Suppress CRLF
            FPRINT FP_WRITE, CVar$, "=NULL; }"
            EXIT FUNCTION
        END IF
    END IF

    IF VI->VarPntr > 1 THEN
        Use_BcxTempStr = Use_DynamicA = TRUE
        FPRINT FP_WRITE, Scoot$, "if (", CVar$; ' Suppress CRLF
        FPRINT FP_WRITE, ") { DestroyArr((void **)", CVar$, ",", STR$(VI->VarPntr), ", 1); "; ' Suppress CRLF
        FPRINT FP_WRITE, CVar$ ; "=NULL; }"
    ELSE
        FPRINT FP_WRITE, Scoot$, "free(", CVar$, "), "; ' Suppress CRLF
        FPRINT FP_WRITE, CVar$, "=NULL;"
    END IF

    RETURN 0
END FUNCTION ' Emit_Free



FUNCTION Emit_Dynamic(sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(sWord)
    UNREFERENCED_PARAMETER(FuncRetnFlag)

    DIM RAW w = 0
    DIM RAW SOF$
    DIM RAW LZZ$
    DIM RAW CVar$
    DIM RAW vt, id, dms

    CALL Process_Option_Base
    CVar$ = Clean$(Stk$[2])
    CALL ValidateVarName(CVar$)

    IF Stk$[Ndx] = "*" THEN CALL PointerFix
    IF Stk$[Ndx] = "&" THEN
        Stk$[Ndx--] = ""
        Stk$[Ndx] += "&"
    END IF

    IF iMatchWrd(Stk$[Ndx-1], "as") THEN
        SOF$ = Stk$[Ndx]
        GetTypeInfo(SOF$, ADDRESSOF(w), ADDRESSOF(id), ADDRESSOF(vt))

        IF vt = vt_STRLIT OR vt = vt_DECFUNC OR vt = vt_NUMBER OR _
            (vt = vt_VOID AND INCHR(Stk$[Ndx], "*") = 0) THEN
            CALL Abort(SOF$ + " is not a valid type")
        END IF
        IF vt = vt_FILEPTR AND INCHR(SOF$, "*") = 0 THEN SOF$ = SOF$ + "*"
        DECR Ndx, 2
    ELSE
        vt = DataType(Stk$[2])
        id = 0
        SOF$ = GetVarTypeName$(vt)
    END IF

    Use_DynamicA = Use_BcxTempStr = TRUE

    CALL BuildStr(3, Ndx, LZZ$)

    dms = TALLY(LZZ$, "][") + 1

    IF dms > 1 THEN REPLACE "][" WITH "," IN LZZ$

    LZZ$ = Clean$(LZZ$)

    RemoveAll(LZZ$, "[]")

    IF vt = vt_STRVAR THEN
        vt = vt_CHAR
        SOF$ = "char"
        IF InTypeDef THEN
            IF Stk$[3] <> "[" THEN
                DECR dms
            ELSE
                vt = vt_CHARPTR
            END IF
        END IF

        INCR dms

        LZZ$ += ","
        LZZ$ += "BCXSTRSIZE"
    END IF

    IF InTypeDef THEN
        IF vt = vt_STRUCT THEN
            FPRINT FP_WRITE, Scoot$, "struct _", SOF$, SPACE$(2), STRING$(dms, 42), CVar$, ";"
        ELSE
            FPRINT FP_WRITE, Scoot$, SOF$, SPACE$(2), STRING$(dms, 42), CVar$, ";"
        END IF
        CALL AddTypedefElement(BaseTypeDefsCnt[InTypeDef], vt, CVar$, SOF$, dms)
    ELSEIF InFunction <> FALSE THEN
        INCR LocalDynArrCnt

        IF cMaxLocalDynArr = LocalDynArrCnt THEN
            CALL Abort("Maximum number of Local Dynamic Arrays exceeded.")
        END IF

        LocalDynArrName$ [LocalDynArrCnt] = "if (" + CVar$ + ") { DestroyArr((void **)" + CVar$ + "," + STR$(dms) + ", 1); " +  CVar$ + "=NULL; }"
        FPRINT FP_WRITE, Scoot$, SOF$, SPACE$(2), STRING$(dms, 42), CVar$, "=0;"
        CALL AddLocal(CVar$, vt, id, "", dms)
    ELSE
        IF Use_GenFree THEN
            CALL AddDynamicGlobal("if (" + CVar$ + ") { DestroyArr((void **)" + CVar$ + "," + STR$(dms) + ", 1); " + CVar$ + "=NULL; }")
        END IF
        CALL AddGlobal(CVar$, vt, id, "", dms)
    END IF

    IF NOT InTypeDef THEN
        REPLACE "," WITH ", (size_t)" IN LZZ$
        FPRINT FP_WRITE, Scoot$, "{"
        FPRINT FP_WRITE, Scoot$, "size_t dimensions[", TRIM$(STR$(dms)), "] = {(size_t)", LZZ$, "};"


        '================  828 MrBcx - prevents heap leaks in LOCAL string arrays  ================
        GLOBAL AuxLocalDynArray$[64]
        GLOBAL AuxLocalDynArrayCount
        INCR AuxLocalDynArrayCount
        AuxLocalDynArray$[AuxLocalDynArrayCount] = "if (" + CVar$ + ") DestroyArr((void " + STRING$(dms-1, 42) +  ")"
        AuxLocalDynArray$[AuxLocalDynArrayCount] += CVar$ + "," +  STR$(dms) + ", 1);"
        '================  828 MrBcx - prevents heap leaks in LOCAL string arrays  ================


        FPRINT FP_WRITE, Scoot$, CVar$, "= (", SOF$, STRING$(dms, 42), ")CreateArr (", CVar$, ",sizeof(", SOF$, "),0,", STR$(dms, 1), ", dimensions);"
        FPRINT FP_WRITE, Scoot$, "}"
    END IF

    RETURN 0
END FUNCTION ' Emit_Dynamic




SUB DimVar(iType)
    '*******************************
    ' DIM A$ * blah blah blah
    ' DIM a%[1000]  (integer)
    ' DIM a![1000]  (single)
    ' DIM a#[1000]  (double)
    ' DIM a~[1000]  (long double)
    ' DIM A$[1000]  (string)
    ' DIM r             AS DATA_TYPE
    ' DIM r[1][2]...[n] AS DATA_TYPE
    ' DIM DYNAMIC A$[1000]
    ' DIM volatile a
    ' DIM a AS LPCTSTR
    '********************************
    DIM RAW w  = 0
    DIM RAW id = 0
    DIM RAW vt = 0
    DIM RAW IsALocalVar    = FALSE
    DIM RAW NotInitialized = TRUE
    DIM STATIC UseStatic$
    DIM STATIC IsVolatile
    DIM STATIC sVolatile$
    DIM STATIC Ok2Initialize
    DIM STATIC szVarName$
    DIM STATIC VarType
    DIM STATIC IsSubOrFuncPtr
    DIM STATIC IsConsOrDestPtr
    DIM STATIC IsPointer
    DIM STATIC LTmp$
    DIM STATIC L_DimType$
    DIM STATIC szVarTypeName$
    DIM STATIC szMemsetName$
    DIM STATIC szVarDecName$

    IF BYTE_AT(Stk[Ndx][0]) = ASC(":") THEN
        Stk$[Ndx - 1] += Stk$[Ndx]
        DECR Ndx
    END IF

    IsDim = IsLocal = IsRaw = IsRegister = IsStatic = FALSE

    IF iType = ImDim      THEN IsDim      = TRUE
    IF iType = ImLocal    THEN IsLocal    = TRUE
    IF iType = ImRaw      THEN IsDim      = IsRaw
    IF iType = ImRegister THEN IsRegister = TRUE
    IF iType = ImStatic   THEN IsStatic   = TRUE

    IsVolatile = iMatchWrd(Stk$[2], "volatile")
    IF IsVolatile THEN

        IF IsRegister THEN
            CALL Abort("Register volatile not supported")
        END IF

        sVolatile$ = "volatile "
    ELSE
        sVolatile$ = ""
    END IF

    IsSubOrFuncPtr = SubFuncTest()
    IsConsOrDestPtr = Ctor_Dtor_Detected(2)

    CALL Process_Option_Base

    IF Stk$[Ndx] = "*" THEN CALL PointerFix
    IF Stk$[Ndx] = "&" THEN
        Stk$[Ndx--] = ""
        Stk$[Ndx] += "&"
    END IF

    '*************************************************************************
    IF IsSubOrFuncPtr THEN

        IF IsVolatile THEN
            CALL Abort("volatile SUB/FUNCTION pointers not supported")
        END IF

        IF DimSubFunc(0) THEN EXIT SUB
    END IF

    IF IsConsOrDestPtr THEN

        IF IsVolatile THEN
            CALL Abort("volatile SUB/FUNCTION pointers not supported")
        END IF

        IF DimSubFunc(2) THEN EXIT SUB
    END IF

    IF InFunction OR InTypeDef OR InCppTypeDef OR InClass OR InBlock OR InNameSpace THEN
        IsALocalVar = TRUE
    END IF

    IF InTypeDef OR IsVolatile THEN
        Ok2Initialize = FALSE
    ELSE
        IF UseCpphdr THEN
            IF NOTZERO (iType BAND (ImDim BOR ImLocal)) THEN
                Ok2Initialize = TRUE
            ELSE
                Ok2Initialize = FALSE
            END IF
        ELSE
            IF NOTZERO (iType BAND (ImDim BOR ImLocal BOR ImAuto)) THEN
                Ok2Initialize = TRUE
            ELSE
                Ok2Initialize = FALSE
            END IF
        END IF
    END IF

    IF InTypeDef OR InNameSpace THEN
        UseStatic$ = ""
        IsStatic = FALSE
    ELSE
        IF NOTZERO (iType BAND ImStatic) THEN
            IsStatic = TRUE
            UseStatic$ = "static "
        ELSE
            UseStatic$ = ""
            IsStatic = FALSE
        END IF
    END IF

    szVarName$ = Clean$(Stk$[2+IsVolatile])

    CALL ValidateVarName(szVarName$)
    VarType = DataType(Stk$[2+IsVolatile])

    IF Stk$[3+IsVolatile] = "*" THEN       ' DIM MySTRING$ * NumBytes

        IF IsVolatile THEN
            CALL Abort("volatile dynamic strings not supported")
        END IF

        CALL DimDynaString(szVarName$, 0, 0)
        EXIT SUB
    END IF

    DIM RAW iASoffset = GetAsPosB(Ndx, 2) ' AS offset

    IF iASoffset THEN
        DIM sConst$
        DIM iIsConst

        IF iASoffset = Ndx-2 THEN
            IF iMatchWrd(Stk$[Ndx-1], "const") THEN
                sConst$ = "const "
                iIsConst = 1
            END IF
        END IF

        IsPointer = TALLY(Stk$[Ndx], "*")

        CALL BuildStr(2+IsVolatile, iASoffset-1, LTmp$)
        CALL BuildStr(3+IsVolatile, iASoffset-1, L_DimType$)

        IF NOTZERO(INCHR(LTmp$, "=")) THEN
            NotInitialized = FALSE
        END IF

        szVarTypeName$ = REMOVE$(Stk$[Ndx], "*")
        GetTypeInfo(szVarTypeName$, ADDRESSOF(w), ADDRESSOF(id), ADDRESSOF(vt))

        IF vt = vt_WINBOOL THEN
            IREPLACE "WINBOOL" WITH "BOOL" IN Stk$[Ndx]
        END IF

        IF vt = vt_STRVAR THEN
            Stk$[Ndx] = "char"
            szVarTypeName$ = Stk$[Ndx]
            L_DimType$ += "[BCXSTRSIZE]"
            LTmp$ += "[BCXSTRSIZE]"
        END IF

        Stk$[Ndx] = RPAD$(Stk$[Ndx], PADSIZE)

        IF vt = vt_FILEPTR THEN
            Stk$[Ndx] += "*"
        END IF

        IF IsALocalVar THEN
            SELECT CASE iType

                CASE ImDim, ImLocal, ImRaw
                IF vt = vt_STRUCT THEN
                    FPRINT FP_WRITE, Scoot$, UseStatic$, sVolatile$, sConst$, "struct _", Stk$[Ndx], SPACE$(2); ' Suppress CRLF
                ELSE
                    FPRINT FP_WRITE, Scoot$, UseStatic$, sVolatile$, sConst$, Stk$[Ndx], SPACE$(2); ' Suppress CRLF
                END IF
                IF InTypeDef AND NOT InBlock THEN
                    IF vt = vt_UDT THEN
                        IF ComSwitchON THEN
                            IF TypeDefs[id].VarName$ = "OBJECT" THEN
                                CALL Abort("Use of Object type in UDTs is Illegal!")
                            END IF
                        END IF
                    END IF
                    CALL AddTypedefElement(BaseTypeDefsCnt[InTypeDef], vt, szVarName$, szVarTypeName$)
                END IF

                CASE ImStatic
                FPRINT FP_WRITE, Scoot$, UseStatic$, sVolatile$, sConst$, Stk$[Ndx], SPACE$(2); ' Suppress CRLF

                CASE ImAuto
                FPRINT FP_WRITE, Scoot$, SPC$, sVolatile$, sConst$, SPC$, Stk$[Ndx], SPACE$(2); ' Suppress CRLF

                CASE ImRegister
                FPRINT FP_WRITE, Scoot$, SPC$, sConst$, Stk$[Ndx], SPACE$(2); ' Suppress CRLF

                CASE ImCPPPrvDim
                FPRINT FP_WRITE, Scoot$, "private: ", Stk$[Ndx], SPACE$(2); ' Suppress CRLF

            END SELECT

            IF iType <> ImCPPPrvDim THEN
                IF NOT InTypeDef THEN
                    IF vt = vt_UDT THEN
                        IF ComSwitchON THEN
                            IF TypeDefs[id].VarName$ = "OBJECT" THEN
                                Add_COM_Global_Variable(szVarName$)
                                Use_COM = Use_BcxTempStr = TRUE
                            END IF
                        END IF
                    END IF
                    CALL AddLocal(szVarName$, vt, id, L_DimType$, IsPointer, 0, 0, iIsConst)
                END IF
            END IF

            IF Ok2Initialize THEN
                szMemsetName$ = Clean$(EXTRACT$(LTmp$, "["))

                IF IsPointer THEN
                    IF NotInitialized THEN
                        FPRINT FP_WRITE, Clean$(LTmp$), "={0};"
                    ELSE
                        FPRINT FP_WRITE, Clean$(LTmp$), ";"
                    END IF
                ELSE
                    SELECT CASE vt

                        CASE vt_BOOL, vt_BYTE, vt_DWORD, vt_INTEGER, vt_LONG, vt_SHORT, _
                        vt_UINT, vt_ULONG, vt_USHORT, vt_DWORD, vt_WORD, vt_DOUBLE, _
                        vt_SINGLE, vt_LDOUBLE, vt_PCHAR, vt_LPBYTE, vt_SSHORT, vt_SCHAR

                        IF NotInitialized THEN
                            FPRINT FP_WRITE, Clean$(LTmp$), "={0};"
                        ELSE
                            FPRINT FP_WRITE, Clean$(LTmp$), ";"
                        END IF

                        CASE ELSE

                        IF NotInitialized THEN
                            FPRINT FP_WRITE, Clean$(LTmp$), "={0};"
                        ELSE
                            FPRINT FP_WRITE, Clean$(LTmp$), ";"
                        END IF
                    END SELECT
                END IF
            ELSE
                FPRINT FP_WRITE, Clean$(LTmp$), ";"
            END IF
        ELSE
            IF IsVolatile THEN
                CALL AddGlobal(szVarName$, vt, id, L_DimType$, IsPointer, 0, 3, 0, iIsConst)
            ELSE
                IF vt = vt_UDT THEN
                    IF ComSwitchON THEN
                        IF TypeDefs[id].VarName$ = "OBJECT" THEN
                            Add_COM_Global_Variable(szVarName$)
                            Use_COM = Use_BcxTempStr = TRUE
                        END IF
                    END IF
                END IF
                IF iType = ImRaw THEN
                    CALL AddGlobal(szVarName$, vt, id, L_DimType$, IsPointer, 0, 2, 0, iIsConst)
                ELSE
                    CALL AddGlobal(szVarName$, vt, id, L_DimType$, IsPointer, 0, 0, 0, iIsConst)
                END IF
            END IF
        END IF
        EXIT SUB
    END IF

    ' Dimensioned without AS
    CALL BuildStr(3+IsVolatile, Ndx, LTmp$)

    IF NOTZERO(INCHR(LTmp$, "=")) THEN
        NotInitialized = FALSE
    END IF

    IF IsALocalVar THEN LTmp$ = TRIM$(Clean$(LTmp$))
    IF VarType = vt_STRVAR THEN LTmp$ += "[BCXSTRSIZE]"

    IF IsALocalVar THEN
        IF VarType = vt_STRVAR THEN
            szVarDecName$ = "char"
        ELSE
            szVarDecName$ = GetVarTypeName$(VarType)
        END IF
        szVarDecName$ = RPAD$(szVarDecName$, PADSIZE)

        IF UseCpphdr THEN
            DIM RAW Ok2UseMemset
            Ok2UseMemset = Ok2Initialize
            SELECT CASE iType

                CASE ImDim, ImLocal, ImRaw, ImStatic
                IF (ImDim BOR ImLocal) AND Ok2UseMemset THEN
                    FPRINT FP_WRITE, Scoot$, szVarDecName$, SPC$, szVarName$, LTmp$, "={0};"
                    Ok2UseMemset = FALSE
                ELSE
                    FPRINT FP_WRITE, Scoot$, UseStatic$, sVolatile$, szVarDecName$, SPC$, szVarName$, LTmp$, ";"
                END IF

                CASE ImRegister
                IF IsVolatile THEN Abort("Register volatile not supported")
                FPRINT FP_WRITE, Scoot$, SPC$, szVarDecName$, SPC$, szVarName$, LTmp$, ";"

                CASE ImCPPPrvDim
                FPRINT FP_WRITE, Scoot$, "private: ", szVarDecName$, SPC$, szVarName$, LTmp$, ";"

            END SELECT

            IF Ok2UseMemset THEN
                szMemsetName$ = Clean$(EXTRACT$(szVarName$, "["))
                FPRINT FP_WRITE, Scoot$, "memset(&", szMemsetName$, ",0,sizeof(", szMemsetName$, "));"
            END IF

        ELSE

            SELECT CASE iType

                CASE ImDim, ImLocal, ImStatic, ImRaw
                IF NotInitialized AND Ok2Initialize THEN
                    FPRINT FP_WRITE, Scoot$, UseStatic$, sVolatile$, szVarDecName$, SPC$, szVarName$, LTmp$, "={0};"
                ELSE
                    FPRINT FP_WRITE, Scoot$, UseStatic$, sVolatile$, szVarDecName$, SPC$, szVarName$, LTmp$, ";"
                END IF

                CASE ImAuto
                IF NotInitialized AND Ok2Initialize THEN
                    FPRINT FP_WRITE, Scoot$, "auto ", sVolatile$, szVarDecName$, SPC$, szVarName$, LTmp$, "={0};"
                ELSE
                    FPRINT FP_WRITE, Scoot$, "auto ", sVolatile$, szVarDecName$, SPC$, szVarName$, LTmp$, ";"
                END IF

                CASE ImRegister
                IF IsVolatile THEN Abort("Register volatile not supported")
                IF NotInitialized AND Ok2Initialize THEN
                    FPRINT FP_WRITE, Scoot$, SPC$, szVarDecName$, SPC$, szVarName$, LTmp$, "={0};"
                ELSE
                    FPRINT FP_WRITE, Scoot$, SPC$, szVarDecName$, SPC$, szVarName$, LTmp$, ";"
                END IF

                CASE ImCPPPrvDim
                IF NotInitialized AND Ok2Initialize THEN
                    FPRINT FP_WRITE, Scoot$, "private: ", szVarDecName$, SPC$, szVarName$, LTmp$, "={0};"
                ELSE
                    FPRINT FP_WRITE, Scoot$, "private: ", szVarDecName$, SPC$, szVarName$, LTmp$, ";"
                END IF

            END SELECT
        END IF

        IF iType <> ImCPPPrvDim THEN
            IF InTypeDef THEN
                IF VarType = vt_UDT THEN
                    IF ComSwitchON THEN
                        IF TypeDefs[id].VarName$ = "OBJECT" THEN
                            Abort("Use of Object type in UDTs is Illegal!")
                        END IF
                    END IF
                END IF
                CALL AddTypedefElement(BaseTypeDefsCnt[InTypeDef], VarType, szVarName$, szVarTypeName$)
            ELSE
                CALL AddLocal(szVarName$, VarType, 0, LTmp$)
            END IF
        END IF
        EXIT SUB
    END IF

    '************************************************************************
    ' if we get here, we're creating with a GLOBAL variable
    '************************************************************************
    DIM STATIC iGlobalExtn

    IF IsVolatile THEN
        iGlobalExtn = 3
    ELSE
        IF VarType = vt_UDT THEN
            IF ComSwitchON THEN
                IF TypeDefs[id].VarName$ = "OBJECT" THEN
                    Add_COM_Global_Variable(szVarName$)
                    Use_COM = Use_BcxTempStr = TRUE
                END IF
            END IF
        END IF
        iGlobalExtn = 0
    END IF
    CALL AddGlobal(szVarName$, VarType, 0, LTmp$, 0, 0, iGlobalExtn)
END SUB ' DimVar



FUNCTION Emit_CPP_EndClass(sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(sWord)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    UseCpp = TRUE

    IF InClass <> 1 THEN
        CALL Abort("Syntax Error")
    END IF
    CALL BumpDown("Extra unindents and/or missing indents before END CLASS")
    FPRINT FP_UDT, Scoot$, "};"
    FPRINT FP_UDT, ""
    CALL BumpDown("Extra unindents and/or missing indents before END CLASS")
    DECR InClass
    FP_WRITE = FP2
    InClassName$ = ""
    InClassPP$ = ""

    RETURN 0
END FUNCTION ' Emit_CPP_EndClass


FUNCTION Emit_CPP_Namespace(sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(sWord)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    UseCpp = TRUE
    FP_WRITE = FP_UDT
    FPRINT FP_WRITE, Scoot$, "namespace ", Stk$[2]
    CALL BumpUp
    FPRINT FP_WRITE, Scoot$, "{"
    INCR InNameSpace
    RETURN 0
END FUNCTION ' Emit_CPP_Namespace




FUNCTION Emit_CPP_Class(sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(sWord)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    UseCpp = TRUE
    IF InClass OR InTypeDef OR InCppTypeDef OR InFunction OR ISNULL(Stk$[2]) THEN
        CALL Abort("Syntax Error")
    END IF
    InClassName$ = Stk$[2]
    IF UsingTemplate = FALSE THEN FPRINT FP_UDT, ""
    IF NOTNULL(InIfDef$) AND InIfDef$ <> "FP3" THEN
        FPRINT FP_UDT, InIfDef$
    END IF
    FPRINT FP_UDT, "class "; ' Suppress CRLF
    FP_WRITE = FP_UDT
    FOR INT i = 2 TO Ndx
        IF iMatchWrd(Stk$[i+1], "inherits") THEN
            Stk$[i] += ":"
            Stk$[i+1] = "public"
        END IF
        IF Stk$[i] = "using" THEN
            FPRINT FP_UDT, " : "; ' Suppress CRLF
            ITERATE
        END IF
        IF Stk$[i] = "::" THEN
            FPRINT FP_UDT, " : "; ' Suppress CRLF
        ELSE
            IF iMatchWrd(Stk$[i], "private") THEN Stk$[i] = "private"
            IF iMatchWrd(Stk$[i], "public") THEN Stk$[i] = "public"
            AddSpace(i)
            FPRINT FP_UDT, Stk$[i]; ' Suppress CRLF
        END IF
    NEXT
    CALL BumpUp
    FPRINT FP_UDT, "\n", Scoot$, "{"
    INCR InClass
    InClassPP$ = ""
    IF UsingTemplate = TRUE THEN WasAClass = TRUE
    RETURN 0
END FUNCTION ' Emit_CPP_Class



FUNCTION Emit_CPP_Public(sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(sWord)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    UseCpp = TRUE
    IF Stk$[2] = ":" THEN
        IF InClassPP[0] THEN
            FPRINT FP_UDT, ""
            CALL BumpDown("Error in Emit_CPP_Public")
        END IF
        FPRINT FP_UDT, Scoot$, "public:"
        CALL BumpUp
        InClassPP$ = "public"
        RETURN 0
    END IF
    RETURN 0
END FUNCTION ' Emit_CPP_Public


FUNCTION Emit_CPP_Asm(sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(sWord)
    CALL Emit_Old(FuncRetnFlag)
    RETURN 0
END FUNCTION ' Emit_CPP_Asm



FUNCTION Emit_CPP_Protected(sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(sWord)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    UseCpp = TRUE
    IF Stk$[2] = ":" THEN
        IF InClassPP[0] THEN
            FPRINT FP_UDT, ""
            CALL BumpDown("Error in Emit_CPP_Protected")
        END IF
        FPRINT FP_UDT, Scoot$, "protected:"
        CALL BumpUp
        InClassPP$ = "protected"
        RETURN 0
    END IF
    RETURN 0
END FUNCTION ' Emit_CPP_Protected



FUNCTION Emit_CPP_Private(sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(sWord)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    IF Stk$[2] = ":" THEN
        IF InClassPP[0] THEN
            FPRINT FP_UDT, ""
            CALL BumpDown("Error in Emit_CPP() CASE private")
        END IF
        FPRINT FP_UDT, Scoot$, "private:"
        CALL BumpUp
        InClassPP$ = "private"
        RETURN 0
    END IF
    RETURN 0
END FUNCTION ' Emit_CPP_Private


FUNCTION Emit_CPP_EndNamespace(sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(sWord)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    UseCpp = TRUE
    FPRINT FP_UDT, Scoot$, "};\n"
    CALL BumpDown("Extra unindents and/or missing indents before END NAMESPACE")
    DECR InNameSpace
    RETURN 0
END FUNCTION ' Emit_CPP_EndNamespace



FUNCTION Emit_CPP_Try(sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(sWord)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    UseCpp = TRUE
    FPRINT FP_WRITE, Scoot$, "try"
    CALL BumpUp
    FPRINT FP_WRITE, Scoot$, "{"
    CALL InBlockSet
    RETURN 0
END FUNCTION ' Emit_CPP_Try



FUNCTION Emit_CPP_EndTry(sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(sWord)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    UseCpp = TRUE
    FPRINT FP_WRITE, Scoot$, "}"
    CALL BumpDown("Unbalanced TRY/END TRY")
    CALL InBlockReSet
    RETURN 0
END FUNCTION ' Emit_CPP_EndTry



FUNCTION Emit_CPP_Throw (sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(sWord)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    UseCpp = TRUE
    DIM RAW LTmp$
    IF Ndx = 1 THEN
        LTmp$ = ENC$("An Exception has occured!")
    ELSE
        CALL BuildDelimStr(2, Ndx, LTmp$)
    END IF
    FPRINT FP_WRITE, Scoot$, "throw ", LTmp$, ";"
    RETURN 0
END FUNCTION ' Emit_CPP_Throw



FUNCTION Emit_CPP_Catch(sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(sWord)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    UseCpp = TRUE
    DIM RAW VarCode AS VARCODE
    VarCode.IsExported = FALSE
    VarCode.UseInLine = UseInLine
    CALL InBlockReSet
    gTmpStr$ = ""
    IF Ndx > 1 THEN
        DIM RAW A
        CALL FuncSubDecs1("sub", 1, Ndx, ADDRESSOF(VarCode))
        CALL FuncSubDecs2("sub", mt_Opts, ADDRESSOF(VarCode), 1, ADDRESSOF(Ndx))
        VarCode.Methd% = mt_FuncSubDecC_DecAParam
        A = 3
        DO WHILE A < Ndx
            CALL GetParameter(ADDRESSOF(A), ADDRESSOF(VarCode), mt_OptsAParam, mt_OptsNoParam, 1)
            INCR A
        LOOP
        VarCode.Methd% = mt_FuncSubDecC_DecAParam
        VarCode.Token$ = Stk$[1]
        FuncSubDecs3(ADDRESSOF(VarCode), Ndx, 0)
        gTmpStr$ = VarCode.Header$
    ELSE
        gTmpStr$ = "catch (LPCTSTR str)"
    END IF
    FPRINT FP_WRITE, Scoot$, "}"
    CALL BumpDown("Extra unindents and/or missing indents before CATCH")
    CALL InBlockSet
    FPRINT FP_WRITE, Scoot$, gTmpStr$
    CALL BumpUp
    FPRINT FP_WRITE, Scoot$, "{"
    RETURN 0
END FUNCTION ' Emit_CPP_Catch



FUNCTION Emit_CPP_Delete(sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(sWord)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    UseCpp = TRUE
    DIM RAW LTmp$
    CALL BuildCleanStr(2, Ndx, LTmp$)
    FPRINT FP_WRITE, Scoot$, "delete ", LTmp$, ";"
    RETURN 0
END FUNCTION ' Emit_CPP_Delete



FUNCTION Emit_DialogBox(sWord$, FuncRetnFlag AS PINT)
    SELECT CASE sWord$

        CASE "dialogbox" ' HELPER
        DIM RAW L_Comma = 0
        FPRINT FP_WRITE, Scoot$, "DialogBox"; ' Suppress CRLF

        FOR INT A = 2 TO Ndx
            IF Stk$[A] = "," THEN INCR L_Comma

            IF L_Comma = 3 THEN
                IF Stk$[A] = "," THEN Stk$[A] = ",(DLGPROC)"
            END IF

            FPRINT FP_WRITE, Clean$(Stk$[A]); ' Suppress CRLF
        NEXT

        FPRINT FP_WRITE, ";"

        CASE ELSE
        CALL Emit_Old(FuncRetnFlag)

    END SELECT
    RETURN 0
END FUNCTION ' Emit_DialogBox



FUNCTION Emit_Conditional_Operator_Repair$(szArg$)  ' Used by Emit_ConditionalCompilation()
    IF NOT INSTR (szArg$, ANY "=!<>|&" ) THEN RETURN szArg$ ' MrBcx 819 updated code
    LOCAL Tmp$
    Tmp$ = TRIM$(szArg$)
    REPLACE   "= ="   WITH  "=="  IN Tmp$
    REPLACE   "! ="   WITH  "!="  IN Tmp$
    REPLACE   "< ="   WITH  "<="  IN Tmp$
    REPLACE   "> ="   WITH  ">="  IN Tmp$
    REPLACE   "| |"   WITH  "||"  IN Tmp$
    REPLACE   "& &"   WITH  "&&"  IN Tmp$
    RETURN Tmp$
END FUNCTION



FUNCTION Emit_ConditionalCompilation(sWord$, FuncRetnFlag AS PINT)
    SELECT CASE sWord$

        CASE "~ifndef"
        InIfDef$ = "#ifndef "
        FOR INT i = 2 TO Ndx
            InIfDef$ += Stk$[i] + SPC$
        NEXT
        InIfDef$ = Emit_Conditional_Operator_Repair$(InIfDef$)

        IF InFunction OR InMain THEN
            FPRINT FP_WRITE, InIfDef$
        ELSE
            FPRINT FP_CST, InIfDef$
        END IF



        CASE "~ifdef"
        InIfDef$ = "#if defined "

        FOR INTEGER i = 2 TO Ndx
            InIfDef$ += Stk$[i] + SPC$
        NEXT

        InIfDef$ = Emit_Conditional_Operator_Repair$(InIfDef$)
        ConstLastDef$ = InIfDef$

        DIM tmp$                                                                               ' MrBcx 817 -- new
        tmp$ = TRIM$(LOOKAHEAD$(SourceFile, 1))                                                ' MrBcx 817 -- new
        IF LEFT$(tmp$, 4) ?? "SUB " OR  LEFT$(tmp$, 9) ?? "FUNCTION " THEN tmp$ = "SUSPEND"    ' MrBcx 817 -- new

        IF InFunction THEN
            FPRINT FP_WRITE, InIfDef$
            InIfDef$ = "FP3"
        ELSE
            IF InMain AND tmp$ <> "SUSPEND" THEN                                               ' MrBcx 817 -- modified
                FPRINT FP_WRITE, InIfDef$
            END IF
        END IF



        CASE "~if"
        InIfDef$ = "#if "
        FOR INT i = 2 TO Ndx
            InIfDef$ += Stk$[i] + SPC$
        NEXT
        InIfDef$ = Emit_Conditional_Operator_Repair$(InIfDef$)
        ConstLastDef$ = InIfDef$
        IF InFunction THEN
            FPRINT FP_WRITE, InIfDef$
            InIfDef$ = "FP3"
        ELSE
            IF InMain THEN
                FPRINT FP_WRITE, InIfDef$
            END IF
        END IF


        CASE "~elseif"
        InIfDef$ = "#elif defined "
        FOR INT i = 2 TO Ndx
            InIfDef$ += Stk$[i] + SPC$
        NEXT
        InIfDef$ = Emit_Conditional_Operator_Repair$(InIfDef$)
        ConstLastDef$ = InIfDef$
        IF InFunction OR InMain THEN
            FPRINT FP_WRITE, InIfDef$
        ELSE
            FPRINT FP_CST, InIfDef$
        END IF


        CASE "~else"
        InIfDef$ = "#else"
        ConstLastDef$ = InIfDef$
        IF InFunction OR InMain THEN
            FPRINT FP_WRITE, InIfDef$
        ELSE
            FPRINT FP_CST, InIfDef$
        END IF



        CASE "~endif"
        IF InIfDef$ = "FP3" THEN
            FPRINT FP3, "#endif"
        ELSE
            FPRINT FP_WRITE, "#endif"
        END IF

        IF ConstLastDef$ = "FP_CST" THEN
            FPRINT FP_CST, "#endif"
        END IF

        InIfDef$ = "#endif"

        IF InConditional = 0 THEN
            InIfDef$ = ""
            ConstLastDef$ = ""
        END IF


        CASE "~pragmaoptimizeon"
        FPRINT FP_WRITE, "#ifdef __POCC__"
        FPRINT FP_WRITE, "#pragma optimize(time)"
        FPRINT FP_WRITE, "#endif"

        FPRINT FP_WRITE, "#ifdef __LCC__"
        FPRINT FP_WRITE, "#pragma optimize(1)"
        FPRINT FP_WRITE, "#endif"

        CASE "~pragmaoptimizeoff"
        FPRINT FP_WRITE, "#ifdef __POCC__"
        FPRINT FP_WRITE, "#pragma optimize(none)"
        FPRINT FP_WRITE, "#endif"

        FPRINT FP_WRITE, "#ifdef __LCC__"
        FPRINT FP_WRITE, "#pragma optimize(0)"
        FPRINT FP_WRITE, "#endif"

        CASE ELSE
        CALL Emit_Old(FuncRetnFlag)

    END SELECT
    RETURN 0
END FUNCTION ' Emit_ConditionalCompilation




FUNCTION Emit_Shared_Global(sWord$, FuncRetnFlag AS PINT)
    SELECT CASE sWord$

        CASE "shared", "global"
        DIM STATIC wxy
        DIM STATIC SOF$
        DIM STATIC IsShared
        DIM STATIC IsVolatile
        DIM STATIC IsSubOrFuncPtr
        DIM STATIC CVar$
        DIM STATIC id, vt, dms, IsPointer
        DIM STATIC LZZ$

        wxy = 0
        IsSubOrFuncPtr = SubFuncTest()
        CALL Process_Option_Base
        IsVolatile = iMatchWrd(Stk$[2], "volatile")
        CVar$ = Clean$(Stk$[2+IsVolatile])
        CALL ValidateVarName(CVar$)

        IsShared = iMatchWrd(Stk$[1], "shared")

        IF Stk$[Ndx] = "*" THEN CALL PointerFix
        IF Stk$[Ndx] = "&" THEN
            Stk$[Ndx--] = ""
            Stk$[Ndx] += "&"
        END IF

        IF Stk$[3+IsVolatile] = "*" THEN
            IF IsVolatile THEN Abort("volatile dynamic strings not supported")
            CALL DimDynaString(CVar$, 1, IsShared)
            EXIT SELECT
        END IF

        IF IsSubOrFuncPtr THEN
            IF IsVolatile THEN Abort("volatile SUB/FUNCTION pointers not supported")
            CALL DimSubFunc(0)
            EXIT SELECT
        END IF

        IF iMatchWrd(Stk$[2], "dynamic") THEN
            CVar$ = Clean$(Stk$[3])

            CALL ValidateVarName(CVar$)
            IF iMatchWrd(Stk$[Ndx-1], "as") THEN
                SOF$ = Stk$[Ndx]
                GetTypeInfo(SOF$, ADDRESSOF(wxy), ADDRESSOF(id), ADDRESSOF(vt))
                IF vt = vt_STRLIT OR vt = vt_DECFUNC OR vt = vt_NUMBER OR (vt = vt_VOID AND INCHR(Stk$[Ndx], "*") = 0) THEN
                    Abort(Stk$[Ndx] + " is not a valid type")
                END IF
                DECR Ndx, 2
            ELSE
                vt = DataType(Stk$[3])
                id = 0
                SOF$ = GetVarTypeName$(vt)
            END IF

            Use_DynamicA = Use_BcxTempStr = TRUE

            CALL BuildStr(4, Ndx, LZZ$)
            dms = TALLY(LZZ$, "][") + 1

            IF dms > 1 THEN REPLACE "][" WITH "," IN LZZ$

            LZZ$ = Clean$(LZZ$)
            RemoveAll(LZZ$, "[]")

            IF vt = vt_STRVAR THEN
                vt = vt_CHAR
                SOF$ = "char"
                INCR dms
                LZZ$ += ","
                LZZ$ += "BCXSTRSIZE"
            END IF

            IF Use_GenFree THEN
                CALL AddDynamicGlobal("if (" + CVar$ + ") {DestroyArr((void **)" + CVar$ + "," + STR$(dms) + ", 1); " +  CVar$ + "=NULL;}")
            END IF

            CALL AddGlobal(CVar$, vt, id, "", dms)

            REPLACE "," WITH ", (size_t)" IN LZZ$

            FPRINT FP_WRITE, Scoot$, "{"
            FPRINT FP_WRITE, Scoot$, "size_t dimensions[", TRIM$(STR$(dms)), "] = {(size_t)", LZZ$, "};" '
            FPRINT FP_WRITE, Scoot$, CVar$ , "= (", SOF$ , STRING$(dms, 42), ")CreateArr (", CVar$ , ", sizeof(", SOF$, "), 0,", STR$(dms, 1), ", dimensions);"
            FPRINT FP_WRITE, Scoot$, "}"
            EXIT SELECT
        END IF

        IsPointer = 0

        Var$ = Clean$(Stk$[2+IsVolatile])
        CALL ValidateVarName(Var$)

        IF iMatchWrd(Stk$[Ndx-1], "as") THEN
            IF INCHR(Stk$[Ndx], "*") THEN
                IsPointer = TALLY(Stk$[Ndx], "*")
                Stk$[Ndx] = REMOVE$(Stk$[Ndx], "*")
            END IF
            CALL BuildStr(3+IsVolatile, Ndx-2, DimType$)
            GetTypeInfo(Stk$[Ndx], ADDRESSOF(wxy), ADDRESSOF(id), ADDRESSOF(vt))
        ELSE
            CALL BuildStr(3+IsVolatile, Ndx, DimType$)
            vt = DataType(Stk$[2+IsVolatile])
            id = 0
        END IF

        IF vt = vt_STRVAR THEN
            DimType$ += "[BCXSTRSIZE]"
        END IF
        ' global object in sub/func
        IF vt = vt_UDT THEN
            IF ComSwitchON THEN
                IF TypeDefs[id].VarName$ = "OBJECT" THEN
                    Add_COM_Global_Variable(CVar$)
                    Use_COM = Use_BcxTempStr = TRUE
                END IF
            END IF
        END IF

        wxy = 0
        IF IsShared THEN wxy = 2
        IF IsVolatile THEN wxy = wxy + 3
        CALL AddGlobal(Var$, vt, id, DimType$, IsPointer, 0, wxy)

        CASE ELSE
        CALL Emit_Old(FuncRetnFlag)

    END SELECT
    RETURN 0
END FUNCTION ' Emit_Shared_Global



FUNCTION Emit_EndFuncSub(sWord$, FuncRetnFlag AS PINT)
    SELECT CASE sWord$

        CASE "endfunction", "endsub"
        AuxLocalDynArrayCount = 0    ' 828  MrBcx  - heap leak detection terminates at end of SUB/FUNCTION
        InMain = TRUE

        IF LoopTypeCnt THEN
            CALL LoopErrorMsg
        END IF

        IF COM_lc_names_index > 0 THEN
            ' cleaning local COM objects if user forgot to
            ' call xxx = Nothing for each declared object
            CALL BCX_FreeLocalCOMObjects(TRUE)
        END IF

        IF iMatchWrd(Stk$[1], "endfunction") THEN
            InWinMain = FALSE
            LocalDynaCnt = 0
            LocalDynArrCnt = 0

            IF InDialogEvt THEN
                FPRINT FP_WRITE, Scoot$, "if(Msg==WM_CLOSE) DestroyWindow(hWnd);"
                IF Use_Sound THEN
                    FPRINT FP_WRITE, Scoot$, "midiOutClose (hMidi);"  ' Added by MrBcx 825
                END IF
                FPRINT FP_WRITE, Scoot$, "return EXIT_SUCCESS;"
                InDialogEvt = FALSE
            END IF

            IF ModDialogEvt THEN
                FPRINT FP_WRITE, Scoot$, "if(Msg==WM_CLOSE) EndDialog(hWnd,0);"
                IF Use_Sound THEN
                    FPRINT FP_WRITE, Scoot$, "midiOutClose (hMidi);"  ' Added by MrBcx 825
                END IF
                FPRINT FP_WRITE, Scoot$, "return EXIT_SUCCESS;"
                ModDialogEvt = FALSE
            END IF

            IF CallBackFlag THEN
                FPRINT FP_WRITE, Scoot$, "return DefWindowProc(hWnd, Msg, wParam, lParam);"
                CallBackFlag = FALSE
            END IF
        END IF

        IF iMatchWrd(Stk$[1], "endsub") THEN


            ' Clean up dynamic strings
            IF NOTZERO (LocalDynaCnt) THEN

                FOR INT j = 1 TO LocalDynaCnt
                    FPRINT FP_WRITE, Scoot$, DynaStr$[j]
                NEXT

                LocalDynaCnt = 0
            END IF
            ' Clean up dynamic strings arrays
            IF NOTZERO(LocalDynArrCnt) THEN

                FOR INT i = 1 TO LocalDynArrCnt
                    FPRINT FP_WRITE, Scoot$, LocalDynArrName$[i]
                NEXT

                LocalDynArrCnt = 0
            END IF
        END IF

        IF ForceMainToFunc = TRUE AND NoMain = FALSE THEN
            IF Use_Sound THEN
                FPRINT FP_WRITE, Scoot$, "midiOutClose (hMidi);"  ' Added by MrBcx 825
            END IF
            FPRINT FP_WRITE, Scoot$, "return EXIT_SUCCESS;"
            ForceMainToFunc = FALSE
        END IF

        CALL BumpDown("Unbalance statements occurred before END")

        IF InNameSpace OR InClass OR InCppTypeDef THEN
            FPRINT FP_UDT, Scoot$, "}\n"

            DIM RAW iIndentsUsed AS INTEGER, szErr$

            iIndentsUsed = 0
            szErr$ = ""
            IF InNameSpace THEN
                INCR iIndentsUsed, (InNameSpace * 2)
                szErr$ = " Namespace,"
            END IF
            IF InClass THEN
                INCR iIndentsUsed, ((InClass+1) * 2)
                szErr$ += " Class Module,"
            END IF
            IF InCppTypeDef THEN
                INCR iIndentsUsed, (InCppTypeDef * 2)
                szErr$ += " PPType,"
            END IF
            IF Indent > iIndentsUsed THEN
                szErr$ = LEFT$(szErr$, LEN(szErr$)-1)
                szErr$ = "Possible missing (" + USING$("##", (Indent-iIndentsUsed)* 0.5) + ") END statements in" + szErr$ + " SUB/FUNCTION"
                PRINT REPEAT$(80, "_")
                PRINT szErr$
                PRINT REPEAT$(80, "_")
            END IF
        ELSE
            FPRINT FP_WRITE, Scoot$, "}\n\n"
        END IF

        InFunction = Use_Static = FALSE

        IF FP_WRITE = FP3 THEN
            InIfDef$ = "FP3"
        END IF

        IF NOT (InNameSpace OR InClass) THEN
            FP_WRITE = FP2
        END IF
        ByrefCnt = 0

        CASE ELSE
        CALL Emit_Old(FuncRetnFlag)

    END SELECT
    RETURN 0
END FUNCTION ' Emit_EndFuncSub




FUNCTION Emit_Union(sWord$, FuncRetnFlag AS PINT)
    SELECT CASE sWord$
        CASE "union"

        IF InTypeDef = 0 THEN
            SaveFP_WRITENum = FP_WRITE
        END IF

        FP_WRITE = FP_UDT

        INCR InTypeDef

        IF cMaxBaseTypeDefs = InTypeDef THEN
            CALL Abort("Maximum number of nested TypeDefs exceeded.")
        END IF

        TypeDefName$[InTypeDef] = Stk$[2]
        CALL AddTypeDefs(TypeDefName$[InTypeDef], vt_UNION)
        BaseTypeDefsCnt[InTypeDef] = TypeDefsCnt
        FPRINT FP_WRITE, ""

        IF InTypeDef = 1 THEN
            FPRINT FP_WRITE, "typedef union "
            FPRINT FP_WRITE, "{"
        ELSE
            FPRINT FP_WRITE, Scoot$, "union"
            FPRINT FP_WRITE, Scoot$, "{"
            CALL AddTypedefElement(BaseTypeDefsCnt[InTypeDef-1], vt_UNION, TypeDefName$[InTypeDef], TypeDefName$[InTypeDef])
        END IF
        CALL BumpUp

        CASE "endunion"
        CALL BumpDown("Unbalanced UNION/END UNION")
        IF InTypeDef = 1 THEN
            FPRINT FP_WRITE, "} ", TypeDefName$[InTypeDef], ", *LP", UCASE$(TypeDefName$[InTypeDef]), ", *", UCASE$(TypeDefName$[InTypeDef]), "_PTR", ";"
            FP_WRITE = SaveFP_WRITENum
        ELSE
            FPRINT FP_WRITE, Scoot$, "} ", TypeDefName$[InTypeDef], ";"
        END IF
        FPRINT FP_WRITE, ""
        DECR InTypeDef

        CASE ELSE
        CALL Emit_Old(FuncRetnFlag)

    END SELECT
    RETURN 0
END FUNCTION ' Emit_Union




FUNCTION Emit_Type(sWord$, FuncRetnFlag AS PINT)
    UNREFERENCED_PARAMETER(FuncRetnFlag)
    SELECT CASE sWord$
        CASE "type"
        DIM STATIC i, j
        IF InTypeDef = 0 THEN
            SaveFP_WRITENum = FP_WRITE
        END IF
        FP_WRITE = FP_UDT
        IF Ndx > 2 THEN
            IF InTypeDef THEN
                CALL Abort("Single line TYPE within type/union not supported")
            END IF

            i = GetAsPosB(Ndx, 1)

            IF i = 0 THEN
                CALL Abort("Missing AS TYPE")
            END IF
            FPRINT FP_WRITE, Scoot$, "typedef "; ' Suppress CRLF
            j = i-1
            INCR i

            DO WHILE i <= Ndx
                FPRINT FP_WRITE, Stk$[i], SPC$; ' Suppress CRLF
                INCR i
            LOOP

            FOR i = 2 TO j
                FPRINT FP_WRITE, Stk$[i]; ' Suppress CRLF
            NEXT
            FPRINT FP_WRITE, ";"
            FP_WRITE = SaveFP_WRITENum
        ELSE
            INCR InTypeDef

            IF cMaxBaseTypeDefs = InTypeDef THEN
                CALL Abort("Maximum number of nested TypeDefs exceeded.")
            END IF

            TypeDefName$[InTypeDef] = Stk$[2]
            CALL AddTypeDefs(TypeDefName$[InTypeDef], vt_STRUCT)
            BaseTypeDefsCnt[InTypeDef] = TypeDefsCnt
            IF InClass OR InTypeDef > 1 THEN
                FPRINT FP_WRITE, Scoot$, "struct"
                FPRINT FP_WRITE, Scoot$, "{"
                CALL AddTypedefElement(BaseTypeDefsCnt[InTypeDef-1], vt_STRUCT, TypeDefName$[InTypeDef], TypeDefName$[InTypeDef])
            ELSE
                FPRINT FP_WRITE, ""
                FPRINT FP_WRITE, "typedef struct _", TypeDefName$[InTypeDef]
                FPRINT FP_WRITE, "{"
            END IF
            CALL BumpUp
        END IF

        CASE "endtype"
        CALL BumpDown("Unbalanced TYPE/END TYPE")
        IF InClass THEN
            FPRINT FP_WRITE, Scoot$, "} ", TypeDefName$[InTypeDef], ";"
            FPRINT FP_WRITE, ""
        ELSE
            DIM szTDNames$
            IF Ndx > 1 THEN
                DIM STATIC i, j
                i = GetAsPosB(Ndx, 1)

                IF i = 0 THEN
                    CALL Abort("Missing AS after END TYPE")
                END IF

                szTDNames$ = ", "
                FOR INT ii = i+1 TO Ndx
                    j = INCHR(Stk$[ii], "*")
                    IF j THEN Stk$[ii] = MID$(Stk$[ii], j)+LEFT$(Stk$[ii], j - 1)
                    szTDNames$ += Stk$[ii]
                NEXT
            END IF
            IF InTypeDef = 1 THEN
                FPRINT FP_WRITE, "}", TypeDefName$[InTypeDef], ", *LP", UCASE$(TypeDefName$[InTypeDef]), ", *", UCASE$(TypeDefName$[InTypeDef]), "_PTR", szTDNames$, ";"
                FPRINT FP_WRITE, ""
                FP_WRITE = SaveFP_WRITENum
                FPRINT FP_CST, Scoot$, "#define ", UCASE$(TypeDefName$[InTypeDef]), "_CLASS struct _", UCASE$(TypeDefName$[InTypeDef]), "*"
            ELSE
                FPRINT FP_WRITE, Scoot$, "} ", TypeDefName$[InTypeDef], szTDNames$, ";"
                FPRINT FP_WRITE, ""
            END IF
        END IF
        DECR InTypeDef
    END SELECT
    RETURN 0
END FUNCTION ' Emit_Type






FUNCTION Emit_PPType(sWord$, FuncRetnFlag AS PINT)
    SELECT CASE sWord$

        CASE "pptype"
        FP_WRITE = FP_UDT

        IF InTypeDef OR InCppTypeDef OR InClass OR InFunction OR ISNULL(Stk$[2]) THEN
            CALL Abort("Syntax Error")
        END IF

        FPRINT FP_UDT, ""

        IF InIfDef$ <> "FP3" AND NOTNULL(InIfDef$) THEN
            FPRINT FP_UDT, InIfDef$
        END IF

        FPRINT FP_UDT, "struct "; ' Suppress CRLF
        FOR INT i = 2 TO Ndx
            IF iMatchWrd(Stk$[i], "using") THEN Stk$[i] = ": "
            AddSpace(i)
            FPRINT FP_UDT, Stk$[i]; ' Suppress CRLF
        NEXT
        CALL BumpUp
        FPRINT FP_UDT, "\n", Scoot$, "{"
        INCR InCppTypeDef

        CASE "endpptype"

        IF InCppTypeDef <> 1 THEN
            CALL Abort("Syntax Error")
        END IF

        CALL BumpDown("Extra unindents and/or missing indents before END PPTYPE")
        FPRINT FP_UDT, Scoot$, "};"
        DECR InCppTypeDef

        CASE ELSE
        CALL Emit_Old(FuncRetnFlag)

    END SELECT
    RETURN 0
END FUNCTION ' Emit_PPType



SUB GetParameterASHelper(iEQPos AS INTEGER, iASPos AS INTEGER, iOptOk AS INTEGER, iLoc AS INTEGER)
    DIM STATIC iLast

    IF iOptOk = 0 THEN
        CALL Abort("Optional variables not supported without OPTIONAL")
    END IF

    IF iASPos = 0 THEN
        iLast = iLoc
    ELSE
        IF iASPos < iEQPos THEN
            iLast = iLoc
        ELSE
            iLast = iASPos-1
        END IF
    END IF
    FOR INT i = iEQPos+1 TO iLast
        Stk$[iEQPos] += SPC$
        Stk$[iEQPos] += Stk$[i]
        Stk$[i] = ""
    NEXT
END SUB ' GetParameterASHelper



SUB GetParameter (piStart AS PINT, ptVar AS VARCODE PTR, iAParam AS INT, iNoParam AS INT, iOptOk AS INT)
    '**************************
    ' This is a recursive SUB
    '**************************
    DIM RAW iASPos = 0
    DIM RAW iEQPos = 0
    DIM RAW iNd
    DIM RAW iLoc = *piStart
    IF ISNULL(Stk$[iLoc]) THEN EXIT SUB

    ptVar->Token$ = Clean$(Stk$[iLoc])

    DO
        IF Stk$[iLoc+1] = "(" THEN
            ' function as parameter type
            DIM STATIC iEndPoint
            DIM STATIC LTmp$
            DIM STATIC iStartPoint
            DIM RAW FP AS FUNCPARSE
            CLEAR(FP)

            CallType$ = ""
            CALL SepFuncArgs(iLoc-1, ADDRESSOF(FP), TRUE)
            iStartPoint = IMAX(FP.CommaPos[0], iLoc)
            SFPOINTER = TRUE
            ' ------------------------------------------------------
            '  Get intialized data  " = xxx" or "= {xxx,xxx}"
            ' ------------------------------------------------------
            IF FP.NumArgs = 0 THEN
                iEndPoint = IMIN(FP.CommaPos[1]+1, Ndx)
            ELSE
                iEndPoint = IMIN(FP.CommaPos[FP.NumArgs]+1, Ndx)
            END IF

            IF Stk$[iEndPoint] = "=" THEN
                Stk$[iEndPoint++] = ""
                DO WHILE NOT iMatchWrd(Stk$[iEndPoint], "as") AND iEndPoint <= Ndx
                    LTmp$ += Stk$[iEndPoint]
                    Stk$[iEndPoint++] = ""
                LOOP
                RemoveAll(LTmp$, "{}", 1)
                IF NOTNULL(LTmp$) THEN CALL RemEmptyTokens
            END IF
            ' ------------------------------------------------------
            DIM STATIC L_FuncName$
            DIM STATIC OldiEndPoint
            IF iMatchWrd(Stk$[iEndPoint], "as") THEN
                INCR iEndPoint
                IF iMatchWrd(Stk$[iEndPoint], "function") THEN
                    LShiftStk(iEndPoint)
                END IF
                DO WHILE *Stk$[iEndPoint] <> ASC(",") AND *Stk$[iEndPoint] <> ASC(")")
                    IF ISNULL(Stk$[iEndPoint]) THEN
                        LShiftStk(iEndPoint)
                    ELSE
                        INCR iEndPoint
                    END IF
                LOOP
            END IF
            OldiEndPoint = iEndPoint

            DIM STATIC tVar AS VARCODE
            tVar.IsExported = FALSE
            tVar.UseInLine = UseInLine

            *piStart = iStartPoint-1
            CALL InsertTokens((*piStart)-1, 1, "function")
            CALL FuncSubDecs1("sub", iStartPoint-1, iEndPoint, ADDRESSOF(tVar))
            CALL FuncSubDecs2("sub", mt_FuncSubDecC_Dec, ADDRESSOF(tVar), *piStart, ADDRESSOF(OldiEndPoint))
            tVar.Functype$ = LTRIM$(tVar.Functype$)
            L_FuncName$ = Clean$(Stk$[iStartPoint])
            *piStart = iStartPoint+2
            DO WHILE *piStart < OldiEndPoint
                CALL GetParameter(piStart, ADDRESSOF(tVar), mt_FuncSubDecC_DecAParam, mt_FuncSubDecC_DecNoParam, 0)
                (*piStart)++
            LOOP

            tVar.Methd% = mt_FuncSubDecC_DecAParam
            tVar.Token$ = L_FuncName$
            FuncSubDecs3(ADDRESSOF(tVar), OldiEndPoint, 1)
            ptVar->Header$ += tVar.Header$
            ptVar->Proto$ += tVar.Proto$
            *piStart = iEndPoint
            IF Stk$[(*piStart)+1] = "," THEN
                ptVar->Header$ += ","
                ptVar->Proto$ += ","
                (*piStart)++
            END IF
            SFPOINTER = FALSE
            EXIT SUB
        END IF
        IF Stk$[iLoc] = "," OR Stk$[iLoc] = ")" THEN EXIT DO
        IF iMatchWrd(Stk$[iLoc], "as") THEN iASPos = iLoc
        IF iMatchWrd(Stk$[iLoc], "=") THEN iEQPos = iLoc
        INCR iLoc
    LOOP
    DECR iLoc
    IF Stk$[iLoc] <> "..." THEN
        DIM RAW iIsConst = 0
        IF iEQPos THEN CALL GetParameterASHelper(iEQPos, iASPos, iOptOk, iLoc)
        IF iASPos THEN
            DIM RAW iLast = iLoc
            DIM RAW iAfterAs1 = iASPos+1
            DIM RAW iAfterAs2 = iASPos+2
            IF iASPos < iEQPos THEN iLast = iEQPos-1
            IF iAfterAs1 <> iLast THEN
                IF iMatchWrd(Stk$[iAfterAs1], "const") THEN
                    iIsConst = 1
                    Stk$[iAfterAs1] += SPC$
                    Stk$[iAfterAs1] += Stk$[iAfterAs2]
                    Stk$[iAfterAs2] = ""
                END IF

                XFOR INT i = iAfterAs2 WHILE i <= iLast BY i++
                    IF iMatchWrd(Stk$[i], "ptr") THEN Stk$[i] = "*"
                    Stk$[iAfterAs1] += Stk$[i]
                    Stk$[i] = ""
                XNEXT

            END IF
            ptVar->AsToken$ = Stk$[iAfterAs1]
            CALL GetTypeInfo(ptVar->AsToken$, ADDRESSOF((ptVar->IsPtrFlag)), ADDRESSOF(iNd), ADDRESSOF((ptVar->VarNo)))
        ELSE
            DIM RAW iPtrCnt = TALLY(Stk$[*piStart], "*")
            ptVar->AsToken$ = VarTypeLookup$[INCHR(VARTYPES$, RIGHT$(Stk$[*piStart], 1))] + STRING$(iPtrCnt, ASC("*"))
            REMOVE "*" FROM Stk$[*piStart]
            CALL GetTypeInfo(ptVar->AsToken$, ADDRESSOF((ptVar->IsPtrFlag)), ADDRESSOF(iNd), ADDRESSOF((ptVar->VarNo)))
        END IF
        ptVar->Methd% = iAParam
        CALL GetVarCode(ptVar, "GetParameter 1")
        IF iEQPos THEN
            ptVar->Methd% = iNoParam
            ptVar->Token$ = Stk$[iEQPos]
            CALL GetVarCode(ptVar, "GetParameter 2")
        END IF

        CALL AddLocal(ptVar->Token$, ptVar->VarNo, 0, "", ptVar->IsPtrFlag, 0, 0, iIsConst)
    ELSE
        ptVar->Methd% = iNoParam
        ptVar->Token$ = Stk$[iLoc]
        CALL GetVarCode(ptVar, "GetParameter 3")

    END IF

    INCR iLoc
    IF Stk$[iLoc] = "," THEN
        ptVar->Methd% = iNoParam
        ptVar->Token$ = Stk$[iLoc]
        CALL GetVarCode(ptVar, "GetParameter 4")
    END IF

    *piStart = iLoc
END SUB ' GetParameter



FUNCTION Emit_OptFuncSub(sWord$, FuncRetnFlag AS PINT)
    SELECT CASE sWord$

        CASE "optfunction", "optsub"  ' , "optdeclare"
        DIM RAW IOptLoc AS INTEGER
        DIM RAW VarCode AS VARCODE
        VarCode.IsExported = FALSE
        VarCode.UseInLine = UseInLine

        CALL FuncSubDecs1("optsub", 1, Ndx, ADDRESSOF(VarCode))

        InFunction = TRUE
        LocalVarCnt = 0

        IF InNameSpace THEN
            FP_WRITE = FP2
        ELSE
            IF UsingTemplate = FALSE THEN
                FP_WRITE = FP3
            END IF
        END IF

        CALL FuncSubDecs2("optsub", mt_Opts, ADDRESSOF(VarCode), 1, ADDRESSOF(Ndx))

        FunctionName$ = Clean$(Stk$[2])

        IOptLoc = 4

        DO WHILE IOptLoc < Ndx
            CALL GetParameter(ADDRESSOF(IOptLoc), ADDRESSOF(VarCode), mt_OptsAParam, mt_OptsNoParam, 1)
            INCR IOptLoc
        LOOP

        VarCode.Methd% = mt_FuncSubDecC_DecAParam
        VarCode.Token$ = FunctionName$
        FuncSubDecs3(ADDRESSOF(VarCode), Ndx, 0)

        IF Use_Static THEN
            VarCode.Header$ = "static " + VarCode.Header$
            VarCode.Proto$ = "static " + VarCode.Proto$
        END IF

        CALL AddProto(VarCode.Proto$)

        IF InIfDef$ = "FP3" THEN
            ProtoType[ProtoCnt].Condition$ = ""
        ELSE
            ProtoType[ProtoCnt].Condition$ = InIfDef$
        END IF
        ProtoType[ProtoCnt].CondLevel  = InConditional

        FPRINT FP_WRITE, VarCode.Header$    ' 775 MrBcx - Do not change these two
        FPRINT FP_WRITE, Scoot$, "{"        ' lines. You will break c++ parsing!
        CALL BumpUp

        CASE ELSE
        CALL Emit_Old(FuncRetnFlag)

    END SELECT
    RETURN 0
END FUNCTION ' Emit_OptFuncSub



FUNCTION Emit_OverLoadFuncSub(sWord$, FuncRetnFlag AS PINT)
    DIM STATIC VarCode AS VARCODE
    GLOBAL Use_Overloaded_Macro
    Use_Overloaded_Macro = TRUE

    VarCode.IsExported = FALSE
    VarCode.UseInLine = UseInLine

    SELECT CASE sWord$

        CASE "overloadedfunction", "overloadedsub"
        DIM STATIC LTmp$
        DIM STATIC A
        Use_Overloaded = TRUE
        CALL FuncSubDecs1("overloadedsub", 1, Ndx, ADDRESSOF(VarCode))
        IF sWord$ = "overloadedfunction" THEN
            InFunction = eFunctionType
        ELSE
            InFunction = eSubType
        END IF
        InMain = FALSE
        LocalVarCnt = 0

        IF UsingTemplate = FALSE THEN
            FP_WRITE = FP_OVR    ' <<----- writing TO BCX.OVR
        END IF

        CALL FuncSubDecs2("overloadedsub", mt_OverLoad, ADDRESSOF(VarCode), 1, ADDRESSOF(Ndx))

        FunctionName$ = Clean$(Stk$[2])
        LTmp$ = " overloaded " + FunctionName$
        FunctionName$ = LTmp$

        A = 4
        DO WHILE A < Ndx
            CALL GetParameter(ADDRESSOF(A), ADDRESSOF(VarCode), mt_OverLoadAParam, mt_OverLoadNoParam, 0)
            INCR A
        LOOP

        VarCode.Methd% = mt_FuncSubDecC_Dec
        VarCode.Token$ = FunctionName$
        FuncSubDecs3(ADDRESSOF(VarCode), Ndx, 0)

        IF Use_Static THEN
            VarCode.Header$ = "static " + VarCode.Header$
        END IF

        FPRINT FP_WRITE, VarCode.Header$    ' 775 MrBcx - Do not change these two
        FPRINT FP_WRITE, Scoot$, "{"        ' lines. You will break c++ parsing!

        CALL BumpUp

        CASE ELSE
        CALL Emit_Old(FuncRetnFlag)

    END SELECT
    RETURN 0
END FUNCTION ' Emit_OverLoadFuncSub



FUNCTION ClassProto(szProto AS PCHAR)
    '************************************************************************
    ' This FUNCTION checks if a given prototype string (szProto$) matches any
    ' of the class names stored in the ClassNames$ array. It iterates through
    ' the array and returns 1 if a match is found, otherwise returns 0.
    '************************************************************************
    DIM STATIC iReturn
    DIM STATIC iCnt
    XFOR iReturn = 0, iCnt = 0 WHILE iCnt < iClassCnt AND iReturn = 0 BY iCnt++
        IF szProto$ = ClassNames$[iCnt] THEN iReturn = 1
    XNEXT
    RETURN iReturn
END FUNCTION



FUNCTION Emit_ConDes(sWord$, FuncRetnFlag AS PINT)
    SELECT CASE sWord$
        CASE "constructor", "destructor"

        IF InFunction THEN
            CALL Abort("Syntax Error: already in function")
        END IF

        DIM RAW A
        DIM RAW CTOR_USE$
        DIM RAW New_Ndx = Ndx
        DIM RAW iCPPFunSub
        DIM RAW VarCode AS VARCODE
        VarCode.IsExported = FALSE
        VarCode.UseInLine = UseInLine
        iCPPFunSub = 0

        FOR INT ct = 1 TO Ndx
            IF Stk$[ct] = "using" THEN
                iCPPFunSub = 1
                New_Ndx = ct-1
                CALL BuildDelimStr(ct+1, Ndx, CTOR_USE$)
                EXIT FOR
            END IF
        NEXT
        Ndx = New_Ndx

        CALL FuncSubDecs1("sub", 1, Ndx, ADDRESSOF(VarCode))
        IsStdFunc = FALSE

        InMain = FALSE
        LocalVarCnt = 0

        IF InNameSpace OR InClass OR InCppTypeDef THEN
            InFunction = FALSE
            FP_WRITE = FP_UDT
        ELSE
            InFunction = TRUE
            IF UsingTemplate = FALSE THEN
                FP_WRITE = FP3
            END IF
        END IF

        CALL FuncSubDecs2("sub", mt_ConsDes, ADDRESSOF(VarCode), 1, ADDRESSOF(Ndx))
        ' to compensate previous substitution errors not fixed

        VarCode.Functype$ = LTRIM$(VarCode.Functype$)
        FunctionName$ = Clean$(Stk$[2])

        A = 4
        DO WHILE A < Ndx
            CALL GetParameter(ADDRESSOF(A), ADDRESSOF(VarCode), mt_ConsDesAParam, mt_ConsDesNoParam, 1)
            INCR A
        LOOP

        IF (sWord$ = "constructor") OR (ISTRUE(INCHR(FunctionName$, "~"))) THEN
            VarCode.Token$ = FunctionName$
        ELSE
            VarCode.Token$ = "~" + FunctionName$
        END IF

        VarCode.Methd% = mt_FuncSubDecC_DecAParam
        FuncSubDecs3(ADDRESSOF(VarCode), Ndx, 0)

        IF Use_Static THEN
            VarCode.Header$ = "static " + VarCode.Header$
            VarCode.Proto$  = "static " + VarCode.Proto$
        END IF

        IF iMatchNQ (VarCode.Proto$, "::") = 0 AND IAmNot(InNameSpace) AND IAmNot(InClass) AND IAmNot(InCppTypeDef) THEN
            iCPPFunSub = 0
            CALL AddProto(VarCode.Proto$)
            IF InIfDef$ = "FP3" THEN
                IF ProtoCnt > 1 THEN
                    ProtoType[ProtoCnt].Condition$ = ProtoType[ProtoCnt-1].Condition$
                ELSE
                    ProtoType[ProtoCnt].Condition$ = ""
                END IF
            ELSE
                ProtoType[ProtoCnt].Condition$ = InIfDef$
            END IF

            ProtoType[ProtoCnt].CondLevel  = InConditional

            IF *InIfDef$ THEN
                IF InIfDef$ <> "FP3" THEN
                    FPRINT FP_WRITE, InIfDef$
                END IF
            END IF
        END IF

        IF iCPPFunSub = 1 THEN
            FPRINT FP_WRITE, Scoot$, VarCode.Header$, ": ", CTOR_USE$
        ELSE
            FPRINT FP_WRITE, Scoot$, VarCode.Header$  ' 775 MrBcx - Do not change these two
        END IF
        FPRINT FP_WRITE, Scoot$, "{"                  ' lines. You will break c++ parsing!
        CALL BumpUp

        CASE "endconstructor"
        CALL BumpDown("Unbalanced CONSTRUCTOR/END CONSTRUCTOR")
        FPRINT FP_WRITE, Scoot$, "}"
        InFunction = FALSE

        CASE "enddestructor"
        CALL BumpDown("Unbalanced DESTRUCTOR/END DESTRUCTOR")
        FPRINT FP_WRITE, Scoot$, "}"
        InFunction = FALSE

        CASE ELSE
        CALL Emit_Old(FuncRetnFlag)

    END SELECT
    RETURN 0
END FUNCTION ' Emit_ConDes




FUNCTION Emit_Implied(sWord$, FuncRetnFlag AS PINT)
    SELECT CASE sWord$
        ' IMPFUNCTION module() = 0 AS virtual double
        CASE "impfunction"
        DIM RAW A
        DIM RAW szImp$
        DIM RAW VarCode AS VARCODE
        VarCode.IsExported = FALSE
        VarCode.UseInLine = UseInLine

        CALL FuncSubDecs1("sub", 1, Ndx, ADDRESSOF(VarCode))
        IsStdFunc = FALSE
        InMain = FALSE
        LocalVarCnt = 0
        CALL FuncSubDecs2("sub", mt_FuncSubDecC_Dec, ADDRESSOF(VarCode), 1, ADDRESSOF(Ndx))
        szImp$ = ""
        DO
            szImp$ = Stk$[Ndx]+ szImp$
        LOOP WHILE Stk$[Ndx--] <> "="

        ' to compensate previous substitution errors not fixed

        VarCode.Functype$ = LTRIM$(VarCode.Functype$)
        FunctionName$ = Clean$(Stk$[2])

        A = 4
        DO WHILE A < Ndx
            CALL GetParameter(ADDRESSOF(A), ADDRESSOF(VarCode), mt_OptsAParam, mt_OptsNoParam, 1)
            INCR A
        LOOP

        VarCode.Methd% = mt_FuncSubDecC_DecAParam
        VarCode.Token$ = FunctionName$
        FuncSubDecs3(ADDRESSOF(VarCode), Ndx, 0)
        FPRINT FP_UDT, Scoot$, VarCode.Header$, szImp$, ";"

        CASE ELSE
        CALL Emit_Old(FuncRetnFlag)
    END SELECT

    RETURN 0
END FUNCTION ' Emit_Implied




FUNCTION Emit_FuncSub(sWord$, FuncRetnFlag AS PINT)
    SELECT CASE sWord$
        CASE _
        "function", _
        "sub", _
        "publicfunction", _
        "publicsub", _
        "privatefunction", _
        "privatesub"

        IF InFunction THEN
            CALL Abort("Syntax Error: Nested functions not supported.")
        END IF

        DIM STATIC A
        DIM STATIC CTOR_USE$
        DIM STATIC iCPPFunSub
        DIM STATIC VarCode AS VARCODE

        DIM RAW New_Ndx = Ndx
        VarCode.IsExported = FALSE
        VarCode.UseInLine = UseInLine

        SELECT CASE sWord$
            CASE "publicfunction", "publicsub"
            Stk$[1] = MID$(Stk$[1], 6)
            CASE "privatefunction", "privatesub"
            Stk$[1] = MID$(Stk$[1], 7)
        END SELECT

        iCPPFunSub = 0

        FOR INT ct = 1 TO Ndx
            IF iMatchWrd(Stk$[ct], "using") THEN
                iCPPFunSub = 1
                New_Ndx = ct-1
                CALL BuildDelimStr(ct+1, Ndx, CTOR_USE$)
                EXIT FOR
            END IF
        NEXT
        Ndx = New_Ndx

        IF Stk$[2] = "main" THEN
            NoMain = TRUE
            Stk$[1] = "function"
            Stk$[2] = "main%"
            ForceMainToFunc = TRUE
        END IF

        CALL FuncSubDecs1("sub", 1, Ndx, ADDRESSOF(VarCode))

        IsStdFunc = FALSE

        IF iMatchWrd(Stk$[Ndx], "stdcall") THEN
            CallType$ = "__stdcall "
            DECR Ndx
            IsStdFunc = TRUE
        END IF

        InMain = FALSE
        LocalVarCnt = 0

        ' IF InNameSpace OR InClass OR InCppTypeDef THEN  ' 786 MrBcx - This important change correctly emits this in CLASSES:
        IF InNameSpace OR InCppTypeDef THEN               '             char *BCX_RetStr={0};
            InFunction = FALSE                            ' allowing normal BCX string functions to be used in C++ CLASSES
            FP_WRITE = FP2
        ELSE
            IF iMatchNQ (sWord$, "function") THEN
                InFunction = eFunctionType
            ELSE
                InFunction = eSubType
            END IF
            IF UsingTemplate = FALSE THEN
                FP_WRITE = FP3
            END IF
        END IF
        VarCode.Functype$ = LTRIM$(VarCode.Functype$)

        CALL FuncSubDecs2("sub", mt_FuncSubDecC_Dec, ADDRESSOF(VarCode), 1, ADDRESSOF(Ndx))

        IF iMatchRgt(Stk$[2], "operator") THEN
            VarCode.Functype$ += Stk$[2]
            VarCode.Functype$ += SPC$
            FunctionName$ = ""
            DIM RAW bOppFound AS BOOL

            XFOR A = 3, bOppFound = FALSE WHILE NOT bOppFound BY A++
                IF *Stk$[A] = ASC("(") THEN
                    IF *Stk$[A+1] <> ASC(")") AND *Stk$[A+2] <> ASC("(") THEN bOppFound = TRUE
                    IF *Stk$[A+1] = ASC(")") AND A > 3 THEN bOppFound = TRUE
                END IF
                IF NOT bOppFound THEN
                    VarCode.Functype$ += Stk$[A]
                END IF
            XNEXT

        ELSE

            FunctionName$ = Clean$(Stk$[2])
            IF VarCode.IsExported OR IsStdFunc THEN
                FunctionName$ = CallType$ + FunctionName$
            END IF
            A = 4
        END IF

        '*******************************************************************************
        ' FOR DEBUGGING:
        ' PRINT FunctionName$, " is ", VarCode.Functype$
        '*******************************************************************************

        DO WHILE A < Ndx
            IF UseCpp THEN
                CALL GetParameter(ADDRESSOF(A), ADDRESSOF(VarCode), mt_OptsAParam, mt_OptsNoParam, 1)
            ELSE
                CALL GetParameter(ADDRESSOF(A), ADDRESSOF(VarCode), mt_FuncSubDecC_DecAParam, mt_FuncSubDecC_DecNoParam, 0)
            END IF
            INCR A
        LOOP

        VarCode.Methd% = mt_FuncSubDecC_DecAParam
        VarCode.Token$ = FunctionName$
        FuncSubDecs3(ADDRESSOF(VarCode), Ndx, 0)

        IF iMatchWrd(Stk$[Ndx], "const") THEN
            VarCode.Header$ += " const"
        END IF

        IF iMatchLft(VarCode.Header$, "main(")  THEN
            VarCode.Header$ = "int main(int argc, LPCTSTR argv[])"
            VarCode.Proto$  = "int main(int argc, LPCTSTR argv[]);"
            CurrentFuncType = vt_INTEGER
        END IF

        IF Use_Static THEN
            VarCode.Header$ = "static " + VarCode.Header$
            VarCode.Proto$  = "static " + VarCode.Proto$
        END IF

        IF IAmNot(InNameSpace) AND IAmNot(InClass) AND IAmNot(InCppTypeDef) THEN
            DIM RAW iClassFunction
            DIM RAW tmp$

            tmp$ = EXTRACT$(VarCode.Proto$, "(")
            IF iMatchNQ (tmp$, "::") > 0 THEN
                tmp$ = EXTRACT$(tmp, "::")
                iClassFunction = ClassProto(tmp$)
                IF iClassFunction = 0 THEN

                    IF cMaxClassNames = iClassCnt THEN
                        CALL Abort("Maximum cMaxClassNames =" + STR$(cMaxClassNames) + " reached")
                    END IF

                    ClassNames$[iClassCnt] = tmp$
                    INCR iClassCnt
                END IF
                iClassFunction = 1
            ELSE
                iClassFunction = 0
            END IF
            IF iClassFunction = 0 THEN
                CALL AddProto(VarCode.Proto$)
                IF InIfDef$ = "FP3" THEN
                    IF ProtoCnt > 1 THEN
                        ProtoType[ProtoCnt].Condition$ = ProtoType[ProtoCnt-1].Condition$
                    ELSE
                        ProtoType[ProtoCnt].Condition$ = ""
                    END IF
                ELSE
                    ProtoType[ProtoCnt].Condition$ = InIfDef$
                END IF

                ProtoType[ProtoCnt].CondLevel  = InConditional
                IF NOTNULL (InIfDef$) THEN
                    IF InIfDef$ <> "FP3" THEN
                        FPRINT FP_WRITE, InIfDef$
                    END IF
                END IF
            END IF
        END IF

        IF InNameSpace OR InClass OR InCppTypeDef THEN
            DIM szCPP_SF1$
            IF iMatchWrd(Stk$[2], InClassName$) AND InClass THEN
                VarCode.Header$ = REMAIN$(VarCode.Header$, SPC$)
            END IF
            FPRINT FP_UDT, Scoot$, szCPP_SF1$, VarCode.Header$; ' Suppress CRLF
            IF iCPPFunSub = 1 THEN
                FPRINT FP_UDT, " : ", CTOR_USE$
            ELSE
                FPRINT FP_UDT, ""
            END IF
            FP_WRITE = FP_UDT
        ELSE
            FPRINT FP_WRITE, VarCode.Header$
        END IF

        FPRINT FP_WRITE, Scoot$, "{"
        CALL BumpUp

        CASE ELSE
        CALL Emit_Old(FuncRetnFlag)

    END SELECT
    RETURN 0
END FUNCTION ' Emit_FuncSub


'*******************************************************************
'   Global variable emitter for variables used by BCX functions.
'*******************************************************************


SUB Emit_BCXVariables
    DO WHILE iEmitVarGroup
        SELECT CASE 1

            CASE (iEmitVarGroup BAND 1)
            CALL Emit_PrinterVariables
            iEmitVarGroup = iEmitVarGroup XOR ePrinterGroup

            CASE ((iEmitVarGroup SHR 1) BAND 1)

            CALL AddFontVariables
            iEmitVarGroup = iEmitVarGroup XOR eFontGroup

            CASE ((iEmitVarGroup SHR 2) BAND 1)

            CALL AddClassName
            iEmitVarGroup = iEmitVarGroup XOR eClassName

            CASE ((iEmitVarGroup SHR 3) BAND 1)

            CALL AddBCX_hInstance
            iEmitVarGroup = iEmitVarGroup XOR eBCX_hInstance

            CASE ELSE
            CALL Abort("Unknown variable grouping was selected (Add to SUB EmitBCXVariables).")
        END SELECT
    LOOP
    ' iEmitVarGroup is zero when it gets here
END SUB ' Emit_BCXVariables



SUB AddBCX_hInstance
    DIM STATIC IWasHere = 0
    IF IWasHere THEN EXIT SUB
    CALL AddGlobal("BCX_hInstance", vt_HINSTANCE)
    INCR IWasHere
END SUB ' AddBCX_hInstance



SUB AddClassName
    DIM STATIC IWasHere
    IF IWasHere THEN EXIT SUB
    CALL AddGlobal("BCX_ClassName", vt_STRVAR)
    INCR IWasHere
END SUB ' AddClassName



SUB Emit_PrinterVariables
    DIM STATIC IWasHere
    IF IWasHere THEN EXIT SUB
    CALL AddGlobal("BcxPtr_hDC"       , vt_HDC)
    CALL AddGlobal("BcxPtr_FontMetrix", vt_LONG)
    CALL AddGlobal("BcxPtr_LineCtr"   , vt_LONG)
    CALL AddGlobal("BcxPtr_PrinterOn" , vt_LONG)
    CALL AddGlobal("BcxPtr_hFont"     , vt_HFONT)
    CALL AddGlobal("BcxPtr_hFontOld"  , vt_HFONT)
    CALL AddGlobal("BcxPtr_di"        , vt_DOCINFO)
    CALL AddGlobal("BcxPtr_Lf"        , vt_LOGFONT)
    CALL AddGlobal("BcxPtr_tm"        , vt_TEXTMETRIC)
    CALL AddGlobal("BcxPtr_Text"      , vt_STRVAR)
    CALL AddGlobal("BcxPtr_Buffer"    , vt_STRVAR)
    INCR IWasHere
END SUB ' Emit_PrinterVariables



SUB AddFontVariables
    DIM STATIC IWasHere
    IF IWasHere THEN EXIT SUB
    CALL AddGlobal("BCX_ScaleX", vt_SINGLE)
    CALL AddGlobal("BCX_ScaleY", vt_SINGLE)
    INCR IWasHere
END SUB ' AddFontVariables



SUB AddBcxFontVar
    DIM STATIC IWasHere
    IF IWasHere THEN EXIT SUB
    CALL AddGlobal("BcxFont"  , vt_HFONT)
    INCR IWasHere
END SUB ' AddBcxFontVar


SUB AddPenSizeVariables
    DIM STATIC IWasHere
    IF IWasHere THEN EXIT SUB
    CALL AddGlobal("BCX_Pensize=1",       vt_INTEGER)
    CALL AddGlobal("BCX_Penstyle=0",      vt_INTEGER)
    INCR IWasHere
END SUB   ' AddPenVariables


SUB AddGrafixVariables
    DIM STATIC IWasHere
    IF IWasHere THEN EXIT SUB
    CALL AddGlobal("BCX_BUFFER_BMWIDTH",  vt_INTEGER)
    CALL AddGlobal("BCX_BUFFER_BMHEIGHT", vt_INTEGER)
    CALL AddGlobal("BCX_BUFFER",          vt_HDC)
    CALL AddGlobal("BCX_PREV_BMP",        vt_HBITMAP)
    CALL AddGlobal("BCX_BUFFER_BMP",      vt_BITMAPINFO)
    INCR IWasHere
END SUB ' AddGrafixVariables



SUB AddGUIGlobals
    DIM STATIC IWasHere
    IF IWasHere THEN EXIT SUB
    CALL AddFontVariables
    CALL AddBCX_hInstance
    CALL AddGlobal("BCX_hwndMDIClient", vt_HWND      )
    CALL AddGlobal("BCX_WndClass"     , vt_WNDCLASSEX)
    CALL AddGlobal("BCX_GUI_Init"     , vt_WINBOOL   )
    CALL AddGlobal("BCX_ClassName"    , vt_STRVAR    )
    INCR IWasHere
END SUB ' AddGUIGlobals



SUB ProcessMsgCracker
    ' HANDLE_MSG WM_SIZE INLINE SendMessage(hWnd, WM_XXXX, 0, 0) : EXIT FUNCTION
    DIM RAW msg_$
    DIM RAW proc_$
    DIM RAW ret_$
    DIM RAW tmp_$[16]
    DIM RAW tmpNdx AS INTEGER
    DIM RAW i AS INTEGER
    DIM RAW j AS INTEGER

    i = j = tmpNdx = 0
    FastLexer(Src$, SPC$, ":")
    IF iMatchWrd(Stk$[3], "inline") THEN
        tmp_$[++tmpNdx] = "IF Msg = " + Stk$[2] + " THEN"
        IF Stk$[Ndx] <> ":" THEN Stk$[++Ndx] = ":"
        XFOR i = 4, j = 4 WHILE i <= Ndx BY i++
            IF Stk$[i] = ":" THEN
                CALL BuildDelimStr(j, i-1, tmp_$[++tmpNdx])
                j = i+1
            END IF
        XNEXT
        tmp_$[++tmpNdx] = "END IF"
        FOR i = 1 TO tmpNdx
            CALL Inject(tmp_$[i])
        NEXT
    ELSE
        ' handle_msg(WM_SIZE, form1_onSize)
        FastLexer(Src$, " ,()", "")
        msg_$  = Stk$[2]
        proc_$ = Stk$[3]
        ret_$  = Stk$[4]
        IF NOTNULL(ret_$) THEN ret_$ = "," + ret_$
        Src$ = "IF Msg = " + msg_$ + " THEN"
        Inject(Src$)
        IF LEN(TRIM$(ret_$)) > 0 THEN
            Src$ = "  FUNCTION=" + proc_$ + "(hWnd,wParam,lParam" + ret_$ + ")"
        ELSE
            Src$ = SPACE$(2) + proc_$ + "(hWnd,wParam,lParam" + ret_$ + ")"
        END IF
        Inject(Src$)
        Src$ = "END IF"
        Inject(Src$)
    END IF
    Src$ = ""
END SUB ' ProcessMsgCracker



SUB ProcessCmdHandler
    DIM RAW id_$
    DIM RAW proc_$
    DIM RAW ret_$
    DIM RAW tmp_$[16]
    DIM RAW tmpNdx  AS INTEGER
    DIM RAW i AS INTEGER
    DIM RAW j AS INTEGER
    tmpNdx = 0
    FastLexer(Src$, SPC$, ":")
    IF iMatchWrd(Stk$[3], "inline") THEN
        ' handle_cmd IDM_NEW INLINE SendMessage(hWnd, WM_XXXX, 0, 0) : EXIT FUNCTION:
        tmp_$[++tmpNdx] = "IF Msg = WM_COMMAND AND CBCTL = " + Stk$[2] + " THEN "
        IF Stk$[Ndx] <> ":" THEN Stk$[++Ndx] = ":"
        XFOR i = 4, j = 4 WHILE i <= Ndx BY i++
            IF Stk$[i] = ":" THEN
                CALL BuildDelimStr(j, i-1, tmp_$[++tmpNdx])
                j = i+1
            END IF
        XNEXT
        tmp_$[++tmpNdx] = "END IF"
        FOR i = 1 TO tmpNdx
            CALL Inject(tmp_$[i])
        NEXT
    ELSE
        ' handle_cmd(IDM_NEW, procedure, retval)
        FastLexer(Src$, " ,()", "")
        id_$ = Stk$[2]
        proc_$ = Stk$[3]
        ret_$ = Stk$[4]
        IF NOTNULL(ret_$) THEN ret_$ = "," + ret_$
        Src$ = "IF Msg = WM_COMMAND AND CBCTL = " + id_$ + " THEN"
        Inject(Src$)
        IF LEN(TRIM$(ret_$)) > 0 THEN
            Src$ = "  FUNCTION=" + proc_$ + "(hWnd,wParam,lParam" + ret_$ + ")"
            Inject(Src$)
        ELSE
            Src$ = SPACE$(2) + proc_$ + "(hWnd,wParam,lParam" + ret_$ + ") "
            Inject(Src$)
        END IF
        Src$ = "END IF"
        Inject(Src$)
    END IF
    Src$ = ""
END SUB ' ProcessCmdHandler



SUB ProcessMsgHandler
    ' MSGHANDLER procedure or CMDHANDLER procedure
    FastLexer(Src$, ", ()", "")
    Src$ = "FUNCTION " + Stk$[2] + " OPTIONAL (hWnd AS HWND, wParam AS WPARAM, lParam AS LPARAM, LReturn AS LRESULT=0) AS LRESULT"
    Inject(Src$)
    Src$ = ""
END SUB ' ProcessMsgHandler



SUB ProcessMsgHandlerEnd
    Src$ = "FUNCTION = LReturn"
    Inject(Src$)
    Src$ = "END FUNCTION"
    Inject(Src$)
    Src$ = ""
END SUB ' ProcessMsgHandlerEnd

' ==================================================================================
'                               End Expand Macros
'                   Begin  Directives - tDirectives[].Emitter()
' ==================================================================================

FUNCTION Doinclude(szWord$, iFLAG AS PINT)
    *iFLAG = 0

    SELECT CASE szWord$

        CASE "#include"
        FPRINT FP_HDR, "#include", Src+8

        CASE "$include"
        DIM RAW orgfileName$
        IREPLACE "$BCX$" WITH BCXPATH$ IN Src$
        szFile$ = TRIM$(REMOVE$(MID$(Src$, 9), DQ$))

        IF *szFile = ASC("<") THEN
            szFile$ = MID$(szFile$, 2, LEN(szFile$)-2)
            szFile$ = ENVIRON$("BCXLIB") + szFile$
        END IF

        orgfileName$ = szFile$
        IF NOT EXIST(szFile$) THEN
            szFile$ = BCXSPLITPATH$(szFile$, FNAME|FEXT)
            szFile$ = BCXSPLITPATH$(FileNames$[FileNdx], FDRV BOR FPATH) + szFile$
        END IF

        IF NOT EXIST(szFile$) THEN
            ? "Debug: Inside FUNCTION Doinclude"
            ? "Debug: szFile =", szFile$
            ? "Debug: orgfileName$ =", orgfileName$
            ?
            Abort("Unable to locate " + orgfileName$)
        END IF

        CALL PushFileIO

        OPEN szFile$ FOR INPUT AS SourceFile

        '=============================================================
        FileNdx++                       ' Added by Richard Meyer 8.0.2
        FileNames$[FileNdx] = szFile$   ' Added by Richard Meyer 8.0.2
        LineNum[FileNdx] = 0            ' Added by Richard Meyer 8.0.2
        '=============================================================

        IF FileNdx = cMaxFiles-1 THEN
            CALL Abort("Maximum Include Files exceeded.")
        END IF

    END SELECT
    RETURN 0
END FUNCTION




SUB CreateUserResourceFile
    LOCAL Tmp$
    IF Use_Resource AND NOT Use_GenResFile THEN
        IF NOTNULL(UserResFile$) THEN Res_File$ = UserResFile$
    END IF

    IF Use_GenResFile THEN
        CombineRes = FALSE

        IF EXIST(UserResFile$) THEN CombineRes = TRUE ' don't overwrite rc file
        gTmpStr$ = EXTRACT$(UCASE$(FileOut$), ".") + "__.rc"
        Res_File$ = gTmpStr$

        OPEN resFile$ FOR INPUT  AS ResIn
        OPEN gTmpStr$   FOR OUTPUT AS ResOut

        FPRINT ResOut, "//  BCX Generated Resource File"
        FPRINT ResOut, "//  Date: ", DATE$, " Time: ", TIME$
        FPRINT ResOut, ""
        FPRINT ResOut, "#include <windows.h>"
        FPRINT ResOut, ""

        IF CombineRes THEN
            OPEN UserResFile$ FOR INPUT AS UserResIn
            FPRINT ResOut, "// User's *.rc file listing"
            FPRINT ResOut, ""
            DO WHILE NOT EOF(UserResIn)
                LINE INPUT UserResIn, Tmp$     ' Read from user's resource file
                IF INSTR(Tmp$, "windows.h", 1, 1) > 0 THEN
                    Tmp$ = ""
                END IF
                FPRINT ResOut, Tmp$           ' Write to final *.rc file
            LOOP
        END IF

        FPRINT ResOut, ""
        FPRINT ResOut, "// BCX generated *.rc file listing"
        FPRINT ResOut, ""

        DO WHILE NOT EOF(ResIn)
            LINE INPUT ResIn, Tmp$       ' Read from temp$
            IF INSTR(Tmp$, "include", 1, 1) > 0 THEN
                FPRINT ResOut, ""
            END IF
            FPRINT ResOut, Tmp$          ' Write to final *.rc file
        LOOP

        CLOSE ResOut, ResIn

        IF CombineRes THEN
            CLOSE UserResIn
        END IF

    END IF

    IF EXIST(resFile$) THEN
        KILL resFile$
    END IF
END SUB




SUB DoGoto(i AS INTEGER, iSend AS INTEGER)
    DIM STATIC LszTmp$
    sprintf(LoopType[i].szUseNeedLabel, "L%i:;", LoopType[i].iJumpTo)
    IF iSend THEN
        sprintf(LszTmp, "goto L%i;", LoopType[i].iJumpTo)
        FPRINT FP_WRITE, Scoot$, LszTmp$
    END IF
END SUB



FUNCTION Doaccelerator(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    Accelerator$ = REMOVE$(Stk$[2], DQ$)
    RETURN 0
END FUNCTION



FUNCTION Doasm(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    DIM LTmp$
    *iFLAG = 0

    CALL Emit_Optimize("none", "0", "  // No Optimizations in ASM block")

    DO
        IF EOF(SourceFile) THEN Abort ("Unbalanced $Asm")
        LINE INPUT SourceFile, Src$
        INCR LineNum[FileNdx]
        IF SrcFlag THEN
            FPRINT FP_WRITE, "// ", Src$
        END IF
        CALL StripTabs
        Src$ = TRIM$(Src$)

        DIM meta_asm_loop
        DIM meta_asm_comment_present AS BOOL
        DIM Src_Len AS INTEGER
        Src_Len = LEN(Src$)
        meta_asm_comment_present = FALSE

        FOR meta_asm_loop = 0 TO Src_Len
            '******************************************
            '   Extracts both the Basic Single Quote
            '   and the Assembly Semicolon
            '******************************************
            IF Src[meta_asm_loop] = c_SglQt OR Src[meta_asm_loop] = 59 THEN
                LTmp$ = RIGHT$(Src$, Src_Len - meta_asm_loop - 1)
                Src[meta_asm_loop] = 0
                meta_asm_comment_present = TRUE
                EXIT FOR
            END IF
        NEXT

        Src$ = TRIM$(Src$)
        IF iMatchLft(Src$, "$asm") THEN EXIT DO
        REPLACE "$" WITH "0x" IN Src$
        IREPLACE "&h" WITH "0x" IN Src$
        IF NOTNULL(Src$) THEN
            Src$ = "_asm(" + ENC$(Src$) + CHR$(1)
            IF meta_asm_comment_present THEN
                Src$ += TAB$ + "//" + LTmp$
            END IF
            SrcTmp$ = Src$
            FPRINT FP_WRITE, "#if !defined(__POCC__) && !defined (__cplusplus)"
            REPLACE CHR$(1) WITH ")" IN Src$
            FPRINT FP_WRITE, Src$
            FPRINT FP_WRITE, "#else"
            REPLACE "_asm(" WITH "__asm{" IN SrcTmp$
            REPLACE CHR$(1) WITH "}" IN SrcTmp$
            FPRINT FP_WRITE, REMOVE$(SrcTmp$, DQ$)
            FPRINT FP_WRITE, "#endif"
        END IF
    LOOP

    CALL Emit_Optimize("", "1", "  // Restoring Optimizer state")
    RETURN 0
END FUNCTION



FUNCTION Dobcx_resource(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    Use_GenResFile = TRUE

    DO
        IF EOF(SourceFile) THEN Abort ("Unbalanced $BCX_RESOURCE")
        LINE INPUT SourceFile, Src$
        INCR LineNum[FileNdx]
        CALL StripCode(Src$)
        IF iMatchLft(LTRIM$(Src$), "$bcx_r") THEN EXIT DO
        FPRINT FP_RES, Src$
    LOOP

    RETURN 0
END FUNCTION



FUNCTION Dobcxversion(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    Src$ = TRIM$(MID$(Src$, 12))
    REMOVE DQ$ FROM Src$
    IF LCASE$(VERSION$) < LCASE$(Src$) THEN
        Abort (CRLF$ + "Your Translator needs updating." + CRLF$ + _
        " This program " + ENC$(FileNames$[FileNdx])             + _
        " requires BCX Version: "  + Src$ + " or later." + CRLF$ + CRLF$)
    ELSE
        IF BCX_COLORS THEN COLOR 11, 0
        PRINT "Program requires BCX Version ", Src$, " or newer."
        IF BCX_COLORS THEN COLOR 10, 0
        PRINT "Detected BCX ", BCX_VERSION$, " [OKAY]"
    END IF
    RETURN 0
END FUNCTION




FUNCTION Doccode(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    DIM RAW FP_TMP AS FILE
    DIM RAW szWhere$
    *iFLAG = 0
    IF Ndx > 1 THEN
        szWhere$ = LCASE$(Stk$[2])
    ELSE
        szWhere$ = "default"
    END IF
    SELECT CASE szWhere$
        CASE "set"
        FP_TMP = FP_SET   ' Temp File FOR Storing GLOBAL SET Vars
        CASE "header"
        FP_TMP = FP_HDR   ' Temp File FOR Storing User's .H files
        CASE "const"
        FP_TMP = FP_CST   ' Temp File FOR Storing User's MACRO
        CASE "udt"
        FP_TMP = FP_UDT   ' Temp File FOR Storing User's Def Types
        CASE "enum"
        FP_TMP = FP_ENU   ' Temp File FOR Storing User's global enums
        CASE "funcsub"
        FP_TMP = FP_CCODE ' Temp File FOR Storing User's C code
        CASE ELSE
        IF InFunction THEN
            FP_TMP = FP3
        ELSE
            IF InClass OR InCppTypeDef OR InNameSpace THEN
                FP_TMP = FP_UDT  ' Temp File FOR Storing User's Def Types
            ELSE
                FP_TMP = FP2
            END IF
        END IF
    END SELECT

    DO
        IF EOF(SourceFile) THEN Abort ("Unbalanced $Ccode")
        LINE INPUT SourceFile, Src$
        INCR LineNum[FileNdx]
        CALL StripTabs
        IF iMatchLft(LTRIM$(Src$) , "$ccode") THEN
            IF SrcFlag THEN ' comments seem to interfere with C line continuations '\'
                FPRINT FP_TMP, "// [", TRIM$(FileNames$[FileNdx]), " - ", _
                TRIM$(STR$(LineNum[FileNdx])), "] End of $CCODE Block"
            END IF
            EXIT DO
        END IF
        FPRINT FP_TMP, RTRIM$(Src$)
    LOOP

    RETURN 0
END FUNCTION





FUNCTION Docom_op(szWord$, iFLAG AS PINT)
    *iFLAG = 0

    SELECT CASE szWord$

        CASE "$com_off"
        Use_COM = FALSE
        ComSwitchON = FALSE

        CASE "$com_on"
        Use_COM = Use_BcxTempStr = TRUE
        ComSwitchON = TRUE

        CASE "$com_trace"
        COM_build_trace_code = TRUE
        PRINT "COM trace code added to translated C file!"
        PRINT "Trace informations will be sent to file: c:\\com_trace.txt"

    END SELECT
    RETURN 0
END FUNCTION



FUNCTION Docomment(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    DIM STATIC TmpFile AS FILE
    IF IAm(InClass) OR IAm(InCppTypeDef) THEN
        TmpFile = FP_UDT
    ELSE
        TmpFile = FP_WRITE
    END IF
    DO
        IF EOF(SourceFile) THEN Abort ("Unbalanced $Comment")
        LINE INPUT SourceFile, Src$
        INCR LineNum[FileNdx]
        CALL StripTabs
        IF iMatchLft(LTRIM$(Src$), "$comment") THEN EXIT DO
        FPRINT TmpFile, "// ", Src$
    LOOP
    RETURN 0
END FUNCTION



FUNCTION Dofillstring (szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0

    DIM STATIC TheVariable$
    IREMOVE "$fill" FROM Src$
    Src$ = TRIM$(Src$)

    IF ISFALSE INCHR(Src$, "$") THEN                        ' It doesn't LOOK like a string, so make it easy on BCX
        IF ISFALSE INCHR(Src$, "[") THEN                    ' It looks like a one-dimensional string
            Src$ += "$"                                     ' ... so we'll append a dollar sign
        ELSE
            DIM RAW i = INCHR(Src$, "[")                    ' It is a member of a string array
            Src$ = MID$(Src$, 1, i-1) + "$" + MID$(Src$, i) ' ... so APPEND a $ sign TO its name
        END IF
    END IF

    Inject (Src$ + " = " + ENC$(""))                        ' 777 MrBcx -- Start with an empty variable
    TheVariable$ = Src$ + " = " + Src$ + " & "              ' This is what precedes the [string expressions]

    DO
        IF EOF(SourceFile) THEN Abort ("Unbalanced $FILL")
        LINE INPUT SourceFile, Src$
        INCR LineNum[FileNdx]
        CALL StripTabs
        Src$ = LTRIM$(Src$)
        IF LEFTSTR(Src$, "'") OR LEFTSTR(Src$, "rem", TRUE) THEN Src$ = ""
        IF LEFTSTR(Src$, "$fill", TRUE) THEN EXIT DO
        REPLACE BKSLASH2$ WITH BKSLASH4$ IN Src$            ' escape the \ character (like in RTF file data)
        REPLACE BKSLASH1$ WITH BKSLASH2$ IN Src$            '                      ditto
        IF NOTNULL(Src$) THEN Inject (TheVariable$ + Src$)  ' Inject each expression into BCX's translate stream
    LOOP
    Src$ = ""
    RETURN 0
END FUNCTION


FUNCTION DoWarningsOn(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    WarningFlag = TRUE
    RETURN 0
END FUNCTION


FUNCTION DoWarningsOff(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    WarningFlag = FALSE
    RETURN 0
END FUNCTION


FUNCTION DoZap(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    ZapFlag = TRUE
    RETURN 0
END FUNCTION


FUNCTION Docompiler(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    Src$ = REMAIN$(Src$, SPC$)
    Compiler$ = TRIM$(Src$)
    RETURN 0
END FUNCTION


FUNCTION DoBcxStrSize (szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    ' We change: #define BCXSTRSIZE 2048 in SUB Final_Transforms
    UserBcxStrSize$ = TRIM$(REMAIN$(Src$, SPC$))
    RETURN 0
END FUNCTION


FUNCTION Docpp(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    UNREFERENCED_PARAMETER(iFLAG)
    UseCpp = TRUE
    RETURN 0
END FUNCTION


FUNCTION Docpphdr(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    UseCpphdr = TRUE
    UseIO = TRUE
    RETURN 0
END FUNCTION


FUNCTION Docproto(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0

    FastLexer(Src$, SPC$, "!")

    IF iMatchWrd(Stk$[2], "!") THEN
        CALL AddProto(REMAIN$(Src$, "!"))
        ProtoType[ProtoCnt].Condition$ = ""
        ProtoType[ProtoCnt].CondLevel  = 0
    ELSE
        DIM RAW i = iMatchNQ(Src$, "function")
        IF i = 0 THEN
            i = iMatchNQ(Src$, "sub")
        END IF

        IF i THEN
            Src$ = "c_declare " + MID$(Src$, i)
        ELSE
            i = iMatchNQ(Src$, "$cproto")
            Src$ = "c_declare function " + MID$(Src$, i+7)
        END IF
        PassOne = TRUE

        CALL XParse(Src$)

        PassOne = FALSE
        UseCProto = TRUE
        *iFLAG = 2
    END IF
    RETURN *iFLAG
END FUNCTION




FUNCTION Dodefine(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    UNREFERENCED_PARAMETER(iFLAG)
    LOCAL Tmp$
    Tmp$ = "#define"
    FOR INT i = 2 TO Ndx
        Tmp$ += SPC$
        Tmp$ += Stk$[i]
        Stk$[i] = ""
    NEXT
    REPLACE " ) = "    WITH ") "       IN Tmp$  ' Important to remove this equals sign
    REPLACE " ( "      WITH " ("       IN Tmp$  ' Cosmetic
    REPLACE " , "      WITH ","        IN Tmp$  ' Cosmetic
    REPLACE " CONST "  WITH " const "  IN Tmp$  '************************************
    REPLACE " INT "    WITH " int "    IN Tmp$  ' Counteract helpful syntax editors
    REPLACE " LONG "   WITH " long "   IN Tmp$  ' This is obviously an incomplete list
    REPLACE " DOUBLE " WITH " double " IN Tmp$  ' but hopefully covers the common ones
    REPLACE " FLOAT "  WITH " float "  IN Tmp$  '************************************

    FPRINT FP_DEF, Tmp$                         ' Operation reduced to one disk-write
    Ndx = 0
    RETURN 0
END FUNCTION



FUNCTION Dodll(szWord$, iFLAG AS PINT)
    *iFLAG = 0
    SELECT CASE szWord$
        CASE "$dll"
        MakeDLL = TRUE
        Ndx = 0
        IF iMatchWrd(Stk$[2], "stdcall") THEN
            UseStdCall = TRUE
        END IF

        IF NoDllMain = FALSE THEN
            FPRINT FP_WRITE, ""
            FPRINT FP_WRITE, "__declspec(dllexport) BOOL WINAPI DllMain (HINSTANCE hInst, ULONG Reason, PVOID Reserved)"
            FPRINT FP_WRITE, "{"
            FPRINT FP_WRITE, "  switch (Reason)"
            FPRINT FP_WRITE, "  {"
            FPRINT FP_WRITE, "    case DLL_PROCESS_ATTACH:"
            FPRINT FP_WRITE, "      BCX_hInstance = hInst;"
            FPRINT FP_WRITE, "      break;"
            FPRINT FP_WRITE, "    case DLL_PROCESS_DETACH:"
            FPRINT FP_WRITE, "      break;"
            FPRINT FP_WRITE, "    case DLL_THREAD_ATTACH:"
            FPRINT FP_WRITE, "      break;"
            FPRINT FP_WRITE, "    case DLL_THREAD_DETACH:"
            FPRINT FP_WRITE, "      break;"
            FPRINT FP_WRITE, "   }"
            FPRINT FP_WRITE, " return TRUE;"
            FPRINT FP_WRITE, "}\n\n"
            CALL AddBCX_hInstance
        END IF

        CASE "$nodllmain"
        NoDllMain = TRUE
    END SELECT
    RETURN 0
END FUNCTION




FUNCTION Dofiletest(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    IF iMatchWrd(Stk$[2], "ON") THEN
        UseFileTest = TRUE
    ELSEIF iMatchWrd(Stk$[2], "OFF") THEN
        UseFileTest = FALSE
    ELSE
        Abort("Unrecognized argument '"+Stk$[2] + "' to $FILETEST")
    END IF
    RETURN 0
END FUNCTION



FUNCTION Dofsstatic(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    Use_Static = NOT Use_Static
    RETURN 0
END FUNCTION



FUNCTION Dogenfree(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    Use_GenFree = TRUE
    RETURN 0
END FUNCTION



FUNCTION Doheader(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    FPRINT FP_HDR, "// *************************************************\n"

    DO
        IF EOF(SourceFile) THEN Abort ("Unbalanced $Header")
        LINE INPUT SourceFile, Src$
        INCR LineNum[FileNdx]
        CALL StripTabs
        Src$ = TRIM$(Src$)
        IF iMatchLft(Src$, "$heade") THEN EXIT DO
        FPRINT FP_HDR, Src$
    LOOP

    FPRINT FP_HDR, ""
    RETURN 0
END FUNCTION



FUNCTION Dointerface(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    UseCpp = TRUE

    Src$ = REMAIN$(Src$, SPC$)
    FPRINT FP_UDT, "interface ", Src$, "\n  {"

    DO
        IF EOF(SourceFile) THEN
            CALL Abort ("$Interface Without $EndInterface")
        END IF

        LINE INPUT SourceFile, Src$
        INCR LineNum[FileNdx]
        IF iMatchLft(LTRIM$(Src$), "$endinterface") THEN
            Src$ = ""
            EXIT DO
        END IF
        FPRINT FP_UDT, Src$
    LOOP

    Src$ = REMAIN$(Src$, SPC$)
    Src$ = TRIM$(Src$)
    FPRINT FP_UDT, "  } ", Src$, ";"
    RETURN 0
END FUNCTION



FUNCTION Doiprint (szWord$, iFLAG AS PINT)
    *iFLAG = 0
    SELECT CASE szWord$

        CASE "$iprint_on"
        TranslateSlash = TRUE

        CASE "$iprint_off"
        TranslateSlash = FALSE

    END SELECT
    RETURN 0
END FUNCTION


FUNCTION DoCase_offon(szWord$, iFLAG AS PINT)
    *iFLAG = 0
    SELECT CASE szWord$

        CASE "$case_on"
        IgnoreStrCase = FALSE  ' Use strcmp (default)

        CASE "$case_off"
        IgnoreStrCase = TRUE   ' Use bcx_stricmp

    END SELECT
    RETURN 0
END FUNCTION



FUNCTION Doleanandmean(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    Use_LeanAndMean = TRUE
    RETURN 0
END FUNCTION



FUNCTION Doliberror(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    Use_BcxTempStr = Use_Date = Use_Time = Use_LoadLibraryError = TRUE

    IF *Stk$[2] <> c_DblQt THEN
        CALL Abort("$LIBERROR requires a string literal")
    END IF

    LibraryErrorLog$ = Stk$[2]
    RETURN 0
END FUNCTION



FUNCTION Dolibrary(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    REPLACE BKSLASH1$ WITH BKSLASH2$ IN Src$
    Src$ = IREMOVE$(Src$, "$library")
    Src$ = TRIM$(Src$)
    AddLibrary(Src$)
    RETURN 0
END FUNCTION



FUNCTION Dolinker(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    Src$ = REMAIN$(Src$, SPC$)
    Linker$ = Src$
    RETURN 0
END FUNCTION



FUNCTION Domultithread(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    Use_MULTITHREADED_SW = TRUE
    RETURN 0
END FUNCTION


FUNCTION DoNoBorland  (szWord$, iFLAG AS PINT)
    GLOBAL NO_BORLAND
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    NO_BORLAND = TRUE
    RETURN 0
END FUNCTION


FUNCTION DoNoGccClang (szWord$, iFLAG AS PINT)
    GLOBAL NO_GCCCLANG
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    NO_GCCCLANG = TRUE
    RETURN 0
END FUNCTION


FUNCTION DoNoLccwin(szWord$, iFLAG AS PINT)
    GLOBAL NO_LCCWIN
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    NO_LCCWIN = TRUE
    RETURN 0
END FUNCTION


FUNCTION DoNoLibs  (szWord$, iFLAG AS PINT)
    GLOBAL NO_LIBS
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    NO_LIBS = TRUE
    RETURN 0
END FUNCTION


FUNCTION DoNoMsvc  (szWord$, iFLAG AS PINT)
    GLOBAL NO_MSVC
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    NO_MSVC = TRUE
    RETURN 0
END FUNCTION


FUNCTION DoNoPelles(szWord$, iFLAG AS PINT)
    GLOBAL NO_PELLES
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    NO_PELLES = TRUE
    RETURN 0
END FUNCTION


FUNCTION DoNoVkkeys (szWord$, iFLAG AS PINT)
    GLOBAL NO_VKKEYS
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    NO_VKKEYS = TRUE
    RETURN 0
END FUNCTION


FUNCTION Donoini(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    TestForBcxIni = TRUE
    RETURN 0
END FUNCTION



FUNCTION Donoio(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    UseIO = FALSE
    RETURN 0
END FUNCTION



FUNCTION Doremovelib (szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    REPLACE BKSLASH1$ WITH BKSLASH2$ IN Src$
    Src$ = IREMOVE$(Src$, "$nolibrary")
    RemoveLibrary(Src$)
    RETURN 0
END FUNCTION



FUNCTION Donomain(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    NoMain = TRUE
    RETURN 0
END FUNCTION



FUNCTION Donowin(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    WinHeaders = FALSE
    RETURN 0
END FUNCTION



FUNCTION Doonentry(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    PassOne = TRUE
    CALL XParse(Src$)
    PassOne = FALSE
    INCR EntryCnt

    IF cMaxOnEntry = EntryCnt THEN
        CALL Abort("Maximum $OnEnty exceeded.")
    END IF

    Entry$[EntryCnt] = Stk$[2]
    RETURN 0
END FUNCTION


FUNCTION Doonexit(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    INCR XitCount

    IF cMaxOnExit = XitCount THEN
        CALL Abort("Maximum $OnExit exceeded.")
    END IF

    Xit$[XitCount]= Stk$[2]
    RETURN 0
END FUNCTION



FUNCTION Dooptimizer(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    DIM RAW szState$
    *iFLAG = 2
    szState$ = LCASE$(Stk$[2])
    Src$ = ""

    IF szState$ = "on" THEN
        IF OptimizerFirstSetting = TRUE THEN
            OptimizerFirstSetting = FALSE
            Src$ = "~pragmaoptimizeon"
            OptimizerEnabled = TRUE
        ELSE
            IF OptimizerEnabled = FALSE THEN
                OptimizerEnabled = TRUE
                Src$ = "~pragmaoptimizeon"
            END IF
        END IF

    ELSEIF szState$ = "off" THEN
        IF OptimizerFirstSetting = TRUE THEN
            OptimizerFirstSetting = FALSE
            Src$ = "~pragmaoptimizeoff"
            OptimizerEnabled = FALSE
        ELSE
            IF OptimizerEnabled = TRUE THEN
                OptimizerEnabled = FALSE
                Src$ = "~pragmaoptimizeoff"
            END IF
        END IF
    ELSE
        Abort("Error in $OPTIMIZER MetaStatement: " + Src$)
    END IF
    CALL XParse(Src$)
    RETURN 2
END FUNCTION


FUNCTION Dopack(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    DIM RAW iLoc = 2
    *iFLAG = 0
    FastLexer(Src$, "", "()")
    IF Stk$[iLoc] = "(" THEN INCR iLoc
    FPRINT FP_UDT, "#pragma pack (", Stk$[iLoc], ")"
    RETURN 0
END FUNCTION



FUNCTION Dopp(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    PPFlag = NOT PPFlag
    IF PPFlag THEN
        IF PPDLL_HANDLE = NULL THEN
            PPDLL_HANDLE = LOADLIBRARY("BCXPP.DLL")
            IF NOT PPDLL_HANDLE THEN ' failed to load preprocessor dll
                Abort ("Failed to Open BCX Preprocessor DLL!")
            ELSE
                PRINT "BCXPP.DLL Successfully Loaded"
            END IF
            '****************************************************************************
            ' This conditional mutes GCC's FARPROC/CPP_FARPROC warning.     - MrBcx 790
            ' It is completely safe and obviously supports a very specific purpose: $PP
            ' UPDATED 8.0.7 mostly unneeded now with current version of Mingw
            '****************************************************************************
            $IFDEF __GNUC__
                $PRAGMA GCC diagnostic ignored "-Wcast-function-type"
                PPProc = (CPP_FARPROC) GetProcAddress (PPDLL_HANDLE, "ProcessLine") ' Suppress CRLF
                $PRAGMA GCC diagnostic pop
            $ELSE
                $IFNDEF _MSC_VER
                $PRAGMA GCC diagnostic ignored "-Wcast-function-type"
            $ENDIF
            PPProc = (CPP_FARPROC) GetProcAddress (PPDLL_HANDLE, "ProcessLine") ' Suppress CRLF
        $ENDIF
        '****************************************************************************
        IF NOT PPProc THEN
            Abort ("'FUNCTION ProcessLine' missing in BCX Preprocessor DLL!")
        END IF
    END IF
END IF
RETURN 0
END FUNCTION




FUNCTION Doprj(szWord$, iFLAG AS PINT)
    *iFLAG = 0

    SELECT CASE szWord$
        CASE "$prj"
        Project$ = UCASE$(EXTRACT$(COMMAND$(1), ".")) + ".USE"
        HFile$   = UCASE$(EXTRACT$(COMMAND$(1), ".")) + ".H"
        Use_SingleFile = FALSE
        Use_BcxTempStr = TRUE

        CASE "$prjuse"
        Use_BcxTempStr = TRUE
        PreParse(Src$)
        CALL SetUsed

    END SELECT
    RETURN 0
END FUNCTION



FUNCTION Doproject(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    CALL EnableProject
    RETURN 0
END FUNCTION



FUNCTION Dorems(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    InsertComments = ~InsertComments
    Src$ = ""
    Ndx = 0
    RETURN 0
END FUNCTION



FUNCTION Doresource(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    Use_Resource = TRUE
    ResCompiler$ = Stk$[2]
    UserResFile$ = REMOVE$(Stk$[3], DQ$)
    RETURN 0
END FUNCTION



FUNCTION Dosource(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    SrcFlag = NOT SrcFlag
    RETURN 0
END FUNCTION



FUNCTION Dostdcall(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    UseStdCall = TRUE
    RETURN 0
END FUNCTION



FUNCTION Dotest(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    TestState = NOT TestState
    RETURN 0
END FUNCTION




FUNCTION Dotrace(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    TraceFlag = NOT TraceFlag
    RETURN 0
END FUNCTION



FUNCTION Dotypedef(szWord$, iFLAG AS PINT)
    UNREFERENCED_PARAMETER(szWord$)
    *iFLAG = 0
    FPRINT FP_UDT, ""
    IREPLACE "callback" WITH "CALLBACK" IN Src$
    FPRINT FP_UDT, "typedef ", REMAIN$(Src$, SPC$), ";"
    RETURN 0
END FUNCTION


FUNCTION IMAX (a, b) AS INTEGER
    IF a>b THEN
        RETURN a
    ELSE
        RETURN b
    END IF
END FUNCTION


FUNCTION IMIN (a, b) AS INTEGER
    IF a<b THEN
        RETURN a
    ELSE
        RETURN b
    END IF
END FUNCTION
'***********************************************************************************************
'                                         End of Directives
'                                     Begin Standard Prototypes
'***********************************************************************************************

SUB StdProtos(FP_OUTPUT AS FILE)
    IF Use_Project = FALSE THEN

        IF Use_BcxTempStr OR Use_Console OR Use_Proto THEN
            FPRINT FP_OUTPUT, ""
            FPRINT FP_OUTPUT, "// *************************************************"
            FPRINT FP_OUTPUT, "//               " + $BCX_STR_STD_PROTOS
            FPRINT FP_OUTPUT, "// *************************************************"
            FPRINT FP_OUTPUT, ""
        END IF

        IF Use_GUINoMain OR Use_MDIGUINoMain OR Use_Wingui THEN
            IF Use_BCX_FrameWnd THEN
                FPRINT FP_OUTPUT, "HWND    BCX_FrameWnd (LPCTSTR, WNDPROC, LPCTSTR, HMENU=NULL, int=0, int=CW_USEDEFAULT, int=CW_USEDEFAULT, int=CW_USEDEFAULT, int=CW_USEDEFAULT, int=0, int=0);"
            END IF

            IF Use_BCX_Wnd THEN
                FPRINT FP_OUTPUT, "HWND    BCX_Wnd (LPCTSTR, WNDPROC, LPCTSTR, HWND=0, int=CW_USEDEFAULT, int=CW_USEDEFAULT, int=CW_USEDEFAULT, int=CW_USEDEFAULT, int=0, int=0, int=0);"
            END IF

            IF Use_BCX_SetBkGrdBrush THEN
                FPRINT FP_OUTPUT, "void    BCX_SetBkGrdBrush (HWND, HBRUSH);"
            END IF

            IF Use_BCX_SetClassStyle THEN
                FPRINT FP_OUTPUT, "void    BCX_SetClassStyle (HWND, long);"
            END IF

            IF Use_BCX_SetIcon THEN
                FPRINT FP_OUTPUT, "void    BCX_SetIcon (HWND, int);"
            END IF

            IF Use_BCX_SetIconSm THEN
                FPRINT FP_OUTPUT, "void    BCX_SetIconSm (HWND, int);"
            END IF

            IF Use_BCX_SetCursor THEN
                FPRINT FP_OUTPUT, "void    BCX_SetCursor (HWND, LPCTSTR);"
            END IF

            IF Use_BCX_SetMetric THEN
                FPRINT FP_OUTPUT, "void    BCX_SetMetric (LPCTSTR);"
            END IF

            IF Use_GUINoMain THEN
                IF Use_BCX_MsgPump THEN
                    FPRINT FP_OUTPUT, "int     BCX_MsgPump (HACCEL=0);"
                END IF
            ELSEIF Use_MDIGUINoMain THEN
                IF Use_BCX_MDI_MsgPump THEN
                    FPRINT FP_OUTPUT, "int     BCX_MDI_MsgPump (HACCEL=0);"
                END IF
            END IF

            IF Use_BCX_RegWnd THEN
                FPRINT FP_OUTPUT, "void    BCX_RegWnd (LPCTSTR, WNDPROC);"
            END IF
            IF Use_BCX_InitGUI THEN
                FPRINT FP_OUTPUT, "void    BCX_InitGUI (void);"
            END IF
        END IF

        IF Use_Clng THEN
            FPRINT FP_OUTPUT, "long    CLNG (double);"
        END IF

        IF Use_Cint THEN
            FPRINT FP_OUTPUT, "int     Cint (double);"
        END IF

        IF Use_Tix THEN
            FPRINT FP_OUTPUT, "void    TIX_START(void);"
            FPRINT FP_OUTPUT, "double  TIX_NOW(void);"
        END IF

        IF Use_StartupCode THEN
            FPRINT FP_OUTPUT, "int     BCX_StartupCode_ (void);"
        END IF

        IF Use_ExitCode THEN
            FPRINT FP_OUTPUT, "int     BCX_ExitCode_ (void);"
        END IF

        IF Use_Eof THEN
            FPRINT FP_OUTPUT, "int     EoF (FILE*);"
        END IF

        IF Use_NamePathFromFP = TRUE THEN
            FPRINT FP_OUTPUT, "char*   NamePathFromFP (FILE*);"
        END IF

        IF Use_Longestline THEN
            FPRINT FP_OUTPUT, "UINT    LongestLine(LPCTSTR);"
        END IF

        IF Use_Nextlinelen THEN
            FPRINT FP_OUTPUT, "UINT    NextLineLen (FILE*);"
        END IF

        IF Use_AppActivate THEN
            FPRINT FP_OUTPUT, "int     AppActivate (LPCTSTR);"
        END IF

        IF Use_BoxCommon THEN
            FPRINT FP_OUTPUT, "LPWORD  lpwAlign (LPWORD);"
        END IF

        IF Use_Inputbox THEN
            FPRINT FP_OUTPUT, "char*   InputBox (LPCTSTR, LPCTSTR, LPCTSTR, int=0);"
            FPRINT FP_OUTPUT, "LRESULT CreatePrompter (LPCTSTR, LPCTSTR, LPCTSTR, int);"
            FPRINT FP_OUTPUT, "LRESULT CALLBACK Prompter (HWND, UINT, WPARAM, LPARAM);"
        END IF

        IF Use_VBS THEN
            FPRINT FP_OUTPUT, "HRESULT VBS_RUN_SCRIPT (LPCTSTR);"
            FPRINT FP_OUTPUT, "HRESULT VBS_ADDCODE    (LPCTSTR);"
            FPRINT FP_OUTPUT, "double  VBS_EVAL_NUM   (LPCTSTR);"
            FPRINT FP_OUTPUT, "char*   VBS_EVAL_STR   (LPCTSTR);"
            FPRINT FP_OUTPUT, "BOOL    VBS_START      (void);"
            FPRINT FP_OUTPUT, "void    VBS_STOP       (void);"
            FPRINT FP_OUTPUT, "void    VBS_RESET      (void);"
            FPRINT FP_OUTPUT, "char*   VBS_ERROR      (void);"
        END IF

        IF Use_Infobox THEN
            FPRINT FP_OUTPUT, "void    InfoBox (LPCTSTR, LPCTSTR, int=170, int=170);"
            FPRINT FP_OUTPUT, "LRESULT CALLBACK CB_InfoBox (HWND, UINT, WPARAM, LPARAM);"
        END IF

        IF Use_Mdigui THEN
            FPRINT FP_OUTPUT, "HWND    BCX_MDICHILD (LPCTSTR, LPCTSTR, int=CW_USEDEFAULT, int=CW_USEDEFAULT, int=CW_USEDEFAULT, int=CW_USEDEFAULT, ULONG=0, LPARAM=0);"
            FPRINT FP_OUTPUT, "void    BCX_MDICLASS (WNDPROC, PCHAR);"
            FPRINT FP_OUTPUT, "HWND    BCX_MDICLIENT (HWND, int);"
        END IF

        IF Use_BCX_Colordlg THEN
            FPRINT FP_OUTPUT, "int     BCX_ColorDlg (ULONG=RGB(128, 128, 128), HWND=0);"
        END IF

        IF Use_BCXMDialog THEN
            FPRINT FP_OUTPUT, "INT_PTR BCX_MDialog (DLGPROC, LPCTSTR, HWND, int=0, int=0, int=250, int=150, int=0, int=0, LPCTSTR=NULL, int=0);"
        END IF

        IF Use_BCXDialog THEN
            FPRINT FP_OUTPUT, "HWND    BCX_Dialog (DLGPROC, LPCTSTR, HWND, int=0, int=0, int=250, int=150, int=0, int=0, LPCTSTR=NULL, int=0);"
        END IF

        IF Use_BCXDialogCommon THEN
            FPRINT FP_OUTPUT, "void    SetDialogScale (HWND, BOOL);"
        END IF

        IF Use_SetDimension THEN
            FPRINT FP_OUTPUT, "void    SetDimension (LPCTSTR , int, HWND, BOOL=FALSE);"
        END IF

        IF Use_GetDimension THEN
            FPRINT FP_OUTPUT, "int     GetDimension (LPCTSTR ,HWND, BOOL=FALSE);"
        END IF

        IF Use_Form THEN
            FPRINT FP_OUTPUT, "HWND    BCX_Form (LPCTSTR, int=0, int=0, int=250, int=150, int=-1, int=0);"
        END IF

        IF Use_Setclientsize THEN
            FPRINT FP_OUTPUT, "void    BCX_SetClientSize (HWND, int, int, float=1.0f, float=1.0f);"
        END  IF

        IF Use_BCX_Get_Window_Width THEN
            FPRINT FP_OUTPUT, "int     BCX_Get_Window_Width (HWND);"
        END  IF

        IF Use_BCX_Get_Window_Height THEN
            FPRINT FP_OUTPUT, "int     BCX_Get_Window_Height (HWND);"
        END  IF

        IF Use_Edit THEN
            FPRINT FP_OUTPUT, "HWND    BCX_Edit (LPCTSTR, HWND, int, int, int, int, int, int=0, int=-1);"
        END IF

        IF Use_BCX_Input THEN
            FPRINT FP_OUTPUT, "HWND    BCX_Input (LPCTSTR, HWND, int, int, int, int, int, int=0, int=-1);"
        END IF

        IF Use_Button THEN
            FPRINT FP_OUTPUT, "HWND    BCX_Button (LPCTSTR, HWND, int=0, int=0, int=0, int=0, int=0, int=0, int=-1);"
        END IF

        IF Use_BmpButton THEN
            FPRINT FP_OUTPUT, "HWND    BCX_BmpButton (LPCTSTR, HWND, int=0, int=0, int=0, int=0, int=0, int=0, int=0, int=-1);"
        END IF

        IF Use_Label THEN
            FPRINT FP_OUTPUT, "HWND    BCX_Label (LPCTSTR, HWND, int=0, int=0, int=0, int=0, int=0, int=0, int=0);"
        END IF

        IF Use_Group THEN
            FPRINT FP_OUTPUT, "HWND    BCX_Group (LPCTSTR, HWND, int, int, int, int, int, int=0, int=0);"
        END IF

        IF Use_Checkbox THEN
            FPRINT FP_OUTPUT, "HWND    BCX_Checkbox (LPCTSTR, HWND, int=0, int=0, int=0, int=0, int=0, int=0, int=0);"
        END IF

        IF Use_Radio THEN
            FPRINT FP_OUTPUT, "HWND    BCX_Radio (LPCTSTR, HWND, int=0, int=0, int=0, int=0, int=0, int=0, int=0);"
        END IF

        IF Use_Combobox THEN
            FPRINT FP_OUTPUT, "HWND    BCX_Combobox (LPCTSTR, HWND, int, int, int, int, int, int=0, int=-1);"
        END IF

        IF Use_Listbox THEN
            FPRINT FP_OUTPUT, "HWND    BCX_Listbox (LPCTSTR, HWND, int, int, int, int, int, int=0, int=-1);"
        END IF

        IF Use_Blackrect THEN
            FPRINT FP_OUTPUT, "HWND    BCX_BlackRect (LPCTSTR, HWND, int, int, int, int, int, int=0, int=0);"
        END IF

        IF Use_Whiterect THEN
            FPRINT FP_OUTPUT, "HWND    BCX_WhiteRect (LPCTSTR, HWND, int, int, int, int, int, int=0, int=0);"
        END IF

        IF Use_Grayrect THEN
            FPRINT FP_OUTPUT, "HWND    BCX_GrayRect (LPCTSTR, HWND, int, int, int, int, int, int=0, int=0);"
        END IF

        IF Use_Datepick THEN
            FPRINT FP_OUTPUT, "HWND    BCX_DatePick (LPCTSTR, HWND, int, int, int, int, int, int=0, int=-1);"
        END IF

        IF Use_Richedit THEN
            FPRINT FP_OUTPUT, "HWND    BCX_RichEdit (LPCTSTR, HWND, int, int, int, int, int, int=0, int=-1);"
            FPRINT FP_OUTPUT, "void    SetWindowRTFText (HWND, LPCTSTR);"
        END IF

        IF Use_Status THEN
            FPRINT FP_OUTPUT, "HWND    BCX_Status (LPCTSTR, HWND, int=200, int=1, PINT=NULL);"
        END IF

        IF Use_BCX_OlePicture THEN
            FPRINT FP_OUTPUT, "HWND    BCX_OlePicture (LPCTSTR, HWND=0, int=0, int=0, int=0, int=0, int=0, int=0, int=0, int=0);"
        END IF

        IF Use_Bitmap THEN
            FPRINT FP_OUTPUT, "HWND    BCX_Bitmap (LPCTSTR, HWND=0, int=0, int=0, int=0, int=0, int=0, int=0, int=0, int=0);"
        END IF

        IF Use_Icon THEN
            FPRINT FP_OUTPUT, "HWND    BCX_Icon (LPCTSTR, HWND=0, int=0, int=0, int=0, int=0, int=0, int=0, int=0, int=0);"
        END IF

        IF Use_Listview THEN
            FPRINT FP_OUTPUT, "HWND    BCX_ListView (LPCTSTR, HWND, int, int, int, int, int, int=0, int=-1, int=15);"
        END IF

        IF Use_Treeview THEN
            FPRINT FP_OUTPUT, "HWND    BCX_Treeview (LPCTSTR, HWND, int, int, int, int, int, int=0, int=-1);"
        END IF

        IF Use_BCX_Control THEN
            FPRINT FP_OUTPUT, "HWND    BCX_Control (LPCTSTR, HWND, LPCTSTR, int, int, int, int, int, int=0, int=0);"
        END IF

        IF Use_ProgressBar THEN
            FPRINT FP_OUTPUT, "HWND    BCX_ProgressBar (LPCTSTR, HWND, int=0, int=0, int=0, int=0, int=0, int=0, int=-1);"
        END IF

        IF Use_BCX_Slider THEN
            FPRINT FP_OUTPUT, "HWND    BCX_Slider (LPCTSTR, HWND, int, int, int, int, int, int=0, int=0, int=0);"
        END IF

        IF Use_BCX_Splitter THEN
            FPRINT FP_OUTPUT, "void    DrawXorBar (HWND, RECT *);"
            FPRINT FP_OUTPUT, "int     BCX_SetSplitPos (HWND, int=50, int=0);"
            FPRINT FP_OUTPUT, "LRESULT CALLBACK SplitterWndProc (HWND, UINT, WPARAM, LPARAM);"
            FPRINT FP_OUTPUT, "HWND    BCX_Splitter (HWND, int, int=0, int=0, int=0, int=0, int=0, int=0);"
        END IF

        IF Use_BCX_Toolbar THEN
            FPRINT FP_OUTPUT, "HWND    BCX_Toolbar (HWND, int, int, LPCTSTR=NULL, PINT=NULL, PVOID=NULL, PINT=NULL, int=0, int=0, int=0, int=0);"
        END IF

        IF Use_BCX_Tab THEN
            FPRINT FP_OUTPUT, "HWND    BCX_Tab (HWND, int, int, HWND *, char[][BCXSTRSIZE], int, int, int, int, HIMAGELIST=NULL, int=0, int=0);"
            FPRINT FP_OUTPUT, "HWND    BCX_AddTab (HWND, int, LPCTSTR, int=-1, int=0);"
            FPRINT FP_OUTPUT, "void    BCX_RemTab (HWND, int);"
            FPRINT FP_OUTPUT, "int     BCX_TabSelect (HWND, LPARAM);"
            FPRINT FP_OUTPUT, "LRESULT CALLBACK TabPageWndProc (HWND, UINT, WPARAM, LPARAM);"
            FPRINT FP_OUTPUT, "LRESULT CALLBACK TabCallback (HWND, UINT, WPARAM, LPARAM);"
            FPRINT FP_OUTPUT, "LRESULT CALLBACK TabSizeCallback (HWND, UINT, WPARAM, LPARAM);"
        END IF

        IF Use_Draw THEN
            FPRINT FP_OUTPUT, "HDC     StartDraw (HWND);"
            FPRINT FP_OUTPUT, "HBITMAP EndDraw (HWND, HDC);"
        END IF

        IF Use_BCX_UpDown THEN
            FPRINT FP_OUTPUT, "HWND    BCX_UpDown (HWND, int, int, int, int, int, int, int=0);"
        END IF

        IF Use_BCX_Get_UpDown THEN
            FPRINT FP_OUTPUT, "int     BCX_Get_UpDown (HWND);"
        END IF

        IF Use_BCX_Print THEN
            FPRINT FP_OUTPUT, "int     BCX_Print (HWND, int, int, LPCTSTR, HDC=NULL);"
        END IF

        IF Use_BCX_Printex THEN
            FPRINT FP_OUTPUT, "void    BCX_Printex (HWND, long, long, char*, long, long, char*, long, HDC=NULL);"
        END IF

        IF Use_SetFormColor THEN
            FPRINT FP_OUTPUT, "void    BCX_Set_Form_Color (HWND, ULONG);"
        END IF

        IF Use_BCX_Tile THEN
            FPRINT FP_OUTPUT, "void    BCX_Tile (HWND, HBITMAP);"
        END IF

        IF Use_GetText THEN
            FPRINT FP_OUTPUT, "char*   BCX_Get_Text (HWND);"
        END IF

        IF Use_GetResource THEN
            FPRINT FP_OUTPUT, "PVOID   GetResource (int, char*, ULONG*);"
        END IF

        IF Use_SetText THEN
            FPRINT FP_OUTPUT, "int     BCX_Set_Text (HWND, LPCTSTR);"
        END IF

        IF Use_Elf THEN
            FPRINT FP_OUTPUT, "void    EditLoadFile (HWND, LPCTSTR);"
        END IF

        IF Use_ListBoxLoadFile THEN
            FPRINT FP_OUTPUT, "void    ListBoxLoadFile (HWND, LPCTSTR, int=0, int=0);"
        END IF

        IF Use_ComboBoxLoadFile THEN
            FPRINT FP_OUTPUT, "void    ComboBoxLoadFile (HWND, LPCTSTR);"
        END IF

        IF Use_SetFont THEN
            FPRINT FP_OUTPUT, "HFONT   BCX_Set_Font (LPCTSTR, float, int=0, int=0, int=0, int=0, int=0, int=0);"
        END IF

        IF Use_BCX_Preset THEN
            FPRINT FP_OUTPUT, "int     BCX_Preset (HWND, int, int, HDC=NULL);"
        END IF

        IF Use_BCX_Line THEN
            FPRINT FP_OUTPUT, "int     BCX_Line (HWND, int, int, int, int, int=0, HDC=NULL);"
        END IF

        IF Use_BCX_Polar_Line THEN
            FPRINT FP_OUTPUT, "void    BCX_Polar_Line(HWND, int, int, float, float, ULONG, HDC=NULL);"
        END IF

        IF Use_BCX_Lineto THEN
            FPRINT FP_OUTPUT, "int     BCX_Lineto (HWND, int, int, int=0, HDC=NULL);"
        END IF

        IF Use_BCX_Triangle THEN
            FPRINT FP_OUTPUT, "int     BCX_Triangle(HWND, LONG, LONG, LONG, LONG, LONG, LONG, DWORD, LONG, HDC=NULL);"
        END IF

        IF Use_BCX_Gradient THEN
            FPRINT FP_OUTPUT, "void    BCX_Gradient(HWND, ULONG, ULONG, int, HDC=NULL);"
        END IF

        IF Use_BCX_Polygon THEN
            FPRINT FP_OUTPUT, "int     BCX_Polygon (HWND, const POINT *, int, int=0, HDC=NULL);"
        END IF

        IF Use_BCX_PolyBezier THEN
            FPRINT FP_OUTPUT, "int     BCX_PolyBezier (HWND, const POINT *, int, int=0, HDC=NULL);"
        END IF

        IF Use_BCX_Polyline THEN
            FPRINT FP_OUTPUT, "int     BCX_Polyline (HWND, const POINT*, int, int=0, HDC=NULL);"
        END IF

        IF Use_BCX_Circle THEN
            FPRINT FP_OUTPUT, "int     BCX_Circle (HWND, int, int, int, int=0, int=0, HDC=NULL);"
        END IF

        IF Use_BCX_Ellipse THEN
            FPRINT FP_OUTPUT, "int     BCX_Ellipse (HWND, int, int, int, int, int=0, int=0, HDC=NULL);"
        END IF

        IF Use_BCX_Rectangle THEN
            FPRINT FP_OUTPUT, "int     BCX_Rectangle (HWND, int, int, int, int, int=0, int=0, HDC=NULL);"
        END IF

        IF Use_BCX_Roundrect THEN
            FPRINT FP_OUTPUT, "int     BCX_Roundrect(HWND, int, int, int, int, int, int, int=0, int=0, HDC=NULL);"
        END IF

        IF Use_BCX_Arc THEN
            FPRINT FP_OUTPUT, "int     BCX_Arc (HWND, int, int, int, int, int, int, int, int, int=0, HDC=NULL);"
        END IF

        IF Use_BCX_Pie THEN
            FPRINT FP_OUTPUT, "int     BCX_Pie(HWND, int, int, int, int, int, int, int, int, int=0, int=0, HDC=NULL);"
        END IF

        IF Use_Set_BCX_Bitmap THEN
            FPRINT FP_OUTPUT, "void    Set_BCX_Bitmap (HWND, LPCTSTR, int=0, int=0, int=0);"
        END IF

        IF Use_Set_BCX_Bitmap2 THEN
            FPRINT FP_OUTPUT, "HBITMAP Set_BCX_Bitmap2 (HWND, HBITMAP, int=1);"
        END IF

        IF Use_Newbmp THEN
            FPRINT FP_OUTPUT, "HBITMAP NewBmp (void);"
        END IF

        IF Use_Makebmp THEN
            FPRINT FP_OUTPUT, "HBITMAP MakeBmp (HDC);"
        END IF

        IF Use_Makehdc THEN
            FPRINT FP_OUTPUT, "HDC     MakeHdc (HBITMAP);"
        END IF

        IF Use_Set_BCX_BmpButton THEN
            FPRINT FP_OUTPUT, "void    Set_BCX_BmpButton (HWND, LPCTSTR, int=0);"
        END IF

        IF Use_Set_BCX_Icon THEN
            FPRINT FP_OUTPUT, "void    Set_BCX_Icon (HWND, LPCTSTR, int=0, int=0, int=0);"
        END IF

        IF Use_BCX_Fontdlg THEN
            FPRINT FP_OUTPUT, "int     BCX_FontDlg (BOOL=0, HWND=0);"
        END IF

        IF Use_BCX_Blit THEN
            FPRINT FP_OUTPUT, "void    BCX_Blit (HBITMAP,HDC);"
        END IF

        IF Use_BCX_Blit_Stretch THEN
            FPRINT FP_OUTPUT, "void    BCX_Blit_Stretch (HBITMAP,HDC);"
        END IF

        IF Use_BCX_Blit_Sprite THEN
            FPRINT FP_OUTPUT, "void    BCX_Blit_Sprite (HBITMAP, int, int, ULONG, HDC);"
        END IF

        IF Use_BCX_Buffer THEN
            FPRINT FP_OUTPUT, "void    BCX_BUFFER_START (int, int);"
            FPRINT FP_OUTPUT, "void    BCX_BUFFER_STOP  (HWND);"
        END IF

        IF Use_BCX_Pset THEN
            FPRINT FP_OUTPUT, "int     BCX_Pset (HWND, int, int, int=0, HDC=NULL);"
        END IF

        IF Use_BCX_Polar_Pset THEN
            FPRINT FP_OUTPUT, "void    BCX_Polar_Pset(HWND, int, int, float, float, ULONG, HDC=NULL);"
        END IF

        IF Use_BCX_Floodfill THEN
            FPRINT FP_OUTPUT, "int     BCX_FloodFill (HWND, int, int, int, int, int=0, HDC=NULL);"
        END IF

        IF Use_BCX_Getpixel THEN
            FPRINT FP_OUTPUT, "ULONG   BCX_Getpixel (HWND, int, int, HDC=NULL);"
        END IF

        IF Use_BCX_Get THEN
            FPRINT FP_OUTPUT, "HBITMAP BCX_Get (HWND, int, int, int, int, int=SRCCOPY, HDC=NULL);"
        END IF

        IF Use_BCX_Put THEN
            FPRINT FP_OUTPUT, "void    BCX_Put (HWND, HBITMAP, int, int, int, int, int=SRCCOPY, HDC=NULL);"
        END IF

        IF Use_BCX_LoadBMP THEN
            FPRINT FP_OUTPUT, "HBITMAP BCX_LoadBMP (LPCTSTR, int=0, int=0);"
        END IF

        IF Use_BCX_LoadImage THEN
            FPRINT FP_OUTPUT, "HBITMAP BCX_LoadImage (LPCTSTR, int=0);"
        END IF

        IF Use_DrawTransBMP THEN
            FPRINT FP_OUTPUT, "void    DrawTransBMP (HWND, HBITMAP, ULONG, int, int, HDC=NULL);"
        END IF

        IF Use_DrawStr THEN
            FPRINT FP_OUTPUT, "void    Draw(char* DrawString);"
        END IF

        IF Use_BCX_BmpWidth THEN
            FPRINT FP_OUTPUT, "int     BCX_BmpWidth (HBITMAP);"
        END IF

        IF Use_BCX_ToolTip THEN
            FPRINT FP_OUTPUT, "LRESULT BCX_ToolTip (LPCTSTR, HWND, int=0);"
            FPRINT FP_OUTPUT, "HWND    BCX_CreateToolTip (HWND, int);"
        END IF

        IF Use_BCX_BmpHeight THEN
            FPRINT FP_OUTPUT, "int     BCX_BmpHeight (HBITMAP);"
        END IF

        IF Use_QBColor THEN
            FPRINT FP_OUTPUT, "ULONG   qbcolor (int);"
        END IF

        IF Use_SetColor THEN
            FPRINT FP_OUTPUT, "LRESULT Set_Color (int, int, HDC, HWND);"
        END IF

        IF Use_PlayWav THEN
            FPRINT FP_OUTPUT, "void    PlayWav (LPCTSTR, int=0,  int=SND_SYNC);"
        END IF

        IF Use_SaveBmp THEN
            FPRINT FP_OUTPUT, "void    SaveBmp (PVOID, LPTSTR);"
        END IF

        IF Use_GetBmp THEN
            FPRINT FP_OUTPUT, "HDC     GetBmp (int, int, int, int, HWND);"
        END IF

        IF Use_Center THEN
            FPRINT FP_OUTPUT, "void    Center (HWND, HWND=0, HWND=0);"
        END IF

        IF Use_Cls THEN
            FPRINT FP_OUTPUT, "void    cls (void);"
        END IF

        IF Use_Color THEN
            FPRINT FP_OUTPUT, "void    color (int, int=0);"
        END IF

        IF Use_PushPopColors THEN
            FPRINT FP_OUTPUT, "void    PushColors (void);"
            FPRINT FP_OUTPUT, "void    PopColors  (void);"
        END IF

        IF Use_Consolesize THEN
            FPRINT FP_OUTPUT, "void    BCX_SetConsoleSize  (int= 80,int= 25);"
            FPRINT FP_OUTPUT, "void    BCX_PushConsoleSize (void);"
            FPRINT FP_OUTPUT, "void    BCX_PopConsoleSize  (void);"
        END IF

        IF Use_Panel THEN
            FPRINT FP_OUTPUT, "void    panel (int, int, int, int, int, int, int, int);"
        END IF

        IF Use_Locate THEN
            FPRINT FP_OUTPUT, "void    locate (int, int, int=1, int=12);"
        END IF

        IF Use_Pos THEN
            FPRINT FP_OUTPUT, "int     Pos (void);"
        END IF

        IF Use_Csrlin THEN
            FPRINT FP_OUTPUT, "int     Csrlin (void);"
        END IF

        IF Use_Run THEN
            FPRINT FP_OUTPUT, "int     Run (LPCTSTR, int=1, int=0);"
        END IF

        IF Use_Doevents THEN
            FPRINT FP_OUTPUT, "void    DoEvents (void);"
        END IF

        IF Use_Randomize THEN
            FPRINT FP_OUTPUT, "void    randomize (unsigned int);"
        END IF

        IF Use_Midstr THEN
            FPRINT FP_OUTPUT, "void    midstr (char*, int, int, char *);"
        END IF

        IF Use_Swap THEN
            FPRINT FP_OUTPUT, "void    swap (byte*, byte*, int);"
        END IF

        IF Use_BcxTempStr THEN
            FPRINT FP_OUTPUT, "char*   BCX_TempStr (size_t);"
        END IF

        IF Use_sziif THEN
            FPRINT FP_OUTPUT, "char*   sziif (int, LPCTSTR, LPCTSTR);"
        END IF

        IF Use_Using THEN
            FPRINT FP_OUTPUT, "char*   Using (LPCTSTR, long double);"
        END IF

        IF Use_TempFileName THEN
            FPRINT FP_OUTPUT, "char*   TempFileName (LPCTSTR, LPCTSTR);"
        END IF

        IF Use_AppExePath THEN
            FPRINT FP_OUTPUT, "char*   AppExePath (void);"
        END IF

        IF Use_AppExeName THEN
            FPRINT FP_OUTPUT, "char*   AppExeName (void);"
        END IF

        IF Use_Chr THEN                                 ' MrBcx 812 increase to (26)
            FPRINT FP_OUTPUT, "char*   chr (unsigned char,  unsigned char=0,unsigned char=0,unsigned char=0,"
            FPRINT FP_OUTPUT, "             unsigned char=0,unsigned char=0,unsigned char=0,unsigned char=0,"
            FPRINT FP_OUTPUT, "             unsigned char=0,unsigned char=0,unsigned char=0,unsigned char=0,"
            FPRINT FP_OUTPUT, "             unsigned char=0,unsigned char=0,unsigned char=0,unsigned char=0,"
            FPRINT FP_OUTPUT, "             unsigned char=0,unsigned char=0,unsigned char=0,unsigned char=0,"
            FPRINT FP_OUTPUT, "             unsigned char=0,unsigned char=0,unsigned char=0,unsigned char=0,"
            FPRINT FP_OUTPUT, "             unsigned char=0,unsigned char=0);"
        END IF

        IF Use_VChr THEN
            FPRINT FP_OUTPUT, "char*   vchr (int,...);"
        END IF

        IF Use_Lcase THEN
            FPRINT FP_OUTPUT, "char*   lcase (LPCTSTR);"
        END IF

        IF Use_Ucase THEN
            FPRINT FP_OUTPUT, "char*   ucase (LPCTSTR);"
        END IF

        IF Use_Mid THEN
            FPRINT FP_OUTPUT, "char*   mid (LPCTSTR, int, int=-1);"
        END IF

        IF Use_Ltrim THEN
            FPRINT FP_OUTPUT, "char*   ltrim (LPCTSTR, char=32);"
        END IF

        IF Use_Rtrim THEN
            FPRINT FP_OUTPUT, "char*   rtrim (LPCTSTR, char=32);"
        END IF

        IF Use_Trim THEN
            FPRINT FP_OUTPUT, "char*   trim (LPCTSTR);"
        END IF

        IF Use_Strim THEN
            FPRINT FP_OUTPUT, "char*   strim (LPCTSTR);"
        END IF

        IF Use_Left THEN
            FPRINT FP_OUTPUT, "char*   left (LPCTSTR, int);"
        END IF

        IF Use_Right THEN
            FPRINT FP_OUTPUT, "char*   right (LPCTSTR, int);"
        END IF

        IF Use_Cpad THEN
            FPRINT FP_OUTPUT, "char*   cpad (LPCTSTR, int, int=32);"
        END IF

        IF Use_Rpad THEN
            FPRINT FP_OUTPUT, "char*   rpad (LPCTSTR, int, int=32);"
        END IF

        IF Use_Lpad THEN
            FPRINT FP_OUTPUT, "char*   lpad (LPCTSTR, int, int=32);"
        END IF

        IF Use_String THEN
            FPRINT FP_OUTPUT, "char*   stringx (int, int);"
        END IF

        IF Use_Repeat THEN
            FPRINT FP_OUTPUT, "char*   repeat (int, LPCTSTR);"
        END IF

        IF Use_Extract THEN
            FPRINT FP_OUTPUT, "char*   extract (LPCTSTR, LPCTSTR);"
        END IF

        IF Use_ExtractAny THEN
            FPRINT FP_OUTPUT, "char*   extractany (LPCTSTR, LPCTSTR);"
        END IF

        IF Use_Remain THEN
            FPRINT FP_OUTPUT, "char*   remain (LPCTSTR, LPCTSTR);"
        END IF

        IF Use_Reverse THEN
            FPRINT FP_OUTPUT, "char*   reverse (LPCTSTR);"
        END IF

        IF Use_Command THEN
            FPRINT FP_OUTPUT, "char*   command (int=-1);"
        END IF

        IF Use_Mcase THEN
            FPRINT FP_OUTPUT, "char*   mcase (LPCTSTR);"
        END IF

        IF Use_Replace THEN
            FPRINT FP_OUTPUT, "char*   replace (LPCTSTR, LPCTSTR, LPCTSTR);"
        END IF

        IF Use_iReplace THEN
            FPRINT FP_OUTPUT, "char*   iReplace (LPCTSTR, LPCTSTR, LPCTSTR);"
        END IF

        IF Use_ReplaceAny THEN
            FPRINT FP_OUTPUT, "char*   ReplaceAny (LPCTSTR, LPCTSTR, LPCTSTR);"
        END IF

        IF Use_IReplaceAny THEN
            FPRINT FP_OUTPUT, "char*   IReplaceAny (LPCTSTR, LPCTSTR, LPCTSTR);"
        END IF


        IF Use_RemoveAny THEN
            FPRINT FP_OUTPUT, "char*   RemoveAny (LPCTSTR, LPCTSTR);"
        END IF

        IF Use_IRemoveAny THEN
            FPRINT FP_OUTPUT, "char*   IRemoveAny (LPCTSTR, LPCTSTR);"
        END IF

        IF Use_Sleep THEN
            FPRINT FP_OUTPUT, "void     BCX_Sleep (int);"
        END IF

        IF Use_Space THEN
            FPRINT FP_OUTPUT, "char*   space (int a);"
        END IF

        IF Use_Str THEN
            FPRINT FP_OUTPUT, "char*   str (double, int=0);"
        END IF

        IF Use_Strl THEN
            FPRINT FP_OUTPUT, "char*   strl (long double, int=0);"
        END IF

        IF Use_RegString THEN
            FPRINT FP_OUTPUT, "char*   RegString (HKEY, LPCTSTR, LPCTSTR);"
        END IF

        IF Use_CreateRegString THEN
            FPRINT FP_OUTPUT, "void    CreateRegString (HKEY, LPCTSTR, LPCTSTR, LPCTSTR);"
        END IF

        IF Use_DeleteRegKey THEN
            FPRINT FP_OUTPUT, "void    DeleteRegKey (HKEY, LPCTSTR);"
        END IF

        IF Use_CreateRegInt THEN
            FPRINT FP_OUTPUT, "void    CreateRegInt (HKEY, LPCTSTR, LPCTSTR, int);"
        END IF
        IF Use_Mkpath THEN
            FPRINT FP_OUTPUT, "void    MkPath (LPCTSTR);"
        END IF

        IF Use_Findfirst THEN
            FPRINT FP_OUTPUT, "char*   findfirst (LPCTSTR);"
        END IF

        IF Use_Findnext THEN
            FPRINT FP_OUTPUT, "char*   findnext (void);"
        END IF

        IF Use_Lookahead THEN
            FPRINT FP_OUTPUT, "char*   LookAhead (FILE*, int=1);"
        END IF

        IF Use_Issystem THEN
            FPRINT FP_OUTPUT, "int     issystem (LPCTSTR);"
        END IF

        IF Use_Ishidden THEN
            FPRINT FP_OUTPUT, "int     ishidden (LPCTSTR);"
        END IF

        IF Use_Isreadonly THEN
            FPRINT FP_OUTPUT, "int     isreadonly (LPCTSTR);"
        END IF

        IF Use_Isfile THEN
            FPRINT FP_OUTPUT, "int     isfile (LPCTSTR);"
        END IF

        IF Use_Isfolder THEN
            FPRINT FP_OUTPUT, "int     isfolder (LPCTSTR);"
        END IF
        IF Use_Curdir THEN
            FPRINT FP_OUTPUT, "char*   curdir (void);"
        END IF

        IF Use_Windir THEN
            FPRINT FP_OUTPUT, "char*   windir (void);"
        END IF

        IF Use_GetSpecialFolder THEN
            FPRINT FP_OUTPUT, "char*   GetSpecialFolder (int, int=0, HWND=NULL);"
        END IF

        IF Use_GetSpecialFolderex THEN
            FPRINT FP_OUTPUT, "char*   GetSpecialFolderEx (const GUID, ULONG=0);"
        END IF

        IF Use_Sysdir THEN
            FPRINT FP_OUTPUT, "char*   sysdir (void);"
        END IF

        IF Use_Tempdir THEN
            FPRINT FP_OUTPUT, "char*   tempdir (void);"
        END IF

        IF Use_Environ THEN
            FPRINT FP_OUTPUT, "char*   Environ (LPCTSTR);"
        END IF

        IF Use_Boolstr THEN
            FPRINT FP_OUTPUT, "char*   BoolStr (int);"
        END IF

        IF Use_Hex THEN
            FPRINT FP_OUTPUT, "char*   hex(uint64_t, int=0);"
        END IF

        IF Use_Bin THEN
            FPRINT FP_OUTPUT, "char*   Bin (int);"
        END IF

        IF Use_Oct THEN
            FPRINT FP_OUTPUT, "char*   oct (int);"
        END IF

        IF Use_Date THEN
            FPRINT FP_OUTPUT, "char*   date (int=0);"
        END IF

        IF Use_IsoDate THEN
            FPRINT FP_OUTPUT, "char*   isodate (int=0);"
        END IF

        IF Use_Mouse_sx THEN
            FPRINT FP_OUTPUT, "int     MOUSEX_SCREEN (void);"
            FPRINT FP_OUTPUT, "#define MOUSE_SX MOUSEX_SCREEN()"
        END IF

        IF Use_Mouse_sy THEN
            FPRINT FP_OUTPUT, "int     MOUSEY_SCREEN (void);"
            FPRINT FP_OUTPUT, "#define MOUSE_SY MOUSEY_SCREEN()"
        END IF

        IF Use_Mouse_cx THEN
            FPRINT FP_OUTPUT, "int     MOUSEX_CLIENT (void);"
            FPRINT FP_OUTPUT, "#define MOUSE_CX MOUSEX_CLIENT()"
        END IF

        IF Use_Mouse_cy THEN
            FPRINT FP_OUTPUT, "int     MOUSEY_CLIENT (void);"
            FPRINT FP_OUTPUT, "#define MOUSE_CY MOUSEY_CLIENT()"
        END IF

        IF Use_Now THEN
            FPRINT FP_OUTPUT, "char*   now (int=0);"
        END IF

        IF Use_SearchPath THEN
            FPRINT FP_OUTPUT, "char*   SEARCHPATH (LPCTSTR);"
        END IF

        IF Use_BcxSplitPath THEN
            FPRINT FP_OUTPUT, "char*   BcxSplitPath (LPCTSTR, int);"
        END IF

        IF Use_BCX_Path THEN
            FPRINT FP_OUTPUT, "char*   BcxPath (void);"
        END IF

        IF Use_LccPath THEN
            FPRINT FP_OUTPUT, "char*   LccPath (void);"
        END IF

        IF Use_PellesPath THEN
            FPRINT FP_OUTPUT, "char*   PellesPath (void);"
        END IF

        IF Use_Strtoken THEN
            FPRINT FP_OUTPUT, "char*   StrToken (LPCTSTR, LPCTSTR, int);"
        END IF

        IF Use_RegExist THEN
            FPRINT FP_OUTPUT, "long    RegExist (HKEY, PCHAR, PCHAR);"
        END IF

        IF Use_RegInt THEN
            FPRINT FP_OUTPUT, "int     RegInt (HKEY, LPCTSTR, LPCTSTR);"
        END IF

        IF Use_FileLocked THEN
            FPRINT FP_OUTPUT, "int     FileLocked (LPCTSTR);"
        END IF

        IF Use_Bff THEN
            FPRINT FP_OUTPUT, "char*   BFF (LPCTSTR, int=0, LPCTSTR=NULL);"
            FPRINT FP_OUTPUT, "int     CALLBACK BFFCallBack (HWND,  UINT,  LPARAM,  LPARAM);"
        END IF

        IF Use_FillArray THEN
            FPRINT FP_OUTPUT, "int     fillarray (LPCTSTR, int, int, void *);"
        END IF

        IF Use_Lclick THEN
            FPRINT FP_OUTPUT, "int     lClick (void);"
        END IF

        IF Use_Rclick THEN
            FPRINT FP_OUTPUT, "int     rClick (void);"
        END IF

        IF Use_Remove THEN
            FPRINT FP_OUTPUT, "char*   RemoveStr (LPCTSTR, LPCTSTR);"
        END IF

        IF Use_IRemove THEN
            FPRINT FP_OUTPUT, "char*   IRemoveStr (LPCTSTR, LPCTSTR);"
        END IF

        IF Use_Hook THEN
            FPRINT FP_OUTPUT, "LRESULT CALLBACK SBProc (int, WPARAM, LPARAM);"
        END IF

        IF Use_Getfilename THEN
            FPRINT FP_OUTPUT, "char*   GetFileName (LPCTSTR,LPCTSTR, int=0, HWND=0, ULONG=0, LPCTSTR=NULL, LPCTSTR=NULL, PINT=NULL);"
        END IF

        IF Use_GetSaveAsFilename THEN
            FPRINT FP_OUTPUT, "char*   GetSaveAsFileName (LPCTSTR, LPCTSTR, int=0, HWND=NULL, ULONG=0, LPCTSTR=NULL, LPCTSTR=NULL, PINT=NULL);"
        END IF

        IF Use_GetTextSize THEN
            FPRINT FP_OUTPUT, "SIZE*   GetTextSize (LPCTSTR, HWND=0, HFONT=0);"
        END IF

        IF Use_Time THEN
            FPRINT FP_OUTPUT, "char*   timef (int=0, int=0);"
        END IF

        IF Use_Join THEN
            FPRINT FP_OUTPUT, "char*   join(int, LPCTSTR, ...);"
        END IF

        IF Use_Enclose THEN
            FPRINT FP_OUTPUT, "char*   enc (LPCTSTR, int=0, int=0);"
        END IF

        IF Use_Stristr THEN
            FPRINT FP_OUTPUT, "char*   _stristr_(LPCTSTR, LPCTSTR);"
        END IF

        IF Use_IInstrAny OR Use_InstrAny THEN
            FPRINT FP_OUTPUT, "char*   DeDupeSort(const char*);"
            FPRINT FP_OUTPUT, "int     DeDupeCompare(const void*, const void*);"
        END IF

        IF Use_Wrap THEN
            FPRINT FP_OUTPUT, "char*   wrap (LPCTSTR, LPCTSTR=", ENC$(""), ", LPCTSTR=", ENC$(""), ");"
        END IF

        IF Use_Unwrap THEN
            FPRINT FP_OUTPUT, "char*   unwrap (LPCTSTR, LPCTSTR=", ENC$(""), ", LPCTSTR=", ENC$(""), ");"
        END IF

        IF Use_Freefile THEN
            FPRINT FP_OUTPUT, "FILE*   FreeFile (void);"
        END IF

        IF Use_PeekStr THEN
            FPRINT FP_OUTPUT, "char*   peekstr (PVOID, int);"
        END IF

        IF Use_Asc THEN
            FPRINT FP_OUTPUT, "int     asc (LPCTSTR, int=0);"
        END IF

        IF Use_Instrrev THEN
            FPRINT FP_OUTPUT, "int     InstrRev (LPCTSTR, LPCTSTR, int=0, int=0);"
        END IF

        IF Use_FirstInstance THEN
            FPRINT FP_OUTPUT, "BOOL    FindFirstInstance (LPCTSTR);"
        END IF

        IF Use_BCX_stricmp THEN
            FPRINT FP_OUTPUT, "int     bcx_stricmp (LPCTSTR cs, LPCTSTR ct);"
        END IF

        IF Use_Instr THEN
            FPRINT FP_OUTPUT, "int     instr (LPCTSTR, LPCTSTR, int=1, int=0);"
        END IF

        IF Use_IInstr THEN
            FPRINT FP_OUTPUT, "int     iinstr (LPCTSTR, LPCTSTR, int=1);"
        END IF

        IF Use_InstrAny THEN
            FPRINT FP_OUTPUT, "int     InstrAny (LPCTSTR, LPCTSTR, int=1);"
        END IF

        IF Use_IInstrAny THEN
            FPRINT FP_OUTPUT, "int     IInstrAny (LPCTSTR, LPCTSTR, int=1);"
        END IF

        IF Use_Like_Instr THEN
            FPRINT FP_OUTPUT, "int     Like_Instr (LPCTSTR Buffer, LPCTSTR Pattern);"
        END IF

        IF Use_Verify THEN
            FPRINT FP_OUTPUT, "int     Verify (LPCTSTR, LPCTSTR);"
            FPRINT FP_OUTPUT, "int     VerifyInstr (LPCTSTR, LPCTSTR, int=0);"
        END IF

        IF Use_Retain THEN
            FPRINT FP_OUTPUT, "char*   Retain (LPCTSTR, LPCTSTR);"
        END IF

        IF Use_LoadFile THEN
            FPRINT FP_OUTPUT, "char*   LoadFile (LPCTSTR);"
        END IF

        IF Use_Inchr THEN
            FPRINT FP_OUTPUT, "int     inchr (LPCTSTR, LPCTSTR);"
        END IF

        IF Use_Idxqsort THEN
            FPRINT FP_OUTPUT, "int     IdxCompare (const void *, const void *);"
        END IF

        IF Use_IdxqsortSt THEN
            FPRINT FP_OUTPUT, "int     IdxCompareSt (const void *, const void *);"
        END IF

        IF Use_PtrqsortSt THEN
            FPRINT FP_OUTPUT, "int     PtrCompareSt (const void *, const void *);"
        END IF

        IF Use_Strqsortas THEN
            FPRINT FP_OUTPUT, "int     StrCompareAs (const void *, const void *);"
        END IF

        IF Use_Strqsorta THEN
            FPRINT FP_OUTPUT, "int     StrCompareA (const void *, const void *);"
        END IF

        IF Use_Strqsortds THEN
            FPRINT FP_OUTPUT, "int     StrCompareDs (const void *, const void *);"
        END IF

        IF Use_Strqsortd THEN
            FPRINT FP_OUTPUT, "int     StrCompareD (const void *, const void *);"
        END IF

        IF Use_DynStrqsortas THEN
            FPRINT FP_OUTPUT, "int     DynStrCompareAs (const void *, const void *);"
        END IF

        IF Use_DynStrqsorta THEN
            FPRINT FP_OUTPUT, "int     DynStrCompareA (const void *, const void *);"
        END IF

        IF Use_DynStrqsortds THEN
            FPRINT FP_OUTPUT, "int     DynStrCompareDs (const void *, const void *);"
        END IF

        IF Use_DynStrqsortd THEN
            FPRINT FP_OUTPUT, "int     DynStrCompareD (const void *, const void *);"
        END IF

        IF Use_DynAlphaNumericA THEN
            FPRINT FP_OUTPUT, "int     DynAlphaNumericA (const void *, const void *);"
        END IF

        IF Use_DynAlphaNumericD THEN
            FPRINT FP_OUTPUT, "int     DynAlphaNumericD (const void *, const void *);"
        END IF

        IF Use_AlphaNumericA THEN
            FPRINT FP_OUTPUT, "int     AlphaNumericA (const void *, const void *);"
        END IF

        IF Use_AlphaNumericD THEN
            FPRINT FP_OUTPUT, "int     AlphaNumericD (const void *, const void *);"
        END IF

        IF Use_AlphaNumeric THEN
            FPRINT FP_OUTPUT, "int     AlphaNumeric (const void *, const void *);"
        END IF

        IF Use_Numqsortaint THEN
            FPRINT FP_OUTPUT, "int     NumCompareAint (const void *,const void *);"
        END IF

        IF Use_Numqsortdint THEN
            FPRINT FP_OUTPUT, "int     NumCompareDint (const void *,const void *);"
        END IF

        IF Use_Numqsortafloat THEN
            FPRINT FP_OUTPUT, "int     NumCompareAfloat (const void *,const void *);"
        END IF

        IF Use_Numqsortdfloat THEN
            FPRINT FP_OUTPUT, "int     NumCompareDfloat (const void *,const void *);"
        END IF

        IF Use_Numqsortadouble THEN
            FPRINT FP_OUTPUT, "int     NumCompareAdouble (const void *,const void *);"
        END IF

        IF Use_Numqsortddouble THEN
            FPRINT FP_OUTPUT, "int     NumCompareDdouble (const void *,const void *);"
        END IF

        IF Use_Msgbox THEN
            FPRINT FP_OUTPUT, "int     MsgBox (LPCTSTR,LPCTSTR,int);"
        END IF

        IF Use_Like THEN
            FPRINT FP_OUTPUT, "int     like (LPCTSTR, LPCTSTR);"
        END IF

        IF Use_LeftStr THEN
            FPRINT FP_OUTPUT, "int     LeftStr  (LPCTSTR, LPCTSTR, int=0);"
        END IF

        IF Use_RightStr THEN
            FPRINT FP_OUTPUT, "int     RightStr (LPCTSTR, LPCTSTR, int=0);"
        END IF

        IF Use_Textmode THEN
            FPRINT FP_OUTPUT, "int     TextMode (int);"
        END IF

        IF Use_Tally THEN
            FPRINT FP_OUTPUT, "int     tally (LPCTSTR, LPCTSTR, int=0);"
        END IF

        IF Use_Diskfree THEN
            FPRINT FP_OUTPUT, "UINT64  DiskFree (LPCTSTR);"
        END IF

        IF Use_Diskused THEN
            FPRINT FP_OUTPUT, "UINT64  DiskUsed (LPCTSTR);"
        END IF

        IF Use_Disksize THEN
            FPRINT FP_OUTPUT, "UINT64  DiskSize (LPCTSTR);"
        END IF

        IF Use_Hex2Dec THEN
            FPRINT FP_OUTPUT, "UINT64  Hex2Dec (LPCTSTR);"
        END IF

        IF Use_Inkey THEN
            FPRINT FP_OUTPUT, "char*   inkey (void);"
        END IF

        IF Use_InkeyD THEN
            FPRINT FP_OUTPUT, "int     inkeyd (void);"
        END IF

        IF Use_Bin2dec THEN
            FPRINT FP_OUTPUT, "int     Bin2Dec (LPCTSTR);"
        END IF

        IF Use_Download THEN
            FPRINT FP_OUTPUT, "int     Download (LPCTSTR, LPCTSTR);"
        END IF

        IF Use_Exist THEN
            FPRINT FP_OUTPUT, "BOOL    Exist   (LPCTSTR);"
            FPRINT FP_OUTPUT, "BOOL    Exist_A (LPCTSTR);"
            FPRINT FP_OUTPUT, "BOOL    Exist_B (LPCTSTR);"
        END IF

        IF Use_Gethttpfilesize THEN
            FPRINT FP_OUTPUT, "ULONG   GetHttpFileSize (LPCTSTR);"
        END IF

        IF Use_Downloadtostr THEN
            FPRINT FP_OUTPUT, "char*   DownloadToStr (LPCTSTR);"
        END IF

        IF Use_Ins THEN
            FPRINT FP_OUTPUT, "char*   ins (LPCTSTR, int, LPCTSTR);"
        END IF

        IF Use_Del THEN
            FPRINT FP_OUTPUT, "char*   del (LPCTSTR, int, int);"
        END IF

        IF Use_Chrtoutf8 THEN
            FPRINT FP_OUTPUT, "char *ChrToUtf8 (LPCSTR);"
        END IF

        IF Use_Utf8tochr THEN
            FPRINT FP_OUTPUT, "char *UTF8toCHR (LPCSTR);"
        END IF


        IF Use_Screen THEN
            FPRINT FP_OUTPUT, "int     Screen (int, int, int=0);"
        END IF

        IF Use_Pause THEN
            FPRINT FP_OUTPUT, "void    Pause (void);"
        END IF

        IF Use_Clip_Gettext THEN
            FPRINT FP_OUTPUT, "char*   Clipboard_GetText (void);"
        END IF

        IF Use_Clip_Gettextsize THEN
            FPRINT FP_OUTPUT, "int     Clipboard_GetTextSize (void);"
        END IF

        IF  Use_Clip_Settext THEN
            FPRINT FP_OUTPUT, "void    Clipboard_SetText (LPCTSTR);"
        END IF

        IF Use_Clip_Getbitmap THEN
            FPRINT FP_OUTPUT, "HBITMAP Clipboard_GetBitmap (void);"
        END IF

        IF  Use_Clip_Setbitmap THEN
            FPRINT FP_OUTPUT, "void    Clipboard_SetBitmap (HBITMAP);"
        END IF

        IF Use_Keypress THEN
            FPRINT FP_OUTPUT, "int     keypress (void);"
        END IF

        IF Use_Lof THEN
            FPRINT FP_OUTPUT, "unsigned long long int  lof (LPCTSTR);"
        END IF

        IF Use_Sgn THEN
            FPRINT FP_OUTPUT, "double  sgn (double);"
        END IF

        IF Use_Round THEN
            FPRINT FP_OUTPUT, "double  Round (double, int);"
        END IF

        IF Use_Rnd THEN
            FPRINT FP_OUTPUT, "float   rnd (void);"
        END IF

        IF Use_Rnd2 THEN
            FPRINT FP_OUTPUT, "double  rnd2 (double, double);"
        END IF

        IF Use_Exp THEN
            FPRINT FP_OUTPUT, "double  Exp (double);"
        END IF

        IF Use_Max THEN
            FPRINT FP_OUTPUT, "double  MAX (double, double);"
        END IF

        IF Use_Min THEN
            FPRINT FP_OUTPUT, "double  MIN (double, double);"
        END IF

        IF Use_Modstyle THEN
            FPRINT FP_OUTPUT, "BOOL    ModStyle (HWND, LONG_PTR=0, LONG_PTR=0, BOOL=0);"
        END IF

        IF Use_Timer THEN
            FPRINT FP_OUTPUT, "float   timer (void);"
        END IF

        IF Use_Iif THEN
            FPRINT FP_OUTPUT, "double  iif (int, double, double);"
        END IF

        IF Use_Loc THEN
            FPRINT FP_OUTPUT, "int     loc (FILE *fp, int fplen);"
        END IF

        IF Use_Rec THEN
            FPRINT FP_OUTPUT, "int     rec (FILE *fp, int fplen);"
        END IF

        IF Use_RecCount THEN
            FPRINT FP_OUTPUT, "int     reccount (FILE *fp, int fplen);"
        END IF

        IF Use_Scan THEN
            FPRINT FP_OUTPUT, "int     scan (LPCTSTR input, LPCTSTR format, ... );"
        END IF

        IF Use_KBinput THEN
            FPRINT FP_OUTPUT, "void    KBinput (void);"
        END IF

        IF Use_Split THEN
            FPRINT FP_OUTPUT, "int     Split (char[][BCXSTRSIZE], LPCTSTR, LPCTSTR, int=0);"
        END IF

        IF Use_DSplit THEN
            FPRINT FP_OUTPUT, "int     DSplit (PSTR *, LPCTSTR, LPCTSTR, int=0);"
        END IF

        IF Use_SysStr THEN
            FPRINT FP_OUTPUT, "BSTR    SysStr (LPCTSTR szIn, int=0, int=0);"
        END IF

        IF Use_LCaseTbl THEN
            FPRINT FP_OUTPUT, "unsigned char*  MakeLCaseTbl (void);"
        END IF

        IF Use_UCaseTbl THEN
            FPRINT FP_OUTPUT, "unsigned char*  MakeUCaseTbl (void);"
        END IF

        IF Use_Cvi THEN
            FPRINT FP_OUTPUT, "short   CVI (LPCTSTR);"
        END IF

        IF Use_Mki THEN
            FPRINT FP_OUTPUT, "char*   MKI (short);"
        END IF

        IF Use_Cvl THEN
            FPRINT FP_OUTPUT, "long    CVL (LPCTSTR);"
        END IF

        IF Use_Mkl THEN
            FPRINT FP_OUTPUT, "char*   MKL (int);"
        END IF

        IF Use_Cvs THEN
            FPRINT FP_OUTPUT, "float   CVS (LPCTSTR);"
        END IF

        IF Use_Mks THEN
            FPRINT FP_OUTPUT, "char*   MKS (float);"
        END IF

        IF Use_Cvd THEN
            FPRINT FP_OUTPUT, "double  CVD (LPCTSTR);"
        END IF

        IF Use_Cvld THEN
            FPRINT FP_OUTPUT, "long double  CVLD (LPCTSTR);"
        END IF

        IF Use_Mkd THEN
            FPRINT FP_OUTPUT, "char*   MKD (double);"
        END IF

        IF Use_Mkld THEN
            FPRINT FP_OUTPUT, "char*   MKLD (long double);"
        END IF

        IF Use_OSVersion THEN
            FPRINT FP_OUTPUT, "int     OSVersion (void);"
        END IF

        IF Use_Sound THEN
            FPRINT FP_OUTPUT, "int     Sound (float, int=0, int=127, int=0, float=1.0f);"
            FPRINT FP_OUTPUT, "int     PlaySnd (void);"
        END IF

        IF Use_Hscroll OR Use_Vscroll THEN
            FPRINT FP_OUTPUT, "void    BCX_Scroll (HWND, int, int, int, int, int, int, int, int, int, int);"
        END IF

        IF Use_DynacallCommon THEN
            FPRINT FP_OUTPUT, "HINSTANCE BCX_LoadDll (LPCTSTR);"
            FPRINT FP_OUTPUT, "void      BCX_UnloadDll (void);"
            IF Use_Dynacall THEN
                FPRINT FP_OUTPUT, "INT_PTR   BCX_DynaCallB (LPCTSTR, LPCTSTR, int, ...);"
            END IF
            IF Use_DynacallA THEN
                FPRINT FP_OUTPUT, "INT_PTR   BCX_DynaCallA(LPCTSTR, LPCTSTR, int, INT_PTR *);"
            END IF
        END IF


        IF Use_DynamicA THEN
            FPRINT FP_OUTPUT, "void*   CreateArr (void*, int, int, int, size_t *);"
            FPRINT FP_OUTPUT, "void    DestroyArr (void**, int, int);"
        END IF

        IF Use_ContainedIn THEN
            FPRINT FP_OUTPUT, "int     containedin (char*, char **, int=0);"
        END IF

        IF Use_FindInType THEN
            FPRINT FP_OUTPUT, "int     FindInType (LPCTSTR, LPCTSTR, int, int, int, int=0, PINT=NULL);"
        END IF

        IF Use_Printer THEN
            FPRINT FP_OUTPUT, "int     PrinterOpen  (LPCTSTR =" , ENC$("Courier New") , ", int=12, int=DEFAULT_CHARSET);"
            FPRINT FP_OUTPUT, "void    PrinterWrite (LPCTSTR, int=80, int=60);"
            FPRINT FP_OUTPUT, "void    EjectPage    (void);"
            FPRINT FP_OUTPUT, "void    PrinterClose (void);"
        END IF

        IF Use_COM THEN
            FPRINT FP_OUTPUT, ""
            FPRINT FP_OUTPUT, "// *************************************************"
            FPRINT FP_OUTPUT, "//          Late binding COM support section"
            FPRINT FP_OUTPUT, "//  (c) Ljubisa Knezevic 2004-2009, ljube@blic.net"
            FPRINT FP_OUTPUT, "// *************************************************"
            FPRINT FP_OUTPUT, ""
            FPRINT FP_OUTPUT, "#define COM_MSGBOX(a,b,c)MessageBox(GetActiveWindow(),(a),(b),(c))"
            FPRINT FP_OUTPUT, "#define COM_PROPS DISPATCH_PROPERTYGET|DISPATCH_METHOD"
            FPRINT FP_OUTPUT, "#define COM_PARAMS COM_param_list.pParams"
            FPRINT FP_OUTPUT, ""
        END IF

        IF Use_WideToAnsi THEN
            FPRINT FP_OUTPUT, "//<---UNICODE AWARE"
            FPRINT FP_OUTPUT, "char*   WideToAnsi (LPWSTR, UINT=CP_ACP, ULONG=0);"  ' 827 MrBcx changed from BSTR
            FPRINT FP_OUTPUT, "//>---UNICODE AWARE"
            FPRINT FP_OUTPUT, ""
        END IF

        IF Use_AnsiToWide THEN
            FPRINT FP_OUTPUT, "//<---UNICODE AWARE"
            FPRINT FP_OUTPUT, "PWSTR AnsiToWide (LPCSTR, UINT=CP_ACP, ULONG=MB_PRECOMPOSED);"
            FPRINT FP_OUTPUT, "//>---UNICODE AWARE"
            FPRINT FP_OUTPUT, ""
        END IF

        IF Use_SafeArrays THEN
            FPRINT FP_OUTPUT, "HRESULT InitSafeArray    (SAFEARRAY** ppsa, VARTYPE vtype, UINT ndim, ...);"
            FPRINT FP_OUTPUT, "HRESULT DestroySafeArray (SAFEARRAY* psA);"
            FPRINT FP_OUTPUT, ""
        END IF

        IF Use_COM_UsesConversion THEN
            FPRINT FP_OUTPUT, "HRESULT  COM_AS2WS (LPCSTR  ansi_string, UINT code_page=CP_ACP);"
            FPRINT FP_OUTPUT, "HRESULT  COM_WS2AS (LPCWSTR wide_string, UINT code_page=CP_ACP);"
            FPRINT FP_OUTPUT, ""
        END IF

        IF Use_COM_CLSID THEN
            FPRINT FP_OUTPUT, "char*    BCX_CLSID(char*);"
        END IF

        IF Use_COM THEN
            FPRINT FP_OUTPUT, "#define COM_STACK_SIZE ", COM_STACK_SIZE
            FPRINT FP_OUTPUT, "#ifndef CON_VARBOOL2BOOL"
            FPRINT FP_OUTPUT, "  #define CON_VARBOOL2BOOL(b) ((BOOL)(b ? TRUE : FALSE))"
            FPRINT FP_OUTPUT, "#endif"
            FPRINT FP_OUTPUT, ""
            FPRINT FP_OUTPUT, "typedef struct _OBJECT {"
            FPRINT FP_OUTPUT, "  IUnknown*  p_unknown;"
            FPRINT FP_OUTPUT, "  VARIANT    pObjects[COM_STACK_SIZE];"
            FPRINT FP_OUTPUT, "  BOOL       pStatus;"
            FPRINT FP_OUTPUT, "  int        ipointer;"
            FPRINT FP_OUTPUT, "}OBJECT, *LPOBJECT;"
            FPRINT FP_OUTPUT, ""
            FPRINT FP_OUTPUT, "typedef struct _PARAM_VARARRAY {"
            FPRINT FP_OUTPUT, "  VARIANT  pParams[COM_STACK_SIZE];"
            FPRINT FP_OUTPUT, "}PARAM_VARARRAY, *LPPARAM_VARARRAY;"
            FPRINT FP_OUTPUT, ""
            FPRINT FP_OUTPUT, "// *************************************************"
            FPRINT FP_OUTPUT, "//       COM functions used internally by BCX"
            FPRINT FP_OUTPUT, "// *************************************************"
            FPRINT FP_OUTPUT, ""
            FPRINT FP_OUTPUT, "void     COM_ole_initialize            (void);"
            FPRINT FP_OUTPUT, "void     COM_ole_uninitialize          (void);"
            FPRINT FP_OUTPUT, "void     COM_HR_ErrMsg                 (HRESULT hr, TCHAR *extra_info);"
            FPRINT FP_OUTPUT, "DISPID   COM_get_dispatch_ID           (IDispatch *lpDispatch, PWSTR comsegment);"
            FPRINT FP_OUTPUT, "void     COM_get_next_dispatch         (OBJECT *object, PWSTR comsegment);"
            FPRINT FP_OUTPUT, "void     COM_invoke                    (OBJECT *object, PWSTR comsegment, WORD wFlags, VARIANT *pvResult);"
            FPRINT FP_OUTPUT, "void     COM_build_except_info         (HRESULT hr, EXCEPINFO *pexcep = NULL, UINT uiArgErr = 0);"
            FPRINT FP_OUTPUT, "void     COM_clean_plist               (void);"
            FPRINT FP_OUTPUT, "void     COM_reset_disp_chain          (OBJECT *object);"
            FPRINT FP_OUTPUT, "void     COM_create_safearray          (void);"

            IF COM_build_trace_code    THEN
                FPRINT FP_OUTPUT, "static char COM_trace_line[BCXSTRSIZE];"
            END IF

            FPRINT FP_OUTPUT, "void     COM_trace_dump_DISPPARAMS     (DISPPARAMS* dp);"
            FPRINT FP_OUTPUT, "void     COM_trace_add_line            (LPCTSTR dp);"
            FPRINT FP_OUTPUT, "void     COM_trace_dump_indicators     (OBJECT *object);"
            FPRINT FP_OUTPUT, "void     COM_trace_dump_flags          (WORD wFlags);"
            FPRINT FP_OUTPUT, "void     COM_FREE_TEMP_ANSI_STRING     (void);"
            FPRINT FP_OUTPUT, "void     COM_FREE_TEMP_WIDE_STRING     (void);"
            FPRINT FP_OUTPUT, ""
            FPRINT FP_OUTPUT, "// *************************************************"
            FPRINT FP_OUTPUT, "//       Public COM support functions"
            FPRINT FP_OUTPUT, "// *************************************************"
            FPRINT FP_OUTPUT, ""
            FPRINT FP_OUTPUT, "OBJECT   COM                    (LPCTSTR);"
            FPRINT FP_OUTPUT, "void     UNCOM                  (OBJECT);"
            FPRINT FP_OUTPUT, "void     BCX_SHOW_COM_ERRORS    (BOOL);"
            FPRINT FP_OUTPUT, "void     BCX_SetNothing         (OBJECT*);"
            FPRINT FP_OUTPUT, "BOOL     BCX_GET_COM_SUCCESS    (void);"
            FPRINT FP_OUTPUT, "BOOL     BCX_GET_COM_STATUS     (OBJECT*);"
            FPRINT FP_OUTPUT, "char*    BCX_GET_COM_ERROR_DESC (void);"
            FPRINT FP_OUTPUT, "int      ISOBJECT               (OBJECT);"
            FPRINT FP_OUTPUT, "HRESULT  BCX_GET_COM_ERROR_CODE (void);"

            IF Use_COM_CreateObject THEN
                FPRINT FP_OUTPUT, "void     BCX_CreateObject       (TCHAR *objname, OBJECT *obj);"
            END IF

            IF Use_COM_GetObject THEN
                FPRINT FP_OUTPUT, "void     BCX_GetObject          (TCHAR *objname, OBJECT *obj);"
                FPRINT FP_OUTPUT, "void     BCX_GetObjectMon       (LPCOLESTR objname, OBJECT *obj);"
            END IF

            IF Use_COM_DispatchObject THEN
                FPRINT FP_OUTPUT, "void     BCX_DispatchObject     (IUnknown *iobj, OBJECT *obj, BOOL b_release = TRUE);"
            END IF

        END IF
    END IF ' IF Use_Project = FALSE
END SUB ' StdProtos


'*********************************************************************
'                 BCX Runtime Code Library Starts Here
'              Late binding COM support Runtime Functions
'*********************************************************************



SUB Emit_COM_SupportTypes (FP_OUTPUT AS FILE)
    '*********************************************************************
    ' Sub: Emit_COM_SupportTypes (part of BCX COM parser)
    ' This sub emits standard typedefs and global variables
    ' used by BCX late binding COM interface.
    '*********************************************************************
    DIM RAW prefix$
    prefix$ = "static "
    IF Use_Project THEN prefix$ = ""

    FPRINT FP_OUTPUT, "// *************************************************"
    FPRINT FP_OUTPUT, "//    Global vars used by late binding COM support"
    FPRINT FP_OUTPUT, "// *************************************************"
    FPRINT FP_OUTPUT, ""
    FPRINT FP_OUTPUT, prefix$ + "PARAM_VARARRAY  COM_param_list;"
    FPRINT FP_OUTPUT, prefix$ + "_TCHAR          COM_last_ErrMsg[4096];"
    FPRINT FP_OUTPUT, prefix$ + "_TCHAR          COM_ErrMsg[64];"
    FPRINT FP_OUTPUT, prefix$ + "int             COM_plist_index = 0;"
    FPRINT FP_OUTPUT, prefix$ + "VARIANT         COM_vt_result;"
    FPRINT FP_OUTPUT, prefix$ + "HRESULT         COM_last_HR;"
    FPRINT FP_OUTPUT, prefix$ + "BOOL            COM_ole_initd = FALSE;"
    FPRINT FP_OUTPUT, prefix$ + "int             COM_objects_cnt = 0;"
    FPRINT FP_OUTPUT, prefix$ + "int             COM_reset_chain = 0;"
    FPRINT FP_OUTPUT, prefix$ + "BOOL            COM_BCX_ERROR = FALSE;"
    FPRINT FP_OUTPUT, prefix$ + "BOOL            COM_bSHOW_ERROR = FALSE;"
    FPRINT FP_OUTPUT, prefix$ + "SAFEARRAY *     COM_PTR_safearray = NULL;"
    FPRINT FP_OUTPUT, prefix$ + "PWSTR           COM_LPWSTR_temp = NULL;"
    FPRINT FP_OUTPUT, prefix$ + "char*           COM_psz_tmp = NULL;"
    FPRINT FP_OUTPUT, prefix$ + "ULONG           COM_wstr_size = 0;"
    FPRINT FP_OUTPUT, prefix$ + "ULONG           COM_zstr_size = 0;"
    FPRINT FP_OUTPUT, prefix$ + "BOOL            COM_GetEnum_iface = FALSE;"

    ' <WITH - END WITH>
    FPRINT FP_OUTPUT, prefix$ + "int             COM_dispatch_storage[", COM_Max_Withs, "];"
    FPRINT FP_OUTPUT, prefix$ + "int             COM_dispatch_storage_index = 0;"
    FPRINT FP_OUTPUT, prefix$ + "int             COM_dispatch_at_offset = 0;" ' for nested (with/end with)
    ' </WITH - END WITH>

    IF Use_COM_Collections THEN
        FPRINT FP_OUTPUT, prefix$ + "VARIANT         COM_ack_var;"
        FPRINT FP_OUTPUT, prefix$ + "IEnumVARIANT*   COM_enum_var = NULL;"
        FPRINT FP_OUTPUT, prefix$ + "ULONG           COM_long_coll = 0;"
    END IF
END SUB ' Emit_COM_SupportTypes





SUB Emit_COM_StandardSet (FP_OUTPUT AS FILE)
    '*********************************************************************
    ' Code emission for BCX late binding COM interface.
    '*********************************************************************
    FPRINT FP_OUTPUT, "// *************************************************"
    FPRINT FP_OUTPUT, "//              COM Runtime Functions"
    FPRINT FP_OUTPUT, "// *************************************************"
    FPRINT FP_OUTPUT, ""
    FPRINT FP_OUTPUT, "OBJECT COM (LPCTSTR szProgID_) {"
    FPRINT FP_OUTPUT, "    static OBJECT oProxy;"
    FPRINT FP_OUTPUT, "    BCX_CreateObject ((char*)szProgID_, &oProxy);"
    FPRINT FP_OUTPUT, "    return oProxy;"
    FPRINT FP_OUTPUT, "}\n\n"
    FPRINT FP_OUTPUT, "void UNCOM (OBJECT oObj_) {"
    FPRINT FP_OUTPUT, "    static OBJECT oProxy;"
    FPRINT FP_OUTPUT, "    oProxy = oObj_;"
    FPRINT FP_OUTPUT, "    BCX_SetNothing (&oProxy);"
    FPRINT FP_OUTPUT, "}\n\n"
    FPRINT FP_OUTPUT, "int ISOBJECT (OBJECT Obj) {"
    FPRINT FP_OUTPUT, "    if(Obj.pStatus)"
    FPRINT FP_OUTPUT, "        return TRUE;"
    FPRINT FP_OUTPUT, "   else"
    FPRINT FP_OUTPUT, "       return FALSE;"
    FPRINT FP_OUTPUT, "}\n\n"
    FPRINT FP_OUTPUT, "HRESULT BCX_GET_COM_ERROR_CODE (void) {"
    FPRINT FP_OUTPUT, "    return COM_last_HR;"
    FPRINT FP_OUTPUT, "}\n\n"
    FPRINT FP_OUTPUT, "_TCHAR* BCX_GET_COM_ERROR_DESC (void) {"
    FPRINT FP_OUTPUT, "    return COM_last_ErrMsg;"
    FPRINT FP_OUTPUT, "}\n\n"
    FPRINT FP_OUTPUT, "BOOL BCX_GET_COM_SUCCESS (void) {"
    FPRINT FP_OUTPUT, "    return (!COM_BCX_ERROR);"
    FPRINT FP_OUTPUT, "}\n\n"
    FPRINT FP_OUTPUT, "void BCX_SHOW_COM_ERRORS (BOOL Show_err) {"
    FPRINT FP_OUTPUT, "    COM_bSHOW_ERROR = Show_err;"
    FPRINT FP_OUTPUT, "}\n\n"
    FPRINT FP_OUTPUT, "BOOL BCX_GET_COM_STATUS(OBJECT *object) {"
    FPRINT FP_OUTPUT, "    if(object)"
    FPRINT FP_OUTPUT, "        return object->pStatus;"
    FPRINT FP_OUTPUT, "    return 0;"
    FPRINT FP_OUTPUT, "}\n\n"
    FPRINT FP_OUTPUT, "void  COM_clean_plist (void) {"
    FPRINT FP_OUTPUT, "int total_parms = COM_plist_index;"
    FPRINT FP_OUTPUT, "if (COM_plist_index > 0)"
    FPRINT FP_OUTPUT, "   {"
    FPRINT FP_OUTPUT, "      do"
    FPRINT FP_OUTPUT, "   {"

    IF COM_build_trace_code THEN
        FPRINT FP_OUTPUT, "    sprintf(COM_trace_line, ", ENC$("+++ clear parameter list. Clear variant at index %d. Variant type = %d"), ",COM_plist_index-1,"
        FPRINT FP_OUTPUT, "          COM_PARAMS[COM_plist_index-1].vt);"
        FPRINT FP_OUTPUT, "    COM_add_trace_line (COM_trace_line);"
    END IF

    ' it appears that VariantClear can't clear a variant that has a vt = VT_ARRAY | VT_VARIANT

    FPRINT FP_OUTPUT, "        COM_last_HR = VariantClear (&COM_PARAMS[COM_plist_index-1]);"
    FPRINT FP_OUTPUT, "        if (FAILED(COM_last_HR))"
    FPRINT FP_OUTPUT, "        {"
    FPRINT FP_OUTPUT, "        wsprintf (COM_ErrMsg, _T(", ENC$("\\nVariant type = %d, at index %d, total params = %d.") , "),"
    FPRINT FP_OUTPUT, "                  COM_PARAMS[COM_plist_index-1].vt, COM_plist_index-1, total_parms);"
    FPRINT FP_OUTPUT, "        COM_HR_ErrMsg (COM_last_HR, _T(", ENC$("Error while cleaning parameter list." ), "));"
    FPRINT FP_OUTPUT, "      }"
    FPRINT FP_OUTPUT, "        COM_plist_index--;"
    FPRINT FP_OUTPUT, "    }"
    FPRINT FP_OUTPUT, "      while (COM_plist_index > 0);"
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "}\n\n"
    FPRINT FP_OUTPUT, "void  COM_reset_disp_chain (OBJECT *object) {"
    FPRINT FP_OUTPUT, "  if (object->ipointer>COM_dispatch_at_offset)"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    do"
    FPRINT FP_OUTPUT, "    {"

    IF COM_build_trace_code THEN
        FPRINT FP_OUTPUT, "  sprintf(COM_trace_line, ", ENC$("Dispath release at index %d. Variant Type = %d")
        FPRINT FP_OUTPUT, "  ,object->ipointer,object->pObjects[object->ipointer].vt);"
        FPRINT FP_OUTPUT, "  COM_add_trace_line (COM_trace_line);"
    END IF

    FPRINT FP_OUTPUT, "      VariantClear (&object->pObjects[object->ipointer]);"
    FPRINT FP_OUTPUT, "      object->ipointer--;"
    FPRINT FP_OUTPUT, "    }"
    FPRINT FP_OUTPUT, "    while (object->ipointer > COM_dispatch_at_offset);"
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "}\n\n"
    FPRINT FP_OUTPUT, "void  COM_ole_uninitialize (void) {"
    FPRINT FP_OUTPUT, "  if (COM_objects_cnt)"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    _TCHAR ermm[BCXSTRSIZE];"
    FPRINT FP_OUTPUT, "    wsprintf (ermm,_T(", ENC$("Check SET Nothing statement!\\nUnreleased objects: %d"), "),COM_objects_cnt);"
    FPRINT FP_OUTPUT, "    COM_MSGBOX (ermm, _T(", ENC$("Memory leaks detected!"), "),MB_OK|MB_ICONWARNING|MB_TASKMODAL);"
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "  COM_FREE_TEMP_WIDE_STRING();"
    FPRINT FP_OUTPUT, "  COM_FREE_TEMP_ANSI_STRING();"
    FPRINT FP_OUTPUT, "  CoUninitialize();"
    FPRINT FP_OUTPUT, "}\n\n"
    FPRINT FP_OUTPUT, "void  COM_get_next_dispatch (OBJECT *object, PWSTR comsegment) {"
    FPRINT FP_OUTPUT, "  if (!object->pStatus) return;"
    FPRINT FP_OUTPUT, "  if (0 == object->ipointer) COM_BCX_ERROR = FALSE;"
    FPRINT FP_OUTPUT, "  if (COM_BCX_ERROR) return;"
    FPRINT FP_OUTPUT, "  COM_reset_chain++;"
    FPRINT FP_OUTPUT, "  COM_invoke (object, comsegment,COM_PROPS,&object->pObjects[object->ipointer+1]);"
    FPRINT FP_OUTPUT, "  COM_reset_chain--;"
    FPRINT FP_OUTPUT, "  if (!COM_BCX_ERROR)"
    FPRINT FP_OUTPUT, "     object->ipointer++;"
    FPRINT FP_OUTPUT, "}\n\n"
    FPRINT FP_OUTPUT, "void COM_HR_ErrMsg (HRESULT hr, _TCHAR *extra_info) {"
    FPRINT FP_OUTPUT, "  COM_BCX_ERROR = TRUE;"
    FPRINT FP_OUTPUT, "  PVOID pMsgBuf;"
    FPRINT FP_OUTPUT, ""
    FPRINT FP_OUTPUT, "  FormatMessage (FORMAT_MESSAGE_ALLOCATE_BUFFER|FORMAT_MESSAGE_FROM_SYSTEM,"
    FPRINT FP_OUTPUT, "  NULL, hr, MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), (LPTSTR)&pMsgBuf, 0, NULL);"
    FPRINT FP_OUTPUT, ""
    FPRINT FP_OUTPUT, "  wsprintf(COM_last_ErrMsg, _T(", ENC$("COM error code %d (0x%X)\\n%s\\n%s\\nmember: %s"), "),"
    FPRINT FP_OUTPUT, "  hr, hr, extra_info, pMsgBuf, COM_ErrMsg);"

    IF COM_build_trace_code  THEN
        FPRINT FP_OUTPUT, ""
        FPRINT FP_OUTPUT, "  COM_trace_add_line(", ENC$(">>> COM ERROR DUMP >>> COM ERROR DUM >>> COM ERROR DUMP >>>"), ");"
        FPRINT FP_OUTPUT, "  COM_trace_add_line(COM_last_ErrMsg);"
        FPRINT FP_OUTPUT, "  COM_trace_add_line(", ENC$("<<< COM ERROR DUMP <<< COM ERROR DUM <<< COM ERROR DUMP <<<"), ");"
        FPRINT FP_OUTPUT, ""
    END IF

    FPRINT FP_OUTPUT, ""
    FPRINT FP_OUTPUT, "  memset(&COM_ErrMsg,0,sizeof(COM_ErrMsg));"
    FPRINT FP_OUTPUT, "  if (COM_bSHOW_ERROR)"
    FPRINT FP_OUTPUT, "      COM_MSGBOX(COM_last_ErrMsg,_T(", ENC$("COM Parser Error Report:"), "),"
    FPRINT FP_OUTPUT, "      MB_OK|MB_ICONERROR|MB_SYSTEMMODAL);"
    FPRINT FP_OUTPUT, "  LocalFree(pMsgBuf);"
    FPRINT FP_OUTPUT, "}\n\n"
    FPRINT FP_OUTPUT, "void BCX_SetNothing (OBJECT *obj) {"
    FPRINT FP_OUTPUT, "  if (!obj->pStatus) return;"

    IF COM_build_trace_code THEN
        FPRINT FP_OUTPUT, "  COM_trace_add_line (", ENC$("Called BCX_SetNothing"), ");"
    END IF

    FPRINT FP_OUTPUT, "  COM_objects_cnt--;"
    FPRINT FP_OUTPUT, "  #ifdef __cplusplus"
    FPRINT FP_OUTPUT, "    if (obj->p_unknown) obj->p_unknown->Release();"
    FPRINT FP_OUTPUT, "  #else"
    FPRINT FP_OUTPUT, "    if (obj->p_unknown) obj->p_unknown->lpVtbl->Release(obj->p_unknown);"
    FPRINT FP_OUTPUT, "  #endif"
    FPRINT FP_OUTPUT, "  if (obj->ipointer)"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    COM_reset_disp_chain (obj);"
    FPRINT FP_OUTPUT, "    obj->ipointer = 0;"
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "  COM_last_HR = VariantClear (&obj->pObjects[0]);"
    FPRINT FP_OUTPUT, "  if (FAILED(COM_last_HR))"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    lstrcpy(COM_ErrMsg, _T(", ENC$("BCX_SetNothing Failed!"), "));"
    FPRINT FP_OUTPUT, "    COM_HR_ErrMsg (COM_last_HR, _T(", ENC$("Release of IDispatch objs failed!" ), "));"
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "  obj->pStatus = FALSE;"
    FPRINT FP_OUTPUT, "  Sleep(100);"
    FPRINT FP_OUTPUT, "}\n\n"
    FPRINT FP_OUTPUT, "void COM_ole_initialize (void) {"
    FPRINT FP_OUTPUT, "  if (COM_ole_initd) return;"

    IF COM_build_trace_code  THEN
        FPRINT FP_OUTPUT, "DeleteFile (", ENC$("c:\\com_trace.txt"), ");"
    END IF

    FPRINT FP_OUTPUT, "  #ifdef __BCX_MULTITHREADED__"
    FPRINT FP_OUTPUT, "    COM_last_HR = CoInitializeEx (NULL, COINIT_MULTITHREADED);"
    FPRINT FP_OUTPUT, "  #else"
    FPRINT FP_OUTPUT, "    COM_last_HR = CoInitializeEx (NULL, COINIT_APARTMENTTHREADED);"
    FPRINT FP_OUTPUT, "  #endif"
    FPRINT FP_OUTPUT, "  if (SUCCEEDED (COM_last_HR))"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    COM_ole_initd = TRUE;"
    FPRINT FP_OUTPUT, "    VariantInit (&COM_vt_result);"

    ' Next line atexit ANSI C function causes COM_ole_uninitialize to call when program exits

    FPRINT FP_OUTPUT, "    atexit (COM_ole_uninitialize);"
    FPRINT FP_OUTPUT, ""
    FPRINT FP_OUTPUT, "    COM_dispatch_storage[0] = 0;"
    FPRINT FP_OUTPUT, "    COM_dispatch_storage_index = 0;"
    FPRINT FP_OUTPUT, ""
    FPRINT FP_OUTPUT, "    if (COM_LPWSTR_temp) CoTaskMemFree((void*)COM_LPWSTR_temp);"
    FPRINT FP_OUTPUT, "    COM_LPWSTR_temp = (PWSTR)CoTaskMemAlloc (BCXSTRSIZE);"
    FPRINT FP_OUTPUT, "    if (NULL == COM_LPWSTR_temp)"
    FPRINT FP_OUTPUT, "    {"
    FPRINT FP_OUTPUT, "      COM_wstr_size = 0;"
    FPRINT FP_OUTPUT, "      COM_last_HR =  E_OUTOFMEMORY;"
    FPRINT FP_OUTPUT, "      COM_HR_ErrMsg (COM_last_HR,_T("
    FPRINT FP_OUTPUT, "     ", ENC$("CoInitializeEx: Memory allocation failure!"), "));"
    FPRINT FP_OUTPUT, "      return;"
    FPRINT FP_OUTPUT, "    }"
    FPRINT FP_OUTPUT, "    COM_wstr_size = BCXSTRSIZE;"
    FPRINT FP_OUTPUT, "    if (COM_psz_tmp) free(COM_psz_tmp);"
    FPRINT FP_OUTPUT, "    COM_psz_tmp = (char*)calloc(BCXSTRSIZE, sizeof(char));"
    FPRINT FP_OUTPUT, "    if (NULL == COM_psz_tmp)"
    FPRINT FP_OUTPUT, "    {"
    FPRINT FP_OUTPUT, "      COM_last_HR =  E_OUTOFMEMORY;"
    FPRINT FP_OUTPUT, "      COM_HR_ErrMsg (COM_last_HR,_T("
    FPRINT FP_OUTPUT, "     ", ENC$("CoInitializeEx: Memory allocation failure!"), "));"
    FPRINT FP_OUTPUT, "    return;"
    FPRINT FP_OUTPUT, "    }"
    FPRINT FP_OUTPUT, "    COM_zstr_size = BCXSTRSIZE;"
    FPRINT FP_OUTPUT, "    return;"
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "  else"
    FPRINT FP_OUTPUT, "    COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("CoInitializeEx Failed!"), "));"
    FPRINT FP_OUTPUT, "}\n\n"
    FPRINT FP_OUTPUT, "void COM_build_except_info (HRESULT hr, EXCEPINFO *pexcep, UINT uiArgErr) {"
    FPRINT FP_OUTPUT, "  SCODE oleSCODE;"
    FPRINT FP_OUTPUT, "  static _TCHAR lv_message[BCXSTRSIZE];"
    FPRINT FP_OUTPUT, "  oleSCODE = GetScode(hr);"
    FPRINT FP_OUTPUT, "  for (;;)"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    if (oleSCODE==DISP_E_PARAMNOTFOUND)"
    FPRINT FP_OUTPUT, "    {"
    FPRINT FP_OUTPUT, "      wsprintf (lv_message, _T(", ENC$("\\nArgument not found, argument %d."), "), uiArgErr);"
    FPRINT FP_OUTPUT, "      _tcscat(COM_last_ErrMsg, lv_message);"
    FPRINT FP_OUTPUT, "      break;"
    FPRINT FP_OUTPUT, "    }"
    FPRINT FP_OUTPUT, "    if (oleSCODE==DISP_E_TYPEMISMATCH)"
    FPRINT FP_OUTPUT, "    {"
    FPRINT FP_OUTPUT, "      wsprintf (lv_message, _T(", ENC$("\\nType mismatch, argument %d."), "), uiArgErr);"
    FPRINT FP_OUTPUT, "      _tcscat (COM_last_ErrMsg, lv_message);"
    FPRINT FP_OUTPUT, "      break;"
    FPRINT FP_OUTPUT, "    }"
    FPRINT FP_OUTPUT, "    if (oleSCODE==DISP_E_BADVARTYPE)"
    FPRINT FP_OUTPUT, "    {"
    FPRINT FP_OUTPUT, "      _tcscat(COM_last_ErrMsg, _T(", ENC$("\\nOne or more invalid VARIANT arguments."), "));"
    FPRINT FP_OUTPUT, "      break;"
    FPRINT FP_OUTPUT, "    }"
    FPRINT FP_OUTPUT, "    if (oleSCODE==E_INVALIDARG)"
    FPRINT FP_OUTPUT, "    {"
    FPRINT FP_OUTPUT, "      _tcscat(COM_last_ErrMsg, _T(", ENC$("\\nOne of the arguments is invalid."), "));"
    FPRINT FP_OUTPUT, "      break;"
    FPRINT FP_OUTPUT, "    }"
    FPRINT FP_OUTPUT, "    break;"
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "  if (pexcep)"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    wsprintf(lv_message, _T(", ENC$("\\nCOM Error %X:"), "), pexcep->wCode);"
    FPRINT FP_OUTPUT, "    if (pexcep->bstrDescription)"
    FPRINT FP_OUTPUT, "    {"
    FPRINT FP_OUTPUT, "      _TCHAR err_desc[512];"
    FPRINT FP_OUTPUT, "      #ifndef UNICODE"
    FPRINT FP_OUTPUT, "        COM_last_HR = COM_WS2AS (pexcep->bstrDescription);"
    FPRINT FP_OUTPUT, "        if (FAILED(COM_last_HR))"
    FPRINT FP_OUTPUT, "          COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("Get Error Desc: W2A failure!"), "));"
    FPRINT FP_OUTPUT, "        else"
    FPRINT FP_OUTPUT, "          wsprintf(err_desc, _T(", ENC$("\\nException desc: %s"), "), COM_psz_tmp);"
    FPRINT FP_OUTPUT, "      #else"
    FPRINT FP_OUTPUT, "          wsprintf(err_desc, _T(", ENC$("\\nException desc: %s"), "), pexcep->bstrDescription);"
    FPRINT FP_OUTPUT, "      #endif"
    FPRINT FP_OUTPUT, "      _tcscat(lv_message, err_desc);"
    FPRINT FP_OUTPUT, "      SysFreeString(pexcep->bstrDescription);"
    FPRINT FP_OUTPUT, "      pexcep->bstrDescription = NULL;"
    FPRINT FP_OUTPUT, "    }"
    FPRINT FP_OUTPUT, "    if (pexcep->bstrSource)"
    FPRINT FP_OUTPUT, "    {"
    FPRINT FP_OUTPUT, "      _TCHAR err_desc[512];"
    FPRINT FP_OUTPUT, "      #ifndef UNICODE"
    FPRINT FP_OUTPUT, "        COM_last_HR = COM_WS2AS (pexcep->bstrSource);"
    FPRINT FP_OUTPUT, "        if (FAILED(COM_last_HR))"
    FPRINT FP_OUTPUT, "            COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("Get Error Source Failed! W2A failure!"), "));"
    FPRINT FP_OUTPUT, "        else"
    FPRINT FP_OUTPUT, "            wsprintf(err_desc, _T(", ENC$("\\nException source: %s"), "), COM_psz_tmp);"
    FPRINT FP_OUTPUT, "      #else"
    FPRINT FP_OUTPUT, "            wsprintf(err_desc, _T(", ENC$("\\nException source: %s"), "), pexcep->bstrSource);"
    FPRINT FP_OUTPUT, "      #endif"
    FPRINT FP_OUTPUT, "      _tcscat (lv_message, err_desc);"
    FPRINT FP_OUTPUT, "      SysFreeString (pexcep->bstrSource);"
    FPRINT FP_OUTPUT, "      pexcep->bstrSource = NULL;"
    FPRINT FP_OUTPUT, "    }"
    FPRINT FP_OUTPUT, "    if (pexcep->bstrHelpFile)"
    FPRINT FP_OUTPUT, "    {"
    FPRINT FP_OUTPUT, "      _TCHAR err_desc[512];"
    FPRINT FP_OUTPUT, "      #ifndef UNICODE"
    FPRINT FP_OUTPUT, "        COM_last_HR = COM_WS2AS (pexcep->bstrHelpFile);"
    FPRINT FP_OUTPUT, "        if (FAILED(COM_last_HR))"
    FPRINT FP_OUTPUT, "        COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("Help File failed: W2A failure!"), "));"
    FPRINT FP_OUTPUT, "        else"
    FPRINT FP_OUTPUT, "        wsprintf(err_desc, _T("
    FPRINT FP_OUTPUT, "        ", ENC$("\\nHelp file: %s | topic: %lu"), "), COM_psz_tmp, pexcep->dwHelpContext);"
    FPRINT FP_OUTPUT, "      #else"
    FPRINT FP_OUTPUT, "        wsprintf(err_desc, _T("
    FPRINT FP_OUTPUT, "        ", ENC$("\\nHelp file: %s | topic: %lu"), "), pexcep->bstrHelpFile, pexcep->dwHelpContext);"
    FPRINT FP_OUTPUT, "      #endif"
    FPRINT FP_OUTPUT, "      _tcscat(lv_message, err_desc);"
    FPRINT FP_OUTPUT, "      SysFreeString (pexcep->bstrHelpFile);"
    FPRINT FP_OUTPUT, "      pexcep->bstrHelpFile = NULL;"
    FPRINT FP_OUTPUT, "    }"
    FPRINT FP_OUTPUT, "    _tcscat (COM_last_ErrMsg ,lv_message);"
    FPRINT FP_OUTPUT, "  }"

    IF COM_build_trace_code  THEN
        FPRINT FP_OUTPUT, "  COM_trace_add_line(", ENC$(">>> COM EXCEPTION DUMP >>> COM EXCEPTION DUMP >>>"), ");"
        FPRINT FP_OUTPUT, "  COM_trace_add_line(COM_last_ErrMsg);"
        FPRINT FP_OUTPUT, "  COM_trace_add_line(", ENC$("<<< COM EXCEPTION DUMP <<< COM EXCEPTION DUMP <<<"), ");"
    END IF

    FPRINT FP_OUTPUT, "  if (COM_bSHOW_ERROR)"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    COM_MSGBOX(COM_last_ErrMsg, _T(", ENC$("COM Parser Exception Info:"), "),"
    FPRINT FP_OUTPUT, "    MB_OK|MB_ICONERROR|MB_SYSTEMMODAL);"

    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "}\n\n"
    FPRINT FP_OUTPUT, "DISPID COM_get_dispatch_ID (IDispatch* lpDispatch, PWSTR comsegment) {"
    FPRINT FP_OUTPUT, "  static DISPID D_ID;"
    FPRINT FP_OUTPUT, "  D_ID = 0;"
    FPRINT FP_OUTPUT, "  if (!lpDispatch) return -1;"
    FPRINT FP_OUTPUT, "  #ifdef __cplusplus"
    FPRINT FP_OUTPUT, "    COM_last_HR = lpDispatch->GetIDsOfNames"
    FPRINT FP_OUTPUT, "                 (IID_NULL, &comsegment, 1, LOCALE_SYSTEM_DEFAULT, &D_ID);"
    FPRINT FP_OUTPUT, "  #else"
    FPRINT FP_OUTPUT, "    COM_last_HR = lpDispatch->lpVtbl->GetIDsOfNames"
    FPRINT FP_OUTPUT, "                 (lpDispatch, &IID_NULL, &comsegment, 1, LOCALE_SYSTEM_DEFAULT, &D_ID);"
    FPRINT FP_OUTPUT, "  #endif"
    FPRINT FP_OUTPUT, "  if (FAILED(COM_last_HR))"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("Unrecognized member name"), "));"
    FPRINT FP_OUTPUT, "    return -1;"
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "  return D_ID;"
    FPRINT FP_OUTPUT, "}\n\n"
    FPRINT FP_OUTPUT, "void COM_invoke (OBJECT *object, PWSTR comsegment, WORD wFlags, VARIANT *pvResult) {"
    FPRINT FP_OUTPUT, "  if (!object->pStatus) return;"
    FPRINT FP_OUTPUT, "  if (COM_BCX_ERROR) return;"
    FPRINT FP_OUTPUT, "  DISPID lv_DID;"
    FPRINT FP_OUTPUT, "  EXCEPINFO exception;"
    FPRINT FP_OUTPUT, "  UINT argerr = 0;"
    FPRINT FP_OUTPUT, "  DISPPARAMS dp = {NULL, NULL, 0, 0 };"
    FPRINT FP_OUTPUT, "  WORD invoke_flags = 0;"
    FPRINT FP_OUTPUT, "  DISPID setdispid = DISPID_PROPERTYPUT;"

    IF COM_build_trace_code THEN
        FPRINT FP_OUTPUT, "  char extra_error_info[BCXSTRSIZE];"
    END IF

    FPRINT FP_OUTPUT, "  if (COM_GetEnum_iface)"
    FPRINT FP_OUTPUT, "    lv_DID = DISPID_NEWENUM;"
    FPRINT FP_OUTPUT, "  else"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    lv_DID = COM_get_dispatch_ID (object->pObjects[object->ipointer].pdispVal, comsegment);"
    FPRINT FP_OUTPUT, "    if (-1 == lv_DID) goto cleanInProp;"
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "  memset (&exception, 0, sizeof(EXCEPINFO));"
    FPRINT FP_OUTPUT, "  if (COM_plist_index>0)"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    setdispid = DISPID_PROPERTYPUT;"
    FPRINT FP_OUTPUT, "    dp.rgvarg = (VARIANTARG*)COM_PARAMS;"
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "  if (wFlags & DISPATCH_PROPERTYPUT)"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    dp.rgdispidNamedArgs = &setdispid;"
    FPRINT FP_OUTPUT, "    dp.cNamedArgs = 1;"
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "  dp.cArgs = COM_plist_index;"
    FPRINT FP_OUTPUT, "  invoke_flags = wFlags;"
    FPRINT FP_OUTPUT, "  if (wFlags & DISPATCH_PROPERTYGET)"
    FPRINT FP_OUTPUT, "    if (pvResult) VariantInit(pvResult);"

    IF COM_build_trace_code  THEN
        FPRINT FP_OUTPUT, "  COM_trace_dump_DISPPARAMS(&dp);"
        FPRINT FP_OUTPUT, "  COM_trace_dump_flags(wFlags);"
        FPRINT FP_OUTPUT, "  COM_trace_dump_indicators(object);"
    END IF

    FPRINT FP_OUTPUT, "  if (VT_DISPATCH!=object->pObjects[object->ipointer].vt||NULL==object->pObjects[object->ipointer].pdispVal)"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "     COM_last_HR = E_NOINTERFACE;"
    FPRINT FP_OUTPUT, "     COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("COM_invoke::Invalid IDispatch interface."), "));"
    FPRINT FP_OUTPUT, "     goto cleanInProp;"
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "    #ifdef __cplusplus"
    FPRINT FP_OUTPUT, "    COM_last_HR = object->pObjects[object->ipointer].pdispVal"
    FPRINT FP_OUTPUT, "      ->Invoke (lv_DID, IID_NULL, LOCALE_SYSTEM_DEFAULT, "
    FPRINT FP_OUTPUT, "        invoke_flags, &dp, pvResult, &exception, &argerr);"
    FPRINT FP_OUTPUT, "    #else"
    FPRINT FP_OUTPUT, "    COM_last_HR = object->pObjects[object->ipointer].pdispVal->lpVtbl"
    FPRINT FP_OUTPUT, "      ->Invoke(object->pObjects[object->ipointer].pdispVal, lv_DID, &IID_NULL, "
    FPRINT FP_OUTPUT, "        LOCALE_SYSTEM_DEFAULT, invoke_flags , &dp, pvResult, &exception, &argerr);"
    FPRINT FP_OUTPUT, "    #endif"
    FPRINT FP_OUTPUT, "  if (FAILED(COM_last_HR))"
    FPRINT FP_OUTPUT, "  {"

    IF COM_build_trace_code  THEN
        FPRINT FP_OUTPUT, "  COM_trace_add_line(", ENC$("Invoke FAILED!"), ");"
    END IF

    FPRINT FP_OUTPUT, "    COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("COM_invoke::Invoke failed."), "));"
    FPRINT FP_OUTPUT, "    COM_build_except_info (COM_last_HR, &exception, argerr);"
    FPRINT FP_OUTPUT, "  }"

    IF COM_build_trace_code  THEN
        FPRINT FP_OUTPUT, "  else "
        FPRINT FP_OUTPUT, "  {"
        FPRINT FP_OUTPUT, "    COM_add_trace_line (", ENC$("Invoke SUCEEDED!"), ");"
        FPRINT FP_OUTPUT, "    if(wFlags & DISPATCH_PROPERTYGET)"
        FPRINT FP_OUTPUT, "    {"
        FPRINT FP_OUTPUT, "      sprintf (extra_error_info,", ENC$("result Variant type = %d"), ",pvResult->vt);"
        FPRINT FP_OUTPUT, "      COM_add_trace_line (extra_error_info);"
        FPRINT FP_OUTPUT, "    }"
        FPRINT FP_OUTPUT, "  }"
    END IF

    FPRINT FP_OUTPUT, "cleanInProp:"
    FPRINT FP_OUTPUT, "  if (V_ISARRAY(&COM_PARAMS[0]))"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    if ((VT_ARRAY|VT_VARIANT)==COM_PARAMS[0].vt)"
    FPRINT FP_OUTPUT, "    {"
    FPRINT FP_OUTPUT, "      COM_last_HR = SafeArrayDestroy(V_ARRAY(&COM_PARAMS[0]));"
    FPRINT FP_OUTPUT, "      if (FAILED (COM_last_HR))"
    FPRINT FP_OUTPUT, "      {"
    FPRINT FP_OUTPUT, "        lstrcpy(COM_ErrMsg, _T(", ENC$("SafeArrayDestroy failed"), "));"
    FPRINT FP_OUTPUT, "        COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("Error wiping param list."), "));"
    FPRINT FP_OUTPUT, "      }"
    FPRINT FP_OUTPUT, "      ZeroMemory((PVOID)&COM_PARAMS[0],sizeof(VARIANT));"
    FPRINT FP_OUTPUT, "      COM_PTR_safearray = NULL;"
    FPRINT FP_OUTPUT, "      COM_plist_index = 0;"
    FPRINT FP_OUTPUT, "    }"
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "  if (COM_plist_index)  COM_clean_plist();"
    FPRINT FP_OUTPUT, "  if (0 == COM_reset_chain)  COM_reset_disp_chain(object);"
    FPRINT FP_OUTPUT, "}\n\n"
END SUB ' Emit_COM_StandardSet



SUB Emit_COM_GetObject (FP_OUTPUT AS FILE)
    ' TCHAR is used to support UNICODE versions of programs
    FPRINT FP_OUTPUT, "void BCX_GetObject (_TCHAR *objname, OBJECT *obj) {"
    FPRINT FP_OUTPUT, "  if (!COM_ole_initd) COM_ole_initialize();"
    FPRINT FP_OUTPUT, "  CLSID clsid;"
    FPRINT FP_OUTPUT, "  #ifndef UNICODE"
    FPRINT FP_OUTPUT, "    COM_last_HR = COM_AS2WS (objname);"
    FPRINT FP_OUTPUT, "    if (FAILED(COM_last_HR))"
    FPRINT FP_OUTPUT, "    {"
    FPRINT FP_OUTPUT, "      COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("CreateObject Failed! A2W failure!"), "));"
    FPRINT FP_OUTPUT, "      return;"
    FPRINT FP_OUTPUT, "    }"
    FPRINT FP_OUTPUT, "    COM_last_HR = COM_WS2AS (COM_LPWSTR_temp);"
    FPRINT FP_OUTPUT, "    if (FAILED (COM_last_HR))"
    FPRINT FP_OUTPUT, "    {"
    FPRINT FP_OUTPUT, "      COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("CreateObject Failed! W2A failure!"), "));"
    FPRINT FP_OUTPUT, "      return;"
    FPRINT FP_OUTPUT, "    }"
    FPRINT FP_OUTPUT, "    sprintf (COM_ErrMsg,", ENC$("%s, WideName(%s)"), ", objname, COM_psz_tmp);"
    FPRINT FP_OUTPUT, "    COM_last_HR = CLSIDFromProgID((LPCOLESTR)COM_LPWSTR_temp, (LPCLSID)&clsid);"
    FPRINT FP_OUTPUT, "  #else"
    FPRINT FP_OUTPUT, "    COM_last_HR = COM_WS2AS ((LPCWSTR)objname);"
    FPRINT FP_OUTPUT, "    lstrcpy (COM_ErrMsg, COM_psz_tmp);"
    FPRINT FP_OUTPUT, "    COM_last_HR = CLSIDFromProgID ((LPCOLESTR)objname, (LPCLSID)&clsid);"
    FPRINT FP_OUTPUT, "  #endif"
    FPRINT FP_OUTPUT, "  if (FAILED (COM_last_HR))"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "  #ifndef UNICODE"
    FPRINT FP_OUTPUT, "    BCX_GetObjectMon ((LPCOLESTR)COM_LPWSTR_temp, obj);"
    FPRINT FP_OUTPUT, "  #else"
    FPRINT FP_OUTPUT, "    BCX_GetObjectMon ((LPCOLESTR)objname, obj);"
    FPRINT FP_OUTPUT, "  #endif"
    FPRINT FP_OUTPUT, "    return;"
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "  #ifdef __cplusplus"
    FPRINT FP_OUTPUT, "    COM_last_HR = GetActiveObject((REFCLSID)clsid, NULL, (IUnknown**)&obj->p_unknown);"
    FPRINT FP_OUTPUT, "  #else"
    FPRINT FP_OUTPUT, "    COM_last_HR = GetActiveObject((REFCLSID)&clsid, NULL, (IUnknown**)&obj->p_unknown);"
    FPRINT FP_OUTPUT, "  #endif"
    FPRINT FP_OUTPUT, "  if (FAILED (COM_last_HR))"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("GetActiveObject failed!"), "));"
    FPRINT FP_OUTPUT, "    return;"
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "  else"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    VariantInit (&obj->pObjects[0]);"
    FPRINT FP_OUTPUT, "    #ifdef __cplusplus"
    FPRINT FP_OUTPUT, "      COM_last_HR = obj->p_unknown"
    FPRINT FP_OUTPUT, "      ->QueryInterface(IID_IDispatch, (void**)&obj->pObjects[0].pdispVal);"
    FPRINT FP_OUTPUT, "    #else"
    FPRINT FP_OUTPUT, "      COM_last_HR = obj->p_unknown->lpVtbl"
    FPRINT FP_OUTPUT, "      ->QueryInterface(obj->p_unknown, &IID_IDispatch, (void **)&obj->pObjects[0].pdispVal);"
    FPRINT FP_OUTPUT, "    #endif"
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "  if (FAILED (COM_last_HR))"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("QueryInterface::IID_IDispatch  failed!"), "));"
    FPRINT FP_OUTPUT, "    if (obj->p_unknown)"
    FPRINT FP_OUTPUT, "    {"
    FPRINT FP_OUTPUT, "    #ifdef __cplusplus"
    FPRINT FP_OUTPUT, "      obj->p_unknown->Release();"
    FPRINT FP_OUTPUT, "    #else"
    FPRINT FP_OUTPUT, "      obj->p_unknown->lpVtbl->Release(obj->p_unknown);"
    FPRINT FP_OUTPUT, "    #endif"
    FPRINT FP_OUTPUT, "    }"
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "  else"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    obj->pObjects[0].vt = VT_DISPATCH;"
    FPRINT FP_OUTPUT, "    obj->pStatus = TRUE;"
    FPRINT FP_OUTPUT, "    obj->ipointer = 0;"
    FPRINT FP_OUTPUT, "    COM_objects_cnt++;"
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "}\n\n"
    FPRINT FP_OUTPUT, "void BCX_GetObjectMon (LPCOLESTR objname, OBJECT *obj) {"
    FPRINT FP_OUTPUT, "  IBindCtx* vBindCtx = NULL;"                  ' Bind context to be used
    FPRINT FP_OUTPUT, "  IMoniker* vMoniker = NULL;"                  ' Receives moniker built from display name
    FPRINT FP_OUTPUT, "  ULONG vChEaten = 0;"                         ' Receives number of characters consumed
    FPRINT FP_OUTPUT, "  COM_last_HR = CreateBindCtx(0, &vBindCtx);"  ' Receives the pointer to the bind context
    FPRINT FP_OUTPUT, "  if (COM_last_HR != S_OK)"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("GetObject: CreateBindCtx failed!"), "));"
    FPRINT FP_OUTPUT, "    return;"                                   ' no interfaces, so it may return.
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "  COM_last_HR = MkParseDisplayName(vBindCtx, objname, &vChEaten, &vMoniker);"
    FPRINT FP_OUTPUT, "  if (COM_last_HR != S_OK)"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("GetObject: Receive Moniker failed!"), "));"
    FPRINT FP_OUTPUT, "    goto CleanGetObjectMon;"                   ' clean all and then exit.
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "  VariantInit(&obj->pObjects[0]);"
    FPRINT FP_OUTPUT, "  #ifdef __cplusplus"
    FPRINT FP_OUTPUT, "    COM_last_HR = vMoniker->BindToObject(vBindCtx, NULL, IID_IDispatch, "
    FPRINT FP_OUTPUT, "                                        (void **)&obj->pObjects[0].pdispVal);"
    FPRINT FP_OUTPUT, "  #else"
    FPRINT FP_OUTPUT, "    COM_last_HR = vMoniker->lpVtbl->BindToObject(vMoniker, vBindCtx, NULL, &IID_IDispatch,"
    FPRINT FP_OUTPUT, "                                                (void **)&obj->pObjects[0].pdispVal);"
    FPRINT FP_OUTPUT, "  #endif"
    FPRINT FP_OUTPUT, "  if (COM_last_HR != S_OK)"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("GetObject: Moniker BindToObject failed!"), "));"
    FPRINT FP_OUTPUT, "    goto CleanGetObjectMon;"                   ' clean all and then exit.
    FPRINT FP_OUTPUT, "  }"                                           ' we have IDispatch, set the flags then object is ready to use
    FPRINT FP_OUTPUT, "  obj->p_unknown = NULL;"                      ' doesn't get IUnknown this way
    FPRINT FP_OUTPUT, "  obj->pObjects[0].vt = VT_DISPATCH;"
    FPRINT FP_OUTPUT, "  obj->pStatus = TRUE;"
    FPRINT FP_OUTPUT, "  obj->ipointer = 0;"
    FPRINT FP_OUTPUT, "  COM_objects_cnt++;"
    FPRINT FP_OUTPUT, "CleanGetObjectMon:"
    FPRINT FP_OUTPUT, "  #ifdef __cplusplus"
    FPRINT FP_OUTPUT, "    if (vMoniker) vMoniker->Release();"
    FPRINT FP_OUTPUT, "    if (vBindCtx) vBindCtx->Release();"
    FPRINT FP_OUTPUT, "  #else"
    FPRINT FP_OUTPUT, "    if (vMoniker) vMoniker->lpVtbl->Release (vMoniker);"
    FPRINT FP_OUTPUT, "    if (vBindCtx) vBindCtx->lpVtbl->Release (vBindCtx);"
    FPRINT FP_OUTPUT, "  #endif"
    FPRINT FP_OUTPUT, "}\n\n"
END SUB ' Emit_COM_GetObject



SUB Emit_COM_DispatchObject (FP_OUTPUT AS FILE)
    FPRINT FP_OUTPUT, "void BCX_DispatchObject(IUnknown *iobj, OBJECT *obj, BOOL b_release) {"
    FPRINT FP_OUTPUT, "  if (!obj) return;"
    FPRINT FP_OUTPUT, "  static ULONG inc_inf_ussage=0;"
    FPRINT FP_OUTPUT, "  if (!COM_ole_initd) COM_ole_initialize();"
    FPRINT FP_OUTPUT, "  obj->p_unknown = iobj;"

    ' Now, we are going to increment IUnknown usage, so that parameter iobj can be released.

    FPRINT FP_OUTPUT, "  #ifdef __cplusplus"
    FPRINT FP_OUTPUT, "    inc_inf_ussage = obj->p_unknown->AddRef();"
    FPRINT FP_OUTPUT, "  #else"
    FPRINT FP_OUTPUT, "    inc_inf_ussage = obj->p_unknown->lpVtbl->AddRef(obj->p_unknown);"
    FPRINT FP_OUTPUT, "  #endif"
    FPRINT FP_OUTPUT, "  VariantInit(&obj->pObjects[0]);"
    FPRINT FP_OUTPUT, "  #ifdef __cplusplus"
    FPRINT FP_OUTPUT, "    COM_last_HR = obj->p_unknown"
    FPRINT FP_OUTPUT, "    ->QueryInterface(IID_IDispatch, (void**)&obj->pObjects[0].pdispVal);"
    FPRINT FP_OUTPUT, "  #else"
    FPRINT FP_OUTPUT, "    COM_last_HR = obj->p_unknown->lpVtbl"
    FPRINT FP_OUTPUT, "    ->QueryInterface(obj->p_unknown, &IID_IDispatch,"
    FPRINT FP_OUTPUT, "     (void**)&obj->pObjects[0].pdispVal);"
    FPRINT FP_OUTPUT, "  #endif"
    FPRINT FP_OUTPUT, "  if (FAILED (COM_last_HR))"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("QueryInterface::IID_IDispatch  failed!"), "));"
    FPRINT FP_OUTPUT, "  #ifdef __cplusplus"
    FPRINT FP_OUTPUT, "      obj->p_unknown->Release();"
    FPRINT FP_OUTPUT, "  #else"
    FPRINT FP_OUTPUT, "      obj->p_unknown->lpVtbl->Release(obj->p_unknown);"
    FPRINT FP_OUTPUT, "  #endif"
    FPRINT FP_OUTPUT, "    return;"
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "  if (b_release)"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "  #ifdef __cplusplus"
    FPRINT FP_OUTPUT, "     iobj->Release();"
    FPRINT FP_OUTPUT, "  #else"
    FPRINT FP_OUTPUT, "     iobj->lpVtbl->Release(obj->p_unknown);"
    FPRINT FP_OUTPUT, "  #endif"
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "  obj->pObjects[0].vt = VT_DISPATCH;"
    FPRINT FP_OUTPUT, "  obj->pStatus = TRUE;"
    FPRINT FP_OUTPUT, "  obj->ipointer = 0;"
    FPRINT FP_OUTPUT, "  COM_objects_cnt++;"
    FPRINT FP_OUTPUT, "}\n\n"
END SUB ' Emit_COM_DispatchObject



SUB Emit_COM_GetProperty (FP_OUTPUT AS FILE)
    UNREFERENCED_PARAMETER(FP_OUTPUT)
END SUB ' Emit_COM_GetProperty



SUB Emit_COM_SetProperty (FP_OUTPUT AS FILE)
    UNREFERENCED_PARAMETER(FP_OUTPUT)
END SUB ' Emit_COM_SetProperty



SUB Emit_COM_InvokeMethod (FP_OUTPUT AS FILE)
    UNREFERENCED_PARAMETER(FP_OUTPUT)
END SUB ' Emit_COM_InvokeMethod



SUB Emit_COM_SafeArray (FP_OUTPUT AS FILE)
    FPRINT FP_OUTPUT, "void COM_create_safearray(void) {"
    FPRINT FP_OUTPUT, "  long lv_param_incr = 0;"
    FPRINT FP_OUTPUT, "  long lv_param_incr_rev = 0;"
    FPRINT FP_OUTPUT, "  HRESULT hr = NO_ERROR;"
    FPRINT FP_OUTPUT, "  COM_PTR_safearray = "
    FPRINT FP_OUTPUT, "  SafeArrayCreateVector (VT_VARIANT,0,COM_plist_index);"
    FPRINT FP_OUTPUT, "  if (COM_PTR_safearray == NULL)"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    COM_clean_plist();"
    FPRINT FP_OUTPUT, "    COM_last_HR = E_OUTOFMEMORY;"
    FPRINT FP_OUTPUT, "    COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("SafeArrayCreate failed."), "));"
    FPRINT FP_OUTPUT, "    return;"
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "  for (lv_param_incr = COM_plist_index-1; lv_param_incr>=0; lv_param_incr-=1)"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    hr = SafeArrayPutElement (COM_PTR_safearray,"
    FPRINT FP_OUTPUT, "    &lv_param_incr, &COM_PARAMS[lv_param_incr_rev]);"
    FPRINT FP_OUTPUT, "    if (FAILED(hr))"
    FPRINT FP_OUTPUT, "    {"
    FPRINT FP_OUTPUT, "      wsprintf(COM_ErrMsg, _T(", ENC$("Param Index = %d."), "),lv_param_incr);"
    FPRINT FP_OUTPUT, "      if (COM_PTR_safearray) SafeArrayDestroy (COM_PTR_safearray);"
    FPRINT FP_OUTPUT, "      COM_PTR_safearray = NULL;"
    FPRINT FP_OUTPUT, "      COM_clean_plist();"
    FPRINT FP_OUTPUT, "      COM_last_HR = hr;"
    FPRINT FP_OUTPUT, "      COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("SafeArrayPutElement failed!"), "));"
    FPRINT FP_OUTPUT, "      return;"
    FPRINT FP_OUTPUT, "    }"
    FPRINT FP_OUTPUT, "    lv_param_incr_rev++;"
    FPRINT FP_OUTPUT, "  }"

    IF COM_build_trace_code THEN
        FPRINT FP_OUTPUT, "  COM_add_trace_line(", ENC$("SafeArray created. Cleaning temp variants...") , ");"
    END IF

    FPRINT FP_OUTPUT, "  COM_clean_plist();"
    FPRINT FP_OUTPUT, "  if(COM_PTR_safearray)"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "     VariantInit (&COM_PARAMS[0]);"
    FPRINT FP_OUTPUT, "     COM_PARAMS[0].vt = VT_ARRAY|VT_VARIANT;"
    FPRINT FP_OUTPUT, "     V_ARRAY (&COM_PARAMS[0]) = COM_PTR_safearray;"
    FPRINT FP_OUTPUT, "     COM_plist_index = 1;"
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "}\n\n"
END SUB ' Emit_COM_SafeArray



SUB Emit_COM_UsesConversion (FP_OUTPUT AS FILE)
    FPRINT FP_OUTPUT, "HRESULT COM_WS2AS(LPCWSTR wide_string, UINT code_page) {"
    FPRINT FP_OUTPUT, "  if (wide_string==NULL) return (HRESULT) NO_ERROR;"
    FPRINT FP_OUTPUT, "  ULONG bytes_copied=0;"
    FPRINT FP_OUTPUT, "  ULONG temp_ansi_len = (ULONG)WideCharToMultiByte ("
    FPRINT FP_OUTPUT, "  code_page,0,wide_string,-1,COM_psz_tmp,0,NULL,NULL);"
    FPRINT FP_OUTPUT, "  if (temp_ansi_len == 0) return (HRESULT) NO_ERROR;"
    FPRINT FP_OUTPUT, "  if (COM_zstr_size < temp_ansi_len)"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    if (COM_psz_tmp) free(COM_psz_tmp);"
    FPRINT FP_OUTPUT, "    COM_psz_tmp = (char*)calloc(temp_ansi_len+1,sizeof(char));"
    FPRINT FP_OUTPUT, "    if (NULL == COM_psz_tmp)"
    FPRINT FP_OUTPUT, "    {"
    FPRINT FP_OUTPUT, "      COM_zstr_size = 0;"
    FPRINT FP_OUTPUT, "      return E_OUTOFMEMORY;"
    FPRINT FP_OUTPUT, "    } "
    FPRINT FP_OUTPUT, "    COM_zstr_size = temp_ansi_len;"
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "  if ((bytes_copied = WideCharToMultiByte(code_page, 0, wide_string, -1,"
    FPRINT FP_OUTPUT, "       COM_psz_tmp, temp_ansi_len,NULL, NULL))==0)"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    return HRESULT_FROM_WIN32 (GetLastError());"
    FPRINT FP_OUTPUT, "  } "
    FPRINT FP_OUTPUT, "  COM_psz_tmp [bytes_copied] = '\\0';"
    FPRINT FP_OUTPUT, "  return (HRESULT)NO_ERROR;"
    FPRINT FP_OUTPUT, "}\n\n"
    FPRINT FP_OUTPUT, "HRESULT COM_AS2WS(LPCSTR ansi_string, UINT code_page) {"
    FPRINT FP_OUTPUT, "  if (!*ansi_string) return (HRESULT)NO_ERROR;"
    FPRINT FP_OUTPUT, "  ULONG ansi_str_len = (ULONG)strlen (ansi_string);"
    FPRINT FP_OUTPUT, "  if (!ansi_str_len) return (HRESULT)NO_ERROR;"
    FPRINT FP_OUTPUT, "  ULONG wide_str_len = (ansi_str_len * 2);"
    FPRINT FP_OUTPUT, "  if (COM_wstr_size < wide_str_len)"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    if (COM_LPWSTR_temp)"
    FPRINT FP_OUTPUT, "       CoTaskMemFree((void*)COM_LPWSTR_temp);"
    FPRINT FP_OUTPUT, "    COM_LPWSTR_temp = (PWSTR)CoTaskMemAlloc (wide_str_len);"
    FPRINT FP_OUTPUT, "    if (NULL == COM_LPWSTR_temp)"
    FPRINT FP_OUTPUT, "    {"
    FPRINT FP_OUTPUT, "      COM_wstr_size = 0;"
    FPRINT FP_OUTPUT, "      return E_OUTOFMEMORY;"
    FPRINT FP_OUTPUT, "    } "
    FPRINT FP_OUTPUT, "    COM_wstr_size = wide_str_len;"
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "  if (MultiByteToWideChar (code_page, MB_PRECOMPOSED, ansi_string, "
    FPRINT FP_OUTPUT, "      ansi_str_len, COM_LPWSTR_temp, wide_str_len)==0)"
    FPRINT FP_OUTPUT, "         return HRESULT_FROM_WIN32(GetLastError());"
    FPRINT FP_OUTPUT, "  COM_LPWSTR_temp[ansi_str_len] = L'\\0';"
    FPRINT FP_OUTPUT, "  return (HRESULT)NO_ERROR;"
    FPRINT FP_OUTPUT, "}\n\n"
    FPRINT FP_OUTPUT, "void COM_FREE_TEMP_WIDE_STRING(void) {"
    FPRINT FP_OUTPUT, "  if (COM_LPWSTR_temp)"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    CoTaskMemFree ((void*)COM_LPWSTR_temp);"
    FPRINT FP_OUTPUT, "    COM_LPWSTR_temp = NULL;"
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "}\n\n"
    FPRINT FP_OUTPUT, "void COM_FREE_TEMP_ANSI_STRING (void) {"
    FPRINT FP_OUTPUT, "  if (COM_psz_tmp)"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    free (COM_psz_tmp);"
    FPRINT FP_OUTPUT, "    COM_psz_tmp = NULL;"
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "}"
END SUB ' Emit_COM_UsesConversion



SUB Emit_COM_TraceCalls (FP_OUTPUT AS FILE)
    FPRINT FP_OUTPUT, "void bcx_com_trace_dump_DISPPARAMS(DISPPARAMS* dp) {"
    FPRINT FP_OUTPUT, "  COM_add_trace_line(", ENC$("   --- BEGIN DUMP OF DISPPARAMS  ---"), ");"
    FPRINT FP_OUTPUT, "  if (!dp)"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    COM_add_trace_line(", ENC$("*** bcx_com_trace_dump_DISPPARAMS failed!"), ");"
    FPRINT FP_OUTPUT, "    COM_add_trace_line(", ENC$("*** NULL argument received for DISPPARAMS* dp"), ");"
    FPRINT FP_OUTPUT, "    COM_add_trace_line(", ENC$("   --- END DUMP OF DISPPARAMS ---"), ");"
    FPRINT FP_OUTPUT, "    return;"
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "  wsprintf(COM_trace_line, ", ENC$("     DISPPARAMS.rgvarg = %lu  // pointer to array of arguments."), ", dp->rgvarg);"
    FPRINT FP_OUTPUT, "  COM_add_trace_line(COM_trace_line);"
    FPRINT FP_OUTPUT, "  wsprintf(COM_trace_line, ", ENC$("     DISPPARAMS.rgdispidNamedArgs = %lu // pointer to array of Dispatch IDs of named arguments."), ", dp->rgdispidNamedArgs);"
    FPRINT FP_OUTPUT, "  COM_add_trace_line(COM_trace_line);"
    FPRINT FP_OUTPUT, "  wsprintf(COM_trace_line, ", ENC$("     DISPPARAMS.cArgs = %d // Number of arguments."), ", dp->cArgs);"
    FPRINT FP_OUTPUT, "  COM_add_trace_line(COM_trace_line);"
    FPRINT FP_OUTPUT, "  wsprintf(COM_trace_line, ", ENC$("     DISPPARAMS.cNamedArgs = %d  // Number of named arguments"), ", dp->cNamedArgs);"
    FPRINT FP_OUTPUT, "  COM_add_trace_line(COM_trace_line);"
    FPRINT FP_OUTPUT, "  COM_add_trace_line(", ENC$("   --- END DUMP OF DISPPARAMS ---"), ");"
    FPRINT FP_OUTPUT, "}\n\n"
    FPRINT FP_OUTPUT, "void bcx_com_trace_dump_indicators(OBJECT *object) {"
    FPRINT FP_OUTPUT, "  COM_add_trace_line(", ENC$("*** start dump of global vars ***"), ");"
    FPRINT FP_OUTPUT, "  if (object->pStatus)"
    FPRINT FP_OUTPUT, "     strcpy(COM_trace_line, ", ENC$("   Object status - Initialized"), ");"
    FPRINT FP_OUTPUT, "  else"
    FPRINT FP_OUTPUT, "     strcpy(COM_trace_line, ", ENC$("   Object status - UnInitialized"), ");"
    FPRINT FP_OUTPUT, "  COM_add_trace_line(COM_trace_line);"
    FPRINT FP_OUTPUT, "  wsprintf(COM_trace_line, ", ENC$("   dispatch chain index = %d"), ", object->ipointer);"
    FPRINT FP_OUTPUT, "  COM_add_trace_line(COM_trace_line);"
    FPRINT FP_OUTPUT, "  wsprintf(COM_trace_line, ", ENC$("   Count of params = %d"), ", COM_plist_index);"
    FPRINT FP_OUTPUT, "  COM_add_trace_line(COM_trace_line);"
    FPRINT FP_OUTPUT, "  wsprintf(COM_trace_line, ", ENC$("   COM_ole_initd = %d"), ", COM_ole_initd);"
    FPRINT FP_OUTPUT, "  COM_add_trace_line(COM_trace_line);"
    FPRINT FP_OUTPUT, "  wsprintf(COM_trace_line, ", ENC$("   COM_objects_cnt = %d"), ", COM_objects_cnt);"
    FPRINT FP_OUTPUT, "  COM_add_trace_line(COM_trace_line);"
    FPRINT FP_OUTPUT, "  wsprintf(COM_trace_line, ", ENC$("   don't reset dispatch chain afer invoke = %d"), ", COM_reset_chain);"
    FPRINT FP_OUTPUT, "  COM_add_trace_line(COM_trace_line);"
    FPRINT FP_OUTPUT, "  COM_add_trace_line(", ENC$("*** end dump of global vars ***"), ");"
    FPRINT FP_OUTPUT, "}\n\n"
    FPRINT FP_OUTPUT, "void bcx_com_trace_dump_flags(WORD wFlags) {"
    FPRINT FP_OUTPUT, "  wsprintf(COM_trace_line, ", ENC$("calling invoke with flags: "), ");"
    FPRINT FP_OUTPUT, "  if(wFlags & DISPATCH_PROPERTYPUT) strcat(COM_trace_line,", ENC$("| DISPATCH_PROPERTYPUT "), ");"
    FPRINT FP_OUTPUT, "  if(wFlags & DISPATCH_PROPERTYGET) strcat(COM_trace_line,", ENC$("| DISPATCH_PROPERTYGET "), ");"
    FPRINT FP_OUTPUT, "  if(wFlags & DISPATCH_PROPERTYPUTREF) strcat(COM_trace_line,", ENC$("| DISPATCH_PROPERTYPUTREF "), ");"
    FPRINT FP_OUTPUT, "  if(wFlags & DISPATCH_METHOD) strcat(COM_trace_line,", ENC$("| DISPATCH_METHOD "), ");"
    FPRINT FP_OUTPUT, "  COM_add_trace_line(COM_trace_line);"
    FPRINT FP_OUTPUT, "}\n\n"
    FPRINT FP_OUTPUT, "void COM_add_trace_line(LPCTSTR trcline) {"
    FPRINT FP_OUTPUT, "  static FILE *com_trc_file;"
    FPRINT FP_OUTPUT, "  if((com_trc_file=fopen(", ENC$("c:\\com_trace.txt"), ",", ENC$("a"), "))==0)"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    fprintf(stderr,", ENC$("Error: File access or File not found. c:\\com_trace.txt\\n"), ");"
    FPRINT FP_OUTPUT, "    exit(1);"
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "  fprintf(com_trc_file,", ENC$("%s\\n"), ", trcline);"
    FPRINT FP_OUTPUT, "  if (com_trc_file)"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    fflush(com_trc_file);"
    FPRINT FP_OUTPUT, "    fclose(com_trc_file);"
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "}\n\n"
END SUB ' Emit_COM_TraceCalls



SUB Emit_BCX_SafeArray (FP_OUTPUT AS FILE)
    FPRINT FP_OUTPUT, "HRESULT InitSafeArray (SAFEARRAY **ppsa, VARTYPE vtype, UINT ndim, ...) {"
    FPRINT FP_OUTPUT, "  int iCNT;"
    FPRINT FP_OUTPUT, "  int iDIM;"
    FPRINT FP_OUTPUT, "  va_list  marker;"
    FPRINT FP_OUTPUT, "  SAFEARRAYBOUND  tArraySize[10];"
    FPRINT FP_OUTPUT, "  va_start(marker,ndim);"
    FPRINT FP_OUTPUT, "  iCNT = 0;"
    FPRINT FP_OUTPUT, "  iDIM = ndim;"
    FPRINT FP_OUTPUT, "  while(iDIM--)"
    FPRINT FP_OUTPUT, "    {"
    FPRINT FP_OUTPUT, "      tArraySize[iCNT].lLbound = va_arg(marker,long);"
    FPRINT FP_OUTPUT, "      tArraySize[iCNT].cElements = va_arg(marker,long);"
    FPRINT FP_OUTPUT, "      iCNT++;"
    FPRINT FP_OUTPUT, "    }"
    FPRINT FP_OUTPUT, "  *ppsa = SafeArrayCreate (vtype,ndim,tArraySize);"
    FPRINT FP_OUTPUT, "  if(*ppsa == NULL)"
    FPRINT FP_OUTPUT, "      return E_OUTOFMEMORY;"
    FPRINT FP_OUTPUT, "  return S_OK;"
    FPRINT FP_OUTPUT, "}\n\n"
    FPRINT FP_OUTPUT, "HRESULT DestroySafeArray(SAFEARRAY *psA) {"
    FPRINT FP_OUTPUT, "  return SafeArrayDestroy(psA);"
    FPRINT FP_OUTPUT, "}\n"
END SUB ' Emit_BCX_SafeArray



SUB Emit_COM_CreateObject (FP_OUTPUT AS FILE)
    FPRINT FP_OUTPUT, "void BCX_CreateObject (_TCHAR *objname, OBJECT *obj) {"
    FPRINT FP_OUTPUT, "  if (!COM_ole_initd) COM_ole_initialize();"
    FPRINT FP_OUTPUT, "  CLSID clsid;"
    FPRINT FP_OUTPUT, "  #ifndef UNICODE"
    FPRINT FP_OUTPUT, "    COM_last_HR = COM_AS2WS(objname);"
    FPRINT FP_OUTPUT, "    if (FAILED(COM_last_HR))"
    FPRINT FP_OUTPUT, "    {"
    FPRINT FP_OUTPUT, "      COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("CreateObject Failed! A2W failure!"), "));"
    FPRINT FP_OUTPUT, "      return;"
    FPRINT FP_OUTPUT, "    }"
    FPRINT FP_OUTPUT, "    COM_last_HR = COM_WS2AS(COM_LPWSTR_temp);"
    FPRINT FP_OUTPUT, "    if (FAILED (COM_last_HR))"
    FPRINT FP_OUTPUT, "    {"
    FPRINT FP_OUTPUT, "       COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("CreateObject Failed! W2A failure!"), "));"
    FPRINT FP_OUTPUT, "      return;"
    FPRINT FP_OUTPUT, "    }"
    FPRINT FP_OUTPUT, "    sprintf(COM_ErrMsg,", ENC$("%s, WideName(%s)"), ", objname, COM_psz_tmp);"
    FPRINT FP_OUTPUT, "    COM_last_HR = CLSIDFromProgID ((LPCOLESTR)COM_LPWSTR_temp, (LPCLSID)&clsid);"
    FPRINT FP_OUTPUT, "  #else"
    FPRINT FP_OUTPUT, "    lstrcpy(COM_ErrMsg, objname);"
    FPRINT FP_OUTPUT, "    COM_last_HR = CLSIDFromProgID ((LPCOLESTR)objname, (LPCLSID)&clsid);"
    FPRINT FP_OUTPUT, "  #endif"
    FPRINT FP_OUTPUT, "  if (FAILED (COM_last_HR))"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("CLSIDFromProgID failed!"), "));"
    FPRINT FP_OUTPUT, "    return;"
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "  #ifdef __cplusplus"
    FPRINT FP_OUTPUT, "    COM_last_HR = CoCreateInstance((REFCLSID)clsid, NULL,  "
    FPRINT FP_OUTPUT, "    CLSCTX_INPROC_SERVER|CLSCTX_LOCAL_SERVER, IID_IUnknown, (void **)&obj->p_unknown);"
    FPRINT FP_OUTPUT, "  #else"
    FPRINT FP_OUTPUT, "    COM_last_HR = CoCreateInstance ((REFCLSID)&clsid, NULL, "
    FPRINT FP_OUTPUT, "    CLSCTX_INPROC_SERVER|CLSCTX_LOCAL_SERVER,&IID_IUnknown, (void **)&obj->p_unknown);"
    FPRINT FP_OUTPUT, "  #endif"
    FPRINT FP_OUTPUT, "  if (FAILED (COM_last_HR))"
    FPRINT FP_OUTPUT, "     COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("CoCreateInstance failed!"), "));"
    FPRINT FP_OUTPUT, "  else"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    VariantInit(&obj->pObjects[0]);"
    FPRINT FP_OUTPUT, "    obj->pObjects[0].vt = VT_DISPATCH;"
    FPRINT FP_OUTPUT, "  #ifdef __cplusplus"
    FPRINT FP_OUTPUT, "    COM_last_HR = obj->p_unknown"
    FPRINT FP_OUTPUT, "    ->QueryInterface(IID_IDispatch, (void **)&obj->pObjects[0].pdispVal);"
    FPRINT FP_OUTPUT, "  #else"
    FPRINT FP_OUTPUT, "    COM_last_HR = obj->p_unknown->lpVtbl"
    FPRINT FP_OUTPUT, "    ->QueryInterface(obj->p_unknown, &IID_IDispatch, (void**)&obj->pObjects[0].pdispVal);"
    FPRINT FP_OUTPUT, "  #endif"
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "  if (FAILED(COM_last_HR))"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    COM_HR_ErrMsg (COM_last_HR,_T(", ENC$("QueryInterface::IID_IDispatch  failed!"), "));"
    FPRINT FP_OUTPUT, "    obj->pObjects[0].vt = VT_NULL;"
    FPRINT FP_OUTPUT, "    VariantClear(&obj->pObjects[0]);"
    FPRINT FP_OUTPUT, "    #ifdef __cplusplus"
    FPRINT FP_OUTPUT, "       obj->p_unknown->Release();"
    FPRINT FP_OUTPUT, "    #else"
    FPRINT FP_OUTPUT, "       obj->p_unknown->lpVtbl->Release(obj->p_unknown);"
    FPRINT FP_OUTPUT, "    #endif"
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "  else"
    FPRINT FP_OUTPUT, "  {"
    FPRINT FP_OUTPUT, "    obj->pStatus = TRUE;"
    FPRINT FP_OUTPUT, "    obj->ipointer = 0;"
    FPRINT FP_OUTPUT, "    COM_objects_cnt++;"
    FPRINT FP_OUTPUT, "  }"
    FPRINT FP_OUTPUT, "}\n\n"
END SUB ' Emit_COM_CreateObject



SUB Emit_VBScript_Support
    DIM STATIC nTimes = 0
    IF nTimes > 0 THEN EXIT SUB
    INCR nTimes
    Use_AnsiToWide = Use_WideToAnsi = TRUE
    FPRINT FP_HDR, ""
    FPRINT FP_HDR, "// ****************************************"
    FPRINT FP_HDR, "// ***** ";$BCX_STR_VBS_STRUCTS;"  *****"
    FPRINT FP_HDR, "// ****************************************"
    FPRINT FP_HDR, ""
    FPRINT FP_HDR, "const GUID IID_IScriptControl ="
    FPRINT FP_HDR, "{"
    FPRINT FP_HDR, "   0x0e59f1d3,0x1fbe,0x11d0,"
    FPRINT FP_HDR, "  {0x8f,0xf2,0x00,0xa0,0xd1,0x00,0x38,0xbc}"
    FPRINT FP_HDR, "};"
    FPRINT FP_HDR, ""
    FPRINT FP_HDR, "enum ScriptControlStates"
    FPRINT FP_HDR, "{"
    FPRINT FP_HDR, "  SCRIPTSTATE_UNINITIALIZED0, SCRIPTSTATE_STARTED1, SCRIPTSTATE_CONNECTED2,"
    FPRINT FP_HDR, "  SCRIPTSTATE_DISCONNECTED3, SCRIPTSTATE_CLOSED4, SCRIPTSTATE_INITIALIZED5"
    FPRINT FP_HDR, "};"
    FPRINT FP_HDR, ""
    FPRINT FP_HDR, "const GUID IID_IScriptError ="
    FPRINT FP_HDR, "{"
    FPRINT FP_HDR, "   0x70841C78, 0x67D, 0x11D0,"
    FPRINT FP_HDR, "  {0x95, 0xD8, 0x0, 0xA0, 0x24, 0x63, 0xAB, 0x28}"
    FPRINT FP_HDR, "};"
    FPRINT FP_HDR, ""
    FPRINT FP_HDR, "// *******************************************************************"
    FPRINT FP_HDR, "#undef  INTERFACE"
    FPRINT FP_HDR, "#define INTERFACE IScriptError"
    FPRINT FP_HDR, "// *******************************************************************"
    FPRINT FP_HDR, "DECLARE_INTERFACE_(IScriptError, IDispatch) {"
    FPRINT FP_HDR, "STDMETHOD (QueryInterface)(THIS_ REFIID riid, PVOID *ppvObj) PURE;"
    FPRINT FP_HDR, "STDMETHOD_(ULONG, AddRef)(THIS)  PURE;"
    FPRINT FP_HDR, "STDMETHOD_(ULONG, Release)(THIS) PURE;"
    FPRINT FP_HDR, "STDMETHOD (GetTypeInfoCount)(THIS_ UINT *pctinfo) PURE;"
    FPRINT FP_HDR, "STDMETHOD (GetTypeInfo)(THIS_ UINT itinfo, LCID lcid,"
    FPRINT FP_HDR, "ITypeInfo **pptinfo) PURE;"
    FPRINT FP_HDR, "STDMETHOD (GetIDsOfNames)(THIS_ REFIID riid, OLECHAR **rgszNames,"
    FPRINT FP_HDR, "           UINT cNames, LCID lcid, DISPID *rgdispid) PURE;"
    FPRINT FP_HDR, "STDMETHOD (Invoke)(THIS_ DISPID dispidMember, REFIID riid, LCID lcid,"
    FPRINT FP_HDR, "           WORD wFlags, DISPPARAMS *pdispparams, VARIANT *pvarResult,"
    FPRINT FP_HDR, "           EXCEPINFO *pexcepinfo, UINT *puArgErr) PURE;"
    FPRINT FP_HDR, "STDMETHOD (Get_Number)(THIS_ long *pNumber) PURE;"
    FPRINT FP_HDR, "STDMETHOD (Get_Source)(THIS_ BSTR *pbstrSource) PURE;"
    FPRINT FP_HDR, "STDMETHOD (Get_Description)(THIS_ BSTR *pbstrDescription) PURE;"
    FPRINT FP_HDR, "STDMETHOD (Get_HelpFile)(THIS_ BSTR *pbstrHelpFile) PURE;"
    FPRINT FP_HDR, "STDMETHOD (Get_HelpContext)(THIS_ long *pHelpContext) PURE;"
    FPRINT FP_HDR, "STDMETHOD (Get_Text)(THIS_ BSTR *pbstrText) PURE;"
    FPRINT FP_HDR, "STDMETHOD (Get_Line)(THIS_ long *pLine) PURE;"
    FPRINT FP_HDR, "STDMETHOD (Get_Column)(THIS_ long *pColumn) PURE;"
    FPRINT FP_HDR, "STDMETHOD (Clear)(THIS) PURE;};"
    FPRINT FP_HDR, ""
    FPRINT FP_HDR, "// *******************************************************************"
    FPRINT FP_HDR, "#undef  INTERFACE"
    FPRINT FP_HDR, "#define INTERFACE IScriptControl"
    FPRINT FP_HDR, "// *******************************************************************"
    FPRINT FP_HDR, "DECLARE_INTERFACE_(IScriptControl, IDispatch) {"
    FPRINT FP_HDR, "STDMETHOD (QueryInterface)(THIS_ REFIID riid, PVOID *ppvObj) PURE;"
    FPRINT FP_HDR, "STDMETHOD_(ULONG, AddRef)(THIS)  PURE;"
    FPRINT FP_HDR, "STDMETHOD_(ULONG, Release)(THIS) PURE;"
    FPRINT FP_HDR, "STDMETHOD (GetTypeInfoCount)(THIS_ UINT *pctinfo) PURE;"
    FPRINT FP_HDR, "STDMETHOD (GetTypeInfo)(THIS_ UINT itinfo, LCID lcid,"
    FPRINT FP_HDR, "ITypeInfo  **pptinfo) PURE;"
    FPRINT FP_HDR, "STDMETHOD (GetIDsOfNames)(THIS_ REFIID riid, OLECHAR **rgszNames,"
    FPRINT FP_HDR, "           UINT cNames, LCID lcid, DISPID *rgdispid) PURE;"
    FPRINT FP_HDR, "STDMETHOD (Invoke)(THIS_ DISPID dispidMember, REFIID riid, LCID lcid,"
    FPRINT FP_HDR, "           WORD wFlags, DISPPARAMS *pdispparams, VARIANT *pvarResult,"
    FPRINT FP_HDR, "           EXCEPINFO *pexcepinfo, UINT *puArgErr) PURE;"
    FPRINT FP_HDR, "STDMETHOD (get_Language)(THIS_ BSTR* pbstrLanguage) PURE;"
    FPRINT FP_HDR, "STDMETHOD (put_Language)(THIS_ BSTR pbstrLanguage) PURE;"
    FPRINT FP_HDR, "STDMETHOD (get_State)(THIS_ enum ScriptControlStates* pssState) PURE;"
    FPRINT FP_HDR, "STDMETHOD (put_State)(THIS_ enum ScriptControlStates pssState) PURE;"
    FPRINT FP_HDR, "STDMETHOD (put_SitehWnd)(THIS_ long phwnd) PURE;"
    FPRINT FP_HDR, "STDMETHOD (get_SitehWnd)(THIS_ long* phwnd) PURE;"
    FPRINT FP_HDR, "STDMETHOD (get_Timeout)(THIS_ long* plMilliseconds) PURE;"
    FPRINT FP_HDR, "STDMETHOD (put_Timeout)(THIS_ long plMilliseconds) PURE;"
    FPRINT FP_HDR, "STDMETHOD (get_AllowUI)(THIS_ VARIANT_BOOL* pfAllowUI) PURE;"
    FPRINT FP_HDR, "STDMETHOD (put_AllowUI)(THIS_ VARIANT_BOOL pfAllowUI) PURE;"
    FPRINT FP_HDR, "STDMETHOD (get_UseSafeSubset)(THIS_ VARIANT_BOOL* pfUseSafeSubset) PURE;"
    FPRINT FP_HDR, "STDMETHOD (put_UseSafeSubset)(THIS_ VARIANT_BOOL pfUseSafeSubset) PURE;"
    FPRINT FP_HDR, "STDMETHOD (get_Modules)(THIS_ interface"
    FPRINT FP_HDR, "           IScriptModuleCollection** ppmods) PURE;"
    FPRINT FP_HDR, "STDMETHOD (get_Error)(THIS_ interface IScriptError** ppse) PURE;"
    FPRINT FP_HDR, "STDMETHOD (get_CodeObject)(THIS_ IDispatch** ppdispObject) PURE;"
    FPRINT FP_HDR, "STDMETHOD (get_Procedures)(THIS_ interface"
    FPRINT FP_HDR, "           IScriptProcedureCollection** ppdispProcedures) PURE;"
    FPRINT FP_HDR, "STDMETHOD (_AboutBox)(THIS) PURE;"
    FPRINT FP_HDR, "STDMETHOD (AddObject)(THIS_ BSTR Name, IDispatch* Object,"
    FPRINT FP_HDR, "           VARIANT_BOOL AddMembers) PURE;"
    FPRINT FP_HDR, "STDMETHOD (Reset)(THIS) PURE;"
    FPRINT FP_HDR, "STDMETHOD (AddCode)(THIS_ BSTR Code) PURE;"
    FPRINT FP_HDR, "STDMETHOD (Eval)(THIS_ BSTR Expression, VARIANT* pvarResult) PURE;"
    FPRINT FP_HDR, "STDMETHOD (ExecuteStatement)(THIS_ BSTR Statement) PURE;"
    FPRINT FP_HDR, "STDMETHOD (Run)(THIS_ BSTR ProcedureName, SAFEARRAY** Parameters,"
    FPRINT FP_HDR, "           VARIANT* pvarResult) PURE;};"
    FPRINT FP_HDR, ""

    IF Use_Project   THEN
        FPRINT FP_HDR, "BOOL OLE_ERROR_S;"
        FPRINT FP_HDR, "IScriptControl *pSC;"
    ELSE
        FPRINT FP_HDR, "static BOOL OLE_ERROR_S;"
        FPRINT FP_HDR, "static IScriptControl *pSC;"
    END IF

    AddLibrary("ole32.lib")
    AddLibrary("oleaut32.lib")
END SUB ' Emit_VBScript_Support





SUB Add_COM_Global_Variable (p_name$)
    '************************************************************************************************************
    ' Sub: Add_COM_Global_Variable (part of BCX COM parser)
    ' This sub adds OBJECT variable to global space, which is cleaned on program end.
    ' If the Global nnn an Object or Dim nnn as Object is called otside Functions ans Subs,
    ' than nnn will be added to global COM names space. This is used so that object variables could be identifed.
    '************************************************************************************************************
    IF LEN(p_name$) > 64 THEN Abort("Length of object variable " + p_name$ + " is:" + STR$(LEN(p_name$)) + ". Maximum allowed is 64 characters.")
    IF COM_gl_names_index = COM_Max_Gl_Objs THEN
        Abort("Max number of Global COM object variables reached:" + STR$(COM_Max_Gl_Objs) + CRLF$ + "Failed to reserve space for Object variable: " + p_name$)
        EXIT SUB
    END IF
    strcpy(COM_gl_names[COM_gl_names_free_index].com_VarName, p_name)
    COM_gl_names[COM_gl_names_free_index].initialized = TRUE
    INCR COM_gl_names_index
    COM_gl_names_free_index = COM_gl_names_index
END SUB ' Add_COM_Global_Variable




SUB Add_COM_Local_Variable (p_name$)
    '************************************************************************************************************
  