// *************************************************
//      Made with BCX BASIC To C/C++ Translator
//            Version 8.2.8 (08/29/2025)
// *************************************************
//    Translated for compiling with a C++ Compiler
// *************************************************

#ifndef __cplusplus
  #error A C++ compiler is required
#endif

#ifdef _MSC_VER
  #ifndef _CRT_SECURE_NO_WARNINGS
    #define _CRT_SECURE_NO_WARNINGS
  #endif
#endif

// Windows API headers
#include <windows.h>    // Core Windows API
#include <windowsx.h>   // Windows API macros and functions
#include <commctrl.h>   // Common Controls
#include <commdlg.h>    // Common Dialogs
#include <direct.h>     // Directory handling
#include <locale.h>     // Locale handling
#include <mmsystem.h>   // Multimedia
#include <oaidl.h>      // OLE Automation
#include <objbase.h>    // Component Object Model (COM)
#include <ocidl.h>      // OLE Control interfaces
#include <ole2.h>       // OLE 2.0 functionality
#include <oleauto.h>    // OLE Automation
#include <olectl.h>     // OLE Controls
#include <richedit.h>   // Rich Edit Control
#include <shellapi.h>   // Shell API
#include <shlobj.h>     // Shell Objects
#include <urlmon.h>     // URL Monikers
#include <wchar.h>      // Wide character support (also in ISO C)
#include <wctype.h>     // Wide character classification (also in ISO C)
#include <tchar.h>      // Unicode/ANSI character mapping
#include <unknwn.h>     // COM base interfaces
#include <wingdi.h>     // GDI
#include <wininet.h>    // Internet
#include <winsock.h>    // Windows Sockets
#include <winuser.h>    // User Interface

// ISO C Standard Library headers
#include <ctype.h>      // Character classification
#include <math.h>       // Mathematical functions
#include <setjmp.h>     // Non-local jumps
#include <stdarg.h>     // Variable arguments
#include <stddef.h>     // Common definitions
#include <stdio.h>      // Input/output
#include <stdlib.h>     // General utilities
#include <string.h>     // String handling
#include <time.h>       // Date and time
#include <errno.h>      // Error numbers (also POSIX)

// C99 Standard headers
#include <stdbool.h>    // Boolean type
#include <inttypes.h>   // Integer types

// POSIX headers
#include <fcntl.h>      // File control options

// Windows-specific headers
#include <process.h>    // Process control functions
#include <io.h>         // Low-level I/O (Windows POSIX subset)
#include <conio.h>      // Console I/O (Windows-specific)

// *************************************************
//            System Defined Macros
// *************************************************

#define BCXSTRSIZE 2048

// *************************************************
//             User Defined Macros
// *************************************************

#define __BCX__ TRUE
#define BCX_COLORS TRUE
#define BCXSTRINGS 2048
#define VERSION "8.2.8 (08/29/2025)"
#define BCX_STR_RUNTIME "Runtime Functions"
#define BCX_STR_VBS_STRUCTS "VBScript Support Structures"
#define BCX_STR_USR_CONST "User Defined Macros"
#define BCX_STR_SYS_CONST "System Defined Macros"
#define BCX_STR_STD_PROTOS "Standard Prototypes"
#define BCX_STR_SYS_VARS "System Variables"
#define BCX_STR_USR_VARS "User's Global Variables"
#define BCX_STR_STD_MACROS "Standard Macros"
#define BCX_STR_MAIN_PROG "Main Program"
#define BCX_STR_USR_PROCS "User's Subs and Functions"
#define BCX_STR_USR_PROTOS "User's Prototypes"
#define BCX_STR_USR_TYPES "User Defined Types And Unions"
#define IAm(X) ((X)!= 1)
#define IAmNot(X) ((X)== 0)
#define IDont(X) ((X)== 0)
#define GetAsPosF(S,E) GetAsPos((S),(E),(1))
#define GetAsPosB(S,E) GetAsPos((S),(E),(- 1))
#define iMatchLft(A,B) iMatch((A),(B),(0))
#define iMatchWrd(A,B) iMatch((A),(B),(1))
#define iMatchRgt(A,B) iMatch((A),(B),(2))
#define WordsInTable(A) (sizeof(A)/sizeof(A[ 0]))
#define GetBrkPairPos(S,E) GetBracketPair((S),(E),(1))
#define IVAL(A) atol((PCHAR)(A))
#define fprintf ReDirectFPrint
#define PADSIZE 1
#define MaxTypes 2048
#define MaxElements 64
#define MaxLocalVars 16384
#define MaxGlobalVars 16384
#define MaxLib 64
#define c_SglQt 39
#define c_DblQt 34
#define c_LPar 40
#define c_RPar 41
#define c_Comma 44
#define c_LtBkt 91
#define c_RtBkt 93
#define vt_VarMin 2
#define vt_VarMax vt_VARIANT
#define COM_NAMES_STORAGE_CLASS struct _COM_NAMES_STORAGE*
#define cMaxComStk 256
#define cMaxParamToken 64
#define cSizeOfName 64
#define COM_STACK_SIZE 64
#define COM_Max_Gl_Objs 64
#define COM_Max_Lc_Objs 64
#define COM_Max_Withs 32
#define cCommaPos 128
#define FUNCPARSE_CLASS struct _FUNCPARSE*
#define VARTYPES "%$#!@`"
#define SELECT_INFO_CLASS struct _SELECT_INFO*
#define cMaxNestedSelects 32
#define NOTFOUND (- 1)
#define WORDS_CLASS struct _WORDS*
#define ARGTYPE_CLASS struct _ARGTYPE*
#define cMAXProtoType 8192
#define cSizeOfCondition 512
#define PROTOSTORE_CLASS struct _PROTOSTORE*
#define cSizeOfElementName 64
#define ELEMENT_CLASS struct _ELEMENT*
#define cSizeOfVarName 64
#define USERTYPEDEF_CLASS struct _USERTYPEDEF*
#define cSizeOfLabel 10
#define LOOPSTORE_CLASS struct _LOOPSTORE*
#define cSizeOfVarDim 128
#define cSizeOfVarCondDef 128
#define cSizeOfVarModule 300
#define VARINFO_CLASS struct _VARINFO*
#define VARCODE_CLASS struct _VARCODE*
#define VARIANTNAMES_CLASS struct _VARIANTNAMES*
#define VTCASTS_CLASS struct _VTCASTS*
#define CASTS_CLASS struct _CASTS*
#define cMaxStk 8192
#define cMaxByref 128
#define cMaxDLLDecl 1024
#define cMaxLoopLocal 512
#define cMaxFiles 512
#define cMaxMacros 2048
#define cMaxBaseTypeDefs 16
#define cMaxSingleLineIFLines 256
#define cMaxSplitLines 256
#define cMaxOnEntry 256
#define cMaxOnExit 256
#define cMaxLocalDynArr 256
#define cMaxGlobalDyna 256
#define cMaxDynaStr 256
#define cMaxStartSub 32
#define cMaxExitSub 32
#define cMaxClassNames 1024
#define cSizeOfDllDecl 512
#define cSizeOfLoadlibs 512
#define cMaxLoadlibs 128
#define MaxHFiles 128
#define cMaxLocalInBlocks 16
#define TOKSUBFUNC_CLASS struct _TOKSUBFUNC*
#define cMaxSrcLen 0x100000
#define CommaEq ",="
#define cPrependVarSize 8
#define cWithVarSize 8
#define FUNCNAMETYPE_CLASS struct _FUNCNAMETYPE*

// *************************************************
//                  Compiler Macros
// *************************************************

// *************************************************
//                   Microsoft VC++
// *************************************************

#ifndef DECLSPEC_UUID
  #if(_MSC_VER >= 1100) && defined(__cplusplus)
    #define DECLSPEC_UUID(x)  __declspec(uuid(x))
  #else
    #define DECLSPEC_UUID(x)
  #endif
#endif
#if (_MSC_VER >= 1900)            // earlier versions untested
   #include <intrin.h>
      #ifndef _rdtsc
         #define _rdtsc __rdtsc   // MSVC uses 2 underscores
      #endif
#endif

// *************************************************
//                  GCC and CLANG
// *************************************************

#if defined(__GNUC__) || defined(__clang__)
   #ifndef __BCPLUSPLUS__
      #include <x86intrin.h>
   #endif
#endif

// *************************************************
//                  Embarcadero C++
// *************************************************

#if defined(__BCPLUSPLUS__)
      #include<malloc.h>
      #if defined (_clang__)
          #include <mmintrin.h>
      #endif
      #define _kbhit kbhit
      #ifndef _rdtsc
         #define _rdtsc __rdtsc  // Uses 2 underscores
      #endif
#endif

// *************************************************
// Instruct Linker to Search Object/Import Libraries
// *************************************************

#if !defined(__GNUC__) && !defined(__TINYC__)
   #if !(defined(__BCPLUSPLUS__) && defined(_WIN64))
    #pragma comment(lib,"kernel32.lib")
    #pragma comment(lib,"user32.lib")
    #pragma comment(lib,"gdi32.lib")
    #pragma comment(lib,"comctl32.lib")
    #pragma comment(lib,"advapi32.lib")
    #pragma comment(lib,"winspool.lib")
    #pragma comment(lib,"shell32.lib")
    #pragma comment(lib,"msimg32.lib")
    #pragma comment(lib,"ole32.lib")
    #pragma comment(lib,"oleaut32.lib")
    #pragma comment(lib,"uuid.lib")
    #pragma comment(lib,"odbc32.lib")
    #pragma comment(lib,"odbccp32.lib")
    #pragma comment(lib,"winmm.lib")
    #pragma comment(lib,"comdlg32.lib")
    #pragma comment(lib,"imagehlp.lib")
    #pragma comment(lib,"version.lib")
    #pragma comment(lib,"wininet.lib")
    #pragma comment(lib,"urlmon.lib")
  #endif
#endif

// *************************************************
//           User's GLOBAL Enumerations
// *************************************************

enum
  {
    vt_UNKNOWN,
    vt_STRLIT,
    vt_INTEGER,
    vt_SINGLE,
    vt_DOUBLE,
    vt_LDOUBLE,
    vt_LLONG,
    vt_STRVAR,
    vt_DECFUNC,
    vt_NUMBER,
    vt_FILEPTR,
    vt_UDT,
    vt_STRUCT,
    vt_UNION,
    vt_LPSTR,
    vt_BOOL,
    vt_CHAR,
    vt_SCHAR,
    vt_LPSTRPTR,
    vt_PCHAR,
    vt_CHARPTR,
    vt_VOID,
    vt_LONG,
    vt_WORD,
    vt_DWORD,
    vt_FARPROC,
    vt_LPBYTE,
    vt_LRESULT,
    vt_BYTE,
    vt_SHORT,
    vt_SSHORT,
    vt_USHORT,
    vt_UINT,
    vt_ULONG,
    vt_ULONGLONG,
    vt_HWND,
    vt_HDC,
    vt_COLORREF,
    vt_HANDLE,
    vt_HINSTANCE,
    vt_BITMAPINFO,
    vt_HBITMAP,
    vt_WNDCLASSEX,
    vt_HFONT,
    vt_CONSTRDESTR,
    vt_VARIANT_BOOL,
    vt__VARIANT_BOOL,
    vt_SCODE,
    vt_CY,
    vt_DATE,
    vt_BSTR,
    vt_IUnknown,
    vt_IDispatch,
    vt_SAFEARRAY,
    vt_PVOID,
    vt_DECIMAL,
    vt_DOCINFO,
    vt_LOGFONT,
    vt_TEXTMETRIC,
    vt_WINBOOL,
    vt_VARIANT
  };

enum
  {
    OSUnknown = (-2),
    OSError   = (-1),
    OS_3x,
    OS_95,
    OS_98,
    OS_ME,
    OS_NT3,
    OS_2000,
    OS_XP,
    OS_XP_Pro_x64,
    OS_Server_2003,
    OS_Home_Server,
    OS_Server_2003_R2,
    OS_Vista,
    OS_Server_2008,
    OS_Server_2008_R2,
    OS_Win_7,
    OS_Server_2012,
    OS_Win_8,
    OS_Win_81,
    OS_Server_2012_R2,
    OS_Win_10,
    OS_Server_2016,
    OS_Win_11,
    OS_Server_2019,
    OS_Server_2022
  };

enum
  {
    eFunctionType = (1),
    eSubType
  };

enum
  {
    ePart,
    eFull,
    eStringPart,
    eStringFull
  };

enum
  {
    ImDim       = 0x0001,
    ImLocal     = 0x0002,
    ImRaw       = 0x0004,
    ImStatic    = 0x0008,
    ImAuto      = 0x0010,
    ImRegister  = 0x0020,
    ImCPPPrvDim = 0x0040
  };

enum
  {
    mt_ProcessSetCommand,
    mt_FuncSubDecC_Dec,
    mt_FuncSubDecC_DecAParam,
    mt_FuncSubDecC_DecNoParam,
    mt_Opts,
    mt_OptsAParam,
    mt_OptsNoParam,
    mt_OverLoad,
    mt_OverLoadAParam,
    mt_OverLoadNoParam,
    mt_ConsDes,
    mt_ConsDesAParam,
    mt_ConsDesNoParam
  };

enum
  {
    eDoNothing,
    eStartSysVariables,
    eDoSysVariables,
    eStartUserVariables,
    eDoUserVariables,
    eStartMacros,
    eDoMacros,
    eStartStdProtos,
    eDoStdProtos,
    eStartUserProtos,
    eDoUserProtos,
    eStartUserConst,
    eDoUserConst,
    eStartSysConst,
    eDoSysConst,
    eDoMainProgram,
    eDoUserProcs,
    eStartUserTypes,
    eDoUserTypes
  };

enum
  {
    comvt_BAD = (-1),
    comvt_TRUE,
    comvt_FALSE,
    comvt_BOOL,
    comvt__VARIANT_BOOL,
    comvt_BSTR,
    comvt_STRVAR,
    comvt_R4,
    comvt_R8,
    comvt_R8_LITERAL,
    comvt_CY,
    comvt_DATE,
    comvt_DISPATCH,
    comvt_PVOID,
    comvt_ERROR,
    comvt_VARIANT,
    comvt_UNKNOWN,
    comvt_DECIMAL,
    comvt_I1,
    comvt_UI1,
    comvt_I2,
    comvt_UI2,
    comvt_I4,
    comvt_I4_LITERAL,
    comvt_UI4,
    comvt_I8,
    comvt_UI8,
    comvt_INT,
    comvt_UINT,
    comvt_VOID,
    comvt_OBJECT,
    comvt_EMPTY,
    comvt_NULL,
    comvt_HRESULT,
    comvt_PTR,
    comvt_SAFEARRAY,
    comvt_CARRAY,
    comvt_USERDEFINED,
    comvt_LPSTR,
    comvt_LPWSTR,
    comvt_RECORD,
    comvt_INT_PTR,
    comvt_UINT_PTR,
    comvt_FILETIME,
    comvt_BLOB,
    comvt_STREAM,
    comvt_STORAGE,
    comvt_STREAMED_OBJECT,
    comvt_STORED_OBJECT,
    comvt_BLOB_OBJECT,
    comvt_CF,
    comvt_CLSID,
    comvt_VERSIONED_STREAM,
    comvt_BSTR_BLOB,
    comvt_NAMED_ARGUMENT,
    comvt_CAST,
    comvt_DEFAULT,
    comvt_VECTOR   = 0x1000,
    comvt_ARRAY    = 0x2000,
    comvt_BYREF    = 0x4000,
    comvt_TYPEMASK = 0x0FFF,
    comvt_ILLEGAL  = 0xFFFF
  };

enum
  {
    ePrinterGroup   = 0x0001,
    eFontGroup      = 0x0002,
    eClassName      = 0x0004,
    eBCX_hInstance  = 0x0008
  };

enum
  {
    lt_DOLOOP = 1,
    lt_DOWHILELOOP,
    lt_DOUNTILLOOP,
    lt_WHILEWEND,
    lt_FORNEXT,
    lt_SELECT,
    lt_FORXNEXT
  };

enum
  {
    eExitingMoreThan1Loop = 1
  };

enum
  {
    eWI_CPPWord       = 0x0001,
    eWI_ReplaceWord   = 0x0002,
    eWI_NoFixup       = 0x0004,
    eWI_Directive     = 0x0008,
    eWI_Transform     = 0x0010,
    eWI_Position1     = 0x0020,
    eWI_Reserve10     = 0x0040,
    eWI_Reserve09     = 0x0080,
    eWI_Reserve08     = 0x0100,
    eWI_Reserve07     = 0x0200,
    eWI_Reserve06     = 0x0400,
    eWI_Reserve05     = 0x0800,
    eWI_Reserve04     = 0x1000,
    eWI_Reserve03     = 0x2000,
    eWI_Reserve02     = 0x4000,
    eWI_Reserve01     = 0x8000
  };

// *************************************************
//               Standard Prototypes
// *************************************************

int     EoF (FILE*);
char*   NamePathFromFP (FILE*);
LPWORD  lpwAlign (LPWORD);
void    InfoBox (LPCTSTR, LPCTSTR, int=170, int=170);
LRESULT CALLBACK CB_InfoBox (HWND, UINT, WPARAM, LPARAM);
void    cls (void);
void    color (int, int=0);
void    PushColors (void);
void    PopColors  (void);
void    locate (int, int, int=1, int=12);
int     Pos (void);
int     Csrlin (void);
void    midstr (char*, int, int, char *);
char*   BCX_TempStr (size_t);
char*   sziif (int, LPCTSTR, LPCTSTR);
char*   Using (LPCTSTR, long double);
char*   TempFileName (LPCTSTR, LPCTSTR);
char*   AppExePath (void);
char*   chr (unsigned char,  unsigned char=0,unsigned char=0,unsigned char=0,
             unsigned char=0,unsigned char=0,unsigned char=0,unsigned char=0,
             unsigned char=0,unsigned char=0,unsigned char=0,unsigned char=0,
             unsigned char=0,unsigned char=0,unsigned char=0,unsigned char=0,
             unsigned char=0,unsigned char=0,unsigned char=0,unsigned char=0,
             unsigned char=0,unsigned char=0,unsigned char=0,unsigned char=0,
             unsigned char=0,unsigned char=0);
char*   vchr (int,...);
char*   lcase (LPCTSTR);
char*   ucase (LPCTSTR);
char*   mid (LPCTSTR, int, int=-1);
char*   ltrim (LPCTSTR, char=32);
char*   rtrim (LPCTSTR, char=32);
char*   trim (LPCTSTR);
char*   strim (LPCTSTR);
char*   left (LPCTSTR, int);
char*   right (LPCTSTR, int);
char*   cpad (LPCTSTR, int, int=32);
char*   rpad (LPCTSTR, int, int=32);
char*   lpad (LPCTSTR, int, int=32);
char*   stringx (int, int);
char*   repeat (int, LPCTSTR);
char*   extract (LPCTSTR, LPCTSTR);
char*   remain (LPCTSTR, LPCTSTR);
char*   command (int=-1);
char*   mcase (LPCTSTR);
char*   replace (LPCTSTR, LPCTSTR, LPCTSTR);
char*   iReplace (LPCTSTR, LPCTSTR, LPCTSTR);
char*   RemoveAny (LPCTSTR, LPCTSTR);
void     BCX_Sleep (int);
char*   space (int a);
char*   str (double, int=0);
char*   RegString (HKEY, LPCTSTR, LPCTSTR);
void    CreateRegString (HKEY, LPCTSTR, LPCTSTR, LPCTSTR);
char*   findfirst (LPCTSTR);
char*   LookAhead (FILE*, int=1);
char*   curdir (void);
char*   tempdir (void);
char*   Environ (LPCTSTR);
char*   date (int=0);
char*   isodate (int=0);
char*   BcxSplitPath (LPCTSTR, int);
char*   BcxPath (void);
char*   LccPath (void);
char*   PellesPath (void);
char*   StrToken (LPCTSTR, LPCTSTR, int);
char*   RemoveStr (LPCTSTR, LPCTSTR);
char*   IRemoveStr (LPCTSTR, LPCTSTR);
char*   timef (int=0, int=0);
char*   join(int, LPCTSTR, ...);
char*   enc (LPCTSTR, int=0, int=0);
char*   _stristr_(LPCTSTR, LPCTSTR);
char*   DeDupeSort(const char*);
int     DeDupeCompare(const void*, const void*);
int     InstrRev (LPCTSTR, LPCTSTR, int=0, int=0);
int     bcx_stricmp (LPCTSTR cs, LPCTSTR ct);
int     instr (LPCTSTR, LPCTSTR, int=1, int=0);
int     iinstr (LPCTSTR, LPCTSTR, int=1);
int     InstrAny (LPCTSTR, LPCTSTR, int=1);
int     inchr (LPCTSTR, LPCTSTR);
int     like (LPCTSTR, LPCTSTR);
int     LeftStr  (LPCTSTR, LPCTSTR, int=0);
int     RightStr (LPCTSTR, LPCTSTR, int=0);
int     tally (LPCTSTR, LPCTSTR, int=0);
BOOL    Exist   (LPCTSTR);
BOOL    Exist_A (LPCTSTR);
BOOL    Exist_B (LPCTSTR);
unsigned long long int  lof (LPCTSTR);
unsigned char*  MakeLCaseTbl (void);
unsigned char*  MakeUCaseTbl (void);

// *************************************************
//          User Defined Types And Unions
// *************************************************

typedef struct _COM_NAMES_STORAGE
{
  char  com_VarName[cSizeOfName];
  BOOL  initialized;
}COM_NAMES_STORAGE, *LPCOM_NAMES_STORAGE, *COM_NAMES_STORAGE_PTR;

typedef struct _FUNCPARSE
{
  int NumArgs;
  int CommaPos[cCommaPos];
}FUNCPARSE, *LPFUNCPARSE, *FUNCPARSE_PTR;

typedef struct _SELECT_INFO
{
  char  CaseStk[BCXSTRSIZE];
  int  CaseElseFlag;
  int  CaseFlag;
  int  iStartCase;
  int  NoBreak;
  int  iJumpTo;
}SELECT_INFO, *LPSELECT_INFO, *SELECT_INFO_PTR;

typedef struct _WORDS
{
  PTCHAR  pszWord;
  int  iType;
  int   (__cdecl *Emitter)(char *,PINT);
}WORDS, *LPWORDS, *WORDS_PTR;

typedef struct _ARGTYPE
{
  char  Arg[BCXSTRSIZE];
  int  ArgType;
}ARGTYPE, *LPARGTYPE, *ARGTYPE_PTR;

typedef struct _PROTOSTORE
{
  char  Condition[cSizeOfCondition];
  int  CondLevel;
  char  Prototype[BCXSTRSIZE];
}PROTOSTORE, *LPPROTOSTORE, *PROTOSTORE_PTR;

typedef struct _ELEMENT
{
  int  ElementType;
  int  ElementID;
  int  ElementDynaPtr;
  char  ElementName[cSizeOfElementName];
}ELEMENT, *LPELEMENT, *ELEMENT_PTR;

typedef struct _USERTYPEDEF
{
  char  VarName[cSizeOfVarName];
  int  TypeofDef;
  int  EleCnt;
  struct _ELEMENT  Elements[MaxElements];
}USERTYPEDEF, *LPUSERTYPEDEF, *USERTYPEDEF_PTR;

typedef struct _LOOPSTORE
{
  int  iLoopType;
  int  iLoopLine;
  int  iJumpTo;
  char  szUseNeedLabel[cSizeOfLabel];
}LOOPSTORE, *LPLOOPSTORE, *LOOPSTORE_PTR;

typedef struct _VARINFO
{
  int  VarLine;
  int  VarType;
  int  VarDef;
  int  VarPntr;
  int  VarSF;
  int  VarExtn;
  int  VarCondLevel;
  int  VarEmitFlag;
  int  VarConstant;
  char  VarName[cSizeOfVarName];
  char  VarDim[cSizeOfVarDim];
  char  VarModule[cSizeOfVarModule];
  char  VarCondDef[cSizeOfVarCondDef];
}VARINFO, *LPVARINFO, *VARINFO_PTR;

typedef struct _VARCODE
{
  int  VarNo;
  int  Methd;
  int  IsPtrFlag;
  int  IsExported;
  int  UseInLine;
  char  Header[BCXSTRSIZE];
  char  Proto[BCXSTRSIZE];
  char  Functype[BCXSTRSIZE];
  char  StaticOut[BCXSTRSIZE];
  char  Token[BCXSTRSIZE];
  char  AsToken[BCXSTRSIZE];
}VARCODE, *LPVARCODE, *VARCODE_PTR;

typedef struct _VARIANTNAMES
{
  PTCHAR  sNAME;
  int  iTYPE;
  int  iPTRS;
}VARIANTNAMES, *LPVARIANTNAMES, *VARIANTNAMES_PTR;

typedef struct _VTCASTS
{
  PTCHAR  pszCAST;
  int  iCASTID;
}VTCASTS, *LPVTCASTS, *VTCASTS_PTR;

typedef struct _CASTS
{
  PTCHAR  pszCAST;
  PTCHAR  pszVAL;
}CASTS, *LPCASTS, *CASTS_PTR;

typedef UINT_PTR (CALLBACK *CPP_FARPROC)(PCHAR);

typedef struct _TOKSUBFUNC
{
  int  iTRAN_FLAG;
  PTCHAR  pszFunctionName;
  PTCHAR  pszFunctionXName;
  int  iWordInfo;
  int  iCOM;
}TOKSUBFUNC, *LPTOKSUBFUNC, *TOKSUBFUNC_PTR;

typedef struct _FuncNameType
{
    char FunctionName[BCXSTRSIZE];
    char FunctionType[BCXSTRSIZE];
}FuncNameType, *LPFUNCNAMETYPE, *FUNCNAMETYPE_PTR;

// *************************************************
//                System Variables
// *************************************************

static char    TAB [2]={9,0};     // Horz Tab
static char    LF  [2]={10,0};    // Line Feed
static char    SPC [2]={32,0};    // Space
static char    DQ  [2]={34,0};    // Double-Quote
static char    DDQ [3]={34,34,0}; // Double-Double-Quote
static char    CRLF[3]={13,10,0}; // Carr Rtn & Line Feed
static COORD   cursor;             // holds coordinates of cursor
static HANDLE  hConsole;           // handle of console window
static int     color_fg = 7;       // forground color set to default
static int     color_bg = 0;       // background color set to default
static int     color_pshpop;       // Push / Pop Color storage
static unsigned char*  LowCase;
static unsigned char*  UprCase;
static HANDLE  fffn_FileHandle;
static WIN32_FIND_DATA fffn_FindData;

// *************************************************
//            User's Global Variables
// *************************************************

static int ComNdx;
static int LinesWritten;
static int DebugModeOff;
static int MacroCount;
static int ByrefCnt;
static int LoopLocalCnt;
static int LoopTypeCnt;
static int FileNdx;
static FILE    *FP_WRITE;
static int iDoWhile;
static int iLoopCond;
static int GlobalVarCnt;
static int TypeDefsCnt;
static int GlobalDynaCnt;
static int LocalVarCnt;
static int LocalDynArrCnt;
static int LocalDynaCnt;
static int CombineRes;
static int FPtrNdx;
static int SplitCnt;
static int SplitCur;
static int StartNdx;
static int ExitNdx;
static int UmQt;
static int UseCpp;
static int UseCpphdr;
static int UseIO;
static int InNameSpace;
static int InClass;
static int InCppTypeDef;
static int iClassCnt;
static int IsVirtual;
static int UsingTemplate;
static int WasAClass;
static int HasVector;
static int UseInLine;
static int CallBackFlag;
static int Comma;
static int CurrentFuncType;
static int DoCountLines;
static int DllCnt;
static int LoadLibsCnt;
static float Elapsed;
static int EndOfProgram;
static int EntryCnt;
static int ErrFile;
static int ExitSubFunc;
static int ForceMainToFunc;
static int HFileCnt;
static int InBlock;
static int InConditional;
static int Indent;
static int InDialogEvt;
static int InfoBoxWarn;
static int InFunction;
static int Inject_Local_Bcx_RetVal;
static int InMain;
static int InWinMain;
static int IsCallBack;
static int ModDialogEvt;
static int UseCProto;
static int InTypeDef;
static int NoTypeDeclare;
static int InsertComments;
static int IsAuto;
static int IsDim;
static int IsLocal;
static int IsRaw;
static int IsRegister;
static int IsStatic;
static int IsStdFunc;
static int KillCFile;
static int LastCmd;
static int LinesRead;
static int MakeDLL;
static int Ndx;
static BOOL NoMain;
static BOOL NoDllMain;
static BOOL OkayToSend;
static BOOL OptimizerEnabled;
static BOOL OptimizerFirstSetting;
static int OptionBase;
static BOOL PassOne;
static int ProtoCnt;
static int StateIdx;
static BOOL PPFlag;
static HINSTANCE PPDLL_HANDLE;
static CPP_FARPROC PPProc;
static int Use_LoadLibraryError;
static BOOL Use_Project;
static BOOL Gen_Header;
static BOOL NoRT;
static BOOL Quiet;
static BOOL WarningFlag;
static BOOL ZapFlag;
static BOOL ReDirect;
static FILE    *SaveFP_WRITENum;
static int ShowStatus;
static int SrcCnt;
static int SrcFlag;
static int TraceFlag;
static BOOL TestForBcxIni;
static int iEmitVarGroup;
static int For_Next_Error_Detected;
static int Statements;
static int IgnoreStrCase;
static int TestState;
static int TranslateSlash;
static int Use_BcxTempStr;
static int Use_BCX_stricmp;
static int UseStdCall;
static int UseImportExport;
static int Use_LCaseTbl;
static int Use_UCaseTbl;
static int WinHeaders;
static int XitCount;
static int Use_GUINoMain;
static int Use_MDIGUINoMain;
static int Use_Wingui;
static int Use_MainEvent;
static int Use_Mdigui;
static int Use_ShowModal;
static int Use_EndModal;
static int Use_BCX_MsgPump;
static int Use_BCX_MDI_MsgPump;
static int Use_BCX_Wnd;
static int Use_BCX_FrameWnd;
static int Use_BCX_SetBkGrdBrush;
static int Use_BCX_SetClassStyle;
static int Use_BCX_SetIcon;
static int Use_BCX_SetIconSm;
static int Use_BCX_SetMetric;
static int Use_BCX_InitGUI;
static int Use_BCX_RegWnd;
static int Use_BCX_SetCursor;
static int Use_AnsiToWide;
static int Use_Asinh;
static int Use_Acosh;
static int Use_AppActivate;
static int Use_Atanh;
static int Use_Asc;
static int Use_AppExeName;
static int Use_AppExePath;
static int Use_Bff;
static int Use_Boolstr;
static int Use_Bnot;
static int Use_BCX_Blit;
static int Use_BCX_Blit_Stretch;
static int Use_BCX_Blit_Sprite;
static int Use_BCX_Buffer;
static int Use_BCX_BmpWidth;
static int Use_BCX_BmpHeight;
static int Use_BCX_Class_Info;
static int Use_BCX_LoadBMP;
static int Use_BCX_LoadImage;
static int Use_BCX_Control;
static int Use_BCX_Colordlg;
static int Use_BCX_Cursor;
static int Use_BCX_Fontdlg;
static int Use_BCX_Floodfill;
static int Use_BCX_Get;
static int Use_BCX_Get_Window_Width;
static int Use_BCX_Get_Window_Height;
static int Use_BcxSplitPath;
static int Use_BCX_Path;
static int Use_BCX_Put;
static int Use_BCX_Preset;
static int Use_BCX_Pset;
static int Use_BCX_Polar_Pset;
static int Use_BCX_Line;
static int Use_BCX_Polar_Line;
static int Use_BCX_Lineto;
static int Use_BCX_Circle;
static int Use_BCX_Triangle;
static int Use_BCX_Gradient;
static int Use_BCX_Ellipse;
static int Use_BCX_Rectangle;
static int Use_BCX_Resize;
static int Use_BCX_Roundrect;
static int Use_BCX_Getpixel;
static int Use_BCX_Arc;
static int Use_BCX_OlePicture;
static int Use_BCX_Pie;
static int Use_BCX_Polygon;
static int Use_BCX_PolyBezier;
static int Use_BCX_Polyline;
static int Use_BCX_Print;
static int Use_BCX_Printex;
static int Use_BCX_Tile;
static int Use_BCX_Slider;
static int Use_BCX_Splitter;
static int Use_BCX_Tab;
static int Use_BCX_Toolbar;
static int Use_BCX_UpDown;
static int Use_BCX_Get_UpDown;
static int Use_Bin;
static int Use_Bin2dec;
static int Use_ByteAt;
static int Use_Cast;
static int Use_Cvd;
static int Use_Cvld;
static int Use_Cvi;
static int Use_Cvl;
static int Use_Cvs;
static int Use_Cdbl;
static int Use_Cldbl;
static int Use_Csng;
static int Use_Clear;
static int Use_Clip_Getbitmap;
static int Use_Clip_Setbitmap;
static int Use_Clip_Gettext;
static int Use_Clip_Gettextsize;
static int Use_Clip_Reset;
static int Use_Clip_Settext;
static int Use_Chr;
static int Use_Chrtoutf8;
static int Use_Cbool;
static int Use_Cint;
static int Use_Clng;
static int Use_Cls;
static int Use_Color;
static int Use_Command;
static int Use_ComboBoxLoadFile;
static int Use_Console;
static int Use_Consolesize;
static int Use_ContainedIn;
static int Use_Cpad;
static int Use_Static;
static int Use_CreateRegInt;
static int Use_CreateRegString;
static int Use_Crlf;
static int Use_Csrlin;
static int Use_Curdir;
static int Use_Cursor;
static int Use_Date;
static int Use_DrawStr;
static int Use_IsoDate;
static int Use_Datacount;
static int Use_Del;
static int Use_DeleteRegKey;
static int Use_Diskfree;
static int Use_Diskused;
static int Use_Disksize;
static int Use_Doevents;
static int Use_Download;
static int Use_Downloadtostr;
static int Use_Draw;
static int Use_Dynacall;
static int Use_DynacallA;
static int Use_DynacallCommon;
static int Use_DynamicA;
static int Use_DrawTransBMP;
static int Use_Elf;
static int Use_Enclose;
static int Use_Environ;
static int Use_EnumFile;
static int Use_Eof;
static int Use_EqualTo;
static int Use_Exist;
static int Use_ExitCode;
static int Use_Extract;
static int Use_ExtractAny;
static int Use_LeanAndMean;
static int Use_Lclick;
static int Use_LoadFile;
static int Use_ForEach;
static int Use_FillArray;
static int Use_FirstInstance;
static int Use_Findfirst;
static int Use_Findnext;
static int Use_Lookahead;
static int Use_FindInType;
static int Use_Fix;
static int Use_FileLocked;
static int Use_Frac;
static int Use_Fracl;
static int Use_Freefile;
static int Use_Get;
static int Use_GetBmp;
static int Use_Gethttpfilesize;
static int Use_SetDimension;
static int Use_GetDimension;
static int Use_Getdrive;
static int Use_Getfilename;
static int Use_GetSaveAsFilename;
static int Use_Getattr;
static int Use_GetResource;
static int Use_GetSpecialFolder;
static int Use_GetSpecialFolderex;
static int Use_GetTextSize;
static int Use_GenFree;
static int Use_GoSub;
static int Use_Hex;
static int Use_Hex2Dec;
static int Use_Hook;
static int Use_Iif;
static int Use_Inputbuffer;
static int Use_Inkey;
static int Use_InkeyD;
static int Use_Inputbox;
static int Use_Infobox;
static int Use_BoxCommon;
static int Use_Isptr;
static int Use_Ins;
static int Use_Instr;
static int Use_IInstr;
static int Use_InstrAny;
static int Use_IInstrAny;
static int Use_Like_Instr;
static int Use_Inchr;
static int Use_iReplace;
static int Use_IReplaceAny;
static int Use_IRemove;
static int Use_IRemoveAny;
static int Use_Instrrev;
static int Use_Imod;
static int Use_Istrue;
static int Use_Isfalse;
static int Use_Isnull;
static int Use_Notnull;
static int Use_Iszero;
static int Use_Issystem;
static int Use_Ishidden;
static int Use_Isreadonly;
static int Use_Isfolder;
static int Use_Isfile;
static int Use_Join;
static int Use_Keypress;
static int Use_KBinput;
static int Use_Lcase;
static int Use_LccPath;
static int Use_PellesPath;
static int Use_Ldouble;
static int Use_Left;
static int Use_LeftStr;
static int Use_Like;
static int Use_LineinputKB;
static int Use_ListBoxLoadFile;
static int Use_Loc;
static int Use_Longestline;
static int Use_Locate;
static int Use_Lof;
static int Use_Lpad;
static int Use_Ltrim;
static int Use_Mcase;
static int Use_Mid;
static int Use_Midstr;
static int Use_Msgbox;
static int Use_Mkd;
static int Use_Mkld;
static int Use_Mki;
static int Use_Mkl;
static int Use_Mks;
static int Use_Mkpath;
static int Use_Min;
static int Use_Modstyle;
static int Use_Max;
static int Use_Mouse_sx;
static int Use_Mouse_sy;
static int Use_Mouse_cx;
static int Use_Mouse_cy;
static int Use_NamePathFromFP;
static int Use_Nextlinelen;
static int Use_Now;
static int Use_Notzero;
static int Use_NotEqualTo;
static int Use_Numqsortdint;
static int Use_Numqsortaint;
static int Use_Numqsortdfloat;
static int Use_Numqsortafloat;
static int Use_Numqsortddouble;
static int Use_Numqsortadouble;
static int Use_Idxqsort;
static int Use_IdxqsortSt;
static int Use_PtrqsortSt;
static int Use_PushPopColors;
static int Use_Oct;
static int Use_Overloaded;
static int Use_OSVersion;
static int Use_Panel;
static int Use_Pause;
static int Use_PeekStr;
static int Use_Pos;
static int Use_Printer;
static int Use_ProgressBar;
static int Use_Proto;
static int Use_Put;
static int Use_QBColor;
static int Use_DegToRad;
static int Use_RadToDeg;
static int Use_Randomize;
static int Use_Read;
static int Use_Readnum;
static int Use_Rec;
static int Use_RecCount;
static int Use_Remain;
static int Use_Remove;
static int Use_Repeat;
static int Use_Replace;
static int Use_ReplaceAny;
static int Use_RemoveAny;
static int Use_Reverse;
static int Use_Right;
static int Use_RightStr;
static int Use_Rpad;
static int Use_Rclick;
static int Use_Rnd;
static int Use_Rnd2;
static int Use_Exp;
static int Use_Retain;
static int Use_Round;
static int Use_Rtrim;
static int Use_Run;
static int Use_SaveBmp;
static int Use_Scan;
static int Use_Screen;
static int Use_Setattr;
static int Use_Seteof;
static int Use_SearchPath;
static int Use_Set_BCX_Bitmap;
static int Use_Set_BCX_Bitmap2;
static int Use_Set_BCX_BmpButton;
static int Use_Set_BCX_Icon;
static int Use_Sgn;
static BOOL Use_SingleFile;
static int Use_Sleep;
static int Use_Sound;
static int Use_Space;
static int Use_Split;
static int Use_DSplit;
static int Use_StartupCode;
static int Use_Stristr;
static int Use_Str;
static int Use_Strl;
static int Use_Strim;
static int Use_String;
static int Use_Strptr;
static int Use_Strqsorta;
static int Use_Strqsortas;
static int Use_Strqsortd;
static int Use_Strqsortds;
static int Use_Strqsorts;
static int Use_Strtoken;
static int Use_DynStrqsorta;
static int Use_DynStrqsortas;
static int Use_DynStrqsortd;
static int Use_DynStrqsortds;
static int Use_DynAlphaNumericA;
static int Use_DynAlphaNumericD;
static int Use_AlphaNumericA;
static int Use_AlphaNumericD;
static int Use_AlphaNumeric;
static int Use_RegExist;
static int Use_RegInt;
static int Use_RegString;
static int Use_Resource;
static int Use_GenResFile;
static int Use_Swap;
static int Use_Sysdir;
static int Use_SysMacros;
static int Use_SysStr;
static int Use_sziif;
static int Use_Tally;
static int Use_Tempdir;
static int Use_TempFileName;
static int Use_Textmode;
static int Use_Threads;
static int Use_Time;
static int Use_Timer;
static int Use_Tix;
static int Use_Treeview;
static int Use_Trim;
static int Use_Ucase;
static int Use_Using;
static int Use_Ubound;
static int Use_Utf8tochr;
static int Use_Unwrap;
static int Use_VChr;
static int Use_VBS;
static int Use_Verify;
static int Use_Val;
static int Use_Vall;
static int Use_WideToAnsi;
static int Use_Vscroll;
static int Use_Hscroll;
static int Use_Newbmp;
static int Use_Makebmp;
static int Use_Makehdc;
static int Use_Windir;
static int Use_Wrap;
static int Use_BCX_Input;
static int Use_BCX_ToolTip;
static int Use_Bitmap;
static int Use_Blackrect;
static int Use_BmpButton;
static int Use_Button;
static int Use_Center;
static int Use_Checkbox;
static int Use_Combobox;
static int Use_Datepick;
static int Use_Edit;
static int Use_BCXMDialog;
static int Use_BCXDialog;
static int Use_BCXDialogCommon;
static int Use_Form;
static int Use_GetText;
static int Use_Grayrect;
static int Use_Group;
static int Use_Hide;
static int Use_Icon;
static int Use_Label;
static int Use_Listbox;
static int Use_Listview;
static int Use_PlayWav;
static int Use_Radio;
static int Use_Refresh;
static int Use_Richedit;
static int Use_SetColor;
static int Use_Setclientsize;
static int Use_SetFont;
static int Use_SetFormColor;
static int Use_SetText;
static int Use_Show;
static int Use_Status;
static int Use_Whiterect;
static int Use_BEL;
static int Use_BS;
static int Use_CR;
static int Use_DDQ;
static int Use_DQ;
static int Use_EF;
static int Use_ESC;
static int Use_FF;
static int Use_LF;
static int Use_NUL;
static int Use_SPC;
static int Use_TAB;
static int Use_VT;
static int ProcessingCOM_Set;
static int COM_gl_names_index;
static int COM_lc_names_index;
static int COM_gl_names_free_index;
static int COM_lc_names_free_index;
static int COM_build_trace_code;
static int COM_open_WITH_statement;
static int COM_FOREACH_enumerator;
static int Use_COM;
static int Use_COM_CLSID;
static int Use_COM_CreateObject;
static int Use_COM_DispatchObject;
static int Use_COM_GetObject;
static int Use_COM_GetProperty;
static int Use_COM_InvokeMethod;
static int Use_COM_SetProperty;
static int Use_COM_SafeArray;
static int Use_COM_UsesConversion;
static int Use_COM_Collections;
static int Use_UNICODE;
static int Use_MULTITHREADED_SW;
static int Use_SafeArrays;
static char *FuncStrNames;
static char *FuncSglNames;
static char *FuncDblNames;
static char *CurLine;
static char *gTmpStr;
static char *Src;
static char *AbortSrc;
static char *WarnMsg;
static char *RmLibs;
static char *IF_Stmt_Buffer;
static FILE    *SourceFile;
static FILE    *FP2;
static FILE    *FP_CCODE;
static FILE    *FP_SYSCST;
static FILE    *FP3;
static FILE    *FP_UDT;
static FILE    *FP_DAT;
static FILE    *FP_CST;
static FILE    *FP_HDR;
static FILE    *FP_RES;
static FILE    *FP_ENU;
static FILE    *FP_OVR;
static FILE    *FP_SET;
static FILE    *FP_DEF;
static long ppret;
static int DoInjection;
static FILE    *FP1;
static FILE    *FP_W;
static FILE    *FP_HeaderFile;
static FILE    *FP_R;
static int SFPOINTER;
static FILE    *fpErr;
static FILE    *FP99;
static FILE    *FPDEF;
static int TransformSigil;
static int PrependCnt;
static int WithCnt;
static int AuxLocalDynArrayCount;
static int Use_Overloaded_Macro;
static FILE    *ResIn;
static FILE    *ResOut;
static FILE    *UserResIn;
static int NO_BORLAND;
static int NO_GCCCLANG;
static int NO_LCCWIN;
static int NO_LIBS;
static int NO_MSVC;
static int NO_PELLES;
static int NO_VKKEYS;
static FILE    *PJ1;
static FILE    *PJ2;
static FILE    *FPUSE;
static FILE    *FPFLAGS;
static FILE    *FPScan;
static FILE    *IncFP;
static FuncNameType FunctionNameType;
static char    ComStk[cMaxComStk][BCXSTRSIZE];
static char    ParamToken[cMaxParamToken][BCXSTRSIZE];
static SELECT_INFO SelectState[cMaxNestedSelects];
static char    ConstMacro[cMaxMacros][BCXSTRSIZE];
static char    ByrefVars[cMaxByref][BCXSTRSIZE];
static int LoopLocalVar[cMaxLoopLocal];
static LOOPSTORE LoopType[cMaxLoopLocal];
static FILE    *FPtr[cMaxFiles];
static char    FileNames[cMaxFiles][BCXSTRSIZE];
static int LineNum[cMaxFiles];
static int BaseTypeDefsCnt[cMaxBaseTypeDefs];
static char    TypeDefName[cMaxBaseTypeDefs][BCXSTRSIZE];
static char    UserResFile[BCXSTRSIZE];
static char    ResCompiler[BCXSTRSIZE];
static char    Stk[cMaxStk][BCXSTRSIZE];
static PROTOSTORE ProtoType[cMAXProtoType];
static char    SrcStk[cMaxSingleLineIFLines][BCXSTRSIZE];
static char    SplitStk[cMaxSplitLines][BCXSTRSIZE];
static char    SrcTmp[BCXSTRSIZE];
static char    Entry[cMaxOnEntry][BCXSTRSIZE];
static char    Xit[cMaxOnExit][BCXSTRSIZE];
static char    LocalDynArrName[cMaxLocalDynArr][BCXSTRSIZE];
static char    GlobalDynaStr[cMaxGlobalDyna][BCXSTRSIZE];
static char    DynaStr[cMaxDynaStr][BCXSTRSIZE];
static char    StartSub[cMaxStartSub][BCXSTRSIZE];
static char    ExitSub[cMaxExitSub][BCXSTRSIZE];
static char    Library[MaxLib][BCXSTRSIZE];
static int GlobalVarHash[MaxGlobalVars];
static VARINFO GlobalVars[MaxGlobalVars];
static VARINFO LocalVars[MaxLocalVars];
static USERTYPEDEF TypeDefs[MaxTypes];
static char    InClassName[BCXSTRSIZE];
static char    ClassNames[cMaxClassNames][BCXSTRSIZE];
static char    InClassPP[BCXSTRSIZE];
static char    szVirtual[BCXSTRSIZE];
static char    Accelerator[BCXSTRSIZE];
static char    CallType[BCXSTRSIZE];
static int LabelGenerator=1000;
static char    CaseVar[BCXSTRSIZE];
static char    Cmd[BCXSTRSIZE];
static char    Compiler[BCXSTRSIZE];
static char    CmdLineConst[BCXSTRSIZE];
static char    CmdLineFileOut[BCXSTRSIZE];
static char    DimType[BCXSTRSIZE];
static char DllDecl[cMaxDLLDecl][cSizeOfDllDecl];
static char Loadlibs[cMaxLoadlibs][cSizeOfLoadlibs];
static char    szFile[BCXSTRSIZE];
static char    Filnam[BCXSTRSIZE];
static char    FunctionName[BCXSTRSIZE];
static char    szFileHandle[BCXSTRSIZE];
static char    HFiles[MaxHFiles][BCXSTRSIZE];
static char    HFile[BCXSTRSIZE];
static char    InIfDef[BCXSTRSIZE];
static int UseFileTest=TRUE;
static int LocalInBlock[cMaxLocalInBlocks];
static char    Keyword1[BCXSTRSIZE];
static char    Linker[BCXSTRSIZE];
static char    Project[BCXSTRSIZE];
static char    LibraryErrorLog[BCXSTRSIZE];
static char    Project_Main[BCXSTRSIZE];
static char    Project_List[BCXSTRSIZE];
static char    Project_Path[BCXSTRSIZE];
static char    Scoot[BCXSTRSIZE];
static char    FileIn[BCXSTRSIZE];
static char    FileOut[BCXSTRSIZE];
static char    FileOutCopy[BCXSTRSIZE];
static char    FileErr[BCXSTRSIZE];
static char    Res_File[BCXSTRSIZE];
static char    ResFileOut[BCXSTRSIZE];
static char    gszType[BCXSTRSIZE];
static char    Var[BCXSTRSIZE];
static char    ConstLastDef[BCXSTRSIZE];
static char    UserBcxStrSize[BCXSTRSIZE];
static char    GUIIcon[BCXSTRSIZE];
static char    GUIMetric[BCXSTRSIZE];
static char    cppFile[BCXSTRSIZE];
static char    prcFile[BCXSTRSIZE];
static char    udtFile[BCXSTRSIZE];
static char    datFile[BCXSTRSIZE];
static char    UsrFile[BCXSTRSIZE];
static char    SysFile[BCXSTRSIZE];
static char    ovrFile[BCXSTRSIZE];
static char    hdrFile[BCXSTRSIZE];
static char    setFile[BCXSTRSIZE];
static char    resFile[BCXSTRSIZE];
static char    enuFile[BCXSTRSIZE];
static char    defFile[BCXSTRSIZE];
static int ComSwitchON=FALSE;
static COM_NAMES_STORAGE COM_gl_names[COM_Max_Gl_Objs+1];
static COM_NAMES_STORAGE COM_lc_names[COM_Max_Lc_Objs+1];
static char    COM_with_temp_str_name[BCXSTRSIZE];
static int iRIndex[97][2];
static char    Version[BCXSTRSIZE];
static char    Copyright[BCXSTRSIZE];
static char    BKSLASH1[BCXSTRSIZE];
static char    BKSLASH2[BCXSTRSIZE];
static char    BKSLASH4[BCXSTRSIZE];
static char    DQUOT[BCXSTRSIZE];
static char    DDQUOT[BCXSTRSIZE];
static char    Injection[BCXSTRSIZE];
static int MSMap[128];
static char    PrependVar[cPrependVarSize][BCXSTRSIZE];
static char    WithVar[cWithVarSize][BCXSTRSIZE];
static char    AuxLocalDynArray[64][BCXSTRSIZE];
static char    IncludeFileNames[cMaxFiles][BCXSTRSIZE];
static int FilesFound=1;

// *************************************************
//               Standard Macros
// *************************************************

#define FOR_EACH(i, a) {for(UINT i=0; i<sizeof(a)/sizeof((a)[0]); i++){
#define NEXT_EACH }}
#define EXIT_EACH break;
#define CAST(to_type,old_obj) ((to_type)(old_obj))
#define READNUM(a) (double)atof((DATA[(a)-1]))
#define FDRV   2
#define FPATH  4
#define FNAME  8
#define FEXT  16
#define ISTRUE 0!=
#define NOTZERO 0!=
#define NOTNULL(A)(*(A)!= 0)
#define ISNULL(A)(*(A)== 0)
#define ISFALSE 0==
#define ISZERO 0==
#define BYTE_AT(B) (B)
#define Clear(arg)memset(&arg,0,sizeof(arg))
#define imod(a,b)((a)%(b))
#define HIDEHWND(Window)ShowWindow(Window,SW_HIDE)
#define GET(A,B,C)fread((B),1,(C),(A))
#define VAL(a)(double)atof((a))

// *************************************************
//               User's Prototypes
// *************************************************

int main (int,PCHAR*);
void Early_Transforms (void);
void Final_Transforms (void);
void TransformStringConcat (void);
void RBForTransform (void);
void StripExtraDefWndProcs (void);
void AllowLoadedStrings (char*);
int iMatch (LPCTSTR,LPCTSTR,int);
int iMatchNQ (char*,char*);
int GetBracketPair (int,int,int);
int GetAsPos (int,int,int);
void BuildStr (int,int,char*);
char * Clean (char *);
void BuildDelimStr (int,int,char*);
void BuildCleanStr (int,int,char*);
void WriteCleanTokens (int,int);
int HasThisToken (char*);
int MacroCheck (void);
void Process_ASC_Function (int);
void ActivityFlags (void);
void DisplayStatus (void);
char * GetVarTypeName (int);
void LoopErrorMsg (void);
char * LoopTypeName (int);
void Emit_CompilerDefines (void);
void MakeFreeGlobals (void);
void ProcessSetCommand (int);
void Emit_Optimize (char*,char*,LPCTSTR= "");
void EnableProject (void);
int SubVarType (int);
char * PrintWriteFormat (int);
void InputBufferFlags (void);
void CommonInputCode (char*,char*);
void Emit_InputCode (void);
void Emit_FileInputCode (void);
void FinishingTouches (void);
void AssembleParts (void);
int CheckForMain (char*,BOOL);
char * RemoveExtension (char *);
int CheckGlobal (char*,int*);
int CheckLocal (char*,int*);
int CheckType (char*);
void ExportStringConst (void);
void ExportInternalConst (void);
int RestrictedWords (char *);
int DataType (char *);
void CloseAll (void);
void RemoveAll (char*,LPCTSTR,int= 0);
void Warning_ID (int,int= 0);
void Warning (char*,int= 0);
ULONGLONG HashNumber (char*);
void AddLibrary (char*);
void RemoveLibrary (char*);
void Emit_Libs (void);
void AddGlobal (char*,int,int= 0,char*  = "",int= 0,int= 0,int= 0,int= 0,int= 0);
void AddLocal (char*,int,int= 0,char*  = "",int= 0,int= 0,int= 0,int= 0);
BOOL IsDecimalNumber (char *);
BOOL IsHexNumber (char*);
void StripTabs (void);
void PushFileIO (void);
void PopFileIO (void);
void VerifyMatchedPairs (void);
void ClearIfThenStacks (void);
void AddExpressionToStack (char*);
void Add2SplitLines (char*);
void PostProcess (void);
void Inject (char*);
int Convert2SimpleFunction (int);
void XParse (char*);
void FuncSubTemplate (int);
void TokenSubstitutions (int);
void LShiftStk (int);
void RShiftStk (int);
void InsertOptionalParens (int);
void JoinStrings (int,int);
void Transforms (void);
int LocateJoiner (int);
int GetNextVarType (int);
int GetPrevVarType (int,int);
int JoinStrTest (int,int);
void FixUps (void);
int IsAllowedContext (char*);
void RemEmptyTokens (void);
void FuncSubDecs1 (char*,int,int,VARCODE*);
void FuncSubDecs2 (char*,int,VARCODE* ,int,int*);
void FuncSubDecs3 (VARCODE* ,int,int);
void AddTypeDefs (char*,int);
int CheckTypeDefs (char *);
void GetTypeInfo (char*,int* ,int* ,int*);
void AddTypedefElement (int,int,char*,char*,int= 0);
char * GetElement (int,int* ,int* ,int);
int GetElementInfo (int* ,int* ,char*);
void Process_Option_Base (void);
int IsValidName (char*);
void ValidateVarName (char*);
void PointerFix (void);
void DimDynaString (char*,int,int);
void AddDynamicGlobal (PCHAR);
int SubFuncTest (void);
int Ctor_Dtor_Detected (int);
int DimSubFunc (int);
void InBlockReSet (void);
void InBlockSet (void);
void AddSpace (int);
void Emit_Old (int*);
void Display_Version_and_Compiler (void);
char * Compiler_Used (void);
void KillFiles (void);
void Abort (char*);
void BumpDown (char*);
void BumpUp (void);
PCHAR BracketHandler (char*,int);
void PushSelectState (char*);
void PopSelectState (char*);
void Emit_Epilog (void);
void Emit_Prolog (FILE*);
void Commandline_Defines (FILE*);
void Emit_UserDirectives (FILE*);
void User_Global_Enum_Blocks (FILE*);
void System_Defined_Constants (FILE*);
void User_Defined_Constants (FILE*);
void User_Defined_Types_And_Unions (FILE*);
void User_Data_Statements (FILE*);
void BeginMain (void);
void User_Global_Variables (FILE*);
void System_Vars (FILE*);
void PreParse (char*);
int GetNumArgs (int,int* = NULL);
void GetVarCode (VARCODE* ,PCHAR);
void User_Global_Initialized_Arrays (FILE*);
void User_Overloaded_SubsFunctions (FILE*);
void User_Global_Set_Statements (FILE*);
void User_Prototypes (FILE*);
void Emit_OSVersionEnum (void);
void AddMacros (FILE*);
void Emit_MDI_MsgPump (void);
void Emit_GUI_MsgPump (void);
void Emit_WinGUIMain (char*,char*,char*);
void Emit_MDICode (FILE*);
int JoinLines (char*);
void StripCode (char*);
void ProcSingleLineIf (int*);
int SplitLines (char*);
int SpecialCaseHandler (char*);
void FastLexer (LPCTSTR,LPCTSTR,LPCTSTR,int= 1);
void InsertTokens (int,int,...);
void AppendTokens (int,...);
void Emit_ExportDef (char*);
char * GetArg (int,FUNCPARSE*);
int SepFuncArgs (int,FUNCPARSE* ,int);
PSTR MakeDecProto (FUNCPARSE* ,int= 2,int= Ndx,int= FALSE);
void AsmUnknownStructs (int);
void CheckForASC (void);
void Make_Stricmp_Map (void);
int Im_A_String_Var (char*);
void Emit_IfCond (char*,int,LPCTSTR= "");
void PrintGlobal (FILE*,int,int,char*,char*,char*,char*);
void ReDirectFPrint (FILE*,char*,...);
void InitReservedWordsLookup (void);
TOKSUBFUNC* GetWordInfo (char*);
int FindWord (char*,WORDS* ,int);
void FixAnyArrays (char*);
void Translate (void);
void FixVector (void);
void Emit_Main (void);
int Emit_FolderDriveProcs (char*,PINT);
int Emit_FunctionReturn (char*,PINT);
int Emit_Msgbox (char*,PINT);
int Emit_BcxSetFont (char*,PINT);
int Emit_BcxSetLabelColor (char*,PINT);
int Emit_BcxSetEditColor (char*,PINT);
int Emit_Hscroll (char*,PINT);
int Emit_Vscroll (char*,PINT);
int Emit_InsertMenuProc (char*,PINT);
int Emit_MdiGuiProcs (char*,PINT);
int Emit_FileIO (char*,PINT);
int Emit_FileManagementProcs (char*,PINT);
int Emit_LineInputProcs (char*,PINT);
int Emit_FinputProcs (char*,PINT);
int Emit_GetProcs (char*,PINT);
int Emit_PutProcs (char*,PINT);
int Emit_FprintProcs (char*,PINT);
int Emit_SeekProcs (char*,PINT);
int Emit_SetEofProcs (char*,PINT);
int Emit_FwriteProcs (char*,PINT);
int Emit_StringProcs (char*,PINT);
int Emit_MathProcs (char*,PINT);
int Emit_ConsoleOnlyProcs (char*,PINT);
int ValidExitStatement (void);
int IsQuoted (char *);
int Emit_ControlFlow (char*,PINT);
int Emit_KeyboardProcs (char*,PINT);
int Emit_QsortIdxProcs (char*,PINT);
int Emit_QsortProcs (char*,PINT);
int Emit_template (char*,PINT);
void AddProto (char*);
int Emit_Const (char*,PINT);
int Emit_Redim (char*,PINT);
int Emit_Extern (char*,PINT);
int Emit_Run (char*,PINT);
int Emit_Shell (char*,PINT);
int Emit_Data (char*,PINT);
int Emit_Declare (char*,PINT);
int Emit_Auto (char*,PINT);
int Emit_Dim (char*,PINT);
int Emit_Local (char*,PINT);
int Emit_PrivateDim (char*,PINT);
int Emit_Raw (char*,PINT);
int Emit_Register (char*,PINT);
int Emit_Static (char*,PINT);
int Emit_Clear (char*,PINT);
int Emit_Swap (char*,PINT);
int Emit_PrinterProcs (char*,PINT);
int Emit_Free (char*,PINT);
int Emit_Dynamic (char*,PINT);
void DimVar (int);
int Emit_CPP_EndClass (char*,PINT);
int Emit_CPP_Namespace (char*,PINT);
int Emit_CPP_Class (char*,PINT);
int Emit_CPP_Public (char*,PINT);
int Emit_CPP_Asm (char*,PINT);
int Emit_CPP_Protected (char*,PINT);
int Emit_CPP_Private (char*,PINT);
int Emit_CPP_EndNamespace (char*,PINT);
int Emit_CPP_Try (char*,PINT);
int Emit_CPP_EndTry (char*,PINT);
int Emit_CPP_Throw (char*,PINT);
int Emit_CPP_Catch (char*,PINT);
int Emit_CPP_Delete (char*,PINT);
int Emit_DialogBox (char*,PINT);
char * Emit_Conditional_Operator_Repair (char*);
int Emit_ConditionalCompilation (char*,PINT);
int Emit_Shared_Global (char*,PINT);
int Emit_EndFuncSub (char*,PINT);
int Emit_Union (char*,PINT);
int Emit_Type (char*,PINT);
int Emit_PPType (char*,PINT);
void GetParameterASHelper (int,int,int,int);
void GetParameter (PINT,VARCODE* ,int,int,int);
int Emit_OptFuncSub (char*,PINT);
int Emit_OverLoadFuncSub (char*,PINT);
int ClassProto (PCHAR);
int Emit_ConDes (char*,PINT);
int Emit_Implied (char*,PINT);
int Emit_FuncSub (char*,PINT);
void Emit_BCXVariables (void);
void AddBCX_hInstance (void);
void AddClassName (void);
void Emit_PrinterVariables (void);
void AddFontVariables (void);
void AddBcxFontVar (void);
void AddPenSizeVariables (void);
void AddGrafixVariables (void);
void AddGUIGlobals (void);
void ProcessMsgCracker (void);
void ProcessCmdHandler (void);
void ProcessMsgHandler (void);
void ProcessMsgHandlerEnd (void);
int Doinclude (char*,PINT);
void CreateUserResourceFile (void);
void DoGoto (int,int);
int Doaccelerator (char*,PINT);
int Doasm (char*,PINT);
int Dobcx_resource (char*,PINT);
int Dobcxversion (char*,PINT);
int Doccode (char*,PINT);
int Docom_op (char*,PINT);
int Docomment (char*,PINT);
int Dofillstring (char*,PINT);
int DoWarningsOn (char*,PINT);
int DoWarningsOff (char*,PINT);
int DoZap (char*,PINT);
int Docompiler (char*,PINT);
int DoBcxStrSize (char*,PINT);
int Docpp (char*,PINT);
int Docpphdr (char*,PINT);
int Docproto (char*,PINT);
int Dodefine (char*,PINT);
int Dodll (char*,PINT);
int Dofiletest (char*,PINT);
int Dofsstatic (char*,PINT);
int Dogenfree (char*,PINT);
int Doheader (char*,PINT);
int Dointerface (char*,PINT);
int Doiprint (char*,PINT);
int DoCase_offon (char*,PINT);
int Doleanandmean (char*,PINT);
int Doliberror (char*,PINT);
int Dolibrary (char*,PINT);
int Dolinker (char*,PINT);
int Domultithread (char*,PINT);
int DoNoBorland (char*,PINT);
int DoNoGccClang (char*,PINT);
int DoNoLccwin (char*,PINT);
int DoNoLibs (char*,PINT);
int DoNoMsvc (char*,PINT);
int DoNoPelles (char*,PINT);
int DoNoVkkeys (char*,PINT);
int Donoini (char*,PINT);
int Donoio (char*,PINT);
int Doremovelib (char*,PINT);
int Donomain (char*,PINT);
int Donowin (char*,PINT);
int Doonentry (char*,PINT);
int Doonexit (char*,PINT);
int Dooptimizer (char*,PINT);
int Dopack (char*,PINT);
int Dopp (char*,PINT);
int Doprj (char*,PINT);
int Doproject (char*,PINT);
int Dorems (char*,PINT);
int Doresource (char*,PINT);
int Dosource (char*,PINT);
int Dostdcall (char*,PINT);
int Dotest (char*,PINT);
int Dotrace (char*,PINT);
int Dotypedef (char*,PINT);
int IMAX (int,int);
int IMIN (int,int);
void StdProtos (FILE*);
void Emit_COM_SupportTypes (FILE*);
void Emit_COM_StandardSet (FILE*);
void Emit_COM_GetObject (FILE*);
void Emit_COM_DispatchObject (FILE*);
void Emit_COM_GetProperty (FILE*);
void Emit_COM_SetProperty (FILE*);
void Emit_COM_InvokeMethod (FILE*);
void Emit_COM_SafeArray (FILE*);
void Emit_COM_UsesConversion (FILE*);
void Emit_COM_TraceCalls (FILE*);
void Emit_BCX_SafeArray (FILE*);
void Emit_COM_CreateObject (FILE*);
void Emit_VBScript_Support (void);
void Add_COM_Global_Variable (char*);
void Add_COM_Local_Variable (char*);
int IsVariableComObject (char*);
void BCX_FreeLocalCOMObjects (BOOL);
BOOL Find_COM_statement (char*);
void COM_Parse_GetProperty (char*,char*);
void COM_Parse_SetProperty (char*,char*,int);
int GetParameterTokens (char*);
int COM_Make_Param_List (char*,int);
int COM_Prep_Param_List (char*,int);
int ComParamType (char*,int*);
void ConvertCast (char*,char*,char*);
void COM_Parse_Method (char*,char*);
void ParseCom (char*);
void Add2ComStk (char*);
char * Make_COM_Trace_Lines (char*);
void RunTimeFunctions (FILE*);
void Project_Support (void);
void SetUsed (void);
void SetFlags (void);
int Im_Single_Dim_StrVar (char*);
int Im_Multi_Dim_StrVar (char*);
int Im_UDT_Single (char*);
int Im_UDT_Double (char*);
int Im_UDT_String (char*);
int iMatchTwoNQ (char*,char*,char*  = " ");
char * iReplace_NQ (char *,char *,char *);
void ScanFunctionNames (char*);
void FindIncludeFiles (char*);
char * Replace_ANY_Keyword (char*,char*);
char * FB2BCX (char*);
void ScanFuncNamesTypes (char*);
char * CleanCodeLine (char *);
void FreeGlobals (void);

// *************************************************
//            User's Global Initialized Arrays
// *************************************************

// *************************************************
//              User's GLOBAL SET Statements
// *************************************************

static PCHAR VarTypeLookup[]=
  {
 "int","int","char *","double","float","FILE *","long double"
};

static VARIANTNAMES VariantList[]=
  {
 {"bVal",vt_BYTE,0},
 {"bool",vt__VARIANT_BOOL,0},
 {"boolVal",vt_VARIANT_BOOL,0},
 {"bstrVal",vt_BSTR,0},
 {"byref",vt_PVOID,0},
 {"cVal",vt_CHAR,0},
 {"cyVal",vt_CY,0},
 {"date",vt_DATE,0},
 {"dblVal",vt_DOUBLE,0},
 {"fltVal",vt_SINGLE,0},
 {"iVal",vt_SHORT,0},
 {"intVal",vt_INTEGER,0},
 {"lVal",vt_LONG,0},
 {"llVal",vt_LLONG,0},
 {"parray",vt_SAFEARRAY,1},
 {"pbVal",vt_BYTE,1},
 {"pbool",vt__VARIANT_BOOL,1},
 {"pboolVal",vt_VARIANT_BOOL,1},
 {"pbstrVal",vt_BSTR,1},
 {"pcVal",vt_CHAR,1},
 {"pcyVal",vt_CY,1},
 {"pdate",vt_DATE,1},
 {"pdblVal",vt_DOUBLE,1},
 {"pdecVal",vt_DECIMAL,1},
 {"pdispVal",vt_IDispatch,1},
 {"pfltVal",vt_SINGLE,1},
 {"piVal",vt_SHORT,1},
 {"pintVal",vt_INTEGER,1},
 {"plVal",vt_LONG,1},
 {"pllVal",vt_LLONG,1},
 {"pparray",vt_SAFEARRAY,2},
 {"ppdispVal",vt_IDispatch,2},
 {"ppunkVal",vt_IUnknown,2},
 {"pscode",vt_SCODE,1},
 {"puiVal",vt_USHORT,1},
 {"pulVal",vt_ULONG,1},
 {"pullVal",vt_ULONGLONG,1},
 {"punkVal",vt_IUnknown,1},
 {"pvarVal",vt_VARIANT,1},
 {"scode",vt_SCODE,0},
 {"uiVal",vt_USHORT,0},
 {"uintVal",vt_UINT,0},
 {"ulVal",vt_ULONG,0},
 {"ullVal",vt_ULONGLONG,0},
 {NULL,0,0}
};

static VTCASTS ptVCasts[]=
  {
 {"VT_BOOL",comvt_BOOL},
 {"VT_BSTR",comvt_BSTR},
 {"VT_CY",comvt_CY},
 {"VT_DATE",comvt_DATE},
 {"VT_DECIMAL",comvt_DECIMAL},
 {"VT_DISPATCH",comvt_DISPATCH},
 {"VT_ERROR",comvt_ERROR},
 {"VT_I1",comvt_I1},
 {"VT_I2",comvt_I2},
 {"VT_I4",comvt_I4},
 {"VT_I8",comvt_I8},
 {"VT_INT",comvt_INT},
 {"VT_R4",comvt_R4},
 {"VT_R8",comvt_R8},
 {"VT_UI1",comvt_UI1},
 {"VT_UI2",comvt_UI2},
 {"VT_UI4",comvt_UI4},
 {"VT_UI8",comvt_UI8},
 {"VT_UINT",comvt_UINT},
 {"VT_UNKNOWN",comvt_UNKNOWN},
 {NULL,0}
};

static CASTS ptCCasts[]=
  {
 {"BYTE","bVal"},
 {"CHAR","cVal"},
 {"DOUBLE","dblVal"},
 {"FLOAT","fltVal"},
 {"IDispatch","pdispVal"},
 {"INT","intVal"},
 {"IUnknown","punkVal"},
 {"LONG","lVal"},
 {"LONGLONG","llVal"},
 {"PVOID","byref"},
 {"SHORT","iVal"},
 {"UINT","uintVal"},
 {"ULONG","ulVal"},
 {"ULONGLONG","ullVal"},
 {"USHORT","uiVal"},
 {NULL,NULL}
};

static char   ConstTypes[][BCXSTRSIZE]=
  {
 "byte",
 "char",
 "double",
 "dword",
 "float",
 "int",
 "integer",
 "llong",
 "long",
 "longlong",
 "sbyte",
 "short",
 "single",
 "ubyte",
 "uchar",
 "uint",
 "uint64",
 "ulong",
 "ulonglong",
 "ushort"
};

static WORDS tBcxWords[]=
  {
 {"_ftelli64",vt_LLONG,NULL},
 {"abs",vt_DOUBLE,NULL},
 {"acos",vt_DOUBLE,NULL},
 {"acosh",vt_DOUBLE,NULL},
 {"acosl",vt_LDOUBLE,NULL},
 {"asin",vt_DOUBLE,NULL},
 {"asinh",vt_DOUBLE,NULL},
 {"asinl",vt_LDOUBLE,NULL},
 {"atan",vt_DOUBLE,NULL},
 {"atan2",vt_DOUBLE,NULL},
 {"atanh",vt_DOUBLE,NULL},
 {"atanl",vt_LDOUBLE,NULL},
 {"band",vt_DECFUNC,NULL},
 {"bin2dec",vt_INTEGER,NULL},
 {"bor",vt_DECFUNC,NULL},
 {"cos",vt_DOUBLE,NULL},
 {"cosh",vt_DOUBLE,NULL},
 {"cosl",vt_LDOUBLE,NULL},
 {"csrlin",vt_DECFUNC,NULL},
 {"cursorx",vt_DECFUNC,NULL},
 {"cursory",vt_DECFUNC,NULL},
 {"cvd",vt_DOUBLE,NULL},
 {"cvld",vt_LDOUBLE,NULL},
 {"cvs",vt_SINGLE,NULL},
 {"degtorad",vt_DOUBLE,NULL},
 {"dsplit",vt_DECFUNC,NULL},
 {"exist",vt_DECFUNC,NULL},
 {"exp",vt_DOUBLE,NULL},
 {"expl",vt_LDOUBLE,NULL},
 {"fabs",vt_DOUBLE,NULL},
 {"fabsf",vt_SINGLE,NULL},
 {"fabsl",vt_LDOUBLE,NULL},
 {"findfirstinstance",vt_DECFUNC,NULL},
 {"fint",vt_INTEGER,NULL},
 {"fix",vt_DECFUNC,NULL},
 {"frac",vt_DOUBLE,NULL},
 {"fracl",vt_LDOUBLE,NULL},
 {"freefile",vt_FILEPTR,NULL},
 {"getattr",vt_DECFUNC,NULL},
 {"hex2dec",vt_INTEGER,NULL},
 {"hypot",vt_DOUBLE,NULL},
 {"hypotl",vt_LDOUBLE,NULL},
 {"iif",vt_DOUBLE,NULL},
 {"iinstr",vt_DECFUNC,NULL},
 {"inchr",vt_DECFUNC,NULL},
 {"instr",vt_DECFUNC,NULL},
 {"instrany",vt_DECFUNC,NULL},
 {"instrrev",vt_DECFUNC,NULL},
 {"isfile",vt_INTEGER,NULL},
 {"isfolder",vt_INTEGER,NULL},
 {"ishidden",vt_INTEGER,NULL},
 {"isreadonly",vt_INTEGER,NULL},
 {"issystem",vt_INTEGER,NULL},
 {"kbhit",vt_DECFUNC,NULL},
 {"keypress()",vt_DECFUNC,NULL},
 {"labs",vt_LONG,NULL},
 {"llabs",vt_LLONG,NULL},
 {"lof",vt_DOUBLE,NULL},
 {"log",vt_DOUBLE,NULL},
 {"log10",vt_DOUBLE,NULL},
 {"log10l",vt_LDOUBLE,NULL},
 {"logl",vt_LDOUBLE,NULL},
 {"max",vt_DOUBLE,NULL},
 {"min",vt_DOUBLE,NULL},
 {"msgbox",vt_DECFUNC,NULL},
 {"pi",vt_DOUBLE,NULL},
 {"pos",vt_DECFUNC,NULL},
 {"pow",vt_DOUBLE,NULL},
 {"powl",vt_LDOUBLE,NULL},
 {"qbcolor",vt_DECFUNC,NULL},
 {"radtodeg",vt_DOUBLE,NULL},
 {"rnd",vt_SINGLE,NULL},
 {"rnd2",vt_DOUBLE,NULL},
 {"round",vt_DOUBLE,NULL},
 {"screen",vt_DECFUNC,NULL},
 {"sgn",vt_DECFUNC,NULL},
 {"sin",vt_DOUBLE,NULL},
 {"sinh",vt_DOUBLE,NULL},
 {"sinl",vt_LDOUBLE,NULL},
 {"sizeof",vt_DECFUNC,NULL},
 {"split",vt_DECFUNC,NULL},
 {"sqrt",vt_DOUBLE,NULL},
 {"sqrtl",vt_LDOUBLE,NULL},
 {"strlen",vt_DECFUNC,NULL},
 {"tally",vt_DECFUNC,NULL},
 {"tan",vt_DOUBLE,NULL},
 {"tanh",vt_DOUBLE,NULL},
 {"tanl",vt_LDOUBLE,NULL},
 {"textmode",vt_DOUBLE,NULL},
 {"timer",vt_SINGLE,NULL},
 {"tix_now",vt_DOUBLE,NULL},
 {"val",vt_DOUBLE,NULL},
 {"vall",vt_LDOUBLE,NULL}
};

static WORDS tTypes[]=
  {
 {"bitmapinfo",vt_BITMAPINFO,NULL},
 {"bool",vt_BOOL,NULL},
 {"boolean",vt_BOOL,NULL},
 {"bstr",vt_BSTR,NULL},
 {"byte",vt_BYTE,NULL},
 {"char",vt_CHAR,NULL},
 {"colorref",vt_COLORREF,NULL},
 {"double",vt_DOUBLE,NULL},
 {"dword",vt_DWORD,NULL},
 {"farproc",vt_FARPROC,NULL},
 {"file",vt_FILEPTR,NULL},
 {"float",vt_SINGLE,NULL},
 {"handle",vt_HANDLE,NULL},
 {"hbitmap",vt_HBITMAP,NULL},
 {"hdc",vt_HDC,NULL},
 {"hfont",vt_HFONT,NULL},
 {"hwnd",vt_HWND,NULL},
 {"int",vt_INTEGER,NULL},
 {"ldouble",vt_LDOUBLE,NULL},
 {"llong",vt_LLONG,NULL},
 {"long",vt_LONG,NULL},
 {"longlong",vt_LLONG,NULL},
 {"lpbyte",vt_LPBYTE,NULL},
 {"lpstr",vt_LPSTR,NULL},
 {"lresult",vt_LRESULT,NULL},
 {"pchar",vt_PCHAR,NULL},
 {"schar",vt_SCHAR,NULL},
 {"short",vt_SHORT,NULL},
 {"sshort",vt_SSHORT,NULL},
 {"string",vt_STRVAR,NULL},
 {"uint",vt_UINT,NULL},
 {"uint64",vt_ULONGLONG,NULL},
 {"ulong",vt_ULONG,NULL},
 {"ulonglong",vt_ULONGLONG,NULL},
 {"ushort",vt_USHORT,NULL},
 {"variant",vt_VARIANT,NULL},
 {"void",vt_VOID,NULL},
 {"winbool",vt_WINBOOL,NULL},
 {"wndclassex",vt_WNDCLASSEX,NULL}
};

static WORDS atEmitWords[]=
  {
 {"_chdir",0,Emit_FolderDriveProcs},
 {"_mkdir",0,Emit_FolderDriveProcs},
 {"_rmdir",0,Emit_FolderDriveProcs},
 {"asm",0,Emit_CPP_Asm},
 {"auto",0,Emit_Auto},
 {"bcx_set_edit_color",0,Emit_BcxSetEditColor},
 {"bcx_set_font",0,Emit_BcxSetFont},
 {"bcx_set_label_color",0,Emit_BcxSetLabelColor},
 {"beginblock",0,Emit_ControlFlow},
 {"call",0,Emit_ControlFlow},
 {"case",0,Emit_ControlFlow},
 {"caseelse",0,Emit_ControlFlow},
 {"catch",0,Emit_CPP_Catch},
 {"chdir",0,Emit_FolderDriveProcs},
 {"class",0,Emit_CPP_Class},
 {"clear",0,Emit_Clear},
 {"close",0,Emit_FileIO},
 {"cls",0,Emit_ConsoleOnlyProcs},
 {"color",0,Emit_ConsoleOnlyProcs},
 {"const",0,Emit_Const},
 {"constructor",0,Emit_ConDes},
 {"continue",0,Emit_ControlFlow},
 {"copyfile",0,Emit_FileManagementProcs},
 {"data",0,Emit_Data},
 {"declare",0,Emit_Declare},
 {"decr",0,Emit_MathProcs},
 {"delay",0,Emit_ConsoleOnlyProcs},
 {"delete",0,Emit_CPP_Delete},
 {"destructor",0,Emit_ConDes},
 {"dialogbox",0,Emit_DialogBox},
 {"dim",0,Emit_Dim},
 {"do",0,Emit_ControlFlow},
 {"dynamic",0,Emit_Dynamic},
 {"ejectpage",0,Emit_PrinterProcs},
 {"else",0,Emit_ControlFlow},
 {"elseif",0,Emit_ControlFlow},
 {"end",0,Emit_ControlFlow},
 {"endblock",0,Emit_ControlFlow},
 {"endclass",0,Emit_CPP_EndClass},
 {"endconstructor",0,Emit_ConDes},
 {"enddestructor",0,Emit_ConDes},
 {"endfunction",0,Emit_EndFuncSub},
 {"endif",0,Emit_ControlFlow},
 {"endnamespace",0,Emit_CPP_EndNamespace},
 {"endpptype",0,Emit_PPType},
 {"endprepend",0,Emit_ControlFlow},
 {"endprogram",0,Emit_ControlFlow},
 {"endrepeat",0,Emit_ControlFlow},
 {"endselect",0,Emit_ControlFlow},
 {"endsub",0,Emit_EndFuncSub},
 {"endtemplate",0,Emit_template},
 {"endtry",0,Emit_CPP_EndTry},
 {"endtype",0,Emit_Type},
 {"endunion",0,Emit_Union},
 {"endwhile",0,Emit_ControlFlow},
 {"endwith",0,Emit_ControlFlow},
 {"exit",0,Emit_ControlFlow},
 {"extern",0,Emit_Extern},
 {"fallthrough",0,Emit_ControlFlow},
 {"finput",0,Emit_FinputProcs},
 {"flush",0,Emit_FileIO},
 {"for",0,Emit_ControlFlow},
 {"fprint",0,Emit_FprintProcs},
 {"free",0,Emit_Free},
 {"function",0,Emit_FuncSub},
 {"functionreturn",0,Emit_FunctionReturn},
 {"fwrite",0,Emit_FwriteProcs},
 {"global",0,Emit_Shared_Global},
 {"gosub",0,Emit_ControlFlow},
 {"goto",0,Emit_ControlFlow},
 {"gui",0,Emit_MdiGuiProcs},
 {"if",0,Emit_ControlFlow},
 {"impfunction",0,Emit_Implied},
 {"incr",0,Emit_MathProcs},
 {"input",0,Emit_KeyboardProcs},
 {"insertmenu",0,Emit_InsertMenuProc},
 {"kill",0,Emit_FileManagementProcs},
 {"lineinput",0,Emit_LineInputProcs},
 {"local",0,Emit_Local},
 {"locate",0,Emit_ConsoleOnlyProcs},
 {"loop",0,Emit_ControlFlow},
 {"lprint",0,Emit_PrinterProcs},
 {"mdigui",0,Emit_MdiGuiProcs},
 {"midstr",0,Emit_StringProcs},
 {"mkdir",0,Emit_FolderDriveProcs},
 {"msgbox",0,Emit_Msgbox},
 {"namespace",0,Emit_CPP_Namespace},
 {"next",0,Emit_ControlFlow},
 {"open",0,Emit_FileIO},
 {"optfunction",0,Emit_OptFuncSub},
 {"optsub",0,Emit_OptFuncSub},
 {"overloadedfunction",0,Emit_OverLoadFuncSub},
 {"overloadedsub",0,Emit_OverLoadFuncSub},
 {"panel",0,Emit_ConsoleOnlyProcs},
 {"pptype",0,Emit_PPType},
 {"prepend",0,Emit_ControlFlow},
 {"print",0,Emit_ConsoleOnlyProcs},
 {"printerclose",0,Emit_PrinterProcs},
 {"printeropen",0,Emit_PrinterProcs},
 {"private",0,Emit_CPP_Private},
 {"privatedim",0,Emit_PrivateDim},
 {"privatefunction",0,Emit_FuncSub},
 {"privatesub",0,Emit_FuncSub},
 {"protected",0,Emit_CPP_Protected},
 {"public",0,Emit_CPP_Public},
 {"publicfunction",0,Emit_FuncSub},
 {"publicsub",0,Emit_FuncSub},
 {"qsort",0,Emit_QsortProcs},
 {"qsortidx",0,Emit_QsortIdxProcs},
 {"raw",0,Emit_Raw},
 {"record",0,Emit_FileIO},
 {"redim",0,Emit_Redim},
 {"register",0,Emit_Register},
 {"rename",0,Emit_FileManagementProcs},
 {"repeat",0,Emit_ControlFlow},
 {"return",0,Emit_ControlFlow},
 {"rmdir",0,Emit_FolderDriveProcs},
 {"run",0,Emit_Run},
 {"seek",0,Emit_SeekProcs},
 {"select",0,Emit_ControlFlow},
 {"seteof",0,Emit_SetEofProcs},
 {"shared",0,Emit_Shared_Global},
 {"shell",0,Emit_Shell},
 {"sprint",0,Emit_PrinterProcs},
 {"static",0,Emit_Static},
 {"sub",0,Emit_FuncSub},
 {"swap",0,Emit_Swap},
 {"template",0,Emit_template},
 {"textmode",0,Emit_ConsoleOnlyProcs},
 {"throw",0,Emit_CPP_Throw},
 {"try",0,Emit_CPP_Try},
 {"type",0,Emit_Type},
 {"union",0,Emit_Union},
 {"wend",0,Emit_ControlFlow},
 {"while",0,Emit_ControlFlow},
 {"with",0,Emit_ControlFlow},
 {"write",0,Emit_ConsoleOnlyProcs},
 {"xfor",0,Emit_ControlFlow},
 {"xnext",0,Emit_ControlFlow},
 {"~else",0,Emit_ConditionalCompilation},
 {"~elseif",0,Emit_ConditionalCompilation},
 {"~endif",0,Emit_ConditionalCompilation},
 {"~get",0,Emit_GetProcs},
 {"~hscroll",0,Emit_Hscroll},
 {"~if",0,Emit_ConditionalCompilation},
 {"~ifdef",0,Emit_ConditionalCompilation},
 {"~ifndef",0,Emit_ConditionalCompilation},
 {"~pragmaoptimizeoff",0,Emit_ConditionalCompilation},
 {"~pragmaoptimizeon",0,Emit_ConditionalCompilation},
 {"~put",0,Emit_PutProcs},
 {"~vscroll",0,Emit_Vscroll}
};

static WORDS tDirectives[]=
  {
 {"#include",0,Doinclude},
 {"$accelerator",0,Doaccelerator},
 {"$asm",0,Doasm},
 {"$bcx_resource",0,Dobcx_resource},
 {"$bcxstrsize",0,DoBcxStrSize},
 {"$bcxversion",0,Dobcxversion},
 {"$case_off",0,DoCase_offon},
 {"$case_on",0,DoCase_offon},
 {"$ccode",0,Doccode},
 {"$com_off",0,Docom_op},
 {"$com_on",0,Docom_op},
 {"$com_trace",0,Docom_op},
 {"$comment",0,Docomment},
 {"$compiler",0,Docompiler},
 {"$cpp",0,Docpp},
 {"$cpphdr",0,Docpphdr},
 {"$cproto",0,Docproto},
 {"$define",0,Dodefine},
 {"$dll",0,Dodll},
 {"$filetest",0,Dofiletest},
 {"$fill",0,Dofillstring},
 {"$fsstatic",0,Dofsstatic},
 {"$genfree",0,Dogenfree},
 {"$header",0,Doheader},
 {"$include",0,Doinclude},
 {"$interface",0,Dointerface},
 {"$iprint_off",0,Doiprint},
 {"$iprint_on",0,Doiprint},
 {"$leanandmean",0,Doleanandmean},
 {"$liberror",0,Doliberror},
 {"$library",0,Dolibrary},
 {"$linker",0,Dolinker},
 {"$mt",0,Domultithread},
 {"$multi",0,Domultithread},
 {"$no_borland",0,DoNoBorland},
 {"$no_gcc_clang",0,DoNoGccClang},
 {"$no_lccwin",0,DoNoLccwin},
 {"$no_libs",0,DoNoLibs},
 {"$no_msvc",0,DoNoMsvc},
 {"$no_pelles",0,DoNoPelles},
 {"$no_vkkeys",0,DoNoVkkeys},
 {"$nodllmain",0,Dodll},
 {"$noini",0,Donoini},
 {"$noio",0,Donoio},
 {"$nolibrary",0,Doremovelib},
 {"$nomain",0,Donomain},
 {"$nowin",0,Donowin},
 {"$onentry",0,Doonentry},
 {"$onexit",0,Doonexit},
 {"$optimizer",0,Dooptimizer},
 {"$pack",0,Dopack},
 {"$pp",0,Dopp},
 {"$prj",0,Doprj},
 {"$prjuse",0,Doprj},
 {"$project",0,Doproject},
 {"$rems",0,Dorems},
 {"$resource",0,Doresource},
 {"$source",0,Dosource},
 {"$stdcall",0,Dostdcall},
 {"$test",0,Dotest},
 {"$trace",0,Dotrace},
 {"$typedef",0,Dotypedef},
 {"$warnings",0,DoWarningsOn},
 {"$warnings_off",0,DoWarningsOff},
 {"$warnings_on",0,DoWarningsOn},
 {"$zap",0,DoZap}
};

static char VarConst[2][8]=
  {
 "",
 "const "
};

static char VarStorage[6][18]=
  {
 "static ",
 "extern ",
 "",
 "static volatile ",
 "extern volatile ",
 "volatile "
};

static TOKSUBFUNC BCXWords[]=
  {
 {1,"#include","#include",8,comvt_BAD},
 {1,"$accelerator","",8,comvt_BAD},
 {1,"$asm","",8,comvt_BAD},
 {1,"$bcx_resource","",8,comvt_BAD},
 {1,"$bcxstrsize","",8,comvt_BAD},
 {1,"$bcxversion","",8,comvt_BAD},
 {1,"$case_off","",8,comvt_BAD},
 {1,"$case_on","",8,comvt_BAD},
 {1,"$ccode","",8,comvt_BAD},
 {1,"$com_off","",8,comvt_BAD},
 {1,"$com_on","",8,comvt_BAD},
 {1,"$com_trace","",8,comvt_BAD},
 {1,"$comment","",8,comvt_BAD},
 {1,"$compiler","",8,comvt_BAD},
 {1,"$cpp","",8,comvt_BAD},
 {1,"$cpphdr","",8,comvt_BAD},
 {1,"$cproto","",8,comvt_BAD},
 {1,"$debug","",8,comvt_BAD},
 {1,"$define","",8,comvt_BAD},
 {1,"$dll","",8,comvt_BAD},
 {1,"$else","~else",2,comvt_BAD},
 {1,"$elseif","~elseif",2,comvt_BAD},
 {1,"$endif","",0,comvt_BAD},
 {1,"$filetest","",8,comvt_BAD},
 {1,"$fill","",8,comvt_BAD},
 {1,"$fsstatic","",8,comvt_BAD},
 {1,"$genfree","",8,comvt_BAD},
 {1,"$header","",8,comvt_BAD},
 {1,"$hscroll","~hscroll",2,comvt_BAD},
 {1,"$if","",0,comvt_BAD},
 {1,"$ifdef","",0,comvt_BAD},
 {1,"$ifndef","",0,comvt_BAD},
 {1,"$include","",8,comvt_BAD},
 {1,"$interface","",8,comvt_BAD},
 {1,"$iprint_off","",8,comvt_BAD},
 {1,"$iprint_on","",8,comvt_BAD},
 {1,"$lcc$","$LCC$",2,comvt_BAD},
 {1,"$leanandmean","",8,comvt_BAD},
 {1,"$liberror","",8,comvt_BAD},
 {1,"$library","",8,comvt_BAD},
 {1,"$linker","",8,comvt_BAD},
 {1,"$mt","",8,comvt_BAD},
 {1,"$multi","",8,comvt_BAD},
 {1,"$no_borland","",8,comvt_BAD},
 {1,"$no_gcc_clang","",8,comvt_BAD},
 {1,"$no_lccwin","",8,comvt_BAD},
 {1,"$no_libs","",8,comvt_BAD},
 {1,"$no_msvc","",8,comvt_BAD},
 {1,"$no_pelles","",8,comvt_BAD},
 {1,"$no_vkkeys","",8,comvt_BAD},
 {1,"$nodllmain","",8,comvt_BAD},
 {1,"$noini","",8,comvt_BAD},
 {1,"$noio","",8,comvt_BAD},
 {1,"$nolibrary","",8,comvt_BAD},
 {1,"$nomain","",8,comvt_BAD},
 {1,"$nowin","",8,comvt_BAD},
 {1,"$onentry","",8,comvt_BAD},
 {1,"$onexit","",8,comvt_BAD},
 {1,"$optimizer","",8,comvt_BAD},
 {1,"$pack","",8,comvt_BAD},
 {1,"$pp","",8,comvt_BAD},
 {1,"$prj","",8,comvt_BAD},
 {1,"$prjuse","",8,comvt_BAD},
 {1,"$project","",8,comvt_BAD},
 {1,"$rems","",8,comvt_BAD},
 {1,"$resource","",8,comvt_BAD},
 {1,"$source","",8,comvt_BAD},
 {1,"$stdcall","",8,comvt_BAD},
 {1,"$test","",8,comvt_BAD},
 {1,"$trace","",8,comvt_BAD},
 {1,"$typedef","",8,comvt_BAD},
 {1,"$vscroll","~vscroll",2,comvt_BAD},
 {1,"$warnings","",8,comvt_BAD},
 {1,"$warnings_off","",8,comvt_BAD},
 {1,"$warnings_on","",8,comvt_BAD},
 {1,"$zap","",8,comvt_BAD},
 {1,"_asm","_asm",2,comvt_BAD},
 {1,"_bool","_Bool",2,comvt_BAD},
 {1,"abs","fabs",2,comvt_R8},
 {1,"acos","acos",2,comvt_R8},
 {1,"acosh","acosh",2,comvt_R8},
 {1,"acosl","acosl",2,comvt_BAD},
 {1,"addressof","",0,comvt_BAD},
 {1,"alias","alias",2,comvt_BAD},
 {1,"and","",0,comvt_BAD},
 {1,"andalso","",0,comvt_BAD},
 {1,"ansitowide","",0,comvt_BAD},
 {1,"appactivate","",0,comvt_BAD},
 {1,"append","",0,comvt_BAD},
 {1,"appexename$","",0,comvt_BAD},
 {1,"appexepath$","",0,comvt_BAD},
 {1,"argc","argc",2,comvt_BAD},
 {1,"argv","argv",2,comvt_BAD},
 {1,"argv$","argv$",2,comvt_BAD},
 {1,"arraygetelement","",0,comvt_BAD},
 {1,"arrayputelement","",0,comvt_BAD},
 {1,"as","",0,comvt_BAD},
 {3,"asc","",0,comvt_BAD},
 {1,"ascending","",0,comvt_BAD},
 {1,"asciiz","string",2,comvt_BAD},
 {1,"asin","asin",2,comvt_R8},
 {1,"asinh","asinh",2,comvt_R8},
 {1,"asinl","asinl",2,comvt_BAD},
 {1,"asm","",1,comvt_BAD},
 {1,"atan","atan",2,comvt_R8},
 {1,"atan2","atan2",2,comvt_R8},
 {1,"atanh","atanh",2,comvt_R8},
 {1,"atanl","atanl",2,comvt_R8},
 {1,"atn","atan",2,comvt_R8},
 {1,"atn2","atan2",2,comvt_R8},
 {1,"atnl","atanl",2,comvt_R8},
 {1,"auto","auto",2,comvt_BAD},
 {3,"band","",0,comvt_BAD},
 {1,"base","base",2,comvt_BAD},
 {1,"bcopy","",0,comvt_BAD},
 {1,"bcx_addtab","BCX_AddTab",2,comvt_BAD},
 {1,"bcx_arc","",0,comvt_BAD},
 {1,"bcx_bitmap","",0,comvt_BAD},
 {1,"bcx_blackrect","",0,comvt_BAD},
 {1,"bcx_bmpbutton","",0,comvt_BAD},
 {1,"bcx_bmpheight","",0,comvt_BAD},
 {1,"bcx_bmpwidth","",0,comvt_BAD},
 {1,"bcx_buffer_start","",0,comvt_BAD},
 {1,"bcx_buffer_stop","",0,comvt_BAD},
 {1,"bcx_button","",0,comvt_BAD},
 {1,"bcx_checkbox","",0,comvt_BAD},
 {1,"bcx_circle","",0,comvt_BAD},
 {1,"bcx_classname$","BCX_ClassName$",2,comvt_BAD},
 {1,"bcx_clsid$","",0,comvt_BAD},
 {1,"bcx_colordlg","",0,comvt_BAD},
 {1,"bcx_combobox","",0,comvt_BAD},
 {1,"bcx_console","",0,comvt_BAD},
 {1,"bcx_control","",0,comvt_BAD},
 {1,"bcx_cursor","",0,comvt_BAD},
 {1,"bcx_datepick","",0,comvt_BAD},
 {1,"bcx_dialog","",0,comvt_BAD},
 {1,"bcx_dispatchobject","",0,comvt_BAD},
 {1,"bcx_edit","",0,comvt_BAD},
 {1,"bcx_ellipse","",0,comvt_BAD},
 {1,"bcx_floodfill","",0,comvt_BAD},
 {1,"bcx_font","",0,comvt_BAD},
 {1,"bcx_fontdlg","",0,comvt_BAD},
 {1,"bcx_form","",0,comvt_BAD},
 {1,"bcx_framewnd","",0,comvt_BAD},
 {1,"bcx_get","",0,comvt_BAD},
 {1,"bcx_get_com_error_code","",0,comvt_BAD},
 {1,"bcx_get_com_error_desc$","BCX_GET_COM_ERROR_DESC()",2,comvt_BAD},
 {1,"bcx_get_com_status","BCX_GET_COM_STATUS",2,comvt_BAD},
 {1,"bcx_get_com_success","BCX_GET_COM_SUCCESS()",2,comvt_BAD},
 {1,"bcx_get_text$","",0,comvt_BAD},
 {1,"bcx_get_updown","",0,comvt_BAD},
 {1,"bcx_get_window_height","",0,comvt_BAD},
 {1,"bcx_get_window_width","",0,comvt_BAD},
 {1,"bcx_getpixel","",0,comvt_BAD},
 {1,"bcx_gradient","",0,comvt_BAD},
 {1,"bcx_grayrect","",0,comvt_BAD},
 {1,"bcx_group","",0,comvt_BAD},
 {1,"bcx_hinstance","BCX_hInstance",2,comvt_BAD},
 {1,"bcx_icon","",0,comvt_BAD},
 {1,"bcx_initgui","",0,comvt_BAD},
 {1,"bcx_input","",0,comvt_BAD},
 {1,"bcx_label","",0,comvt_BAD},
 {1,"bcx_line","",0,comvt_BAD},
 {1,"bcx_lineto","",0,comvt_BAD},
 {1,"bcx_listbox","",0,comvt_BAD},
 {1,"bcx_listview","",0,comvt_BAD},
 {1,"bcx_loadbmp","",0,comvt_BAD},
 {1,"bcx_loadimage","",0,comvt_BAD},
 {1,"bcx_mdi_msgpump","",0,comvt_BAD},
 {1,"bcx_mdialog","",0,comvt_BAD},
 {1,"bcx_mdichild","BCX_MDICHILD",2,comvt_BAD},
 {1,"bcx_mdiclass","BCX_MDICLASS",2,comvt_BAD},
 {1,"bcx_mdiclient","BCX_MDICLIENT",2,comvt_BAD},
 {1,"bcx_msgpump","",0,comvt_BAD},
 {1,"bcx_ole_height","",0,comvt_BAD},
 {1,"bcx_ole_width","",0,comvt_BAD},
 {1,"bcx_olepicture","",0,comvt_BAD},
 {1,"bcx_pensize","",0,comvt_BAD},
 {1,"bcx_penstyle","",0,comvt_BAD},
 {1,"bcx_pie","",0,comvt_BAD},
 {1,"bcx_polar_line","",0,comvt_BAD},
 {1,"bcx_polar_pset","",0,comvt_BAD},
 {1,"bcx_polybezier","",0,comvt_BAD},
 {1,"bcx_polygon","",0,comvt_BAD},
 {1,"bcx_polyline","",0,comvt_BAD},
 {1,"bcx_popconsolesize","",0,comvt_BAD},
 {1,"bcx_preset","",0,comvt_BAD},
 {1,"bcx_print","",0,comvt_BAD},
 {1,"bcx_printex","",0,comvt_BAD},
 {1,"bcx_progressbar","",0,comvt_BAD},
 {1,"bcx_pset","",0,comvt_BAD},
 {1,"bcx_pushconsolesize","",0,comvt_BAD},
 {1,"bcx_put","",0,comvt_BAD},
 {1,"bcx_radio","",0,comvt_BAD},
 {1,"bcx_rectangle","",0,comvt_BAD},
 {1,"bcx_regwnd","",0,comvt_BAD},
 {1,"bcx_remtab","BCX_RemTab",2,comvt_BAD},
 {1,"bcx_resource","",0,comvt_BAD},
 {1,"bcx_richedit","",0,comvt_BAD},
 {1,"bcx_roundrect","",0,comvt_BAD},
 {1,"bcx_scalex","BCX_ScaleX",2,comvt_BAD},
 {1,"bcx_scaley","BCX_ScaleY",2,comvt_BAD},
 {1,"bcx_set_edit_color","",0,comvt_BAD},
 {1,"bcx_set_font","",0,comvt_BAD},
 {1,"bcx_set_form_color","",0,comvt_BAD},
 {1,"bcx_set_label_color","",0,comvt_BAD},
 {1,"bcx_set_text","",0,comvt_BAD},
 {1,"bcx_setbkgrdbrush","",0,comvt_BAD},
 {1,"bcx_setclassstyle","",0,comvt_BAD},
 {1,"bcx_setcolor","",0,comvt_BAD},
 {1,"bcx_setconsolesize","",0,comvt_BAD},
 {1,"bcx_setcursor","",0,comvt_BAD},
 {1,"bcx_seticon","",0,comvt_BAD},
 {1,"bcx_seticonsm","",0,comvt_BAD},
 {1,"bcx_setmetric","",0,comvt_BAD},
 {1,"bcx_setsplitpos","",0,comvt_BAD},
 {1,"bcx_show_com_errors","BCX_SHOW_COM_ERRORS",2,comvt_BAD},
 {1,"bcx_slider","",0,comvt_BAD},
 {1,"bcx_splitter","",0,comvt_BAD},
 {1,"bcx_status","",0,comvt_BAD},
 {1,"bcx_stricmp","",0,comvt_BAD},
 {1,"bcx_tab","",0,comvt_BAD},
 {1,"bcx_tabselect","",0,comvt_BAD},
 {1,"bcx_tempstr","BCX_TempStr",2,comvt_BAD},
 {1,"bcx_thread","",0,comvt_BAD},
 {1,"bcx_threadend","",0,comvt_BAD},
 {1,"bcx_threadkill","",0,comvt_BAD},
 {1,"bcx_threadresume","",0,comvt_BAD},
 {1,"bcx_threadsuspend","",0,comvt_BAD},
 {1,"bcx_threadwait","",0,comvt_BAD},
 {1,"bcx_tile","",0,comvt_BAD},
 {1,"bcx_toolbar","",0,comvt_BAD},
 {1,"bcx_tooltip","",0,comvt_BAD},
 {1,"bcx_treeview","",0,comvt_BAD},
 {1,"bcx_updown","",0,comvt_BAD},
 {1,"bcx_version$","",0,comvt_BAD},
 {1,"bcx_whiterect","",0,comvt_BAD},
 {1,"bcx_wnd","",0,comvt_BAD},
 {1,"bcx_wndclass","",0,comvt_BAD},
 {1,"bcxfont","BcxFont",2,comvt_BAD},
 {1,"bcxlib","BCXLIB",2,comvt_BAD},
 {1,"bcxpath$","",0,comvt_BAD},
 {1,"bcxsplitpath$","",0,comvt_BAD},
 {1,"bcxstrsize","BCXSTRSIZE",0,comvt_BAD},
 {1,"beep","Beep",2,comvt_BAD},
 {1,"begin","",0,comvt_BAD},
 {1,"bel$","",0,comvt_BAD},
 {1,"bff$","",0,comvt_BAD},
 {1,"bin$","",0,comvt_BAD},
 {1,"bin2dec","",0,comvt_I4},
 {1,"binary","",0,comvt_BAD},
 {3,"bnot","",0,comvt_BAD},
 {1,"bool","",0,comvt_BAD},
 {1,"bool$","",0,comvt_BAD},
 {1,"boolean","",0,comvt_BAD},
 {3,"bor","",0,comvt_BAD},
 {1,"bs$","",0,comvt_BAD},
 {1,"byref","",0,comvt_BAD},
 {1,"byte","unsigned char",2,comvt_BAD},
 {1,"byte_at","",0,comvt_BAD},
 {1,"c_declare","",0,comvt_BAD},
 {1,"call","",0,comvt_BAD},
 {1,"callback","",0,comvt_BAD},
 {1,"callwindowproc","",0,comvt_BAD},
 {1,"case","",0,comvt_BAD},
 {1,"catch","catch",3,comvt_BAD},
 {1,"cbctl","LOWORD(wParam)",2,comvt_BAD},
 {1,"cbctlmsg","HIWORD(wParam)",2,comvt_BAD},
 {1,"cbhndl","hWnd",2,comvt_BAD},
 {1,"cbhwnd","hWnd",2,comvt_BAD},
 {1,"cblparam","lParam",2,comvt_BAD},
 {1,"cbmsg","Msg",2,comvt_BAD},
 {1,"cbnmcode","((LPNMHDR)lParam)->code",2,comvt_BAD},
 {1,"cbnmhwnd","((LPNMHDR)lParam)->hwndFrom",2,comvt_BAD},
 {1,"cbnmid","((LPNMHDR)lParam)->idFrom",2,comvt_BAD},
 {1,"cbool","",0,comvt_BAD},
 {1,"cbwparam","wParam",2,comvt_BAD},
 {1,"cdbl","",0,comvt_BAD},
 {1,"ceil","ceil",2,comvt_BAD},
 {1,"center","",0,comvt_BAD},
 {1,"char","char",2,comvt_BAD},
 {1,"chdir","_chdir",2,comvt_BAD},
 {1,"chdrive","_chdir",2,comvt_BAD},
 {1,"chr$","",0,comvt_BAD},
 {1,"chrtoutf8$","",0,comvt_BAD},
 {1,"cint","",0,comvt_BAD},
 {1,"class","class",3,comvt_BAD},
 {1,"cldbl","",0,comvt_BAD},
 {1,"clear","",0,comvt_BAD},
 {1,"clipboard_getbitmap","",0,comvt_BAD},
 {1,"clipboard_gettext","",0,comvt_BAD},
 {1,"clipboard_gettextsize","",0,comvt_BAD},
 {1,"clipboard_reset","",0,comvt_BAD},
 {1,"clipboard_setbitmap","",0,comvt_BAD},
 {1,"clipboard_settext","",0,comvt_BAD},
 {1,"clng","",0,comvt_BAD},
 {1,"close","",0,comvt_BAD},
 {1,"close#","close",2,comvt_BAD},
 {1,"closedialog","",0,comvt_BAD},
 {1,"cls","",0,comvt_BAD},
 {1,"color","",0,comvt_BAD},
 {1,"color_bg","",0,comvt_BAD},
 {1,"color_fg","",0,comvt_BAD},
 {1,"colorref","COLORREF",2,comvt_BAD},
 {1,"com","COM",2,comvt_BAD},
 {1,"comboboxloadfile","",0,comvt_BAD},
 {1,"command$","",0,comvt_BAD},
 {1,"concat","",0,comvt_BAD},
 {1,"const","const",2,comvt_BAD},
 {1,"const_cast","const_cast",3,comvt_BAD},
 {1,"constructor","",1,comvt_BAD},
 {1,"containedin","",0,comvt_BAD},
 {1,"continue","continue",2,comvt_BAD},
 {1,"control","HWND",2,comvt_BAD},
 {1,"conwin","GetConsoleWindow()",2,comvt_BAD},
 {1,"copyfile","copyfile",2,comvt_BAD},
 {1,"cos","cos",2,comvt_R8},
 {1,"cosh","cosh",2,comvt_R8},
 {1,"cosl","cosl",2,comvt_BAD},
 {1,"cpad$","",0,comvt_BAD},
 {1,"cr$","",0,comvt_BAD},
 {1,"createobject","",0,comvt_BAD},
 {1,"createregint","",0,comvt_BAD},
 {1,"createregstring","",0,comvt_BAD},
 {1,"crlf$","",0,comvt_BAD},
 {1,"csng","",0,comvt_BAD},
 {1,"csrlin","",0,comvt_BAD},
 {1,"curdir$","",0,comvt_BAD},
 {1,"currency","CURRENCY",2,comvt_BAD},
 {1,"cursorx","",0,comvt_BAD},
 {1,"cursory","",0,comvt_BAD},
 {1,"cvd","",0,comvt_BAD},
 {1,"cvi","",0,comvt_BAD},
 {1,"cvl","",0,comvt_BAD},
 {1,"cvld","",0,comvt_BAD},
 {1,"cvs","",0,comvt_BAD},
 {1,"data","",0,comvt_BAD},
 {1,"data$","DATA$",2,comvt_BAD},
 {1,"date$","",0,comvt_BAD},
 {1,"ddq$","",0,comvt_BAD},
 {1,"declare","",16,comvt_BAD},
 {1,"decr","decr",2,comvt_BAD},
 {1,"degtorad","",0,comvt_BAD},
 {1,"del$","",0,comvt_BAD},
 {1,"delay","delay",2,comvt_BAD},
 {1,"delete","delete",3,comvt_BAD},
 {1,"deleteregkey","",0,comvt_BAD},
 {1,"descending","",0,comvt_BAD},
 {1,"destroysafearray","DestroySafeArray",0,comvt_BAD},
 {1,"destructor","",1,comvt_BAD},
 {1,"dialog","",0,comvt_BAD},
 {1,"dialogbox","DialogBox",2,comvt_BAD},
 {1,"dim","dim",2,comvt_BAD},
 {1,"diskfree","DiskFree",0,comvt_BAD},
 {1,"disksize","DiskSize",0,comvt_BAD},
 {1,"diskused","DiskUsed",0,comvt_BAD},
 {1,"do","do",2,comvt_BAD},
 {1,"doevents","",0,comvt_BAD},
 {1,"double","double",2,comvt_BAD},
 {1,"download","",0,comvt_BAD},
 {1,"downloadtostr","",0,comvt_BAD},
 {1,"dpi","dpi",2,comvt_BAD},
 {1,"dq$","",0,comvt_BAD},
 {1,"draw","",0,comvt_BAD},
 {1,"drawtransbmp","",0,comvt_BAD},
 {1,"dsplit","",0,comvt_BAD},
 {1,"dwl_dlgproc","DWLP_DLGPROC",2,comvt_BAD},
 {1,"dwl_msgresult","DWLP_MSGRESULT",2,comvt_BAD},
 {1,"dwl_user","DWLP_USER",2,comvt_BAD},
 {1,"dword","ULONG",2,comvt_BAD},
 {1,"dynamic","dynamic",2,comvt_BAD},
 {1,"dynamic_cast","dynamic_cast",3,comvt_BAD},
 {1,"editloadfile","",0,comvt_BAD},
 {1,"ejectpage","ejectpage",2,comvt_BAD},
 {1,"else","else",2,comvt_BAD},
 {1,"elseif","",0,comvt_BAD},
 {1,"enc$","",0,comvt_BAD},
 {1,"end","",0,comvt_BAD},
 {1,"enddraw","",0,comvt_BAD},
 {1,"endif","endif",2,comvt_BAD},
 {1,"endmodal","",0,comvt_BAD},
 {1,"enum","",0,comvt_BAD},
 {1,"environ$","",0,comvt_BAD},
 {1,"eof","",0,comvt_BAD},
 {1,"eof$","",0,comvt_BAD},
 {1,"equalto","",0,comvt_BAD},
 {1,"esc$","",0,comvt_BAD},
 {1,"events","events",0,comvt_BAD},
 {1,"exist","",0,comvt_BAD},
 {1,"exit","exit",2,comvt_BAD},
 {1,"exit_each","EXIT_EACH",2,comvt_BAD},
 {1,"exp","",0,comvt_R8},
 {1,"explicit","explicit",3,comvt_BAD},
 {1,"export","export",2,comvt_BAD},
 {1,"extern","extern",2,comvt_BAD},
 {1,"extract$","",0,comvt_BAD},
 {1,"extractany$","",0,comvt_BAD},
 {1,"fallthrough","fallthrough",2,comvt_BAD},
 {1,"false","",0,comvt_BAD},
 {1,"farproc","FARPROC",2,comvt_BAD},
 {1,"ff$","",0,comvt_BAD},
 {1,"file","FILE",2,comvt_BAD},
 {1,"filecopy","copyfile",2,comvt_BAD},
 {1,"filelocked","",0,comvt_BAD},
 {1,"fillarray","",0,comvt_BAD},
 {1,"findfirst$","",0,comvt_BAD},
 {1,"findfirstinstance","",0,comvt_BAD},
 {1,"findintype","",0,comvt_BAD},
 {1,"findnext$","",0,comvt_BAD},
 {1,"finput","finput",2,comvt_BAD},
 {1,"fint","",0,comvt_INT},
 {1,"fix","",0,comvt_R4},
 {1,"float","float",2,comvt_BAD},
 {1,"floor","floor",2,comvt_BAD},
 {1,"flush","flush",2,comvt_BAD},
 {1,"for","",0,comvt_BAD},
 {1,"for_each","",0,comvt_BAD},
 {1,"formload","FormLoad",2,comvt_BAD},
 {1,"fprint","fprint",2,comvt_BAD},
 {1,"frac","",0,comvt_R8},
 {1,"fracl","",0,comvt_BAD},
 {1,"free","free",2,comvt_BAD},
 {1,"freefile","",0,comvt_BAD},
 {1,"freeglobals","FreeGlobals",2,comvt_BAD},
 {1,"freelibrary","FreeLibrary",2,comvt_BAD},
 {1,"friend","",1,comvt_BAD},
 {1,"from","from",2,comvt_BAD},
 {1,"funcname$","__func__$",2,comvt_BAD},
 {1,"function","",0,comvt_BAD},
 {1,"fwrite","fwrite",2,comvt_BAD},
 {1,"gcl_hbrbackground","GCLP_HBRBACKGROUND",2,comvt_BAD},
 {1,"gcl_hcursor","GCLP_HCURSOR",2,comvt_BAD},
 {1,"gcl_hicon","GCLP_HICON",2,comvt_BAD},
 {1,"gcl_hiconsm","GCLP_HICONSM",2,comvt_BAD},
 {1,"gcl_hmodule","GCLP_HMODULE",2,comvt_BAD},
 {1,"gcl_menuname","GCLP_MENUNAME",2,comvt_BAD},
 {1,"gcl_wndproc","GCLP_WNDPROC",2,comvt_BAD},
 {1,"get","~get",2,comvt_BAD},
 {1,"get$","~get",2,comvt_BAD},
 {1,"getattr","",0,comvt_BAD},
 {1,"getbmp","",0,comvt_BAD},
 {1,"getbvalue","GetBValue",2,comvt_BAD},
 {1,"getch","_getch",2,comvt_BAD},
 {1,"getdimension","",0,comvt_BAD},
 {1,"getdlgitem","GetDlgItem",2,comvt_BAD},
 {1,"getdrive","",0,comvt_BAD},
 {1,"getfilename$","",0,comvt_BAD},
 {1,"getgvalue","GetGValue",2,comvt_BAD},
 {1,"gethttpfilesize","",0,comvt_BAD},
 {1,"getobject","",0,comvt_BAD},
 {1,"getprocaddress","",0,comvt_BAD},
 {1,"getresource","",0,comvt_BAD},
 {1,"getrvalue","GetRValue",2,comvt_BAD},
 {1,"getsaveasfilename","",0,comvt_BAD},
 {1,"getspecialfolder","",0,comvt_BAD},
 {1,"getspecialfolder$","",0,comvt_BAD},
 {1,"getspecialfolderex$","",0,comvt_BAD},
 {1,"gettextsize","",0,comvt_BAD},
 {1,"getwindowlong","GetWindowLongPtr",2,comvt_BAD},
 {1,"global","global",2,comvt_BAD},
 {1,"gosub","gosub",2,comvt_BAD},
 {1,"goto","goto",2,comvt_BAD},
 {1,"gui","gui",2,comvt_BAD},
 {1,"gwl_hinstance","GWLP_HINSTANCE",2,comvt_BAD},
 {1,"gwl_hwndparent","GWLP_HWNDPARENT",2,comvt_BAD},
 {1,"gwl_id","GWLP_ID",2,comvt_BAD},
 {1,"gwl_userdata","GWLP_USERDATA",2,comvt_BAD},
 {1,"gwl_wndproc","GWLP_WNDPROC",2,comvt_BAD},
 {1,"hex$","",0,comvt_BAD},
 {1,"hex2dec","",0,comvt_I4},
 {1,"hibyte","HIBYTE",2,comvt_BAD},
 {1,"hide","",0,comvt_BAD},
 {1,"hiword","HIWORD",2,comvt_BAD},
 {1,"hypot","hypot",2,comvt_R8},
 {1,"hypotl","hypotl",2,comvt_R8},
 {1,"iabs","abs",2,comvt_BAD},
 {1,"icompare","",0,comvt_BAD},
 {1,"icon","icon",2,comvt_BAD},
 {1,"if","if",16,comvt_BAD},
 {1,"iif","",0,comvt_R8},
 {1,"iif$","",0,comvt_BAD},
 {1,"iinstr","",0,comvt_BAD},
 {1,"iinstrany","",0,comvt_BAD},
 {1,"imod","",0,comvt_BAD},
 {1,"impfunction","impfunction",3,comvt_BAD},
 {1,"in","in",0,comvt_BAD},
 {1,"inchr","",0,comvt_R4},
 {1,"incr","incr",2,comvt_BAD},
 {1,"infobox","",0,comvt_BAD},
 {1,"initsafearray","InitSafeArray",0,comvt_BAD},
 {1,"inkey","",0,comvt_BAD},
 {1,"inkey$","",0,comvt_BAD},
 {1,"inline","",1,comvt_BAD},
 {1,"inp","",0,comvt_BAD},
 {1,"input","",0,comvt_BAD},
 {1,"inputbox$","",0,comvt_BAD},
 {1,"inputbuffer$","InputBuffer$",0,comvt_BAD},
 {1,"ins$","",0,comvt_BAD},
 {1,"instat","_kbhit()",2,comvt_BAD},
 {1,"instr","",0,comvt_R4},
 {1,"instrany","",0,comvt_BAD},
 {1,"instrrev","",0,comvt_R4},
 {1,"int","int",2,comvt_BAD},
 {1,"integer","int",2,comvt_BAD},
 {1,"iremove","",16,comvt_BAD},
 {1,"iremove$","",0,comvt_BAD},
 {1,"iremoveany$","",0,comvt_BAD},
 {1,"ireplace","",16,comvt_BAD},
 {1,"ireplace$","",0,comvt_BAD},
 {1,"ireplaceany$","",0,comvt_BAD},
 {1,"is","is",2,comvt_BAD},
 {1,"isdigit","isdigit",2,comvt_BAD},
 {1,"isobject","ISOBJECT",2,comvt_BAD},
 {1,"isodate","",0,comvt_BAD},
 {1,"isptr","",0,comvt_BAD},
 {1,"ispunct","ispunct",2,comvt_BAD},
 {1,"iswxdigit","iswxdigit",2,comvt_BAD},
 {1,"iterate","continue",2,comvt_BAD},
 {1,"join$","",0,comvt_BAD},
 {1,"keypress","",0,comvt_BAD},
 {1,"kill","kill",2,comvt_BAD},
 {1,"labs","labs",2,comvt_BAD},
 {1,"land","",0,comvt_BAD},
 {3,"lcase$","",0,comvt_BAD},
 {1,"lccpath$","",0,comvt_BAD},
 {1,"ldouble","",0,comvt_BAD},
 {1,"left$","",0,comvt_BAD},
 {1,"leftstr","",0,comvt_BAD},
 {1,"len","(int)strlen",2,comvt_R4},
 {1,"lf$","",0,comvt_BAD},
 {1,"lib","lib",2,comvt_BAD},
 {1,"libmain","dllmain",2,comvt_BAD},
 {1,"like","",0,comvt_BAD},
 {1,"like_instr","",0,comvt_BAD},
 {1,"line","",0,comvt_BAD},
 {1,"listboxloadfile","",0,comvt_BAD},
 {1,"llabs","llabs",2,comvt_BAD},
 {1,"load_dll","LoadLibrary",2,comvt_BAD},
 {1,"loadfile$","",0,comvt_BAD},
 {1,"loadlibrary","LoadLibrary",2,comvt_BAD},
 {1,"lobyte","LOBYTE",2,comvt_BAD},
 {1,"loc","",0,comvt_BAD},
 {1,"local","",0,comvt_BAD},
 {1,"locate","",0,comvt_BAD},
 {1,"lof","",0,comvt_R8},
 {1,"log","log",2,comvt_R8},
 {1,"log10","log10",2,comvt_R8},
 {1,"log10l","log10l",2,comvt_BAD},
 {1,"logl","logl",2,comvt_BAD},
 {1,"long","long",2,comvt_BAD},
 {1,"longest","",0,comvt_BAD},
 {1,"longlong","LONGLONG",2,comvt_BAD},
 {1,"lookahead","",0,comvt_BAD},
 {1,"loop","loop",2,comvt_BAD},
 {1,"lor","",0,comvt_BAD},
 {1,"loword","LOWORD",2,comvt_BAD},
 {1,"lpad$","",0,comvt_BAD},
 {1,"lpbyte","LPBYTE",2,comvt_BAD},
 {1,"lprint","",0,comvt_BAD},
 {1,"lpstr","PSTR",2,comvt_BAD},
 {1,"lresult","LRESULT",2,comvt_BAD},
 {1,"ltoa","_ltoa",2,comvt_BAD},
 {1,"ltrim$","",0,comvt_BAD},
 {1,"macro","const",2,comvt_BAD},
 {1,"main","main",2,comvt_BAD},
 {1,"makedword","MAKELONG",2,comvt_BAD},
 {1,"makeintresource","MAKEINTRESOURCE",2,comvt_BAD},
 {1,"makelong","MAKELONG",2,comvt_BAD},
 {1,"makeword","MAKEWORD",2,comvt_BAD},
 {1,"max","",0,comvt_R8},
 {3,"mcase$","",0,comvt_BAD},
 {1,"mdigui","mdigui",2,comvt_BAD},
 {1,"me","",0,comvt_BAD},
 {1,"memicmp","_memicmp",2,comvt_BAD},
 {1,"memsize","_msize",2,comvt_BAD},
 {1,"mid$","",0,comvt_BAD},
 {1,"min","",0,comvt_R8},
 {1,"mkd$","",0,comvt_BAD},
 {1,"mkdir","_mkdir",2,comvt_BAD},
 {1,"mki$","",0,comvt_BAD},
 {1,"mkl$","",0,comvt_BAD},
 {1,"mkld$","",0,comvt_BAD},
 {1,"mks$","",0,comvt_BAD},
 {1,"mod","fmod",2,comvt_BAD},
 {1,"modstyle","",0,comvt_BAD},
 {1,"mouse_cx","",0,comvt_BAD},
 {1,"mouse_cy","",0,comvt_BAD},
 {1,"mouse_sx","",0,comvt_BAD},
 {1,"mouse_sy","",0,comvt_BAD},
 {1,"msgbox","",0,comvt_BAD},
 {1,"namespace","namespace",3,comvt_BAD},
 {1,"nest","nest",2,comvt_BAD},
 {1,"new","",1,comvt_BAD},
 {1,"newbmp","",0,comvt_BAD},
 {1,"next","next",34,comvt_BAD},
 {1,"next_each","",0,comvt_BAD},
 {1,"nextlinelen","",0,comvt_BAD},
 {1,"nosort","WS_CHILD|WS_VISIBLE|WS_VSCROLL",2,comvt_BAD},
 {1,"not","",0,comvt_BAD},
 {1,"notequalto","",0,comvt_BAD},
 {1,"nothing","",0,comvt_BAD},
 {1,"now$","",0,comvt_BAD},
 {1,"nul$","",0,comvt_BAD},
 {1,"null","NULL",2,comvt_BAD},
 {1,"object","",0,comvt_BAD},
 {1,"oct$","",0,comvt_BAD},
 {1,"on","on",0,comvt_BAD},
 {1,"open","",0,comvt_BAD},
 {1,"operator","",0,comvt_BAD},
 {1,"option","option",2,comvt_BAD},
 {1,"optional","optional",2,comvt_BAD},
 {1,"or","",0,comvt_BAD},
 {1,"orelse","",0,comvt_BAD},
 {1,"osversion","",0,comvt_BAD},
 {1,"outp","",0,comvt_BAD},
 {1,"output","",0,comvt_BAD},
 {1,"outpw","",0,comvt_BAD},
 {1,"overloaded","",0,comvt_BAD},
 {1,"panel","",0,comvt_BAD},
 {1,"pause","",0,comvt_BAD},
 {1,"pchar","PCHAR",2,comvt_BAD},
 {1,"peek$","",0,comvt_BAD},
 {1,"pellespath$","",0,comvt_BAD},
 {1,"pi","",0,comvt_BAD},
 {1,"pixels","pixels",2,comvt_BAD},
 {1,"playwav","",0,comvt_BAD},
 {1,"poke","memcpy",2,comvt_BAD},
 {1,"popcolors","",0,comvt_BAD},
 {1,"pos","",0,comvt_R4},
 {1,"pow","pow",2,comvt_R8},
 {1,"powl","powl",2,comvt_BAD},
 {1,"pptype","pptype",2,comvt_BAD},
 {1,"prepend","prepend",2,comvt_BAD},
 {1,"preserve","PRESERVE",2,comvt_BAD},
 {1,"print","",0,comvt_BAD},
 {1,"print#","fprint",2,comvt_BAD},
 {1,"printer","",0,comvt_BAD},
 {1,"private","",1,comvt_BAD},
 {1,"program","program",2,comvt_BAD},
 {1,"property","property",3,comvt_BAD},
 {1,"protected","",1,comvt_BAD},
 {1,"ps_dash","PS_DASH",2,comvt_BAD},
 {1,"ps_dashdot","PS_DASHDOT",2,comvt_BAD},
 {1,"ps_dashdotdot","PS_DASHDOTDOT",2,comvt_BAD},
 {1,"ps_dot","PS_DOT",2,comvt_BAD},
 {1,"ps_solid","PS_SOLID",2,comvt_BAD},
 {1,"pstr","PSTR",2,comvt_BAD},
 {1,"ptr","",0,comvt_BAD},
 {1,"public","",1,comvt_BAD},
 {1,"pushcolors","",0,comvt_BAD},
 {1,"put","~put",2,comvt_BAD},
 {1,"put$","~put",2,comvt_BAD},
 {1,"qbcolor","",0,comvt_BAD},
 {1,"qsort","qsort",2,comvt_BAD},
 {1,"qsortidx","qsortidx",2,comvt_BAD},
 {1,"radtodeg","",0,comvt_BAD},
 {1,"randomize","",0,comvt_BAD},
 {1,"raw","raw",2,comvt_BAD},
 {1,"read","",0,comvt_BAD},
 {1,"read$","",0,comvt_BAD},
 {1,"rec","",0,comvt_BAD},
 {1,"reccount","",0,comvt_BAD},
 {1,"reclen","reclen",2,comvt_BAD},
 {1,"record","record",2,comvt_BAD},
 {1,"redim","redim",2,comvt_BAD},
 {1,"refresh","",0,comvt_BAD},
 {1,"regexist","",0,comvt_BAD},
 {1,"regint","",0,comvt_BAD},
 {1,"register","register",2,comvt_BAD},
 {1,"regstring$","",0,comvt_BAD},
 {1,"reinterpret_cast","reinterpret_cast",3,comvt_BAD},
 {1,"release","",0,comvt_BAD},
 {1,"rem","rem",0,comvt_BAD},
 {1,"remain$","",0,comvt_BAD},
 {1,"remove","remove",18,comvt_BAD},
 {1,"remove$","",0,comvt_BAD},
 {1,"removeany$","",0,comvt_BAD},
 {1,"rename","rename",2,comvt_BAD},
 {1,"repeat","repeat",0,comvt_BAD},
 {1,"repeat$","",0,comvt_BAD},
 {1,"replace","replace",18,comvt_BAD},
 {1,"replace$","",0,comvt_BAD},
 {1,"replaceany$","",0,comvt_BAD},
 {1,"resume","",0,comvt_BAD},
 {1,"retain$","",0,comvt_BAD},
 {1,"return","return",2,comvt_BAD},
 {1,"reverse$","",0,comvt_BAD},
 {1,"rewind","",0,comvt_BAD},
 {1,"right$","",0,comvt_BAD},
 {1,"rightstr","",0,comvt_BAD},
 {1,"rmdir","_rmdir",2,comvt_BAD},
 {1,"rnd","",0,comvt_R4},
 {1,"rnd2","",0,comvt_R4},
 {1,"round","",0,comvt_R8},
 {1,"rpad$","",0,comvt_BAD},
 {1,"rtrim$","",0,comvt_BAD},
 {1,"run","",0,comvt_BAD},
 {1,"savebmp","",0,comvt_BAD},
 {1,"scanerror","ScanError",2,comvt_BAD},
 {1,"schar","signed char",2,comvt_BAD},
 {1,"screen","",0,comvt_BAD},
 {1,"searchpath$","",0,comvt_BAD},
 {1,"seek","seek",2,comvt_BAD},
 {1,"select","select",2,comvt_BAD},
 {1,"sendmessage","",0,comvt_BAD},
 {1,"set","",0,comvt_BAD},
 {1,"set_bcx_bitmap","",0,comvt_BAD},
 {1,"set_bcx_bitmap2","",0,comvt_BAD},
 {1,"set_bcx_bmpbutton","",0,comvt_BAD},
 {1,"set_bcx_icon","",0,comvt_BAD},
 {1,"setattr","",0,comvt_BAD},
 {1,"setdimension","",0,comvt_BAD},
 {1,"seteof","SetEof",2,comvt_BAD},
 {1,"setmode","_setmode",2,comvt_BAD},
 {1,"setwindowlong","SetWindowLongPtr",2,comvt_BAD},
 {1,"setwindowrtftext","",0,comvt_BAD},
 {1,"sgn","",0,comvt_R4},
 {1,"shared","shared",2,comvt_BAD},
 {1,"shell","shell",2,comvt_BAD},
 {1,"shl","",0,comvt_BAD},
 {1,"short","short",2,comvt_BAD},
 {1,"show","",0,comvt_BAD},
 {1,"showmodal","",0,comvt_BAD},
 {1,"shr","",0,comvt_BAD},
 {1,"sin","sin",2,comvt_R8},
 {1,"single","float",2,comvt_BAD},
 {1,"sinh","sinh",2,comvt_R8},
 {1,"sinl","sinl",2,comvt_BAD},
 {1,"size_t","size_t",2,comvt_R4},
 {1,"sizeof","sizeof",2,comvt_R4},
 {1,"sleep","",0,comvt_BAD},
 {1,"sndmsg","",0,comvt_BAD},
 {1,"sound","",0,comvt_BAD},
 {1,"space$","",0,comvt_BAD},
 {1,"spc$","",0,comvt_BAD},
 {1,"split","",0,comvt_BAD},
 {1,"splitbarbg","SplitBarBG",2,comvt_BAD},
 {1,"splitbarfg","SplitBarFG",2,comvt_BAD},
 {1,"sprint","sprint",2,comvt_BAD},
 {1,"sqr","sqrt",2,comvt_R8},
 {1,"sqrl","sqrtl",2,comvt_BAD},
 {1,"sqrt","sqrt",2,comvt_R8},
 {1,"sqrtl","sqrtl",2,comvt_BAD},
 {1,"sshort","signed short",2,comvt_BAD},
 {1,"startdraw","",0,comvt_BAD},
 {1,"static","static",2,comvt_BAD},
 {1,"static_cast","static_cast",3,comvt_BAD},
 {1,"stdcall","",0,comvt_BAD},
 {1,"step","",0,comvt_BAD},
 {1,"str$","",0,comvt_BAD},
 {1,"str2variant","",0,comvt_BAD},
 {1,"strarray","PSTR*",2,comvt_BAD},
 {1,"strim$","",0,comvt_BAD},
 {1,"string","string",2,comvt_BAD},
 {1,"string$","",0,comvt_BAD},
 {1,"strl$","",0,comvt_BAD},
 {1,"strptr","",0,comvt_BAD},
 {1,"strtoken$","",0,comvt_BAD},
 {1,"struct","struct",0,comvt_BAD},
 {1,"sub","sub",0,comvt_BAD},
 {1,"swap","",0,comvt_BAD},
 {1,"sysdir$","",0,comvt_BAD},
 {1,"sysstr","",0,comvt_BAD},
 {1,"tab$","",0,comvt_BAD},
 {1,"tally","",0,comvt_R4},
 {1,"tan","tan",2,comvt_R8},
 {1,"tanh","tanh",2,comvt_R8},
 {1,"tanl","tanl",2,comvt_BAD},
 {1,"tempdir$","",0,comvt_BAD},
 {1,"tempfilename$","",0,comvt_BAD},
 {1,"template","template",2,comvt_BAD},
 {1,"textmode","",0,comvt_BAD},
 {1,"then","",0,comvt_BAD},
 {1,"this","this",3,comvt_BAD},
 {1,"throw","throw",3,comvt_BAD},
 {1,"time$","",0,comvt_BAD},
 {1,"timer","",0,comvt_R4},
 {1,"to","to",0,comvt_BAD},
 {1,"trim$","",0,comvt_BAD},
 {1,"true","",0,comvt_BAD},
 {1,"try","try",3,comvt_BAD},
 {1,"type","type",2,comvt_BAD},
 {1,"typeid","typeid$",3,comvt_BAD},
 {1,"typename","",1,comvt_BAD},
 {1,"ubound","",0,comvt_BAD},
 {1,"ubound_d","",0,comvt_BAD},
 {1,"ubound_s","",0,comvt_BAD},
 {1,"ubyte","unsigned char",2,comvt_BAD},
 {3,"ucase$","",0,comvt_BAD},
 {1,"uchar","UCHAR",2,comvt_BAD},
 {1,"uint","UINT",2,comvt_BAD},
 {1,"uint64","UINT64",2,comvt_BAD},
 {1,"ulong","ULONG",2,comvt_BAD},
 {1,"ulonglong","ULONGLONG",2,comvt_BAD},
 {1,"uncom","UNCOM",0,comvt_BAD},
 {1,"union","union",2,comvt_BAD},
 {1,"until","",0,comvt_BAD},
 {1,"unwrap$","",0,comvt_BAD},
 {1,"ushort","USHORT",2,comvt_BAD},
 {1,"using","using",3,comvt_BAD},
 {1,"using$","",0,comvt_BAD},
 {1,"utf8tochr","",0,comvt_BAD},
 {1,"val","",0,comvt_R8},
 {1,"vall","",0,comvt_BAD},
 {1,"variant","VARIANT",2,comvt_BAD},
 {1,"variant2str","",0,comvt_BAD},
 {1,"vbs_addcode","",0,comvt_BAD},
 {1,"vbs_error$","",0,comvt_BAD},
 {1,"vbs_eval_num","",0,comvt_BAD},
 {1,"vbs_eval_num#","",0,comvt_BAD},
 {1,"vbs_eval_str$","",0,comvt_BAD},
 {1,"vbs_reset","",0,comvt_BAD},
 {1,"vbs_run_script","",0,comvt_BAD},
 {1,"vbs_start","",0,comvt_BAD},
 {1,"vbs_stop","",0,comvt_BAD},
 {1,"vchr$","",0,comvt_BAD},
 {1,"vector","",0,comvt_BAD},
 {1,"verify","",0,comvt_BAD},
 {1,"virtual","",1,comvt_BAD},
 {1,"vt$","",0,comvt_BAD},
 {1,"wchar","WCHAR",2,comvt_BAD},
 {1,"wend","wend",2,comvt_BAD},
 {1,"while","",0,comvt_BAD},
 {1,"widetoansi$","",0,comvt_BAD},
 {1,"winbool","winbool",2,comvt_BAD},
 {1,"windir$","",0,comvt_BAD},
 {1,"winmain","",0,comvt_BAD},
 {1,"with","",0,comvt_BAD},
 {1,"wndproc","",0,comvt_BAD},
 {1,"word","WORD",2,comvt_BAD},
 {1,"wrap$","",0,comvt_BAD},
 {1,"write","write",2,comvt_BAD},
 {1,"wstring","PWSTR",2,comvt_BAD},
 {3,"xor","",0,comvt_BAD},
 {1,"zzzz","zzzz",0,comvt_BAD}
};

// *************************************************
//                 Runtime Functions
// *************************************************

char *BCX_TempStr(size_t iBytes)
{
  static int StrCnt;
  static char *StrFunc[2048];
  static CRITICAL_SECTION cs;
  static LONG initialized = 0;
  // Thread-safe one-time initialization
  if (InterlockedCompareExchange(&initialized, 1, 0) == 0) {
      InitializeCriticalSection(&cs);
  }
  // Allocating memory before locking reduces lock duration and blocking.
  char *newStr = (char *)calloc(iBytes + 1, sizeof(char));
  if (!newStr) return NULL;
  EnterCriticalSection(&cs);
      StrCnt = (StrCnt + 1) & 2047;
      if (StrFunc[StrCnt]) {
        free(StrFunc[StrCnt]);
      }
      StrFunc[StrCnt] = newStr;
  LeaveCriticalSection(&cs);
  return StrFunc[StrCnt];
}

char *left (LPCTSTR szSrc, int length)
{
  size_t tmplen = strlen(szSrc);
  if (length < 1) return BCX_TempStr(1);
  if (length < (int)tmplen) tmplen = length;
  char *strtmp = BCX_TempStr(tmplen);
  return (char*)memcpy(strtmp, szSrc, tmplen);
}

char *right (LPCTSTR szSrc, int length)
{
  size_t tmplen = strlen(szSrc);
  if (length < 1) return BCX_TempStr(1);
  if ((size_t)length >= tmplen) return strcpy(BCX_TempStr(tmplen), szSrc);
  return strcpy(BCX_TempStr(length), szSrc + (tmplen - length));
}

char *cpad (LPCTSTR szStr, int i_Max, int c)
{
  char  fill[2]={0}; fill[0] = (char) c;
  char *szTmp = BCX_TempStr(i_Max);
  size_t Half = (i_Max/2) + (strlen(szStr)/2);
  strcpy(szTmp, szStr);
  while((int)strlen(szTmp) < (int)Half)
  {
    strcpy(szTmp, join(2, fill, szTmp));
  }
  while((int)strlen(szTmp)<i_Max)
  {
    strcat(szTmp, fill);
  }
  szTmp[i_Max] = 0;
  return szTmp;
}

char *rpad (LPCTSTR szStr, int L, int c)
{
  char *strtmp;
  int s = (int)strlen(szStr);
  if ((L-s) < 1) return (char*)szStr;
  strtmp = BCX_TempStr(strlen(szStr)+L);
  strcpy (strtmp, szStr);
  memset (&strtmp[s], c, (L-s));
  return strtmp;
}

char *lpad (LPCTSTR szStr, int L, int c)
{
  char *strtmp;
  int s = L-(int)strlen(szStr);
  if (s < 1) return (char*)szStr;
  strtmp = BCX_TempStr(L);
  memset (strtmp, c, s);
  return strcat(strtmp, szStr);
}

char *mid (LPCTSTR szSrc, int start, int length)
{
  char *strtmp;
  int tmplen = (int)strlen(szSrc);
  if (start > tmplen||start < 1) return BCX_TempStr(1);
  if (length < 0 || length > (tmplen-start) + 1)
    length = (tmplen-start) + 1;
  strtmp = BCX_TempStr(length);
  return (char*)memcpy(strtmp, &szSrc[start - 1], length);
}

char *trim (LPCTSTR szSrc)
{
  if (0 == szSrc[0]) return (char*)szSrc;
  while(*szSrc == 32 || (*szSrc >= 9 && *szSrc <= 13)) szSrc++;
  size_t i = strlen(szSrc);
  while(i > 0 && (szSrc[i-1] == 32 || (szSrc[i-1] >= 9 && szSrc[i-1] <= 13))) i--;
  char *strtmp = BCX_TempStr(i);
  return (char*)memcpy(strtmp, szSrc, i);
}

char *ltrim (LPCTSTR szSrc, char c)
{
  if (0 == szSrc[0]) return (char*) szSrc;
  while(*szSrc==32 || (*szSrc >= 9 && *szSrc <= 13) || *szSrc == c) szSrc++;
  char *strtmp = BCX_TempStr(strlen(szSrc));
  return strcpy(strtmp, szSrc);
}

char *rtrim (LPCTSTR szSrc, char c)
{
  if (0 == szSrc[0]) return (char*)szSrc;
  size_t i = strlen(szSrc);
  while(i > 0 && (szSrc[i-1]==32 || (szSrc[i-1]>=9 && szSrc[i-1]<=13) || szSrc[i-1]==c)) i--;
  char *strtmp = BCX_TempStr(i);
  return (char*)memcpy(strtmp, szSrc, i);
}

char *strim (LPCTSTR szSrc)
{
  if (0 == szSrc[0]) return (char*) szSrc;
  char *strtmp = BCX_TempStr(strlen(szSrc));
  char *dst = strtmp;
  while (isspace((unsigned char)*szSrc)) szSrc++;
  do
  {
    while (*szSrc && !isspace((unsigned char)*szSrc)) *dst++ = *szSrc++;
    if (*szSrc)
    {
      *dst++ = *szSrc++;
      while (isspace((unsigned char)*szSrc)) szSrc++;
    }
  }
  while (*szSrc);
  if (isspace((unsigned char)*(--dst))) *dst = 0;
  return strtmp;
}

char *command (int nArg)
{
  int ii = 0;
  char *c = NULL, *retstr, *s = GetCommandLine();
  if (nArg < ii) // return entire commandline
  {
    while(*s && *s != 32)
    {
      if (*s == 34) while(*++s && *s != 34);
      s++;
    }
    while(isspace((unsigned char)*s))s++;
    retstr = BCX_TempStr(strlen(s)+1);
    strcpy(retstr, s);
    if (*(retstr + strlen(retstr)-1)==20) *retstr=0;
    return retstr;
  }
  while(ii <= nArg)
  {
    while(isspace((unsigned char)*s)) s++; // skip whitespace
    c = s;
    if (*s == 34) {              // argument starts a quote
      while(*++s && *s != 34)    // skip until next quote
        ;                        // Do NOT remove this semicolon
      if (*s) s++;               // skip quote itself
    }
    else
    {
      while(*s && *s != 32) s++;
    }
    ii++;
  }
  if (*c == 34)
  {
    c++;                       // skip leading quote
    if (*(s-1) == 34) s--;     // skip any trailing quotes
  }
  retstr = BCX_TempStr((int)(s - c) + 1);
  strncpy(retstr, c,(int)(s - c));
  retstr[s-c]=0;
  return retstr;
}

char *extract (LPCTSTR strSrc, LPCTSTR strPattern)
{
  LPCTSTR szMatch;
  char *strtmp = BCX_TempStr(strlen(strSrc));
  if (*strPattern != 0)
  {
    szMatch = strstr(strSrc, strPattern);
    if (szMatch) return (char*)memcpy(strtmp, strSrc, szMatch-strSrc);
  }
  return strcpy(strtmp, strSrc);
}

char *remain (LPCTSTR strSrc, LPCTSTR strPattern)
{
  LPCTSTR p = strstr(strSrc, strPattern);
  if (p)
  {
    p += (strlen(strPattern));
    return (char*)p;
  }
  return (char*)strSrc;
}

char *replace (LPCTSTR szMain, LPCTSTR szFind, LPCTSTR szRepl)
{
  size_t LenPat, LenRep, iTmp, iChange;
  char *strtmp, *cp_p, *cp_q, *cp_r;
  if (!szFind || !*szFind) return (char*) szMain;
  LenRep = strlen(szRepl);
  LenPat = strlen(szFind);
  for (iTmp = 0, cp_p = (char*)szMain;
       (cp_q = strstr(cp_p, (char*)szFind))!=0;
       cp_p = cp_q + LenPat)
    iTmp += (int)(cp_q - cp_p) + LenRep;
  iTmp += strlen(cp_p);
  strtmp = BCX_TempStr(iTmp);
  if (!strtmp) return NULL;
  for (cp_r = strtmp, cp_p=(char*)szMain;
       (cp_q=strstr(cp_p,(char*)szFind))!=0;
       cp_p = cp_q + LenPat)
  {
    iChange = (int)(cp_q-cp_p);
    memcpy(cp_r, cp_p, iChange); cp_r += iChange;
    strcpy(cp_r, szRepl); cp_r += LenRep;
  }
  strcpy(cp_r, cp_p);
  return strtmp;
}

char *iReplace (LPCTSTR szMain, LPCTSTR szFind, LPCTSTR szRepl)
{
  size_t LenPat, LenRep, tmpsz, iChange;
  char *strtmp, *cp_p, *cp_q, *cp_r;
  if (!szFind || !*szFind) return (char*)szMain;
  LenRep = (int)strlen(szRepl);
  LenPat = (int)strlen(szFind);
  for (tmpsz=0, cp_p = (char*)szMain;
       (cp_q =_stristr_(cp_p,(char*)szFind))!= 0;
       cp_p = cp_q + LenPat)
    tmpsz += (int)(cp_q - cp_p) + LenRep;
  tmpsz += strlen(cp_p);
  strtmp = BCX_TempStr(tmpsz);
  if (!strtmp) return NULL;
  for (cp_r = strtmp,cp_p=(char*)szMain;
       (cp_q =_stristr_(cp_p,(char*)szFind))!=0;
       cp_p = cp_q + LenPat)
  {
    iChange = (int) (cp_q-cp_p);
    memcpy(cp_r, cp_p, iChange);
    cp_r += iChange;
    strcpy(cp_r,(char*)szRepl);
    cp_r += LenRep;
  }
  strcpy(cp_r,cp_p);
  return strtmp;
}

char *RemoveAny (LPCTSTR MainStr, LPCTSTR CharsToRemove)
{
    char *BCX_RetStr = NULL;
    char ResultStr[BCXSTRSIZE]={0};
    int i = 0;
    int j = 0;
    int MainLen  = (int)strlen(MainStr);
    int CharsLen = (int)strlen(CharsToRemove);
    int CharToRemoveFlag[255]={0};
    int ResultLen = 0;
    // Set flags for characters to be removed
    for (j = 0; j < CharsLen; j++) {
        CharToRemoveFlag[(unsigned char)CharsToRemove[j]] = 1;
    }
    for (i = 0; i < MainLen; i++) {
        if (CharToRemoveFlag[(unsigned char)MainStr[i]] == 0) {
            ResultStr[ResultLen++] = MainStr[i];
        }
    }
    ResultStr[ResultLen] = 0; // Null-terminate
    BCX_RetStr = BCX_TempStr(ResultLen);
    strcpy(BCX_RetStr, ResultStr);
    return BCX_RetStr;
}

void BCX_Sleep (int Milliseconds)
{
  static UINT Initialized;
  static UINT OriginalPeriod;
  static UINT CallCount;
  // If called with 0, explicitly reset timer resolution and exit
  if(Milliseconds <= 0 || CallCount >=65535){
      if(Initialized){
          timeEndPeriod(OriginalPeriod);
          Initialized = FALSE;
        }
      return;
    }
  // Set timer resolution to 1 ms if not already initialized
  if(!Initialized){
      TIMECAPS  tMinRes;
      timeGetDevCaps(&tMinRes,sizeof(TIMECAPS));
      OriginalPeriod = tMinRes.wPeriodMin;
      timeBeginPeriod(OriginalPeriod); // Typically sets to 1 ms
      Initialized = TRUE;
    }
  Sleep(Milliseconds);
}

char *findfirst (LPCTSTR szSrc)
{
  char *strtmp = BCX_TempStr(BCXSTRSIZE);
  if (fffn_FileHandle) FindClose(fffn_FileHandle);
  fffn_FileHandle = FindFirstFile(szSrc, &fffn_FindData);
  if (fffn_FileHandle != INVALID_HANDLE_VALUE)
    strcpy(strtmp, fffn_FindData.cFileName);
  else
    fffn_FileHandle = 0;
  return strtmp;
}

char *LookAhead(FILE *FilePointer, int NumLines) {
    char *EmptyStr = "";
    char *BCX_RetStr = NULL;
    fpos_t CurrentPosition;
    char FILELINE[BCXSTRSIZE] = {0};
    int Counter;

    // Validate inputs
    if (FilePointer == NULL || NumLines <= 0 || ferror(FilePointer)) {
        BCX_RetStr = BCX_TempStr(1);
        if (BCX_RetStr) strcpy(BCX_RetStr, EmptyStr);
        return BCX_RetStr;
    }

    // Save current file position
    if (fgetpos(FilePointer, &CurrentPosition) != 0) {
        BCX_RetStr = BCX_TempStr(1);
        if (BCX_RetStr) strcpy(BCX_RetStr, EmptyStr);
        return BCX_RetStr;
    }

    // Read lines
    for (Counter = 1; Counter <= NumLines; Counter++) {
        FILELINE[0] = '\0';
        if (fgets(FILELINE, BCXSTRSIZE, FilePointer) == NULL) {
            fsetpos(FilePointer, &CurrentPosition); // Restore position
            BCX_RetStr = BCX_TempStr(1);
            if (BCX_RetStr) strcpy(BCX_RetStr, EmptyStr);
            return BCX_RetStr;
        }
    }

    // Remove newline characters
    FILELINE[strcspn(FILELINE, "\r\n")] = '\0';

    // Restore file position
    fsetpos(FilePointer, &CurrentPosition);

    // Allocate and copy the result
    BCX_RetStr = BCX_TempStr(strlen(FILELINE));
    if (BCX_RetStr) {
        strcpy(BCX_RetStr, FILELINE);
    } else {
        BCX_RetStr = BCX_TempStr(1);
        if (BCX_RetStr) strcpy(BCX_RetStr, EmptyStr);
    }

    return BCX_RetStr;
}

char *ucase (LPCTSTR szStr)
{
  return CharUpperA(strcpy(BCX_TempStr(strlen(szStr)), szStr));
}

char *lcase (LPCTSTR szStr)
{
  return CharLowerA(strcpy(BCX_TempStr(strlen(szStr)), szStr));
}

char *mcase (LPCTSTR szStr)
{
  char *strtmp = BCX_TempStr(strlen(szStr)+1);
  char *s = strtmp;
  CharLowerA(strcpy(strtmp, szStr));
  while(*s)
  {
    if (islower(*s))
    {
      *s-=32;
      while(isalpha(*++s));
    }
    s++;
  }
  return strtmp;
}

char *RemoveStr (LPCTSTR szSrc, LPCTSTR RemoveMe)
{
  char *strtmp, *pp, *dd;
  int  tmplen;
  strtmp = dd = BCX_TempStr(strlen(szSrc));
  if ((!RemoveMe) || (!*RemoveMe)) return strcpy(strtmp, szSrc);
  pp = strstr((char*)szSrc, (char*)RemoveMe); tmplen = (int)strlen(RemoveMe);
  while (pp)
  {
    memcpy (dd, szSrc, pp-szSrc);
    dd+= (pp - szSrc);
    szSrc = pp + tmplen;
    pp = strstr((char*)szSrc,(char*)RemoveMe);
  }
  strcpy (dd, (char*)szSrc);
  return strtmp;
}

char *IRemoveStr (LPCTSTR szSrc, LPCTSTR RemoveMe)
{
  char *strtmp, *pp, *dd;
  int  tmplen;
  strtmp = dd = BCX_TempStr(strlen(szSrc));
  if (!RemoveMe || !*RemoveMe) return strcpy(strtmp, szSrc);
  pp = _stristr_(szSrc, RemoveMe); tmplen = (int)strlen(RemoveMe);
  while(pp)
  {
    memcpy (dd, szSrc, pp-szSrc);
    dd+= (pp - szSrc);
    szSrc =  pp + tmplen;
    pp = _stristr_(szSrc, RemoveMe);
  }
  strcpy (dd, szSrc);
  return strtmp;
}

char *str(double d_, int nospc)
{
  char *strtmp = BCX_TempStr(64);
  if (nospc)
    snprintf(strtmp, 64, "%.15G", d_);
  else
    snprintf(strtmp, 64, "% .15G", d_);
  return strtmp;
}

char *curdir (void)
{
  char *strtmp = BCX_TempStr(BCXSTRSIZE);
  GetCurrentDirectory (1024, strtmp);
  return strtmp;
}

char *tempdir (void)
{
  char *strtmp = BCX_TempStr(BCXSTRSIZE);
  GetTempPath (1024, strtmp);
  return strtmp;
}

char *repeat (int count, LPCTSTR a_)
{
  char *strtmp = BCX_TempStr((count+1)*strlen(a_));
  while(count-- > 0) strtmp = strcat(strtmp, a_);
  return strtmp;
}

char *stringx (int count_, int a_)
{
  if (count_<1) return BCX_TempStr(1);
  char *strtmp = BCX_TempStr(count_);
  return (char*)memset(strtmp, a_, count_);
}

char *space (int count)
{
  if (count<1) return BCX_TempStr(1);
  char *strtmp = BCX_TempStr(count);
  return (char*)memset(strtmp, 32, count);
}

char *timef (int t, int u)
{
  time_t elapse_time;
  struct tm *tp;
  char *strtmp = BCX_TempStr(256);
  time (&elapse_time);
  if (u==0)
    tp = localtime(&elapse_time);
  else
    tp = gmtime(&elapse_time);
  switch (t)
  {
  case 0:
    strftime(strtmp, 256, "%H:%M:%S", tp); break;
  case 1:
    strftime(strtmp, 256, "%H", tp); break;
  case 2:
    strftime(strtmp, 256, "%M", tp); break;
  case 3:
    strftime(strtmp, 256, "%S", tp); break;
  case 4:
    strftime(strtmp, 256, "%p", tp); break;
  case 5:
    strftime(strtmp, 256, "%Y", tp); break;
  case 6:
    strftime(strtmp, 256, "%m", tp); break;
  case 7:
    strftime(strtmp, 256, "%d", tp); break;
  case 8:
    strftime(strtmp, 256, "%A", tp); break;
  case 9:
    strftime(strtmp, 256, "%w", tp); break;
  case 10:
    strftime(strtmp, 256, "%j", tp); break;
  case 11:
    strftime(strtmp, 256, "%U", tp); break;
  case 12:
    strftime(strtmp, 256, "%I:%M:%S %p", tp); break;
  }
  return strtmp;
}

char *enc (LPCTSTR Arg_A, int L, int R)
{
  size_t tmplen = strlen(Arg_A);
  char *BCX_RetStr = BCX_TempStr(tmplen+3);
  memcpy(BCX_RetStr+1, Arg_A, tmplen);
  *BCX_RetStr = (char)((L==0) ? 34 : L);
  BCX_RetStr[++tmplen] = (char)((R==0) ? *BCX_RetStr : R);
  BCX_RetStr[++tmplen] = 0;
  return BCX_RetStr;
}

char *chr
(
  unsigned char a_, unsigned char b_,
  unsigned char c_, unsigned char d_,
  unsigned char e_, unsigned char f_,
  unsigned char g_, unsigned char h_,
  unsigned char i_, unsigned char j_,
  unsigned char k_, unsigned char l_,
  unsigned char m_, unsigned char n_,
  unsigned char o_, unsigned char p_,
  unsigned char q_, unsigned char r_,
  unsigned char s_, unsigned char t_,
  unsigned char u_, unsigned char v_,
  unsigned char w_, unsigned char x_,
  unsigned char y_, unsigned char z_
)
{
  char *strtmp = BCX_TempStr(27);
  strtmp [0] = a_;
  strtmp [1] = b_;
  strtmp [2] = c_;
  strtmp [3] = d_;
  strtmp [4] = e_;
  strtmp [5] = f_;
  strtmp [6] = g_;
  strtmp [7] = h_;
  strtmp [8] = i_;
  strtmp [9] = j_;
  strtmp[10] = k_;
  strtmp[11] = l_;
  strtmp[12] = m_;
  strtmp[13] = n_;
  strtmp[14] = o_;
  strtmp[15] = p_;
  strtmp[16] = q_;
  strtmp[17] = r_;
  strtmp[18] = s_;
  strtmp[19] = t_;
  strtmp[20] = u_;
  strtmp[21] = v_;
  strtmp[22] = w_;
  strtmp[23] = x_;
  strtmp[24] = y_;
  strtmp[25] = z_;
  strtmp[26] = 0;
  return strtmp;
}

char *vchr(int charcount, ...)
{
  int c = 0, ii = charcount;
  char *s_ = BCX_TempStr(charcount + 1);
  va_list marker;
  s_[ii] = 0;
  va_start(marker, charcount);
  while (ii-- > 0) s_[c++] = (char) va_arg(marker, int);
  va_end(marker);
  return s_;
}

char *join(int ArgCount, LPCTSTR Str1, ...)
{
  va_list  ap={0};
  PSTR BCX_RetStr = NULL;
  PSTR currentStr = NULL;
  int i;
  size_t totalLen;
  totalLen = strlen(Str1);
                                      //  Calc memory reqmnt
  va_start(ap,Str1);
  for(i=1; i<=ArgCount-1; i++)
    {
      currentStr = va_arg(ap,PSTR);
      if(strlen(currentStr)>0 ){
          totalLen += (int)strlen(currentStr);
        }
    }
  va_end(ap);
                                      //  Allocate memory
  BCX_RetStr = BCX_TempStr(totalLen);
  if(BCX_RetStr == 0 ){
      return NULL;                    //   Not a good sign :-(
    }
                                      //   Init result with Str1
  strcpy(BCX_RetStr,Str1);
                                      //   Concat remainiing strings
  va_start(ap,Str1);
  for(i=1; i<=ArgCount-1; i++)
    {
      currentStr = va_arg(ap,PSTR);
      if((int)strlen(currentStr)>0 ){
          strcat(BCX_RetStr,currentStr);
        }
    }
  va_end(ap);
  return BCX_RetStr;
}

char* Environ(LPCTSTR szStr)
{
  char *strtmp = BCX_TempStr(32768);
  GetEnvironmentVariable (szStr, strtmp, 32767);
  return strtmp;
}

char *date (int tz)
{
  time_t elapse_time;
  struct tm *tp;
  char *strtmp = BCX_TempStr(24);
  time(&elapse_time);
  if (tz == 0)
    tp = localtime(&elapse_time);
  else
    tp = gmtime(&elapse_time);
  strftime(strtmp, 24, "%m-%d-20%y", tp);
  return strtmp;
}

char *isodate (int tz)
{
  time_t elapse_time;
  struct tm *tp;
  char *strtmp = BCX_TempStr(24);
  time(&elapse_time);
  if (tz == 0)
    tp = localtime(&elapse_time);
  else
    tp = gmtime(&elapse_time);
  strftime(strtmp, 24, "20%y-%m-%d", tp);
  return strtmp;
}

char *AppExePath (void)
{
  char *strtmp = BCX_TempStr (BCXSTRSIZE);
  int ii;
  ii = GetModuleFileName(GetModuleHandle(0), strtmp, BCXSTRSIZE);
  while(ii && strtmp[ii] != 0x5C)
    ii--;
  strtmp[ii+1] = 0;
  return strtmp;
}

char *TempFileName (LPCTSTR szFolder, LPCTSTR szPrefix)
{
  char *strtmp = BCX_TempStr (BCXSTRSIZE);
  GetTempFileName(szFolder, szPrefix, 0, strtmp);
  return strtmp;
}

char *Using(LPCTSTR szMask, long double Num)
{
  int CntDec = 0;    // Count the number of "0" to left pad the result
  int Decimals = 0;  // Count ALL digits RIGHT of the decimal point
  int Dollar = 0;    // Flag to LEFT prepend "$" symbol
  int Percent = 0;   // Flag to convert result to percent
  int SN = 0;        // Flag to use Sci Notation 
  int SN_Digits = 0; // Count of digits RIGHT of decimal
  int Spaces = 0;    // Flag for using spaces padding
  int Zeros = 0;     // Flag for using zero padding 

  char *BCX_RetStr = BCX_TempStr(256);
  char Buf_1[256]={0};
  LPCTSTR p = szMask;
  int len;

  // First pass: analyze the format mask

  while (*p)
  {
    if (*p == 36)  Dollar++;      // $
    if (Dollar>1)  Dollar=1;      // Restrict
    if (*p == 37)  Percent++;     // %
    if (Percent>1) Percent=1;     // Restrict
    if (*p == 32)  Spaces++;      // Space
    
    // Track zero padding before decimal
    if (*p == 48 && !CntDec)  Zeros++;
    
    // Count decimal places (spaces, # or 0 after decimal point)
    if ((*p == 32 || *p == 35 || *p == 48) && CntDec)  Decimals++;
    
    // Count # symbols after decimal for SN precision
    if (*p == 35 && SN && CntDec)  SN_Digits++;
    
    if (*p == 46)  CntDec = 1;    // Decimal point
    
    if (*p == 94)  SN++;          // ^ is for scientific notation
      
    p++;
  }
    
  // Second pass: Assemble the resulting string
  
  if (SN)                         // Process SN and return
  {
    char Tmp[64]={0};
    char fmt[16]={0};
    
    // Use SN_Digits for precision after decimal, add 1 for the digit before decimal
    int precision = SN_Digits;
    sprintf(fmt, "%%.%dE", precision);
    sprintf(Tmp, fmt, (double)Num);
    
    // Clean up scientific notation
    while (instr(Tmp, "0E"))
      strcpy(Tmp, replace(Tmp, "0E", "E"));
    while (instr(Tmp, "E+00"))
      strcpy(Tmp, replace(Tmp, "E+00", "E+0"));
    while (instr(Tmp, "E-00"))
      strcpy(Tmp, replace(Tmp, "E-00", "E-0"));
    strcpy(BCX_RetStr, Tmp);
    return BCX_RetStr;
  }
  
  if(Percent) Num = Num * 100.0L;
  // Format the number with specified decimals
  sprintf(Buf_1, "%1.*Lf", Decimals, Num);

  // Find integer part length
  char *decimal_pos = strchr(Buf_1, '.');
  int num_int_digits = decimal_pos ? (int)(decimal_pos - Buf_1) : (int)strlen(Buf_1);

  // Adjust for negative sign
  int has_negative = (Buf_1[0] == '-');
  if (has_negative)
    num_int_digits--;

  // Initialize the return string
  memset(BCX_RetStr, 0, 256);

  int zero_pad = 0;

  // Calculate zero padding (apply only if needed)
  if (Zeros > 0 && Zeros > num_int_digits)
    zero_pad = Zeros - num_int_digits;

  // Position for the start of the number
  int pos = Dollar + Spaces + zero_pad;

  // Copy the number to the return string
  if (has_negative)
  {
    if (Zeros > 0)
    {
      // With zero padding, negative goes before zeros
      BCX_RetStr[Dollar + Spaces] = '-';
      strcpy(BCX_RetStr + pos, Buf_1 + 1);
    }
    else
    {
      // Without zero padding, negative stays with number
      strcpy(BCX_RetStr + pos, Buf_1);
    }
  }
  else
  {
    strcpy(BCX_RetStr + pos, Buf_1);
  }

  // Add commas for thousands
  char temp[256]={0};
  strcpy(temp, BCX_RetStr);

  // Find where the number starts after any potential padding
  int number_start = Dollar + Spaces + zero_pad;

  // Handle negative sign position for proper comma placement
  if (has_negative && Zeros == 0)
    number_start++; // Skip past the negative sign for comma placement

  // Find integer part end
  decimal_pos = strchr(temp, '.');
  int int_end = decimal_pos ? (int)(decimal_pos - temp) : (int)strlen(temp);

  // Add commas working backwards, but never insert a comma right after the negative sign
  for (int i = int_end - 3; i > number_start; i -= 3)
  {
    // Ensure we don't place a comma immediately after a negative sign
    if (i > number_start && !(temp[i-1] == '-'))
    {
      memmove(temp + i + 1, temp + i, (int)strlen(temp + i) + 1);
      temp[i] = ',';
    }
  }

  strcpy(BCX_RetStr, temp);

  // Add dollar sign
  if (Dollar)
  {
    if (Num >= 0)
    {
      BCX_RetStr[Spaces] = '$';
    }
    else
    {
      if (Zeros > 0)
      {
        // With zero padding: move negative, then add dollar
        BCX_RetStr[Spaces] = '-';
        BCX_RetStr[Spaces + 1] = '$';
        
        // Remove duplicate negative sign
        for (int i = pos; i < (int)strlen(BCX_RetStr); i++)
        {
          if (BCX_RetStr[i] == '-')
          {
            memmove(BCX_RetStr + i, BCX_RetStr + i + 1, (int)strlen(BCX_RetStr + i));
            break;
          }
        }
      }
      else
      {
        // Without zero padding: dollar then negative
        BCX_RetStr[Spaces] = '$';
      }
    }
  }

  // Fill leading spaces
  if (Spaces)
    memset(BCX_RetStr, ' ', Spaces);

  // Fill zeros after spaces but only if needed
  for (int i = 0; i < zero_pad; i++)
    BCX_RetStr[Dollar + Spaces + i] = '0';

  // Add percent sign if needed
  if (Percent)
  {
    len = (int)strlen(BCX_RetStr);
    BCX_RetStr[len] = '%';
    BCX_RetStr[len + 1] = 0;
  }
  return BCX_RetStr;
}

int bcx_stricmp (LPCTSTR szOne, LPCTSTR szTwo)
{
  char  c1 [BCXSTRSIZE];
  char  c2 [BCXSTRSIZE];
  strcpy(c1,szOne);
  strcpy(c2,szTwo);
  CharUpperA(c1);
  CharUpperA(c2);
  int counter=0;
  for(;;)
  {
    if(c1[counter]^c2[counter])
    {
      if(c1[counter]>c2[counter])
        return  1;
      return -1;
    }
    if(!c1[counter]) return 0;
    counter++;
  }
}

char *_stristr_(LPCTSTR Haystack, LPCTSTR Needle)
{
  int mi = (-1);
  while(Needle[++mi])
  {
    if (Haystack[mi]==0) return 0;
    if (UprCase[(unsigned char)Haystack[mi]] != UprCase[(unsigned char)Needle[mi]])
    {
      Haystack++;
      mi = (-1);
    }
  }
  return (char*)Haystack;
}

char *sziif (int cond, LPCTSTR szOne, LPCTSTR szTwo)
{
  if (cond!=0) return (char*)szOne;
  return (char*)szTwo;
}

char *BcxSplitPath (LPCTSTR FPath, int mask)
{
  if (!FPath) return BCX_TempStr(1);
  char *BCX_RetStr = BCX_TempStr(strlen(FPath));
  char tmp[MAX_PATH*4];
  _splitpath(FPath,tmp,&tmp[MAX_PATH],&tmp[MAX_PATH*2],&tmp[MAX_PATH*3]);
  if (mask & FDRV) strcat(BCX_RetStr,tmp);
  if (mask & FPATH)strcat(BCX_RetStr,&tmp[MAX_PATH]);
  if (mask & FNAME)strcat(BCX_RetStr,&tmp[MAX_PATH*2]);
  if (mask & FEXT) strcat(BCX_RetStr,&tmp[MAX_PATH*3]);
  return BCX_RetStr;
}

char *BcxPath (void)
{
  char *BCX_RegPath=BCX_TempStr (BCXSTRSIZE);
  strcpy(BCX_RegPath,RegString
         (HKEY_LOCAL_MACHINE,"Software\\Bcx-32\\Bcx\\Settings","Path"));
  if (BCX_RegPath[0]==0)
    strcpy(BCX_RegPath,RegString
           (HKEY_CURRENT_USER,"Software\\Bcx-32\\Bcx\\Settings","Path"));
  if (BCX_RegPath[0]==0)
    return strcpy(BCX_RegPath,"Not Found");
  return BCX_RegPath;
}

char *LccPath (void)
{
  char *BCX_RetStr={0};
  static char LCC_Reg     [BCXSTRSIZE];
  static char LCC_RegPath [BCXSTRSIZE];
  strcpy(LCC_Reg,"Software\\lcc\\lcclnk\\");
  strcpy(LCC_RegPath,(char*)RegString(HKEY_LOCAL_MACHINE,LCC_Reg,"libpath"));
  if (LCC_RegPath[0]==0)
  {
    strcpy(LCC_RegPath,(char*)RegString(HKEY_CURRENT_USER,LCC_Reg,"libpath"));
  }
  if (strcmp(LCC_RegPath,"")!=0)
  {
    BCX_RetStr=BCX_TempStr(256);
    return strcpy(BCX_RetStr,(char*)left(LCC_RegPath,InstrRev(LCC_RegPath,"\\")));
  }
  else
  {
    BCX_RetStr=BCX_TempStr(strlen(LCC_RegPath));
    return strcpy(BCX_RetStr,LCC_RegPath);
  }
}

char *PellesPath (void)
{
  char *BCX_RetStr={0};
  static char Pelles_Reg     [BCXSTRSIZE];
  static char Pelles_RegPath [BCXSTRSIZE];
  strcpy(Pelles_Reg,"Software\\Pelle Orinius\\PellesC\\Directories\\");
  strcpy(Pelles_RegPath,(char*)RegString(HKEY_LOCAL_MACHINE,Pelles_Reg,"PathDirs"));
  if (Pelles_RegPath[0]==0)
  {
    strcpy(Pelles_RegPath,(char*)RegString(HKEY_CURRENT_USER,Pelles_Reg,"PathDirs"));
  }
  if (strcmp(Pelles_RegPath,"")!=0)
  {
    BCX_RetStr=BCX_TempStr(256);
    return strcpy(BCX_RetStr,(char*)left(Pelles_RegPath,InstrRev(Pelles_RegPath,"\\")));
  }
  else
  {
    BCX_RetStr=BCX_TempStr(strlen(Pelles_RegPath));
    return strcpy(BCX_RetStr,Pelles_RegPath);
  }
}

char *RegString (HKEY hKey, LPCTSTR RegPath, LPCTSTR SubKey)
{
  char *Result = BCX_TempStr (BCXSTRSIZE);
  int BufferLen = BCXSTRSIZE;
  if (!RegOpenKeyEx(hKey,RegPath,0,KEY_QUERY_VALUE,&hKey))
  {
    RegQueryValueEx(hKey,SubKey,0,0,(LPBYTE)Result,(LPDWORD)&BufferLen);
  }
  RegCloseKey(hKey);
  return Result;
}

void CreateRegString (HKEY HK, LPCTSTR Key, LPCTSTR VarName, LPCTSTR Value)
{
  HKEY  hKey;
  char  Buff[100]={0};
  ULONG  Result;
  RegCreateKeyEx(HK,Key,0,Buff,REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,0,&hKey,&Result);
  RegSetValueEx(hKey,VarName,0,REG_SZ,(LPBYTE)Value,(ULONG)strlen(Value)+1);
  RegCloseKey(hKey);
}

char *StrToken (LPCTSTR Source, LPCTSTR TokenChar, int n)
{
  char *BCX_RetStr = NULL;
  char *RetVal = NULL;
  LPCTSTR Copy = NULL;
  int Posn = 0;
  int Find = 0;
  int LenSrc = (int)strlen(Source);
  Copy = Source;
  if (tally(Source,TokenChar)==0)
  {
    BCX_RetStr=BCX_TempStr(1);
    return BCX_RetStr;
  }
  if (n==1)
  {
    BCX_RetStr = BCX_TempStr(LenSrc);
    strcpy(BCX_RetStr,(char*)extract(Source,TokenChar));
    return BCX_RetStr;
  }
  if (n>tally(Source,TokenChar)+1)
  {
    BCX_RetStr=BCX_TempStr(1);
    return BCX_RetStr;
  }
  while(*Copy)
  {
    if (*Copy==TokenChar[0]) Find++;
    if (Find==n) break;
    Copy++;
    Posn++;
  }
  if (n==tally(Source,TokenChar)+1)
  {
    Posn=LenSrc;
    Copy=Source+Posn;
    while(*Copy && Source[Posn]!=TokenChar[0])
    {
      Posn--;
      Copy--;
    }
  }
  RetVal = (char*)calloc(LenSrc+1,sizeof(char));
  strcpy(RetVal,(char*)mid(Source,1,Posn));
  strcpy(RetVal,(char*)mid(RetVal,InstrRev(RetVal,TokenChar)));
  BCX_RetStr=BCX_TempStr(LenSrc);
  strcpy(BCX_RetStr,(char*)RemoveStr(RetVal,(char*)TokenChar));
  if (RetVal)free(RetVal);
  return BCX_RetStr;
}

int EoF(FILE *filstream) {
    int c;
    // Validate file stream
    if (filstream == NULL || ferror(filstream)) {
        return -1; // Indicate error
    }
    // Read a character
    c = fgetc(filstream);
    if (c == EOF) {
        if (ferror(filstream)) {
            return -1; // File error
        }
        return 1; // True EOF
    }
    // Push back the character if it was not EOF
    if (ungetc(c, filstream) == EOF) {
        return -1; // ungetc failed
    }
    return 0; // Not EOF
}

char *NamePathFromFP (FILE *FP)
{
  char *BCX_RetStr={0};
  char *szTmp={0};
  szTmp = (char*)calloc(2048, 1);
  if(GetFinalPathNameByHandle((HANDLE)_get_osfhandle(_fileno(FP)),szTmp,2047,0))
  {
    strcpy(szTmp, szTmp+4);
  }
  BCX_RetStr = BCX_TempStr(strlen(szTmp));
  strcpy(BCX_RetStr,szTmp);
  if (szTmp)
  {
    free(szTmp);
    szTmp = NULL;
  }
  return BCX_RetStr;
}

int instr(LPCTSTR Haystack, LPCTSTR Needle, int offset, int sensflag)
{
  if(offset == 0) {return 0;}
  LPCTSTR s;
  if (!Haystack||!*Haystack||!Needle||!*Needle||offset>(int)strlen(Haystack)) return 0;
  if (sensflag)
    s = _stristr_(offset > 0 ? Haystack + offset - 1 : Haystack, Needle);
  else
    s = strstr(offset > 0 ? Haystack + offset - 1 : Haystack, Needle);
  return s ? (int)(s-Haystack)+1 : 0;
}

int iinstr(LPCTSTR Haystack, LPCTSTR Needle, int offset)
{
  if(offset == 0) return 0;
  LPCTSTR s;
  if (!Haystack||!*Haystack||!Needle||!*Needle||offset>=(int)strlen(Haystack)) return 0;
    s = _stristr_(offset > 0 ? Haystack + offset-1 : Haystack, Needle);
  return s ? (int)(s-Haystack)+1 : 0;
}

int DeDupeCompare(const void *a, const void *b) {
    return (*(char*)a - *(char*)b);
}
 
char* DeDupeSort(const char* input) {
    int CharFreq[256]={0}; 
    int length = (int)strlen(input);
    char *result = (char*)malloc(length + 1);
    int index = 0;

    // Iterate over each character in the input string
    for (int i = 0; i < length; i++) {
        unsigned char ch = input[i];
        if (CharFreq[ch] == 0) { // If character not encountered before
            CharFreq[ch] = 1;
            result[index++] = ch; // Add character to the result
        }
    }
    result[index] = 0;  
    qsort(result, index, sizeof(char), DeDupeCompare);
    return result; 
}

int InstrAny (LPCTSTR Main, LPCTSTR Words, int Start)
{
  char Buffer[1024];
  strcpy (Buffer, DeDupeSort(Words));
  int BufLen = (int)strlen(Buffer);
  for(int i = 1; i <= BufLen; i++)
  {
    int Found = instr(Main, mid(Buffer, i, 1), Start, 0);
    if (Found) return Found;
  }
return 0;
}

int InstrRev (LPCTSTR Haystack, LPCTSTR Needle, int offset, int sens)
{
  int sl, pl, ox;
  int (*cmp)(LPCTSTR, LPCTSTR, size_t);
  if (!Haystack || !Needle)  return 0;
  sl = (int)strlen(Haystack); pl  = (int)strlen(Needle);
  if (offset > sl || 0 == sl || 0 == pl || (ox = sl - pl) < 0)
     return 0;
  if (offset <= 0)
     offset = ox ;
  else if (offset >= pl)
     offset = offset - pl ;
  else
     return 0;
  cmp = (sens ? _strnicmp : strncmp);
  do
  {
     if (cmp(Haystack + offset , Needle, pl) == 0)
        return offset+1;
  }
  while (offset--);
  return 0;
}

unsigned char* MakeLCaseTbl (void)
{
  static unsigned char tbl[257];
  int ii; for (ii = 0; ii < 256; ii++)
    tbl[ii] = (unsigned char) ii;
  tbl[0] = 1;
  tbl[256] = 0;
  CharLowerA((char *)tbl);
  tbl[0] = 0;
  return tbl;
}

unsigned char* MakeUCaseTbl (void)
{
  static unsigned char tbl[257];
  int ii; for (ii = 0; ii < 256; ii++)
    tbl[ii] = (unsigned char) ii;
  tbl[0] = 1;
  tbl[256] = 0;
  CharUpperA((char *)tbl);
  tbl[0] = 0;
  return tbl;
}

int inchr (LPCTSTR Haystack, LPCTSTR Needle)
{
  LPCTSTR Idx = Haystack;
  while(*Idx)
  {
    if (*Idx == *Needle) return (int)(Idx-Haystack)+1;
    Idx++;
  }
  return 0;
}

BOOL Exist (LPCTSTR szFilePath)
{
  if (strchr(szFilePath, '*') || strchr(szFilePath, '?'))
  return Exist_A (szFilePath);
  return Exist_B (szFilePath);
}

BOOL Exist_A (LPCTSTR szFilePath)
{
  WIN32_FIND_DATA W32FindData;
  HANDLE rc;
  rc = FindFirstFile(szFilePath, &W32FindData);
  if (rc == INVALID_HANDLE_VALUE) return FALSE;
  FindClose(rc);
  return TRUE;
}

BOOL Exist_B (LPCTSTR szFilePath)
{
  ULONG ret;
  ret = GetFileAttributes(szFilePath);
  if (ret != 0xffffffff) return TRUE;
  return FALSE;
}

int tally (LPCTSTR Haystack, LPCTSTR Needle, int sensflag)
{
  if (!*Needle) return 0;
  if (!*Haystack) return 0;
  size_t mlen = strlen(Needle);
  int iCount = 0;
  LPCTSTR p = (0 == sensflag ? strstr(Haystack, Needle) : _stristr_(Haystack, Needle));
  while (p)
  {
    iCount++;
    p += mlen;
    p = (0 == sensflag ? strstr(p, Needle) : _stristr_(p, Needle));
  }
  return iCount;
}

void locate (int row, int col, int show, int shape)
{
  CONSOLE_CURSOR_INFO cci;
  memset (&cci, 0, sizeof(CONSOLE_CURSOR_INFO));
  cursor.X = (SHORT)col-1;
  cursor.Y = (SHORT)row-1;
  SetConsoleCursorPosition(hConsole, cursor);
  cci.bVisible = show;
  cci.dwSize   = shape;
  SetConsoleCursorInfo(hConsole, &cci);
}

int Pos (void)
{
  HANDLE  hStdOut;
  CONSOLE_SCREEN_BUFFER_INFO csbi;
  memset (&csbi, 0, sizeof(CONSOLE_SCREEN_BUFFER_INFO));
  hStdOut = GetStdHandle(STD_OUTPUT_HANDLE);
  GetConsoleScreenBufferInfo(hStdOut, &csbi);
  return csbi.dwCursorPosition.X+1;
}

int Csrlin (void)
{
  HANDLE  hStdOut;
  CONSOLE_SCREEN_BUFFER_INFO csbi;
  memset (&csbi, 0, sizeof(CONSOLE_SCREEN_BUFFER_INFO));
  hStdOut = GetStdHandle(STD_OUTPUT_HANDLE);
  GetConsoleScreenBufferInfo(hStdOut, &csbi);
  return csbi.dwCursorPosition.Y+1;
}

void cls(void)
{
    ULONG cCharsWritten;
    COORD coordScreen = { 0, 0 };
    CONSOLE_SCREEN_BUFFER_INFO csbi;
    ULONG dwConSize;
    WORD attr;

    // Get current screen buffer info
    GetConsoleScreenBufferInfo(hConsole, &csbi);

    // Calculate the console screen size
    dwConSize = csbi.dwSize.X * csbi.dwSize.Y;

    // Fill the console with spaces
    FillConsoleOutputCharacter(hConsole, (TCHAR)' ', dwConSize, coordScreen, &cCharsWritten);

    // Fill the console with the current text and background colors
    attr = (WORD)color_fg + (WORD)color_bg * 16;
    FillConsoleOutputAttribute(hConsole, attr, dwConSize, coordScreen, &cCharsWritten);

#ifndef __LCC__
    // Clear the scrollback buffer by resizing the console buffer
    SMALL_RECT rect;
    rect.Left = 0;
    rect.Top = 0;
    rect.Right = csbi.dwSize.X;
    rect.Bottom = csbi.dwSize.Y-1;
    SetConsoleWindowInfo(hConsole, TRUE, &rect);
    SetConsoleScreenBufferSize(hConsole, csbi.dwSize);
#endif

    locate(1, 1, 1);
}

void color(int fg, int bg)
{
  if (bg == (-1))
  {
    SetConsoleTextAttribute(hConsole, (WORD)fg + (WORD)color_bg * 16);
  }
  else
  {
    SetConsoleTextAttribute(hConsole, (WORD)fg + (WORD)bg * 16);
  }
  color_fg = fg;
  if (bg!=(-1)) color_bg = bg;
}

void PushColors (void)
{
  CONSOLE_SCREEN_BUFFER_INFO csbi;
  memset (&csbi, 0, sizeof(CONSOLE_SCREEN_BUFFER_INFO));
  if(0==GetConsoleScreenBufferInfo(GetStdHandle(STD_OUTPUT_HANDLE), &csbi))
  {
    color_pshpop = 7;
  }
  else
  {
    color_pshpop = csbi.wAttributes;
  }
}

void PopColors (void)
{
  if(color_pshpop == 0)
  {
    color (7,0);
  }
  else
  {
    SetConsoleTextAttribute (GetStdHandle (STD_OUTPUT_HANDLE),(WORD)color_pshpop);
  }
}

void midstr (char *szSrc, int st, int length, char *rep)
{
  int srclen = (int)strlen(szSrc);
  if (st > srclen++ || st<1) return;
  int replen = (int)strlen(rep);
  if (replen < length || length==(-1)) length = replen;
  if ((st+length) > srclen) length = srclen-st;
  memcpy(&szSrc[st-1], rep, length);
}

int like (LPCTSTR Haystack, LPCTSTR Needle)
{
  while (*Needle)
  {
    if (*Needle == '#')
    {
      if (! *Haystack) return false;
      if (! isdigit(*Haystack)) return false;
      ++Haystack;
      ++Needle;
    }
    else if (*Needle == '?')
    {
      if (! *Haystack) return false;
      ++Haystack;
      ++Needle;
    }
    else if (*Needle == '*')
    {
      if (like(Haystack, Needle + 1)) return true;
      if (*Haystack && like(Haystack + 1, Needle))
        return true;
      return false;
    }
    else if ((*Haystack++ | 32) != (*Needle++ | 32)) return false; // case-insensitive
  }
  return !*Haystack && !*Needle;
}

unsigned long long int lof (LPCTSTR FName)
{
  WIN32_FILE_ATTRIBUTE_DATA fad;
  if (!GetFileAttributesEx(FName, GetFileExInfoStandard, &fad))
    return 0;
  LARGE_INTEGER size;
  size.HighPart = fad.nFileSizeHigh;
  size.LowPart = fad.nFileSizeLow;
  return size.QuadPart;
}

int LeftStr (LPCTSTR Haystack, LPCTSTR Needle, int Insensitive)
{
  if (0 == Insensitive)
  {
    if (strcmp(left(Haystack, (int)strlen(Needle)), Needle)==0)
      return 1;
    else
      return 0;
  }
  if (strcmp(lcase(left(Haystack, (int)strlen(Needle))), lcase(Needle))==0)
    return 1;
  else
    return 0;
}

int RightStr (LPCTSTR Haystack, LPCTSTR Needle, int Insensitive)
{
  if (0 == Insensitive)
  {
    if (strcmp(right(Haystack, (int)strlen(Needle)), Needle) == 0)
      return 1;
    else
      return 0;
  }
  if (strcmp(lcase(right(Haystack,(int)strlen(Needle))), lcase(Needle))==0)
    return 1;
  else
    return 0;
}

void InfoBox(LPCTSTR Title, LPCTSTR xValue, int xSize, int ySize)
{
  PSTR Value = _strdup(xValue);
  if((int)strlen(Value)>32500) Value[32500] = 0;

  LPDLGITEMTEMPLATE lpdit;
  LPDLGTEMPLATE lpdt;
  HINSTANCE hInst;
  HGLOBAL hgbl;
  LPWORD lpw;
  LPWSTR lpwsz;
  int nchar;
  int ID_EDIT = 101;
  int ID_OKAY = 102;
  // *************************************
  hgbl=GlobalAlloc(GMEM_ZEROINIT, 0xFFFF);
  lpdt=(LPDLGTEMPLATE)GlobalLock(hgbl);
  // *************************************
  //  Create the InfoBox Window
  // *************************************
  lpdt->style = WS_VISIBLE|DS_NOFAILCREATE|WS_BORDER|DS_CENTER|DS_SETFONT;
  lpdt->cdit = 2;
  lpdt->cx = (SHORT)xSize;
  lpdt->cy = (SHORT)ySize + 10;
  lpw = (LPWORD)(lpdt+1);
  *lpw++ = 0;
  *lpw++ = 0;
  lpwsz = (LPWSTR)lpw;
  nchar = MultiByteToWideChar(CP_ACP, 0, Title, -1, lpwsz, 2*(int)strlen(Title) + 1);
  lpw +=  nchar;
  *lpw++ = DEFAULT_PITCH;
  lpwsz = (LPWSTR)lpw;
  nchar = MultiByteToWideChar(CP_ACP, 0, "Courier", -1, lpwsz, 15);
  lpw +=  nchar;
  // ********************************
  //  Create the OKAY button.
  // ********************************
  lpw   = lpwAlign(lpw);
  lpdit = (LPDLGITEMTEMPLATE)lpw;
  lpdit->x  = (SHORT)(xSize* 0.5)-24;
  lpdit->y  = (SHORT)ySize - 29;
  lpdit->cx = (SHORT)40;
  lpdit->cy = (SHORT)12;
  lpdit->id = (SHORT)ID_OKAY;
  lpdit->style = WS_CHILD|WS_VISIBLE|BS_DEFPUSHBUTTON|WS_TABSTOP;
  lpw = (LPWORD)(lpdit+1);
  *lpw++ = 0xFFFF;
  *lpw++ = 0x0080;
  lpwsz  = (LPWSTR)lpw;
  nchar  = MultiByteToWideChar(CP_ACP, 0, "Okay", -1, lpwsz, 9);
  lpw +=  nchar;
  lpw = lpwAlign(lpw);
  *lpw++ = 0;
  // ************************************
  //  Create the Read-Only EDIT control
  // ************************************
  lpw   = (LPWORD)lpwAlign(lpw);
  lpdit = (LPDLGITEMTEMPLATE)lpw;
  lpdit->x  =  4;
  lpdit->y  =  8;
  lpdit->cx = (SHORT)xSize-9;
  lpdit->cy = (SHORT)ySize-40;
  lpdit->id = (SHORT)ID_EDIT;
  lpdit->style = WS_VISIBLE|WS_VSCROLL|ES_AUTOHSCROLL|WS_CHILD|
                 ES_READONLY|ES_MULTILINE|ES_WANTRETURN|WS_HSCROLL;
  lpw    = (LPWORD)(lpdit+1);
  *lpw++ = 0xFFFF;
  *lpw++ = 0x0081;
  lpwsz  = (LPWSTR)lpw;
  nchar  = MultiByteToWideChar(CP_ACP, 0, Value, -1, lpwsz, 2*(int)strlen(Value) + 1);
  lpw   += nchar;
  lpw    = lpwAlign(lpw);
  *lpw++ = 0;
  // ********************************
  GlobalUnlock(hgbl);
  hInst = (HINSTANCE)(LONG_PTR)GetWindowLongPtr(0, GWLP_HINSTANCE);
  DialogBoxIndirect (hInst, (LPDLGTEMPLATE)hgbl, GetActiveWindow(), (DLGPROC)CB_InfoBox);
  GlobalFree(hgbl);
}

LRESULT CALLBACK CB_InfoBox(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam)
{
  UNREFERENCED_PARAMETER(lParam);
  int ID_OKAY = 102;
  if (Msg == WM_INITDIALOG)
      return TRUE;

  if (Msg == WM_COMMAND && LOWORD(wParam) == ID_OKAY)
      EndDialog(hWnd, 0);

  if (Msg == WM_CLOSE)
      EndDialog(hWnd, 0);
  return 0;
}

LPWORD lpwAlign(LPWORD lpIn)
{
  return (LPWORD)((((uintptr_t)lpIn) + 3) & (~3));
}

// *************************************************
//            User's Subs and Functions
// *************************************************

int main (int argc,PCHAR* argv)
{
  hConsole=GetStdHandle(STD_OUTPUT_HANDLE);
  LowCase = MakeLCaseTbl();
  UprCase = MakeUCaseTbl();
  FuncStrNames=(char*)calloc(cMaxSrcLen ,1);
  FuncSglNames=(char*)calloc(cMaxSrcLen ,1);
  FuncDblNames=(char*)calloc(cMaxSrcLen ,1);
  CurLine=(char*)calloc(cMaxSrcLen ,1);
  gTmpStr=(char*)calloc(cMaxSrcLen ,1);
  Src=(char*)calloc(cMaxSrcLen ,1);
  AbortSrc=(char*)calloc(cMaxSrcLen ,1);
  WarnMsg=(char*)calloc(32767 ,1);
  RmLibs=(char*)calloc(32767 ,1);
  IF_Stmt_Buffer=(char*)calloc(cMaxSrcLen ,1);
  strcpy(Version, join(3,Version,SPC,enc(isodate(),40,41)));
  strcpy(Version,replace(Version,"-","/"));
  strcpy(Copyright, join(3,"BCX BASIC to C/C++ Translator (c) 1999-",right(date(),4)," by Kevin Diggins"));
  InitReservedWordsLookup();
  WarningFlag=FALSE;
  DebugModeOff=TRUE;
  *CmdLineConst=0;
  *CmdLineFileOut=0;
  ExitNdx=0;
  Gen_Header=FALSE;
  *HFile=0;
  InMain=TRUE;
  InNameSpace=0;
  InsertComments=FALSE;
  NoRT=FALSE;
  OkayToSend=TRUE;
  OptimizerEnabled=TRUE;
  OptimizerFirstSetting=TRUE;
  *Project_List=0;
  *Project_Main=0;
  ProtoCnt=0;
  Quiet=FALSE;
  StartNdx=0;
  TestState=FALSE;
  TranslateSlash=TRUE;
  Use_ExitCode=FALSE;
  Use_LeanAndMean=FALSE;
  Use_Project=FALSE;
  Use_SingleFile=TRUE;
  Use_StartupCode=FALSE;
  WinHeaders=TRUE;
  strcpy(BKSLASH1,chr(92));
  strcpy(BKSLASH2,chr(92,92));
  strcpy(BKSLASH4,chr(92,92,92,92));
  strcpy(DQUOT,chr(34,34,34));
  strcpy(DDQUOT,chr(34,34,34,34));
  PPFlag=FALSE;
  PPProc=NULL;
  PPDLL_HANDLE=NULL;
  if(instr(command(-1),"-v")||instr(command(-1),"-V")){
      printf("\n");
      printf("%s\n",Copyright);
      Display_Version_and_Compiler();
      fflush(stdout);
      ExitProcess(0);
    }
  if(Pos()==1&&Csrlin()==1&&ISNULL(command(-1))){
      HIDEHWND(GetConsoleWindow());
      strcpy(Copyright, join(4,Copyright,CRLF,CRLF,cpad(join(2,"Version ",VERSION),100)));
      MessageBox (GetActiveWindow(),(join(6,space(10),Copyright,CRLF,CRLF,space(12),ltrim(Compiler_Used()))),"",MB_SYSTEMMODAL );
      fflush(stdout);
      ExitProcess(0);
    }
  if(ISNULL(command(-1))){
      printf("\n");
      printf("%s\n",Copyright);
      Display_Version_and_Compiler();
      printf("\n");
      printf("%s\n"," Usage: BC infile [.bas] [options]");
      printf("%s\n"," [-b]   Build using user-defined bat file .. ex -b:c:\\bat\\pw.bat");
      printf("%s\n"," [-cpp] Generate C++ compatible code with .cpp extension");
      printf("%s\n"," [-d]   DEFINE a constant ... ex. BC MyFile -D:MyConst[=SomeValue]");
      printf("%s\n"," [-e]   Write ERRORS to BCX.ERR file");
      printf("%s\n"," [-f]   Output FILENAME... ex. BC MyFile -f:C:\\MyFiles\\MyFile.c");
      printf("%s\n"," [-i]   Send Warnings and Errors to INFOBOX");
      printf("%s\n"," [-k]   KILL the generated BCX generated 'C' file");
      printf("%s\n"," [-m]   Enable eMbedded BCX code in the C translation");
      printf("%s\n"," [-n]   Enable NO RUNTIME Code Generation");
      printf("%s\n"," [-o]   OUTPUT a copy of the generated C file to STDOUT");
      printf("%s\n"," [-q]   QUIET - No output to screen during translation");
      printf("%s\n"," [-r]   Update BCX Path variable in the Windows REGISTRY");
      printf("%s\n"," [-s]   Show STATUS of translation by line number");
      printf("%s\n"," [-u]   Turn UNICODE Support ON");
      printf("%s\n"," [-v]   Show BCX version and build information");
      printf("%s\n"," [-w]   Enable BCX WARNINGS during translation and all compiler warnings.");
      printf("%s\n"," [-x]   EXCLUDE Win32 Headers from the resulting C file");
      printf("%s\n"," [-z]   ZAP (remove DEFAULT headers and libraries from the resulting C file");
      FreeGlobals();
      fflush(stdout);
      ExitProcess(0);
    }
  if(bcx_stricmp(command(-1),"-r")==0){
      CreateRegString(HKEY_LOCAL_MACHINE,"Software\\Bcx-32\\Bcx\\Settings","Path",AppExePath());
      CreateRegString(HKEY_CURRENT_USER,"Software\\Bcx-32\\Bcx\\Settings","Path",AppExePath());
      printf("%s%s\n","      BCX Path set to ",BcxPath());
      fflush(stdout);
      ExitProcess(0);
    }
  for(int i=2; i<=argc-1; i++)
    {
      strcpy(gTmpStr,lcase(argv[i]));
      if(instr(gTmpStr,"-b")){
          if(cMaxOnExit==XitCount ){
              Abort("Maximum $OnExit exceeded.");
            }
          XitCount++;
          strcpy(Xit[XitCount], join(3,mid(argv[i],4),SPC,enc(extract(command(1),"."))));
        }
      if(strcmp(gTmpStr,"-cpp")==0){
          UseCpp=TRUE;
        }
      if(strcmp(gTmpStr,"-c")==0){
          UseCpp=TRUE;
        }
      if(strcmp(gTmpStr,"-e")==0){
          ErrFile=TRUE;
        }
      if(strcmp(gTmpStr,"-h")==0){
          Gen_Header=TRUE;
        }
      if(strcmp(gTmpStr,"-i")==0){
          InfoBoxWarn=TRUE;
        }
      if(strcmp(gTmpStr,"-q")==0){
          Quiet=TRUE;
        }
      if(strcmp(gTmpStr,"-k")==0){
          KillCFile=TRUE;
        }
      if(strcmp(gTmpStr,"-m")==0){
          SrcFlag=TRUE;
        }
      if(strcmp(gTmpStr,"-n")==0){
          NoRT=TRUE;
        }
      if(strcmp(gTmpStr,"-o")==0){
          ReDirect=TRUE;
        }
      if(strcmp(gTmpStr,"-s")==0){
          ShowStatus=TRUE;
        }
      if(strcmp(gTmpStr,"-u")==0){
          Use_UNICODE=TRUE;
        }
      if(strcmp(gTmpStr,"-z")==0){
          ZapFlag=TRUE;
        }
      if(strcmp(gTmpStr,"-w")==0){
          TestState=TRUE;
          WarningFlag=TRUE;
        }
      if(strcmp(gTmpStr,"-x")==0){
          WinHeaders=FALSE;
        }
      if(iMatchLft(gTmpStr,"-f:")){
          strcpy(CmdLineFileOut,mid(argv[i],4));
        }
      if(iMatchLft(gTmpStr,"-d:")){
          strcpy(CmdLineConst, join(3,CmdLineConst,mid(argv[i],4),chr(1)));
        }
    }
  if(ShowStatus ){
      cls();
    }
  if(!Quiet ){
      if(BCX_COLORS ){
          PushColors();
        }
      if(BCX_COLORS ){
          color (11,0 );
        }
      printf("\n");
      printf("%s\n",Copyright);
      Display_Version_and_Compiler();
      if(BCX_COLORS ){
          PopColors();
        }
    }
  if(inchr(command(1),".")){
      strcpy(Cmd,command(1));
    }
  else
    {
      strcpy(Cmd, join(2,extract(command(1),"."),".bas"));
    }
  strcpy(Cmd,findfirst(Cmd));
  if(inchr(Cmd,"*")||inchr(Cmd,"?")){
      strcpy(Cmd,findfirst(Cmd));
    }
  strcpy(FileIn,Cmd);
  if(ISNULL(CmdLineFileOut)){
      strcpy(FileOut, join(2,left(Cmd,InstrRev(Cmd,".",0)-1),".out"));
    }
  else
    {
      strcpy(FileOut,CmdLineFileOut);
    }
  strcpy(FileErr, join(2,left(Cmd,InstrRev(Cmd,".",0)-1),".err"));
  if(Exist(FileErr)){
      system(join(2,"DEL ",FileErr));
    }
  if(DebugModeOff ){
      strcpy(gTmpStr,tempdir());
      strcpy(cppFile,TempFileName(gTmpStr,"ccode"));
      strcpy(prcFile,TempFileName(gTmpStr,"prc"));
      strcpy(udtFile,TempFileName(gTmpStr,"udt"));
      strcpy(datFile,TempFileName(gTmpStr,"dat"));
      strcpy(UsrFile,TempFileName(gTmpStr,"cst"));
      strcpy(SysFile,TempFileName(gTmpStr,"syscst"));
      strcpy(ovrFile,TempFileName(gTmpStr,"ovr"));
      strcpy(hdrFile,TempFileName(gTmpStr,"hdr"));
      strcpy(setFile,TempFileName(gTmpStr,"set"));
      strcpy(resFile,TempFileName(gTmpStr,"res"));
      strcpy(enuFile,TempFileName(gTmpStr,"enu"));
      strcpy(defFile,TempFileName(gTmpStr,"def"));
    }
  else
    {
      strcpy(gTmpStr,AppExePath());
      strcpy(cppFile, join(2,gTmpStr,"ccode_debug.txt"));
      strcpy(prcFile, join(2,gTmpStr,"prc_debug.txt"));
      strcpy(udtFile, join(2,gTmpStr,"udt_debug.txt"));
      strcpy(datFile, join(2,gTmpStr,"dat_debug.txt"));
      strcpy(UsrFile, join(2,gTmpStr,"cst_debug.txt"));
      strcpy(SysFile, join(2,gTmpStr,"syscst_debug.txt"));
      strcpy(ovrFile, join(2,gTmpStr,"ovr_debug.txt"));
      strcpy(hdrFile, join(2,gTmpStr,"hdr_debug.txt"));
      strcpy(setFile, join(2,gTmpStr,"set_debug.txt"));
      strcpy(resFile, join(2,gTmpStr,"res_debug.txt"));
      strcpy(enuFile, join(2,gTmpStr,"enu_debug.txt"));
      strcpy(defFile, join(2,gTmpStr,"def_debug.txt"));
    }
  FindIncludeFiles(FileIn);
  for(int j=0; j<=FilesFound; j++)
    {
      ScanFunctionNames(IncludeFileNames[j]);
    }
  if((SourceFile=fopen(FileIn, "rb"))==0)
   {
  fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", FileIn); exit(1);
   }
  if((FP2=fopen(FileOut, "w"))==0)
   {
  fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", FileOut); exit(1);
   }
  FP_WRITE=FP2;
  if((FP_CCODE=fopen(cppFile, "w"))==0)
   {
  fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", cppFile); exit(1);
   }
  if((FP_SYSCST=fopen(SysFile, "w"))==0)
   {
  fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", SysFile); exit(1);
   }
  if((FP3=fopen(prcFile, "w"))==0)
   {
  fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", prcFile); exit(1);
   }
  if((FP_UDT=fopen(udtFile, "w"))==0)
   {
  fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", udtFile); exit(1);
   }
  if((FP_DAT=fopen(datFile, "w"))==0)
   {
  fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", datFile); exit(1);
   }
  if((FP_CST=fopen(UsrFile, "w"))==0)
   {
  fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", UsrFile); exit(1);
   }
  if((FP_HDR=fopen(hdrFile, "w"))==0)
   {
  fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", hdrFile); exit(1);
   }
  if((FP_RES=fopen(resFile, "w"))==0)
   {
  fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", resFile); exit(1);
   }
  if((FP_ENU=fopen(enuFile, "w"))==0)
   {
  fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", enuFile); exit(1);
   }
  if((FP_OVR=fopen(ovrFile, "w"))==0)
   {
  fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", ovrFile); exit(1);
   }
  if((FP_SET=fopen(setFile, "w"))==0)
   {
  fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", setFile); exit(1);
   }
  if((FP_DEF=fopen(defFile, "w"))==0)
   {
  fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", defFile); exit(1);
   }
  ExportStringConst();
  FileNdx=1;
  strcpy(FileNames[FileNdx],FileIn);
  LineNum[FileNdx]=0;
  if(NoRT==TRUE ){
      EnableProject();
    }
  BeginMain();
  ClearIfThenStacks();
  if(UseCpp==TRUE ){
      int iTmp;
      Docpp("",&(iTmp));
    }

READSRCLINE:;
  while(!EoF(SourceFile)||SplitCnt){
      if(SplitCnt==0 ){
          Src[0]=0;
          fgets(Src, 2048 , SourceFile);
            if(feof(SourceFile) || (Src[strlen(Src)-1]==10))
              {
               Src[strcspn(Src,"\r\n")] = 0;
              }
             else
              {
                printf("%s%d while reading file: %s\n","Error! - LINE INPUT truncation detected at PROGRAM line: ",__LINE__-7, NamePathFromFP(SourceFile));
                printf("%s\n","The actual truncated line of text:");
                printf("%s",Src);
                exit(1);
              }
          LineNum[FileNdx]++;
          strcpy(Src,ltrim(Src));
          if(ISNULL(Src)){
              continue;
            }
          if(InFunction ){
              if(InsertComments ){
                  if(*Src==c_SglQt ){
                      fprintf(FP_WRITE,"%s%s%s\n",Scoot,"//",(PCHAR)(Src+1));
                      *Src=0;
                      continue;
                    }
                  if(iMatchLft(Src,"rem ")){
                      fprintf(FP_WRITE,"%s%s%s\n",Scoot,"//",(PCHAR)(Src+3));
                      *Src=0;
                      continue;
                    }
                }
            }
          StripCode(Src);
          if(ISNULL(Src)){
              continue;
            }
          if(JoinLines(Src)){
              continue;
            }
          if(inchr(Src,"[")){
              BracketHandler(Src,0);
            }
          if(PPFlag ){
              ppret= CAST (long,PPProc(Src));
              if(ppret==0 ){
                  Abort(Src);
                }
            }
          if(ISFALSE MacroCheck()){
              if(SplitLines(Src)){
                  strcpy(Src,ltrim(SplitStk[++SplitCur]));
                }
            }
        }
      else
        {
          strcpy(Src,ltrim(SplitStk[++SplitCur]));
        }
      Early_Transforms();
      if(SplitCur==SplitCnt ){
          SplitCur=SplitCnt=0;
        }
      strcpy(AbortSrc,Src);
      if(*Src==33 ){
          if(InFunction||InClass||InNameSpace||InTypeDef ){
              fprintf(FP_WRITE,"%s\n",mid(Src,2));
            }
          else
            {
              if(InMain ){
                  fprintf(FP2,"%s\n",mid(Src,2));
                }
              else
                {
                  fprintf(FP_CST,"%s\n",mid(Src,2));
                }
            }
          continue;
        }
      VerifyMatchedPairs();
      if((TraceFlag&&InFunction)||(SrcFlag)||(ShowStatus)){
          ActivityFlags();
        }
      if(ISNULL(Src)){
          continue;
        }
      Translate();
      if(UseCpp==FALSE ){
          if(DoInjection ){
              PassOne=TRUE;
              Inject(Injection);
              PassOne=TRUE;
            }
          DoInjection=FALSE;
          *Injection=0;
        }
      if(Inject_Local_Bcx_RetVal==TRUE ){
          PassOne=TRUE;
          Inject("LOCAL Bcx_RetVal AS INTEGER");
          PassOne=TRUE;
          Inject_Local_Bcx_RetVal=FALSE;
        }
    }
     fflush(FP_WRITE);
  if(FPtrNdx ){
      PopFileIO();
      goto READSRCLINE;
    }
  Emit_CompilerDefines();
  if(TestForBcxIni==FALSE ){
      TestForBcxIni=TRUE;
      strcpy(szFile, join(2,curdir(),"\\bcx.ini"));
      if(!Exist(szFile)){
          strcpy(szFile, join(2,AppExePath(),"bcx.ini"));
        }
      if(Exist(szFile)){
          PushFileIO();
          if((SourceFile=fopen(szFile, "rb"))==0)
           {
          fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", szFile); exit(1);
           }
          if(FileNdx==cMaxFiles-1 ){
              Abort("Maximum Include Files exceeded.");
            }
          strcpy(FileNames[++FileNdx],szFile);
          LineNum[FileNdx]=0;
          goto READSRCLINE;
        }
    }
  if(LoopTypeCnt ){
      LoopErrorMsg();
    }
  if(Indent ){
      printf("%s\n",repeat(80,"_"));
      printf("%s\n","Possible missing END IF before END of program");
      printf("%s\n",repeat(80,"_"));
    }
  if(Use_VBS ){
      Emit_VBScript_Support();
    }
  if(NO_LIBS==FALSE ){
      if(ZapFlag==FALSE ){
          if(Use_Project==FALSE ){
              static int Pass_1;
              if(Pass_1==FALSE ){
                  Pass_1++;
                  AddLibrary("kernel32.lib");
                  AddLibrary("user32.lib");
                  AddLibrary("gdi32.lib");
                  AddLibrary("comctl32.lib");
                  AddLibrary("advapi32.lib");
                  AddLibrary("winspool.lib");
                  AddLibrary("shell32.lib");
                  AddLibrary("Msimg32.lib");
                  AddLibrary("ole32.lib");
                  AddLibrary("oleaut32.lib");
                  AddLibrary("uuid.lib");
                  AddLibrary("odbc32.lib");
                  AddLibrary("odbccp32.lib");
                  AddLibrary("winmm.lib");
                  AddLibrary("comdlg32.lib");
                  AddLibrary("imagehlp.lib");
                  AddLibrary("version.lib");
                  AddLibrary("wininet.lib");
                  AddLibrary("urlmon.lib");
                }
            }
        }
    }
  if(Use_GenFree&&GlobalDynaCnt ){
      MakeFreeGlobals();
    }
  Emit_Libs();
  ExportInternalConst();
  Emit_Epilog();
  CloseAll();
  AssembleParts();
  CreateUserResourceFile();
  if(ShowStatus ){
      cls();
    }
  if(!Quiet ){
      LinesRead+=(LineNum[1]);
      Elapsed=(float)clock()/(float)CLOCKS_PER_SEC;
      if(BCX_COLORS ){
          color (11,0 );
        }
      printf("%s","[Lines In:");
      if(BCX_COLORS ){
          color (14,0 );
        }
      printf("% .15G ",(double)LinesRead);
      if(BCX_COLORS ){
          color (11,0 );
        }
      printf("%s","] [Lines Out:");
      if(BCX_COLORS ){
          color (14,0 );
        }
      printf("% .15G ",(double)LinesWritten);
      if(BCX_COLORS ){
          color (11,0 );
        }
      printf("%s","] ");
      printf("%s","[Statements:");
      if(BCX_COLORS ){
          color (14,0 );
        }
      printf("% .15G ",(double)Statements);
      if(BCX_COLORS ){
          color (11,0 );
        }
      printf("%s","] [Time: ");
      if(BCX_COLORS ){
          color (14,0 );
        }
      printf("%s",Using("#.##",Elapsed));
      if(BCX_COLORS ){
          color (11,0 );
        }
      printf("%s\n"," Sec's]");
      char Tmp[BCXSTRSIZE]={0};
      strcpy(Tmp, join(2,"BCX translated [",RemoveStr(mcase(FileIn),SPC)));
      strcpy(Tmp, join(4,Tmp,"] to [",RemoveStr(mcase(FileOut),SPC),"]"));
      if(UseCpp ){
          strcat(Tmp," for a C++ Compiler");
        }
      else
        {
          strcat(Tmp," for a C Compiler");
        }
      if(Use_Project ){
          strcat(Tmp," with No Runtime");
        }
      if(BCX_COLORS ){
          color (10,0 );
        }
      printf("%s\n",Tmp);
      printf("\n");
      if(BCX_COLORS ){
          PopColors();
        }
    }
  if(Use_Project&&Gen_Header ){
      Project_Support();
    }
  if(WarnMsg[0]!=0 ){
      if(InfoBoxWarn ){
          InfoBox("Warnings! :",WarnMsg,GetSystemMetrics(SM_CXSCREEN)/4,GetSystemMetrics(SM_CYSCREEN)/4);
        }
      else
        {
          printf("%s%s%s\n","Warnings! :",CRLF,WarnMsg);
        }
    }
  Final_Transforms();
  PostProcess();
  if(KillCFile ){
      DeleteFile ((FileOut));
    }
  KillFiles();
  FreeGlobals();
  return EXIT_SUCCESS;
}

void Early_Transforms ()
{
  if(UseCpp==FALSE ){
      if(strcmp(ucase(left(Src,8)),"FUNCTION")==0  || strcmp(ucase(left(Src,10)),"OVERLOADED")==0  || strcmp(ucase(left(Src,8)),"CALLBACK")==0){
          if(!InTypeDef&&!InCppTypeDef ){
              DoInjection=FALSE;
              *Injection=0;
              strcpy(Src,trim(Src));
              ScanFuncNamesTypes(Src);
              if((int)strlen(FunctionNameType.FunctionName) && strcmp(ucase(FunctionNameType.FunctionType),"STRING")!=0){
                  DoInjection=TRUE;
                  strcpy(Injection,"DIM Bcx_RetVal AS ");
                  strcat(Injection,FunctionNameType .FunctionType);
                }
            }
        }
    }
  if(iMatchNQ(Src,"=+")&&!iMatchNQ(Src,"=++")){
      Abort("'=+' looks like a typo.");
    }
  if(iMatchNQ(Src,"+=")){
      char  LeftSide[BCXSTRSIZE]={0};
      char  RightSide[BCXSTRSIZE]={0};
      int  i={0};
      int  j={0};
      FastLexer(Src,SPC,"=&()[]{}',+-*/<>?;.|:^");
      if(strcmp(Stk[1],"!")==0){
          return;
        }
      if(bcx_stricmp(Stk[1],"if")==0){
          for(i=2; i<=Ndx; i++)
            {
              if(bcx_stricmp(Stk[i],"then")==0){
                  goto L1003;
                }
            }
L1003:;
          for(j=1; j<=i; j++)
            {
              strcpy(LeftSide, join(3,LeftSide,SPC,Stk[j]));
            }
          for(j=i+1; j<=Ndx; j++)
            {
              strcat(RightSide,Stk[j]);
            }
          FastLexer(RightSide,SPC,"=&()[]{}',+-*/<>?;.|:^");
        }
      TransformStringConcat();
      strcpy(Src,SPC);
      for(i=1; i<=Ndx; i++)
        {
          strcpy(Src, join(3,Src,Stk[i],SPC));
        }
      if(LeftSide[0]>0 ){
          strcpy(Src,trim(join(3,LeftSide,SPC,Src)));
        }
    }
  strcpy(Src, join(2,SPC,Src));
  if(UseCpp==FALSE ){
      if(iMatchNQ(Src,"<iostream>")){
          UseCpp=TRUE;
        }
      if(iMatchNQ(Src," delete ")){
          UseCpp=TRUE;
        }
      if(iMatchNQ(Src," std::cout ")){
          UseCpp=TRUE;
        }
      if(iMatchNQ(Src," std::cin ")){
          UseCpp=TRUE;
        }
      if(iMatchNQ(Src," class ")){
          UseCpp=TRUE;
        }
      if(iMatchNQ(Src," interface ")){
          UseCpp=TRUE;
        }
      if(iMatchNQ(Src," inline ")){
          if(like(Src,"*inline*function*")||like(Src,"*inline*sub*")){
              UseCpp=TRUE;
            }
        }
      if(like(Src,"*HANDLE_MSG*")){
          UseCpp=FALSE;
          UseInLine=FALSE;
        }
      if(iMatchNQ(Src," namespace ")){
          UseCpp=TRUE;
        }
      if(iMatchNQ(Src," template ")){
          UseCpp=TRUE;
        }
      if(iMatchNQ(Src," pptype ")){
          UseCpp=TRUE;
        }
      if(iMatchNQ(Src," operator ")){
          if(like(Src,"*function*operator*")){
              UseCpp=TRUE;
            }
        }
      if(!iMatchNQ(Src," binary ")){
          if(iMatchNQ(Src," new ")){
              UseCpp=TRUE;
            }
        }
    }
  if(UseCpp==TRUE ){
      if(iMatchNQ(Src,"propget")){
          strcpy(Src,iReplace_NQ(Src,"propget","FUNCTION"));
        }
      if(iMatchNQ(Src,"propset")){
          strcpy(Src,iReplace_NQ(Src,"propset","SUB"));
        }
      if(iMatchNQ(Src,"property")){
          char szTmp[BCXSTRSIZE]={0};
          strcpy(szTmp, join(3,SPC,Src,SPC));
          if(iinstr(szTmp," property ")){
              strcpy(Src,iReplace_NQ(Src,"property","SUB"));
            }
        }
      if(iMatchNQ(Src,"method")){
          char szTmp[BCXSTRSIZE]={0};
          strcpy(szTmp, join(3,SPC,Src,SPC));
          if(iinstr(szTmp," method ")||iinstr(szTmp," method=")){
              strcpy(Src,iReplace_NQ(Src,"method","FUNCTION"));
            }
        }
    }
  if(UseCpp==TRUE ){
      if(iMatchNQ(Src,"rbfor")||iMatchNQ(Src,"rbnext")||iMatchNQ(Src,"rbexit")){
          RBForTransform();
        }
    }
  if(iMatchNQ(Src,"band")){
      if(like(Src,"*select*case*band*")){
          char szTmp[BCXSTRSIZE]={0};
          strcpy(szTmp,trim(strim(Src)));
          if(like(szTmp,"select case band*")){
              strcpy(Src,iReplace_NQ(Src," band ",SPC));
              strcpy(Src, join(3,Src,SPC,"&&"));
            }
        }
    }
  if(iMatchNQ(Src,"const")){
      if(like(Src,"*dim*as*const*")){
          FastLexer(Src,SPC,"=&()[]{}',+-*/<>?;.|:^");
          if(bcx_stricmp(Stk[1],"dim")==0  &&  bcx_stricmp(Stk[2],"as")==0  &&  bcx_stricmp(Stk[3],"const")==0){
              strcpy(Src,replace(Src," [","["));
              strcpy(Src,replace(Src," ]","]"));
            }
        }
    }
  if(iMatchNQ(Src,"const")){
      FastLexer(Src,SPC,"=&()[]{}',+-*/<>?;.|:^");
      if(bcx_stricmp(Stk[1],"const")==0){
          FOR_EACH(i,ConstTypes);
          if(bcx_stricmp(Stk[2],ConstTypes[i])==0){
              strcpy(Src, join(2,"DIM AS ",Src));
              EXIT_EACH;
            }
          NEXT_EACH;
        }
    }
  if(iMatchTwoNQ(Src,"input "," #")==TRUE ){
      if(iMatchNQ(Src,"line ")==FALSE ){
          if(iMatchNQ(Src,"open ")==FALSE ){
              if(iMatchNQ(Src,"as ")==FALSE ){
                  strcpy(Src,iReplace_NQ(Src," input "," finput "));
                }
            }
        }
    }
  if(iMatchTwoNQ(Src,"print "," #")==TRUE ){
      if(iMatchNQ(Src,"using$")==FALSE ){
          if(iMatchNQ(Src,"lprint")==FALSE ){
              strcpy(Src,iReplace_NQ(Src," print "," fprint "));
            }
        }
    }
  if(iMatchNQ(Src,"print")){
      FastLexer(Src,SPC,"=&()[]{}',+-*/<>?;.|:^");
      for(int i=1; i<=Ndx; i++)
        {
          if(bcx_stricmp(Stk[i],"print")==0){
              if(CheckType(Stk[i+1])==vt_FILEPTR ){
                  strcpy(Src,iReplace_NQ(Src," print "," fprint "));
                }
            }
        }
    }
  if(iMatchNQ(Src," comset ")){
      strcpy(Src,iReplace(Src," comset "," SET "));
    }
  if(iMatchNQ(Src,"asciiz")){
      strcpy(Src,iReplace(Src,"asciiz","string"));
    }
  if(instr(Src,DDQUOT)){
      Use_DDQ=TRUE;
      strcpy(Src,replace(Src,DDQUOT," DDQ$ "));
    }
  if(instr(Src,DQUOT)){
      Use_DQ=TRUE;
      strcpy(Src,replace(Src,DQUOT," DQ$ "));
    }
  if(iMatchNQ(Src," $pragma ")){
      strcpy(Src,iReplace_NQ(Src,"$pragma ","!#pragma "));
    }
  if(iMatchNQ(Src," ANY ")){
      if(iMatchNQ(Src,"EXTRACT$")){
          strcpy(Src,iReplace(Src,"EXTRACT$","$TCARTXE"));
          strcpy(Src,Replace_ANY_Keyword(Src,"$TCARTXE"));
          strcpy(Src,iReplace(Src,"$TCARTXEANY"," EXTRACTANY$ "));
          Use_ExtractAny=Use_BcxTempStr=TRUE;
        }
      if(iMatchNQ(Src,"IINSTR")){
          strcpy(Src,iReplace(Src,"IINSTR","II2NSTR"));
          strcpy(Src,Replace_ANY_Keyword(Src,"II2NSTR"));
          strcpy(Src,iReplace(Src,"II2NSTRANY"," IINSTRANY "));
          Use_IInstrAny=Use_IInstr=TRUE;
        }
      if(iMatchNQ(Src,"INSTR")){
          strcpy(Src,Replace_ANY_Keyword(Src,"INSTR"));
        }
      if(iMatchNQ(Src,"IREMOVE$")){
          strcpy(Src,iReplace(Src,"IREMOVE$","REMOVEI$"));
          strcpy(Src,Replace_ANY_Keyword(Src,"REMOVEI$"));
          strcpy(Src,iReplace(Src,"REMOVEI$ANY"," IREMOVEANY$ "));
          Use_IRemoveAny=Use_BcxTempStr=TRUE;
        }
      if(iMatchNQ(Src,"IREPLACE$")){
          strcpy(Src,iReplace(Src,"IREPLACE$","REPLACEI$"));
          strcpy(Src,Replace_ANY_Keyword(Src,"REPLACEI$"));
          strcpy(Src,iReplace(Src,"REPLACEI$ANY"," IREPLACEANY$ "));
          Use_IReplaceAny=Use_BcxTempStr=TRUE;
        }
      if(iMatchNQ(Src,"REMOVE$")){
          strcpy(Src,Replace_ANY_Keyword(Src,"REMOVE$"));
        }
      if(iMatchNQ(Src,"REPLACE$")){
          strcpy(Src,Replace_ANY_Keyword(Src,"REPLACE$"));
        }
      strcpy(Src,iReplace(Src,"REMOVE$ANY"," REMOVEANY$ "));
      strcpy(Src,iReplace(Src,"REPLACE$ANY"," REPLACEANY$ "));
      strcpy(Src,iReplace(Src,"INSTRANY"," INSTRANY "));
      strcpy(Src,iReplace(Src,"EXTRACT$ANY"," EXTRACTANY$ "));
    }
  strcpy(Src,trim(Src));
}

void Final_Transforms ()
{
  char Source[BCXSTRSIZE];
  char Dll_Orig[BCXSTRSIZE];
  strcpy(Dll_Orig,vchr(30,67,95,69,88,80,79,82,84,32,105,110,116,32,95,95,115,116,100,99,97,108,108,32,68,108,108,77,97,105,110));
  char Dll_Repl[BCXSTRSIZE];
  strcpy(Dll_Repl,vchr(41,95,95,100,101,99,108,115,112,101,99,40,100,108,108,101,120,112,111,114,116,41,32,66,79,79,76,32,87,73,78,65,80,73,32,68,108,108,77,97,105,110));
  char QQF[BCXSTRSIZE];
  char QQR[BCXSTRSIZE];
  strcpy(QQF,chr(99,104,97,114,42,32,32,61,32,68,81,36));
  strcpy(QQR,chr(99,104,97,114,42,32,32,61,32,68,81));
  char BandAid[BCXSTRSIZE];
  strcpy(BandAid,chr(38,38,61,61));
  StripExtraDefWndProcs();
  ULONG  ZapBCXSTRSIZE={0};
  ULONGLONG  filesize={0};
  filesize=lof(FileOut);
  char *Buffer;
  Buffer=(char*)calloc(filesize ,1);
  if((FP1=fopen(FileOut, "rb+"))==0)
   {
  fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", FileOut); exit(1);
   }
  GET(FP1,Buffer,filesize );
  if(FP1)
   {
     fclose(FP1);
     FP1=NULL;
   }
  if(tally(Buffer,"BCXSTRSIZE")==1 ){
      ZapBCXSTRSIZE=TRUE;
    }
  if((FP1=fopen(FileOut, "rb"))==0)
   {
  fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", FileOut); exit(1);
   }
  if((FP2=fopen("$Bcx$Temp$File$", "w"))==0)
   {
  fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", "$Bcx$Temp$File$"); exit(1);
   }
  while(!EoF(FP1)){
      Source[0]=0;
      fgets(Source, 2048 , FP1);
        if(feof(FP1) || (Source[strlen(Source)-1]==10))
          {
           Source[strcspn(Source,"\r\n")] = 0;
          }
         else
          {
            printf("%s%d while reading file: %s\n","Error! - LINE INPUT truncation detected at PROGRAM line: ",__LINE__-7, NamePathFromFP(FP1));
            printf("%s\n","The actual truncated line of text:");
            printf("%s",Source);
            exit(1);
          }
      if(LeftStr(Source,"LRESULT CALLBACK WndProc (HWND hWnd,")){
          fprintf(FP2,"%s\n",Source);
          Source[0]=0;
          fgets(Source, 2048 , FP1);
            if(feof(FP1) || (Source[strlen(Source)-1]==10))
              {
               Source[strcspn(Source,"\r\n")] = 0;
              }
             else
              {
                printf("%s%d while reading file: %s\n","Error! - LINE INPUT truncation detected at PROGRAM line: ",__LINE__-7, NamePathFromFP(FP1));
                printf("%s\n","The actual truncated line of text:");
                printf("%s",Source);
                exit(1);
              }
          fprintf(FP2,"%s\n",Source);
          Source[0]=0;
          fgets(Source, 2048 , FP1);
            if(feof(FP1) || (Source[strlen(Source)-1]==10))
              {
               Source[strcspn(Source,"\r\n")] = 0;
              }
             else
              {
                printf("%s%d while reading file: %s\n","Error! - LINE INPUT truncation detected at PROGRAM line: ",__LINE__-7, NamePathFromFP(FP1));
                printf("%s\n","The actual truncated line of text:");
                printf("%s",Source);
                exit(1);
              }
          if(instr(Source,"Bcx_RetVal")==0 ){
              fprintf(FP2,"%s\n","  LRESULT Bcx_RetVal={0};");
              fprintf(FP2,"%s\n",Source);
              strcpy(Source,SPC);
            }
        }
      if(instr(Source,"BCXSTRSIZE")&&ZapBCXSTRSIZE ){
          continue;
        }
      if(strcmp(ltrim(Source),"")==0  && strcmp(ltrim(LookAhead(FP1)),"")==0){
          continue;
        }
      if(strcmp(ltrim(Source),"")==0  && strcmp(ltrim(LookAhead(FP1)),"#endif")==0){
          continue;
        }
      strcpy(Source,replace(Source,chr(15),":"));
      strcpy(Source,replace(Source,QQF,QQR));
      strcpy(Source,replace(Source,Dll_Orig,Dll_Repl));
      if(LeftStr(Source,"#define 3.14")){
          printf("%s\n","CONST PI was detected in your program.");
          printf("%s\n","PI is a BCX reserved word and cannot be re-defined.");
          printf("%s\n","You must update your source code to remove this error.");
          fflush(stdout);
          ExitProcess(0);
        }
      if(UserBcxStrSize[0]>0&&LeftStr(Source,"#define BCXSTRSIZE")){
          strcpy(Source, join(2,"#define BCXSTRSIZE ",UserBcxStrSize));
        }
      if(iMatchNQ(Source,"BCXSTRSIZE")){
          if(like(Source,"*=*[BCXSTRSIZE];*")){
              AllowLoadedStrings(Source);
            }
        }
      strcpy(Source,replace(Source,chr(61,45,32),chr(32,61,32,45)));
      strcpy(Source,replace(Source,chr(32,45,62),chr(45,62)));
      if(iMatchNQ(Source,BandAid)){
          if(like(Source,"*if(*")){
              strcpy(Source,replace(Source,BandAid," & "));
            }
        }
      strcpy(Source,replace(Source,chr(40,41,40,41),chr(40,40)));
      strcpy(Source,replace(Source,chr(70,73,76,69,32,32,32,42,32,32),"FILE   *"));
      if(instr(Source,"char*")){
          strcpy(Source,replace(Source,"char* ,","char*,"));
        }
      if(inchr(Source,"(")){
          strcpy(Source,iReplace_NQ(Source,"( ","("));
        }
      if(iMatchNQ(Source,"PostQuitMessage(0);")&&Use_Sound ){
          strcpy(Source, join(3,"       midiOutClose (hMidi);",LF,Source));
        }
      fprintf(FP2,"%s\n",Source);
    }
  _fcloseall();
  DeleteFile ((FileOut));
  MoveFile ("$Bcx$Temp$File$",FileOut );
  if (Buffer) {free(Buffer); Buffer = NULL;}
}

void TransformStringConcat ()
{
  int  j={0};
  int  InString={0};
  char QuoteChar[BCXSTRSIZE]={0};
  char Tmp[BCXSTRSIZE]={0};
  int  ParenDepth={0};
  for(int i=2; i<=Ndx-1; i++)
    {
      if(strcmp(Stk[i],DQ)==0){
          if(InString==FALSE ){
              InString=TRUE;
              strcpy(QuoteChar,Stk[i]);
            }
          else if(strcmp(Stk[i],DQ)==0){
              InString=FALSE;
            }
        }
      if(InString==FALSE ){
          if(strcmp(Stk[i],"+")==0  && strcmp(Stk[i+1],"=")==0){
              *Tmp=0;
              ParenDepth=0;
              j=i-1;
              while(j>0){
                  if(strcmp(Stk[j],")")==0){
                      ParenDepth+=1;
                      strcpy(Tmp, join(2,Stk[j],Tmp));
                    }
                  else if(strcmp(Stk[j],"(")==0){
                      ParenDepth-=1;
                      strcpy(Tmp, join(2,Stk[j],Tmp));
                      if(ParenDepth<0 ){
                          strcpy(Tmp,mid(Tmp,2));
                          goto L1010;
                        }
                    }
                  else if(ParenDepth==0&&(strcmp(Stk[j],SPC)==0  || strcmp(Stk[j],",")==0  || strcmp(Stk[j],"=")==0)){
                      goto L1010;
                    }
                  else
                    {
                      strcpy(Tmp, join(2,Stk[j],Tmp));
                    }
                  j-=1;
                }
L1010:;
              for(j=Ndx; j>=i+1; j+=-1)
                {
                  strcpy(Stk[j+1],Stk[j]);
                }
              strcpy(Stk[i],"=");
              strcpy(Stk[i+1],Tmp);
              strcpy(Stk[i+2],"+");
              Ndx+=1;
              goto L1009;
            }
        }
    }
L1009:;
}

void RBForTransform ()
{
  char Kopy[BCXSTRSIZE];
  strcpy(Kopy,trim(Src));
  if(LeftStr(Kopy,"rbfor",1)){
      strcpy(Src,iReplace_NQ(Src,"AUTO","auto"));
      strcpy(Src,iReplace_NQ(Src,"rbfor","! for "));
      strcat(Src," { ");
    }
  if(LeftStr(Kopy,"rbnext",1)){
      strcpy(Src,"}");
    }
  if(LeftStr(Kopy,"rbexit",1)){
      strcpy(Src,"break");
    }
}

void StripExtraDefWndProcs ()
{
  char Source[BCXSTRSIZE];
  char CurrLin[BCXSTRSIZE];
  char PrevLin[BCXSTRSIZE];
  if((FP1=fopen(FileOut, "rb"))==0)
   {
  fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", FileOut); exit(1);
   }
  if((FP2=fopen("$Bcx$Temp$File$", "w"))==0)
   {
  fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", "$Bcx$Temp$File$"); exit(1);
   }
  while(!EoF(FP1)){
      Source[0]=0;
      fgets(Source, 2048 , FP1);
        if(feof(FP1) || (Source[strlen(Source)-1]==10))
          {
           Source[strcspn(Source,"\r\n")] = 0;
          }
         else
          {
            printf("%s%d while reading file: %s\n","Error! - LINE INPUT truncation detected at PROGRAM line: ",__LINE__-7, NamePathFromFP(FP1));
            printf("%s\n","The actual truncated line of text:");
            printf("%s",Source);
            exit(1);
          }
      strcpy(CurrLin,left(ltrim(Source),20));
      if(strcmp(CurrLin,"return DefWindowProc")!=0){
          fprintf(FP2,"%s\n",Source);
          strcpy(PrevLin,left(ltrim(Source),7));
          continue;
        }
      if(strcmp(CurrLin,"return DefWindowProc")==0  && strcmp(PrevLin,"return ")!=0){
          fprintf(FP2,"%s\n",Source);
        }
      strcpy(PrevLin,left(ltrim(Source),7));
    }
  if(FP1)
   {
     fclose(FP1);
     FP1=NULL;
   }
  if(FP2)
   {
     fclose(FP2);
     FP2=NULL;
   }
  DeleteFile ((FileOut));
  MoveFile ("$Bcx$Temp$File$",FileOut );
}

void AllowLoadedStrings (char* szSrc)
{
  int i;
  char Varname[BCXSTRSIZE];
  char Literal[BCXSTRSIZE];
  char Target[BCXSTRSIZE];
  strcpy(Target, join(2,DQ,"[BCXSTRSIZE];"));
  i=instr(szSrc,Target);
  if(i>0 ){
      strcpy(Literal,mid(szSrc,1+inchr(szSrc,"=")));
      strcpy(Literal,RemoveStr(Literal,"[BCXSTRSIZE];"));
      strcpy(Varname,extract(szSrc,"="));
      strcpy(Varname,strim(Varname));
      strcpy(szSrc, join(2,Varname,"[BCXSTRSIZE];  strcpy("));
      strcpy(Varname,trim(mid(Varname,inchr(Varname,SPC))));
      strcpy(szSrc, join(5,szSrc,Varname,",",Literal,");"));
      strcpy(szSrc,iReplace_NQ(szSrc,CommaEq,","));
      strcpy(szSrc, join(2,space(3),szSrc));
    }
}

int iMatch (LPCTSTR  Arg,LPCTSTR  MatchStr,int mt)
{
  int  L1;
  int  L2;
  if(mt==2 ){
      L1=(int)strlen(Arg);
      L2=(int)strlen(MatchStr);
      if(L1<L2 ){
          return FALSE;
        }
      Arg=(Arg+L1)-L2;
    }
  while(*MatchStr){
      if(ISNULL(Arg)){
          return FALSE;
        }
      if((*Arg|32)!=(*MatchStr|32)){
          return FALSE;
        }
      Arg++;
      MatchStr++;
    }
  if(mt&&NOTNULL(Arg)){
      return FALSE;
    }
  else
    {
      return TRUE;
    }
}

int iMatchNQ (char* Arg,char* MatchStr)
{
  int mi;
  PCHAR  a;
  mi=0;
  a=Arg;
  while(MatchStr[mi]){
      if(*a==c_DblQt ){
          mi=0;
          while(*(++a)!=c_DblQt){
              if(*a==0 ){
                  return 0;
                }
            }
        }
      if(a[mi]==0 ){
          return 0;
        }
      if((a[mi]|32)!=(MatchStr[mi]|32)){
          a++;
          mi=(-1);
        }
      mi++;
    }
  return  CAST (int,(a-Arg)+1);
}

int GetBracketPair (int iStart,int iEnd,int iDir)
{
  for(int i=iStart; (iDir>=0 ? i<=iEnd : i>=iEnd); i+=iDir)
    {
      if(*Stk[i]==91&&*Stk[i+1]==93 ){
          return i;
        }
    }
  return 0;
}

int GetAsPos (int iStart,int iEnd,int iDir)
{
  for(int i=iStart; (iDir>=0 ? i<=iEnd : i>=iEnd); i+=iDir)
    {
      if(iMatchWrd(Stk[i],"as")){
          return i;
        }
    }
  return 0;
}

void BuildStr (int iStart,int iEnd,char* szBuild)
{
  *szBuild=0;
  for(int i=iStart; i<=iEnd; i++)
    {
      strcat(szBuild,Stk[i]);
    }
}

char * Clean (char *StringArg)
{
  char   *BCX_RetStr={0};
  char LTmp[BCXSTRSIZE];
  if(inchr(StringArg,"%")){
      if(strcmp(trim(StringArg),"%")==0){
          BCX_RetStr = BCX_TempStr(strlen(" % "));
          strcpy(BCX_RetStr," % ");
          return BCX_RetStr;
        }
    }
  if(iMatchNQ(StringArg,"!=")){
      BCX_RetStr = BCX_TempStr(strlen(StringArg));
      strcpy(BCX_RetStr,StringArg);
      return BCX_RetStr;
    }
  strcpy(LTmp,StringArg);
  RemoveAll(LTmp,VARTYPES,1);
  BCX_RetStr = BCX_TempStr(strlen(LTmp));
  strcpy(BCX_RetStr,LTmp);
  return BCX_RetStr;
}

void BuildDelimStr (int iStart,int iEnd,char* szBuild)
{
  PCHAR  pszStk;
  *szBuild=0;
  for(int i=iStart; i<=iEnd; i++)
    {
      pszStk= CAST (PCHAR,&(Stk[i]));
      if(NOTNULL(pszStk)){
          if(strcmp(pszStk,"!")==0){
              strcat(szBuild," ! ");
            }
          else
            {
              if(*pszStk==95 ){
                  strcat(szBuild,SPC);
                  strcat(szBuild,pszStk);
                }
              else
                {
                  strcat(szBuild,pszStk);
                  if(ispunct(*pszStk)){
                      if(ISNULL(pszStk+1)){
                          continue;
                        }
                    }
                }
              if(i<iEnd&&(ISFALSE ispunct(*Stk[i+1])||NOTZERO Stk[i+1][1])){
                  if(*Stk[2]!=61 ){
                      strcat(szBuild,SPC);
                    }
                }
            }
        }
    }
}

void BuildCleanStr (int iStart,int iEnd,char* szBuild)
{
  BuildDelimStr(iStart,iEnd,szBuild);
  strcpy(szBuild,Clean(szBuild));
}

void WriteCleanTokens (int iStart,int iEnd)
{
  char LTmp[BCXSTRSIZE];
  BuildCleanStr(iStart,iEnd,LTmp);
  fprintf(FP_WRITE,"%s\n",LTmp);
}

int HasThisToken (char* sToken)
{
  int ThisToken=0;
    {
    int  j;
    for(j=1; j<=Ndx && IAmNot(ThisToken); j++)
      {
        ThisToken=iMatchWrd(Stk[j],sToken);
      }
      }
  return ThisToken;
}

int MacroCheck ()
{
  char szMacroCheck[BCXSTRSIZE];
  int IsMacro=FALSE;
  FastLexer(Src," (","");
  strcpy(szMacroCheck,lcase(Stk[1]));
  if(iMatchNQ("handle_msg handle_cmd bcx_resource msghandler cmdhandler end",szMacroCheck)){
      if(strcmp(szMacroCheck,"handle_msg")==0){
          VerifyMatchedPairs();
          ProcessMsgCracker();
          IsMacro=TRUE;
          goto L1021;
        }
      if(strcmp(szMacroCheck,"handle_cmd")==0){
          VerifyMatchedPairs();
          ProcessCmdHandler();
          IsMacro=TRUE;
          goto L1021;
        }
      if(strcmp(szMacroCheck,"bcx_resource")==0){
          Use_GenResFile=TRUE;
          fprintf(FP_RES,"%s\n",mid(Src,14));
          IsMacro=TRUE;
          goto L1021;
        }
      if(strcmp(szMacroCheck,"msghandler")==0  || strcmp(szMacroCheck,"cmdhandler")==0){
          Inject_Local_Bcx_RetVal=TRUE;
          VerifyMatchedPairs();
          ProcessMsgHandler();
          IsMacro=TRUE;
          goto L1021;
        }
      if(strcmp(szMacroCheck,"end")==0){
          if(ISTRUE(iMatchWrd(Stk[2],"handler"))){
              VerifyMatchedPairs();
              ProcessMsgHandlerEnd();
              IsMacro=TRUE;
            }
        }
L1021:;
    }
  if(IsMacro==TRUE ){
      *Src=0;
    }
  return IsMacro;
}

void Process_ASC_Function (int St_idx)
{
  int i;
  int j;
  j=GetNumArgs(St_idx+2,&(i));
  if(*Stk[St_idx+2]==*DQ ){
      if(j||*Stk[St_idx+3]!=41 ){
          strcpy(Stk[St_idx],"asc");
          Use_Asc=Use_Proto=TRUE;
        }
      else
        {
          if(strcmp(Stk[St_idx+2],DDQ)==0){
              strcpy(Stk[St_idx],"0");
            }
          else
            {
              strcpy(Stk[St_idx],str(CAST (double,(UCHAR)*(Stk[St_idx+2]+1)),TRUE));
            }
          *Stk[St_idx+1]=0;
          *Stk[St_idx+2]=0;
          *Stk[St_idx+3]=0;
        }
    }
  else
    {
      if(j>0 ){
          strcpy(Stk[i],"+");
        }
      strcpy(Stk[St_idx],"(UCHAR)*");
    }
}

void ActivityFlags ()
{
  if(ShowStatus ){
      DisplayStatus();
    }
  if(ISTRUE(TraceFlag&&InFunction)){
      if(ISFALSE(iMatchLft(Src,"$trace"))){
          if(ISFALSE(iMatchLft(Src,"end "))&&ISZERO(iMatchNQ(Src,"function"))){
              fprintf(FP_WRITE,"%s%s%s%s%s%s\n","// [",trim(FileNames[FileNdx])," - ",trim(str(LineNum[FileNdx])),"] ",Src);
              char Tmp[BCXSTRSIZE]={0};
              strcpy(Tmp,trim(FileNames[FileNdx]));
              strcpy(Tmp,replace(Tmp,BKSLASH1,BKSLASH2));
              strcpy(Tmp, join(5,SPC,Tmp," - ",str(LineNum[FileNdx])," \\n"));
              strcpy(Tmp, join(3,"printf(",enc(Tmp),");"));
              fprintf(FP_WRITE,"%s\n",Tmp);
            }
        }
    }
  if(SrcFlag ){
      if(ISFALSE(iMatchLft(Src,"$sourc"))&&*Src!=33 ){
          fprintf(FP_WRITE,"%s%s%s%s%s%s\n","// [",trim(FileNames[FileNdx])," - ",trim(str(LineNum[FileNdx])),"] ",Src);
        }
    }
}

void DisplayStatus ()
{
  locate (5,1,0 );
  printf("%s%s%s% .15G \n","Processing Module: ",trim(FileNames[FileNdx])," - Line:",(double)LineNum[FileNdx]);
  locate (6,1,0 );
  printf("%s\n",space(1000));
  if(BCX_COLORS ){
      color (10,0 );
    }
  locate (6,1,0 );
  printf("%s\n",strim(AbortSrc));
  if(BCX_COLORS ){
      color (13,0 );
    }
  locate (10,1,0 );
  printf("%s\n","Press any key to cancel");
  BCX_Sleep(100);
  if(_kbhit()){
      _fcloseall();
      BCX_Sleep(100);
      DeleteFile (("BC.out"));
      DeleteFile (("BC.c"));
      DeleteFile (("BC.cpp"));
      PopColors();
      printf("%s\n","Cancelled by user. Unfinished translation files removed.");
      fflush(stdout);
      ExitProcess(0);
    }
  PopColors();
}

char * GetVarTypeName (int i)
{
  char   *BCX_RetStr={0};
  char A[BCXSTRSIZE];
  if(i==vt_INTEGER ){
      strcpy(A,"int");
      goto L1022;
    }
  if(i==vt_STRVAR ){
      strcpy(A,"char *");
      goto L1022;
    }
  if(i==vt_STRLIT ){
      strcpy(A,"STRLIT");
      goto L1022;
    }
  if(i==vt_UNKNOWN ){
      strcpy(A,"UNKNOWN");
      goto L1022;
    }
  if(i==vt_SINGLE ){
      strcpy(A,"float");
      goto L1022;
    }
  if(i==vt_DOUBLE ){
      strcpy(A,"double");
      goto L1022;
    }
  if(i==vt_LDOUBLE ){
      strcpy(A,"LDOUBLE");
      goto L1022;
    }
  if(i==vt_DECFUNC ){
      strcpy(A,"DECFUNC");
      goto L1022;
    }
  if(i==vt_NUMBER ){
      strcpy(A,"NUMBER");
      goto L1022;
    }
  if(i==vt_FILEPTR ){
      strcpy(A,"FILE*");
      goto L1022;
    }
  if(i==vt_UDT ){
      strcpy(A,"struct");
      goto L1022;
    }
  if(i==vt_STRUCT ){
      strcpy(A,"struct");
      goto L1022;
    }
  if(i==vt_UNION ){
      strcpy(A,"union");
      goto L1022;
    }
  if(i==vt_LPSTR ){
      strcpy(A,"PSTR");
      goto L1022;
    }
  if(i==vt_BSTR ){
      strcpy(A,"BSTR");
      goto L1022;
    }
  if(i==vt_BOOL ){
      strcpy(A,"BOOL");
      goto L1022;
    }
  if(i==vt_CHAR ){
      strcpy(A,"char");
      goto L1022;
    }
  if(i==vt_SCHAR ){
      strcpy(A,"signed char");
      goto L1022;
    }
  if(i==vt_LPSTRPTR ){
      strcpy(A,"PSTR *");
      goto L1022;
    }
  if(i==vt_CHARPTR ){
      strcpy(A,"char");
      goto L1022;
    }
  if(i==vt_PCHAR ){
      strcpy(A,"PCHAR");
      goto L1022;
    }
  if(i==vt_VOID ){
      strcpy(A,"void");
      goto L1022;
    }
  if(i==vt_LONG ){
      strcpy(A,"long");
      goto L1022;
    }
  if(i==vt_DWORD ){
      strcpy(A,"ULONG");
      goto L1022;
    }
  if(i==vt_FARPROC ){
      strcpy(A,"FARPROC");
      goto L1022;
    }
  if(i==vt_LPBYTE ){
      strcpy(A,"LPBYTE");
      goto L1022;
    }
  if(i==vt_LRESULT ){
      strcpy(A,"LRESULT");
      goto L1022;
    }
  if(i==vt_BYTE ){
      strcpy(A,"BYTE");
      goto L1022;
    }
  if(i==vt_SHORT ){
      strcpy(A,"short");
      goto L1022;
    }
  if(i==vt_USHORT ){
      strcpy(A,"USHORT");
      goto L1022;
    }
  if(i==vt_SSHORT ){
      strcpy(A,"signed short");
      goto L1022;
    }
  if(i==vt_COLORREF ){
      strcpy(A,"COLORREF");
      goto L1022;
    }
  if(i==vt_UINT ){
      strcpy(A,"UINT");
      goto L1022;
    }
  if(i==vt_ULONG ){
      strcpy(A,"ULONG");
      goto L1022;
    }
  if(i==vt_ULONGLONG ){
      strcpy(A,"ULONGLONG");
      goto L1022;
    }
  if(i==vt_LLONG ){
      strcpy(A,"long long");
      goto L1022;
    }
  if(i==vt_HWND ){
      strcpy(A,"HWND");
      goto L1022;
    }
  if(i==vt_HANDLE ){
      strcpy(A,"HANDLE");
      goto L1022;
    }
  if(i==vt_HINSTANCE ){
      strcpy(A,"HINSTANCE");
      goto L1022;
    }
  if(i==vt_HDC ){
      strcpy(A,"HDC");
      goto L1022;
    }
  if(i==vt_SAFEARRAY ){
      strcpy(A,"SAFEARRAY");
      goto L1022;
    }
  if(i==vt_VARIANT ){
      strcpy(A,"VARIANT");
      goto L1022;
    }
  if(i==vt_WNDCLASSEX ){
      strcpy(A,"WNDCLASSEX");
      goto L1022;
    }
  if(i==vt_HFONT ){
      strcpy(A,"HFONT");
      goto L1022;
    }
  if(i==vt_DOCINFO ){
      strcpy(A,"DOCINFO");
      goto L1022;
    }
  if(i==vt_LOGFONT ){
      strcpy(A,"LOGFONT");
      goto L1022;
    }
  if(i==vt_TEXTMETRIC ){
      strcpy(A,"TEXTMETRIC");
      goto L1022;
    }
  if(i==vt_WINBOOL ){
      strcpy(A,"BOOL");
      goto L1022;
    }
  if(i==vt_BITMAPINFO ){
      strcpy(A,"BITMAPINFO");
      goto L1022;
    }
  if(i==vt_HBITMAP ){
      strcpy(A,"HBITMAP");
    }
  else
    {
      *A=0;
    }
L1022:;
  BCX_RetStr = BCX_TempStr(strlen(A));
  strcpy(BCX_RetStr,A);
  return BCX_RetStr;
}

void LoopErrorMsg ()
{
  char sError[BCXSTRSIZE];
  if(LoopTypeCnt>1 ){
      strcpy(sError,"Multiple loop errors, innermost starting at");
    }
  else
    {
      strcpy(sError,"Loop error starting at");
    }
  strcpy(sError, join(3,sError,str(LoopType[LoopTypeCnt].iLoopLine),SPC));
  if(LoopType[LoopTypeCnt].iLoopType==lt_DOLOOP ){
      strcat(sError,"DO without LOOP");
      goto L1023;
    }
  if(LoopType[LoopTypeCnt].iLoopType==lt_DOWHILELOOP||LoopType[LoopTypeCnt].iLoopType==lt_DOUNTILLOOP ){
      strcat(sError,"DO CONDITION without LOOP");
      goto L1023;
    }
  if(LoopType[LoopTypeCnt].iLoopType==lt_WHILEWEND ){
      strcat(sError,"WHILE without WEND");
      goto L1023;
    }
  if(LoopType[LoopTypeCnt].iLoopType==lt_FORNEXT ){
      strcat(sError,"FOR without NEXT");
      goto L1023;
    }
  if(LoopType[LoopTypeCnt].iLoopType==lt_SELECT ){
      strcat(sError,"SELECT without END SELECT");
      goto L1023;
    }
  if(LoopType[LoopTypeCnt].iLoopType==lt_FORXNEXT ){
      strcat(sError,"XFOR without XNEXT");
    }
L1023:;
  Abort(sError);
}

char * LoopTypeName (int iLoopType)
{
  char   *BCX_RetStr={0};
  char sLoopType[BCXSTRSIZE]={0};
  if(iLoopType==lt_DOLOOP ){
      strcpy(sLoopType,"DO");
      goto L1024;
    }
  if(iLoopType==lt_DOWHILELOOP||iLoopType==lt_DOUNTILLOOP ){
      strcpy(sLoopType,"DO CONDITION");
      goto L1024;
    }
  if(iLoopType==lt_WHILEWEND ){
      strcpy(sLoopType,"WHILE");
      goto L1024;
    }
  if(iLoopType==lt_FORNEXT ){
      strcpy(sLoopType,"FOR");
      goto L1024;
    }
  if(iLoopType==lt_SELECT ){
      strcpy(sLoopType,"SELECT");
      goto L1024;
    }
  if(iLoopType==lt_FORXNEXT ){
      strcpy(sLoopType,"XFOR");
    }
L1024:;
  BCX_RetStr = BCX_TempStr(strlen(sLoopType));
  strcpy(BCX_RetStr,sLoopType);
  return BCX_RetStr;
}

void Emit_CompilerDefines ()
{
  static int BeenHere;
  if(BeenHere ){
      return;
    }
  BeenHere=TRUE;
  fprintf(FP_HDR,"%s\n","");
  fprintf(FP_HDR,"%s\n","// *************************************************");
  fprintf(FP_HDR,"%s\n","//                  Compiler Macros");
  fprintf(FP_HDR,"%s\n","// *************************************************");
  fprintf(FP_HDR,"%s\n","");
  if(UseImportExport ){
      fprintf(FP_HDR,"%s\n","#if defined(__cplusplus)");
      fprintf(FP_HDR,"%s\n","  #define C_EXPORT EXTERN_C __declspec(dllexport)");
      fprintf(FP_HDR,"%s\n","  #define C_IMPORT EXTERN_C __declspec(dllimport)");
      fprintf(FP_HDR,"%s\n","#else");
      fprintf(FP_HDR,"%s\n","  #define C_EXPORT __declspec(dllexport)");
      fprintf(FP_HDR,"%s\n","  #define C_IMPORT __declspec(dllimport)");
      fprintf(FP_HDR,"%s\n","#endif");
      fprintf(FP_HDR,"%s\n","");
    }
  if(NO_VKKEYS==FALSE&&ZapFlag==FALSE ){
      fprintf(FP_HDR,"%s\n","#ifndef    VK_0");
      fprintf(FP_HDR,"%s\n","   #define VK_0  0x30");
      fprintf(FP_HDR,"%s\n","   #define VK_1  0x31");
      fprintf(FP_HDR,"%s\n","   #define VK_2  0x32");
      fprintf(FP_HDR,"%s\n","   #define VK_3  0x33");
      fprintf(FP_HDR,"%s\n","   #define VK_4  0x34");
      fprintf(FP_HDR,"%s\n","   #define VK_5  0x35");
      fprintf(FP_HDR,"%s\n","   #define VK_6  0x36");
      fprintf(FP_HDR,"%s\n","   #define VK_7  0x37");
      fprintf(FP_HDR,"%s\n","   #define VK_8  0x38");
      fprintf(FP_HDR,"%s\n","   #define VK_9  0x39");
      fprintf(FP_HDR,"%s\n","   #define VK_A  0x41");
      fprintf(FP_HDR,"%s\n","   #define VK_B  0x42");
      fprintf(FP_HDR,"%s\n","   #define VK_C  0x43");
      fprintf(FP_HDR,"%s\n","   #define VK_D  0x44");
      fprintf(FP_HDR,"%s\n","   #define VK_E  0x45");
      fprintf(FP_HDR,"%s\n","   #define VK_F  0x46");
      fprintf(FP_HDR,"%s\n","   #define VK_G  0x47");
      fprintf(FP_HDR,"%s\n","   #define VK_H  0x48");
      fprintf(FP_HDR,"%s\n","   #define VK_I  0x49");
      fprintf(FP_HDR,"%s\n","   #define VK_J  0x4A");
      fprintf(FP_HDR,"%s\n","   #define VK_K  0x4B");
      fprintf(FP_HDR,"%s\n","   #define VK_L  0x4C");
      fprintf(FP_HDR,"%s\n","   #define VK_M  0x4D");
      fprintf(FP_HDR,"%s\n","   #define VK_N  0x4E");
      fprintf(FP_HDR,"%s\n","   #define VK_O  0x4F");
      fprintf(FP_HDR,"%s\n","   #define VK_P  0x50");
      fprintf(FP_HDR,"%s\n","   #define VK_Q  0x51");
      fprintf(FP_HDR,"%s\n","   #define VK_R  0x52");
      fprintf(FP_HDR,"%s\n","   #define VK_S  0x53");
      fprintf(FP_HDR,"%s\n","   #define VK_T  0x54");
      fprintf(FP_HDR,"%s\n","   #define VK_U  0x55");
      fprintf(FP_HDR,"%s\n","   #define VK_V  0x56");
      fprintf(FP_HDR,"%s\n","   #define VK_W  0x57");
      fprintf(FP_HDR,"%s\n","   #define VK_X  0x58");
      fprintf(FP_HDR,"%s\n","   #define VK_Y  0x59");
      fprintf(FP_HDR,"%s\n","   #define VK_Z  0x5A");
      fprintf(FP_HDR,"%s\n","#endif ");
      fprintf(FP_HDR,"%s\n","");
    }
  if(ZapFlag==FALSE ){
      if(NO_MSVC==FALSE ){
          fprintf(FP_HDR,"%s\n","// *************************************************");
          fprintf(FP_HDR,"%s\n","//                   Microsoft VC++");
          fprintf(FP_HDR,"%s\n","// *************************************************");
          fprintf(FP_HDR,"%s\n","");
          fprintf(FP_HDR,"%s\n","#ifndef DECLSPEC_UUID");
          fprintf(FP_HDR,"%s\n","  #if(_MSC_VER >= 1100) && defined(__cplusplus)");
          fprintf(FP_HDR,"%s\n","    #define DECLSPEC_UUID(x)  __declspec(uuid(x))");
          fprintf(FP_HDR,"%s\n","  #else");
          fprintf(FP_HDR,"%s\n","    #define DECLSPEC_UUID(x)");
          fprintf(FP_HDR,"%s\n","  #endif");
          fprintf(FP_HDR,"%s\n","#endif");
          fprintf(FP_HDR,"%s\n","#if (_MSC_VER >= 1900)            // earlier versions untested");
          fprintf(FP_HDR,"%s\n","   #include <intrin.h>");
          fprintf(FP_HDR,"%s\n","      #ifndef _rdtsc");
          fprintf(FP_HDR,"%s\n","         #define _rdtsc __rdtsc   // MSVC uses 2 underscores");
          fprintf(FP_HDR,"%s\n","      #endif");
          if(WarningFlag==FALSE ){
              fprintf(FP_HDR,"%s\n","   #pragma warning(disable: 4018) // signed/unsigned mismatch warnings");
              fprintf(FP_HDR,"%s\n","   #pragma warning(disable: 4100) // unreferenced argument warnings");
              fprintf(FP_HDR,"%s\n","   #pragma warning(disable: 4459) // local hides global declaration");
              fprintf(FP_HDR,"%s\n","   #pragma warning(disable: 4267) // conversion from type1 to type2 warnings");
              fprintf(FP_HDR,"%s\n","   #pragma warning(disable: 4305) // truncation from double to float warnings");
              fprintf(FP_HDR,"%s\n","   #pragma warning(disable: 4459) // hides global declaration warnings");
              fprintf(FP_HDR,"%s\n","   #pragma warning(disable: 4800) // forcing value to bool warnings");
              fprintf(FP_HDR,"%s\n","   #pragma warning(disable: 4838) // conversion from type1 to type2 warnings");
              fprintf(FP_HDR,"%s\n","   #pragma warning(disable: 4244) // conversion from type1 to type2 warnings");
              fprintf(FP_HDR,"%s\n","   #pragma warning(disable: 4245) // conversion from type1 to type2 warnings");
              fprintf(FP_HDR,"%s\n","   #pragma warning(disable: 4554) // use parentheses to clarify precedence");
              fprintf(FP_HDR,"%s\n","   #pragma warning(disable: 4389) // conversion from signed to unsigned warnings");
            }
          fprintf(FP_HDR,"%s\n","#endif");
          fprintf(FP_HDR,"%s\n","");
        }
      if(NO_GCCCLANG==FALSE ){
          fprintf(FP_HDR,"%s\n","");
          fprintf(FP_HDR,"%s\n","// *************************************************");
          fprintf(FP_HDR,"%s\n","//                  GCC and CLANG");
          fprintf(FP_HDR,"%s\n","// *************************************************");
          fprintf(FP_HDR,"%s\n","");
          fprintf(FP_HDR,"%s\n","#if defined(__GNUC__) || defined(__clang__)");
          fprintf(FP_HDR,"%s\n","   #ifndef __BCPLUSPLUS__");
          fprintf(FP_HDR,"%s\n","      #include <x86intrin.h>");
          fprintf(FP_HDR,"%s\n","   #endif");
          if(WarningFlag==FALSE ){
              fprintf(FP_HDR,"%s%s\n","   #pragma GCC diagnostic ignored ",enc("-Wwrite-strings"));
              fprintf(FP_HDR,"%s%s\n","   #pragma GCC diagnostic ignored ",enc("-Wunused-parameter"));
              fprintf(FP_HDR,"%s%s\n","   #pragma GCC diagnostic ignored ",enc("-Wunknown-pragmas"));
              fprintf(FP_HDR,"%s%s\n","   #pragma GCC diagnostic ignored ",enc("-Wdangling-else"));
              fprintf(FP_HDR,"%s%s\n","   #pragma GCC diagnostic ignored ",enc("-Wdeprecated"));
              fprintf(FP_HDR,"%s%s\n","   #pragma GCC diagnostic ignored ",enc("-Wsizeof-pointer-div"));
            }
          fprintf(FP_HDR,"%s\n","#endif");
          fprintf(FP_HDR,"%s\n","");
        }
      if(NO_BORLAND==FALSE ){
          fprintf(FP_HDR,"%s\n","");
          fprintf(FP_HDR,"%s\n","// *************************************************");
          fprintf(FP_HDR,"%s\n","//                  Embarcadero C++");
          fprintf(FP_HDR,"%s\n","// *************************************************");
          fprintf(FP_HDR,"%s\n","");
          fprintf(FP_HDR,"%s\n","#if defined(__BCPLUSPLUS__)");
          fprintf(FP_HDR,"%s\n","      #include<malloc.h>");
          fprintf(FP_HDR,"%s\n","      #if defined (_clang__)");
          fprintf(FP_HDR,"%s\n","          #include <mmintrin.h>");
          fprintf(FP_HDR,"%s\n","      #endif");
          fprintf(FP_HDR,"%s\n","      #define _kbhit kbhit");
          fprintf(FP_HDR,"%s\n","      #ifndef _rdtsc");
          fprintf(FP_HDR,"%s\n","         #define _rdtsc __rdtsc  // Uses 2 underscores");
          fprintf(FP_HDR,"%s\n","      #endif");
          fprintf(FP_HDR,"%s\n","#endif");
          fprintf(FP_HDR,"%s\n","");
        }
      if(ISFALSE UseCpp&&NO_LCCWIN==FALSE ){
          fprintf(FP_HDR,"%s\n","");
          fprintf(FP_HDR,"%s\n","// *************************************************");
          fprintf(FP_HDR,"%s\n","//                     Lcc-Win32");
          fprintf(FP_HDR,"%s\n","// *************************************************");
          fprintf(FP_HDR,"%s\n","");
          fprintf(FP_HDR,"%s\n","#if defined(__LCC__)");
          fprintf(FP_HDR,"%s\n","    #define _strdup    strdup");
          fprintf(FP_HDR,"%s\n","    #define _fseeki64  fseek");
          fprintf(FP_HDR,"%s\n","    #define _ftelli64  ftell");
          fprintf(FP_HDR,"%s\n","    #define _stricmp   stricmp");
          fprintf(FP_HDR,"%s\n","    #define _strnicmp  strnicmp");
          fprintf(FP_HDR,"%s\n","    #define _itoa      itoa");
          fprintf(FP_HDR,"%s\n","    #define _ltoa      ltoa");
          fprintf(FP_HDR,"%s\n","    #include <intrinsics.h>");
          fprintf(FP_HDR,"%s\n","    #include <malloc.h>  // for _msize");
          fprintf(FP_HDR,"%s\n","    #if defined(__windows_h__)");
          fprintf(FP_HDR,"%s\n","       #define COMPILE_MULTIMON_STUBS");
          fprintf(FP_HDR,"%s\n","       #include <multimon.h>");
          fprintf(FP_HDR,"%s\n","       #include <iehelper.h>");
          fprintf(FP_HDR,"%s\n","       #include <exdisp.h>");
          fprintf(FP_HDR,"%s\n","    #endif");
          fprintf(FP_HDR,"%s\n","#endif");
          fprintf(FP_HDR,"%s\n","");
        }
      if(Use_Overloaded_Macro ){
          fprintf(FP_HDR,"%s\n","#if !defined(__LCC__)");
          fprintf(FP_HDR,"%s\n","    #define overloaded");
          fprintf(FP_HDR,"%s\n","#else");
          fprintf(FP_HDR,"%s\n","    #define overloaded overloaded");
          fprintf(FP_HDR,"%s\n","#endif");
          fprintf(FP_HDR,"%s\n","");
        }
      if(ISFALSE UseCpp&&NO_PELLES==FALSE ){
          fprintf(FP_HDR,"%s\n","// *************************************************");
          fprintf(FP_HDR,"%s\n","//                     Pelles C");
          fprintf(FP_HDR,"%s\n","// *************************************************");
          fprintf(FP_HDR,"%s\n","");
          fprintf(FP_HDR,"%s\n","#if defined(__POCC__)");
          fprintf(FP_HDR,"%s\n","    #include <intrin.h>");
          fprintf(FP_HDR,"%s\n","    #pragma pack_stack(off)");
          if(WarningFlag==FALSE ){
              fprintf(FP_HDR,"%s\n","    #pragma warn(disable: 2006)    // Non-portable conversion int to const char*");
              fprintf(FP_HDR,"%s\n","    #pragma warn(disable: 2007)    // Non-portable inline code");
              fprintf(FP_HDR,"%s\n","    #pragma warn(disable: 2027)    // Missing prototype");
              fprintf(FP_HDR,"%s\n","    #pragma warn(disable: 2073)    // Loss of precision float to int");
              fprintf(FP_HDR,"%s\n","    #pragma warn(disable: 2115)    // Initialized but not used warnings");
              fprintf(FP_HDR,"%s\n","    #pragma warn(disable: 2118)    // Unreferenced argument warnings");
              fprintf(FP_HDR,"%s\n","    #pragma warn(disable: 2130)    // Usually flawed reporting");
              fprintf(FP_HDR,"%s\n","    #pragma warn(disable: 2134)    // Possible infinite loop");
              fprintf(FP_HDR,"%s\n","    #pragma warn(disable: 2154)    // Buggy unreachable code warning using sizeof");
              fprintf(FP_HDR,"%s\n","    #pragma warn(disable: 2197)    // Unsigned long int not a std bit-field type");
              fprintf(FP_HDR,"%s\n","    #pragma warn(disable: 2215)    // Conversion from type1 to type2 warnings");
              fprintf(FP_HDR,"%s\n","    #pragma warn(disable: 2218)    // Unreferenced parameter");
              fprintf(FP_HDR,"%s\n","    #pragma warn(disable: 2230)    // Incomplete struct declarations (vbs support)");
              fprintf(FP_HDR,"%s\n","    #pragma warn(disable: 2232)    // Unable to check variable arguments");
              fprintf(FP_HDR,"%s\n","    #pragma warn(disable: 2235)    // Not all control paths return a value");
              fprintf(FP_HDR,"%s\n","    #pragma warn(disable: 2241)    // Function marked for deprecation");
              fprintf(FP_HDR,"%s\n","    #pragma warn(disable: 2243)    // Use parentheses to clarify");
              fprintf(FP_HDR,"%s\n","    #pragma warn(disable: 2248)    // Non-portable use of extension");
              fprintf(FP_HDR,"%s\n","    #pragma warn(disable: 2251)    // Types with different signedness");
              fprintf(FP_HDR,"%s\n","    #pragma warn(disable: 2804)    // Consider changing type to size_t warnings");
              fprintf(FP_HDR,"%s\n","    #pragma warn(disable: 2805)    // Possible anti-aliasing violation warnings");
              fprintf(FP_HDR,"%s\n","    #pragma warn(disable: 2808)    // Unsequenced assignment warnings");
              fprintf(FP_HDR,"%s\n","    #pragma warn(disable: 2810)    // Potential realloc warnings");
              fprintf(FP_HDR,"%s\n","    #pragma warn(disable: 2812)    // Attempt to read from non-readable location");
              fprintf(FP_HDR,"%s\n","    #pragma warn(disable: 2813)    // Possible out-of-bounds warning (caused by CAST)");
            }
          fprintf(FP_HDR,"%s\n","#endif");
          fprintf(FP_HDR,"%s\n","");
        }
    }
}

void MakeFreeGlobals ()
{
  strcpy(Src,"SUB FreeGlobals");
  PassOne=TRUE;
  Inject(Src);
  while(GlobalDynaCnt){
      fprintf(FP_WRITE,"%s%s%s\n",SPC,SPC,GlobalDynaStr[GlobalDynaCnt]);
      GlobalDynaCnt--;
    }
  strcpy(Src,"END SUB");
  PassOne=TRUE;
  Inject(Src);
}

void ProcessSetCommand (int GS)
{
  struct _VARCODE  VarCode;
  int id;
  int ii;
  int iIsConst;
  int IsPointer;
  int iThisToken;
  int iFoundEqual;
  int SetString;
  int vt1;
  char szIsConst[BCXSTRSIZE];
  char LTmp[BCXSTRSIZE];
  char CVar[BCXSTRSIZE];
  char L_DimType[BCXSTRSIZE];
  FILE*  SaveFP;
  VarCode.UseInLine=UseInLine;
  VarCode.IsPtrFlag=0;
  SaveFP=FP_WRITE;
  SetString=0;
  if(InNameSpace||InClass ){
      FP_WRITE=FP_UDT;
    }
  else if(InFunction==FALSE ){
      FP_WRITE=FP_SET;
    }
  if(inchr(Src,"$")&&tally(Src,"[")>1 ){
      strcpy(Src,strim(Src));
      strcpy(Src,IRemoveStr(Src,"as string"));
      strcpy(Src,IRemoveStr(Src,"as char"));
      strcat(Src," AS char");
    }
  strcat(Src,"=");
  PassOne=TRUE;
  XParse(Src);
  FixUps();
  *gszType=0;
  *szIsConst=0;
  iThisToken=GetAsPosF(1,Ndx);
  if(iThisToken ){
      *Stk[iThisToken++]=0;
      strcpy(gszType,Stk[iThisToken]);
      if(iMatchWrd(gszType,"const")){
          strcpy(szIsConst,"const ");
          *Stk[iThisToken++]=0;
          strcpy(gszType,Stk[iThisToken]);
        }
      *Stk[iThisToken]=0;
    }
  if(ISNULL(gszType)){
      strcpy(gTmpStr,Stk[2]);
      SetString=DataType(gTmpStr);
      VarCode.Methd=mt_ProcessSetCommand;
      strcpy(VarCode.Token,gTmpStr);
      VarCode.VarNo=SetString;
      GetVarCode(&(VarCode),"set command");
      if(GS ){
          fprintf(FP_WRITE,"%s%s",Scoot,RemoveStr(VarCode.StaticOut,"static "));
        }
      else
        {
          fprintf(FP_WRITE,"%s%s",Scoot,VarCode.StaticOut);
        }
      *LTmp=0;
      strcpy(CVar,Clean(Stk[2]));
      ValidateVarName(CVar);
      vt1=DataType(Stk[2]);
      BuildStr(3,Ndx,LTmp);
      if(vt1==vt_STRVAR&&NOTNULL(LTmp)){
          strcat(LTmp,"[BCXSTRSIZE]");
        }
      if(InFunction==FALSE ){
          AddGlobal(CVar,vt1,0,LTmp,0,0,0,1);
        }
      else
        {
          AddLocal(CVar,vt1,0,LTmp,0,0,1);
        }
    }
  else
    {
      strcpy(CVar,Clean(Stk[2]));
      if(GS ){
          fprintf(FP_WRITE,"%s%s%s%s%s",Scoot,szIsConst,gszType,SPC,CVar);
        }
      else
        {
          fprintf(FP_WRITE,"%s%s%s%s%s%s",Scoot,"static ",szIsConst,gszType,SPC,CVar);
        }
      if(*szIsConst ){
          iIsConst=1;
        }
      else
        {
          iIsConst=0;
        }
      strcpy(L_DimType,RemoveStr(gszType,"*"));
      GetTypeInfo(gszType,&(IsPointer), &id, &vt1);
      if(vt1==vt_STRVAR ){
          strcat(L_DimType,"[BCXSTRSIZE]");
        }
      if(InFunction==FALSE ){
          AddGlobal(CVar,vt1,id,L_DimType,IsPointer,0,0,1,iIsConst);
        }
      else
        {
          AddLocal(CVar,vt1,id,L_DimType,IsPointer,0,1,iIsConst);
        }
    }
  iThisToken=2;
  iFoundEqual=FALSE;
  for(;;)
    {
      iThisToken++;
      if(*Stk[iThisToken]==61 ){
          iFoundEqual=TRUE;
        }
      if(SetString==vt_STRVAR&&iFoundEqual ){
          fprintf(FP_WRITE,"%s","[BCXSTRSIZE]=");
        }
      else
        {
          fprintf(FP_WRITE,"%s",Stk[iThisToken]);
        }
      if(*Stk[iThisToken]==61 ){
          goto L1026;
        }
      if(iThisToken==Ndx ){
          goto L1026;
        }
    }
L1026:;
  fprintf(FP_WRITE,"%s\n","");
  fprintf(FP_WRITE,"%s\n","  {");
  while(!EoF(SourceFile)){
      Src[0]=0;
      fgets(Src, 2048 , SourceFile);
        if(feof(SourceFile) || (Src[strlen(Src)-1]==10))
          {
           Src[strcspn(Src,"\r\n")] = 0;
          }
         else
          {
            printf("%s%d while reading file: %s\n","Error! - LINE INPUT truncation detected at PROGRAM line: ",__LINE__-7, NamePathFromFP(SourceFile));
            printf("%s\n","The actual truncated line of text:");
            printf("%s",Src);
            exit(1);
          }
      LineNum[FileNdx]++;
      StripCode(Src);
      if(JoinLines(Src)){
          continue;
        }
      PassOne=TRUE;
      XParse(Src);
      PassOne=FALSE;
      if(iMatchWrd(Src,"endset")){
          goto L1027;
        }
      TokenSubstitutions(2);
      if(*Src ){
          fprintf(FP_WRITE,"%s",SPC);
          for(ii=1; ii<=Ndx; ii++)
            {
              fprintf(FP_WRITE,"%s",Clean(Stk[ii]));
            }
          fprintf(FP_WRITE,"%s\n","");
        }
    }
L1027:;
  fprintf(FP_WRITE,"%s\n","};");
  fprintf(FP_WRITE,"%s\n","");
  *Src=0;
  FP_WRITE=SaveFP;
}

void Emit_Optimize (char* Str1,char* Str2,LPCTSTR  Str3)
{
  if(OptimizerEnabled ){
      fprintf(FP_WRITE,"%s\n","#if defined (__POCC__) && !defined(__cplusplus)");
      fprintf(FP_WRITE,"%s%s%s%s\n","  #pragma optimize(",Str1,")",Str3);
      fprintf(FP_WRITE,"%s\n","#elif !defined (__cplusplus)");
      fprintf(FP_WRITE,"%s%s%s%s\n","  #pragma optimize(",Str2,")",Str3);
      fprintf(FP_WRITE,"%s\n","#endif");
    }
}

void EnableProject ()
{
  static int iWasHere;
  if(iWasHere ){
      return;
    }
  char cHFn[BCXSTRSIZE];
  iWasHere++;
  strcpy(Project_Main,trim(RemoveStr(mid(Src,9),DQ)));
  strcpy(Project_Main,extract(Project_Main,"'"));
  strcpy(Project_Main,extract(Project_Main,"."));
  Use_Project=TRUE;
  if(inchr(command(1),chr(92))){
      strcpy(cHFn,mid(command(1),InstrRev(command(1),chr(92),0)+1));
    }
  else
    {
      strcpy(cHFn,command(1));
    }
  if(inchr(cHFn,".")){
      strcpy(cHFn,mid(cHFn,1,InstrRev(cHFn,".",0)-1));
    }
  fprintf(FP_HDR,"%s%s%s\n","#define __BCX_HEADER_",ucase(cHFn),"__");
}

int SubVarType (int TokenNum)
{
  int iVarType;
  int j=0;
  iVarType=CheckLocal(Stk[TokenNum],&(j));
  if(iVarType==vt_CHAR||iVarType==vt_SCHAR ){
      if(*LocalVars[j].VarDim!=91&&LocalVars[j].VarPntr==0 ){
          iVarType=vt_INTEGER;
        }
    }
  else
    {
      if(iVarType==vt_UNKNOWN ){
          iVarType=CheckGlobal(Stk[TokenNum],&(j));
          if(iVarType==vt_CHAR||iVarType==vt_SCHAR ){
              if(*GlobalVars[j].VarDim!=91&&GlobalVars[j].VarPntr==0 ){
                  iVarType=vt_INTEGER;
                }
            }
        }
    }
  j=(UCHAR)*(right(Stk[TokenNum],1));
  if(iVarType==vt_STRVAR||iVarType==vt_CHAR||iVarType==vt_SCHAR ){
      if(j!=36 ){
          strcpy(Stk[TokenNum], join(2,Stk[TokenNum],"$"));
        }
      goto L1029;
    }
  if(iVarType==vt_INTEGER ){
      if(j!=37 ){
          strcpy(Stk[TokenNum], join(2,Stk[TokenNum],"%"));
        }
      goto L1029;
    }
  if(iVarType==vt_SINGLE ){
      if(j!=33 ){
          strcpy(Stk[TokenNum], join(2,Stk[TokenNum],"!"));
        }
      goto L1029;
    }
  if(iVarType==vt_DOUBLE ){
      if(j!=35 ){
          strcpy(Stk[TokenNum], join(2,Stk[TokenNum],"#"));
        }
      goto L1029;
    }
  if(iVarType==vt_LDOUBLE ){
      if(j!=96 ){
          strcpy(Stk[TokenNum], join(2,Stk[TokenNum],"`"));
        }
    }
L1029:;
  return iVarType;
}

char * PrintWriteFormat (int DoWrite)
{
  char   *BCX_RetStr={0};
  char Arg[BCXSTRSIZE];
  int Argcount;
  char Frmat[BCXSTRSIZE];
  int iThisToken;
  int iVarType;
  char LZZ[BCXSTRSIZE];
  int SuppressCRLF;
  int NextArgcount;
  char PWF_Cast[BCXSTRSIZE];
  char TmpClean[BCXSTRSIZE];
  struct _ARGTYPE  Stak[128];
  int x;
  SuppressCRLF=FALSE;
  NextArgcount=1;
  Argcount=0;
  *Frmat=0;
  *Arg=0;
  *LZZ=0;
  if(strcmp(Stk[Ndx],";")==0){
      SuppressCRLF=TRUE;
      Ndx--;
    }
  if(Ndx==1 ){
      goto PRINTWRITELABEL;
    }
  Stak[1].ArgType=(-1);
  iThisToken=2;
  for(int i=1; i<=Ndx; i++)
    {
      if(strcmp(Stk[i],"(int)strlen")==0){
          strcpy(Stk[i],"strlen");
        }
    }
  for(int i=2; i<=Ndx; i++)
    {
      if(Im_UDT_String(Stk[i])){
          strcpy(Stk[i], join(2,Stk[i],"$"));
        }
      if(Im_UDT_Single(Stk[i])){
          strcpy(Stk[i], join(2,Stk[i],"!"));
        }
      if(Im_UDT_Double(Stk[i])){
          strcpy(Stk[i], join(2,Stk[i],"#"));
        }
    }
  for(int i=2; i<=Ndx; i++)
    {
      x=CheckType(Stk[i]);
      if(x==vt_STRVAR||x==vt_PCHAR||x==vt_CHARPTR ){
          strcpy(Stk[i], join(2,Stk[i],"$"));
          goto L1033;
        }
      if(x==vt_SINGLE ){
          strcpy(Stk[i], join(2,Stk[i],"!"));
          goto L1033;
        }
      if(x==vt_DOUBLE ){
          strcpy(Stk[i], join(2,Stk[i],"#"));
          goto L1033;
        }
      if(x==vt_LDOUBLE ){
          strcpy(Stk[i], join(2,Stk[i],"`"));
        }
L1033:;
    }
  char Testing[BCXSTRSIZE];
  int Dot;
  for(int i=2; i<=Ndx; i++)
    {
      strcpy(Testing, join(4,SPC,Clean(Stk[i]),"$",SPC));
      Dot=iMatchNQ(Stk[i],".");
      if(Dot ){
          strcpy(Testing, join(2,SPC,mid(Testing,Dot+2)));
        }
      if(instr(FuncStrNames,Testing)){
          if(!inchr(Stk[i],"$")){
              strcpy(Stk[i], join(2,Stk[i],"$"));
            }
        }
    }
  for(int i=2; i<=Ndx; i++)
    {
      strcpy(Testing, join(4,SPC,Clean(Stk[i]),"!",SPC));
      Dot=iMatchNQ(Stk[i],".");
      if(Dot ){
          strcpy(Testing, join(2,SPC,mid(Testing,Dot+2)));
        }
      if(instr(FuncSglNames,Testing)){
          if(!inchr(Stk[i],"!")){
              strcpy(Stk[i], join(2,Stk[i],"!"));
            }
        }
    }
  for(int i=2; i<=Ndx; i++)
    {
      strcpy(Testing, join(4,SPC,Clean(Stk[i]),"#",SPC));
      Dot=iMatchNQ(Stk[i],".");
      if(Dot ){
          strcpy(Testing, join(2,SPC,mid(Testing,Dot+2)));
        }
      if(instr(FuncDblNames,Testing)){
          if(!inchr(Stk[i],"#")){
              strcpy(Stk[i], join(2,Stk[i],"#"));
            }
        }
    }
  while(iThisToken<=Ndx){
      strcpy(TmpClean,Clean(Stk[iThisToken]));
      if(strcmp(TmpClean,"BCX_DynaCallA")!=0  && strcmp(TmpClean,"BCX_DynaCallB")!=0){
          iVarType=SubVarType(iThisToken);
          if(Stak[NextArgcount].ArgType==(-1)){
              if(iVarType==vt_CHAR||iVarType==vt_SCHAR||iVarType==vt_STRVAR||iVarType==vt_INTEGER||iVarType==vt_SINGLE||iVarType==vt_DOUBLE||iVarType==vt_LDOUBLE ){
                  Stak[NextArgcount].ArgType=iVarType;
                }
            }
          if(*Stk[iThisToken]==40 ){
              int iCnt=0;
              for(;;)
                {
                  if(*Stk[iThisToken]==40 ){
                      iCnt++;
                    }
                  if(*Stk[iThisToken]==41 ){
                      iCnt--;
                    }
                  strcat(Arg,Stk[iThisToken]);
                  iThisToken++;
                  if(iCnt<=0||iThisToken>=Ndx ){
                      goto L1039;
                    }
                }
L1039:;
            }
          if(*Stk[iThisToken]==91 ){
              int iCnt=0;
              for(;;)
                {
                  if(*Stk[iThisToken]==91 ){
                      iCnt++;
                    }
                  if(*Stk[iThisToken]==93 ){
                      iCnt--;
                    }
                  strcat(Arg,Stk[iThisToken]);
                  iThisToken++;
                  if(*Stk[iThisToken]==91&&iCnt==0 ){
                      continue;
                    }
                  if(iCnt<=0||iThisToken>=Ndx ){
                      goto L1040;
                    }
                }
L1040:;
            }
          if(*Stk[iThisToken]==59||*Stk[iThisToken]==44||*Stk[iThisToken]==38 ){
              Argcount++;
              NextArgcount++;
              strcpy(Stak[Argcount].Arg,Arg);
              Stak[NextArgcount].ArgType=(-1);
              *Arg=0;
              iThisToken++;
            }
          else
            {
              strcat(Arg,Stk[iThisToken]);
              iThisToken++;
            }
        }
      else
        {
          strcat(Arg,Stk[iThisToken]);
          iThisToken++;
        }
    }
  Argcount++;
  NextArgcount++;
  strcpy(Stak[Argcount].Arg,Arg);
  *Arg=0;
  for(iThisToken=1; iThisToken<=Argcount; iThisToken++)
    {
      iVarType=Stak[iThisToken].ArgType;
      if(iVarType==(-1)){
          strcpy(LZZ,extract(Stak[iThisToken].Arg,"("));
          iVarType=DataType(LZZ);
        }
      if(iVarType==vt_INTEGER ){
          int A;
          int indx;
          A=CheckLocal(LZZ,&(indx));
          if(A==vt_UNKNOWN ){
              A=CheckGlobal(LZZ,&(indx));
              if(A!=vt_UNKNOWN ){
                  iVarType=GlobalVars[indx].VarType;
                }
            }
          else
            {
              iVarType=LocalVars[indx].VarType;
            }
        }
      if(iVarType==vt_STRLIT||iVarType==vt_STRVAR||iVarType==vt_CHAR||iVarType==vt_SCHAR ){
          if(DoWrite ){
              strcpy(Frmat, join(7,Frmat,"\\",DQ,"%s","\\",DQ,","));
            }
          else
            {
              strcat(Frmat,"%s");
            }
          if(LeftStr(LZZ,"BCX_DynaCall")){
              strcpy(Arg, join(3,Arg,",(char*)",Stak[iThisToken].Arg));
            }
          else
            {
              strcpy(Arg, join(3,Arg,",",Stak[iThisToken].Arg));
            }
          goto L1042;
        }
      if(iVarType==vt_DOUBLE||iVarType==vt_NUMBER||iVarType==vt_INTEGER||iVarType==vt_DECFUNC ){
          if(DoWrite ){
              strcat(Frmat,"%.15G ,");
            }
          else
            {
              strcat(Frmat,"% .15G ");
            }
          strcpy(Arg, join(3,Arg,",(double)",Stak[iThisToken].Arg));
          goto L1042;
        }
      if(iVarType==vt_LLONG ){
          if(DoWrite ){
              strcat(Frmat,"%lli,");
            }
          else
            {
              strcat(Frmat,"% lli");
            }
          strcpy(Arg, join(3,Arg,",(long long)",Stak[iThisToken].Arg));
          goto L1042;
        }
      if(iVarType==vt_ULONGLONG ){
          if(DoWrite ){
              strcat(Frmat,"%llu,");
            }
          else
            {
              strcat(Frmat,"% llu");
            }
          strcpy(Arg, join(3,Arg,",(unsigned long long)",Stak[iThisToken].Arg));
          goto L1042;
        }
      if(iVarType==vt_SINGLE ){
          if(DoWrite ){
              strcat(Frmat,"%.7G,");
            }
          else
            {
              strcat(Frmat,"% .7G");
            }
          strcpy(Arg, join(3,Arg,",(float)",Stak[iThisToken].Arg));
          goto L1042;
        }
      if(iVarType==vt_LDOUBLE ){
          if(DoWrite ){
              strcat(Frmat,"%.19LG,");
            }
          else
            {
              strcat(Frmat,"% .19LG");
            }
          Use_Ldouble=TRUE;
          strcpy(Arg, join(3,Arg,",(LDOUBLE)",Stak[iThisToken].Arg));
        }
      else
        {
          if((UCHAR)*(Stak[iThisToken].Arg)==40 ){
              *LZZ=0;
              strcat(Arg,",");
              for(;;)
                {
                  int iParentheses=inchr(Stak[iThisToken].Arg,")");
                  strcpy(PWF_Cast,mid(Stak[iThisToken].Arg,1,iParentheses++));
                  strcpy(Stak[iThisToken].Arg,trim(mid(Stak[iThisToken].Arg,iParentheses)));
                  strcpy(PWF_Cast,iReplace(PWF_Cast,"char*","char *"));
                  strcpy(PWF_Cast,iReplace(PWF_Cast,"lpstr","char *"));
                  strcpy(PWF_Cast,iReplace(PWF_Cast,"integer","int"));
                  strcpy(PWF_Cast,iReplace(PWF_Cast,"single","float"));
                  strcpy(PWF_Cast,iReplace(PWF_Cast,"ldouble","LDOUBLE"));
                  strcpy(PWF_Cast,iReplace(PWF_Cast,"ulonglong","unsigned long long"));
                  strcpy(PWF_Cast,iReplace(PWF_Cast,"longlong","long long"));
                  strcpy(PWF_Cast,iReplace(PWF_Cast,"llong","long long"));
                  strcpy(PWF_Cast,iReplace(PWF_Cast,"long long","long long"));
                  if(ISNULL(LZZ)){
                      if(iMatchNQ("(char *)(int)(float)(double)(LDOUBLE)(long long)(unsigned long long)",PWF_Cast)){
                          strcpy(LZZ,PWF_Cast);
                        }
                      else
                        {
                          strcpy(LZZ,"(double)");
                          strcpy(PWF_Cast, join(2,LZZ,PWF_Cast));
                        }
                      RemoveAll(LZZ,"()");
                      strcpy(LZZ,iReplace(LZZ,"char *","%s"));
                      strcpy(LZZ,iReplace(LZZ,"int","% d "));
                      strcpy(LZZ,iReplace(LZZ,"float","% .7G "));
                      strcpy(LZZ,iReplace(LZZ,"ldouble","% .19LG "));
                      strcpy(LZZ,iReplace(LZZ,"double","% .15G "));
                      strcpy(LZZ,iReplace(LZZ,"long long","% lli "));
                      strcpy(LZZ,iReplace(LZZ,"unsigned long long","% llu "));
                    }
                  strcat(Arg,PWF_Cast);
                  if(!((UCHAR)*(Stak[iThisToken].Arg)==c_LPar)){
                      goto L1043;
                    }
                }
L1043:;
              strcat(Arg,Stak[iThisToken].Arg);
              strcat(Frmat,LZZ);
              if(DoWrite ){
                  strcat(Frmat,",");
                }
            }
          else
            {
              if(DoWrite ){
                  strcat(Frmat,"%G,");
                }
              else
                {
                  strcat(Frmat,"% G");
                  strcpy(Arg, join(3,Arg,",(float)",Stak[iThisToken].Arg));
                }
            }
        }
L1042:;
    }
  if(DoWrite ){
      strcpy(Frmat,left(Frmat,(int)strlen(Frmat)-1));
    }

PRINTWRITELABEL:;
  if(SuppressCRLF==FALSE ){
      strcat(Frmat,"\\n");
    }
  BCX_RetStr=join(4,"printf(",enc(Frmat),Clean(Arg),");");
  return BCX_RetStr;
}

void InputBufferFlags ()
{
  if(!Use_Inputbuffer ){
      Use_Inputbuffer=TRUE;
      Use_BcxTempStr=TRUE;
      Use_Scan=TRUE;
      Use_Proto=TRUE;
      Use_Split=TRUE;
      Use_Replace=TRUE;
      Use_Remove=TRUE;
      Use_Mid=TRUE;
      Use_Left=TRUE;
      Use_Instr=TRUE;
      Use_Stristr=TRUE;
      Use_UCaseTbl=TRUE;
    }
}

void CommonInputCode (char* Frmat,char* Arg)
{
  int Argcount=0;
  int iThisToken;
  int iVarType;
  char szParamToken[BCXSTRSIZE];
  char Stak[128][BCXSTRSIZE];
  Clear(Stak);
  InputBufferFlags();
  *Arg=0;
  *Frmat=0;
  iThisToken=1;
  while(iThisToken<=Ndx){
      if(strcmp(Stk[iThisToken],",")==0){
          Argcount++;
          strcpy(Stak[Argcount],Arg);
          *Arg=0;
          iThisToken++;
        }
      else
        {
          strcat(Arg,Stk[iThisToken]);
          iThisToken++;
          if(iThisToken<Ndx ){
              int iCnt=tally(Arg,"[")-tally(Arg,"]");
              while(iCnt){
                  strcat(Arg,Stk[iThisToken]);
                  iThisToken++;
                  iCnt=tally(Arg,"[")-tally(Arg,"]");
                }
            }
        }
    }
  Argcount++;
  strcpy(Stak[Argcount],Arg);
  *Arg=0;
  fprintf(FP_WRITE,"%s",Scoot);
  for(iThisToken=1; iThisToken<=Argcount; iThisToken++)
    {
      strcpy(szParamToken,Stak[iThisToken]);
      iVarType=CheckType(szParamToken);
      if(iVarType==vt_UDT||iVarType==vt_STRUCT||iVarType==vt_UNION ){
          iVarType=DataType(szParamToken);
        }
      else
        {
          int iCnt=inchr(szParamToken,"[");
          if(iCnt ){
              *(--iCnt+szParamToken)=0;
            }
          iVarType=DataType(szParamToken);
        }
      strcpy(szParamToken,Clean(Stak[iThisToken]));
      if(Im_UDT_String(szParamToken)){
          iVarType=vt_STRVAR;
        }
      if(Im_UDT_Single(szParamToken)){
          iVarType=vt_SINGLE;
        }
      if(Im_UDT_Double(szParamToken)){
          iVarType=vt_DOUBLE;
        }
      int x={0};
      for(int i=2; i<=Ndx; i++)
        {
          x=CheckType(szParamToken);
          if(x==vt_STRVAR ){
              iVarType=vt_STRVAR;
              goto L1048;
            }
          if(x==vt_PCHAR ){
              iVarType=vt_STRVAR;
              goto L1048;
            }
          if(x==vt_LPSTR ){
              iVarType=vt_STRVAR;
              goto L1048;
            }
          if(x==vt_CHARPTR ){
              iVarType=vt_STRVAR;
              goto L1048;
            }
          if(x==vt_SINGLE ){
              iVarType=vt_SINGLE;
              goto L1048;
            }
          if(x==vt_DOUBLE ){
              iVarType=vt_DOUBLE;
              goto L1048;
            }
          if(x==vt_LDOUBLE ){
              iVarType=vt_LDOUBLE;
            }
L1048:;
        }
      if(iVarType==vt_STRVAR ){
          strcat(Frmat,"%s");
          strcpy(Arg, join(3,Arg,",",szParamToken));
          fprintf(FP_WRITE,"%s%s%s","*",trim(szParamToken),"=0, ");
          goto L1049;
        }
      if(iVarType==vt_INTEGER ){
          strcat(Frmat,"%d");
          strcpy(Arg, join(3,Arg,",&",szParamToken));
          fprintf(FP_WRITE,"%s%s",szParamToken,"=0, ");
          goto L1049;
        }
      if(iVarType==vt_SINGLE ){
          strcat(Frmat,"%g");
          strcpy(Arg, join(3,Arg,",&",szParamToken));
          fprintf(FP_WRITE,"%s%s",szParamToken,"=0, ");
          goto L1049;
        }
      if(iVarType==vt_DOUBLE ){
          strcat(Frmat,"%lG");
          strcpy(Arg, join(3,Arg,",&",szParamToken));
          fprintf(FP_WRITE,"%s%s",szParamToken,"=0, ");
          goto L1049;
        }
      if(iVarType==vt_LDOUBLE ){
          strcat(Frmat,"%lG");
          strcpy(Arg, join(3,Arg,",&",szParamToken));
          fprintf(FP_WRITE,"%s%s",szParamToken,"=0, ");
        }
      else
        {
          strcat(Frmat,"%d");
          strcpy(Arg, join(3,Arg,",&",szParamToken));
          fprintf(FP_WRITE,"%s%s",szParamToken,"=0, ");
        }
L1049:;
    }
}

void Emit_InputCode ()
{
  char Frmat[BCXSTRSIZE];
  char Arg[BCXSTRSIZE];
  char szWrk[BCXSTRSIZE];
  int TestType;
  int iThisToken=2;
  if(DataType(Stk[iThisToken])==vt_STRLIT ){
      if(strcmp(Stk[iThisToken+1],",")==0){
          fprintf(FP_WRITE,"%s%s%s%s",Scoot,"printf(",Clean(Stk[iThisToken]),"), ");
        }
      else
        {
          fprintf(FP_WRITE,"%s%s%s%s%s%s",Scoot,"printf(",enc("%s? "),",",Clean(Stk[iThisToken]),"), ");
        }
      iThisToken=4;
    }
  for(int i=1; i<=Ndx; i++)
    {
      if(Im_UDT_String(Stk[i])){
          strcpy(Stk[i], join(2,Stk[i],"$"));
        }
      if(Im_UDT_Single(Stk[i])){
          strcpy(Stk[i], join(2,Stk[i],"!"));
        }
      if(Im_UDT_Double(Stk[i])){
          strcpy(Stk[i], join(2,Stk[i],"#"));
        }
      TestType=CheckType(Stk[i]);
      if(TestType==vt_STRVAR ){
          strcpy(Stk[i], join(2,Stk[i],"$"));
        }
      if(TestType==vt_SINGLE ){
          strcpy(Stk[i], join(2,Stk[i],"!"));
        }
      if(TestType==vt_DOUBLE ){
          strcpy(Stk[i], join(2,Stk[i],"#"));
        }
      if(TestType==vt_LDOUBLE ){
          strcpy(Stk[i], join(2,Stk[i],"#"));
        }
    }
  BuildStr(iThisToken,Ndx,szWrk);
  FastLexer(szWrk,"",",");
  CommonInputCode(Frmat,Arg);
  Use_KBinput=Use_Scan=TRUE;
  fprintf(FP_WRITE,"%s%s",Scoot,"KBinput(),");
  fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,"ScanError=scan(InputBuffer,",enc(Frmat),Arg,");");
}

void Emit_FileInputCode ()
{
  char Arg[BCXSTRSIZE]={0};
  char Frmat[BCXSTRSIZE]={0};
  char szWrk[BCXSTRSIZE]={0};
  int iThisToken={0};
  char FHandle[BCXSTRSIZE]={0};
  InputBufferFlags();
  for(int Tmp=2; Tmp<=Ndx; Tmp++)
    {
      if(*Stk[Tmp]==35 ){
          strcpy(Stk[Tmp],RemoveStr(Stk[Tmp],"#"));
        }
    }
  if(DataType(Stk[2])==vt_NUMBER ){
      strcpy(Stk[2], join(2,"FP",Stk[2]));
    }
  iThisToken=4;
  for(int j=2; j<=Ndx; j++)
    {
      if(*Stk[j]==44 ){
          iThisToken=j+1;
          goto L1052;
        }
      strcat(FHandle,Stk[j]);
    }
L1052:;
  for(int i=1; i<=Ndx; i++)
    {
      if(Im_UDT_String(Stk[i])){
          strcpy(Stk[i], join(2,Stk[i],"$"));
        }
      if(Im_UDT_Single(Stk[i])){
          strcpy(Stk[i], join(2,Stk[i],"!"));
        }
      if(Im_UDT_Double(Stk[i])){
          strcpy(Stk[i], join(2,Stk[i],"#"));
        }
      if(CheckType(Stk[i])==vt_STRVAR ){
          strcpy(Stk[i], join(2,Stk[i],"$"));
        }
      if(CheckType(Stk[i])==vt_SINGLE ){
          strcpy(Stk[i], join(2,Stk[i],"!"));
        }
      if(CheckType(Stk[i])==vt_DOUBLE ){
          strcpy(Stk[i], join(2,Stk[i],"#"));
        }
      if(CheckType(Stk[i])==vt_LDOUBLE ){
          strcpy(Stk[i], join(2,Stk[i],"#"));
        }
    }
  BuildStr(iThisToken,Ndx,szWrk);
  FastLexer(szWrk,"",",");
  CommonInputCode(Frmat,Arg);
  fprintf(FP_WRITE,"%s%s%s\n","fgets(InputBuffer, 0x100000, ",FHandle,");");
  fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"InputBuffer[strcspn(InputBuffer, ",enc("\\r\\n"),")] = 0;");
  fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,"ScanError = scan(InputBuffer,",enc(Frmat),Arg,");");
  fprintf(FP_WRITE,"%s%s\n",Scoot,"*InputBuffer=0;");
}

void FinishingTouches ()
{
  if(Use_Project==FALSE ){
      int Accum=Use_BCXMDialog;
      Accum+=(Use_BCXDialog);
      Accum+=(Use_Form);
      Accum+=(Use_Button);
      Accum+=(Use_BmpButton);
      Accum+=(Use_Edit);
      Accum+=(Use_BCX_Input);
      Accum+=(Use_Label);
      Accum+=(Use_Group);
      Accum+=(Use_Checkbox);
      Accum+=(Use_Radio);
      Accum+=(Use_Combobox);
      Accum+=(Use_Listbox);
      Accum+=(Use_Treeview);
      Accum+=(Use_Blackrect);
      Accum+=(Use_Whiterect);
      Accum+=(Use_Grayrect);
      Accum+=(Use_Datepick);
      Accum+=(Use_Richedit);
      Accum+=(Use_Bitmap);
      Accum+=(Use_BCX_OlePicture);
      Accum+=(Use_Icon);
      Accum+=(Use_Listview);
      Accum+=(Use_BCX_Control);
      Accum+=(Use_ProgressBar);
      Accum+=(Use_BCX_Slider);
      Accum+=(Use_BCX_Splitter);
      Accum+=(Use_BCX_Tab);
      Accum+=(Use_BCX_Toolbar);
      Accum+=(Use_BCX_UpDown);
      Accum+=(Use_Set_BCX_Icon);
      Accum+=(Use_BCX_FrameWnd);
      Accum+=(Use_BCX_Wnd);
      Accum+=(Use_BCX_SetIcon);
      Accum+=(Use_BCX_SetIconSm);
      Accum+=(Use_BCX_SetCursor);
      Accum+=(Use_BCX_RegWnd);
      Accum+=(Use_BCX_InitGUI);
      if(Accum ){
          AddBCX_hInstance();
          AddFontVariables();
        }
    }
}

void AssembleParts ()
{
  char LTmp1[BCXSTRSIZE];
  char P1[BCXSTRSIZE]={0};
  char P2[BCXSTRSIZE]={0};
  char P3[BCXSTRSIZE]={0};
  char P4[BCXSTRSIZE]={0};
  char P5[BCXSTRSIZE]={0};
  char P6[BCXSTRSIZE]={0};
  char P7[BCXSTRSIZE]={0};
  char P8[BCXSTRSIZE]={0};
  DoCountLines=TRUE;
  FinishingTouches();
  if(Exist("$WRK$.TXT")){
      DeleteFile (("$WRK$.TXT"));
    }
  MoveFile (FileOut,"$WRK$.TXT" );
  if(ISNULL(CmdLineFileOut)){
      if(UseCpp ){
          strcpy(gTmpStr, join(2,extract(FileOut,"."),".cpp"));
          DeleteFile ((gTmpStr));
          strcpy(FileOut,gTmpStr);
        }
      else
        {
          strcpy(gTmpStr, join(2,extract(FileOut,"."),".c"));
          DeleteFile ((gTmpStr));
          strcpy(FileOut,gTmpStr);
        }
    }
  if((FP_W=fopen(FileOut, "w"))==0)
   {
  fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", FileOut); exit(1);
   }
  Emit_Prolog(FP_W);
  Commandline_Defines(FP_W);
  System_Defined_Constants(FP_W);
  User_Defined_Constants(FP_W);
  Emit_UserDirectives(FP_W);
  User_Global_Enum_Blocks(FP_W);
  if(Use_Project==FALSE ){
      if(Use_SingleFile==FALSE ){
          if((FP_HeaderFile=fopen(HFile, "w"))==0)
           {
          fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", HFile); exit(1);
           }
        }
    }
  StdProtos(FP_W);
  User_Defined_Types_And_Unions(FP_W);
  System_Vars(FP_W);
  if(Use_COM ){
      Emit_COM_SupportTypes(FP_W);
    }
  User_Global_Variables(FP_W);
  User_Data_Statements(FP_W);
  AddMacros(FP_W);
  User_Prototypes(FP_W);
  User_Global_Initialized_Arrays(FP_W);
  User_Overloaded_SubsFunctions(FP_W);
  User_Global_Set_Statements(FP_W);
  if(Use_SingleFile==FALSE ){
      if(FP_HeaderFile)
       {
         fclose(FP_HeaderFile);
         FP_HeaderFile=NULL;
       }
    }
  if(Use_SingleFile==TRUE&&Use_Project==FALSE ){
      RunTimeFunctions(FP_W);
    }
  else
    {
      if(Use_Project==FALSE ){
          SetFlags();
        }
    }
  BOOL  bMain=(Use_Wingui+MakeDLL+NoMain);
  BOOL  bMainOut=FALSE;
  if(lof(cppFile)){
      fprintf(FP_W,"%s\n","");
      fprintf(FP_W,"%s\n","// *************************************************");
      fprintf(FP_W,"%s\n","//                   User's C code");
      fprintf(FP_W,"%s\n","// *************************************************");
      fprintf(FP_W,"%s\n","");
      if((FP_R=fopen(cppFile, "rb"))==0)
       {
      fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", cppFile); exit(1);
       }
      while(!EoF(FP_R)){
          LTmp1[0]=0;
          fgets(LTmp1, 2048 , FP_R);
            if(feof(FP_R) || (LTmp1[strlen(LTmp1)-1]==10))
              {
               LTmp1[strcspn(LTmp1,"\r\n")] = 0;
              }
             else
              {
                printf("%s%d while reading file: %s\n","Error! - LINE INPUT truncation detected at PROGRAM line: ",__LINE__-7, NamePathFromFP(FP_R));
                printf("%s\n","The actual truncated line of text:");
                printf("%s",LTmp1);
                exit(1);
              }
          fprintf(FP_W,"%s\n",LTmp1);
        }
      if(FP_R)
       {
         fclose(FP_R);
         FP_R=NULL;
       }
    }
  if(Exist(prcFile)&&lof(prcFile)>2 ){
      fprintf(FP_W,"%s\n","// *************************************************");
      fprintf(FP_W,"%s\n","//            User's Subs and Functions");
      fprintf(FP_W,"%s\n","// *************************************************");
      fprintf(FP_W,"%s\n","");
      if(UseCpp ){
          strcpy(P1,chr(99,111,117,116,60,60));
          strcpy(P2,chr(99,111,117,116,32,60,60,32));
          strcpy(P3,chr(99,105,110,60,60));
          strcpy(P4,chr(99,105,110,32,60,60,32));
          strcpy(P5,chr(60,60,115,116,100,58,58));
          strcpy(P6,chr(32,60,60,32,115,116,100,58,58));
          strcpy(P7,chr(60,60,101,110,100,108));
          strcpy(P8,chr(32,60,60,32,101,110,100,108));
        }
      if((FP_R=fopen(prcFile, "rb"))==0)
       {
      fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", prcFile); exit(1);
       }
      while(!EoF(FP_R)){
          LTmp1[0]=0;
          fgets(LTmp1, 2048 , FP_R);
            if(feof(FP_R) || (LTmp1[strlen(LTmp1)-1]==10))
              {
               LTmp1[strcspn(LTmp1,"\r\n")] = 0;
              }
             else
              {
                printf("%s%d while reading file: %s\n","Error! - LINE INPUT truncation detected at PROGRAM line: ",__LINE__-7, NamePathFromFP(FP_R));
                printf("%s\n","The actual truncated line of text:");
                printf("%s",LTmp1);
                exit(1);
              }
          if(UseCpp ){
              strcpy(LTmp1,replace(LTmp1,P1,P2));
              strcpy(LTmp1,replace(LTmp1,P3,P4));
              strcpy(LTmp1,replace(LTmp1,P5,P6));
              strcpy(LTmp1,replace(LTmp1,P7,P8));
            }
          fprintf(FP_W,"%s\n",LTmp1);
          if(bMainOut ){
              continue;
            }
          bMainOut=CheckForMain(LTmp1,bMain);
        }
      if(FP_R)
       {
         fclose(FP_R);
         FP_R=NULL;
       }
    }
  if(Use_Wingui==FALSE&&NoMain==FALSE ){
      fprintf(FP_W,"%s\n","");
      fprintf(FP_W,"%s\n","// *************************************************");
      fprintf(FP_W,"%s%s\n","//                  ",BCX_STR_MAIN_PROG);
      fprintf(FP_W,"%s\n","// *************************************************");
      fprintf(FP_W,"%s\n","");
    }
  if((FP_R=fopen("$WRK$.TXT", "rb"))==0)
   {
  fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", "$WRK$.TXT"); exit(1);
   }
  while(!EoF(FP_R)){
      LTmp1[0]=0;
      fgets(LTmp1, 2048 , FP_R);
        if(feof(FP_R) || (LTmp1[strlen(LTmp1)-1]==10))
          {
           LTmp1[strcspn(LTmp1,"\r\n")] = 0;
          }
         else
          {
            printf("%s%d while reading file: %s\n","Error! - LINE INPUT truncation detected at PROGRAM line: ",__LINE__-7, NamePathFromFP(FP_R));
            printf("%s\n","The actual truncated line of text:");
            printf("%s",LTmp1);
            exit(1);
          }
      if(iMatchNQ(LTmp1,"int main")){
          if(bMain ){
              continue;
            }
        }
      fprintf(FP_W,"%s%s\n",Scoot,LTmp1);
      if(bMainOut ){
          continue;
        }
      bMainOut=CheckForMain(LTmp1,bMain);
    }
  if(FP_R)
   {
     fclose(FP_R);
     FP_R=NULL;
   }
  DeleteFile (("$WRK$.TXT"));
  if(FP_W)
   {
     fclose(FP_W);
     FP_W=NULL;
   }
  DoCountLines=FALSE;
}

int CheckForMain (char* ArgStr,BOOL bMain)
{
  int bMainOut=FALSE;
  char LTmp1[BCXSTRSIZE];
  char LZZ[BCXSTRSIZE];
  if(iMatchNQ(ArgStr,"main")){
      strcpy(LZZ,ltrim(ArgStr));
      strcpy(Scoot,space(2));
      if(LeftStr(LZZ,"int main")||LeftStr(LZZ,"int WINAPI WinMain")||LeftStr(LZZ,"__declspec(dllexport) BOOL WINAPI DllMain")||like(LZZ,"*__stdcall*DllMain*(HINSTANCE *,*")){
          if(bMain==FALSE ){
              fprintf(FP_W,"%s\n","{");
            }
          if(bMain ){
              LTmp1[0]=0;
              fgets(LTmp1, 2048 , FP_R);
                if(feof(FP_R) || (LTmp1[strlen(LTmp1)-1]==10))
                  {
                   LTmp1[strcspn(LTmp1,"\r\n")] = 0;
                  }
                 else
                  {
                    printf("%s%d while reading file: %s\n","Error! - LINE INPUT truncation detected at PROGRAM line: ",__LINE__-7, NamePathFromFP(FP_R));
                    printf("%s\n","The actual truncated line of text:");
                    printf("%s",LTmp1);
                    exit(1);
                  }
              fprintf(FP_W,"%s\n",LTmp1);
            }
          if(Use_Console ){
              fprintf(FP_W,"%s%s\n",Scoot,"hConsole=GetStdHandle(STD_OUTPUT_HANDLE);");
            }
          if(Use_StartupCode ){
              fprintf(FP_W,"%s%s\n",Scoot,"int BCX_SUCode=BCX_StartupCode_();  // execute user's startup code");
            }
          if(Use_ExitCode ){
              fprintf(FP_W,"%s%s\n",Scoot,"int BCX_EXCode=BCX_ExitCode_();     // Prepare for user's exit code");
            }
          if(Use_LCaseTbl ){
              fprintf(FP_W,"%s%s\n",Scoot,"LowCase = MakeLCaseTbl();");
            }
          if(Use_UCaseTbl ){
              fprintf(FP_W,"%s%s\n",Scoot,"UprCase = MakeUCaseTbl();");
            }
          if(DllCnt ){
              char szLoadLibHandle[BCXSTRSIZE]={0};
              char LTmp[BCXSTRSIZE]={0};
              int i={0};
              fprintf(FP_W,"%s%s\n",Scoot,"");
              fprintf(FP_W,"%s%s\n",Scoot,"// **********[ DLL Declarations ]**********");
              fprintf(FP_W,"%s%s\n",Scoot,"");
              if(Use_LoadLibraryError ){
                  fprintf(FP_W,"%s%s\n",Scoot,"FILE   *FPLoadLibraryErrorLog;");
                  char Op[BCXSTRSIZE];
                  strcpy(Op,enc("w"));
                  if(UseFileTest ){
                      fprintf(FP_W,"%s%s%s%s%s%s\n",Scoot,"if((FPLoadLibraryErrorLog=fopen(",LibraryErrorLog,", ",Op,"))==0)");
                      fprintf(FP_W,"%s%s\n",Scoot," {");
                      strcpy(LTmp,enc("Error: Cannot Access File or File Not Found. %s\\n"));
                      fprintf(FP_W,"%s%s%s%s%s%s\n",Scoot,"fprintf(stderr, ",LTmp,", ",LibraryErrorLog,"); exit(1);");
                      fprintf(FP_W,"%s%s\n",Scoot," }");
                    }
                  else
                    {
                      fprintf(FP_W,"%s%s%s%s%s%s\n",Scoot,"FPLoadLibraryErrorLog = fopen(",enc(LibraryErrorLog),", ",Op,");");
                    }
                }
              strcpy(LTmp,enc("[%s %s] Failed to load %s\\n"));
              for(i=1; i<=LoadLibsCnt; i++)
                {
                  strcpy(szLoadLibHandle, join(2,"H_",ucase(RemoveExtension(Loadlibs[i]))));
                  if((inchr(szLoadLibHandle,"-"))||(inchr(szLoadLibHandle,"."))){
                      strcpy(szLoadLibHandle,replace(szLoadLibHandle,"-.","_"));
                      strcpy(szLoadLibHandle,replace(szLoadLibHandle,"-","_"));
                    }
                  fprintf(FP_W,"%s%s%s%s%s%s\n",Scoot,"HMODULE  ",szLoadLibHandle," = LoadLibrary(",enc(Loadlibs[i]),");");
                  if(Use_LoadLibraryError ){
                      fprintf(FP_W,"%s%s%s%s\n",Scoot,"if(",szLoadLibHandle,"==NULL) {");
                      fprintf(FP_W,"%s%s%s%s%s%s\n",Scoot,"  fprintf(FPLoadLibraryErrorLog, ",LTmp,", date(), timef(0,0), ",enc(Loadlibs[i]),");");
                      fprintf(FP_W,"%s%s\n",Scoot,"  }");
                    }
                }
              strcpy(LTmp,enc("[%s %s] Failed to find process %s\\n"));
              for(i=1; i<=DllCnt; i++)
                {
                  fprintf(FP_W,"%s%s\n",Scoot,DllDecl[i]);
                  if(Use_LoadLibraryError ){
                      int iEQ;
                      char szProcAddress[BCXSTRSIZE];
                      iEQ=inchr(DllDecl[i],"=")-1;
                      strcpy(szProcAddress,left(DllDecl[i],iEQ));
                      fprintf(FP_W,"%s%s%s%s\n",Scoot,"if(",szProcAddress,"==NULL) {");
                      fprintf(FP_W,"%s%s%s%s%s%s\n",Scoot,"  fprintf(FPLoadLibraryErrorLog, ",LTmp,",date(),timef(0,0),",enc(szProcAddress),");");
                      fprintf(FP_W,"%s%s\n",Scoot,"  }");
                    }
                }
              if(Use_LoadLibraryError ){
                  fprintf(FP_W,"%s%s\n",Scoot,"fclose(FPLoadLibraryErrorLog);");
                }
              fprintf(FP_W,"%s%s\n",Scoot,"");
              fprintf(FP_W,"%s%s\n",Scoot,"// ****************************************");
              fprintf(FP_W,"%s%s\n",Scoot,"");
            }
          bMainOut=TRUE;
        }
    }
  return bMainOut;
}

char * RemoveExtension (char *f)
{
  char   *BCX_RetStr={0};
  int  i={0};
  int  dotPosition;
  dotPosition=inchr(f,".");
  if(dotPosition ){
      i=InstrRev(f,".",0)-1;
    }
  else
    {
      i=(int)strlen(f);
    }
  BCX_RetStr=left(f,i);
  return BCX_RetStr;
}

int CheckGlobal (char* szVariable,int* varidx)
{
  ULONGLONG  iHasValue;
  int iTokenLoc;
  char szTemp[BCXSTRSIZE];
  int iBrack;
  strcpy(szTemp,szVariable);
  RemoveAll(szTemp,"%$#!@`&*( )",1);
  iBrack=inchr(szTemp,"[");
  if(iBrack ){
      *(--iBrack+szTemp)=0;
    }
  iHasValue=HashNumber(szTemp);
  while(GlobalVarHash[iHasValue]){
      iTokenLoc=GlobalVarHash[iHasValue];
      if(strcmp(szTemp,GlobalVars[iTokenLoc].VarName)==0){
          (*varidx)=iTokenLoc;
          return GlobalVars[iTokenLoc].VarType;
        }
      iHasValue++;
      iHasValue=imod(iHasValue,MaxGlobalVars);
    }
  return vt_UNKNOWN;
}

int CheckLocal (char* szVariable,int* varidx)
{
  char szTemp[BCXSTRSIZE];
  int iBrack;
  int iTokenLoc;
  if(LocalVarCnt ){
      strcpy(szTemp,szVariable);
      RemoveAll(szTemp,"%$#!@`&*( )",1);
      iBrack=inchr(szTemp,"[");
      if(iBrack ){
          *(--iBrack+szTemp)=0;
        }
      for(iTokenLoc=LocalVarCnt; iTokenLoc>=1; iTokenLoc+=-1)
        {
          if(strcmp(szTemp,LocalVars[iTokenLoc].VarName)==0){
              (*varidx)=iTokenLoc;
              return LocalVars[iTokenLoc].VarType;
            }
        }
    }
  return vt_UNKNOWN;
}

int CheckType (char* ParamStr)
{
  char Keyword[BCXSTRSIZE];
  int varid;
  int i;
  strcpy(Keyword,trim(lcase(ParamStr)));
  i=FindWord(Keyword,tTypes,WordsInTable(tTypes));
  if(i!=NOTFOUND ){
      return tTypes[i].iType;
    }
  i=CheckLocal(ParamStr,&(varid));
  if(i==vt_UNKNOWN ){
      i=CheckGlobal(ParamStr,&(varid));
      if(i==vt_UNKNOWN ){
          i=CheckTypeDefs(ParamStr);
          if(i ){
              i=TypeDefs[i].TypeofDef;
            }
        }
    }
  return i;
}

void ExportStringConst ()
{
  FILE*  FP_SAVE;
  FP_SAVE=FP_CST;
  FP_CST=FP_SYSCST;
  strcpy(Src, join(2,"MACRO BCXSTRSIZE=",str(BCXSTRINGS)));
  PassOne=TRUE;
  Inject(Src);
  FP_CST=FP_SAVE;
}

void ExportInternalConst ()
{
  if(Use_FillArray ){
      FILE*  FP_SAVE;
      FP_SAVE=FP_CST;
      FP_CST=FP_SYSCST;
      strcpy(Src,"MACRO vt_INTEGER =  2");
      PassOne=TRUE;
      Inject(Src);
      strcpy(Src,"MACRO vt_SINGLE  =  3");
      PassOne=TRUE;
      Inject(Src);
      strcpy(Src,"MACRO vt_DOUBLE  =  4");
      PassOne=TRUE;
      Inject(Src);
      strcpy(Src,"MACRO vt_LDOUBLE =  5");
      PassOne=TRUE;
      Inject(Src);
      FP_CST=FP_SAVE;
    }
}

int RestrictedWords (char *ParamStr)
{
  if(strcmp(ParamStr,"CmdLine")==0  || strcmp(ParamStr,"CmdShow")==0  || strcmp(ParamStr,"hInst")==0  || strcmp(ParamStr,"hPrev")==0  || strcmp(ParamStr,"hWnd")==0  || strcmp(ParamStr,"lParam")==0  || strcmp(ParamStr,"Msg")==0  || strcmp(ParamStr,"wParam")==0  || strcmp(ParamStr,"vt_INTEGER")==0  || strcmp(ParamStr,"vt_SINGLE")==0  || strcmp(ParamStr,"vt_DOUBLE")==0  || strcmp(ParamStr,"vt_LDOUBLE")==0){
      return 1;
    }
  else
    {
      return 0;
    }
}

int DataType (char *ParamStr)
{
  char Keyword[BCXSTRSIZE];
  int i;
  if(ParamStr[0]==c_DblQt ){
      return vt_STRLIT;
    }
  if(inchr(ParamStr,"$")){
      return vt_STRVAR;
    }
  if(IsDecimalNumber(ParamStr)){
      return vt_NUMBER;
    }
  i=CheckTypeDefs(ParamStr);
  if(i ){
      return TypeDefs[i].TypeofDef;
    }
  strcpy(Keyword,lcase(ParamStr));
  i=FindWord(Keyword,tBcxWords,WordsInTable(tBcxWords));
  if(i!=NOTFOUND ){
      return tBcxWords[i].iType;
    }
  if(inchr(ParamStr,"%")){
      return vt_INTEGER;
    }
  if(inchr(ParamStr,"!")){
      return vt_SINGLE;
    }
  if(inchr(ParamStr,"#")){
      return vt_DOUBLE;
    }
  if(inchr(ParamStr,"^")){
      return vt_DOUBLE;
    }
  if(inchr(ParamStr,"`")){
      return vt_LDOUBLE;
    }
  if(iMatchRgt(ParamStr,"@")){
      return vt_FILEPTR;
    }
  if(inchr(ParamStr,SPC)){
      return vt_UDT;
    }
  if(iMatchLft(ParamStr,"_")){
      return vt_INTEGER;
    }
  if(isalpha(ParamStr[0])){
      return vt_INTEGER;
    }
  if(CAST (UINT,ParamStr[0])>127 ){
      return vt_INTEGER;
    }
  return vt_UNKNOWN;
}

void CloseAll ()
{
  if(PPDLL_HANDLE ){
      FreeLibrary(PPDLL_HANDLE);
      PPDLL_HANDLE=NULL;
      PPProc=NULL;
    }
  _fcloseall();
}

void RemoveAll (char* Haystack,LPCTSTR  Needles,int qtflag)
{
  PCHAR  C=Haystack;
  PCHAR  pmc=NULL;
  while(NOTNULL(Haystack)){
      if(qtflag ){
          if(*Haystack==c_DblQt ){
              *(C++)=*Haystack;
              while(*(++Haystack)!=c_DblQt){
                  *(C++)=*Haystack;
                  if(ISNULL(Haystack)){
                      return;
                    }
                }
              *(C++)=*(Haystack++);
              continue;
            }
        }
      pmc= CAST (PCHAR,Needles);
      while(*pmc){
          if(*(pmc++)==*Haystack ){
              goto SKIP;
            }
        }
      *(C++)=*Haystack;

SKIP:;
      Haystack++;
    }
  *C=0;
}

void Warning_ID (int iWarning,int WarnLvl)
{
  if(iWarning==eExitingMoreThan1Loop ){
      Warning("Exiting more than one loop",WarnLvl);
    }
}

void Warning (char* ParmStr,int WarnLvl)
{
  FILE*  fErr={0};
  if(WarnLvl ){
      strcpy(WarnMsg, join(7,WarnMsg," Line",str(LineNum[FileNdx])," in Module: ",trim(FileNames[FileNdx])," - ",ParmStr));
    }
  else
    {
      strcat(WarnMsg,ParmStr);
    }
  strcpy(WarnMsg, join(3,WarnMsg,CRLF,CRLF));
  if(ErrFile ){
      if((fErr=fopen(FileErr, "a"))==0)
       {
      fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", FileErr); exit(1);
       }
      fprintf(fErr,"%s%s\n","WARNING ",ParmStr);
      if(fErr)
       {
         fclose(fErr);
         fErr=NULL;
       }
    }
}

ULONGLONG HashNumber (char* Str2Hash)
{
  PCHAR  StrgPtr={0};
  UCHAR  c={0};
  ULONGLONG  hash={0};
  hash=5381ULL;
  StrgPtr=Str2Hash;
  while(*StrgPtr){
      c=*StrgPtr;
      hash=((hash<<5)+hash)+c;
      StrgPtr++;
    }
  return  CAST (ULONGLONG,imod(hash,MaxGlobalVars));
}

void AddLibrary (char* LibName)
{
  static int nTimes;
  int nLibNdx={0};
  char TempLibName[BCXSTRSIZE]={0};
  strcpy(TempLibName,lcase(LibName));
  if(!inchr(TempLibName,DQ)&&!inchr(TempLibName,"<")){
      strcpy(TempLibName,enc(TempLibName,60,62));
    }
  if(nTimes==0 ){
      for(int i=0; i<=MaxLib-1; i++)
        {
          *Library[i]=0;
        }
      nTimes++;
      strcpy(Library[0],TempLibName);
      return;
    }
  nLibNdx=0;
  while(NOTNULL(Library[nLibNdx])){
      if(strcmp(Library[nLibNdx],TempLibName)==0){
          return;
        }
      nLibNdx++;
    }
  if(nLibNdx<MaxLib-1 ){
      strcpy(Library[nLibNdx],TempLibName);
    }
  else
    {
      Abort(join(2,"Max libraries exceeded. Currently MaxLib set to",str(MaxLib)));
    }
}

void RemoveLibrary (char* LibName)
{
  if(!instr(RmLibs,LibName,1,1)){
      strcpy(RmLibs, join(3,RmLibs,",",lcase(LibName)));
    }
}

void Emit_Libs ()
{
  static int IWasHere;
  static int nCount;
  char LTmp[BCXSTRSIZE]={0};
  if(IWasHere ){
      return;
    }
  IWasHere++;
  if(*Library[0]==0 ){
      return;
    }
  if(NO_LIBS==FALSE ){
        {
        int  i;
        for(i=0; i<MaxLib && NOTNULL(Library[i]); i++)
          {
            strcpy(LTmp,Library[i]);
            RemoveAll(LTmp,join(2,"<>",DQ));
            if(instr(RmLibs,LTmp)){
                continue;
              }
            if(nCount==0 ){
                nCount++;
                fprintf(FP_HDR,"%s\n","");
                fprintf(FP_HDR,"%s\n","// *************************************************");
                fprintf(FP_HDR,"%s\n","// Instruct Linker to Search Object/Import Libraries");
                fprintf(FP_HDR,"%s\n","// *************************************************");
                fprintf(FP_HDR,"%s\n","");
                fprintf(FP_HDR,"%s\n","#if !defined(__GNUC__) && !defined(__TINYC__)");
                fprintf(FP_HDR,"%s\n","   #if !(defined(__BCPLUSPLUS__) && defined(_WIN64))");
                if(ISFALSE UseCpp ){
                    fprintf(FP_HDR,"%s\n","      #if !defined(__LCC__)");
                  }
              }
            fprintf(FP_HDR,"%s%s%s\n","    #pragma comment(lib,",enc(LTmp),")");
          }
          }
      if(ISFALSE UseCpp ){
          fprintf(FP_HDR,"%s\n","  #else");
          strcat(RmLibs,",<libc.lib>,<kernel32.lib>,<comdlg32.lib>,<user32.lib>,");
          strcat(RmLibs,"<gdi32.lib>,<advapi32.lib>,<comctl32.lib>,<crtdll.lib>,<Msimg32.lib>");
            {
            int  i;
            for(i=0; i<MaxLib && NOTNULL(Library[i]); i++)
              {
                if(instr(RmLibs,Library[i])){
                    continue;
                  }
                if(nCount==0 ){
                    nCount++;
                    fprintf(FP_HDR,"%s\n","  #if !defined(__LCC__)");
                  }
                fprintf(FP_HDR,"%s%s\n","    #pragma lib ",Library[i]);
              }
              }
        }
      if(NOTZERO(nCount)){
          if(ISFALSE UseCpp ){
              fprintf(FP_HDR,"%s\n","     #endif");
            }
          fprintf(FP_HDR,"%s\n","  #endif");
          fprintf(FP_HDR,"%s\n","#endif");
        }
    }
}

void AddGlobal (char* GlobalName,int GlobalType,int GlobalDef,char* GlobalDim,int GlobalPtr,int GlobalFS,int GlobalExtn,int iEmitted,int iConst)
{
  char FirstVar[BCXSTRSIZE];
  char SecondVar[BCXSTRSIZE];
  char Warn[BCXSTRSIZE];
  ULONGLONG  GlobalNameHash;
  struct _VARINFO*  ptGlobal;
  int s;
  if(Use_Project==TRUE ){
      if(GlobalExtn==0 ){
          GlobalExtn=2;
        }
    }
  if(RestrictedWords(GlobalName)&&TestState ){
      strcpy(Warn, join(3,"Restricted Word ",GlobalName," on Line"));
      strcpy(Warn, join(4,Warn,str(LineNum[FileNdx])," in Module: ",trim(FileNames[FileNdx])));
      Warning(Warn);
    }
  GlobalNameHash=HashNumber(GlobalName);
  while(GlobalVarHash[GlobalNameHash]){
      s=GlobalVarHash[GlobalNameHash];
      ptGlobal=&(GlobalVars[s]);
      if(strcmp(GlobalName,ptGlobal->VarName)==0){
          if(InConditional==0||(InConditional>0 && strcmp(InIfDef,ptGlobal->VarCondDef)==0)){
              if(ptGlobal->VarType!=GlobalType || strcmp(GlobalDim,ptGlobal->VarDim)!=0  || ptGlobal->VarDef!=GlobalDef ){
                  *FirstVar=0;
                  strcpy(FirstVar, join(4,FirstVar,"Line",str(LineNum[FileNdx])," in Module: "));
                  strcpy(FirstVar, join(4,FirstVar,trim(FileNames[FileNdx])," : ",GlobalName));
                  strcpy(FirstVar, join(4,FirstVar,GlobalDim," as ",GetVarTypeName(GlobalType)));
                  strcpy(FirstVar, join(3,FirstVar,SPC,TypeDefs[GlobalDef].VarName));
                  *SecondVar=0;
                  strcpy(SecondVar, join(4,SecondVar,"Line",str(ptGlobal->VarLine)," in Module: "));
                  strcpy(SecondVar, join(4,SecondVar,ptGlobal->VarModule," : ",GlobalName));
                  strcpy(SecondVar, join(4,SecondVar,ptGlobal->VarDim," as ",GetVarTypeName(ptGlobal->VarType)));
                  strcpy(SecondVar, join(3,SecondVar,SPC,TypeDefs[ptGlobal->VarDef].VarName));
                  strcpy(Warn, join(4,"Two Variables ",FirstVar," previously defined at ",SecondVar));
                  Warning(Warn);
                }
              return;
            }
        }
      GlobalNameHash=imod(GlobalNameHash+1,MaxGlobalVars);
    }
  GlobalVarCnt++;
  if(GlobalVarCnt==MaxGlobalVars ){
      Abort("Maximum Global Variables reached.");
    }
  ptGlobal=&(GlobalVars[GlobalVarCnt]);
  strcpy(ptGlobal->VarName,GlobalName);
  ptGlobal->VarType=GlobalType;
  ptGlobal->VarDef=GlobalDef;
  strcpy(ptGlobal->VarDim,GlobalDim);
  ptGlobal->VarLine=LineNum[FileNdx];
  ptGlobal->VarPntr=GlobalPtr;
  ptGlobal->VarSF=GlobalFS;
  ptGlobal->VarEmitFlag=iEmitted;
  strcpy(ptGlobal->VarModule,trim(FileNames[FileNdx]));
  ptGlobal->VarExtn=GlobalExtn;
  ptGlobal->VarCondLevel=InConditional;
  ptGlobal->VarConstant=iConst;
  strcpy(ptGlobal->VarCondDef,InIfDef);
  GlobalVarHash[GlobalNameHash]=GlobalVarCnt;
}

void AddLocal (char* LocalName,int LocalType,int LocalDef,char* LocalDim,int LocalPtr,int LocalFS,int iEmitted,int iConst)
{
  int varid=0;
  char FirstVar[BCXSTRSIZE];
  char SecondVar[BCXSTRSIZE];
  char Warn[BCXSTRSIZE];
  int s;
  if(LocalVarCnt&&TestState ){
      if(CheckGlobal(LocalName,&(varid))!=vt_UNKNOWN ){
          if(LocalDef ){
              *FirstVar=0;
              strcpy(FirstVar, join(3,FirstVar,"Line",str(LineNum[FileNdx])));
              strcpy(FirstVar, join(3,FirstVar," in Module: ",trim(FileNames[FileNdx])));
              strcpy(FirstVar, join(5,FirstVar," : ",LocalName,LocalDim," as "));
              strcat(FirstVar,TypeDefs[LocalDef].VarName);
            }
          else
            {
              *FirstVar=0;
              strcpy(FirstVar, join(3,FirstVar,"Line",str(LineNum[FileNdx])));
              strcpy(FirstVar, join(3,FirstVar," in Module: ",trim(FileNames[FileNdx])));
              strcpy(FirstVar, join(5,FirstVar," : ",LocalName,LocalDim," as "));
              strcat(FirstVar,GetVarTypeName(LocalType));
            }
          if(GlobalVars[varid].VarDef ){
              *SecondVar=0;
              strcpy(SecondVar, join(3,SecondVar,"Line",str(GlobalVars[varid].VarLine)));
              strcpy(SecondVar, join(3,SecondVar," in Module: ",GlobalVars[varid].VarModule));
              strcpy(SecondVar, join(4,SecondVar," : ",LocalName,GlobalVars[varid].VarDim));
              strcpy(SecondVar, join(3,SecondVar," as ",TypeDefs[GlobalVars[varid].VarDef].VarName));
            }
          else
            {
              *SecondVar=0;
              strcpy(SecondVar, join(3,SecondVar,"Line",str(GlobalVars[varid].VarLine)));
              strcpy(SecondVar, join(3,SecondVar," in Module: ",GlobalVars[varid].VarModule));
              strcpy(SecondVar, join(4,SecondVar," : ",LocalName,GlobalVars[varid].VarDim));
              strcpy(SecondVar, join(3,SecondVar," as ",GetVarTypeName(GlobalVars[varid].VarType)));
            }
          strcpy(Warn, join(5,"Local Variable ",FirstVar,CRLF,"Has Same Name as Global ",SecondVar));
          Warning(Warn);
        }
      for(s=1; s<=LocalVarCnt; s++)
        {
          if(strcmp(LocalName,LocalVars[s].VarName)==0){
              if(LocalVars[s].VarType!=LocalType || strcmp(LocalDim,LocalVars[s].VarDim)!=0  || LocalVars[s].VarDef!=LocalDef ){
                  *FirstVar=0;
                  strcpy(FirstVar, join(3,FirstVar,"Line",str(LineNum[FileNdx])));
                  strcpy(FirstVar, join(3,FirstVar," in Module: ",trim(FileNames[FileNdx])));
                  strcpy(FirstVar, join(5,FirstVar," : ",LocalName,LocalDim," as "));
                  strcpy(FirstVar, join(3,FirstVar,GetVarTypeName(LocalType),SPC));
                  strcat(FirstVar,TypeDefs[LocalDef].VarName);
                  *SecondVar=0;
                  strcpy(SecondVar, join(4,SecondVar,"Line",str(LocalVars[s].VarLine)," in Module: "));
                  strcpy(SecondVar, join(4,SecondVar,LocalVars[s].VarModule," : ",LocalName));
                  strcpy(SecondVar, join(3,SecondVar,LocalVars[s].VarDim," as "));
                  strcpy(SecondVar, join(3,SecondVar,GetVarTypeName(LocalVars[s].VarType),SPC));
                  strcat(SecondVar,TypeDefs[LocalVars[s].VarDef].VarName);
                  strcpy(Warn, join(4,"Two Variables ",FirstVar," previously defined at ",SecondVar));
                  Warning(Warn);
                }
              return;
            }
        }
    }
  LocalVarCnt++;
  if(LocalVarCnt==MaxLocalVars ){
      strcpy(Warn,"Maximum Local Variables reached.");
      Abort(Warn);
    }
  strcpy(LocalVars[LocalVarCnt].VarName,LocalName);
  LocalVars[LocalVarCnt].VarType=LocalType;
  LocalVars[LocalVarCnt].VarDef=LocalDef;
  strcpy(LocalVars[LocalVarCnt].VarDim,LocalDim);
  LocalVars[LocalVarCnt].VarLine=LineNum[FileNdx];
  LocalVars[LocalVarCnt].VarPntr=LocalPtr;
  LocalVars[LocalVarCnt].VarSF=LocalFS;
  LocalVars[LocalVarCnt].VarEmitFlag=iEmitted;
  LocalVars[LocalVarCnt].VarConstant=iConst;
  strcpy(LocalVars[LocalVarCnt].VarModule,trim(FileNames[FileNdx]));
}

BOOL IsDecimalNumber (char *szNumber)
{
  int  i={0};
  int  HasDigit={0};
  int  HasE={0};
  int  HasMinus={0};
  int  HasPlus={0};
  int  HasDecimal={0};
  BOOLEAN  digitAfterE={0};
  BOOLEAN  prevWasE={0};
  if(ISNULL(szNumber)){
      return FALSE;
    }
  if(instr(szNumber,SPC)){
      return FALSE;
    }
  if(szNumber[0]==43 ){
      HasPlus++;
      i++;
    }
  else if(szNumber[0]==45 ){
      HasMinus++;
      i++;
    }
  while(szNumber[i]){
      if(szNumber[i]>=48&&szNumber[i]<=57 ){
          HasDigit++;
          if(HasE>0 ){
              digitAfterE=TRUE;
            }
          prevWasE=FALSE;
        }
      else if(szNumber[i]==46 ){
          HasDecimal++;
          if(HasDecimal>1||HasE>0 ){
              return FALSE;
            }
          prevWasE=FALSE;
        }
      else if(szNumber[i]==69||szNumber[i]==101 ){
          HasE++;
          if(HasE>1||HasDigit==0 ){
              return FALSE;
            }
          prevWasE=TRUE;
        }
      else if(szNumber[i]==43 ){
          HasPlus++;
          if(!prevWasE&&i>0 ){
              return FALSE;
            }
          if(HasPlus>2 ){
              return FALSE;
            }
          prevWasE=FALSE;
        }
      else if(szNumber[i]==45 ){
          HasMinus++;
          if(!prevWasE&&i>0 ){
              return FALSE;
            }
          if(HasMinus>2 ){
              return FALSE;
            }
          prevWasE=FALSE;
        }
      else if((szNumber[i]==76||szNumber[i]==108)&&szNumber[i+1]==0 ){
          prevWasE=FALSE;
        }
      else
        {
          return FALSE;
        }
      i++;
    }
  if(i==0 ){
      return FALSE;
    }
  i--;
  if(szNumber[i]==43||szNumber[i]==45 ){
      return FALSE;
    }
  if(HasDigit==0 ){
      return FALSE;
    }
  if(HasE>0&&!digitAfterE ){
      return FALSE;
    }
  return TRUE;
}

BOOL IsHexNumber (char* szArg)
{
  if(ISNULL(szArg)){
      return 0;
    }
  if(instr(szArg,SPC)){
      return 0;
    }
  if((int)strlen(szArg)<3 ){
      return FALSE;
    }
  char  inputStr[BCXSTRSIZE]={0};
  strcpy(inputStr,lcase(szArg));
  char prefix[BCXSTRSIZE]={0};
  strcpy(prefix,left(inputStr,2));
  if(strcmp(prefix,"0x")!=0  && strcmp(prefix,"&h")!=0){
      return FALSE;
    }
  char hexDigits[BCXSTRSIZE]={0};
  strcpy(hexDigits,mid(inputStr,3));
  for(int i=1; i<=(int)strlen(hexDigits); i++)
    {
      char currentChar[BCXSTRSIZE]={0};
      strcpy(currentChar,mid(hexDigits,i,1));
      if(!((strcmp(currentChar,"0")>=0  && strcmp(currentChar,"9")<=0)  || (strcmp(currentChar,"a")>=0  && strcmp(currentChar,"f")<=0))){
          return FALSE;
        }
    }
  return TRUE;
}

void StripTabs ()
{
  PCHAR  pszSrc;
  int iQuoteFlag;
  pszSrc=Src;
  iQuoteFlag=0;
  while(*pszSrc){
      if(*pszSrc==c_DblQt ){
          iQuoteFlag=iQuoteFlag^1;
        }
      if(*pszSrc==9&&!iQuoteFlag ){
          *pszSrc=32;
        }
      pszSrc++;
    }
}

void PushFileIO ()
{
  FPtr[++FPtrNdx]=SourceFile;
}

void PopFileIO ()
{
  if(FPtrNdx>0 ){
      if(SourceFile)
       {
         fclose(SourceFile);
         SourceFile=NULL;
       }
      LinesRead+=(LineNum[FileNdx--]);
      SourceFile=FPtr[FPtrNdx--];
    }
}

void VerifyMatchedPairs ()
{
  int CountR;
  CountR=0;
  int CountS;
  CountS=0;
  BOOL  DoCount;
  DoCount=TRUE;
  PCHAR  pszSrc;
  pszSrc=Src;
  while(*pszSrc){
      if(*pszSrc==c_DblQt ){
          DoCount=!DoCount;
        }
      if(DoCount ){
          if(*pszSrc==c_LPar ){
              CountR++;
              goto L1077;
            }
          if(*pszSrc==c_RPar ){
              CountR--;
              goto L1077;
            }
          if(*pszSrc==c_LtBkt ){
              CountS++;
              goto L1077;
            }
          if(*pszSrc==c_RtBkt ){
              CountS--;
            }
L1077:;
        }
      pszSrc++;
    }
  if(!DoCount ){
      Abort("Unmatched Quotes");
    }
  if(CountS ){
      Abort("Unmatched []");
    }
  if(CountR ){
      Abort("Unmatched ()");
    }
}

void ClearIfThenStacks ()
{
  long  i={0};
  while(*SrcStk[i]&&i<cMaxSingleLineIFLines){
      *SrcStk[i++]=0;
    }
  SrcCnt=0;
}

void AddExpressionToStack (char* szAssembledExpression)
{
  if(SrcCnt==cMaxSingleLineIFLines-1 ){
      Abort("Single line conversion to multi-line stack exceeds limit.");
    }
  strcpy(SrcStk[++SrcCnt],szAssembledExpression);
}

void Add2SplitLines (char* szSplitLine)
{
  if(SplitCnt==cMaxSplitLines-1 ){
      Abort("Maximum line splitting exceeded.");
    }
  strcpy(SplitStk[++SplitCnt],szSplitLine);
}

void PostProcess ()
{
  if(ReDirect==TRUE ){
      char LTmp1[BCXSTRSIZE];
      if((FP1=fopen(FileOut, "rb"))==0)
       {
      fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", FileOut); exit(1);
       }
      while(!EoF(FP1)){
          LTmp1[0]=0;
          fgets(LTmp1, 2048 , FP1);
            if(feof(FP1) || (LTmp1[strlen(LTmp1)-1]==10))
              {
               LTmp1[strcspn(LTmp1,"\r\n")] = 0;
              }
             else
              {
                printf("%s%d while reading file: %s\n","Error! - LINE INPUT truncation detected at PROGRAM line: ",__LINE__-7, NamePathFromFP(FP1));
                printf("%s\n","The actual truncated line of text:");
                printf("%s",LTmp1);
                exit(1);
              }
          printf("%s\n",LTmp1);
        }
      CloseAll();
    }
  strcpy(FileOutCopy,FileOut);
  strcpy(FileOutCopy,extract(FileOutCopy,"."));
  for(int A=1; A<=EntryCnt; A++)
    {
      strcpy(Cmd,RemoveStr(Entry[A],DQ));
      strcpy(Cmd,replace(Cmd,BKSLASH4,BKSLASH2));
      strcpy(Cmd,iReplace(Cmd,"$FILE$",FileOutCopy));
      strcpy(Cmd,iReplace(Cmd,"$PELLES$\\",PellesPath()));
      strcpy(Cmd,iReplace(Cmd,"$PELLES$",PellesPath()));
      strcpy(Cmd,iReplace(Cmd,"$LCC$\\",LccPath()));
      strcpy(Cmd,iReplace(Cmd,"$LCC$",LccPath()));
      strcpy(Cmd,iReplace(Cmd,"$BCX$\\",BcxPath()));
      strcpy(Cmd,iReplace(Cmd,"$BCX$",BcxPath()));
      printf("%s%s\n","Shelling Out To:",Cmd);
      system(Cmd);
    }
  if(NOTNULL(Compiler)){
      strcpy(Compiler,trim(RemoveStr(Compiler,DQ)));
      if(inchr(Compiler,SPC)){
          strcpy(Compiler, join(3,enc(extract(Compiler,SPC)),SPC,remain(Compiler,SPC)));
        }
      else
        {
          strcpy(Compiler,enc(Compiler));
        }
      strcpy(Compiler,replace(Compiler,BKSLASH4,BKSLASH2));
      strcpy(Compiler,iReplace(Compiler,"$FILE$",FileOutCopy));
      strcpy(Compiler,iReplace(Compiler,"$PELLES$\\",PellesPath()));
      strcpy(Compiler,iReplace(Compiler,"$PELLES$",PellesPath()));
      strcpy(Compiler,iReplace(Compiler,"$LCC$\\",LccPath()));
      strcpy(Compiler,iReplace(Compiler,"$LCC$",LccPath()));
      strcpy(Compiler,replace(Compiler,DDQ,DQ));
      printf("%s%s\n","Shelling Out To:",Compiler);
      system(Compiler);
    }
  if(NOTNULL(ResCompiler)){
      strcpy(ResCompiler,enc(ResCompiler));
      strcpy(ResCompiler, join(3,ResCompiler,SPC,Res_File));
      strcpy(ResCompiler,iReplace(ResCompiler,"$PELLES$\\",PellesPath()));
      strcpy(ResCompiler,iReplace(ResCompiler,"$PELLES$",PellesPath()));
      strcpy(ResCompiler,iReplace(ResCompiler,"$LCC$\\",LccPath()));
      strcpy(ResCompiler,iReplace(ResCompiler,"$LCC$",LccPath()));
      strcpy(ResCompiler,iReplace(ResCompiler,"$FILE$",FileOutCopy));
      strcpy(ResCompiler,replace(ResCompiler,BKSLASH4,BKSLASH2));
      strcpy(ResCompiler,replace(ResCompiler,DDQ,DQ));
      printf("%s%s\n","Shelling Out To:",ResCompiler);
      system(ResCompiler);
    }
  if(NOTNULL(Linker)){
      strcpy(Linker,trim(RemoveStr(Linker,DQ)));
      if(inchr(Linker,SPC)){
          strcpy(Linker, join(5,DQ,extract(Linker,SPC),DQ,SPC,remain(Linker,SPC)));
        }
      else
        {
          strcpy(Linker,enc(Linker));
        }
      strcpy(Linker,iReplace(Linker,"$PELLES$\\",PellesPath()));
      strcpy(Linker,iReplace(Linker,"$PELLES$",PellesPath()));
      strcpy(Linker,iReplace(Linker,"$LCC$\\",LccPath()));
      strcpy(Linker,iReplace(Linker,"$LCC$",LccPath()));
      strcpy(Linker,iReplace(Linker,"$FILE$",FileOutCopy));
      strcpy(Linker,replace(Linker,BKSLASH4,BKSLASH2));
      strcpy(Linker,replace(Linker,DDQ,DQ));
      if(Use_Resource ){
          strcpy(ResFileOut, join(2,extract(Res_File,"."),".res"));
          strcpy(Linker, join(3,Linker,SPC,ResFileOut));
        }
      printf("%s%s\n","Shelling Out To:",Linker);
      system(Linker);
    }
  char szSave[BCXSTRSIZE]={0};
  strcpy(szSave,FileOut);
  strcpy(FileOut,extract(FileOut,"."));
  for(int A=1; A<=XitCount; A++)
    {
      strcpy(Cmd,RemoveStr(Xit[A],DQ));
      strcpy(Cmd,iReplace(Cmd,"$FILE$",FileOutCopy));
      strcpy(Cmd,iReplace(Cmd,"$PELLES$\\",PellesPath()));
      strcpy(Cmd,iReplace(Cmd,"$PELLES$",PellesPath()));
      strcpy(Cmd,iReplace(Cmd,"$LCC$\\",LccPath()));
      strcpy(Cmd,iReplace(Cmd,"$LCC$",LccPath()));
      strcpy(Cmd,iReplace(Cmd,"$BCX$\\",BcxPath()));
      strcpy(Cmd,iReplace(Cmd,"$BCX$",BcxPath()));
      strcpy(Cmd,replace(Cmd,BKSLASH4,BKSLASH2));
      strcpy(Cmd,replace(Cmd,DDQ,DQ));
      printf("%s%s\n","Shelling Out To:",Cmd);
      system(Cmd);
    }
  strcpy(FileOut,szSave);
}

void Inject (char* szLine)
{
  XParse(szLine);
  FixUps();
  Emit_Main();
}

int Convert2SimpleFunction (int Tmp)
{
  int iNextToken=(++Tmp+1);
  int iRetVal=0;
  if(strcmp(Stk[Tmp],"(")==0  && strcmp(Stk[iNextToken],")")==0){
      *Stk[Tmp]=0;
      *Stk[iNextToken]=0;
      iRetVal++;
    }
  return iRetVal;
}

void XParse (char* Statement)
{
  int i={0};
  int j={0};
  int InIF={0};
  int InXFOR={0};
  int Gapflag={0};
  char LTmp[BCXSTRSIZE]={0};
  if(Statement[0]==0 ){
      Ndx=0;
      return;
    }
  int HexFlag=FALSE;
  FastLexer(Statement,""," =()[]{}',+-*/<>?;.|:^");
  for(int ii=1; ii<=Ndx; ii++)
    {
      if(IsHexNumber(Stk[ii])){
          HexFlag=TRUE;
          strcpy(Stk[ii],iReplace(Stk[ii],"&h","0x"));
        }
    }
  if(HexFlag==TRUE ){
      *Statement=0;
      for(int ii=1; ii<=Ndx; ii++)
        {
          strcat(Statement,Stk[ii]);
        }
    }
  FastLexer(Statement,SPC,"=&()[]{}',+-*/<>?;.|:^");
  while(++i<20){
      *Stk[i+Ndx]=0;
    }
  for(int ii=1; ii<=Ndx; ii++)
    {
      if(*Stk[ii]==38&&*Stk[ii+1]==38 ){
          strcpy(Stk[ii],"and");
          LShiftStk(ii+1);
        }
    }
  if(iMatchWrd(Stk[1],"end")){
      strcpy(LTmp,enc(lcase(Stk[2]),(UCHAR)*(SPC)));
      if(iMatchNQ(" events , mdievents , mdichildevents ",LTmp)){
          strcpy(Stk[1], join(2,Stk[1],lcase(Stk[2])));
          if(iMatchWrd(Stk[3],"main")){
              Use_MainEvent=TRUE;
            }
          Ndx=1;
          strcpy(Src,Stk[1]);
          return;
        }
      if(strcmp(Stk[2],"=")!=0  && Ndx==2 ){
          if(iMatchWrd(Stk[2],"dialog")){
              strcpy(Stk[2],"function");
            }
          strcpy(Stk[1], join(2,"end",lcase(Stk[2])));
          Ndx=1;
          strcpy(Src,Stk[1]);
          return;
        }
    }
  if(iMatchWrd(Stk[1],"end")&&iMatchWrd(Stk[2],"prepend")){
      strcpy(Stk[1],"endprepend");
      strcpy(Src,Stk[1]);
      Ndx=1;
      return;
    }
  if(iMatchWrd(Stk[1],"end")&&iMatchWrd(Stk[2],"with")){
      strcpy(Stk[1],"endwith");
      strcpy(Src,Stk[1]);
      Ndx=1;
      return;
    }
  int iP=1;
  if(iMatchWrd(Stk[iP],"public")||iMatchWrd(Stk[iP],"private")){
      iP++;
    }
  if((iMatchWrd(Stk[iP],"function")||iMatchWrd(Stk[iP],"catch")||iMatchWrd(Stk[iP],"sub"))&&inchr(Statement,"*")){
        {
        int  ii;
        int  jjj;
        for(ii=2,jjj=1; ii<Ndx-1 && jjj; ii++)
          {
            jjj=GetAsPosF(ii,Ndx-2);
            if(jjj ){
                ii=jjj;
                if(iMatchWrd(Stk[ii+1],"const")){
                    ii++;
                  }
                while(strcmp(Stk[ii+2],"*")==0){
                    strcpy(Stk[ii+2],"PTR");
                    ii++;
                  }
              }
          }
          }
      BuildDelimStr(1,Ndx,Src);
      FastLexer(Src,SPC,"=&()[]{}',+-*/<>?;.|:^");
      strcpy(Statement,Src);
    }
  Gapflag=FALSE;
  for(i=1; i<=Ndx; i++)
    {
      if(IsDecimalNumber(Stk[i])&&BYTE_AT(Stk[i][1])){
          strcpy(Keyword1,right(Stk[i],1));
          if(*Keyword1==69||*Keyword1==101 ){
              strcpy(Stk[i], join(2,Stk[i],Stk[i+1]));
              strcpy(Stk[i], join(2,Stk[i],Stk[i+2]));
              *Stk[i+1]=0;
              *Stk[i+2]=0;
              if(strcmp(Stk[i-1],"-")==0){
                  strcpy(Stk[i-1], join(2,Stk[i-1],Stk[i]));
                  *Stk[i]=0;
                }
              Gapflag=TRUE;
            }
        }
    }
  if(Gapflag==TRUE ){
      RemEmptyTokens();
    }
  for(i=1; i<=Ndx; i++)
    {
      strcpy(Keyword1,lcase(Stk[i]));
      if(Keyword1[1]){
          if(strcmp(Keyword1,"not")==0){
              strcpy(Stk[i],"!");
              goto L1090;
            }
          if(strcmp(Keyword1,"is")==0){
              strcpy(Stk[i],"=");
              goto L1090;
            }
          if(strcmp(Keyword1,"xor")==0){
              strcpy(Stk[i],"xor");
              goto L1090;
            }
          if(strcmp(Keyword1,"if")==0  || strcmp(Keyword1,"iif")==0  || strcmp(Keyword1,"iif$")==0  || strcmp(Keyword1,"case")==0  || strcmp(Keyword1,"elseif")==0  || strcmp(Keyword1,"while")==0){
              InIF=1;
              if(strcmp(Keyword1,"case")==0  && iMatchWrd(Stk[i+1],"else")){
                  strcpy(Stk[i],"caseelse");
                  *Stk[i+1]=0;
                  Gapflag=TRUE;
                }
              else
                {
                  strcpy(Stk[i],Keyword1);
                }
              goto L1090;
            }
          if(strcmp(Keyword1,"$if")==0  || strcmp(Keyword1,"$ifdef")==0){
              InIF=1;
              goto L1090;
            }
          if(strcmp(Keyword1,"$endif")==0){
              InIF=0;
              goto L1090;
            }
          if(strcmp(Keyword1,"xfor")==0){
              InXFOR=1;
              goto L1090;
            }
          if(strcmp(Keyword1,"until")==0){
              InIF=InXFOR;
              InXFOR=0;
              goto L1090;
            }
          if(strcmp(Keyword1,"by")==0){
              InIF=0;
              goto L1090;
            }
          if(strcmp(Keyword1,"then")==0){
              InIF=0;
              goto L1090;
            }
          if(strcmp(Keyword1,"byval")==0  || strcmp(Keyword1,"let")==0){
              *Stk[i]=0;
              Gapflag=TRUE;
              goto L1090;
            }
          if(strcmp(Keyword1,"shl")==0){
              strcpy(Stk[i],"<<");
              goto L1090;
            }
          if(strcmp(Keyword1,"shr")==0){
              strcpy(Stk[i],">>");
              goto L1090;
            }
          if(strcmp(Keyword1,"byref")==0){
              if(!iMatchWrd(Stk[1],"declare")&&!iMatchWrd(Stk[1],"c_declare")){
                  if(ByrefCnt==cMaxByref-1 ){
                      Abort("Maxium number of BYREFs reached.");
                    }
                  strcpy(ByrefVars[++ByrefCnt],Stk[i+1]);
                }
              int iDontHaveAs=TRUE;
              for(j=i; j<=Ndx; j++)
                {
                  if(iMatchWrd(Stk[j],"as")){
                      iDontHaveAs=FALSE;
                    }
                  if(strcmp(Stk[j+1],",")==0  || strcmp(Stk[j+1],")")==0){
                      strcpy(Stk[j],"PTR");
                      if(iDontHaveAs ){
                          InsertTokens(j-1,2,"as",VarTypeLookup[inchr(VARTYPES,right(ByrefVars[ByrefCnt],1))]);
                        }
                      goto L1091;
                    }
                  strcpy(Stk[j],Stk[j+1]);
                }
L1091:;
              goto L1090;
            }
          if(strcmp(Keyword1,"and")==0){
              if(InIF ){
                  strcpy(Stk[i],"&&");
                }
              else
                {
                  strcpy(Stk[i],"&");
                }
              goto L1090;
            }
          if(strcmp(Keyword1,"or")==0){
              if(InIF ){
                  strcpy(Stk[i],"||");
                }
              else
                {
                  strcpy(Stk[i],"|");
                }
              goto L1090;
            }
          if(strcmp(Keyword1,"procedure")==0){
              strcpy(Stk[i],"sub");
            }
          else
            {
              if(PassOne ){
                  if(strcmp(Keyword1,enc(chr(92)))==0){
                      if(*Stk[i+1]!=c_DblQt ){
                          strcpy(Stk[i],"chr$");
                          InsertTokens(i,3,"(","92",")");
                          i+=(3);
                        }
                      else
                        {
                          strcpy(Stk[i], join(2,Stk[i],Stk[i+1]));
                          *Stk[i+1]=0;
                          Gapflag=TRUE;
                        }
                    }
                  else
                    {
                      if(TranslateSlash ){
                          strcpy(Stk[i],replace(Stk[i],BKSLASH1,BKSLASH2));
                        }
                    }
                }
            }
L1090:;
        }
      else
        {
          if((UCHAR)*(Keyword1)==38 ){
              if(inchr("+&,(=",Stk[i-1])&&*Stk[i+1]!=46 ){
                  strcpy(Stk[i+1], join(2," &",Stk[i+1]));
                  *Stk[i]=0;
                  Gapflag=TRUE;
                }
              goto L1092;
            }
          if((UCHAR)*(Keyword1)==63 ){
              if(bcx_stricmp(Stk[1],"IF")==0){
                  goto L1092;
                }
              if(Use_GUINoMain||Use_MDIGUINoMain||Use_Wingui ){
                  strcpy(Stk[i],"msgbox");
                  if(strcmp(Stk[i+1],"")==0){
                      strcpy(Stk[i+1],enc(""));
                      Ndx++;
                    }
                }
              else
                {
                  if(i==1||(i>1 && strcmp(Stk[i-1],":")==0)){
                      strcpy(Stk[i],"print");
                    }
                }
              goto L1092;
            }
          if((UCHAR)*(Keyword1)==45 ){
              if((UCHAR)*(Stk[i+1])==62 ){
                  strcpy(Stk[i], join(2,"->",Stk[i+2]));
                  *Stk[++i]=0;
                  *Stk[++i]=0;
                  Gapflag=TRUE;
                }
              goto L1092;
            }
          if((UCHAR)*(Keyword1)==46 ){
              if((UCHAR)*(Stk[i+1])==46&&(UCHAR)*(Stk[i+2])==46 ){
                  strcpy(Stk[i],"...");
                  *Stk[i+1]=0;
                  *Stk[i+2]=0;
                  Gapflag=TRUE;
                }
              if(IsDecimalNumber(Stk[i-1])){
                  strcpy(Stk[i], join(2,Stk[i-1],"."));
                  *Stk[i-1]=0;
                  Gapflag=TRUE;
                }
              if(!inchr(",)=<>*/+-^",Stk[i+1])){
                  strcpy(Stk[i], join(2,Stk[i],Stk[i+1]));
                  *Stk[++i]=0;
                  Gapflag=TRUE;
                }
            }
L1092:;
        }
    }
  if(Gapflag==TRUE ){
      RemEmptyTokens();
    }
  if(PassOne==TRUE ){
   char lszTmp[BCXSTRSIZE];  strcpy(lszTmp,"");
      if(InFunction ){
          for(i=1; i<=Ndx; i++)
            {
              for(j=1; j<=ByrefCnt; j++)
                {
                  if(iMatchLft(Stk[i]," &")){
                      strcpy(lszTmp,Stk[i]+2);
                    }
                  else
                    {
                      strcpy(lszTmp,Stk[i]);
                    }
                  if(strcmp(Clean(lszTmp),Clean(ByrefVars[j]))==0){
                      if(i>2 ){
                          if(inchr("+-^%*/|&<=>,",Stk[i-2]) && strcmp(Stk[i-1],"*")==0){
                              *Stk[i-1]=0;
                              Gapflag=TRUE;
                            }
                          if(iMatchLft(Stk[i]," &")){
                              strcpy(Stk[i],Stk[i]+2);
                              goto L1094;
                            }
                        }
                      else if(i==2 ){
                          if(strcmp(Stk[i-1],"*")==0){
                              *Stk[i-1]=0;
                              Gapflag=1;
                            }
                        }
                      strcpy(Stk[i], join(2,"*",Stk[i]));
                      if(strcmp(Stk[i-1],"(")!=0  || strcmp(Stk[i+1],")")!=0){
                          strcpy(Stk[i],enc(Stk[i],40,41));
                        }
                      goto L1094;
                    }
                }
L1094:;
            }
        }
      if(Gapflag==TRUE ){
          RemEmptyTokens();
        }
    }
  if(iMatchWrd(Stk[1],"dim")){
      if(iMatchWrd(Stk[Ndx-1],"static")){
          strcpy(Stk[1],"static");
          strcpy(Stk[Ndx-1],Stk[Ndx]);
          Ndx--;
        }
    }
  strcpy(Keyword1,lcase(Stk[1]));
  if(InTypeDef&&!InClass ){
   char lsz[BCXSTRSIZE];  strcpy(lsz,"");
      strcpy(lsz,enc(Keyword1,(UCHAR)*(SPC)));
      if(iMatchNQ(" end dim declare type union ",lsz)==0 ){
          int iCnt=0;
          int iFnd=0;
          if(MacroCount ){
              for(iCnt=0; iCnt<MacroCount; iCnt++)
                {
                  if(strcmp(Stk[1],ConstMacro[iCnt])==0){
                      iFnd=TRUE;
                    }
                }
            }
          if(iFnd==FALSE ){
              InsertTokens(0,1,"dim");
            }
        }
    }
  if(!InTypeDef&&!InCppTypeDef ){
      int Res={0};
      char lsz[BCXSTRSIZE]={0};
      char Storage[BCXSTRSIZE]={0};
      strcpy(Storage," dim local global raw static shared dynamic auto register extern ");
      strcpy(lsz,enc(Keyword1,(UCHAR)*(SPC)));
      if(iMatchNQ(Storage,lsz)){
          Res=1;
        }
      strcpy(lsz,enc(lcase(Stk[2]),(UCHAR)*(SPC)));
      if(iMatchNQ(Storage,lsz)){
          Res=2;
        }
      if(Res>0 ){
          i=Ndx;
          while(i>1 && strcmp(Stk[i],")")!=0){
              if(iMatchWrd(Stk[i],"as")){
                  if(iMatchWrd(Stk[i+1],"function")){
                      if(i+1==Ndx ){
                          *Stk[i]=0;
                        }
                      *Stk[i+1]=0;
                      InsertTokens(Res,1,"function");
                    }
                  else if(iMatchWrd(Stk[i+1],"sub")){
                      if(i+1==Ndx ){
                          *Stk[i]=0;
                        }
                      *Stk[i+1]=0;
                      InsertTokens(Res,1,"sub");
                    }
                  RemEmptyTokens();
                  goto L1096;
                }
              i--;
            }
L1096:;
        }
    }
  if(InTypeDef||iMatchWrd(Stk[1],"declare")||iMatchWrd(Stk[1],"c_declare")){
      if(iMatchWrd(Stk[2],"sub")||iMatchWrd(Stk[2],"function")){
          for(int mm=2; mm<=Ndx; mm++)
            {
              if(iMatchLft(Stk[mm],"as")&&iMatchWrd(Stk[mm+1],"string")){
                  if(*Stk[mm+2]!=42 ){
                      strcpy(Stk[mm+1],"char *");
                    }
                }
            }
        }
    }
}

void FuncSubTemplate (int Tmp)
{
  int  iConc=++Tmp;
  if(strcmp(Stk[++Tmp],"<")!=0){
      return;
    }
    {
    int  i;
    int  NotFnd;
    for(i=Tmp,NotFnd=TRUE; NotFnd==TRUE && i<=Ndx; i++)
      {
        if(strcmp(Stk[i],"(")==0){
            NotFnd=FALSE;
          }
        else
          {
            if(strcmp(Stk[i],",")==0){
                strcpy(Stk[i],chr(18));
              }
            strcpy(Stk[iConc], join(2,Stk[iConc],Stk[i]));
            *Stk[i]=0;
          }
      }
      }
  RemEmptyTokens();
}

void TokenSubstitutions (int iSubLoc)
{
  int  A;
  int  a;
  int  i;
  int  j;
  int  Tmp;
  char Keyword[BCXSTRSIZE];
  int CompToken;
  int NoTrans;
  struct _TOKSUBFUNC*  tpBCX;
  i=GetAsPosF(1,Ndx);
  if(i ){
      if(iMatchWrd(Stk[i+1],"string")){
          if(strcmp(Stk[i+2],"*")==0){
              strcpy(Stk[i],"[");
              strcpy(Stk[i+1],Stk[i+3]);
              strcpy(Stk[i+2],"]");
              strcpy(Stk[i+3],"as");
              Ndx++;
              strcpy(Stk[Ndx],"char");
            }
        }
    }
  if(InFunction==FALSE ){
      for(i=1; i<=Ndx; i++)
        {
          if(iMatchWrd(Stk[i],"global")){
              strcpy(Stk[i],"dim");
            }
        }
    }
  A=FALSE;
  if(iMatchWrd(Stk[1],"pptype")==0 ){
      for(Tmp=1; Tmp<=Ndx; Tmp++)
        {
          if(*Stk[Tmp]==48&&!iMatchWrd(mid(Stk[Tmp],2,1),"b")&&!iMatchWrd(mid(Stk[Tmp],2,1),"x")&&!iMatchWrd(mid(Stk[Tmp],2,1),".")&&!iMatchWrd(mid(Stk[Tmp],2,1),"l")){
              strcpy(Stk[Tmp],ltrim(Stk[Tmp],48));
              if(ISNULL(Stk[Tmp])){
                  strcpy(Stk[Tmp],"0");
                }
            }
          if(iMatchWrd(Stk[Tmp],"xor")){
              strcpy(Stk[Tmp],"^");
            }
          else
            {
              if(strcmp(Stk[Tmp],"=")==0){
                  if(*Stk[Tmp+1]==62 ){
                      strcpy(Stk[Tmp],">");
                      strcpy(Stk[Tmp+1],"=");
                    }
                  if(*Stk[Tmp+1]==60 ){
                      strcpy(Stk[Tmp],"<");
                      strcpy(Stk[Tmp+1],"=");
                    }
                  goto L1101;
                }
              if(strcmp(Stk[Tmp],"<")==0){
                  if(*Stk[Tmp+1]==62 ){
                      strcpy(Stk[Tmp],"!=");
                      *Stk[Tmp+1]=0;
                      A=TRUE;
                    }
                  goto L1101;
                }
              if(strcmp(Stk[Tmp],">")==0){
                  if(*Stk[Tmp+1]==60 ){
                      strcpy(Stk[Tmp],"!=");
                      *Stk[Tmp+1]=0;
                      A=TRUE;
                    }
                  goto L1101;
                }
              if(strcmp(Stk[Tmp],"!")==0){
                  if(*Stk[Tmp+1]==61 ){
                      strcpy(Stk[Tmp],"!=");
                      *Stk[Tmp+1]=0;
                      A=TRUE;
                    }
                }
L1101:;
            }
        }
    }
  if(A==TRUE ){
      RemEmptyTokens();
    }
  CompToken=0;
  for(Tmp=1; Tmp<=Ndx; Tmp++)
    {
      A=CheckLocal(Stk[Tmp],&(i));
      if(A==vt_UNKNOWN ){
          A=CheckGlobal(Stk[Tmp],&(i));
        }
      if(A==vt_STRUCT||A==vt_UDT||A==vt_UNION ){
          CompToken=1;
        }
      if(iMatchWrd(Stk[Tmp],"int") && strcmp(Stk[Tmp+1],"(")==0){
          strcpy(Stk[Tmp],"int");
        }
      if(iMatchWrd(Stk[Tmp],"int") && strcmp(Stk[Tmp+1],"(")==0  && strcmp(Stk[Tmp+2],")")!=0){
          strcpy(Stk[Tmp],"floor");
        }
      else if(iMatchWrd(Stk[Tmp],"integer")){
          strcpy(Stk[Tmp],"int");
        }
      else
        {
          if(iMatchWrd(Stk[Tmp],"fint") && strcmp(Stk[Tmp+1],")")==0){
              strcpy(Stk[Tmp],"int");
            }
        }
    }
  NoTrans=0;
  for(Tmp=1; Tmp<=Ndx; Tmp++)
    {
      if(NoTrans==1 ){
          goto L1103;
        }
      strcpy(Keyword,lcase(Stk[Tmp]));
      tpBCX=GetWordInfo(Keyword);
      if(tpBCX ){
          if((tpBCX->iTRAN_FLAG  &  iSubLoc)!=iSubLoc ){
              continue;
            }
          if((tpBCX->iWordInfo  &  eWI_ReplaceWord)){
              if((tpBCX->iWordInfo  &  eWI_Position1)==0 ){
                  strcpy(Stk[Tmp],tpBCX->pszFunctionXName);
                  continue;
                }
              else if(Tmp==1 ){
                  strcpy(Stk[Tmp],tpBCX->pszFunctionXName);
                  continue;
                }
            }
        }
      a=inchr("abcdefghijklmnopqrstuvwxyz$",Keyword);
      if(a==1 ){
          if(strcmp(Keyword,"acosh")==0){
              strcpy(Stk[Tmp],"acosh");
              Use_Acosh=Use_Proto=TRUE;
              goto L1105;
            }
          if(strcmp(Keyword,"addressof")==0){
              strcpy(Stk[Tmp+1], join(2,"&",Stk[Tmp+1]));
              *Stk[Tmp]=0;
              goto L1105;
            }
          if(strcmp(Keyword,"appactivate")==0){
              strcpy(Stk[Tmp],"AppActivate");
              Use_AppActivate=Use_BcxTempStr=Use_Instr=Use_Stristr=TRUE;
              Use_Lcase=Use_Left=Use_UCaseTbl=TRUE;
              goto L1105;
            }
          if(strcmp(Keyword,"appexename$")==0){
              strcpy(Stk[Tmp],"AppExeName$()");
              Use_AppExeName=Use_BcxTempStr=TRUE;
              goto L1105;
            }
          if(strcmp(Keyword,"appexepath$")==0){
              strcpy(Stk[Tmp],"AppExePath$()");
              Convert2SimpleFunction(Tmp);
              Use_AppExePath=Use_BcxTempStr=TRUE;
              goto L1105;
            }
          if(strcmp(Keyword,"ansitowide")==0  || strcmp(Keyword,"ansitowide$")==0  || strcmp(Keyword,"a2w$")==0  || strcmp(Keyword,"a2w")==0){
              strcpy(Stk[Tmp],"AnsiToWide");
              Use_AnsiToWide=Use_BcxTempStr=TRUE;
              goto L1105;
            }
          if(strcmp(Keyword,"andalso")==0){
              strcpy(Stk[Tmp]," &&");
              goto L1105;
            }
          if(strcmp(Keyword,"asc")==0){
              Process_ASC_Function(Tmp);
              goto L1105;
            }
          if(strcmp(Keyword,"arrayputelement")==0){
              char sTmp[BCXSTRSIZE];
              Add2SplitLines("BEGINBLOCK");
              strcpy(sTmp, join(3,"DIM RAW lIndex[",Stk[Tmp+6],"] = {"));
              for(i=Tmp+8; i<=Ndx-1; i++)
                {
                  strcat(sTmp,Stk[i]);
                }
              Add2SplitLines(join(2,sTmp,"} AS long"));
              strcpy(Stk[Tmp],"SafeArrayPutElement");
              *sTmp=0;
              for(i=1; i<=Tmp+3; i++)
                {
                  strcat(sTmp,Stk[i]);
                }
              Add2SplitLines(join(4,sTmp,"lIndex,(void *)&",Stk[Tmp+4],")"));
              Add2SplitLines("ENDBLOCK");
              Ndx=0;
              goto L1105;
            }
          if(strcmp(Keyword,"arraygetelement")==0){
              char sTmp[BCXSTRSIZE];
              Add2SplitLines("BEGINBLOCK");
              strcpy(sTmp, join(3,"DIM RAW lIndex[",Stk[Tmp+6],"] = {"));
              for(i=Tmp+8; i<=Ndx-1; i++)
                {
                  strcat(sTmp,Clean(Stk[i]));
                }
              Add2SplitLines(join(2,sTmp,"} AS long"));
              strcpy(Stk[Tmp],"SafeArrayGetElement");
              *sTmp=0;
              for(i=1; i<=Tmp+3; i++)
                {
                  strcat(sTmp,Clean(Stk[i]));
                }
              Add2SplitLines(join(4,sTmp,"lIndex,(void *)&",Clean(Stk[Tmp+4]),")"));
              Add2SplitLines("ENDBLOCK");
              Ndx=0;
              goto L1105;
            }
          if(strcmp(Keyword,"asinh")==0){
              strcpy(Stk[Tmp],"asinh");
              Use_Asinh=Use_Proto=TRUE;
              goto L1105;
            }
          if(strcmp(Keyword,"atanh")==0){
              strcpy(Stk[Tmp],"atanh");
              Use_Atanh=Use_Proto=TRUE;
              goto L1105;
            }
          if(strcmp(Keyword,"auto")==0){
              if(iMatchWrd(Stk[Tmp+1],"local")){
                  strcpy(Stk[Tmp],"dim");
                  strcpy(Stk[Tmp+1],"raw");
                }
              else
                {
                  strcpy(Stk[Tmp],"auto");
                }
              goto L1105;
            }
          if(strcmp(Keyword,"acode$")==0  || strcmp(Keyword,"acode")==0){
              strcpy(Stk[Tmp],"$$WideToAnsi$");
              Use_WideToAnsi=Use_BcxTempStr=TRUE;
            }
L1105:;
          goto L1104;
        }
      if(a==2 ){
          if(strcmp(Keyword,"bcopy")==0){
              *Stk[1]=0;
              for(i=Tmp+1; i<=Ndx; i++)
                {
                  if(iMatchWrd(Stk[i],"to")){
                      goto L1111;
                    }
                  strcpy(Stk[1], join(2,Stk[1],Stk[i]));
                  strcpy(Stk[1], join(2,Stk[1],chr(1)));
                }
L1111:;
              *Stk[2]=0;
              for(i=i+1; i<=Ndx; i++)
                {
                  strcpy(Stk[2], join(2,Stk[2],Stk[i]));
                  strcpy(Stk[2], join(2,Stk[2],chr(1)));
                }
              *Src=0;
              strcpy(Src, join(7,Src,"memmove",chr(1),"((char*)",chr(1),"&",chr(1)));
              strcpy(Src, join(6,Src,Stk[2],",(const char*)",chr(1),"&",chr(1)));
              strcpy(Src, join(8,Src,Stk[1],",",chr(1),"sizeof",chr(1),"(",chr(1)));
              strcpy(Src, join(5,Src,Stk[2],")",chr(1),")"));
              strcpy(Src,RemoveStr(Src,"&*"));
              FastLexer(Src,chr(1),"");
              goto L1110;
            }
          if(strcmp(Keyword,"begin")==0){
              Inject_Local_Bcx_RetVal=TRUE;
              if(iMatchWrd(Stk[Tmp+1],"events")||iMatchWrd(Stk[Tmp+1],"mdievents")||iMatchWrd(Stk[Tmp+1],"mdichildevents")){
                  if(Indent ){
                      printf("%s\n",repeat(80,"_"));
                      printf("%s\n","Possible missing END IF before start of BEGIN");
                      printf("%s\n",repeat(80,"_"));
                    }
                  if(Ndx==3 ){
                      strcpy(Src, join(3,"FUNCTION|",Stk[Tmp+2],"(hWnd|AS|HWND,Msg|AS|UINT,wParam|AS|WPARAM,lParam|AS|LPARAM)|AS|LRESULT|CALLBACK"));
                    }
                  else
                    {
                      strcpy(Src,"FUNCTION|WndProc(hWnd|AS|HWND,Msg|AS|UINT,wParam|AS|WPARAM,lParam|AS|LPARAM)|AS|LRESULT|CALLBACK");
                    }
                  FastLexer(Src,"|",",()");
                  Use_Wingui=TRUE;
                  return;
                }
              goto L1110;
            }
          if(strcmp(Keyword,"bel$")==0){
              strcpy(Stk[Tmp],"BEL$");
              Use_BEL=Use_BcxTempStr=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bs$")==0){
              strcpy(Stk[Tmp],"BS$");
              Use_BS=Use_BcxTempStr=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcxstrsize")==0){
              strcpy(Stk[Tmp],"BCXSTRSIZE");
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_dynacall")==0){
              strcpy(Stk[Tmp],"BCX_DynaCallA");
              Use_DynacallCommon=Use_DynacallA=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_font")==0){
              strcpy(Stk[Tmp],ucase(Stk[Tmp]));
              char temp[BCXSTRSIZE];
              int iNextToken=Tmp+1;
              strcpy(Stk[iNextToken],Clean(Stk[iNextToken]));
              strcpy(temp,ucase(Stk[iNextToken]));
              if(strcmp(temp,".NAME")==0){
                  strcpy(Stk[iNextToken],".lf.lfFaceName$");
                  goto L1113;
                }
              if(strcmp(temp,".BOLD")==0){
                  strcpy(Stk[iNextToken],".lf.lfWeight");
                  goto L1113;
                }
              if(strcmp(temp,".UNDERLINE")==0){
                  strcpy(Stk[iNextToken],".lf.lfUnderline");
                  goto L1113;
                }
              if(strcmp(temp,".STRIKEOUT")==0){
                  strcpy(Stk[iNextToken],".lf.lfStrikeOut");
                  goto L1113;
                }
              if(strcmp(temp,".ITALIC")==0){
                  strcpy(Stk[iNextToken],".lf.lfItalic");
                  goto L1113;
                }
              if(strcmp(temp,".CHARSET")==0){
                  strcpy(Stk[iNextToken],".lf.lfCharSet");
                  goto L1113;
                }
              if(strcmp(temp,".SIZE")==0  || strcmp(temp,".RGB")==0){
                  strcpy(Stk[iNextToken],temp);
                }
L1113:;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_setcursor")==0){
              strcpy(Stk[Tmp],"BCX_SetCursor");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_SetCursor=Use_BCX_InitGUI=TRUE;
              AddGUIGlobals();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_msgpump")==0){
              strcpy(Stk[Tmp],"BCX_MsgPump");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_MsgPump=TRUE;
              AddGUIGlobals();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_wnd")==0){
              strcpy(Stk[Tmp],"BCX_Wnd");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Wnd=Use_BCX_InitGUI=Use_BCX_SetMetric=Use_BCX_RegWnd=TRUE;
              AddGUIGlobals();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_framewnd")==0){
              strcpy(Stk[Tmp],"BCX_FrameWnd");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_FrameWnd=Use_BCX_RegWnd=Use_BCX_InitGUI=Use_BCX_SetMetric=TRUE;
              AddGUIGlobals();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_setbkgrdbrush")==0){
              strcpy(Stk[Tmp],"BCX_SetBkGrdBrush");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_SetBkGrdBrush=Use_BCX_InitGUI=TRUE;
              AddGUIGlobals();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_setclassstyle")==0){
              strcpy(Stk[Tmp],"BCX_SetClassStyle");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_SetClassStyle=Use_BCX_InitGUI=TRUE;
              AddGUIGlobals();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_seticon")==0){
              strcpy(Stk[Tmp],"BCX_SetIcon");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_SetIcon=Use_BCX_InitGUI=TRUE;
              AddGUIGlobals();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_seticonsm")==0){
              strcpy(Stk[Tmp],"BCX_SetIconSm");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_SetIconSm=Use_BCX_InitGUI=TRUE;
              AddGUIGlobals();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_setmetric")==0){
              strcpy(Stk[Tmp],"BCX_SetMetric");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_SetMetric=Use_BCX_InitGUI=TRUE;
              AddGUIGlobals();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_initgui")==0){
              strcpy(Stk[Tmp],"BCX_InitGUI");
              Use_BCX_InitGUI=TRUE;
              AddGUIGlobals();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_regwnd")==0){
              strcpy(Stk[Tmp],"BCX_RegWnd");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_RegWnd=Use_BCX_InitGUI=Use_BCX_SetMetric=TRUE;
              AddGUIGlobals();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_mdi_msgpump")==0){
              strcpy(Stk[Tmp],"BCX_MDI_MsgPump");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_MDI_MsgPump=TRUE;
              AddGUIGlobals();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_wndclass")==0){
              strcpy(Stk[Tmp],"BCX_WndClass");
              AddGUIGlobals();
              goto L1110;
            }
          if(strcmp(Keyword,"bcxsplitpath$")==0){
              strcpy(Stk[Tmp],"$$BcxSplitPath$");
              Use_BcxSplitPath=Use_BcxTempStr=TRUE;
              Use_SysMacros=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcxpath$")==0){
              strcpy(Stk[Tmp],"BcxPath$()");
              Convert2SimpleFunction(Tmp);
              Use_BCX_Path=Use_RegString=TRUE;
              Use_BcxTempStr=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_pensize")==0){
              strcpy(Stk[Tmp],"BCX_Pensize");
              AddPenSizeVariables();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_penstyle")==0){
              strcpy(Stk[Tmp],"BCX_Penstyle");
              AddPenSizeVariables();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_arc")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Arc");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Arc=Use_Proto=TRUE;
              AddPenSizeVariables();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_pie")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Pie");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Pie=Use_Proto=TRUE;
              AddPenSizeVariables();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_bitmap")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Bitmap");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Bitmap=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_blit")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Blit");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Blit=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_blit_stretch")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Blit_Stretch");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Blit_Stretch=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_blit_sprite")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Blit_Sprite");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Blit_Sprite=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_buffer")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_BUFFER");
              Use_BCX_Buffer=Use_Proto=TRUE;
              AddGrafixVariables();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_buffer_start")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_BUFFER_START");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Buffer=Use_Proto=TRUE;
              AddGrafixVariables();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_buffer_stop")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_BUFFER_STOP");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Buffer=Use_Proto=TRUE;
              AddGrafixVariables();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_olepicture")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_OlePicture");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_OlePicture=Use_GetResource=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_ole_width")==0){
              strcpy(Stk[Tmp],"BCX_OLE_WIDTH");
              Use_SysMacros=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_ole_height")==0){
              strcpy(Stk[Tmp],"BCX_OLE_HEIGHT");
              Use_SysMacros=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_blackrect")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_BlackRect");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Blackrect=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_button")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Button");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Button=Use_GetTextSize=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_bmpbutton")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_BmpButton");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BmpButton=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_bmpwidth")==0){
              strcpy(Stk[Tmp],"BCX_BmpWidth");
              Use_BCX_BmpWidth=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_bmpheight")==0){
              strcpy(Stk[Tmp],"BCX_BmpHeight");
              Use_BCX_BmpHeight=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_checkbox")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Checkbox");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Checkbox=Use_GetTextSize=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_combobox")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Combobox");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Combobox=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_console")==0){
              strcpy(Stk[Tmp],"hConsole");
              Use_Console=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_com_error")==0){
              strcpy(Stk[Tmp],"COM_BCX_ERROR");
              ComSwitchON=Use_COM=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_control")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Control");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Control=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_colordlg")==0){
              strcpy(Stk[Tmp],"BCX_ColorDlg");
              if(!inchr(Src,"(")){
                  strcpy(Stk[Tmp], join(2,Stk[Tmp],"()"));
                }
              Use_BCX_Colordlg=Use_Hook=Use_BcxTempStr=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_cursor")==0){
              strcpy(Stk[Tmp],"BCX_Cursor");
              Use_BCX_Cursor=Use_SysMacros=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_datepick")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_DatePick");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Datepick=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_edit")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Edit");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Edit=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_circle")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Circle");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Circle=Use_Proto=TRUE;
              AddPenSizeVariables();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_ellipse")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Ellipse");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Ellipse=Use_Proto=TRUE;
              AddPenSizeVariables();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_mdialog")==0){
              AddBcxFontVar();
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              if(InWinMain&&!Use_BCXMDialog ){
                  fprintf(FP_WRITE,"%s%s\n",Scoot,"BCX_hInstance = hInst;");
                  iEmitVarGroup=iEmitVarGroup|(eFontGroup|eBCX_hInstance);
                }
              strcpy(Stk[Tmp],"BCX_MDialog");
              if(Tmp==3 ){
                  strcpy(Stk[Tmp+1],"((DLGPROC)");
                }
              Use_BCXDialogCommon=Use_BCXMDialog=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_dialog")==0){
              AddBcxFontVar();
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              strcpy(Stk[Tmp],"BCX_Dialog");
              if(Tmp==3 ){
                  strcpy(Stk[Tmp+1],"((DLGPROC)");
                }
              Use_BCXDialogCommon=Use_BCXDialog=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_form")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Form");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Form=Use_Proto=Use_MainEvent=TRUE;
              if(!Use_BCX_Class_Info ){
                  Use_BCX_Class_Info=TRUE;
                  iEmitVarGroup=iEmitVarGroup|(eFontGroup|eClassName);
                }
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_fontdlg")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_FontDlg");
              if(Tmp==Ndx ){
                  strcpy(Stk[Tmp], join(2,Stk[Tmp],"()"));
                }
              Use_BCX_Fontdlg=TRUE;
              Use_Hook=Use_BcxTempStr=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_floodfill")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_FloodFill");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Floodfill=Use_Proto=TRUE;
              AddPenSizeVariables();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_get")==0){
              strcpy(Stk[Tmp],"BCX_Get");
              Use_BCX_Get=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_get_window_height")==0){
              strcpy(Stk[Tmp],"BCX_Get_Window_Height");
              Use_BCX_Get_Window_Height=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_get_window_width")==0){
              strcpy(Stk[Tmp],"BCX_Get_Window_Width");
              Use_BCX_Get_Window_Width=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_get_text$")==0){
              strcpy(Stk[Tmp],"$$BCX_Get_Text$");
              Use_GetText=Use_BcxTempStr=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_getpixel")==0){
              strcpy(Stk[Tmp],"BCX_Getpixel");
              Use_BCX_Getpixel=Use_BcxTempStr=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_gradient")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Gradient");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Gradient=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_grayrect")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_GrayRect");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Grayrect=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_group")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Group");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Group=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_icon")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Icon");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Icon=Use_GetResource=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_input")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Input");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Input=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_label")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Label");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Label=Use_GetTextSize=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_line")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Line");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Line=Use_Proto=TRUE;
              AddPenSizeVariables();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_polar_line")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Polar_Line");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Line=Use_Proto=TRUE;
              Use_BCX_Polar_Line=TRUE;
              AddPenSizeVariables();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_lineto")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Lineto");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Lineto=Use_Proto=TRUE;
              AddPenSizeVariables();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_triangle")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Triangle");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Triangle=Use_Proto=TRUE;
              AddPenSizeVariables();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_listbox")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Listbox");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Listbox=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_listview")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_ListView");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Listview=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_loadbmp")==0){
              strcpy(Stk[Tmp],"BCX_LoadBMP");
              Use_BCX_LoadBMP=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_loadimage")==0){
              strcpy(Stk[Tmp],"BCX_LoadImage");
              Use_BCX_LoadImage=Use_GetResource=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_print")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Print");
              Use_BCX_Print=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_printex")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Printex");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Printex=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_polygon")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Polygon");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Polygon=Use_Proto=TRUE;
              AddPenSizeVariables();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_polybezier")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_PolyBezier");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_PolyBezier=Use_Proto=TRUE;
              AddPenSizeVariables();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_polyline")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Polyline");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Polyline=Use_Proto=TRUE;
              AddPenSizeVariables();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_preset")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Preset");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Preset=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_pset")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Pset");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Pset=Use_Proto=TRUE;
              AddPenSizeVariables();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_polar_pset")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Polar_Pset");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Pset=Use_Proto=TRUE;
              Use_BCX_Polar_Pset=TRUE;
              AddPenSizeVariables();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_polar_line")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Polar_Line");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Line=Use_Proto=TRUE;
              Use_BCX_Polar_Line=TRUE;
              AddPenSizeVariables();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_progressbar")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_ProgressBar");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_ProgressBar=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_put")==0){
              strcpy(Stk[Tmp],"BCX_Put");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Put=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_radio")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Radio");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Radio=Use_GetTextSize=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_rectangle")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Rectangle");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Rectangle=Use_BcxTempStr=TRUE;
              AddPenSizeVariables();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_resize")==0){
              strcpy(Stk[Tmp],"BCX_RESIZE");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Resize=Use_SysMacros=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_richedit")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_RichEdit");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Richedit=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_roundrect")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Roundrect");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Roundrect=Use_Proto=TRUE;
              AddPenSizeVariables();
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_slider")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Slider");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Slider=Use_Label=Use_GetTextSize=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_splitter")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Splitter");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Splitter=Use_Proto=Use_Modstyle=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_setsplitpos")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_SetSplitPos");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Splitter=Use_Proto=Use_Modstyle=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_tab")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Tab");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Tab=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_toolbar")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Toolbar");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_Toolbar=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_updown")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_UpDown");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_UpDown=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_version$")==0){
              strcpy(Stk[Tmp],enc(Version));
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_get_updown")==0){
              strcpy(Stk[Tmp],"BCX_Get_UpDown");
              Use_BCX_Get_UpDown=Use_Proto=Use_BcxTempStr=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_set_form_color")==0){
              strcpy(Stk[Tmp],"BCX_Set_Form_Color");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_SetFormColor=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_setclientsize")==0){
              Use_Setclientsize=Use_Proto=TRUE;
              strcpy(Stk[Tmp],"BCX_SetClientSize");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_set_font")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Set_Font");
              Use_SetFont=Use_Proto=TRUE;
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_setcolor")==0){
              strcpy(Stk[Tmp],"Set_Color");
              int iPCnt=GetNumArgs(Tmp+2);
              if(iPCnt==1 ){
                  InsertTokens(Ndx-1,4,",","(HDC)wParam",",","(HWND)lParam");
                }
              else if(iPCnt==2 ){
                  InsertTokens(Ndx-1,2,",","(HWND)lParam");
                }
              Use_SetColor=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_set_text")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Set_Text");
              Use_SetText=Use_Proto=TRUE;
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_status")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Status");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Status=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_stricmp")==0){
              strcpy(Stk[Tmp],"bcx_stricmp");
              Use_BCX_stricmp=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_setconsolesize")==0){
              strcpy(Stk[Tmp],"BCX_SetConsoleSize");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Consolesize=Use_Console=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_pushconsolesize")==0){
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  strcpy(Stk[Tmp],"BCX_PushConsoleSize()");
                }
              Use_Consolesize=Use_Console=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_popconsolesize")==0){
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  strcpy(Stk[Tmp],"BCX_PopConsoleSize()");
                }
              Use_Consolesize=Use_Console=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_tabselect")==0){
              strcpy(Stk[Tmp],"BCX_TabSelect(hWnd, lParam)");
              Use_BCX_Tab=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_tile")==0){
              Use_BCX_Tile=Use_Proto=TRUE;
              strcpy(Stk[Tmp],"BCX_Tile");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_thread")==0  || strcmp(Keyword,"bcx_threadwait")==0  || strcmp(Keyword,"bcx_threadsuspend")==0  || strcmp(Keyword,"bcx_threadresume")==0  || strcmp(Keyword,"bcx_threadkill")==0  || strcmp(Keyword,"bcx_threadend")==0){
              strcpy(Stk[Tmp],ucase(Stk[Tmp]));
              Use_Threads=Use_SysMacros=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_tooltip")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_ToolTip");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BCX_ToolTip=Use_Proto=TRUE;
              AddGlobal("BCX_hWnd_ToolTip",vt_HWND);
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_tempstr")==0){
              strcpy(Stk[Tmp],"BCX_TempStr");
              Use_BcxTempStr=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_treeview")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_Treeview");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Treeview=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_whiterect")==0){
              AddBcxFontVar();
              strcpy(Stk[Tmp],"BCX_WhiteRect");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Whiterect=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_clsid$")==0){
              strcpy(Stk[Tmp],"BCX_CLSID$");
              Use_Proto=Use_BcxTempStr=TRUE;
              Use_COM_CLSID=Use_AnsiToWide=Use_WideToAnsi=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bcx_dispatchobject")==0){
              Use_BcxTempStr=TRUE;
              ComSwitchON=Use_COM=TRUE;
              Use_COM_CreateObject=TRUE;
              Use_COM_DispatchObject=TRUE;
              Use_COM_GetObject=TRUE;
              Use_COM_GetProperty=TRUE;
              Use_COM_InvokeMethod=TRUE;
              Use_COM_SafeArray=TRUE;
              Use_COM_SetProperty=TRUE;
              Use_COM_UsesConversion=TRUE;
   char szObj[BCXSTRSIZE];  strcpy(szObj,"&");
              char szUnknown[BCXSTRSIZE]={0};
              char szRelease[BCXSTRSIZE]={0};
              int  iTobj;
              iTobj=1;
              while(strcmp(Stk[iTobj],"=")!=0){
                  strcat(szObj,Stk[iTobj]);
                  iTobj++;
                }
              iTobj=Tmp+2;
              while(strcmp(Stk[iTobj],",")!=0  && strcmp(Stk[iTobj],")")!=0){
                  strcat(szUnknown,Stk[iTobj]);
                  iTobj++;
                }
              if(strcmp(Stk[iTobj],")")==0){
                  strcpy(szRelease,"TRUE");
                }
              else
                {
                  strcpy(szRelease,Stk[iTobj+1]);
                }
              strcpy(Stk[1],"BCX_DispatchObject");
              strcpy(Stk[2],"(");
              strcpy(Stk[3],szUnknown);
              strcpy(Stk[4],",");
              strcpy(Stk[5],szObj);
              strcpy(Stk[6],",");
              strcpy(Stk[7],szRelease);
              strcpy(Stk[8],")");
              Ndx=8;
              goto L1110;
            }
          if(strcmp(Keyword,"bff$")==0){
              strcpy(Stk[Tmp],"$$BFF$");
              Use_Bff=Use_BcxTempStr=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bin$")==0){
              strcpy(Stk[Tmp],"$$Bin$");
              Use_Bin=Use_BcxTempStr=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bin2dec")==0){
              strcpy(Stk[Tmp],"Bin2Dec");
              Use_Bin2dec=Use_Proto=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bool$")==0){
              strcpy(Stk[Tmp],"$$BoolStr$");
              Use_Boolstr=Use_BcxTempStr=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bool")==0){
              strcpy(Stk[Tmp],"BOOL");
              goto L1110;
            }
          if(strcmp(Keyword,"boolean")==0){
              strcpy(Stk[Tmp],"BOOLEAN");
              goto L1110;
            }
          if(strcmp(Keyword,"band")==0){
              if(*Stk[Tmp+1]==61 ){
                  strcpy(Stk[Tmp+1],"&=");
                  *Stk[Tmp]=0;
                }
              else
                {
                  strcpy(Stk[Tmp]," & ");
                }
              goto L1110;
            }
          if(strcmp(Keyword,"bnot")==0){
              strcpy(Stk[Tmp]," BNOT ");
              Use_Bnot=Use_SysMacros=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"byte_at")==0){
              strcpy(Stk[Tmp],"BYTE_AT");
              Use_ByteAt=Use_SysMacros=TRUE;
              goto L1110;
            }
          if(strcmp(Keyword,"bor")==0){
              if(*Stk[Tmp+1]==61 ){
                  strcpy(Stk[Tmp+1],"|=");
                  *Stk[Tmp]=0;
                }
              else
                {
                  strcpy(Stk[Tmp],"|");
                }
            }
L1110:;
          goto L1104;
        }
      if(a==3 ){
          if(strcmp(Keyword,"case")==0){
              int nBrace;
              int CntMarker;
              nBrace=0;
              CntMarker=2;
              j=0;
              for(i=2; i<=Ndx; i++)
                {
                  if(inchr("([",Stk[i])){
                      nBrace++;
                    }
                  if(inchr(")]",Stk[i])){
                      nBrace--;
                    }
                  if(strcmp(Stk[i],",")==0){
                      if(nBrace==0 ){
                          CntMarker=i+1;
                        }
                    }
                  if(iMatchWrd(Stk[i],"to")){
                      j=1;
                      strcpy(Stk[i], join(3,"&&",chr(1),"<="));
                      strcpy(Stk[CntMarker], join(3,">=",chr(1),Stk[CntMarker]));
                    }
                }
              if(j==1 ){
                  *Src=0;
                  for(i=1; i<=Ndx; i++)
                    {
                      strcpy(Src, join(3,Src,Stk[i],chr(1)));
                    }
                  FastLexer(Src,chr(1),"");
                }
              goto L1116;
            }
          if(strcmp(Keyword,"cast")==0){
              strcpy(Stk[Tmp]," CAST ");
              Use_Cast=Use_SysMacros=TRUE;
              goto L1116;
            }
          if(strcmp(Keyword,"callback")==0){
              strcpy(Stk[Tmp],"CALLBACK");
              if(Tmp==1 ){
                  if(Ndx>5 ){
                      Warning("Extra Callback code truncated",1);
                    }
                  strcpy(Src, join(3,"FUNCTION|",Stk[3],"(hWnd|AS|HWND,Msg|AS|UINT,wParam|AS|WPARAM,lParam|AS|LPARAM)|AS|LRESULT|CALLBACK"));
                  FastLexer(Src,"|",",()");
                  CallBackFlag=TRUE;
                }
              goto L1116;
            }
          if(strcmp(Keyword,"callwindowproc")==0){
              strcpy(Stk[Tmp],"CallWindowProc");
              if(strcmp(Stk[Tmp+3],"WNDPROC")!=0){
                  InsertTokens(Tmp+1,3,"(","WNDPROC",")");
                }
              goto L1116;
            }
          if(strcmp(Keyword,"com")==0){
              strcpy(Stk[Tmp],"COM");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              ComSwitchON=Use_COM=TRUE;
              Use_COM_CreateObject=TRUE;
              Use_COM_DispatchObject=TRUE;
              Use_COM_GetObject=TRUE;
              Use_COM_GetProperty=TRUE;
              Use_COM_InvokeMethod=TRUE;
              Use_COM_SafeArray=TRUE;
              Use_COM_SetProperty=TRUE;
              Use_COM_UsesConversion=TRUE;
              goto L1116;
            }
          if(strcmp(Keyword,"createobject")==0){
              ComSwitchON=Use_COM_UsesConversion=Use_COM_CreateObject=Use_COM=TRUE;
              if(strcmp(Stk[2],"[")==0){
                  int iii;
                  iii=2;
                  while(strcmp(Stk[iii],"=")!=0){
                      strcpy(Stk[1], join(2,Stk[1],Stk[iii]));
                      *Stk[iii]=0;
                      iii++;
                    }
                  RemEmptyTokens();
                }
              strcpy(Stk[3],Stk[5]);
              sprintf(Stk[5],"&%s",Stk[1]);
              strcpy(Stk[1],"BCX_CreateObject");
              strcpy(Stk[2],"(");
              strcpy(Stk[4],",");
              goto L1116;
            }
          if(strcmp(Keyword,"concat")==0){
              strcpy(Stk[Tmp],"strcat");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              goto L1116;
            }
          if(strcmp(Keyword,"containedin")==0){
              strcpy(Stk[Tmp],"containedin");
              Use_ContainedIn=Use_BCX_stricmp=TRUE;
              goto L1116;
            }
          if(strcmp(Keyword,"cr$")==0){
              strcpy(Stk[Tmp],"CR$");
              Use_CR=Use_BcxTempStr=TRUE;
              goto L1116;
            }
          if(strcmp(Keyword,"close")==0){
              int iNextToken=Tmp+1;
              if(*Stk[iNextToken]==35 ){
                  strcpy(Stk[iNextToken],mid(Stk[iNextToken],2));
                }
              goto L1116;
            }
          if(strcmp(Keyword,"closedialog")==0){
              Ndx=1;
              if(ModDialogEvt ){
                  strcpy(Stk[Ndx],"EndDialog(hWnd,0)");
                }
              else
                {
                  strcpy(Stk[Ndx],"DestroyWindow(hWnd)");
                }
              goto L1116;
            }
          if(strcmp(Keyword,"cvd")==0){
              strcpy(Stk[Tmp],"CVD");
              Use_Cvd=Use_Proto=TRUE;
              goto L1116;
            }
          if(strcmp(Keyword,"cvi")==0){
              strcpy(Stk[Tmp],"CVI");
              Use_Cvi=Use_Proto=TRUE;
              goto L1116;
            }
          if(strcmp(Keyword,"cvl")==0){
              strcpy(Stk[Tmp],"CVL");
              Use_Cvl=Use_Proto=TRUE;
              goto L1116;
            }
          if(strcmp(Keyword,"cvld")==0){
              strcpy(Stk[Tmp],"CVLD");
              Use_Cvld=Use_Proto=TRUE;
              goto L1116;
            }
          if(strcmp(Keyword,"cvs")==0){
              strcpy(Stk[Tmp],"CVS");
              Use_Cvs=Use_Proto=TRUE;
              goto L1116;
            }
          if(strcmp(Keyword,"chr$")==0){
              strcpy(Stk[Tmp],"$$chr$");
              Use_Chr=Use_BcxTempStr=TRUE;
              goto L1116;
            }
          if(strcmp(Keyword,"chrtoutf8$")==0){
              strcpy(Stk[Tmp],"ChrToUtf8$");
              Use_Chrtoutf8=Use_BcxTempStr=TRUE;
              goto L1116;
            }
          if(strcmp(Keyword,"crlf$")==0){
              strcpy(Stk[Tmp],"CRLF$");
              Use_Crlf=Use_BcxTempStr=TRUE;
              goto L1116;
            }
          if(strcmp(Keyword,"createregstring")==0){
              strcpy(Stk[Tmp],"CreateRegString");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_CreateRegString=Use_BcxTempStr=TRUE;
              goto L1116;
            }
          if(strcmp(Keyword,"createregint")==0){
              strcpy(Stk[Tmp],"CreateRegInt");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_CreateRegInt=Use_BcxTempStr=TRUE;
              goto L1116;
            }
          if(strcmp(Keyword,"cdbl")==0){
              strcpy(Stk[Tmp],"CDBL");
              Use_Cdbl=Use_SysMacros=TRUE;
              goto L1116;
            }
          if(strcmp(Keyword,"center")==0){
              strcpy(Stk[Tmp],"Center");
              Use_Center=Use_Proto=TRUE;
              if(Ndx>=2 && strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              goto L1116;
            }
          if(strcmp(Keyword,"cint")==0){
              strcpy(Stk[Tmp],"Cint");
              Use_Cint=Use_Proto=TRUE;
              goto L1116;
            }
          if(strcmp(Keyword,"cldbl")==0){
              strcpy(Stk[Tmp],"CLDBL");
              Use_Cldbl=Use_SysMacros=TRUE;
              goto L1116;
            }
          if(strcmp(Keyword,"clng")==0){
              strcpy(Stk[Tmp],"CLNG");
              Use_Clng=Use_Proto=TRUE;
              goto L1116;
            }
          if(strcmp(Keyword,"clipboard_gettext")==0  || strcmp(Keyword,"clipboard_gettext$")==0){
              strcpy(Stk[Tmp],"Clipboard_GetText$()");
              Convert2SimpleFunction(Tmp);
              Use_Clip_Gettext=Use_BcxTempStr=TRUE;
              goto L1116;
            }
          if(strcmp(Keyword,"clipboard_getbitmap")==0){
              strcpy(Stk[Tmp],"Clipboard_GetBitmap()");
              Convert2SimpleFunction(Tmp);
              Use_Clip_Getbitmap=TRUE;
              goto L1116;
            }
          if(strcmp(Keyword,"clipboard_gettextsize")==0){
              strcpy(Stk[Tmp],"Clipboard_GetTextSize()");
              Convert2SimpleFunction(Tmp);
              Use_Clip_Gettextsize=Use_Proto=TRUE;
              goto L1116;
            }
          if(strcmp(Keyword,"clipboard_settext")==0){
              strcpy(Stk[Tmp],"Clipboard_SetText");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Clip_Settext=TRUE;
              goto L1116;
            }
          if(strcmp(Keyword,"clipboard_setbitmap")==0){
              strcpy(Stk[Tmp],"Clipboard_SetBitmap");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Clip_Setbitmap=TRUE;
              goto L1116;
            }
          if(strcmp(Keyword,"clipboard_reset")==0){
              strcpy(Stk[Tmp],"Clipboard_Reset");
              Use_Clip_Reset=Use_SysMacros=TRUE;
              goto L1116;
            }
          if(strcmp(Keyword,"cls")==0){
              strcpy(Stk[Tmp],"cls");
              Use_Cls=TRUE;
              Use_Locate=Use_Console=Use_Proto=Use_Cursor=TRUE;
              goto L1116;
            }
          if(strcmp(Keyword,"color")==0  || strcmp(Keyword,"color_fg")==0  || strcmp(Keyword,"color_bg")==0){
              strcpy(Stk[Tmp],lcase(Stk[Tmp]));
              Use_Color=Use_Console=Use_Proto=TRUE;
              goto L1116;
            }
          if(strcmp(Keyword,"command$")==0){
              Use_Command=Use_BcxTempStr=TRUE;
              strcpy(Stk[Tmp],"command$(-1)");
              if(strcmp(Stk[Tmp+1],"(")==0){
                  strcpy(Stk[Tmp],"command$");
                }
              goto L1116;
            }
          if(strcmp(Keyword,"comboboxloadfile")==0){
              strcpy(Stk[Tmp],"ComboBoxLoadFile");
              Use_ComboBoxLoadFile=TRUE;
              Use_BcxTempStr=TRUE;
              Use_Proto=TRUE;
              Use_Trim=TRUE;
              goto L1116;
            }
          if(strcmp(Keyword,"cbool")==0){
              strcpy(Stk[Tmp],"CBOOL");
              Use_Cbool=Use_SysMacros=TRUE;
              int iii={0};
              int t={0};
              int expos=0;
              struct _FUNCPARSE  fp;
              Clear(fp);
              if(SepFuncArgs(Tmp+1,&(fp),TRUE)==0 ){
                  Abort("No argument specified in CBOOL");
                }
              for(iii=fp.CommaPos[0]; iii<=fp.CommaPos[1]; iii++)
                {
                  t=inchr("!<>=",Stk[iii]);
                  if(t ){
                      if(t<4 ){
                          if(strcmp(Stk[iii+1],"=")==0){
                              strcpy(Stk[iii], join(2,Stk[iii],Stk[iii+1]));
                              *Stk[iii+1]=0;
                            }
                          else if(t==1 && strcmp(Stk[iii],"!=")!=0){
                              continue;
                            }
                        }
                      else
                        {
                          if(strcmp(Stk[iii+1],"=")!=0){
                              strcpy(Stk[iii],"==");
                            }
                        }
                      expos=iii;
                      goto L1120;
                    }
                }
L1120:;
              t=DataType(Stk[expos-1]);
              if(t==vt_STRLIT||t==vt_STRVAR ){
                  if(expos ){
                      strcpy(Stk[Tmp+1], join(2,Stk[Tmp+1],"strcmp("));
                      strcpy(Stk[fp.CommaPos[1]], join(3,")",Stk[expos],"0)"));
                      strcpy(Stk[expos],",");
                      *Src=0;
                      for(iii=1; iii<=Ndx; iii++)
                        {
                          strcat(Src,Stk[iii]);
                          strcat(Src,SPC);
                        }
                      FastLexer(Src,SPC,"(),");
                    }
                }
              goto L1116;
            }
          if(strcmp(Keyword,"csng")==0){
              strcpy(Stk[Tmp],"CSNG");
              Use_Csng=Use_SysMacros=TRUE;
              goto L1116;
            }
          if(strcmp(Keyword,"cpad$")==0){
              strcpy(Stk[Tmp],"cpad$");
              Use_Cpad=Use_Join=Use_BcxTempStr=TRUE;
              goto L1116;
            }
          if(strcmp(Keyword,"cursorx")==0){
              strcpy(Stk[Tmp],"Pos()");
              Use_Pos=Use_Proto=TRUE;
              goto L1116;
            }
          if(strcmp(Keyword,"csrlin")==0  || strcmp(Keyword,"cursory")==0){
              strcpy(Stk[Tmp],"Csrlin()");
              Use_Csrlin=Use_Proto=TRUE;
              goto L1116;
            }
          if(strcmp(Keyword,"curdir$")==0){
              strcpy(Stk[Tmp],"curdir$()");
              Convert2SimpleFunction(Tmp);
              Use_Curdir=Use_BcxTempStr=TRUE;
              goto L1116;
            }
          if(strcmp(Keyword,"c_declare")==0){
              strcpy(CallType,"__cdecl ");
              strcpy(Stk[Tmp],"declare");
              if(iMatchWrd(Stk[4],"lib")){
                  NoTypeDeclare=FALSE;
                }
              else
                {
                  NoTypeDeclare=TRUE;
                }
            }
L1116:;
          goto L1104;
        }
      if(a==4 ){
          if(strcmp(Keyword,"datacount")==0){
              strcpy(Stk[Tmp],"DATACOUNT");
              Use_Datacount=Use_SysMacros=TRUE;
              goto L1122;
            }
          if(strcmp(Keyword,"declare")==0){
              strcpy(CallType,"__stdcall ");
              strcpy(Stk[Tmp],"declare");
              if(!iMatchWrd(Stk[4],"lib")){
                  NoTypeDeclare=TRUE;
                }
              else
                {
                  NoTypeDeclare=FALSE;
                }
              goto L1122;
            }
          if(strcmp(Keyword,"degtorad")==0){
              strcpy(Stk[Tmp],"DegToRad");
              Use_DegToRad=Use_SysMacros=TRUE;
              goto L1122;
            }
          if(strcmp(Keyword,"dq$")==0){
              strcpy(Stk[Tmp],"DQ$");
              Use_DQ=Use_BcxTempStr=TRUE;
              goto L1122;
            }
          if(strcmp(Keyword,"ddq$")==0){
              strcpy(Stk[Tmp],"DDQ$");
              Use_DDQ=Use_BcxTempStr=TRUE;
              goto L1122;
            }
          if(strcmp(Keyword,"data")==0){
              NoTrans=1;
              goto L1122;
            }
          if(strcmp(Keyword,"date$")==0){
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  strcpy(Stk[Tmp],"date$()");
                }
              else
                {
                  strcpy(Stk[Tmp],"date$");
                }
              Use_Date=Use_BcxTempStr=TRUE;
              goto L1122;
            }
          if(strcmp(Keyword,"del$")==0){
              strcpy(Stk[Tmp],"del$");
              Use_Del=Use_BcxTempStr=Use_Proto=TRUE;
              goto L1122;
            }
          if(strcmp(Keyword,"deleteregkey")==0){
              strcpy(Stk[Tmp],"DeleteRegKey");
              Use_DeleteRegKey=Use_BcxTempStr=TRUE;
              goto L1122;
            }
          if(strcmp(Keyword,"diskfree")==0){
              strcpy(Stk[Tmp],"(UINT64) DiskFree");
              Use_Diskfree=Use_Proto=TRUE;
              goto L1122;
            }
          if(strcmp(Keyword,"diskused")==0){
              strcpy(Stk[Tmp],"(UINT64) DiskUsed");
              Use_Diskused=Use_Proto=TRUE;
              goto L1122;
            }
          if(strcmp(Keyword,"disksize")==0){
              strcpy(Stk[Tmp],"(UINT64) DiskSize");
              Use_Disksize=Use_Proto=TRUE;
              goto L1122;
            }
          if(strcmp(Keyword,"dialog")==0){
              Inject_Local_Bcx_RetVal=TRUE;
              if(iMatchWrd(Stk[1],"begin")){
                  if(Ndx==4&&iMatchWrd(Stk[3],"as")){
                      InDialogEvt=TRUE;
                    }
                  else if(Ndx==5&&iMatchWrd(Stk[4],"as")){
                      ModDialogEvt=TRUE;
                    }
                  else
                    {
                      Abort("Malformed Begin Dialog");
                    }
                  strcpy(Src, join(3,"function ",Stk[Ndx],"(hWnd AS HWND,Msg AS UINT,wParam AS WPARAM,lParam AS LPARAM) AS INT_PTR CALLBACK"));
                  FastLexer(Src,SPC,"(),");
                }
              goto L1122;
            }
          if(strcmp(Keyword,"destroysafearray")==0){
              strcpy(Stk[Tmp],"DestroySafeArray");
              Use_SafeArrays=TRUE;
              goto L1122;
            }
          if(strcmp(Keyword,"doevents")==0){
              strcpy(Stk[Tmp],"DoEvents()");
              Convert2SimpleFunction(Tmp);
              Use_Doevents=Use_Proto=TRUE;
              goto L1122;
            }
          if(strcmp(Keyword,"drawtransbmp")==0){
              strcpy(Stk[Tmp],"DrawTransBMP");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_DrawTransBMP=Use_Proto=TRUE;
              goto L1122;
            }
          if(strcmp(Keyword,"draw")==0){
              strcpy(Stk[Tmp],"Draw");
              if(Tmp==Ndx ){
                  Abort("DRAW command expects a string argument");
                }
              AddPenSizeVariables();
              Use_BCX_Floodfill=Use_BCX_Line=Use_BCX_Lineto=Use_BCX_Preset=TRUE;
              Use_BcxTempStr=Use_Bitmap=Use_DSplit=Use_Draw=Use_DrawStr=TRUE;
              Use_DynamicA=Use_Instr=Use_Left=Use_Mid=Use_Proto=Use_QBColor=TRUE;
              Use_Remove=Use_Replace=Use_Stristr=Use_UCaseTbl=Use_Ucase=Use_Val=TRUE;
              Use_SysMacros=Use_Val=TRUE;
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              goto L1122;
            }
          if(strcmp(Keyword,"download")==0){
              if(Tmp==Ndx ){
                  Abort("DOWNLOAD command expects two string arguments");
                }
              strcpy(Stk[Tmp],"Download");
              Use_Download=Use_Proto=TRUE;
              goto L1122;
            }
          if(strcmp(Keyword,"downloadtostr")==0  || strcmp(Keyword,"downloadtostr$")==0){
              if(Tmp==Ndx ){
                  Abort("DOWNLOADTOSTR command expects one string arguments");
                }
              strcpy(Stk[Tmp],"DownloadToStr");
              Use_Downloadtostr=Use_Download=TRUE;
              Use_LoadFile=Use_BcxTempStr=Use_Lof=TRUE;
              Use_Exist=Use_TempFileName=TRUE;
              Use_LoadFile=Use_Get=Use_Tempdir=TRUE;
              Use_SysMacros=Use_Proto=TRUE;
              goto L1122;
            }
          if(strcmp(Keyword,"dsplit")==0){
              strcpy(Stk[Tmp],"DSplit");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BcxTempStr=TRUE;
              Use_UCaseTbl=TRUE;
              Use_Stristr=TRUE;
              Use_Proto=TRUE;
              Use_DSplit=TRUE;
              Use_Remove=TRUE;
              Use_Mid=TRUE;
              Use_Left=TRUE;
              Use_Instr=TRUE;
              Use_Replace=TRUE;
            }
L1122:;
          goto L1104;
        }
      if(a==5 ){
          if(strcmp(Keyword,"enddraw")==0){
              strcpy(Stk[Tmp],"EndDraw");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Draw=TRUE;
              goto L1123;
            }
          if(strcmp(Keyword,"endmodal")==0){
              strcpy(Stk[Tmp],"EndModal");
              Use_Show=Use_SysMacros=Use_ShowModal=Use_EndModal=TRUE;
              goto L1123;
            }
          if(strcmp(Keyword,"editloadfile")==0){
              strcpy(Stk[Tmp],"EditLoadFile");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BcxTempStr=TRUE;
              Use_SysMacros=TRUE;
              Use_Elf=TRUE;
              Use_Exist=TRUE;
              Use_Get=TRUE;
              Use_Lof=TRUE;
              Use_Proto=TRUE;
              Use_Join=TRUE;
              goto L1123;
            }
          if(strcmp(Keyword,"enc$")==0){
              strcpy(Stk[Tmp],"$$enc$");
              Use_Enclose=Use_BcxTempStr=TRUE;
              goto L1123;
            }
          if(strcmp(Keyword,"extract$")==0){
              strcpy(Stk[Tmp],"$$extract$");
              Use_Extract=Use_BcxTempStr=TRUE;
              goto L1123;
            }
          if(strcmp(Keyword,"extractany$")==0){
              strcpy(Stk[Tmp],"$$extractany$");
              Use_ExtractAny=Use_BcxTempStr=TRUE;
              goto L1123;
            }
          if(strcmp(Keyword,"eof$")==0){
              strcpy(Stk[Tmp],"EF$");
              Use_EF=Use_BcxTempStr=TRUE;
              goto L1123;
            }
          if(strcmp(Keyword,"eof")==0){
              strcpy(Stk[Tmp],"EoF");
              Use_Eof=Use_BcxTempStr=TRUE;
              strcpy(Stk[Tmp+2],RemoveStr(Stk[Tmp+2],"#"));
              if(strcmp(Stk[Tmp+2],"")==0){
                  Abort("Bad EOF Argument");
                }
              if(DataType(Stk[Tmp+2])==vt_NUMBER ){
                  strcpy(Stk[Tmp+2], join(2,"FP",Stk[Tmp+2]));
                }
              goto L1123;
            }
          if(strcmp(Keyword,"equalto")==0){
              strcpy(Stk[Tmp]," EqualTo ");
              Use_EqualTo=Use_SysMacros=TRUE;
              goto L1123;
            }
          if(strcmp(Keyword,"esc$")==0){
              strcpy(Stk[Tmp],"ESC$");
              Use_ESC=Use_BcxTempStr=TRUE;
              goto L1123;
            }
          if(strcmp(Keyword,"enum")==0){
              int iNamedEnum=0;
              if(Tmp==3 ){
                  iNamedEnum=iMatchWrd(Stk[Tmp-1],"as");
                }
              else
                {
                  if(Ndx==3 ){
                      iNamedEnum=iMatchWrd(Stk[Tmp+1],"as");
                    }
                }
              if(Ndx==1||iNamedEnum ){
                  Use_EnumFile=TRUE;
                  char szNameOfEnum[BCXSTRSIZE];
                  int EnumFlag=FALSE;
                  fprintf(FP_ENU,"%s\n","");
                  if(iNamedEnum ){
                      if(Tmp==3 ){
                          strcpy(szNameOfEnum,Stk[Tmp-2]);
                          fprintf(FP_ENU,"%s%s\n","typedef enum _",szNameOfEnum);
                        }
                      else
                        {
                          strcpy(szNameOfEnum,Stk[Tmp+2]);
                          fprintf(FP_ENU,"%s%s\n","typedef enum _",szNameOfEnum);
                        }
                      strcpy(szNameOfEnum, join(2,SPC,szNameOfEnum));
                    }
                  else
                    {
                      *szNameOfEnum=0;
                      fprintf(FP_ENU,"%s\n","enum");
                    }
                  fprintf(FP_ENU,"%s\n","  {");
                  *Src=0;
                  while(!iMatchLft(Src,"end ")){
                      if(EoF(SourceFile)){
                          Abort("Unbalanced ENUM");
                        }
                      Src[0]=0;
                      fgets(Src, 2048 , SourceFile);
                        if(feof(SourceFile) || (Src[strlen(Src)-1]==10))
                          {
                           Src[strcspn(Src,"\r\n")] = 0;
                          }
                         else
                          {
                            printf("%s%d while reading file: %s\n","Error! - LINE INPUT truncation detected at PROGRAM line: ",__LINE__-7, NamePathFromFP(SourceFile));
                            printf("%s\n","The actual truncated line of text:");
                            printf("%s",Src);
                            exit(1);
                          }
                      LineNum[FileNdx]++;
                      StripCode(Src);
                      if(iMatchLft(Src,"$comme")){
                          int ccc;
                          Docomment(Src,&(ccc));
                          continue;
                        }
                      strcpy(Src,trim(Src));
                      if(ISNULL(Src)){
                          continue;
                        }
                      if(LeftStr(join(2,Src,SPC),"end ",TRUE)){
                          goto L1124;
                        }
                      else
                        {
                          if(EnumFlag==FALSE ){
                              EnumFlag=TRUE;
                            }
                          else
                            {
                              fprintf(FP_ENU,"%s\n",",");
                            }
                        }
                      fprintf(FP_ENU,"%s%s","    ",rtrim(Src));
                    }
L1124:;
                  *Src=0;
                  Ndx=0;
                  fprintf(FP_ENU,"%s\n","");
                  fprintf(FP_ENU,"%s%s%s\n","  }",szNameOfEnum,";\n");
                  return;
                }
              int iEquallLoc=Tmp+2;
              if(strcmp(Stk[iEquallLoc],"=")==0){
                  strcpy(Stk[Tmp],"enum ");
                  InsertTokens(iEquallLoc-1,2,"{",Stk[Tmp+1]);
                  strcpy(Stk[++Ndx],"}");
                  return;
                }
              strcpy(Stk[1],"enum {");
              for(j=2; j<=Ndx; j++)
                {
                  strcpy(Stk[1], join(2,Stk[1],Stk[j]));
                }
              strcpy(Stk[1], join(2,Stk[1],"}"));
              Ndx=1;
              goto L1123;
            }
          if(strcmp(Keyword,"environ$")==0){
              strcpy(Stk[Tmp],"Environ$");
              Use_Environ=Use_BcxTempStr=TRUE;
              goto L1123;
            }
          if(strcmp(Keyword,"exist")==0){
              strcpy(Stk[Tmp],"Exist");
              Use_Exist=Use_Proto=Use_BcxTempStr=TRUE;
              goto L1123;
            }
          if(strcmp(Keyword,"exp")==0){
              strcpy(Stk[Tmp],"Exp");
              Use_Exp=Use_Proto=TRUE;
            }
L1123:;
          goto L1104;
        }
      if(a==6 ){
          if(strcmp(Keyword,"for_each")==0){
              strcpy(Stk[Tmp],"FOR_EACH");
              Use_ForEach=Use_SysMacros=TRUE;
              goto L1126;
            }
          if(strcmp(Keyword,"ff$")==0){
              strcpy(Stk[Tmp],"FF$");
              Use_FF=Use_BcxTempStr=TRUE;
              goto L1126;
            }
          if(strcmp(Keyword,"function")==0){
              if(strcmp(Stk[Tmp+1],"=")==0){
                  if(strcmp(Stk[Tmp+2],DDQ)==0){
                      strcpy(Stk[Tmp+2],"NUL$");
                    }
                  strcpy(Stk[Tmp],"functionreturn");
                }
              else
                {
                  strcpy(Stk[Tmp],"function");
                  if(UseCpp||UseCpphdr ){
                      FuncSubTemplate(Tmp);
                    }
                }
              goto L1126;
            }
          if(strcmp(Keyword,"false")==0){
              strcpy(Stk[Tmp],"FALSE");
              goto L1126;
            }
          if(strcmp(Keyword,"findintype")==0){
              strcpy(Stk[Tmp],"FindInType");
              Use_FindInType=Use_Proto=Use_BCX_stricmp=TRUE;
              char StMem[BCXSTRSIZE];
              char StName[BCXSTRSIZE];
              char VarName[BCXSTRSIZE];
              struct _FUNCPARSE  fp;
              Clear(fp);
              SepFuncArgs(Tmp,&(fp),TRUE);
              strcpy(StMem,remain(Clean(GetArg(2,&(fp))),"."));
              strcpy(VarName,extract(Clean(GetArg(2,&(fp))),"."));
              for(j=fp.CommaPos[1]+1; j<=fp.CommaPos[2]-1; j++)
                {
                  *Stk[j]=0;
                }
              if(CheckLocal(VarName,&(i))!=vt_UNKNOWN ){
                  strcpy(StName,TypeDefs[LocalVars[i].VarDef].VarName);
                }
              else if(CheckGlobal(VarName,&(i))!=vt_UNKNOWN ){
                  strcpy(StName,TypeDefs[GlobalVars[i].VarDef].VarName);
                }
              j=fp.CommaPos[1]+1;
              strcpy(Stk[j], join(9,"(char*)",VarName," + offsetof(",StName,",",StMem,"), sizeof(",StName,")"));
              goto L1126;
            }
          if(strcmp(Keyword,"fillarray")==0){
              strcpy(Stk[Tmp],"fillarray");
              Use_FillArray=TRUE;
              Use_Proto=TRUE;
              goto L1126;
            }
          if(strcmp(Keyword,"findfirst$")==0){
              strcpy(Stk[Tmp],"findfirst$");
              Use_Findfirst=Use_BcxTempStr=TRUE;
              goto L1126;
            }
          if(strcmp(Keyword,"findfirstinstance")==0){
              strcpy(Stk[Tmp],"FindFirstInstance");
              Use_FirstInstance=TRUE;
              goto L1126;
            }
          if(strcmp(Keyword,"findnext$")==0){
              strcpy(Stk[Tmp],"findnext$()");
              Convert2SimpleFunction(Tmp);
              Use_Findnext=Use_BcxTempStr=TRUE;
              goto L1126;
            }
          if(strcmp(Keyword,"fint")==0){
              strcpy(Stk[Tmp],"FINT");
              goto L1126;
            }
          if(strcmp(Keyword,"fix")==0){
              strcpy(Stk[Tmp],"FIX");
              Use_Fix=Use_SysMacros=TRUE;
              goto L1126;
            }
          if(strcmp(Keyword,"filelocked")==0){
              strcpy(Stk[Tmp],"FileLocked");
              Use_FileLocked=Use_Proto=TRUE;
              goto L1126;
            }
          if(strcmp(Keyword,"ftell")==0){
              strcpy(Stk[Tmp],"_ftelli64");
              for(int f=Tmp+1; f<=Ndx; f++)
                {
                  strcpy(Stk[f],RemoveStr(Stk[f],"#"));
                  if(ISNULL(Stk[f])){
                      Abort("Bad or Missing FTELL Argument");
                    }
                  if(DataType(Stk[f])==vt_NUMBER ){
                      strcpy(Stk[f], join(2,"FP",Stk[f]));
                      if(CheckLocal(Stk[f],&(f))==vt_UNKNOWN ){
                          if(CheckGlobal(Stk[f],&(f))==vt_UNKNOWN ){
                              AddGlobal(Stk[f],vt_FILEPTR);
                              goto L1126;
                            }
                        }
                    }
                }
              goto L1126;
            }
          if(strcmp(Keyword,"frac")==0){
              strcpy(Stk[Tmp],"FRAC");
              Use_Fix=Use_Frac=Use_SysMacros=TRUE;
              goto L1126;
            }
          if(strcmp(Keyword,"fracl")==0){
              strcpy(Stk[Tmp],"FRACL");
              Use_Fix=Use_Fracl=Use_SysMacros=TRUE;
              goto L1126;
            }
          if(strcmp(Keyword,"freefile")==0){
              strcpy(Stk[Tmp],"FreeFile()");
              Use_Freefile=Use_Proto=TRUE;
              goto L1126;
            }
          if(strcmp(Keyword,"function")==0){
              if(bcx_stricmp(Stk[2],"main")==0){
                  NoMain=TRUE;
                }
            }
L1126:;
          goto L1104;
        }
      if(a==7 ){
          if(strcmp(Keyword,"getdimension")==0){
              strcpy(Stk[Tmp],"GetDimension");
              Use_GetDimension=Use_Proto=TRUE;
              goto L1129;
            }
          if(strcmp(Keyword,"getobject")==0){
              if(Ndx<7 ){
                  ComSwitchON=TRUE;
                  Use_COM=TRUE;
                  Use_COM_CreateObject=TRUE;
                  Use_COM_DispatchObject=TRUE;
                  Use_COM_GetObject=TRUE;
                  Use_COM_GetProperty=TRUE;
                  Use_COM_InvokeMethod=TRUE;
                  Use_COM_SafeArray=TRUE;
                  Use_COM_SetProperty=TRUE;
                  Use_COM_UsesConversion=TRUE;
                  strcpy(Stk[3],Stk[5]);
                  sprintf(Stk[5],"&%s",Stk[1]);
                  strcpy(Stk[1],"BCX_GetObject");
                  strcpy(Stk[2],"(");
                  strcpy(Stk[4],",");
                }
              goto L1129;
            }
          if(strcmp(Keyword,"getprocaddress")==0){
              char GlobalName[BCXSTRSIZE]={0};
              int s={0};
              ULONGLONG  GlobalNameHash={0};
              char Atemp[BCXSTRSIZE]={0};
              strcpy(GlobalName,Stk[Tmp-2]);
              GlobalNameHash=HashNumber(GlobalName);
              while(GlobalVarHash[GlobalNameHash]){
                  s=GlobalVarHash[GlobalNameHash];
                  struct _VARINFO*  ptGlobal;
                  ptGlobal=&(GlobalVars[s]);
                  if(strcmp(GlobalName,ptGlobal->VarName)==0){
                      strcpy(Atemp,TypeDefs[ptGlobal->VarDef].VarName);
                      if(ptGlobal->VarPntr ){
                          strcat(Atemp," *");
                        }
                    }
                  GlobalNameHash=imod(GlobalNameHash+1,MaxGlobalVars);
                }
              if(Atemp[0]==0 ){
                  char LocalName[BCXSTRSIZE]={0};
                  strcpy(LocalName,Stk[Tmp-2]);
                  if(LocalVarCnt ){
                      for(int yy=1; yy<=LocalVarCnt; yy++)
                        {
                          if(strcmp(LocalName,LocalVars[yy].VarName)==0){
                              strcpy(Atemp,TypeDefs[LocalVars[yy].VarDef].VarName);
                              if(LocalVars[yy].VarPntr ){
                                  strcat(Atemp," *");
                                }
                              goto L1131;
                            }
                        }
L1131:;
                    }
                }
              if(Atemp[0]!=0 ){
                  strcpy(Stk[Tmp], join(3,"(",Atemp,")GetProcAddress"));
                }
              else
                {
                  strcpy(Stk[Tmp],"GetProcAddress");
                }
              goto L1129;
            }
          if(strcmp(Keyword,"getattr")==0){
              strcpy(Stk[Tmp],"GETATTR");
              Use_Getattr=Use_SysMacros=TRUE;
              goto L1129;
            }
          if(strcmp(Keyword,"gethttpfilesize")==0){
              strcpy(Stk[Tmp],"GetHttpFileSize");
              Use_Gethttpfilesize=TRUE;
              goto L1129;
            }
          if(strcmp(Keyword,"gettextsize")==0){
              strcpy(Stk[Tmp],"GetTextSize");
              Use_GetTextSize=Use_Proto=TRUE;
              goto L1129;
            }
          if(strcmp(Keyword,"getc")==0){
              strcpy(Stk[Tmp],"getc");
              strcpy(Stk[Tmp+2],RemoveStr(Stk[Tmp+2],"#"));
              if(DataType(Stk[Tmp+2])==vt_NUMBER ){
                  strcpy(Stk[Tmp+2], join(2,"FP",Stk[Tmp+2]));
                }
              goto L1129;
            }
          if(strcmp(Keyword,"getbmp")==0){
              strcpy(Stk[Tmp],"GetBmp");
              Use_GetBmp=Use_Proto=Use_BcxTempStr=TRUE;
              goto L1129;
            }
          if(strcmp(Keyword,"getdrive")==0){
              strcpy(Stk[Tmp],"_getdrive()");
              Convert2SimpleFunction(Tmp);
              Use_Getdrive=Use_Proto=TRUE;
              goto L1129;
            }
          if(strcmp(Keyword,"getfilename$")==0){
              strcpy(Stk[Tmp],"$$GetFileName$");
              Use_Getfilename=Use_Hook=TRUE;
              goto L1129;
            }
          if(strcmp(Keyword,"getsaveasfilename$")==0){
              strcpy(Stk[Tmp],"GetSaveAsFileName$");
              Use_GetSaveAsFilename=TRUE;
              goto L1129;
            }
          if(strcmp(Keyword,"getresource")==0){
              strcpy(Stk[Tmp],"GetResource");
              Use_GetResource=Use_Proto=TRUE;
              goto L1129;
            }
          if(strcmp(Keyword,"getspecialfolder$")==0  || strcmp(Keyword,"getspecialfolder")==0){
              strcpy(Stk[Tmp],"$$GetSpecialFolder$");
              Use_GetSpecialFolder=TRUE;
              Use_Proto=Use_BcxTempStr=TRUE;
              goto L1129;
            }
          if(strcmp(Keyword,"getspecialfolderex$")==0){
              strcpy(Stk[Tmp],"GetSpecialFolderEx$");
              Use_GetSpecialFolderex=TRUE;
              Use_Proto=Use_BcxTempStr=TRUE;
              Use_WideToAnsi=TRUE;
            }
L1129:;
          goto L1104;
        }
      if(a==8 ){
          if(strcmp(Keyword,"hex$")==0){
              strcpy(Stk[Tmp],"hex$");
              Use_Hex=Use_BcxTempStr=TRUE;
              goto L1132;
            }
          if(strcmp(Keyword,"hex2dec")==0){
              strcpy(Stk[Tmp],"Hex2Dec");
              Use_Hex2Dec=Use_Proto=TRUE;
              goto L1132;
            }
          if(strcmp(Keyword,"hide")==0){
              strcpy(Stk[Tmp],"HIDEHWND");
              Use_Hide=Use_SysMacros=TRUE;
              if(Ndx>=2 && strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
            }
L1132:;
          goto L1104;
        }
      if(a==9 ){
          if(strcmp(Keyword,"icompare")==0){
              strcpy(Stk[Tmp],"bcx_stricmp");
              Use_BCX_stricmp=TRUE;
              goto L1133;
            }
          if(strcmp(Keyword,"instr")==0){
              strcpy(Stk[Tmp],"instr");
              Use_Instr=Use_Proto=TRUE;
              Use_Stristr=Use_UCaseTbl=TRUE;
              goto L1133;
            }
          if(strcmp(Keyword,"iinstr")==0){
              strcpy(Stk[Tmp],"iinstr");
              Use_IInstr=Use_Proto=TRUE;
              Use_Stristr=Use_UCaseTbl=TRUE;
              goto L1133;
            }
          if(strcmp(Keyword,"instrany")==0){
              strcpy(Stk[Tmp],"InstrAny");
              Use_InstrAny=Use_Instr=Use_Proto=TRUE;
              Use_Mid=Use_BcxTempStr=Use_Stristr=Use_UCaseTbl=TRUE;
              goto L1133;
            }
          if(strcmp(Keyword,"iinstrany")==0){
              strcpy(Stk[Tmp],"IInstrAny");
              Use_IInstrAny=Use_IInstr=Use_Proto=TRUE;
              Use_Mid=Use_BcxTempStr=Use_Stristr=Use_UCaseTbl=TRUE;
              goto L1133;
            }
          if(strcmp(Keyword,"inchr")==0){
              strcpy(Stk[Tmp],"inchr");
              Use_Inchr=Use_Proto=TRUE;
              goto L1133;
            }
          if(strcmp(Keyword,"imod")==0){
              strcpy(Stk[Tmp],"imod");
              Use_Imod=Use_SysMacros=TRUE;
              goto L1133;
            }
          if(strcmp(Keyword,"iif")==0){
              strcpy(Stk[Tmp],"iif");
              Use_Iif=Use_Proto=TRUE;
              for(i=Tmp+1; i<=Ndx; i++)
                {
                  if(strcmp(Stk[i],"=")==0){
                      if(strcmp(Stk[i-1],"<")!=0  && strcmp(Stk[i-1],">")!=0){
                          strcpy(Stk[i],"==");
                        }
                    }
                }
              goto L1133;
            }
          if(strcmp(Keyword,"iif$")==0){
              strcpy(Stk[Tmp],"sziif$");
              Use_sziif=Use_Proto=TRUE;
              for(i=Tmp+1; i<=Ndx; i++)
                {
                  if(strcmp(Stk[i],"=")==0){
                      if(strcmp(Stk[i-1],"<")!=0  && strcmp(Stk[i-1],">")!=0){
                          strcpy(Stk[i],"==");
                        }
                    }
                }
              goto L1133;
            }
          if(strcmp(Keyword,"initsafearray")==0){
              strcpy(Stk[Tmp],"InitSafeArray");
              Use_SafeArrays=TRUE;
              strcpy(Stk[Tmp+2], join(2,"&",Stk[Tmp+2]));
              goto L1133;
            }
          if(strcmp(Keyword,"inkey")==0){
              Use_BcxTempStr=Use_Proto=Use_InkeyD=TRUE;
              strcpy(Stk[Tmp],"inkeyd()");
              Convert2SimpleFunction(Tmp);
              goto L1133;
            }
          if(strcmp(Keyword,"inkey$")==0){
              Use_BcxTempStr=Use_Proto=Use_Inkey=TRUE;
              strcpy(Stk[Tmp],"inkey$()");
              Convert2SimpleFunction(Tmp);
              goto L1133;
            }
          if(strcmp(Keyword,"inline")==0){
              if(Tmp==1 ){
                  *Stk[1]=0;
                  UseInLine=TRUE;
                  RemEmptyTokens();
                  Tmp--;
                }
              goto L1133;
            }
          if(strcmp(Keyword,"inputbox$")==0){
              strcpy(Stk[Tmp],"InputBox$");
              Use_BoxCommon=Use_Inputbox=Use_BcxTempStr=TRUE;
              goto L1133;
            }
          if(strcmp(Keyword,"infobox")==0){
              strcpy(Stk[Tmp],"InfoBox");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_BoxCommon=Use_Infobox=Use_BcxTempStr=TRUE;
              goto L1133;
            }
          if(strcmp(Keyword,"ins$")==0){
              strcpy(Stk[Tmp],"ins$");
              Use_Ins=Use_Proto=Use_BcxTempStr=TRUE;
              goto L1133;
            }
          if(strcmp(Keyword,"instrrev")==0){
              strcpy(Stk[Tmp],"InstrRev");
              Use_Instrrev=Use_Proto=TRUE;
              goto L1133;
            }
          if(strcmp(Keyword,"isodate$")==0){
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  strcpy(Stk[Tmp],"isodate$()");
                }
              else
                {
                  strcpy(Stk[Tmp],"isodate$");
                }
              Use_IsoDate=Use_BcxTempStr=TRUE;
              goto L1133;
            }
          if(strcmp(Keyword,"isptr")==0){
              strcpy(Stk[Tmp],"IsPtr");
              Use_Isptr=Use_SysMacros=TRUE;
              goto L1133;
            }
          if(strcmp(Keyword,"istrue")==0){
              strcpy(Stk[Tmp],"ISTRUE");
              Use_Istrue=Use_SysMacros=TRUE;
              goto L1133;
            }
          if(strcmp(Keyword,"isfalse")==0){
              strcpy(Stk[Tmp],"ISFALSE");
              Use_Isfalse=Use_SysMacros=TRUE;
              goto L1133;
            }
          if(strcmp(Keyword,"iszero")==0){
              strcpy(Stk[Tmp],"ISZERO");
              Use_Iszero=Use_SysMacros=TRUE;
              goto L1133;
            }
          if(strcmp(Keyword,"isnull")==0){
              strcpy(Stk[Tmp],"ISNULL");
              Use_Isnull=Use_SysMacros=TRUE;
              goto L1133;
            }
          if(strcmp(Keyword,"issystem")==0){
              strcpy(Stk[Tmp],"issystem");
              Use_Issystem=Use_BcxTempStr=TRUE;
              goto L1133;
            }
          if(strcmp(Keyword,"ishidden")==0){
              strcpy(Stk[Tmp],"ishidden");
              Use_Ishidden=Use_BcxTempStr=TRUE;
              goto L1133;
            }
          if(strcmp(Keyword,"isreadonly")==0){
              strcpy(Stk[Tmp],"isreadonly");
              Use_Isreadonly=Use_BcxTempStr=TRUE;
              goto L1133;
            }
          if(strcmp(Keyword,"isfile")==0){
              strcpy(Stk[Tmp],"isfile");
              Use_Isfile=Use_BcxTempStr=TRUE;
              goto L1133;
            }
          if(strcmp(Keyword,"isfolder")==0){
              strcpy(Stk[Tmp],"isfolder");
              Use_Isfolder=Use_BcxTempStr=TRUE;
              goto L1133;
            }
          if(strcmp(Keyword,"ireplace$")==0){
              strcpy(Stk[Tmp],"iReplace$");
              Use_iReplace=Use_Stristr=Use_BcxTempStr=TRUE;
              Use_UCaseTbl=TRUE;
              goto L1133;
            }
          if(strcmp(Keyword,"ireplaceany$")==0){
              strcpy(Stk[Tmp],"IReplaceAny$");
              Use_IReplaceAny=Use_BcxTempStr=TRUE;
              goto L1133;
            }
          if(strcmp(Keyword,"iremove$")==0){
              strcpy(Stk[Tmp],"IRemoveStr$");
              Use_IRemove=Use_BcxTempStr=TRUE;
              Use_Stristr=Use_UCaseTbl=TRUE;
              goto L1133;
            }
          if(strcmp(Keyword,"iremoveany$")==0){
              strcpy(Stk[Tmp],"IRemoveAny$");
              Use_IRemoveAny=Use_BcxTempStr=TRUE;
            }
L1133:;
          goto L1104;
        }
      if(a==10 ){
          if(strcmp(Keyword,"join$")==0){
              strcpy(Stk[Tmp],"$$join$");
              Use_Join=Use_BcxTempStr=TRUE;
            }
          goto L1104;
        }
      if(a==11 ){
          if(strcmp(Keyword,"keypress")==0){
              strcpy(Stk[Tmp],"keypress()");
              Convert2SimpleFunction(Tmp);
              Use_Keypress=Use_Proto=TRUE;
            }
          goto L1104;
        }
      if(a==12 ){
          if(strcmp(Keyword,"land")==0){
              strcpy(Stk[Tmp]," &&");
              goto L1138;
            }
          if(strcmp(Keyword,"lor")==0){
              strcpy(Stk[Tmp]," ||");
              goto L1138;
            }
          if(strcmp(Keyword,"local")==0){
              if(iMatchWrd(Stk[Tmp+1],"dynamic")){
                  strcpy(Stk[Tmp],"dim");
                }
              goto L1138;
            }
          if(strcmp(Keyword,"lccpath$")==0){
              strcpy(Stk[Tmp],"LccPath$()");
              Convert2SimpleFunction(Tmp);
              Use_LccPath=Use_RegString=Use_Instrrev=TRUE;
              Use_Left=Use_BcxTempStr=TRUE;
              goto L1138;
            }
          if(strcmp(Keyword,"loadfile$")==0){
              strcpy(Stk[Tmp],"$$LoadFile$");
              Use_LoadFile=Use_Get=Use_BcxTempStr=TRUE;
              Use_SysMacros=Use_Exist=Use_Lof=TRUE;
              goto L1138;
            }
          if(strcmp(Keyword,"listboxloadfile")==0){
              strcpy(Stk[Tmp],"ListBoxLoadFile");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_ListBoxLoadFile=TRUE;
              Use_GetTextSize=TRUE;
              Use_Proto=TRUE;
              Use_Trim=TRUE;
              Use_String=TRUE;
              Use_BcxTempStr=TRUE;
              Use_Eof=TRUE;
              goto L1138;
            }
          if(strcmp(Keyword,"lf$")==0){
              strcpy(Stk[Tmp],"LF$");
              Use_LF=Use_BcxTempStr=TRUE;
              goto L1138;
            }
          if(strcmp(Keyword,"line")==0){
              if(iMatchWrd(Stk[Tmp+1],"input")){
                  strcpy(Stk[Tmp],"lineinput");
                  j=Tmp+4;
                  *Stk[Tmp+1]=0;
                  for(i=Tmp+2; i<=Ndx; i++)
                    {
                      if(*Stk[i]==44 ){
                          j=i+1;
                          goto L1139;
                        }
                      strcpy(Stk[Tmp+1], join(2,Stk[Tmp+1],Stk[i]));
                      *Stk[i]=0;
                    }
L1139:;
                  for(i=j; i<=Ndx; i++)
                    {
                      strcpy(Stk[Tmp+2], join(2,Stk[Tmp+2],Stk[i]));
                    }
                }
              goto L1138;
            }
          if(strcmp(Keyword,"lcase$")==0){
              if(iSubLoc==2 ){
                  if(strcmp(Stk[Tmp+1],"(")==0){
                      Abort("'lcase' can only be used as a Function Pointer when in a SET");
                    }
                  strcpy(Stk[Tmp],"lcase");
                }
              else
                {
                  strcpy(Stk[Tmp],"$$lcase$");
                }
              Use_Lcase=Use_BcxTempStr=TRUE;
              goto L1138;
            }
          if(strcmp(Keyword,"ldouble")==0){
              strcpy(Stk[Tmp],"LDOUBLE");
              Use_Ldouble=Use_BcxTempStr=TRUE;
              goto L1138;
            }
          if(strcmp(Keyword,"left$")==0){
              strcpy(Stk[Tmp],"$$left$");
              Use_Left=Use_BcxTempStr=TRUE;
              goto L1138;
            }
          if(strcmp(Keyword,"leftstr")==0){
              strcpy(Stk[Tmp],"LeftStr");
              Use_LeftStr=Use_Left=Use_Lcase=Use_BcxTempStr=TRUE;
              goto L1138;
            }
          if(strcmp(Keyword,"lprint")==0){
              strcpy(Stk[Tmp],"lprint");
              if(Tmp==Ndx ){
                  Ndx++;
                  strcpy(Stk[Ndx],enc(""));
                }
              goto L1138;
            }
          if(strcmp(Keyword,"lpad$")==0){
              strcpy(Stk[Tmp],"$$lpad$");
              Use_Lpad=Use_BcxTempStr=TRUE;
              goto L1138;
            }
          if(strcmp(Keyword,"ltrim$")==0){
              strcpy(Stk[Tmp],"$$ltrim$");
              Use_Ltrim=Use_BcxTempStr=TRUE;
              goto L1138;
            }
          if(strcmp(Keyword,"lof")==0){
              strcpy(Stk[Tmp],"lof");
              Use_Lof=Use_Proto=TRUE;
              goto L1138;
            }
          if(strcmp(Keyword,"like")==0){
              strcpy(Stk[Tmp],"like");
              Use_Like=Use_Proto=TRUE;
              goto L1138;
            }
          if(strcmp(Keyword,"lclick")==0){
              strcpy(Stk[Tmp],"lClick()");
              Convert2SimpleFunction(Tmp);
              Use_Lclick=Use_Proto=TRUE;
              goto L1138;
            }
          if(strcmp(Keyword,"like_instr")==0){
              strcpy(Stk[Tmp],"Like_Instr");
              Use_Like_Instr=Use_Ucase=Use_BcxTempStr=Use_Proto=Use_Mid=TRUE;
              goto L1138;
            }
          if(strcmp(Keyword,"loc")==0){
              int Tmp2=Tmp+2;
              if(DataType(Stk[Tmp2])==vt_NUMBER ){
                  strcpy(Stk[Tmp2], join(2,"FP",Stk[Tmp2]));
                }
              strcpy(Stk[Tmp2],RemoveStr(Stk[Tmp2],"#"));
              strcpy(Stk[Tmp], join(5,"loc(",Stk[Tmp2],",",Stk[Tmp2],"len)"));
              *Stk[Tmp+1]=0;
              *Stk[Tmp2]=0;
              *Stk[Tmp+3]=0;
              Use_Loc=TRUE;
              goto L1138;
            }
          if(strcmp(Keyword,"locate")==0){
              strcpy(Stk[Tmp],"locate");
              Use_Locate=Use_Console=Use_Proto=Use_Cursor=TRUE;
              goto L1138;
            }
          if(strcmp(Keyword,"longestline")==0){
              strcpy(Stk[Tmp],"LongestLine");
              Use_Longestline=Use_Eof=Use_Proto=TRUE;
              goto L1138;
            }
          if(strcmp(Keyword,"lookahead$")==0){
              strcpy(Stk[Tmp],"LookAhead$");
              strcpy(Stk[Tmp+2],RemoveStr(Stk[Tmp+2],"#"));
              if(DataType(Stk[Tmp+2])==vt_NUMBER ){
                  strcpy(Stk[Tmp+2], join(2,"FP",Stk[Tmp+2]));
                }
              Use_Lookahead=Use_NamePathFromFP=Use_Eof=Use_Proto=Use_BcxTempStr=TRUE;
            }
L1138:;
          goto L1104;
        }
      if(a==13 ){
          if(strcmp(Keyword,"makebmp")==0){
              strcpy(Stk[Tmp],"MakeBmp");
              Use_Makebmp=Use_Proto=TRUE;
              goto L1141;
            }
          if(strcmp(Keyword,"makehdc")==0){
              strcpy(Stk[Tmp],"MakeHdc");
              Use_Makehdc=Use_Proto=TRUE;
              goto L1141;
            }
          if(strcmp(Keyword,"me")==0){
              strcpy(Stk[Tmp],"Me");
              int Tmp1=Tmp+1;
              if(*Stk[Tmp1]==46 ){
                  if(InFunction ){
                      strcpy(Stk[Tmp1], join(2,"->",mid(Stk[Tmp1],2)));
                    }
                }
              goto L1141;
            }
          if(strcmp(Keyword,"mkd$")==0){
              if(Tmp>2 ){
                  if(inchr(Stk[Tmp-2],"$")&&*Stk[Tmp-1]==61 ){
                      strcpy(Stk[1], join(2,"memcpy(",Stk[1]));
                      strcpy(Stk[Tmp-1],",");
                      strcpy(Stk[++Ndx],",9)");
                    }
                }
              strcpy(Stk[Tmp],"MKD");
              Use_Mkd=Use_BcxTempStr=TRUE;
              goto L1141;
            }
          if(strcmp(Keyword,"mki$")==0){
              if(Tmp>2 ){
                  if(inchr(Stk[Tmp-2],"$")&&*Stk[Tmp-1]==61 ){
                      strcpy(Stk[1], join(2,"memcpy(",Stk[1]));
                      strcpy(Stk[Tmp-1],",");
                      strcpy(Stk[++Ndx],",3)");
                    }
                }
              strcpy(Stk[Tmp],"MKI");
              Use_Mki=Use_BcxTempStr=TRUE;
              goto L1141;
            }
          if(strcmp(Keyword,"mkl$")==0){
              if(Tmp>2 ){
                  if(inchr(Stk[Tmp-2],"$")&&*Stk[Tmp-1]==61 ){
                      strcpy(Stk[1], join(2,"memcpy(",Stk[1]));
                      strcpy(Stk[Tmp-1],",");
                      strcpy(Stk[++Ndx],",5)");
                    }
                }
              strcpy(Stk[Tmp],"MKL");
              Use_Mkl=Use_BcxTempStr=TRUE;
              goto L1141;
            }
          if(strcmp(Keyword,"mkld$")==0){
              if(Tmp>2 ){
                  if(inchr(Stk[Tmp-2],"$")&&*Stk[Tmp-1]==61 ){
                      strcpy(Stk[1], join(2,"memcpy(",Stk[1]));
                      strcpy(Stk[Tmp-1],",");
                      strcpy(Stk[++Ndx],",11)");
                    }
                }
              strcpy(Stk[Tmp],"MKLD");
              Use_Mkld=Use_BcxTempStr=TRUE;
              goto L1141;
            }
          if(strcmp(Keyword,"mks$")==0){
              if(Tmp>2 ){
                  if(inchr(Stk[Tmp-2],"$")&&*Stk[Tmp-1]==61 ){
                      strcpy(Stk[1], join(2,"memcpy(",Stk[1]));
                      strcpy(Stk[Tmp-1],",");
                      strcpy(Stk[++Ndx],",5)");
                    }
                }
              strcpy(Stk[Tmp],"MKS");
              Use_Mks=Use_BcxTempStr=TRUE;
              goto L1141;
            }
          if(strcmp(Keyword,"mid$")==0){
              if(Tmp>1 ){
                  strcpy(Stk[Tmp],"$$mid$");
                  Use_Mid=Use_BcxTempStr=TRUE;
                }
              else
                {
                  strcpy(Stk[Tmp],"midstr");
                  Use_Midstr=TRUE;
                }
              goto L1141;
            }
          if(strcmp(Keyword,"min")==0){
              strcpy(Stk[Tmp],"MIN");
              Use_Min=Use_Proto=TRUE;
              goto L1141;
            }
          if(strcmp(Keyword,"max")==0){
              strcpy(Stk[Tmp],"MAX");
              Use_Max=Use_Proto=TRUE;
              goto L1141;
            }
          if(strcmp(Keyword,"mcase$")==0){
              if(iSubLoc==2 ){
                  if(strcmp(Stk[Tmp+1],"(")==0){
                      Abort("'mcase' can only be used as a Function Pointer when in a SET");
                    }
                  strcpy(Stk[Tmp],"mcase");
                }
              else
                {
                  strcpy(Stk[Tmp],"$$mcase$");
                }
              Use_Mcase=Use_BcxTempStr=TRUE;
              goto L1141;
            }
          if(strcmp(Keyword,"mkpath")==0){
              strcpy(Stk[Tmp],"MkPath");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Mkpath=Use_Chr=Use_Instr=Use_Mid=TRUE;
              Use_Join=Use_Split=Use_Replace=Use_UCaseTbl=TRUE;
              Use_Proto=Use_Remove=Use_BcxTempStr=Use_Stristr=TRUE;
              goto L1141;
            }
          if(strcmp(Keyword,"modstyle")==0){
              strcpy(Stk[Tmp],"ModStyle");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Modstyle=Use_Proto=TRUE;
              goto L1141;
            }
          if(strcmp(Keyword,"mouse_sx")==0){
              strcpy(Stk[Tmp],"MOUSE_SX");
              Use_Mouse_sx=Use_Proto=TRUE;
              goto L1141;
            }
          if(strcmp(Keyword,"mouse_sy")==0){
              strcpy(Stk[Tmp],"MOUSE_SY");
              Use_Mouse_sy=Use_Proto=TRUE;
              goto L1141;
            }
          if(strcmp(Keyword,"mouse_cx")==0){
              strcpy(Stk[Tmp],"MOUSE_CX");
              Use_Mouse_cx=Use_Proto=TRUE;
              goto L1141;
            }
          if(strcmp(Keyword,"mouse_cy")==0){
              strcpy(Stk[Tmp],"MOUSE_CY");
              Use_Mouse_cy=Use_Proto=TRUE;
              goto L1141;
            }
          if(strcmp(Keyword,"msgbox")==0){
              int Tmm1=Tmp-1;
              if(strcmp(Stk[Tmm1],"=")==0  || iMatchWrd(Stk[Tmm1],"if")||iMatchWrd(Stk[Tmm1],"elseif")){
                  strcpy(Stk[Tmp],"MsgBox");
                  Use_Msgbox=Use_Proto=TRUE;
                }
            }
L1141:;
          goto L1104;
        }
      if(a==14 ){
          if(strcmp(Keyword,"next_each")==0){
              Use_ForEach=Use_SysMacros=TRUE;
              strcpy(Stk[Tmp],"NEXT_EACH");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  goto L1142;
                }
              Tmp++;
              for(;;)
                {
                  if(Tmp>Ndx ){
                      goto L1143;
                    }
                  *Stk[Tmp]=0;
                  Tmp++;
                }
L1143:;
              goto L1142;
            }
          if(strcmp(Keyword,"new")==0){
              if(iMatchWrd(Stk[Tmp-1],"binary")){
                  goto L1142;
                }
              UseCpp=TRUE;
              strcpy(Stk[Tmp],"new ");
              goto L1142;
            }
          if(strcmp(Keyword,"newbmp")==0){
              strcpy(Stk[Tmp],"NewBmp()");
              Use_Newbmp=Use_Proto=TRUE;
              goto L1142;
            }
          if(strcmp(Keyword,"nextlinelen")==0){
              strcpy(Stk[Tmp],"NextLineLen");
              Use_Nextlinelen=Use_Proto=TRUE;
              goto L1142;
            }
          if(strcmp(Keyword,"nothing")==0){
              ComSwitchON=Use_COM=TRUE;
              char sObj[BCXSTRSIZE];
              int ii=2;
              strcpy(sObj, join(2,"&",Stk[1]));
              while(strcmp(Stk[ii],"=")!=0){
                  strcat(sObj,Stk[ii]);
                  ii++;
                }
              strcpy(Stk[1],"BCX_SetNothing");
              strcpy(Stk[2],"(");
              strcpy(Stk[3],sObj);
              strcpy(Stk[4],")");
              Ndx=4;
              goto L1142;
            }
          if(strcmp(Keyword,"notzero")==0){
              strcpy(Stk[Tmp],"NOTZERO");
              Use_Notzero=Use_SysMacros=TRUE;
              goto L1142;
            }
          if(strcmp(Keyword,"notnull")==0){
              strcpy(Stk[Tmp],"NOTNULL");
              Use_Notnull=Use_SysMacros=TRUE;
              goto L1142;
            }
          if(strcmp(Keyword,"notequalto")==0){
              strcpy(Stk[Tmp]," NotEqualTo ");
              Use_NotEqualTo=Use_SysMacros=TRUE;
              goto L1142;
            }
          if(strcmp(Keyword,"nul$")==0){
              strcpy(Stk[Tmp],"NUL$");
              Use_NUL=Use_BcxTempStr=TRUE;
              goto L1142;
            }
          if(strcmp(Keyword,"now$")==0){
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  strcpy(Stk[Tmp],"now$()");
                }
              else
                {
                  strcpy(Stk[Tmp],"now$");
                }
              Use_Now=Use_BcxTempStr=TRUE;
            }
L1142:;
          goto L1104;
        }
      if(a==15 ){
          if(strcmp(Keyword,"object")==0){
              ComSwitchON=Use_COM=Use_BcxTempStr=TRUE;
              strcpy(Stk[Tmp],"OBJECT");
              goto L1145;
            }
          if(strcmp(Keyword,"open")==0){
              for(A=Tmp+1; A<=Ndx; A++)
                {
                  if(*Stk[A]==35 ){
                      strcpy(Stk[A],mid(Stk[A],2));
                      goto L1146;
                    }
                }
L1146:;
              goto L1145;
            }
          if(strcmp(Keyword,"oct$")==0){
              strcpy(Stk[Tmp],"oct$");
              Use_Oct=Use_BcxTempStr=TRUE;
              goto L1145;
            }
          if(strcmp(Keyword,"or")==0  || strcmp(Keyword,"orelse")==0){
              strcpy(Stk[Tmp]," || ");
              goto L1145;
            }
          if(strcmp(Keyword,"osversion")==0){
              strcpy(Stk[Tmp],"OSVersion()");
              Convert2SimpleFunction(Tmp);
              Emit_OSVersionEnum();
              Use_OSVersion=Use_Proto=TRUE;
            }
L1145:;
          goto L1104;
        }
      if(a==16 ){
          if(strcmp(Keyword,"pellespath$")==0){
              strcpy(Stk[Tmp],"PellesPath$()");
              Convert2SimpleFunction(Tmp);
              Use_PellesPath=Use_RegString=Use_Instrrev=TRUE;
              Use_Left=Use_BcxTempStr=TRUE;
              goto L1147;
            }
          if(strcmp(Keyword,"putc")==0){
              strcpy(Stk[Tmp],"putc");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              strcpy(Stk[Tmp+2],RemoveStr(Stk[Tmp+2],"#"));
              if(DataType(Stk[Tmp+2])==vt_NUMBER ){
                  strcpy(Stk[Tmp+2], join(2,"FP",Stk[Tmp+2]));
                }
              char fp[BCXSTRSIZE]={0};
              strcpy(fp,Stk[Tmp+2]);
              LShiftStk(Tmp+2);
              LShiftStk(Tmp+2);
              strcpy(Stk[Ndx],",");
              Ndx++;
              strcpy(Stk[Ndx],fp);
              Ndx++;
              strcpy(Stk[Ndx],")");
              goto L1147;
            }
          if(strcmp(Keyword,"printer")==0){
              int Tmp1=Tmp+1;
              if(*Stk[Tmp1]){
                  if(iMatchWrd(Stk[Tmp1],"open")){
                      strcpy(Stk[Tmp],"printeropen");
                    }
                  if(iMatchWrd(Stk[Tmp1],"ejectpage")){
                      strcpy(Stk[Tmp],"ejectpage");
                    }
                  if(iMatchWrd(Stk[Tmp1],"close")){
                      strcpy(Stk[Tmp],"printerclose");
                    }
                  if(iMatchWrd(Stk[Tmp],"printer")){
                      Abort(join(3,"Unknown word '",Stk[Tmp1],"' with printer"));
                    }
                  LShiftStk(Tmp1);
                }
              else
                {
                  Ndx=0;
                }
              Use_Printer=Use_Proto=TRUE;
              iEmitVarGroup=iEmitVarGroup|ePrinterGroup;
              Use_Mid=Use_Left=TRUE;
              Use_Extract=Use_Str=Use_BcxTempStr=TRUE;
              goto L1147;
            }
          if(strcmp(Keyword,"print")==0){
              if(*Stk[Tmp+1]==35 ){
                  strcpy(Stk[Tmp],"fprint");
                  strcpy(Stk[Tmp+1],mid(Stk[Tmp+1],2));
                }
              goto L1147;
            }
          if(strcmp(Keyword,"ptr")==0){
              strcpy(Stk[Tmp-1], join(2,Stk[Tmp-1],"*"));
              *Stk[Tmp]=0;
              if(Tmp==Ndx ){
                  Ndx--;
                  while(tally(Stk[Ndx],"*")==(int)strlen(Stk[Ndx])){
                      strcpy(Stk[Ndx-1], join(2,Stk[Ndx-1],Stk[Ndx]));
                      *Stk[Ndx]=0;
                      Ndx--;
                    }
                }
              else
                {
                  i=Tmp-1;
                  while(tally(Stk[i],"*")==(int)strlen(Stk[i])){
                      strcpy(Stk[i-1], join(2,Stk[i-1],Stk[i]));
                      *Stk[i--]=0;
                    }
                }
              goto L1147;
            }
          if(strcmp(Keyword,"panel")==0){
              strcpy(Stk[Tmp],"panel");
              Use_Panel=Use_Console=Use_Proto=Use_Cursor=TRUE;
              goto L1147;
            }
          if(strcmp(Keyword,"pause")==0){
              strcpy(Stk[Tmp],"Pause()");
              Convert2SimpleFunction(Tmp);
              Use_Pause=Use_Proto=TRUE;
              goto L1147;
            }
          if(strcmp(Keyword,"peek$")==0){
              strcpy(Stk[Tmp],"$$peekstr$");
              Use_PeekStr=Use_BcxTempStr=TRUE;
              goto L1147;
            }
          if(strcmp(Keyword,"pi")==0){
              strcpy(Stk[Tmp],"3.141592653589793");
              goto L1147;
            }
          if(strcmp(Keyword,"playwav")==0){
              strcpy(Stk[Tmp],"PlayWav");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_PlayWav=Use_GetResource=Use_Proto=TRUE;
              goto L1147;
            }
          if(strcmp(Keyword,"pos")==0){
              strcpy(Stk[Tmp],"Pos()");
              Use_Pos=Use_Proto=TRUE;
              goto L1147;
            }
          if(strcmp(Keyword,"pushcolors")==0){
              strcpy(Stk[Tmp],"PushColors()");
              Use_PushPopColors=Use_Color=Use_Console=Use_Proto=TRUE;
              goto L1147;
            }
          if(strcmp(Keyword,"popcolors")==0){
              strcpy(Stk[Tmp],"PopColors()");
              Use_PushPopColors=Use_Color=Use_Console=Use_Proto=TRUE;
              goto L1147;
            }
          if(strcmp(Keyword,"private")==0){
              if(iMatchWrd(Stk[Tmp+1],"const")){
                  strcpy(Stk[Tmp],"enum ");
                  strcpy(Stk[Tmp+1], join(2,Stk[Tmp+2],"{"));
                  Ndx++;
                  strcpy(Stk[Ndx],"}");
                }
              else
                {
                  strcpy(Stk[1],"private");
                }
            }
L1147:;
          goto L1104;
        }
      if(a==17 ){
          if(strcmp(Keyword,"qbcolor")==0){
              strcpy(Stk[Tmp],"qbcolor");
              Use_QBColor=Use_Proto=TRUE;
            }
          goto L1104;
        }
      if(a==18 ){
          if(strcmp(Keyword,"rgb")==0){
              strcpy(Stk[Tmp],"RGB");
              goto L1151;
            }
          if(strcmp(Keyword,"read")==0){
              strcpy(Stk[Tmp],"READNUM");
              Use_Readnum=Use_SysMacros=Use_Proto=TRUE;
              goto L1151;
            }
          if(strcmp(Keyword,"read$")==0){
              strcpy(Stk[Tmp],"READ$");
              Use_Read=Use_SysMacros=Use_Proto=TRUE;
              goto L1151;
            }
          if(strcmp(Keyword,"rewind")==0){
              strcpy(Stk[Tmp],"rewind");
              int Tmp2=Tmp+2;
              if(DataType(Stk[Tmp2])==vt_NUMBER ){
                  strcpy(Stk[Tmp2], join(2,"FP",Stk[Tmp2]));
                }
              goto L1151;
            }
          if(strcmp(Keyword,"remove$")==0){
              strcpy(Stk[Tmp],"$$RemoveStr$");
              Use_Remove=Use_BcxTempStr=TRUE;
              goto L1151;
            }
          if(strcmp(Keyword,"replace$")==0){
              strcpy(Stk[Tmp],"$$replace$");
              Use_Replace=Use_BcxTempStr=TRUE;
              goto L1151;
            }
          if(strcmp(Keyword,"replaceany$")==0){
              strcpy(Stk[Tmp],"ReplaceAny$");
              Use_ReplaceAny=Use_BcxTempStr=TRUE;
              goto L1151;
            }
          if(strcmp(Keyword,"removeany$")==0){
              strcpy(Stk[Tmp],"RemoveAny$");
              Use_RemoveAny=Use_BcxTempStr=TRUE;
              goto L1151;
            }
          if(strcmp(Keyword,"right$")==0){
              strcpy(Stk[Tmp],"$$right$");
              Use_Right=Use_BcxTempStr=TRUE;
              goto L1151;
            }
          if(strcmp(Keyword,"rightstr")==0){
              strcpy(Stk[Tmp],"RightStr");
              Use_RightStr=Use_Right=Use_Lcase=Use_BcxTempStr=TRUE;
              goto L1151;
            }
          if(strcmp(Keyword,"rclick")==0){
              strcpy(Stk[Tmp],"rClick()");
              Convert2SimpleFunction(Tmp);
              Use_Rclick=Use_Proto=TRUE;
              goto L1151;
            }
          if(strcmp(Keyword,"randomize")==0){
              strcpy(Stk[Tmp],"randomize");
              Use_Randomize=TRUE;
              Use_Proto=TRUE;
              if(Ndx==1 ){
                  Use_Timer=TRUE;
                  strcpy(Stk[1],"randomize(timer())");
                }
              if(Ndx==2 && strcmp(Stk[2],"timer")==0){
                  Use_Timer=TRUE;
                  Ndx=1;
                  strcpy(Stk[1],"randomize(timer())");
                }
              if(Ndx>=2 && strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              goto L1151;
            }
          if(strcmp(Keyword,"rec")==0){
              int Tmp2=Tmp+2;
              if(DataType(Stk[Tmp2])==vt_NUMBER ){
                  strcpy(Stk[Tmp2], join(2,"FP",Stk[Tmp2]));
                }
              strcpy(Stk[Tmp2],RemoveStr(Stk[Tmp2],"#"));
              strcpy(Stk[Tmp], join(5,"rec(",Stk[Tmp2],",",Stk[Tmp2],"len)"));
              *Stk[Tmp+1]=0;
              *Stk[Tmp2]=0;
              *Stk[Tmp+3]=0;
              Use_Rec=Use_Proto=TRUE;
              goto L1151;
            }
          if(strcmp(Keyword,"reccount")==0){
              char length[BCXSTRSIZE];
              int Tmp2=Tmp+2;
              if(DataType(Stk[Tmp2])==vt_NUMBER ){
                  strcpy(Stk[Tmp2], join(2,"FP",Stk[Tmp2]));
                }
              strcpy(Stk[Tmp2],RemoveStr(Stk[Tmp2],"#"));
              strcpy(Stk[Tmp],"reccount");
              strcpy(length, join(2,Stk[Tmp2],"len)"));
              for(i=Tmp+1; i<=Ndx; i++)
                {
                  if(*Stk[i]==41 ){
                      *Stk[i]=0;
                      goto L1152;
                    }
                  strcpy(Stk[Tmp], join(2,Stk[Tmp],Stk[i]));
                  *Stk[i]=0;
                }
L1152:;
              strcpy(Stk[Tmp], join(3,Stk[Tmp],",",length));
              Use_RecCount=Use_Proto=TRUE;
              goto L1151;
            }
          if(strcmp(Keyword,"refresh")==0){
              strcpy(Stk[Tmp],"Refresh");
              Use_Refresh=Use_SysMacros=TRUE;
              goto L1151;
            }
          if(strcmp(Keyword,"radtodeg")==0){
              strcpy(Stk[Tmp],"RadToDeg");
              Use_RadToDeg=Use_SysMacros=TRUE;
              goto L1151;
            }
          if(strcmp(Keyword,"regstring$")==0){
              strcpy(Stk[Tmp],"$$RegString$");
              Convert2SimpleFunction(Tmp);
              Use_RegString=Use_BcxTempStr=TRUE;
              goto L1151;
            }
          if(strcmp(Keyword,"regexist")==0){
              strcpy(Stk[Tmp],"RegExist");
              Convert2SimpleFunction(Tmp);
              Use_RegExist=Use_BcxTempStr=TRUE;
              goto L1151;
            }
          if(strcmp(Keyword,"regint")==0){
              strcpy(Stk[Tmp],"RegInt");
              Convert2SimpleFunction(Tmp);
              Use_RegInt=Use_BcxTempStr=TRUE;
              goto L1151;
            }
          if(strcmp(Keyword,"remain$")==0){
              strcpy(Stk[Tmp],"$$remain$");
              Use_Remain=Use_BcxTempStr=TRUE;
              goto L1151;
            }
          if(strcmp(Keyword,"retain$")==0){
              strcpy(Stk[Tmp],"$$Retain$");
              Use_Retain=Use_BcxTempStr=TRUE;
              goto L1151;
            }
          if(strcmp(Keyword,"repeat$")==0){
              strcpy(Stk[Tmp],"$$repeat$");
              Use_Repeat=Use_BcxTempStr=TRUE;
              goto L1151;
            }
          if(strcmp(Keyword,"reverse$")==0){
              strcpy(Stk[Tmp],"$$reverse$");
              Use_Reverse=Use_BcxTempStr=TRUE;
              goto L1151;
            }
          if(strcmp(Keyword,"rnd")==0){
              strcpy(Stk[Tmp],"rnd()");
              Convert2SimpleFunction(Tmp);
              Use_Rnd=Use_Proto=TRUE;
              goto L1151;
            }
          if(strcmp(Keyword,"rnd2")==0){
              strcpy(Stk[Tmp],"rnd2");
              Use_Rnd2=Use_Proto=TRUE;
              goto L1151;
            }
          if(strcmp(Keyword,"round")==0){
              strcpy(Stk[Tmp],"Round");
              Use_Round=Use_Proto=TRUE;
              goto L1151;
            }
          if(strcmp(Keyword,"rpad$")==0){
              strcpy(Stk[Tmp],"$$rpad$");
              Use_Rpad=Use_BcxTempStr=TRUE;
              goto L1151;
            }
          if(strcmp(Keyword,"rtrim$")==0){
              strcpy(Stk[Tmp],"$$rtrim$");
              Use_Rtrim=Use_BcxTempStr=TRUE;
              goto L1151;
            }
          if(strcmp(Keyword,"run")==0){
              strcpy(Stk[Tmp],"Run");
              Use_Run=Use_Proto=TRUE;
            }
L1151:;
          goto L1104;
        }
      if(a==19 ){
          if(strcmp(Keyword,"setdimension")==0){
              strcpy(Stk[Tmp],"SetDimension");
              Use_SetDimension=Use_Proto=TRUE;
              goto L1153;
            }
          if(strcmp(Keyword,"spc$")==0){
              strcpy(Stk[Tmp],"SPC$");
              Use_SPC=Use_BcxTempStr=TRUE;
              goto L1153;
            }
          if(strcmp(Keyword,"startdraw")==0){
              strcpy(Stk[Tmp],"StartDraw");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Draw=TRUE;
              goto L1153;
            }
          if(strcmp(Keyword,"str$")==0){
              strcpy(Stk[Tmp],"$$str$");
              Use_Str=Use_BcxTempStr=TRUE;
              goto L1153;
            }
          if(strcmp(Keyword,"strl$")==0){
              strcpy(Stk[Tmp],"$$strl$");
              Use_Strl=Use_BcxTempStr=TRUE;
              goto L1153;
            }
          if(strcmp(Keyword,"str2variant")==0){
              Add2SplitLines(join(3,"COM_AS2WS(",Stk[Tmp+2],")"));
              Add2SplitLines(join(2,Stk[Tmp+4],".vt = VT_BSTR"));
              Add2SplitLines(join(2,Stk[Tmp+4],".bstrVal = SysAllocString(COM_LPWSTR_temp)"));
              Ndx=0;
              goto L1153;
            }
          if(strcmp(Keyword,"searchpath$")==0){
              strcpy(Stk[Tmp],"$$SEARCHPATH$");
              Use_SearchPath=Use_BcxTempStr=TRUE;
              goto L1153;
            }
          if(strcmp(Keyword,"sendmessage")==0  || strcmp(Keyword,"sndmsg")==0){
              if(!iMatchWrd(Stk[1],"const")){
                  if(strcmp(Stk[Tmp+1],"(")!=0){
                      InsertOptionalParens(Tmp+1);
                    }
                  strcpy(Stk[Tmp],"SendMessage");
                  Comma=i=0;
                  A=Tmp+1;
                  for(;;)
                    {
                      if(A>Ndx ){
                          Abort("Malformed SendMessage");
                        }
                      A++;
                      if(inchr("([{",Stk[A])){
                          i++;
                        }
                      if(inchr(")]}",Stk[A])){
                          i--;
                        }
                      if(NOTZERO(i)){
                          continue;
                        }
                      if(*Stk[A]==44 ){
                          if(Comma==0 ){
                              if(ISFALSE(iMatchWrd(Stk[A+2],"UINT"))){
                                  InsertTokens(A,3,"(","UINT",")");
                                }
                            }
                          else if(Comma==1 ){
                              if(ISFALSE(iMatchWrd(Stk[A+2],"WPARAM"))){
                                  InsertTokens(A,3,"(","WPARAM",")");
                                }
                            }
                          else if(Comma==2 ){
                              if(ISFALSE(iMatchWrd(Stk[A+2],"LPARAM"))){
                                  InsertTokens(A,3,"(","LPARAM",")");
                                }
                              goto L1154;
                            }
                          Comma++;
                        }
                    }
L1154:;
                }
              goto L1153;
            }
          if(strcmp(Keyword,"savebmp")==0){
              strcpy(Stk[Tmp],"SaveBmp");
              Use_SaveBmp=Use_Proto=Use_BcxTempStr=TRUE;
              goto L1153;
            }
          if(strcmp(Keyword,"set_bcx_bitmap")==0){
              strcpy(Stk[Tmp],"Set_BCX_Bitmap");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Set_BCX_Bitmap=Use_BcxTempStr=TRUE;
              goto L1153;
            }
          if(strcmp(Keyword,"set_bcx_bitmap2")==0){
              strcpy(Stk[Tmp],"Set_BCX_Bitmap2");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Set_BCX_Bitmap2=Use_BcxTempStr=TRUE;
              goto L1153;
            }
          if(strcmp(Keyword,"set_bcx_bmpbutton")==0){
              strcpy(Stk[Tmp],"Set_BCX_BmpButton");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Set_BCX_BmpButton=Use_BcxTempStr=TRUE;
              goto L1153;
            }
          if(strcmp(Keyword,"set_bcx_icon")==0){
              strcpy(Stk[Tmp],"Set_BCX_Icon");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Proto=TRUE;
              Use_Set_BCX_Icon=Use_GetResource=TRUE;
              goto L1153;
            }
          if(strcmp(Keyword,"screen")==0){
              strcpy(Stk[Tmp],"Screen");
              Use_Screen=Use_Proto=TRUE;
              goto L1153;
            }
          if(strcmp(Keyword,"setattr")==0){
              strcpy(Stk[Tmp],"SETATTR");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Setattr=Use_SysMacros=TRUE;
              goto L1153;
            }
          if(strcmp(Keyword,"setwindowrtftext")==0){
              strcpy(Stk[Tmp],"SetWindowRTFText");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Richedit=Use_BcxTempStr=TRUE;
              goto L1153;
            }
          if(strcmp(Keyword,"sgn")==0){
              strcpy(Stk[Tmp],"sgn");
              Use_Sgn=Use_Proto=TRUE;
              goto L1153;
            }
          if(strcmp(Keyword,"show")==0){
              strcpy(Stk[Tmp],"SHOWHWND");
              Use_Show=Use_SysMacros=TRUE;
              if(Ndx>=2 && strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              goto L1153;
            }
          if(strcmp(Keyword,"sleep")==0){
              Use_Sleep=TRUE;
              strcpy(Stk[Tmp],"BCX_Sleep");
              if(Ndx>=2 && strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              goto L1153;
            }
          if(strcmp(Keyword,"showmodal")==0){
              strcpy(Stk[Tmp],"ShowModal");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Show=Use_SysMacros=Use_ShowModal=Use_EndModal=TRUE;
              goto L1153;
            }
          if(strcmp(Keyword,"space$")==0){
              strcpy(Stk[Tmp],"$$space$");
              Use_Space=Use_BcxTempStr=TRUE;
              goto L1153;
            }
          if(strcmp(Keyword,"sound")==0){
              strcpy(Stk[Tmp],"Sound");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Sound=Use_Round=Use_Str=Use_BcxTempStr=TRUE;
              goto L1153;
            }
          if(strcmp(Keyword,"split")==0){
              strcpy(Stk[Tmp],"Split");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Proto=TRUE;
              Use_BcxTempStr=TRUE;
              Use_UCaseTbl=TRUE;
              Use_Stristr=TRUE;
              Use_Split=TRUE;
              Use_Remove=TRUE;
              Use_Mid=TRUE;
              Use_Left=TRUE;
              Use_Instr=TRUE;
              Use_Replace=TRUE;
              goto L1153;
            }
          if(strcmp(Keyword,"strim$")==0){
              strcpy(Stk[Tmp],"$$strim$");
              Use_Strim=Use_BcxTempStr=TRUE;
              goto L1153;
            }
          if(strcmp(Keyword,"string$")==0){
              strcpy(Stk[Tmp],"$$stringx$");
              Use_String=Use_BcxTempStr=TRUE;
              goto L1153;
            }
          if(strcmp(Keyword,"strptr")==0){
              strcpy(Stk[Tmp],"STRPTR");
              Use_Strptr=Use_SysMacros=TRUE;
              goto L1153;
            }
          if(strcmp(Keyword,"strtoken$")==0){
              strcpy(Stk[Tmp],"StrToken$");
              Use_Strtoken=Use_BcxTempStr=Use_Mid=Use_Left=Use_Extract=TRUE;
              Use_Instr=Use_Instrrev=Use_Stristr=Use_Tally=Use_Remove=TRUE;
              Use_UCaseTbl=TRUE;
              goto L1153;
            }
          if(strcmp(Keyword,"sub")==0){
              if(bcx_stricmp(Stk[2],"main")==0){
                  NoMain=TRUE;
                  strcpy(Stk[1],"function");
                }
              goto L1153;
            }
          if(strcmp(Keyword,"swap")==0){
              strcpy(Stk[Tmp],"swap");
              Use_Swap=Use_Proto=TRUE;
              goto L1153;
            }
          if(strcmp(Keyword,"sysdir$")==0){
              strcpy(Stk[Tmp],"$$sysdir$()");
              Convert2SimpleFunction(Tmp);
              Use_Sysdir=Use_BcxTempStr=TRUE;
              goto L1153;
            }
          if(strcmp(Keyword,"sysstr")==0){
              strcpy(Stk[Tmp],"SysStr");
              Use_SysStr=Use_Proto=TRUE;
            }
L1153:;
          goto L1104;
        }
      if(a==20 ){
          if(strcmp(Keyword,"tab$")==0){
              strcpy(Stk[Tmp],"TAB$");
              Use_TAB=Use_BcxTempStr=TRUE;
              goto L1155;
            }
          if(strcmp(Keyword,"true")==0){
              strcpy(Stk[Tmp],"TRUE");
              goto L1155;
            }
          if(strcmp(Keyword,"trim$")==0){
              strcpy(Stk[Tmp],"$$trim$");
              Use_Trim=Use_BcxTempStr=TRUE;
              goto L1155;
            }
          if(strcmp(Keyword,"tally")==0){
              strcpy(Stk[Tmp],"tally");
              Use_Tally=Use_UCaseTbl=Use_Stristr=Use_Proto=TRUE;
              goto L1155;
            }
          if(strcmp(Keyword,"tempdir$")==0){
              strcpy(Stk[Tmp],"$$tempdir$()");
              Convert2SimpleFunction(Tmp);
              Use_Tempdir=Use_BcxTempStr=TRUE;
              goto L1155;
            }
          if(strcmp(Keyword,"tempfilename$")==0){
              strcpy(Stk[Tmp],"$$TempFileName$");
              Use_TempFileName=Use_BcxTempStr=TRUE;
              goto L1155;
            }
          if(strcmp(Keyword,"textmode")==0){
              strcpy(Stk[Tmp],"TextMode");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              Use_Textmode=Use_Proto=TRUE;
              goto L1155;
            }
          if(strcmp(Keyword,"time$")==0){
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  strcpy(Stk[Tmp],"$$timef$()");
                }
              else
                {
                  strcpy(Stk[Tmp],"$$timef$");
                }
              Convert2SimpleFunction(Tmp);
              Use_Time=Use_BcxTempStr=TRUE;
              goto L1155;
            }
          if(strcmp(Keyword,"timer")==0){
              strcpy(Stk[Tmp],"timer()");
              Convert2SimpleFunction(Tmp);
              Use_Timer=Use_Proto=TRUE;
              goto L1155;
            }
          if(strcmp(Keyword,"tix_start")==0){
              strcpy(Stk[Tmp],"TIX_START()");
              Convert2SimpleFunction(Tmp);
              Use_Tix=Use_Proto=TRUE;
              goto L1155;
            }
          if(strcmp(Keyword,"tix_now")==0){
              strcpy(Stk[Tmp],"TIX_NOW()");
              Convert2SimpleFunction(Tmp);
              Use_Tix=Use_Proto=TRUE;
            }
L1155:;
          goto L1104;
        }
      if(a==21 ){
          if(strcmp(Keyword,"ucase$")==0){
              if(iSubLoc==2 ){
                  if(strcmp(Stk[Tmp+1],"(")==0){
                      Abort("'ucase' can only be used as a Function Pointer when in a SET");
                    }
                  strcpy(Stk[Tmp],"ucase");
                }
              else
                {
                  strcpy(Stk[Tmp],"$$ucase$");
                }
              Use_Ucase=Use_BcxTempStr=TRUE;
              goto L1156;
            }
          if(strcmp(Keyword,"unwrap$")==0){
              strcpy(Stk[Tmp],"$$unwrap$");
              Use_Unwrap=Use_BcxTempStr=Use_Left=Use_Right=TRUE;
              goto L1156;
            }
          if(strcmp(Keyword,"ubound")==0){
              strcpy(Stk[Tmp],"ubound");
              Use_Ubound=Use_SysMacros=TRUE;
              goto L1156;
            }
          if(strcmp(Keyword,"ubound_d")==0){
              strcpy(Stk[Tmp],"ubound_d");
              Use_Ubound=Use_SysMacros=TRUE;
              goto L1156;
            }
          if(strcmp(Keyword,"ubound_s")==0){
              strcpy(Stk[Tmp],"ubound_s");
              Use_Ubound=Use_SysMacros=TRUE;
              goto L1156;
            }
          if(strcmp(Keyword,"ucode$")==0  || strcmp(Keyword,"ucode")==0){
              strcpy(Stk[Tmp],"$$AnsiToWide$");
              Use_AnsiToWide=Use_BcxTempStr=TRUE;
              goto L1156;
            }
          if(strcmp(Keyword,"utf8tochr$")==0){
              strcpy(Stk[Tmp],"UTF8toCHR$");
              Use_Utf8tochr=Use_BcxTempStr=TRUE;
              goto L1156;
            }
          if(strcmp(Keyword,"uncom")==0){
              Use_AnsiToWide=Use_WideToAnsi=Use_BcxTempStr=TRUE;
              strcpy(Stk[Tmp],"UNCOM");
              if(strcmp(Stk[Tmp+1],"(")!=0){
                  InsertOptionalParens(Tmp+1);
                }
              ComSwitchON=TRUE;
              Use_COM=TRUE;
              Use_COM_CreateObject=TRUE;
              Use_COM_DispatchObject=TRUE;
              Use_COM_GetObject=TRUE;
              Use_COM_GetProperty=TRUE;
              Use_COM_InvokeMethod=TRUE;
              Use_COM_SafeArray=TRUE;
              Use_COM_SetProperty=TRUE;
              Use_COM_UsesConversion=TRUE;
              goto L1156;
            }
          if(strcmp(Keyword,"using$")==0){
              strcpy(Stk[Tmp],"$$Using$");
              Use_Using=Use_Instr=Use_Stristr=Use_Replace=Use_BcxTempStr=Use_UCaseTbl=Use_LCaseTbl=TRUE;
            }
L1156:;
          goto L1104;
        }
      if(a==22 ){
          if(strcmp(Keyword,"val")==0){
              strcpy(Stk[Tmp],"VAL");
              Use_Val=Use_SysMacros=TRUE;
              goto L1157;
            }
          if(strcmp(Keyword,"vall")==0){
              strcpy(Stk[Tmp],"VALL");
              Use_Vall=Use_SysMacros=TRUE;
              goto L1157;
            }
          if(strcmp(Keyword,"variant2str")==0){
              Add2SplitLines("BEGINBLOCK");
              Add2SplitLines(join(3,"DIM RAW sBuf[wlen(",Stk[Tmp+2],".bstrVal)+2] AS char"));
              Add2SplitLines(join(3,"wstrcpy(sBuf,",Stk[Tmp+2],".bstrVal)"));
              Add2SplitLines("COM_WS2AS(sBuf)");
              Add2SplitLines(join(2,Stk[Tmp+4]," = COM_psz_tmp$"));
              Add2SplitLines("ENDBLOCK");
              Ndx=0;
              Use_COM_UsesConversion=TRUE;
              goto L1157;
            }
          if(strcmp(Keyword,"varptr")==0){
              strcpy(Stk[Tmp],"&");
              goto L1157;
            }
          if(strcmp(Keyword,"vchr$")==0){
              strcpy(Stk[Tmp],"$$vchr$");
              Use_VChr=Use_BcxTempStr=TRUE;
              goto L1157;
            }
          if(strcmp(Keyword,"vt$")==0){
              strcpy(Stk[Tmp],"VT$");
              Use_VT=Use_BcxTempStr=TRUE;
              goto L1157;
            }
          if(strcmp(Keyword,"virtual")==0){
              if(Tmp==1 ){
                  strcpy(Stk[Tmp],"dim");
                  IsVirtual=TRUE;
                  int ii=Ndx;
                  while(strcmp(Stk[ii],")")!=0){
                      ii--;
                    }
                  ii++;
                  if(iMatchWrd(Stk[Ndx],"stdcall")){
                      int iNdx=Ndx-1;
                      if(iMatchWrd(Stk[iNdx],"as")){
                          iNdx--;
                        }
                      if(ii<=iNdx ){
                          BuildDelimStr(ii,iNdx,szVirtual);
                        }
                      else
                        {
                          *szVirtual=0;
                        }
                    }
                  else
                    {
                      if(ii<=Ndx ){
                          BuildDelimStr(ii,Ndx,szVirtual);
                        }
                      else
                        {
                          *szVirtual=0;
                        }
                    }
                }
              goto L1157;
            }
          if(strcmp(Keyword,"vector")==0){
              if(strcmp(Stk[Tmp+1],"<")==0){
                  strcpy(Stk[Tmp],"vector");
                  HasVector=TRUE;
                }
              goto L1157;
            }
          if(strcmp(Keyword,"verify")==0){
              strcpy(Stk[Tmp],"Verify");
              Use_Verify=Use_Mid=Use_BcxTempStr=TRUE;
              goto L1157;
            }
          if(strcmp(Keyword,"vbs_addcode")==0  || strcmp(Keyword,"vbs_run_script")==0  || strcmp(Keyword,"vbs_eval_str$")==0){
              strcpy(Stk[Tmp],ucase(Stk[Tmp]));
              Use_VBS=Use_BcxTempStr=TRUE;
              goto L1157;
            }
          if(strcmp(Keyword,"vbs_eval_num")==0  || strcmp(Keyword,"vbs_eval_num#")==0){
              strcpy(Stk[Tmp],"VBS_EVAL_NUM#");
              Use_VBS=Use_BcxTempStr=TRUE;
              goto L1157;
            }
          if(strcmp(Keyword,"vbs_start")==0  || strcmp(Keyword,"vbs_stop")==0  || strcmp(Keyword,"vbs_reset")==0  || strcmp(Keyword,"vbs_error$")==0){
              Use_VBS=Use_BcxTempStr=TRUE;
              strcpy(Stk[Tmp], join(2,ucase(Stk[Tmp]),"()"));
              Convert2SimpleFunction(Tmp);
            }
L1157:;
          goto L1104;
        }
      if(a==23 ){
          if(strcmp(Keyword,"wrap$")==0){
              strcpy(Stk[Tmp],"$$wrap$");
              Use_Wrap=Use_BcxTempStr=TRUE;
              goto L1159;
            }
          if(strcmp(Keyword,"widetoansi$")==0  || strcmp(Keyword,"widetoansi")==0  || strcmp(Keyword,"w2a$")==0  || strcmp(Keyword,"w2a")==0){
              strcpy(Stk[Tmp],"$$WideToAnsi$");
              Use_WideToAnsi=Use_BcxTempStr=TRUE;
              goto L1159;
            }
          if(strcmp(Keyword,"windir$")==0){
              strcpy(Stk[Tmp],"$$windir$()");
              Convert2SimpleFunction(Tmp);
              Use_Windir=Use_BcxTempStr=TRUE;
              goto L1159;
            }
          if(strcmp(Keyword,"wndproc")==0){
              if(Tmp==2&&Ndx<6 ){
                  strcpy(Src,"FUNCTION|WndProc(hWnd|AS|HWND,Msg|AS|UINT,wParam|AS|WPARAM,lParam|AS|LPARAM)|AS|CALLBACK|LRESULT");
                  FastLexer(Src,"|",",()");
                  Use_Wingui=TRUE;
                  CallBackFlag=TRUE;
                }
              goto L1159;
            }
          if(strcmp(Keyword,"winmain")==0){
              Use_Wingui=InWinMain=TRUE;
              if(Tmp==2&&Ndx<6 ){
                  strcpy(Src,"FUNCTION|WinMain(hInst|AS|HINSTANCE,hPrev|AS|HINSTANCE,CmdLine|AS|PSTR,CmdShow|AS|int)AS|int WINAPI");
                  FastLexer(Src,"|",",()");
                }
              else
                {
                  strcpy(Stk[Tmp],"WinMain");
                }
            }
L1159:;
          goto L1104;
        }
      if(a==26 ){
          if(strcmp(Keyword,"zstring")==0){
              if(iMatchWrd(Stk[Tmp+1],"ptr")){
                  strcpy(Stk[Tmp],"char");
                  Tmp++;
                  strcpy(Stk[Tmp-1], join(2,Stk[Tmp-1],"*"));
                  *Stk[Tmp]=0;
                  if(Tmp==Ndx ){
                      Ndx--;
                      while(tally(Stk[Ndx],"*")==(int)strlen(Stk[Ndx])){
                          strcpy(Stk[Ndx-1], join(2,Stk[Ndx-1],Stk[Ndx]));
                          *Stk[Ndx]=0;
                          Ndx--;
                        }
                    }
                  else
                    {
                      i=Tmp-1;
                      while(tally(Stk[i],"*")==(int)strlen(Stk[i])){
                          strcpy(Stk[i-1], join(2,Stk[i-1],Stk[i]));
                          *Stk[i]=0;
                          i--;
                        }
                    }
                }
              strcpy(Stk[Tmp],"string");
            }
          goto L1104;
        }
      if(a==27 ){
          if(strcmp(Keyword,"$ifndef")==0){
              strcpy(Stk[Tmp],"~ifndef");
              InConditional++;
              goto L1163;
            }
          if(strcmp(Keyword,"$ifdef")==0){
              strcpy(Stk[Tmp],"~ifdef");
              InConditional++;
              goto L1163;
            }
          if(strcmp(Keyword,"$if")==0){
              strcpy(Stk[Tmp],"~if");
              InConditional++;
              goto L1163;
            }
          if(strcmp(Keyword,"$endif")==0){
              strcpy(Stk[Tmp],"~endif");
              InConditional--;
              if(InConditional<0 ){
                  Abort("Too many $ENDIFs");
                }
            }
L1163:;
        }
L1104:;
    }
L1103:;
  RemEmptyTokens();
  if(PrependCnt ){
      i=PrependCnt;
      while(i){
          if(!iMatchWrd(Stk[1],"with")&&!iMatchWrd(Stk[1],"prepend")&&!iMatchWrd(Stk[1],"endwith")&&!iMatchWrd(Stk[1],"endprepend")){
              InsertTokens(0,1,PrependVar[i]);
            }
          i--;
        }
    }
  if(WithCnt ){
      int WithVarPositions[32]={0};
      for(i=1; i<=Ndx; i++)
        {
          if(strcmp(Stk[i],WithVar[WithCnt])==0){
              WithVarPositions[i]=TRUE;
            }
        }
      i=Ndx;
      while(i){
          if(LeftStr(Stk[i],"->")||(*Stk[i]==46&&!IsDecimalNumber(Stk[i]+1))){
              if(strcmp(WithVar[WithCnt],"Me")==0  && *Stk[i]==46 ){
                  if(InFunction ){
                      strcpy(Stk[i], join(2,"->",mid(Stk[i],2)));
                    }
                }
              strcpy(Stk[i], join(2,WithVar[WithCnt],Stk[i]));
            }
          i--;
        }
      int t={0};
      for(i=1; i<=Ndx; i++)
        {
          if(instr(Stk[i],WithVar[WithCnt])){
              t++;
            }
          if(instr(Stk[i],WithVar[WithCnt])&&t>1 && strcmp(WithVar[WithCnt],"Me")!=0){
              strcpy(Stk[i],RemoveStr(Stk[i],WithVar[WithCnt]));
            }
        }
      for(i=1; i<=Ndx; i++)
        {
          if(WithVarPositions[i]==TRUE ){
              strcpy(Stk[i],WithVar[WithCnt]);
            }
        }
    }
  if(PrependCnt ){
      BuildDelimStr(1,Ndx,Src);
      XParse(Src);
    }
  if(CompToken==1 ){
      strcpy(Keyword,lcase(Stk[1]));
      if(strcmp(Keyword,"dim")==0){
          CompToken=0;
          goto L1169;
        }
      if(strcmp(Keyword,"local")==0){
          CompToken=0;
          goto L1169;
        }
      if(strcmp(Keyword,"global")==0){
          CompToken=0;
          goto L1169;
        }
      if(strcmp(Keyword,"static")==0){
          CompToken=0;
          goto L1169;
        }
      if(strcmp(Keyword,"shared")==0){
          CompToken=0;
          goto L1169;
        }
      if(strcmp(Keyword,"raw")==0){
          CompToken=0;
          goto L1169;
        }
      if(strcmp(Keyword,"dynamic")==0){
          CompToken=0;
          goto L1169;
        }
      if(strcmp(Keyword,"free")==0){
          CompToken=0;
          goto L1169;
        }
      if(strcmp(Keyword,"redim")==0){
          CompToken=0;
          goto L1169;
        }
      if(strcmp(Keyword,"sub")==0){
          CompToken=0;
          goto L1169;
        }
      if(strcmp(Keyword,"function")==0){
          CompToken=0;
          goto L1169;
        }
      if(strcmp(Keyword,"overloaded")==0){
          CompToken=0;
          goto L1169;
        }
      if(strcmp(Keyword,"callback")==0){
          CompToken=0;
          goto L1169;
        }
      if(strcmp(Keyword,"public")==0){
          CompToken=0;
          goto L1169;
        }
      if(strcmp(Keyword,"declare")==0){
          CompToken=0;
          goto L1169;
        }
      if(strcmp(Keyword,"c_declare")==0){
          CompToken=0;
          goto L1169;
        }
      if(strcmp(Keyword,"auto")==0){
          CompToken=0;
          goto L1169;
        }
      if(strcmp(Keyword,"register")==0){
          CompToken=0;
          goto L1169;
        }
      if(strcmp(Keyword,"extern")==0){
          CompToken=0;
        }
      else
        {
          AsmUnknownStructs(1);
        }
L1169:;
    }
}

void LShiftStk (int ToCell)
{
  int i;
  Ndx--;
  for(i=ToCell; i<=Ndx; i++)
    {
      strcpy(Stk[i],Stk[i+1]);
    }
  *Stk[Ndx+1]=0;
}

void RShiftStk (int FromCell)
{
  int i;
  Ndx++;
  for(i=Ndx; i>=FromCell; i+=-1)
    {
      strcpy(Stk[i],Stk[i-1]);
    }
  *Stk[FromCell]=0;
}

void InsertOptionalParens (int StartCell)
{
  RShiftStk(StartCell);
  strcpy(Stk[StartCell],"(");
  Ndx++;
  strcpy(Stk[Ndx],")");
}

void JoinStrings (int iThisToken,int inIF)
{
  int sj=iThisToken;
  int DoJoin=0;
  int InBrace=0;
  int OnlyPara=0;
  int j=0;
  int vt=0;
   char szToken[BCXSTRSIZE];  strcpy(szToken,"");
  while(iThisToken<=Ndx){
      strcpy(szToken,Stk[iThisToken]);
      if(!j&&!OnlyPara&&!InBrace ){
          vt=DataType(szToken);
          if(vt==vt_INTEGER ){
              vt=GetNextVarType(iThisToken);
            }
          if(vt==vt_STRVAR||vt==vt_STRLIT ){
              sj=iThisToken;
              iThisToken++;
              continue;
            }
        }
      strcpy(szToken,lcase(szToken));
      if(strcmp(szToken,"&")==0){
          if(OnlyPara ){
              goto L1173;
            }
          vt=DataType(Stk[iThisToken+1]);
          if(vt==vt_INTEGER ){
              vt=GetNextVarType(iThisToken+1);
            }
          if(vt!=vt_STRVAR&&vt!=vt_STRLIT ){
              vt=DataType(Stk[iThisToken-1]);
              if(vt==vt_INTEGER ){
                  vt=GetPrevVarType(iThisToken-1,1);
                }
            }
          if(vt==vt_STRVAR||vt==vt_STRLIT ){
              j++;
              strcpy(Stk[iThisToken],",");
              *szToken=0;
            }
          goto L1173;
        }
      if(strcmp(szToken,"[")==0){
          InBrace++;
          goto L1173;
        }
      if(strcmp(szToken,"]")==0){
          InBrace--;
          goto L1173;
        }
      if(strcmp(szToken,"(")==0){
          if(strcmp(Stk[iThisToken+1],"*")!=0){
              JoinStrings(iThisToken+1,inIF);
              int iBuildHere=iThisToken-1;
              while(strcmp(Stk[iThisToken],")")!=0){
                  strcpy(Stk[iBuildHere], join(3,Stk[iBuildHere],Stk[iThisToken],SPC));
                  *Stk[iThisToken]=0;
                  iThisToken++;
                }
              strcpy(Stk[iBuildHere], join(2,Stk[iBuildHere],Stk[iThisToken]));
              *Stk[iThisToken]=0;
            }
          goto L1173;
        }
      if(strcmp(szToken,")")==0){
          if(j ){
              strcpy(Stk[sj], join(4,"join$(",str(j+1,TRUE),",",Stk[sj]));
              j=sj;
              while(++j<iThisToken){
                  strcpy(Stk[sj], join(2,Stk[sj],Stk[j]));
                  *Stk[j]=0;
                }
              strcpy(Stk[sj], join(2,Stk[sj],")"));
            }
          return;
        }
      if(strcmp(szToken,"||")==0){
          strcpy(Stk[iThisToken],"or");
          DoJoin=TRUE;
          goto L1173;
        }
      if(strcmp(szToken,"&&")==0){
          strcpy(Stk[iThisToken],"and");
          DoJoin=TRUE;
          goto L1173;
        }
      if(strcmp(szToken,"then")==0  || strcmp(szToken,"for")==0  || strcmp(szToken,"xfor")==0){
          DoJoin=TRUE;
          goto L1173;
        }
      if(strcmp(szToken,"=")==0){
          if(!inIF ){
              OnlyPara=TRUE;
            }
          else
            {
              DoJoin=TRUE;
            }
          goto L1173;
        }
      if(strcmp(szToken,"if")==0  || strcmp(szToken,"elseif")==0  || strcmp(szToken,"while")==0){
          inIF=TRUE;
          sj=iThisToken+1;
          goto L1173;
        }
      if(strcmp(szToken,"sprint")==0  || strcmp(szToken,"lprint")==0  || strcmp(szToken,"fprint")==0  || strcmp(szToken,"fprintf")==0  || strcmp(szToken,"print")==0  || strcmp(szToken,"print#")==0){
          OnlyPara=TRUE;
        }
      else
        {
          if(LeftStr(Stk[iThisToken],"].")||LeftStr(Stk[iThisToken],"]->")){
              InBrace--;
            }
        }
L1173:;
      if((DoJoin||inchr(",+-*/^;:<>~|&",szToken))&&!OnlyPara&&!InBrace ){
          DoJoin=0;
          if(j ){
              strcpy(Stk[sj], join(4,"join$(",str(j+1,1),",",Stk[sj]));
              j=sj;
              while(++j<iThisToken){
                  strcpy(Stk[sj], join(2,Stk[sj],Stk[j]));
                  *Stk[j]=0;
                }
              strcpy(Stk[sj], join(2,Stk[sj],")"));
            }
          j=0;
          sj=iThisToken+1;
        }
      iThisToken++;
    }
  if(j ){
      strcpy(Stk[sj], join(4,"join$(",str(j+1,1),",",trim(Stk[sj])));
      j=sj;
      while(++j<=iThisToken){
          strcpy(Stk[sj], join(2,Stk[sj],trim(Stk[j])));
          *Stk[j]=0;
        }
      strcpy(Stk[sj], join(2,Stk[sj],")"));
    }
}

void Transforms ()
{
  int a;
  int i;
  char Keyword[BCXSTRSIZE];
  char LTmp[BCXSTRSIZE];
  struct _TOKSUBFUNC*  tpBCX;
  strcpy(Keyword,lcase(Stk[1]));
  tpBCX=GetWordInfo(Keyword);
  if(tpBCX ){
      if((tpBCX->iWordInfo  &  eWI_Transform)==0 ){
          return;
        }
    }
  else
    {
      return;
    }
  *LTmp=0;
  a=inchr("abcdefghijklmnopqrstuvwxyz$",Keyword);
  if(a==4 ){
      if(strcmp(Keyword,"declare")==0  && iMatchWrd(Stk[4],"lib")){
          char szAlias[BCXSTRSIZE];
          int kk;
          int idx=-1;
          strcpy(Stk[5],RemoveStr(Stk[5],DQ));
          for(kk=1; kk<=LoadLibsCnt; kk++)
            {
              if(strcmp(Stk[5],Loadlibs[kk])==0){
                  idx=kk;
                  goto L1179;
                }
            }
L1179:;
          if(idx<0 ){
              if(cMaxLoadlibs==++LoadLibsCnt ){
                  Abort("Maximum number of LIBs that can be loaded exceeded.");
                }
              strcpy(Loadlibs[LoadLibsCnt],Stk[5]);
            }
          if(iMatchWrd(Stk[6],"alias")){
              strcpy(szAlias,Stk[7]);
              *Stk[6]=0;
              *Stk[7]=0;
            }
          else
            {
              strcpy(szAlias,enc(ucase(Stk[3])));
            }
          DllCnt++;
          if(DllCnt>=cMaxDLLDecl ){
              Abort("Maximum number of declarations exceeded.");
            }
          char mod_name[BCXSTRSIZE]={0};
          strcpy(mod_name,ucase(RemoveExtension(Stk[5])));
          if(inchr(mod_name,"-")||inchr(mod_name,".")){
              strcpy(mod_name,replace(mod_name,"-.","_"));
              strcpy(mod_name,replace(mod_name,"-","_"));
            }
          *DllDecl[DllCnt]=0;
          strcpy(DllDecl[DllCnt], join(3,DllDecl[DllCnt],Clean(Stk[3]),"=(BCXFPROT"));
          strcpy(DllDecl[DllCnt], join(3,DllDecl[DllCnt],str(DllCnt,TRUE),")GetProcAddress(H_"));
          strcpy(DllDecl[DllCnt], join(5,DllDecl[DllCnt],mod_name,", ",szAlias,");"));
          *Stk[4]=0;
          *Stk[5]=0;
        }
      return;
    }
  if(a==9 ){
      if(strcmp(Keyword,"iremove")==0){
          char Mat[BCXSTRSIZE];
          char Fat[BCXSTRSIZE];
          for(i=2; i<=Ndx; i++)
            {
              if(iMatchWrd(Stk[i],"from")){
                  *Stk[i]=0;
                  goto L1180;
                }
            }
L1180:;
          BuildStr(2,i,Mat);
          BuildStr(i,Ndx,Fat);
          if(inchr(Fat,"$")==0 ){
              strcat(Fat,"$");
            }
          if(inchr(Mat,"$")==0 ){
              strcat(Mat,"$");
            }
          strcpy(LTmp, join(5,"=iremove$(",Fat,",",Mat,")"));
          FastLexer(Fat," ()","");
          strcpy(LTmp, join(2,Stk[Ndx],LTmp));
          XParse(LTmp);
          TokenSubstitutions(1);
          Emit_Main();
          Ndx=0;
          return;
        }
      if(strcmp(Keyword,"ireplace")==0){
          if(Ndx<6 ){
              Abort("Problem with IREPLACE statement");
            }
          int W;
          int I;
          char VV[BCXSTRSIZE];
          char RR[BCXSTRSIZE];
          char WW[BCXSTRSIZE];
          for(W=2; W<=Ndx; W++)
            {
              if(iMatchWrd(Stk[W],"with")){
                  *Stk[W]=0;
                  goto L1181;
                }
            }
L1181:;
          for(I=2; I<=Ndx; I++)
            {
              if(iMatchWrd(Stk[I],"in")){
                  *Stk[I]=0;
                  goto L1182;
                }
            }
L1182:;
          BuildStr(I+1,Ndx,VV);
          BuildStr(2,W,RR);
          BuildStr(W+1,I,WW);
          if(inchr(VV,"$")==0 ){
              strcat(VV,"$");
            }
          if(inchr(RR,"$")==0 ){
              strcat(RR,"$");
            }
          if(inchr(WW,"$")==0 ){
              strcat(WW,"$");
            }
          strcpy(LTmp, join(7,"=ireplace$(",VV,",",RR,",",WW,")"));
          FastLexer(VV," ()","");
          strcpy(LTmp, join(2,Stk[Ndx],LTmp));
          XParse(LTmp);
          TokenSubstitutions(1);
          Emit_Main();
          Ndx=0;
        }
      return;
    }
  if(a==18 ){
      if(strcmp(Keyword,"remove")==0){
          char Mat[BCXSTRSIZE];
          char Fat[BCXSTRSIZE];
          for(i=2; i<=Ndx && !iMatchWrd(Stk[i],"from"); i++)
            {
            }
          if(i>Ndx ){
              Abort("Malformed REMOVE statement.");
            }
          BuildStr(2,i-1,Mat);
          BuildStr(i+1,Ndx,Fat);
          if(inchr(Fat,"$")==0 ){
              strcat(Fat,"$");
            }
          if(inchr(Mat,"$")==0 ){
              strcat(Mat,"$");
            }
          strcpy(LTmp, join(5,"=remove$(",Fat,",",Mat,")"));
          FastLexer(Fat," ()","");
          strcpy(LTmp, join(2,Stk[Ndx],LTmp));
          XParse(LTmp);
          TokenSubstitutions(1);
          Emit_Main();
          Ndx=0;
          return;
        }
      if(strcmp(Keyword,"replace")==0){
          if(Ndx<6 ){
              Abort("Problem with REPLACE statement");
            }
          int W;
          int I;
          char VV[BCXSTRSIZE];
          char RR[BCXSTRSIZE];
          char WW[BCXSTRSIZE];
          for(W=2; W<=Ndx; W++)
            {
              if(iMatchWrd(Stk[W],"with")){
                  *Stk[W]=0;
                  goto L1184;
                }
            }
L1184:;
          for(I=2; I<=Ndx; I++)
            {
              if(iMatchWrd(Stk[I],"in")){
                  *Stk[I]=0;
                  goto L1185;
                }
            }
L1185:;
          if(I<W||W==0 ){
              Abort("Malformed REPLACE statement");
            }
          BuildStr(I+1,Ndx,VV);
          BuildStr(2,W,RR);
          BuildStr(W+1,I,WW);
          if(inchr(VV,"$")==0 ){
              strcat(VV,"$");
            }
          if(inchr(RR,"$")==0 ){
              strcat(RR,"$");
            }
          if(inchr(WW,"$")==0 ){
              strcat(WW,"$");
            }
          strcpy(LTmp, join(8,VV,"=replace$(",VV,",",RR,",",WW,")"));
          XParse(LTmp);
          TokenSubstitutions(1);
          Emit_Main();
          Ndx=0;
        }
      return;
    }
}

int LocateJoiner (int iStart)
{
  while(iStart<Ndx){
      if((strcmp(Stk[iStart],"&")==0)  || ((strcmp(Stk[iStart],"+")==0)  && (strcmp(Stk[iStart+1],"+")!=0))){
          return iStart;
        }
      iStart++;
    }
  return 0;
}

int GetNextVarType (int iLoc)
{
  int  vt1;
  int  cvt1;
  int  Tmp;
  int  k;
  cvt1=CheckType(Stk[iLoc]);
  if(cvt1==0 ){
      vt1=DataType(Stk[iLoc]);
    }
  else
    {
      if(cvt1==vt_UDT||cvt1==vt_STRUCT ){
          if(*Stk[iLoc+1]==91 ){
              for(Tmp=iLoc+2,k=1; Tmp<=Ndx && k; Tmp++)
                {
                  if(*Stk[Tmp]==91 ){
                      k++;
                    }
                  if(*Stk[Tmp]==93 ){
                      k--;
                    }
                }
              vt1=DataType(Stk[Tmp]);
            }
          else
            {
              vt1=DataType(Stk[iLoc+1]);
            }
        }
      else
        {
          if(cvt1==vt_CHAR||cvt1==vt_SCHAR ){
              int i;
              int varid;
              struct _VARINFO*  vi;
              vi=NULL;
              i=CheckLocal(Stk[iLoc],&(varid));
              if(i ){
                  vi=&(LocalVars[varid]);
                }
              if(i==vt_UNKNOWN ){
                  i=CheckGlobal(Stk[iLoc],&(varid));
                  if(i ){
                      vi=&(GlobalVars[varid]);
                    }
                }
              if(vi ){
                  if(*(vi->VarDim)){
                      cvt1=vt_STRVAR;
                    }
                  else
                    {
                      cvt1=DataType(Stk[iLoc]);
                    }
                }
              else
                {
                  cvt1=DataType(Stk[iLoc]);
                }
            }
          vt1=cvt1;
        }
    }
  return vt1;
}

int GetPrevVarType (int iLoc,int iEarly)
{
  int  vt;
  int  Tmp;
  int  k;
  if(strcmp(Stk[iLoc],")")==0  || strcmp(Stk[iLoc],"]")==0){
      for(Tmp=iLoc-1,k=1; Tmp>=iEarly && k; Tmp--)
        {
          if(*Stk[Tmp]==41 ){
              k++;
            }
          if(*Stk[Tmp]==93 ){
              k++;
            }
          if(*Stk[Tmp]==40 ){
              k--;
            }
          if(*Stk[Tmp]==91 ){
              k--;
            }
        }
      vt=DataType(Stk[Tmp]);
    }
  else
    {
      vt=DataType(Stk[iLoc]);
      if(vt==vt_INTEGER ){
          vt=CheckType(Stk[iLoc]);
        }
      if(vt==vt_CHAR||vt==vt_SCHAR ){
          int i;
          int varid;
          struct _VARINFO*  vi;
          vi=NULL;
          i=CheckLocal(Stk[iLoc],&(varid));
          if(i ){
              vi=&(LocalVars[varid]);
            }
          if(i==vt_UNKNOWN ){
              i=CheckGlobal(Stk[iLoc],&(varid));
              if(i ){
                  vi=&(GlobalVars[varid]);
                }
            }
          if(vi ){
              if(*(vi->VarDim)){
                  vt=vt_STRVAR;
                }
            }
        }
    }
  return vt;
}

int JoinStrTest (int iStart,int iEarly)
{
  int Plus2Amp;
  int vtLeft;
  int vtRight;
  int iJoiner;
  int iDoJoin;
  iDoJoin=0;
  Plus2Amp=iMatchNQ(Stk[iStart++],"&");
  iJoiner=LocateJoiner(iStart);
  if(iJoiner==0 ){
      return iDoJoin;
    }
  vtLeft=GetPrevVarType(iJoiner-1,iEarly);
  vtRight=GetNextVarType(iJoiner+1);
  if(vtLeft==vt_STRVAR||vtLeft==vt_STRLIT||vtLeft==vt_LPSTR||vtLeft==vt_LPSTRPTR||vtLeft==vt_PCHAR ){
      vtLeft=1;
    }
  else
    {
      vtLeft=0;
    }
  if(vtRight==vt_STRVAR||vtRight==vt_STRLIT||vtRight==vt_LPSTR||vtRight==vt_LPSTRPTR||vtRight==vt_PCHAR ){
      vtRight=1;
    }
  else
    {
      vtRight=0;
    }
  if(vtLeft&&vtRight ){
      strcpy(Stk[iJoiner],"&");
      Plus2Amp=TRUE;
      iEarly=iJoiner+1;
    }
  iStart=iJoiner+1;
  if(iStart<Ndx ){
      iDoJoin=JoinStrTest(iStart,iEarly)|Plus2Amp;
    }
  else
    {
      iDoJoin=Plus2Amp;
    }
  return iDoJoin;
}

void FixUps ()
{
  int A;
  int B;
  int i;
  int j;
  int CommaCnt;
  int AmpCnt;
   char LTmp[BCXSTRSIZE];  strcpy(LTmp,"");
   char LStk1[BCXSTRSIZE];  strcpy(LStk1,"");
   char LStk2[BCXSTRSIZE];  strcpy(LStk2,"");
   char Var1[BCXSTRSIZE];  strcpy(Var1,"");
  PassOne=FALSE;
  if(!iMatchWrd(Stk[1],"function")){
      if(JoinStrTest(1,1)){
          int k;
          int Tmp;
          j=0;
          k=0;
          AmpCnt=0;
          for(Tmp=1; Tmp<Ndx && (j==0||k==0); Tmp++)
            {
              if(strcmp(Stk[Tmp],"&")==0){
                  A=GetNextVarType(Tmp+1);
                  if(A==vt_STRVAR||A==vt_STRLIT ){
                      AmpCnt++;
                      if(ISZERO(k)){
                          k=Tmp;
                        }
                    }
                }
              else
                {
                  A=CheckLocal(Stk[Tmp],&(i));
                  if(A==vt_UNKNOWN ){
                      A=CheckGlobal(Stk[Tmp],&(i));
                    }
                  if(A==vt_STRUCT||A==vt_UDT||A==vt_UNION ){
                      j=1;
                    }
                }
            }
          if(AmpCnt>1 ){
              Use_Join=Use_BcxTempStr=TRUE;
            }
          if(k ){
              if(j ){
                  AsmUnknownStructs(0);
                }
              JoinStrings(1,0);
              BuildDelimStr(1,Ndx,Src);
              XParse(Src);
            }
        }
    }
  if(UseCpp ){
      if(iMatchNQ(Src,"->lpVtbl")){
          for(int tt=1; tt<=Ndx; tt++)
            {
              if(iMatchRgt(Stk[tt],"->lpVtbl")){
                  strcpy(Stk[tt],extract(Stk[tt],"->lpVtbl"));
                  if((strcmp(Stk[tt+3],Stk[tt-1])==0  || strcmp(Stk[tt+3],Stk[tt])==0)  && strcmp(Stk[tt+3],")")!=0){
                      *Stk[tt+3]=0;
                      if(strcmp(Stk[tt+4],",")==0){
                          *Stk[tt+4]=0;
                        }
                    }
                }
            }
          RemEmptyTokens();
        }
    }
  if(InTypeDef ){
      for(int tt=1; tt<=Ndx; tt++)
        {
          if(bcx_stricmp(Stk[tt],"PSTR")==0){
              strcpy(Stk[tt],"PTCHAR");
            }
        }
      for(int tt=1; tt<=Ndx; tt++)
        {
          if(bcx_stricmp(Stk[tt],"PCHAR")==0){
              strcpy(Stk[tt],"PTCHAR");
            }
        }
      for(int tt=1; tt<=Ndx-1; tt++)
        {
          if(bcx_stricmp(Stk[tt],"CHAR")==0  &&  bcx_stricmp(Stk[tt+1],"PTR")==0){
              strcpy(Stk[tt],"PTCHAR");
              LShiftStk(tt+1);
            }
        }
    }
  if(HasThisToken("^")){
      int lp=0;
      int rp=0;
      int Insert1;
      int Insert2;
      for(i=1; i<=Ndx; i++)
        {
          if(strcmp(Stk[i],"^")==0){
              if(strcmp(Stk[i+1],"-")==0){
                  InsertTokens(i,1,"(");
                  B=i+3;
                  if(*Stk[B]==40 ){
                      lp=0;
                      rp=0;
                      for(;;)
                        {
                          if(*Stk[B]==40 ){
                              lp++;
                            }
                          if(*Stk[B]==41 ){
                              rp++;
                            }
                          B++;
                          if(lp==rp ){
                              goto L1197;
                            }
                        }
L1197:;
                      InsertTokens(B,1,")");
                    }
                  else
                    {
                      B=i+4;
                      if(inchr("[",Stk[B])){
                          for(;;)
                            {
                              B++;
                              if(inchr("]",Stk[B])){
                                  goto L1198;
                                }
                            }
L1198:;
                          Ndx++;
                          InsertTokens(B,1,")");
                        }
                      else
                        {
                          if(inchr("(",Stk[B])){
                              for(;;)
                                {
                                  B++;
                                  if(inchr(")",Stk[B])){
                                      goto L1199;
                                    }
                                }
L1199:;
                              InsertTokens(B,1,")");
                            }
                          else
                            {
                              InsertTokens(B,1,")");
                            }
                        }
                    }
                }
              Insert1=i-1;
              B=0;
              while(strcmp(Stk[Insert1],"=")!=0){
                  if(*Stk[Insert1]==93 ){
                      B++;
                    }
                  if(*Stk[Insert1]==41 ){
                      B++;
                    }
                  if(*Stk[Insert1]==91 ){
                      B--;
                    }
                  if(*Stk[Insert1]==40 ){
                      B--;
                    }
                  if(B==0 ){
                      goto L1200;
                    }
                  Insert1--;
                }
L1200:;
              if(*Stk[Insert1]==91 ){
                  Insert1--;
                }
              if(*Stk[Insert1]==61 ){
                  Insert1++;
                }
              if(*Stk[Insert1]==40 ){
                  B=DataType(Stk[Insert1-1]);
                  if(B==vt_INTEGER||B==vt_SINGLE||B==vt_DOUBLE ){
                      if(ISFALSE(iMatchWrd(Stk[Insert1-1],"print"))){
                          Insert1--;
                        }
                    }
                }
              Insert1--;
              strcpy(Stk[i],",");
              Insert2=i+1;
              B=DataType(Stk[Insert2]);
              if(B==vt_INTEGER||B==vt_SINGLE||B==vt_DOUBLE ){
                  if(*Stk[Insert2+1]==40||*Stk[Insert2+1]==91 ){
                      Insert2++;
                    }
                }
              B=0;
              while(Insert2<=Ndx){
                  if(*Stk[Insert2]==91 ){
                      B++;
                    }
                  if(*Stk[Insert2]==40 ){
                      B++;
                    }
                  if(*Stk[Insert2]==93 ){
                      B--;
                    }
                  if(*Stk[Insert2]==41 ){
                      B--;
                    }
                  if(ISZERO(B)){
                      goto L1201;
                    }
                  Insert2++;
                }
L1201:;
              InsertTokens(Insert2,1,")");
              InsertTokens(Insert1,2,"pow","(");
            }
        }
    }
  if(HasThisToken("mod")){
      int lp=0;
      int rp=0;
      int Insert1;
      int Insert2;
      for(i=1; i<=Ndx; i++)
        {
          if(bcx_stricmp(Stk[i],"MOD")==0){
              strcpy(Stk[i],"mod");
            }
          if(strcmp(Stk[i],"mod")==0  && strcmp(Stk[i+1],"(")!=0  && strcmp(Stk[i-1],"=")!=0){
              if(strcmp(Stk[i+1],"-")==0){
                  InsertTokens(i,1,"(");
                  B=i+3;
                  if(*Stk[B]==40 ){
                      lp=0;
                      rp=0;
                      for(;;)
                        {
                          if(*Stk[B]==40 ){
                              lp++;
                            }
                          if(*Stk[B]==41 ){
                              rp++;
                            }
                          B++;
                          if(lp==rp ){
                              goto L1203;
                            }
                        }
L1203:;
                      InsertTokens(B,1,")");
                    }
                  else
                    {
                      B=i+4;
                      if(inchr("[",Stk[B])){
                          for(;;)
                            {
                              B++;
                              if(inchr("]",Stk[B])){
                                  goto L1204;
                                }
                            }
L1204:;
                          Ndx++;
                          InsertTokens(B,1,")");
                        }
                      else
                        {
                          if(inchr("(",Stk[B])){
                              for(;;)
                                {
                                  B++;
                                  if(inchr(")",Stk[B])){
                                      goto L1205;
                                    }
                                }
L1205:;
                              InsertTokens(B,1,")");
                            }
                          else
                            {
                              InsertTokens(B,1,")");
                            }
                        }
                    }
                }
              Insert1=i-1;
              B=0;
              while(strcmp(Stk[Insert1],"=")!=0){
                  if(*Stk[Insert1]==93 ){
                      B++;
                    }
                  if(*Stk[Insert1]==41 ){
                      B++;
                    }
                  if(*Stk[Insert1]==91 ){
                      B--;
                    }
                  if(*Stk[Insert1]==40 ){
                      B--;
                    }
                  if(B==0 ){
                      goto L1206;
                    }
                  Insert1--;
                }
L1206:;
              if(*Stk[Insert1]==91 ){
                  Insert1--;
                }
              if(*Stk[Insert1]==61 ){
                  Insert1++;
                }
              if(*Stk[Insert1]==40 ){
                  B=DataType(Stk[Insert1-1]);
                  if(B==vt_INTEGER||B==vt_SINGLE||B==vt_DOUBLE ){
                      if(ISFALSE(iMatchWrd(Stk[Insert1-1],"print"))){
                          Insert1--;
                        }
                    }
                }
              Insert1--;
              strcpy(Stk[i],",");
              Insert2=i+1;
              B=DataType(Stk[Insert2]);
              if(B==vt_INTEGER||B==vt_SINGLE||B==vt_DOUBLE ){
                  if(*Stk[Insert2+1]==40||*Stk[Insert2+1]==91 ){
                      Insert2++;
                    }
                }
              B=0;
              while(Insert2<=Ndx){
                  if(*Stk[Insert2]==91 ){
                      B++;
                    }
                  if(*Stk[Insert2]==40 ){
                      B++;
                    }
                  if(*Stk[Insert2]==93 ){
                      B--;
                    }
                  if(*Stk[Insert2]==41 ){
                      B--;
                    }
                  if(ISZERO(B)){
                      goto L1207;
                    }
                  Insert2++;
                }
L1207:;
              InsertTokens(Insert2,1,")");
              InsertTokens(Insert1,2,"mod","(");
            }
        }
    }
  TokenSubstitutions(1);
  if(Ndx==0 ){
      return;
    }
  if(Ndx==3&&ISZERO(WithCnt)){
      if(*Stk[2]==43&&*Stk[3]==43 ){
          fprintf(FP_WRITE,"%s%s%s\n",Scoot,Clean(Stk[1]),"++;");
          Ndx=0;
          Statements++;
          return;
        }
      if(*Stk[2]==45&&*Stk[3]==45 ){
          fprintf(FP_WRITE,"%s%s%s\n",Scoot,Clean(Stk[1]),"--;");
          Ndx=0;
          Statements++;
          return;
        }
      if(*Stk[1]==43&&*Stk[2]==43 ){
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"++",Clean(Stk[3]),";");
          Ndx=0;
          Statements++;
          return;
        }
      if(*Stk[1]==45&&*Stk[2]==45 ){
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"--",Clean(Stk[3]),";");
          Ndx=0;
          Statements++;
          return;
        }
    }
  IsCallBack=0;
  if(iMatchWrd(Stk[Ndx],"callback")){
      IsCallBack=1;
      *Stk[Ndx--]=0;
    }
  Transforms();
  if(Ndx==0 ){
      return;
    }
  if(iMatchWrd(Stk[1],"function")||iMatchWrd(Stk[1],"impfunction")){
      if(iMatchWrd(Stk[Ndx-2],"as") && strcmp(Stk[Ndx],")")!=0){
          if(ISFALSE(iMatchWrd(Stk[Ndx],"export"))&&ISFALSE(iMatchWrd(Stk[Ndx],"stdcall"))){
              strcpy(Stk[Ndx-1], join(3,Stk[Ndx-1],SPC,Stk[Ndx]));
              Ndx--;
            }
        }
    }
  int iP=1;
  if(iMatchLft(Stk[1],"public")||iMatchLft(Stk[1],"private")){
      iP++;
    }
  if(iMatchWrd(Stk[iP],"function")||iMatchWrd(Stk[iP],"sub")){
      int offset;
      int LastBrk=Ndx-2;
      for(i=Ndx; i>=3; i+=-1)
        {
          if(*Stk[i]==41 ){
              LastBrk=i;
              goto L1208;
            }
        }
L1208:;
        {
        int  jjj;
        for(i=3,jjj=1; i<=LastBrk && jjj; i++)
          {
            offset=2;
            jjj=GetAsPosF(i,LastBrk);
            if(jjj ){
                i=jjj;
                if((i<LastBrk) && strcmp(Stk[i+offset],"=")!=0){
                    if(iMatchWrd(Stk[i+1],"function")){
                        offset=3;
                      }
                    if(ISFALSE(inchr(Stk[i+offset],")"))&&ISFALSE(inchr(Stk[i+offset],","))){
                        if(NOTZERO((int)strlen(Stk[i+offset]))&&ISFALSE(iMatchWrd(Stk[i+3],"as"))){
                            strcpy(Stk[i+offset-1], join(3,Stk[i+offset-1],SPC,Stk[i+offset]));
                            *Stk[i+offset]=0;
                          }
                      }
                  }
              }
          }
          }
    }
  if(ISFALSE(iMatchWrd(Stk[1],"declare"))){
      for(i=1; i<=Ndx; i++)
        {
          if(iMatchWrd(Stk[i],"lib")){
              if(strcmp(Stk[i-1],"(")==0  && (DataType(Stk[i+1])==vt_STRLIT||DataType(Stk[i+1])==vt_STRVAR)){
                  j=GetNumArgs(i+2);
                  strcpy(LTmp,"BCX_DynaCallB");
                  if(ISFALSE(iMatchWrd(Stk[1],"print"))){
                      if(DataType(Stk[i-2])==vt_STRVAR||DataType(Stk[1])==vt_STRVAR ){
                          strcpy(LTmp, join(2,"(char*)",LTmp));
                        }
                    }
                  strcpy(Var1,right(Stk[i-2],1));
                  if(inchr(VARTYPES,Var1)){
                      strcat(LTmp,Var1);
                      strcpy(Stk[i],enc(left(Stk[i-2],(int)strlen(Stk[i-2])-1)));
                    }
                  else
                    {
                      strcpy(Stk[i],enc(Stk[i-2]));
                    }
                  strcpy(Stk[i-2],LTmp);
                  for(B=Ndx+3; B>=i+3; B+=-1)
                    {
                      strcpy(Stk[B],Stk[B-3]);
                    }
                  strcpy(Stk[i+2],Stk[i+1]);
                  strcpy(Stk[i+1],",");
                  strcpy(Stk[i+3],",");
                  strcpy(Stk[i+4],str(j,1));
                  strcpy(Stk[i+5],sziif(j,",",")"));
                  Ndx+=(3);
                  Use_DynacallCommon=Use_Dynacall=Use_BcxTempStr=Use_Proto=TRUE;
                }
            }
        }
    }
  strcpy(LStk1,lcase(Stk[1]));
  strcpy(LStk2,lcase(Stk[2]));
  if(strcmp(LStk1,"open")==0){
      for(A=2; A<=Ndx; A++)
        {
          if(iMatchWrd(Stk[A],"binary")){
              goto L1212;
            }
        }
L1212:;
      if(A==Ndx ){
          return;
        }
      if(A<Ndx ){
          A++;
          strcpy(Var1,lcase(Stk[A]));
          if(strcmp(Var1,"new")==0){
              strcpy(Stk[A-1],"binarynew");
              LShiftStk(A);
              return;
            }
          if(strcmp(Var1,"append")==0){
              strcpy(Stk[A-1],"binaryappend");
              LShiftStk(A);
              return;
            }
          if(strcmp(Var1,"input")==0){
              strcpy(Stk[A-1],"binaryinput");
              LShiftStk(A);
              return;
            }
          if(strcmp(Var1,"output")==0){
              strcpy(Stk[A-1],"binaryoutput");
              LShiftStk(A);
              return;
            }
        }
    }
  if(strcmp(LStk1,"option")==0){
      if(strcmp(LStk2,"base")==0){
          OptionBase=IVAL(Stk[3]);
          Ndx=0;
          return;
        }
    }
  if(strcmp(LStk1,"dim")==0){
      strcpy(LTmp,enc(LStk2,(UCHAR)*(SPC)));
      if(iMatchNQ(" shared , dynamic , raw , local , auto , register , static ",LTmp)){
          strcpy(Stk[1],LStk2);
          strcpy(LStk1,LStk2);
          LShiftStk(2);
        }
      return;
    }
  if(strcmp(LStk1,"public")==0){
      if(strcmp(LStk2,"function")==0  || strcmp(LStk2,"sub")==0){
          if(InClass ){
              strcat(LStk1,LStk2);
              strcpy(Stk[1],LStk1);
            }
          else
            {
              strcpy(Stk[1],LStk2);
            }
          LShiftStk(2);
        }
      return;
    }
  if(strcmp(LStk1,"private")==0){
      if(strcmp(LStk2,"function")==0  || strcmp(LStk2,"sub")==0){
          if(InClass ){
              strcat(LStk1,LStk2);
              strcpy(Stk[1],LStk1);
            }
          else
            {
              Use_Static=TRUE;
              strcpy(Stk[1],LStk2);
            }
          LShiftStk(2);
        }
      return;
    }
  if(strcmp(LStk1,"onexit")==0){
      if(strcmp(LStk2,"sub")==0){
          Use_ExitCode=Use_Proto=TRUE;
          if(cMaxExitSub==++ExitNdx ){
              Abort("Maximum number of exit calls exceeded.");
            }
          strcpy(ExitSub[ExitNdx],Stk[3]);
          strcpy(Stk[1],LStk2);
          strcpy(LStk1,LStk2);
          LShiftStk(2);
        }
      return;
    }
  if(strcmp(LStk1,"onstart")==0){
      if(strcmp(LStk2,"sub")==0){
          Use_StartupCode=Use_Proto=TRUE;
          if(cMaxStartSub==++StartNdx ){
              Abort("Maximum number of startup calls exceeded.");
            }
          strcpy(StartSub[StartNdx],Stk[3]);
          strcpy(Stk[1],LStk2);
          strcpy(LStk1,LStk2);
          LShiftStk(2);
          return;
        }
      Abort("ONSTART syntax error, can only be used with a SUB.");
    }
  if(strcmp(LStk1,"overloaded")==0){
      if(strcmp(LStk2,"function")==0){
          strcpy(Stk[1],"overloadedfunction");
          strcpy(LStk1,"overloadedfunction");
          LShiftStk(2);
          if(strcmp(Stk[2],"=")!=0){
              OkayToSend=TRUE;
            }
          return;
        }
      if(strcmp(LStk2,"sub")==0){
          strcpy(Stk[1],"overloadedsub");
          LShiftStk(2);
          return;
        }
    }
  if(strcmp(LStk1,"function")==0){
      if(iMatchWrd(Stk[3],"optional")){
          strcpy(Stk[1],"optfunction");
          strcpy(LStk1,"optfunction");
          LShiftStk(3);
          if(strcmp(Stk[2],"=")!=0){
              OkayToSend=TRUE;
            }
          return;
        }
    }
  if(UseCpp==FALSE ){
      if(strcmp(LStk1,"function")==0){
          if(strcmp(Stk[2],"=")!=0){
              for(int ij=3; ij<=Ndx; ij++)
                {
                  if(strcmp(Stk[ij],"=")==0){
                      strcpy(Stk[1],"optfunction");
                      strcpy(LStk1,"optfunction");
                      return;
                    }
                }
            }
        }
    }
  if(strcmp(LStk1,"sub")==0){
      if(iMatchWrd(Stk[3],"optional")){
          strcpy(LStk1,"optsub");
          strcpy(Stk[1],"optsub");
          LShiftStk(3);
          return;
        }
    }
  if(UseCpp==FALSE ){
      if(strcmp(LStk1,"sub")==0){
          for(int ij=2; ij<=Ndx; ij++)
            {
              if(strcmp(Stk[ij],"=")==0){
                  strcpy(Stk[1],"optsub");
                  strcpy(LStk1,"optsub");
                  return;
                }
            }
        }
    }
  if(strcmp(LStk1,"end")==0){
      if(strcmp(Stk[2],"=")!=0){
          strcpy(Stk[1], join(2,LStk1,LStk2));
          if(Ndx==2 ){
              Ndx=1;
              return;
            }
          else
            {
              if(iMatchWrd(Stk[3],"as")){
                  *Stk[2]=0;
                  RemEmptyTokens();
                  return;
                }
            }
        }
    }
  if(strcmp(LStk1,"function")==0){
      if(strcmp(Stk[2],"=")!=0){
          OkayToSend=TRUE;
        }
    }
  if(strcmp(LStk1,"midstr")==0){
      if(inchr(Stk[3],DQ)){
          Abort("MID$ statement string argument cannot be a literal");
        }
      CommaCnt=0;
      for(i=1; i<=Ndx; i++)
        {
          if(*Stk[i]==44 ){
              CommaCnt++;
            }
          else if(strcmp(Stk[i],"=")==0){
              if(CommaCnt<2 ){
                  strcpy(Stk[i],"-1,");
                }
              else
                {
                  *Stk[i]=0;
                }
              strcpy(Stk[i-1],",");
              Ndx++;
              strcpy(Stk[Ndx],")");
              goto L1215;
            }
        }
L1215:;
    }
  if(strcmp(LStk1,"endevents")==0  || strcmp(LStk1,"endmdievents")==0  || strcmp(LStk1,"endmdichildevents")==0){
      char szError[BCXSTRSIZE];
      if(Use_Vscroll||Use_Hscroll ){
          Use_Max=Use_Min=TRUE;
          strcpy(Src,"GLOBAL BCX_siX AS SCROLLINFO");
          Inject(Src);
          strcpy(Src,"GLOBAL BCX_siY AS SCROLLINFO");
          Inject(Src);
          strcpy(Src,"GLOBAL BCX_DynaScroll AS INT");
          Inject(Src);
          fprintf(FP_WRITE,"%s% .15G %s\n","static  int BCX_ViewWidth =",(double)Use_Hscroll,";");
          fprintf(FP_WRITE,"%s% .15G %s\n","static  int BCX_ViewHeight =",(double)Use_Vscroll,";");
          fprintf(FP_WRITE,"%s\n","static  int BCX_SmallChangeX;");
          fprintf(FP_WRITE,"%s\n","static  int BCX_SmallChangeY;");
          fprintf(FP_WRITE,"%s\n","static  int BCX_LargeChangeX;");
          fprintf(FP_WRITE,"%s\n","static  int BCX_LargeChangeY;");
          fprintf(FP_WRITE,"%s\n","static  int BCX_ScrollInit;");
          fprintf(FP_WRITE,"%s\n","");
          fprintf(FP_WRITE,"%s\n","  if(!BCX_ScrollInit)");
          fprintf(FP_WRITE,"%s\n","   {");
          fprintf(FP_WRITE,"%s\n","     BCX_siY.cbSize=sizeof(BCX_siY);");
          fprintf(FP_WRITE,"%s\n","     BCX_siX.cbSize=sizeof(BCX_siX);");
          fprintf(FP_WRITE,"%s\n","     BCX_siY.fMask=SIF_ALL;");
          fprintf(FP_WRITE,"%s\n","     BCX_siX.fMask=SIF_ALL;");
          fprintf(FP_WRITE,"%s\n","     BCX_siX.nMax=BCX_ViewWidth;");
          fprintf(FP_WRITE,"%s\n","     BCX_siY.nMax=BCX_ViewHeight;");
          fprintf(FP_WRITE,"%s\n","     BCX_SmallChangeX=1;");
          fprintf(FP_WRITE,"%s\n","     BCX_LargeChangeX=20;");
          fprintf(FP_WRITE,"%s\n","     BCX_SmallChangeY=1;");
          fprintf(FP_WRITE,"%s\n","     BCX_LargeChangeY=20;");
          fprintf(FP_WRITE,"%s\n","     BCX_siY.nPage=1;");
          fprintf(FP_WRITE,"%s\n","     BCX_siX.nPage=1;");
          fprintf(FP_WRITE,"%s\n","     SetScrollInfo(hWnd,SB_VERT,&BCX_siY,TRUE);");
          fprintf(FP_WRITE,"%s\n","     SetScrollInfo(hWnd,SB_HORZ,&BCX_siX,TRUE);");
          fprintf(FP_WRITE,"%s\n","     BCX_DynaScroll=TRUE;");
          fprintf(FP_WRITE,"%s\n","     BCX_ScrollInit=TRUE;");
          fprintf(FP_WRITE,"%s\n","   }");
          fprintf(FP_WRITE,"%s\n"," if(Msg==WM_HSCROLL||Msg==WM_VSCROLL||Msg==WM_SIZE)");
          fprintf(FP_WRITE,"%s\n","   {");
          fprintf(FP_WRITE,"%s\n","     BCX_Scroll(hWnd,Msg,wParam,lParam,BCX_LargeChangeX,");
          fprintf(FP_WRITE,"%s\n","     BCX_LargeChangeY,BCX_SmallChangeX,BCX_SmallChangeY,");
          fprintf(FP_WRITE,"%s\n","     BCX_ViewWidth,BCX_ViewHeight,BCX_DynaScroll);");
          fprintf(FP_WRITE,"%s\n","   }");
        }
      if(ISFALSE(Use_BCX_Class_Info)){
          Use_BCX_Class_Info=TRUE;
          iEmitVarGroup=iEmitVarGroup|(eFontGroup|eClassName);
        }
      if(strcmp(LStk1,"endmdichildevents")!=0  && Use_MainEvent ){
          Use_MainEvent=FALSE;
          fprintf(FP_WRITE,"%s\n","  if(Msg==WM_DESTROY)");
          fprintf(FP_WRITE,"%s\n","    {");
          fprintf(FP_WRITE,"%s\n","       OleUninitialize();");
          fprintf(FP_WRITE,"%s\n","       CoUninitialize();");
          fprintf(FP_WRITE,"%s\n","       PostQuitMessage(0);");
          fprintf(FP_WRITE,"%s\n","       return EXIT_SUCCESS;");
          fprintf(FP_WRITE,"%s\n","    }");
        }
      if(strcmp(LStk1,"endevents")==0){
          fprintf(FP_WRITE,"%s\n","Bcx_RetVal = DefWindowProc(hWnd,Msg,wParam,lParam);");
          fprintf(FP_WRITE,"%s\n","return Bcx_RetVal; // endevents");
        }
      else if(strcmp(LStk1,"endmdievents")==0){
          fprintf(FP_WRITE,"%s\n","Bcx_RetVal = DefFrameProc(hWnd,BCX_hwndMDIClient,Msg,wParam,lParam);");
          fprintf(FP_WRITE,"%s\n","return Bcx_RetVal;");
        }
      else if(strcmp(LStk1,"endmdichildevents")==0){
          fprintf(FP_WRITE,"%s\n","Bcx_RetVal = DefMDIChildProc(hWnd,Msg,wParam,lParam);");
          fprintf(FP_WRITE,"%s\n","return Bcx_RetVal;");
        }
      fprintf(FP_WRITE,"%s\n","}\n\n");
      sprintf(szError,"Too many unindents for END %s",ucase(LStk1+3));
      BumpDown(szError);
      if(Indent ){
          printf("%s\n",repeat(80,"_"));
          printf("%s%s\n","Possible missing END IF before END ",ucase(mid(LStk1,4)));
          printf("%s\n",repeat(80,"_"));
        }
      Ndx=0;
      InFunction=FALSE;
      return;
    }
  if(strcmp(Stk[2],":")==0){
      if(Ndx==2 ){
          strcpy(LTmp,enc(LStk1,(UCHAR)*(SPC)));
          if(iMatchNQ(" public , private , protected ",LTmp)==0 ){
              strcpy(Stk[1], join(2,ucase(Stk[1]),":"));
              Ndx=1;
            }
          return;
        }
    }
  if(iMatchWrd(Stk[3],"createwindow")){
      Comma=0;
      for(A=4; A<=Ndx; A++)
        {
          if(strcmp(Stk[A],",")==0){
              Comma++;
            }
          if(strcmp(Stk[A],",")==0){
              if(Comma==8 ){
                  strcpy(Stk[A],",(HMENU)(UINT_PTR)");
                  Comma++;
                }
            }
        }
    }
  if(iMatchWrd(Stk[3],"createwindowex")){
      Comma=0;
      for(A=4; A<=Ndx; A++)
        {
          if(strcmp(Stk[A],",")==0){
              Comma++;
            }
          if(strcmp(Stk[A],",")==0){
              if(Comma==9 ){
                  strcpy(Stk[A],",(HMENU)(UINT_PTR)");
                  Comma++;
                }
            }
        }
    }
  if(*Stk[Ndx]==42 ){
      strcpy(Stk[Ndx-1], join(2,Stk[Ndx-1],"*"));
      Ndx--;
    }
  if(iMatchWrd(Stk[3],"setwindowlong")||iMatchWrd(Stk[3],"setwindowlongptr")){
      Comma=0;
      strcpy(Stk[3],"(WNDPROC)(LONG_PTR)SetWindowLongPtr");
      for(A=4; A<=Ndx; A++)
        {
          if(strcmp(Stk[A],",")==0){
              Comma++;
            }
          if(strcmp(Stk[A],",")==0){
              if(Comma==2 ){
                  strcpy(Stk[A],",(LONG_PTR)");
                  Comma++;
                }
            }
        }
      return;
    }
  if(TestState==TRUE ){
      char Tmp[BCXSTRSIZE]={0};
      if(LastCmd==0 ){
          if(*Stk[1]==42 ){
              strcpy(Tmp,Clean(Stk[2]));
            }
          else
            {
              strcpy(Tmp,Clean(Stk[1]));
            }
          if(LeftStr(Tmp,"*")){
              strcpy(Tmp,mid(Tmp,2));
            }
          i=inchr(Tmp,".");
          if(i==0 ){
              i=iMatchNQ(Tmp,"->");
            }
          if(i>0 ){
              if(WithCnt ){
                  strcpy(Tmp,WithVar[WithCnt]);
                }
              else
                {
                  strcpy(Tmp,left(Tmp,i-1));
                }
            }
          if(inchr(Tmp,"[")){
              strcpy(Tmp,extract(Tmp,"["));
            }
          if(CheckLocal(Tmp,&(j))==vt_UNKNOWN ){
              if(CheckGlobal(Tmp,&(j))==vt_UNKNOWN ){
                  strcpy(Tmp,lcase(Tmp));
                  if(strcmp(Stk[2],"=")==0  && IsAllowedContext(Tmp)&&iMatchNQ(Src,"->")==0 ){
                      Warning(join(6,"Assignment before Declaration in Line ",str(LineNum[FileNdx])," in Module: ",trim(FileNames[FileNdx]),": ",Src));
                    }
                }
            }
        }
    }
}

int IsAllowedContext (char* Tmp)
{
  if(strcmp(Tmp,"functionreturn")==0){
      return FALSE;
    }
  if(strcmp(Tmp,"bcx_retstr")==0){
      return FALSE;
    }
  if(strcmp(Tmp,"end")==0){
      return FALSE;
    }
  return TRUE;
}

void RemEmptyTokens ()
{
  int i;
  int j;
  for(i=1; i<=Ndx; i++)
    {
      if(ISNULL(Stk[i])){
          j=i;
          while(ISNULL(Stk[j])&&(j<Ndx)){
              j++;
            }
          if(ISNULL(Stk[j])){
              goto L1219;
            }
          strcpy(Stk[i],Stk[j]);
          *Stk[j]=0;
        }
    }
L1219:;
  Ndx=i-1;
}

void FuncSubDecs1 (char* s,int iStart,int iEnd,VARCODE*  ptVar)
{
  int iBrktPairLoc;
  int iEmpty;
  if(iMatchRgt(Stk[iStart],s)){
      if(DataType(Stk[iStart+1])==vt_STRVAR ){
          Abort(join(3,"Invalid ",s," name"));
        }
    }
  for(iEmpty=FALSE,iBrktPairLoc=GetBrkPairPos(iStart,iEnd); iBrktPairLoc; iBrktPairLoc=GetBrkPairPos(iBrktPairLoc,iEnd))
    {
      int iVarLoc=iBrktPairLoc-1;
      if(iMatchWrd(Stk[iBrktPairLoc+2],"as")){
          strcpy(Stk[iBrktPairLoc+3], join(2,Stk[iBrktPairLoc+3],"*"));
          *Stk[iBrktPairLoc++]=0;
          *Stk[iBrktPairLoc]=0;
          iEmpty=TRUE;
        }
      else if(strcmp(Stk[iBrktPairLoc+2],"[")==0){
          while(iBrktPairLoc<=iEnd){
              if(iMatchWrd(Stk[iBrktPairLoc],"as")){
                  goto L1222;
                }
              if(iMatchRgt(Stk[iVarLoc],"]")&&inchr(",)=",Stk[iBrktPairLoc])){
                  goto L1222;
                }
              strcpy(Stk[iVarLoc], join(2,Stk[iVarLoc],Stk[iBrktPairLoc]));
              *Stk[iBrktPairLoc++]=0;
              iEmpty=TRUE;
            }
L1222:;
        }
      else
        {
          int iDataType=DataType(Stk[iVarLoc]);
          strcpy(Stk[iVarLoc],Clean(Stk[iVarLoc]));
          if(iDataType==vt_STRVAR ){
              InsertTokens(iBrktPairLoc+1,5,"[","BCXSTRSIZE","]","as","char");
              iEnd+=(5);
            }
          else
            {
              strcpy(Stk[iBrktPairLoc++],"as");
              strcpy(Stk[iBrktPairLoc], join(2,GetVarTypeName(iDataType),"*"));
            }
        }
    }
  if(iMatchWrd(Stk[iEnd],"export")){
      Ndx--;
      ptVar->IsExported=TRUE;
      if(UseStdCall ){
          strcpy(CallType,"__stdcall ");
        }
      else
        {
          strcpy(CallType,"__cdecl ");
        }
    }
  if(iEmpty ){
      RemEmptyTokens();
    }
}

void FuncSubDecs2 (char* s,int methd,VARCODE*  VarCode,int iFirstToken,int* iLastToken)
{
  if(iMatchRgt(Stk[iFirstToken],s)){
      if(iMatchWrd(Stk[*iLastToken-1],"as")){
          Abort(join(2,"Attempted type assignment to ",s));
        }
      VarCode->IsPtrFlag=0;
      CurrentFuncType=vt_VOID;
    }
  else
    {
      if(iMatchWrd(Stk[(*iLastToken)-1],"as")){
          CurrentFuncType=CheckType(Stk[*iLastToken]);
          strcpy(VarCode->Token,Stk[iFirstToken+1]);
          strcpy(VarCode->AsToken,Stk[*iLastToken]);
          VarCode->IsPtrFlag=tally(Stk[*iLastToken],"*");
          *Stk[(*iLastToken)--]=0;
          *Stk[(*iLastToken)--]=0;
        }
      else
        {
          if(Ctor_Dtor_Detected(1)){
              CurrentFuncType=vt_CONSTRDESTR;
            }
          else
            {
              CurrentFuncType=DataType(Stk[iFirstToken+1]);
            }
          strcpy(VarCode->Token,Stk[iFirstToken+1]);
          VarCode->IsPtrFlag=tally(Stk[iFirstToken+1],"*");
          *VarCode->AsToken=0;
        }
    }
  strcpy(VarCode->Proto," (");
  strcpy(VarCode->Header," (");
  *VarCode->Functype=0;
  VarCode->Methd=methd;
  VarCode->VarNo=CurrentFuncType;
  GetVarCode(VarCode,"FuncSubDecs2");
}

void FuncSubDecs3 (VARCODE*  varcode,int iLast,int iExtended)
{
  if(*Stk[iLast-1]==46 ){
      strcpy(Stk[iLast-1],"...");
    }
  strcpy(varcode->Header,rtrim(varcode->Header));
  strcat(varcode->Header,")");
  if(UseCpp==FALSE ){
      strcpy(varcode->Header,replace(varcode->Header,"()","(void)"));
    }
  if(iExtended ){
      strcpy(varcode->Header, join(5,varcode->Functype,"(*",varcode->Token,")",varcode->Header));
    }
  else
    {
      strcpy(varcode->Header, join(3,varcode->Functype,varcode->Token,varcode->Header));
    }
  if(varcode->Methd==2 ){
      strcpy(varcode->Proto,rtrim(varcode->Proto));
      if(iMatchRgt(varcode->Proto,",")){
          midstr(varcode->Proto,(int)strlen(varcode->Proto),-1,")");
        }
      else
        {
          strcat(varcode->Proto,")");
        }
      strcpy(varcode->Proto,replace(varcode->Proto,"()","(void)"));
      if(iExtended ){
          strcpy(varcode->Proto, join(3,varcode->Functype,"(*)",varcode->Proto));
        }
      else
        {
          strcpy(varcode->Proto, join(4,varcode->Functype,varcode->Token,varcode->Proto,";"));
        }
    }
  if(varcode->UseInLine ){
      strcpy(varcode->Header, join(2,"inline ",varcode->Header));
      strcpy(varcode->Proto, join(2,"inline ",varcode->Proto));
    }
  UseInLine=FALSE;
  if(varcode->IsExported ){
      UseImportExport=TRUE;
      strcpy(varcode->Proto, join(2,"C_EXPORT ",varcode->Proto));
      strcpy(varcode->Header, join(2,"C_EXPORT ",varcode->Header));
    }
  strcpy(varcode->Proto,replace(varcode->Proto," . ","."));
  strcpy(varcode->Header,replace(varcode->Header," . ","."));
}

void AddTypeDefs (char* sTypeDefName,int TDef)
{
  TypeDefsCnt++;
  if(TypeDefsCnt==MaxTypes ){
      Abort("Exceeded TYPE Limits.");
    }
  strcpy(TypeDefs[TypeDefsCnt].VarName,sTypeDefName);
  TypeDefs[TypeDefsCnt].TypeofDef=TDef;
  TypeDefs[TypeDefsCnt].EleCnt=0;
}

int CheckTypeDefs (char *ParmStr)
{
  if(TypeDefsCnt>0 ){
      for(int i=1; i<=TypeDefsCnt; i++)
        {
          if(strcmp(ParmStr,TypeDefs[i].VarName)==0){
              return i;
            }
        }
    }
  return 0;
}

void GetTypeInfo (char* szArg,int* IsPointer,int* UdtIdx,int* vtCode)
{
  char Var1[BCXSTRSIZE];
  (*IsPointer)=tally(szArg,"*");
  strcpy(Var1,trim(RemoveStr(szArg,"*")));
  if(RightStr(Var1,"_CLASS")){
      strcpy(Var1,left(Var1,(int)strlen(Var1)-6));
    }
  (*vtCode)=CheckType(Var1);
  if((*vtCode)==vt_UNKNOWN ){
      AddTypeDefs(Var1,vt_UDT);
      (*vtCode)=vt_UDT;
    }
  (*UdtIdx)=0;
  if((*vtCode)==vt_STRUCT||(*vtCode)==vt_UNION||(*vtCode)==vt_UDT ){
      (*UdtIdx)=CheckTypeDefs(Var1);
    }
}

void AddTypedefElement (int WorkingTypeDefsCnt,int ElType,char* EName,char* EType,int EPtr)
{
  struct _USERTYPEDEF*  TD;
  TD=&((TypeDefs[WorkingTypeDefsCnt]));
  if(TD->EleCnt==MaxElements ){
      Abort("Exceeded TYPE Element Limits.");
    }
  TD->Elements[TD->EleCnt].ElementType=ElType;
  TD->Elements[TD->EleCnt].ElementDynaPtr=EPtr;
  if(ElType==vt_STRUCT||ElType==vt_UNION||ElType==vt_UDT ){
      TD->Elements[TD->EleCnt].ElementID=CheckTypeDefs(EType);
    }
  else
    {
      TD->Elements[TD->EleCnt].ElementID=0;
    }
  strcpy(TD->Elements[TD->EleCnt].ElementName,EName);
  TD->EleCnt=1+TD->EleCnt;
}

char * GetElement (int StartStk,int* vt,int* dms,int id)
{
  char   *BCX_RetStr={0};
  int BC=0;
  int i;
  char LZZ[BCXSTRSIZE];
  for(i=StartStk+1; i<=Ndx; i++)
    {
      if(*Stk[i]==91 ){
          BC++;
        }
      else if(*Stk[i]==93 ){
          BC--;
        }
      else
        {
          if(BC==0 ){
              if(iMatchLft(Stk[i],"->")||*Stk[i]==46 ){
                  strcpy(LZZ,Stk[i]);
                  RemoveAll(LZZ,"%$#!@`.->( *)",1);
                  (*vt)=GetElementInfo(&(id),&(*dms),LZZ);
                  if((*vt)!=vt_STRUCT&&(*vt)!=vt_UNION ){
                      goto L1224;
                    }
                }
            }
        }
    }
L1224:;
  if((*vt)==vt_UDT||(*vt)==vt_UNION||(*vt)==vt_STRUCT ){
      strcpy(LZZ,TypeDefs[id].VarName);
    }
  else
    {
      strcpy(LZZ,GetVarTypeName(*vt));
    }
  BCX_RetStr = BCX_TempStr(strlen(LZZ));
  strcpy(BCX_RetStr,LZZ);
  return BCX_RetStr;
}

int GetElementInfo (int* DefID,int* EPtr,char* Elename)
{
  int id;
  id=(*DefID);
  for(int i=0; i<=TypeDefs[id].EleCnt-1; i++)
    {
      if(strcmp(Elename,TypeDefs[id].Elements[i].ElementName)==0){
          (*DefID)=TypeDefs[id].Elements[i].ElementID;
          (*EPtr)=TypeDefs[id].Elements[i].ElementDynaPtr;
          return TypeDefs[id].Elements[i].ElementType;
        }
    }
  return 0;
}

void Process_Option_Base ()
{
  for(int i=1; i<=Ndx; i++)
    {
      if(iMatchWrd(Stk[i],"as")){
          strcpy(Stk[i-1],Clean(Stk[i-1]));
        }
      if(strcmp(Stk[i],"=")==0){
          return;
        }
      if(OptionBase ){
          if(*Stk[i]==91&&*Stk[i+1]==93 ){
              continue;
            }
          if(*Stk[i]==91&&*Stk[i+1]!=93 ){
              if(DataType(Stk[i+1])==vt_NUMBER ){
                  strcpy(Stk[i+1],str(OptionBase+VAL(Stk[i+1]),1));
                }
              else
                {
                  strcpy(Stk[i+1], join(3,str(OptionBase,TRUE),"+",Stk[i+1]));
                }
            }
        }
    }
}

int IsValidName (char* szArg)
{
  if(!isalpha(*szArg)&&*szArg!=95&&!((unsigned char)*szArg>192)){
      if(!iMatchLft(szArg,"(*") && strcmp(szArg,"&")!=0){
          return FALSE;
        }
    }
  return TRUE;
}

void ValidateVarName (char* v)
{
  char LZZ[BCXSTRSIZE];
  if(LeftStr(v,"3.14")){
      Abort("PI is predefined in BCX.  You cannot DIM PI ...");
    }
  if(!isalpha(*v)&&*v!=95&&!((unsigned char)*v>192)){
      if(!iMatchLft(v,"(*") && strcmp(v,"&")!=0){
          Abort("Invalid String Variable Name");
        }
    }
  if(RestrictedWords(v)&&TestState ){
      strcpy(LZZ, join(3,"Variable ",v," on line"));
      strcpy(LZZ, join(5,LZZ,str(LineNum[FileNdx])," in Module: ",trim(FileNames[FileNdx])," is a Restricted Word"));
      Warning(LZZ);
    }
}

void PointerFix ()
{
  strcpy(Stk[Ndx-1], join(2,Stk[Ndx-1],Stk[Ndx]));
  *Stk[Ndx]=0;
  Ndx--;
  while(tally(Stk[Ndx],"*")==(int)strlen(Stk[Ndx])){
      strcpy(Stk[Ndx-1], join(2,Stk[Ndx-1],Stk[Ndx]));
      *Stk[Ndx]=0;
      Ndx--;
    }
}

void DimDynaString (char* SVar,int DG,int s)
{
  char DS[BCXSTRSIZE];
  strcpy(DS, join(7,"if (",SVar,") {free(",SVar,"); ",SVar," = NULL;}"));
  if(InFunction&&(IsLocal||IsDim||IsRaw||IsAuto||IsRegister)&&DG==0 ){
      if(cMaxDynaStr==++LocalDynaCnt ){
          Abort("Maximum number of local dynamic allocations exceeded.");
        }
      strcpy(DynaStr[LocalDynaCnt],DS);
      if(IsAuto ){
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"char *",SVar,";");
        }
      else if(IsRegister ){
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"char *",SVar,";");
        }
      else
        {
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"char *",SVar,";");
        }
      AddLocal(SVar,vt_CHAR,0,"",1);
    }
  else
    {
      if(Use_GenFree ){
          AddDynamicGlobal(DS);
        }
      if(DG==2 ){
          AddGlobal(SVar,vt_CHAR,0,"",1,0,1);
        }
      else
        {
          if(s ){
              AddGlobal(SVar,vt_CHAR,0,"",1,0,2);
            }
          else
            {
              AddGlobal(SVar,vt_CHAR,0,"",1);
            }
        }
    }
  if(DG!=2 ){
      fprintf(FP_WRITE,"%s%s%s",Scoot,SVar,"=(char*)calloc(");
      strcpy(Stk[++Ndx],",1);");
      WriteCleanTokens(4,Ndx);
    }
}

void AddDynamicGlobal (PCHAR szGlobalStr)
{
  GlobalDynaCnt++;
  if(cMaxGlobalDyna==GlobalDynaCnt ){
      Abort("Maximum number of global dynamic arrays exceeded.");
    }
  strcpy(GlobalDynaStr[GlobalDynaCnt],szGlobalStr);
}

int SubFuncTest ()
{
  if(iMatchWrd(Stk[2],"function")||iMatchWrd(Stk[2],"sub")){
      return 1;
    }
  return 0;
}

int Ctor_Dtor_Detected (int iTokenLoc)
{
  if(iMatchWrd(Stk[iTokenLoc],"constructor")||iMatchWrd(Stk[iTokenLoc],"destructor")){
      return 1;
    }
  return 0;
}

int DimSubFunc (int iMethod)
{
  BOOL  bOppFound;
  int Funptr=0;
  int i;
  int id;
  int iEqualLoc;
   char LTmp[BCXSTRSIZE];  strcpy(LTmp,"");
  int StartPoint=3;
  char szInit[BCXSTRSIZE];
  char szIsConst[BCXSTRSIZE];
  char szStatic[BCXSTRSIZE];
  char szV[BCXSTRSIZE];
  char szWrk[BCXSTRSIZE];
  int vt;
  int w;
  struct _FUNCPARSE  FP;
  Clear(FP);
  if(iMatchWrd(Stk[Ndx],"stdcall")){
      strcpy(CallType,"__stdcall ");
      *Stk[Ndx--]=0;
      IsStdFunc=TRUE;
    }
  else
    {
      if(InClass||InCppTypeDef ){
          *CallType=0;
        }
      else
        {
          strcpy(CallType,"__cdecl ");
        }
      IsStdFunc=FALSE;
    }
  if(iMatchWrd(Stk[3],"operator")){
      for(i=4,bOppFound=FALSE; !bOppFound; i++)
        {
          if(strcmp(Stk[i],"(")==0){
              if(strcmp(Stk[i+1],")")!=0  && strcmp(Stk[i+2],"(")!=0){
                  bOppFound=TRUE;
                }
              if(strcmp(Stk[i+1],")")==0  && i>4 ){
                  bOppFound=TRUE;
                }
            }
          if(!bOppFound ){
              strcpy(Stk[3], join(2,Stk[3],Stk[i]));
              *Stk[i]=0;
            }
        }
    }
  strcpy(szWrk,Clean(Stk[Ndx]));
  if(*szWrk ){
      GetTypeInfo(szWrk,&(w),&(id),&(vt));
      if(vt==vt_WINBOOL ){
          strcpy(Stk[Ndx],iReplace(Stk[Ndx],"WINBOOL","BOOL"));
        }
    }
  SepFuncArgs(3,&(FP),TRUE);
  StartPoint=IMAX(FP.CommaPos[0],3);
  if(!InTypeDef&&!InCppTypeDef&&!InClass ){
      SFPOINTER=TRUE;
      if(FP.NumArgs==0 ){
          i=IMIN(FP.CommaPos[1]+1,Ndx);
        }
      else
        {
          i=IMIN(FP.CommaPos[FP.NumArgs]+1,Ndx);
        }
      if(strcmp(Stk[i],"=")==0){
          *Stk[i++]=0;
          while(!iMatchWrd(Stk[i],"as")&&i<=Ndx){
              strcat(LTmp,Stk[i]);
              *Stk[i++]=0;
            }
          RemoveAll(LTmp,"{}",1);
          if(LTmp[0]!=0 ){
              RemEmptyTokens();
            }
        }
      fprintf(FP_UDT,"%s%s%s\n",Scoot,MakeDecProto(&(FP)),";");
      SFPOINTER=FALSE;
      Ndx=StartPoint;
      *Stk[2]=0;
      if(LTmp[0]!=0 ){
          strcpy(Stk[Ndx++],"=");
          strcpy(Stk[Ndx++],"{");
          strcpy(Stk[Ndx++],Clean(LTmp));
          strcpy(Stk[Ndx++],"}");
        }
      strcpy(Stk[Ndx++],"as");
      strcpy(Stk[Ndx], join(3,Clean(Stk[3]),"_TYPE",stringx(Funptr,42)));
      RemEmptyTokens();
      return FALSE;
    }
  else
    {
      *szV=0;
      *szWrk=0;
      *szStatic=0;
      *szIsConst=0;
      *szInit=0;
      iEqualLoc=Ndx;
      if(IsVirtual ){
          strcpy(szV,"virtual ");
          IsVirtual=FALSE;
        }
      else
        {
          *szV=0;
        }
      while(strcmp(Stk[iEqualLoc],"=")!=0  && iEqualLoc){
          if(strcmp(Stk[iEqualLoc],")")==0){
              goto L1230;
            }
          iEqualLoc--;
        }
L1230:;
      if(strcmp(Stk[iEqualLoc],"=")==0){
          strcpy(szInit,Stk[iEqualLoc++]);
          strcat(szInit,Stk[iEqualLoc++]);
        }
      if(iMatchWrd(Stk[Ndx],"const")){
          strcpy(szIsConst,"const");
        }
      else
        {
          *szIsConst=0;
        }
      if(iMatchWrd(Stk[1],"static")){
          strcpy(szStatic,"static ");
        }
      else
        {
          *szStatic=0;
        }
      strcpy(szWrk,MakeDecProto(&(FP)));
      if(iMethod ){
          strcpy(szWrk,trim(mid(szWrk,inchr(szWrk,SPC))));
        }
      if(strcmp(szVirtual,szInit)==0){
          *szInit=0;
        }
      fprintf(FP_UDT,"%s%s%s%s%s%s%s%s\n",Scoot,szV,szStatic,szWrk,szVirtual,szInit,szIsConst,";");
      *szVirtual=0;
    }
  return TRUE;
}

void InBlockReSet ()
{
  LocalVarCnt=LocalInBlock[InBlock];
  InBlock--;
  if(InBlock<0 ){
      Abort("Too many END BLOCKS");
    }
}

void InBlockSet ()
{
  InBlock++;
  if(InBlock==cMaxLocalInBlocks ){
      Abort("Too many nested BEGINBLOCK/ENDBLOCKs");
    }
  LocalInBlock[InBlock]=LocalVarCnt;
}

void AddSpace (int i)
{
  if(IsValidName(Stk[i])&&IsValidName(Stk[i+1])){
      strcpy(Stk[i], join(2,Stk[i],SPC));
    }
}

void Emit_Old (int* FuncRetnFlag)
{
  int strtest={0};
  int varid={0};
  struct _VARINFO*  vi={0};
  char vr[BCXSTRSIZE]={0};
  int brcnt={0};
  char LTmp[BCXSTRSIZE]={0};
  int eo_H={0};
  int eo_I={0};
  int eo_J={0};
  int eo_K={0};
  int HasStorage={0};
  char Arg[BCXSTRSIZE];
  int EqlSgnPos;
  if(Ndx==0 ){
      return;
    }
  for(int i=1; i<=Ndx; i++)
    {
      if(Im_UDT_String(Stk[i])){
          strcpy(Stk[i], join(2,Stk[i],"$"));
        }
      if(Im_UDT_Single(Stk[i])){
          strcpy(Stk[i], join(2,Stk[i],"!"));
        }
      if(Im_UDT_Double(Stk[i])){
          strcpy(Stk[i], join(2,Stk[i],"#"));
        }
    }
  for(EqlSgnPos=1; EqlSgnPos<=Ndx; EqlSgnPos++)
    {
      if(*Stk[EqlSgnPos]==61 ){
          if(!(*Stk[EqlSgnPos-1]==60||*Stk[EqlSgnPos-1]==62||*Stk[EqlSgnPos-1]==43||*Stk[EqlSgnPos-1]==45||*Stk[EqlSgnPos-1]==47||*Stk[EqlSgnPos-1]==42)){
              goto L1232;
            }
        }
    }
L1232:;
  if(EqlSgnPos-1==Ndx ){
      BuildCleanStr(1,Ndx,LTmp);
      strcat(LTmp,";");
      if(*FuncRetnFlag==2 ){
          fprintf(FP_WRITE,"%s\n",LTmp);
        }
      else
        {
          fprintf(FP_WRITE,"%s%s\n",Scoot,LTmp);
        }
      if(*FuncRetnFlag==2 ){
          *FuncRetnFlag=0;
          *Stk[1]=0;
          return;
        }
      return;
    }
  for(eo_I=2; eo_I<=EqlSgnPos-1; eo_I++)
    {
      strcpy(Stk[1], join(2,Stk[1],Stk[eo_I]));
    }
  if(Im_UDT_String(Stk[1])){
      strcpy(Stk[1], join(2,Stk[1],"$"));
      for(int i=EqlSgnPos+1; i<=Ndx; i++)
        {
          if(strcmp(Stk[i],"+")==0){
              if(strcmp(Stk[i+1],"+")==0){
                  goto L1234;
                }
              strcpy(Stk[i],"&");
              goto L1234;
            }
        }
L1234:;
    }
  eo_H=inchr(Stk[1],"*");
  if(eo_H ){
      if(!(inchr(Stk[1],"$")&&eo_H>1)){
          RemoveAll(Stk[1],"$");
          goto PROCESSNUMERIC;
        }
    }
  strtest=DataType(Stk[1]);
  if(*Stk[1]!=40 ){
      if(strtest==vt_UNKNOWN ){
          strcpy(Stk[1], join(2,Stk[1],"$"));
          strtest=vt_STRVAR;
        }
    }
  if(strtest==vt_INTEGER ){
      brcnt=tally(Stk[1],"[");
      strcpy(vr,extract(Stk[1],"["));
      strtest=CheckLocal(vr,&(varid));
      if(strtest==vt_UNKNOWN ){
          strtest=CheckGlobal(vr,&(varid));
          vi=&((GlobalVars[varid]));
        }
      else
        {
          vi=&((LocalVars[varid]));
        }
      if(strtest==vt_CHAR||strtest==vt_SCHAR ){
          strtest=vt_STRVAR;
        }
      if(strtest==vt_STRVAR ){
          if(NOTZERO(vi->VarPntr)){
              goto PROCESSNUMERIC;
            }
          if(tally(vi->VarDim,"[")==brcnt ){
              goto PROCESSNUMERIC;
            }
          if(tally(vi->VarDim,"[")!=brcnt+1 ){
              goto PROCESSNUMERIC;
            }
        }
    }
  if(strtest==vt_UNKNOWN ){
      if(!inchr(Stk[1],"$")){
          if(Im_UDT_String(Stk[1])){
              strcpy(Stk[1], join(2,Stk[1],"$"));
              strtest=vt_STRVAR;
            }
        }
    }
  if(strtest==vt_UNKNOWN ){
      if(!inchr(Stk[1],"!")){
          if(Im_UDT_Single(Stk[1])){
              strcpy(Stk[1], join(2,Stk[1],"!"));
              strtest=vt_SINGLE;
            }
        }
    }
  if(strtest==vt_UNKNOWN ){
      if(!inchr(Stk[1],"#")){
          if(Im_UDT_Double(Stk[1])){
              strcpy(Stk[1], join(2,Stk[1],"#"));
              strtest=vt_DOUBLE;
            }
        }
    }
  if(strtest==vt_STRVAR ){
      if(EqlSgnPos+1==Ndx ){
          if(strcmp(Stk[Ndx],DDQ)==0){
              fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"*",Clean(Stk[1]),"=0;");
              goto STRINGEXIT;
            }
        }
      if(Ndx==3 ){
          strcpy(Stk[1],Clean(Stk[1]));
          strcpy(Stk[3],Clean(Stk[3]));
          if(strcmp(Stk[1],"BCX_RetStr")==0){
              fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"BCX_RetStr = BCX_TempStr(strlen(",Stk[3],"));");
            }
          fprintf(FP_WRITE,"%s%s%s%s%s%s\n",Scoot,"strcpy(",Stk[1],",",Stk[3],");");
          goto STRINGEXIT;
        }
      *Arg=0;
      *LTmp=0;
      eo_J=eo_K=0;
      if(iMatchLft(Stk[3],"$$")){
          HasStorage=TRUE;
        }
      strcpy(Var,Clean(Stk[1]));
      if(strcmp(Clean(Stk[EqlSgnPos+1]),Var)==0){
          eo_K=TRUE;
        }
      for(eo_H=EqlSgnPos+1; eo_H<=Ndx; eo_H++)
        {
          if(strcmp(Stk[eo_H],"&")==0  && strcmp(Stk[eo_H-1],",")!=0  && strcmp(Stk[eo_H-1],"(")!=0){
              eo_J++;
              strcat(Arg,LTmp);
              strcpy(LTmp,",");
            }
          else
            {
              strcat(LTmp,Clean(Stk[eo_H]));
            }
        }
      if(NOTNULL(LTmp) && strcmp(LTmp,",")!=0){
          strcat(Arg,LTmp);
        }
      RemoveAll(Var,SPC);
      if(eo_J==0 ){
          if(strcmp(Var,"BCX_RetStr")==0){
              if(HasStorage ){
                  fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"BCX_RetStr=",Arg,";");
                  goto STRINGEXIT;
                }
              else
                {
                  fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"BCX_RetStr = BCX_TempStr(strlen(",Arg,"));");
                }
            }
          if(strcmp(right(Var,3),"[0]")==0  && strcmp(Arg,"0")==0){
              fprintf(FP_WRITE,"%s%s%s\n",Scoot,Var," = 0;");
            }
          else
            {
              fprintf(FP_WRITE,"%s%s%s%s%s%s\n",Scoot,"strcpy(",Var,",",Arg,");");
            }
          goto STRINGEXIT;
        }
      if(eo_K==TRUE&&eo_J==1 ){
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"strcat(",Arg,");");
          goto STRINGEXIT;
        }
      strcpy(LTmp,str(++eo_J,1));
      Use_Join=Use_BcxTempStr=TRUE;
      if(strcmp(Var,"BCX_RetStr")==0){
          fprintf(FP_WRITE,"%s%s%s%s%s%s\n",Scoot,"BCX_RetStr=join(",LTmp,",",Arg,");");
        }
      else
        {
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"strcpy(",Var,", join(",LTmp,",",Arg,"));");
        }

STRINGEXIT:;
      return;
    }
  else
    {

PROCESSNUMERIC:;
      for(int i=1; i<=Ndx; i++)
        {
          if(strcmp(Stk[i],"!=")==0){
              strcpy(Stk[i],chr(198,230));
            }
        }
      for(eo_I=2; eo_I<=EqlSgnPos; eo_I++)
        {
          *Stk[eo_I]=0;
        }
      strcpy(Stk[EqlSgnPos],"=");
      if(strcmp(Stk[EqlSgnPos+1],Stk[1])==0  && Ndx==5 ){
          if(InstrAny(Stk[EqlSgnPos+2],"+-*/") && strcmp(Stk[EqlSgnPos+3],">")!=0){
              strcpy(Stk[EqlSgnPos], join(2,Stk[EqlSgnPos+2],Stk[EqlSgnPos]));
              *Stk[EqlSgnPos+1]=0;
              *Stk[EqlSgnPos+2]=0;
            }
        }
      for(eo_H=2; eo_H<=Ndx; eo_H++)
        {
          if(isdigit(*Stk[eo_H])&&iMatchRgt(Stk[eo_H],"E")){
              strcpy(Stk[eo_H], join(2,Stk[eo_H],Stk[eo_H+1]));
              if(*Stk[eo_H+1]==45 ){
                  strcpy(Stk[eo_H], join(2,Stk[eo_H],Stk[eo_H+2]));
                  *Stk[eo_H+2]=0;
                }
              *Stk[eo_H+1]=0;
            }
        }
      fprintf(FP_WRITE,"%s%s",Scoot,Clean(Stk[1]));
      int eo_FoundEql={0};
      for(int A=2; A<=Ndx; A++)
        {
          if(*Stk[A]==61 ){
              eo_FoundEql=TRUE;
            }
          if(*Stk[A]==33 ){
              fprintf(FP_WRITE,"%s","!");
              if(eo_FoundEql==FALSE ){
                  if(*Stk[A-1]!=61 ){
                      strcpy(Stk[A-1],replace(Stk[A-1],chr(198,230),"!="));
                      fprintf(FP_WRITE,"%s","=");
                    }
                }
            }
          else
            {
              strcpy(Stk[A],Clean(Stk[A]));
              strcpy(Stk[A],replace(Stk[A],chr(198,230),"!="));
              fprintf(FP_WRITE,"%s",Stk[A]);
            }
          if(A<Ndx ){
              if(ISFALSE(ispunct(*Stk[A+1]))){
                  fprintf(FP_WRITE,"%s","");
                }
            }
        }
      fprintf(FP_WRITE,"%s\n",";");
    }
}

void Display_Version_and_Compiler ()
{
  if(BCX_COLORS ){
      color (10,0 );
    }
  printf("%s%s%s\n","Version ",VERSION,Compiler_Used());
  PopColors();
}

char * Compiler_Used ()
{
  char   *BCX_RetStr={0};
   char Buff[BCXSTRSIZE];  strcpy(Buff," Compiled using ");
#if defined __BCPLUSPLUS__ 
  strcat(Buff,"Embarcadero C++");
#elif defined __INTEL_LLVM_COMPILER 
  strcat(Buff,"Intel C++ Compiler");
#elif defined __BORLANDC__ 
  strcat(Buff,"Embarcadero C++");
#elif defined __DMC__ 
  strcat(Buff,"Digital Mars C/C++");
#elif defined __POCC__ 
  strcat(Buff,"Pelles C");
#elif defined __LCC__ 
  strcat(Buff,"Lcc-Win32");
#elif defined __clang__ & __MINGW64__
  strcat(Buff,"LLVM-MinGW64 (");
  strcat(Buff,__VERSION__);
  strcat(Buff,")");
#elif defined __MINGW64__ 
  strcat(Buff,"MinGW64 C++ (");
  strcat(Buff,__VERSION__);
  strcat(Buff,")");
#elif defined __MINGW32__ 
  strcat(Buff,"MinGW32 C++ (");
  strcat(Buff,__VERSION__);
  strcat(Buff,")");
#elif defined __clang__ 
  strcat(Buff,"LLVM-Clang (");
  strcat(Buff,str(__clang_major__,1));
  strcat(Buff,".");
  strcat(Buff,str(__clang_minor__,1));
  strcat(Buff,".");
  strcat(Buff,str(__clang_patchlevel__,1));
  strcat(Buff,")");
#elif defined _MSC_VER 
  strcat(Buff,"MS Visual C++ (");
  strcat(Buff,str(_MSC_FULL_VER,1));
  strcat(Buff,")");
#else
  strcat(Buff,"Unknown Compiler");
#endif
#if defined _WIN64 
  strcat(Buff," for 64-bit Windows");
#else
  strcat(Buff," for 32-bit Windows");
#endif
  BCX_RetStr = BCX_TempStr(strlen(Buff));
  strcpy(BCX_RetStr,Buff);
  return BCX_RetStr;
}

void KillFiles ()
{
  if(DebugModeOff ){
      DeleteFile ((hdrFile));
      DeleteFile ((enuFile));
      DeleteFile ((SysFile));
      DeleteFile ((UsrFile));
      DeleteFile ((udtFile));
      DeleteFile ((setFile));
      DeleteFile ((cppFile));
      DeleteFile ((prcFile));
      DeleteFile ((ovrFile));
      DeleteFile ((datFile));
      DeleteFile ((resFile));
    }
}

void Abort (char* AbortStr)
{
  int  i={0};
  int  j={0};
  int  k={0};
  char t[BCXSTRSIZE]={0};
  int varnum={0};
  char frmt[BCXSTRSIZE]={0};
  *WarnMsg=0;
  if(LeftStr(AbortSrc,"$BCXVERSION")){
      strcat(WarnMsg,AbortStr);
    }
  else
    {
      strcpy(WarnMsg, join(4,WarnMsg,AbortStr," at line",str(LineNum[FileNdx])));
      strcpy(WarnMsg, join(4,WarnMsg," in Module: ",trim(FileNames[FileNdx]),CRLF));
      strcpy(WarnMsg, join(3,WarnMsg,"Original line",CRLF));
      strcpy(WarnMsg, join(3,WarnMsg,AbortSrc,CRLF));
      strcpy(WarnMsg, join(3,WarnMsg,"==============",CRLF));
      strcpy(WarnMsg, join(3,WarnMsg,"Current Tokens",CRLF));
      strcpy(WarnMsg, join(3,WarnMsg,"==============",CRLF));
      for(k=1; k<=Ndx; k++)
        {
          j=(int)strlen(Stk[k]);
          if(j<40 ){
              j=40-j;
            }
          else
            {
              j=8-imod(j,8);
            }
          strcpy(frmt,lpad(str(k),3));
          strcpy(WarnMsg, join(6,WarnMsg,frmt,SPC,Stk[k],stringx(j,32),CRLF));
          strcpy(t,Clean(Stk[k]));
          i=CheckLocal(t,&(varnum));
          if(i!=vt_UNKNOWN ){
              strcpy(WarnMsg,trim(WarnMsg));
              strcpy(WarnMsg, join(3,WarnMsg," is a LOCAL defined at line",str(LocalVars[varnum].VarLine)));
              strcpy(WarnMsg, join(4,WarnMsg," in Module: ",LocalVars[varnum].VarModule,CRLF));
            }
          else
            {
              i=CheckGlobal(t,&(varnum));
              if(i!=vt_UNKNOWN ){
                  strcpy(WarnMsg,trim(WarnMsg));
                  strcpy(WarnMsg, join(3,WarnMsg," is a GLOBAL defined at line",str(GlobalVars[varnum].VarLine)));
                  strcpy(WarnMsg, join(3,WarnMsg," in Module: ",GlobalVars[varnum].VarModule));
                  strcpy(WarnMsg, join(5,WarnMsg,SPC,Stk[k],GlobalVars[varnum].VarDim," as "));
                  if(GlobalVars[varnum].VarDef ){
                      strcpy(WarnMsg, join(3,WarnMsg,trim(TypeDefs[GlobalVars[varnum].VarDef].VarName),CRLF));
                    }
                  else
                    {
                      strcpy(WarnMsg, join(3,WarnMsg,trim(GetVarTypeName(GlobalVars[varnum].VarType)),CRLF));
                    }
                }
              else
                {
                  if(*Stk[k]==c_DblQt ){
                      strcpy(WarnMsg,trim(WarnMsg));
                      strcpy(WarnMsg, join(3,WarnMsg," is a string literal",CRLF));
                    }
                }
            }
        }
      strcpy(WarnMsg, join(3,WarnMsg,"===============",CRLF));
      strcpy(WarnMsg, join(3,WarnMsg,"Original Tokens",CRLF));
      strcpy(WarnMsg, join(3,WarnMsg,"===============",CRLF));
      XParse(AbortSrc);
      for(k=1; k<=Ndx; k++)
        {
          j=(int)strlen(Stk[k]);
          if(j<40 ){
              j=40-j;
            }
          else
            {
              j=8-imod(j,8);
            }
          strcpy(frmt,lpad(str(k),3));
          strcpy(WarnMsg, join(6,WarnMsg,frmt,SPC,Stk[k],stringx(j,32),CRLF));
          strcpy(t,Clean(Stk[k]));
          i=CheckLocal(t,&(varnum));
          if(i!=vt_UNKNOWN ){
              strcpy(WarnMsg,trim(WarnMsg));
              strcpy(WarnMsg, join(3,WarnMsg," is a LOCAL defined at line",str(LocalVars[varnum].VarLine)));
              strcpy(WarnMsg, join(4,WarnMsg," in Module: ",LocalVars[varnum].VarModule,CRLF));
            }
          else
            {
              i=CheckGlobal(t,&(varnum));
              if(i!=vt_UNKNOWN ){
                  strcpy(WarnMsg,trim(WarnMsg));
                  strcpy(WarnMsg, join(3,WarnMsg," is a GLOBAL defined at line",str(GlobalVars[varnum].VarLine)));
                  strcpy(WarnMsg, join(3,WarnMsg," in Module: ",GlobalVars[varnum].VarModule));
                  strcpy(WarnMsg, join(5,WarnMsg,SPC,Stk[k],GlobalVars[varnum].VarDim," as "));
                  if(GlobalVars[varnum].VarDef ){
                      strcpy(WarnMsg, join(3,WarnMsg,TypeDefs[GlobalVars[varnum].VarDef].VarName,CRLF));
                    }
                  else
                    {
                      strcpy(WarnMsg, join(3,WarnMsg,GetVarTypeName(GlobalVars[varnum].VarType),CRLF));
                    }
                }
              else
                {
                  if(*Stk[k]==c_DblQt ){
                      strcpy(WarnMsg,trim(WarnMsg));
                      strcpy(WarnMsg, join(3,WarnMsg," is a string literal",CRLF));
                    }
                }
            }
        }
    }
  strcat(WarnMsg,CRLF);
  CloseAll();
  KillFiles();
  DeleteFile (("$WRK$.TXT"));
  DeleteFile ((FileOut));
  DeleteFile (("$t$e$m$p"));
  if(ErrFile ){
      if((fpErr=fopen(FileErr, "a"))==0)
       {
      fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", FileErr); exit(1);
       }
      fprintf(fpErr,"%s%s% .15G %s%s\n",AbortStr," at line",(double)LineNum[FileNdx]," in Module: ",trim(FileNames[FileNdx]));
      if(fpErr)
       {
         fclose(fpErr);
         fpErr=NULL;
       }
    }
  if(InfoBoxWarn ){
      InfoBox("Warnings! :",WarnMsg,GetSystemMetrics(SM_CXSCREEN)/4,GetSystemMetrics(SM_CYSCREEN)/4);
    }
  else
    {
      printf("%s%s%s%s%s\n","Error!",CRLF,FileIn,CRLF,WarnMsg);
    }
  FreeGlobals();
  fflush(stdout);
  ExitProcess(1);
}

void BumpDown (char* szErr)
{
  Indent-=(2);
  if(Indent<0 ){
      if(ISNULL(szErr)){
          Abort("Unknown Error");
        }
      else
        {
          Abort(szErr);
        }
    }
  strcpy(Scoot,space(Indent));
}

void BumpUp ()
{
  if(Indent<0 ){
      Indent=0;
    }
  Indent+=(2);
  strcpy(Scoot,space(Indent));
}

PCHAR BracketHandler (char* Source,int l)
{
  PCHAR  s;
  s=Source;
  if(l==0 ){
      for(;;)
        {
          if(*s==0 ){
              goto L1243;
            }
          if(*s==c_DblQt ){
              s++;
              while(*s!=c_DblQt){
                  if(*s==0 ){
                      goto L1244;
                    }
                  s++;
                }
L1244:;
            }
          if(*s==c_LtBkt ){
              s++;
              s=BracketHandler(s,1);
            }
          if(*s==c_LPar ){
              s++;
              s=BracketHandler(s,2);
            }
          s++;
        }
L1243:;
      goto L1242;
    }
  if(l==1 ){
      while(*s!=c_RtBkt){
          if(*s==c_DblQt ){
              s++;
              while(*s!=c_DblQt){
                  if(*s==0 ){
                      goto L1246;
                    }
                  s++;
                }
L1246:;
            }
          if(*s==c_LtBkt ){
              s++;
              s=BracketHandler(s,1);
            }
          if(*s==c_LPar ){
              s++;
              s=BracketHandler(s,2);
            }
          if(*s==0 ){
              goto L1245;
            }
          if(*s==c_Comma ){
              *s=1;
            }
          s++;
        }
L1245:;
      goto L1242;
    }
  if(l==2 ){
      while(*s!=c_RPar){
          if(*s==c_DblQt ){
              s++;
              while(*s!=c_DblQt){
                  if(*s==0 ){
                      goto L1248;
                    }
                  s++;
                }
L1248:;
            }
          if(*s==c_LtBkt ){
              s++;
              s=BracketHandler(s,1);
            }
          if(*s==c_LPar ){
              s++;
              s=BracketHandler(s,2);
            }
          if(*s==0 ){
              goto L1247;
            }
          s++;
        }
L1247:;
    }
L1242:;
  if(l==0 ){
      strcpy(Source,replace(Source,chr(1),"]["));
      return Source;
    }
  return s;
}

void PushSelectState (char* SelState)
{
  StateIdx++;
  if(cMaxNestedSelects==StateIdx ){
      Abort("Maximum nested SELECT/END SELECT reached.");
    }
  strcpy(SelectState[StateIdx].CaseStk,SelState);
}

void PopSelectState (char* SelState)
{
  strcpy(SelState,SelectState[--StateIdx].CaseStk);
}

void Emit_Epilog ()
{
  if(Use_Wingui+MakeDLL+NoMain+EndOfProgram==0 ){
      if(Use_Sound ){
          fprintf(FP_WRITE,"%s%s\n",Scoot,"midiOutClose (hMidi);");
        }
      fprintf(FP_WRITE,"%s\n","return EXIT_SUCCESS;   // End of main program");
      fprintf(FP_WRITE,"%s\n","}");
         fflush(FP_WRITE);
    }
}

void Emit_Prolog (FILE* FP_OUTPUT)
{
  fprintf(FP_OUTPUT,"%s\n","// *************************************************");
  fprintf(FP_OUTPUT,"%s\n","//      Made with BCX BASIC To C/C++ Translator");
  fprintf(FP_OUTPUT,"%s%s\n","//            Version ",VERSION);
  fprintf(FP_OUTPUT,"%s\n","// *************************************************");
  fprintf(FP_OUTPUT,"%s","//    Translated for compiling with a ");
  if(UseCpp ){
      fprintf(FP_OUTPUT,"%s\n","C++ Compiler");
    }
  else
    {
      fprintf(FP_OUTPUT,"%s\n","C Compiler");
    }
  fprintf(FP_OUTPUT,"%s\n","// *************************************************");
  if(UseCpp ){
      fprintf(FP_OUTPUT,"%s\n","");
      fprintf(FP_OUTPUT,"%s\n","#ifndef __cplusplus");
      fprintf(FP_OUTPUT,"%s\n","  #error A C++ compiler is required");
      fprintf(FP_OUTPUT,"%s\n","#endif");
      fprintf(FP_OUTPUT,"%s\n","");
    }
  if(NO_MSVC==FALSE ){
      fprintf(FP_OUTPUT,"%s\n","#ifdef _MSC_VER");
      fprintf(FP_OUTPUT,"%s\n","  #ifndef _CRT_SECURE_NO_WARNINGS");
      fprintf(FP_OUTPUT,"%s\n","    #define _CRT_SECURE_NO_WARNINGS");
      fprintf(FP_OUTPUT,"%s\n","  #endif");
      fprintf(FP_OUTPUT,"%s\n","#endif");
    }
  if(Use_LeanAndMean==TRUE ){
      fprintf(FP_OUTPUT,"%s\n","#define  WIN32_LEAN_AND_MEAN");
    }
  if(Use_MULTITHREADED_SW ){
      fprintf(FP_OUTPUT,"%s\n","#define __BCX_MULTITHREADED__");
    }
  if(Use_COM||Use_VBS ){
      fprintf(FP_OUTPUT,"%s\n","");
      fprintf(FP_OUTPUT,"%s\n","#ifndef _WIN32_DCOM");
      fprintf(FP_OUTPUT,"%s\n","  #define _WIN32_DCOM");
      fprintf(FP_OUTPUT,"%s\n","#endif");
    }
  if(Use_UNICODE ){
      fprintf(FP_OUTPUT,"%s\n","");
      fprintf(FP_OUTPUT,"%s\n","#ifndef UNICODE");
      fprintf(FP_OUTPUT,"%s\n","  #define UNICODE   // used by Windows headers");
      fprintf(FP_OUTPUT,"%s\n","#endif");
      fprintf(FP_OUTPUT,"%s\n","");
      fprintf(FP_OUTPUT,"%s\n","#ifndef _UNICODE");
      fprintf(FP_OUTPUT,"%s\n","  #define _UNICODE  // used by CRT headers");
      fprintf(FP_OUTPUT,"%s\n","#endif");
      fprintf(FP_OUTPUT,"%s\n","");
    }
  if(UseCpp&&UseCpphdr ){
      fprintf(FP_OUTPUT,"%s\n","");
      fprintf(FP_OUTPUT,"%s\n","#if defined(__cplusplus)");
      if(UseIO ){
          fprintf(FP_OUTPUT,"%s\n","  #include <iostream>");
        }
      fprintf(FP_OUTPUT,"%s\n","  #include <fstream>");
      fprintf(FP_OUTPUT,"%s\n","  #include <sstream>");
      fprintf(FP_OUTPUT,"%s\n","  #include <iomanip>");
      fprintf(FP_OUTPUT,"%s\n","  typedef std::string stdstr;");
      fprintf(FP_OUTPUT,"%s\n","#endif");
      fprintf(FP_OUTPUT,"%s\n","");
    }
  if(lof(defFile)>7 ){
      if((FP99=fopen(defFile, "rb"))==0)
       {
      fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", defFile); exit(1);
       }
      while(!EoF(FP99)){
          Src[0]=0;
          fgets(Src, 2048 , FP99);
            if(feof(FP99) || (Src[strlen(Src)-1]==10))
              {
               Src[strcspn(Src,"\r\n")] = 0;
              }
             else
              {
                printf("%s%d while reading file: %s\n","Error! - LINE INPUT truncation detected at PROGRAM line: ",__LINE__-7, NamePathFromFP(FP99));
                printf("%s\n","The actual truncated line of text:");
                printf("%s",Src);
                exit(1);
              }
          fprintf(FP_OUTPUT,"%s\n",Src);
        }
      if(FP99)
       {
         fclose(FP99);
         FP99=NULL;
       }
      fprintf(FP_OUTPUT,"%s\n","");
    }
  if(ZapFlag==FALSE ){
      if(WinHeaders==TRUE||Use_Project==TRUE ){
          fprintf(FP_OUTPUT,"%s\n","");
          fprintf(FP_OUTPUT,"%s\n","// Windows API headers");
          fprintf(FP_OUTPUT,"%s\n","#include <windows.h>    // Core Windows API");
          fprintf(FP_OUTPUT,"%s\n","#include <windowsx.h>   // Windows API macros and functions");
          fprintf(FP_OUTPUT,"%s\n","#include <commctrl.h>   // Common Controls");
          fprintf(FP_OUTPUT,"%s\n","#include <commdlg.h>    // Common Dialogs");
          fprintf(FP_OUTPUT,"%s\n","#include <direct.h>     // Directory handling");
          fprintf(FP_OUTPUT,"%s\n","#include <locale.h>     // Locale handling");
          fprintf(FP_OUTPUT,"%s\n","#include <mmsystem.h>   // Multimedia");
          fprintf(FP_OUTPUT,"%s\n","#include <oaidl.h>      // OLE Automation");
          fprintf(FP_OUTPUT,"%s\n","#include <objbase.h>    // Component Object Model (COM)");
          fprintf(FP_OUTPUT,"%s\n","#include <ocidl.h>      // OLE Control interfaces");
          fprintf(FP_OUTPUT,"%s\n","#include <ole2.h>       // OLE 2.0 functionality");
          fprintf(FP_OUTPUT,"%s\n","#include <oleauto.h>    // OLE Automation");
          fprintf(FP_OUTPUT,"%s\n","#include <olectl.h>     // OLE Controls");
          fprintf(FP_OUTPUT,"%s\n","#include <richedit.h>   // Rich Edit Control");
          fprintf(FP_OUTPUT,"%s\n","#include <shellapi.h>   // Shell API");
          fprintf(FP_OUTPUT,"%s\n","#include <shlobj.h>     // Shell Objects");
          fprintf(FP_OUTPUT,"%s\n","#include <urlmon.h>     // URL Monikers");
          fprintf(FP_OUTPUT,"%s\n","#include <wchar.h>      // Wide character support (also in ISO C)");
          fprintf(FP_OUTPUT,"%s\n","#include <wctype.h>     // Wide character classification (also in ISO C)");
          fprintf(FP_OUTPUT,"%s\n","#include <tchar.h>      // Unicode/ANSI character mapping");
          fprintf(FP_OUTPUT,"%s\n","#include <unknwn.h>     // COM base interfaces");
          fprintf(FP_OUTPUT,"%s\n","#include <wingdi.h>     // GDI");
          fprintf(FP_OUTPUT,"%s\n","#include <wininet.h>    // Internet");
          fprintf(FP_OUTPUT,"%s\n","#include <winsock.h>    // Windows Sockets");
          fprintf(FP_OUTPUT,"%s\n","#include <winuser.h>    // User Interface");
          fprintf(FP_OUTPUT,"%s\n","");
        }
      fprintf(FP_OUTPUT,"%s\n","// ISO C Standard Library headers");
      fprintf(FP_OUTPUT,"%s\n","#include <ctype.h>      // Character classification");
      fprintf(FP_OUTPUT,"%s\n","#include <math.h>       // Mathematical functions");
      fprintf(FP_OUTPUT,"%s\n","#include <setjmp.h>     // Non-local jumps");
      fprintf(FP_OUTPUT,"%s\n","#include <stdarg.h>     // Variable arguments");
      fprintf(FP_OUTPUT,"%s\n","#include <stddef.h>     // Common definitions");
      fprintf(FP_OUTPUT,"%s\n","#include <stdio.h>      // Input/output");
      fprintf(FP_OUTPUT,"%s\n","#include <stdlib.h>     // General utilities");
      fprintf(FP_OUTPUT,"%s\n","#include <string.h>     // String handling");
      fprintf(FP_OUTPUT,"%s\n","#include <time.h>       // Date and time");
      fprintf(FP_OUTPUT,"%s\n","#include <errno.h>      // Error numbers (also POSIX)");
      fprintf(FP_OUTPUT,"%s\n","");
      fprintf(FP_OUTPUT,"%s\n","// C99 Standard headers");
      fprintf(FP_OUTPUT,"%s\n","#include <stdbool.h>    // Boolean type");
      fprintf(FP_OUTPUT,"%s\n","#include <inttypes.h>   // Integer types");
      fprintf(FP_OUTPUT,"%s\n","");
      fprintf(FP_OUTPUT,"%s\n","// POSIX headers");
      fprintf(FP_OUTPUT,"%s\n","#include <fcntl.h>      // File control options");
      fprintf(FP_OUTPUT,"%s\n","");
      fprintf(FP_OUTPUT,"%s\n","// Windows-specific headers");
      fprintf(FP_OUTPUT,"%s\n","#include <process.h>    // Process control functions");
      fprintf(FP_OUTPUT,"%s\n","#include <io.h>         // Low-level I/O (Windows POSIX subset)");
      fprintf(FP_OUTPUT,"%s\n","#include <conio.h>      // Console I/O (Windows-specific)");
    }
  fprintf(FP_OUTPUT,"%s\n","");
}

void Commandline_Defines (FILE* FP_OUTPUT)
{
  if(CmdLineConst[0]!=0 ){
      FILE*  Ftmp;
      char LTmp1[BCXSTRSIZE];
      fprintf(FP_OUTPUT,"%s\n","");
      fprintf(FP_OUTPUT,"%s\n","// ***************************************************");
      fprintf(FP_OUTPUT,"%s\n","//                 Command line Defines");
      fprintf(FP_OUTPUT,"%s\n","// ***************************************************");
      fprintf(FP_OUTPUT,"%s\n","");
      Ftmp=FP_CST;
      FP_CST=FP_OUTPUT;
      for(int i=1; i<=tally(CmdLineConst,chr(1)); i++)
        {
          strcpy(LTmp1,StrToken(CmdLineConst,chr(1),i));
          if(ISNULL(LTmp1)){
              goto L1250;
            }
          strcpy(LTmp1, join(2,"MACRO ",LTmp1));
          Inject(LTmp1);
        }
L1250:;
      FP_CST=Ftmp;
      fprintf(FP_OUTPUT,"%s\n","");
      fprintf(FP_OUTPUT,"%s\n","// ***************************************************");
      fprintf(FP_OUTPUT,"%s\n","//              End of Command Line Defines");
      fprintf(FP_OUTPUT,"%s\n","// ***************************************************");
      fprintf(FP_OUTPUT,"%s\n","");
    }
}

void Emit_UserDirectives (FILE* FP_OUTPUT)
{
  if(Exist(hdrFile)){
      char LTmp1[BCXSTRSIZE];
      FILE*  LFP1;
      if((LFP1=fopen(hdrFile, "rb"))==0)
       {
      fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", hdrFile); exit(1);
       }
      while(!EoF(LFP1)){
          LTmp1[0]=0;
          fgets(LTmp1, 2048 , LFP1);
            if(feof(LFP1) || (LTmp1[strlen(LTmp1)-1]==10))
              {
               LTmp1[strcspn(LTmp1,"\r\n")] = 0;
              }
             else
              {
                printf("%s%d while reading file: %s\n","Error! - LINE INPUT truncation detected at PROGRAM line: ",__LINE__-7, NamePathFromFP(LFP1));
                printf("%s\n","The actual truncated line of text:");
                printf("%s",LTmp1);
                exit(1);
              }
          fprintf(FP_OUTPUT,"%s\n",LTmp1);
        }
      if(LFP1)
       {
         fclose(LFP1);
         LFP1=NULL;
       }
    }
}

void User_Global_Enum_Blocks (FILE* FP_OUTPUT)
{
  char LTmp1[BCXSTRSIZE];
  FILE*  LFP1;
  if(Exist(enuFile)&&lof(enuFile)>2 ){
      fprintf(FP_OUTPUT,"%s\n","");
      fprintf(FP_OUTPUT,"%s\n","// *************************************************");
      fprintf(FP_OUTPUT,"%s\n","//           User's GLOBAL Enumerations");
      fprintf(FP_OUTPUT,"%s\n","// *************************************************");
      if((LFP1=fopen(enuFile, "rb"))==0)
       {
      fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", enuFile); exit(1);
       }
      while(!EoF(LFP1)){
          LTmp1[0]=0;
          fgets(LTmp1, 2048 , LFP1);
            if(feof(LFP1) || (LTmp1[strlen(LTmp1)-1]==10))
              {
               LTmp1[strcspn(LTmp1,"\r\n")] = 0;
              }
             else
              {
                printf("%s%d while reading file: %s\n","Error! - LINE INPUT truncation detected at PROGRAM line: ",__LINE__-7, NamePathFromFP(LFP1));
                printf("%s\n","The actual truncated line of text:");
                printf("%s",LTmp1);
                exit(1);
              }
          fprintf(FP_OUTPUT,"%s\n",LTmp1);
        }
      if(LFP1)
       {
         fclose(LFP1);
         LFP1=NULL;
       }
    }
}

void System_Defined_Constants (FILE* FP_OUTPUT)
{
  char LTmp1[BCXSTRSIZE];
  FILE*  LFP1;
  if(Exist(SysFile)&&lof(SysFile)>2 ){
      fprintf(FP_OUTPUT,"%s\n","");
      fprintf(FP_OUTPUT,"%s\n","// *************************************************");
      fprintf(FP_OUTPUT,"%s\n","//            System Defined Macros");
      fprintf(FP_OUTPUT,"%s\n","// *************************************************");
      fprintf(FP_OUTPUT,"%s\n","");
      if((LFP1=fopen(SysFile, "rb"))==0)
       {
      fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", SysFile); exit(1);
       }
      while(!EoF(LFP1)){
          LTmp1[0]=0;
          fgets(LTmp1, 2048 , LFP1);
            if(feof(LFP1) || (LTmp1[strlen(LTmp1)-1]==10))
              {
               LTmp1[strcspn(LTmp1,"\r\n")] = 0;
              }
             else
              {
                printf("%s%d while reading file: %s\n","Error! - LINE INPUT truncation detected at PROGRAM line: ",__LINE__-7, NamePathFromFP(LFP1));
                printf("%s\n","The actual truncated line of text:");
                printf("%s",LTmp1);
                exit(1);
              }
          strcpy(LTmp1,trim(LTmp1));
          if(LTmp1[0]>0 ){
              fprintf(FP_OUTPUT,"%s\n",LTmp1);
            }
        }
      if(LFP1)
       {
         fclose(LFP1);
         LFP1=NULL;
       }
    }
}

void User_Defined_Constants (FILE* FP_OUTPUT)
{
  char LTmp1[BCXSTRSIZE];
  FILE*  LFP1;
  if(Exist(UsrFile)&&lof(UsrFile)>2 ){
      fprintf(FP_OUTPUT,"%s\n","");
      fprintf(FP_OUTPUT,"%s\n","// *************************************************");
      fprintf(FP_OUTPUT,"%s\n","//             User Defined Macros");
      fprintf(FP_OUTPUT,"%s\n","// *************************************************");
      fprintf(FP_OUTPUT,"%s\n","");
      if((LFP1=fopen(UsrFile, "rb"))==0)
       {
      fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", UsrFile); exit(1);
       }
      while(!EoF(LFP1)){
          LTmp1[0]=0;
          fgets(LTmp1, 2048 , LFP1);
            if(feof(LFP1) || (LTmp1[strlen(LTmp1)-1]==10))
              {
               LTmp1[strcspn(LTmp1,"\r\n")] = 0;
              }
             else
              {
                printf("%s%d while reading file: %s\n","Error! - LINE INPUT truncation detected at PROGRAM line: ",__LINE__-7, NamePathFromFP(LFP1));
                printf("%s\n","The actual truncated line of text:");
                printf("%s",LTmp1);
                exit(1);
              }
          fprintf(FP_OUTPUT,"%s\n",ltrim(LTmp1));
        }
      if(LFP1)
       {
         fclose(LFP1);
         LFP1=NULL;
       }
    }
}

void User_Defined_Types_And_Unions (FILE* FP_OUTPUT)
{
  char LTmp1[BCXSTRSIZE];
  FILE*  LFP1;
  if(Exist(udtFile)&&lof(udtFile)>2 ){
      fprintf(FP_OUTPUT,"%s\n","");
      fprintf(FP_OUTPUT,"%s\n","// *************************************************");
      fprintf(FP_OUTPUT,"%s\n","//          User Defined Types And Unions");
      fprintf(FP_OUTPUT,"%s\n","// *************************************************");
      if((LFP1=fopen(udtFile, "rb"))==0)
       {
      fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", udtFile); exit(1);
       }
      while(!EoF(LFP1)){
          LTmp1[0]=0;
          fgets(LTmp1, 2048 , LFP1);
            if(feof(LFP1) || (LTmp1[strlen(LTmp1)-1]==10))
              {
               LTmp1[strcspn(LTmp1,"\r\n")] = 0;
              }
             else
              {
                printf("%s%d while reading file: %s\n","Error! - LINE INPUT truncation detected at PROGRAM line: ",__LINE__-7, NamePathFromFP(LFP1));
                printf("%s\n","The actual truncated line of text:");
                printf("%s",LTmp1);
                exit(1);
              }
          fprintf(FP_OUTPUT,"%s\n",LTmp1);
        }
      if(LFP1)
       {
         fclose(LFP1);
         LFP1=NULL;
       }
    }
}

void User_Data_Statements (FILE* FP_OUTPUT)
{
  char LTmp1[BCXSTRSIZE];
  FILE*  LFP1;
  if(lof(datFile)>0 ){
      if((LFP1=fopen(datFile, "rb"))==0)
       {
      fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", datFile); exit(1);
       }
      fprintf(FP_OUTPUT,"%s\n","");
      fprintf(FP_OUTPUT,"%s\n","// *************************************************");
      fprintf(FP_OUTPUT,"%s\n","//              User's Data Statements");
      fprintf(FP_OUTPUT,"%s\n","// *************************************************");
      fprintf(FP_OUTPUT,"%s\n","");
      fprintf(FP_OUTPUT,"%s\n","char * DATA[] =");
      fprintf(FP_OUTPUT,"%s\n","{");
      while(!EoF(LFP1)){
          LTmp1[0]=0;
          fgets(LTmp1, 2048 , LFP1);
            if(feof(LFP1) || (LTmp1[strlen(LTmp1)-1]==10))
              {
               LTmp1[strcspn(LTmp1,"\r\n")] = 0;
              }
             else
              {
                printf("%s%d while reading file: %s\n","Error! - LINE INPUT truncation detected at PROGRAM line: ",__LINE__-7, NamePathFromFP(LFP1));
                printf("%s\n","The actual truncated line of text:");
                printf("%s",LTmp1);
                exit(1);
              }
          fprintf(FP_OUTPUT,"%s",LTmp1);
          if(!EoF(LFP1)){
              fprintf(FP_OUTPUT,"%s\n",",");
            }
        }
      if(LFP1)
       {
         fclose(LFP1);
         LFP1=NULL;
       }
      fprintf(FP_OUTPUT,"%s\n","\n};");
    }
}

void BeginMain ()
{
  fprintf(FP_WRITE,"%s\n","int main(int argc, char *argv[])");
     fflush(FP_WRITE);
}

void User_Global_Variables (FILE* FP_OUTPUT)
{
  int i;
  char VarName[BCXSTRSIZE];
  char Storage[BCXSTRSIZE];
  char VarDim[BCXSTRSIZE];
  int A;
  char P[BCXSTRSIZE];
  if(GlobalVarCnt||DllCnt ){
      fprintf(FP_W,"%s\n","");
      fprintf(FP_W,"%s\n","// *************************************************");
      fprintf(FP_W,"%s%s\n","//            ",BCX_STR_USR_VARS);
      fprintf(FP_W,"%s\n","// *************************************************");
      fprintf(FP_W,"%s\n","");
    }
  if(DllCnt ){
      for(int iii=1; iii<=DllCnt; iii++)
        {
          fprintf(FP_W,"%s%s%s%s%s\n","static BCXFPROT",ltrim(str(iii)),SPC,extract(DllDecl[iii],"="),";");
        }
    }
  for(i=1; i<=GlobalVarCnt; i++)
    {
      if(GlobalVars[i].VarEmitFlag ){
          continue;
        }
      if(strcmp("",GlobalVars[i].VarDim)==0  && GlobalVars[i].VarCondLevel==0 ){
          *P=0;
          if(GlobalVars[i].VarPntr ){
              strcpy(P,stringx(GlobalVars[i].VarPntr,42));
            }
          A=GlobalVars[i].VarType;
          if(GlobalVars[i].VarSF ){
              strcpy(VarName, join(3,"(*",GlobalVars[i].VarName,")"));
            }
          else
            {
              strcpy(VarName,GlobalVars[i].VarName);
            }
          strcpy(Storage, join(2,VarStorage[GlobalVars[i].VarExtn],VarConst[GlobalVars[i].VarConstant]));
          strcpy(VarDim,GlobalVars[i].VarDim);
          PrintGlobal(FP_OUTPUT,A,i,Storage,P,VarName,VarDim);
        }
    }
  for(i=1; i<=GlobalVarCnt; i++)
    {
      if(GlobalVars[i].VarEmitFlag ){
          continue;
        }
      if(strcmp("",GlobalVars[i].VarDim)!=0  && GlobalVars[i].VarCondLevel==0 ){
          if(inchr(GlobalVars[i].VarDim,"{")==0 ){
              *P=0;
              if(GlobalVars[i].VarPntr ){
                  strcpy(P,stringx(GlobalVars[i].VarPntr,42));
                }
              A=GlobalVars[i].VarType;
              if(GlobalVars[i].VarSF ){
                  strcpy(VarName, join(4,"(*",GlobalVars[i].VarName,extract(GlobalVars[i].VarDim,"("),")"));
                  strcpy(VarDim,mid(GlobalVars[i].VarDim,inchr(GlobalVars[i].VarDim,"(")));
                }
              else
                {
                  strcpy(VarName,GlobalVars[i].VarName);
                  strcpy(VarDim,GlobalVars[i].VarDim);
                }
              strcpy(Storage, join(2,VarStorage[GlobalVars[i].VarExtn],VarConst[GlobalVars[i].VarConstant]));
              PrintGlobal(FP_OUTPUT,A,i,Storage,P,VarName,VarDim);
            }
        }
    }
   char LastDef[BCXSTRSIZE];  strcpy(LastDef,"");
  int LastLevel=1;
  for(i=1; i<=GlobalVarCnt; i++)
    {
      if(GlobalVars[i].VarEmitFlag ){
          continue;
        }
      if(GlobalVars[i].VarCondLevel ){
          if(ISNULL(LastDef)){
              strcpy(LastDef,GlobalVars[i].VarCondDef);
              LastLevel=GlobalVars[i].VarCondLevel;
              fprintf(FP_OUTPUT,"%s\n",LastDef);
            }
          if(strcmp(LastDef,GlobalVars[i].VarCondDef)!=0){
              if(strcmp(GlobalVars[i].VarCondDef,"#else")==0){
                  while(LastLevel>GlobalVars[i].VarCondLevel){
                      fprintf(FP_OUTPUT,"%s\n","#endif");
                      LastLevel--;
                    }
                  fprintf(FP_OUTPUT,"%s\n","#else");
                  strcpy(LastDef,GlobalVars[i].VarCondDef);
                }
              else
                {
                  while(LastLevel>=GlobalVars[i].VarCondLevel){
                      fprintf(FP_OUTPUT,"%s\n","#endif");
                      LastLevel--;
                    }
                  strcpy(LastDef,GlobalVars[i].VarCondDef);
                  LastLevel=GlobalVars[i].VarCondLevel;
                  fprintf(FP_OUTPUT,"%s\n",LastDef);
                }
            }
          *P=0;
          if(GlobalVars[i].VarPntr ){
              strcpy(P,stringx(GlobalVars[i].VarPntr,42));
            }
          A=GlobalVars[i].VarType;
          if(GlobalVars[i].VarSF ){
              strcpy(VarName, join(3,"(*",GlobalVars[i].VarName,")"));
            }
          else
            {
              strcpy(VarName,GlobalVars[i].VarName);
            }
          strcpy(VarDim,GlobalVars[i].VarDim);
          strcpy(Storage, join(2,VarStorage[GlobalVars[i].VarExtn],VarConst[GlobalVars[i].VarConstant]));
          PrintGlobal(FP_OUTPUT,A,i,Storage,P,VarName,VarDim);
        }
    }
  if(*LastDef ){
      while(LastLevel){
          fprintf(FP_OUTPUT,"%s\n","#endif");
          LastLevel--;
        }
    }
}

void System_Vars (FILE* FP_OUTPUT)
{
  if(Use_Console||Use_Findfirst||Use_Findnext||Use_GoSub||Use_BcxTempStr||Use_Ldouble||Use_Crlf||Use_Inputbox||Use_Infobox||Use_Inputbuffer||Use_BCX_Splitter||Use_Dynacall||Use_DynacallA||Use_LCaseTbl||Use_UCaseTbl ){
      fprintf(FP_OUTPUT,"%s\n","");
      fprintf(FP_OUTPUT,"%s\n","// *************************************************");
      fprintf(FP_OUTPUT,"%s%s\n","//                ",BCX_STR_SYS_VARS);
      fprintf(FP_OUTPUT,"%s\n","// *************************************************");
      fprintf(FP_OUTPUT,"%s\n","");
    }
  if(Use_BCX_Splitter ){
      fprintf(FP_OUTPUT,"%s\n","static ULONG SplitBarFG=RGB(0,0,255);");
      fprintf(FP_OUTPUT,"%s\n","static ULONG SplitBarBG=RGB(212,212,212);");
      fprintf(FP_OUTPUT,"%s\n","#define SPLITBAR_SIZE 2");
      fprintf(FP_OUTPUT,"%s\n","#define MIN_PANESIZE 4");
      fprintf(FP_OUTPUT,"%s\n","");
      fprintf(FP_OUTPUT,"%s\n","typedef struct _SPLITTERINFO{");
      fprintf(FP_OUTPUT,"%s\n","  int   swsStyle;");
      fprintf(FP_OUTPUT,"%s\n","  int   splittype;");
      fprintf(FP_OUTPUT,"%s\n","  HCURSOR  hCursor;");
      fprintf(FP_OUTPUT,"%s\n","  HWND  hwPane1;");
      fprintf(FP_OUTPUT,"%s\n","  HWND  hwPane2;");
      fprintf(FP_OUTPUT,"%s\n","  BOOL  fMovingBar;");
      fprintf(FP_OUTPUT,"%s\n","  int   percent;");
      fprintf(FP_OUTPUT,"%s\n","}SPLITTERINFO, *LPSPLITTERINFO;");
      fprintf(FP_OUTPUT,"%s\n","");
    }
  if(Use_Ldouble ){
      fprintf(FP_OUTPUT,"%s\n","#define LDOUBLE long double");
    }
  if(Use_Idxqsort ){
      fprintf(FP_OUTPUT,"%s\n","char*** pppStr;");
    }
  if(Use_Idxqsort||Use_IdxqsortSt||Use_PtrqsortSt ){
      fprintf(FP_OUTPUT,"%s\n","int     Key;");
    }
  if(Use_IdxqsortSt ){
      fprintf(FP_OUTPUT,"%s\n","char*   cmp1;");
      fprintf(FP_OUTPUT,"%s\n","int     StructSize;");
    }
  if(Use_PtrqsortSt ){
      fprintf(FP_OUTPUT,"%s\n","int     OffSet;");
    }
  if(Use_Sound ){
      fprintf(FP_OUTPUT,"%s\n","");
      fprintf(FP_OUTPUT,"%s\n","#define SNDQUE 10000");
      fprintf(FP_OUTPUT,"%s\n","");
      fprintf(FP_OUTPUT,"%s\n","typedef struct _soundtype {");
      fprintf(FP_OUTPUT,"%s\n","  float  Freq;");
      fprintf(FP_OUTPUT,"%s\n","  int    Dura;");
      fprintf(FP_OUTPUT,"%s\n","  int    Vol;");
      fprintf(FP_OUTPUT,"%s\n","  int    Voice;");
      fprintf(FP_OUTPUT,"%s\n","  float  Tempo;");
      fprintf(FP_OUTPUT,"%s\n","  int    sndTid;");
      fprintf(FP_OUTPUT,"%s\n","} soundtype, *LPSOUNDTYPE;");
      fprintf(FP_OUTPUT,"%s\n","");
      fprintf(FP_OUTPUT,"%s\n","static soundtype  SndPmtr[SNDQUE+1];");
      fprintf(FP_OUTPUT,"%s\n","static UINT       gTenter;");
      fprintf(FP_OUTPUT,"%s\n","static UINT       gTwait;");
      fprintf(FP_OUTPUT,"%s\n","static UINT       gTexit;");
      fprintf(FP_OUTPUT,"%s\n","static UINT       gTarray;");
      fprintf(FP_OUTPUT,"%s\n","static BOOL       gTsig;");
      fprintf(FP_OUTPUT,"%s\n","static HANDLE     gSThread=NULL;");
      fprintf(FP_OUTPUT,"%s\n","static HMIDIOUT   hMidi;");
      fprintf(FP_OUTPUT,"%s\n","");
    }
  if(Use_BCX_Fontdlg ){
      fprintf(FP_OUTPUT,"%s\n","");
      fprintf(FP_OUTPUT,"%s\n","typedef struct _BCX_FONT_TYPE {");
      fprintf(FP_OUTPUT,"%s\n","  LOGFONT lf;");
      fprintf(FP_OUTPUT,"%s\n","  int  SIZE;");
      fprintf(FP_OUTPUT,"%s\n","  int  RGB;");
      fprintf(FP_OUTPUT,"%s\n","} BCX_FONT_TYPE;");
      fprintf(FP_OUTPUT,"%s\n","");
      fprintf(FP_OUTPUT,"%s\n","BCX_FONT_TYPE BCX_FONT;");
      fprintf(FP_OUTPUT,"%s\n","");
    }
  if(Use_NUL ){
      fprintf(FP_OUTPUT,"%s\n","static char    NUL [1]={0};       // Null");
    }
  if(Use_BEL ){
      fprintf(FP_OUTPUT,"%s\n","static char    BEL [2]={7,0};     // Bell");
    }
  if(Use_BS ){
      fprintf(FP_OUTPUT,"%s\n","static char    BS  [2]={8,0};     // Back Space");
    }
  if(Use_TAB ){
      fprintf(FP_OUTPUT,"%s\n","static char    TAB [2]={9,0};     // Horz Tab");
    }
  if(Use_LF ){
      fprintf(FP_OUTPUT,"%s\n","static char    LF  [2]={10,0};    // Line Feed");
    }
  if(Use_VT ){
      fprintf(FP_OUTPUT,"%s\n","static char    VT  [2]={11,0};    // Vert Tab");
    }
  if(Use_FF ){
      fprintf(FP_OUTPUT,"%s\n","static char    FF  [2]={12,0};    // Form Feed");
    }
  if(Use_CR ){
      fprintf(FP_OUTPUT,"%s\n","static char    CR  [2]={13,0};    // Carr Rtn");
    }
  if(Use_EF ){
      fprintf(FP_OUTPUT,"%s\n","static char    EF  [2]={26,0};    // End-of-File");
    }
  if(Use_ESC ){
      fprintf(FP_OUTPUT,"%s\n","static char    ESC [2]={27,0};    // Escape");
    }
  if(Use_SPC ){
      fprintf(FP_OUTPUT,"%s\n","static char    SPC [2]={32,0};    // Space");
    }
  if(Use_DQ ){
      fprintf(FP_OUTPUT,"%s\n","static char    DQ  [2]={34,0};    // Double-Quote");
    }
  if(Use_DDQ ){
      fprintf(FP_OUTPUT,"%s\n","static char    DDQ [3]={34,34,0}; // Double-Double-Quote");
    }
  if(Use_Crlf ){
      fprintf(FP_OUTPUT,"%s\n","static char    CRLF[3]={13,10,0}; // Carr Rtn & Line Feed");
    }
  if(Use_Inputbox ){
      fprintf(FP_OUTPUT,"%s\n","char   BCX_INPUTBOX_VAL[BCXSTRSIZE];");
    }
  if(Use_Cursor ){
      fprintf(FP_OUTPUT,"%s\n","static COORD   cursor;             // holds coordinates of cursor");
    }
  if(Use_Console ){
      fprintf(FP_OUTPUT,"%s\n","static HANDLE  hConsole;           // handle of console window");
    }
  if(Use_Cls||Use_Color ){
      fprintf(FP_OUTPUT,"%s\n","static int     color_fg = 7;       // forground color set to default");
      fprintf(FP_OUTPUT,"%s\n","static int     color_bg = 0;       // background color set to default");
    }
  if(Use_Consolesize ){
      fprintf(FP_OUTPUT,"%s\n","static int     BcxSaveConX;");
      fprintf(FP_OUTPUT,"%s\n","static int     BcxSaveConY;");
    }
  if(Use_PushPopColors ){
      fprintf(FP_OUTPUT,"%s\n","static int     color_pshpop;       // Push / Pop Color storage");
    }
  if(Use_Scan ){
      fprintf(FP_OUTPUT,"%s\n","static int     ScanError;          // holds last error from scan function");
    }
  if(Use_Inputbuffer ){
      fprintf(FP_OUTPUT,"%s\n","static char    InputBuffer[1048577];");
    }
  if(Use_Hook ){
      fprintf(FP_OUTPUT,"%s\n","static HHOOK   CmDlgHook;");
    }
  if(Use_GoSub ){
      fprintf(FP_OUTPUT,"%s\n","static jmp_buf GosubStack[32];");
      fprintf(FP_OUTPUT,"%s\n","static int     GosubNdx;");
    }
  if(Use_LCaseTbl ){
      fprintf(FP_OUTPUT,"%s\n","static unsigned char*  LowCase;");
    }
  if(Use_UCaseTbl ){
      fprintf(FP_OUTPUT,"%s\n","static unsigned char*  UprCase;");
    }
  if(Use_Findfirst||Use_Findnext ){
      fprintf(FP_OUTPUT,"%s\n","static HANDLE  fffn_FileHandle;");
      fprintf(FP_OUTPUT,"%s\n","static WIN32_FIND_DATA fffn_FindData;");
    }
  if(Use_DynacallCommon ){
      fprintf(FP_OUTPUT,"%s\n","static  HINSTANCE BCX_DllStore[256];");
    }
  fprintf(FP_OUTPUT,"%s\n","");
}

void PreParse (char* Arg)
{
   char Anyword[BCXSTRSIZE];  strcpy(Anyword,"");
   char szChar[BCXSTRSIZE];  strcpy(szChar,"");
   char Strlit[BCXSTRSIZE];  strcpy(Strlit,"");
  int  Arglen;
  int  Counter;
  int  TT;
  int  Tmp;
  int  A;
  int  j;
  Ndx=0;
  strcpy(Arg,ltrim(Arg));
  if(ISNULL(Arg)){
      Ndx=0;
      return;
    }
  for(Tmp=0; Tmp<=31; Tmp++)
    {
      *Stk[Tmp]=0;
    }
  Arglen=(int)strlen(Arg);
  Counter=0;
  while(Counter<=Arglen){
      if(Ndx>=cMaxStk ){
          Abort("Overflowed Parse Stack");
        }
      Counter++;
      szChar[0]=Arg[Counter-1];
      szChar[1]=0;
      TT=(UCHAR)*(szChar);
      if(TT==c_DblQt ){
          strcpy(Strlit,szChar);
          *szChar=0;
          for(;;)
            {
              if(strcmp(szChar,DQ)==0){
                  goto L1267;
                }
              Counter++;
              if(Counter==Arglen ){
                  szChar[0]=Arg[Counter-1];
                  szChar[1]=0;
                  strcat(Strlit,szChar);
                  goto L1267;
                }
              szChar[0]=Arg[Counter-1];
              szChar[1]=0;
              strcat(Strlit,szChar);
            }
L1267:;
          Ndx++;
          strcpy(Stk[Ndx],Strlit);
          goto L1266;
        }
      if(TT==32 ){
          if(*Anyword ){
              Ndx++;
              strcpy(Stk[Ndx],Anyword);
              *Anyword=0;
            }
          goto L1266;
        }
      if(TT==61||TT==38||TT==40||TT==41||TT==91||TT==93||TT==39||TT==44||TT==43||TT==45||TT==42||TT==47||TT==63||TT==60||TT==62||TT==59||TT==124||TT==58||TT==94 ){
          if(*Anyword ){
              Ndx++;
              strcpy(Stk[Ndx],Anyword);
              *Anyword=0;
            }
          Ndx++;
          strcpy(Stk[Ndx],szChar);
        }
      else
        {
          A=(int)strlen(Anyword);
          Anyword[A]=Arg[Counter-1];
          Anyword[A+1]=0;
        }
L1266:;
    }
  if(*Anyword ){
      Ndx++;
      strcpy(Stk[Ndx],Anyword);
    }
  for(j=1; j<=Ndx; j++)
    {
      strcpy(Anyword,lcase(Stk[j]));
      if(strcmp(Anyword,"bor")==0){
          strcpy(Stk[j],"|");
          goto L1269;
        }
      if(strcmp(Anyword,"band")==0){
          strcpy(Stk[j],"&");
        }
L1269:;
    }
}

int GetNumArgs (int Strt,int* NdxPos)
{
  int CountR=0;
  int CountS=0;
  int i;
  int j=0;
  int k=1;
  for(i=Strt; i<=Ndx; i++)
    {
      if(*Stk[i]==40 ){
          CountR++;
          k++;
          goto L1271;
        }
      if(*Stk[i]==41 ){
          CountR--;
          k--;
          if(k==0 ){
              goto L1270;
            }
          goto L1271;
        }
      if(*Stk[i]==91 ){
          CountS++;
          goto L1271;
        }
      if(*Stk[i]==93 ){
          CountS--;
          goto L1271;
        }
      if(*Stk[i]==44 ){
          if(CountR==0&&CountS==0 ){
              j++;
              if(NdxPos ){
                  *NdxPos=i;
                }
            }
        }
L1271:;
    }
L1270:;
  return j;
}

void GetVarCode (VARCODE*  varcode,PCHAR szWhere)
{
  UNREFERENCED_PARAMETER(szWhere);
  char CB[BCXSTRSIZE];
  char PT[BCXSTRSIZE];
  char PTH[BCXSTRSIZE];
  char VAR[BCXSTRSIZE];
  int vn;
  char RF[BCXSTRSIZE];
  BOOL  bRemoveSplat;
  if(varcode->Methd==mt_ConsDesNoParam||varcode->Methd==mt_FuncSubDecC_DecNoParam||varcode->Methd==mt_OverLoadNoParam ){
      strcat(varcode->Proto,varcode->Token);
      strcat(varcode->Header,varcode->Token);
      return;
    }
  if(varcode->Methd==mt_OptsNoParam ){
      strcat(varcode->Proto,varcode->Token);
      if(strcmp(varcode->Token,",")==0  || InClass || strcmp(varcode->Token,"...")==0){
          strcat(varcode->Header,varcode->Token);
        }
      return;
    }
  if(IsCallBack ){
      strcpy(CB,"CALLBACK ");
    }
  else
    {
      *CB=0;
    }
  if(varcode->Methd==mt_ConsDesAParam ){
      int iSplat=inchr(varcode->AsToken,"*");
      int iLT=inchr(varcode->AsToken,"<");
      int iGT=inchr(varcode->AsToken,">");
      if(iSplat>iLT&&iSplat<iGT ){
          bRemoveSplat=FALSE;
        }
      else
        {
          bRemoveSplat=TRUE;
        }
    }
  else
    {
      bRemoveSplat=TRUE;
    }
  if(((inchr(varcode->Token,"*")||inchr(varcode->AsToken,"*"))&&bRemoveSplat)||varcode->IsPtrFlag ){
      RemoveAll(varcode->Token,"*");
      RemoveAll(varcode->AsToken,"*");
      strcpy(PT, join(2,stringx(varcode->IsPtrFlag,42),SPC));
      strcpy(PTH,PT);
    }
  else
    {
      strcpy(PTH,SPC);
      *PT=0;
    }
  if(inchr(varcode->Token,"&")){
      strcpy(RF," &");
    }
  else
    {
      *RF=0;
    }
  vn=varcode->VarNo;
  strcpy(VAR,GetVarTypeName(vn));
  char pszHead[BCXSTRSIZE];
  char pszProto[BCXSTRSIZE];
  strcpy(pszHead,Clean(varcode->Token));
  strcpy(pszProto,pszHead);
  if(inchr(pszProto,"[")){
      strcpy(pszProto,mid(pszProto,inchr(pszProto,"[")));
    }
  else
    {
      *pszProto=0;
    }
  if(vn==vt_STRVAR ){
      if(varcode->Methd==mt_ProcessSetCommand ){
          strcpy(varcode->StaticOut, join(2,"static char   ",pszHead));
          goto L1273;
        }
      if(varcode->Methd==mt_FuncSubDecC_Dec ){
          strcpy(varcode->Functype, join(2,"char * ",CB));
          goto L1273;
        }
      if(varcode->Methd==mt_FuncSubDecC_DecAParam ){
          if(!inchr(varcode->Token,"[")){
              strcpy(varcode->Header, join(3,varcode->Header,"char *",pszHead));
              strcat(varcode->Proto,"char *");
            }
          else
            {
              strcpy(varcode->Header, join(3,varcode->Header,"char ",RemoveStr(pszHead,"*")));
              strcat(varcode->Proto,"char[][BCXSTRSIZE]");
            }
          goto L1273;
        }
      if(varcode->Methd==mt_Opts ){
          strcpy(varcode->Functype,"char *");
          goto L1273;
        }
      if(varcode->Methd==mt_ConsDesAParam ){
          strcpy(varcode->Header, join(3,varcode->Header,"char *",pszHead));
          strcpy(varcode->Proto, join(3,varcode->Proto,"char *",pszHead));
          goto L1273;
        }
      if(varcode->Methd==mt_OptsAParam ){
          strcpy(varcode->Header, join(3,varcode->Header,"char *",pszHead));
          strcat(varcode->Proto,"char *");
          goto L1273;
        }
      if(varcode->Methd==mt_OverLoad ){
          strcpy(varcode->Functype,"char *");
          goto L1273;
        }
      if(varcode->Methd==mt_OverLoadAParam ){
          strcpy(varcode->Header, join(3,varcode->Header,"char *",pszHead));
        }
L1273:;
      goto L1272;
    }
  if(vn==vt_BOOL||vn==vt_BYTE||vn==vt_COLORREF||vn==vt_DOUBLE||vn==vt_DWORD||vn==vt_FARPROC||vn==vt_HDC||vn==vt_HANDLE||vn==vt_HINSTANCE||vn==vt_HWND||vn==vt_HBITMAP||vn==vt_INTEGER||vn==vt_PCHAR||vn==vt_LONG||vn==vt_LPBYTE||vn==vt_LRESULT||vn==vt_SHORT||vn==vt_SINGLE||vn==vt_UINT||vn==vt_ULONG||vn==vt_USHORT||vn==vt_SAFEARRAY||vn==vt_VARIANT||vn==vt_VOID||vn==vt_LDOUBLE||vn==vt_SSHORT||vn==vt_SCHAR||vn==vt_DWORD||vn==vt_WORD||vn==vt_WINBOOL||vn==vt_BSTR ){
      if(varcode->Methd==mt_ProcessSetCommand ){
          strcpy(varcode->StaticOut, join(4,"static ",VAR,SPC,pszHead));
          goto L1274;
        }
      if(varcode->Methd==mt_FuncSubDecC_Dec ){
          strcpy(varcode->Functype, join(3,VAR,PTH,CB));
          goto L1274;
        }
      if(varcode->Methd==mt_FuncSubDecC_DecAParam ){
          strcpy(varcode->Header, join(4,varcode->Header,VAR,PTH,pszHead));
          strcpy(varcode->Proto, join(4,varcode->Proto,VAR,RF,PT));
          goto L1274;
        }
      if(varcode->Methd==mt_Opts ){
          strcpy(varcode->Functype, join(2,VAR,PTH));
          goto L1274;
        }
      if(varcode->Methd==mt_OptsAParam ){
          strcpy(varcode->Header, join(4,varcode->Header,VAR,PTH,pszHead));
          strcpy(varcode->Proto, join(4,varcode->Proto,VAR,RF,PT));
          goto L1274;
        }
      if(varcode->Methd==mt_ConsDesAParam ){
          strcpy(varcode->Header, join(4,varcode->Header,VAR,PTH,pszHead));
          strcpy(varcode->Proto, join(4,varcode->Proto,VAR,PTH,pszHead));
          goto L1274;
        }
      if(varcode->Methd==mt_OverLoad ){
          strcpy(varcode->Functype, join(2,VAR,SPC));
          goto L1274;
        }
      if(varcode->Methd==mt_OverLoadAParam ){
          strcpy(varcode->Header, join(4,varcode->Header,VAR,PTH,pszHead));
        }
L1274:;
      goto L1272;
    }
  if(vn==vt_FILEPTR ){
      if(varcode->Methd==mt_FuncSubDecC_Dec ){
          strcpy(varcode->Functype, join(3,VAR,PTH,CB));
          goto L1275;
        }
      if(varcode->Methd==mt_FuncSubDecC_DecAParam ){
          strcpy(varcode->Header, join(4,varcode->Header,VAR,PTH,pszHead));
          if(inchr(varcode->Token,"[")){
              strcpy(varcode->Proto, join(5,varcode->Proto,VAR,PT,SPC,pszHead));
            }
          else
            {
              strcpy(varcode->Proto, join(3,varcode->Proto,VAR,PT));
            }
          goto L1275;
        }
      if(varcode->Methd==mt_Opts ){
          strcpy(varcode->Functype, join(2,VAR,PTH));
          goto L1275;
        }
      if(varcode->Methd==mt_OptsAParam ){
          strcpy(varcode->Header, join(4,varcode->Header,VAR,PTH,pszHead));
          strcpy(varcode->Proto, join(3,varcode->Proto,VAR,PT));
          goto L1275;
        }
      if(varcode->Methd==mt_ConsDesAParam ){
          strcpy(varcode->Header, join(4,varcode->Header,VAR,PTH,pszHead));
          strcpy(varcode->Proto, join(4,varcode->Proto,VAR,PTH,pszHead));
          goto L1275;
        }
      if(varcode->Methd==mt_OverLoad ){
          strcpy(varcode->Functype, join(2,VAR,SPC));
          goto L1275;
        }
      if(varcode->Methd==mt_OverLoadAParam ){
          strcpy(varcode->Header, join(4,varcode->Header,VAR,PTH,pszHead));
        }
L1275:;
      goto L1272;
    }
  if(vn==vt_CHAR||vn==vt_SCHAR ){
      if(varcode->Methd==mt_FuncSubDecC_Dec ){
          strcpy(varcode->Functype, join(3,VAR,PTH,CB));
          goto L1276;
        }
      if(varcode->Methd==mt_FuncSubDecC_DecAParam ){
          strcpy(varcode->Header, join(4,varcode->Header,VAR,PTH,pszHead));
          strcpy(varcode->Proto, join(5,varcode->Proto,VAR,PT,SPC,pszProto));
          goto L1276;
        }
      if(varcode->Methd==mt_Opts ){
          strcpy(varcode->Functype, join(2,VAR,PTH));
          goto L1276;
        }
      if(varcode->Methd==mt_OptsAParam ){
          strcpy(varcode->Header, join(4,varcode->Header,VAR,PTH,pszHead));
          strcpy(varcode->Proto, join(5,varcode->Proto,VAR,PT,SPC,pszProto));
          goto L1276;
        }
      if(varcode->Methd==mt_ConsDesAParam ){
          strcpy(varcode->Header, join(4,varcode->Header,VAR,PTH,pszHead));
          strcpy(varcode->Proto, join(5,varcode->Proto,VAR,PTH,SPC,pszProto));
          goto L1276;
        }
      if(varcode->Methd==mt_OverLoad ){
          strcpy(varcode->Functype, join(2,VAR,SPC));
          goto L1276;
        }
      if(varcode->Methd==mt_OverLoadAParam ){
          strcpy(varcode->Header, join(4,varcode->Header,VAR,PTH,pszHead));
        }
L1276:;
      goto L1272;
    }
  if(vn==vt_UDT||vn==vt_STRUCT||vn==vt_UNION ){
      if(varcode->Methd==mt_ProcessSetCommand ){
          if(vn==vt_UNION ){
              strcpy(varcode->StaticOut, join(2,"static union  ",pszHead));
            }
          else
            {
              strcpy(varcode->StaticOut, join(3,"static struct _",pszHead,SPC));
            }
          goto L1277;
        }
      if(varcode->Methd==mt_FuncSubDecC_Dec ){
          strcpy(varcode->Functype, join(3,varcode->AsToken,PTH,CB));
          goto L1277;
        }
      if(varcode->Methd==mt_FuncSubDecC_DecAParam ){
          strcpy(varcode->Header, join(4,varcode->Header,varcode->AsToken,PTH,pszHead));
          strcpy(varcode->Proto, join(4,varcode->Proto,varcode->AsToken,RF,PT));
          goto L1277;
        }
      if(varcode->Methd==mt_Opts ){
          strcpy(varcode->Functype, join(2,varcode->AsToken,PTH));
          goto L1277;
        }
      if(varcode->Methd==mt_OptsAParam ){
          strcpy(varcode->Header, join(5,varcode->Header,Clean(varcode->AsToken),PTH,SPC,pszHead));
          strcpy(varcode->Proto, join(4,varcode->Proto,Clean(varcode->AsToken),RF,PT));
          goto L1277;
        }
      if(varcode->Methd==mt_ConsDesAParam ){
          strcpy(varcode->Header, join(5,varcode->Header,Clean(varcode->AsToken),PTH,SPC,pszHead));
          strcpy(varcode->Proto, join(5,varcode->Proto,Clean(varcode->AsToken),PTH,SPC,pszHead));
          goto L1277;
        }
      if(varcode->Methd==mt_OverLoad ){
          strcpy(varcode->Functype, join(2,VAR,SPC));
          goto L1277;
        }
      if(varcode->Methd==mt_OverLoadAParam ){
          strcpy(varcode->Header, join(4,varcode->Header,varcode->AsToken,PTH,pszHead));
        }
L1277:;
      goto L1272;
    }
  if(vn==vt_CONSTRDESTR ){
      if(varcode->Methd==mt_ConsDes ){
          strcpy(varcode->Functype, join(3,VAR,PTH,CB));
        }
    }
  else
    {
      if(varcode->Methd==mt_FuncSubDecC_Dec ){
          strcpy(varcode->Functype, join(3,varcode->AsToken,PTH,CB));
          goto L1279;
        }
      if(varcode->Methd==mt_FuncSubDecC_DecAParam ){
          strcpy(varcode->Header, join(4,varcode->Header,varcode->AsToken,PTH,pszHead));
          strcpy(varcode->Proto, join(4,varcode->Proto,varcode->AsToken,RF,PT));
          goto L1279;
        }
      if(varcode->Methd==mt_Opts ){
          strcpy(varcode->Functype, join(2,varcode->AsToken,PTH));
          goto L1279;
        }
      if(varcode->Methd==mt_OptsAParam ){
          strcpy(varcode->Header, join(5,varcode->Header,Clean(varcode->AsToken),PTH,SPC,pszHead));
          strcpy(varcode->Proto, join(4,varcode->Proto,Clean(varcode->AsToken),RF,PT));
          goto L1279;
        }
      if(varcode->Methd==mt_ConsDesAParam ){
          strcpy(varcode->Header, join(4,varcode->Header,Clean(varcode->AsToken),SPC,pszHead));
          strcpy(varcode->Proto, join(4,varcode->Proto,Clean(varcode->AsToken),SPC,pszHead));
        }
L1279:;
    }
L1272:;
}

void User_Global_Initialized_Arrays (FILE* FP_OUTPUT)
{
  static int Banner_Printed;
  char Banner[BCXSTRSIZE];
  char P[BCXSTRSIZE];
  int i;
  int A;
  char VarName[BCXSTRSIZE];
  char VarDim[BCXSTRSIZE];
  char Storage[BCXSTRSIZE];
  char VAR[BCXSTRSIZE];
  if(Banner_Printed==FALSE ){
      *Banner=0;
      strcpy(Banner, join(3,Banner,"",LF));
      strcpy(Banner, join(3,Banner,"// *************************************************",LF));
      strcpy(Banner, join(3,Banner,"//            User's Global Initialized Arrays",LF));
      strcpy(Banner, join(3,Banner,"// *************************************************",LF));
      Banner_Printed=TRUE;
      fprintf(FP_OUTPUT,"%s\n",Banner);
    }
  for(i=1; i<=GlobalVarCnt; i++)
    {
      if(GlobalVars[i].VarEmitFlag ){
          continue;
        }
      if(strcmp("",GlobalVars[i].VarDim)!=0  && GlobalVars[i].VarCondLevel==0 ){
          if(inchr(GlobalVars[i].VarDim,"{")){
              *P=0;
              if(GlobalVars[i].VarPntr ){
                  strcpy(P,stringx(GlobalVars[i].VarPntr,42));
                }
              A=GlobalVars[i].VarType;
              if(GlobalVars[i].VarSF ){
                  strcpy(VarName, join(4,"(*",GlobalVars[i].VarName,extract(GlobalVars[i].VarDim,"("),")"));
                  strcpy(VarDim,mid(GlobalVars[i].VarDim,inchr(GlobalVars[i].VarDim,"(")));
                }
              else
                {
                  strcpy(VarName,GlobalVars[i].VarName);
                  strcpy(VarDim,GlobalVars[i].VarDim);
                }
              strcpy(Storage, join(2,VarStorage[GlobalVars[i].VarExtn],VarConst[GlobalVars[i].VarConstant]));
              if(A==vt_STRVAR ){
                  fprintf(FP_OUTPUT,"%s%s%s%s%s\n",Storage,"char    ",VarName,VarDim,";");
                  goto L1281;
                }
              if(A==vt_FILEPTR ){
                  strcpy(GlobalVars[i].VarName,RemoveStr(GlobalVars[i].VarName,"@"));
                  fprintf(FP_OUTPUT,"%s%s%s%s%s\n",Storage,"FILE    *",VarName,VarDim,";");
                  goto L1281;
                }
              if(A==vt_LPSTR ){
                  fprintf(FP_OUTPUT,"%s%s%s%s%s%s\n",Storage,"PSTR   ",P,VarName,VarDim,";");
                  goto L1281;
                }
              if(A==vt_UDT||A==vt_STRUCT||A==vt_UNION ){
                  strcpy(VAR,TypeDefs[GlobalVars[i].VarDef].VarName);
                  strcpy(VAR,rpad(VAR,PADSIZE));
                  fprintf(FP_OUTPUT,"%s%s%s%s%s%s%s\n",Storage,VAR,SPC,P,VarName,VarDim,";");
                  goto L1281;
                }
              if(A>=vt_VarMin&&A<=vt_VarMax ){
                  strcpy(VAR,GetVarTypeName(GlobalVars[i].VarType));
                  strcpy(VAR,rpad(VAR,PADSIZE));
                  fprintf(FP_OUTPUT,"%s%s%s%s%s%s%s\n",Storage,VAR,SPC,P,VarName,VarDim,";");
                }
L1281:;
            }
        }
    }
}

void User_Overloaded_SubsFunctions (FILE* FP_OUTPUT)
{
  char LZZ[BCXSTRSIZE];
  FILE*  FP_OVR_IN;
  if(Use_Overloaded ){
      fprintf(FP_OUTPUT,"%s\n","// *************************************************");
      fprintf(FP_OUTPUT,"%s\n","//        User's Overloaded Subs/Functions          ");
      fprintf(FP_OUTPUT,"%s\n","// *************************************************");
      if((FP_OVR_IN=fopen(ovrFile, "rb"))==0)
       {
      fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", ovrFile); exit(1);
       }
      while(!EoF(FP_OVR_IN)){
          LZZ[0]=0;
          fgets(LZZ, 2048 , FP_OVR_IN);
            if(feof(FP_OVR_IN) || (LZZ[strlen(LZZ)-1]==10))
              {
               LZZ[strcspn(LZZ,"\r\n")] = 0;
              }
             else
              {
                printf("%s%d while reading file: %s\n","Error! - LINE INPUT truncation detected at PROGRAM line: ",__LINE__-7, NamePathFromFP(FP_OVR_IN));
                printf("%s\n","The actual truncated line of text:");
                printf("%s",LZZ);
                exit(1);
              }
          if(iMatchNQ(LZZ,"overloaded")){
              fprintf(FP_OUTPUT,"%s\n","\n");
            }
          fprintf(FP_OUTPUT,"%s\n",LZZ);
        }
      if(FP_OVR_IN)
       {
         fclose(FP_OVR_IN);
         FP_OVR_IN=NULL;
       }
      fprintf(FP_OUTPUT,"%s\n","\n\n");
    }
}

void User_Global_Set_Statements (FILE* FP_OUTPUT)
{
  char LTmp1[BCXSTRSIZE];
  FILE*  LFP1;
  if(lof(setFile)>0 ){
      if((LFP1=fopen(setFile, "rb"))==0)
       {
      fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", setFile); exit(1);
       }
      fprintf(FP_OUTPUT,"%s\n","");
      fprintf(FP_OUTPUT,"%s\n","// *************************************************");
      fprintf(FP_OUTPUT,"%s\n","//              User's GLOBAL SET Statements");
      fprintf(FP_OUTPUT,"%s\n","// *************************************************");
      fprintf(FP_OUTPUT,"%s\n","");
      while(!EoF(LFP1)){
          LTmp1[0]=0;
          fgets(LTmp1, 2048 , LFP1);
            if(feof(LFP1) || (LTmp1[strlen(LTmp1)-1]==10))
              {
               LTmp1[strcspn(LTmp1,"\r\n")] = 0;
              }
             else
              {
                printf("%s%d while reading file: %s\n","Error! - LINE INPUT truncation detected at PROGRAM line: ",__LINE__-7, NamePathFromFP(LFP1));
                printf("%s\n","The actual truncated line of text:");
                printf("%s",LTmp1);
                exit(1);
              }
          fprintf(FP_OUTPUT,"%s\n",LTmp1);
        }
      fprintf(FP_OUTPUT,"%s\n","");
      if(LFP1)
       {
         fclose(LFP1);
         LFP1=NULL;
       }
    }
}

void User_Prototypes (FILE* FP_OUTPUT)
{
  char LastDef[BCXSTRSIZE];
  int LastLevel;
  int A;
  if(ProtoCnt ){
      fprintf(FP_OUTPUT,"%s\n","");
      fprintf(FP_OUTPUT,"%s\n","// *************************************************");
      fprintf(FP_OUTPUT,"%s%s\n","//               ",BCX_STR_USR_PROTOS);
      fprintf(FP_OUTPUT,"%s\n","// *************************************************");
      fprintf(FP_OUTPUT,"%s\n","");
      *LastDef=0;
      LastLevel=1;
      for(A=1; A<=ProtoCnt; A++)
        {
          if(LastDef[0]==0 ){
              strcpy(LastDef,ProtoType[A].Condition);
              LastLevel=ProtoType[A].CondLevel;
              if(Use_SingleFile==FALSE ){
                  if(LastDef[0]!=0 ){
                      fprintf(FP_HeaderFile,"%s\n",LastDef);
                    }
                }
              if(LastDef[0]!=0 ){
                  fprintf(FP_OUTPUT,"%s\n",LastDef);
                }
            }
          if(strcmp(LastDef,ProtoType[A].Condition)!=0){
              if(strcmp(ProtoType[A].Condition,"#else")==0){
                  while(LastLevel>ProtoType[A].CondLevel){
                      if(Use_SingleFile==FALSE ){
                          fprintf(FP_HeaderFile,"%s\n","#endif");
                        }
                      fprintf(FP_OUTPUT,"%s\n","#endif");
                      LastLevel--;
                    }
                  if(Use_SingleFile==FALSE ){
                      fprintf(FP_HeaderFile,"%s\n","#else");
                    }
                  fprintf(FP_OUTPUT,"%s\n","#else");
                  strcpy(LastDef,ProtoType[A].Condition);
                  LastLevel=ProtoType[A].CondLevel;
                }
              else
                {
                  while(LastLevel>=ProtoType[A].CondLevel){
                      if(Use_SingleFile==FALSE ){
                          fprintf(FP_HeaderFile,"%s\n","#endif");
                        }
                      fprintf(FP_OUTPUT,"%s\n","#endif");
                      LastLevel--;
                    }
                  strcpy(LastDef,ProtoType[A].Condition);
                  LastLevel=ProtoType[A].CondLevel;
                  if(Use_SingleFile==FALSE ){
                      if(LastDef[0]!=0 ){
                          fprintf(FP_HeaderFile,"%s\n",LastDef);
                        }
                    }
                  if(LastDef[0]!=0 ){
                      fprintf(FP_OUTPUT,"%s\n",LastDef);
                    }
                }
            }
          if(UseStdCall&&UseCpp ){
              if(LeftStr(ProtoType[A].Prototype,"C_EXPORT ")){
                  Emit_ExportDef(ProtoType[A].Prototype);
                  UseImportExport=TRUE;
                }
            }
          char T[BCXSTRSIZE];
          strcpy(T,extract(ProtoType[A].Prototype,SPC));
          strcpy(T, join(2,rpad(T,PADSIZE),SPC));
          strcpy(ProtoType[A].Prototype, join(2,T,remain(ProtoType[A].Prototype,SPC)));
          strcpy(ProtoType[A].Prototype,replace(ProtoType[A].Prototype,"char*  ,","char*,"));
          strcpy(ProtoType[A].Prototype,replace(ProtoType[A].Prototype,"char    * ","char*   "));
          if(Use_SingleFile==FALSE ){
              fprintf(FP_HeaderFile,"%s\n",ProtoType[A].Prototype);
            }
          fprintf(FP_OUTPUT,"%s\n",ProtoType[A].Prototype);
        }
      if(FPDEF ){
          if(FPDEF)
           {
             fclose(FPDEF);
             FPDEF=NULL;
           }
        }
      if(*LastDef ){
          while(LastLevel>0){
              if(Use_SingleFile==FALSE ){
                  fprintf(FP_HeaderFile,"%s\n","#endif");
                }
              fprintf(FP_OUTPUT,"%s\n","#endif");
              LastLevel--;
            }
        }
    }
}

void Emit_OSVersionEnum ()
{
  static int BeenHereDoneThat;
  if(BeenHereDoneThat==TRUE ){
      return;
    }
  BeenHereDoneThat=TRUE;
  fprintf(FP_ENU,"%s\n","");
  fprintf(FP_ENU,"%s\n","enum");
  fprintf(FP_ENU,"%s\n","  {");
  fprintf(FP_ENU,"%s\n","  OSUnknown = -2,");
  fprintf(FP_ENU,"%s\n","  OSError = -1,");
  fprintf(FP_ENU,"%s\n","  OS_3x,");
  fprintf(FP_ENU,"%s\n","  OS_95,");
  fprintf(FP_ENU,"%s\n","  OS_98,");
  fprintf(FP_ENU,"%s\n","  OS_ME,");
  fprintf(FP_ENU,"%s\n","  OS_NT3,");
  fprintf(FP_ENU,"%s\n","  OS_2000,");
  fprintf(FP_ENU,"%s\n","  OS_XP,");
  fprintf(FP_ENU,"%s\n","  OS_XP_Pro_x64,");
  fprintf(FP_ENU,"%s\n","  OS_Server_2003,");
  fprintf(FP_ENU,"%s\n","  OS_Home_Server,");
  fprintf(FP_ENU,"%s\n","  OS_Server_2003_R2,");
  fprintf(FP_ENU,"%s\n","  OS_Vista,");
  fprintf(FP_ENU,"%s\n","  OS_Server_2008,");
  fprintf(FP_ENU,"%s\n","  OS_Server_2008_R2,");
  fprintf(FP_ENU,"%s\n","  OS_Win_7,");
  fprintf(FP_ENU,"%s\n","  OS_Server_2012,");
  fprintf(FP_ENU,"%s\n","  OS_Win_8,");
  fprintf(FP_ENU,"%s\n","  OS_Win_81,");
  fprintf(FP_ENU,"%s\n","  OS_Server_2012_R2,");
  fprintf(FP_ENU,"%s\n","  OS_Win_10,");
  fprintf(FP_ENU,"%s\n","  OS_Server_2016,");
  fprintf(FP_ENU,"%s\n","  OS_Win_11,");
  fprintf(FP_ENU,"%s\n","  OS_Server_2019,");
  fprintf(FP_ENU,"%s\n","  OS_Server_2022");
  fprintf(FP_ENU,"%s\n","  };");
  fprintf(FP_ENU,"%s\n","");
}

void AddMacros (FILE* FP_OUTPUT)
{
  if(Use_SysMacros||Use_Wingui ){
      fprintf(FP_OUTPUT,"%s\n","");
      fprintf(FP_OUTPUT,"%s\n","// *************************************************");
      fprintf(FP_OUTPUT,"%s%s\n","//               ",BCX_STR_STD_MACROS);
      fprintf(FP_OUTPUT,"%s\n","// *************************************************");
      fprintf(FP_OUTPUT,"%s\n","");
    }
  int Accum=Use_Form;
  Accum+=(Use_Button);
  Accum+=(Use_BmpButton);
  Accum+=(Use_Edit);
  Accum+=(Use_BCX_Input);
  Accum+=(Use_Label);
  Accum+=(Use_Group);
  Accum+=(Use_Checkbox);
  Accum+=(Use_Radio);
  Accum+=(Use_Combobox);
  Accum+=(Use_Listbox);
  Accum+=(Use_Treeview);
  Accum+=(Use_Blackrect);
  Accum+=(Use_Whiterect);
  Accum+=(Use_Grayrect);
  Accum+=(Use_Datepick);
  Accum+=(Use_Listview);
  Accum+=(Use_BCX_Control);
  Accum+=(Use_BCX_Slider);
  Accum+=(Use_BCX_Tab);
  Accum+=(Use_BCX_Toolbar);
  Accum+=(Use_BCX_UpDown);
  Accum+=(Use_BCX_FrameWnd);
  Accum+=(Use_BCX_Wnd);
  if(Accum ){
      if(!Use_Project ){
          fprintf(FP_OUTPUT,"%s\n","#define DefFont ((BcxFont!=0)?BcxFont:(HFONT)SNDMSG(hWnd, WM_GETFONT, 0, 0))");
          fprintf(FP_OUTPUT,"%s\n","#define DefaultFont ((DefFont==0)?GetStockObject(DEFAULT_GUI_FONT):DefFont)");
        }
      else
        {
          fprintf(FP_OUTPUT,"%s\n","#ifndef __BCXFONT_DEFINED__");
          fprintf(FP_OUTPUT,"%s\n","  #define __BCXFONT_DEFINED__");
          fprintf(FP_OUTPUT,"%s\n","  #define DefFont ((BcxFont!=0)?BcxFont:(HFONT)SNDMSG(hWnd, WM_GETFONT, 0, 0))");
          fprintf(FP_OUTPUT,"%s\n","  #define DefaultFont ((DefFont==0)?GetStockObject(DEFAULT_GUI_FONT):DefFont)");
          fprintf(FP_OUTPUT,"%s\n","#endif");
        }
      AddBcxFontVar();
    }
  if(Use_SysMacros ){
      if(Use_ForEach ){
          fprintf(FP_OUTPUT,"%s\n","#define FOR_EACH(i, a) {for(UINT i=0; i<sizeof(a)/sizeof((a)[0]); i++){");
          fprintf(FP_OUTPUT,"%s\n","#define NEXT_EACH }}");
          fprintf(FP_OUTPUT,"%s\n","#define EXIT_EACH break;");
        }
      if(Use_Clip_Reset ){
          fprintf(FP_OUTPUT,"%s\n","#define Clipboard_Reset OpenClipboard(NULL),EmptyClipboard(),CloseClipboard();");
        }
      if(Use_Cast ){
          fprintf(FP_OUTPUT,"%s\n","#define CAST(to_type,old_obj) ((to_type)(old_obj))");
        }
      if(Use_Read ){
          fprintf(FP_OUTPUT,"%s\n","#define READ(a) DATA[(a)-1]");
        }
      if(Use_Readnum ){
          fprintf(FP_OUTPUT,"%s\n","#define READNUM(a) (double)atof((DATA[(a)-1]))");
        }
      if(Use_EqualTo ){
          fprintf(FP_OUTPUT,"%s\n","#define EqualTo ==");
        }
      if(Use_NotEqualTo ){
          fprintf(FP_OUTPUT,"%s\n","#define NotEqualTo !=");
        }
      if(Use_BcxSplitPath ){
          fprintf(FP_OUTPUT,"%s\n","#define FDRV   2");
          fprintf(FP_OUTPUT,"%s\n","#define FPATH  4");
          fprintf(FP_OUTPUT,"%s\n","#define FNAME  8");
          fprintf(FP_OUTPUT,"%s\n","#define FEXT  16");
        }
      if(Use_Cbool ){
          fprintf(FP_OUTPUT,"%s\n","#define CBOOL(A)((A)!=0)?1:0");
        }
      if(Use_Istrue ){
          fprintf(FP_OUTPUT,"%s\n","#define ISTRUE 0!=");
        }
      if(Use_Notzero ){
          fprintf(FP_OUTPUT,"%s\n","#define NOTZERO 0!=");
        }
      if(Use_Notnull ){
          fprintf(FP_OUTPUT,"%s\n","#define NOTNULL(A)(*(A)!= 0)");
        }
      if(Use_Isnull ){
          fprintf(FP_OUTPUT,"%s\n","#define ISNULL(A)(*(A)== 0)");
        }
      if(Use_Isfalse ){
          fprintf(FP_OUTPUT,"%s\n","#define ISFALSE 0==");
        }
      if(Use_Iszero ){
          fprintf(FP_OUTPUT,"%s\n","#define ISZERO 0==");
        }
      if(Use_Isptr ){
          fprintf(FP_OUTPUT,"%s\n","#define IsPtr(a)((ULONG_PTR)(a))");
        }
      if(Use_ByteAt ){
          fprintf(FP_OUTPUT,"%s\n","#define BYTE_AT(B) (B)");
        }
      if(Use_Bnot ){
          fprintf(FP_OUTPUT,"%s\n","#define BNOT ~(int)");
        }
      if(Use_Datacount ){
          fprintf(FP_OUTPUT,"%s\n","#define DATACOUNT (int)(sizeof((DATA))/sizeof((DATA[0])))");
        }
      if(Use_Ubound ){
          fprintf(FP_OUTPUT,"%s\n","#define ubound_s(t)(int)(sizeof((t))/sizeof((t[0]))-1)");
          fprintf(FP_OUTPUT,"%s\n","#define ubound_d(i)(int)(_msize((i))/sizeof(i[0])-3)");
          fprintf(FP_OUTPUT,"%s\n","#define ubound(x)((int)ubound_s(x)<2?ubound_d(x):ubound_s(x))");
        }
      if(Use_Clear ){
          fprintf(FP_OUTPUT,"%s\n","#define Clear(arg)memset(&arg,0,sizeof(arg))");
        }
      if(Use_Imod ){
          fprintf(FP_OUTPUT,"%s\n","#define imod(a,b)((a)%(b))");
        }
      if(Use_BCX_OlePicture ){
          fprintf(FP_OUTPUT,"%s\n","#define BCX_OLE_WIDTH(H)  LOWORD(PtrToUlong(GetWindowLongPtr(H,GWLP_USERDATA)))");
          fprintf(FP_OUTPUT,"%s\n","#define BCX_OLE_HEIGHT(H) HIWORD(PtrToUlong(GetWindowLongPtr(H,GWLP_USERDATA)))");
        }
      if(Use_BCX_Resize ){
          fprintf(FP_OUTPUT,"%s\n","#define BCX_RESIZE(hwnd,cx,cy) SetWindowPos (hwnd,NULL,0,0,(cx),(cy),SWP_NOMOVE|SWP_NOREPOSITION|SWP_NOZORDER|SWP_FRAMECHANGED)");
        }
      if(Use_BCX_Cursor ){
          fprintf(FP_OUTPUT,"%s\n","#define BCX_Cursor(x)SetCursor(LoadCursor(NULL,x))");
        }
      if(Use_Refresh ){
          fprintf(FP_OUTPUT,"%s\n","#define Refresh(A) RedrawWindow(A,NULL,NULL,RDW_ERASE|RDW_INVALIDATE|RDW_ALLCHILDREN|RDW_UPDATENOW);");
        }
      if(Use_ShowModal ){
          fprintf(FP_OUTPUT,"%s\n","#define ShowModal(Window)EnableWindow(GetWindow(Window,GW_OWNER),FALSE);SHOWHWNDWindow);");
        }
      if(Use_EndModal ){
          fprintf(FP_OUTPUT,"%s\n","#define EndModal(Window)EnableWindow(GetWindow(Window,GW_OWNER),TRUE);DestroyWindow(Window);");
        }
      if(Use_Show ){
          fprintf(FP_OUTPUT,"%s\n","#define SHOWHWND(Window)RedrawWindow(Window,0,0,0);ShowWindow(Window,SW_SHOW);");
        }
      if(Use_Hide ){
          fprintf(FP_OUTPUT,"%s\n","#define HIDEHWND(Window)ShowWindow(Window,SW_HIDE)");
        }
      if(Use_Get ){
          fprintf(FP_OUTPUT,"%s\n","#define GET(A,B,C)fread((B),1,(C),(A))");
        }
      if(Use_Put ){
          fprintf(FP_OUTPUT,"%s\n","#define PUT(A,B,C)fwrite((B),1,(C),(A))");
        }
      if(Use_Seteof ){
          fprintf(FP_OUTPUT,"%s\n","#define SetEof(A) SetEndOfFile((HANDLE)_get_osfhandle(_fileno((A))))");
        }
      if(Use_Strptr ){
          fprintf(FP_OUTPUT,"%s\n","#define STRPTR(A)(char*)&((A))");
        }
      if(Use_Val ){
          fprintf(FP_OUTPUT,"%s\n","#define VAL(a)(double)atof((a))");
        }
      if(Use_Vall ){
          fprintf(FP_OUTPUT,"%s\n","#if defined(__LCC__)||defined(__POCC__)||defined(__MINGW32__)||defined(__MINGW64__)");
          fprintf(FP_OUTPUT,"%s\n","  #define VALL(a) (long double)strtold((a),(char**)NULL)");
          fprintf(FP_OUTPUT,"%s\n","#elif defined(__BCPLUSPLUS__)");
          fprintf(FP_OUTPUT,"%s\n","  #define VALL(a) (long double)_strtold((a),(char**)NULL)");
          fprintf(FP_OUTPUT,"%s\n","#else");
          fprintf(FP_OUTPUT,"%s\n","  #define VALL(a) (long double)strtod((a),(char**)NULL)");
          fprintf(FP_OUTPUT,"%s\n","#endif");
        }
      if(Use_Getattr ){
          fprintf(FP_OUTPUT,"%s\n","#define GETATTR(a)(ULONG)GetFileAttributes((a))");
        }
      if(Use_Setattr ){
          fprintf(FP_OUTPUT,"%s\n","#define SETATTR(a,b)(ULONG)SetFileAttributes((a),(b))");
        }
      if(Use_Frac ){
          fprintf(FP_OUTPUT,"%s\n","#define FRAC(a)(double)(((a))-FIX((a)))");
          Use_Fix=TRUE;
        }
      if(Use_Fracl ){
          fprintf(FP_OUTPUT,"%s\n","#define FRACL(a)(long double)((a)-FIX((a)))");
          Use_Fix=TRUE;
        }
      if(Use_Fix ){
          fprintf(FP_OUTPUT,"%s\n","#define FIX(a)(int)((a))");
        }
      if(Use_Csng ){
          fprintf(FP_OUTPUT,"%s\n","#define CSNG(a)(float)((a))");
        }
      if(Use_Cdbl ){
          fprintf(FP_OUTPUT,"%s\n","#define CDBL(a)(double)((a))");
        }
      if(Use_Cldbl ){
          fprintf(FP_OUTPUT,"%s\n","#define CLDBL(a)(long double)((a))");
        }
      if(Use_DegToRad ){
          fprintf(FP_OUTPUT,"%s\n","#define DegToRad(Degrees)((Degrees)*0.017453292519943)");
        }
      if(Use_RadToDeg ){
          fprintf(FP_OUTPUT,"%s\n","#define RadToDeg(Radians)((Radians)*57.29577951308232)");
        }
      if(Use_Threads ){
          fprintf(FP_OUTPUT,"%s\n","");
          fprintf(FP_OUTPUT,"%s\n","#define BCX_THREAD(a)        (HANDLE)_beginthreadex(0,0,(unsigned int (__stdcall *)(void *))a,0,0,(unsigned int *)&BCX_Thread_ID)");
          fprintf(FP_OUTPUT,"%s\n","#define BCX_THREADWAIT(a)    while(WaitForSingleObject(((void *)a),0)==WAIT_TIMEOUT){}CloseHandle(((void *)a))");
          fprintf(FP_OUTPUT,"%s\n","#define BCX_THREADSUSPEND(a) SuspendThread((void *)a)");
          fprintf(FP_OUTPUT,"%s\n","#define BCX_THREADRESUME(a)  ResumeThread((void *)a)");
          fprintf(FP_OUTPUT,"%s\n","#define BCX_THREADKILL(a)    TerminateThread((void *)a,0); CloseHandle((void *)a)");
          fprintf(FP_OUTPUT,"%s\n","#define BCX_THREADEND        _endthreadex(0)");
          fprintf(FP_OUTPUT,"%s\n","ULONG   BCX_Thread_ID = 0;");
          fprintf(FP_OUTPUT,"%s\n","");
        }
      if(Use_LineinputKB ){
          fprintf(FP_OUTPUT,"%s\n","#define mIsDynaString(v)(sizeof((v))==4||sizeof((v))==8)?1:0");
          fprintf(FP_OUTPUT,"%s\n","");
          fprintf(FP_OUTPUT,"%s\n","#define mLineInputKB(p,v)\\");
          fprintf(FP_OUTPUT,"%s\n","{\\");
          fprintf(FP_OUTPUT,"%s%s%s\n","  printf(",enc("%s"),",(p));\\");
          fprintf(FP_OUTPUT,"%s\n","  if(mIsDynaString(v))\\");
          fprintf(FP_OUTPUT,"%s\n","     fgets((v), _msize((v)), stdin);\\");
          fprintf(FP_OUTPUT,"%s\n","   else \\");
          fprintf(FP_OUTPUT,"%s\n","     fgets((v), sizeof((v)), stdin);\\");
          fprintf(FP_OUTPUT,"%s\n","  (v)[strlen((v))-1]=0;\\");
          fprintf(FP_OUTPUT,"%s\n","}");
          fprintf(FP_OUTPUT,"%s\n","");
        }
    }
}

void Emit_MDI_MsgPump ()
{
  if((int)strlen(Accelerator)){
      fprintf(FP_WRITE,"%s\n","  if(!BCX_hwndMDIClient)");
      fprintf(FP_WRITE,"%s\n","    {");
      fprintf(FP_WRITE,"%s\n","      return FALSE;");
      fprintf(FP_WRITE,"%s\n","    }");
      fprintf(FP_WRITE,"%s\n","  while((GetMessage(&Msg,NULL,0,0)))");
      fprintf(FP_WRITE,"%s\n","    {");
      fprintf(FP_WRITE,"%s\n","      HWND hActiveWindow=GetActiveWindow();");
      fprintf(FP_WRITE,"%s\n","      if((!TranslateMDISysAccel(BCX_hwndMDIClient,&Msg)))");
      fprintf(FP_WRITE,"%s\n","        {");
      fprintf(FP_WRITE,"%s%s%s\n","          if((!TranslateAccelerator(hActiveWindow,",Accelerator,",&Msg)))");
      fprintf(FP_WRITE,"%s\n","            {");
      fprintf(FP_WRITE,"%s\n","              TranslateMessage(&Msg);");
      fprintf(FP_WRITE,"%s\n","              DispatchMessage(&Msg);");
      fprintf(FP_WRITE,"%s\n","            }");
      fprintf(FP_WRITE,"%s\n","        }");
      fprintf(FP_WRITE,"%s\n","    }");
      fprintf(FP_WRITE,"%s\n","  return Msg.wParam;");
      fprintf(FP_WRITE,"%s\n","}\n");
    }
  else
    {
      fprintf(FP_WRITE,"%s\n"," if(!BCX_hwndMDIClient)");
      fprintf(FP_WRITE,"%s\n"," {");
      fprintf(FP_WRITE,"%s\n","   return FALSE;");
      fprintf(FP_WRITE,"%s\n"," }");
      fprintf(FP_WRITE,"%s\n"," while((GetMessage(&Msg,NULL,0,0)))");
      fprintf(FP_WRITE,"%s\n","   {");
      fprintf(FP_WRITE,"%s\n","   if((!TranslateMDISysAccel(BCX_hwndMDIClient,&Msg)))");
      fprintf(FP_WRITE,"%s\n","     {");
      fprintf(FP_WRITE,"%s\n","       TranslateMessage(&Msg);");
      fprintf(FP_WRITE,"%s\n","       DispatchMessage(&Msg);");
      fprintf(FP_WRITE,"%s\n","     }");
      fprintf(FP_WRITE,"%s\n","   }");
      fprintf(FP_WRITE,"%s\n","return Msg.wParam;");
      fprintf(FP_WRITE,"%s\n","}\n");
    }
}

void Emit_GUI_MsgPump ()
{
  if((int)strlen(Accelerator)){
      fprintf(FP_WRITE,"%s\n"," while(GetMessage(&Msg,NULL,0,0))");
      fprintf(FP_WRITE,"%s\n","   {");
      fprintf(FP_WRITE,"%s\n","    HWND hActiveWindow = GetActiveWindow();");
      fprintf(FP_WRITE,"%s%s%s\n","    if(!TranslateAccelerator(hActiveWindow,",Accelerator,",&Msg) &&");
      fprintf(FP_WRITE,"%s\n","       ((!IsDialogMessage(hActiveWindow,&Msg)) || (!IsWindow(hActiveWindow))))");
      fprintf(FP_WRITE,"%s\n","      {");
      fprintf(FP_WRITE,"%s\n","        TranslateMessage(&Msg);");
      fprintf(FP_WRITE,"%s\n","        DispatchMessage(&Msg);");
      fprintf(FP_WRITE,"%s\n","      }");
      fprintf(FP_WRITE,"%s\n","   }");
      fprintf(FP_WRITE,"%s\n"," return Msg.wParam;");
      fprintf(FP_WRITE,"%s\n","}\n");
    }
  else
    {
      fprintf(FP_WRITE,"%s\n"," while(GetMessage(&Msg,NULL,0,0))");
      fprintf(FP_WRITE,"%s\n","   {");
      fprintf(FP_WRITE,"%s\n","    HWND hActiveWindow = GetActiveWindow();");
      fprintf(FP_WRITE,"%s\n","    if((!IsWindow(hActiveWindow)) || (!IsDialogMessage(hActiveWindow,&Msg)))");
      fprintf(FP_WRITE,"%s\n","      {");
      fprintf(FP_WRITE,"%s\n","        TranslateMessage(&Msg);");
      fprintf(FP_WRITE,"%s\n","        DispatchMessage(&Msg);");
      fprintf(FP_WRITE,"%s\n","      }");
      fprintf(FP_WRITE,"%s\n","    }");
      fprintf(FP_WRITE,"%s\n"," return Msg.wParam;");
      fprintf(FP_WRITE,"%s\n","}\n");
    }
}

void Emit_WinGUIMain (char* classname,char* metric,char* icon)
{
  fprintf(FP_WRITE,"%s\n","");
  fprintf(FP_WRITE,"%s\n","int WINAPI WinMain(HINSTANCE hInst,HINSTANCE hPrev,PSTR CmdLine,int CmdShow) {");
  fprintf(FP_WRITE,"%s\n","    MSG  Msg;");
  fprintf(FP_WRITE,"%s%s%s\n","  strcpy(BCX_ClassName,",classname,");");
  fprintf(FP_WRITE,"%s%s%s\n","  BCX_SetMetric(",enc(metric),");");
  fprintf(FP_WRITE,"%s\n","  BCX_InitGUI();");
  fprintf(FP_WRITE,"%s\n","  BCX_hInstance       =  hInst;");
  fprintf(FP_WRITE,"%s%s\n","  BCX_WndClass.hIcon  = ",icon);
  fprintf(FP_WRITE,"%s\n","  BCX_RegWnd(BCX_ClassName, WndProc);");
  fprintf(FP_WRITE,"%s\n","");
  fprintf(FP_WRITE,"%s\n","  // ******************************************");
  fprintf(FP_WRITE,"%s\n","                    FormLoad();");
  fprintf(FP_WRITE,"%s\n","  // ******************************************");
}

void Emit_MDICode (FILE* FP_OUTPUT)
{
  fprintf(FP_OUTPUT,"%s\n","HWND BCX_MDICHILD (LPCTSTR title, LPCTSTR MdiClassName,int x,int y,int cx,int cy,ULONG style,LPARAM lParam) {");
  fprintf(FP_OUTPUT,"%s\n","  HWND  hwndChild;");
  fprintf(FP_OUTPUT,"%s%s\n","  char rgch","[BCXSTRSIZE]={0};");
  fprintf(FP_OUTPUT,"%s\n","  static int cUntitled=1;");
  fprintf(FP_OUTPUT,"%s\n","  if(title[0]==0)");
  fprintf(FP_OUTPUT,"%s\n","    {");
  fprintf(FP_OUTPUT,"%s%s%s%s%s\n","      sprintf(rgch,",enc("%s%i"),",",enc("Untitled"),",cUntitled++);");
  fprintf(FP_OUTPUT,"%s\n","    }");
  fprintf(FP_OUTPUT,"%s\n","  else");
  fprintf(FP_OUTPUT,"%s\n","    {");
  fprintf(FP_OUTPUT,"%s\n","      strcpy(rgch,title);");
  fprintf(FP_OUTPUT,"%s\n","    }");
  fprintf(FP_OUTPUT,"%s\n","  //  Create the MDI child window");
  fprintf(FP_OUTPUT,"%s\n","  hwndChild = CreateMDIWindow(MdiClassName, rgch, style, x, y,");
  fprintf(FP_OUTPUT,"%s\n","              cx, cy, BCX_hwndMDIClient, BCX_hInstance, lParam);");
  fprintf(FP_OUTPUT,"%s\n","  return hwndChild;");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
  fprintf(FP_OUTPUT,"%s\n","void BCX_MDICLASS (WNDPROC MCWP, PCHAR ClassName) {");
  fprintf(FP_OUTPUT,"%s\n","  WNDCLASS wc={0};");
  fprintf(FP_OUTPUT,"%s\n","  wc.style=0;");
  fprintf(FP_OUTPUT,"%s\n","  wc.lpfnWndProc=(WNDPROC)MCWP;");
  fprintf(FP_OUTPUT,"%s\n","  wc.cbClsExtra=0;");
  fprintf(FP_OUTPUT,"%s\n","  wc.cbWndExtra=20;");
  fprintf(FP_OUTPUT,"%s\n","  wc.hInstance=BCX_hInstance;");
  fprintf(FP_OUTPUT,"%s%s\n","  wc.hIcon= ",GUIIcon);
  fprintf(FP_OUTPUT,"%s\n","  wc.hCursor=LoadCursor(NULL,IDC_ARROW);");
  fprintf(FP_OUTPUT,"%s\n","  wc.hbrBackground=(HBRUSH)(COLOR_WINDOW+1);");
  fprintf(FP_OUTPUT,"%s\n","  wc.lpszMenuName=NULL;");
  fprintf(FP_OUTPUT,"%s\n","  wc.lpszClassName=ClassName;");
  fprintf(FP_OUTPUT,"%s\n","  RegisterClass((LPWNDCLASS)&wc);");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
  fprintf(FP_OUTPUT,"%s\n","HWND BCX_MDICLIENT (HWND hwndparent, int icount) {");
  fprintf(FP_OUTPUT,"%s\n","  CLIENTCREATESTRUCT ccs={0,1};");
  fprintf(FP_OUTPUT,"%s\n","  //  Find window menu where children will be listed");
  fprintf(FP_OUTPUT,"%s\n","  ccs.hWindowMenu=GetSubMenu(GetMenu(hwndparent),icount-1);");
  fprintf(FP_OUTPUT,"%s\n","  //  Create the MDI client filling the client area");
  fprintf(FP_OUTPUT,"%s%s%s\n","  BCX_hwndMDIClient=CreateWindow(",enc("MDICLIENT"),",NULL, WS_CHILD | WS_CLIPCHILDREN | WS_VISIBLE | WS_VSCROLL | WS_HSCROLL,");
  fprintf(FP_OUTPUT,"%s\n","                                 0,0,0,0,hwndparent,(HMENU)(UINT_PTR)NULL,BCX_hInstance,(PVOID)&ccs);");
  fprintf(FP_OUTPUT,"%s\n","  return BCX_hwndMDIClient;");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
}

int JoinLines (char* Arg)
{
  strcpy(Arg,rtrim(Arg));
  if(iMatchRgt(Arg," _")||iMatchRgt(Arg,",_")||iMatchRgt(Arg,";_")||iMatchRgt(Arg,":_")||iMatchRgt(Arg,")_")||iMatchRgt(Arg,"]_")||iMatchRgt(Arg,"}_")||iMatchRgt(Arg,">_")||iMatchRgt(Arg,"$_")||iMatchRgt(Arg,join(2,DQ,"_"))){
      Arg[(int)strlen(Arg)-1]=0;
      strcat(CurLine,Arg);
      return TRUE;
    }
  if(NOTNULL(CurLine)){
      strcpy(Arg, join(2,CurLine,Arg));
      *CurLine=0;
    }
  UmQt=FALSE;
  return FALSE;
}

void StripCode (char* Arg)
{
  PCHAR  p;
  PCHAR  p2=Arg;
  int asmFlag=0;
  int eStr=0;
  char sub_[BCXSTRSIZE];
  while((*p2>8&&*p2<13)||*p2==32){
      p2++;
    }
  if(*p2==33 ){
      asmFlag=!UmQt;
    }
  p=p2;
  while(*p){
      if(*p==9 ){
          *p=32;
        }
      if(*p==c_DblQt ){
          if(*(p-1)==69 ){
              *(p-1)=1;
              eStr=TRUE;
            }
          while(*(++p)!=c_DblQt){
              if(*p==92&&eStr ){
                  *p=2;
                  if(*(p+1)==48 ){
                      *(p+1)=3;
                      goto L1291;
                    }
                  if(*(p+1)==116 ){
                      *(p+1)=4;
                      goto L1291;
                    }
                  if(*(p+1)==110 ){
                      *(p+1)=5;
                      goto L1291;
                    }
                  if(*(p+1)==114 ){
                      *(p+1)=6;
                      goto L1291;
                    }
                  if(*(p+1)==113 ){
                      *(p+1)=7;
                      goto L1291;
                    }
                  if(*(p+1)==92 ){
                      *(p+1)=8;
                    }
L1291:;
                  p++;
                }
              if(*p==0 ){
                  UmQt=!UmQt;
                  goto L1290;
                }
            }
L1290:;
        }
      if(!UmQt&&!asmFlag ){
          if((*p|32)==114 ){
              if((*(p+1)|32)==101&&(*(p+2)|32)==109&&(*(p+3)==32||*(p+3)==0)){
                  if(p==p2||*(p-1)==58||*(p-1)==32 ){
                      *p=0;
                      goto L1289;
                    }
                }
            }
          if(*p==39||(*p==47&&*(p+1)==47)){
              *p=0;
              goto L1289;
            }
        }
      p++;
    }
L1289:;
  while(p2<p){
      while((*(p-1)>8&&*(p-1)<13)||*(p-1)==32){
          *(--p)=0;
        }
      if(UmQt||asmFlag ){
          goto L1292;
        }
      if(*(p-1)==58&&*(p-2)==32 ){
          p--;
        }
      else
        {
          goto L1292;
        }
    }
L1292:;
  if(eStr ){
      strcpy(p2,RemoveStr(p2,chr(1)));
      strcpy(p2,RemoveStr(p2,chr(2)));
      strcpy(sub_,enc("+CHR$(0)+"));
      strcpy(p2,replace(p2,chr(3),sub_));
      strcpy(sub_,enc("+CHR$(9)+"));
      strcpy(p2,replace(p2,chr(4),sub_));
      strcpy(sub_,enc("+CHR$(10)+"));
      strcpy(p2,replace(p2,chr(5),sub_));
      strcpy(sub_,enc("+CHR$(13)+"));
      strcpy(p2,replace(p2,chr(6),sub_));
      strcpy(sub_,enc("+CHR$(34)+"));
      strcpy(p2,replace(p2,chr(7),sub_));
      strcpy(sub_,enc("+CHR$(92)+"));
      strcpy(p2,replace(p2,chr(8),sub_));
      strcpy(p2,RemoveStr(p2,chr(c_DblQt,c_DblQt,43)));
      strcpy(p2,RemoveStr(p2,chr(43,c_DblQt,c_DblQt)));
    }
  strcpy(Arg,p2);
}

void ProcSingleLineIf (int* ifFlag)
{
  char Tmp[BCXSTRSIZE];
  int ifp;
  int NdIfs;
  static int EFlag;
  if((*ifFlag)==0 ){
      EFlag=0;
    }

REDO:;
  if(SplitCnt==cMaxSplitLines ){
      Abort("Stack Overflow - Too many statements on one line");
    }
  strcpy(Tmp, join(2,SplitStk[SplitCnt],SPC));
  if(iMatchLft(Tmp,"if ")){
      ifp=iMatchNQ(Tmp," then ");
      if(ifp ){
          if(SplitCnt==cMaxSplitLines-1 ){
              Abort("Stack Overflow - Too many statements on one line");
            }
          strcpy(SplitStk[SplitCnt++],left(Tmp,ifp+4));
          strcpy(SplitStk[SplitCnt],ltrim(Tmp+ifp+4));
          EFlag=IMAX(0,EFlag-1);
          (*ifFlag)++;
          goto REDO;
        }
    }
  else
    {
      if((*ifFlag)){
          if(iMatchLft(Tmp,"else ")){

LFTLSE:;
              if(++EFlag>1 ){
                  NdIfs=IMAX(1,(*ifFlag)-1);
                  (*ifFlag)=1;
                  EFlag=0;
                  if(iMatchWrd(SplitStk[SplitCnt-1],"else")){
                      SplitCnt--;
                    }
                  if(SplitCnt==cMaxSplitLines-1 ){
                      Abort("Stack Overflow - Too many statements on one line");
                    }
                    for(int BCX_REPEAT = 1; BCX_REPEAT <= NdIfs; BCX_REPEAT++)
                    {
                      strcpy(SplitStk[SplitCnt++],"END IF");
                    }
                }
              if(SplitCnt==cMaxSplitLines-1 ){
                  Abort("Stack Overflow - Too many statements on one line");
                }
              strcpy(SplitStk[SplitCnt++],"ELSE");
              strcpy(SplitStk[SplitCnt],trim(Tmp+4));
              goto REDO;
            }
          else
            {
              ifp=iMatchNQ(Tmp," else ");
              if(ifp ){
                  if(SplitCnt==cMaxSplitLines-1 ){
                      Abort("Stack Overflow - Too many statements on one line");
                    }
                  strcpy(SplitStk[SplitCnt++],rtrim(left(Tmp,ifp-1)));
                  strcpy(Tmp,mid(Tmp,ifp+1));
                  goto LFTLSE;
                }
            }
        }
    }
}

int SplitLines (char* Arg)
{
  PCHAR  p=Arg;
  PCHAR  st=Arg;
  int i={0};
  int IfFlag={0};
  int SpcolonFlag={0};
  int ParaCnt={0};
  if(*p==33||*p==36 ){
      return 0;
    }
  while(*p){
      if(*p==32 ){
          SpcolonFlag=1;
        }
      if(*p==c_DblQt ){
          while(*(++p)!=c_DblQt){
              if(*p==0 ){
                  return SplitCnt;
                }
            }
        }
      if(*p==c_LPar ){
          ParaCnt++;
        }
      if(*p==c_RPar ){
          ParaCnt--;
        }
      if(*p==58 ){
          if(*(p+1)==58 ){
              *p=15;
              *(p+1)=15;
            }
          else
            {
              if(NOTNULL((p+1))||ISTRUE(SpcolonFlag)){
                  while(*st==32){
                      st++;
                    }
                  SplitCnt++;
                  if(SplitCnt==cMaxSplitLines ){
                      Abort("Stack Overflow - Too many statements on one line");
                    }
                  while(st<p){
                      SplitStk[SplitCnt][i++]=*(st++);
                    }
                  strcpy(SplitStk[SplitCnt],trim(SplitStk[SplitCnt]));
                  SplitStk[SplitCnt][i]=0;
                  if(ParaCnt==0 ){
                      i=0;
                      st++;
                      ProcSingleLineIf(&(IfFlag));
                    }
                  else
                    {
                      SplitCnt--;
                    }
                }
            }
        }
      p++;
    }
  if(SplitCnt>0 ){
      while(*st==32){
          st++;
        }
      SplitCnt++;
      if(SplitCnt==cMaxSplitLines ){
          Abort("Stack Overflow - Too many statements on one line");
        }
      while(*st){
          SplitStk[SplitCnt][i++]=*(st++);
        }
      SplitStk[SplitCnt][i]=0;
      ProcSingleLineIf(&(IfFlag));
    }
  else
    {
      if(iMatchLft(Arg,"if ")&&!iMatchRgt(Arg," then")){
          Add2SplitLines(Arg);
          ProcSingleLineIf(&(IfFlag));
        }
    }
  if(IfFlag ){
      while(IfFlag){
          Add2SplitLines("END IF");
          IfFlag--;
        }
    }
  return SplitCnt;
}

int SpecialCaseHandler (char* Param)
{
  int i;
  int j;
  int k;
  int iSrcStkIndex;
  char lsz[BCXSTRSIZE];
  char Arg[BCXSTRSIZE];
  strcpy(Arg,Param);
  if(inchr(Param,"[")||inchr(Param,"]")){
        for(int BCX_REPEAT = 1; BCX_REPEAT <= 2; BCX_REPEAT++)
        {
          strcpy(Arg,replace(Arg,"[ ","["));
          strcpy(Arg,replace(Arg," [","["));
          strcpy(Arg,replace(Arg,"] ","]"));
          strcpy(Arg,replace(Arg," ]","]"));
        }
    }
  if(iMatchNQ(Arg," sub ")||iMatchNQ(Arg," function ")){
      return FALSE;
    }
  strcpy(lsz, join(3,SPC,extract(Arg,SPC),SPC));
  if(iMatchNQ(" dim , local , global , raw , static , shared , dynamic , auto , register , extern ",lsz)){
      FastLexer(Arg,SPC,",&(){}=");
      if(iMatchWrd("as",Stk[3])){
          strcpy(lsz, join(3,SPC,lcase(Stk[2]),SPC));
          if(iMatchNQ(" local , raw , static , shared , dynamic , auto , register ",lsz)){
              strcpy(Stk[1],Stk[2]);
              LShiftStk(2);
            }
        }
      if(iMatchWrd("as",Stk[2])){
          char szWrk[BCXSTRSIZE];
          int FirstComma;
          int Ignore;
          int b;
          int EqualAt;
          char Tmp[8][BCXSTRSIZE];
          int iFUNC={0};
          BuildDelimStr(1,Ndx,szWrk);
          FastLexer(szWrk,SPC,",&(){}=");
          for(i=3,Ignore=0,FirstComma=0,EqualAt=0; i<=Ndx && FirstComma==0; i++)
            {
              if(*Stk[i]==61&&Ignore==0 ){
                  EqualAt=i;
                }
              if(*Stk[i]==123 ){
                  Ignore++;
                }
              if(*Stk[i]==40 ){
                  Ignore++;
                  if(iFUNC==0 ){
                      iFUNC=i;
                    }
                }
              if(*Stk[i]==41 ){
                  Ignore--;
                }
              if(*Stk[i]==125 ){
                  Ignore--;
                }
              if(*Stk[i]==44&&Ignore==0 ){
                  FirstComma=i;
                }
            }
          if(FirstComma==0 ){
              FirstComma=Ndx+1;
            }
          if(iFUNC ){
              i=iFUNC;
            }
          if(i>EqualAt&&EqualAt ){
              i=EqualAt;
            }
          b=0;
          for(;;)
            {
              i--;
              if(*Stk[i]==125 ){
                  b++;
                }
              if(*Stk[i]==41 ){
                  b++;
                }
              if(*Stk[i]==40 ){
                  b--;
                }
              if(*Stk[i]==123 ){
                  b--;
                }
              if(!(b)){
                  goto L1302;
                }
            }
L1302:;
          if(*Stk[i]==61 ){
              i--;
            }
          if(*Stk[i]==40 ){
              i--;
            }
          if(*Stk[i]==123 ){
              i--;
            }
          if(*Stk[i]==44 ){
              i--;
            }
          int iVecCheck;
          for(j=0,k=2,iVecCheck=0; k<i; j++,k++)
            {
              if(inchr(Stk[k],chr(15))){
                  iVecCheck=1;
                }
              if(iVecCheck ){
                  strcpy(Stk[k],replace(Stk[k],"<",chr(16)));
                }
              if(iVecCheck ){
                  strcpy(Stk[k],replace(Stk[k],",",chr(18)));
                }
              if(iVecCheck ){
                  strcpy(Stk[k],replace(Stk[k],">",chr(17)));
                }
              strcpy(Tmp[j],Stk[k]);
              *Stk[k]=0;
            }
          k=Ndx;
          strcpy(Tmp[0], join(2,SPC,Tmp[0]));
          InsertTokens(Ndx,j,Tmp[0],Tmp[1],Tmp[2],Tmp[3],Tmp[4],Tmp[5],Tmp[6],Tmp[7]);
          Ignore=0;
          while(k>=FirstComma){
              if(*Stk[k]==125 ){
                  Ignore++;
                }
              if(*Stk[k]==41 ){
                  Ignore++;
                }
              if(*Stk[k]==40 ){
                  Ignore--;
                }
              if(*Stk[k]==123 ){
                  Ignore--;
                }
              if(*Stk[k]==44&&!Ignore ){
                  InsertTokens(k-1,j,Tmp[0],Tmp[1],Tmp[2],Tmp[3],Tmp[4],Tmp[5],Tmp[6],Tmp[7]);
                }
              k--;
            }
          RemEmptyTokens();
          BuildDelimStr(1,Ndx,Arg);
          if(InFunction==FALSE&&UseCpp==FALSE ){
              if(LeftStr(Arg,"RAW ",1)){
                  strcpy(Arg, join(2,"STATIC ",mid(Arg,4)));
                }
            }
          FastLexer(Arg,SPC,",(){}=");
        }
      else
        {
            {
            int  t;
            int  iVecCheck;
            for(i=1,t=1,iVecCheck=0; i<Ndx && t; i++)
              {
                t=GetAsPosF(i,Ndx);
                if(t ){
                    t++;
                    for(iVecCheck=0; t<=Ndx; t++)
                      {
                        if(*Stk[t]==44&&iVecCheck==0 ){
                            goto L1306;
                          }
                        if(inchr(Stk[t],chr(15))){
                            iVecCheck=1;
                          }
                        if(iVecCheck ){
                            strcpy(Stk[t],replace(Stk[t],"<",chr(16)));
                          }
                        if(iVecCheck ){
                            strcpy(Stk[t],replace(Stk[t],",",chr(18)));
                          }
                        if(iVecCheck ){
                            strcpy(Stk[t],replace(Stk[t],">",chr(17)));
                          }
                      }
L1306:;
                  }
              }
              }
        }
        {
        int  t;
        for(i=1,t=1; i<Ndx && t; i++)
          {
            t=GetAsPosF(i,Ndx);
            if(t ){
                i=t;
                strcpy(Stk[i-1],Clean(Stk[i-1]));
              }
          }
          }
      strcpy(Stk[2], join(3,SPC,Stk[2],SPC));
      if(iMatchNQ(" raw , local , dynamic , register , static , shared , auto ",Stk[2])){
          strcpy(Stk[1], join(2,Stk[1],Stk[2]));
          *Stk[2]=0;
        }
      SrcCnt++;
      j=0;
      for(i=1; i<=Ndx; i++)
        {
          if(*Stk[i]==40 ){
              j++;
            }
          if(*Stk[i]==123 ){
              j++;
            }
          if(*Stk[i]==41 ){
              j--;
            }
          if(*Stk[i]==125 ){
              j--;
            }
          if(*Stk[i]==44&&!j ){
              strcpy(Stk[i],Stk[1]);
              SrcCnt++;
            }
          if(SrcCnt==cMaxSingleLineIFLines ){
              Abort("Single line conversion to multi-line exceeds limit.");
            }
          strcpy(SrcStk[SrcCnt], join(3,SrcStk[SrcCnt],Stk[i],SPC));
        }
      goto PROCESSNEW;
    }
  if(InDialogEvt||ModDialogEvt ){
      if(iMatchNQ(Arg,"WM_INITDIALOG")){
          AddExpressionToStack(Arg);
          AddExpressionToStack("SetDialogScale(hWnd,0)");
          goto PROCESSNEW;
        }
    }
  if(TRUE==iMatchLft(Arg,"on ")){
      int Target=0;
      j=0;
      FastLexer(Arg,SPC,",");
      for(i=1; i<=Ndx; i++)
        {
          if(iMatchLft(Stk[i],"gosub")||iMatchLft(Stk[i],"goto")||iMatchLft(Stk[i],"call")){
              Target=i+1;
              goto L1310;
            }
        }
L1310:;
      if(Target==0 ){
          Abort("Malformed ON/GOSUB,GOTO,CALL.");
        }
      AddExpressionToStack("select case ");
      for(i=2; i<=Target-2; i++)
        {
          strcpy(SrcStk[SrcCnt], join(3,SrcStk[SrcCnt],SPC,Stk[i]));
        }
      for(i=Target; i<=Ndx; i++)
        {
          if(*Stk[i]==44 ){
              continue;
            }
          j++;
          AddExpressionToStack(join(2,"case",str(j)));
          AddExpressionToStack(join(3,Stk[Target-1],SPC,Stk[i]));
        }
      AddExpressionToStack("end select");
      goto PROCESSNEW;
    }
  if(TRUE==iMatchLft(Arg,"loop ")){
      FastLexer(Arg,SPC,",()");
      if(iMatchLft(Stk[2],"until")){
          AddExpressionToStack("if ");
          for(i=3; i<=Ndx; i++)
            {
              strcpy(SrcStk[SrcCnt], join(3,SrcStk[SrcCnt],Stk[i],SPC));
            }
          strcpy(SrcStk[SrcCnt], join(2,SrcStk[SrcCnt]," then"));
          AddExpressionToStack("exit do");
          AddExpressionToStack("end if");
          AddExpressionToStack("loop");
          iLoopCond=1;
          goto PROCESSNEW;
        }
      else if(iMatchLft(Stk[2],"while")){
          AddExpressionToStack("if NOT (");
          for(i=3; i<=Ndx; i++)
            {
              strcpy(SrcStk[SrcCnt], join(3,SrcStk[SrcCnt],Stk[i],SPC));
            }
          strcpy(SrcStk[SrcCnt], join(2,SrcStk[SrcCnt],") then"));
          AddExpressionToStack("exit do");
          AddExpressionToStack("end if");
          AddExpressionToStack("loop");
          iLoopCond=1;
          goto PROCESSNEW;
        }
      else
        {
          if(Ndx>1 ){
              Abort(join(3,"UNKNOWN Word ",Stk[2]," After LOOP"));
            }
        }
      goto L1309;
    }
  if(TRUE==iMatchLft(Arg,"do ")){
      FastLexer(Arg,SPC,",()");
      if(iMatchLft(Stk[2],"until")){
          AddExpressionToStack("do");
          AddExpressionToStack("if ");
          for(i=3; i<=Ndx; i++)
            {
              strcpy(SrcStk[SrcCnt], join(3,SrcStk[SrcCnt],Stk[i],SPC));
            }
          strcpy(SrcStk[SrcCnt], join(2,SrcStk[SrcCnt],"then"));
          AddExpressionToStack("exit do");
          AddExpressionToStack("end if");
          iDoWhile=lt_DOUNTILLOOP;
          goto PROCESSNEW;
        }
      else if(iMatchLft(Stk[2],"while")){
          AddExpressionToStack("while ");
          iDoWhile=lt_DOWHILELOOP;
          for(i=3; i<=Ndx; i++)
            {
              strcpy(SrcStk[SrcCnt], join(3,SrcStk[SrcCnt],Stk[i],SPC));
            }
          goto PROCESSNEW;
        }
      else
        {
          if(Ndx>1 ){
              Abort(join(3,"UNKNOWN Word ",Stk[2]," After DO"));
            }
        }
    }
L1309:;
  return FALSE;

PROCESSNEW:;
  Ndx=iSrcStkIndex=0;
  while(SrcCnt){
      strcpy(Arg,SrcStk[++iSrcStkIndex]);
      *SrcStk[iSrcStkIndex]=0;
      SrcCnt--;
      PassOne=TRUE;
      XParse(Arg);
      PassOne=FALSE;
      FixUps();
      if(Ndx ){
          Emit_Main();
        }
    }
  return TRUE;
}

void FastLexer (LPCTSTR  Arg,LPCTSTR  delim1,LPCTSTR  delim2,int TokQuote)
{
  PCHAR  pd1;
  PCHAR  pd2;
  int cnt1;
  int cnt2;
  cnt1=cnt2=0;
  Ndx=1;
  while(Arg[cnt1]){
      if(Arg[cnt1]==c_DblQt ){
          if(cnt2&&TokQuote ){
              Stk[Ndx++][cnt2]=0;
              cnt2=0;
            }
          Stk[Ndx][cnt2]=c_DblQt;
          while(Arg[++cnt1]!=c_DblQt){
              Stk[Ndx][++cnt2]=Arg[cnt1];
              if(Arg[cnt1]==0 ){
                  return;
                }
            }
          Stk[Ndx][++cnt2]=Arg[cnt1];
          if(TokQuote ){
              Stk[Ndx++][++cnt2]=0;
              cnt2=0;
              goto AGAIN;
            }
        }
      pd1= CAST (PCHAR,delim1);
      while(*pd1){
          if(*(pd1++)==Arg[cnt1] ){
              if(cnt2 ){
                  Stk[Ndx++][cnt2]=0;
                  cnt2=0;
                }
              goto AGAIN;
            }
        }
      pd2= CAST (PCHAR,delim2);
      while(*pd2){
          if(*(pd2++)==Arg[cnt1] ){
              if(cnt2 ){
                  Stk[Ndx++][cnt2]=0;
                }
              Stk[Ndx][0]=Arg[cnt1];
              Stk[Ndx++][1]=0;
              cnt2=0;
              goto AGAIN;
            }
        }
      Stk[Ndx][cnt2++]=Arg[cnt1];

AGAIN:;
      cnt1++;
    }
  Stk[Ndx][cnt2]=0;
  if(cnt2==0 ){
      Ndx--;
    }
}

void InsertTokens (int PosAfter,int NumTokens,...)
{
  va_list  ap;
  int i;
  for(i=Ndx; i>=PosAfter+1; i+=-1)
    {
      strcpy(Stk[i+NumTokens],Stk[i]);
    }
  va_start(ap,NumTokens);
  for(i=PosAfter+1; i<=PosAfter+NumTokens; i++)
    {
      strcpy(Stk[i],va_arg(ap,char*));
    }
  va_end(ap);
  Ndx+=(NumTokens);
  *Stk[Ndx+1]=0;
}

void AppendTokens (int NumTokens,...)
{
  va_list  ap;
  va_start(ap,NumTokens);
  for(int i=Ndx+1; i<=Ndx+NumTokens; i++)
    {
      strcpy(Stk[i],va_arg(ap,char*));
    }
  va_end(ap);
  Ndx+=(NumTokens);
  *Stk[Ndx+1]=0;
}

void Emit_ExportDef (char* fs)
{
  static int BeenHere;
  static char fname[BCXSTRSIZE];
  static char Private_FunctionName[BCXSTRSIZE];
  int i;
  int st=1;
  int sz=0;
  strcpy(fname, join(2,extract(FileIn,"."),".def"));
  if(!BeenHere ){
      if((FPDEF=fopen(fname, "w"))==0)
       {
      fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", fname); exit(1);
       }
       _splitpath(FileIn,NULL,NULL,fname,NULL);
      fprintf(FPDEF,"%s%s\n","LIBRARY ",enc(fname));
      fprintf(FPDEF,"%s\n","EXPORTS");
      BeenHere=TRUE;
    }
  FastLexer(fs,"","(,)");
  while(*Stk[st]!=40){
      st++;
    }
  for(i=st+1; i<=Ndx; i++)
    {
      if(*Stk[i]==41 ){
          goto L1326;
        }
      if(*Stk[i]!=44 ){
          if(inchr(Stk[i],"*")){
              sz+=(4);
              continue;
            }
          if(iMatchNQ(Stk[i],"longlong")||iMatchNQ(Stk[i],"double")||iMatchNQ(Stk[i],"long long")){
              sz+=(8);
              continue;
            }
          if(!inchr(Stk[i],"void")){
              sz+=(4);
            }
        }
    }
L1326:;
  strcpy(Stk[1],trim(Stk[1]));
  strcpy(Private_FunctionName,mid(Stk[1],InstrRev(Stk[1],SPC)+1));
  fprintf(FPDEF,"%s%s%s%s%s\n",Private_FunctionName," = _",Private_FunctionName,"@",ltrim(str(sz)));
}

char * GetArg (int ArgNum,FUNCPARSE*  fp)
{
  char   *BCX_RetStr={0};
   char RetArg[BCXSTRSIZE];  strcpy(RetArg,"");
  int ArgEnd=fp->CommaPos[ArgNum]-1;
  int ArgStart=fp->CommaPos[ArgNum-1]+1;
  if(ArgNum>=fp->NumArgs ){
      ArgEnd=Ndx;
    }
  for(int i=ArgStart; i<=ArgEnd; i++)
    {
      strcat(RetArg,Stk[i]);
    }
  BCX_RetStr = BCX_TempStr(strlen(RetArg));
  strcpy(BCX_RetStr,RetArg);
  return BCX_RetStr;
}

int SepFuncArgs (int Strt,FUNCPARSE*  fp,int functionflag)
{
  int CountR=0;
  int i=Strt;
  if(functionflag ){
      while(i<=Ndx){
          if(*Stk[i]==40 ){
              goto L1328;
            }
          i++;
        }
L1328:;
      Strt=i+1;
      fp->NumArgs=0;
      fp->CommaPos[0]=i;
      if(Strt>Ndx ){
          return 0;
        }
    }
  else
    {
      Strt=2;
      fp->CommaPos[0]=1;
    }
  if(*Stk[Strt]==41 ){
      fp->CommaPos[1]=Strt;
      return 0;
    }
  fp->NumArgs=1;
  for(i=Strt; i<=Ndx; i++)
    {
      if(*Stk[i]==40||*Stk[i]==91 ){
          CountR++;
        }
      else if(*Stk[i]==41||*Stk[i]==93 ){
          if(CountR==0 ){
              fp->CommaPos[fp->NumArgs]=i;
              goto L1329;
            }
          CountR--;
        }
      else if(*Stk[i]==44&&CountR==0 ){
          fp->CommaPos[fp->NumArgs]=i;
          fp->NumArgs++;
          if(fp->NumArgs==cCommaPos ){
              Abort("Number of arguments exceeds 127");
            }
        }
    }
L1329:;
  if(functionflag==0 ){
      fp->CommaPos[fp->NumArgs]=Ndx;
    }
  return fp->NumArgs;
}

PSTR MakeDecProto (FUNCPARSE*  fp,int iStart,int iEnd,int iNoTypeDef)
{
  int OptFlag={0};
  int pointer={0};
  static char Proto[BCXSTRSIZE];
  static int SubFunPtr;
  static char FunType[BCXSTRSIZE];
  int i;
  int ii;
  char AsType[BCXSTRSIZE];
  char OptValue[BCXSTRSIZE];
  char AsArrys[BCXSTRSIZE];
  int FoundAs;
  struct _FUNCPARSE  fpp;
  Clear(fpp);
  if(SubFunPtr ){
      goto ARGPARSE;
    }
  *Proto=0;
  *FunType=0;
  if(Ctor_Dtor_Detected(1)){
      *FunType=0;
    }
  else
    {
      if(iMatchWrd(Stk[iStart],"sub")){
          strcpy(FunType,"void");
        }
      else if(*Stk[iEnd]==41 ){
          strcpy(FunType,VarTypeLookup[inchr(VARTYPES,right(Stk[iStart+1],1))]);
        }
      else
        {
          for(i=iEnd; i>=fp->CommaPos[fp->NumArgs]+1; i+=-1)
            {
              if(iMatchWrd(Stk[i],"ptr")||*Stk[i]==42 ){
                  pointer++;
                }
              else if(iMatchWrd(Stk[i],"as")){
                  goto L1330;
                }
              else
                {
                  if(*Stk[i]!=0 ){
                      strcpy(FunType, join(3,Stk[i],SPC,FunType));
                    }
                }
            }
L1330:;
          strcpy(FunType,trim(FunType));
        }
    }
  if(ISNULL(FunType)){
      strcpy(Proto, join(2,Stk[iStart],"("));
    }
  else
    {
      if(InTypeDef ){
          char L_Var[BCXSTRSIZE];
          int w;
          int id;
          int vt;
          strcpy(Proto, join(4,FunType,space(2),stringx(pointer,42)," ("));
          strcpy(Proto, join(5,Proto,CallType,"*",Clean(Stk[iStart+1]),")("));
          strcpy(L_Var, join(2,FunType,stringx(pointer,42)));
          GetTypeInfo(L_Var,&(w),&(id),&(vt));
          AddTypedefElement(BaseTypeDefsCnt[InTypeDef],vt,Clean(Stk[iStart+1]),FunType);
        }
      else if(SFPOINTER ){
          if(iNoTypeDef ){
              strcpy(Proto, join(6,FunType," (",CallType,"*",Clean(Stk[iStart+1]),")("));
            }
          else
            {
              strcpy(Proto, join(4,"typedef ",FunType," (",CallType));
              strcpy(Proto, join(4,Proto,"*",Clean(Stk[iStart+1]),"_TYPE)("));
            }
        }
      else if(!NoTypeDeclare&&!InClass&&!InCppTypeDef ){
          strcpy(Proto, join(4,"typedef ",FunType," (",CallType));
          strcpy(Proto, join(4,Proto,"*BCXFPROT",ltrim(str(DllCnt)),")("));
        }
      else
        {
          if(UseCProto||InClass||InCppTypeDef ){
              UseCProto=FALSE;
              strcpy(Proto, join(4,FunType,SPC,stringx(pointer,42),SPC));
              strcpy(Proto, join(4,Proto,CallType,Clean(Stk[iStart+1]),"("));
            }
          else
            {
              strcpy(Proto, join(4,"C_IMPORT ",FunType,space(2),stringx(pointer,42)));
              strcpy(Proto, join(5,Proto,SPC,CallType,Clean(Stk[iStart+1]),"("));
              UseImportExport=TRUE;
            }
        }
    }

ARGPARSE:;
  if(fp->NumArgs==0 ){
      if(FunType[0]!=0 ){
          strcat(Proto,"void)");
        }
      else
        {
          strcat(Proto,")");
        }
    }
  else
    {
      for(ii=0; ii<=fp->NumArgs-1; ii++)
        {
          *OptValue=0;
          *AsType=0;
          *AsArrys=0;
          pointer=0;
          FoundAs=0;
          int FirstToken=fp->CommaPos[ii]+1;
          int LastToken=fp->CommaPos[ii+1]-1;
          int NumOfTokens=(LastToken-FirstToken)+1;
          i=inchr(Stk[FirstToken],"[");
          if(i ){
              strcpy(AsArrys,mid(Stk[FirstToken],i));
              Stk[FirstToken][i-1]=0;
            }
          if(NumOfTokens==1 ){
              strcpy(AsType,VarTypeLookup[inchr(VARTYPES,right(Stk[FirstToken],1))]);
              if(*AsArrys ){
                  strcpy(AsType,RemoveStr(AsType,"*"));
                }
              else
                {
                  pointer=tally(Stk[FirstToken],"*");
                }
              FoundAs=TRUE;
            }
          else
            {
              for(i=LastToken; i>=FirstToken; i+=-1)
                {
                  if(iMatchWrd(Stk[i],"ptr")||*Stk[i]==42 ){
                      pointer++;
                    }
                  else if(iMatchWrd(Stk[i],"sub")){
                      SepFuncArgs(fp->CommaPos[ii]+2,&(fpp),TRUE);
                      strcat(Proto,"void (*)(");
                      SubFunPtr=FoundAs=TRUE;
                      MakeDecProto(&(fpp));
                      SubFunPtr=FALSE;
                      goto L1332;
                    }
                  else if(iMatchWrd(Stk[i],"function")){
                      SepFuncArgs(fp->CommaPos[ii]+2,&(fpp),TRUE);
                      if(ISNULL(AsType)){
                          strcpy(AsType,VarTypeLookup[inchr(VARTYPES,right(Stk[FirstToken],1))]);
                        }
                      strcpy(Proto, join(4,Proto,rtrim(AsType),stringx(pointer,42)," (*)("));
                      pointer=0;
                      *AsType=0;
                      SubFunPtr=FoundAs=TRUE;
                      MakeDecProto(&(fpp));
                      SubFunPtr=FALSE;
                      goto L1332;
                    }
                  else if(iMatchWrd(Stk[i],"as")){
                      if(ISNULL(AsType)){
                          Abort(join(2,"No type specified for argument",str(ii+1)));
                        }
                      FoundAs=TRUE;
                      goto L1332;
                    }
                  else if(*Stk[i]==61 ){
                      OptFlag=FoundAs=TRUE;
                      strcpy(OptValue, join(2," =",AsType));
                      *AsType=0;
                      if(i==FirstToken+1 ){
                          strcpy(AsType,VarTypeLookup[inchr(VARTYPES,right(Stk[FirstToken],1))]);
                          if(*AsArrys ){
                              strcpy(AsType,RemoveStr(AsType,"*"));
                            }
                          else
                            {
                              pointer=tally(Stk[FirstToken],"*");
                            }
                          goto L1332;
                        }
                    }
                  else
                    {
                      if(*Stk[i]!=46 ){
                          strcpy(AsType, join(3,Stk[i],SPC,AsType));
                        }
                      else
                        {
                          if(*Stk[i-1]==46 ){
                              if(OptFlag ){
                                  Abort("Default value not allowed when using variable arguments");
                                }
                              if(ii!=(fp->NumArgs-1)){
                                  Abort("Variable argument must be the last parameter");
                                }
                              if(fp->NumArgs==1 ){
                                  Abort("Variable argument must be preceded by at least one other parameter");
                                }
                              FoundAs=TRUE;
                            }
                          strcpy(AsType, join(2,Stk[i],AsType));
                        }
                    }
                }
L1332:;
            }
          if(!FoundAs ){
              Abort(join(2,"Malformed argument type in parameter",str(ii+1)));
            }
          if(ii!=fp->NumArgs&&OptFlag&&ISNULL(OptValue)){
              Warning(join(2,"No default value specified for parameter",str(ii+1)),1);
            }
          strcpy(Proto, join(6,Proto,rtrim(AsType),AsArrys,stringx(pointer,42),OptValue,Stk[fp->CommaPos[ii+1]]));
        }
    }
  return Proto;
}

void AsmUnknownStructs (int CompArrays)
{
  int InBrace={0};
  int InStruct={0};
  int i={0};
  char LTmp[BCXSTRSIZE]={0};
  for(i=2; i<=Ndx; i++)
    {
      if(CompArrays ){
          if(*Stk[i]==91 ){
              strcpy(LTmp,Stk[i-1]);
              *Stk[i-1]=0;
              for(;;)
                {
                  strcat(LTmp,Stk[i]);
                  if(*Stk[i]==93 ){
                      InBrace--;
                    }
                  if(*Stk[i]==91 ){
                      InBrace++;
                    }
                  *Stk[i]=0;
                  i++;
                  if(!(InBrace>0&&i<=Ndx)){
                      goto L1334;
                    }
                }
L1334:;
              strcpy(Stk[--i],LTmp);
            }
        }
      if((int)strlen(Stk[i])>1&&!IsDecimalNumber(Stk[i]+1)){
          if(*Stk[i]==46||iMatchLft(Stk[i],"->")){
              if(InStruct==0 ){
                  strcpy(Stk[i], join(2,Stk[i-1],Stk[i]));
                  *Stk[i-1]=0;
                  InStruct=i;
                }
              else
                {
                  strcpy(Stk[InStruct], join(2,Stk[InStruct],Stk[i]));
                  *Stk[i]=0;
                }
              continue;
            }
        }
      if(NOTNULL(Stk[i])&&InStruct ){
          InStruct=0;
        }
    }
  RemEmptyTokens();
}

void CheckForASC ()
{
  int Tmp;
  int iEmp;
  iEmp=0;
  for(Tmp=1; Tmp<=Ndx; Tmp++)
    {
      if(iMatchWrd(Stk[Tmp],"asc")){
          iEmp=1;
          Process_ASC_Function(Tmp);
        }
    }
  if(iEmp ){
      RemEmptyTokens();
    }
}

void Make_Stricmp_Map ()
{
  int MSM_Ndx;
  int i;
  MSM_Ndx=0;
  for(i=0; i<=127; i++)
    {
      MSMap[i]=0;
    }
  for(i=2; i<=Ndx; i++)
    {
      if(RightStr(Stk[i],"$")==FALSE ){
          if(Im_Multi_Dim_StrVar(Stk[i])){
              strcpy(Stk[i], join(2,Stk[i],"$"));
            }
        }
    }
  char szExamine[BCXSTRSIZE]={0};
  for(i=2; i<=Ndx; i++)
    {
      strcpy(szExamine, join(3,szExamine,SPC,Stk[i]));
    }
  for(i=2; i<=Ndx; i++)
    {
      if(Im_Single_Dim_StrVar(Stk[i])&&tally(szExamine,"[")>0 ){
          strcpy(Stk[i],RemoveStr(Stk[i],"$"));
        }
    }
  for(i=1; i<=Ndx; i++)
    {
      if((*Stk[i]==63&&*Stk[i+1]==63&&*Stk[i+2]==61)||(*Stk[i]==61&&*Stk[i+1]==63&&*Stk[i+2]==63)||(*Stk[i]==63&&*Stk[i+1]==61&&*Stk[i+2]==63)){
          Abort("Combining string operators '?' and '=' is ambiguous");
        }
    }
  for(i=1; i<=Ndx; i++)
    {
      if(*Stk[i]==61&&*Stk[i+1]==61 ){
          strcpy(Stk[i],"==");
          LShiftStk(i+1);
        }
    }
  for(i=1; i<=Ndx; i++)
    {
      if(*Stk[i]==63&&*Stk[i+1]==63 ){
          strcpy(Stk[i],"??");
          LShiftStk(i+1);
        }
    }
  for(i=1; i<=Ndx; i++)
    {
      if((*Stk[i]==60 && strcmp(Stk[i+1],"??")==0  && *Stk[i+2]==62)||(*Stk[i]==60&&*Stk[i+1]==62 && strcmp(Stk[i+2],"??")==0)  || (*Stk[i]==62 && strcmp(Stk[i+1],"??")==0  && *Stk[i+2]==60)){
          strcpy(Stk[i],"!??");
          LShiftStk(i+1);
          LShiftStk(i+1);
        }
    }
  for(i=1; i<=Ndx; i++)
    {
      if((*Stk[i]==33 && strcmp(Stk[i+1],"??")==0)  || (strcmp(Stk[i],"??")==0  && *Stk[i+1]==33)){
          strcpy(Stk[i],"!??");
          LShiftStk(i+1);
        }
    }
  for(i=1; i<=Ndx; i++)
    {
      if((strcmp(Stk[i],"??")==0  && *Stk[i+1]==62)||(*Stk[i]==62 && strcmp(Stk[i+1],"??")==0)){
          strcpy(Stk[i],">??");
          LShiftStk(i+1);
        }
    }
  for(i=1; i<=Ndx; i++)
    {
      if((strcmp(Stk[i],"??")==0  && *Stk[i+1]==60)||(*Stk[i]==60 && strcmp(Stk[i+1],"??")==0)){
          strcpy(Stk[i],"<??");
          LShiftStk(i+1);
        }
    }
  for(i=1; i<=Ndx; i++)
    {
      if((*Stk[i]==60&&*Stk[i+1]==61)||(*Stk[i]==61&&*Stk[i+1]==60)){
          strcpy(Stk[i],"<=");
          LShiftStk(i+1);
        }
    }
  for(i=1; i<=Ndx; i++)
    {
      if((*Stk[i]==62&&*Stk[i+1]==61)||(*Stk[i]==61&&*Stk[i+1]==62)){
          strcpy(Stk[i],">=");
          LShiftStk(i+1);
        }
    }
  for(i=1; i<=Ndx; i++)
    {
      if((*Stk[i]==33&&*Stk[i+1]==61)){
          strcpy(Stk[i],"!=");
          LShiftStk(i+1);
        }
    }
  for(i=1; i<=Ndx; i++)
    {
      if(strcmp(Stk[i],"??")==0){
          strcpy(Stk[i],"=");
          MSMap[++MSM_Ndx]=1;
          goto L1351;
        }
      if(strcmp(Stk[i],"<??")==0){
          strcpy(Stk[i],"<");
          MSMap[++MSM_Ndx]=1;
          goto L1351;
        }
      if(strcmp(Stk[i],">??")==0){
          strcpy(Stk[i],">");
          MSMap[++MSM_Ndx]=1;
          goto L1351;
        }
      if(strcmp(Stk[i],"!??")==0){
          strcpy(Stk[i],"!=");
          MSMap[++MSM_Ndx]=1;
          goto L1351;
        }
      if(strcmp(Stk[i],"=")==0  || strcmp(Stk[i],"<")==0  || strcmp(Stk[i],">")==0  || strcmp(Stk[i],"<=")==0  || strcmp(Stk[i],">=")==0  || strcmp(Stk[i],"!=")==0  || strcmp(Stk[i],"!")==0){
          MSMap[++MSM_Ndx]=2;
        }
L1351:;
    }
}

int Im_A_String_Var (char* A)
{
  int idx;
  if(CheckLocal(A,&(idx))==vt_SCHAR ){
      return TRUE;
    }
  if(CheckLocal(A,&(idx))==vt_CHAR ){
      return TRUE;
    }
  if(CheckGlobal(A,&(idx))==vt_CHAR ){
      return TRUE;
    }
  if(CheckGlobal(A,&(idx))==vt_SCHAR ){
      return TRUE;
    }
  if(CheckLocal(A,&(idx))==vt_STRVAR ){
      return TRUE;
    }
  if(CheckGlobal(A,&(idx))==vt_STRVAR ){
      return TRUE;
    }
  return FALSE;
}

void Emit_IfCond (char* CondType,int iOutputMethod,LPCTSTR  ArgOut)
{
  int IsWhile={0};
  int A;
  int B;
  int TestString;
  int ParCnt;
  int Tmp;
  char szTest[BCXSTRSIZE];
  char szOut[BCXSTRSIZE];
  if(Im_A_String_Var(Stk[2])){
      int ii={0};
      if(*Stk[3]!=91 ){
          ii=TRUE;
        }
      if(ii==TRUE&&inchr(Stk[2],"$")==FALSE ){
          strcpy(Stk[2], join(2,Stk[2],"$"));
        }
    }
  strcpy(szOut,ArgOut);
  CheckForASC();
  if(iOutputMethod==eStringPart||iOutputMethod==eStringFull ){
      *szOut=0;
    }
  TestString=DataType(Stk[2]);
  if(TestString==vt_STRVAR||TestString==vt_CHAR||TestString==vt_SCHAR ){
      if(strcmp(Stk[4],DDQ)==0){
          strcpy(Stk[2], join(2,Clean(Stk[2]),"[0]"));
          strcpy(Stk[4],"0");
        }
      else
        {
          if(strcmp(Stk[3],"[")==0  && strcmp(Stk[7],DDQ)==0){
              strcpy(Stk[2], join(2,"*",Clean(Stk[2])));
              strcpy(Stk[7],"0");
            }
        }
    }
  if(strcmp(CondType,"while")==0){
      IsWhile=TRUE;
    }
  *IF_Stmt_Buffer=0;
  Make_Stricmp_Map();
  if(iOutputMethod==eFull ){
      strcpy(IF_Stmt_Buffer, join(3,Scoot,CondType,"("));
    }
  if(iOutputMethod==eStringFull ){
      strcpy(szOut, join(2,CondType,"("));
    }
  Tmp=2;
  while(strcmp(Stk[Tmp],"(")==0  || strcmp(Stk[Tmp],"!")==0){
      if(iOutputMethod==ePart||iOutputMethod==eFull ){
          strcat(IF_Stmt_Buffer,Stk[Tmp]);
        }
      else
        {
          strcat(szOut,Stk[Tmp]);
        }
      Tmp++;
    }
  TestString=FALSE;
  A=DataType(Stk[Tmp]);
  if(A==vt_STRLIT||A==vt_STRVAR ){
      if(strcmp(Stk[Tmp+1],")")!=0  && ISFALSE(iMatchWrd(Stk[Tmp+1],"then"))){
          TestString=TRUE;
          if(iOutputMethod==ePart||iOutputMethod==eFull ){
              strcat(IF_Stmt_Buffer,"strcmp(");
            }
          else
            {
              strcat(szOut,Stk[Tmp]);
            }
        }
    }
  *szTest=0;
  ParCnt=0;
  for(;;)
    {
      if(TestString ){
          if(strcmp(Stk[Tmp],"=")==0){
              strcpy(Stk[Tmp],",");
              strcpy(szTest,")==0");
              ParCnt=0;
              goto L1354;
            }
          if(strcmp(Stk[Tmp],"!=")==0){
              strcpy(Stk[Tmp],",");
              strcpy(szTest,")!=0");
              ParCnt=0;
              goto L1354;
            }
          if(strcmp(Stk[Tmp],">")==0){
              if(strcmp(Stk[Tmp+1],"=")==0){
                  strcpy(Stk[Tmp],",");
                  strcpy(szTest,")>=0");
                  *Stk[Tmp+1]=0;
                }
              else
                {
                  strcpy(Stk[Tmp],",");
                  strcpy(szTest,")==1");
                }
              ParCnt=0;
              goto L1354;
            }
          if(strcmp(Stk[Tmp],"<")==0){
              if(strcmp(Stk[Tmp+1],"=")==0){
                  strcpy(Stk[Tmp],",");
                  strcpy(szTest,")<=0");
                  *Stk[Tmp+1]=0;
                }
              else
                {
                  strcpy(Stk[Tmp],",");
                  strcpy(szTest,")==-1");
                }
              ParCnt=0;
              goto L1354;
            }
          if(strcmp(Stk[Tmp],">=")==0){
              strcpy(Stk[Tmp],",");
              strcpy(szTest,")>=0");
              ParCnt=0;
              goto L1354;
            }
          if(strcmp(Stk[Tmp],"<=")==0){
              strcpy(Stk[Tmp],",");
              strcpy(szTest,")<=0");
              ParCnt=0;
              goto L1354;
            }
          if(strcmp(Stk[Tmp],"(")==0){
              ParCnt++;
              goto L1354;
            }
          if(strcmp(Stk[Tmp],")")==0){
              ParCnt--;
            }
L1354:;
          if(strcmp(Stk[Tmp],")")==0  && strcmp(szTest,"")!=0  && ParCnt<0 ){
              if(iOutputMethod==ePart||iOutputMethod==eFull ){
                  strcpy(IF_Stmt_Buffer, join(3,IF_Stmt_Buffer,szTest,Stk[Tmp]));
                }
              else
                {
                  strcat(szOut,szTest);
                  strcat(szOut,Stk[Tmp]);
                }
              *szTest=0;
            }
          else
            {
              if(strcmp(Stk[Tmp],"||")==0  || strcmp(Stk[Tmp],"&&")==0){
                  strcpy(Stk[Tmp], join(4,szTest,SPC,Stk[Tmp],SPC));
                  *szTest=0;
                  B=1;
                  while(strcmp(Stk[Tmp+B],"(")==0){
                      strcpy(Stk[Tmp], join(2,Stk[Tmp],"("));
                      *Stk[Tmp+B]=0;
                      B++;
                    }
                  A=DataType(Stk[Tmp+B]);
                  if((A==vt_STRLIT||A==vt_STRVAR) && strcmp(Stk[Tmp+B+1],")")!=0){
                      strcpy(Stk[Tmp], join(2,Stk[Tmp]," strcmp("));
                    }
                  else
                    {
                      if(iOutputMethod==ePart||iOutputMethod==eFull ){
                          strcat(IF_Stmt_Buffer,Clean(Stk[Tmp]));
                        }
                      else
                        {
                          strcat(szOut,Clean(Stk[Tmp]));
                        }
                      TestString=FALSE;
                      goto NXTTOKEN;
                    }
                }
              if(iOutputMethod==ePart||iOutputMethod==eFull ){
                  strcat(IF_Stmt_Buffer,Clean(Stk[Tmp]));
                }
              else
                {
                  strcat(szOut,Clean(Stk[Tmp]));
                }
            }
        }
      else
        {
          if(strcmp(Stk[Tmp],"||")==0  || strcmp(Stk[Tmp],"&&")==0){
              B=1;
              while(strcmp(Stk[Tmp+B],"(")==0){
                  strcpy(Stk[Tmp], join(2,Stk[Tmp],"("));
                  *Stk[Tmp+B]=0;
                  B++;
                }
              A=DataType(Stk[Tmp+B]);
              if((A==vt_STRLIT||A==vt_STRVAR) && strcmp(Stk[Tmp+B+1],")")!=0){
                  strcpy(Stk[Tmp], join(2,Stk[Tmp]," strcmp("));
                  TestString=TRUE;
                  *szTest=0;
                  ParCnt=0;
                  if(iOutputMethod==ePart||iOutputMethod==eFull ){
                      strcat(IF_Stmt_Buffer,Clean(Stk[Tmp]));
                    }
                  else
                    {
                      strcat(szOut,Clean(Stk[Tmp]));
                    }
                  goto NXTTOKEN;
                }
            }
          if(strcmp(Stk[Tmp],"!")==0){
              if(iOutputMethod==ePart||iOutputMethod==eFull ){
                  strcat(IF_Stmt_Buffer,Stk[Tmp]);
                }
              else
                {
                  strcat(szOut,Stk[Tmp]);
                }
            }
          else
            {
              if(iOutputMethod==ePart||iOutputMethod==eFull ){
                  strcat(IF_Stmt_Buffer,Clean(Stk[Tmp]));
                }
              else
                {
                  strcat(szOut,Clean(Stk[Tmp]));
                }
              if(!ispunct(*Stk[Tmp])){
                  if(Tmp<Ndx&&!ispunct(*Stk[Tmp+1])){
                      if(iOutputMethod==ePart||iOutputMethod==eFull ){
                          strcat(IF_Stmt_Buffer,SPC);
                        }
                      else
                        {
                          strcat(szOut,SPC);
                        }
                    }
                }
            }
          if(strcmp(Stk[Tmp],"=")==0){
              if(strcmp(Stk[Tmp-1],"<")!=0  && strcmp(Stk[Tmp-1],">")!=0){
                  if(strcmp(Stk[Tmp+1],">")!=0  && strcmp(Stk[Tmp+1],"<")!=0){
                      if(iOutputMethod==ePart||iOutputMethod==eFull ){
                          strcat(IF_Stmt_Buffer,"=");
                        }
                      else
                        {
                          strcat(szOut,"=");
                        }
                    }
                }
            }
        }

NXTTOKEN:;
      Tmp++;
      if(!IsWhile ){
          if(iMatchWrd(Stk[Tmp],"then")){
              goto L1353;
            }
          else if(Tmp>Ndx ){
              Abort("If Without THEN");
            }
        }
      if(Tmp>Ndx ){
          goto L1353;
        }
    }
L1353:;
  if(iOutputMethod==eFull ){
      strcpy(IF_Stmt_Buffer, join(3,IF_Stmt_Buffer,szTest,")"));
      BumpUp();
      strcat(IF_Stmt_Buffer,"{");
      BumpUp();
      goto L1357;
    }
  if(iOutputMethod==ePart ){
      strcat(IF_Stmt_Buffer,szTest);
      goto L1357;
    }
  if(iOutputMethod==eStringPart ){
      strcat(szOut,szTest);
      goto L1357;
    }
  if(iOutputMethod==eStringFull ){
      strcat(szOut,szTest);
      strcat(szOut,")");
    }
L1357:;
  FastLexer(IF_Stmt_Buffer,""," =&()[]{}',+-*/<>?;.|:^");
  for(int ii=1; ii<=Ndx; ii++)
    {
      if(*Stk[ii]==61&&*Stk[ii+1]==61 ){
          strcpy(Stk[ii],"==");
          LShiftStk(ii+1);
        }
    }
  for(int ii=1; ii<=Ndx; ii++)
    {
      if(*Stk[ii]==62&&*Stk[ii+1]==61 ){
          strcpy(Stk[ii],">=");
          LShiftStk(ii+1);
        }
    }
  for(int ii=1; ii<=Ndx; ii++)
    {
      if(strcmp(Stk[ii],"<=")==0  && *Stk[ii+1]==61 ){
          strcpy(Stk[ii],"<=");
          LShiftStk(ii+1);
        }
    }
  for(int ii=1; ii<=Ndx; ii++)
    {
      if(*Stk[ii]==33&&*Stk[ii+1]==61 ){
          strcpy(Stk[ii],"!=");
          LShiftStk(ii+1);
        }
    }
  for(int ii=1; ii<=Ndx; ii++)
    {
      if(*Stk[ii]==38&&*Stk[ii+1]==38 ){
          strcpy(Stk[ii],"&&");
          LShiftStk(ii+1);
        }
    }
  for(int ii=1; ii<=Ndx; ii++)
    {
      if(*Stk[ii]==124&&*Stk[ii+1]==124 ){
          strcpy(Stk[ii],"||");
          LShiftStk(ii+1);
        }
    }
  int Map_Idx={0};
  for(int ii=1; ii<=Ndx; ii++)
    {
      if(strcmp(Stk[ii],"strcmp")==0){
          if(MSMap[++Map_Idx]==1 ){
              strcpy(Stk[ii],"bcx_stricmp");
              Use_BCX_stricmp=TRUE;
            }
        }
    }
  *IF_Stmt_Buffer=0;
  for(int ii=1; ii<=Ndx; ii++)
    {
      strcat(IF_Stmt_Buffer,Stk[ii]);
    }
  if(IgnoreStrCase==TRUE ){
      strcpy(IF_Stmt_Buffer,replace(IF_Stmt_Buffer,"strcmp","bcx_stricmp"));
      Use_BCX_stricmp=TRUE;
    }
  strcpy(IF_Stmt_Buffer,replace(IF_Stmt_Buffer," ) {",") {"));
  if(iMatchNQ(IF_Stmt_Buffer,"cmp")){
      strcpy(IF_Stmt_Buffer,replace(IF_Stmt_Buffer,"||  strcmp","|| strcmp"));
      strcpy(IF_Stmt_Buffer,replace(IF_Stmt_Buffer,"&&  strcmp","&& strcmp"));
      strcpy(IF_Stmt_Buffer,replace(IF_Stmt_Buffer,"||  stricmp","|| stricmp"));
      strcpy(IF_Stmt_Buffer,replace(IF_Stmt_Buffer,"&&  stricmp","&& stricmp"));
      strcpy(IF_Stmt_Buffer,replace(IF_Stmt_Buffer,"( strcmp","(strcmp"));
      strcpy(IF_Stmt_Buffer,replace(IF_Stmt_Buffer,"( stricmp","(stricmp"));
    }
  if(ISFALSE iMatchNQ(IF_Stmt_Buffer,"  || ")){
      strcpy(IF_Stmt_Buffer,replace(IF_Stmt_Buffer,"|| "," || "));
    }
  if(ISFALSE iMatchNQ(IF_Stmt_Buffer,"  && ")){
      strcpy(IF_Stmt_Buffer,replace(IF_Stmt_Buffer,"&& "," && "));
    }
  if(iOutputMethod==ePart ){
      fprintf(FP_WRITE,"%s",IF_Stmt_Buffer);
    }
  else
    {
      fprintf(FP_WRITE,"%s\n",IF_Stmt_Buffer);
    }
}

void PrintGlobal (FILE* FP_OUTPUT,int A,int idx,char* Storage,char* P,char* VarName,char* VarDim)
{
  char L_Var[BCXSTRSIZE];
  if(A==vt_FILEPTR ){
      strcpy(VarName,RemoveStr(VarName,"@"));
      fprintf(FP_OUTPUT,"%s%s%s%s%s%s\n",Storage,"FILE    *",P,VarName,VarDim,";");
      goto L1366;
    }
  if(A==vt_UDT||A==vt_STRUCT||A==vt_UNION ){
      strcpy(L_Var,TypeDefs[GlobalVars[idx].VarDef].VarName);
      strcpy(L_Var,rpad(L_Var,PADSIZE));
      fprintf(FP_OUTPUT,"%s%s%s%s%s%s%s\n",Storage,L_Var,SPC,P,VarName,VarDim,";");
      goto L1366;
    }
  if(A==vt_LPSTR ){
      fprintf(FP_OUTPUT,"%s%s%s%s%s%s\n",Storage,"PSTR  ",P,VarName,VarDim,";");
      goto L1366;
    }
  if(A==vt_STRVAR ){
      if(ISNULL(VarDim)){
          strcpy(VarDim,"[BCXSTRSIZE]");
        }
      fprintf(FP_OUTPUT,"%s%s%s%s%s%s\n",Storage,"char    ",P,VarName,VarDim,";");
      goto L1366;
    }
  if(A>=vt_VarMin&&A<=vt_VarMax ){
      strcpy(L_Var,GetVarTypeName(GlobalVars[idx].VarType));
      strcpy(L_Var,rpad(L_Var,PADSIZE));
      fprintf(FP_OUTPUT,"%s%s%s%s%s%s%s\n",Storage,L_Var,SPC,P,VarName,VarDim,";");
    }
L1366:;
}

void ReDirectFPrint (FILE* TgtFile,char* pat,...)
{
  va_list  ap;
  if(DoCountLines&&TgtFile==FP_W ){
      LinesWritten++;
    }
  va_start(ap,pat);
  vfprintf(TgtFile,pat,ap);
  va_end(ap);
}

void InitReservedWordsLookup ()
{
  int  MaxReservedWords={0};
  char sL[BCXSTRSIZE]={0};
  int  iC={0};
  int  iD={0};
  MaxReservedWords=WordsInTable(BCXWords);
  for(iC=0; iC<=96; iC++)
    {
      iRIndex[iC][0]=MaxReservedWords-1;
      iRIndex[iC][1]=0;
    }
  for(iC=0; iC<=MaxReservedWords-1; iC++)
    {
      if(strcmp(sL,BCXWords[iC].pszFunctionName)==1){
          Abort(join(7,"Error in BCXWords[], Names out of order",CRLF,sL," comes after ",BCXWords[iC].pszFunctionName,CRLF,"Correct and recompile"));
        }
      strcpy(sL,BCXWords[iC].pszFunctionName);
      iD=(UCHAR)*(sL)-32;
      if(iD<0 ){
          iD=0;
        }
      if(iD>96 ){
          iD=96;
        }
      if(iRIndex[iD][0]>iC ){
          iRIndex[iD][0]=iC;
        }
      if(iRIndex[iD][1]<iC ){
          iRIndex[iD][1]=iC;
        }
    }
  for(iC=0; iC<=96; iC++)
    {
      if(iRIndex[iC][0]>iRIndex[iC][1]){
          iRIndex[iC][0]=iRIndex[iC][1];
        }
      iRIndex[iC][1]++;
    }
  int  iChk;
  int  iSize;
  iSize=WordsInTable(tBcxWords)-2;
  for(iChk=0; iChk<=iSize; iChk++)
    {
      if(strcmp(tBcxWords[iChk].pszWord,tBcxWords[iChk+1].pszWord)==1){
          Abort(join(4,"Error in SET tBcxWords: ",tBcxWords[iChk].pszWord," comes after ",tBcxWords[iChk+1].pszWord));
        }
    }
  iSize=WordsInTable(tTypes)-2;
  for(iChk=0; iChk<=iSize; iChk++)
    {
      if(strcmp(tTypes[iChk].pszWord,tTypes[iChk+1].pszWord)==1){
          Abort(join(4,"Error in SET tTypes: ",tTypes[iChk].pszWord," comes after ",tTypes[iChk+1].pszWord));
        }
    }
  iSize=WordsInTable(atEmitWords)-2;
  for(iChk=0; iChk<=iSize; iChk++)
    {
      if(strcmp(atEmitWords[iChk].pszWord,atEmitWords[iChk+1].pszWord)==1){
          Abort(join(4,"Error in SET atEmitWords: ",atEmitWords[iChk].pszWord," comes after ",atEmitWords[iChk+1].pszWord));
        }
    }
  iSize=WordsInTable(tDirectives)-2;
  for(iChk=0; iChk<=iSize; iChk++)
    {
      if(strcmp(tDirectives[iChk].pszWord,tDirectives[iChk+1].pszWord)==1){
          Abort(join(4,"Error in SET tDirectives: ",tDirectives[iChk].pszWord," comes after ",tDirectives[iChk+1].pszWord));
        }
    }
  iSize=WordsInTable(VariantList)-3;
  for(iChk=0; iChk<=iSize; iChk++)
    {
      if(strcmp(VariantList[iChk].sNAME,VariantList[iChk+1].sNAME)==1){
          Abort(join(4,"Error in SET VariantList: ",VariantList[iChk].sNAME," comes after ",VariantList[iChk+1].sNAME));
        }
    }
  iSize=WordsInTable(ptVCasts)-3;
  for(iChk=0; iChk<=iSize; iChk++)
    {
      if(strcmp(ptVCasts[iChk].pszCAST,ptVCasts[iChk+1].pszCAST)==1){
          Abort(join(4,"Error in SET ptVCasts: ",ptVCasts[iChk].pszCAST," comes after ",ptVCasts[iChk+1].pszCAST));
        }
    }
  iSize=WordsInTable(ptCCasts)-3;
  for(iChk=0; iChk<=iSize; iChk++)
    {
      if(strcmp(ptCCasts[iChk].pszCAST,ptCCasts[iChk+1].pszCAST)==1){
          Abort(join(4,"Error in SET ptCCasts: ",ptCCasts[iChk].pszCAST," comes after ",ptCCasts[iChk+1].pszCAST));
        }
    }
}

TOKSUBFUNC* GetWordInfo (char* sWord)
{
  int iH;
  int iL;
  int iM;
  int iV;
  iM=(UCHAR)*(sWord)-32;
  if(iM<0 ){
      iM=0;
    }
  if(iM>96 ){
      iM=96;
    }
  iL=iRIndex[iM][0];
  iH=iRIndex[iM][1];
  for(;;)
    {
      iM=(iH+iL)>>1;
      iV=strcmp(BCXWords[iM].pszFunctionName,sWord);
      if(iV==-1 ){
          if(iL!=iH ){
              if(iL==iM ){
                  iL++;
                }
              else
                {
                  iL=iM;
                }
            }
          goto L1378;
        }
      if(iV==0 ){
          return &(BCXWords[iM]);
        }
      if(iV==1 ){
          if(iL!=iH ){
              iH=iM;
            }
        }
L1378:;
      if(iL==iH ){
          goto L1377;
        }
    }
L1377:;
  return NULL;
}

int FindWord (char* sWord,WORDS*  tWordList,int iWordsInTable)
{
  int  iH;
  int  iL;
  int  iM;
  int  iV;
  iL=0;
  iH=iWordsInTable;
  while(iL!=iH){
      iM=(iH+iL)>>1;
      iV=strcmp(tWordList[iM].pszWord,sWord);
      if(iV==-1 ){
          if(iL==iM ){
              return (-1);
            }
          iL=iM;
          goto L1380;
        }
      if(iV==0 ){
          return iM;
        }
      if(iV==1 ){
          if(iL==iM ){
              return (-1);
            }
          iH=iM;
        }
L1380:;
    }
  return (-1);
}

void FixAnyArrays (char* Arg)
{
  int  iMakeNewArg;
  int  iAttach;
  iMakeNewArg=0;
  for(int i=1; i<=Ndx; i++)
    {
      if(iMatchWrd(Stk[i],"as")){
          i++;
          iAttach=0;
          if(iMatchWrd(Stk[i],"vector")){
              i++;
              if(*Stk[i]==60 ){
                  iAttach=i-1;
                }
            }
          else
            {
              if(iMatchWrd(Stk[i+1],"vector")){
                  i+=(2);
                  if(*Stk[i]==60 ){
                      iAttach=i-1;
                    }
                }
            }
          if(iAttach>0 ){
              iMakeNewArg=1;
              for(int j=iAttach+1; j<=Ndx; j++)
                {
                  if(strcmp(Stk[j],"<")==0){
                      strcpy(Stk[iAttach], join(2,Stk[iAttach],chr(16)));
                      *Stk[j]=0;
                        {
                        int  k;
                        int  iV;
                        for(k=j+1,iV=1; k<=Ndx && iV>0; k++)
                          {
                            if(strcmp(Stk[k],">")==0){
                                iV--;
                                strcpy(Stk[iAttach], join(2,Stk[iAttach],chr(17)));
                                *Stk[k]=0;
                                goto L1384;
                              }
                            if(strcmp(Stk[k],"<")==0){
                                iV++;
                                strcpy(Stk[iAttach], join(2,Stk[iAttach],chr(16)));
                                *Stk[k]=0;
                                goto L1384;
                              }
                            if(strcmp(Stk[k],",")==0){
                                strcpy(Stk[iAttach], join(2,Stk[iAttach],chr(18)));
                                *Stk[k]=0;
                              }
                            else
                              {
                                strcpy(Stk[iAttach], join(2,Stk[iAttach],Stk[k]));
                                *Stk[k]=0;
                              }
L1384:;
                          }
                          }
                    }
                }
            }
        }
    }
  if(iMakeNewArg ){
      char szNewArg[BCXSTRSIZE];
      *szNewArg=0;
      RemEmptyTokens();
      for(int i=1; i<=Ndx; i++)
        {
          strcat(szNewArg,Stk[i]);
          strcat(szNewArg,SPC);
        }
      strcpy(Arg,szNewArg);
    }
}

void Translate ()
{
  struct _TOKSUBFUNC*  ptW={0};
  char szWord[BCXSTRSIZE]={0};
  char Scratch[BCXSTRSIZE]={0};
  int iEmitID={0};
  int iDoFixup={0};
  if(iMatchLft(Src,"set ")){
      if(ComSwitchON==TRUE ){
          if(inchr(Src,"=")){
              Use_COM=Use_BcxTempStr=TRUE;
            }
          else
            {
              ProcessSetCommand(0);
              return;
            }
        }
      else
        {
          ProcessSetCommand(0);
          return;
        }
    }
  if(iMatchLft(Src,"sharedset ")){
      ProcessSetCommand(1);
      return;
    }
  PassOne=TRUE;
  XParse(Src);
  PassOne=FALSE;
  if(Ndx==0 ){
      return;
    }
  if(bcx_stricmp(Stk[1],"FUNCTION")==0  && strcmp(Stk[2],"=")!=0){
      if(bcx_stricmp(Stk[Ndx],"FLOAT")==0  &&  bcx_stricmp(Stk[Ndx-1],"AS")==0){
          strcpy(Stk[2], join(2,Stk[2],"!"));
          Ndx-=(2);
        }
      if(bcx_stricmp(Stk[Ndx],"SINGLE")==0  &&  bcx_stricmp(Stk[Ndx-1],"AS")==0){
          strcpy(Stk[2], join(2,Stk[2],"!"));
          Ndx-=(2);
        }
      if(bcx_stricmp(Stk[Ndx],"DOUBLE")==0  &&  bcx_stricmp(Stk[Ndx-1],"AS")==0){
          strcpy(Stk[2], join(2,Stk[2],"#"));
          Ndx-=(2);
        }
      if(bcx_stricmp(Stk[Ndx],"STRING")==0  &&  bcx_stricmp(Stk[Ndx-1],"AS")==0){
          strcpy(Stk[2], join(2,Stk[2],"$"));
          Ndx-=(2);
        }
    }
  int ArgsFound={0};
  if(UseCpp==FALSE ){
      TransformSigil=FALSE;
      if(iMatchWrd(Stk[1],"SUB")||(iMatchWrd(Stk[1],"FUNCTION") && strcmp(Stk[2],"=")!=0)  || iMatchWrd(Stk[1],"DECLARE")||iMatchWrd(Stk[1],"C_DECLARE")||iMatchWrd(Stk[1],"PUBLIC")||iMatchWrd(Stk[1],"PRIVATE")){
          for(int zz=1; zz<=Ndx; zz++)
            {
              if(strcmp(Stk[zz],"(")==0){
                  ArgsFound=TRUE;
                }
              if(ArgsFound ){
                  if(RightStr(Stk[zz],"#")){
                      strcpy(Stk[zz],replace(Stk[zz],"#"," AS DOUBLE "));
                      TransformSigil=TRUE;
                    }
                }
              if(ArgsFound ){
                  if(RightStr(Stk[zz],"!")){
                      strcpy(Stk[zz],replace(Stk[zz],"!"," AS SINGLE "));
                      TransformSigil=TRUE;
                    }
                }
              if(ArgsFound ){
                  if(TransformSigil ){
                      for(int yy=1; yy<=Ndx; yy++)
                        {
                          if(strcmp(Stk[yy],"[")==0  && strcmp(Stk[zz+1],"]")==0){
                              strcpy(Stk[yy],"*");
                              *Stk[yy+1]=0;
                            }
                        }
                    }
                }
            }
        }
      if(TransformSigil ){
          *Scratch=0;
          for(int zz=1; zz<=Ndx; zz++)
            {
              strcat(Scratch,Stk[zz]);
              strcat(Scratch,SPC);
            }
          strcpy(Scratch,replace(Scratch,"DOUBLE  as double","DOUBLE"));
          strcpy(Scratch,replace(Scratch,"SINGLE  as single","SINGLE"));
          FastLexer(Scratch,SPC,"=&()[]{}',+-*/<>?;.|:^");
        }
    }
  for(int i=1; i<=Ndx; i++)
    {
      if(bcx_stricmp(Stk[i],"data")==0  &&  bcx_stricmp(Stk[i+1],"as")==0){
          Abort("DATA is a reserved word ");
        }
    }
  if(UseCpp||UseCpphdr ){
      FixAnyArrays(Src);
    }
  if(ComSwitchON==TRUE ){
      int i;
      int j;
      for(i=1,j=COM_open_WITH_statement; i<=Ndx && j==0; i++)
        {
          if(IsVariableComObject(Stk[i])){
              j=1;
            }
        }
      if(j ){
          if(Find_COM_statement(Src)==TRUE ){
              return;
            }
        }
    }
  if(SpecialCaseHandler(Src)){
      return;
    }
  iDoFixup=TRUE;
  strcpy(szWord,lcase(Stk[1]));
  ptW=GetWordInfo(szWord);
  if(ptW ){
      if((ptW->iWordInfo  &  eWI_Directive)){
          iEmitID=FindWord(szWord,tDirectives,WordsInTable(tDirectives));
          if(iEmitID!=NOTFOUND ){
              int FuncRetnFlag={0};
              if(tDirectives[iEmitID].Emitter(szWord,&(FuncRetnFlag))==0 ){
                  return;
                }
            }
        }
      if((ptW->iWordInfo  &  eWI_NoFixup)){
          iDoFixup=FALSE;
        }
    }
  if(iDoFixup ){
      FixUps();
      PassOne=FALSE;
    }
  if(Ndx ){
      Emit_Main();
      if(iEmitVarGroup ){
          Emit_BCXVariables();
        }
    }
}

void FixVector ()
{
  int Tmp;
  int j;
  int k;
  for(Tmp=2; Tmp<=Ndx; Tmp++)
    {
      if(iMatchWrd(Stk[Tmp],"as")){
          if(strcmp(Stk[Tmp+1],"vector")==0){
              Tmp++;
              k=Tmp;
              j=0;
              for(;;)
                {
                  strcpy(Stk[k], join(2,Stk[k],Stk[++Tmp]));
                  if(strcmp(Stk[Tmp],">")==0){
                      j++;
                    }
                  *Stk[Tmp]=0;
                  if(j ){
                      goto L1392;
                    }
                }
L1392:;
            }
        }
    }
  RemEmptyTokens();
}

void Emit_Main ()
{
  int EmitAgain=TRUE;
  int FuncRetnFlag=0;
  int iEmitID;
  char Lookup[BCXSTRSIZE];
  if(HasVector ){
      FixVector();
      HasVector=FALSE;
    }
  strcpy(Lookup,lcase(Stk[1]));
  if(SelectState[StateIdx].NoBreak&&!iMatchLft(Lookup,"case")&&!iMatchWrd(Lookup,"endselect")){
      SelectState[StateIdx].NoBreak=0;
    }
  for(int i=1; i<=Ndx; i++)
    {
      if(inchr(Stk[i],chr(15))){
          strcpy(Stk[i],replace(Stk[i],chr(15),":"));
        }
      if(inchr(Stk[i],chr(16))){
          strcpy(Stk[i],replace(Stk[i],chr(16),"<"));
        }
      if(inchr(Stk[i],chr(17))){
          strcpy(Stk[i],replace(Stk[i],chr(17),">"));
        }
      if(inchr(Stk[i],chr(18))){
          strcpy(Stk[i],replace(Stk[i],chr(18),","));
        }
    }
  if(iMatchRgt(Stk[1],":")){
      fprintf(FP_WRITE,"%s\n","");
      fprintf(FP_WRITE,"%s%s\n",ucase(Stk[1]),";");
      return;
    }
  while(EmitAgain&&Ndx>0){
      Statements++;
      if(CurrentFuncType==vt_STRVAR&&(InFunction||InCppTypeDef)&&OkayToSend ){
          fprintf(FP_WRITE,"%s%s\n",Scoot,"char   *BCX_RetStr={0};");
          OkayToSend=FALSE;
        }
      strcpy(Lookup,lcase(Stk[1]));
      iEmitID=FindWord(Lookup,atEmitWords,WordsInTable(atEmitWords));
      if(iEmitID==NOTFOUND ){
          Emit_Old(&(FuncRetnFlag));
          EmitAgain=FALSE;
        }
      else
        {
          EmitAgain=atEmitWords[iEmitID].Emitter(Lookup,&(FuncRetnFlag));
        }
    }
  if(FuncRetnFlag==1 ){
      if(NOTZERO(LocalDynaCnt)){
          for(int j=1; j<=LocalDynaCnt; j++)
            {
              fprintf(FP_WRITE,"%s%s\n",Scoot,DynaStr[j]);
            }
        }
      if(AuxLocalDynArrayCount>0 ){
          fprintf(FP_WRITE,"%s\n","");
          while(AuxLocalDynArrayCount>0){
              fprintf(FP_WRITE,"%s%s\n",Scoot,AuxLocalDynArray[AuxLocalDynArrayCount]);
              *AuxLocalDynArray[AuxLocalDynArrayCount]=0;
              AuxLocalDynArrayCount--;
            }
          fprintf(FP_WRITE,"%s\n","");
        }
      fprintf(FP_WRITE,"%s%s\n",Scoot,"return BCX_RetStr;");
    }
  ExitSubFunc=FALSE;
  if(iMatchWrd(Stk[1],"exit")){
      if(iMatchWrd(Stk[2],"sub")||iMatchWrd(Stk[2],"function")){
          ExitSubFunc=TRUE;
        }
    }
}

int Emit_FolderDriveProcs (char* Lookup,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  fprintf(FP_WRITE,"%s%s%s",Scoot,Lookup," (");
  strcpy(Stk[++Ndx],");");
  WriteCleanTokens(2,Ndx);
  return 0;
}

int Emit_FunctionReturn (char* Lookup,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(Lookup);
  if(UseCpp==FALSE ){
      char LTmp[BCXSTRSIZE]={0};
      if(SelectState[StateIdx].CaseFlag ){
          SelectState[StateIdx].NoBreak=TRUE;
        }
      for(int i=1; i<=Ndx; i++)
        {
          if((int)strlen(Stk[i])>1 && strcmp(right(Stk[i],1),"!")==0){
              strcpy(Stk[i],RemoveStr(Stk[i],"!"));
            }
          if((int)strlen(Stk[i])>1 && strcmp(right(Stk[i],1),"%")==0){
              strcpy(Stk[i],RemoveStr(Stk[i],"%"));
            }
          if((int)strlen(Stk[i])>1 && strcmp(right(Stk[i],1),"#")==0){
              strcpy(Stk[i],RemoveStr(Stk[i],"#"));
            }
        }
      for(int i=3; i<=Ndx; i++)
        {
          strcpy(LTmp, join(3,LTmp,Stk[i],SPC));
        }
      strcpy(LTmp,CleanCodeLine(trim(LTmp)));
      if(RightStr(LTmp," export",1)){
          strcpy(LTmp,IRemoveStr(LTmp,"export"));
        }
      if(CurrentFuncType==vt_STRVAR ){
          strcpy(LTmp, join(2,"BCX_RetStr$ = ",LTmp));
          *FuncRetnFlag=1;
          Use_BcxTempStr=TRUE;
        }
      else
        {
          strcpy(LTmp, join(2,"Bcx_RetVal = ",LTmp));
          strcpy(Stk[1],"Bcx_RetVal");
          JoinStrings(1,0);
          *LTmp=0;
          for(int i=1; i<=Ndx; i++)
            {
              strcat(LTmp,Stk[i]);
            }
          strcpy(LTmp,trim(LTmp));
          strcpy(LTmp,Clean(LTmp));
          strcpy(LTmp,CleanCodeLine(LTmp));
          *FuncRetnFlag=2;
        }
      if(*FuncRetnFlag==2 ){
          fprintf(FP_WRITE,"%s%s%s\n",Scoot,LTmp,";");
        }
      if(*FuncRetnFlag==2 ){
          if(NOTZERO(LocalDynaCnt)){
              for(int j=1; j<=LocalDynaCnt; j++)
                {
                  fprintf(FP_WRITE,"%s%s\n",Scoot,DynaStr[j]);
                }
            }
          if(NOTZERO(LocalDynArrCnt)){
              for(int i=1; i<=LocalDynArrCnt; i++)
                {
                  fprintf(FP_WRITE,"%s%s\n",Scoot,LocalDynArrName[i]);
                }
            }
          if(*FuncRetnFlag==2 ){
              fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"return ",trim(extract(LTmp,"=")),";");
              *LTmp=0;
            }
          LastCmd=2;
        }
      XParse(LTmp);
      FixUps();
      LastCmd=2;
    }
  else
    {
      char LTmp[BCXSTRSIZE]={0};
      if(SelectState[StateIdx].CaseFlag ){
          SelectState[StateIdx].NoBreak=TRUE;
        }
      for(int iA=3; iA<=Ndx; iA++)
        {
          strcpy(LTmp, join(3,LTmp,Stk[iA],SPC));
        }
      if(CurrentFuncType==vt_STRVAR ){
          strcpy(LTmp, join(2,"BCX_RetStr$ = ",LTmp));
          *FuncRetnFlag=1;
          Use_BcxTempStr=TRUE;
        }
      else
        {
          *FuncRetnFlag=2;
        }
      if(*FuncRetnFlag==2 ){
          if(NOTZERO(LocalDynaCnt)){
              for(int j=1; j<=LocalDynaCnt; j++)
                {
                  fprintf(FP_WRITE,"%s%s\n",Scoot,DynaStr[j]);
                }
            }
          if(NOTZERO(LocalDynArrCnt)){
              for(int i=1; i<=LocalDynArrCnt; i++)
                {
                  fprintf(FP_WRITE,"%s%s\n",Scoot,LocalDynArrName[i]);
                }
            }
          fprintf(FP_WRITE,"%s%s",Scoot,"return ");
          LastCmd=2;
        }
      XParse(LTmp);
      FixUps();
      LastCmd=0;
    }
  return 1;
}

int Emit_Msgbox (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  UNREFERENCED_PARAMETER(sWord);
  int i;
  int j;
  int k;
  j=0;
  k=0;
  for(i=2; i<=Ndx; i++)
    {
      if(strcmp(Stk[i],"[")==0){
          j++;
        }
      else if(strcmp(Stk[i],"]")==0){
          j--;
        }
      else if(strcmp(Stk[i],"(")==0){
          j++;
        }
      else if(strcmp(Stk[i],")")==0){
          j--;
        }
      if(j==0 && strcmp(Stk[i],",")==0){
          k++;
        }
    }
  if(k==0 ){
      Ndx++;
      strcpy(Stk[Ndx],",");
      Ndx++;
      strcpy(Stk[Ndx],DDQ);
      k=1;
    }
  if(k==1 ){
      Ndx++;
      strcpy(Stk[Ndx],",");
      Ndx++;
      strcpy(Stk[Ndx],"MB_SYSTEMMODAL");
    }
  fprintf(FP_WRITE,"%s%s",Scoot,"MessageBox (GetActiveWindow(),");
  strcpy(Stk[++Ndx],");");
  WriteCleanTokens(2,Ndx);
  return 0;
}

int Emit_BcxSetFont (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  UNREFERENCED_PARAMETER(sWord);
  Use_SetFont=TRUE;
  Use_Proto=TRUE;
  if(strcmp(Stk[2],"(")==0){
      LShiftStk(2);
      Ndx--;
    }
  fprintf(FP_WRITE,"%s%s",Scoot,"SendMessage(");
  int i;
  i=2;
  for(;;)
    {
      fprintf(FP_WRITE,"%s",Clean(Stk[i]));
      i++;
      if(strcmp(Stk[i],",")==0){
          goto L1406;
        }
      if(i>Ndx ){
          Abort("Malformed BCX_SET_FONT");
        }
    }
L1406:;
  i++;
  fprintf(FP_WRITE,"%s",",(UINT_PTR)WM_SETFONT,");
  fprintf(FP_WRITE,"%s","(WPARAM)BCX_Set_Font(");
  strcpy(Stk[++Ndx],"),1);");
  WriteCleanTokens(i,Ndx);
  return FALSE;
}

int Emit_BcxSetLabelColor (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  UNREFERENCED_PARAMETER(sWord);
  Use_SetColor=Use_Proto=TRUE;
  if(strcmp(Stk[2],"(")==0){
      LShiftStk(2);
      Ndx--;
    }
  *gTmpStr=0;
  int i;
  for(i=2; i<=Ndx; i++)
    {
      if(strcmp(Stk[i],",")==0){
          goto L1407;
        }
      strcat(gTmpStr,Stk[i]);
    }
L1407:;
  fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"if((HWND)lParam==",gTmpStr," && Msg==WM_CTLCOLORSTATIC)");
  fprintf(FP_WRITE,"%s%s",Scoot,"return Set_Color(");
  strcpy(Stk[++Ndx],",(HDC)(UINT_PTR)wParam,(HWND)lParam);");
  WriteCleanTokens(i+1,Ndx);
  return FALSE;
}

int Emit_BcxSetEditColor (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  UNREFERENCED_PARAMETER(sWord);
  Use_SetColor=Use_Proto=TRUE;
  if(strcmp(Stk[2],"(")==0){
      LShiftStk(2);
      Ndx--;
    }
  *gTmpStr=0;
  int iii;
  for(iii=2; iii<=Ndx; iii++)
    {
      if(strcmp(Stk[iii],",")==0){
          goto L1408;
        }
      strcat(gTmpStr,Stk[iii]);
    }
L1408:;
  fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"if((HWND)lParam==",gTmpStr," && Msg==WM_CTLCOLOREDIT)");
  fprintf(FP_WRITE,"%s%s",Scoot,"return Set_Color(");
  strcpy(Stk[++Ndx],",(HDC)(UINT_PTR)wParam,(HWND)lParam);");
  WriteCleanTokens(iii+1,Ndx);
  return FALSE;
}

int Emit_Hscroll (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  UNREFERENCED_PARAMETER(sWord);
  Use_Hscroll=IVAL(Stk[2]);
  if(Use_Hscroll==0 ){
      Use_Hscroll=TRUE;
    }
  return FALSE;
}

int Emit_Vscroll (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  UNREFERENCED_PARAMETER(sWord);
  Use_Vscroll=IVAL(Stk[2]);
  if(Use_Vscroll==0 ){
      Use_Vscroll=TRUE;
    }
  return FALSE;
}

int Emit_InsertMenuProc (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  UNREFERENCED_PARAMETER(sWord);
  int L_Comma;
  L_Comma=0;
  fprintf(FP_WRITE,"%s%s",Scoot,"InsertMenu");
  for(int A=2; A<=Ndx; A++)
    {
      if(strcmp(Stk[A],",")==0){
          L_Comma++;
        }
      if(strcmp(Stk[A],",")==0){
          if(L_Comma==3 ){
              strcpy(Stk[A],",(UINT_PTR)");
            }
        }
      fprintf(FP_WRITE,"%s",Clean(Stk[A]));
    }
  fprintf(FP_WRITE,"%s\n",";");
  return FALSE;
}

int Emit_MdiGuiProcs (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  if(Ndx<2 ){
      Abort(join(3,"Not Enough Parameters with ",ucase(sWord)," Statement!"));
    }
  if(iMatchWrd(Stk[2],"nomain")){
      Use_Wingui=TRUE;
      NoMain=TRUE;
      Use_GUINoMain=TRUE;
      if(iMatchWrd(Stk[4],"pixels")){
          strcpy(GUIMetric,"pixels");
        }
      if(iMatchWrd(Stk[4],"dpi")){
          strcpy(GUIMetric,"dpi");
        }
      if(iMatchWrd(Stk[4],"icon") && strcmp(Stk[6],"")!=0){
          strcpy(GUIIcon, join(3," LoadIcon(BCX_hInstance,MAKEINTRESOURCE(",Stk[6],"));"));
        }
      else if(iMatchWrd(Stk[6],"icon") && strcmp(Stk[8],"")!=0){
          strcpy(GUIIcon, join(3," LoadIcon(BCX_hInstance,MAKEINTRESOURCE(",Stk[8],"));"));
        }
      else
        {
          strcpy(GUIIcon," LoadIcon(NULL,IDI_WINLOGO);");
        }
      if(strcmp(sWord,"mdigui")==0){
          Use_Mdigui=TRUE;
          Emit_MDICode(FP_WRITE);
          Use_MDIGUINoMain=TRUE;
          Use_GUINoMain=FALSE;
        }
    }
  else
    {
      Use_Wingui=TRUE;
      char classname[BCXSTRSIZE]={0};
      char metric[BCXSTRSIZE]={0};
      strcpy(classname,Stk[2]);
      if(iMatchWrd(Stk[4],"pixels")){
          strcpy(metric,"pixels");
          strcpy(GUIMetric,"pixels");
        }
      if(iMatchWrd(Stk[4],"dpi")){
          strcpy(metric,"dpi");
          strcpy(GUIMetric,"dpi");
        }
      if(iMatchWrd(Stk[4],"icon") && strcmp(Stk[6],"")!=0){
          strcpy(GUIIcon, join(3," LoadIcon(BCX_hInstance,MAKEINTRESOURCE(",Stk[6],"));"));
        }
      else if(iMatchWrd(Stk[6],"icon") && strcmp(Stk[8],"")!=0){
          strcpy(GUIIcon, join(3," LoadIcon(BCX_hInstance,MAKEINTRESOURCE(",Stk[8],"));"));
        }
      else
        {
          strcpy(GUIIcon," LoadIcon(NULL,IDI_WINLOGO);");
        }
      Use_BCX_SetMetric=Use_BCX_InitGUI=Use_BCX_RegWnd=TRUE;
      Emit_WinGUIMain(classname,metric,GUIIcon);
      if(strcmp(sWord,"mdigui")==0){
          Use_Mdigui=TRUE;
          Emit_MDI_MsgPump();
          Emit_MDICode(FP_WRITE);
        }
      else
        {
          Emit_GUI_MsgPump();
        }
    }
  AddGUIGlobals();
  if(!Use_BCX_Class_Info ){
      Use_BCX_Class_Info=TRUE;
      iEmitVarGroup=iEmitVarGroup|(eFontGroup|eClassName);
    }
  return FALSE;
}

int Emit_FileIO (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  if(strcmp(sWord,"flush")==0){
      for(int i=2; i<=Ndx; i++)
        {
          strcpy(Stk[i],RemoveStr(Stk[i],"#"));
          if(ISNULL(Stk[i])){
              Abort("Bad FLUSH Argument");
            }
          if(DataType(Stk[i])==vt_NUMBER ){
              strcpy(Stk[i], join(2,"FP",Stk[i]));
            }
        }
      if(strcmp(Stk[2],"(")==0){
          LShiftStk(2);
          Ndx--;
        }
      int i={0};
      if(CheckLocal(Stk[2],&(i))==vt_UNKNOWN ){
          if(CheckGlobal(Stk[2],&(i))==vt_UNKNOWN ){
              AddGlobal(Stk[2],vt_FILEPTR);
            }
        }
      *szFileHandle=0;
      for(int j=2; j<=Ndx; j++)
        {
          strcat(szFileHandle,Stk[j]);
        }
      fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"   fflush(",szFileHandle,");");
      goto L1410;
    }
  if(strcmp(sWord,"close")==0){
      if(Ndx==1 ){
          fprintf(FP_WRITE,"%s%s\n",Scoot,"_fcloseall();");
          goto L1410;
        }
      int Redo={0};
      for(int i=1; i<=Ndx; i++)
        {
          if(strcmp(Stk[i],",")==0){
              strcpy(Stk[i]," : close ");
              Redo=TRUE;
            }
        }
      if(Redo ){
          *Src=0;
          for(int i=1; i<=Ndx; i++)
            {
              strcat(Src,Stk[i]);
              strcat(Src,SPC);
            }
          SplitLines(Src);
          strcpy(Src,ltrim(SplitStk[++SplitCur]));
          FastLexer(Src,SPC,"=&()[]{}',+-*/<>?;.|:^");
        }
      for(int i=2; i<=Ndx; i++)
        {
          strcpy(Stk[i],RemoveStr(Stk[i],"#"));
          if(*Stk[i]==0 ){
              Abort("Bad CLOSE Argument");
            }
          if(DataType(Stk[i])==vt_NUMBER ){
              strcpy(Stk[i], join(2,"FP",Stk[i]));
            }
        }
      if(strcmp(Stk[2],"(")==0){
          LShiftStk(2);
          Ndx--;
        }
      int i;
      if(CheckLocal(Stk[2],&(i))==vt_UNKNOWN ){
          if(CheckGlobal(Stk[2],&(i))==vt_UNKNOWN ){
              AddGlobal(Stk[2],vt_FILEPTR);
            }
        }
      *szFileHandle=0;
      for(int j=2; j<=Ndx; j++)
        {
          strcat(szFileHandle,Stk[j]);
        }
      if(UseFileTest ){
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"if(",szFileHandle,")");
          fprintf(FP_WRITE,"%s%s\n",Scoot," {");
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"   fclose(",szFileHandle,");");
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"   ",szFileHandle,"=NULL;");
          fprintf(FP_WRITE,"%s%s\n",Scoot," }");
        }
      else
        {
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"fclose(",szFileHandle,");");
        }
      goto L1410;
    }
  if(strcmp(sWord,"open")==0){
      char Keyword[BCXSTRSIZE];
      char LTmp[BCXSTRSIZE];
      char Op[BCXSTRSIZE];
      int HaveFOR;
      int HaveAS;
      HaveFOR=FALSE;
      HaveAS=FALSE;
      *Op=0;
      for(int iA=1; iA<=Ndx; iA++)
        {
          strcpy(Keyword,lcase(Stk[iA]));
          if(strcmp(Keyword,"open")==0){
              *Stk[iA]=0;
              goto L1418;
            }
          if(strcmp(Keyword,"for")==0){
              *Stk[iA]=0;
              BuildCleanStr(2,iA-1,Filnam);
              HaveFOR=TRUE;
              goto L1418;
            }
          if(strcmp(Keyword,"as")==0){
              *Stk[iA]=0;
              if(DataType(Stk[iA+1])==vt_NUMBER ){
                  strcpy(Stk[iA+1], join(2,"FP",Stk[iA+1]));
                }
              HaveAS=TRUE;
              int i;
              if(CheckLocal(Stk[iA+1],&(i))==vt_UNKNOWN ){
                  if(CheckGlobal(Stk[iA+1],&(i))==vt_UNKNOWN ){
                      AddGlobal(Stk[iA+1],vt_FILEPTR);
                    }
                }
              *Var=0;
              for(int j=iA+1; j<=Ndx; j++)
                {
                  if(iMatchWrd(Stk[j],"reclen")){
                      goto L1419;
                    }
                  strcat(Var,Stk[j]);
                  *Stk[j]=0;
                }
L1419:;
              strcpy(szFileHandle, join(2,Var,"@"));
              goto L1418;
            }
          if(strcmp(Keyword,"input")==0){
              strcpy(Op,enc("rb"));
              *Stk[iA]=0;
              goto L1418;
            }
          if(strcmp(Keyword,"output")==0){
              strcpy(Op,enc("w"));
              *Stk[iA]=0;
              goto L1418;
            }
          if(strcmp(Keyword,"append")==0){
              strcpy(Op,enc("a"));
              *Stk[iA]=0;
              goto L1418;
            }
          if(strcmp(Keyword,"binary")==0){
              strcpy(Op,enc("rb+"));
              *Stk[iA]=0;
              goto L1418;
            }
          if(strcmp(Keyword,"binaryappend")==0){
              strcpy(Op,enc("ab+"));
              *Stk[iA]=0;
              goto L1418;
            }
          if(strcmp(Keyword,"binarynew")==0){
              strcpy(Op,enc("wb+"));
              *Stk[iA]=0;
              goto L1418;
            }
          if(strcmp(Keyword,"binaryinput")==0){
              strcpy(Op,enc("rb"));
              *Stk[iA]=0;
              goto L1418;
            }
          if(strcmp(Keyword,"binaryoutput")==0){
              strcpy(Op,enc("rb+"));
              *Stk[iA]=0;
              goto L1418;
            }
          if(strcmp(Keyword,"reclen")==0){
              if(strcmp(Stk[iA+1],"=")==0){
                  for(int j=iA+2; j<=Ndx; j++)
                    {
                      strcpy(Stk[j-1],Stk[j]);
                    }
                  Ndx--;
                }
              strcpy(Var, join(2,extract(Clean(szFileHandle),"["),"len"));
              int i;
              int j;
              char LZZ[BCXSTRSIZE];
              if(CheckLocal(Var,&(i))==vt_UNKNOWN ){
                  AddGlobal(Var,vt_INTEGER);
                }
              else
                {
                  if(CheckLocal(Var,&(i))==vt_UNKNOWN ){
                      AddLocal(Var,vt_INTEGER);
                      strcpy(Var, join(2,"int ",Var));
                    }
                }
              i=CheckType(Stk[iA+1]);
              strcpy(LZZ,lcase(Stk[iA+1]));
              j=FindWord(LZZ,tTypes,WordsInTable(tTypes));
              if(i==vt_STRUCT||i==vt_UNION||j==vt_BOOL||j==vt_BYTE||j==vt_CHAR||j==vt_SCHAR||j==vt_COLORREF||j==vt_DOUBLE||j==vt_DWORD||j==vt_SINGLE||j==vt_INTEGER||j==vt_LDOUBLE||j==vt_LLONG||j==vt_SSHORT||j==vt_LONG||j==vt_SHORT||j==vt_UINT||j==vt_ULONG||j==vt_ULONGLONG||j==vt_USHORT||j==vt_VARIANT||j==vt_WINBOOL ){
                  fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,Var," = sizeof(",Stk[iA+1],");");
                }
              else
                {
                  fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,Var," = ",Clean(Stk[iA+1]),";");
                }
              *Stk[iA]=0;
              *Stk[iA+1]=0;
            }
L1418:;
        }
      if(ISNULL(Op)){
          Abort("Syntax Error: Missing FOR in OPEN statement");
        }
      if(IDont(HaveFOR)){
          Abort("Syntax Error: Missing FOR in OPEN statement");
        }
      if(IDont(HaveAS)){
          Abort("Syntax Error: Missing AS  in OPEN statement");
        }
      if(UseFileTest ){
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"if((",Clean(szFileHandle),"=fopen(",Filnam,", ",Op,"))==0)");
          fprintf(FP_WRITE,"%s%s\n",Scoot," {");
          strcpy(LTmp,enc("Error: Cannot Access File or File Not Found. %s\\n"));
          fprintf(FP_WRITE,"%s%s%s%s%s%s\n",Scoot,"fprintf(stderr, ",LTmp,", ",Filnam,"); exit(1);");
          fprintf(FP_WRITE,"%s%s\n",Scoot," }");
        }
      else
        {
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s\n",Scoot,Clean(szFileHandle),"=fopen(",Filnam,", ",Op,");");
        }
      goto L1410;
    }
  if(strcmp(sWord,"record")==0){
      int numargs={0};
      struct _FUNCPARSE  ffp;
      Clear(ffp);
      if(DataType(Stk[2])==vt_NUMBER ){
          strcpy(Stk[2], join(2,"FP",Stk[2]));
        }
      if(Ndx>1 ){
          numargs=SepFuncArgs(1,&(ffp),FALSE);
        }
      if(numargs<1 ){
          Abort("Missing required arguments to RECORD");
        }
      if(numargs>4 ){
          Abort("Too many arguments to RECORD");
        }
      if(numargs==3 ){
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s%s%s\n",Scoot,"_fseeki64 (",GetArg(1,&(ffp)),",(",GetArg(2,&(ffp)),"-1)*",Stk[2],"len+",GetArg(3,&(ffp)),",SEEK_SET);");
        }
      else if(numargs==2 ){
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"_fseeki64 (",GetArg(1,&(ffp)),",(",GetArg(2,&(ffp)),"-1)*",Stk[2],"len,SEEK_SET);");
        }
      else
        {
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"_fseeki64 (",GetArg(1,&(ffp)),",0,SEEK_SET);");
        }
    }
L1410:;
  return 0;
}

int Emit_FileManagementProcs (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  if(strcmp(sWord,"copyfile")==0){
      fprintf(FP_WRITE,"%s%s",Scoot,"CopyFile (");
      char szUS[BCXSTRSIZE];
      strcpy(szUS,ucase(Stk[Ndx]));
      if(strcmp(Stk[Ndx],"1")==0  || strcmp(Stk[Ndx],"0")==0){
          strcpy(Stk[++Ndx],");");
          goto L1422;
        }
      if(strcmp(Stk[Ndx],"TRUE")==0  || strcmp(Stk[Ndx],"FALSE")==0){
          if(UseCpp ){
              strcpy(Stk[Ndx], join(2,lcase(Stk[Ndx]),");"));
            }
          else
            {
              strcpy(Stk[Ndx], join(2,szUS,");"));
            }
        }
      else
        {
          if(UseCpp ){
              strcpy(Stk[++Ndx],",false);");
            }
          else
            {
              strcpy(Stk[++Ndx],",FALSE);");
            }
        }
L1422:;
      WriteCleanTokens(2,Ndx);
      goto L1421;
    }
  if(strcmp(sWord,"kill")==0){
      fprintf(FP_WRITE,"%s%s",Scoot,"DeleteFile (");
      if(Ndx>=2 && strcmp(Stk[2],"(")!=0){
          InsertOptionalParens(2);
        }
      strcpy(Stk[++Ndx],");");
      WriteCleanTokens(2,Ndx);
      goto L1421;
    }
  if(strcmp(sWord,"rename")==0){
      fprintf(FP_WRITE,"%s%s",Scoot,"MoveFile (");
      strcpy(Stk[++Ndx],");");
      WriteCleanTokens(2,Ndx);
    }
L1421:;
  return 0;
}

int Emit_LineInputProcs (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  UNREFERENCED_PARAMETER(sWord);
  char Var1[BCXSTRSIZE];
  char Var2[BCXSTRSIZE];
  char CVar[BCXSTRSIZE];
  char L_Handle[BCXSTRSIZE];
  int i=DataType(Stk[2]);
  if(i==vt_STRLIT||i==vt_STRVAR ){
      if(i!=vt_STRLIT ){
          strcpy(Stk[2],Clean(Stk[2]));
        }
      char sC_Stk3[BCXSTRSIZE];
      strcpy(sC_Stk3,Clean(Stk[3]));
      Use_LineinputKB=Use_SysMacros=TRUE;
      fprintf(FP_WRITE,"%s%s%s%s%s%s\n",Scoot,"mLineInputKB (",Stk[2],", ",sC_Stk3,");");
      return 0;
    }
  Use_NamePathFromFP=Use_BcxTempStr=TRUE;
  strcpy(Stk[2],RemoveStr(Stk[2],"#"));
  if(ISNULL(Stk[2])){
      Abort("Bad LINE INPUT File Handle");
    }
  if(DataType(Stk[2])==vt_NUMBER ){
      strcpy(Stk[2], join(2,"FP",Stk[2]));
    }
  strcpy(L_Handle,extract(Stk[2],"["));
  if(CheckLocal(L_Handle,&(i))==vt_UNKNOWN ){
      if(CheckGlobal(L_Handle,&(i))==vt_UNKNOWN ){
          AddGlobal(L_Handle,vt_FILEPTR);
        }
    }
  strcpy(Var1,Clean(Stk[3]));
  *Var2=0;
  strcpy(CVar,Var1);
  char Optional_Limit[BCXSTRSIZE]={0};
  strcpy(Optional_Limit,mid(Var1,InstrRev(Var1,",")));
  strcpy(Var1,RemoveStr(Var1,Optional_Limit));
  strcpy(CVar,RemoveStr(CVar,Optional_Limit));
  strcpy(Optional_Limit,trim(mid(Optional_Limit,2)));
  if(inchr(Var1,"[")&&inchr(Var1,"]")){
      if(iMatchNQ(Var1,"[++")){
          strcpy(CVar,RemoveStr(CVar,"++"));
        }
      if(iMatchNQ(Var1,"[--")){
          strcpy(CVar,RemoveStr(CVar,"--"));
        }
      if(iMatchNQ(Var1,"++]")){
          strcpy(CVar,RemoveStr(CVar,"++"));
          strcpy(Var2,mid(Var1,inchr(Var1,"[")+1));
          strcpy(Var2,extract(Var2,"]"));
          strcpy(Var1,CVar);
        }
      if(iMatchNQ(Var1,"--]")){
          strcpy(CVar,RemoveStr(CVar,"--"));
          strcpy(Var2,mid(Var1,inchr(Var1,"[")+1));
          strcpy(Var2,extract(Var2,"]"));
          strcpy(Var1,CVar);
        }
    }
  fprintf(FP_WRITE,"%s%s%s\n",Scoot,Var1,"[0]=0;");
  strcpy(Var1,RemoveStr(Var1,"--"));
  strcpy(Var1,RemoveStr(Var1,"++"));
  if(Optional_Limit[0]>0 ){
      fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"fgets(",Var1,", ",Optional_Limit,", ",Clean(Stk[2]),");");
    }
  else
    {
      fprintf(FP_WRITE,"%s%s%s%s% .15G %s%s%s\n",Scoot,"fgets(",Var1,",",(double)BCXSTRSIZE,", ",Clean(Stk[2]),");");
    }
  fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"  if(feof(",Clean(Stk[2]),") || (",Var1,"[strlen(",Var1,")-1]==10))");
  fprintf(FP_WRITE,"%s%s\n",Scoot,"    {");
  fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"     ",Var1,"[strcspn(",Var1,",",enc("\\r\\n"),")] = 0;");
  fprintf(FP_WRITE,"%s%s\n",Scoot,"    }");
  fprintf(FP_WRITE,"%s%s\n",Scoot,"   else");
  fprintf(FP_WRITE,"%s%s\n",Scoot,"    {");
  fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"      printf(",enc("%s%d while reading file: %s\\n"),",",enc("Error! - LINE INPUT truncation detected at PROGRAM line: "),",__LINE__-7, NamePathFromFP(",Clean(Stk[2]),"));");
  fprintf(FP_WRITE,"%s%s%s%s%s%s\n",Scoot,"      printf(",enc("%s\\n"),",",enc("The actual truncated line of text:"),");");
  fprintf(FP_WRITE,"%s%s%s%s%s%s\n",Scoot,"      printf(",enc("%s"),",",Var1,");");
  fprintf(FP_WRITE,"%s%s\n",Scoot,"      exit(1);");
  fprintf(FP_WRITE,"%s%s\n",Scoot,"    }");
  if(Var2[0]!=0 ){
      fprintf(FP_WRITE,"%s%s\n",Var2,";");
    }
  return 0;
}

int Emit_FinputProcs (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  UNREFERENCED_PARAMETER(sWord);
  Emit_FileInputCode();
  return 0;
}

int Emit_GetProcs (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  UNREFERENCED_PARAMETER(sWord);
  int i;
  Use_Get=TRUE;
  Use_SysMacros=TRUE;
  strcpy(Stk[2],RemoveStr(Stk[2],"#"));
  if(ISNULL(Stk[2])){
      Abort("Bad GET$ Argument");
    }
  if(DataType(Stk[2])==vt_NUMBER ){
      strcpy(Stk[2], join(2,"FP",Stk[2]));
    }
  if(CheckLocal(Stk[2],&(i))==vt_UNKNOWN ){
      if(CheckGlobal(Stk[2],&(i))==vt_UNKNOWN ){
          AddGlobal(Stk[2],vt_FILEPTR);
        }
    }
  fprintf(FP_WRITE,"%s%s",Scoot,"GET(");
  strcpy(Stk[++Ndx],");");
  WriteCleanTokens(2,Ndx);
  return 0;
}

int Emit_PutProcs (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  UNREFERENCED_PARAMETER(sWord);
  int i;
  Use_Put=TRUE;
  Use_SysMacros=TRUE;
  strcpy(Stk[2],RemoveStr(Stk[2],"#"));
  if(ISNULL(Stk[2])){
      Abort("Bad PUT$ Argument");
    }
  if(DataType(Stk[2])==vt_NUMBER ){
      strcpy(Stk[2], join(2,"FP",Stk[2]));
    }
  if(CheckLocal(Stk[2],&(i))==vt_UNKNOWN ){
      if(CheckGlobal(Stk[2],&(i))==vt_UNKNOWN ){
          AddGlobal(Stk[2],vt_FILEPTR);
        }
    }
  fprintf(FP_WRITE,"%s%s",Scoot,"PUT(");
  strcpy(Stk[++Ndx],");");
  WriteCleanTokens(2,Ndx);
  return 0;
}

int Emit_FprintProcs (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  UNREFERENCED_PARAMETER(sWord);
  static int i;
  static int j;
  static char LZZ[BCXSTRSIZE];
  char L_Handle[BCXSTRSIZE];
  strcpy(Stk[2],RemoveStr(Stk[2],"#"));
  if(ISNULL(Stk[2])){
      Abort("Bad FPRINT Argument");
    }
  if(DataType(Stk[2])==vt_NUMBER ){
      strcpy(Stk[2], join(2,"FP",Stk[2]));
    }
  if(iMatchWrd(Stk[2],"stderr")){
      strcpy(L_Handle,"stderr");
    }
  else
    {
      if(CheckLocal(Stk[2],&(i))==vt_UNKNOWN ){
          if(CheckGlobal(Stk[2],&(i))==vt_UNKNOWN ){
              AddGlobal(Stk[2],vt_FILEPTR);
            }
        }
      *L_Handle=0;
      for(j=2; j<=Ndx; j++)
        {
          if(*Stk[j]==44||*Stk[j]==59 ){
              *Stk[j]=0;
              goto L1423;
            }
          strcat(L_Handle,Stk[j]);
          *Stk[j]=0;
        }
L1423:;
      strcat(L_Handle,"@");
    }
  *Stk[2]=0;
  *Stk[3]=0;
  strcpy(LZZ, join(2,"f",PrintWriteFormat(0)));
  strcpy(LZZ, join(4,left(LZZ,8),RemoveStr(L_Handle,"@"),",",mid(LZZ,9)));
  fprintf(FP_WRITE,"%s%s\n",Scoot,LZZ);
  return 0;
}

int Emit_SeekProcs (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  UNREFERENCED_PARAMETER(sWord);
  strcpy(Stk[2],RemoveStr(Stk[2],"#"));
  if(ISNULL(Stk[2])){
      Abort("Bad SEEK Argument");
    }
  char Origin[BCXSTRSIZE]={0};
  if(strcmp(ucase(Stk[Ndx]),"SEEK_CUR")==0  || strcmp(ucase(Stk[Ndx]),"SEEK_END")==0  || strcmp(ucase(Stk[Ndx]),"SEEK_SET")==0){
      strcpy(Origin,ucase(Stk[Ndx]));
      Ndx-=(2);
    }
  else
    {
      strcpy(Origin,"SEEK_SET");
    }
  if(DataType(Stk[2])==vt_NUMBER ){
      strcpy(Stk[2], join(2,"FP",Stk[2]));
    }
  int i={0};
  if(CheckLocal(Stk[2],&(i))==vt_UNKNOWN ){
      AddGlobal(Stk[2],vt_FILEPTR);
    }
  fprintf(FP_WRITE,"%s%s",Scoot,"_fseeki64(");
  strcpy(Stk[++Ndx], join(3,",",Origin,");"));
  WriteCleanTokens(2,Ndx);
  return 0;
}

int Emit_SetEofProcs (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  UNREFERENCED_PARAMETER(sWord);
  Use_SysMacros=Use_Seteof=TRUE;
  int i;
  for(i=2; i<=Ndx; i++)
    {
      strcpy(Stk[i],RemoveStr(Stk[i],"#"));
    }
  if(strcmp(Stk[2],"(")==0){
      strcpy(Stk[2],Stk[3]);
    }
  if(DataType(Stk[2])==vt_NUMBER ){
      strcpy(Stk[2], join(2,"FP",Stk[2]));
    }
  if(CheckLocal(Stk[2],&(i))==vt_UNKNOWN ){
      AddGlobal(Stk[2],vt_FILEPTR);
    }
  fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"SetEof(",Stk[2],");");
  return 0;
}

int Emit_FwriteProcs (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  UNREFERENCED_PARAMETER(sWord);
  int i;
  char LZZ[BCXSTRSIZE];
  char L_Handle[BCXSTRSIZE];
  strcpy(Stk[2],RemoveStr(Stk[2],"#"));
  if(ISNULL(Stk[2])){
      Abort("Bad WRITE Argument");
    }
  if(DataType(Stk[2])==vt_NUMBER ){
      strcpy(Stk[2], join(2,"FP",Stk[2]));
    }
  if(CheckLocal(Stk[2],&(i))==vt_UNKNOWN ){
      AddGlobal(Stk[2],vt_FILEPTR);
    }
  *L_Handle=0;
  for(int j=2; j<=Ndx; j++)
    {
      if(iMatchWrd(Stk[j],",")||iMatchWrd(Stk[j],";")){
          *Stk[j]=0;
          goto L1426;
        }
      strcat(L_Handle,Stk[j]);
      *Stk[j]=0;
    }
L1426:;
  strcat(L_Handle,"@");
  strcpy(LZZ, join(2,"f",PrintWriteFormat(1)));
  strcpy(LZZ, join(4,left(LZZ,8),Clean(L_Handle),",",mid(LZZ,9)));
  fprintf(FP_WRITE,"%s%s\n",Scoot,LZZ);
  return 0;
}

int Emit_StringProcs (char* sWord,PINT  FuncRetnFlag)
{
  if(strcmp(sWord,"midstr")==0){
      *Src=0;
      for(int A=1; A<=Ndx; A++)
        {
          strcat(Src,Clean(Stk[A]));
        }
      fprintf(FP_WRITE,"%s%s%s\n",Scoot,trim(Src),";");
    }
  else
    {
      Emit_Old(FuncRetnFlag);
    }
  return 0;
}

int Emit_MathProcs (char* sWord,PINT  FuncRetnFlag)
{
  if(strcmp(sWord,"incr")==0){
      int j={0};
      fprintf(FP_WRITE,"%s",Scoot);
      for(int i=2; i<=Ndx; i++)
        {
          if(*Stk[i]==44 ){
              fprintf(FP_WRITE,"%s","+=(");
              j=TRUE;
            }
          else
            {
              fprintf(FP_WRITE,"%s",Clean(Stk[i]));
            }
        }
      fprintf(FP_WRITE,"%s\n",sziif(j,");","++;"));
      goto L1429;
    }
  if(strcmp(sWord,"decr")==0){
      int j={0};
      fprintf(FP_WRITE,"%s",Scoot);
      for(int i=2; i<=Ndx; i++)
        {
          if(*Stk[i]==44 ){
              fprintf(FP_WRITE,"%s","-=(");
              j=TRUE;
            }
          else
            {
              fprintf(FP_WRITE,"%s",Clean(Stk[i]));
            }
        }
      fprintf(FP_WRITE,"%s\n",sziif(j,");","--;"));
    }
  else
    {
      Emit_Old(FuncRetnFlag);
    }
L1429:;
  return 0;
}

int Emit_ConsoleOnlyProcs (char* sWord,PINT  FuncRetnFlag)
{
  if(strcmp(sWord,"print")==0){
      fprintf(FP_WRITE,"%s%s\n",Scoot,PrintWriteFormat(0));
      goto L1432;
    }
  if(strcmp(sWord,"locate")==0){
      if(NoMain==TRUE||MakeDLL==TRUE ){
          Use_Console=TRUE;
        }
      fprintf(FP_WRITE,"%s%s",Scoot,"locate (");
      strcpy(Stk[++Ndx],");");
      WriteCleanTokens(2,Ndx);
      goto L1432;
    }
  if(strcmp(sWord,"panel")==0){
      if(NoMain==TRUE||MakeDLL==TRUE ){
          Use_Console=TRUE;
        }
      fprintf(FP_WRITE,"%s%s",Scoot,"panel (");
      strcpy(Stk[++Ndx],");");
      WriteCleanTokens(2,Ndx);
      goto L1432;
    }
  if(strcmp(sWord,"cls")==0){
      if(NoMain==TRUE||MakeDLL==TRUE ){
          Use_Console=TRUE;
        }
      fprintf(FP_WRITE,"%s%s\n",Scoot,"cls();");
      goto L1432;
    }
  if(strcmp(sWord,"color")==0){
      if(NoMain==TRUE||MakeDLL==TRUE ){
          Use_Console=TRUE;
        }
      fprintf(FP_WRITE,"%s%s",Scoot,"color (");
      strcpy(Stk[++Ndx],");");
      WriteCleanTokens(2,Ndx);
      goto L1432;
    }
  if(strcmp(sWord,"textmode")==0){
      char LTmp[BCXSTRSIZE];
      BuildCleanStr(2,Ndx,LTmp);
      fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"TextMode(",LTmp,");");
      goto L1432;
    }
  if(strcmp(sWord,"delay")==0){
      char LTmp[BCXSTRSIZE];
      BuildCleanStr(2,Ndx,LTmp);
      fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"Sleep(1000*",LTmp,");");
      goto L1432;
    }
  if(strcmp(sWord,"write")==0){
      fprintf(FP_WRITE,"%s%s\n",Scoot,PrintWriteFormat(1));
    }
  else
    {
      Emit_Old(FuncRetnFlag);
    }
L1432:;
  return 0;
}

int ValidExitStatement ()
{
  char RightTerm[BCXSTRSIZE]={0};
  strcpy(RightTerm,lcase(Stk[2]));
  if(strcmp(RightTerm,"sub")==0  || strcmp(RightTerm,"function")==0  || strcmp(RightTerm,"for")==0  || strcmp(RightTerm,"xfor")==0  || strcmp(RightTerm,"do")==0  || strcmp(RightTerm,"while")==0  || strcmp(RightTerm,"select")==0  || strcmp(RightTerm,"nest")==0  || strcmp(RightTerm,"loop")==0  || strcmp(RightTerm,"repeat")==0){
      return TRUE;
    }
  return FALSE;
}

int IsQuoted (char *A)
{
  int ArgLen=(int)strlen(A);
  if(ArgLen<2 ){
      return 0;
    }
  if(A[0]==34&&A[ArgLen-1]==34 ){
      return 1;
    }
  else
    {
      return 0;
    }
}

int Emit_ControlFlow (char* sWord,PINT  FuncRetnFlag)
{
  static int  iFallThrough;
  if(strcmp(sWord,"exit")==0){
      if(ValidExitStatement()==FALSE ){
          Abort("Expected to find EXIT: sub|function|for|xfor|do|while|select|nest|loop|repeat");
        }
      if(SelectState[StateIdx].CaseFlag ){
          SelectState[StateIdx].NoBreak=TRUE;
        }
      char szL_Stk2[BCXSTRSIZE]={0};
      int iLoops1={0};
      int iLoops2={0};
      for(iLoops1=2; iLoops1<=Ndx; iLoops1++)
        {
          if(*Stk[iLoops1]==44 ){
              continue;
            }
          strcpy(szL_Stk2,lcase(Stk[iLoops1]));
          if(strcmp(szL_Stk2,"sub")==0){
              if(COM_lc_names_index>0 ){
                  BCX_FreeLocalCOMObjects(FALSE);
                }
              if(NOTZERO(LocalDynaCnt)){
                  for(int j=1; j<=LocalDynaCnt; j++)
                    {
                      fprintf(FP_WRITE,"%s%s\n",Scoot,DynaStr[j]);
                    }
                }
              if(NOTZERO(LocalDynArrCnt)){
                  for(int i=1; i<=LocalDynArrCnt; i++)
                    {
                      fprintf(FP_WRITE,"%s%s\n",Scoot,LocalDynArrName[i]);
                    }
                }
              fprintf(FP_WRITE,"%s%s\n",Scoot,"return;");
              goto L1436;
            }
          if(strcmp(szL_Stk2,"function")==0){
              if(NOTZERO(LocalDynaCnt)){
                  for(int j=1; j<=LocalDynaCnt; j++)
                    {
                      fprintf(FP_WRITE,"%s%s\n",Scoot,DynaStr[j]);
                    }
                }
              if(NOTZERO(LocalDynArrCnt)){
                  for(int i=1; i<=LocalDynArrCnt; i++)
                    {
                      fprintf(FP_WRITE,"%s%s\n",Scoot,LocalDynArrName[i]);
                    }
                }
              fprintf(FP_WRITE,"%s%s\n",Scoot,"return 0;");
              goto L1436;
            }
          if(strcmp(szL_Stk2,"for")==0){
              static char LszTmp[BCXSTRSIZE];
              static int i;
              for(i=LoopTypeCnt-iLoops2; !(LoopType[i].iLoopType==lt_FORNEXT||i==0);i--)
                {
                }
              if(i ){
                  if(i!=LoopTypeCnt-iLoops2 ){
                      if(TestState ){
                          Warning_ID(eExitingMoreThan1Loop,1);
                        }
                    }
                  iLoops2=LoopTypeCnt-i+1;
                  if(iLoops1==Ndx ){
                      DoGoto(i,1);
                    }
                }
              else
                {
                  strcpy(LszTmp,"No FOR to exit from. Inner most loop is ");
                  strcat(LszTmp,LoopTypeName(LoopType[LoopTypeCnt].iLoopType));
                  Abort(LszTmp);
                }
              goto L1436;
            }
          if(strcmp(szL_Stk2,"xfor")==0){
              static char LszTmp[BCXSTRSIZE];
              static int i;
              for(i=LoopTypeCnt-iLoops2; !(LoopType[i].iLoopType==lt_FORXNEXT||i==0);i--)
                {
                }
              if(i ){
                  if(i!=LoopTypeCnt-iLoops2 ){
                      if(TestState ){
                          Warning_ID(eExitingMoreThan1Loop,1);
                        }
                    }
                  iLoops2=LoopTypeCnt-i+1;
                  if(iLoops1==Ndx ){
                      DoGoto(i,1);
                    }
                }
              else
                {
                  strcpy(LszTmp,"No XFOR to exit from. Inner most loop is ");
                  strcat(LszTmp,LoopTypeName(LoopType[LoopTypeCnt].iLoopType));
                  Abort(LszTmp);
                }
              goto L1436;
            }
          if(strcmp(szL_Stk2,"do")==0){
              static char LszTmp[BCXSTRSIZE];
              static int i;
              for(i=LoopTypeCnt-iLoops2; !(LoopType[i].iLoopType==lt_DOLOOP||LoopType[i].iLoopType==lt_DOUNTILLOOP||LoopType[i].iLoopType==lt_DOWHILELOOP||i==0);i--)
                {
                }
              if(i ){
                  if(i!=LoopTypeCnt-iLoops2 ){
                      if(TestState ){
                          Warning_ID(eExitingMoreThan1Loop,1);
                        }
                    }
                  iLoops2=LoopTypeCnt-i+1;
                  if(iLoops1==Ndx ){
                      DoGoto(i,1);
                    }
                }
              else
                {
                  strcpy(LszTmp,"No DO to exit from. Inner most loop is ");
                  strcat(LszTmp,LoopTypeName(LoopType[LoopTypeCnt].iLoopType));
                  Abort(LszTmp);
                }
              goto L1436;
            }
          if(strcmp(szL_Stk2,"while")==0){
              static char LszTmp[BCXSTRSIZE];
              static int i;
              for(i=LoopTypeCnt-iLoops2; !(LoopType[i].iLoopType==lt_WHILEWEND||i==0);i--)
                {
                }
              if(i ){
                  if(i!=LoopTypeCnt-iLoops2 ){
                      if(TestState ){
                          Warning_ID(eExitingMoreThan1Loop,1);
                        }
                    }
                  iLoops2=LoopTypeCnt-i+1;
                  if(iLoops1==Ndx ){
                      DoGoto(i,1);
                    }
                }
              else
                {
                  strcpy(LszTmp,"No WHILE to exit from. Inner most loop is ");
                  strcat(LszTmp,LoopTypeName(LoopType[LoopTypeCnt].iLoopType));
                  Abort(LszTmp);
                }
              goto L1436;
            }
          if(strcmp(szL_Stk2,"select")==0){
              static char LszTmp[BCXSTRSIZE];
              static int i;
              for(i=LoopTypeCnt-iLoops2; !(LoopType[i].iLoopType==lt_SELECT||i==0);i--)
                {
                }
              if(i ){
                  if(i!=LoopTypeCnt-iLoops2 ){
                      if(TestState ){
                          Warning_ID(eExitingMoreThan1Loop,1);
                        }
                    }
                  iLoops2=LoopTypeCnt-i+1;
                  if(iLoops1==Ndx ){
                      DoGoto(i,1);
                      SelectState[StateIdx].CaseFlag++;
                    }
                }
              else
                {
                  strcpy(LszTmp,"No SELECT to exit from. Inner most loop is ");
                  strcat(LszTmp,LoopTypeName(LoopType[LoopTypeCnt].iLoopType));
                  Abort(LszTmp);
                }
              goto L1436;
            }
          if(strcmp(szL_Stk2,"nest")==0){
              static char LszTmp[BCXSTRSIZE];
              static int i;
              if(LoopTypeCnt==0 ){
                  Abort("Too many end loops");
                }
              for(i=LoopTypeCnt-iLoops2; !(LoopType[i].iLoopType!=LoopType[LoopTypeCnt-iLoops2].iLoopType);i--)
                {
                }
              strcpy(LszTmp,"Exiting from nested control loops. Outer to inner control loops are ");
              strcat(LszTmp,LoopTypeName(LoopType[LoopTypeCnt].iLoopType));
              if(TestState ){
                  Warning(LszTmp,1);
                }
              i++;
              iLoops2=LoopTypeCnt-i+1;
              if(iLoops1==Ndx ){
                  DoGoto(i,1);
                }
            }
          else
            {
              static char LszTmp[BCXSTRSIZE];
              strcpy(LszTmp,"Exiting from a misnamed or unnamed control loop.  Expected: EXIT ");
              strcat(LszTmp,LoopTypeName(LoopType[LoopTypeCnt].iLoopType));
              if(TestState ){
                  Warning(LszTmp,1);
                }
              if(iLoops1==Ndx ){
                  DoGoto(LoopTypeCnt-iLoops2,1);
                }
              iLoops2++;
            }
L1436:;
        }
      goto L1434;
    }
  if(strcmp(sWord,"repeat")==0){
      char LTmp[BCXSTRSIZE]={0};
      for(int i=2; i<=Ndx; i++)
        {
          strcat(LTmp,Stk[i]);
        }
      strcpy(LTmp,Clean(LTmp));
      BumpUp();
      if(inchr(Stk[2],"-")){
          if(LeftStr(LTmp,"-")){
              strcpy(LTmp,mid(LTmp,2));
            }
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"for(int BCX_REPEAT = ",LTmp,"; BCX_REPEAT >= 1; BCX_REPEAT--)");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"{");
        }
      else
        {
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"for(int BCX_REPEAT = 1; BCX_REPEAT <= ",LTmp,"; BCX_REPEAT++)");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"{");
        }
      BumpUp();
      goto L1434;
    }
  if(strcmp(sWord,"endrepeat")==0){
      BumpDown("Too many unindents in REPEAT/END REPEAT");
      fprintf(FP_WRITE,"%s%s\n",Scoot,"}");
      BumpDown("Too many unindents in REPEAT/END REPEAT");
      goto L1434;
    }
  if(strcmp(sWord,"while")==0){
      Emit_IfCond("while",eFull);
      if(iDoWhile ){
          LoopType[++LoopTypeCnt].iLoopType=iDoWhile;
        }
      else
        {
          LoopType[++LoopTypeCnt].iLoopType=lt_WHILEWEND;
        }
      LoopType[LoopTypeCnt].iJumpTo=LabelGenerator++;
      *LoopType[LoopTypeCnt].szUseNeedLabel=0;
      iDoWhile=0;
      LoopType[LoopTypeCnt].iLoopLine=LineNum[FileNdx];
      InBlockSet();
      goto L1434;
    }
  if(strcmp(sWord,"wend")==0  || strcmp(sWord,"endwhile")==0){
      InBlockReSet();
      if(LoopTypeCnt==0 ){
          Abort("Too many end loops");
        }
      if(LoopType[LoopTypeCnt].iLoopType!=lt_WHILEWEND ){
          char sErr[BCXSTRSIZE];
          strcpy(sErr, join(4,LoopTypeName(LoopType[LoopTypeCnt].iLoopType)," at",str(LoopType[LoopTypeCnt].iLoopLine)," closed with WEND"));
          Abort(sErr);
        }
      BumpDown("Error in Emit_ControlFlow() CASE wend, endwhile");
      fprintf(FP_WRITE,"%s%s\n",Scoot,"}");
      if(LoopType[LoopTypeCnt].szUseNeedLabel[0]>0 ){
          fprintf(FP_WRITE,"%s\n",LoopType[LoopTypeCnt].szUseNeedLabel);
        }
      LoopTypeCnt--;
      BumpDown("Unbalanced LOOP");
      goto L1434;
    }
  if(strcmp(sWord,"prepend")==0){
      PrependCnt++;
      if(PrependCnt==cPrependVarSize ){
          Abort("Prepend depth exceeded");
        }
      BuildDelimStr(2,Ndx,PrependVar[PrependCnt]);
      goto L1434;
    }
  if(strcmp(sWord,"endprepend")==0){
      PrependCnt--;
      if(PrependCnt<0 ){
          Abort("Too many END PREPENDs.");
        }
      goto L1434;
    }
  if(strcmp(sWord,"with")==0){
      WithCnt++;
      if(WithCnt==cWithVarSize ){
          Abort("[With] depth exceeded");
        }
      BuildStr(2,Ndx,WithVar[WithCnt]);
      goto L1434;
    }
  if(strcmp(sWord,"endwith")==0){
      if(COM_open_WITH_statement ){
          if(COM_open_WITH_statement>1 ){
              fprintf(FP_WRITE,"%s%s\n",Scoot,"COM_dispatch_storage_index--;");
              fprintf(FP_WRITE,"%s%s\n",Scoot,"COM_dispatch_at_offset = COM_dispatch_storage[COM_dispatch_storage_index];");
            }
          else
            {
              fprintf(FP_WRITE,"%s%s\n",Scoot,"COM_dispatch_at_offset = 0;");
              fprintf(FP_WRITE,"%s%s\n",Scoot,"COM_dispatch_storage_index = 0;");
            }
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"COM_reset_disp_chain(&",COM_with_temp_str_name,");");
          COM_open_WITH_statement--;
        }
      else
        {
          WithCnt--;
        }
      goto L1434;
    }
  if(strcmp(sWord,"goto")==0){
      if(SelectState[StateIdx].CaseFlag ){
          SelectState[StateIdx].NoBreak=TRUE;
        }
      fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"goto ",ucase(Stk[2]),";");
      goto L1434;
    }
  if(strcmp(sWord,"gosub")==0){
      Use_GoSub=TRUE;
      fprintf(FP_WRITE,"%s%s",Scoot,"if (setjmp(GosubStack[GosubNdx++])==0)");
      fprintf(FP_WRITE,"%s%s%s\n"," goto ",ucase(Stk[2]),";");
      goto L1434;
    }
  if(strcmp(sWord,"return")==0){
      if(Ndx>1 ){
          char Convert[BCXSTRSIZE]={0};
          strcpy(Convert,"FUNCTION = ");
          for(int i=2; i<=Ndx; i++)
            {
              strcat(Convert,Stk[i]);
              strcat(Convert,SPC);
            }
          Inject(Convert);
          return 0;
        }
      else
        {
          Use_GoSub=TRUE;
          fprintf(FP_WRITE,"%s%s\n",Scoot,"longjmp (GosubStack [--GosubNdx],1);");
          fprintf(FP_WRITE,"%s\n","");
        }
      goto L1434;
    }
  if(strcmp(sWord,"fallthrough")==0){
      iFallThrough=TRUE;
      goto L1434;
    }
  if(strcmp(sWord,"case")==0){
      if(SelectState[StateIdx].iStartCase==0 ){
          InBlockReSet();
        }
      SelectState[StateIdx].iStartCase=0;
      InBlockSet();
      for(int i=2; i<=Ndx; i++)
        {
          if(strcmp(Stk[i],"!=")==0){
              strcpy(Stk[i],"<>");
            }
          if(*Stk[i]==37 ){
              strcpy(Stk[i]," % ");
            }
          if(*Stk[i]==33&&*Stk[i+1]==61 ){
              strcpy(Stk[i],"<>");
              *Stk[i+1]=0;
            }
          if(*Stk[i]==60&&*Stk[i+1]==62 ){
              strcpy(Stk[i],"<>");
              *Stk[i+1]=0;
            }
          if(*Stk[i]==61&&*Stk[i+1]==60 ){
              strcpy(Stk[i],"<=");
              *Stk[i+1]=0;
            }
          if(*Stk[i]==60&&*Stk[i+1]==61 ){
              strcpy(Stk[i],"<=");
              *Stk[i+1]=0;
            }
          if(*Stk[i]==61&&*Stk[i+1]==62 ){
              strcpy(Stk[i],">=");
              *Stk[i+1]=0;
            }
          if(*Stk[i]==62&&*Stk[i+1]==61 ){
              strcpy(Stk[i],">=");
              *Stk[i+1]=0;
            }
          if(isalpha(*Stk[i])){
              strcpy(Stk[i], join(2,Stk[i],SPC));
            }
        }
      *gTmpStr=0;
      For_Next_Error_Detected=FALSE;
      if(DataType(CaseVar)==vt_STRVAR ){
          For_Next_Error_Detected=TRUE;
        }
      int ss={0};
      int idx={0};
      if(CheckLocal(CaseVar,&(idx))==vt_CHAR ){
          ss=TRUE;
        }
      if(CheckLocal(CaseVar,&(idx))==vt_SCHAR ){
          ss=TRUE;
        }
      if(CheckGlobal(CaseVar,&(idx))==vt_CHAR ){
          ss=TRUE;
        }
      if(CheckGlobal(CaseVar,&(idx))==vt_SCHAR ){
          ss=TRUE;
        }
      if(CheckLocal(CaseVar,&(idx))==vt_STRVAR ){
          ss=TRUE;
        }
      if(CheckGlobal(CaseVar,&(idx))==vt_STRVAR ){
          ss=TRUE;
        }
      if(ss==TRUE ){
          strcat(CaseVar,"$");
        }
      int i={0};
      for(int A=2; A<=Ndx; A++)
        {
          if(inchr("([",Stk[A])){
              i++;
            }
          if(inchr(")]",Stk[A])){
              i--;
            }
          if(i ){
              strcat(gTmpStr,Stk[A]);
              continue;
            }
          if(strcmp(Stk[A],",")==0){
              if(!inchr("<>=",Stk[A+1])){
                  strcpy(gTmpStr, join(4,gTmpStr," or ",CaseVar,"="));
                }
              else
                {
                  strcpy(gTmpStr, join(3,gTmpStr," or ",CaseVar));
                }
              *Stk[A]=0;
              continue;
            }
          if(strcmp(Stk[A],"&&")==0){
              strcpy(gTmpStr, join(3,gTmpStr," and ",CaseVar));
              *Stk[A]=0;
            }
          else if(strcmp(Stk[A],"||")==0){
              strcpy(gTmpStr, join(3,gTmpStr," or ",CaseVar));
              *Stk[A]=0;
            }
          else
            {
              strcat(gTmpStr,Stk[A]);
            }
        }
      char szDrop[BCXSTRSIZE]={0};
      if(SelectState[StateIdx].CaseFlag==0 ){
          SelectState[StateIdx].NoBreak=0;
        }
      if(SelectState[StateIdx].CaseFlag ){
          char LszTmp[BCXSTRSIZE]={0};
          if(iFallThrough==FALSE ){
              SelectState[StateIdx].CaseFlag--;
              if(SelectState[StateIdx].NoBreak==0 ){
                  if(SelectState[StateIdx].NoBreak==0 ){
                      SelectState[StateIdx].CaseFlag++;
                      sprintf(LszTmp,"goto L%i;",SelectState[StateIdx].iJumpTo);
                      fprintf(FP_WRITE,"%s%s\n",Scoot,LszTmp);
                    }
                }
            }
          else
            {
              sprintf(szDrop,"L%i",LabelGenerator);
              sprintf(LszTmp,"goto L%i;",LabelGenerator++);
              strcat(szDrop,":");
              fprintf(FP_WRITE,"%s%s\n",Scoot,LszTmp);
              SelectState[StateIdx].CaseFlag--;
            }
          BumpDown("Unbalanced SELECT");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"}");
          BumpDown("Unbalanced SELECT");
        }
      SelectState[StateIdx].CaseFlag++;
      if(iMatchLft(CaseVar," BAND ")){
          SelectState[StateIdx].NoBreak=1;
          strcpy(Src, join(4,"IF ",gTmpStr,CaseVar," Then "));
        }
      else
        {
          if(inchr("<>=",gTmpStr)&&!IsQuoted(gTmpStr)){
              strcpy(Src, join(4,"IF ",CaseVar,gTmpStr," Then "));
            }
          else
            {
              strcpy(Src, join(5,"IF ",CaseVar," = ",gTmpStr," Then "));
            }
        }
      Inject(Src);
      if(iFallThrough ){
          Inject(szDrop);
        }
      iFallThrough=FALSE;
      goto L1434;
    }
  if(strcmp(sWord,"select")==0){
      LoopType[++LoopTypeCnt].iLoopType=lt_SELECT;
      LoopType[LoopTypeCnt].iJumpTo=LabelGenerator++;
      DoGoto(LoopTypeCnt,0);
      LoopType[LoopTypeCnt].iLoopLine=LineNum[FileNdx];
      BuildStr(3,Ndx,CaseVar);
      PushSelectState(CaseVar);
      SelectState[StateIdx].iStartCase=1;
      SelectState[StateIdx].CaseFlag=0;
      SelectState[StateIdx].iJumpTo=LoopType[LoopTypeCnt].iJumpTo;
      iFallThrough=FALSE;
      goto L1434;
    }
  if(strcmp(sWord,"caseelse")==0){
      if(SelectState[StateIdx].iStartCase==0 ){
          InBlockReSet();
        }
      InBlockSet();
      SelectState[StateIdx].iStartCase=0;
      SelectState[StateIdx].CaseElseFlag=TRUE;
      if(SelectState[StateIdx].CaseFlag ){
          BumpDown("Unbalanced SELECT");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"}");
          BumpDown("Unbalanced SELECT");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"else");
          BumpUp();
          fprintf(FP_WRITE,"%s%s\n",Scoot,"{");
          BumpUp();
        }
      goto L1434;
    }
  if(strcmp(sWord,"endselect")==0){
      if(SelectState[StateIdx].iStartCase==0 ){
          InBlockReSet();
        }
      if(LoopTypeCnt==0 ){
          Abort("Too many end loops");
        }
      if(LoopType[LoopTypeCnt--].iLoopType!=lt_SELECT ){
          static char sErr[BCXSTRSIZE];
          strcpy(sErr, join(4,LoopTypeName(LoopType[LoopTypeCnt+1].iLoopType)," at",str(LoopType[LoopTypeCnt+1].iLoopLine)," closed with END SELECT"));
          Abort(sErr);
        }
      if(SelectState[StateIdx].CaseFlag==0 ){
          if(SelectState[StateIdx].CaseElseFlag==0 ){
              Abort("Missing case statement before select end");
            }
          else
            {
              Abort("Missing case statement before case else");
            }
        }
      BumpDown("Unbalanced SELECT");
      fprintf(FP_WRITE,"%s%s\n",Scoot,"}");
      BumpDown("Unbalanced SELECT");
      if(SelectState[StateIdx].CaseFlag>1 ){
          static char LszTmp[BCXSTRSIZE];
          sprintf(LszTmp,"L%i:;",SelectState[StateIdx].iJumpTo);
          fprintf(FP_WRITE,"%s\n",LszTmp);
        }
      SelectState[StateIdx].NoBreak=SelectState[StateIdx].CaseElseFlag=0;
      PopSelectState(CaseVar);
      goto L1434;
    }
  if(strcmp(sWord,"for")==0){
      if(iMatchWrd(Stk[2],"each")){
          char foreachlocal[BCXSTRSIZE];
          char temp_parms[BCXSTRSIZE];
          char ComVar[BCXSTRSIZE];
          strcpy(ComVar,Stk[3]);
          Use_COM_Collections=Use_COM=ComSwitchON=TRUE;
          fprintf(FP_WRITE,"%s%s\n",Scoot," VariantClear(&COM_ack_var);");
          fprintf(FP_WRITE,"%s%s\n",Scoot," COM_enum_var = NULL;");
          fprintf(FP_WRITE,"%s%s\n",Scoot," COM_long_coll = 0;");
          if(!IsVariableComObject(ComVar)){
              fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"OBJECT ",ComVar,";");
            }
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"ZeroMemory((PVOID)&",ComVar,",sizeof(OBJECT));");
          LoopLocalVar[LoopLocalCnt++]=0;
          COM_FOREACH_enumerator=TRUE;
          strcpy(foreachlocal,mid(Src,instr(Src," in ",1,1)+3));
          if(!IsVariableComObject(ComVar)){
              Add_COM_Local_Variable(ComVar);
            }
          if(inchr(foreachlocal,".")){
              COM_Parse_GetProperty("COM_ack_var",foreachlocal);
              strcpy(temp_parms,trim(extract(foreachlocal,".")));
            }
          else
            {
              strcpy(temp_parms,trim(foreachlocal));
            }
          COM_FOREACH_enumerator=FALSE;
          fprintf(FP_WRITE,"%s%s\n",Scoot,"COM_GetEnum_iface = TRUE;");
          fprintf(FP_WRITE,"%s%s%s%s%s%s\n",Scoot,"COM_invoke(&",temp_parms,", L",DDQ,",");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"DISPATCH_PROPERTYGET|DISPATCH_METHOD, &COM_ack_var);");
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"COM_reset_disp_chain(&",temp_parms,");");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"COM_GetEnum_iface = FALSE;\n");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"for(;;) { // for each construction ...");
          BumpUp();
          fprintf(FP_WRITE,"%s%s\n",Scoot,"if (FAILED(COM_last_HR)) {");
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  COM_HR_ErrMsg (COM_last_HR,_T(",enc("Get object enumerator: No Collections!"),"));");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"  break;");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"} ");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"if (COM_ack_var.vt != VT_DISPATCH && COM_ack_var.vt != VT_UNKNOWN) {");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"  COM_last_HR = E_NOINTERFACE;");
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  COM_HR_ErrMsg (COM_last_HR,_T(",enc("Enum interface not available! Collections unavailable!"),"));");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"  VariantClear(&COM_ack_var);");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"  break;");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"} ");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"if (COM_ack_var.vt == VT_DISPATCH) {");
          BumpUp();
          fprintf(FP_WRITE,"%s%s\n",Scoot,"  #ifdef __cplusplus");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"  COM_last_HR = COM_ack_var.pdispVal");
          fprintf(FP_WRITE,"%s%s\n",Scoot," ->QueryInterface(IID_IEnumVARIANT, (void **)&COM_enum_var);");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"  #else");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"   COM_last_HR = COM_ack_var.pdispVal->lpVtbl");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"  ->QueryInterface(COM_ack_var.pdispVal,");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"   &IID_IEnumVARIANT, (void **)&COM_enum_var);");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"#endif\n");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"if (FAILED(COM_last_HR)) {");
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"   COM_HR_ErrMsg (COM_last_HR,_T(",enc("QueryInterface: Get enum variant: No Collections!"),"));");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"   VariantClear(&COM_ack_var);");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"   break;");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"} ");
          BumpDown("");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"} else if (COM_ack_var.vt == VT_UNKNOWN) {");
          BumpUp();
          fprintf(FP_WRITE,"%s%s\n",Scoot,"  #ifdef __cplusplus");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"    COM_last_HR = COM_ack_var.punkVal");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"    ->QueryInterface(IID_IEnumVARIANT, (void **)&COM_enum_var);");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"  #else");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"    COM_last_HR = COM_ack_var.punkVal->lpVtbl");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"   ->QueryInterface(COM_ack_var.punkVal, ");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"    &IID_IEnumVARIANT, (void **)&COM_enum_var);");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"#endif\n");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"if (FAILED(COM_last_HR)) {");
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  COM_HR_ErrMsg (COM_last_HR,_T(",enc("QueryInterface: Get enum variant: No Collections!"),"));");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"  VariantClear(&COM_ack_var);");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"  break;");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"} ");
          BumpDown("");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"} ");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"VariantClear(&COM_ack_var);");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"break;");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"}\n");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"  while(COM_enum_var) {");
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"    BCX_SetNothing(&",ComVar,");");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"    #ifdef __cplusplus");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"      COM_last_HR = COM_enum_var");
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"    ->Next(1, &",ComVar,".pObjects[0], &COM_long_coll);");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"    #else");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"      COM_last_HR = COM_enum_var->lpVtbl");
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"    ->Next(COM_enum_var, 1, &",ComVar,".pObjects[0], &COM_long_coll);");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"    #endif");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"    if (FAILED(COM_last_HR)) {");
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"      COM_HR_ErrMsg (COM_last_HR,_T(",enc("Enumeration failed! No Collections!"),"));");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"    #ifdef __cplusplus");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"       if(COM_enum_var) COM_enum_var->Release();");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"    #else");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"       if(COM_enum_var) COM_enum_var->lpVtbl");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"      ->Release(COM_enum_var);");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"    #endif");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"    COM_enum_var = NULL;");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"    break;");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"  } ");
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  if (",ComVar,".pObjects[0].vt != VT_DISPATCH)");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"    {");
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"      VariantClear(&",ComVar,".pObjects[0]);");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"      COM_long_coll = 0;");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"    }");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"  else");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"    { ");
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"      ",ComVar,".pStatus = TRUE;");
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"      ",ComVar,".ipointer = 0;");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"      COM_objects_cnt++;");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"    }");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"  if (0 == COM_long_coll) {");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"  #ifdef __cplusplus");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"     if(COM_enum_var) COM_enum_var->Release();");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"  #else");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"     if(COM_enum_var) COM_enum_var->lpVtbl");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"    ->Release(COM_enum_var);");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"  #endif");
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  BCX_SetNothing(&",ComVar,");");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"  COM_enum_var = NULL;");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"  break;");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"  }");
          BumpUp();
        }
      else
        {
          int FFlg={0};
          int For1={0};
          int For2={0};
          int For3={0};
          int For4={0};
          char Reg[BCXSTRSIZE]={0};
          char xxx[BCXSTRSIZE]={0};
          char yyy[BCXSTRSIZE]={0};
          char zzz[BCXSTRSIZE]={0};
          char qqq[BCXSTRSIZE]={0};
          char Lvar[BCXSTRSIZE]={0};
          char Scratch[BCXSTRSIZE]={0};
          *Scratch=0;
          for(long zz=1; zz<=Ndx; zz++)
            {
              strcpy(Scratch, join(3,Scratch,SPC,Stk[zz]));
            }
          strcpy(Scratch,FB2BCX(Scratch));
          FastLexer(Scratch,SPC,"=&()[]{}',+-*/<>?;.|:^");
          for(int i=Ndx; i>=1; i+=-1)
            {
              if(iMatchWrd(Stk[i],"step")){
                  FFlg=TRUE;
                  goto L1452;
                }
            }
L1452:;
          if(!FFlg ){
              Ndx++;
              strcpy(Stk[Ndx],"step");
              Ndx++;
              strcpy(Stk[Ndx],"1");
            }
          For_Next_Error_Detected=FALSE;
          for(int i=1; i<=Ndx; i++)
            {
              if(*Stk[i]==61 ){
                  For_Next_Error_Detected=TRUE;
                }
            }
          if(For_Next_Error_Detected==FALSE ){
              Abort("Missing =");
            }
          For_Next_Error_Detected=FALSE;
          for(int i=1; i<=Ndx; i++)
            {
              if(iMatchWrd(Stk[i],"to")){
                  For_Next_Error_Detected=TRUE;
                }
            }
          if(For_Next_Error_Detected==FALSE ){
              Abort("Missing TO");
            }
          strcpy(Reg,lcase(Stk[2]));
          if(strcmp(Reg,"char")==0  || strcmp(Reg,"sbyte")==0){
              strcpy(Reg,SPC);
              LoopLocalVar[LoopLocalCnt++]=1;
              strcpy(Lvar,"signed char ");
              goto L1455;
            }
          if(strcmp(Reg,"uchar")==0  || strcmp(Reg,"ubyte")==0  || strcmp(Reg,"byte")==0){
              strcpy(Reg,SPC);
              LoopLocalVar[LoopLocalCnt++]=1;
              strcpy(Lvar,"unsigned char ");
              goto L1455;
            }
          if(strcmp(Reg,"int")==0  || strcmp(Reg,"fint")==0){
              strcpy(Reg,SPC);
              LoopLocalVar[LoopLocalCnt++]=1;
              strcpy(Lvar,"int ");
              goto L1455;
            }
          if(strcmp(Reg,"uint")==0){
              strcpy(Reg,SPC);
              LoopLocalVar[LoopLocalCnt++]=1;
              strcpy(Lvar,"unsigned int ");
              goto L1455;
            }
          if(strcmp(Reg,"long")==0){
              strcpy(Reg,SPC);
              LoopLocalVar[LoopLocalCnt++]=1;
              strcpy(Lvar,"long ");
              goto L1455;
            }
          if(strcmp(Reg,"ulong")==0){
              strcpy(Reg,SPC);
              LoopLocalVar[LoopLocalCnt++]=1;
              strcpy(Lvar,"unsigned long ");
              goto L1455;
            }
          if(strcmp(Reg,"llong")==0  || strcmp(Reg,"longlong")==0){
              strcpy(Reg,SPC);
              LoopLocalVar[LoopLocalCnt++]=1;
              strcpy(Lvar,"long long ");
              goto L1455;
            }
          if(strcmp(Reg,"ulonglong")==0  || strcmp(Reg,"uint64")==0){
              strcpy(Reg,SPC);
              LoopLocalVar[LoopLocalCnt++]=1;
              strcpy(Lvar,"unsigned long long ");
              goto L1455;
            }
          if(strcmp(Reg,"short")==0){
              strcpy(Reg,SPC);
              LoopLocalVar[LoopLocalCnt++]=1;
              strcpy(Lvar,"short ");
              goto L1455;
            }
          if(strcmp(Reg,"ushort")==0){
              strcpy(Reg,SPC);
              LoopLocalVar[LoopLocalCnt++]=1;
              strcpy(Lvar,"unsigned short ");
              goto L1455;
            }
          if(strcmp(Reg,"single")==0  || strcmp(Reg,"float")==0){
              strcpy(Reg,SPC);
              LoopLocalVar[LoopLocalCnt++]=1;
              strcpy(Lvar,"float ");
              goto L1455;
            }
          if(strcmp(Reg,"size_t")==0){
              strcpy(Reg,SPC);
              LoopLocalVar[LoopLocalCnt++]=1;
              strcpy(Lvar,"size_t ");
              goto L1455;
            }
          if(strcmp(Reg,"ssize_t")==0){
              strcpy(Reg,SPC);
              LoopLocalVar[LoopLocalCnt++]=1;
              strcpy(Lvar,"SSIZE_T");
              goto L1455;
            }
          if(strcmp(Reg,"int8_t")==0){
              strcpy(Reg,SPC);
              LoopLocalVar[LoopLocalCnt++]=1;
              strcpy(Lvar,"int8_t ");
              goto L1455;
            }
          if(strcmp(Reg,"int16_t")==0){
              strcpy(Reg,SPC);
              LoopLocalVar[LoopLocalCnt++]=1;
              strcpy(Lvar,"int16_t ");
              goto L1455;
            }
          if(strcmp(Reg,"int32_t")==0){
              strcpy(Reg,SPC);
              LoopLocalVar[LoopLocalCnt++]=1;
              strcpy(Lvar,"int32_t ");
              goto L1455;
            }
          if(strcmp(Reg,"int64_t")==0){
              strcpy(Reg,SPC);
              LoopLocalVar[LoopLocalCnt++]=1;
              strcpy(Lvar,"int64_t ");
              goto L1455;
            }
          if(strcmp(Reg,"uint8_t")==0){
              strcpy(Reg,SPC);
              LoopLocalVar[LoopLocalCnt++]=1;
              strcpy(Lvar,"uint8_t ");
              goto L1455;
            }
          if(strcmp(Reg,"uint16_t")==0){
              strcpy(Reg,SPC);
              LoopLocalVar[LoopLocalCnt++]=1;
              strcpy(Lvar,"uint16_t ");
              goto L1455;
            }
          if(strcmp(Reg,"uint32_t")==0){
              strcpy(Reg,SPC);
              LoopLocalVar[LoopLocalCnt++]=1;
              strcpy(Lvar,"uint32_t ");
              goto L1455;
            }
          if(strcmp(Reg,"uint64_t")==0){
              strcpy(Reg,SPC);
              LoopLocalVar[LoopLocalCnt++]=1;
              strcpy(Lvar,"uint64_t ");
              goto L1455;
            }
          if(strcmp(Reg,"double")==0){
              strcpy(Reg,SPC);
              LoopLocalVar[LoopLocalCnt++]=1;
              strcpy(Lvar,"double ");
              goto L1455;
            }
          if(strcmp(Reg,"ldouble")==0){
              strcpy(Reg,SPC);
              LoopLocalVar[LoopLocalCnt++]=1;
              strcpy(Lvar,"long double ");
              Use_Ldouble=TRUE;
            }
          else
            {
              *Reg=0;
              LoopLocalVar[LoopLocalCnt++]=0;
            }
L1455:;
          if(*Reg ){
              for(int j=3; j<=Ndx; j++)
                {
                  strcpy(Stk[j-1],Stk[j]);
                }
              Ndx--;
            }
          for(int i=2; i<=Ndx; i++)
            {
              if(strcmp(Stk[i],"=")==0){
                  For1=i-1;
                  goto L1457;
                }
            }
L1457:;
          for(int i=For1+2; i<=Ndx; i++)
            {
              if(iMatchWrd(Stk[i],"to")){
                  For2=i-1;
                  goto L1458;
                }
            }
L1458:;
          for(int i=For2+2; i<=Ndx; i++)
            {
              if(iMatchWrd(Stk[i],"step")){
                  For3=i-1;
                  goto L1459;
                }
            }
L1459:;
          For4=For3+2;
          BuildCleanStr(2,For1,xxx);
          BuildCleanStr(For1+2,For2,yyy);
          BuildCleanStr(For2+2,For3,zzz);
          BuildCleanStr(For4,Ndx,qqq);
          strcpy(Reg,Lvar);
          if(IsDecimalNumber(qqq)){
              if(LeftStr(qqq,"-")){
                  if(strcmp(qqq,"1")==0){
                      fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s%s%s%s%s%s\n",Scoot,"for(",Reg,xxx,"=",yyy,"; ",xxx,">=",zzz,"; ",xxx,"++)");
                    }
                  else
                    {
                      if(strcmp(qqq,"1")==0){
                          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s%s%s%s%s%s\n",Scoot,"for(",Reg,xxx,"=",yyy,"; ",xxx,">=",zzz,"; ",xxx,"++)");
                        }
                      else
                        {
                          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s\n",Scoot,"for(",Reg,xxx,"=",yyy,"; ",xxx,">=",zzz,"; ",xxx,"+=",qqq,")");
                        }
                    }
                }
              else
                {
                  if(strcmp(qqq,"1")==0){
                      fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s%s%s%s%s%s\n",Scoot,"for(",Reg,xxx,"=",yyy,"; ",xxx,"<=",zzz,"; ",xxx,"++)");
                    }
                  else
                    {
                      fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s\n",Scoot,"for(",Reg,xxx,"=",yyy,"; ",xxx,"<=",zzz,"; ",xxx,"+=",qqq,")");
                    }
                }
            }
          else
            {
              fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s\n",Scoot,"for(",Reg,xxx,"=",yyy,"; (",qqq,">=0 ? ",xxx,"<=",zzz," : ",xxx,">=",zzz,"); ",xxx,"+=",qqq,")");
            }
          BumpUp();
          fprintf(FP_WRITE,"%s%s\n",Scoot,"{");
          BumpUp();
        }
      LoopType[++LoopTypeCnt].iLoopType=lt_FORNEXT;
      LoopType[LoopTypeCnt].iJumpTo=LabelGenerator++;
      *LoopType[LoopTypeCnt].szUseNeedLabel=0;
      LoopType[LoopTypeCnt].iLoopLine=LineNum[FileNdx];
      InBlockSet();
      goto L1434;
    }
  if(strcmp(sWord,"next")==0){
      InBlockReSet();
      if(LoopTypeCnt==0 ){
          Abort("Too many end loops");
        }
      if(LoopType[LoopTypeCnt].iLoopType!=lt_FORNEXT ){
          char sErr[BCXSTRSIZE];
          strcpy(sErr, join(4,LoopTypeName(LoopType[LoopTypeCnt].iLoopType)," at",str(LoopType[LoopTypeCnt].iLoopLine)," closed with NEXT"));
          Abort(sErr);
        }
      BumpDown("Unbalanced FOR/NEXT");
      fprintf(FP_WRITE,"%s%s\n",Scoot,"}");
      LoopLocalVar[LoopLocalCnt]--;
      if(LoopType[LoopTypeCnt].szUseNeedLabel[0]>0 ){
          fprintf(FP_WRITE,"%s\n",LoopType[LoopTypeCnt].szUseNeedLabel);
        }
      LoopTypeCnt--;
      if(LoopLocalCnt<0 ){
          Abort("Next without For");
        }
      BumpDown("Unbalanced FOR/NEXT");
      goto L1434;
    }
  if(strcmp(sWord,"beginblock")==0){
      InBlockSet();
      fprintf(FP_WRITE,"%s%s\n",Scoot,"{");
      BumpUp();
      goto L1434;
    }
  if(strcmp(sWord,"endblock")==0){
      InBlockReSet();
      BumpDown("Unbalanced BLOCK/END BLOCK");
      fprintf(FP_WRITE,"%s%s\n",Scoot,"}");
      goto L1434;
    }
  if(strcmp(sWord,"call")==0){
      static char LTmp[BCXSTRSIZE];
      BuildCleanStr(2,Ndx,LTmp);
      if(!iMatchRgt(LTmp,")")){
          strcat(LTmp,"()");
        }
      strcat(LTmp,";");
      fprintf(FP_WRITE,"%s%s\n",Scoot,LTmp);
      goto L1434;
    }
  if(strcmp(sWord,"continue")==0){
      fprintf(FP_WRITE,"%s%s\n",Scoot,"continue;");
      goto L1434;
    }
  if(strcmp(sWord,"end")==0){
      if(Ndx==1 ){
          InsertTokens(1,2,"=","0");
        }
      if(strcmp(Stk[2],"=")==0){
          if(Use_Wingui==FALSE ){
              fprintf(FP_WRITE,"%s%s\n",Scoot,"fflush(stdout);");
            }
          fprintf(FP_WRITE,"%s%s",Scoot,"ExitProcess(");
          strcpy(Stk[++Ndx],");");
          WriteCleanTokens(3,Ndx);
          goto L1434;
        }
      if(iMatchWrd(Stk[2],"if")){
          BumpDown("Unbalanced IF/END IF");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"}");
          BumpDown("Unbalanced IF/END IF");
          goto L1434;
        }
      goto L1434;
    }
  if(strcmp(sWord,"endif")==0){
      BumpDown("Extra unindents at ENDIF");
      fprintf(FP_WRITE,"%s%s\n",Scoot,"}");
      BumpDown("Extra unindents at ENDIF");
      goto L1434;
    }
  if(strcmp(sWord,"endprogram")==0){
      fprintf(FP_WRITE,"%s\n","");
      if(Use_Sound ){
          fprintf(FP_WRITE,"%s%s\n",Scoot,"midiOutClose (hMidi);");
        }
      fprintf(FP_WRITE,"%s\n","return EXIT_SUCCESS;    // End of main program");
      fprintf(FP_WRITE,"%s\n","}\n\n");
      EndOfProgram=1;
      goto L1434;
    }
  if(strcmp(sWord,"if")==0){
      Emit_IfCond("if",eFull);
      goto L1434;
    }
  if(strcmp(sWord,"else")==0){
      BumpDown("Unbalanced IF/END IF");
      fprintf(FP_WRITE,"%s%s\n",Scoot,"}");
      BumpDown("Unbalanced IF/END IF");
      fprintf(FP_WRITE,"%s%s\n",Scoot,"else");
      BumpUp();
      fprintf(FP_WRITE,"%s%s\n",Scoot,"{");
      BumpUp();
      goto L1434;
    }
  if(strcmp(sWord,"elseif")==0){
      BumpDown("Unbalanced IF/END IF");
      fprintf(FP_WRITE,"%s%s\n",Scoot,"}");
      BumpDown("Unbalanced IF/END IF");
      Emit_IfCond("else if",eFull);
      goto L1434;
    }
  if(strcmp(sWord,"xfor")==0){
      int iBy={0};
      int iUntil={0};
      int iWhile={0};
      static int Ndx2;
      static int iPB;
      static int iLast;
      static char Stak[128][BCXSTRSIZE];
      static char sClose[BCXSTRSIZE];
      static char lszType[BCXSTRSIZE];
      for(int ii=2; ii<=Ndx; ii++)
        {
          if(iMatchWrd(Stk[ii],"while")){
              iWhile=ii;
            }
          if(iMatchWrd(Stk[ii],"until")){
              iUntil=ii;
            }
          if(iMatchWrd(Stk[ii],"by")){
              iBy=ii;
            }
        }
      if(iWhile==0&&iUntil==0 ){
          Abort("Missing WHILE or UNTIL in XFOR");
        }
      if(iWhile&&iUntil ){
          Abort("Can't have both WHILE and UNTIL in XFOR");
        }
      if(iBy==0 ){
          Abort("Missing BY in XFOR");
        }
      iLast=iWhile+iUntil;
      *lszType=0;
      if(iLast>2 ){
          int i=2;
          int j=3;
          for(;;)
            {
              while(strcmp(Stk[j],"=")!=0){
                  j++;
                }
              if(j-i>1 ){
                  if(lszType[0]!=0 ){
                      strcat(lszType,": RAW ");
                    }
                  strcat(lszType,Stk[j-1]);
                  strcat(lszType," AS");
                  while(i<j-1){
                      strcat(lszType,SPC);
                      strcat(lszType,Stk[i]);
                      *Stk[i++]=0;
                    }
                }
              i=j+1;
              iPB=0;
              while(i<=iLast){
                  if(*Stk[i]==40 ){
                      iPB++;
                    }
                  if(*Stk[i]==41 ){
                      iPB--;
                    }
                  if(*Stk[i]==91 ){
                      iPB++;
                    }
                  if(*Stk[i]==93 ){
                      iPB--;
                    }
                  if(iPB==0 && strcmp(Stk[i],",")==0){
                      goto L1464;
                    }
                  i++;
                }
L1464:;
              i++;
              j=i+1;
              if(i>=iLast ){
                  goto L1461;
                }
            }
L1461:;
        }
      strcpy(Stak[1],"for(");
      strcpy(sClose,"; ");
      int jj=2;
      int ii=2;
      while(ii<=Ndx){
          if(*Stk[ii]!=0 ){
              if(iMatchWrd(Stk[ii],"while")){
                  strcpy(Stk[ii],"; ");
                  iLast=jj;
                }
              if(iMatchWrd(Stk[ii],"until")){
                  strcpy(Stk[ii],"; !(");
                  strcpy(sClose,");");
                  iLast=jj;
                }
              if(iMatchWrd(Stk[ii],"by")){
                  strcpy(Stk[ii],sClose);
                  iBy=jj;
                }
              strcpy(Stak[jj],Stk[ii]);
              jj++;
            }
          ii++;
        }
      Ndx2=jj-1;
      if(NOTNULL(lszType)){
          BumpUp();
          fprintf(FP_WRITE,"%s%s\n",Scoot,"{");
          InBlockSet();
          strcpy(lszType, join(2,"RAW ",lszType));
          LoopLocalVar[LoopLocalCnt++]=1;
          ii=iMatchNQ(lszType,": RAW ");
          while(ii){
              strcpy(Src,left(lszType,ii-1));
              strcpy(lszType,mid(lszType,ii+2));
              PassOne=TRUE;
              Inject(Src);
              ii=iMatchNQ(lszType,": RAW ");
            }
          strcpy(Src,lszType);
          PassOne=TRUE;
          Inject(Src);
        }
      else
        {
          LoopLocalVar[LoopLocalCnt++]=0;
        }
      strcpy(Stk[1],"while");
      for(int k=iLast+1; k<=iBy-1; k++)
        {
          strcpy(Stk[k-iLast+1],Stak[k]);
        }
      Ndx=iBy-iLast;
      *Stk[Ndx+1]=0;
      for(int m=1; m<=Ndx; m++)
        {
          if(strcmp(Stk[m],"&&")==0){
              strcpy(Stk[m],"&& ");
            }
        }
      fprintf(FP_WRITE,"%s",Scoot);
      for(int k=1; k<=Ndx2; k++)
        {
          if(k<=iLast||k>=iBy ){
              fprintf(FP_WRITE,"%s",Stak[k]);
            }
          if(k==iLast ){
              Emit_IfCond("while",ePart);
            }
        }
      fprintf(FP_WRITE,"%s\n",")");
      BumpUp();
      fprintf(FP_WRITE,"%s%s\n",Scoot,"{");
      BumpUp();
      LoopType[++LoopTypeCnt].iLoopType=lt_FORXNEXT;
      LoopType[LoopTypeCnt].iJumpTo=LabelGenerator++;
      *LoopType[LoopTypeCnt].szUseNeedLabel=0;
      LoopType[LoopTypeCnt].iLoopLine=LineNum[FileNdx];
      InBlockSet();
      goto L1434;
    }
  if(strcmp(sWord,"xnext")==0){
      InBlockReSet();
      if(LoopTypeCnt==0 ){
          Abort("Too many end loops");
        }
      if(LoopType[LoopTypeCnt].iLoopType!=lt_FORXNEXT ){
          char sErr[BCXSTRSIZE];
          strcpy(sErr, join(4,LoopTypeName(LoopType[LoopTypeCnt].iLoopType)," at",str(LoopType[LoopTypeCnt].iLoopLine)," closed with NEXT"));
          Abort(sErr);
        }
      BumpDown("Unbalanced XFOR/XNEXT");
      fprintf(FP_WRITE,"%s%s\n",Scoot,"}");
      if(NOTZERO(LoopLocalVar[--LoopLocalCnt])){
          InBlockReSet();
          fprintf(FP_WRITE,"%s%s\n",Scoot,"}");
          BumpDown("Unbalanced XFOR/XNEXT");
        }
      if(LoopType[LoopTypeCnt].szUseNeedLabel[0]>0 ){
          fprintf(FP_WRITE,"%s\n",LoopType[LoopTypeCnt].szUseNeedLabel);
        }
      LoopTypeCnt--;
      if(LoopLocalCnt<0 ){
          Abort("XNEXT without XFOR");
        }
      BumpDown("Unbalanced XFOR/XNEXT");
      goto L1434;
    }
  if(strcmp(sWord,"do")==0){
      InBlockSet();
      if(iDoWhile ){
          LoopType[++LoopTypeCnt].iLoopType=iDoWhile;
        }
      else
        {
          LoopType[++LoopTypeCnt].iLoopType=lt_DOLOOP;
        }
      LoopType[LoopTypeCnt].iJumpTo=LabelGenerator++;
      *LoopType[LoopTypeCnt].szUseNeedLabel=0;
      iDoWhile=0;
      LoopType[LoopTypeCnt].iLoopLine=LineNum[FileNdx];
      fprintf(FP_WRITE,"%s%s\n",Scoot,"for(;;)");
      BumpUp();
      fprintf(FP_WRITE,"%s%s\n",Scoot,"{");
      BumpUp();
      goto L1434;
    }
  if(strcmp(sWord,"loop")==0){
      InBlockReSet();
      if(LoopTypeCnt==0 ){
          Abort("Too many end loops");
        }
      if(iLoopCond ){
          if(LoopType[LoopTypeCnt].iLoopType!=lt_DOLOOP ){
              char sErr[BCXSTRSIZE];
              strcpy(sErr, join(4,LoopTypeName(LoopType[LoopTypeCnt].iLoopType)," at",str(LoopType[LoopTypeCnt].iLoopLine)," closed with LOOP CONDITION"));
              Abort(sErr);
            }
        }
      iLoopCond=0;
      BumpDown("Unbalanced DO/LOOP");
      fprintf(FP_WRITE,"%s%s\n",Scoot,"}");
      if(LoopType[LoopTypeCnt].szUseNeedLabel[0]>0 ){
          fprintf(FP_WRITE,"%s\n",LoopType[LoopTypeCnt].szUseNeedLabel);
        }
      LoopTypeCnt--;
      BumpDown("Unbalanced DO/LOOP");
    }
  else
    {
      Emit_Old(FuncRetnFlag);
    }
L1434:;
  return 0;
}

int Emit_KeyboardProcs (char* sWord,PINT  FuncRetnFlag)
{
  if(strcmp(sWord,"input")==0){
      Emit_InputCode();
    }
  else
    {
      Emit_Old(FuncRetnFlag);
    }
  return 0;
}

int Emit_QsortIdxProcs (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(sWord);
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  int i={0};
  char LTmp[BCXSTRSIZE]={0};
  char Stptr[BCXSTRSIZE]={0};
  char StMem[BCXSTRSIZE]={0};
  char StName[BCXSTRSIZE]={0};
  Use_BcxTempStr=TRUE;
  strcpy(Var,Clean(Stk[2]));
  BuildCleanStr(4,Ndx-4,LTmp);
  fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"Key = ",Stk[Ndx],";");
  if(strcmp(Var,"0")!=0){
      fprintf(FP_WRITE,"%s%s\n",Scoot,"int iDx;");
      fprintf(FP_WRITE,"%s%s%s%s",Scoot,"for(iDx=0; iDx<",LTmp,"; iDx += 1) ");
      fprintf(FP_WRITE,"%s%s\n",Var,"[iDx]=iDx;");
    }
  if(!inchr(Stk[Ndx-2],".")){
      Use_Idxqsort=Use_BCX_stricmp=TRUE;
      fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"pppStr = ",Clean(Stk[Ndx-2]),";");
      fprintf(FP_WRITE,"%s%s%s%s%s%s\n",Scoot,"qsort(",Var,",",LTmp,",sizeof(int), IdxCompare);");
    }
  else
    {
      strcpy(StMem,remain(Clean(Stk[Ndx-2]),"."));
      strcpy(Stptr,extract(Stk[Ndx-2],"."));
      if(CheckLocal(Stptr,&(i))!=vt_UNKNOWN ){
          strcpy(StName,TypeDefs[LocalVars[i].VarDef].VarName);
        }
      else
        {
          if(CheckGlobal(Stptr,&(i))!=vt_UNKNOWN ){
              strcpy(StName,TypeDefs[GlobalVars[i].VarDef].VarName);
            }
        }
      if(strcmp(Var,"0")!=0){
          Use_IdxqsortSt=Use_BCX_stricmp=TRUE;
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"cmp1 =(char*)(",Stptr,") + offsetof(",StName,",",StMem,");");
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"StructSize = sizeof(",StName,");");
          fprintf(FP_WRITE,"%s%s%s%s%s%s\n",Scoot,"qsort(",Var,",",LTmp,", sizeof(int), IdxCompareSt);");
        }
      else
        {
          Use_PtrqsortSt=Use_BCX_stricmp=TRUE;
          fprintf(FP_WRITE,"%s%s%s%s%s%s\n",Scoot,"OffSet = offsetof(",StName,",",StMem,");");
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"qsort(",Stptr,",",LTmp,", sizeof(",StName,"), PtrCompareSt);");
        }
    }
  return 0;
}

int Emit_QsortProcs (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(sWord);
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  int iAlphaNumeric=FALSE;
  char LTmp[BCXSTRSIZE];
  int order=0;
  int QST=0;
  int vt;
  Use_BcxTempStr=TRUE;
  if(iMatchWrd(Stk[Ndx],"sensitive")){
      Use_Strqsorts=TRUE;
      Ndx-=(2);
    }
  if(iMatchWrd(Stk[2],"dynamic")){
      QST=TRUE;
      LShiftStk(2);
    }
  if(iMatchWrd(Stk[Ndx],"natural")){
      iAlphaNumeric=Use_AlphaNumeric=TRUE;
      Ndx-=(2);
    }
  if(iMatchWrd(Stk[Ndx],"ascending")){
      order=2;
      Ndx-=(2);
    }
  if(iMatchWrd(Stk[Ndx],"descending")){
      order=1;
      Ndx-=(2);
    }
  if(order==0 ){
      order=2;
    }
  BuildStr(4,Ndx,LTmp);
  strcpy(Var,Clean(Stk[2]));
  vt=DataType(Stk[2]);
  if(vt!=vt_STRVAR&&vt!=vt_INTEGER&&vt!=vt_SINGLE&&vt!=vt_DOUBLE ){
      vt=CheckType(Stk[2]);
    }
  fprintf(FP_WRITE,"%s%s%s%s%s",Scoot,"qsort(",Var,",",Clean(LTmp));
  if(vt==vt_STRVAR ){
      if(!QST ){
          if(order==1 ){
              if(iAlphaNumeric ){
                  fprintf(FP_WRITE,"%s%s%s\n",",sizeof(",Var,"[0]),AlphaNumericD);");
                  Use_AlphaNumericD=TRUE;
                }
              else
                {
                  if(Use_Strqsorts==TRUE ){
                      fprintf(FP_WRITE,"%s%s%s\n",",sizeof(",Var,"[0]),StrCompareDs);");
                      Use_Strqsortds=TRUE;
                      Use_Strqsorts=FALSE;
                    }
                  else
                    {
                      fprintf(FP_WRITE,"%s%s%s\n",",sizeof(",Var,"[0]),StrCompareD);");
                      Use_Strqsortd=Use_BCX_stricmp=TRUE;
                    }
                }
            }
          else
            {
              if(iAlphaNumeric ){
                  fprintf(FP_WRITE,"%s%s%s\n",",sizeof(",Var,"[0]),AlphaNumericA);");
                  Use_AlphaNumericA=TRUE;
                }
              else
                {
                  if(Use_Strqsorts==TRUE ){
                      fprintf(FP_WRITE,"%s%s%s\n",",sizeof(",Var,"[0]),StrCompareAs);");
                      Use_Strqsortas=TRUE;
                      Use_Strqsorts=FALSE;
                    }
                  else
                    {
                      fprintf(FP_WRITE,"%s%s%s\n",",sizeof(",Var,"[0]),StrCompareA);");
                      Use_Strqsorta=Use_BCX_stricmp=TRUE;
                    }
                }
            }
        }
      else
        {
          if(order==1 ){
              if(iAlphaNumeric ){
                  fprintf(FP_WRITE,"%s%s%s\n",",sizeof(",Var,"[0]),DynAlphaNumericD);");
                  Use_DynAlphaNumericD=TRUE;
                }
              else
                {
                  if(Use_Strqsorts==TRUE ){
                      fprintf(FP_WRITE,"%s%s%s\n",",sizeof(",Var,"[0]),DynStrCompareDs);");
                      Use_DynStrqsortds=TRUE;
                      Use_Strqsorts=FALSE;
                    }
                  else
                    {
                      fprintf(FP_WRITE,"%s%s%s\n",",sizeof(",Var,"[0]),DynStrCompareD);");
                      Use_DynStrqsortd=Use_BCX_stricmp=TRUE;
                    }
                }
            }
          else
            {
              if(iAlphaNumeric ){
                  fprintf(FP_WRITE,"%s%s%s\n",",sizeof(",Var,"[0]),DynAlphaNumericA);");
                  Use_DynAlphaNumericA=TRUE;
                }
              else
                {
                  if(Use_Strqsorts==TRUE ){
                      fprintf(FP_WRITE,"%s%s%s\n",",sizeof(",Var,"[0]),DynStrCompareAs);");
                      Use_DynStrqsortas=TRUE;
                      Use_Strqsorts=FALSE;
                    }
                  else
                    {
                      fprintf(FP_WRITE,"%s%s%s\n",",sizeof(",Var,"[0]),DynStrCompareA);");
                      Use_DynStrqsorta=Use_BCX_stricmp=TRUE;
                    }
                }
            }
        }
      goto L1471;
    }
  if(vt==vt_INTEGER ){
      if(order==1 ){
          fprintf(FP_WRITE,"%s\n",",sizeof(int), NumCompareDint);");
          Use_Numqsortdint=TRUE;
        }
      else
        {
          fprintf(FP_WRITE,"%s\n",",sizeof(int), NumCompareAint);");
          Use_Numqsortaint=TRUE;
        }
      goto L1471;
    }
  if(vt==vt_SINGLE ){
      if(order==1 ){
          fprintf(FP_WRITE,"%s\n",",sizeof(float), NumCompareDfloat);");
          Use_Numqsortdfloat=TRUE;
        }
      else
        {
          fprintf(FP_WRITE,"%s\n",",sizeof(float), NumCompareAfloat);");
          Use_Numqsortafloat=TRUE;
        }
      goto L1471;
    }
  if(vt==vt_DOUBLE ){
      if(order==1 ){
          fprintf(FP_WRITE,"%s\n",",sizeof(double), NumCompareDdouble);");
          Use_Numqsortddouble=TRUE;
        }
      else
        {
          fprintf(FP_WRITE,"%s\n",",sizeof(double), NumCompareAdouble);");
          Use_Numqsortadouble=TRUE;
        }
    }
  else
    {
      if(order==1 ){
          fprintf(FP_WRITE,"%s\n",",sizeof(int), NumCompareDint);");
          Use_Numqsortdint=TRUE;
        }
      else
        {
          fprintf(FP_WRITE,"%s\n",",sizeof(int), NumCompareAint);");
          Use_Numqsortaint=TRUE;
        }
    }
L1471:;
  return 0;
}

int Emit_template (char* sWord,PINT  FuncRetnFlag)
{
  if(strcmp(sWord,"template")==0){
      char LTmp[BCXSTRSIZE];
      UsingTemplate=TRUE;
      BuildDelimStr(1,Ndx,LTmp);
      fprintf(FP_UDT,"%s\n",LTmp);
      FP_WRITE=FP_UDT;
      goto L1472;
    }
  if(strcmp(sWord,"endtemplate")==0){
      UsingTemplate=FALSE;
    }
L1472:;
  *FuncRetnFlag=0;
  return 0;
}

void AddProto (char* szProto)
{
  if(UsingTemplate==FALSE ){
      ProtoCnt++;
      if(ProtoCnt==cMAXProtoType ){
          Abort("Maximum Prototypes Exceeded.");
        }
      strcpy(ProtoType[ProtoCnt].Prototype,szProto);
    }
}

int Emit_Const (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(sWord);
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  static int i;
  static char Buffer[BCXSTRSIZE];
  *Buffer=0;
  if(InClass ){
      for(i=1; i<=Ndx; i++)
        {
          if(IsValidName(Stk[i])&&IsValidName(Stk[i+1])){
              strcpy(Stk[i], join(2,Stk[i],SPC));
            }
          strcat(Buffer,Stk[i]);
        }
      fprintf(FP_UDT,"%s%s%s\n",Scoot,Buffer,";");
    }
  else
    {
      *Stk[1]=0;
      if(strcmp(Stk[3],"(")==0){
          if(cMaxMacros==MacroCount ){
              Abort("Max Const Macros exceeded.");
            }
          strcpy(ConstMacro[MacroCount++],Stk[2]);
        }
      for(i=2; i<=Ndx; i++)
        {
          if(*Stk[i]==61 ){
              i++;
              goto L1474;
            }
          else
            {
              if(IsDecimalNumber(Stk[i])){
                  strcpy(Stk[1], join(2,Stk[1],SPC));
                }
              strcpy(Stk[1], join(2,Stk[1],Stk[i]));
            }
        }
L1474:;
      strcpy(Stk[1], join(3,"#define ",Clean(Stk[1]),SPC));
      for(int j=i; j<=Ndx; j++)
        {
          if(!IsQuoted(Stk[j])){
              strcpy(Stk[j],RemoveStr(Stk[j],"$"));
            }
          if((IsValidName(Stk[j])&&IsValidName(Stk[j+1]))||IsDecimalNumber(Stk[j+1])){
              strcpy(Stk[j], join(2,Stk[j],SPC));
            }
          strcat(Buffer,Stk[j]);
        }
      strcpy(Buffer, join(2,Stk[1],Buffer));
      strcpy(Buffer,replace(Buffer,"( ","("));
      if(InConditional ){
          if(InFunction ){
              fprintf(FP_WRITE,"%s\n",Buffer);
            }
          else
            {
              if(strcmp(ConstLastDef,"FP_CST")!=0){
                  fprintf(FP_CST,"%s%s\n",InIfDef,"// FP_CST");
                  strcpy(ConstLastDef,"FP_CST");
                }
              fprintf(FP_CST,"%s\n",Buffer);
            }
        }
      else
        {
          fprintf(FP_CST,"%s\n",Buffer);
        }
    }
  return 0;
}

int Emit_Redim (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(sWord);
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  int VarDataType={0};
  int IsAsterisk={0};
  int BC={0};
  struct _VARINFO*  VI={0};
  int vt={0};
  int id={0};
  int dms={0};
  int i={0};
  int IsPreserve={0};
  int LoIndex={0};
  int HiIndex={0};
  char szVarName[BCXSTRSIZE]={0};
  char Tmpz[BCXSTRSIZE]={0};
  char SOF[BCXSTRSIZE]={0};
  Process_Option_Base();
  IsPreserve=iMatchWrd(Stk[2],"preserve");
  LoIndex=2+IsPreserve;
  VarDataType=DataType(Stk[LoIndex]);
  strcpy(szVarName,Clean(Stk[LoIndex]));
  IsAsterisk=iMatchWrd(Stk[LoIndex+1],"*");
  ValidateVarName(szVarName);
  HiIndex=GetAsPosB(Ndx,1)-1;
  if(HiIndex<1 ){
      HiIndex=Ndx;
    }
  while(HiIndex>LoIndex){
      if(strcmp(Stk[HiIndex],"[")==0){
          BC--;
        }
      else if(strcmp(Stk[HiIndex],"]")==0){
          BC++;
          if(BC==1 ){
              HiIndex--;
              continue;
            }
        }
      if(BC==0 ){
          if(strcmp(Stk[HiIndex-1],"]")!=0){
              goto L1476;
            }
          strcpy(Tmpz, join(2,",",Tmpz));
        }
      else
        {
          strcpy(Tmpz, join(2,Stk[HiIndex],Tmpz));
        }
      HiIndex--;
    }
L1476:;
  vt=CheckLocal(szVarName,&(id));
  if(vt==vt_UNKNOWN ){
      vt=CheckGlobal(szVarName,&(id));
      if(vt==vt_UNKNOWN ){
          char szTmp[BCXSTRSIZE]={0};
          int startNdx={0};
          if(strcmp(Stk[3],"*")==0  || strcmp(Stk[5],"*")==0){
              strcpy(szTmp,"DIM ");
              for(int j=2; j<=Ndx; j++)
                {
                  strcpy(szTmp, join(3,szTmp,Stk[j],SPC));
                }
              Inject(szTmp);
              return 0;
            }
          if(bcx_stricmp(Stk[2],"PRESERVE")==0){
              startNdx=3;
            }
          else
            {
              startNdx=2;
            }
          for(int j=startNdx; j<=Ndx; j++)
            {
              strcpy(szTmp, join(3,szTmp,Stk[j],SPC));
            }
          if(InWinMain||InMain==TRUE ){
              Inject(join(2,"GLOBAL dynamic ",szTmp));
            }
          else
            {
              Inject(join(2,"LOCAL dynamic ",szTmp));
            }
          return 0;
        }
      VI=&(GlobalVars[id]);
    }
  else
    {
      VI=&(LocalVars[id]);
    }
  dms=VI->VarPntr;
  if(vt==vt_STRUCT||vt==vt_UDT||vt==vt_UNION ){
      strcpy(SOF,GetElement(LoIndex,&(vt),&(dms),VI->VarDef));
      i=Ndx;
      Ndx=HiIndex-1;
      AsmUnknownStructs(1);
      Ndx=i;
      RemEmptyTokens();
      strcpy(szVarName,Clean(Stk[LoIndex]));
      IsAsterisk=iMatchWrd(Stk[LoIndex+1],"*");
    }
  else
    {
      strcpy(SOF,GetVarTypeName(vt));
    }
  if(strcmp(trim(SOF),"")!=0){
      if(iMatchWrd(Stk[Ndx-1],"as")){
          if(strcmp(SOF,Stk[Ndx])!=0  && !iMatchWrd(Stk[Ndx],"string")){
              Abort(join(6,"Can not change types for variable ",szVarName," previously defined as ",SOF," on line",str(VI->VarLine)));
            }
          if(iMatchWrd(Stk[Ndx],"string")){
              Ndx--;
              AppendTokens(3,"[","BCXSTRSIZE","]");
            }
          else
            {
              Ndx-=(2);
            }
        }
      else
        {
          if(((vt==vt_CHAR||vt==vt_SCHAR)&&VarDataType==vt_STRVAR&&IsAsterisk==0)||vt==vt_CHARPTR ){
              AppendTokens(3,"[","BCXSTRSIZE","]");
            }
        }
    }
  if(SOF[0]==0 ){
      strcpy(SOF,Stk[Ndx]);
    }
  if(strcmp(Stk[3+IsPreserve],"[")==0){
      if(IsPreserve ){
          LoIndex=4;
        }
      else
        {
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s%s%s\n",Scoot,"if (",szVarName,") { DestroyArr((void **)",szVarName,",",str(dms),", 1); ",szVarName,"=NULL; }");
          LoIndex=3;
        }
      Use_DynamicA=Use_BcxTempStr=TRUE;
      *Tmpz=0;
      for(i=LoIndex; i<=Ndx; i++)
        {
          if(*Stk[i]==91 ){
              i++;
              BC=1;
              while(BC>0){
                  if(*Stk[i]==91 ){
                      BC++;
                      strcat(Tmpz,Stk[i]);
                    }
                  else
                    {
                      if(*Stk[i]==93 ){
                          BC--;
                          if(BC==0&&i<Ndx ){
                              strcat(Tmpz,",");
                            }
                          if(BC ){
                              strcat(Tmpz,Stk[i]);
                            }
                        }
                      else
                        {
                          strcat(Tmpz,Stk[i]);
                        }
                    }
                  i++;
                }
              i--;
            }
        }
      strcpy(Tmpz,Clean(Tmpz));
      if(vt==vt_STRLIT||vt==vt_DECFUNC||vt==vt_NUMBER||(vt==vt_VOID&&inchr(Stk[Ndx],"*")==0)){
          Abort(join(2,Stk[Ndx]," is not a valid type"));
        }
      if(vt==vt_STRVAR ){
          strcpy(SOF,"char");
          strcat(Tmpz,",");
          strcat(Tmpz,"BCXSTRSIZE");
        }
      strcpy(Tmpz,replace(Tmpz,",",", (size_t)"));
      fprintf(FP_WRITE,"%s%s\n",Scoot,"{");
      char szTmp[BCXSTRSIZE]={0};
      strcpy(szTmp, join(5,"size_t dimensions[",trim(str(dms)),"] = {(size_t)",Tmpz,"};"));
      strcpy(szTmp,replace(szTmp,", (size_t)};","};"));
      fprintf(FP_WRITE,"%s%s\n",Scoot,szTmp);
      if(LeftStr(szVarName,"(*")){
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s%s%s%s%s%s%s\n",Scoot,szVarName,"= (",SOF,stringx(dms-1,42),")CreateArr (",szVarName,", sizeof(",SOF,"), ",str(IsPreserve,1),", ",str(dms-1,1),", dimensions);");
        }
      else
        {
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s%s%s%s%s%s%s\n",Scoot,szVarName,"= (",SOF,stringx(dms,42),")CreateArr (",szVarName,", sizeof(",SOF,"), ",str(IsPreserve,1),", ",str(dms,1),", dimensions);");
        }
      fprintf(FP_WRITE,"%s%s\n",Scoot,"}");
      goto REDIM_EXIT;
    }
  if(strcmp(Stk[3],"*")==0  || (IsPreserve && strcmp(Stk[4],"*")==0)){
      if(IsPreserve ){
          fprintf(FP_WRITE,"%s%s%s%s%s",Scoot,szVarName,"=(char*)realloc(",szVarName,",");
          i=5;
        }
      else
        {
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"free(",szVarName,");");
          fprintf(FP_WRITE,"%s%s%s",Scoot,szVarName,"=(char*)calloc(");
          i=4;
        }
      if(IsPreserve ){
          strcpy(Stk[++Ndx],");");
        }
      else
        {
          strcpy(Stk[++Ndx],",1);");
        }
      WriteCleanTokens(i,Ndx);
      goto REDIM_EXIT;
    }
  Abort("Invalid REDIM statement");

REDIM_EXIT:;
  return 0;
}

int Emit_Extern (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(sWord);
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  int IsVolatile;
  int IsSubOrFuncPtr;
  char CVar[BCXSTRSIZE];
  int IsPointer;
  int id;
  int vt;
  char L_DimType[BCXSTRSIZE];
  IsSubOrFuncPtr=SubFuncTest();
  Process_Option_Base();
  IsVolatile=iMatchWrd(Stk[2],"volatile");
  strcpy(CVar,Clean(Stk[2+IsVolatile]));
  ValidateVarName(CVar);
  if(strcmp(Stk[Ndx],"*")==0){
      PointerFix();
    }
  if(strcmp(Stk[Ndx],"&")==0){
      *Stk[Ndx--]=0;
      strcpy(Stk[Ndx], join(2,Stk[Ndx],"&"));
    }
  if(strcmp(Stk[3+IsVolatile],"*")==0){
      if(IsVolatile ){
          Abort("volatile dynamic strings not supported");
        }
      DimDynaString(CVar,2,0);
      return 0;
    }
  if(IsSubOrFuncPtr ){
      if(IsVolatile ){
          Abort("volatile SUB/FUNCTION pointers not supported");
        }
      if(DimSubFunc(0)){
          return 0;
        }
    }
  strcpy(Var,Clean(Stk[2+IsVolatile]));
  ValidateVarName(Var);
  IsPointer=0;
  *L_DimType=0;
  if(iMatchWrd(Stk[Ndx-1],"as")){
      GetTypeInfo(Stk[Ndx],&(IsPointer),&(id),&(vt));
      strcpy(Stk[Ndx],RemoveStr(Stk[Ndx],"*"));
      BuildStr(3+IsVolatile,Ndx-2,L_DimType);
    }
  else
    {
      BuildStr(3+IsVolatile,Ndx,L_DimType);
      vt=DataType(Stk[2+IsVolatile]);
      id=0;
    }
  if(vt==vt_STRVAR ){
      strcat(L_DimType,"[BCXSTRSIZE]");
    }
  if(IsVolatile ){
      AddGlobal(Var,vt,id,L_DimType,IsPointer,0,4);
    }
  else
    {
      AddGlobal(Var,vt,id,L_DimType,IsPointer,0,1);
    }
  return 0;
}

int Emit_Run (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(sWord);
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  fprintf(FP_WRITE,"%s%s",Scoot,"Run (");
  strcpy(Stk[++Ndx],");");
  WriteCleanTokens(2,Ndx);
  return 0;
}

int Emit_Shell (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(sWord);
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  char LZZ[BCXSTRSIZE];
  BuildDelimStr(2,Ndx,LZZ);
  if(ISNULL(LZZ)){
      strcpy(LZZ,DDQ);
    }
  fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"system(",Clean(LZZ),");");
  return 0;
}

int Emit_Data (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(sWord);
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  for(int A=2; A<=Ndx; A++)
    {
      if(strcmp(Stk[A],"-")==0){
          strcpy(Stk[A], join(2,"-",Stk[A+1]));
          *Stk[A+1]=0;
          LShiftStk(A+1);
        }
    }
  for(int A=2; A<=Ndx; A++)
    {
      if(inchr(Stk[A],DQ)==0 && strcmp(Stk[A],",")!=0){
          strcpy(Stk[A],enc(Stk[A]));
        }
      fprintf(FP_DAT,"%s",Stk[A]);
    }
  fprintf(FP_DAT,"%s\n","");
  return 0;
}

int Emit_Declare (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(sWord);
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  char TempProto[BCXSTRSIZE];
  struct _VARCODE  Varcode;
  struct _FUNCPARSE  FP;
  Varcode.IsExported=FALSE;
  Varcode.UseInLine=UseInLine;
  FuncSubDecs1("sub",1,Ndx,&(Varcode));
  SepFuncArgs(3,&(FP),TRUE);
  strcpy(TempProto,MakeDecProto(&(FP)));
  if(!NoTypeDeclare ){
      fprintf(FP_UDT,"%s%s\n",TempProto,";");
    }
  else
    {
      AddProto(join(2,TempProto,";"));
    }
  return 0;
}

int Emit_Auto (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(sWord);
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  DimVar(ImAuto);
  return 0;
}

int Emit_Dim (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(sWord);
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  DimVar(ImDim);
  return 0;
}

int Emit_Local (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(sWord);
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  DimVar(ImLocal);
  return 0;
}

int Emit_PrivateDim (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(sWord);
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  DimVar(ImCPPPrvDim);
  return 0;
}

int Emit_Raw (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(sWord);
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  DimVar(ImRaw);
  return 0;
}

int Emit_Register (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(sWord);
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  DimVar(ImRegister);
  return 0;
}

int Emit_Static (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(sWord);
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  DimVar(ImStatic);
  return 0;
}

int Emit_Clear (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(sWord);
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  Use_Clear=Use_SysMacros=TRUE;
  fprintf(FP_WRITE,"%s%s",Scoot,"Clear");
  if(strcmp(Stk[2],"(")!=0){
      fprintf(FP_WRITE,"%s","(");
    }
  for(int i=2; i<=Ndx; i++)
    {
      fprintf(FP_WRITE,"%s",Clean(Stk[i]));
    }
  if(strcmp(Stk[Ndx],")")!=0){
      fprintf(FP_WRITE,"%s",")");
    }
  fprintf(FP_WRITE,"%s\n",";");
  return 0;
}

int Emit_Swap (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(sWord);
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  struct _VARINFO*  VI1;
  struct _VARINFO*  VI2;
  int  indx;
  int A;
  int i;
  int j;
  BOOLEAN  ThirdArgExists;
  Use_BcxTempStr=TRUE;
  ThirdArgExists=FALSE;
  for(i=2; i<=Ndx; i++)
    {
      if(*Stk[i]==44 ){
          if(i<Ndx ){
              for(j=i+1; j<=Ndx; j++)
                {
                  if(*Stk[j]==44 ){
                      ThirdArgExists=TRUE;
                      goto L1485;
                    }
                }
L1485:;
            }
          goto L1484;
        }
    }
L1484:;
  if(ThirdArgExists ){
      fprintf(FP_WRITE,"%s%s",Scoot,"swap (");
      for(i=2; i<=Ndx; i++)
        {
          if(*Stk[i]==44 ){
              fprintf(FP_WRITE,"%s",", ");
            }
          else
            {
              fprintf(FP_WRITE,"%s",Clean(Stk[i]));
            }
        }
      fprintf(FP_WRITE,"%s\n",");");
    }
  else
    {
      fprintf(FP_WRITE,"%s%s",Scoot,"swap ((byte*)&");
      for(i=2; i<=Ndx; i++)
        {
          if(*Stk[i]==44 ){
              goto L1487;
            }
          fprintf(FP_WRITE,"%s",Clean(Stk[i]));
        }
L1487:;
      A=CheckLocal(Stk[2],&(indx));
      if(A==vt_UNKNOWN ){
          A=CheckGlobal(Stk[2],&(indx));
          if(A==vt_UNKNOWN ){
              Abort(join(3,"Variable '",Stk[2],"' in swap statement unknown"));
            }
          VI1=&(GlobalVars[indx]);
        }
      else
        {
          VI1=&(LocalVars[indx]);
        }
      if(RightStr(Stk[i-1],"]")){
          if(VI1->VarType==vt_CHAR&&VI1->VarPntr==1 ){
              fprintf(FP_WRITE,"%s","[0]");
            }
          if(VI1->VarType==vt_SCHAR&&VI1->VarPntr==1 ){
              fprintf(FP_WRITE,"%s","[0]");
            }
        }
      fprintf(FP_WRITE,"%s",",(byte*)&");
      i++;
      for(j=i; j<=Ndx; j++)
        {
          fprintf(FP_WRITE,"%s",Clean(Stk[j]));
        }
      A=CheckLocal(Stk[i],&(indx));
      if(A==vt_UNKNOWN ){
          A=CheckGlobal(Stk[i],&(indx));
          if(A==vt_UNKNOWN ){
              Abort(join(3,"Variable '",Stk[i],"' in swap statement unknown"));
            }
          VI2=&(GlobalVars[indx]);
        }
      else
        {
          VI2=&(LocalVars[indx]);
        }
      if(RightStr(Stk[j-1],"]")){
          if(VI2->VarType==vt_CHAR&&VI2->VarPntr==1 ){
              fprintf(FP_WRITE,"%s","[0]");
            }
          if(VI2->VarType==vt_SCHAR&&VI2->VarPntr==1 ){
              fprintf(FP_WRITE,"%s","[0]");
            }
        }
      if(VI1->VarType!=VI2->VarType ){
          Warning("Possible size error in swap statement");
        }
      if(VI2->VarType==vt_STRVAR||VI2->VarType==vt_CHAR||VI2->VarType==vt_SCHAR ){
          fprintf(FP_WRITE,"%s",",strlen(");
        }
      else
        {
          fprintf(FP_WRITE,"%s",",sizeof(");
        }
      strcpy(Stk[++Ndx],"));");
      WriteCleanTokens(i,Ndx);
    }
  return 0;
}

int Emit_PrinterProcs (char* sWord,PINT  FuncRetnFlag)
{
  if(strcmp(sWord,"ejectpage")==0){
      fprintf(FP_WRITE,"%s%s\n",Scoot,"EjectPage();");
      goto L1489;
    }
  if(strcmp(sWord,"printerclose")==0){
      fprintf(FP_WRITE,"%s%s\n",Scoot,"PrinterClose();");
      goto L1489;
    }
  if(strcmp(sWord,"printeropen")==0){
      if(Ndx==1 ){
          fprintf(FP_WRITE,"%s%s\n",Scoot,"PrinterOpen();");
        }
      else
        {
          char szPrinterParameters[BCXSTRSIZE];
          BuildStr(2,Ndx,szPrinterParameters);
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"PrinterOpen(",szPrinterParameters,");");
        }
      goto L1489;
    }
  if(strcmp(sWord,"lprint")==0  || strcmp(sWord,"sprint")==0){
      int IsLprint=FALSE;
      int IsSprint=FALSE;
      if(iMatchWrd(Stk[1],"lprint")){
          Use_Proto=IsLprint=IsSprint=TRUE;
          strcpy(Stk[1],"sprint");
          InsertTokens(1,2,"BcxPtr_Buffer",",");
        }
      if(iMatchWrd(Stk[1],"sprint")){
          IsSprint=TRUE;
        }
      if(IsDecimalNumber(Stk[2])){
          strcpy(Stk[2], join(2,"FP",Stk[2]));
        }
      if(IsSprint ){
          strcpy(szFileHandle,Clean(Stk[2]));
        }
      else
        {
          if(iMatchWrd(Stk[2],"stderr")){
              strcpy(szFileHandle,"stderr");
            }
          else
            {
              static int i;
              if(CheckLocal(Stk[2],&(i))==vt_UNKNOWN ){
                  if(CheckGlobal(Stk[2],&(i))==vt_UNKNOWN ){
                      AddGlobal(Stk[2],vt_FILEPTR);
                    }
                }
              *szFileHandle=0;
              for(int iii=2; iii<=Ndx; iii++)
                {
                  if(*Stk[iii]==44||*Stk[iii]==59 ){
                      *Stk[iii]=0;
                      goto L1490;
                    }
                  strcat(szFileHandle,Stk[iii]);
                  *Stk[iii]=0;
                }
L1490:;
              strcat(szFileHandle,"@");
            }
        }
      *Stk[2]=0;
      *Stk[3]=0;
      static char LZZ[BCXSTRSIZE];
      if(IsSprint ){
          strcpy(LZZ, join(2,"s",PrintWriteFormat(0)));
          strcpy(LZZ,RemoveStr(LZZ,"\\n"));
        }
      else
        {
          strcpy(LZZ, join(2,"f",PrintWriteFormat(0)));
        }
      strcpy(LZZ, join(4,left(LZZ,8),RemoveStr(szFileHandle,"@"),",",mid(LZZ,9)));
      if(IsLprint ){
          fprintf(FP_WRITE,"%s%s\n",Scoot,LZZ);
          fprintf(FP_WRITE,"%s%s\n",Scoot,"PrinterWrite(BcxPtr_Buffer);");
          if(!Use_Printer ){
              strcpy(SrcTmp,"printer");
              Inject(SrcTmp);
            }
        }
      else
        {
          fprintf(FP_WRITE,"%s%s\n",Scoot,LZZ);
        }
    }
  else
    {
      Emit_Old(FuncRetnFlag);
    }
L1489:;
  return 0;
}

int Emit_Free (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(sWord);
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  struct _VARINFO*  VI;
  int A;
  int vt;
  int id;
  int dms;
  char CVar[BCXSTRSIZE];
  int IsDynVar={0};
  A=2;
  if(iMatchWrd(Stk[2],"dynamic")){
      IsDynVar=TRUE;
      A=3;
    }
  if(strcmp(Stk[A],"(")==0){
      A++;
      Ndx--;
    }
  strcpy(CVar,Clean(Stk[A]));
  vt=CheckLocal(CVar,&(id));
  if(vt==vt_UNKNOWN ){
      vt=CheckGlobal(CVar,&(id));
      if(vt==vt_UNKNOWN ){
          Abort(join(3,"Can not REDIM ",CVar," not previously dimensioned"));
        }
      VI=&(GlobalVars[id]);
    }
  else
    {
      VI=&(LocalVars[id]);
      if(IsDynVar ){
          Warning("Local dynamic variables are automatically freed.",1);
        }
    }
  BuildStr(A,Ndx,CVar);
  strcpy(CVar,trim(Clean(CVar)));
  if(vt==vt_STRUCT||vt==vt_UNION ){
      GetElement(2,&(vt),&(dms),VI->VarDef);
      if(vt!=vt_UNKNOWN&&dms>0 ){
          Use_BcxTempStr=Use_DynamicA=TRUE;
          fprintf(FP_WRITE,"%s%s%s",Scoot,"if (",CVar);
          fprintf(FP_WRITE,"%s%s%s% .15G %s",") { DestroyArr((void **)",CVar,",",(double)dms,", 1); ");
          fprintf(FP_WRITE,"%s%s\n",CVar,"=NULL; }");
          return 0;
        }
    }
  if(VI->VarPntr>1 ){
      Use_BcxTempStr=Use_DynamicA=TRUE;
      fprintf(FP_WRITE,"%s%s%s",Scoot,"if (",CVar);
      fprintf(FP_WRITE,"%s%s%s%s%s",") { DestroyArr((void **)",CVar,",",str(VI->VarPntr),", 1); ");
      fprintf(FP_WRITE,"%s%s\n",CVar,"=NULL; }");
    }
  else
    {
      fprintf(FP_WRITE,"%s%s%s%s",Scoot,"free(",CVar,"), ");
      fprintf(FP_WRITE,"%s%s\n",CVar,"=NULL;");
    }
  return 0;
}

int Emit_Dynamic (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(sWord);
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  int w=0;
  char SOF[BCXSTRSIZE];
  char LZZ[BCXSTRSIZE];
  char CVar[BCXSTRSIZE];
  int vt;
  int id;
  int dms;
  Process_Option_Base();
  strcpy(CVar,Clean(Stk[2]));
  ValidateVarName(CVar);
  if(strcmp(Stk[Ndx],"*")==0){
      PointerFix();
    }
  if(strcmp(Stk[Ndx],"&")==0){
      *Stk[Ndx--]=0;
      strcpy(Stk[Ndx], join(2,Stk[Ndx],"&"));
    }
  if(iMatchWrd(Stk[Ndx-1],"as")){
      strcpy(SOF,Stk[Ndx]);
      GetTypeInfo(SOF,&(w),&(id),&(vt));
      if(vt==vt_STRLIT||vt==vt_DECFUNC||vt==vt_NUMBER||(vt==vt_VOID&&inchr(Stk[Ndx],"*")==0)){
          Abort(join(2,SOF," is not a valid type"));
        }
      if(vt==vt_FILEPTR&&inchr(SOF,"*")==0 ){
          strcat(SOF,"*");
        }
      Ndx-=(2);
    }
  else
    {
      vt=DataType(Stk[2]);
      id=0;
      strcpy(SOF,GetVarTypeName(vt));
    }
  Use_DynamicA=Use_BcxTempStr=TRUE;
  BuildStr(3,Ndx,LZZ);
  dms=tally(LZZ,"][")+1;
  if(dms>1 ){
      strcpy(LZZ,replace(LZZ,"][",","));
    }
  strcpy(LZZ,Clean(LZZ));
  RemoveAll(LZZ,"[]");
  if(vt==vt_STRVAR ){
      vt=vt_CHAR;
      strcpy(SOF,"char");
      if(InTypeDef ){
          if(strcmp(Stk[3],"[")!=0){
              dms--;
            }
          else
            {
              vt=vt_CHARPTR;
            }
        }
      dms++;
      strcat(LZZ,",");
      strcat(LZZ,"BCXSTRSIZE");
    }
  if(InTypeDef ){
      if(vt==vt_STRUCT ){
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s\n",Scoot,"struct _",SOF,space(2),stringx(dms,42),CVar,";");
        }
      else
        {
          fprintf(FP_WRITE,"%s%s%s%s%s%s\n",Scoot,SOF,space(2),stringx(dms,42),CVar,";");
        }
      AddTypedefElement(BaseTypeDefsCnt[InTypeDef],vt,CVar,SOF,dms);
    }
  else if(InFunction!=FALSE ){
      LocalDynArrCnt++;
      if(cMaxLocalDynArr==LocalDynArrCnt ){
          Abort("Maximum number of Local Dynamic Arrays exceeded.");
        }
      strcpy(LocalDynArrName[LocalDynArrCnt], join(9,"if (",CVar,") { DestroyArr((void **)",CVar,",",str(dms),", 1); ",CVar,"=NULL; }"));
      fprintf(FP_WRITE,"%s%s%s%s%s%s\n",Scoot,SOF,space(2),stringx(dms,42),CVar,"=0;");
      AddLocal(CVar,vt,id,"",dms);
    }
  else
    {
      if(Use_GenFree ){
          AddDynamicGlobal(join(9,"if (",CVar,") { DestroyArr((void **)",CVar,",",str(dms),", 1); ",CVar,"=NULL; }"));
        }
      AddGlobal(CVar,vt,id,"",dms);
    }
  if(!InTypeDef ){
      strcpy(LZZ,replace(LZZ,",",", (size_t)"));
      fprintf(FP_WRITE,"%s%s\n",Scoot,"{");
      fprintf(FP_WRITE,"%s%s%s%s%s%s\n",Scoot,"size_t dimensions[",trim(str(dms)),"] = {(size_t)",LZZ,"};");
      AuxLocalDynArrayCount++;
      strcpy(AuxLocalDynArray[AuxLocalDynArrayCount], join(5,"if (",CVar,") DestroyArr((void ",stringx(dms-1,42),")"));
      strcpy(AuxLocalDynArray[AuxLocalDynArrayCount], join(5,AuxLocalDynArray[AuxLocalDynArrayCount],CVar,",",str(dms),", 1);"));
      fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s%s%s%s%s\n",Scoot,CVar,"= (",SOF,stringx(dms,42),")CreateArr (",CVar,",sizeof(",SOF,"),0,",str(dms,1),", dimensions);");
      fprintf(FP_WRITE,"%s%s\n",Scoot,"}");
    }
  return 0;
}

void DimVar (int iType)
{
  int w=0;
  int id=0;
  int vt=0;
  int IsALocalVar=FALSE;
  int NotInitialized=TRUE;
  static char UseStatic[BCXSTRSIZE];
  static int IsVolatile;
  static char sVolatile[BCXSTRSIZE];
  static int Ok2Initialize;
  static char szVarName[BCXSTRSIZE];
  static int VarType;
  static int IsSubOrFuncPtr;
  static int IsConsOrDestPtr;
  static int IsPointer;
  static char LTmp[BCXSTRSIZE];
  static char L_DimType[BCXSTRSIZE];
  static char szVarTypeName[BCXSTRSIZE];
  static char szMemsetName[BCXSTRSIZE];
  static char szVarDecName[BCXSTRSIZE];
  if(BYTE_AT(Stk[Ndx][0])==58 ){
      strcpy(Stk[Ndx-1], join(2,Stk[Ndx-1],Stk[Ndx]));
      Ndx--;
    }
  IsDim=IsLocal=IsRaw=IsRegister=IsStatic=FALSE;
  if(iType==ImDim ){
      IsDim=TRUE;
    }
  if(iType==ImLocal ){
      IsLocal=TRUE;
    }
  if(iType==ImRaw ){
      IsDim=IsRaw;
    }
  if(iType==ImRegister ){
      IsRegister=TRUE;
    }
  if(iType==ImStatic ){
      IsStatic=TRUE;
    }
  IsVolatile=iMatchWrd(Stk[2],"volatile");
  if(IsVolatile ){
      if(IsRegister ){
          Abort("Register volatile not supported");
        }
      strcpy(sVolatile,"volatile ");
    }
  else
    {
      *sVolatile=0;
    }
  IsSubOrFuncPtr=SubFuncTest();
  IsConsOrDestPtr=Ctor_Dtor_Detected(2);
  Process_Option_Base();
  if(strcmp(Stk[Ndx],"*")==0){
      PointerFix();
    }
  if(strcmp(Stk[Ndx],"&")==0){
      *Stk[Ndx--]=0;
      strcpy(Stk[Ndx], join(2,Stk[Ndx],"&"));
    }
  if(IsSubOrFuncPtr ){
      if(IsVolatile ){
          Abort("volatile SUB/FUNCTION pointers not supported");
        }
      if(DimSubFunc(0)){
          return;
        }
    }
  if(IsConsOrDestPtr ){
      if(IsVolatile ){
          Abort("volatile SUB/FUNCTION pointers not supported");
        }
      if(DimSubFunc(2)){
          return;
        }
    }
  if(InFunction||InTypeDef||InCppTypeDef||InClass||InBlock||InNameSpace ){
      IsALocalVar=TRUE;
    }
  if(InTypeDef||IsVolatile ){
      Ok2Initialize=FALSE;
    }
  else
    {
      if(UseCpphdr ){
          if(NOTZERO(iType  & (ImDim|ImLocal))){
              Ok2Initialize=TRUE;
            }
          else
            {
              Ok2Initialize=FALSE;
            }
        }
      else
        {
          if(NOTZERO(iType  & (ImDim|ImLocal|ImAuto))){
              Ok2Initialize=TRUE;
            }
          else
            {
              Ok2Initialize=FALSE;
            }
        }
    }
  if(InTypeDef||InNameSpace ){
      *UseStatic=0;
      IsStatic=FALSE;
    }
  else
    {
      if(NOTZERO(iType  &  ImStatic)){
          IsStatic=TRUE;
          strcpy(UseStatic,"static ");
        }
      else
        {
          *UseStatic=0;
          IsStatic=FALSE;
        }
    }
  strcpy(szVarName,Clean(Stk[2+IsVolatile]));
  ValidateVarName(szVarName);
  VarType=DataType(Stk[2+IsVolatile]);
  if(strcmp(Stk[3+IsVolatile],"*")==0){
      if(IsVolatile ){
          Abort("volatile dynamic strings not supported");
        }
      DimDynaString(szVarName,0,0);
      return;
    }
  int iASoffset=GetAsPosB(Ndx,2);
  if(iASoffset ){
      char sConst[BCXSTRSIZE]={0};
      int iIsConst={0};
      if(iASoffset==Ndx-2 ){
          if(iMatchWrd(Stk[Ndx-1],"const")){
              strcpy(sConst,"const ");
              iIsConst=1;
            }
        }
      IsPointer=tally(Stk[Ndx],"*");
      BuildStr(2+IsVolatile,iASoffset-1,LTmp);
      BuildStr(3+IsVolatile,iASoffset-1,L_DimType);
      if(NOTZERO(inchr(LTmp,"="))){
          NotInitialized=FALSE;
        }
      strcpy(szVarTypeName,RemoveStr(Stk[Ndx],"*"));
      GetTypeInfo(szVarTypeName,&(w),&(id),&(vt));
      if(vt==vt_WINBOOL ){
          strcpy(Stk[Ndx],iReplace(Stk[Ndx],"WINBOOL","BOOL"));
        }
      if(vt==vt_STRVAR ){
          strcpy(Stk[Ndx],"char");
          strcpy(szVarTypeName,Stk[Ndx]);
          strcat(L_DimType,"[BCXSTRSIZE]");
          strcat(LTmp,"[BCXSTRSIZE]");
        }
      strcpy(Stk[Ndx],rpad(Stk[Ndx],PADSIZE));
      if(vt==vt_FILEPTR ){
          strcpy(Stk[Ndx], join(2,Stk[Ndx],"*"));
        }
      if(IsALocalVar ){
          if(iType==ImDim||iType==ImLocal||iType==ImRaw ){
              if(vt==vt_STRUCT ){
                  fprintf(FP_WRITE,"%s%s%s%s%s%s%s",Scoot,UseStatic,sVolatile,sConst,"struct _",Stk[Ndx],space(2));
                }
              else
                {
                  fprintf(FP_WRITE,"%s%s%s%s%s%s",Scoot,UseStatic,sVolatile,sConst,Stk[Ndx],space(2));
                }
              if(InTypeDef&&!InBlock ){
                  if(vt==vt_UDT ){
                      if(ComSwitchON ){
                          if(strcmp(TypeDefs[id].VarName,"OBJECT")==0){
                              Abort("Use of Object type in UDTs is Illegal!");
                            }
                        }
                    }
                  AddTypedefElement(BaseTypeDefsCnt[InTypeDef],vt,szVarName,szVarTypeName);
                }
              goto L1491;
            }
          if(iType==ImStatic ){
              fprintf(FP_WRITE,"%s%s%s%s%s%s",Scoot,UseStatic,sVolatile,sConst,Stk[Ndx],space(2));
              goto L1491;
            }
          if(iType==ImAuto ){
              fprintf(FP_WRITE,"%s%s%s%s%s%s%s",Scoot,SPC,sVolatile,sConst,SPC,Stk[Ndx],space(2));
              goto L1491;
            }
          if(iType==ImRegister ){
              fprintf(FP_WRITE,"%s%s%s%s%s",Scoot,SPC,sConst,Stk[Ndx],space(2));
              goto L1491;
            }
          if(iType==ImCPPPrvDim ){
              fprintf(FP_WRITE,"%s%s%s%s",Scoot,"private: ",Stk[Ndx],space(2));
            }
L1491:;
          if(iType!=ImCPPPrvDim ){
              if(!InTypeDef ){
                  if(vt==vt_UDT ){
                      if(ComSwitchON ){
                          if(strcmp(TypeDefs[id].VarName,"OBJECT")==0){
                              Add_COM_Global_Variable(szVarName);
                              Use_COM=Use_BcxTempStr=TRUE;
                            }
                        }
                    }
                  AddLocal(szVarName,vt,id,L_DimType,IsPointer,0,0,iIsConst);
                }
            }
          if(Ok2Initialize ){
              strcpy(szMemsetName,Clean(extract(LTmp,"[")));
              if(IsPointer ){
                  if(NotInitialized ){
                      fprintf(FP_WRITE,"%s%s\n",Clean(LTmp),"={0};");
                    }
                  else
                    {
                      fprintf(FP_WRITE,"%s%s\n",Clean(LTmp),";");
                    }
                }
              else
                {
                  if(vt==vt_BOOL||vt==vt_BYTE||vt==vt_DWORD||vt==vt_INTEGER||vt==vt_LONG||vt==vt_SHORT||vt==vt_UINT||vt==vt_ULONG||vt==vt_USHORT||vt==vt_DWORD||vt==vt_WORD||vt==vt_DOUBLE||vt==vt_SINGLE||vt==vt_LDOUBLE||vt==vt_PCHAR||vt==vt_LPBYTE||vt==vt_SSHORT||vt==vt_SCHAR ){
                      if(NotInitialized ){
                          fprintf(FP_WRITE,"%s%s\n",Clean(LTmp),"={0};");
                        }
                      else
                        {
                          fprintf(FP_WRITE,"%s%s\n",Clean(LTmp),";");
                        }
                    }
                  else
                    {
                      if(NotInitialized ){
                          fprintf(FP_WRITE,"%s%s\n",Clean(LTmp),"={0};");
                        }
                      else
                        {
                          fprintf(FP_WRITE,"%s%s\n",Clean(LTmp),";");
                        }
                    }
                }
            }
          else
            {
              fprintf(FP_WRITE,"%s%s\n",Clean(LTmp),";");
            }
        }
      else
        {
          if(IsVolatile ){
              AddGlobal(szVarName,vt,id,L_DimType,IsPointer,0,3,0,iIsConst);
            }
          else
            {
              if(vt==vt_UDT ){
                  if(ComSwitchON ){
                      if(strcmp(TypeDefs[id].VarName,"OBJECT")==0){
                          Add_COM_Global_Variable(szVarName);
                          Use_COM=Use_BcxTempStr=TRUE;
                        }
                    }
                }
              if(iType==ImRaw ){
                  AddGlobal(szVarName,vt,id,L_DimType,IsPointer,0,2,0,iIsConst);
                }
              else
                {
                  AddGlobal(szVarName,vt,id,L_DimType,IsPointer,0,0,0,iIsConst);
                }
            }
        }
      return;
    }
  BuildStr(3+IsVolatile,Ndx,LTmp);
  if(NOTZERO(inchr(LTmp,"="))){
      NotInitialized=FALSE;
    }
  if(IsALocalVar ){
      strcpy(LTmp,trim(Clean(LTmp)));
    }
  if(VarType==vt_STRVAR ){
      strcat(LTmp,"[BCXSTRSIZE]");
    }
  if(IsALocalVar ){
      if(VarType==vt_STRVAR ){
          strcpy(szVarDecName,"char");
        }
      else
        {
          strcpy(szVarDecName,GetVarTypeName(VarType));
        }
      strcpy(szVarDecName,rpad(szVarDecName,PADSIZE));
      if(UseCpphdr ){
          int Ok2UseMemset;
          Ok2UseMemset=Ok2Initialize;
          if(iType==ImDim||iType==ImLocal||iType==ImRaw||iType==ImStatic ){
              if((ImDim|ImLocal)&&Ok2UseMemset ){
                  fprintf(FP_WRITE,"%s%s%s%s%s%s\n",Scoot,szVarDecName,SPC,szVarName,LTmp,"={0};");
                  Ok2UseMemset=FALSE;
                }
              else
                {
                  fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,UseStatic,sVolatile,szVarDecName,SPC,szVarName,LTmp,";");
                }
              goto L1493;
            }
          if(iType==ImRegister ){
              if(IsVolatile ){
                  Abort("Register volatile not supported");
                }
              fprintf(FP_WRITE,"%s%s%s%s%s%s%s\n",Scoot,SPC,szVarDecName,SPC,szVarName,LTmp,";");
              goto L1493;
            }
          if(iType==ImCPPPrvDim ){
              fprintf(FP_WRITE,"%s%s%s%s%s%s%s\n",Scoot,"private: ",szVarDecName,SPC,szVarName,LTmp,";");
            }
L1493:;
          if(Ok2UseMemset ){
              strcpy(szMemsetName,Clean(extract(szVarName,"[")));
              fprintf(FP_WRITE,"%s%s%s%s%s%s\n",Scoot,"memset(&",szMemsetName,",0,sizeof(",szMemsetName,"));");
            }
        }
      else
        {
          if(iType==ImDim||iType==ImLocal||iType==ImStatic||iType==ImRaw ){
              if(NotInitialized&&Ok2Initialize ){
                  fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,UseStatic,sVolatile,szVarDecName,SPC,szVarName,LTmp,"={0};");
                }
              else
                {
                  fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,UseStatic,sVolatile,szVarDecName,SPC,szVarName,LTmp,";");
                }
              goto L1494;
            }
          if(iType==ImAuto ){
              if(NotInitialized&&Ok2Initialize ){
                  fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"auto ",sVolatile,szVarDecName,SPC,szVarName,LTmp,"={0};");
                }
              else
                {
                  fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"auto ",sVolatile,szVarDecName,SPC,szVarName,LTmp,";");
                }
              goto L1494;
            }
          if(iType==ImRegister ){
              if(IsVolatile ){
                  Abort("Register volatile not supported");
                }
              if(NotInitialized&&Ok2Initialize ){
                  fprintf(FP_WRITE,"%s%s%s%s%s%s%s\n",Scoot,SPC,szVarDecName,SPC,szVarName,LTmp,"={0};");
                }
              else
                {
                  fprintf(FP_WRITE,"%s%s%s%s%s%s%s\n",Scoot,SPC,szVarDecName,SPC,szVarName,LTmp,";");
                }
              goto L1494;
            }
          if(iType==ImCPPPrvDim ){
              if(NotInitialized&&Ok2Initialize ){
                  fprintf(FP_WRITE,"%s%s%s%s%s%s%s\n",Scoot,"private: ",szVarDecName,SPC,szVarName,LTmp,"={0};");
                }
              else
                {
                  fprintf(FP_WRITE,"%s%s%s%s%s%s%s\n",Scoot,"private: ",szVarDecName,SPC,szVarName,LTmp,";");
                }
            }
L1494:;
        }
      if(iType!=ImCPPPrvDim ){
          if(InTypeDef ){
              if(VarType==vt_UDT ){
                  if(ComSwitchON ){
                      if(strcmp(TypeDefs[id].VarName,"OBJECT")==0){
                          Abort("Use of Object type in UDTs is Illegal!");
                        }
                    }
                }
              AddTypedefElement(BaseTypeDefsCnt[InTypeDef],VarType,szVarName,szVarTypeName);
            }
          else
            {
              AddLocal(szVarName,VarType,0,LTmp);
            }
        }
      return;
    }
  static int iGlobalExtn;
  if(IsVolatile ){
      iGlobalExtn=3;
    }
  else
    {
      if(VarType==vt_UDT ){
          if(ComSwitchON ){
              if(strcmp(TypeDefs[id].VarName,"OBJECT")==0){
                  Add_COM_Global_Variable(szVarName);
                  Use_COM=Use_BcxTempStr=TRUE;
                }
            }
        }
      iGlobalExtn=0;
    }
  AddGlobal(szVarName,VarType,0,LTmp,0,0,iGlobalExtn);
}

int Emit_CPP_EndClass (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(sWord);
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  UseCpp=TRUE;
  if(InClass!=1 ){
      Abort("Syntax Error");
    }
  BumpDown("Extra unindents and/or missing indents before END CLASS");
  fprintf(FP_UDT,"%s%s\n",Scoot,"};");
  fprintf(FP_UDT,"%s\n","");
  BumpDown("Extra unindents and/or missing indents before END CLASS");
  InClass--;
  FP_WRITE=FP2;
  *InClassName=0;
  *InClassPP=0;
  return 0;
}

int Emit_CPP_Namespace (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(sWord);
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  UseCpp=TRUE;
  FP_WRITE=FP_UDT;
  fprintf(FP_WRITE,"%s%s%s\n",Scoot,"namespace ",Stk[2]);
  BumpUp();
  fprintf(FP_WRITE,"%s%s\n",Scoot,"{");
  InNameSpace++;
  return 0;
}

int Emit_CPP_Class (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(sWord);
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  UseCpp=TRUE;
  if(InClass||InTypeDef||InCppTypeDef||InFunction||ISNULL(Stk[2])){
      Abort("Syntax Error");
    }
  strcpy(InClassName,Stk[2]);
  if(UsingTemplate==FALSE ){
      fprintf(FP_UDT,"%s\n","");
    }
  if(NOTNULL(InIfDef) && strcmp(InIfDef,"FP3")!=0){
      fprintf(FP_UDT,"%s\n",InIfDef);
    }
  fprintf(FP_UDT,"%s","class ");
  FP_WRITE=FP_UDT;
  for(int i=2; i<=Ndx; i++)
    {
      if(iMatchWrd(Stk[i+1],"inherits")){
          strcpy(Stk[i], join(2,Stk[i],":"));
          strcpy(Stk[i+1],"public");
        }
      if(strcmp(Stk[i],"using")==0){
          fprintf(FP_UDT,"%s"," : ");
          continue;
        }
      if(strcmp(Stk[i],"::")==0){
          fprintf(FP_UDT,"%s"," : ");
        }
      else
        {
          if(iMatchWrd(Stk[i],"private")){
              strcpy(Stk[i],"private");
            }
          if(iMatchWrd(Stk[i],"public")){
              strcpy(Stk[i],"public");
            }
          AddSpace(i);
          fprintf(FP_UDT,"%s",Stk[i]);
        }
    }
  BumpUp();
  fprintf(FP_UDT,"%s%s%s\n","\n",Scoot,"{");
  InClass++;
  *InClassPP=0;
  if(UsingTemplate==TRUE ){
      WasAClass=TRUE;
    }
  return 0;
}

int Emit_CPP_Public (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(sWord);
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  UseCpp=TRUE;
  if(strcmp(Stk[2],":")==0){
      if(InClassPP[0]){
          fprintf(FP_UDT,"%s\n","");
          BumpDown("Error in Emit_CPP_Public");
        }
      fprintf(FP_UDT,"%s%s\n",Scoot,"public:");
      BumpUp();
      strcpy(InClassPP,"public");
      return 0;
    }
  return 0;
}

int Emit_CPP_Asm (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(sWord);
  Emit_Old(FuncRetnFlag);
  return 0;
}

int Emit_CPP_Protected (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(sWord);
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  UseCpp=TRUE;
  if(strcmp(Stk[2],":")==0){
      if(InClassPP[0]){
          fprintf(FP_UDT,"%s\n","");
          BumpDown("Error in Emit_CPP_Protected");
        }
      fprintf(FP_UDT,"%s%s\n",Scoot,"protected:");
      BumpUp();
      strcpy(InClassPP,"protected");
      return 0;
    }
  return 0;
}

int Emit_CPP_Private (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(sWord);
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  if(strcmp(Stk[2],":")==0){
      if(InClassPP[0]){
          fprintf(FP_UDT,"%s\n","");
          BumpDown("Error in Emit_CPP() CASE private");
        }
      fprintf(FP_UDT,"%s%s\n",Scoot,"private:");
      BumpUp();
      strcpy(InClassPP,"private");
      return 0;
    }
  return 0;
}

int Emit_CPP_EndNamespace (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(sWord);
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  UseCpp=TRUE;
  fprintf(FP_UDT,"%s%s\n",Scoot,"};\n");
  BumpDown("Extra unindents and/or missing indents before END NAMESPACE");
  InNameSpace--;
  return 0;
}

int Emit_CPP_Try (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(sWord);
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  UseCpp=TRUE;
  fprintf(FP_WRITE,"%s%s\n",Scoot,"try");
  BumpUp();
  fprintf(FP_WRITE,"%s%s\n",Scoot,"{");
  InBlockSet();
  return 0;
}

int Emit_CPP_EndTry (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(sWord);
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  UseCpp=TRUE;
  fprintf(FP_WRITE,"%s%s\n",Scoot,"}");
  BumpDown("Unbalanced TRY/END TRY");
  InBlockReSet();
  return 0;
}

int Emit_CPP_Throw (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(sWord);
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  UseCpp=TRUE;
  char LTmp[BCXSTRSIZE];
  if(Ndx==1 ){
      strcpy(LTmp,enc("An Exception has occured!"));
    }
  else
    {
      BuildDelimStr(2,Ndx,LTmp);
    }
  fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"throw ",LTmp,";");
  return 0;
}

int Emit_CPP_Catch (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(sWord);
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  UseCpp=TRUE;
  struct _VARCODE  VarCode;
  VarCode.IsExported=FALSE;
  VarCode.UseInLine=UseInLine;
  InBlockReSet();
  *gTmpStr=0;
  if(Ndx>1 ){
      int A;
      FuncSubDecs1("sub",1,Ndx,&(VarCode));
      FuncSubDecs2("sub",mt_Opts,&(VarCode),1,&(Ndx));
      VarCode.Methd=mt_FuncSubDecC_DecAParam;
      A=3;
      while(A<Ndx){
          GetParameter(&(A),&(VarCode),mt_OptsAParam,mt_OptsNoParam,1);
          A++;
        }
      VarCode.Methd=mt_FuncSubDecC_DecAParam;
      strcpy(VarCode.Token,Stk[1]);
      FuncSubDecs3(&(VarCode),Ndx,0);
      strcpy(gTmpStr,VarCode.Header);
    }
  else
    {
      strcpy(gTmpStr,"catch (LPCTSTR str)");
    }
  fprintf(FP_WRITE,"%s%s\n",Scoot,"}");
  BumpDown("Extra unindents and/or missing indents before CATCH");
  InBlockSet();
  fprintf(FP_WRITE,"%s%s\n",Scoot,gTmpStr);
  BumpUp();
  fprintf(FP_WRITE,"%s%s\n",Scoot,"{");
  return 0;
}

int Emit_CPP_Delete (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(sWord);
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  UseCpp=TRUE;
  char LTmp[BCXSTRSIZE];
  BuildCleanStr(2,Ndx,LTmp);
  fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"delete ",LTmp,";");
  return 0;
}

int Emit_DialogBox (char* sWord,PINT  FuncRetnFlag)
{
  if(strcmp(sWord,"dialogbox")==0){
      int L_Comma=0;
      fprintf(FP_WRITE,"%s%s",Scoot,"DialogBox");
      for(int A=2; A<=Ndx; A++)
        {
          if(strcmp(Stk[A],",")==0){
              L_Comma++;
            }
          if(L_Comma==3 ){
              if(strcmp(Stk[A],",")==0){
                  strcpy(Stk[A],",(DLGPROC)");
                }
            }
          fprintf(FP_WRITE,"%s",Clean(Stk[A]));
        }
      fprintf(FP_WRITE,"%s\n",";");
    }
  else
    {
      Emit_Old(FuncRetnFlag);
    }
  return 0;
}

char * Emit_Conditional_Operator_Repair (char* szArg)
{
  char   *BCX_RetStr={0};
  if(!InstrAny(szArg,"=!<>|&")){
      BCX_RetStr = BCX_TempStr(strlen(szArg));
      strcpy(BCX_RetStr,szArg);
      return BCX_RetStr;
    }
  char Tmp[BCXSTRSIZE]={0};
  strcpy(Tmp,trim(szArg));
  strcpy(Tmp,replace(Tmp,"= =","=="));
  strcpy(Tmp,replace(Tmp,"! =","!="));
  strcpy(Tmp,replace(Tmp,"< =","<="));
  strcpy(Tmp,replace(Tmp,"> =",">="));
  strcpy(Tmp,replace(Tmp,"| |","||"));
  strcpy(Tmp,replace(Tmp,"& &","&&"));
  BCX_RetStr = BCX_TempStr(strlen(Tmp));
  strcpy(BCX_RetStr,Tmp);
  return BCX_RetStr;
}

int Emit_ConditionalCompilation (char* sWord,PINT  FuncRetnFlag)
{
  if(strcmp(sWord,"~ifndef")==0){
      strcpy(InIfDef,"#ifndef ");
      for(int i=2; i<=Ndx; i++)
        {
          strcpy(InIfDef, join(3,InIfDef,Stk[i],SPC));
        }
      strcpy(InIfDef,Emit_Conditional_Operator_Repair(InIfDef));
      if(InFunction||InMain ){
          fprintf(FP_WRITE,"%s\n",InIfDef);
        }
      else
        {
          fprintf(FP_CST,"%s\n",InIfDef);
        }
      goto L1499;
    }
  if(strcmp(sWord,"~ifdef")==0){
      strcpy(InIfDef,"#if defined ");
      for(int i=2; i<=Ndx; i++)
        {
          strcpy(InIfDef, join(3,InIfDef,Stk[i],SPC));
        }
      strcpy(InIfDef,Emit_Conditional_Operator_Repair(InIfDef));
      strcpy(ConstLastDef,InIfDef);
      char tmp[BCXSTRSIZE]={0};
      strcpy(tmp,trim(LookAhead(SourceFile,1)));
      if(bcx_stricmp(left(tmp,4),"SUB ")==0  ||  bcx_stricmp(left(tmp,9),"FUNCTION ")==0){
          strcpy(tmp,"SUSPEND");
        }
      if(InFunction ){
          fprintf(FP_WRITE,"%s\n",InIfDef);
          strcpy(InIfDef,"FP3");
        }
      else
        {
          if(InMain && strcmp(tmp,"SUSPEND")!=0){
              fprintf(FP_WRITE,"%s\n",InIfDef);
            }
        }
      goto L1499;
    }
  if(strcmp(sWord,"~if")==0){
      strcpy(InIfDef,"#if ");
      for(int i=2; i<=Ndx; i++)
        {
          strcpy(InIfDef, join(3,InIfDef,Stk[i],SPC));
        }
      strcpy(InIfDef,Emit_Conditional_Operator_Repair(InIfDef));
      strcpy(ConstLastDef,InIfDef);
      if(InFunction ){
          fprintf(FP_WRITE,"%s\n",InIfDef);
          strcpy(InIfDef,"FP3");
        }
      else
        {
          if(InMain ){
              fprintf(FP_WRITE,"%s\n",InIfDef);
            }
        }
      goto L1499;
    }
  if(strcmp(sWord,"~elseif")==0){
      strcpy(InIfDef,"#elif defined ");
      for(int i=2; i<=Ndx; i++)
        {
          strcpy(InIfDef, join(3,InIfDef,Stk[i],SPC));
        }
      strcpy(InIfDef,Emit_Conditional_Operator_Repair(InIfDef));
      strcpy(ConstLastDef,InIfDef);
      if(InFunction||InMain ){
          fprintf(FP_WRITE,"%s\n",InIfDef);
        }
      else
        {
          fprintf(FP_CST,"%s\n",InIfDef);
        }
      goto L1499;
    }
  if(strcmp(sWord,"~else")==0){
      strcpy(InIfDef,"#else");
      strcpy(ConstLastDef,InIfDef);
      if(InFunction||InMain ){
          fprintf(FP_WRITE,"%s\n",InIfDef);
        }
      else
        {
          fprintf(FP_CST,"%s\n",InIfDef);
        }
      goto L1499;
    }
  if(strcmp(sWord,"~endif")==0){
      if(strcmp(InIfDef,"FP3")==0){
          fprintf(FP3,"%s\n","#endif");
        }
      else
        {
          fprintf(FP_WRITE,"%s\n","#endif");
        }
      if(strcmp(ConstLastDef,"FP_CST")==0){
          fprintf(FP_CST,"%s\n","#endif");
        }
      strcpy(InIfDef,"#endif");
      if(InConditional==0 ){
          *InIfDef=0;
          *ConstLastDef=0;
        }
      goto L1499;
    }
  if(strcmp(sWord,"~pragmaoptimizeon")==0){
      fprintf(FP_WRITE,"%s\n","#ifdef __POCC__");
      fprintf(FP_WRITE,"%s\n","#pragma optimize(time)");
      fprintf(FP_WRITE,"%s\n","#endif");
      fprintf(FP_WRITE,"%s\n","#ifdef __LCC__");
      fprintf(FP_WRITE,"%s\n","#pragma optimize(1)");
      fprintf(FP_WRITE,"%s\n","#endif");
      goto L1499;
    }
  if(strcmp(sWord,"~pragmaoptimizeoff")==0){
      fprintf(FP_WRITE,"%s\n","#ifdef __POCC__");
      fprintf(FP_WRITE,"%s\n","#pragma optimize(none)");
      fprintf(FP_WRITE,"%s\n","#endif");
      fprintf(FP_WRITE,"%s\n","#ifdef __LCC__");
      fprintf(FP_WRITE,"%s\n","#pragma optimize(0)");
      fprintf(FP_WRITE,"%s\n","#endif");
    }
  else
    {
      Emit_Old(FuncRetnFlag);
    }
L1499:;
  return 0;
}

int Emit_Shared_Global (char* sWord,PINT  FuncRetnFlag)
{
  if(strcmp(sWord,"shared")==0  || strcmp(sWord,"global")==0){
      static int wxy;
      static char SOF[BCXSTRSIZE];
      static int IsShared;
      static int IsVolatile;
      static int IsSubOrFuncPtr;
      static char CVar[BCXSTRSIZE];
      static int id;
      static int vt;
      static int dms;
      static int IsPointer;
      static char LZZ[BCXSTRSIZE];
      wxy=0;
      IsSubOrFuncPtr=SubFuncTest();
      Process_Option_Base();
      IsVolatile=iMatchWrd(Stk[2],"volatile");
      strcpy(CVar,Clean(Stk[2+IsVolatile]));
      ValidateVarName(CVar);
      IsShared=iMatchWrd(Stk[1],"shared");
      if(strcmp(Stk[Ndx],"*")==0){
          PointerFix();
        }
      if(strcmp(Stk[Ndx],"&")==0){
          *Stk[Ndx--]=0;
          strcpy(Stk[Ndx], join(2,Stk[Ndx],"&"));
        }
      if(strcmp(Stk[3+IsVolatile],"*")==0){
          if(IsVolatile ){
              Abort("volatile dynamic strings not supported");
            }
          DimDynaString(CVar,1,IsShared);
          goto L1504;
        }
      if(IsSubOrFuncPtr ){
          if(IsVolatile ){
              Abort("volatile SUB/FUNCTION pointers not supported");
            }
          DimSubFunc(0);
          goto L1504;
        }
      if(iMatchWrd(Stk[2],"dynamic")){
          strcpy(CVar,Clean(Stk[3]));
          ValidateVarName(CVar);
          if(iMatchWrd(Stk[Ndx-1],"as")){
              strcpy(SOF,Stk[Ndx]);
              GetTypeInfo(SOF,&(wxy),&(id),&(vt));
              if(vt==vt_STRLIT||vt==vt_DECFUNC||vt==vt_NUMBER||(vt==vt_VOID&&inchr(Stk[Ndx],"*")==0)){
                  Abort(join(2,Stk[Ndx]," is not a valid type"));
                }
              Ndx-=(2);
            }
          else
            {
              vt=DataType(Stk[3]);
              id=0;
              strcpy(SOF,GetVarTypeName(vt));
            }
          Use_DynamicA=Use_BcxTempStr=TRUE;
          BuildStr(4,Ndx,LZZ);
          dms=tally(LZZ,"][")+1;
          if(dms>1 ){
              strcpy(LZZ,replace(LZZ,"][",","));
            }
          strcpy(LZZ,Clean(LZZ));
          RemoveAll(LZZ,"[]");
          if(vt==vt_STRVAR ){
              vt=vt_CHAR;
              strcpy(SOF,"char");
              dms++;
              strcat(LZZ,",");
              strcat(LZZ,"BCXSTRSIZE");
            }
          if(Use_GenFree ){
              AddDynamicGlobal(join(9,"if (",CVar,") {DestroyArr((void **)",CVar,",",str(dms),", 1); ",CVar,"=NULL;}"));
            }
          AddGlobal(CVar,vt,id,"",dms);
          strcpy(LZZ,replace(LZZ,",",", (size_t)"));
          fprintf(FP_WRITE,"%s%s\n",Scoot,"{");
          fprintf(FP_WRITE,"%s%s%s%s%s%s\n",Scoot,"size_t dimensions[",trim(str(dms)),"] = {(size_t)",LZZ,"};");
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s%s%s%s%s\n",Scoot,CVar,"= (",SOF,stringx(dms,42),")CreateArr (",CVar,", sizeof(",SOF,"), 0,",str(dms,1),", dimensions);");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"}");
          goto L1504;
        }
      IsPointer=0;
      strcpy(Var,Clean(Stk[2+IsVolatile]));
      ValidateVarName(Var);
      if(iMatchWrd(Stk[Ndx-1],"as")){
          if(inchr(Stk[Ndx],"*")){
              IsPointer=tally(Stk[Ndx],"*");
              strcpy(Stk[Ndx],RemoveStr(Stk[Ndx],"*"));
            }
          BuildStr(3+IsVolatile,Ndx-2,DimType);
          GetTypeInfo(Stk[Ndx],&(wxy),&(id),&(vt));
        }
      else
        {
          BuildStr(3+IsVolatile,Ndx,DimType);
          vt=DataType(Stk[2+IsVolatile]);
          id=0;
        }
      if(vt==vt_STRVAR ){
          strcat(DimType,"[BCXSTRSIZE]");
        }
      if(vt==vt_UDT ){
          if(ComSwitchON ){
              if(strcmp(TypeDefs[id].VarName,"OBJECT")==0){
                  Add_COM_Global_Variable(CVar);
                  Use_COM=Use_BcxTempStr=TRUE;
                }
            }
        }
      wxy=0;
      if(IsShared ){
          wxy=2;
        }
      if(IsVolatile ){
          wxy+=3;
        }
      AddGlobal(Var,vt,id,DimType,IsPointer,0,wxy);
    }
  else
    {
      Emit_Old(FuncRetnFlag);
    }
L1504:;
  return 0;
}

int Emit_EndFuncSub (char* sWord,PINT  FuncRetnFlag)
{
  if(strcmp(sWord,"endfunction")==0  || strcmp(sWord,"endsub")==0){
      AuxLocalDynArrayCount=0;
      InMain=TRUE;
      if(LoopTypeCnt ){
          LoopErrorMsg();
        }
      if(COM_lc_names_index>0 ){
          BCX_FreeLocalCOMObjects(TRUE);
        }
      if(iMatchWrd(Stk[1],"endfunction")){
          InWinMain=FALSE;
          LocalDynaCnt=0;
          LocalDynArrCnt=0;
          if(InDialogEvt ){
              fprintf(FP_WRITE,"%s%s\n",Scoot,"if(Msg==WM_CLOSE) DestroyWindow(hWnd);");
              if(Use_Sound ){
                  fprintf(FP_WRITE,"%s%s\n",Scoot,"midiOutClose (hMidi);");
                }
              fprintf(FP_WRITE,"%s%s\n",Scoot,"return EXIT_SUCCESS;");
              InDialogEvt=FALSE;
            }
          if(ModDialogEvt ){
              fprintf(FP_WRITE,"%s%s\n",Scoot,"if(Msg==WM_CLOSE) EndDialog(hWnd,0);");
              if(Use_Sound ){
                  fprintf(FP_WRITE,"%s%s\n",Scoot,"midiOutClose (hMidi);");
                }
              fprintf(FP_WRITE,"%s%s\n",Scoot,"return EXIT_SUCCESS;");
              ModDialogEvt=FALSE;
            }
          if(CallBackFlag ){
              fprintf(FP_WRITE,"%s%s\n",Scoot,"return DefWindowProc(hWnd, Msg, wParam, lParam);");
              CallBackFlag=FALSE;
            }
        }
      if(iMatchWrd(Stk[1],"endsub")){
          if(NOTZERO(LocalDynaCnt)){
              for(int j=1; j<=LocalDynaCnt; j++)
                {
                  fprintf(FP_WRITE,"%s%s\n",Scoot,DynaStr[j]);
                }
              LocalDynaCnt=0;
            }
          if(NOTZERO(LocalDynArrCnt)){
              for(int i=1; i<=LocalDynArrCnt; i++)
                {
                  fprintf(FP_WRITE,"%s%s\n",Scoot,LocalDynArrName[i]);
                }
              LocalDynArrCnt=0;
            }
        }
      if(ForceMainToFunc==TRUE&&NoMain==FALSE ){
          if(Use_Sound ){
              fprintf(FP_WRITE,"%s%s\n",Scoot,"midiOutClose (hMidi);");
            }
          fprintf(FP_WRITE,"%s%s\n",Scoot,"return EXIT_SUCCESS;");
          ForceMainToFunc=FALSE;
        }
      BumpDown("Unbalance statements occurred before END");
      if(InNameSpace||InClass||InCppTypeDef ){
          fprintf(FP_UDT,"%s%s\n",Scoot,"}\n");
          int  iIndentsUsed;
          char szErr[BCXSTRSIZE];
          iIndentsUsed=0;
          *szErr=0;
          if(InNameSpace ){
              iIndentsUsed+=((InNameSpace*2));
              strcpy(szErr," Namespace,");
            }
          if(InClass ){
              iIndentsUsed+=(((InClass+1)*2));
              strcat(szErr," Class Module,");
            }
          if(InCppTypeDef ){
              iIndentsUsed+=((InCppTypeDef*2));
              strcat(szErr," PPType,");
            }
          if(Indent>iIndentsUsed ){
              strcpy(szErr,left(szErr,(int)strlen(szErr)-1));
              strcpy(szErr, join(5,"Possible missing (",Using("##",(Indent-iIndentsUsed)*0.5),") END statements in",szErr," SUB/FUNCTION"));
              printf("%s\n",repeat(80,"_"));
              printf("%s\n",szErr);
              printf("%s\n",repeat(80,"_"));
            }
        }
      else
        {
          fprintf(FP_WRITE,"%s%s\n",Scoot,"}\n\n");
        }
      InFunction=Use_Static=FALSE;
      if(FP_WRITE==FP3 ){
          strcpy(InIfDef,"FP3");
        }
      if(!(InNameSpace||InClass)){
          FP_WRITE=FP2;
        }
      ByrefCnt=0;
    }
  else
    {
      Emit_Old(FuncRetnFlag);
    }
  return 0;
}

int Emit_Union (char* sWord,PINT  FuncRetnFlag)
{
  if(strcmp(sWord,"union")==0){
      if(InTypeDef==0 ){
          SaveFP_WRITENum=FP_WRITE;
        }
      FP_WRITE=FP_UDT;
      InTypeDef++;
      if(cMaxBaseTypeDefs==InTypeDef ){
          Abort("Maximum number of nested TypeDefs exceeded.");
        }
      strcpy(TypeDefName[InTypeDef],Stk[2]);
      AddTypeDefs(TypeDefName[InTypeDef],vt_UNION);
      BaseTypeDefsCnt[InTypeDef]=TypeDefsCnt;
      fprintf(FP_WRITE,"%s\n","");
      if(InTypeDef==1 ){
          fprintf(FP_WRITE,"%s\n","typedef union ");
          fprintf(FP_WRITE,"%s\n","{");
        }
      else
        {
          fprintf(FP_WRITE,"%s%s\n",Scoot,"union");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"{");
          AddTypedefElement(BaseTypeDefsCnt[InTypeDef-1],vt_UNION,TypeDefName[InTypeDef],TypeDefName[InTypeDef]);
        }
      BumpUp();
      goto L1508;
    }
  if(strcmp(sWord,"endunion")==0){
      BumpDown("Unbalanced UNION/END UNION");
      if(InTypeDef==1 ){
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n","} ",TypeDefName[InTypeDef],", *LP",ucase(TypeDefName[InTypeDef]),", *",ucase(TypeDefName[InTypeDef]),"_PTR",";");
          FP_WRITE=SaveFP_WRITENum;
        }
      else
        {
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"} ",TypeDefName[InTypeDef],";");
        }
      fprintf(FP_WRITE,"%s\n","");
      InTypeDef--;
    }
  else
    {
      Emit_Old(FuncRetnFlag);
    }
L1508:;
  return 0;
}

int Emit_Type (char* sWord,PINT  FuncRetnFlag)
{
  UNREFERENCED_PARAMETER(FuncRetnFlag);
  if(strcmp(sWord,"type")==0){
      static int i;
      static int j;
      if(InTypeDef==0 ){
          SaveFP_WRITENum=FP_WRITE;
        }
      FP_WRITE=FP_UDT;
      if(Ndx>2 ){
          if(InTypeDef ){
              Abort("Single line TYPE within type/union not supported");
            }
          i=GetAsPosB(Ndx,1);
          if(i==0 ){
              Abort("Missing AS TYPE");
            }
          fprintf(FP_WRITE,"%s%s",Scoot,"typedef ");
          j=i-1;
          i++;
          while(i<=Ndx){
              fprintf(FP_WRITE,"%s%s",Stk[i],SPC);
              i++;
            }
          for(i=2; i<=j; i++)
            {
              fprintf(FP_WRITE,"%s",Stk[i]);
            }
          fprintf(FP_WRITE,"%s\n",";");
          FP_WRITE=SaveFP_WRITENum;
        }
      else
        {
          InTypeDef++;
          if(cMaxBaseTypeDefs==InTypeDef ){
              Abort("Maximum number of nested TypeDefs exceeded.");
            }
          strcpy(TypeDefName[InTypeDef],Stk[2]);
          AddTypeDefs(TypeDefName[InTypeDef],vt_STRUCT);
          BaseTypeDefsCnt[InTypeDef]=TypeDefsCnt;
          if(InClass||InTypeDef>1 ){
              fprintf(FP_WRITE,"%s%s\n",Scoot,"struct");
              fprintf(FP_WRITE,"%s%s\n",Scoot,"{");
              AddTypedefElement(BaseTypeDefsCnt[InTypeDef-1],vt_STRUCT,TypeDefName[InTypeDef],TypeDefName[InTypeDef]);
            }
          else
            {
              fprintf(FP_WRITE,"%s\n","");
              fprintf(FP_WRITE,"%s%s\n","typedef struct _",TypeDefName[InTypeDef]);
              fprintf(FP_WRITE,"%s\n","{");
            }
          BumpUp();
        }
      goto L1509;
    }
  if(strcmp(sWord,"endtype")==0){
      BumpDown("Unbalanced TYPE/END TYPE");
      if(InClass ){
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"} ",TypeDefName[InTypeDef],";");
          fprintf(FP_WRITE,"%s\n","");
        }
      else
        {
          char szTDNames[BCXSTRSIZE]={0};
          if(Ndx>1 ){
              static int i;
              static int j;
              i=GetAsPosB(Ndx,1);
              if(i==0 ){
                  Abort("Missing AS after END TYPE");
                }
              strcpy(szTDNames,", ");
              for(int ii=i+1; ii<=Ndx; ii++)
                {
                  j=inchr(Stk[ii],"*");
                  if(j ){
                      strcpy(Stk[ii], join(2,mid(Stk[ii],j),left(Stk[ii],j-1)));
                    }
                  strcat(szTDNames,Stk[ii]);
                }
            }
          if(InTypeDef==1 ){
              fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s%s\n","}",TypeDefName[InTypeDef],", *LP",ucase(TypeDefName[InTypeDef]),", *",ucase(TypeDefName[InTypeDef]),"_PTR",szTDNames,";");
              fprintf(FP_WRITE,"%s\n","");
              FP_WRITE=SaveFP_WRITENum;
              fprintf(FP_CST,"%s%s%s%s%s%s\n",Scoot,"#define ",ucase(TypeDefName[InTypeDef]),"_CLASS struct _",ucase(TypeDefName[InTypeDef]),"*");
            }
          else
            {
              fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,"} ",TypeDefName[InTypeDef],szTDNames,";");
              fprintf(FP_WRITE,"%s\n","");
            }
        }
      InTypeDef--;
    }
L1509:;
  return 0;
}

int Emit_PPType (char* sWord,PINT  FuncRetnFlag)
{
  if(strcmp(sWord,"pptype")==0){
      FP_WRITE=FP_UDT;
      if(InTypeDef||InCppTypeDef||InClass||InFunction||ISNULL(Stk[2])){
          Abort("Syntax Error");
        }
      fprintf(FP_UDT,"%s\n","");
      if(strcmp(InIfDef,"FP3")!=0  && NOTNULL(InIfDef)){
          fprintf(FP_UDT,"%s\n",InIfDef);
        }
      fprintf(FP_UDT,"%s","struct ");
      for(int i=2; i<=Ndx; i++)
        {
          if(iMatchWrd(Stk[i],"using")){
              strcpy(Stk[i],": ");
            }
          AddSpace(i);
          fprintf(FP_UDT,"%s",Stk[i]);
        }
      BumpUp();
      fprintf(FP_UDT,"%s%s%s\n","\n",Scoot,"{");
      InCppTypeDef++;
      goto L1513;
    }
  if(strcmp(sWord,"endpptype")==0){
      if(InCppTypeDef!=1 ){
          Abort("Syntax Error");
        }
      BumpDown("Extra unindents and/or missing indents before END PPTYPE");
      fprintf(FP_UDT,"%s%s\n",Scoot,"};");
      InCppTypeDef--;
    }
  else
    {
      Emit_Old(FuncRetnFlag);
    }
L1513:;
  return 0;
}

void GetParameterASHelper (int iEQPos,int iASPos,int iOptOk,int iLoc)
{
  static int iLast;
  if(iOptOk==0 ){
      Abort("Optional variables not supported without OPTIONAL");
    }
  if(iASPos==0 ){
      iLast=iLoc;
    }
  else
    {
      if(iASPos<iEQPos ){
          iLast=iLoc;
        }
      else
        {
          iLast=iASPos-1;
        }
    }
  for(int i=iEQPos+1; i<=iLast; i++)
    {
      strcpy(Stk[iEQPos], join(2,Stk[iEQPos],SPC));
      strcpy(Stk[iEQPos], join(2,Stk[iEQPos],Stk[i]));
      *Stk[i]=0;
    }
}

void GetParameter (PINT  piStart,VARCODE*  ptVar,int iAParam,int iNoParam,int iOptOk)
{
  int iASPos=0;
  int iEQPos=0;
  int iNd;
  int iLoc=*piStart;
  if(ISNULL(Stk[iLoc])){
      return;
    }
  strcpy(ptVar->Token,Clean(Stk[iLoc]));
  for(;;)
    {
      if(strcmp(Stk[iLoc+1],"(")==0){
          static int iEndPoint;
          static char LTmp[BCXSTRSIZE];
          static int iStartPoint;
          struct _FUNCPARSE  FP;
          Clear(FP);
          *CallType=0;
          SepFuncArgs(iLoc-1,&(FP),TRUE);
          iStartPoint=IMAX(FP.CommaPos[0],iLoc);
          SFPOINTER=TRUE;
          if(FP.NumArgs==0 ){
              iEndPoint=IMIN(FP.CommaPos[1]+1,Ndx);
            }
          else
            {
              iEndPoint=IMIN(FP.CommaPos[FP.NumArgs]+1,Ndx);
            }
          if(strcmp(Stk[iEndPoint],"=")==0){
              *Stk[iEndPoint++]=0;
              while(!iMatchWrd(Stk[iEndPoint],"as")&&iEndPoint<=Ndx){
                  strcat(LTmp,Stk[iEndPoint]);
                  *Stk[iEndPoint++]=0;
                }
              RemoveAll(LTmp,"{}",1);
              if(NOTNULL(LTmp)){
                  RemEmptyTokens();
                }
            }
          static char L_FuncName[BCXSTRSIZE];
          static int OldiEndPoint;
          if(iMatchWrd(Stk[iEndPoint],"as")){
              iEndPoint++;
              if(iMatchWrd(Stk[iEndPoint],"function")){
                  LShiftStk(iEndPoint);
                }
              while(*Stk[iEndPoint]!=44&&*Stk[iEndPoint]!=41){
                  if(ISNULL(Stk[iEndPoint])){
                      LShiftStk(iEndPoint);
                    }
                  else
                    {
                      iEndPoint++;
                    }
                }
            }
          OldiEndPoint=iEndPoint;
          static VARCODE  tVar;
          tVar.IsExported=FALSE;
          tVar.UseInLine=UseInLine;
          *piStart=iStartPoint-1;
          InsertTokens((*piStart)-1,1,"function");
          FuncSubDecs1("sub",iStartPoint-1,iEndPoint,&(tVar));
          FuncSubDecs2("sub",mt_FuncSubDecC_Dec,&(tVar),*piStart,&(OldiEndPoint));
          strcpy(tVar.Functype,ltrim(tVar.Functype));
          strcpy(L_FuncName,Clean(Stk[iStartPoint]));
          *piStart=iStartPoint+2;
          while(*piStart<OldiEndPoint){
              GetParameter(piStart,&(tVar),mt_FuncSubDecC_DecAParam,mt_FuncSubDecC_DecNoParam,0);
              (*piStart)++;
            }
          tVar.Methd=mt_FuncSubDecC_DecAParam;
          strcpy(tVar.Token,L_FuncName);
          FuncSubDecs3(&(tVar),OldiEndPoint,1);
          strcat(ptVar->Header,tVar.Header);
          strcat(ptVar->Proto,tVar.Proto);
          *piStart=iEndPoint;
          if(strcmp(Stk[(*piStart)+1],",")==0){
              strcat(ptVar->Header,",");
              strcat(ptVar->Proto,",");
              (*piStart)++;
            }
          SFPOINTER=FALSE;
          return;
        }
      if(strcmp(Stk[iLoc],",")==0  || strcmp(Stk[iLoc],")")==0){
          goto L1516;
        }
      if(iMatchWrd(Stk[iLoc],"as")){
          iASPos=iLoc;
        }
      if(iMatchWrd(Stk[iLoc],"=")){
          iEQPos=iLoc;
        }
      iLoc++;
    }
L1516:;
  iLoc--;
  if(strcmp(Stk[iLoc],"...")!=0){
      int iIsConst=0;
      if(iEQPos ){
          GetParameterASHelper(iEQPos,iASPos,iOptOk,iLoc);
        }
      if(iASPos ){
          int iLast=iLoc;
          int iAfterAs1=iASPos+1;
          int iAfterAs2=iASPos+2;
          if(iASPos<iEQPos ){
              iLast=iEQPos-1;
            }
          if(iAfterAs1!=iLast ){
              if(iMatchWrd(Stk[iAfterAs1],"const")){
                  iIsConst=1;
                  strcpy(Stk[iAfterAs1], join(2,Stk[iAfterAs1],SPC));
                  strcpy(Stk[iAfterAs1], join(2,Stk[iAfterAs1],Stk[iAfterAs2]));
                  *Stk[iAfterAs2]=0;
                }
                {
                int  i;
                for(i=iAfterAs2; i<=iLast; i++)
                  {
                    if(iMatchWrd(Stk[i],"ptr")){
                        strcpy(Stk[i],"*");
                      }
                    strcpy(Stk[iAfterAs1], join(2,Stk[iAfterAs1],Stk[i]));
                    *Stk[i]=0;
                  }
                  }
            }
          strcpy(ptVar->AsToken,Stk[iAfterAs1]);
          GetTypeInfo(ptVar->AsToken,&((ptVar->IsPtrFlag)),&(iNd),&((ptVar->VarNo)));
        }
      else
        {
          int iPtrCnt=tally(Stk[*piStart],"*");
          strcpy(ptVar->AsToken, join(2,VarTypeLookup[inchr(VARTYPES,right(Stk[*piStart],1))],stringx(iPtrCnt,42)));
          strcpy(Stk[*piStart],RemoveStr(Stk[*piStart],"*"));
          GetTypeInfo(ptVar->AsToken,&((ptVar->IsPtrFlag)),&(iNd),&((ptVar->VarNo)));
        }
      ptVar->Methd=iAParam;
      GetVarCode(ptVar,"GetParameter 1");
      if(iEQPos ){
          ptVar->Methd=iNoParam;
          strcpy(ptVar->Token,Stk[iEQPos]);
          GetVarCode(ptVar,"GetParameter 2");
        }
      AddLocal(ptVar->Token,ptVar->VarNo,0,"",ptVar->IsPtrFlag,0,0,iIsConst);
    }
  else
    {
      ptVar->Methd=iNoParam;
      strcpy(ptVar->Token,Stk[iLoc]);
      GetVarCode(ptVar,"GetParameter 3");
    }
  iLoc++;
  if(strcmp(Stk[iLoc],",")==0){
      ptVar->Methd=iNoParam;
      strcpy(ptVar->Token,Stk[iLoc]);
      GetVarCode(ptVar,"GetParameter 4");
    }
  *piStart=iLoc;
}

int Emit_OptFuncSub (char* sWord,PINT  FuncRetnFlag)
{
  if(strcmp(sWord,"optfunction")==0  || strcmp(sWord,"optsub")==0){
      int  IOptLoc;
      struct _VARCODE  VarCode;
      VarCode.IsExported=FALSE;
      VarCode.UseInLine=UseInLine;
      FuncSubDecs1("optsub",1,Ndx,&(VarCode));
      InFunction=TRUE;
      LocalVarCnt=0;
      if(InNameSpace ){
          FP_WRITE=FP2;
        }
      else
        {
          if(UsingTemplate==FALSE ){
              FP_WRITE=FP3;
            }
        }
      FuncSubDecs2("optsub",mt_Opts,&(VarCode),1,&(Ndx));
      strcpy(FunctionName,Clean(Stk[2]));
      IOptLoc=4;
      while(IOptLoc<Ndx){
          GetParameter(&(IOptLoc),&(VarCode),mt_OptsAParam,mt_OptsNoParam,1);
          IOptLoc++;
        }
      VarCode.Methd=mt_FuncSubDecC_DecAParam;
      strcpy(VarCode.Token,FunctionName);
      FuncSubDecs3(&(VarCode),Ndx,0);
      if(Use_Static ){
          strcpy(VarCode.Header, join(2,"static ",VarCode.Header));
          strcpy(VarCode.Proto, join(2,"static ",VarCode.Proto));
        }
      AddProto(VarCode.Proto);
      if(strcmp(InIfDef,"FP3")==0){
          *ProtoType[ProtoCnt].Condition=0;
        }
      else
        {
          strcpy(ProtoType[ProtoCnt].Condition,InIfDef);
        }
      ProtoType[ProtoCnt].CondLevel=InConditional;
      fprintf(FP_WRITE,"%s\n",VarCode.Header);
      fprintf(FP_WRITE,"%s%s\n",Scoot,"{");
      BumpUp();
    }
  else
    {
      Emit_Old(FuncRetnFlag);
    }
  return 0;
}

int Emit_OverLoadFuncSub (char* sWord,PINT  FuncRetnFlag)
{
  static VARCODE  VarCode;
  Use_Overloaded_Macro=TRUE;
  VarCode.IsExported=FALSE;
  VarCode.UseInLine=UseInLine;
  if(strcmp(sWord,"overloadedfunction")==0  || strcmp(sWord,"overloadedsub")==0){
      static char LTmp[BCXSTRSIZE];
      static int A;
      Use_Overloaded=TRUE;
      FuncSubDecs1("overloadedsub",1,Ndx,&(VarCode));
      if(strcmp(sWord,"overloadedfunction")==0){
          InFunction=eFunctionType;
        }
      else
        {
          InFunction=eSubType;
        }
      InMain=FALSE;
      LocalVarCnt=0;
      if(UsingTemplate==FALSE ){
          FP_WRITE=FP_OVR;
        }
      FuncSubDecs2("overloadedsub",mt_OverLoad,&(VarCode),1,&(Ndx));
      strcpy(FunctionName,Clean(Stk[2]));
      strcpy(LTmp, join(2," overloaded ",FunctionName));
      strcpy(FunctionName,LTmp);
      A=4;
      while(A<Ndx){
          GetParameter(&(A),&(VarCode),mt_OverLoadAParam,mt_OverLoadNoParam,0);
          A++;
        }
      VarCode.Methd=mt_FuncSubDecC_Dec;
      strcpy(VarCode.Token,FunctionName);
      FuncSubDecs3(&(VarCode),Ndx,0);
      if(Use_Static ){
          strcpy(VarCode.Header, join(2,"static ",VarCode.Header));
        }
      fprintf(FP_WRITE,"%s\n",VarCode.Header);
      fprintf(FP_WRITE,"%s%s\n",Scoot,"{");
      BumpUp();
    }
  else
    {
      Emit_Old(FuncRetnFlag);
    }
  return 0;
}

int ClassProto (PCHAR szProto)
{
  static int iReturn;
  static int iCnt;
  for(iReturn=0,iCnt=0; iCnt<iClassCnt && iReturn==0; iCnt++)
    {
      if(strcmp(szProto,ClassNames[iCnt])==0){
          iReturn=1;
        }
    }
  return iReturn;
}

int Emit_ConDes (char* sWord,PINT  FuncRetnFlag)
{
  if(strcmp(sWord,"constructor")==0  || strcmp(sWord,"destructor")==0){
      if(InFunction ){
          Abort("Syntax Error: already in function");
        }
      int A;
      char CTOR_USE[BCXSTRSIZE];
      int New_Ndx=Ndx;
      int iCPPFunSub;
      struct _VARCODE  VarCode;
      VarCode.IsExported=FALSE;
      VarCode.UseInLine=UseInLine;
      iCPPFunSub=0;
      for(int ct=1; ct<=Ndx; ct++)
        {
          if(strcmp(Stk[ct],"using")==0){
              iCPPFunSub=1;
              New_Ndx=ct-1;
              BuildDelimStr(ct+1,Ndx,CTOR_USE);
              goto L1527;
            }
        }
L1527:;
      Ndx=New_Ndx;
      FuncSubDecs1("sub",1,Ndx,&(VarCode));
      IsStdFunc=FALSE;
      InMain=FALSE;
      LocalVarCnt=0;
      if(InNameSpace||InClass||InCppTypeDef ){
          InFunction=FALSE;
          FP_WRITE=FP_UDT;
        }
      else
        {
          InFunction=TRUE;
          if(UsingTemplate==FALSE ){
              FP_WRITE=FP3;
            }
        }
      FuncSubDecs2("sub",mt_ConsDes,&(VarCode),1,&(Ndx));
      strcpy(VarCode.Functype,ltrim(VarCode.Functype));
      strcpy(FunctionName,Clean(Stk[2]));
      A=4;
      while(A<Ndx){
          GetParameter(&(A),&(VarCode),mt_ConsDesAParam,mt_ConsDesNoParam,1);
          A++;
        }
      if((strcmp(sWord,"constructor")==0)  || (ISTRUE(inchr(FunctionName,"~")))){
          strcpy(VarCode.Token,FunctionName);
        }
      else
        {
          strcpy(VarCode.Token, join(2,"~",FunctionName));
        }
      VarCode.Methd=mt_FuncSubDecC_DecAParam;
      FuncSubDecs3(&(VarCode),Ndx,0);
      if(Use_Static ){
          strcpy(VarCode.Header, join(2,"static ",VarCode.Header));
          strcpy(VarCode.Proto, join(2,"static ",VarCode.Proto));
        }
      if(iMatchNQ(VarCode.Proto,"::")==0&&IAmNot(InNameSpace)&&IAmNot(InClass)&&IAmNot(InCppTypeDef)){
          iCPPFunSub=0;
          AddProto(VarCode.Proto);
          if(strcmp(InIfDef,"FP3")==0){
              if(ProtoCnt>1 ){
                  strcpy(ProtoType[ProtoCnt].Condition,ProtoType[ProtoCnt-1].Condition);
                }
              else
                {
                  *ProtoType[ProtoCnt].Condition=0;
                }
            }
          else
            {
              strcpy(ProtoType[ProtoCnt].Condition,InIfDef);
            }
          ProtoType[ProtoCnt].CondLevel=InConditional;
          if(*InIfDef ){
              if(strcmp(InIfDef,"FP3")!=0){
                  fprintf(FP_WRITE,"%s\n",InIfDef);
                }
            }
        }
      if(iCPPFunSub==1 ){
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,VarCode.Header,": ",CTOR_USE);
        }
      else
        {
          fprintf(FP_WRITE,"%s%s\n",Scoot,VarCode.Header);
        }
      fprintf(FP_WRITE,"%s%s\n",Scoot,"{");
      BumpUp();
      goto L1526;
    }
  if(strcmp(sWord,"endconstructor")==0){
      BumpDown("Unbalanced CONSTRUCTOR/END CONSTRUCTOR");
      fprintf(FP_WRITE,"%s%s\n",Scoot,"}");
      InFunction=FALSE;
      goto L1526;
    }
  if(strcmp(sWord,"enddestructor")==0){
      BumpDown("Unbalanced DESTRUCTOR/END DESTRUCTOR");
      fprintf(FP_WRITE,"%s%s\n",Scoot,"}");
      InFunction=FALSE;
    }
  else
    {
      Emit_Old(FuncRetnFlag);
    }
L1526:;
  return 0;
}

int Emit_Implied (char* sWord,PINT  FuncRetnFlag)
{
  if(strcmp(sWord,"impfunction")==0){
      int A;
      char szImp[BCXSTRSIZE];
      struct _VARCODE  VarCode;
      VarCode.IsExported=FALSE;
      VarCode.UseInLine=UseInLine;
      FuncSubDecs1("sub",1,Ndx,&(VarCode));
      IsStdFunc=FALSE;
      InMain=FALSE;
      LocalVarCnt=0;
      FuncSubDecs2("sub",mt_FuncSubDecC_Dec,&(VarCode),1,&(Ndx));
      *szImp=0;
      for(;;)
        {
          strcpy(szImp, join(2,Stk[Ndx],szImp));
          if(!(strcmp(Stk[Ndx--],"=")!=0)){
              goto L1530;
            }
        }
L1530:;
      strcpy(VarCode.Functype,ltrim(VarCode.Functype));
      strcpy(FunctionName,Clean(Stk[2]));
      A=4;
      while(A<Ndx){
          GetParameter(&(A),&(VarCode),mt_OptsAParam,mt_OptsNoParam,1);
          A++;
        }
      VarCode.Methd=mt_FuncSubDecC_DecAParam;
      strcpy(VarCode.Token,FunctionName);
      FuncSubDecs3(&(VarCode),Ndx,0);
      fprintf(FP_UDT,"%s%s%s%s\n",Scoot,VarCode.Header,szImp,";");
    }
  else
    {
      Emit_Old(FuncRetnFlag);
    }
  return 0;
}

int Emit_FuncSub (char* sWord,PINT  FuncRetnFlag)
{
  if(strcmp(sWord,"function")==0  || strcmp(sWord,"sub")==0  || strcmp(sWord,"publicfunction")==0  || strcmp(sWord,"publicsub")==0  || strcmp(sWord,"privatefunction")==0  || strcmp(sWord,"privatesub")==0){
      if(InFunction ){
          Abort("Syntax Error: Nested functions not supported.");
        }
      static int A;
      static char CTOR_USE[BCXSTRSIZE];
      static int iCPPFunSub;
      static VARCODE  VarCode;
      int New_Ndx=Ndx;
      VarCode.IsExported=FALSE;
      VarCode.UseInLine=UseInLine;
      if(strcmp(sWord,"publicfunction")==0  || strcmp(sWord,"publicsub")==0){
          strcpy(Stk[1],mid(Stk[1],6));
          goto L1533;
        }
      if(strcmp(sWord,"privatefunction")==0  || strcmp(sWord,"privatesub")==0){
          strcpy(Stk[1],mid(Stk[1],7));
        }
L1533:;
      iCPPFunSub=0;
      for(int ct=1; ct<=Ndx; ct++)
        {
          if(iMatchWrd(Stk[ct],"using")){
              iCPPFunSub=1;
              New_Ndx=ct-1;
              BuildDelimStr(ct+1,Ndx,CTOR_USE);
              goto L1534;
            }
        }
L1534:;
      Ndx=New_Ndx;
      if(strcmp(Stk[2],"main")==0){
          NoMain=TRUE;
          strcpy(Stk[1],"function");
          strcpy(Stk[2],"main%");
          ForceMainToFunc=TRUE;
        }
      FuncSubDecs1("sub",1,Ndx,&(VarCode));
      IsStdFunc=FALSE;
      if(iMatchWrd(Stk[Ndx],"stdcall")){
          strcpy(CallType,"__stdcall ");
          Ndx--;
          IsStdFunc=TRUE;
        }
      InMain=FALSE;
      LocalVarCnt=0;
      if(InNameSpace||InCppTypeDef ){
          InFunction=FALSE;
          FP_WRITE=FP2;
        }
      else
        {
          if(iMatchNQ(sWord,"function")){
              InFunction=eFunctionType;
            }
          else
            {
              InFunction=eSubType;
            }
          if(UsingTemplate==FALSE ){
              FP_WRITE=FP3;
            }
        }
      strcpy(VarCode.Functype,ltrim(VarCode.Functype));
      FuncSubDecs2("sub",mt_FuncSubDecC_Dec,&(VarCode),1,&(Ndx));
      if(iMatchRgt(Stk[2],"operator")){
          strcat(VarCode.Functype,Stk[2]);
          strcat(VarCode.Functype,SPC);
          *FunctionName=0;
          BOOL  bOppFound;
          for(A=3,bOppFound=FALSE; !bOppFound; A++)
            {
              if(*Stk[A]==40 ){
                  if(*Stk[A+1]!=41&&*Stk[A+2]!=40 ){
                      bOppFound=TRUE;
                    }
                  if(*Stk[A+1]==41&&A>3 ){
                      bOppFound=TRUE;
                    }
                }
              if(!bOppFound ){
                  strcat(VarCode.Functype,Stk[A]);
                }
            }
        }
      else
        {
          strcpy(FunctionName,Clean(Stk[2]));
          if(VarCode.IsExported||IsStdFunc ){
              strcpy(FunctionName, join(2,CallType,FunctionName));
            }
          A=4;
        }
      while(A<Ndx){
          if(UseCpp ){
              GetParameter(&(A),&(VarCode),mt_OptsAParam,mt_OptsNoParam,1);
            }
          else
            {
              GetParameter(&(A),&(VarCode),mt_FuncSubDecC_DecAParam,mt_FuncSubDecC_DecNoParam,0);
            }
          A++;
        }
      VarCode.Methd=mt_FuncSubDecC_DecAParam;
      strcpy(VarCode.Token,FunctionName);
      FuncSubDecs3(&(VarCode),Ndx,0);
      if(iMatchWrd(Stk[Ndx],"const")){
          strcat(VarCode.Header," const");
        }
      if(iMatchLft(VarCode.Header,"main(")){
          strcpy(VarCode.Header,"int main(int argc, LPCTSTR argv[])");
          strcpy(VarCode.Proto,"int main(int argc, LPCTSTR argv[]);");
          CurrentFuncType=vt_INTEGER;
        }
      if(Use_Static ){
          strcpy(VarCode.Header, join(2,"static ",VarCode.Header));
          strcpy(VarCode.Proto, join(2,"static ",VarCode.Proto));
        }
      if(IAmNot(InNameSpace)&&IAmNot(InClass)&&IAmNot(InCppTypeDef)){
          int iClassFunction;
          char tmp[BCXSTRSIZE];
          strcpy(tmp,extract(VarCode.Proto,"("));
          if(iMatchNQ(tmp,"::")>0 ){
              strcpy(tmp,extract(tmp,"::"));
              iClassFunction=ClassProto(tmp);
              if(iClassFunction==0 ){
                  if(cMaxClassNames==iClassCnt ){
                      Abort(join(3,"Maximum cMaxClassNames =",str(cMaxClassNames)," reached"));
                    }
                  strcpy(ClassNames[iClassCnt],tmp);
                  iClassCnt++;
                }
              iClassFunction=1;
            }
          else
            {
              iClassFunction=0;
            }
          if(iClassFunction==0 ){
              AddProto(VarCode.Proto);
              if(strcmp(InIfDef,"FP3")==0){
                  if(ProtoCnt>1 ){
                      strcpy(ProtoType[ProtoCnt].Condition,ProtoType[ProtoCnt-1].Condition);
                    }
                  else
                    {
                      *ProtoType[ProtoCnt].Condition=0;
                    }
                }
              else
                {
                  strcpy(ProtoType[ProtoCnt].Condition,InIfDef);
                }
              ProtoType[ProtoCnt].CondLevel=InConditional;
              if(NOTNULL(InIfDef)){
                  if(strcmp(InIfDef,"FP3")!=0){
                      fprintf(FP_WRITE,"%s\n",InIfDef);
                    }
                }
            }
        }
      if(InNameSpace||InClass||InCppTypeDef ){
          char szCPP_SF1[BCXSTRSIZE]={0};
          if(iMatchWrd(Stk[2],InClassName)&&InClass ){
              strcpy(VarCode.Header,remain(VarCode.Header,SPC));
            }
          fprintf(FP_UDT,"%s%s%s",Scoot,szCPP_SF1,VarCode.Header);
          if(iCPPFunSub==1 ){
              fprintf(FP_UDT,"%s%s\n"," : ",CTOR_USE);
            }
          else
            {
              fprintf(FP_UDT,"%s\n","");
            }
          FP_WRITE=FP_UDT;
        }
      else
        {
          fprintf(FP_WRITE,"%s\n",VarCode.Header);
        }
      fprintf(FP_WRITE,"%s%s\n",Scoot,"{");
      BumpUp();
    }
  else
    {
      Emit_Old(FuncRetnFlag);
    }
  return 0;
}

void Emit_BCXVariables ()
{
  while(iEmitVarGroup){
      if(1==(iEmitVarGroup&1)){
          Emit_PrinterVariables();
          iEmitVarGroup=iEmitVarGroup^ePrinterGroup;
          goto L1538;
        }
      if(1==((iEmitVarGroup>>1)&1)){
          AddFontVariables();
          iEmitVarGroup=iEmitVarGroup^eFontGroup;
          goto L1538;
        }
      if(1==((iEmitVarGroup>>2)&1)){
          AddClassName();
          iEmitVarGroup=iEmitVarGroup^eClassName;
          goto L1538;
        }
      if(1==((iEmitVarGroup>>3)&1)){
          AddBCX_hInstance();
          iEmitVarGroup=iEmitVarGroup^eBCX_hInstance;
        }
      else
        {
          Abort("Unknown variable grouping was selected (Add to SUB EmitBCXVariables).");
        }
L1538:;
    }
}

void AddBCX_hInstance ()
{
  static int IWasHere=0;
  if(IWasHere ){
      return;
    }
  AddGlobal("BCX_hInstance",vt_HINSTANCE);
  IWasHere++;
}

void AddClassName ()
{
  static int IWasHere;
  if(IWasHere ){
      return;
    }
  AddGlobal("BCX_ClassName",vt_STRVAR);
  IWasHere++;
}

void Emit_PrinterVariables ()
{
  static int IWasHere;
  if(IWasHere ){
      return;
    }
  AddGlobal("BcxPtr_hDC",vt_HDC);
  AddGlobal("BcxPtr_FontMetrix",vt_LONG);
  AddGlobal("BcxPtr_LineCtr",vt_LONG);
  AddGlobal("BcxPtr_PrinterOn",vt_LONG);
  AddGlobal("BcxPtr_hFont",vt_HFONT);
  AddGlobal("BcxPtr_hFontOld",vt_HFONT);
  AddGlobal("BcxPtr_di",vt_DOCINFO);
  AddGlobal("BcxPtr_Lf",vt_LOGFONT);
  AddGlobal("BcxPtr_tm",vt_TEXTMETRIC);
  AddGlobal("BcxPtr_Text",vt_STRVAR);
  AddGlobal("BcxPtr_Buffer",vt_STRVAR);
  IWasHere++;
}

void AddFontVariables ()
{
  static int IWasHere;
  if(IWasHere ){
      return;
    }
  AddGlobal("BCX_ScaleX",vt_SINGLE);
  AddGlobal("BCX_ScaleY",vt_SINGLE);
  IWasHere++;
}

void AddBcxFontVar ()
{
  static int IWasHere;
  if(IWasHere ){
      return;
    }
  AddGlobal("BcxFont",vt_HFONT);
  IWasHere++;
}

void AddPenSizeVariables ()
{
  static int IWasHere;
  if(IWasHere ){
      return;
    }
  AddGlobal("BCX_Pensize=1",vt_INTEGER);
  AddGlobal("BCX_Penstyle=0",vt_INTEGER);
  IWasHere++;
}

void AddGrafixVariables ()
{
  static int IWasHere;
  if(IWasHere ){
      return;
    }
  AddGlobal("BCX_BUFFER_BMWIDTH",vt_INTEGER);
  AddGlobal("BCX_BUFFER_BMHEIGHT",vt_INTEGER);
  AddGlobal("BCX_BUFFER",vt_HDC);
  AddGlobal("BCX_PREV_BMP",vt_HBITMAP);
  AddGlobal("BCX_BUFFER_BMP",vt_BITMAPINFO);
  IWasHere++;
}

void AddGUIGlobals ()
{
  static int IWasHere;
  if(IWasHere ){
      return;
    }
  AddFontVariables();
  AddBCX_hInstance();
  AddGlobal("BCX_hwndMDIClient",vt_HWND);
  AddGlobal("BCX_WndClass",vt_WNDCLASSEX);
  AddGlobal("BCX_GUI_Init",vt_WINBOOL);
  AddGlobal("BCX_ClassName",vt_STRVAR);
  IWasHere++;
}

void ProcessMsgCracker ()
{
  char msg_[BCXSTRSIZE];
  char proc_[BCXSTRSIZE];
  char ret_[BCXSTRSIZE];
  char tmp_[16][BCXSTRSIZE];
  int  tmpNdx;
  int  i;
  int  j;
  i=j=tmpNdx=0;
  FastLexer(Src,SPC,":");
  if(iMatchWrd(Stk[3],"inline")){
      strcpy(tmp_[++tmpNdx], join(3,"IF Msg = ",Stk[2]," THEN"));
      if(strcmp(Stk[Ndx],":")!=0){
          strcpy(Stk[++Ndx],":");
        }
      for(i=4,j=4; i<=Ndx; i++)
        {
          if(strcmp(Stk[i],":")==0){
              BuildDelimStr(j,i-1,tmp_[++tmpNdx]);
              j=i+1;
            }
        }
      strcpy(tmp_[++tmpNdx],"END IF");
      for(i=1; i<=tmpNdx; i++)
        {
          Inject(tmp_[i]);
        }
    }
  else
    {
      FastLexer(Src," ,()","");
      strcpy(msg_,Stk[2]);
      strcpy(proc_,Stk[3]);
      strcpy(ret_,Stk[4]);
      if(NOTNULL(ret_)){
          strcpy(ret_, join(2,",",ret_));
        }
      strcpy(Src, join(3,"IF Msg = ",msg_," THEN"));
      Inject(Src);
      if((int)strlen(trim(ret_))>0 ){
          strcpy(Src, join(5,"  FUNCTION=",proc_,"(hWnd,wParam,lParam",ret_,")"));
        }
      else
        {
          strcpy(Src, join(5,space(2),proc_,"(hWnd,wParam,lParam",ret_,")"));
        }
      Inject(Src);
      strcpy(Src,"END IF");
      Inject(Src);
    }
  *Src=0;
}

void ProcessCmdHandler ()
{
  char id_[BCXSTRSIZE];
  char proc_[BCXSTRSIZE];
  char ret_[BCXSTRSIZE];
  char tmp_[16][BCXSTRSIZE];
  int  tmpNdx;
  int  i;
  int  j;
  tmpNdx=0;
  FastLexer(Src,SPC,":");
  if(iMatchWrd(Stk[3],"inline")){
      strcpy(tmp_[++tmpNdx], join(3,"IF Msg = WM_COMMAND AND CBCTL = ",Stk[2]," THEN "));
      if(strcmp(Stk[Ndx],":")!=0){
          strcpy(Stk[++Ndx],":");
        }
      for(i=4,j=4; i<=Ndx; i++)
        {
          if(strcmp(Stk[i],":")==0){
              BuildDelimStr(j,i-1,tmp_[++tmpNdx]);
              j=i+1;
            }
        }
      strcpy(tmp_[++tmpNdx],"END IF");
      for(i=1; i<=tmpNdx; i++)
        {
          Inject(tmp_[i]);
        }
    }
  else
    {
      FastLexer(Src," ,()","");
      strcpy(id_,Stk[2]);
      strcpy(proc_,Stk[3]);
      strcpy(ret_,Stk[4]);
      if(NOTNULL(ret_)){
          strcpy(ret_, join(2,",",ret_));
        }
      strcpy(Src, join(3,"IF Msg = WM_COMMAND AND CBCTL = ",id_," THEN"));
      Inject(Src);
      if((int)strlen(trim(ret_))>0 ){
          strcpy(Src, join(5,"  FUNCTION=",proc_,"(hWnd,wParam,lParam",ret_,")"));
          Inject(Src);
        }
      else
        {
          strcpy(Src, join(5,space(2),proc_,"(hWnd,wParam,lParam",ret_,") "));
          Inject(Src);
        }
      strcpy(Src,"END IF");
      Inject(Src);
    }
  *Src=0;
}

void ProcessMsgHandler ()
{
  FastLexer(Src,", ()","");
  strcpy(Src, join(3,"FUNCTION ",Stk[2]," OPTIONAL (hWnd AS HWND, wParam AS WPARAM, lParam AS LPARAM, LReturn AS LRESULT=0) AS LRESULT"));
  Inject(Src);
  *Src=0;
}

void ProcessMsgHandlerEnd ()
{
  strcpy(Src,"FUNCTION = LReturn");
  Inject(Src);
  strcpy(Src,"END FUNCTION");
  Inject(Src);
  *Src=0;
}

int Doinclude (char* szWord,PINT  iFLAG)
{
  *iFLAG=0;
  if(strcmp(szWord,"#include")==0){
      fprintf(FP_HDR,"%s%s\n","#include",Src+8);
      goto L1543;
    }
  if(strcmp(szWord,"$include")==0){
      char orgfileName[BCXSTRSIZE];
      strcpy(Src,iReplace(Src,"$BCX$",BcxPath()));
      strcpy(szFile,trim(RemoveStr(mid(Src,9),DQ)));
      if(*szFile==60 ){
          strcpy(szFile,mid(szFile,2,(int)strlen(szFile)-2));
          strcpy(szFile, join(2,Environ("BCXLIB"),szFile));
        }
      strcpy(orgfileName,szFile);
      if(!Exist(szFile)){
          strcpy(szFile,BcxSplitPath(szFile,FNAME|FEXT));
          strcpy(szFile, join(2,BcxSplitPath(FileNames[FileNdx],FDRV|FPATH),szFile));
        }
      if(!Exist(szFile)){
          printf("%s\n","Debug: Inside FUNCTION Doinclude");
          printf("%s%s\n","Debug: szFile =",szFile);
          printf("%s%s\n","Debug: orgfileName$ =",orgfileName);
          printf("\n");
          Abort(join(2,"Unable to locate ",orgfileName));
        }
      PushFileIO();
      if((SourceFile=fopen(szFile, "rb"))==0)
       {
      fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", szFile); exit(1);
       }
      FileNdx++;
      strcpy(FileNames[FileNdx],szFile);
      LineNum[FileNdx]=0;
      if(FileNdx==cMaxFiles-1 ){
          Abort("Maximum Include Files exceeded.");
        }
    }
L1543:;
  return 0;
}

void CreateUserResourceFile ()
{
  char Tmp[BCXSTRSIZE]={0};
  if(Use_Resource&&!Use_GenResFile ){
      if(NOTNULL(UserResFile)){
          strcpy(Res_File,UserResFile);
        }
    }
  if(Use_GenResFile ){
      CombineRes=FALSE;
      if(Exist(UserResFile)){
          CombineRes=TRUE;
        }
      strcpy(gTmpStr, join(2,extract(ucase(FileOut),"."),"__.rc"));
      strcpy(Res_File,gTmpStr);
      if((ResIn=fopen(resFile, "rb"))==0)
       {
      fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", resFile); exit(1);
       }
      if((ResOut=fopen(gTmpStr, "w"))==0)
       {
      fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", gTmpStr); exit(1);
       }
      fprintf(ResOut,"%s\n","//  BCX Generated Resource File");
      fprintf(ResOut,"%s%s%s%s\n","//  Date: ",date()," Time: ",timef());
      fprintf(ResOut,"%s\n","");
      fprintf(ResOut,"%s\n","#include <windows.h>");
      fprintf(ResOut,"%s\n","");
      if(CombineRes ){
          if((UserResIn=fopen(UserResFile, "rb"))==0)
           {
          fprintf(stderr, "Error: Cannot Access File or File Not Found. %s\n", UserResFile); exit(1);
           }
          fprintf(ResOut,"%s\n","// User's *.rc file listing");
          fprintf(ResOut,"%s\n","");
          while(!EoF(UserResIn)){
              Tmp[0]=0;
              fgets(Tmp, 2048 , UserResIn);
                if(feof(UserResIn) || (Tmp[strlen(Tmp)-1]==10))
                  {
                   Tmp[strcspn(Tmp,"\r\n")] = 0;
                  }
                 else
                  {
                    printf("%s%d while reading file: %s\n","Error! - LINE INPUT truncation detected at PROGRAM line: ",__LINE__-7, NamePathFromFP(UserResIn));
                    printf("%s\n","The actual truncated line of text:");
                    printf("%s",Tmp);
                    exit(1);
                  }
              if(instr(Tmp,"windows.h",1,1)>0 ){
                  *Tmp=0;
                }
              fprintf(ResOut,"%s\n",Tmp);
            }
        }
      fprintf(ResOut,"%s\n","");
      fprintf(ResOut,"%s\n","// BCX generated *.rc file listing");
      fprintf(ResOut,"%s\n","");
      while(!EoF(ResIn)){
          Tmp[0]=0;
          fgets(Tmp, 2048 , ResIn);
            if(feof(ResIn) || (Tmp[strlen(Tmp)-1]==10))
              {
               Tmp[strcspn(Tmp,"\r\n")] = 0;
              }
             else
              {
                printf("%s%d while reading file: %s\n","Error! - LINE INPUT truncation detected at PROGRAM line: ",__LINE__-7, NamePathFromFP(ResIn));
                printf("%s\n","The actual truncated line of text:");
                printf("%s",Tmp);
                exit(1);
              }
          if(instr(Tmp,"include",1,1)>0 ){
              fprintf(ResOut,"%s\n","");
            }
          fprintf(ResOut,"%s\n",Tmp);
        }
      if(ResOut)
       {
         fclose(ResOut);
         ResOut=NULL;
       }
      if(ResIn)
       {
         fclose(ResIn);
         ResIn=NULL;
       }
      if(CombineRes ){
          if(UserResIn)
           {
             fclose(UserResIn);
             UserResIn=NULL;
           }
        }
    }
  if(Exist(resFile)){
      DeleteFile ((resFile));
    }
}

void DoGoto (int i,int iSend)
{
  static char LszTmp[BCXSTRSIZE];
  sprintf(LoopType[i].szUseNeedLabel,"L%i:;",LoopType[i].iJumpTo);
  if(iSend ){
      sprintf(LszTmp,"goto L%i;",LoopType[i].iJumpTo);
      fprintf(FP_WRITE,"%s%s\n",Scoot,LszTmp);
    }
}

int Doaccelerator (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  strcpy(Accelerator,RemoveStr(Stk[2],DQ));
  return 0;
}

int Doasm (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  char LTmp[BCXSTRSIZE]={0};
  *iFLAG=0;
  Emit_Optimize("none","0","  // No Optimizations in ASM block");
  for(;;)
    {
      if(EoF(SourceFile)){
          Abort("Unbalanced $Asm");
        }
      Src[0]=0;
      fgets(Src, 2048 , SourceFile);
        if(feof(SourceFile) || (Src[strlen(Src)-1]==10))
          {
           Src[strcspn(Src,"\r\n")] = 0;
          }
         else
          {
            printf("%s%d while reading file: %s\n","Error! - LINE INPUT truncation detected at PROGRAM line: ",__LINE__-7, NamePathFromFP(SourceFile));
            printf("%s\n","The actual truncated line of text:");
            printf("%s",Src);
            exit(1);
          }
      LineNum[FileNdx]++;
      if(SrcFlag ){
          fprintf(FP_WRITE,"%s%s\n","// ",Src);
        }
      StripTabs();
      strcpy(Src,trim(Src));
      int meta_asm_loop={0};
      BOOL  meta_asm_comment_present={0};
      int  Src_Len={0};
      Src_Len=(int)strlen(Src);
      meta_asm_comment_present=FALSE;
      for(meta_asm_loop=0; meta_asm_loop<=Src_Len; meta_asm_loop++)
        {
          if(Src[meta_asm_loop]==c_SglQt||Src[meta_asm_loop]==59 ){
              strcpy(LTmp,right(Src,Src_Len-meta_asm_loop-1));
              Src[meta_asm_loop]=0;
              meta_asm_comment_present=TRUE;
              goto L1547;
            }
        }
L1547:;
      strcpy(Src,trim(Src));
      if(iMatchLft(Src,"$asm")){
          goto L1546;
        }
      strcpy(Src,replace(Src,"$","0x"));
      strcpy(Src,iReplace(Src,"&h","0x"));
      if(NOTNULL(Src)){
          strcpy(Src, join(3,"_asm(",enc(Src),chr(1)));
          if(meta_asm_comment_present ){
              strcpy(Src, join(4,Src,TAB,"//",LTmp));
            }
          strcpy(SrcTmp,Src);
          fprintf(FP_WRITE,"%s\n","#if !defined(__POCC__) && !defined (__cplusplus)");
          strcpy(Src,replace(Src,chr(1),")"));
          fprintf(FP_WRITE,"%s\n",Src);
          fprintf(FP_WRITE,"%s\n","#else");
          strcpy(SrcTmp,replace(SrcTmp,"_asm(","__asm{"));
          strcpy(SrcTmp,replace(SrcTmp,chr(1),"}"));
          fprintf(FP_WRITE,"%s\n",RemoveStr(SrcTmp,DQ));
          fprintf(FP_WRITE,"%s\n","#endif");
        }
    }
L1546:;
  Emit_Optimize("","1","  // Restoring Optimizer state");
  return 0;
}

int Dobcx_resource (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  Use_GenResFile=TRUE;
  for(;;)
    {
      if(EoF(SourceFile)){
          Abort("Unbalanced $BCX_RESOURCE");
        }
      Src[0]=0;
      fgets(Src, 2048 , SourceFile);
        if(feof(SourceFile) || (Src[strlen(Src)-1]==10))
          {
           Src[strcspn(Src,"\r\n")] = 0;
          }
         else
          {
            printf("%s%d while reading file: %s\n","Error! - LINE INPUT truncation detected at PROGRAM line: ",__LINE__-7, NamePathFromFP(SourceFile));
            printf("%s\n","The actual truncated line of text:");
            printf("%s",Src);
            exit(1);
          }
      LineNum[FileNdx]++;
      StripCode(Src);
      if(iMatchLft(ltrim(Src),"$bcx_r")){
          goto L1548;
        }
      fprintf(FP_RES,"%s\n",Src);
    }
L1548:;
  return 0;
}

int Dobcxversion (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  strcpy(Src,trim(mid(Src,12)));
  strcpy(Src,RemoveStr(Src,DQ));
  if(strcmp(lcase(VERSION),lcase(Src))==-1){
      Abort(join(10,CRLF,"Your Translator needs updating.",CRLF," This program ",enc(FileNames[FileNdx])," requires BCX Version: ",Src," or later.",CRLF,CRLF));
    }
  else
    {
      if(BCX_COLORS ){
          color (11,0 );
        }
      printf("%s%s%s\n","Program requires BCX Version ",Src," or newer.");
      if(BCX_COLORS ){
          color (10,0 );
        }
      printf("%s%s%s\n","Detected BCX "," (2025/08/29)"," [OKAY]");
    }
  return 0;
}

int Doccode (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  FILE*  FP_TMP;
  char szWhere[BCXSTRSIZE];
  *iFLAG=0;
  if(Ndx>1 ){
      strcpy(szWhere,lcase(Stk[2]));
    }
  else
    {
      strcpy(szWhere,"default");
    }
  if(strcmp(szWhere,"set")==0){
      FP_TMP=FP_SET;
      goto L1549;
    }
  if(strcmp(szWhere,"header")==0){
      FP_TMP=FP_HDR;
      goto L1549;
    }
  if(strcmp(szWhere,"const")==0){
      FP_TMP=FP_CST;
      goto L1549;
    }
  if(strcmp(szWhere,"udt")==0){
      FP_TMP=FP_UDT;
      goto L1549;
    }
  if(strcmp(szWhere,"enum")==0){
      FP_TMP=FP_ENU;
      goto L1549;
    }
  if(strcmp(szWhere,"funcsub")==0){
      FP_TMP=FP_CCODE;
    }
  else
    {
      if(InFunction ){
          FP_TMP=FP3;
        }
      else
        {
          if(InClass||InCppTypeDef||InNameSpace ){
              FP_TMP=FP_UDT;
            }
          else
            {
              FP_TMP=FP2;
            }
        }
    }
L1549:;
  for(;;)
    {
      if(EoF(SourceFile)){
          Abort("Unbalanced $Ccode");
        }
      Src[0]=0;
      fgets(Src, 2048 , SourceFile);
        if(feof(SourceFile) || (Src[strlen(Src)-1]==10))
          {
           Src[strcspn(Src,"\r\n")] = 0;
          }
         else
          {
            printf("%s%d while reading file: %s\n","Error! - LINE INPUT truncation detected at PROGRAM line: ",__LINE__-7, NamePathFromFP(SourceFile));
            printf("%s\n","The actual truncated line of text:");
            printf("%s",Src);
            exit(1);
          }
      LineNum[FileNdx]++;
      StripTabs();
      if(iMatchLft(ltrim(Src),"$ccode")){
          if(SrcFlag ){
              fprintf(FP_TMP,"%s%s%s%s%s\n","// [",trim(FileNames[FileNdx])," - ",trim(str(LineNum[FileNdx])),"] End of $CCODE Block");
            }
          goto L1550;
        }
      fprintf(FP_TMP,"%s\n",rtrim(Src));
    }
L1550:;
  return 0;
}

int Docom_op (char* szWord,PINT  iFLAG)
{
  *iFLAG=0;
  if(strcmp(szWord,"$com_off")==0){
      Use_COM=FALSE;
      ComSwitchON=FALSE;
      goto L1551;
    }
  if(strcmp(szWord,"$com_on")==0){
      Use_COM=Use_BcxTempStr=TRUE;
      ComSwitchON=TRUE;
      goto L1551;
    }
  if(strcmp(szWord,"$com_trace")==0){
      COM_build_trace_code=TRUE;
      printf("%s\n","COM trace code added to translated C file!");
      printf("%s\n","Trace informations will be sent to file: c:\\com_trace.txt");
    }
L1551:;
  return 0;
}

int Docomment (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  static FILE*  TmpFile;
  if(IAm(InClass)||IAm(InCppTypeDef)){
      TmpFile=FP_UDT;
    }
  else
    {
      TmpFile=FP_WRITE;
    }
  for(;;)
    {
      if(EoF(SourceFile)){
          Abort("Unbalanced $Comment");
        }
      Src[0]=0;
      fgets(Src, 2048 , SourceFile);
        if(feof(SourceFile) || (Src[strlen(Src)-1]==10))
          {
           Src[strcspn(Src,"\r\n")] = 0;
          }
         else
          {
            printf("%s%d while reading file: %s\n","Error! - LINE INPUT truncation detected at PROGRAM line: ",__LINE__-7, NamePathFromFP(SourceFile));
            printf("%s\n","The actual truncated line of text:");
            printf("%s",Src);
            exit(1);
          }
      LineNum[FileNdx]++;
      StripTabs();
      if(iMatchLft(ltrim(Src),"$comment")){
          goto L1552;
        }
      fprintf(TmpFile,"%s%s\n","// ",Src);
    }
L1552:;
  return 0;
}

int Dofillstring (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  static char TheVariable[BCXSTRSIZE];
  strcpy(Src,IRemoveStr(Src,"$fill"));
  strcpy(Src,trim(Src));
  if(ISFALSE inchr(Src,"$")){
      if(ISFALSE inchr(Src,"[")){
          strcat(Src,"$");
        }
      else
        {
          int i=inchr(Src,"[");
          strcpy(Src, join(3,mid(Src,1,i-1),"$",mid(Src,i)));
        }
    }
  Inject(join(3,Src," = ",enc("")));
  strcpy(TheVariable, join(4,Src," = ",Src," & "));
  for(;;)
    {
      if(EoF(SourceFile)){
          Abort("Unbalanced $FILL");
        }
      Src[0]=0;
      fgets(Src, 2048 , SourceFile);
        if(feof(SourceFile) || (Src[strlen(Src)-1]==10))
          {
           Src[strcspn(Src,"\r\n")] = 0;
          }
         else
          {
            printf("%s%d while reading file: %s\n","Error! - LINE INPUT truncation detected at PROGRAM line: ",__LINE__-7, NamePathFromFP(SourceFile));
            printf("%s\n","The actual truncated line of text:");
            printf("%s",Src);
            exit(1);
          }
      LineNum[FileNdx]++;
      StripTabs();
      strcpy(Src,ltrim(Src));
      if(LeftStr(Src,"'")||LeftStr(Src,"rem",TRUE)){
          *Src=0;
        }
      if(LeftStr(Src,"$fill",TRUE)){
          goto L1553;
        }
      strcpy(Src,replace(Src,BKSLASH2,BKSLASH4));
      strcpy(Src,replace(Src,BKSLASH1,BKSLASH2));
      if(NOTNULL(Src)){
          Inject(join(2,TheVariable,Src));
        }
    }
L1553:;
  *Src=0;
  return 0;
}

int DoWarningsOn (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  WarningFlag=TRUE;
  return 0;
}

int DoWarningsOff (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  WarningFlag=FALSE;
  return 0;
}

int DoZap (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  ZapFlag=TRUE;
  return 0;
}

int Docompiler (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  strcpy(Src,remain(Src,SPC));
  strcpy(Compiler,trim(Src));
  return 0;
}

int DoBcxStrSize (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  strcpy(UserBcxStrSize,trim(remain(Src,SPC)));
  return 0;
}

int Docpp (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  UNREFERENCED_PARAMETER(iFLAG);
  UseCpp=TRUE;
  return 0;
}

int Docpphdr (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  UseCpphdr=TRUE;
  UseIO=TRUE;
  return 0;
}

int Docproto (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  FastLexer(Src,SPC,"!");
  if(iMatchWrd(Stk[2],"!")){
      AddProto(remain(Src,"!"));
      *ProtoType[ProtoCnt].Condition=0;
      ProtoType[ProtoCnt].CondLevel=0;
    }
  else
    {
      int i=iMatchNQ(Src,"function");
      if(i==0 ){
          i=iMatchNQ(Src,"sub");
        }
      if(i ){
          strcpy(Src, join(2,"c_declare ",mid(Src,i)));
        }
      else
        {
          i=iMatchNQ(Src,"$cproto");
          strcpy(Src, join(2,"c_declare function ",mid(Src,i+7)));
        }
      PassOne=TRUE;
      XParse(Src);
      PassOne=FALSE;
      UseCProto=TRUE;
      *iFLAG=2;
    }
  return *iFLAG;
}

int Dodefine (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  UNREFERENCED_PARAMETER(iFLAG);
  char Tmp[BCXSTRSIZE]={0};
  strcpy(Tmp,"#define");
  for(int i=2; i<=Ndx; i++)
    {
      strcat(Tmp,SPC);
      strcat(Tmp,Stk[i]);
      *Stk[i]=0;
    }
  strcpy(Tmp,replace(Tmp," ) = ",") "));
  strcpy(Tmp,replace(Tmp," ( "," ("));
  strcpy(Tmp,replace(Tmp," , ",","));
  strcpy(Tmp,replace(Tmp," CONST "," const "));
  strcpy(Tmp,replace(Tmp," INT "," int "));
  strcpy(Tmp,replace(Tmp," LONG "," long "));
  strcpy(Tmp,replace(Tmp," DOUBLE "," double "));
  strcpy(Tmp,replace(Tmp," FLOAT "," float "));
  fprintf(FP_DEF,"%s\n",Tmp);
  Ndx=0;
  return 0;
}

int Dodll (char* szWord,PINT  iFLAG)
{
  *iFLAG=0;
  if(strcmp(szWord,"$dll")==0){
      MakeDLL=TRUE;
      Ndx=0;
      if(iMatchWrd(Stk[2],"stdcall")){
          UseStdCall=TRUE;
        }
      if(NoDllMain==FALSE ){
          fprintf(FP_WRITE,"%s\n","");
          fprintf(FP_WRITE,"%s\n","__declspec(dllexport) BOOL WINAPI DllMain (HINSTANCE hInst, ULONG Reason, PVOID Reserved)");
          fprintf(FP_WRITE,"%s\n","{");
          fprintf(FP_WRITE,"%s\n","  switch (Reason)");
          fprintf(FP_WRITE,"%s\n","  {");
          fprintf(FP_WRITE,"%s\n","    case DLL_PROCESS_ATTACH:");
          fprintf(FP_WRITE,"%s\n","      BCX_hInstance = hInst;");
          fprintf(FP_WRITE,"%s\n","      break;");
          fprintf(FP_WRITE,"%s\n","    case DLL_PROCESS_DETACH:");
          fprintf(FP_WRITE,"%s\n","      break;");
          fprintf(FP_WRITE,"%s\n","    case DLL_THREAD_ATTACH:");
          fprintf(FP_WRITE,"%s\n","      break;");
          fprintf(FP_WRITE,"%s\n","    case DLL_THREAD_DETACH:");
          fprintf(FP_WRITE,"%s\n","      break;");
          fprintf(FP_WRITE,"%s\n","   }");
          fprintf(FP_WRITE,"%s\n"," return TRUE;");
          fprintf(FP_WRITE,"%s\n","}\n\n");
          AddBCX_hInstance();
        }
      goto L1555;
    }
  if(strcmp(szWord,"$nodllmain")==0){
      NoDllMain=TRUE;
    }
L1555:;
  return 0;
}

int Dofiletest (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  if(iMatchWrd(Stk[2],"ON")){
      UseFileTest=TRUE;
    }
  else if(iMatchWrd(Stk[2],"OFF")){
      UseFileTest=FALSE;
    }
  else
    {
      Abort(join(3,"Unrecognized argument '",Stk[2],"' to $FILETEST"));
    }
  return 0;
}

int Dofsstatic (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  Use_Static=!Use_Static;
  return 0;
}

int Dogenfree (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  Use_GenFree=TRUE;
  return 0;
}

int Doheader (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  fprintf(FP_HDR,"%s\n","// *************************************************\n");
  for(;;)
    {
      if(EoF(SourceFile)){
          Abort("Unbalanced $Header");
        }
      Src[0]=0;
      fgets(Src, 2048 , SourceFile);
        if(feof(SourceFile) || (Src[strlen(Src)-1]==10))
          {
           Src[strcspn(Src,"\r\n")] = 0;
          }
         else
          {
            printf("%s%d while reading file: %s\n","Error! - LINE INPUT truncation detected at PROGRAM line: ",__LINE__-7, NamePathFromFP(SourceFile));
            printf("%s\n","The actual truncated line of text:");
            printf("%s",Src);
            exit(1);
          }
      LineNum[FileNdx]++;
      StripTabs();
      strcpy(Src,trim(Src));
      if(iMatchLft(Src,"$heade")){
          goto L1556;
        }
      fprintf(FP_HDR,"%s\n",Src);
    }
L1556:;
  fprintf(FP_HDR,"%s\n","");
  return 0;
}

int Dointerface (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  UseCpp=TRUE;
  strcpy(Src,remain(Src,SPC));
  fprintf(FP_UDT,"%s%s%s\n","interface ",Src,"\n  {");
  for(;;)
    {
      if(EoF(SourceFile)){
          Abort("$Interface Without $EndInterface");
        }
      Src[0]=0;
      fgets(Src, 2048 , SourceFile);
        if(feof(SourceFile) || (Src[strlen(Src)-1]==10))
          {
           Src[strcspn(Src,"\r\n")] = 0;
          }
         else
          {
            printf("%s%d while reading file: %s\n","Error! - LINE INPUT truncation detected at PROGRAM line: ",__LINE__-7, NamePathFromFP(SourceFile));
            printf("%s\n","The actual truncated line of text:");
            printf("%s",Src);
            exit(1);
          }
      LineNum[FileNdx]++;
      if(iMatchLft(ltrim(Src),"$endinterface")){
          *Src=0;
          goto L1557;
        }
      fprintf(FP_UDT,"%s\n",Src);
    }
L1557:;
  strcpy(Src,remain(Src,SPC));
  strcpy(Src,trim(Src));
  fprintf(FP_UDT,"%s%s%s\n","  } ",Src,";");
  return 0;
}

int Doiprint (char* szWord,PINT  iFLAG)
{
  *iFLAG=0;
  if(strcmp(szWord,"$iprint_on")==0){
      TranslateSlash=TRUE;
      goto L1558;
    }
  if(strcmp(szWord,"$iprint_off")==0){
      TranslateSlash=FALSE;
    }
L1558:;
  return 0;
}

int DoCase_offon (char* szWord,PINT  iFLAG)
{
  *iFLAG=0;
  if(strcmp(szWord,"$case_on")==0){
      IgnoreStrCase=FALSE;
      goto L1559;
    }
  if(strcmp(szWord,"$case_off")==0){
      IgnoreStrCase=TRUE;
    }
L1559:;
  return 0;
}

int Doleanandmean (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  Use_LeanAndMean=TRUE;
  return 0;
}

int Doliberror (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  Use_BcxTempStr=Use_Date=Use_Time=Use_LoadLibraryError=TRUE;
  if(*Stk[2]!=c_DblQt ){
      Abort("$LIBERROR requires a string literal");
    }
  strcpy(LibraryErrorLog,Stk[2]);
  return 0;
}

int Dolibrary (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  strcpy(Src,replace(Src,BKSLASH1,BKSLASH2));
  strcpy(Src,IRemoveStr(Src,"$library"));
  strcpy(Src,trim(Src));
  AddLibrary(Src);
  return 0;
}

int Dolinker (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  strcpy(Src,remain(Src,SPC));
  strcpy(Linker,Src);
  return 0;
}

int Domultithread (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  Use_MULTITHREADED_SW=TRUE;
  return 0;
}

int DoNoBorland (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  NO_BORLAND=TRUE;
  return 0;
}

int DoNoGccClang (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  NO_GCCCLANG=TRUE;
  return 0;
}

int DoNoLccwin (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  NO_LCCWIN=TRUE;
  return 0;
}

int DoNoLibs (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  NO_LIBS=TRUE;
  return 0;
}

int DoNoMsvc (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  NO_MSVC=TRUE;
  return 0;
}

int DoNoPelles (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  NO_PELLES=TRUE;
  return 0;
}

int DoNoVkkeys (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  NO_VKKEYS=TRUE;
  return 0;
}

int Donoini (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  TestForBcxIni=TRUE;
  return 0;
}

int Donoio (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  UseIO=FALSE;
  return 0;
}

int Doremovelib (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  strcpy(Src,replace(Src,BKSLASH1,BKSLASH2));
  strcpy(Src,IRemoveStr(Src,"$nolibrary"));
  RemoveLibrary(Src);
  return 0;
}

int Donomain (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  NoMain=TRUE;
  return 0;
}

int Donowin (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  WinHeaders=FALSE;
  return 0;
}

int Doonentry (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  PassOne=TRUE;
  XParse(Src);
  PassOne=FALSE;
  EntryCnt++;
  if(cMaxOnEntry==EntryCnt ){
      Abort("Maximum $OnEnty exceeded.");
    }
  strcpy(Entry[EntryCnt],Stk[2]);
  return 0;
}

int Doonexit (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  XitCount++;
  if(cMaxOnExit==XitCount ){
      Abort("Maximum $OnExit exceeded.");
    }
  strcpy(Xit[XitCount],Stk[2]);
  return 0;
}

int Dooptimizer (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  char szState[BCXSTRSIZE];
  *iFLAG=2;
  strcpy(szState,lcase(Stk[2]));
  *Src=0;
  if(strcmp(szState,"on")==0){
      if(OptimizerFirstSetting==TRUE ){
          OptimizerFirstSetting=FALSE;
          strcpy(Src,"~pragmaoptimizeon");
          OptimizerEnabled=TRUE;
        }
      else
        {
          if(OptimizerEnabled==FALSE ){
              OptimizerEnabled=TRUE;
              strcpy(Src,"~pragmaoptimizeon");
            }
        }
    }
  else if(strcmp(szState,"off")==0){
      if(OptimizerFirstSetting==TRUE ){
          OptimizerFirstSetting=FALSE;
          strcpy(Src,"~pragmaoptimizeoff");
          OptimizerEnabled=FALSE;
        }
      else
        {
          if(OptimizerEnabled==TRUE ){
              OptimizerEnabled=FALSE;
              strcpy(Src,"~pragmaoptimizeoff");
            }
        }
    }
  else
    {
      Abort(join(2,"Error in $OPTIMIZER MetaStatement: ",Src));
    }
  XParse(Src);
  return 2;
}

int Dopack (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  int iLoc=2;
  *iFLAG=0;
  FastLexer(Src,"","()");
  if(strcmp(Stk[iLoc],"(")==0){
      iLoc++;
    }
  fprintf(FP_UDT,"%s%s%s\n","#pragma pack (",Stk[iLoc],")");
  return 0;
}

int Dopp (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  PPFlag=!PPFlag;
  if(PPFlag ){
      if(PPDLL_HANDLE==NULL ){
          PPDLL_HANDLE=LoadLibrary("BCXPP.DLL");
          if(!PPDLL_HANDLE ){
              Abort("Failed to Open BCX Preprocessor DLL!");
            }
          else
            {
              printf("%s\n","BCXPP.DLL Successfully Loaded");
            }
#if defined __GNUC__ 
#pragma GCC diagnostic ignored "-Wcast-function-type"
          PPProc=(CPP_FARPROC)GetProcAddress(PPDLL_HANDLE,"ProcessLine");
#pragma GCC diagnostic pop
#else
#ifndef _MSC_VER 
#pragma GCC diagnostic ignored "-Wcast-function-type"
#endif
          PPProc=(CPP_FARPROC)GetProcAddress(PPDLL_HANDLE,"ProcessLine");
#endif
          if(!PPProc ){
              Abort("'FUNCTION ProcessLine' missing in BCX Preprocessor DLL!");
            }
        }
    }
  return 0;
}

int Doprj (char* szWord,PINT  iFLAG)
{
  *iFLAG=0;
  if(strcmp(szWord,"$prj")==0){
      strcpy(Project, join(2,ucase(extract(command(1),".")),".USE"));
      strcpy(HFile, join(2,ucase(extract(command(1),".")),".H"));
      Use_SingleFile=FALSE;
      Use_BcxTempStr=TRUE;
      goto L1560;
    }
  if(strcmp(szWord,"$prjuse")==0){
      Use_BcxTempStr=TRUE;
      PreParse(Src);
      SetUsed();
    }
L1560:;
  return 0;
}

int Doproject (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  EnableProject();
  return 0;
}

int Dorems (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  InsertComments=~InsertComments;
  *Src=0;
  Ndx=0;
  return 0;
}

int Doresource (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  Use_Resource=TRUE;
  strcpy(ResCompiler,Stk[2]);
  strcpy(UserResFile,RemoveStr(Stk[3],DQ));
  return 0;
}

int Dosource (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  SrcFlag=!SrcFlag;
  return 0;
}

int Dostdcall (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  UseStdCall=TRUE;
  return 0;
}

int Dotest (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  TestState=!TestState;
  return 0;
}

int Dotrace (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  TraceFlag=!TraceFlag;
  return 0;
}

int Dotypedef (char* szWord,PINT  iFLAG)
{
  UNREFERENCED_PARAMETER(szWord);
  *iFLAG=0;
  fprintf(FP_UDT,"%s\n","");
  strcpy(Src,iReplace(Src,"callback","CALLBACK"));
  fprintf(FP_UDT,"%s%s%s\n","typedef ",remain(Src,SPC),";");
  return 0;
}

int IMAX (int a,int b)
{
  if(a>b ){
      return a;
    }
  else
    {
      return b;
    }
}

int IMIN (int a,int b)
{
  if(a<b ){
      return a;
    }
  else
    {
      return b;
    }
}

void StdProtos (FILE* FP_OUTPUT)
{
  if(Use_Project==FALSE ){
      if(Use_BcxTempStr||Use_Console||Use_Proto ){
          fprintf(FP_OUTPUT,"%s\n","");
          fprintf(FP_OUTPUT,"%s\n","// *************************************************");
          fprintf(FP_OUTPUT,"%s%s\n","//               ",BCX_STR_STD_PROTOS);
          fprintf(FP_OUTPUT,"%s\n","// *************************************************");
          fprintf(FP_OUTPUT,"%s\n","");
        }
      if(Use_GUINoMain||Use_MDIGUINoMain||Use_Wingui ){
          if(Use_BCX_FrameWnd ){
              fprintf(FP_OUTPUT,"%s\n","HWND    BCX_FrameWnd (LPCTSTR, WNDPROC, LPCTSTR, HMENU=NULL, int=0, int=CW_USEDEFAULT, int=CW_USEDEFAULT, int=CW_USEDEFAULT, int=CW_USEDEFAULT, int=0, int=0);");
            }
          if(Use_BCX_Wnd ){
              fprintf(FP_OUTPUT,"%s\n","HWND    BCX_Wnd (LPCTSTR, WNDPROC, LPCTSTR, HWND=0, int=CW_USEDEFAULT, int=CW_USEDEFAULT, int=CW_USEDEFAULT, int=CW_USEDEFAULT, int=0, int=0, int=0);");
            }
          if(Use_BCX_SetBkGrdBrush ){
              fprintf(FP_OUTPUT,"%s\n","void    BCX_SetBkGrdBrush (HWND, HBRUSH);");
            }
          if(Use_BCX_SetClassStyle ){
              fprintf(FP_OUTPUT,"%s\n","void    BCX_SetClassStyle (HWND, long);");
            }
          if(Use_BCX_SetIcon ){
              fprintf(FP_OUTPUT,"%s\n","void    BCX_SetIcon (HWND, int);");
            }
          if(Use_BCX_SetIconSm ){
              fprintf(FP_OUTPUT,"%s\n","void    BCX_SetIconSm (HWND, int);");
            }
          if(Use_BCX_SetCursor ){
              fprintf(FP_OUTPUT,"%s\n","void    BCX_SetCursor (HWND, LPCTSTR);");
            }
          if(Use_BCX_SetMetric ){
              fprintf(FP_OUTPUT,"%s\n","void    BCX_SetMetric (LPCTSTR);");
            }
          if(Use_GUINoMain ){
              if(Use_BCX_MsgPump ){
                  fprintf(FP_OUTPUT,"%s\n","int     BCX_MsgPump (HACCEL=0);");
                }
            }
          else if(Use_MDIGUINoMain ){
              if(Use_BCX_MDI_MsgPump ){
                  fprintf(FP_OUTPUT,"%s\n","int     BCX_MDI_MsgPump (HACCEL=0);");
                }
            }
          if(Use_BCX_RegWnd ){
              fprintf(FP_OUTPUT,"%s\n","void    BCX_RegWnd (LPCTSTR, WNDPROC);");
            }
          if(Use_BCX_InitGUI ){
              fprintf(FP_OUTPUT,"%s\n","void    BCX_InitGUI (void);");
            }
        }
      if(Use_Clng ){
          fprintf(FP_OUTPUT,"%s\n","long    CLNG (double);");
        }
      if(Use_Cint ){
          fprintf(FP_OUTPUT,"%s\n","int     Cint (double);");
        }
      if(Use_Tix ){
          fprintf(FP_OUTPUT,"%s\n","void    TIX_START(void);");
          fprintf(FP_OUTPUT,"%s\n","double  TIX_NOW(void);");
        }
      if(Use_StartupCode ){
          fprintf(FP_OUTPUT,"%s\n","int     BCX_StartupCode_ (void);");
        }
      if(Use_ExitCode ){
          fprintf(FP_OUTPUT,"%s\n","int     BCX_ExitCode_ (void);");
        }
      if(Use_Eof ){
          fprintf(FP_OUTPUT,"%s\n","int     EoF (FILE*);");
        }
      if(Use_NamePathFromFP==TRUE ){
          fprintf(FP_OUTPUT,"%s\n","char*   NamePathFromFP (FILE*);");
        }
      if(Use_Longestline ){
          fprintf(FP_OUTPUT,"%s\n","UINT    LongestLine(LPCTSTR);");
        }
      if(Use_Nextlinelen ){
          fprintf(FP_OUTPUT,"%s\n","UINT    NextLineLen (FILE*);");
        }
      if(Use_AppActivate ){
          fprintf(FP_OUTPUT,"%s\n","int     AppActivate (LPCTSTR);");
        }
      if(Use_BoxCommon ){
          fprintf(FP_OUTPUT,"%s\n","LPWORD  lpwAlign (LPWORD);");
        }
      if(Use_Inputbox ){
          fprintf(FP_OUTPUT,"%s\n","char*   InputBox (LPCTSTR, LPCTSTR, LPCTSTR, int=0);");
          fprintf(FP_OUTPUT,"%s\n","LRESULT CreatePrompter (LPCTSTR, LPCTSTR, LPCTSTR, int);");
          fprintf(FP_OUTPUT,"%s\n","LRESULT CALLBACK Prompter (HWND, UINT, WPARAM, LPARAM);");
        }
      if(Use_VBS ){
          fprintf(FP_OUTPUT,"%s\n","HRESULT VBS_RUN_SCRIPT (LPCTSTR);");
          fprintf(FP_OUTPUT,"%s\n","HRESULT VBS_ADDCODE    (LPCTSTR);");
          fprintf(FP_OUTPUT,"%s\n","double  VBS_EVAL_NUM   (LPCTSTR);");
          fprintf(FP_OUTPUT,"%s\n","char*   VBS_EVAL_STR   (LPCTSTR);");
          fprintf(FP_OUTPUT,"%s\n","BOOL    VBS_START      (void);");
          fprintf(FP_OUTPUT,"%s\n","void    VBS_STOP       (void);");
          fprintf(FP_OUTPUT,"%s\n","void    VBS_RESET      (void);");
          fprintf(FP_OUTPUT,"%s\n","char*   VBS_ERROR      (void);");
        }
      if(Use_Infobox ){
          fprintf(FP_OUTPUT,"%s\n","void    InfoBox (LPCTSTR, LPCTSTR, int=170, int=170);");
          fprintf(FP_OUTPUT,"%s\n","LRESULT CALLBACK CB_InfoBox (HWND, UINT, WPARAM, LPARAM);");
        }
      if(Use_Mdigui ){
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_MDICHILD (LPCTSTR, LPCTSTR, int=CW_USEDEFAULT, int=CW_USEDEFAULT, int=CW_USEDEFAULT, int=CW_USEDEFAULT, ULONG=0, LPARAM=0);");
          fprintf(FP_OUTPUT,"%s\n","void    BCX_MDICLASS (WNDPROC, PCHAR);");
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_MDICLIENT (HWND, int);");
        }
      if(Use_BCX_Colordlg ){
          fprintf(FP_OUTPUT,"%s\n","int     BCX_ColorDlg (ULONG=RGB(128, 128, 128), HWND=0);");
        }
      if(Use_BCXMDialog ){
          fprintf(FP_OUTPUT,"%s\n","INT_PTR BCX_MDialog (DLGPROC, LPCTSTR, HWND, int=0, int=0, int=250, int=150, int=0, int=0, LPCTSTR=NULL, int=0);");
        }
      if(Use_BCXDialog ){
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_Dialog (DLGPROC, LPCTSTR, HWND, int=0, int=0, int=250, int=150, int=0, int=0, LPCTSTR=NULL, int=0);");
        }
      if(Use_BCXDialogCommon ){
          fprintf(FP_OUTPUT,"%s\n","void    SetDialogScale (HWND, BOOL);");
        }
      if(Use_SetDimension ){
          fprintf(FP_OUTPUT,"%s\n","void    SetDimension (LPCTSTR , int, HWND, BOOL=FALSE);");
        }
      if(Use_GetDimension ){
          fprintf(FP_OUTPUT,"%s\n","int     GetDimension (LPCTSTR ,HWND, BOOL=FALSE);");
        }
      if(Use_Form ){
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_Form (LPCTSTR, int=0, int=0, int=250, int=150, int=-1, int=0);");
        }
      if(Use_Setclientsize ){
          fprintf(FP_OUTPUT,"%s\n","void    BCX_SetClientSize (HWND, int, int, float=1.0f, float=1.0f);");
        }
      if(Use_BCX_Get_Window_Width ){
          fprintf(FP_OUTPUT,"%s\n","int     BCX_Get_Window_Width (HWND);");
        }
      if(Use_BCX_Get_Window_Height ){
          fprintf(FP_OUTPUT,"%s\n","int     BCX_Get_Window_Height (HWND);");
        }
      if(Use_Edit ){
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_Edit (LPCTSTR, HWND, int, int, int, int, int, int=0, int=-1);");
        }
      if(Use_BCX_Input ){
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_Input (LPCTSTR, HWND, int, int, int, int, int, int=0, int=-1);");
        }
      if(Use_Button ){
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_Button (LPCTSTR, HWND, int=0, int=0, int=0, int=0, int=0, int=0, int=-1);");
        }
      if(Use_BmpButton ){
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_BmpButton (LPCTSTR, HWND, int=0, int=0, int=0, int=0, int=0, int=0, int=0, int=-1);");
        }
      if(Use_Label ){
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_Label (LPCTSTR, HWND, int=0, int=0, int=0, int=0, int=0, int=0, int=0);");
        }
      if(Use_Group ){
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_Group (LPCTSTR, HWND, int, int, int, int, int, int=0, int=0);");
        }
      if(Use_Checkbox ){
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_Checkbox (LPCTSTR, HWND, int=0, int=0, int=0, int=0, int=0, int=0, int=0);");
        }
      if(Use_Radio ){
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_Radio (LPCTSTR, HWND, int=0, int=0, int=0, int=0, int=0, int=0, int=0);");
        }
      if(Use_Combobox ){
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_Combobox (LPCTSTR, HWND, int, int, int, int, int, int=0, int=-1);");
        }
      if(Use_Listbox ){
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_Listbox (LPCTSTR, HWND, int, int, int, int, int, int=0, int=-1);");
        }
      if(Use_Blackrect ){
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_BlackRect (LPCTSTR, HWND, int, int, int, int, int, int=0, int=0);");
        }
      if(Use_Whiterect ){
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_WhiteRect (LPCTSTR, HWND, int, int, int, int, int, int=0, int=0);");
        }
      if(Use_Grayrect ){
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_GrayRect (LPCTSTR, HWND, int, int, int, int, int, int=0, int=0);");
        }
      if(Use_Datepick ){
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_DatePick (LPCTSTR, HWND, int, int, int, int, int, int=0, int=-1);");
        }
      if(Use_Richedit ){
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_RichEdit (LPCTSTR, HWND, int, int, int, int, int, int=0, int=-1);");
          fprintf(FP_OUTPUT,"%s\n","void    SetWindowRTFText (HWND, LPCTSTR);");
        }
      if(Use_Status ){
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_Status (LPCTSTR, HWND, int=200, int=1, PINT=NULL);");
        }
      if(Use_BCX_OlePicture ){
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_OlePicture (LPCTSTR, HWND=0, int=0, int=0, int=0, int=0, int=0, int=0, int=0, int=0);");
        }
      if(Use_Bitmap ){
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_Bitmap (LPCTSTR, HWND=0, int=0, int=0, int=0, int=0, int=0, int=0, int=0, int=0);");
        }
      if(Use_Icon ){
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_Icon (LPCTSTR, HWND=0, int=0, int=0, int=0, int=0, int=0, int=0, int=0, int=0);");
        }
      if(Use_Listview ){
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_ListView (LPCTSTR, HWND, int, int, int, int, int, int=0, int=-1, int=15);");
        }
      if(Use_Treeview ){
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_Treeview (LPCTSTR, HWND, int, int, int, int, int, int=0, int=-1);");
        }
      if(Use_BCX_Control ){
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_Control (LPCTSTR, HWND, LPCTSTR, int, int, int, int, int, int=0, int=0);");
        }
      if(Use_ProgressBar ){
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_ProgressBar (LPCTSTR, HWND, int=0, int=0, int=0, int=0, int=0, int=0, int=-1);");
        }
      if(Use_BCX_Slider ){
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_Slider (LPCTSTR, HWND, int, int, int, int, int, int=0, int=0, int=0);");
        }
      if(Use_BCX_Splitter ){
          fprintf(FP_OUTPUT,"%s\n","void    DrawXorBar (HWND, RECT *);");
          fprintf(FP_OUTPUT,"%s\n","int     BCX_SetSplitPos (HWND, int=50, int=0);");
          fprintf(FP_OUTPUT,"%s\n","LRESULT CALLBACK SplitterWndProc (HWND, UINT, WPARAM, LPARAM);");
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_Splitter (HWND, int, int=0, int=0, int=0, int=0, int=0, int=0);");
        }
      if(Use_BCX_Toolbar ){
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_Toolbar (HWND, int, int, LPCTSTR=NULL, PINT=NULL, PVOID=NULL, PINT=NULL, int=0, int=0, int=0, int=0);");
        }
      if(Use_BCX_Tab ){
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_Tab (HWND, int, int, HWND *, char[][BCXSTRSIZE], int, int, int, int, HIMAGELIST=NULL, int=0, int=0);");
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_AddTab (HWND, int, LPCTSTR, int=-1, int=0);");
          fprintf(FP_OUTPUT,"%s\n","void    BCX_RemTab (HWND, int);");
          fprintf(FP_OUTPUT,"%s\n","int     BCX_TabSelect (HWND, LPARAM);");
          fprintf(FP_OUTPUT,"%s\n","LRESULT CALLBACK TabPageWndProc (HWND, UINT, WPARAM, LPARAM);");
          fprintf(FP_OUTPUT,"%s\n","LRESULT CALLBACK TabCallback (HWND, UINT, WPARAM, LPARAM);");
          fprintf(FP_OUTPUT,"%s\n","LRESULT CALLBACK TabSizeCallback (HWND, UINT, WPARAM, LPARAM);");
        }
      if(Use_Draw ){
          fprintf(FP_OUTPUT,"%s\n","HDC     StartDraw (HWND);");
          fprintf(FP_OUTPUT,"%s\n","HBITMAP EndDraw (HWND, HDC);");
        }
      if(Use_BCX_UpDown ){
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_UpDown (HWND, int, int, int, int, int, int, int=0);");
        }
      if(Use_BCX_Get_UpDown ){
          fprintf(FP_OUTPUT,"%s\n","int     BCX_Get_UpDown (HWND);");
        }
      if(Use_BCX_Print ){
          fprintf(FP_OUTPUT,"%s\n","int     BCX_Print (HWND, int, int, LPCTSTR, HDC=NULL);");
        }
      if(Use_BCX_Printex ){
          fprintf(FP_OUTPUT,"%s\n","void    BCX_Printex (HWND, long, long, char*, long, long, char*, long, HDC=NULL);");
        }
      if(Use_SetFormColor ){
          fprintf(FP_OUTPUT,"%s\n","void    BCX_Set_Form_Color (HWND, ULONG);");
        }
      if(Use_BCX_Tile ){
          fprintf(FP_OUTPUT,"%s\n","void    BCX_Tile (HWND, HBITMAP);");
        }
      if(Use_GetText ){
          fprintf(FP_OUTPUT,"%s\n","char*   BCX_Get_Text (HWND);");
        }
      if(Use_GetResource ){
          fprintf(FP_OUTPUT,"%s\n","PVOID   GetResource (int, char*, ULONG*);");
        }
      if(Use_SetText ){
          fprintf(FP_OUTPUT,"%s\n","int     BCX_Set_Text (HWND, LPCTSTR);");
        }
      if(Use_Elf ){
          fprintf(FP_OUTPUT,"%s\n","void    EditLoadFile (HWND, LPCTSTR);");
        }
      if(Use_ListBoxLoadFile ){
          fprintf(FP_OUTPUT,"%s\n","void    ListBoxLoadFile (HWND, LPCTSTR, int=0, int=0);");
        }
      if(Use_ComboBoxLoadFile ){
          fprintf(FP_OUTPUT,"%s\n","void    ComboBoxLoadFile (HWND, LPCTSTR);");
        }
      if(Use_SetFont ){
          fprintf(FP_OUTPUT,"%s\n","HFONT   BCX_Set_Font (LPCTSTR, float, int=0, int=0, int=0, int=0, int=0, int=0);");
        }
      if(Use_BCX_Preset ){
          fprintf(FP_OUTPUT,"%s\n","int     BCX_Preset (HWND, int, int, HDC=NULL);");
        }
      if(Use_BCX_Line ){
          fprintf(FP_OUTPUT,"%s\n","int     BCX_Line (HWND, int, int, int, int, int=0, HDC=NULL);");
        }
      if(Use_BCX_Polar_Line ){
          fprintf(FP_OUTPUT,"%s\n","void    BCX_Polar_Line(HWND, int, int, float, float, ULONG, HDC=NULL);");
        }
      if(Use_BCX_Lineto ){
          fprintf(FP_OUTPUT,"%s\n","int     BCX_Lineto (HWND, int, int, int=0, HDC=NULL);");
        }
      if(Use_BCX_Triangle ){
          fprintf(FP_OUTPUT,"%s\n","int     BCX_Triangle(HWND, LONG, LONG, LONG, LONG, LONG, LONG, DWORD, LONG, HDC=NULL);");
        }
      if(Use_BCX_Gradient ){
          fprintf(FP_OUTPUT,"%s\n","void    BCX_Gradient(HWND, ULONG, ULONG, int, HDC=NULL);");
        }
      if(Use_BCX_Polygon ){
          fprintf(FP_OUTPUT,"%s\n","int     BCX_Polygon (HWND, const POINT *, int, int=0, HDC=NULL);");
        }
      if(Use_BCX_PolyBezier ){
          fprintf(FP_OUTPUT,"%s\n","int     BCX_PolyBezier (HWND, const POINT *, int, int=0, HDC=NULL);");
        }
      if(Use_BCX_Polyline ){
          fprintf(FP_OUTPUT,"%s\n","int     BCX_Polyline (HWND, const POINT*, int, int=0, HDC=NULL);");
        }
      if(Use_BCX_Circle ){
          fprintf(FP_OUTPUT,"%s\n","int     BCX_Circle (HWND, int, int, int, int=0, int=0, HDC=NULL);");
        }
      if(Use_BCX_Ellipse ){
          fprintf(FP_OUTPUT,"%s\n","int     BCX_Ellipse (HWND, int, int, int, int, int=0, int=0, HDC=NULL);");
        }
      if(Use_BCX_Rectangle ){
          fprintf(FP_OUTPUT,"%s\n","int     BCX_Rectangle (HWND, int, int, int, int, int=0, int=0, HDC=NULL);");
        }
      if(Use_BCX_Roundrect ){
          fprintf(FP_OUTPUT,"%s\n","int     BCX_Roundrect(HWND, int, int, int, int, int, int, int=0, int=0, HDC=NULL);");
        }
      if(Use_BCX_Arc ){
          fprintf(FP_OUTPUT,"%s\n","int     BCX_Arc (HWND, int, int, int, int, int, int, int, int, int=0, HDC=NULL);");
        }
      if(Use_BCX_Pie ){
          fprintf(FP_OUTPUT,"%s\n","int     BCX_Pie(HWND, int, int, int, int, int, int, int, int, int=0, int=0, HDC=NULL);");
        }
      if(Use_Set_BCX_Bitmap ){
          fprintf(FP_OUTPUT,"%s\n","void    Set_BCX_Bitmap (HWND, LPCTSTR, int=0, int=0, int=0);");
        }
      if(Use_Set_BCX_Bitmap2 ){
          fprintf(FP_OUTPUT,"%s\n","HBITMAP Set_BCX_Bitmap2 (HWND, HBITMAP, int=1);");
        }
      if(Use_Newbmp ){
          fprintf(FP_OUTPUT,"%s\n","HBITMAP NewBmp (void);");
        }
      if(Use_Makebmp ){
          fprintf(FP_OUTPUT,"%s\n","HBITMAP MakeBmp (HDC);");
        }
      if(Use_Makehdc ){
          fprintf(FP_OUTPUT,"%s\n","HDC     MakeHdc (HBITMAP);");
        }
      if(Use_Set_BCX_BmpButton ){
          fprintf(FP_OUTPUT,"%s\n","void    Set_BCX_BmpButton (HWND, LPCTSTR, int=0);");
        }
      if(Use_Set_BCX_Icon ){
          fprintf(FP_OUTPUT,"%s\n","void    Set_BCX_Icon (HWND, LPCTSTR, int=0, int=0, int=0);");
        }
      if(Use_BCX_Fontdlg ){
          fprintf(FP_OUTPUT,"%s\n","int     BCX_FontDlg (BOOL=0, HWND=0);");
        }
      if(Use_BCX_Blit ){
          fprintf(FP_OUTPUT,"%s\n","void    BCX_Blit (HBITMAP,HDC);");
        }
      if(Use_BCX_Blit_Stretch ){
          fprintf(FP_OUTPUT,"%s\n","void    BCX_Blit_Stretch (HBITMAP,HDC);");
        }
      if(Use_BCX_Blit_Sprite ){
          fprintf(FP_OUTPUT,"%s\n","void    BCX_Blit_Sprite (HBITMAP, int, int, ULONG, HDC);");
        }
      if(Use_BCX_Buffer ){
          fprintf(FP_OUTPUT,"%s\n","void    BCX_BUFFER_START (int, int);");
          fprintf(FP_OUTPUT,"%s\n","void    BCX_BUFFER_STOP  (HWND);");
        }
      if(Use_BCX_Pset ){
          fprintf(FP_OUTPUT,"%s\n","int     BCX_Pset (HWND, int, int, int=0, HDC=NULL);");
        }
      if(Use_BCX_Polar_Pset ){
          fprintf(FP_OUTPUT,"%s\n","void    BCX_Polar_Pset(HWND, int, int, float, float, ULONG, HDC=NULL);");
        }
      if(Use_BCX_Floodfill ){
          fprintf(FP_OUTPUT,"%s\n","int     BCX_FloodFill (HWND, int, int, int, int, int=0, HDC=NULL);");
        }
      if(Use_BCX_Getpixel ){
          fprintf(FP_OUTPUT,"%s\n","ULONG   BCX_Getpixel (HWND, int, int, HDC=NULL);");
        }
      if(Use_BCX_Get ){
          fprintf(FP_OUTPUT,"%s\n","HBITMAP BCX_Get (HWND, int, int, int, int, int=SRCCOPY, HDC=NULL);");
        }
      if(Use_BCX_Put ){
          fprintf(FP_OUTPUT,"%s\n","void    BCX_Put (HWND, HBITMAP, int, int, int, int, int=SRCCOPY, HDC=NULL);");
        }
      if(Use_BCX_LoadBMP ){
          fprintf(FP_OUTPUT,"%s\n","HBITMAP BCX_LoadBMP (LPCTSTR, int=0, int=0);");
        }
      if(Use_BCX_LoadImage ){
          fprintf(FP_OUTPUT,"%s\n","HBITMAP BCX_LoadImage (LPCTSTR, int=0);");
        }
      if(Use_DrawTransBMP ){
          fprintf(FP_OUTPUT,"%s\n","void    DrawTransBMP (HWND, HBITMAP, ULONG, int, int, HDC=NULL);");
        }
      if(Use_DrawStr ){
          fprintf(FP_OUTPUT,"%s\n","void    Draw(char* DrawString);");
        }
      if(Use_BCX_BmpWidth ){
          fprintf(FP_OUTPUT,"%s\n","int     BCX_BmpWidth (HBITMAP);");
        }
      if(Use_BCX_ToolTip ){
          fprintf(FP_OUTPUT,"%s\n","LRESULT BCX_ToolTip (LPCTSTR, HWND, int=0);");
          fprintf(FP_OUTPUT,"%s\n","HWND    BCX_CreateToolTip (HWND, int);");
        }
      if(Use_BCX_BmpHeight ){
          fprintf(FP_OUTPUT,"%s\n","int     BCX_BmpHeight (HBITMAP);");
        }
      if(Use_QBColor ){
          fprintf(FP_OUTPUT,"%s\n","ULONG   qbcolor (int);");
        }
      if(Use_SetColor ){
          fprintf(FP_OUTPUT,"%s\n","LRESULT Set_Color (int, int, HDC, HWND);");
        }
      if(Use_PlayWav ){
          fprintf(FP_OUTPUT,"%s\n","void    PlayWav (LPCTSTR, int=0,  int=SND_SYNC);");
        }
      if(Use_SaveBmp ){
          fprintf(FP_OUTPUT,"%s\n","void    SaveBmp (PVOID, LPTSTR);");
        }
      if(Use_GetBmp ){
          fprintf(FP_OUTPUT,"%s\n","HDC     GetBmp (int, int, int, int, HWND);");
        }
      if(Use_Center ){
          fprintf(FP_OUTPUT,"%s\n","void    Center (HWND, HWND=0, HWND=0);");
        }
      if(Use_Cls ){
          fprintf(FP_OUTPUT,"%s\n","void    cls (void);");
        }
      if(Use_Color ){
          fprintf(FP_OUTPUT,"%s\n","void    color (int, int=0);");
        }
      if(Use_PushPopColors ){
          fprintf(FP_OUTPUT,"%s\n","void    PushColors (void);");
          fprintf(FP_OUTPUT,"%s\n","void    PopColors  (void);");
        }
      if(Use_Consolesize ){
          fprintf(FP_OUTPUT,"%s\n","void    BCX_SetConsoleSize  (int= 80,int= 25);");
          fprintf(FP_OUTPUT,"%s\n","void    BCX_PushConsoleSize (void);");
          fprintf(FP_OUTPUT,"%s\n","void    BCX_PopConsoleSize  (void);");
        }
      if(Use_Panel ){
          fprintf(FP_OUTPUT,"%s\n","void    panel (int, int, int, int, int, int, int, int);");
        }
      if(Use_Locate ){
          fprintf(FP_OUTPUT,"%s\n","void    locate (int, int, int=1, int=12);");
        }
      if(Use_Pos ){
          fprintf(FP_OUTPUT,"%s\n","int     Pos (void);");
        }
      if(Use_Csrlin ){
          fprintf(FP_OUTPUT,"%s\n","int     Csrlin (void);");
        }
      if(Use_Run ){
          fprintf(FP_OUTPUT,"%s\n","int     Run (LPCTSTR, int=1, int=0);");
        }
      if(Use_Doevents ){
          fprintf(FP_OUTPUT,"%s\n","void    DoEvents (void);");
        }
      if(Use_Randomize ){
          fprintf(FP_OUTPUT,"%s\n","void    randomize (unsigned int);");
        }
      if(Use_Midstr ){
          fprintf(FP_OUTPUT,"%s\n","void    midstr (char*, int, int, char *);");
        }
      if(Use_Swap ){
          fprintf(FP_OUTPUT,"%s\n","void    swap (byte*, byte*, int);");
        }
      if(Use_BcxTempStr ){
          fprintf(FP_OUTPUT,"%s\n","char*   BCX_TempStr (size_t);");
        }
      if(Use_sziif ){
          fprintf(FP_OUTPUT,"%s\n","char*   sziif (int, LPCTSTR, LPCTSTR);");
        }
      if(Use_Using ){
          fprintf(FP_OUTPUT,"%s\n","char*   Using (LPCTSTR, long double);");
        }
      if(Use_TempFileName ){
          fprintf(FP_OUTPUT,"%s\n","char*   TempFileName (LPCTSTR, LPCTSTR);");
        }
      if(Use_AppExePath ){
          fprintf(FP_OUTPUT,"%s\n","char*   AppExePath (void);");
        }
      if(Use_AppExeName ){
          fprintf(FP_OUTPUT,"%s\n","char*   AppExeName (void);");
        }
      if(Use_Chr ){
          fprintf(FP_OUTPUT,"%s\n","char*   chr (unsigned char,  unsigned char=0,unsigned char=0,unsigned char=0,");
          fprintf(FP_OUTPUT,"%s\n","             unsigned char=0,unsigned char=0,unsigned char=0,unsigned char=0,");
          fprintf(FP_OUTPUT,"%s\n","             unsigned char=0,unsigned char=0,unsigned char=0,unsigned char=0,");
          fprintf(FP_OUTPUT,"%s\n","             unsigned char=0,unsigned char=0,unsigned char=0,unsigned char=0,");
          fprintf(FP_OUTPUT,"%s\n","             unsigned char=0,unsigned char=0,unsigned char=0,unsigned char=0,");
          fprintf(FP_OUTPUT,"%s\n","             unsigned char=0,unsigned char=0,unsigned char=0,unsigned char=0,");
          fprintf(FP_OUTPUT,"%s\n","             unsigned char=0,unsigned char=0);");
        }
      if(Use_VChr ){
          fprintf(FP_OUTPUT,"%s\n","char*   vchr (int,...);");
        }
      if(Use_Lcase ){
          fprintf(FP_OUTPUT,"%s\n","char*   lcase (LPCTSTR);");
        }
      if(Use_Ucase ){
          fprintf(FP_OUTPUT,"%s\n","char*   ucase (LPCTSTR);");
        }
      if(Use_Mid ){
          fprintf(FP_OUTPUT,"%s\n","char*   mid (LPCTSTR, int, int=-1);");
        }
      if(Use_Ltrim ){
          fprintf(FP_OUTPUT,"%s\n","char*   ltrim (LPCTSTR, char=32);");
        }
      if(Use_Rtrim ){
          fprintf(FP_OUTPUT,"%s\n","char*   rtrim (LPCTSTR, char=32);");
        }
      if(Use_Trim ){
          fprintf(FP_OUTPUT,"%s\n","char*   trim (LPCTSTR);");
        }
      if(Use_Strim ){
          fprintf(FP_OUTPUT,"%s\n","char*   strim (LPCTSTR);");
        }
      if(Use_Left ){
          fprintf(FP_OUTPUT,"%s\n","char*   left (LPCTSTR, int);");
        }
      if(Use_Right ){
          fprintf(FP_OUTPUT,"%s\n","char*   right (LPCTSTR, int);");
        }
      if(Use_Cpad ){
          fprintf(FP_OUTPUT,"%s\n","char*   cpad (LPCTSTR, int, int=32);");
        }
      if(Use_Rpad ){
          fprintf(FP_OUTPUT,"%s\n","char*   rpad (LPCTSTR, int, int=32);");
        }
      if(Use_Lpad ){
          fprintf(FP_OUTPUT,"%s\n","char*   lpad (LPCTSTR, int, int=32);");
        }
      if(Use_String ){
          fprintf(FP_OUTPUT,"%s\n","char*   stringx (int, int);");
        }
      if(Use_Repeat ){
          fprintf(FP_OUTPUT,"%s\n","char*   repeat (int, LPCTSTR);");
        }
      if(Use_Extract ){
          fprintf(FP_OUTPUT,"%s\n","char*   extract (LPCTSTR, LPCTSTR);");
        }
      if(Use_ExtractAny ){
          fprintf(FP_OUTPUT,"%s\n","char*   extractany (LPCTSTR, LPCTSTR);");
        }
      if(Use_Remain ){
          fprintf(FP_OUTPUT,"%s\n","char*   remain (LPCTSTR, LPCTSTR);");
        }
      if(Use_Reverse ){
          fprintf(FP_OUTPUT,"%s\n","char*   reverse (LPCTSTR);");
        }
      if(Use_Command ){
          fprintf(FP_OUTPUT,"%s\n","char*   command (int=-1);");
        }
      if(Use_Mcase ){
          fprintf(FP_OUTPUT,"%s\n","char*   mcase (LPCTSTR);");
        }
      if(Use_Replace ){
          fprintf(FP_OUTPUT,"%s\n","char*   replace (LPCTSTR, LPCTSTR, LPCTSTR);");
        }
      if(Use_iReplace ){
          fprintf(FP_OUTPUT,"%s\n","char*   iReplace (LPCTSTR, LPCTSTR, LPCTSTR);");
        }
      if(Use_ReplaceAny ){
          fprintf(FP_OUTPUT,"%s\n","char*   ReplaceAny (LPCTSTR, LPCTSTR, LPCTSTR);");
        }
      if(Use_IReplaceAny ){
          fprintf(FP_OUTPUT,"%s\n","char*   IReplaceAny (LPCTSTR, LPCTSTR, LPCTSTR);");
        }
      if(Use_RemoveAny ){
          fprintf(FP_OUTPUT,"%s\n","char*   RemoveAny (LPCTSTR, LPCTSTR);");
        }
      if(Use_IRemoveAny ){
          fprintf(FP_OUTPUT,"%s\n","char*   IRemoveAny (LPCTSTR, LPCTSTR);");
        }
      if(Use_Sleep ){
          fprintf(FP_OUTPUT,"%s\n","void     BCX_Sleep (int);");
        }
      if(Use_Space ){
          fprintf(FP_OUTPUT,"%s\n","char*   space (int a);");
        }
      if(Use_Str ){
          fprintf(FP_OUTPUT,"%s\n","char*   str (double, int=0);");
        }
      if(Use_Strl ){
          fprintf(FP_OUTPUT,"%s\n","char*   strl (long double, int=0);");
        }
      if(Use_RegString ){
          fprintf(FP_OUTPUT,"%s\n","char*   RegString (HKEY, LPCTSTR, LPCTSTR);");
        }
      if(Use_CreateRegString ){
          fprintf(FP_OUTPUT,"%s\n","void    CreateRegString (HKEY, LPCTSTR, LPCTSTR, LPCTSTR);");
        }
      if(Use_DeleteRegKey ){
          fprintf(FP_OUTPUT,"%s\n","void    DeleteRegKey (HKEY, LPCTSTR);");
        }
      if(Use_CreateRegInt ){
          fprintf(FP_OUTPUT,"%s\n","void    CreateRegInt (HKEY, LPCTSTR, LPCTSTR, int);");
        }
      if(Use_Mkpath ){
          fprintf(FP_OUTPUT,"%s\n","void    MkPath (LPCTSTR);");
        }
      if(Use_Findfirst ){
          fprintf(FP_OUTPUT,"%s\n","char*   findfirst (LPCTSTR);");
        }
      if(Use_Findnext ){
          fprintf(FP_OUTPUT,"%s\n","char*   findnext (void);");
        }
      if(Use_Lookahead ){
          fprintf(FP_OUTPUT,"%s\n","char*   LookAhead (FILE*, int=1);");
        }
      if(Use_Issystem ){
          fprintf(FP_OUTPUT,"%s\n","int     issystem (LPCTSTR);");
        }
      if(Use_Ishidden ){
          fprintf(FP_OUTPUT,"%s\n","int     ishidden (LPCTSTR);");
        }
      if(Use_Isreadonly ){
          fprintf(FP_OUTPUT,"%s\n","int     isreadonly (LPCTSTR);");
        }
      if(Use_Isfile ){
          fprintf(FP_OUTPUT,"%s\n","int     isfile (LPCTSTR);");
        }
      if(Use_Isfolder ){
          fprintf(FP_OUTPUT,"%s\n","int     isfolder (LPCTSTR);");
        }
      if(Use_Curdir ){
          fprintf(FP_OUTPUT,"%s\n","char*   curdir (void);");
        }
      if(Use_Windir ){
          fprintf(FP_OUTPUT,"%s\n","char*   windir (void);");
        }
      if(Use_GetSpecialFolder ){
          fprintf(FP_OUTPUT,"%s\n","char*   GetSpecialFolder (int, int=0, HWND=NULL);");
        }
      if(Use_GetSpecialFolderex ){
          fprintf(FP_OUTPUT,"%s\n","char*   GetSpecialFolderEx (const GUID, ULONG=0);");
        }
      if(Use_Sysdir ){
          fprintf(FP_OUTPUT,"%s\n","char*   sysdir (void);");
        }
      if(Use_Tempdir ){
          fprintf(FP_OUTPUT,"%s\n","char*   tempdir (void);");
        }
      if(Use_Environ ){
          fprintf(FP_OUTPUT,"%s\n","char*   Environ (LPCTSTR);");
        }
      if(Use_Boolstr ){
          fprintf(FP_OUTPUT,"%s\n","char*   BoolStr (int);");
        }
      if(Use_Hex ){
          fprintf(FP_OUTPUT,"%s\n","char*   hex(uint64_t, int=0);");
        }
      if(Use_Bin ){
          fprintf(FP_OUTPUT,"%s\n","char*   Bin (int);");
        }
      if(Use_Oct ){
          fprintf(FP_OUTPUT,"%s\n","char*   oct (int);");
        }
      if(Use_Date ){
          fprintf(FP_OUTPUT,"%s\n","char*   date (int=0);");
        }
      if(Use_IsoDate ){
          fprintf(FP_OUTPUT,"%s\n","char*   isodate (int=0);");
        }
      if(Use_Mouse_sx ){
          fprintf(FP_OUTPUT,"%s\n","int     MOUSEX_SCREEN (void);");
          fprintf(FP_OUTPUT,"%s\n","#define MOUSE_SX MOUSEX_SCREEN()");
        }
      if(Use_Mouse_sy ){
          fprintf(FP_OUTPUT,"%s\n","int     MOUSEY_SCREEN (void);");
          fprintf(FP_OUTPUT,"%s\n","#define MOUSE_SY MOUSEY_SCREEN()");
        }
      if(Use_Mouse_cx ){
          fprintf(FP_OUTPUT,"%s\n","int     MOUSEX_CLIENT (void);");
          fprintf(FP_OUTPUT,"%s\n","#define MOUSE_CX MOUSEX_CLIENT()");
        }
      if(Use_Mouse_cy ){
          fprintf(FP_OUTPUT,"%s\n","int     MOUSEY_CLIENT (void);");
          fprintf(FP_OUTPUT,"%s\n","#define MOUSE_CY MOUSEY_CLIENT()");
        }
      if(Use_Now ){
          fprintf(FP_OUTPUT,"%s\n","char*   now (int=0);");
        }
      if(Use_SearchPath ){
          fprintf(FP_OUTPUT,"%s\n","char*   SEARCHPATH (LPCTSTR);");
        }
      if(Use_BcxSplitPath ){
          fprintf(FP_OUTPUT,"%s\n","char*   BcxSplitPath (LPCTSTR, int);");
        }
      if(Use_BCX_Path ){
          fprintf(FP_OUTPUT,"%s\n","char*   BcxPath (void);");
        }
      if(Use_LccPath ){
          fprintf(FP_OUTPUT,"%s\n","char*   LccPath (void);");
        }
      if(Use_PellesPath ){
          fprintf(FP_OUTPUT,"%s\n","char*   PellesPath (void);");
        }
      if(Use_Strtoken ){
          fprintf(FP_OUTPUT,"%s\n","char*   StrToken (LPCTSTR, LPCTSTR, int);");
        }
      if(Use_RegExist ){
          fprintf(FP_OUTPUT,"%s\n","long    RegExist (HKEY, PCHAR, PCHAR);");
        }
      if(Use_RegInt ){
          fprintf(FP_OUTPUT,"%s\n","int     RegInt (HKEY, LPCTSTR, LPCTSTR);");
        }
      if(Use_FileLocked ){
          fprintf(FP_OUTPUT,"%s\n","int     FileLocked (LPCTSTR);");
        }
      if(Use_Bff ){
          fprintf(FP_OUTPUT,"%s\n","char*   BFF (LPCTSTR, int=0, LPCTSTR=NULL);");
          fprintf(FP_OUTPUT,"%s\n","int     CALLBACK BFFCallBack (HWND,  UINT,  LPARAM,  LPARAM);");
        }
      if(Use_FillArray ){
          fprintf(FP_OUTPUT,"%s\n","int     fillarray (LPCTSTR, int, int, void *);");
        }
      if(Use_Lclick ){
          fprintf(FP_OUTPUT,"%s\n","int     lClick (void);");
        }
      if(Use_Rclick ){
          fprintf(FP_OUTPUT,"%s\n","int     rClick (void);");
        }
      if(Use_Remove ){
          fprintf(FP_OUTPUT,"%s\n","char*   RemoveStr (LPCTSTR, LPCTSTR);");
        }
      if(Use_IRemove ){
          fprintf(FP_OUTPUT,"%s\n","char*   IRemoveStr (LPCTSTR, LPCTSTR);");
        }
      if(Use_Hook ){
          fprintf(FP_OUTPUT,"%s\n","LRESULT CALLBACK SBProc (int, WPARAM, LPARAM);");
        }
      if(Use_Getfilename ){
          fprintf(FP_OUTPUT,"%s\n","char*   GetFileName (LPCTSTR,LPCTSTR, int=0, HWND=0, ULONG=0, LPCTSTR=NULL, LPCTSTR=NULL, PINT=NULL);");
        }
      if(Use_GetSaveAsFilename ){
          fprintf(FP_OUTPUT,"%s\n","char*   GetSaveAsFileName (LPCTSTR, LPCTSTR, int=0, HWND=NULL, ULONG=0, LPCTSTR=NULL, LPCTSTR=NULL, PINT=NULL);");
        }
      if(Use_GetTextSize ){
          fprintf(FP_OUTPUT,"%s\n","SIZE*   GetTextSize (LPCTSTR, HWND=0, HFONT=0);");
        }
      if(Use_Time ){
          fprintf(FP_OUTPUT,"%s\n","char*   timef (int=0, int=0);");
        }
      if(Use_Join ){
          fprintf(FP_OUTPUT,"%s\n","char*   join(int, LPCTSTR, ...);");
        }
      if(Use_Enclose ){
          fprintf(FP_OUTPUT,"%s\n","char*   enc (LPCTSTR, int=0, int=0);");
        }
      if(Use_Stristr ){
          fprintf(FP_OUTPUT,"%s\n","char*   _stristr_(LPCTSTR, LPCTSTR);");
        }
      if(Use_IInstrAny||Use_InstrAny ){
          fprintf(FP_OUTPUT,"%s\n","char*   DeDupeSort(const char*);");
          fprintf(FP_OUTPUT,"%s\n","int     DeDupeCompare(const void*, const void*);");
        }
      if(Use_Wrap ){
          fprintf(FP_OUTPUT,"%s%s%s%s%s\n","char*   wrap (LPCTSTR, LPCTSTR=",enc(""),", LPCTSTR=",enc(""),");");
        }
      if(Use_Unwrap ){
          fprintf(FP_OUTPUT,"%s%s%s%s%s\n","char*   unwrap (LPCTSTR, LPCTSTR=",enc(""),", LPCTSTR=",enc(""),");");
        }
      if(Use_Freefile ){
          fprintf(FP_OUTPUT,"%s\n","FILE*   FreeFile (void);");
        }
      if(Use_PeekStr ){
          fprintf(FP_OUTPUT,"%s\n","char*   peekstr (PVOID, int);");
        }
      if(Use_Asc ){
          fprintf(FP_OUTPUT,"%s\n","int     asc (LPCTSTR, int=0);");
        }
      if(Use_Instrrev ){
          fprintf(FP_OUTPUT,"%s\n","int     InstrRev (LPCTSTR, LPCTSTR, int=0, int=0);");
        }
      if(Use_FirstInstance ){
          fprintf(FP_OUTPUT,"%s\n","BOOL    FindFirstInstance (LPCTSTR);");
        }
      if(Use_BCX_stricmp ){
          fprintf(FP_OUTPUT,"%s\n","int     bcx_stricmp (LPCTSTR cs, LPCTSTR ct);");
        }
      if(Use_Instr ){
          fprintf(FP_OUTPUT,"%s\n","int     instr (LPCTSTR, LPCTSTR, int=1, int=0);");
        }
      if(Use_IInstr ){
          fprintf(FP_OUTPUT,"%s\n","int     iinstr (LPCTSTR, LPCTSTR, int=1);");
        }
      if(Use_InstrAny ){
          fprintf(FP_OUTPUT,"%s\n","int     InstrAny (LPCTSTR, LPCTSTR, int=1);");
        }
      if(Use_IInstrAny ){
          fprintf(FP_OUTPUT,"%s\n","int     IInstrAny (LPCTSTR, LPCTSTR, int=1);");
        }
      if(Use_Like_Instr ){
          fprintf(FP_OUTPUT,"%s\n","int     Like_Instr (LPCTSTR Buffer, LPCTSTR Pattern);");
        }
      if(Use_Verify ){
          fprintf(FP_OUTPUT,"%s\n","int     Verify (LPCTSTR, LPCTSTR);");
          fprintf(FP_OUTPUT,"%s\n","int     VerifyInstr (LPCTSTR, LPCTSTR, int=0);");
        }
      if(Use_Retain ){
          fprintf(FP_OUTPUT,"%s\n","char*   Retain (LPCTSTR, LPCTSTR);");
        }
      if(Use_LoadFile ){
          fprintf(FP_OUTPUT,"%s\n","char*   LoadFile (LPCTSTR);");
        }
      if(Use_Inchr ){
          fprintf(FP_OUTPUT,"%s\n","int     inchr (LPCTSTR, LPCTSTR);");
        }
      if(Use_Idxqsort ){
          fprintf(FP_OUTPUT,"%s\n","int     IdxCompare (const void *, const void *);");
        }
      if(Use_IdxqsortSt ){
          fprintf(FP_OUTPUT,"%s\n","int     IdxCompareSt (const void *, const void *);");
        }
      if(Use_PtrqsortSt ){
          fprintf(FP_OUTPUT,"%s\n","int     PtrCompareSt (const void *, const void *);");
        }
      if(Use_Strqsortas ){
          fprintf(FP_OUTPUT,"%s\n","int     StrCompareAs (const void *, const void *);");
        }
      if(Use_Strqsorta ){
          fprintf(FP_OUTPUT,"%s\n","int     StrCompareA (const void *, const void *);");
        }
      if(Use_Strqsortds ){
          fprintf(FP_OUTPUT,"%s\n","int     StrCompareDs (const void *, const void *);");
        }
      if(Use_Strqsortd ){
          fprintf(FP_OUTPUT,"%s\n","int     StrCompareD (const void *, const void *);");
        }
      if(Use_DynStrqsortas ){
          fprintf(FP_OUTPUT,"%s\n","int     DynStrCompareAs (const void *, const void *);");
        }
      if(Use_DynStrqsorta ){
          fprintf(FP_OUTPUT,"%s\n","int     DynStrCompareA (const void *, const void *);");
        }
      if(Use_DynStrqsortds ){
          fprintf(FP_OUTPUT,"%s\n","int     DynStrCompareDs (const void *, const void *);");
        }
      if(Use_DynStrqsortd ){
          fprintf(FP_OUTPUT,"%s\n","int     DynStrCompareD (const void *, const void *);");
        }
      if(Use_DynAlphaNumericA ){
          fprintf(FP_OUTPUT,"%s\n","int     DynAlphaNumericA (const void *, const void *);");
        }
      if(Use_DynAlphaNumericD ){
          fprintf(FP_OUTPUT,"%s\n","int     DynAlphaNumericD (const void *, const void *);");
        }
      if(Use_AlphaNumericA ){
          fprintf(FP_OUTPUT,"%s\n","int     AlphaNumericA (const void *, const void *);");
        }
      if(Use_AlphaNumericD ){
          fprintf(FP_OUTPUT,"%s\n","int     AlphaNumericD (const void *, const void *);");
        }
      if(Use_AlphaNumeric ){
          fprintf(FP_OUTPUT,"%s\n","int     AlphaNumeric (const void *, const void *);");
        }
      if(Use_Numqsortaint ){
          fprintf(FP_OUTPUT,"%s\n","int     NumCompareAint (const void *,const void *);");
        }
      if(Use_Numqsortdint ){
          fprintf(FP_OUTPUT,"%s\n","int     NumCompareDint (const void *,const void *);");
        }
      if(Use_Numqsortafloat ){
          fprintf(FP_OUTPUT,"%s\n","int     NumCompareAfloat (const void *,const void *);");
        }
      if(Use_Numqsortdfloat ){
          fprintf(FP_OUTPUT,"%s\n","int     NumCompareDfloat (const void *,const void *);");
        }
      if(Use_Numqsortadouble ){
          fprintf(FP_OUTPUT,"%s\n","int     NumCompareAdouble (const void *,const void *);");
        }
      if(Use_Numqsortddouble ){
          fprintf(FP_OUTPUT,"%s\n","int     NumCompareDdouble (const void *,const void *);");
        }
      if(Use_Msgbox ){
          fprintf(FP_OUTPUT,"%s\n","int     MsgBox (LPCTSTR,LPCTSTR,int);");
        }
      if(Use_Like ){
          fprintf(FP_OUTPUT,"%s\n","int     like (LPCTSTR, LPCTSTR);");
        }
      if(Use_LeftStr ){
          fprintf(FP_OUTPUT,"%s\n","int     LeftStr  (LPCTSTR, LPCTSTR, int=0);");
        }
      if(Use_RightStr ){
          fprintf(FP_OUTPUT,"%s\n","int     RightStr (LPCTSTR, LPCTSTR, int=0);");
        }
      if(Use_Textmode ){
          fprintf(FP_OUTPUT,"%s\n","int     TextMode (int);");
        }
      if(Use_Tally ){
          fprintf(FP_OUTPUT,"%s\n","int     tally (LPCTSTR, LPCTSTR, int=0);");
        }
      if(Use_Diskfree ){
          fprintf(FP_OUTPUT,"%s\n","UINT64  DiskFree (LPCTSTR);");
        }
      if(Use_Diskused ){
          fprintf(FP_OUTPUT,"%s\n","UINT64  DiskUsed (LPCTSTR);");
        }
      if(Use_Disksize ){
          fprintf(FP_OUTPUT,"%s\n","UINT64  DiskSize (LPCTSTR);");
        }
      if(Use_Hex2Dec ){
          fprintf(FP_OUTPUT,"%s\n","UINT64  Hex2Dec (LPCTSTR);");
        }
      if(Use_Inkey ){
          fprintf(FP_OUTPUT,"%s\n","char*   inkey (void);");
        }
      if(Use_InkeyD ){
          fprintf(FP_OUTPUT,"%s\n","int     inkeyd (void);");
        }
      if(Use_Bin2dec ){
          fprintf(FP_OUTPUT,"%s\n","int     Bin2Dec (LPCTSTR);");
        }
      if(Use_Download ){
          fprintf(FP_OUTPUT,"%s\n","int     Download (LPCTSTR, LPCTSTR);");
        }
      if(Use_Exist ){
          fprintf(FP_OUTPUT,"%s\n","BOOL    Exist   (LPCTSTR);");
          fprintf(FP_OUTPUT,"%s\n","BOOL    Exist_A (LPCTSTR);");
          fprintf(FP_OUTPUT,"%s\n","BOOL    Exist_B (LPCTSTR);");
        }
      if(Use_Gethttpfilesize ){
          fprintf(FP_OUTPUT,"%s\n","ULONG   GetHttpFileSize (LPCTSTR);");
        }
      if(Use_Downloadtostr ){
          fprintf(FP_OUTPUT,"%s\n","char*   DownloadToStr (LPCTSTR);");
        }
      if(Use_Ins ){
          fprintf(FP_OUTPUT,"%s\n","char*   ins (LPCTSTR, int, LPCTSTR);");
        }
      if(Use_Del ){
          fprintf(FP_OUTPUT,"%s\n","char*   del (LPCTSTR, int, int);");
        }
      if(Use_Chrtoutf8 ){
          fprintf(FP_OUTPUT,"%s\n","char *ChrToUtf8 (LPCSTR);");
        }
      if(Use_Utf8tochr ){
          fprintf(FP_OUTPUT,"%s\n","char *UTF8toCHR (LPCSTR);");
        }
      if(Use_Screen ){
          fprintf(FP_OUTPUT,"%s\n","int     Screen (int, int, int=0);");
        }
      if(Use_Pause ){
          fprintf(FP_OUTPUT,"%s\n","void    Pause (void);");
        }
      if(Use_Clip_Gettext ){
          fprintf(FP_OUTPUT,"%s\n","char*   Clipboard_GetText (void);");
        }
      if(Use_Clip_Gettextsize ){
          fprintf(FP_OUTPUT,"%s\n","int     Clipboard_GetTextSize (void);");
        }
      if(Use_Clip_Settext ){
          fprintf(FP_OUTPUT,"%s\n","void    Clipboard_SetText (LPCTSTR);");
        }
      if(Use_Clip_Getbitmap ){
          fprintf(FP_OUTPUT,"%s\n","HBITMAP Clipboard_GetBitmap (void);");
        }
      if(Use_Clip_Setbitmap ){
          fprintf(FP_OUTPUT,"%s\n","void    Clipboard_SetBitmap (HBITMAP);");
        }
      if(Use_Keypress ){
          fprintf(FP_OUTPUT,"%s\n","int     keypress (void);");
        }
      if(Use_Lof ){
          fprintf(FP_OUTPUT,"%s\n","unsigned long long int  lof (LPCTSTR);");
        }
      if(Use_Sgn ){
          fprintf(FP_OUTPUT,"%s\n","double  sgn (double);");
        }
      if(Use_Round ){
          fprintf(FP_OUTPUT,"%s\n","double  Round (double, int);");
        }
      if(Use_Rnd ){
          fprintf(FP_OUTPUT,"%s\n","float   rnd (void);");
        }
      if(Use_Rnd2 ){
          fprintf(FP_OUTPUT,"%s\n","double  rnd2 (double, double);");
        }
      if(Use_Exp ){
          fprintf(FP_OUTPUT,"%s\n","double  Exp (double);");
        }
      if(Use_Max ){
          fprintf(FP_OUTPUT,"%s\n","double  MAX (double, double);");
        }
      if(Use_Min ){
          fprintf(FP_OUTPUT,"%s\n","double  MIN (double, double);");
        }
      if(Use_Modstyle ){
          fprintf(FP_OUTPUT,"%s\n","BOOL    ModStyle (HWND, LONG_PTR=0, LONG_PTR=0, BOOL=0);");
        }
      if(Use_Timer ){
          fprintf(FP_OUTPUT,"%s\n","float   timer (void);");
        }
      if(Use_Iif ){
          fprintf(FP_OUTPUT,"%s\n","double  iif (int, double, double);");
        }
      if(Use_Loc ){
          fprintf(FP_OUTPUT,"%s\n","int     loc (FILE *fp, int fplen);");
        }
      if(Use_Rec ){
          fprintf(FP_OUTPUT,"%s\n","int     rec (FILE *fp, int fplen);");
        }
      if(Use_RecCount ){
          fprintf(FP_OUTPUT,"%s\n","int     reccount (FILE *fp, int fplen);");
        }
      if(Use_Scan ){
          fprintf(FP_OUTPUT,"%s\n","int     scan (LPCTSTR input, LPCTSTR format, ... );");
        }
      if(Use_KBinput ){
          fprintf(FP_OUTPUT,"%s\n","void    KBinput (void);");
        }
      if(Use_Split ){
          fprintf(FP_OUTPUT,"%s\n","int     Split (char[][BCXSTRSIZE], LPCTSTR, LPCTSTR, int=0);");
        }
      if(Use_DSplit ){
          fprintf(FP_OUTPUT,"%s\n","int     DSplit (PSTR *, LPCTSTR, LPCTSTR, int=0);");
        }
      if(Use_SysStr ){
          fprintf(FP_OUTPUT,"%s\n","BSTR    SysStr (LPCTSTR szIn, int=0, int=0);");
        }
      if(Use_LCaseTbl ){
          fprintf(FP_OUTPUT,"%s\n","unsigned char*  MakeLCaseTbl (void);");
        }
      if(Use_UCaseTbl ){
          fprintf(FP_OUTPUT,"%s\n","unsigned char*  MakeUCaseTbl (void);");
        }
      if(Use_Cvi ){
          fprintf(FP_OUTPUT,"%s\n","short   CVI (LPCTSTR);");
        }
      if(Use_Mki ){
          fprintf(FP_OUTPUT,"%s\n","char*   MKI (short);");
        }
      if(Use_Cvl ){
          fprintf(FP_OUTPUT,"%s\n","long    CVL (LPCTSTR);");
        }
      if(Use_Mkl ){
          fprintf(FP_OUTPUT,"%s\n","char*   MKL (int);");
        }
      if(Use_Cvs ){
          fprintf(FP_OUTPUT,"%s\n","float   CVS (LPCTSTR);");
        }
      if(Use_Mks ){
          fprintf(FP_OUTPUT,"%s\n","char*   MKS (float);");
        }
      if(Use_Cvd ){
          fprintf(FP_OUTPUT,"%s\n","double  CVD (LPCTSTR);");
        }
      if(Use_Cvld ){
          fprintf(FP_OUTPUT,"%s\n","long double  CVLD (LPCTSTR);");
        }
      if(Use_Mkd ){
          fprintf(FP_OUTPUT,"%s\n","char*   MKD (double);");
        }
      if(Use_Mkld ){
          fprintf(FP_OUTPUT,"%s\n","char*   MKLD (long double);");
        }
      if(Use_OSVersion ){
          fprintf(FP_OUTPUT,"%s\n","int     OSVersion (void);");
        }
      if(Use_Sound ){
          fprintf(FP_OUTPUT,"%s\n","int     Sound (float, int=0, int=127, int=0, float=1.0f);");
          fprintf(FP_OUTPUT,"%s\n","int     PlaySnd (void);");
        }
      if(Use_Hscroll||Use_Vscroll ){
          fprintf(FP_OUTPUT,"%s\n","void    BCX_Scroll (HWND, int, int, int, int, int, int, int, int, int, int);");
        }
      if(Use_DynacallCommon ){
          fprintf(FP_OUTPUT,"%s\n","HINSTANCE BCX_LoadDll (LPCTSTR);");
          fprintf(FP_OUTPUT,"%s\n","void      BCX_UnloadDll (void);");
          if(Use_Dynacall ){
              fprintf(FP_OUTPUT,"%s\n","INT_PTR   BCX_DynaCallB (LPCTSTR, LPCTSTR, int, ...);");
            }
          if(Use_DynacallA ){
              fprintf(FP_OUTPUT,"%s\n","INT_PTR   BCX_DynaCallA(LPCTSTR, LPCTSTR, int, INT_PTR *);");
            }
        }
      if(Use_DynamicA ){
          fprintf(FP_OUTPUT,"%s\n","void*   CreateArr (void*, int, int, int, size_t *);");
          fprintf(FP_OUTPUT,"%s\n","void    DestroyArr (void**, int, int);");
        }
      if(Use_ContainedIn ){
          fprintf(FP_OUTPUT,"%s\n","int     containedin (char*, char **, int=0);");
        }
      if(Use_FindInType ){
          fprintf(FP_OUTPUT,"%s\n","int     FindInType (LPCTSTR, LPCTSTR, int, int, int, int=0, PINT=NULL);");
        }
      if(Use_Printer ){
          fprintf(FP_OUTPUT,"%s%s%s\n","int     PrinterOpen  (LPCTSTR =",enc("Courier New"),", int=12, int=DEFAULT_CHARSET);");
          fprintf(FP_OUTPUT,"%s\n","void    PrinterWrite (LPCTSTR, int=80, int=60);");
          fprintf(FP_OUTPUT,"%s\n","void    EjectPage    (void);");
          fprintf(FP_OUTPUT,"%s\n","void    PrinterClose (void);");
        }
      if(Use_COM ){
          fprintf(FP_OUTPUT,"%s\n","");
          fprintf(FP_OUTPUT,"%s\n","// *************************************************");
          fprintf(FP_OUTPUT,"%s\n","//          Late binding COM support section");
          fprintf(FP_OUTPUT,"%s\n","//  (c) Ljubisa Knezevic 2004-2009, ljube@blic.net");
          fprintf(FP_OUTPUT,"%s\n","// *************************************************");
          fprintf(FP_OUTPUT,"%s\n","");
          fprintf(FP_OUTPUT,"%s\n","#define COM_MSGBOX(a,b,c)MessageBox(GetActiveWindow(),(a),(b),(c))");
          fprintf(FP_OUTPUT,"%s\n","#define COM_PROPS DISPATCH_PROPERTYGET|DISPATCH_METHOD");
          fprintf(FP_OUTPUT,"%s\n","#define COM_PARAMS COM_param_list.pParams");
          fprintf(FP_OUTPUT,"%s\n","");
        }
      if(Use_WideToAnsi ){
          fprintf(FP_OUTPUT,"%s\n","//<---UNICODE AWARE");
          fprintf(FP_OUTPUT,"%s\n","char*   WideToAnsi (LPWSTR, UINT=CP_ACP, ULONG=0);");
          fprintf(FP_OUTPUT,"%s\n","//>---UNICODE AWARE");
          fprintf(FP_OUTPUT,"%s\n","");
        }
      if(Use_AnsiToWide ){
          fprintf(FP_OUTPUT,"%s\n","//<---UNICODE AWARE");
          fprintf(FP_OUTPUT,"%s\n","PWSTR AnsiToWide (LPCSTR, UINT=CP_ACP, ULONG=MB_PRECOMPOSED);");
          fprintf(FP_OUTPUT,"%s\n","//>---UNICODE AWARE");
          fprintf(FP_OUTPUT,"%s\n","");
        }
      if(Use_SafeArrays ){
          fprintf(FP_OUTPUT,"%s\n","HRESULT InitSafeArray    (SAFEARRAY** ppsa, VARTYPE vtype, UINT ndim, ...);");
          fprintf(FP_OUTPUT,"%s\n","HRESULT DestroySafeArray (SAFEARRAY* psA);");
          fprintf(FP_OUTPUT,"%s\n","");
        }
      if(Use_COM_UsesConversion ){
          fprintf(FP_OUTPUT,"%s\n","HRESULT  COM_AS2WS (LPCSTR  ansi_string, UINT code_page=CP_ACP);");
          fprintf(FP_OUTPUT,"%s\n","HRESULT  COM_WS2AS (LPCWSTR wide_string, UINT code_page=CP_ACP);");
          fprintf(FP_OUTPUT,"%s\n","");
        }
      if(Use_COM_CLSID ){
          fprintf(FP_OUTPUT,"%s\n","char*    BCX_CLSID(char*);");
        }
      if(Use_COM ){
          fprintf(FP_OUTPUT,"%s% .15G \n","#define COM_STACK_SIZE ",(double)COM_STACK_SIZE);
          fprintf(FP_OUTPUT,"%s\n","#ifndef CON_VARBOOL2BOOL");
          fprintf(FP_OUTPUT,"%s\n","  #define CON_VARBOOL2BOOL(b) ((BOOL)(b ? TRUE : FALSE))");
          fprintf(FP_OUTPUT,"%s\n","#endif");
          fprintf(FP_OUTPUT,"%s\n","");
          fprintf(FP_OUTPUT,"%s\n","typedef struct _OBJECT {");
          fprintf(FP_OUTPUT,"%s\n","  IUnknown*  p_unknown;");
          fprintf(FP_OUTPUT,"%s\n","  VARIANT    pObjects[COM_STACK_SIZE];");
          fprintf(FP_OUTPUT,"%s\n","  BOOL       pStatus;");
          fprintf(FP_OUTPUT,"%s\n","  int        ipointer;");
          fprintf(FP_OUTPUT,"%s\n","}OBJECT, *LPOBJECT;");
          fprintf(FP_OUTPUT,"%s\n","");
          fprintf(FP_OUTPUT,"%s\n","typedef struct _PARAM_VARARRAY {");
          fprintf(FP_OUTPUT,"%s\n","  VARIANT  pParams[COM_STACK_SIZE];");
          fprintf(FP_OUTPUT,"%s\n","}PARAM_VARARRAY, *LPPARAM_VARARRAY;");
          fprintf(FP_OUTPUT,"%s\n","");
          fprintf(FP_OUTPUT,"%s\n","// *************************************************");
          fprintf(FP_OUTPUT,"%s\n","//       COM functions used internally by BCX");
          fprintf(FP_OUTPUT,"%s\n","// *************************************************");
          fprintf(FP_OUTPUT,"%s\n","");
          fprintf(FP_OUTPUT,"%s\n","void     COM_ole_initialize            (void);");
          fprintf(FP_OUTPUT,"%s\n","void     COM_ole_uninitialize          (void);");
          fprintf(FP_OUTPUT,"%s\n","void     COM_HR_ErrMsg                 (HRESULT hr, TCHAR *extra_info);");
          fprintf(FP_OUTPUT,"%s\n","DISPID   COM_get_dispatch_ID           (IDispatch *lpDispatch, PWSTR comsegment);");
          fprintf(FP_OUTPUT,"%s\n","void     COM_get_next_dispatch         (OBJECT *object, PWSTR comsegment);");
          fprintf(FP_OUTPUT,"%s\n","void     COM_invoke                    (OBJECT *object, PWSTR comsegment, WORD wFlags, VARIANT *pvResult);");
          fprintf(FP_OUTPUT,"%s\n","void     COM_build_except_info         (HRESULT hr, EXCEPINFO *pexcep = NULL, UINT uiArgErr = 0);");
          fprintf(FP_OUTPUT,"%s\n","void     COM_clean_plist               (void);");
          fprintf(FP_OUTPUT,"%s\n","void     COM_reset_disp_chain          (OBJECT *object);");
          fprintf(FP_OUTPUT,"%s\n","void     COM_create_safearray          (void);");
          if(COM_build_trace_code ){
              fprintf(FP_OUTPUT,"%s\n","static char COM_trace_line[BCXSTRSIZE];");
            }
          fprintf(FP_OUTPUT,"%s\n","void     COM_trace_dump_DISPPARAMS     (DISPPARAMS* dp);");
          fprintf(FP_OUTPUT,"%s\n","void     COM_trace_add_line            (LPCTSTR dp);");
          fprintf(FP_OUTPUT,"%s\n","void     COM_trace_dump_indicators     (OBJECT *object);");
          fprintf(FP_OUTPUT,"%s\n","void     COM_trace_dump_flags          (WORD wFlags);");
          fprintf(FP_OUTPUT,"%s\n","void     COM_FREE_TEMP_ANSI_STRING     (void);");
          fprintf(FP_OUTPUT,"%s\n","void     COM_FREE_TEMP_WIDE_STRING     (void);");
          fprintf(FP_OUTPUT,"%s\n","");
          fprintf(FP_OUTPUT,"%s\n","// *************************************************");
          fprintf(FP_OUTPUT,"%s\n","//       Public COM support functions");
          fprintf(FP_OUTPUT,"%s\n","// *************************************************");
          fprintf(FP_OUTPUT,"%s\n","");
          fprintf(FP_OUTPUT,"%s\n","OBJECT   COM                    (LPCTSTR);");
          fprintf(FP_OUTPUT,"%s\n","void     UNCOM                  (OBJECT);");
          fprintf(FP_OUTPUT,"%s\n","void     BCX_SHOW_COM_ERRORS    (BOOL);");
          fprintf(FP_OUTPUT,"%s\n","void     BCX_SetNothing         (OBJECT*);");
          fprintf(FP_OUTPUT,"%s\n","BOOL     BCX_GET_COM_SUCCESS    (void);");
          fprintf(FP_OUTPUT,"%s\n","BOOL     BCX_GET_COM_STATUS     (OBJECT*);");
          fprintf(FP_OUTPUT,"%s\n","char*    BCX_GET_COM_ERROR_DESC (void);");
          fprintf(FP_OUTPUT,"%s\n","int      ISOBJECT               (OBJECT);");
          fprintf(FP_OUTPUT,"%s\n","HRESULT  BCX_GET_COM_ERROR_CODE (void);");
          if(Use_COM_CreateObject ){
              fprintf(FP_OUTPUT,"%s\n","void     BCX_CreateObject       (TCHAR *objname, OBJECT *obj);");
            }
          if(Use_COM_GetObject ){
              fprintf(FP_OUTPUT,"%s\n","void     BCX_GetObject          (TCHAR *objname, OBJECT *obj);");
              fprintf(FP_OUTPUT,"%s\n","void     BCX_GetObjectMon       (LPCOLESTR objname, OBJECT *obj);");
            }
          if(Use_COM_DispatchObject ){
              fprintf(FP_OUTPUT,"%s\n","void     BCX_DispatchObject     (IUnknown *iobj, OBJECT *obj, BOOL b_release = TRUE);");
            }
        }
    }
}

void Emit_COM_SupportTypes (FILE* FP_OUTPUT)
{
  char prefix[BCXSTRSIZE];
  strcpy(prefix,"static ");
  if(Use_Project ){
      *prefix=0;
    }
  fprintf(FP_OUTPUT,"%s\n","// *************************************************");
  fprintf(FP_OUTPUT,"%s\n","//    Global vars used by late binding COM support");
  fprintf(FP_OUTPUT,"%s\n","// *************************************************");
  fprintf(FP_OUTPUT,"%s\n","");
  fprintf(FP_OUTPUT,"%s%s\n",prefix,"PARAM_VARARRAY  COM_param_list;");
  fprintf(FP_OUTPUT,"%s%s\n",prefix,"_TCHAR          COM_last_ErrMsg[4096];");
  fprintf(FP_OUTPUT,"%s%s\n",prefix,"_TCHAR          COM_ErrMsg[64];");
  fprintf(FP_OUTPUT,"%s%s\n",prefix,"int             COM_plist_index = 0;");
  fprintf(FP_OUTPUT,"%s%s\n",prefix,"VARIANT         COM_vt_result;");
  fprintf(FP_OUTPUT,"%s%s\n",prefix,"HRESULT         COM_last_HR;");
  fprintf(FP_OUTPUT,"%s%s\n",prefix,"BOOL            COM_ole_initd = FALSE;");
  fprintf(FP_OUTPUT,"%s%s\n",prefix,"int             COM_objects_cnt = 0;");
  fprintf(FP_OUTPUT,"%s%s\n",prefix,"int             COM_reset_chain = 0;");
  fprintf(FP_OUTPUT,"%s%s\n",prefix,"BOOL            COM_BCX_ERROR = FALSE;");
  fprintf(FP_OUTPUT,"%s%s\n",prefix,"BOOL            COM_bSHOW_ERROR = FALSE;");
  fprintf(FP_OUTPUT,"%s%s\n",prefix,"SAFEARRAY *     COM_PTR_safearray = NULL;");
  fprintf(FP_OUTPUT,"%s%s\n",prefix,"PWSTR           COM_LPWSTR_temp = NULL;");
  fprintf(FP_OUTPUT,"%s%s\n",prefix,"char*           COM_psz_tmp = NULL;");
  fprintf(FP_OUTPUT,"%s%s\n",prefix,"ULONG           COM_wstr_size = 0;");
  fprintf(FP_OUTPUT,"%s%s\n",prefix,"ULONG           COM_zstr_size = 0;");
  fprintf(FP_OUTPUT,"%s%s\n",prefix,"BOOL            COM_GetEnum_iface = FALSE;");
  fprintf(FP_OUTPUT,"%s%s% .15G %s\n",prefix,"int             COM_dispatch_storage[",(double)COM_Max_Withs,"];");
  fprintf(FP_OUTPUT,"%s%s\n",prefix,"int             COM_dispatch_storage_index = 0;");
  fprintf(FP_OUTPUT,"%s%s\n",prefix,"int             COM_dispatch_at_offset = 0;");
  if(Use_COM_Collections ){
      fprintf(FP_OUTPUT,"%s%s\n",prefix,"VARIANT         COM_ack_var;");
      fprintf(FP_OUTPUT,"%s%s\n",prefix,"IEnumVARIANT*   COM_enum_var = NULL;");
      fprintf(FP_OUTPUT,"%s%s\n",prefix,"ULONG           COM_long_coll = 0;");
    }
}

void Emit_COM_StandardSet (FILE* FP_OUTPUT)
{
  fprintf(FP_OUTPUT,"%s\n","// *************************************************");
  fprintf(FP_OUTPUT,"%s\n","//              COM Runtime Functions");
  fprintf(FP_OUTPUT,"%s\n","// *************************************************");
  fprintf(FP_OUTPUT,"%s\n","");
  fprintf(FP_OUTPUT,"%s\n","OBJECT COM (LPCTSTR szProgID_) {");
  fprintf(FP_OUTPUT,"%s\n","    static OBJECT oProxy;");
  fprintf(FP_OUTPUT,"%s\n","    BCX_CreateObject ((char*)szProgID_, &oProxy);");
  fprintf(FP_OUTPUT,"%s\n","    return oProxy;");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
  fprintf(FP_OUTPUT,"%s\n","void UNCOM (OBJECT oObj_) {");
  fprintf(FP_OUTPUT,"%s\n","    static OBJECT oProxy;");
  fprintf(FP_OUTPUT,"%s\n","    oProxy = oObj_;");
  fprintf(FP_OUTPUT,"%s\n","    BCX_SetNothing (&oProxy);");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
  fprintf(FP_OUTPUT,"%s\n","int ISOBJECT (OBJECT Obj) {");
  fprintf(FP_OUTPUT,"%s\n","    if(Obj.pStatus)");
  fprintf(FP_OUTPUT,"%s\n","        return TRUE;");
  fprintf(FP_OUTPUT,"%s\n","   else");
  fprintf(FP_OUTPUT,"%s\n","       return FALSE;");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
  fprintf(FP_OUTPUT,"%s\n","HRESULT BCX_GET_COM_ERROR_CODE (void) {");
  fprintf(FP_OUTPUT,"%s\n","    return COM_last_HR;");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
  fprintf(FP_OUTPUT,"%s\n","_TCHAR* BCX_GET_COM_ERROR_DESC (void) {");
  fprintf(FP_OUTPUT,"%s\n","    return COM_last_ErrMsg;");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
  fprintf(FP_OUTPUT,"%s\n","BOOL BCX_GET_COM_SUCCESS (void) {");
  fprintf(FP_OUTPUT,"%s\n","    return (!COM_BCX_ERROR);");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
  fprintf(FP_OUTPUT,"%s\n","void BCX_SHOW_COM_ERRORS (BOOL Show_err) {");
  fprintf(FP_OUTPUT,"%s\n","    COM_bSHOW_ERROR = Show_err;");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
  fprintf(FP_OUTPUT,"%s\n","BOOL BCX_GET_COM_STATUS(OBJECT *object) {");
  fprintf(FP_OUTPUT,"%s\n","    if(object)");
  fprintf(FP_OUTPUT,"%s\n","        return object->pStatus;");
  fprintf(FP_OUTPUT,"%s\n","    return 0;");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
  fprintf(FP_OUTPUT,"%s\n","void  COM_clean_plist (void) {");
  fprintf(FP_OUTPUT,"%s\n","int total_parms = COM_plist_index;");
  fprintf(FP_OUTPUT,"%s\n","if (COM_plist_index > 0)");
  fprintf(FP_OUTPUT,"%s\n","   {");
  fprintf(FP_OUTPUT,"%s\n","      do");
  fprintf(FP_OUTPUT,"%s\n","   {");
  if(COM_build_trace_code ){
      fprintf(FP_OUTPUT,"%s%s%s\n","    sprintf(COM_trace_line, ",enc("+++ clear parameter list. Clear variant at index %d. Variant type = %d"),",COM_plist_index-1,");
      fprintf(FP_OUTPUT,"%s\n","          COM_PARAMS[COM_plist_index-1].vt);");
      fprintf(FP_OUTPUT,"%s\n","    COM_add_trace_line (COM_trace_line);");
    }
  fprintf(FP_OUTPUT,"%s\n","        COM_last_HR = VariantClear (&COM_PARAMS[COM_plist_index-1]);");
  fprintf(FP_OUTPUT,"%s\n","        if (FAILED(COM_last_HR))");
  fprintf(FP_OUTPUT,"%s\n","        {");
  fprintf(FP_OUTPUT,"%s%s%s\n","        wsprintf (COM_ErrMsg, _T(",enc("\\nVariant type = %d, at index %d, total params = %d."),"),");
  fprintf(FP_OUTPUT,"%s\n","                  COM_PARAMS[COM_plist_index-1].vt, COM_plist_index-1, total_parms);");
  fprintf(FP_OUTPUT,"%s%s%s\n","        COM_HR_ErrMsg (COM_last_HR, _T(",enc("Error while cleaning parameter list."),"));");
  fprintf(FP_OUTPUT,"%s\n","      }");
  fprintf(FP_OUTPUT,"%s\n","        COM_plist_index--;");
  fprintf(FP_OUTPUT,"%s\n","    }");
  fprintf(FP_OUTPUT,"%s\n","      while (COM_plist_index > 0);");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
  fprintf(FP_OUTPUT,"%s\n","void  COM_reset_disp_chain (OBJECT *object) {");
  fprintf(FP_OUTPUT,"%s\n","  if (object->ipointer>COM_dispatch_at_offset)");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s\n","    do");
  fprintf(FP_OUTPUT,"%s\n","    {");
  if(COM_build_trace_code ){
      fprintf(FP_OUTPUT,"%s%s\n","  sprintf(COM_trace_line, ",enc("Dispath release at index %d. Variant Type = %d"));
      fprintf(FP_OUTPUT,"%s\n","  ,object->ipointer,object->pObjects[object->ipointer].vt);");
      fprintf(FP_OUTPUT,"%s\n","  COM_add_trace_line (COM_trace_line);");
    }
  fprintf(FP_OUTPUT,"%s\n","      VariantClear (&object->pObjects[object->ipointer]);");
  fprintf(FP_OUTPUT,"%s\n","      object->ipointer--;");
  fprintf(FP_OUTPUT,"%s\n","    }");
  fprintf(FP_OUTPUT,"%s\n","    while (object->ipointer > COM_dispatch_at_offset);");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
  fprintf(FP_OUTPUT,"%s\n","void  COM_ole_uninitialize (void) {");
  fprintf(FP_OUTPUT,"%s\n","  if (COM_objects_cnt)");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s\n","    _TCHAR ermm[BCXSTRSIZE];");
  fprintf(FP_OUTPUT,"%s%s%s\n","    wsprintf (ermm,_T(",enc("Check SET Nothing statement!\\nUnreleased objects: %d"),"),COM_objects_cnt);");
  fprintf(FP_OUTPUT,"%s%s%s\n","    COM_MSGBOX (ermm, _T(",enc("Memory leaks detected!"),"),MB_OK|MB_ICONWARNING|MB_TASKMODAL);");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","  COM_FREE_TEMP_WIDE_STRING();");
  fprintf(FP_OUTPUT,"%s\n","  COM_FREE_TEMP_ANSI_STRING();");
  fprintf(FP_OUTPUT,"%s\n","  CoUninitialize();");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
  fprintf(FP_OUTPUT,"%s\n","void  COM_get_next_dispatch (OBJECT *object, PWSTR comsegment) {");
  fprintf(FP_OUTPUT,"%s\n","  if (!object->pStatus) return;");
  fprintf(FP_OUTPUT,"%s\n","  if (0 == object->ipointer) COM_BCX_ERROR = FALSE;");
  fprintf(FP_OUTPUT,"%s\n","  if (COM_BCX_ERROR) return;");
  fprintf(FP_OUTPUT,"%s\n","  COM_reset_chain++;");
  fprintf(FP_OUTPUT,"%s\n","  COM_invoke (object, comsegment,COM_PROPS,&object->pObjects[object->ipointer+1]);");
  fprintf(FP_OUTPUT,"%s\n","  COM_reset_chain--;");
  fprintf(FP_OUTPUT,"%s\n","  if (!COM_BCX_ERROR)");
  fprintf(FP_OUTPUT,"%s\n","     object->ipointer++;");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
  fprintf(FP_OUTPUT,"%s\n","void COM_HR_ErrMsg (HRESULT hr, _TCHAR *extra_info) {");
  fprintf(FP_OUTPUT,"%s\n","  COM_BCX_ERROR = TRUE;");
  fprintf(FP_OUTPUT,"%s\n","  PVOID pMsgBuf;");
  fprintf(FP_OUTPUT,"%s\n","");
  fprintf(FP_OUTPUT,"%s\n","  FormatMessage (FORMAT_MESSAGE_ALLOCATE_BUFFER|FORMAT_MESSAGE_FROM_SYSTEM,");
  fprintf(FP_OUTPUT,"%s\n","  NULL, hr, MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), (LPTSTR)&pMsgBuf, 0, NULL);");
  fprintf(FP_OUTPUT,"%s\n","");
  fprintf(FP_OUTPUT,"%s%s%s\n","  wsprintf(COM_last_ErrMsg, _T(",enc("COM error code %d (0x%X)\\n%s\\n%s\\nmember: %s"),"),");
  fprintf(FP_OUTPUT,"%s\n","  hr, hr, extra_info, pMsgBuf, COM_ErrMsg);");
  if(COM_build_trace_code ){
      fprintf(FP_OUTPUT,"%s\n","");
      fprintf(FP_OUTPUT,"%s%s%s\n","  COM_trace_add_line(",enc(">>> COM ERROR DUMP >>> COM ERROR DUM >>> COM ERROR DUMP >>>"),");");
      fprintf(FP_OUTPUT,"%s\n","  COM_trace_add_line(COM_last_ErrMsg);");
      fprintf(FP_OUTPUT,"%s%s%s\n","  COM_trace_add_line(",enc("<<< COM ERROR DUMP <<< COM ERROR DUM <<< COM ERROR DUMP <<<"),");");
      fprintf(FP_OUTPUT,"%s\n","");
    }
  fprintf(FP_OUTPUT,"%s\n","");
  fprintf(FP_OUTPUT,"%s\n","  memset(&COM_ErrMsg,0,sizeof(COM_ErrMsg));");
  fprintf(FP_OUTPUT,"%s\n","  if (COM_bSHOW_ERROR)");
  fprintf(FP_OUTPUT,"%s%s%s\n","      COM_MSGBOX(COM_last_ErrMsg,_T(",enc("COM Parser Error Report:"),"),");
  fprintf(FP_OUTPUT,"%s\n","      MB_OK|MB_ICONERROR|MB_SYSTEMMODAL);");
  fprintf(FP_OUTPUT,"%s\n","  LocalFree(pMsgBuf);");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
  fprintf(FP_OUTPUT,"%s\n","void BCX_SetNothing (OBJECT *obj) {");
  fprintf(FP_OUTPUT,"%s\n","  if (!obj->pStatus) return;");
  if(COM_build_trace_code ){
      fprintf(FP_OUTPUT,"%s%s%s\n","  COM_trace_add_line (",enc("Called BCX_SetNothing"),");");
    }
  fprintf(FP_OUTPUT,"%s\n","  COM_objects_cnt--;");
  fprintf(FP_OUTPUT,"%s\n","  #ifdef __cplusplus");
  fprintf(FP_OUTPUT,"%s\n","    if (obj->p_unknown) obj->p_unknown->Release();");
  fprintf(FP_OUTPUT,"%s\n","  #else");
  fprintf(FP_OUTPUT,"%s\n","    if (obj->p_unknown) obj->p_unknown->lpVtbl->Release(obj->p_unknown);");
  fprintf(FP_OUTPUT,"%s\n","  #endif");
  fprintf(FP_OUTPUT,"%s\n","  if (obj->ipointer)");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s\n","    COM_reset_disp_chain (obj);");
  fprintf(FP_OUTPUT,"%s\n","    obj->ipointer = 0;");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","  COM_last_HR = VariantClear (&obj->pObjects[0]);");
  fprintf(FP_OUTPUT,"%s\n","  if (FAILED(COM_last_HR))");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s%s%s\n","    lstrcpy(COM_ErrMsg, _T(",enc("BCX_SetNothing Failed!"),"));");
  fprintf(FP_OUTPUT,"%s%s%s\n","    COM_HR_ErrMsg (COM_last_HR, _T(",enc("Release of IDispatch objs failed!"),"));");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","  obj->pStatus = FALSE;");
  fprintf(FP_OUTPUT,"%s\n","  Sleep(100);");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
  fprintf(FP_OUTPUT,"%s\n","void COM_ole_initialize (void) {");
  fprintf(FP_OUTPUT,"%s\n","  if (COM_ole_initd) return;");
  if(COM_build_trace_code ){
      fprintf(FP_OUTPUT,"%s%s%s\n","DeleteFile (",enc("c:\\com_trace.txt"),");");
    }
  fprintf(FP_OUTPUT,"%s\n","  #ifdef __BCX_MULTITHREADED__");
  fprintf(FP_OUTPUT,"%s\n","    COM_last_HR = CoInitializeEx (NULL, COINIT_MULTITHREADED);");
  fprintf(FP_OUTPUT,"%s\n","  #else");
  fprintf(FP_OUTPUT,"%s\n","    COM_last_HR = CoInitializeEx (NULL, COINIT_APARTMENTTHREADED);");
  fprintf(FP_OUTPUT,"%s\n","  #endif");
  fprintf(FP_OUTPUT,"%s\n","  if (SUCCEEDED (COM_last_HR))");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s\n","    COM_ole_initd = TRUE;");
  fprintf(FP_OUTPUT,"%s\n","    VariantInit (&COM_vt_result);");
  fprintf(FP_OUTPUT,"%s\n","    atexit (COM_ole_uninitialize);");
  fprintf(FP_OUTPUT,"%s\n","");
  fprintf(FP_OUTPUT,"%s\n","    COM_dispatch_storage[0] = 0;");
  fprintf(FP_OUTPUT,"%s\n","    COM_dispatch_storage_index = 0;");
  fprintf(FP_OUTPUT,"%s\n","");
  fprintf(FP_OUTPUT,"%s\n","    if (COM_LPWSTR_temp) CoTaskMemFree((void*)COM_LPWSTR_temp);");
  fprintf(FP_OUTPUT,"%s\n","    COM_LPWSTR_temp = (PWSTR)CoTaskMemAlloc (BCXSTRSIZE);");
  fprintf(FP_OUTPUT,"%s\n","    if (NULL == COM_LPWSTR_temp)");
  fprintf(FP_OUTPUT,"%s\n","    {");
  fprintf(FP_OUTPUT,"%s\n","      COM_wstr_size = 0;");
  fprintf(FP_OUTPUT,"%s\n","      COM_last_HR =  E_OUTOFMEMORY;");
  fprintf(FP_OUTPUT,"%s\n","      COM_HR_ErrMsg (COM_last_HR,_T(");
  fprintf(FP_OUTPUT,"%s%s%s\n","     ",enc("CoInitializeEx: Memory allocation failure!"),"));");
  fprintf(FP_OUTPUT,"%s\n","      return;");
  fprintf(FP_OUTPUT,"%s\n","    }");
  fprintf(FP_OUTPUT,"%s\n","    COM_wstr_size = BCXSTRSIZE;");
  fprintf(FP_OUTPUT,"%s\n","    if (COM_psz_tmp) free(COM_psz_tmp);");
  fprintf(FP_OUTPUT,"%s\n","    COM_psz_tmp = (char*)calloc(BCXSTRSIZE, sizeof(char));");
  fprintf(FP_OUTPUT,"%s\n","    if (NULL == COM_psz_tmp)");
  fprintf(FP_OUTPUT,"%s\n","    {");
  fprintf(FP_OUTPUT,"%s\n","      COM_last_HR =  E_OUTOFMEMORY;");
  fprintf(FP_OUTPUT,"%s\n","      COM_HR_ErrMsg (COM_last_HR,_T(");
  fprintf(FP_OUTPUT,"%s%s%s\n","     ",enc("CoInitializeEx: Memory allocation failure!"),"));");
  fprintf(FP_OUTPUT,"%s\n","    return;");
  fprintf(FP_OUTPUT,"%s\n","    }");
  fprintf(FP_OUTPUT,"%s\n","    COM_zstr_size = BCXSTRSIZE;");
  fprintf(FP_OUTPUT,"%s\n","    return;");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","  else");
  fprintf(FP_OUTPUT,"%s%s%s\n","    COM_HR_ErrMsg (COM_last_HR,_T(",enc("CoInitializeEx Failed!"),"));");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
  fprintf(FP_OUTPUT,"%s\n","void COM_build_except_info (HRESULT hr, EXCEPINFO *pexcep, UINT uiArgErr) {");
  fprintf(FP_OUTPUT,"%s\n","  SCODE oleSCODE;");
  fprintf(FP_OUTPUT,"%s\n","  static _TCHAR lv_message[BCXSTRSIZE];");
  fprintf(FP_OUTPUT,"%s\n","  oleSCODE = GetScode(hr);");
  fprintf(FP_OUTPUT,"%s\n","  for (;;)");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s\n","    if (oleSCODE==DISP_E_PARAMNOTFOUND)");
  fprintf(FP_OUTPUT,"%s\n","    {");
  fprintf(FP_OUTPUT,"%s%s%s\n","      wsprintf (lv_message, _T(",enc("\\nArgument not found, argument %d."),"), uiArgErr);");
  fprintf(FP_OUTPUT,"%s\n","      _tcscat(COM_last_ErrMsg, lv_message);");
  fprintf(FP_OUTPUT,"%s\n","      break;");
  fprintf(FP_OUTPUT,"%s\n","    }");
  fprintf(FP_OUTPUT,"%s\n","    if (oleSCODE==DISP_E_TYPEMISMATCH)");
  fprintf(FP_OUTPUT,"%s\n","    {");
  fprintf(FP_OUTPUT,"%s%s%s\n","      wsprintf (lv_message, _T(",enc("\\nType mismatch, argument %d."),"), uiArgErr);");
  fprintf(FP_OUTPUT,"%s\n","      _tcscat (COM_last_ErrMsg, lv_message);");
  fprintf(FP_OUTPUT,"%s\n","      break;");
  fprintf(FP_OUTPUT,"%s\n","    }");
  fprintf(FP_OUTPUT,"%s\n","    if (oleSCODE==DISP_E_BADVARTYPE)");
  fprintf(FP_OUTPUT,"%s\n","    {");
  fprintf(FP_OUTPUT,"%s%s%s\n","      _tcscat(COM_last_ErrMsg, _T(",enc("\\nOne or more invalid VARIANT arguments."),"));");
  fprintf(FP_OUTPUT,"%s\n","      break;");
  fprintf(FP_OUTPUT,"%s\n","    }");
  fprintf(FP_OUTPUT,"%s\n","    if (oleSCODE==E_INVALIDARG)");
  fprintf(FP_OUTPUT,"%s\n","    {");
  fprintf(FP_OUTPUT,"%s%s%s\n","      _tcscat(COM_last_ErrMsg, _T(",enc("\\nOne of the arguments is invalid."),"));");
  fprintf(FP_OUTPUT,"%s\n","      break;");
  fprintf(FP_OUTPUT,"%s\n","    }");
  fprintf(FP_OUTPUT,"%s\n","    break;");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","  if (pexcep)");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s%s%s\n","    wsprintf(lv_message, _T(",enc("\\nCOM Error %X:"),"), pexcep->wCode);");
  fprintf(FP_OUTPUT,"%s\n","    if (pexcep->bstrDescription)");
  fprintf(FP_OUTPUT,"%s\n","    {");
  fprintf(FP_OUTPUT,"%s\n","      _TCHAR err_desc[512];");
  fprintf(FP_OUTPUT,"%s\n","      #ifndef UNICODE");
  fprintf(FP_OUTPUT,"%s\n","        COM_last_HR = COM_WS2AS (pexcep->bstrDescription);");
  fprintf(FP_OUTPUT,"%s\n","        if (FAILED(COM_last_HR))");
  fprintf(FP_OUTPUT,"%s%s%s\n","          COM_HR_ErrMsg (COM_last_HR,_T(",enc("Get Error Desc: W2A failure!"),"));");
  fprintf(FP_OUTPUT,"%s\n","        else");
  fprintf(FP_OUTPUT,"%s%s%s\n","          wsprintf(err_desc, _T(",enc("\\nException desc: %s"),"), COM_psz_tmp);");
  fprintf(FP_OUTPUT,"%s\n","      #else");
  fprintf(FP_OUTPUT,"%s%s%s\n","          wsprintf(err_desc, _T(",enc("\\nException desc: %s"),"), pexcep->bstrDescription);");
  fprintf(FP_OUTPUT,"%s\n","      #endif");
  fprintf(FP_OUTPUT,"%s\n","      _tcscat(lv_message, err_desc);");
  fprintf(FP_OUTPUT,"%s\n","      SysFreeString(pexcep->bstrDescription);");
  fprintf(FP_OUTPUT,"%s\n","      pexcep->bstrDescription = NULL;");
  fprintf(FP_OUTPUT,"%s\n","    }");
  fprintf(FP_OUTPUT,"%s\n","    if (pexcep->bstrSource)");
  fprintf(FP_OUTPUT,"%s\n","    {");
  fprintf(FP_OUTPUT,"%s\n","      _TCHAR err_desc[512];");
  fprintf(FP_OUTPUT,"%s\n","      #ifndef UNICODE");
  fprintf(FP_OUTPUT,"%s\n","        COM_last_HR = COM_WS2AS (pexcep->bstrSource);");
  fprintf(FP_OUTPUT,"%s\n","        if (FAILED(COM_last_HR))");
  fprintf(FP_OUTPUT,"%s%s%s\n","            COM_HR_ErrMsg (COM_last_HR,_T(",enc("Get Error Source Failed! W2A failure!"),"));");
  fprintf(FP_OUTPUT,"%s\n","        else");
  fprintf(FP_OUTPUT,"%s%s%s\n","            wsprintf(err_desc, _T(",enc("\\nException source: %s"),"), COM_psz_tmp);");
  fprintf(FP_OUTPUT,"%s\n","      #else");
  fprintf(FP_OUTPUT,"%s%s%s\n","            wsprintf(err_desc, _T(",enc("\\nException source: %s"),"), pexcep->bstrSource);");
  fprintf(FP_OUTPUT,"%s\n","      #endif");
  fprintf(FP_OUTPUT,"%s\n","      _tcscat (lv_message, err_desc);");
  fprintf(FP_OUTPUT,"%s\n","      SysFreeString (pexcep->bstrSource);");
  fprintf(FP_OUTPUT,"%s\n","      pexcep->bstrSource = NULL;");
  fprintf(FP_OUTPUT,"%s\n","    }");
  fprintf(FP_OUTPUT,"%s\n","    if (pexcep->bstrHelpFile)");
  fprintf(FP_OUTPUT,"%s\n","    {");
  fprintf(FP_OUTPUT,"%s\n","      _TCHAR err_desc[512];");
  fprintf(FP_OUTPUT,"%s\n","      #ifndef UNICODE");
  fprintf(FP_OUTPUT,"%s\n","        COM_last_HR = COM_WS2AS (pexcep->bstrHelpFile);");
  fprintf(FP_OUTPUT,"%s\n","        if (FAILED(COM_last_HR))");
  fprintf(FP_OUTPUT,"%s%s%s\n","        COM_HR_ErrMsg (COM_last_HR,_T(",enc("Help File failed: W2A failure!"),"));");
  fprintf(FP_OUTPUT,"%s\n","        else");
  fprintf(FP_OUTPUT,"%s\n","        wsprintf(err_desc, _T(");
  fprintf(FP_OUTPUT,"%s%s%s\n","        ",enc("\\nHelp file: %s | topic: %lu"),"), COM_psz_tmp, pexcep->dwHelpContext);");
  fprintf(FP_OUTPUT,"%s\n","      #else");
  fprintf(FP_OUTPUT,"%s\n","        wsprintf(err_desc, _T(");
  fprintf(FP_OUTPUT,"%s%s%s\n","        ",enc("\\nHelp file: %s | topic: %lu"),"), pexcep->bstrHelpFile, pexcep->dwHelpContext);");
  fprintf(FP_OUTPUT,"%s\n","      #endif");
  fprintf(FP_OUTPUT,"%s\n","      _tcscat(lv_message, err_desc);");
  fprintf(FP_OUTPUT,"%s\n","      SysFreeString (pexcep->bstrHelpFile);");
  fprintf(FP_OUTPUT,"%s\n","      pexcep->bstrHelpFile = NULL;");
  fprintf(FP_OUTPUT,"%s\n","    }");
  fprintf(FP_OUTPUT,"%s\n","    _tcscat (COM_last_ErrMsg ,lv_message);");
  fprintf(FP_OUTPUT,"%s\n","  }");
  if(COM_build_trace_code ){
      fprintf(FP_OUTPUT,"%s%s%s\n","  COM_trace_add_line(",enc(">>> COM EXCEPTION DUMP >>> COM EXCEPTION DUMP >>>"),");");
      fprintf(FP_OUTPUT,"%s\n","  COM_trace_add_line(COM_last_ErrMsg);");
      fprintf(FP_OUTPUT,"%s%s%s\n","  COM_trace_add_line(",enc("<<< COM EXCEPTION DUMP <<< COM EXCEPTION DUMP <<<"),");");
    }
  fprintf(FP_OUTPUT,"%s\n","  if (COM_bSHOW_ERROR)");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s%s%s\n","    COM_MSGBOX(COM_last_ErrMsg, _T(",enc("COM Parser Exception Info:"),"),");
  fprintf(FP_OUTPUT,"%s\n","    MB_OK|MB_ICONERROR|MB_SYSTEMMODAL);");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
  fprintf(FP_OUTPUT,"%s\n","DISPID COM_get_dispatch_ID (IDispatch* lpDispatch, PWSTR comsegment) {");
  fprintf(FP_OUTPUT,"%s\n","  static DISPID D_ID;");
  fprintf(FP_OUTPUT,"%s\n","  D_ID = 0;");
  fprintf(FP_OUTPUT,"%s\n","  if (!lpDispatch) return -1;");
  fprintf(FP_OUTPUT,"%s\n","  #ifdef __cplusplus");
  fprintf(FP_OUTPUT,"%s\n","    COM_last_HR = lpDispatch->GetIDsOfNames");
  fprintf(FP_OUTPUT,"%s\n","                 (IID_NULL, &comsegment, 1, LOCALE_SYSTEM_DEFAULT, &D_ID);");
  fprintf(FP_OUTPUT,"%s\n","  #else");
  fprintf(FP_OUTPUT,"%s\n","    COM_last_HR = lpDispatch->lpVtbl->GetIDsOfNames");
  fprintf(FP_OUTPUT,"%s\n","                 (lpDispatch, &IID_NULL, &comsegment, 1, LOCALE_SYSTEM_DEFAULT, &D_ID);");
  fprintf(FP_OUTPUT,"%s\n","  #endif");
  fprintf(FP_OUTPUT,"%s\n","  if (FAILED(COM_last_HR))");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s%s%s\n","    COM_HR_ErrMsg (COM_last_HR,_T(",enc("Unrecognized member name"),"));");
  fprintf(FP_OUTPUT,"%s\n","    return -1;");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","  return D_ID;");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
  fprintf(FP_OUTPUT,"%s\n","void COM_invoke (OBJECT *object, PWSTR comsegment, WORD wFlags, VARIANT *pvResult) {");
  fprintf(FP_OUTPUT,"%s\n","  if (!object->pStatus) return;");
  fprintf(FP_OUTPUT,"%s\n","  if (COM_BCX_ERROR) return;");
  fprintf(FP_OUTPUT,"%s\n","  DISPID lv_DID;");
  fprintf(FP_OUTPUT,"%s\n","  EXCEPINFO exception;");
  fprintf(FP_OUTPUT,"%s\n","  UINT argerr = 0;");
  fprintf(FP_OUTPUT,"%s\n","  DISPPARAMS dp = {NULL, NULL, 0, 0 };");
  fprintf(FP_OUTPUT,"%s\n","  WORD invoke_flags = 0;");
  fprintf(FP_OUTPUT,"%s\n","  DISPID setdispid = DISPID_PROPERTYPUT;");
  if(COM_build_trace_code ){
      fprintf(FP_OUTPUT,"%s\n","  char extra_error_info[BCXSTRSIZE];");
    }
  fprintf(FP_OUTPUT,"%s\n","  if (COM_GetEnum_iface)");
  fprintf(FP_OUTPUT,"%s\n","    lv_DID = DISPID_NEWENUM;");
  fprintf(FP_OUTPUT,"%s\n","  else");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s\n","    lv_DID = COM_get_dispatch_ID (object->pObjects[object->ipointer].pdispVal, comsegment);");
  fprintf(FP_OUTPUT,"%s\n","    if (-1 == lv_DID) goto cleanInProp;");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","  memset (&exception, 0, sizeof(EXCEPINFO));");
  fprintf(FP_OUTPUT,"%s\n","  if (COM_plist_index>0)");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s\n","    setdispid = DISPID_PROPERTYPUT;");
  fprintf(FP_OUTPUT,"%s\n","    dp.rgvarg = (VARIANTARG*)COM_PARAMS;");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","  if (wFlags & DISPATCH_PROPERTYPUT)");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s\n","    dp.rgdispidNamedArgs = &setdispid;");
  fprintf(FP_OUTPUT,"%s\n","    dp.cNamedArgs = 1;");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","  dp.cArgs = COM_plist_index;");
  fprintf(FP_OUTPUT,"%s\n","  invoke_flags = wFlags;");
  fprintf(FP_OUTPUT,"%s\n","  if (wFlags & DISPATCH_PROPERTYGET)");
  fprintf(FP_OUTPUT,"%s\n","    if (pvResult) VariantInit(pvResult);");
  if(COM_build_trace_code ){
      fprintf(FP_OUTPUT,"%s\n","  COM_trace_dump_DISPPARAMS(&dp);");
      fprintf(FP_OUTPUT,"%s\n","  COM_trace_dump_flags(wFlags);");
      fprintf(FP_OUTPUT,"%s\n","  COM_trace_dump_indicators(object);");
    }
  fprintf(FP_OUTPUT,"%s\n","  if (VT_DISPATCH!=object->pObjects[object->ipointer].vt||NULL==object->pObjects[object->ipointer].pdispVal)");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s\n","     COM_last_HR = E_NOINTERFACE;");
  fprintf(FP_OUTPUT,"%s%s%s\n","     COM_HR_ErrMsg (COM_last_HR,_T(",enc("COM_invoke::Invalid IDispatch interface."),"));");
  fprintf(FP_OUTPUT,"%s\n","     goto cleanInProp;");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","    #ifdef __cplusplus");
  fprintf(FP_OUTPUT,"%s\n","    COM_last_HR = object->pObjects[object->ipointer].pdispVal");
  fprintf(FP_OUTPUT,"%s\n","     ->Invoke (lv_DID, IID_NULL, LOCALE_SYSTEM_DEFAULT, ");
  fprintf(FP_OUTPUT,"%s\n","        invoke_flags, &dp, pvResult, &exception, &argerr);");
  fprintf(FP_OUTPUT,"%s\n","    #else");
  fprintf(FP_OUTPUT,"%s\n","    COM_last_HR = object->pObjects[object->ipointer].pdispVal->lpVtbl");
  fprintf(FP_OUTPUT,"%s\n","     ->Invoke(object->pObjects[object->ipointer].pdispVal, lv_DID, &IID_NULL, ");
  fprintf(FP_OUTPUT,"%s\n","        LOCALE_SYSTEM_DEFAULT, invoke_flags , &dp, pvResult, &exception, &argerr);");
  fprintf(FP_OUTPUT,"%s\n","    #endif");
  fprintf(FP_OUTPUT,"%s\n","  if (FAILED(COM_last_HR))");
  fprintf(FP_OUTPUT,"%s\n","  {");
  if(COM_build_trace_code ){
      fprintf(FP_OUTPUT,"%s%s%s\n","  COM_trace_add_line(",enc("Invoke FAILED!"),");");
    }
  fprintf(FP_OUTPUT,"%s%s%s\n","    COM_HR_ErrMsg (COM_last_HR,_T(",enc("COM_invoke::Invoke failed."),"));");
  fprintf(FP_OUTPUT,"%s\n","    COM_build_except_info (COM_last_HR, &exception, argerr);");
  fprintf(FP_OUTPUT,"%s\n","  }");
  if(COM_build_trace_code ){
      fprintf(FP_OUTPUT,"%s\n","  else ");
      fprintf(FP_OUTPUT,"%s\n","  {");
      fprintf(FP_OUTPUT,"%s%s%s\n","    COM_add_trace_line (",enc("Invoke SUCEEDED!"),");");
      fprintf(FP_OUTPUT,"%s\n","    if(wFlags & DISPATCH_PROPERTYGET)");
      fprintf(FP_OUTPUT,"%s\n","    {");
      fprintf(FP_OUTPUT,"%s%s%s\n","      sprintf (extra_error_info,",enc("result Variant type = %d"),",pvResult->vt);");
      fprintf(FP_OUTPUT,"%s\n","      COM_add_trace_line (extra_error_info);");
      fprintf(FP_OUTPUT,"%s\n","    }");
      fprintf(FP_OUTPUT,"%s\n","  }");
    }
  fprintf(FP_OUTPUT,"%s\n","cleanInProp:");
  fprintf(FP_OUTPUT,"%s\n","  if (V_ISARRAY(&COM_PARAMS[0]))");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s\n","    if ((VT_ARRAY|VT_VARIANT)==COM_PARAMS[0].vt)");
  fprintf(FP_OUTPUT,"%s\n","    {");
  fprintf(FP_OUTPUT,"%s\n","      COM_last_HR = SafeArrayDestroy(V_ARRAY(&COM_PARAMS[0]));");
  fprintf(FP_OUTPUT,"%s\n","      if (FAILED (COM_last_HR))");
  fprintf(FP_OUTPUT,"%s\n","      {");
  fprintf(FP_OUTPUT,"%s%s%s\n","        lstrcpy(COM_ErrMsg, _T(",enc("SafeArrayDestroy failed"),"));");
  fprintf(FP_OUTPUT,"%s%s%s\n","        COM_HR_ErrMsg (COM_last_HR,_T(",enc("Error wiping param list."),"));");
  fprintf(FP_OUTPUT,"%s\n","      }");
  fprintf(FP_OUTPUT,"%s\n","      ZeroMemory((PVOID)&COM_PARAMS[0],sizeof(VARIANT));");
  fprintf(FP_OUTPUT,"%s\n","      COM_PTR_safearray = NULL;");
  fprintf(FP_OUTPUT,"%s\n","      COM_plist_index = 0;");
  fprintf(FP_OUTPUT,"%s\n","    }");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","  if (COM_plist_index)  COM_clean_plist();");
  fprintf(FP_OUTPUT,"%s\n","  if (0 == COM_reset_chain)  COM_reset_disp_chain(object);");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
}

void Emit_COM_GetObject (FILE* FP_OUTPUT)
{
  fprintf(FP_OUTPUT,"%s\n","void BCX_GetObject (_TCHAR *objname, OBJECT *obj) {");
  fprintf(FP_OUTPUT,"%s\n","  if (!COM_ole_initd) COM_ole_initialize();");
  fprintf(FP_OUTPUT,"%s\n","  CLSID clsid;");
  fprintf(FP_OUTPUT,"%s\n","  #ifndef UNICODE");
  fprintf(FP_OUTPUT,"%s\n","    COM_last_HR = COM_AS2WS (objname);");
  fprintf(FP_OUTPUT,"%s\n","    if (FAILED(COM_last_HR))");
  fprintf(FP_OUTPUT,"%s\n","    {");
  fprintf(FP_OUTPUT,"%s%s%s\n","      COM_HR_ErrMsg (COM_last_HR,_T(",enc("CreateObject Failed! A2W failure!"),"));");
  fprintf(FP_OUTPUT,"%s\n","      return;");
  fprintf(FP_OUTPUT,"%s\n","    }");
  fprintf(FP_OUTPUT,"%s\n","    COM_last_HR = COM_WS2AS (COM_LPWSTR_temp);");
  fprintf(FP_OUTPUT,"%s\n","    if (FAILED (COM_last_HR))");
  fprintf(FP_OUTPUT,"%s\n","    {");
  fprintf(FP_OUTPUT,"%s%s%s\n","      COM_HR_ErrMsg (COM_last_HR,_T(",enc("CreateObject Failed! W2A failure!"),"));");
  fprintf(FP_OUTPUT,"%s\n","      return;");
  fprintf(FP_OUTPUT,"%s\n","    }");
  fprintf(FP_OUTPUT,"%s%s%s\n","    sprintf (COM_ErrMsg,",enc("%s, WideName(%s)"),", objname, COM_psz_tmp);");
  fprintf(FP_OUTPUT,"%s\n","    COM_last_HR = CLSIDFromProgID((LPCOLESTR)COM_LPWSTR_temp, (LPCLSID)&clsid);");
  fprintf(FP_OUTPUT,"%s\n","  #else");
  fprintf(FP_OUTPUT,"%s\n","    COM_last_HR = COM_WS2AS ((LPCWSTR)objname);");
  fprintf(FP_OUTPUT,"%s\n","    lstrcpy (COM_ErrMsg, COM_psz_tmp);");
  fprintf(FP_OUTPUT,"%s\n","    COM_last_HR = CLSIDFromProgID ((LPCOLESTR)objname, (LPCLSID)&clsid);");
  fprintf(FP_OUTPUT,"%s\n","  #endif");
  fprintf(FP_OUTPUT,"%s\n","  if (FAILED (COM_last_HR))");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s\n","  #ifndef UNICODE");
  fprintf(FP_OUTPUT,"%s\n","    BCX_GetObjectMon ((LPCOLESTR)COM_LPWSTR_temp, obj);");
  fprintf(FP_OUTPUT,"%s\n","  #else");
  fprintf(FP_OUTPUT,"%s\n","    BCX_GetObjectMon ((LPCOLESTR)objname, obj);");
  fprintf(FP_OUTPUT,"%s\n","  #endif");
  fprintf(FP_OUTPUT,"%s\n","    return;");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","  #ifdef __cplusplus");
  fprintf(FP_OUTPUT,"%s\n","    COM_last_HR = GetActiveObject((REFCLSID)clsid, NULL, (IUnknown**)&obj->p_unknown);");
  fprintf(FP_OUTPUT,"%s\n","  #else");
  fprintf(FP_OUTPUT,"%s\n","    COM_last_HR = GetActiveObject((REFCLSID)&clsid, NULL, (IUnknown**)&obj->p_unknown);");
  fprintf(FP_OUTPUT,"%s\n","  #endif");
  fprintf(FP_OUTPUT,"%s\n","  if (FAILED (COM_last_HR))");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s%s%s\n","    COM_HR_ErrMsg (COM_last_HR,_T(",enc("GetActiveObject failed!"),"));");
  fprintf(FP_OUTPUT,"%s\n","    return;");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","  else");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s\n","    VariantInit (&obj->pObjects[0]);");
  fprintf(FP_OUTPUT,"%s\n","    #ifdef __cplusplus");
  fprintf(FP_OUTPUT,"%s\n","      COM_last_HR = obj->p_unknown");
  fprintf(FP_OUTPUT,"%s\n","     ->QueryInterface(IID_IDispatch, (void**)&obj->pObjects[0].pdispVal);");
  fprintf(FP_OUTPUT,"%s\n","    #else");
  fprintf(FP_OUTPUT,"%s\n","      COM_last_HR = obj->p_unknown->lpVtbl");
  fprintf(FP_OUTPUT,"%s\n","     ->QueryInterface(obj->p_unknown, &IID_IDispatch, (void **)&obj->pObjects[0].pdispVal);");
  fprintf(FP_OUTPUT,"%s\n","    #endif");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","  if (FAILED (COM_last_HR))");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s%s%s\n","    COM_HR_ErrMsg (COM_last_HR,_T(",enc("QueryInterface::IID_IDispatch  failed!"),"));");
  fprintf(FP_OUTPUT,"%s\n","    if (obj->p_unknown)");
  fprintf(FP_OUTPUT,"%s\n","    {");
  fprintf(FP_OUTPUT,"%s\n","    #ifdef __cplusplus");
  fprintf(FP_OUTPUT,"%s\n","      obj->p_unknown->Release();");
  fprintf(FP_OUTPUT,"%s\n","    #else");
  fprintf(FP_OUTPUT,"%s\n","      obj->p_unknown->lpVtbl->Release(obj->p_unknown);");
  fprintf(FP_OUTPUT,"%s\n","    #endif");
  fprintf(FP_OUTPUT,"%s\n","    }");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","  else");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s\n","    obj->pObjects[0].vt = VT_DISPATCH;");
  fprintf(FP_OUTPUT,"%s\n","    obj->pStatus = TRUE;");
  fprintf(FP_OUTPUT,"%s\n","    obj->ipointer = 0;");
  fprintf(FP_OUTPUT,"%s\n","    COM_objects_cnt++;");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
  fprintf(FP_OUTPUT,"%s\n","void BCX_GetObjectMon (LPCOLESTR objname, OBJECT *obj) {");
  fprintf(FP_OUTPUT,"%s\n","  IBindCtx* vBindCtx = NULL;");
  fprintf(FP_OUTPUT,"%s\n","  IMoniker* vMoniker = NULL;");
  fprintf(FP_OUTPUT,"%s\n","  ULONG vChEaten = 0;");
  fprintf(FP_OUTPUT,"%s\n","  COM_last_HR = CreateBindCtx(0, &vBindCtx);");
  fprintf(FP_OUTPUT,"%s\n","  if (COM_last_HR != S_OK)");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s%s%s\n","    COM_HR_ErrMsg (COM_last_HR,_T(",enc("GetObject: CreateBindCtx failed!"),"));");
  fprintf(FP_OUTPUT,"%s\n","    return;");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","  COM_last_HR = MkParseDisplayName(vBindCtx, objname, &vChEaten, &vMoniker);");
  fprintf(FP_OUTPUT,"%s\n","  if (COM_last_HR != S_OK)");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s%s%s\n","    COM_HR_ErrMsg (COM_last_HR,_T(",enc("GetObject: Receive Moniker failed!"),"));");
  fprintf(FP_OUTPUT,"%s\n","    goto CleanGetObjectMon;");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","  VariantInit(&obj->pObjects[0]);");
  fprintf(FP_OUTPUT,"%s\n","  #ifdef __cplusplus");
  fprintf(FP_OUTPUT,"%s\n","    COM_last_HR = vMoniker->BindToObject(vBindCtx, NULL, IID_IDispatch, ");
  fprintf(FP_OUTPUT,"%s\n","                                        (void **)&obj->pObjects[0].pdispVal);");
  fprintf(FP_OUTPUT,"%s\n","  #else");
  fprintf(FP_OUTPUT,"%s\n","    COM_last_HR = vMoniker->lpVtbl->BindToObject(vMoniker, vBindCtx, NULL, &IID_IDispatch,");
  fprintf(FP_OUTPUT,"%s\n","                                                (void **)&obj->pObjects[0].pdispVal);");
  fprintf(FP_OUTPUT,"%s\n","  #endif");
  fprintf(FP_OUTPUT,"%s\n","  if (COM_last_HR != S_OK)");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s%s%s\n","    COM_HR_ErrMsg (COM_last_HR,_T(",enc("GetObject: Moniker BindToObject failed!"),"));");
  fprintf(FP_OUTPUT,"%s\n","    goto CleanGetObjectMon;");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","  obj->p_unknown = NULL;");
  fprintf(FP_OUTPUT,"%s\n","  obj->pObjects[0].vt = VT_DISPATCH;");
  fprintf(FP_OUTPUT,"%s\n","  obj->pStatus = TRUE;");
  fprintf(FP_OUTPUT,"%s\n","  obj->ipointer = 0;");
  fprintf(FP_OUTPUT,"%s\n","  COM_objects_cnt++;");
  fprintf(FP_OUTPUT,"%s\n","CleanGetObjectMon:");
  fprintf(FP_OUTPUT,"%s\n","  #ifdef __cplusplus");
  fprintf(FP_OUTPUT,"%s\n","    if (vMoniker) vMoniker->Release();");
  fprintf(FP_OUTPUT,"%s\n","    if (vBindCtx) vBindCtx->Release();");
  fprintf(FP_OUTPUT,"%s\n","  #else");
  fprintf(FP_OUTPUT,"%s\n","    if (vMoniker) vMoniker->lpVtbl->Release (vMoniker);");
  fprintf(FP_OUTPUT,"%s\n","    if (vBindCtx) vBindCtx->lpVtbl->Release (vBindCtx);");
  fprintf(FP_OUTPUT,"%s\n","  #endif");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
}

void Emit_COM_DispatchObject (FILE* FP_OUTPUT)
{
  fprintf(FP_OUTPUT,"%s\n","void BCX_DispatchObject(IUnknown *iobj, OBJECT *obj, BOOL b_release) {");
  fprintf(FP_OUTPUT,"%s\n","  if (!obj) return;");
  fprintf(FP_OUTPUT,"%s\n","  static ULONG inc_inf_ussage=0;");
  fprintf(FP_OUTPUT,"%s\n","  if (!COM_ole_initd) COM_ole_initialize();");
  fprintf(FP_OUTPUT,"%s\n","  obj->p_unknown = iobj;");
  fprintf(FP_OUTPUT,"%s\n","  #ifdef __cplusplus");
  fprintf(FP_OUTPUT,"%s\n","    inc_inf_ussage = obj->p_unknown->AddRef();");
  fprintf(FP_OUTPUT,"%s\n","  #else");
  fprintf(FP_OUTPUT,"%s\n","    inc_inf_ussage = obj->p_unknown->lpVtbl->AddRef(obj->p_unknown);");
  fprintf(FP_OUTPUT,"%s\n","  #endif");
  fprintf(FP_OUTPUT,"%s\n","  VariantInit(&obj->pObjects[0]);");
  fprintf(FP_OUTPUT,"%s\n","  #ifdef __cplusplus");
  fprintf(FP_OUTPUT,"%s\n","    COM_last_HR = obj->p_unknown");
  fprintf(FP_OUTPUT,"%s\n","   ->QueryInterface(IID_IDispatch, (void**)&obj->pObjects[0].pdispVal);");
  fprintf(FP_OUTPUT,"%s\n","  #else");
  fprintf(FP_OUTPUT,"%s\n","    COM_last_HR = obj->p_unknown->lpVtbl");
  fprintf(FP_OUTPUT,"%s\n","   ->QueryInterface(obj->p_unknown, &IID_IDispatch,");
  fprintf(FP_OUTPUT,"%s\n","     (void**)&obj->pObjects[0].pdispVal);");
  fprintf(FP_OUTPUT,"%s\n","  #endif");
  fprintf(FP_OUTPUT,"%s\n","  if (FAILED (COM_last_HR))");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s%s%s\n","    COM_HR_ErrMsg (COM_last_HR,_T(",enc("QueryInterface::IID_IDispatch  failed!"),"));");
  fprintf(FP_OUTPUT,"%s\n","  #ifdef __cplusplus");
  fprintf(FP_OUTPUT,"%s\n","      obj->p_unknown->Release();");
  fprintf(FP_OUTPUT,"%s\n","  #else");
  fprintf(FP_OUTPUT,"%s\n","      obj->p_unknown->lpVtbl->Release(obj->p_unknown);");
  fprintf(FP_OUTPUT,"%s\n","  #endif");
  fprintf(FP_OUTPUT,"%s\n","    return;");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","  if (b_release)");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s\n","  #ifdef __cplusplus");
  fprintf(FP_OUTPUT,"%s\n","     iobj->Release();");
  fprintf(FP_OUTPUT,"%s\n","  #else");
  fprintf(FP_OUTPUT,"%s\n","     iobj->lpVtbl->Release(obj->p_unknown);");
  fprintf(FP_OUTPUT,"%s\n","  #endif");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","  obj->pObjects[0].vt = VT_DISPATCH;");
  fprintf(FP_OUTPUT,"%s\n","  obj->pStatus = TRUE;");
  fprintf(FP_OUTPUT,"%s\n","  obj->ipointer = 0;");
  fprintf(FP_OUTPUT,"%s\n","  COM_objects_cnt++;");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
}

void Emit_COM_GetProperty (FILE* FP_OUTPUT)
{
  UNREFERENCED_PARAMETER(FP_OUTPUT);
}

void Emit_COM_SetProperty (FILE* FP_OUTPUT)
{
  UNREFERENCED_PARAMETER(FP_OUTPUT);
}

void Emit_COM_InvokeMethod (FILE* FP_OUTPUT)
{
  UNREFERENCED_PARAMETER(FP_OUTPUT);
}

void Emit_COM_SafeArray (FILE* FP_OUTPUT)
{
  fprintf(FP_OUTPUT,"%s\n","void COM_create_safearray(void) {");
  fprintf(FP_OUTPUT,"%s\n","  long lv_param_incr = 0;");
  fprintf(FP_OUTPUT,"%s\n","  long lv_param_incr_rev = 0;");
  fprintf(FP_OUTPUT,"%s\n","  HRESULT hr = NO_ERROR;");
  fprintf(FP_OUTPUT,"%s\n","  COM_PTR_safearray = ");
  fprintf(FP_OUTPUT,"%s\n","  SafeArrayCreateVector (VT_VARIANT,0,COM_plist_index);");
  fprintf(FP_OUTPUT,"%s\n","  if (COM_PTR_safearray == NULL)");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s\n","    COM_clean_plist();");
  fprintf(FP_OUTPUT,"%s\n","    COM_last_HR = E_OUTOFMEMORY;");
  fprintf(FP_OUTPUT,"%s%s%s\n","    COM_HR_ErrMsg (COM_last_HR,_T(",enc("SafeArrayCreate failed."),"));");
  fprintf(FP_OUTPUT,"%s\n","    return;");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","  for (lv_param_incr = COM_plist_index-1; lv_param_incr>=0; lv_param_incr-=1)");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s\n","    hr = SafeArrayPutElement (COM_PTR_safearray,");
  fprintf(FP_OUTPUT,"%s\n","    &lv_param_incr, &COM_PARAMS[lv_param_incr_rev]);");
  fprintf(FP_OUTPUT,"%s\n","    if (FAILED(hr))");
  fprintf(FP_OUTPUT,"%s\n","    {");
  fprintf(FP_OUTPUT,"%s%s%s\n","      wsprintf(COM_ErrMsg, _T(",enc("Param Index = %d."),"),lv_param_incr);");
  fprintf(FP_OUTPUT,"%s\n","      if (COM_PTR_safearray) SafeArrayDestroy (COM_PTR_safearray);");
  fprintf(FP_OUTPUT,"%s\n","      COM_PTR_safearray = NULL;");
  fprintf(FP_OUTPUT,"%s\n","      COM_clean_plist();");
  fprintf(FP_OUTPUT,"%s\n","      COM_last_HR = hr;");
  fprintf(FP_OUTPUT,"%s%s%s\n","      COM_HR_ErrMsg (COM_last_HR,_T(",enc("SafeArrayPutElement failed!"),"));");
  fprintf(FP_OUTPUT,"%s\n","      return;");
  fprintf(FP_OUTPUT,"%s\n","    }");
  fprintf(FP_OUTPUT,"%s\n","    lv_param_incr_rev++;");
  fprintf(FP_OUTPUT,"%s\n","  }");
  if(COM_build_trace_code ){
      fprintf(FP_OUTPUT,"%s%s%s\n","  COM_add_trace_line(",enc("SafeArray created. Cleaning temp variants..."),");");
    }
  fprintf(FP_OUTPUT,"%s\n","  COM_clean_plist();");
  fprintf(FP_OUTPUT,"%s\n","  if(COM_PTR_safearray)");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s\n","     VariantInit (&COM_PARAMS[0]);");
  fprintf(FP_OUTPUT,"%s\n","     COM_PARAMS[0].vt = VT_ARRAY|VT_VARIANT;");
  fprintf(FP_OUTPUT,"%s\n","     V_ARRAY (&COM_PARAMS[0]) = COM_PTR_safearray;");
  fprintf(FP_OUTPUT,"%s\n","     COM_plist_index = 1;");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
}

void Emit_COM_UsesConversion (FILE* FP_OUTPUT)
{
  fprintf(FP_OUTPUT,"%s\n","HRESULT COM_WS2AS(LPCWSTR wide_string, UINT code_page) {");
  fprintf(FP_OUTPUT,"%s\n","  if (wide_string==NULL) return (HRESULT) NO_ERROR;");
  fprintf(FP_OUTPUT,"%s\n","  ULONG bytes_copied=0;");
  fprintf(FP_OUTPUT,"%s\n","  ULONG temp_ansi_len = (ULONG)WideCharToMultiByte (");
  fprintf(FP_OUTPUT,"%s\n","  code_page,0,wide_string,-1,COM_psz_tmp,0,NULL,NULL);");
  fprintf(FP_OUTPUT,"%s\n","  if (temp_ansi_len == 0) return (HRESULT) NO_ERROR;");
  fprintf(FP_OUTPUT,"%s\n","  if (COM_zstr_size < temp_ansi_len)");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s\n","    if (COM_psz_tmp) free(COM_psz_tmp);");
  fprintf(FP_OUTPUT,"%s\n","    COM_psz_tmp = (char*)calloc(temp_ansi_len+1,sizeof(char));");
  fprintf(FP_OUTPUT,"%s\n","    if (NULL == COM_psz_tmp)");
  fprintf(FP_OUTPUT,"%s\n","    {");
  fprintf(FP_OUTPUT,"%s\n","      COM_zstr_size = 0;");
  fprintf(FP_OUTPUT,"%s\n","      return E_OUTOFMEMORY;");
  fprintf(FP_OUTPUT,"%s\n","    } ");
  fprintf(FP_OUTPUT,"%s\n","    COM_zstr_size = temp_ansi_len;");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","  if ((bytes_copied = WideCharToMultiByte(code_page, 0, wide_string, -1,");
  fprintf(FP_OUTPUT,"%s\n","       COM_psz_tmp, temp_ansi_len,NULL, NULL))==0)");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s\n","    return HRESULT_FROM_WIN32 (GetLastError());");
  fprintf(FP_OUTPUT,"%s\n","  } ");
  fprintf(FP_OUTPUT,"%s\n","  COM_psz_tmp [bytes_copied] = '\\0';");
  fprintf(FP_OUTPUT,"%s\n","  return (HRESULT)NO_ERROR;");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
  fprintf(FP_OUTPUT,"%s\n","HRESULT COM_AS2WS(LPCSTR ansi_string, UINT code_page) {");
  fprintf(FP_OUTPUT,"%s\n","  if (!*ansi_string) return (HRESULT)NO_ERROR;");
  fprintf(FP_OUTPUT,"%s\n","  ULONG ansi_str_len = (ULONG)strlen (ansi_string);");
  fprintf(FP_OUTPUT,"%s\n","  if (!ansi_str_len) return (HRESULT)NO_ERROR;");
  fprintf(FP_OUTPUT,"%s\n","  ULONG wide_str_len = (ansi_str_len * 2);");
  fprintf(FP_OUTPUT,"%s\n","  if (COM_wstr_size < wide_str_len)");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s\n","    if (COM_LPWSTR_temp)");
  fprintf(FP_OUTPUT,"%s\n","       CoTaskMemFree((void*)COM_LPWSTR_temp);");
  fprintf(FP_OUTPUT,"%s\n","    COM_LPWSTR_temp = (PWSTR)CoTaskMemAlloc (wide_str_len);");
  fprintf(FP_OUTPUT,"%s\n","    if (NULL == COM_LPWSTR_temp)");
  fprintf(FP_OUTPUT,"%s\n","    {");
  fprintf(FP_OUTPUT,"%s\n","      COM_wstr_size = 0;");
  fprintf(FP_OUTPUT,"%s\n","      return E_OUTOFMEMORY;");
  fprintf(FP_OUTPUT,"%s\n","    } ");
  fprintf(FP_OUTPUT,"%s\n","    COM_wstr_size = wide_str_len;");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","  if (MultiByteToWideChar (code_page, MB_PRECOMPOSED, ansi_string, ");
  fprintf(FP_OUTPUT,"%s\n","      ansi_str_len, COM_LPWSTR_temp, wide_str_len)==0)");
  fprintf(FP_OUTPUT,"%s\n","         return HRESULT_FROM_WIN32(GetLastError());");
  fprintf(FP_OUTPUT,"%s\n","  COM_LPWSTR_temp[ansi_str_len] = L'\\0';");
  fprintf(FP_OUTPUT,"%s\n","  return (HRESULT)NO_ERROR;");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
  fprintf(FP_OUTPUT,"%s\n","void COM_FREE_TEMP_WIDE_STRING(void) {");
  fprintf(FP_OUTPUT,"%s\n","  if (COM_LPWSTR_temp)");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s\n","    CoTaskMemFree ((void*)COM_LPWSTR_temp);");
  fprintf(FP_OUTPUT,"%s\n","    COM_LPWSTR_temp = NULL;");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
  fprintf(FP_OUTPUT,"%s\n","void COM_FREE_TEMP_ANSI_STRING (void) {");
  fprintf(FP_OUTPUT,"%s\n","  if (COM_psz_tmp)");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s\n","    free (COM_psz_tmp);");
  fprintf(FP_OUTPUT,"%s\n","    COM_psz_tmp = NULL;");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","}");
}

void Emit_COM_TraceCalls (FILE* FP_OUTPUT)
{
  fprintf(FP_OUTPUT,"%s\n","void bcx_com_trace_dump_DISPPARAMS(DISPPARAMS* dp) {");
  fprintf(FP_OUTPUT,"%s%s%s\n","  COM_add_trace_line(",enc("   --- BEGIN DUMP OF DISPPARAMS  ---"),");");
  fprintf(FP_OUTPUT,"%s\n","  if (!dp)");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s%s%s\n","    COM_add_trace_line(",enc("*** bcx_com_trace_dump_DISPPARAMS failed!"),");");
  fprintf(FP_OUTPUT,"%s%s%s\n","    COM_add_trace_line(",enc("*** NULL argument received for DISPPARAMS* dp"),");");
  fprintf(FP_OUTPUT,"%s%s%s\n","    COM_add_trace_line(",enc("   --- END DUMP OF DISPPARAMS ---"),");");
  fprintf(FP_OUTPUT,"%s\n","    return;");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s%s%s\n","  wsprintf(COM_trace_line, ",enc("     DISPPARAMS.rgvarg = %lu  // pointer to array of arguments."),", dp->rgvarg);");
  fprintf(FP_OUTPUT,"%s\n","  COM_add_trace_line(COM_trace_line);");
  fprintf(FP_OUTPUT,"%s%s%s\n","  wsprintf(COM_trace_line, ",enc("     DISPPARAMS.rgdispidNamedArgs = %lu // pointer to array of Dispatch IDs of named arguments."),", dp->rgdispidNamedArgs);");
  fprintf(FP_OUTPUT,"%s\n","  COM_add_trace_line(COM_trace_line);");
  fprintf(FP_OUTPUT,"%s%s%s\n","  wsprintf(COM_trace_line, ",enc("     DISPPARAMS.cArgs = %d // Number of arguments."),", dp->cArgs);");
  fprintf(FP_OUTPUT,"%s\n","  COM_add_trace_line(COM_trace_line);");
  fprintf(FP_OUTPUT,"%s%s%s\n","  wsprintf(COM_trace_line, ",enc("     DISPPARAMS.cNamedArgs = %d  // Number of named arguments"),", dp->cNamedArgs);");
  fprintf(FP_OUTPUT,"%s\n","  COM_add_trace_line(COM_trace_line);");
  fprintf(FP_OUTPUT,"%s%s%s\n","  COM_add_trace_line(",enc("   --- END DUMP OF DISPPARAMS ---"),");");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
  fprintf(FP_OUTPUT,"%s\n","void bcx_com_trace_dump_indicators(OBJECT *object) {");
  fprintf(FP_OUTPUT,"%s%s%s\n","  COM_add_trace_line(",enc("*** start dump of global vars ***"),");");
  fprintf(FP_OUTPUT,"%s\n","  if (object->pStatus)");
  fprintf(FP_OUTPUT,"%s%s%s\n","     strcpy(COM_trace_line, ",enc("   Object status - Initialized"),");");
  fprintf(FP_OUTPUT,"%s\n","  else");
  fprintf(FP_OUTPUT,"%s%s%s\n","     strcpy(COM_trace_line, ",enc("   Object status - UnInitialized"),");");
  fprintf(FP_OUTPUT,"%s\n","  COM_add_trace_line(COM_trace_line);");
  fprintf(FP_OUTPUT,"%s%s%s\n","  wsprintf(COM_trace_line, ",enc("   dispatch chain index = %d"),", object->ipointer);");
  fprintf(FP_OUTPUT,"%s\n","  COM_add_trace_line(COM_trace_line);");
  fprintf(FP_OUTPUT,"%s%s%s\n","  wsprintf(COM_trace_line, ",enc("   Count of params = %d"),", COM_plist_index);");
  fprintf(FP_OUTPUT,"%s\n","  COM_add_trace_line(COM_trace_line);");
  fprintf(FP_OUTPUT,"%s%s%s\n","  wsprintf(COM_trace_line, ",enc("   COM_ole_initd = %d"),", COM_ole_initd);");
  fprintf(FP_OUTPUT,"%s\n","  COM_add_trace_line(COM_trace_line);");
  fprintf(FP_OUTPUT,"%s%s%s\n","  wsprintf(COM_trace_line, ",enc("   COM_objects_cnt = %d"),", COM_objects_cnt);");
  fprintf(FP_OUTPUT,"%s\n","  COM_add_trace_line(COM_trace_line);");
  fprintf(FP_OUTPUT,"%s%s%s\n","  wsprintf(COM_trace_line, ",enc("   don't reset dispatch chain afer invoke = %d"),", COM_reset_chain);");
  fprintf(FP_OUTPUT,"%s\n","  COM_add_trace_line(COM_trace_line);");
  fprintf(FP_OUTPUT,"%s%s%s\n","  COM_add_trace_line(",enc("*** end dump of global vars ***"),");");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
  fprintf(FP_OUTPUT,"%s\n","void bcx_com_trace_dump_flags(WORD wFlags) {");
  fprintf(FP_OUTPUT,"%s%s%s\n","  wsprintf(COM_trace_line, ",enc("calling invoke with flags: "),");");
  fprintf(FP_OUTPUT,"%s%s%s\n","  if(wFlags & DISPATCH_PROPERTYPUT) strcat(COM_trace_line,",enc("| DISPATCH_PROPERTYPUT "),");");
  fprintf(FP_OUTPUT,"%s%s%s\n","  if(wFlags & DISPATCH_PROPERTYGET) strcat(COM_trace_line,",enc("| DISPATCH_PROPERTYGET "),");");
  fprintf(FP_OUTPUT,"%s%s%s\n","  if(wFlags & DISPATCH_PROPERTYPUTREF) strcat(COM_trace_line,",enc("| DISPATCH_PROPERTYPUTREF "),");");
  fprintf(FP_OUTPUT,"%s%s%s\n","  if(wFlags & DISPATCH_METHOD) strcat(COM_trace_line,",enc("| DISPATCH_METHOD "),");");
  fprintf(FP_OUTPUT,"%s\n","  COM_add_trace_line(COM_trace_line);");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
  fprintf(FP_OUTPUT,"%s\n","void COM_add_trace_line(LPCTSTR trcline) {");
  fprintf(FP_OUTPUT,"%s\n","  static FILE *com_trc_file;");
  fprintf(FP_OUTPUT,"%s%s%s%s%s\n","  if((com_trc_file=fopen(",enc("c:\\com_trace.txt"),",",enc("a"),"))==0)");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s%s%s\n","    fprintf(stderr,",enc("Error: File access or File not found. c:\\com_trace.txt\\n"),");");
  fprintf(FP_OUTPUT,"%s\n","    exit(1);");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s%s%s\n","  fprintf(com_trc_file,",enc("%s\\n"),", trcline);");
  fprintf(FP_OUTPUT,"%s\n","  if (com_trc_file)");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s\n","    fflush(com_trc_file);");
  fprintf(FP_OUTPUT,"%s\n","    fclose(com_trc_file);");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
}

void Emit_BCX_SafeArray (FILE* FP_OUTPUT)
{
  fprintf(FP_OUTPUT,"%s\n","HRESULT InitSafeArray (SAFEARRAY **ppsa, VARTYPE vtype, UINT ndim, ...) {");
  fprintf(FP_OUTPUT,"%s\n","  int iCNT;");
  fprintf(FP_OUTPUT,"%s\n","  int iDIM;");
  fprintf(FP_OUTPUT,"%s\n","  va_list  marker;");
  fprintf(FP_OUTPUT,"%s\n","  SAFEARRAYBOUND  tArraySize[10];");
  fprintf(FP_OUTPUT,"%s\n","  va_start(marker,ndim);");
  fprintf(FP_OUTPUT,"%s\n","  iCNT = 0;");
  fprintf(FP_OUTPUT,"%s\n","  iDIM = ndim;");
  fprintf(FP_OUTPUT,"%s\n","  while(iDIM--)");
  fprintf(FP_OUTPUT,"%s\n","    {");
  fprintf(FP_OUTPUT,"%s\n","      tArraySize[iCNT].lLbound = va_arg(marker,long);");
  fprintf(FP_OUTPUT,"%s\n","      tArraySize[iCNT].cElements = va_arg(marker,long);");
  fprintf(FP_OUTPUT,"%s\n","      iCNT++;");
  fprintf(FP_OUTPUT,"%s\n","    }");
  fprintf(FP_OUTPUT,"%s\n","  *ppsa = SafeArrayCreate (vtype,ndim,tArraySize);");
  fprintf(FP_OUTPUT,"%s\n","  if(*ppsa == NULL)");
  fprintf(FP_OUTPUT,"%s\n","      return E_OUTOFMEMORY;");
  fprintf(FP_OUTPUT,"%s\n","  return S_OK;");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
  fprintf(FP_OUTPUT,"%s\n","HRESULT DestroySafeArray(SAFEARRAY *psA) {");
  fprintf(FP_OUTPUT,"%s\n","  return SafeArrayDestroy(psA);");
  fprintf(FP_OUTPUT,"%s\n","}\n");
}

void Emit_COM_CreateObject (FILE* FP_OUTPUT)
{
  fprintf(FP_OUTPUT,"%s\n","void BCX_CreateObject (_TCHAR *objname, OBJECT *obj) {");
  fprintf(FP_OUTPUT,"%s\n","  if (!COM_ole_initd) COM_ole_initialize();");
  fprintf(FP_OUTPUT,"%s\n","  CLSID clsid;");
  fprintf(FP_OUTPUT,"%s\n","  #ifndef UNICODE");
  fprintf(FP_OUTPUT,"%s\n","    COM_last_HR = COM_AS2WS(objname);");
  fprintf(FP_OUTPUT,"%s\n","    if (FAILED(COM_last_HR))");
  fprintf(FP_OUTPUT,"%s\n","    {");
  fprintf(FP_OUTPUT,"%s%s%s\n","      COM_HR_ErrMsg (COM_last_HR,_T(",enc("CreateObject Failed! A2W failure!"),"));");
  fprintf(FP_OUTPUT,"%s\n","      return;");
  fprintf(FP_OUTPUT,"%s\n","    }");
  fprintf(FP_OUTPUT,"%s\n","    COM_last_HR = COM_WS2AS(COM_LPWSTR_temp);");
  fprintf(FP_OUTPUT,"%s\n","    if (FAILED (COM_last_HR))");
  fprintf(FP_OUTPUT,"%s\n","    {");
  fprintf(FP_OUTPUT,"%s%s%s\n","       COM_HR_ErrMsg (COM_last_HR,_T(",enc("CreateObject Failed! W2A failure!"),"));");
  fprintf(FP_OUTPUT,"%s\n","      return;");
  fprintf(FP_OUTPUT,"%s\n","    }");
  fprintf(FP_OUTPUT,"%s%s%s\n","    sprintf(COM_ErrMsg,",enc("%s, WideName(%s)"),", objname, COM_psz_tmp);");
  fprintf(FP_OUTPUT,"%s\n","    COM_last_HR = CLSIDFromProgID ((LPCOLESTR)COM_LPWSTR_temp, (LPCLSID)&clsid);");
  fprintf(FP_OUTPUT,"%s\n","  #else");
  fprintf(FP_OUTPUT,"%s\n","    lstrcpy(COM_ErrMsg, objname);");
  fprintf(FP_OUTPUT,"%s\n","    COM_last_HR = CLSIDFromProgID ((LPCOLESTR)objname, (LPCLSID)&clsid);");
  fprintf(FP_OUTPUT,"%s\n","  #endif");
  fprintf(FP_OUTPUT,"%s\n","  if (FAILED (COM_last_HR))");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s%s%s\n","    COM_HR_ErrMsg (COM_last_HR,_T(",enc("CLSIDFromProgID failed!"),"));");
  fprintf(FP_OUTPUT,"%s\n","    return;");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","  #ifdef __cplusplus");
  fprintf(FP_OUTPUT,"%s\n","    COM_last_HR = CoCreateInstance((REFCLSID)clsid, NULL,  ");
  fprintf(FP_OUTPUT,"%s\n","    CLSCTX_INPROC_SERVER|CLSCTX_LOCAL_SERVER, IID_IUnknown, (void **)&obj->p_unknown);");
  fprintf(FP_OUTPUT,"%s\n","  #else");
  fprintf(FP_OUTPUT,"%s\n","    COM_last_HR = CoCreateInstance ((REFCLSID)&clsid, NULL, ");
  fprintf(FP_OUTPUT,"%s\n","    CLSCTX_INPROC_SERVER|CLSCTX_LOCAL_SERVER,&IID_IUnknown, (void **)&obj->p_unknown);");
  fprintf(FP_OUTPUT,"%s\n","  #endif");
  fprintf(FP_OUTPUT,"%s\n","  if (FAILED (COM_last_HR))");
  fprintf(FP_OUTPUT,"%s%s%s\n","     COM_HR_ErrMsg (COM_last_HR,_T(",enc("CoCreateInstance failed!"),"));");
  fprintf(FP_OUTPUT,"%s\n","  else");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s\n","    VariantInit(&obj->pObjects[0]);");
  fprintf(FP_OUTPUT,"%s\n","    obj->pObjects[0].vt = VT_DISPATCH;");
  fprintf(FP_OUTPUT,"%s\n","  #ifdef __cplusplus");
  fprintf(FP_OUTPUT,"%s\n","    COM_last_HR = obj->p_unknown");
  fprintf(FP_OUTPUT,"%s\n","   ->QueryInterface(IID_IDispatch, (void **)&obj->pObjects[0].pdispVal);");
  fprintf(FP_OUTPUT,"%s\n","  #else");
  fprintf(FP_OUTPUT,"%s\n","    COM_last_HR = obj->p_unknown->lpVtbl");
  fprintf(FP_OUTPUT,"%s\n","   ->QueryInterface(obj->p_unknown, &IID_IDispatch, (void**)&obj->pObjects[0].pdispVal);");
  fprintf(FP_OUTPUT,"%s\n","  #endif");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","  if (FAILED(COM_last_HR))");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s%s%s\n","    COM_HR_ErrMsg (COM_last_HR,_T(",enc("QueryInterface::IID_IDispatch  failed!"),"));");
  fprintf(FP_OUTPUT,"%s\n","    obj->pObjects[0].vt = VT_NULL;");
  fprintf(FP_OUTPUT,"%s\n","    VariantClear(&obj->pObjects[0]);");
  fprintf(FP_OUTPUT,"%s\n","    #ifdef __cplusplus");
  fprintf(FP_OUTPUT,"%s\n","       obj->p_unknown->Release();");
  fprintf(FP_OUTPUT,"%s\n","    #else");
  fprintf(FP_OUTPUT,"%s\n","       obj->p_unknown->lpVtbl->Release(obj->p_unknown);");
  fprintf(FP_OUTPUT,"%s\n","    #endif");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","  else");
  fprintf(FP_OUTPUT,"%s\n","  {");
  fprintf(FP_OUTPUT,"%s\n","    obj->pStatus = TRUE;");
  fprintf(FP_OUTPUT,"%s\n","    obj->ipointer = 0;");
  fprintf(FP_OUTPUT,"%s\n","    COM_objects_cnt++;");
  fprintf(FP_OUTPUT,"%s\n","  }");
  fprintf(FP_OUTPUT,"%s\n","}\n\n");
}

void Emit_VBScript_Support ()
{
  static int nTimes=0;
  if(nTimes>0 ){
      return;
    }
  nTimes++;
  Use_AnsiToWide=Use_WideToAnsi=TRUE;
  fprintf(FP_HDR,"%s\n","");
  fprintf(FP_HDR,"%s\n","// ****************************************");
  fprintf(FP_HDR,"%s%s%s\n","// ***** ",BCX_STR_VBS_STRUCTS,"  *****");
  fprintf(FP_HDR,"%s\n","// ****************************************");
  fprintf(FP_HDR,"%s\n","");
  fprintf(FP_HDR,"%s\n","const GUID IID_IScriptControl =");
  fprintf(FP_HDR,"%s\n","{");
  fprintf(FP_HDR,"%s\n","   0x0e59f1d3,0x1fbe,0x11d0,");
  fprintf(FP_HDR,"%s\n","  {0x8f,0xf2,0x00,0xa0,0xd1,0x00,0x38,0xbc}");
  fprintf(FP_HDR,"%s\n","};");
  fprintf(FP_HDR,"%s\n","");
  fprintf(FP_HDR,"%s\n","enum ScriptControlStates");
  fprintf(FP_HDR,"%s\n","{");
  fprintf(FP_HDR,"%s\n","  SCRIPTSTATE_UNINITIALIZED0, SCRIPTSTATE_STARTED1, SCRIPTSTATE_CONNECTED2,");
  fprintf(FP_HDR,"%s\n","  SCRIPTSTATE_DISCONNECTED3, SCRIPTSTATE_CLOSED4, SCRIPTSTATE_INITIALIZED5");
  fprintf(FP_HDR,"%s\n","};");
  fprintf(FP_HDR,"%s\n","");
  fprintf(FP_HDR,"%s\n","const GUID IID_IScriptError =");
  fprintf(FP_HDR,"%s\n","{");
  fprintf(FP_HDR,"%s\n","   0x70841C78, 0x67D, 0x11D0,");
  fprintf(FP_HDR,"%s\n","  {0x95, 0xD8, 0x0, 0xA0, 0x24, 0x63, 0xAB, 0x28}");
  fprintf(FP_HDR,"%s\n","};");
  fprintf(FP_HDR,"%s\n","");
  fprintf(FP_HDR,"%s\n","// *******************************************************************");
  fprintf(FP_HDR,"%s\n","#undef  INTERFACE");
  fprintf(FP_HDR,"%s\n","#define INTERFACE IScriptError");
  fprintf(FP_HDR,"%s\n","// *******************************************************************");
  fprintf(FP_HDR,"%s\n","DECLARE_INTERFACE_(IScriptError, IDispatch) {");
  fprintf(FP_HDR,"%s\n","STDMETHOD (QueryInterface)(THIS_ REFIID riid, PVOID *ppvObj) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD_(ULONG, AddRef)(THIS)  PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD_(ULONG, Release)(THIS) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (GetTypeInfoCount)(THIS_ UINT *pctinfo) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (GetTypeInfo)(THIS_ UINT itinfo, LCID lcid,");
  fprintf(FP_HDR,"%s\n","ITypeInfo **pptinfo) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (GetIDsOfNames)(THIS_ REFIID riid, OLECHAR **rgszNames,");
  fprintf(FP_HDR,"%s\n","           UINT cNames, LCID lcid, DISPID *rgdispid) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (Invoke)(THIS_ DISPID dispidMember, REFIID riid, LCID lcid,");
  fprintf(FP_HDR,"%s\n","           WORD wFlags, DISPPARAMS *pdispparams, VARIANT *pvarResult,");
  fprintf(FP_HDR,"%s\n","           EXCEPINFO *pexcepinfo, UINT *puArgErr) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (Get_Number)(THIS_ long *pNumber) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (Get_Source)(THIS_ BSTR *pbstrSource) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (Get_Description)(THIS_ BSTR *pbstrDescription) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (Get_HelpFile)(THIS_ BSTR *pbstrHelpFile) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (Get_HelpContext)(THIS_ long *pHelpContext) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (Get_Text)(THIS_ BSTR *pbstrText) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (Get_Line)(THIS_ long *pLine) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (Get_Column)(THIS_ long *pColumn) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (Clear)(THIS) PURE;};");
  fprintf(FP_HDR,"%s\n","");
  fprintf(FP_HDR,"%s\n","// *******************************************************************");
  fprintf(FP_HDR,"%s\n","#undef  INTERFACE");
  fprintf(FP_HDR,"%s\n","#define INTERFACE IScriptControl");
  fprintf(FP_HDR,"%s\n","// *******************************************************************");
  fprintf(FP_HDR,"%s\n","DECLARE_INTERFACE_(IScriptControl, IDispatch) {");
  fprintf(FP_HDR,"%s\n","STDMETHOD (QueryInterface)(THIS_ REFIID riid, PVOID *ppvObj) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD_(ULONG, AddRef)(THIS)  PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD_(ULONG, Release)(THIS) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (GetTypeInfoCount)(THIS_ UINT *pctinfo) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (GetTypeInfo)(THIS_ UINT itinfo, LCID lcid,");
  fprintf(FP_HDR,"%s\n","ITypeInfo  **pptinfo) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (GetIDsOfNames)(THIS_ REFIID riid, OLECHAR **rgszNames,");
  fprintf(FP_HDR,"%s\n","           UINT cNames, LCID lcid, DISPID *rgdispid) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (Invoke)(THIS_ DISPID dispidMember, REFIID riid, LCID lcid,");
  fprintf(FP_HDR,"%s\n","           WORD wFlags, DISPPARAMS *pdispparams, VARIANT *pvarResult,");
  fprintf(FP_HDR,"%s\n","           EXCEPINFO *pexcepinfo, UINT *puArgErr) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (get_Language)(THIS_ BSTR* pbstrLanguage) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (put_Language)(THIS_ BSTR pbstrLanguage) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (get_State)(THIS_ enum ScriptControlStates* pssState) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (put_State)(THIS_ enum ScriptControlStates pssState) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (put_SitehWnd)(THIS_ long phwnd) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (get_SitehWnd)(THIS_ long* phwnd) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (get_Timeout)(THIS_ long* plMilliseconds) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (put_Timeout)(THIS_ long plMilliseconds) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (get_AllowUI)(THIS_ VARIANT_BOOL* pfAllowUI) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (put_AllowUI)(THIS_ VARIANT_BOOL pfAllowUI) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (get_UseSafeSubset)(THIS_ VARIANT_BOOL* pfUseSafeSubset) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (put_UseSafeSubset)(THIS_ VARIANT_BOOL pfUseSafeSubset) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (get_Modules)(THIS_ interface");
  fprintf(FP_HDR,"%s\n","           IScriptModuleCollection** ppmods) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (get_Error)(THIS_ interface IScriptError** ppse) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (get_CodeObject)(THIS_ IDispatch** ppdispObject) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (get_Procedures)(THIS_ interface");
  fprintf(FP_HDR,"%s\n","           IScriptProcedureCollection** ppdispProcedures) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (_AboutBox)(THIS) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (AddObject)(THIS_ BSTR Name, IDispatch* Object,");
  fprintf(FP_HDR,"%s\n","           VARIANT_BOOL AddMembers) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (Reset)(THIS) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (AddCode)(THIS_ BSTR Code) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (Eval)(THIS_ BSTR Expression, VARIANT* pvarResult) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (ExecuteStatement)(THIS_ BSTR Statement) PURE;");
  fprintf(FP_HDR,"%s\n","STDMETHOD (Run)(THIS_ BSTR ProcedureName, SAFEARRAY** Parameters,");
  fprintf(FP_HDR,"%s\n","           VARIANT* pvarResult) PURE;};");
  fprintf(FP_HDR,"%s\n","");
  if(Use_Project ){
      fprintf(FP_HDR,"%s\n","BOOL OLE_ERROR_S;");
      fprintf(FP_HDR,"%s\n","IScriptControl *pSC;");
    }
  else
    {
      fprintf(FP_HDR,"%s\n","static BOOL OLE_ERROR_S;");
      fprintf(FP_HDR,"%s\n","static IScriptControl *pSC;");
    }
  AddLibrary("ole32.lib");
  AddLibrary("oleaut32.lib");
}

void Add_COM_Global_Variable (char* p_name)
{
  if((int)strlen(p_name)>64 ){
      Abort(join(5,"Length of object variable ",p_name," is:",str((int)strlen(p_name)),". Maximum allowed is 64 characters."));
    }
  if(COM_gl_names_index==COM_Max_Gl_Objs ){
      Abort(join(5,"Max number of Global COM object variables reached:",str(COM_Max_Gl_Objs),CRLF,"Failed to reserve space for Object variable: ",p_name));
      return;
    }
  strcpy(COM_gl_names[COM_gl_names_free_index].com_VarName,p_name);
  COM_gl_names[COM_gl_names_free_index].initialized=TRUE;
  COM_gl_names_index++;
  COM_gl_names_free_index=COM_gl_names_index;
}

void Add_COM_Local_Variable (char* p_name)
{
  if((int)strlen(p_name)>64 ){
      Abort(join(5,"Length of object variable ",p_name," is:",str((int)strlen(p_name)),". Maximum allowed is 64 characters."));
    }
  if(COM_lc_names_index==COM_Max_Lc_Objs ){
      Abort(join(5,"Max number of Local COM object variables reached:",str(COM_Max_Lc_Objs),CRLF,"Failed to reserve space for Object variable: ",p_name));
      return;
    }
  strcpy(COM_lc_names[COM_lc_names_free_index].com_VarName,p_name);
  COM_lc_names[COM_lc_names_free_index].initialized=TRUE;
  COM_lc_names_index++;
  COM_lc_names_free_index=COM_lc_names_index;
}

int IsVariableComObject (char* p_varname)
{
  char sz_var_name[BCXSTRSIZE];
  int  l_index;
  strcpy(sz_var_name,trim(p_varname));
  if(COM_lc_names_index>0 ){
      for(l_index=0; l_index<=COM_lc_names_index-1; l_index++)
        {
          if(COM_lc_names[l_index].initialized==TRUE ){
              if(strcmp(sz_var_name,COM_lc_names[l_index].com_VarName)==0){
                  return l_index+1;
                }
            }
        }
    }
  if(COM_gl_names_index>0 ){
      for(l_index=0; l_index<=COM_gl_names_index-1; l_index++)
        {
          if(COM_gl_names[l_index].initialized==TRUE ){
              if(strcmp(sz_var_name,COM_gl_names[l_index].com_VarName)==0){
                  return (-1*(l_index+1));
                }
            }
        }
    }
  return 0;
}

void BCX_FreeLocalCOMObjects (BOOL p_remove)
{
  int  j={0};
  int eraseOffset={0};
  for(;;)
    {
      if(COM_lc_names[j].initialized==TRUE ){
        }
      else
        {
          eraseOffset++;
        }
      j++;
      if(!(j<(COM_lc_names_index+eraseOffset))){
          goto L1563;
        }
    }
L1563:;
  if(p_remove==TRUE ){
      COM_lc_names_index=0;
      COM_lc_names_free_index=0;
    }
}

BOOL Find_COM_statement (char* pp_Src)
{
  int FOUND_OBJECT={0};
  int FOUND_DOT={0};
  int FOUND_EQU={0};
  char p_Src[BCXSTRSIZE];
  char word_left[BCXSTRSIZE];
  char prev_word_left[BCXSTRSIZE];
  int  j;
  strcpy(p_Src,pp_Src);
  if(ISNULL(p_Src)){
      return FALSE;
    }
  if(strcmp(p_Src,"endwith")==0){
      return FALSE;
    }
  ProcessingCOM_Set=FALSE;
  if(LeftStr(pp_Src,"set ",TRUE)){
      ProcessingCOM_Set=TRUE;
      strcpy(pp_Src,trim(mid(pp_Src,5)));
      strcpy(p_Src,pp_Src);
    }
  if(iMatchLft(p_Src,"for ")){
      return FALSE;
    }
  if(iMatchLft(p_Src,"with ")){
      strcpy(word_left,trim(mid(p_Src,6)));
      if(COM_open_WITH_statement ){
          if(word_left[0]==46 ){
              COM_open_WITH_statement++;
              strcpy(p_Src, join(4,COM_with_temp_str_name," = ",COM_with_temp_str_name,word_left));
            }
          else
            {
              Abort("Nested <WITH> statements, in open WITH block, are allowed only for interfaces of same COM object. For more info, see rules for using COM in BCX.");
            }
        }
      else
        {
          strcpy(prev_word_left,trim(extract(word_left,".")));
          if(IsVariableComObject(prev_word_left)){
              COM_open_WITH_statement++;
              strcpy(COM_with_temp_str_name,prev_word_left);
              strcpy(p_Src,word_left);
              if(inchr(p_Src,".")==0 ){
                  *pp_Src=0;
                  return TRUE;
                }
              strcpy(p_Src, join(3,prev_word_left," = ",word_left));
            }
        }
    }
  else
    {
      if(COM_open_WITH_statement ){
          if(p_Src[0]==46 ){
              strcpy(p_Src, join(2,COM_with_temp_str_name,p_Src));
            }
        }
    }
  FastLexer(p_Src,"","'");
  int  i;
  i=2;
  strcpy(p_Src,Stk[1]);
  while(i<=Ndx){
      if(*Stk[i]==39 ){
          goto L1564;
        }
      strcat(p_Src,Stk[i]);
      i++;
    }
L1564:;
  FastLexer(p_Src,"","= ",0);
  i=1;
  j=0;
  while(i<Ndx){
      if(*Stk[i]==61 ){
          j=i;
        }
      i++;
    }
  if(j ){
      i=2;
      strcpy(p_Src,trim(Stk[1]));
      while(i<j){
          strcat(p_Src,trim(Stk[i]));
          i++;
        }
      strcat(p_Src,Stk[j]);
      while(++j<=Ndx){
          strcat(p_Src,trim(Stk[j]));
        }
    }
  FastLexer(p_Src,"","[]()=. ",0);
  char szLeft[BCXSTRSIZE]={0};
  char szRight[BCXSTRSIZE]={0};
  int FOUND_SPACE={0};
  FOUND_OBJECT=FALSE;
  FOUND_EQU=FALSE;
  FOUND_SPACE=FALSE;
  FOUND_DOT=FALSE;
  int DO_COM=0;
  for(i=1; i<=Ndx; i++)
    {
      if(FOUND_OBJECT==FALSE ){
          FOUND_OBJECT=IsVariableComObject(Stk[i]);
        }
      if(*Stk[i]==61 ){
          FOUND_EQU=TRUE;
          if(FOUND_OBJECT==FALSE ){
              if(DO_COM==0 ){
                  DO_COM=(-1);
                }
              else
                {
                  DO_COM=1;
                }
            }
          else
            {
              if(FOUND_DOT==FALSE ){
                  DO_COM=(-1);
                }
              else
                {
                  DO_COM=1;
                }
            }
          continue;
        }
      if(*Stk[i]==46&&FOUND_OBJECT!=FALSE ){
          FOUND_DOT=TRUE;
        }
      if(FOUND_OBJECT&&*Stk[i]==32 ){
          FOUND_SPACE=i;
          continue;
        }
      if(FOUND_EQU||FOUND_SPACE ){
          strcat(szRight,Stk[i]);
          if(strcmp(Stk[i],"(")==0){
              int  iP;
              iP=1;
              while(iP){
                  i++;
                  if(strcmp(Stk[i],"(")==0){
                      iP++;
                    }
                  if(strcmp(Stk[i],")")==0){
                      iP--;
                    }
                  strcat(szRight,trim(Stk[i]));
                }
            }
        }
      else
        {
          if(strcmp(Stk[i],"(")==0){
              int  iP;
              strcat(szLeft,Stk[i]);
              iP=1;
              while(iP){
                  if(i==Ndx ){
                      Abort("Unbalance () in COM statement");
                    }
                  i++;
                  if(strcmp(Stk[i],"(")==0){
                      iP++;
                    }
                  if(strcmp(Stk[i],")")==0){
                      iP--;
                    }
                  strcat(szLeft,trim(Stk[i]));
                }
            }
          else
            {
              strcat(szLeft,Stk[i]);
            }
        }
    }
  if(FOUND_OBJECT!=FALSE ){
      if(FOUND_DOT ){
          if(COM_build_trace_code ){
              fprintf(FP_WRITE,"%s%s%s\n","COM_add_trace_line(",enc("  "),");");
              fprintf(FP_WRITE,"%s%s%s\n","COM_add_trace_line(",enc("***********************************************************"),");");
              fprintf(FP_WRITE,"%s%s%s\n","COM_add_trace_line(",enc(join(2,"Source Line= ",Make_COM_Trace_Lines(pp_Src))),");");
            }
          if(DO_COM==-1 ){
              COM_Parse_GetProperty(szLeft,szRight);
              goto L1571;
            }
          if(DO_COM==0 ){
              COM_Parse_Method(szLeft,szRight);
              goto L1571;
            }
          if(DO_COM==1 ){
              COM_Parse_SetProperty(szLeft,szRight,FOUND_OBJECT);
            }
L1571:;
          *pp_Src=0;
          return TRUE;
        }
    }
  XParse(pp_Src);
  return FALSE;
}

void COM_Parse_GetProperty (char* varname,char* com_property)
{
  Use_COM_GetProperty=Use_COM_UsesConversion=Use_COM=TRUE;
  char com_method[BCXSTRSIZE]={0};
  int j={0};
  int k={0};
  char ObjName[BCXSTRSIZE]={0};
  char ComTok[BCXSTRSIZE]={0};
  char ComTokPrev[BCXSTRSIZE]={0};
  char temp_param[BCXSTRSIZE]={0};
  char force_cast[BCXSTRSIZE]={0};
  int force_casting={0};
  strcpy(com_method,trim(com_property));
  if(com_method[0]==c_LPar ){
      strcpy(force_cast,trim(ucase(extract(com_method+1,")"))));
      strcpy(com_method,trim(remain(com_method,")")));
      force_casting=1;
    }
  ParseCom(com_method);
  j=1;
  strcpy(ObjName,ComStk[j++]);
  strcpy(ComTok,ComStk[j++]);
  for(;;)
    {
      strcpy(ComTokPrev,ComTok);
      strcpy(ComTok,ComStk[j++]);
      fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"lstrcpy(COM_ErrMsg, _T(",enc(Make_COM_Trace_Lines(ComTokPrev)),"));");
      if(inchr(ComTokPrev,"(")>0 ){
          strcpy(temp_param,trim(remain(ComTokPrev,"(")));
          k=COM_Make_Param_List(mid(temp_param,1,(int)strlen(temp_param)-1),1);
          fprintf(FP_WRITE,"%s%s% .15G %s\n",Scoot,"COM_plist_index =",(double)k,";");
          strcpy(ComTokPrev,extract(ComTokPrev,"("));
        }
      if(ComTok[0]>0 ){
          if(COM_build_trace_code ){
              fprintf(FP_WRITE,"%s%s%s\n","    COM_add_trace_line(",enc(join(2,">>> Get next dispatch for:: ",ComTokPrev)),");");
            }
          fprintf(FP_WRITE,"%s%s%s%s%s%s\n",Scoot,"COM_get_next_dispatch(&",ObjName,", L",enc(RemoveStr(ComTokPrev,SPC)),");");
        }
      else
        {
          if(COM_open_WITH_statement ){
              if(COM_build_trace_code ){
                  fprintf(FP_WRITE,"%s%s%s\n","    COM_add_trace_line(",enc(join(2,"WITH construction >>> Get next dispatch for:: ",ComTokPrev)),");");
                }
              fprintf(FP_WRITE,"%s%s%s%s%s%s\n",Scoot,"COM_get_next_dispatch(&",ObjName,", L",enc(RemoveStr(ComTokPrev,SPC)),");");
              fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"COM_dispatch_at_offset = ",COM_with_temp_str_name,".ipointer;");
              fprintf(FP_WRITE,"%s%s\n",Scoot,"COM_dispatch_storage_index++;");
              fprintf(FP_WRITE,"%s%s\n",Scoot,"COM_dispatch_storage[COM_dispatch_storage_index] = COM_dispatch_at_offset;");
              return;
            }
          if(COM_build_trace_code ){
              fprintf(FP_WRITE,"%s%s%s\n","    COM_add_trace_line(",enc(join(2,">>> COM_invoke for:: ",ComTokPrev)),");");
            }
          if(COM_FOREACH_enumerator==TRUE ){
              fprintf(FP_WRITE,"%s%s%s%s%s%s\n",Scoot,"COM_get_next_dispatch(&",ObjName,", L",enc(RemoveStr(ComTokPrev,SPC)),");");
              return;
            }
          else
            {
              fprintf(FP_WRITE,"%s%s%s%s%s",Scoot,"COM_invoke(&",ObjName,", L",enc(RemoveStr(ComTokPrev,SPC)));
              fprintf(FP_WRITE,"%s\n",",COM_PROPS, &COM_vt_result);\n");
            }
          if(force_casting==1 ){
              fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"VariantChangeType(&COM_vt_result, &COM_vt_result,0,",force_cast,");");
            }
          if(!*varname ){
              goto L1572;
            }
          char Cleanvarname[BCXSTRSIZE];
          strcpy(Cleanvarname,trim(Clean(varname)));
          if(force_casting==1 ){
              if(strcmp(force_cast,"VT_BSTR")==0){
                  fprintf(FP_WRITE,"%s%s%s\n",Scoot,Cleanvarname," = SysAllocString(COM_vt_result.bstrVal);");
                }
              else
                {
                  strcpy(force_cast,replace(force_cast,"VT_","V_"));
                  fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,Cleanvarname," = ",force_cast,"(&COM_vt_result);");
                }
            }
          else
            {
              struct _VARINFO*  VI;
              int vt;
              int id;
              struct _VARINFO  tVI;
              if(inchr(Cleanvarname,".")){
                  char sTAG[BCXSTRSIZE];
                  strcpy(sTAG,left(Cleanvarname,inchr(Cleanvarname,".")-1));
                  vt=CheckLocal(sTAG,&(id));
                  if(vt==vt_UNKNOWN ){
                      vt=CheckGlobal(sTAG,&(id));
                      if(vt==vt_UNKNOWN ){
                          Abort(join(3,"Unknown structure ",sTAG," not previously dimensioned"));
                        }
                    }
                  tVI.VarPntr=0;
                  tVI.VarType=0;
                  if(vt==vt_VARIANT ){
                      int i={0};
                      strcpy(sTAG,mid(Cleanvarname,inchr(Cleanvarname,".")+1));
                      i=0;
                      while(VariantList[i].sNAME){
                          if(strcmp(VariantList[i].sNAME,sTAG)==0){
                              tVI.VarType=VariantList[i].iTYPE;
                              tVI.VarPntr=VariantList[i].iPTRS;
                              vt=tVI.VarType;
                              goto L1573;
                            }
                          i++;
                        }
L1573:;
                    }
                  VI=&(tVI);
                }
              else
                {
                  vt=CheckLocal(Cleanvarname,&(id));
                  if(vt==vt_UNKNOWN ){
                      vt=CheckGlobal(Cleanvarname,&(id));
                      if(vt==vt_UNKNOWN ){
                          Abort(join(3,"Unknown variable ",varname," not previously dimensioned"));
                        }
                      VI=&(GlobalVars[id]);
                    }
                  else
                    {
                      VI=&(LocalVars[id]);
                    }
                }
              if(vt==vt_VARIANT ){
                  if(VI->VarPntr ){
                      fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"VariantCopy((VARIANT *)(&",Cleanvarname,"),&COM_vt_result);");
                    }
                  else
                    {
                      fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"VariantCopy(&",Cleanvarname,",&COM_vt_result);");
                    }
                  goto L1574;
                }
              if(vt==vt_DOUBLE ){
                  if(VI->VarPntr ){
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"if (COM_vt_result.vt != (VT_R8|VT_BYREF))");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  {");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_R8|VT_BYREF);");
                      if(COM_build_trace_code ){
                          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  COM_add_trace_line(",enc(join(3,"Return variable for ",Cleanvarname," was coerced")),");");
                        }
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  }");
                      fprintf(FP_WRITE,"%s%s%s\n",Scoot,Cleanvarname," = COM_vt_result.pdblVal;");
                    }
                  else
                    {
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"if (COM_vt_result.vt != VT_R8)");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  {");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_R8);");
                      if(COM_build_trace_code ){
                          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  COM_add_trace_line(",enc(join(3,"Return variable for ",Cleanvarname," was coerced")),");");
                        }
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  }");
                      fprintf(FP_WRITE,"%s%s%s\n",Scoot,Cleanvarname," = COM_vt_result.dblVal;");
                    }
                  goto L1574;
                }
              if(vt==vt_SINGLE ){
                  if(VI->VarPntr ){
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"if (COM_vt_result.vt != (VT_R4|VT_BYREF))");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  {");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_R4|VT_BYREF);");
                      if(COM_build_trace_code ){
                          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  COM_add_trace_line(",enc(join(3,"Return variable for ",Cleanvarname," was coerced")),");");
                        }
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  }");
                      fprintf(FP_WRITE,"%s%s%s\n",Scoot,Cleanvarname," = COM_vt_result.pfltVal;");
                    }
                  else
                    {
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"if (COM_vt_result.vt != VT_R4)");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  {");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_R4);");
                      if(COM_build_trace_code ){
                          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  COM_add_trace_line(",enc(join(3,"Return variable for ",Cleanvarname," was coerced")),");");
                        }
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  }");
                      fprintf(FP_WRITE,"%s%s%s\n",Scoot,Cleanvarname," = COM_vt_result.fltVal;");
                    }
                  goto L1574;
                }
              if(vt==vt_INTEGER ){
                  if(VI->VarPntr ){
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"if (COM_vt_result.vt != (VT_INT|VT_BYREF))");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  {");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_INT|VT_BYREF);");
                      if(COM_build_trace_code ){
                          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  COM_add_trace_line(",enc(join(3,"Return variable for ",Cleanvarname," was coerced")),");");
                        }
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  }");
                      fprintf(FP_WRITE,"%s%s%s\n",Scoot,Cleanvarname," = COM_vt_result.pintVal;");
                    }
                  else
                    {
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"if (COM_vt_result.vt != VT_INT)");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  {");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  VariantChangeType(&COM_vt_result,");
                      fprintf(FP_WRITE,"%s%s\n",Scoot," &COM_vt_result,0, VT_INT);");
                      if(COM_build_trace_code ){
                          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  COM_add_trace_line(",enc(join(3,"Return variable for ",Cleanvarname," was coerced")),");");
                        }
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  }");
                      fprintf(FP_WRITE,"%s%s%s\n",Scoot,Cleanvarname," = COM_vt_result.intVal;");
                    }
                  goto L1574;
                }
              if(vt==vt_UINT ){
                  if(VI->VarPntr ){
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"if (COM_vt_result.vt != (VT_UI4|VT_BYREF))");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  {");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_UI4|VT_BYREF);");
                      if(COM_build_trace_code ){
                          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  COM_add_trace_line(",enc(join(3,"Return variable for ",Cleanvarname," was coerced")),");");
                        }
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  }");
                      fprintf(FP_WRITE,"%s%s%s\n",Scoot,Cleanvarname," = COM_vt_result.uintVal;");
                    }
                  else
                    {
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"if (COM_vt_result.vt != VT_INT)");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  {");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  VariantChangeType(&COM_vt_result,");
                      fprintf(FP_WRITE,"%s%s\n",Scoot," &COM_vt_result,0, VT_INT);");
                      if(COM_build_trace_code ){
                          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  COM_add_trace_line(",enc(join(3,"Return variable for ",Cleanvarname," was coerced")),");");
                        }
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  }");
                      fprintf(FP_WRITE,"%s%s%s\n",Scoot,Cleanvarname," = COM_vt_result.uintVal;");
                    }
                  goto L1574;
                }
              if(vt==vt_LONG ){
                  if(VI->VarPntr ){
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"if (COM_vt_result.vt != (VT_I4|VT_BYREF))");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  {");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_I4|VT_BYREF);");
                      if(COM_build_trace_code ){
                          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  COM_add_trace_line(",enc(join(3,"Return variable for ",Cleanvarname," was coerced")),");");
                        }
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  }");
                      fprintf(FP_WRITE,"%s%s%s\n",Scoot,Cleanvarname," = COM_vt_result.plVal;");
                    }
                  else
                    {
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"if (COM_vt_result.vt != VT_I4)");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  {");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"    VariantChangeType(&COM_vt_result, &COM_vt_result,0,VT_I4);");
                      if(COM_build_trace_code ){
                          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  COM_add_trace_line(",enc(join(3,"Return variable for ",Cleanvarname," was coerced")),");");
                        }
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  }");
                      fprintf(FP_WRITE,"%s%s%s\n",Scoot,Cleanvarname," = COM_vt_result.lVal;");
                    }
                  goto L1574;
                }
              if(vt==vt_ULONG ){
                  if(VI->VarPntr ){
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"if (COM_vt_result.vt != (VT_UI4|VT_BYREF))");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  {");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_UI4|VT_BYREF);");
                      if(COM_build_trace_code ){
                          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  COM_add_trace_line(",enc(join(3,"Return variable for ",Cleanvarname," was coerced")),");");
                        }
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  }");
                      fprintf(FP_WRITE,"%s%s%s\n",Scoot,Cleanvarname," = COM_vt_result.pulVal;");
                    }
                  else
                    {
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"if (COM_vt_result.vt != VT_UI4)");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  {");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_UI4);");
                      if(COM_build_trace_code ){
                          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  COM_add_trace_line(",enc(join(3,"Return variable for ",Cleanvarname," was coerced")),");");
                        }
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  }");
                      fprintf(FP_WRITE,"%s%s%s\n",Scoot,Cleanvarname," = COM_vt_result.ulVal;");
                    }
                  goto L1574;
                }
              if(vt==vt_LLONG ){
                  if(VI->VarPntr ){
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"if (COM_vt_result.vt != (VT_I8|VT_BYREF))");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  {");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"    VariantChangeType (&COM_vt_result,&COM_vt_result,0,VT_I8|VT_BYREF);");
                      if(COM_build_trace_code ){
                          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  COM_add_trace_line(",enc(join(3,"Return variable for ",Cleanvarname," was coerced")),");");
                        }
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  }");
                      fprintf(FP_WRITE,"%s%s%s\n",Scoot,Cleanvarname," = COM_vt_result.pllVal;");
                    }
                  else
                    {
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"if (COM_vt_result.vt != VT_I8)");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  {");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_I8);");
                      if(COM_build_trace_code ){
                          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  COM_add_trace_line(",enc(join(3,"Return variable for ",Cleanvarname," was coerced")),");");
                        }
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  }");
                      fprintf(FP_WRITE,"%s%s%s\n",Scoot,Cleanvarname," = COM_vt_result.llVal;");
                    }
                  goto L1574;
                }
              if(vt==vt_ULONGLONG ){
                  if(VI->VarPntr ){
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"if (COM_vt_result.vt != (VT_UI8|VT_BYREF))");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  {");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_UI8|VT_BYREF);");
                      if(COM_build_trace_code ){
                          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  COM_add_trace_line(",enc(join(3,"Return variable for ",Cleanvarname," was coerced")),");");
                        }
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  }");
                      fprintf(FP_WRITE,"%s%s%s\n",Scoot,Cleanvarname," = COM_vt_result.pullVal;");
                    }
                  else
                    {
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"if (COM_vt_result.vt != VT_UI8)");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  {");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_UI8);");
                      if(COM_build_trace_code ){
                          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  COM_add_trace_line(",enc(join(3,"Return variable for ",Cleanvarname," was coerced")),");");
                        }
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  }");
                      fprintf(FP_WRITE,"%s%s%s\n",Scoot,Cleanvarname," = COM_vt_result.ullVal;");
                    }
                  goto L1574;
                }
              if(vt==vt_SHORT||vt==vt_SSHORT ){
                  if(VI->VarPntr ){
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"if (COM_vt_result.vt != (VT_I2|VT_BYREF))");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  {");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_I2|VT_BYREF);");
                      if(COM_build_trace_code ){
                          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  COM_add_trace_line(",enc(join(3,"Return variable for ",Cleanvarname," was coerced")),");");
                        }
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  }");
                      fprintf(FP_WRITE,"%s%s%s\n",Scoot,Cleanvarname," = COM_vt_result.piVal;");
                    }
                  else
                    {
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"if (COM_vt_result.vt != VT_I2)");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  {");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_I2);");
                      if(COM_build_trace_code ){
                          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  COM_add_trace_line(",enc(join(3,"Return variable for ",Cleanvarname," was coerced")),");");
                        }
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  }");
                      fprintf(FP_WRITE,"%s%s%s\n",Scoot,Cleanvarname," = COM_vt_result.iVal;");
                    }
                  goto L1574;
                }
              if(vt==vt_USHORT ){
                  if(VI->VarPntr ){
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"if (COM_vt_result.vt != (VT_UI2|VT_BYREF))");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  {");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_UI2|VT_BYREF);");
                      if(COM_build_trace_code ){
                          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  COM_add_trace_line(",enc(join(3,"Return variable for ",Cleanvarname," was coerced")),");");
                        }
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  }");
                      fprintf(FP_WRITE,"%s%s%s\n",Scoot,Cleanvarname," = COM_vt_result.puiVal;");
                    }
                  else
                    {
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"if (COM_vt_result.vt != VT_UI2)");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  {");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_UI2);");
                      if(COM_build_trace_code ){
                          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  COM_add_trace_line(",enc(join(3,"Return variable for ",Cleanvarname," was coerced")),");");
                        }
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  }");
                      fprintf(FP_WRITE,"%s%s%s\n",Scoot,Cleanvarname," = COM_vt_result.uiVal;");
                    }
                  goto L1574;
                }
              if(vt==vt_BYTE ){
                  if(VI->VarPntr ){
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"if (COM_vt_result.vt != (VT_UI1|VT_BYREF))");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  {");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_UI1|VT_BYREF);");
                      if(COM_build_trace_code ){
                          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  COM_add_trace_line(",enc(join(3,"Return variable for ",Cleanvarname," was coerced")),");");
                        }
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  }");
                      fprintf(FP_WRITE,"%s%s%s\n",Scoot,Cleanvarname," = COM_vt_result.pbVal;");
                    }
                  else
                    {
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"if (COM_vt_result.vt != VT_UI1)");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  {");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"    VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_UI1);");
                      if(COM_build_trace_code ){
                          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  COM_add_trace_line(",enc(join(3,"Return variable for ",Cleanvarname," was coerced")),");");
                        }
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  }");
                      fprintf(FP_WRITE,"%s%s%s\n",Scoot,Cleanvarname," = COM_vt_result.bVal;");
                    }
                  goto L1574;
                }
              if(vt==vt_BOOL ){
                  if(VI->VarPntr ){
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"if (COM_vt_result.vt != (VT_BOOL|VT_BYREF))");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  {");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"     VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_BOOL|VT_BYREF);");
                      if(COM_build_trace_code ){
                          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"    COM_add_trace_line(",enc(join(3,"Return variable for ",Cleanvarname," was coerced")),");");
                        }
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  }");
                      fprintf(FP_WRITE,"%s%s%s\n",Scoot,Cleanvarname," = COM_vt_result.pboolVal;");
                    }
                  else
                    {
                      fprintf(FP_WRITE,"%s%s%s\n",Scoot,Cleanvarname," = CON_VARBOOL2BOOL(COM_vt_result.boolVal);");
                    }
                  goto L1574;
                }
              if(vt==vt_STRVAR||vt==vt_CHAR||vt==vt_SCHAR ){
                  fprintf(FP_WRITE,"%s%s\n",Scoot,"if(COM_vt_result.vt == VT_NULL){");
                  fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  *",Cleanvarname,"=0;");
                  fprintf(FP_WRITE,"%s%s\n",Scoot,"} else {");
                  fprintf(FP_WRITE,"%s%s\n",Scoot,"COM_last_HR = VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_BSTR);\n");
                  fprintf(FP_WRITE,"%s%s\n",Scoot,"if (FAILED(COM_last_HR)) {");
                  fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  COM_HR_ErrMsg (COM_last_HR,_T(",enc("VariantChangeType (BSTR) Failed!"),"));");
                  fprintf(FP_WRITE,"%s%s\n",Scoot,"} else {");
                  fprintf(FP_WRITE,"%s%s\n",Scoot,"  #ifndef UNICODE");
                  fprintf(FP_WRITE,"%s%s\n",Scoot,"  COM_last_HR = COM_WS2AS(COM_vt_result.bstrVal);");
                  fprintf(FP_WRITE,"%s%s\n",Scoot,"  if (FAILED(COM_last_HR)) {");
                  fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"    COM_HR_ErrMsg (COM_last_HR,_T(",enc("COM Get Property Failed! W2A failure!"),"));");
                  fprintf(FP_WRITE,"%s%s\n",Scoot,"  } else {");
                  fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"   strcpy(",Cleanvarname,", COM_psz_tmp);");
                  fprintf(FP_WRITE,"%s%s\n",Scoot,"  }");
                  fprintf(FP_WRITE,"%s%s\n",Scoot,"  #else");
                  fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  lstrcpy(",Cleanvarname,",COM_vt_result.bstrVal);");
                  fprintf(FP_WRITE,"%s%s\n",Scoot,"  #endif");
                  fprintf(FP_WRITE,"%s%s\n",Scoot,"}");
                  fprintf(FP_WRITE,"%s%s\n",Scoot,"}");
                  goto L1574;
                }
              if(vt==vt_UDT ){
                  if(ProcessingCOM_Set&&IsVariableComObject(Cleanvarname)){
                      ProcessingCOM_Set=FALSE;
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"if (COM_vt_result.vt != VT_DISPATCH) {");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"    COM_last_HR = VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_DISPATCH);");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"}\n");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"if (FAILED(COM_last_HR)) {");
                      fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  strcpy(COM_ErrMsg ,",enc(Cleanvarname),");");
                      fprintf(FP_WRITE,"%s%s",Scoot,"  COM_HR_ErrMsg (COM_last_HR, _T(");
                      fprintf(FP_WRITE,"%s%s%s\n",Scoot,enc("VariantChangeType failed. Expected IDispatch*"),"));");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"} else {");
                      fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  VariantInit(&",Cleanvarname,".pObjects[0]);");
                      fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  COM_last_HR = VariantCopy(&",Cleanvarname,".pObjects[0],&COM_vt_result);\n");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  if (FAILED(COM_last_HR)) {");
                      fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"    strcpy(COM_ErrMsg ,",enc(Cleanvarname),");");
                      fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"    COM_HR_ErrMsg (COM_last_HR, _T(",enc("VariantCopy failed."),"));");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  } else {");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"    COM_objects_cnt++;");
                      fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"    ",Cleanvarname,".pStatus = TRUE;");
                      fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"    ",Cleanvarname,".ipointer = 0;");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  }  ");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"} ");
                    }
                  else
                    {
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"if (COM_vt_result.vt == VT_BOOL) {");
                      fprintf(FP_WRITE,"%s%s%s\n",Scoot,Cleanvarname," = CON_VARBOOL2BOOL(COM_vt_result.boolVal);");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"} else {");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"switch (COM_vt_result.vt)");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  {");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  case VT_R8:");
                      fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"      ",Cleanvarname," = COM_vt_result.dblVal;");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"    break;");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  case VT_R4:");
                      fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"      ",Cleanvarname," = COM_vt_result.fltVal;");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"    break;");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  default:");
                      fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"      ",Cleanvarname," = (int)COM_vt_result.lVal;");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"    break;");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  }");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"}");
                    }
                  goto L1574;
                }
              if(vt==vt_BSTR ){
                  if(VI->VarPntr ){
                      fprintf(FP_WRITE,"%s%s%s\n",Scoot,Cleanvarname," = COM_vt_result.pbstrVal;");
                    }
                  else
                    {
                      fprintf(FP_WRITE,"%s%s%s\n",Scoot,Cleanvarname," = COM_vt_result.bstrVal;");
                    }
                }
              else
                {
                  if(ProcessingCOM_Set&&IsVariableComObject(Cleanvarname)){
                      ProcessingCOM_Set=FALSE;
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"if (COM_vt_result.vt != VT_DISPATCH) {");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"    COM_last_HR = VariantChangeType(&COM_vt_result,&COM_vt_result,0,VT_DISPATCH);");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"}\n");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"if (FAILED(COM_last_HR)) {");
                      fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  strcpy(COM_ErrMsg ,",enc(Cleanvarname),");");
                      fprintf(FP_WRITE,"%s%s",Scoot,"  COM_HR_ErrMsg (COM_last_HR, _T(");
                      fprintf(FP_WRITE,"%s%s%s\n",Scoot,enc("VariantChangeType failed. Expected IDispatch*"),"));");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"} else {");
                      fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  VariantInit(&",Cleanvarname,".pObjects[0]);");
                      fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  COM_last_HR = VariantCopy(&",Cleanvarname,".pObjects[0], &COM_vt_result);\n");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  if (FAILED(COM_last_HR)) {");
                      fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"    strcpy(COM_ErrMsg ,",enc(Cleanvarname),");");
                      fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"    COM_HR_ErrMsg (COM_last_HR, _T(",enc("VariantCopy failed."),"));");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  } else {");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"    bcx_ole_objects_count++;");
                      fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"    ",Cleanvarname,".pStatus = TRUE;");
                      fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"    ",Cleanvarname,".ipointer = 0;");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  }  ");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"} ");
                    }
                  else
                    {
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"if (COM_vt_result.vt == VT_BOOL) {");
                      fprintf(FP_WRITE,"%s%s%s\n",Scoot,Cleanvarname," = CON_VARBOOL2BOOL(COM_vt_result.boolVal);");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"} else {");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"switch (COM_vt_result.vt)");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  {");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  case VT_R8:");
                      fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"      ",Cleanvarname," = COM_vt_result.dblVal;");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"    break;");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  case VT_R4:");
                      fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"      ",Cleanvarname," = COM_vt_result.fltVal;");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"    break;");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  default:");
                      fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"      ",Cleanvarname," = (int)COM_vt_result.lVal;");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"    break;");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"  }");
                      fprintf(FP_WRITE,"%s%s\n",Scoot,"}");
                    }
                }
L1574:;
            }
          fprintf(FP_WRITE,"%s%s\n",Scoot,"VariantClear(&COM_vt_result);");
          goto L1572;
        }
    }
L1572:;
  fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"if (0 == COM_reset_chain) COM_reset_disp_chain(&",ObjName,");");
}

void COM_Parse_SetProperty (char* com_method,char* pparms,int Obj_At_Index)
{
  Use_COM_SetProperty=Use_COM_UsesConversion=Use_COM=TRUE;
  int j={0};
  int k={0};
  char ObjName[BCXSTRSIZE]={0};
  char ComTok[BCXSTRSIZE]={0};
  char ComTokPrev[BCXSTRSIZE]={0};
  char temp_param[BCXSTRSIZE]={0};
  char parms[BCXSTRSIZE]={0};
  int BuildSafeArray={0};
  if(COM_build_trace_code ){
      fprintf(FP_WRITE,"%s%s%s\n","    COM_add_trace_line(",enc(join(7,"COM_Parse_SetProperty(",Make_COM_Trace_Lines(com_method)," , ",Make_COM_Trace_Lines(pparms)," , ",str(Obj_At_Index),")")),");");
    }
  strcpy(parms,trim(pparms));
  if(NOTNULL(parms)){
      if(strcmp(mid(ucase(parms),1,6),"ARRAY(")==0  || strcmp(mid(ucase(parms),1,6),"ARRAY ")==0){
          strcpy(parms,remain(parms,"("));
          j=(int)strlen(parms)-1;
          parms[j]=0;
          BuildSafeArray=1;
          Use_COM_SafeArray=TRUE;
        }
    }
  ParseCom(com_method);
  j=1;
  strcpy(ObjName,ComStk[j++]);
  strcpy(ComTok,ComStk[j++]);
  for(;;)
    {
      strcpy(ComTokPrev,ComTok);
      strcpy(ComTok,ComStk[j++]);
      fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"lstrcpy(COM_ErrMsg, _T(",enc(Make_COM_Trace_Lines(ComTokPrev)),"));");
      if(ComTok[0]>0 ){
          if(inchr(ComTokPrev,"(")>0 ){
              strcpy(temp_param,trim(remain(ComTokPrev,"(")));
              k=COM_Make_Param_List(mid(temp_param,1,(int)strlen(temp_param)-1),1);
              fprintf(FP_WRITE,"%s%s% .15G %s\n",Scoot,"COM_plist_index =",(double)k,";");
              strcpy(ComTokPrev,trim(extract(ComTokPrev,"(")));
            }
          if(COM_build_trace_code ){
              fprintf(FP_WRITE,"%s%s%s\n","    COM_add_trace_line(",enc(join(2,">>> Get next dispatch for:: ",ComTokPrev)),");");
            }
          fprintf(FP_WRITE,"%s%s%s%s%s%s\n",Scoot,"COM_get_next_dispatch(&",ObjName,", L",enc(RemoveStr(ComTokPrev,SPC)),");");
        }
      else
        {
          if(COM_build_trace_code ){
              fprintf(FP_WRITE,"%s%s%s\n","COM_add_trace_line(",enc(join(2,"Invoke helper for:: ",ComTokPrev)),");");
            }
          k=COM_Make_Param_List(parms,0);
          fprintf(FP_WRITE,"%s%s% .15G %s\n",Scoot,"COM_plist_index =",(double)k,";");
          if(BuildSafeArray ){
              fprintf(FP_WRITE,"%s%s\n",Scoot,"COM_create_safearray();");
            }
          char sXX[BCXSTRSIZE];
          strcpy(sXX, join(2,chr(92),chr(c_DblQt)));
          strcpy(ComTokPrev,replace(ComTokPrev,chr(c_DblQt),sXX));
          fprintf(FP_WRITE,"%s\n","");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"if (!COM_BCX_ERROR)");
          fprintf(FP_WRITE,"%s%s%s%s%s%s\n",Scoot,"  COM_invoke(&",ObjName,", L",enc(RemoveStr(ComTokPrev,SPC)),", DISPATCH_PROPERTYPUT, NULL);\n");
          goto L1575;
        }
    }
L1575:;
}

int GetParameterTokens (char* sP)
{
  int  iWorkingOn;
  int  iLastTokenPlus1;
  char ParamTok[BCXSTRSIZE];
  FastLexer(sP,"",",()[]");
  iLastTokenPlus1=Ndx;
  if(tally(sP,"(")||tally(sP,"[")){
      for(iWorkingOn=1; iWorkingOn<=Ndx; iWorkingOn++)
        {
          strcpy(Stk[iWorkingOn],trim(Stk[iWorkingOn]));
        }
      RemEmptyTokens();
      iWorkingOn=1;
      iLastTokenPlus1=0;
      while(BYTE_AT(Stk[iWorkingOn][0])){
          strcpy(ParamTok,Stk[iWorkingOn]);
          if(ParamTok[0]!=c_Comma&&BYTE_AT(Stk[iWorkingOn+1][0])!=c_Comma ){
              for(;;)
                {
                  iWorkingOn++;
                  if(iWorkingOn>Ndx ){
                      goto L1578;
                    }
                  strcat(ParamTok,Stk[iWorkingOn]);
                  while((tally(ParamTok,"[")-tally(ParamTok,"]"))!=0||(tally(ParamTok,"(")-tally(ParamTok,")"))!=0){
                      iWorkingOn++;
                      strcat(ParamTok,Stk[iWorkingOn]);
                    }
                  if(BYTE_AT(Stk[iWorkingOn][0])==c_Comma ){
                      goto L1578;
                    }
                  if(!(*Stk[iWorkingOn])){
                      goto L1578;
                    }
                }
L1578:;
            }
          iWorkingOn++;
          strcpy(Stk[++iLastTokenPlus1],ParamTok);
          if(iWorkingOn>Ndx ){
              goto L1577;
            }
        }
L1577:;
      Ndx=iLastTokenPlus1;
    }
  iLastTokenPlus1++;
  *Stk[iLastTokenPlus1]=0;
  if(cMaxParamToken<=iLastTokenPlus1 ){
      Abort("Maximum nunber of com tokens exceeded.");
    }
  for(iWorkingOn=1; iWorkingOn<=iLastTokenPlus1; iWorkingOn++)
    {
      strcpy(ParamToken[iWorkingOn],Stk[iWorkingOn]);
    }
  return Ndx;
}

int COM_Make_Param_List (char* parms,int i)
{
  int RetValue;
  RetValue=COM_Prep_Param_List(parms,i);
  return RetValue;
}

int COM_Prep_Param_List (char* parms,int IsIndex)
{
  char sTMP[BCXSTRSIZE];
  char sCleanTemp[BCXSTRSIZE];
  int  iTokens;
  int  i;
  int  j;
  int  k;
  int  iArrayFlag;
  int  iByrefFlag;
  char P[BCXSTRSIZE];
  char P2[BCXSTRSIZE];
  char local_parm_copy[BCXSTRSIZE];
  char local_temp_str[BCXSTRSIZE];
  int  ComParameterCnt;
  int  iReturn;
  if(!*parms ){
      return 0;
    }
  ComParameterCnt=0;
  strcpy(local_parm_copy,trim(parms));
  iTokens=GetParameterTokens(local_parm_copy);
  i=1;
  while(i<=iTokens){
      if(BYTE_AT(ParamToken[i][0])==c_Comma ){
          i++;
        }
      else
        {
          i+=(2);
        }
      ComParameterCnt++;
    }
  iReturn=ComParameterCnt;
  i=1;
  while(i<=iTokens){
      *P=0;
      strcpy(P2,";");
      iByrefFlag=0;
      iArrayFlag=0;
      if(BYTE_AT(ParamToken[i][0])==c_Comma ){
          j=comvt_ERROR;
          strcpy(sCleanTemp,"DISP_E_PARAMNOTFOUND");
          i++;
        }
      else
        {
          j=ComParamType(ParamToken[i],&(k));
          if(k ){
              *sCleanTemp=0;
              for(k=1; k<=Ndx; k++)
                {
                  strcat(sCleanTemp,Stk[k]);
                }
              strcpy(sCleanTemp,Clean(sCleanTemp));
            }
          else
            {
              if(j==comvt_CAST ){
                  ConvertCast(ParamToken[i],local_temp_str,sCleanTemp);
                }
              else
                {
                  strcpy(sCleanTemp,Clean(ParamToken[i]));
                }
            }
          iByrefFlag=j & comvt_BYREF;
          if(iByrefFlag ){
              strcpy(P,"p");
              strcpy(P2,"|VT_BYREF;");
            }
          iArrayFlag=j & comvt_ARRAY;
          if(iArrayFlag ){
              strcat(P,"p");
              strcpy(P2, join(2,"|VT_ARRAY",P2));
            }
          j=j & comvt_TYPEMASK;
          i+=(2);
        }
      ComParameterCnt--;
      strcpy(sTMP,trim(str(ComParameterCnt)));
      if(j==comvt_EMPTY ){
          if(iArrayFlag ){
              Abort("Invalid: Array of empty");
            }
          if(iByrefFlag ){
              Abort("Invalid: Pointer to empty");
            }
          goto L1584;
        }
      if(j==comvt_UI1 ){
          fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].vt = VT_UI1",P2);
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].",P,"bVal = ",sCleanTemp,";");
          goto L1584;
        }
      if(j==comvt_UI2 ){
          fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].vt = VT_UI2",P2);
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].",P,"uiVal = ",sCleanTemp,";");
          goto L1584;
        }
      if(j==comvt_UI4 ){
          fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].vt = VT_UI4",P2);
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].",P,"ulVal = ",sCleanTemp,";");
          goto L1584;
        }
      if(j==comvt_UI8 ){
          fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].vt = VT_UI8",P2);
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].",P,"ullVal = ",sCleanTemp,";");
          goto L1584;
        }
      if(j==comvt_UINT ){
          fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].vt = VT_UINT",P2);
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].",P,"uintVal = ",sCleanTemp,";");
          goto L1584;
        }
      if(j==comvt_INT ){
          if(IsIndex==1 ){
              fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].vt = VT_I4",P2);
              fprintf(FP_WRITE,"%s%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].lVal = ",sCleanTemp,";");
            }
          else
            {
              fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].vt = VT_INT",P2);
              fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].",P,"intVal = ",sCleanTemp,";");
            }
          goto L1584;
        }
      if(j==comvt_I1 ){
          fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].vt = VT_I1",P2);
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].",P,"cVal = ",sCleanTemp,";");
          goto L1584;
        }
      if(j==comvt_I2 ){
          fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].vt = VT_I2",P2);
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].",P,"iVal = ",sCleanTemp,";");
          goto L1584;
        }
      if(j==comvt_I4 ){
          fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].vt = VT_I4",P2);
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].",P,"lVal = ",sCleanTemp,";");
          goto L1584;
        }
      if(j==comvt_I8 ){
          fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].vt = VT_I8",P2);
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].",P,"llval = ",sCleanTemp,";");
          goto L1584;
        }
      if(j==comvt_R4 ){
          fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].vt = VT_R4",P2);
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].",P,"fltVal = ",sCleanTemp,";");
          goto L1584;
        }
      if(j==comvt_R8 ){
          fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].vt = VT_R8",P2);
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].",P,"dblVal = ",sCleanTemp,";");
          goto L1584;
        }
      if(j==comvt_CY ){
          fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].vt = VT_CY",P2);
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].",P,"cyVal = ",sCleanTemp,";");
          goto L1584;
        }
      if(j==comvt_BSTR ){
          strcpy(sCleanTemp,replace(sCleanTemp,chr(92),chr(92,92)));
          strcpy(sCleanTemp,replace(sCleanTemp,chr(92,92,92),chr(92,92)));
          fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].vt = VT_BSTR",P2);
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].",P,"bstrVal = SysAllocString(L",sCleanTemp,");");
          goto L1584;
        }
      if(j==comvt_DECIMAL ){
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].vt = VT_BYREF|VT_DECIMAL;");
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].",P,"decVal = ",sCleanTemp,";");
          goto L1584;
        }
      if(j==comvt_NULL ){
          if(iArrayFlag ){
              Abort("Invalid: Array of NULLs");
            }
          if(iByrefFlag ){
              Abort("Invalid: Pointer to NULL");
            }
          goto L1584;
        }
      if(j==comvt_ERROR ){
          fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].vt = VT_ERROR",P2);
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].",P,"scode = ",sCleanTemp,";");
          goto L1584;
        }
      if(j==comvt_BOOL ){
          fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].vt = VT_BOOL",P2);
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].",P,"boolVal = ",sCleanTemp,";");
          goto L1584;
        }
      if(j==comvt_TRUE ){
          fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].vt = VT_BOOL",P2);
          fprintf(FP_WRITE,"%s%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].",P,"boolVal = VARIANT_TRUE;");
          goto L1584;
        }
      if(j==comvt_FALSE ){
          fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].vt = VT_BOOL",P2);
          fprintf(FP_WRITE,"%s%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].",P,"boolVal = VARIANT_FALSE;");
          goto L1584;
        }
      if(j==comvt_DATE ){
          fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].vt = VT_DATE",P2);
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].",P,"date = ",sCleanTemp,";");
          goto L1584;
        }
      if(j==comvt_DISPATCH ){
          fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].vt = VT_DISPATCH",P2);
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].",P,"pdispVal = ",sCleanTemp,";");
          goto L1584;
        }
      if(j==comvt_VARIANT ){
          if(!iByrefFlag&&!iArrayFlag ){
              fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  COM_PARAMS[",sTMP,"].vt = VT_VARIANT|VT_ARRAY;");
              fprintf(FP_WRITE,"%s%s%s%s%s%s\n",Scoot,"  COM_PARAMS[",sTMP,"].pvarVal = ",sCleanTemp,".pvarVal;");
            }
          else
            {
              fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,"  COM_PARAMS[",sTMP,"].vt = VT_VARIANT",P2);
              fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"  COM_PARAMS[",sTMP,"].",P,"pvarVal = ",sCleanTemp,";");
            }
          goto L1584;
        }
      if(j==comvt_UNKNOWN ){
          fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].vt = VT_UNKNOWN",P2);
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].",P,"punkVal = ",sCleanTemp,";");
          goto L1584;
        }
      if(j==comvt_PVOID ){
          fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].vt = VT_PVOID",P2);
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].",P,"byref = ",sCleanTemp,";");
          goto L1584;
        }
      if(j==comvt_STRVAR ){
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"COM_last_HR = COM_AS2WS(",sCleanTemp,");");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"if (FAILED(COM_last_HR)) {");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"  COM_HR_ErrMsg (COM_last_HR, _T(");
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,SPC,enc("Build ParamList Failed! A2W failure!"),"));");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"} else {");
          fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].vt = VT_BSTR",P2);
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"  COM_PARAMS[",sTMP,"].bstrVal = SysAllocString(COM_LPWSTR_temp);");
          fprintf(FP_WRITE,"%s%s\n",Scoot,"}");
          goto L1584;
        }
      if(j==comvt_R8_LITERAL ){
          fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].vt = VT_R8",P2);
          fprintf(FP_WRITE,"%s%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].dblVal = ",sCleanTemp,";");
          goto L1584;
        }
      if(j==comvt_OBJECT ){
          fprintf(FP_WRITE,"%s%s%s%s%s%s\n",Scoot,"VariantCopy(&COM_PARAMS[",sTMP,"], &",sCleanTemp,".pObjects[0]);");
          goto L1584;
        }
      if(j==comvt_I4_LITERAL ){
          fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].vt = VT_I4",P2);
          fprintf(FP_WRITE,"%s%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].lVal = ",sCleanTemp,";");
          goto L1584;
        }
      if(j==comvt_VOID ){
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].vt = VT_VOID;");
          fprintf(FP_WRITE,"%s%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].lVal = (void)",sCleanTemp,";");
          goto L1584;
        }
      if(j==comvt_SAFEARRAY ){
          fprintf(FP_WRITE,"%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].vt = VT_SAFEARRAY",P2);
          fprintf(FP_WRITE,"%s%s%s%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].",P,"parray = &",sCleanTemp,";");
          goto L1584;
        }
      if(j==comvt_NAMED_ARGUMENT ){
          Abort(join(3,"Named arguments are NOT supported in this version! (",ParamToken[i],")"));
          goto L1584;
        }
      if(j==comvt_CAST ){
          fprintf(FP_WRITE,"%s%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].vt = ",local_temp_str,";");
          fprintf(FP_WRITE,"%s%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].",sCleanTemp,";");
          goto L1584;
        }
      if(j==comvt_DEFAULT ){
          fprintf(FP_WRITE,"%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].vt = VT_I4;");
          fprintf(FP_WRITE,"%s%s%s%s%s%s\n",Scoot,"COM_PARAMS[",sTMP,"].lVal = (long)",sCleanTemp,";");
        }
L1584:;
    }
  return iReturn;
}

int ComParamType (char* sParam,int* iRebuild)
{
  int  varidx;
  int  k;
  struct _VARINFO*  ptVI;
  int  iBYREF_Flag;
  *iRebuild=0;
  if(sParam[0]==c_LPar ){
      return comvt_CAST;
    }
  if(iMatchWrd(sParam,"true")){
      return comvt_TRUE;
    }
  if(iMatchWrd(sParam,"false")){
      return comvt_FALSE;
    }
  if(sParam[0]==c_DblQt ){
      return comvt_BSTR;
    }
  if(IsDecimalNumber(sParam)){
      if(inchr(sParam,".")){
          return comvt_R8_LITERAL;
        }
      else
        {
          return comvt_I4_LITERAL;
        }
    }
  if(iMatchNQ(sParam,":=")>0 ){
      return comvt_NAMED_ARGUMENT;
    }
  if(IsVariableComObject(trim(Clean(sParam)))){
      return comvt_OBJECT;
    }
  if(RightStr(sParam,"#")){
      return comvt_R8;
    }
  if(RightStr(sParam,"!")){
      return comvt_R4;
    }
  if(RightStr(sParam,"$")){
      return comvt_STRVAR;
    }
  if(RightStr(sParam,"%")){
      return comvt_INT;
    }
  ptVI=NULL;
  k=CheckLocal(sParam,&(varidx));
  if(k!=vt_UNKNOWN ){
      ptVI=&(LocalVars[varidx]);
    }
  else
    {
      k=CheckGlobal(sParam,&(varidx));
      if(k!=vt_UNKNOWN ){
          ptVI=&(GlobalVars[varidx]);
        }
    }
  if(ptVI!=NULL ){