// *************************************************************
//   Created with BCX -- The BASIC To C Translator (ver 3.52b)
//      BCX (c) 1999, 2000, 2001, 2002, 2003 by Kevin Diggins
// *************************************************************
#include <windows.h>    // Win32 Header File 
#include <windowsx.h>   // Win32 Header File 
#include <commctrl.h>   // Win32 Header File 
#include <mmsystem.h>   // Win32 Header File 
#include <shellapi.h>   // Win32 Header File 
#include <shlobj.h>     // Win32 Header File 
#include <winsock2.h>   // Win32 Header File 
#include <richedit.h>   // Win32 Header File 
#include <conio.h>
#include <ctype.h>
#include <math.h>
#include <stdio.h>
#include <string.h>
#include <stddef.h>
#include <stdlib.h>
#include <setjmp.h>
#include <time.h>
#include <stdarg.h>

// *************************************************
//            User Defined Constants
// *************************************************

#define MNUIMGFLAGS LR_MONOCHROME|LR_LOADREALSIZE 
#define MAXWIDTH GetSystemMetrics (SM_CXSCREEN)
#define MAXHEIGHT GetSystemMetrics (SM_CYSCREEN)
#define IDRES_HORIZONAL 100
#define IDRES_VERTICAL 101
#define IDRES_CORNER 102
#define IDHND_HBMP 103
#define IDHND_VBMP 104
#define IDHND_CBMP 105
#define IDVLAYOUT 106
#define IDHLAYOUT 107
#define IDSLAYOUT 108
#define IDH100PX 109
#define IDH150PX 110
#define IDH200PX 111
#define IDH250PX 112
#define IDH300PX 113
#define IDH350PX 114
#define IDH400PX 115
#define IDH450PX 116
#define IDH500PX 117
#define IDH550PX 118
#define IDH600PX 119
#define IDH650PX 120
#define IDH700PX 121
#define IDH750PX 122
#define IDH800PX 123
#define IDHFULL 124
#define IDV100PX 125
#define IDV150PX 126
#define IDV200PX 127
#define IDV250PX 128
#define IDV300PX 129
#define IDV350PX 130
#define IDV400PX 131
#define IDV450PX 132
#define IDV500PX 133
#define IDV550PX 134
#define IDV600PX 135
#define IDV650PX 136
#define IDV700PX 137
#define IDV750PX 138
#define IDV800PX 139
#define IDVFULL 140
#define ID_TOPLEFT 141
#define IDMNU_EXIT 142
#define IDMNU_IMGL 143
#define IDMNU_IMGH 144
#define IDMNU_IMGV 145
#define IDMNU_IMGT 146

// *************************************************
//                System Variables
// *************************************************


// *************************************************
//            User Global Variables
// *************************************************

static HINSTANCE BCX_hInstance;
static int     BCX_ScaleX;
static int     BCX_ScaleY;
static char   AppName[2048];
static long    RULE;
static long    CURRH;
static long    CURRV;
static HWND    frmRule;
static HMENU   mnuRoot;
static HMENU   mnuOptions;
static HMENU   mnuLayout;
static HMENU   mnuHSize;
static HMENU   mnuVSize;
static HBITMAP hVbmp;
static HBITMAP hHbmp;
static HBITMAP hCbmp;
static POINT   pnt;
static RECT    tRect;
static int     x;
static int     y;
static int     w;
static int     h;
static long    q;

// *************************************************
//               Standard Macros
// *************************************************

#define Show(Window)ShowWindow(Window,SW_SHOW);
#define Hide(Window)ShowWindow(Window,SW_HIDE);


// *************************************************
//               Standard Prototypes
// *************************************************

HWND    BCX_Form(char*,int=0,int=0,int=250,int=150,int=0,int=0);
HWND    BCX_Bitmap(char*,HWND=0,int=0,int=0,int=0,int=0,int=0,int=0,int=0,int=0);
void    Center (HWND);
char*   BCX_TmpStr(size_t);
char*   AppExeName(void);

// *************************************************
//               User's Prototypes
// *************************************************

void    Form_Setup (void);
void    MenuSetup (void);
void    Skin (void);
void    Layout (int);
void    CheckMark (HMENU, long);
void    Nudge (void);
void    ReSizeH (int);
void    ReSizeV (int);
void    TopMost (HWND);
void    PreLoad (void);
BOOL    IsLoaded (char *);
void    FormLoad (void);
LRESULT CALLBACK WndProc (HWND, UINT, WPARAM, LPARAM);

// -------------------------------------------------------------- 
//  App:      Screen Ruler v.1.00 
//  Compiler: BCX v3.52b 
//  Author:   Michael S. Sanders 
//  Email:    mjs@nts-online.net 
//  Licnese:  Use as you like understanding if your break anything 
//            you get to keep both pieces |-) 
// -------------------------------------------------------------- 
//**********************************


int WINAPI WinMain(HINSTANCE hInst,HINSTANCE hPrev,LPSTR CmdLine,int CmdShow)
{
 WNDCLASS Wc;
 MSG      Msg;
 // *****************************
 strcpy(AppName,"Screen Ruler");
 //***************************************
 // Programmer has selected to use pixels
 //***************************************
 BCX_ScaleX       = 1;
 BCX_ScaleY       = 1;
 BCX_hInstance    =  hInst;
 //*****************************
 Wc.style         =  CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
 Wc.lpfnWndProc   =  WndProc;
 Wc.cbClsExtra    =  0;
 Wc.cbWndExtra    =  0;
 Wc.hInstance     =  hInst;
 Wc.hIcon         =  LoadIcon(hInst,MAKEINTRESOURCE(99));
 Wc.hCursor       =  LoadCursor(NULL,IDC_ARROW);
 Wc.hbrBackground =  (HBRUSH)(COLOR_BTNFACE+1);
 Wc.lpszMenuName  =  NULL;
 Wc.lpszClassName =  AppName;
 RegisterClass(&Wc);

 INITCOMMONCONTROLSEX iccex;
 iccex.dwSize = sizeof(INITCOMMONCONTROLSEX);
 iccex.dwICC  = ICC_LISTVIEW_CLASSES |
                ICC_TREEVIEW_CLASSES |
                ICC_BAR_CLASSES      |
                ICC_TAB_CLASSES      |
                ICC_UPDOWN_CLASS     |
                ICC_PROGRESS_CLASS   |
                ICC_DATE_CLASSES;
 InitCommonControlsEx(&iccex);

 //*****************************
 FormLoad();
 //*****************************
 while(GetMessage(&Msg,NULL,0,0))
   {
   if(!IsWindow(GetActiveWindow()) ||
      !IsDialogMessage(GetActiveWindow(),&Msg))
     {
       TranslateMessage(&Msg);
       DispatchMessage(&Msg);
     }
   }
 return Msg.wParam;
}


#pragma optimize(1)
// $COMPILER  "c:\lcc\bin\lc.exe" 
// $LINKER    "c:\lcc\bin\lcclnk.exe" 
// -------------------------------------------------------------- 
//  Includes 
// -------------------------------------------------------------- 
// -------------------------------------------------------------- 
//  App:      Screen Ruler v.1.00 
//  Compiler: BCX v3.52b 
//  Author:   Michael S. Sanders 
//  Email:    mjs@nts-online.net 
//  Licnese:  Use as you like understanding if your break anything 
//            you get to keep both pieces |-) 
// -------------------------------------------------------------- 
// -------------------------------------------------------------- 
// -------------------------------------------------------------- 
// -------------------------------------------------------------- 
// -------------------------------------------------------------- 
// -------------------------------------------------------------- 
// -------------------------------------------------------------- 
// -------------------------------------------------------------- 
// -------------------------------------------------------------- 
// -------------------------------------------------------------- 
// -------------------------------------------------------------- 
//  App:      Screen Ruler v.1.00 
//  Compiler: BCX v3.52b 
//  Author:   Michael S. Sanders 
//  Email:    mjs@nts-online.net 
//  Licnese:  Use as you like understanding if your break anything 
//            you get to keep both pieces |-) 
// -------------------------------------------------------------- 
// -------------------------------------------------------------- 
// -------------------------------------------------------------- 
// -------------------------------------------------------------- 
//  Constants 
// -------------------------------------------------------------- 
// -------------------------------------------------------------- 
//  Top Level Declarations 
// -------------------------------------------------------------- 
// -------------------------------------------------------------- 
// -------------------------------------------------------------- 

// *************************************************
//               Run Time Functions
// *************************************************

char *BCX_TmpStr (size_t Bites)
{
 static int   StrCnt;
 static char *StrFunc[2048];
 StrCnt=(StrCnt + 1) & 2047;
 if(StrFunc[StrCnt])free(StrFunc[StrCnt]);
 return StrFunc[StrCnt]=(char*)calloc(Bites+128,1);
}


char *AppExeName (void)
{
 char *temp = BCX_TmpStr(1024);
 char *strtmp = BCX_TmpStr(1024);
 GetModuleFileName(GetModuleHandle(NULL),temp,1024);
 for(register int i = strlen(temp); i > 0 ; i--)
 {
  if (temp[i] == 0x5C)
   {
    strcpy(strtmp,&temp[i+1]);
    break;
   }
 }
 return strtmp;
}


void Center (HWND hWnd)
{
  RECT  DesktopArea;
  RECT  rc;
  SystemParametersInfo(SPI_GETWORKAREA,0,&DesktopArea,0);
  GetWindowRect(hWnd,&rc);
  SetWindowPos(hWnd,HWND_TOP,
  ((DesktopArea.right-DesktopArea.left)-(rc.right-rc.left))/2+
  DesktopArea.left,((DesktopArea.bottom-DesktopArea.top)-
  (rc.bottom-rc.top))/2+DesktopArea.top,0,0,SWP_NOSIZE);
}


HWND BCX_Form
( char *Caption,
 int X,
 int Y,
 int W,
 int H,
 int Style,
 int Exstyle)
{
 HWND  A;
 if(!Style)
 {
 Style= WS_MINIMIZEBOX  |
        WS_SIZEBOX      |
        WS_CAPTION      |
        WS_MAXIMIZEBOX  |
        WS_POPUP        |
        WS_SYSMENU;
 }
 A = CreateWindowEx(Exstyle,AppName,Caption,
 Style,
 X*BCX_ScaleX,
 Y*BCX_ScaleY,
 (4+W)*BCX_ScaleX,
 (12+H)*BCX_ScaleY,
 NULL,(HMENU)NULL,BCX_hInstance,NULL);
 SendMessage(A,(UINT)WM_SETFONT,(WPARAM)GetStockObject
 (DEFAULT_GUI_FONT),(LPARAM)MAKELPARAM(FALSE,0));
 return A;
}


HWND BCX_Bitmap
(char* Text,HWND hWnd,int id,int X,int Y,int W,int H,int Res,int Style,int Exstyle)
{
 HWND  A;
 HBITMAP hBitmap;
 if(!Style)
 {
  Style=WS_CHILD | WS_VISIBLE | SS_BITMAP | WS_TABSTOP;
 }
 A = CreateWindowEx(Exstyle,"static",NULL,Style,
     X*BCX_ScaleX, Y*BCX_ScaleY, 0, 0,
     hWnd,(HMENU)id,BCX_hInstance,NULL);
  if(!Res)
    hBitmap=LoadImage(0,Text,IMAGE_BITMAP,0,0,    LR_LOADFROMFILE|LR_CREATEDIBSECTION);
  else
    hBitmap=LoadImage(GetModuleHandle(0),MAKEINTRESOURCE(Res),
    IMAGE_BITMAP,0,0,LR_CREATEDIBSECTION);
 SendMessage(A,(UINT)STM_SETIMAGE,(WPARAM)IMAGE_BITMAP,(LPARAM)hBitmap);
 if(W||H) SetWindowPos(A,HWND_TOP,X,Y,W,H,SWP_DRAWFRAME);
 return A;
}



// ************************************
//       User Subs and Functions
// ************************************


void Form_Setup (void)
{
// -------------------------------------------------------------- 
  frmRule=BCX_Form("Screen Ruler",0,0,3051,3051,WS_POPUP,WS_EX_TOOLWINDOW);
  hCbmp=BCX_Bitmap("",frmRule,IDHND_CBMP,0,0,21,21,IDRES_CORNER);
  hHbmp=BCX_Bitmap("",frmRule,IDHND_HBMP,0,0,3051,21,IDRES_HORIZONAL);
  hVbmp=BCX_Bitmap("",frmRule,IDHND_VBMP,0,0,21,3051,IDRES_VERTICAL);
}


void MenuSetup (void)
{
// -------------------------------------------------------------- 
  static  HBITMAP  mnuImgL;
  memset(&mnuImgL,0,sizeof(mnuImgL));
  static  HBITMAP  mnuImgH;
  memset(&mnuImgH,0,sizeof(mnuImgH));
  static  HBITMAP  mnuImgV;
  memset(&mnuImgV,0,sizeof(mnuImgV));
  static  HBITMAP  mnuImgT;
  memset(&mnuImgT,0,sizeof(mnuImgT));
  mnuRoot=CreateMenu();
  mnuOptions=CreateMenu();
  mnuLayout=CreateMenu();
  mnuHSize=CreateMenu();
  mnuVSize=CreateMenu();
//  Create Layout submenu items 
  InsertMenu(mnuOptions,0,MF_POPUP,(UINT)mnuLayout,"&Layout");
  AppendMenu(mnuLayout,MF_STRING,IDHLAYOUT,"&Horizontal");
  AppendMenu(mnuLayout,MF_STRING,IDVLAYOUT,"&Vertical");
  AppendMenu(mnuLayout,MF_STRING,IDSLAYOUT,"&Square");
//  Create Size submenu items 
  InsertMenu(mnuOptions,1,MF_POPUP,(UINT)mnuHSize,"&HSize");
  AppendMenu(mnuHSize,MF_STRING,IDH100PX,"&100 px");
  AppendMenu(mnuHSize,MF_STRING,IDH150PX,"1&50 px");
  AppendMenu(mnuHSize,MF_STRING,IDH200PX,"&200 px");
  AppendMenu(mnuHSize,MF_STRING,IDH250PX,"2&50 px");
  AppendMenu(mnuHSize,MF_STRING,IDH300PX,"&300 px");
  AppendMenu(mnuHSize,MF_STRING,IDH350PX,"3&50 px");
  AppendMenu(mnuHSize,MF_STRING,IDH400PX,"&400 px");
  AppendMenu(mnuHSize,MF_STRING,IDH450PX,"4&50 px");
  AppendMenu(mnuHSize,MF_STRING,IDH500PX,"&500 px");
  AppendMenu(mnuHSize,MF_STRING,IDH550PX,"5&50 px");
  AppendMenu(mnuHSize,MF_STRING,IDH600PX,"&600 px");
  AppendMenu(mnuHSize,MF_STRING,IDH650PX,"6&50 px");
  AppendMenu(mnuHSize,MF_STRING,IDH700PX,"&700 px");
  AppendMenu(mnuHSize,MF_STRING,IDH750PX,"7&50 px");
  AppendMenu(mnuHSize,MF_STRING,IDH800PX,"&800 px");
  AppendMenu(mnuHSize,MF_SEPARATOR,0,"");
  AppendMenu(mnuHSize,MF_STRING,IDHFULL,"&Screen Width");
  InsertMenu(mnuOptions,2,MF_POPUP,(UINT)mnuVSize,"&VSize");
  AppendMenu(mnuVSize,MF_STRING,IDV100PX,"&100 px");
  AppendMenu(mnuVSize,MF_STRING,IDV150PX,"1&50 px");
  AppendMenu(mnuVSize,MF_STRING,IDV200PX,"&200 px");
  AppendMenu(mnuVSize,MF_STRING,IDV250PX,"2&50 px");
  AppendMenu(mnuVSize,MF_STRING,IDV300PX,"&300 px");
  AppendMenu(mnuVSize,MF_STRING,IDV350PX,"3&50 px");
  AppendMenu(mnuVSize,MF_STRING,IDV400PX,"&400 px");
  AppendMenu(mnuVSize,MF_STRING,IDV450PX,"4&50 px");
  AppendMenu(mnuVSize,MF_STRING,IDV500PX,"&500 px");
  AppendMenu(mnuVSize,MF_STRING,IDV550PX,"5&50 px");
  AppendMenu(mnuVSize,MF_STRING,IDV600PX,"&600 px");
  AppendMenu(mnuVSize,MF_STRING,IDV650PX,"6&50 px");
  AppendMenu(mnuVSize,MF_STRING,IDV700PX,"&700 px");
  AppendMenu(mnuVSize,MF_STRING,IDV750PX,"7&50 px");
  AppendMenu(mnuVSize,MF_STRING,IDV800PX,"&800 px");
  AppendMenu(mnuVSize,MF_SEPARATOR,0,"");
  AppendMenu(mnuVSize,MF_STRING,IDVFULL,"&Screen Height");
  AppendMenu(mnuOptions,MF_STRING,ID_TOPLEFT,"&Top Left");
  AppendMenu(mnuOptions,MF_SEPARATOR,0,"");
  AppendMenu(mnuOptions,MF_STRING,IDMNU_EXIT,"E&xit");
  mnuImgL=LoadImage(BCX_hInstance,MAKEINTRESOURCE(IDMNU_IMGL),IMAGE_BITMAP,0,0,MNUIMGFLAGS);
  SetMenuItemBitmaps(mnuOptions,0,MF_BYPOSITION,mnuImgL,0);
  mnuImgH=LoadImage(BCX_hInstance,MAKEINTRESOURCE(IDMNU_IMGH),IMAGE_BITMAP,0,0,MNUIMGFLAGS);
  SetMenuItemBitmaps(mnuOptions,1,MF_BYPOSITION,mnuImgH,0);
  mnuImgV=LoadImage(BCX_hInstance,MAKEINTRESOURCE(IDMNU_IMGV),IMAGE_BITMAP,0,0,MNUIMGFLAGS);
  SetMenuItemBitmaps(mnuOptions,2,MF_BYPOSITION,mnuImgV,0);
  mnuImgT=LoadImage(BCX_hInstance,MAKEINTRESOURCE(IDMNU_IMGT),IMAGE_BITMAP,0,0,MNUIMGFLAGS);
  SetMenuItemBitmaps(mnuOptions,3,MF_BYPOSITION,mnuImgT,0);
//  Attach menu items to main menu 
  InsertMenu(mnuRoot,0,MF_POPUP,(UINT)mnuOptions,"");
}


void Skin (void)
{
// -------------------------------------------------------------- 
  static  HRGN  hRgnOuter;
  memset(&hRgnOuter,0,sizeof(hRgnOuter));
  static  HRGN  hRgnInner;
  memset(&hRgnInner,0,sizeof(hRgnInner));
  static  HRGN  hRgnComb;
  memset(&hRgnComb,0,sizeof(hRgnComb));
  GetWindowRect(frmRule,&tRect);
  h=tRect.bottom-tRect.top;
  w=tRect.right-tRect.left;
  hRgnComb=CreateRectRgn(0,0,0,0);
  hRgnOuter=CreateRectRgn(tRect.left,tRect.top,w,h);
  hRgnInner=CreateRectRgn(tRect.left+21,tRect.top+21,w,h);
  CombineRgn(hRgnComb,hRgnOuter,hRgnInner,RGN_DIFF);
  SetWindowRgn(frmRule,hRgnComb,FALSE);
  SetWindowPos(frmRule,0,0,0,w,h,SWP_NOMOVE|SWP_NOZORDER);
  InvalidateRgn(frmRule,hRgnComb,FALSE);
  DeleteObject(hRgnComb);
  DeleteObject(hRgnOuter);
  DeleteObject(hRgnInner);
}


void Layout (int Mode)
{
// -------------------------------------------------------------- 
  GetWindowRect(frmRule,&tRect);
  w=tRect.right-tRect.left;
  h=tRect.bottom-tRect.top;
  while(1)
  {
  if(Mode==0)
    {
      if(RULE==0)
        {
          return;
        }
// If RULE = 1 Then ReSizeH(h -1) 
      ReSizeV(20);
      Hide(hVbmp);
      Hide(hCbmp);
      Show(hHbmp);
//  checkmark horizontal layout 
      CheckMenuItem(mnuLayout,IDHLAYOUT,MF_CHECKED);
      CheckMenuItem(mnuLayout,IDVLAYOUT,MF_UNCHECKED);
      CheckMenuItem(mnuLayout,IDSLAYOUT,MF_UNCHECKED);
//  disable VSize menu 
      EnableMenuItem(mnuOptions,2,MF_BYPOSITION|MF_GRAYED);
//  enable HSize menu 
      EnableMenuItem(mnuOptions,1,MF_BYPOSITION|MF_ENABLED);
//  checkmark current horizontal size 
      SendMessage(frmRule,(UINT)WM_COMMAND,(WPARAM)CURRH,(LPARAM)0);
      RULE=0;
      break;
    }
  if(Mode==1)
    {
      if(RULE==1)
        {
          return;
        }
// If RULE = 0 Then ReSizeV(w -1) 
      ReSizeH(20);
      Hide(hHbmp);
      Hide(hCbmp);
      Show(hVbmp);
//  checkmark vertical layout 
      CheckMenuItem(mnuLayout,IDHLAYOUT,MF_UNCHECKED);
      CheckMenuItem(mnuLayout,IDVLAYOUT,MF_CHECKED);
      CheckMenuItem(mnuLayout,IDSLAYOUT,MF_UNCHECKED);
//  disable HSize menu 
      EnableMenuItem(mnuOptions,1,MF_BYPOSITION|MF_GRAYED);
//  enable VSize menu 
      EnableMenuItem(mnuOptions,2,MF_BYPOSITION|MF_ENABLED);
//  checkmark current vertical size 
      SendMessage(frmRule,(UINT)WM_COMMAND,(WPARAM)CURRV,(LPARAM)0);
      RULE=1;
      break;
    }
  if(Mode==2)
    {
      while(1)
      {
      if(RULE==(-1))
        {
          q=351;
          break;
        }
      if(RULE==0)
        {
          q=w;
          break;
        }
      if(RULE==1)
        {
          q=h;
          break;
        }
      if(RULE==2)
        {
          return;
        }
      break;
      }
    SetWindowPos(frmRule,0,0,0,q,q,SWP_NOMOVE|SWP_NOZORDER);
    Show(hHbmp);
    Show(hVbmp);
    Show(hCbmp);
    Nudge();
//  check mark square layout 
    CheckMenuItem(mnuLayout,IDHLAYOUT,MF_UNCHECKED);
    CheckMenuItem(mnuLayout,IDVLAYOUT,MF_UNCHECKED);
    CheckMenuItem(mnuLayout,IDSLAYOUT,MF_CHECKED);
//  enable both HSize/VSize menus 
    EnableMenuItem(mnuOptions,1,MF_BYPOSITION|MF_ENABLED);
    EnableMenuItem(mnuOptions,2,MF_BYPOSITION|MF_ENABLED);
//  checkmark both current horizontal/vertical size 
    SendMessage(frmRule,(UINT)WM_COMMAND,(WPARAM)CURRH,(LPARAM)0);
    SendMessage(frmRule,(UINT)WM_COMMAND,(WPARAM)CURRV,(LPARAM)0);
    RULE=2;
  }
break;
}
}


void CheckMark (HMENU MNU, long ID)
{
// -------------------------------------------------------------- 
  while(1)
  {
  if(MNU==mnuHSize)
    {
      for( q=IDH100PX;q<=IDHFULL;q++)
        {
          if(q!=ID)
            {
              CheckMenuItem(mnuHSize,q,MF_UNCHECKED);
            }
          else
            {
              CheckMenuItem(MNU,q,MF_CHECKED);
            }
        }
      CURRH=ID;
      break;
    }
  if(MNU==mnuVSize)
    {
      for( q=IDV100PX;q<=IDVFULL;q++)
        {
          if(q!=ID)
            {
              CheckMenuItem(mnuVSize,q,MF_UNCHECKED);
            }
          else
            {
              CheckMenuItem(MNU,q,MF_CHECKED);
            }
        }
      CURRV=ID;
    }
  break;
  }
}


void Nudge (void)
{
// -------------------------------------------------------------- 
  GetWindowRect(frmRule,&tRect);
  w=tRect.right-tRect.left;
  if((w+tRect.left)>MAXWIDTH)
    {
      SetWindowPos(frmRule,0,MAXWIDTH-w,tRect.top,0,0,SWP_NOSIZE|SWP_NOZORDER);
    }
  GetWindowRect(frmRule,&tRect);
  h=tRect.bottom-tRect.top;
  if((tRect.top+h)>MAXHEIGHT)
    {
      SetWindowPos(frmRule,0,tRect.left,MAXHEIGHT-h,0,0,SWP_NOSIZE|SWP_NOZORDER);
    }
  GetWindowRect(frmRule,&tRect);
  if(tRect.left<0)
    {
      SetWindowPos(frmRule,0,0,tRect.top,0,0,SWP_NOSIZE|SWP_NOZORDER);
    }
  GetWindowRect(frmRule,&tRect);
  if(tRect.top<0)
    {
      SetWindowPos(frmRule,0,tRect.left,0,0,0,SWP_NOSIZE|SWP_NOZORDER);
    }
}


void ReSizeH (int iWidth)
{
// -------------------------------------------------------------- 
  GetWindowRect(frmRule,&tRect);
  w=iWidth+1;
  h=tRect.bottom-tRect.top;
  SetWindowPos(frmRule,0,0,0,w,h,SWP_NOMOVE|SWP_NOZORDER);
  Nudge();
}


void ReSizeV (int iHeight)
{
// -------------------------------------------------------------- 
  GetWindowRect(frmRule,&tRect);
  w=tRect.right-tRect.left;
  h=iHeight+1;
  SetWindowPos(frmRule,0,0,0,w,h,SWP_NOMOVE|SWP_NOZORDER);
  Nudge();
}


void TopMost (HWND hWnd)
{
// -------------------------------------------------------------- 
  SetWindowPos(hWnd,HWND_TOPMOST,0,0,0,0,SWP_NOACTIVATE|SWP_NOSIZE|SWP_NOMOVE);
}


void PreLoad (void)
{
// -------------------------------------------------------------- 
  if(IsLoaded(AppExeName()))
    {
      MessageBox (GetActiveWindow(),"Another instance of Screen Ruler detected - aborting","Already loaded!",MB_OK);
      fflush(stdout);
      ExitProcess(0);
    }
}


BOOL IsLoaded (char *UniqueId)
{
// -------------------------------------------------------------- 
//  Mutex's are automatically closed/deleted 
//  when the creating process terminates 
// CONSTant MUTEX_ALL_ACCESS = 0x1f0001 
// DIM hMtx As HANDLE 
  if(OpenMutex(MUTEX_ALL_ACCESS,0,UniqueId)!=0)
    {
      return       TRUE;
    }
  else
    {
      CreateMutex(0,1,UniqueId);
      return       FALSE;
    }
}


void FormLoad (void)
{
// -------------------------------------------------------------- 
  RULE=(-1);
  CURRH=IDH350PX;
  CURRV=IDV350PX;
//  start building our frmRule 
  Form_Setup();
  MenuSetup();
//  load initial settings 
  Skin();
  Layout(2);
  CheckMenuItem(mnuHSize,IDH350PX,MF_CHECKED);
  CheckMenuItem(mnuVSize,IDV350PX,MF_CHECKED);
  CheckMenuItem(mnuLayout,IDSLAYOUT,MF_CHECKED);
//  lets rock! 
  Center(frmRule);
  TopMost(frmRule);
  Show(frmRule);
}


LRESULT CALLBACK WndProc (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam)
{
// -------------------------------------------------------------- 
  while(1)
  {
  if(Msg==WM_CREATE)
    {
      PreLoad();
      break;
    }
  if(Msg==WM_CONTEXTMENU)
    {
      GetCursorPos(&pnt);
      TrackPopupMenuEx(mnuOptions,TPM_LEFTALIGN|TPM_RIGHTBUTTON,pnt.x,pnt.y,hWnd,NULL);
      PostMessage(frmRule,WM_NULL,0,0);
      break;
    }
  if(Msg==WM_LBUTTONDOWN)
    {
      SetCapture(frmRule);
      x=LOWORD(lParam);
      y=HIWORD(lParam);
      break;
    }
  if(Msg==WM_MOUSEMOVE)
    {
      if(wParam==MK_LBUTTON)
        {
          GetCursorPos(&pnt);
          SetWindowPos(frmRule,0,pnt.x-x,pnt.y-y,0,0,SWP_NOSIZE|SWP_NOZORDER);
        }
      break;
    }
  if(Msg==WM_LBUTTONUP||Msg==WM_RBUTTONUP)
    {
      ReleaseCapture();
      Nudge();
      break;
    }
  if(Msg==WM_COMMAND)
    {
      while(1)
      {
      if(LOWORD(wParam)==IDMNU_EXIT)
        {
          SendMessage(frmRule,(UINT)WM_CLOSE,(WPARAM)0,(LPARAM)0);
          break;
        }
      if(LOWORD(wParam)==IDH100PX)
        {
          ReSizeH(100);
          CheckMark(mnuHSize,IDH100PX);
          break;
        }
      if(LOWORD(wParam)==IDH150PX)
        {
          ReSizeH(150);
          CheckMark(mnuHSize,IDH150PX);
          break;
        }
      if(LOWORD(wParam)==IDH200PX)
        {
          ReSizeH(200);
          CheckMark(mnuHSize,IDH200PX);
          break;
        }
      if(LOWORD(wParam)==IDH250PX)
        {
          ReSizeH(250);
          CheckMark(mnuHSize,IDH250PX);
          break;
        }
      if(LOWORD(wParam)==IDH300PX)
        {
          ReSizeH(300);
          CheckMark(mnuHSize,IDH300PX);
          break;
        }
      if(LOWORD(wParam)==IDH350PX)
        {
          ReSizeH(350);
          CheckMark(mnuHSize,IDH350PX);
          break;
        }
      if(LOWORD(wParam)==IDH400PX)
        {
          ReSizeH(400);
          CheckMark(mnuHSize,IDH400PX);
          break;
        }
      if(LOWORD(wParam)==IDH450PX)
        {
          ReSizeH(450);
          CheckMark(mnuHSize,IDH450PX);
          break;
        }
      if(LOWORD(wParam)==IDH500PX)
        {
          ReSizeH(500);
          CheckMark(mnuHSize,IDH500PX);
          break;
        }
      if(LOWORD(wParam)==IDH550PX)
        {
          ReSizeH(550);
          CheckMark(mnuHSize,IDH550PX);
          break;
        }
      if(LOWORD(wParam)==IDH600PX)
        {
          ReSizeH(600);
          CheckMark(mnuHSize,IDH600PX);
          break;
        }
      if(LOWORD(wParam)==IDH650PX)
        {
          ReSizeH(650);
          CheckMark(mnuHSize,IDH650PX);
          break;
        }
      if(LOWORD(wParam)==IDH700PX)
        {
          ReSizeH(700);
          CheckMark(mnuHSize,IDH700PX);
          break;
        }
      if(LOWORD(wParam)==IDH750PX)
        {
          ReSizeH(750);
          CheckMark(mnuHSize,IDH750PX);
          break;
        }
      if(LOWORD(wParam)==IDH800PX)
        {
          ReSizeH(800);
          CheckMark(mnuHSize,IDH800PX);
          break;
        }
      if(LOWORD(wParam)==IDHFULL)
        {
          ReSizeH(MAXWIDTH);
          CheckMark(mnuHSize,IDHFULL);
// -- 
          break;
        }
      if(LOWORD(wParam)==IDV100PX)
        {
          ReSizeV(100);
          CheckMark(mnuVSize,IDV100PX);
          break;
        }
      if(LOWORD(wParam)==IDV150PX)
        {
          ReSizeV(150);
          CheckMark(mnuVSize,IDV150PX);
          break;
        }
      if(LOWORD(wParam)==IDV200PX)
        {
          ReSizeV(200);
          CheckMark(mnuVSize,IDV200PX);
          break;
        }
      if(LOWORD(wParam)==IDV250PX)
        {
          ReSizeV(250);
          CheckMark(mnuVSize,IDV250PX);
          break;
        }
      if(LOWORD(wParam)==IDV300PX)
        {
          ReSizeV(300);
          CheckMark(mnuVSize,IDV300PX);
          break;
        }
      if(LOWORD(wParam)==IDV350PX)
        {
          ReSizeV(350);
          CheckMark(mnuVSize,IDV350PX);
          break;
        }
      if(LOWORD(wParam)==IDV400PX)
        {
          ReSizeV(400);
          CheckMark(mnuVSize,IDV400PX);
          break;
        }
      if(LOWORD(wParam)==IDV450PX)
        {
          ReSizeV(450);
          CheckMark(mnuVSize,IDV450PX);
          break;
        }
      if(LOWORD(wParam)==IDV500PX)
        {
          ReSizeV(500);
          CheckMark(mnuVSize,IDV500PX);
          break;
        }
      if(LOWORD(wParam)==IDV550PX)
        {
          ReSizeV(550);
          CheckMark(mnuVSize,IDV550PX);
          break;
        }
      if(LOWORD(wParam)==IDV600PX)
        {
          ReSizeV(600);
          CheckMark(mnuVSize,IDV600PX);
          break;
        }
      if(LOWORD(wParam)==IDV650PX)
        {
          ReSizeV(650);
          CheckMark(mnuVSize,IDV650PX);
          break;
        }
      if(LOWORD(wParam)==IDV700PX)
        {
          ReSizeV(700);
          CheckMark(mnuVSize,IDV700PX);
          break;
        }
      if(LOWORD(wParam)==IDV750PX)
        {
          ReSizeV(750);
          CheckMark(mnuVSize,IDV750PX);
          break;
        }
      if(LOWORD(wParam)==IDV800PX)
        {
          ReSizeV(800);
          CheckMark(mnuVSize,IDV800PX);
          break;
        }
      if(LOWORD(wParam)==IDVFULL)
        {
          ReSizeV(MAXHEIGHT);
          CheckMark(mnuVSize,IDVFULL);
          break;
        }
      if(LOWORD(wParam)==IDHLAYOUT)
        {
          Layout(0);
          break;
        }
      if(LOWORD(wParam)==IDVLAYOUT)
        {
          Layout(1);
          break;
        }
      if(LOWORD(wParam)==IDSLAYOUT)
        {
          Layout(2);
          break;
        }
      if(LOWORD(wParam)==ID_TOPLEFT)
        {
          SetWindowPos(frmRule,0,0,0,w,h,SWP_NOSIZE|SWP_NOZORDER);
        }
      break;
      }
    break;
  }
if(Msg==WM_CLOSE)
  {
    DestroyWindow(frmRule);
    break;
  }
if(Msg==WM_DESTROY)
  {
    PostQuitMessage(0);
    break;
  }
if(Msg==WM_CTLCOLORSTATIC)
  {
  }
break;
}
 if(Msg==WM_DESTROY)
 {
   UnregisterClass(AppName,BCX_hInstance);
   PostQuitMessage(0);
 }
return DefWindowProc(hWnd,Msg,wParam,lParam);
}


