'--------------------------------------------------------------
' App:      Screen Ruler v.1.00
' Compiler: BCX v3.52b
' Author:   Michael S. Sanders
' Email:    mjs@nts-online.net
' Licnese:  Use as you like understanding if your break anything
'           you get to keep both pieces |-)
'--------------------------------------------------------------

GUI "Screen Ruler", PIXELS, ICON, 99

$OPTIMIZER ON
'$COMPILER  "c:\lcc\bin\lc.exe"
'$LINKER    "c:\lcc\bin\lcclnk.exe"

'--------------------------------------------------------------
' Includes
'--------------------------------------------------------------
$INCLUDE  "include\functions.bcx"
$INCLUDE  "include\isloaded.bcx"

'--------------------------------------------------------------
' Constants
'--------------------------------------------------------------
CONST MAXWIDTH        = GetSystemMetrics(SM_CXSCREEN)
CONST MAXHEIGHT       = GetSystemMetrics(SM_CYSCREEN)
CONST IDRES_HORIZONAL = 100
CONST IDRES_VERTICAL  = 101
CONST IDRES_CORNER    = 102
CONST IDHND_HBMP      = 103
CONST IDHND_VBMP      = 104
CONST IDHND_CBMP      = 105
CONST IDVLAYOUT       = 106
CONST IDHLAYOUT       = 107
CONST IDSLAYOUT       = 108
CONST IDH100PX        = 109
CONST IDH150PX        = 110
CONST IDH200PX        = 111
CONST IDH250PX        = 112
CONST IDH300PX        = 113
CONST IDH350PX        = 114
CONST IDH400PX        = 115
CONST IDH450PX        = 116
CONST IDH500PX        = 117
CONST IDH550PX        = 118
CONST IDH600PX        = 119
CONST IDH650PX        = 120
CONST IDH700PX        = 121
CONST IDH750PX        = 122
CONST IDH800PX        = 123
CONST IDHFULL         = 124
CONST IDV100PX        = 125
CONST IDV150PX        = 126
CONST IDV200PX        = 127
CONST IDV250PX        = 128
CONST IDV300PX        = 129
CONST IDV350PX        = 130
CONST IDV400PX        = 131
CONST IDV450PX        = 132
CONST IDV500PX        = 133
CONST IDV550PX        = 134
CONST IDV600PX        = 135
CONST IDV650PX        = 136
CONST IDV700PX        = 137
CONST IDV750PX        = 138
CONST IDV800PX        = 139
CONST IDVFULL         = 140
CONST ID_TOPLEFT      = 141
CONST IDMNU_EXIT      = 142
CONST IDMNU_IMGL      = 143
CONST IDMNU_IMGH      = 144
CONST IDMNU_IMGV      = 145
CONST IDMNU_IMGT      = 146

'--------------------------------------------------------------
' Top Level Declarations
'--------------------------------------------------------------
STATIC RULE AS LONG
STATIC CURRH AS LONG
STATIC CURRV AS LONG

DIM frmRule       AS CONTROL
DIM mnuRoot       AS HMENU
DIM mnuOptions    AS HMENU
DIM mnuLayout     AS HMENU
DIM mnuHSize      AS HMENU
DIM mnuVSize      AS HMENU

DIM hVbmp         AS HBITMAP
DIM hHbmp         AS HBITMAP
DIM hCbmp         AS HBITMAP

DIM pnt           AS POINT
DIM tRect         AS RECT
DIM x, y, w, h, q AS LONG

'--------------------------------------------------------------
Sub FORMLOAD
'--------------------------------------------------------------
RULE = (-1)
CURRH = IDH350PX
CURRV = IDV350PX

' start building our frmRule
Form_Setup()
MenuSetup()

' load initial settings
Skin()
Layout(2)

CheckMenuItem(mnuHSize, IDH350PX, MF_CHECKED)
CheckMenuItem(mnuVSize, IDV350PX, MF_CHECKED)
CheckMenuItem(mnuLayout, IDSLAYOUT, MF_CHECKED)

' lets rock!
CENTER(frmRule)
TopMost(frmRule)
SHOW(frmRule)
End Sub

'--------------------------------------------------------------
BEGIN EVENTS
'--------------------------------------------------------------

Select CASE CBMSG
CASE WM_CREATE
PreLoad()

CASE WM_CONTEXTMENU
GetCursorPos(&pnt)
TrackPopupMenuEx(mnuOptions, TPM_LEFTALIGN|TPM_RIGHTBUTTON, pnt.x, pnt.y, hWnd, NULL)
PostMessage(frmRule, WM_NULL, 0, 0)

Case WM_LBUTTONDOWN
SetCapture(frmRule)
x = LOWORD(lParam)
y = HIWORD(lParam)

Case WM_MOUSEMOVE
If  wParam = MK_LBUTTON Then
    GetCursorPos(&pnt)
    SetWindowPos(frmRule, 0, pnt.x - x, pnt.y - y, 0, 0, SWP_NOSIZE|SWP_NOZORDER)
End If
    
Case WM_LBUTTONUP, WM_RBUTTONUP
ReleaseCapture()
Nudge()
  
Case WM_COMMAND
Select Case CBCTL
    Case IDMNU_EXIT
    SendMessage(frmRule, WM_CLOSE,0,0)

    CASE IDH100PX
    ReSizeH(100)
    CheckMark(mnuHSize, IDH100PX)
 
    CASE IDH150PX
    ReSizeH(150)
    CheckMark(mnuHSize, IDH150PX)

    CASE IDH200PX
    ReSizeH(200)
    CheckMark(mnuHSize, IDH200PX)

    CASE IDH250PX
    ReSizeH(250)
    CheckMark(mnuHSize, IDH250PX)

    CASE IDH300PX
    ReSizeH(300)
    CheckMark(mnuHSize, IDH300PX)

    CASE IDH350PX
    ReSizeH(350)
    CheckMark(mnuHSize, IDH350PX)

    CASE IDH400PX
    ReSizeH(400)
    CheckMark(mnuHSize, IDH400PX)

    CASE IDH450PX
    ReSizeH(450)
    CheckMark(mnuHSize, IDH450PX)

    CASE IDH500PX
    ReSizeH(500)
    CheckMark(mnuHSize, IDH500PX)

    CASE IDH550PX
    ReSizeH(550)
    CheckMark(mnuHSize, IDH550PX)

    CASE IDH600PX
    ReSizeH(600)
    CheckMark(mnuHSize, IDH600PX)

    CASE IDH650PX
    ReSizeH(650)
    CheckMark(mnuHSize, IDH650PX)

    CASE IDH700PX
    ReSizeH(700)
    CheckMark(mnuHSize, IDH700PX)

    CASE IDH750PX
    ReSizeH(750)
    CheckMark(mnuHSize, IDH750PX)

    CASE IDH800PX
    ReSizeH(800)
    CheckMark(mnuHSize, IDH800PX)

    CASE IDHFULL
    ReSizeH(MAXWIDTH)
    CheckMark(mnuHSize, IDHFULL)

'--

    CASE IDV100PX
    ReSizeV(100)
    CheckMark(mnuVSize, IDV100PX)

    CASE IDV150PX
    ReSizeV(150)
    CheckMark(mnuVSize, IDV150PX)

    CASE IDV200PX
    ReSizeV(200)
    CheckMark(mnuVSize, IDV200PX)

    CASE IDV250PX
    ReSizeV(250)
    CheckMark(mnuVSize, IDV250PX)

    CASE IDV300PX
    ReSizeV(300)
    CheckMark(mnuVSize, IDV300PX)

    CASE IDV350PX
    ReSizeV(350)
    CheckMark(mnuVSize, IDV350PX)

    CASE IDV400PX
    ReSizeV(400)
    CheckMark(mnuVSize, IDV400PX)

    CASE IDV450PX
    ReSizeV(450)
    CheckMark(mnuVSize, IDV450PX)

    CASE IDV500PX
    ReSizeV(500)
    CheckMark(mnuVSize, IDV500PX)

    CASE IDV550PX
    ReSizeV(550)
    CheckMark(mnuVSize, IDV550PX)

    CASE IDV600PX
    ReSizeV(600)
    CheckMark(mnuVSize, IDV600PX)

    CASE IDV650PX
    ReSizeV(650)
    CheckMark(mnuVSize, IDV650PX)

    CASE IDV700PX
    ReSizeV(700)
    CheckMark(mnuVSize, IDV700PX)

    CASE IDV750PX
    ReSizeV(750)
    CheckMark(mnuVSize, IDV750PX)

    CASE IDV800PX
    ReSizeV(800)
    CheckMark(mnuVSize, IDV800PX)

    CASE IDVFULL
    ReSizeV(MAXHEIGHT)
    CheckMark(mnuVSize, IDVFULL)

    CASE IDHLAYOUT
    Layout(0)

    CASE IDVLAYOUT
    Layout(1)

    CASE IDSLAYOUT
    Layout(2)

    CASE ID_TOPLEFT
    SetWindowPos(frmRule, 0, 0,0, w, h, SWP_NOSIZE|SWP_NOZORDER)
End Select ' end WM_COMMAND

CASE WM_CLOSE
DestroyWindow (frmRule)

CASE WM_DESTROY
PostQuitMessage(0)

CASE WM_CTLCOLORSTATIC ' Colorize our static text controls
End Select
End EVENTS


