GUI "Test Comm Ports",PIXELS

$INCLUDE "Decode_SerialPorts.inc"
$INCLUDE "MoveAnchorInc.Inc"


CONST Stc1_Style    = WS_CHILD|WS_VISIBLE|WS_TABSTOP|SS_NOTIFY
CONST Stc1_ExtStyle = WS_EX_STATICEDGE
CONST Stc2_Style    = WS_CHILD|WS_VISIBLE|WS_TABSTOP|SS_NOTIFY
CONST Stc2_ExtStyle = WS_EX_STATICEDGE
CONST Edt1_Style    = WS_CHILD|WS_VISIBLE|WS_TABSTOP|ES_MULTILINE|ES_AUTOVSCROLL|ES_AUTOHSCROLL|ES_WANTRETURN
CONST Edt1_ExtStyle = WS_EX_STATICEDGE
CONST Edt2_Style    = WS_CHILD|WS_VISIBLE|WS_TABSTOP|ES_MULTILINE|ES_AUTOVSCROLL|ES_AUTOHSCROLL|ES_WANTRETURN
CONST Edt2_ExtStyle = WS_EX_STATICEDGE
CONST Edt3_Style    = WS_CHILD|WS_VISIBLE|WS_TABSTOP|ES_MULTILINE|ES_AUTOVSCROLL|ES_WANTRETURN
CONST Edt3_ExtStyle = WS_EX_STATICEDGE
CONST Edt4_Style    = WS_CHILD|WS_VISIBLE|WS_TABSTOP|ES_MULTILINE|ES_AUTOVSCROLL|ES_WANTRETURN
CONST Edt4_ExtStyle = WS_EX_STATICEDGE
CONST Btn1_Style    = WS_CHILD|WS_VISIBLE|WS_TABSTOP
CONST Btn1_ExtStyle = WS_EX_STATICEDGE
CONST Btn2_Style    = WS_CHILD|WS_VISIBLE|WS_TABSTOP
CONST Btn2_ExtStyle = WS_EX_STATICEDGE
CONST Btn3_Style    = WS_CHILD|WS_VISIBLE|WS_TABSTOP
CONST Btn3_ExtStyle = WS_EX_STATICEDGE


TYPE BCX_COMM_PORT
   Baud AS INTEGER
   Port AS INTEGER
   Parity AS INTEGER
   StopBits AS INTEGER
   DataBits AS INTEGER
   XonXoff AS INTEGER
   OPEN AS BOOL
   rcvbuf$
   sendbuf$
END TYPE


ENUM
   ID_Stc1
   ID_Stc2
   ID_Edt1
   ID_Edt2
   ID_Edt3
   ID_Edt4
   ID_Edt5
   ID_Edt6
   ID_Btn1
   ID_Btn2
   ID_Btn3
   ID_Btn4
   ID_Btn5
END ENUM

GLOBAL Form1 AS HWND
GLOBAL hStc1 AS CONTROL
GLOBAL hStc2 AS CONTROL
GLOBAL hEdt1 AS CONTROL
GLOBAL hEdt2 AS CONTROL
GLOBAL hEdt3 AS CONTROL
GLOBAL hEdt4 AS CONTROL
GLOBAL hEdt5 AS CONTROL
GLOBAL hEdt6 AS CONTROL
GLOBAL hBtn1 AS CONTROL
GLOBAL hBtn2 AS CONTROL
GLOBAL hBtn3 AS CONTROL
GLOBAL hBtn4 AS CONTROL
GLOBAL hBtn5 AS CONTROL

GLOBAL CommA AS BCX_COMM_PORT
GLOBAL CommB AS BCX_COMM_PORT

CONST WM_RCVDATA   = WM_USER + 50
CONST WM_SENTDATA  = WM_USER + 51
CONST WM_COMERROR  = WM_USER + 52
CONST WM_MODSTATUS = WM_USER + 53



SUB FORMLOAD
   DIM hFont AS HFONT
   Form1 = BCX_FORM("Test Comm Ports", 0, 0, 662, 425)
   hStc1 = BCX_LABEL("Comm A",Form1,ID_Stc1, 10, 10, 310, 20, Stc1_Style, Stc1_ExtStyle)
   hStc2 = BCX_LABEL("Comm B",Form1,ID_Stc2, 335, 10, 310, 20, Stc2_Style, Stc2_ExtStyle)
   hEdt1 = BCX_EDIT("Edit",Form1,ID_Edt1, 10, 30, 310, 20, Edt1_Style, Edt1_ExtStyle)
   hEdt2 = BCX_EDIT("Edit",Form1,ID_Edt2, 335, 30, 310, 20, Edt2_Style, Edt2_ExtStyle)
   hEdt3 = BCX_EDIT("CommA Data1",Form1,ID_Edt3, 10, 50, 310, 200, Edt3_Style, Edt3_ExtStyle)
   hEdt4 = BCX_EDIT("CommB Data2",Form1,ID_Edt4, 335, 50, 310, 300, Edt4_Style, Edt4_ExtStyle)
   hEdt5 = BCX_EDIT("CommA Data1",Form1,ID_Edt5, 10, 250, 310, 100, Edt3_Style, Edt3_ExtStyle)
   hEdt6 = BCX_EDIT("CommB Data2",Form1,ID_Edt6, 335, 250, 310, 100, Edt4_Style, Edt4_ExtStyle)
   hBtn1 = BCX_BUTTON("Open A",Form1,ID_Btn1, 20, 360, 100, 30, Btn1_Style, Btn1_ExtStyle)
   hBtn2 = BCX_BUTTON("Open B",Form1,ID_Btn2, 300, 360, 100, 30, Btn2_Style, Btn2_ExtStyle)
   hBtn3 = BCX_BUTTON("END ALL",Form1,ID_Btn3, 540, 360, 100, 30, Btn3_Style, Btn3_ExtStyle)
   hBtn4 = BCX_BUTTON("Config A",Form1,ID_Btn4, 140, 360, 100, 30, Btn3_Style, Btn3_ExtStyle)
   hBtn5 = BCX_BUTTON("Config B",Form1,ID_Btn5, 420, 360, 100, 30, Btn3_Style, Btn3_ExtStyle)

   'Setup the ports
   CommA.Port = 1
   CommA.Baud = 9600
   CommA.StopBits = 1
   CommA.DataBits = 8
   CommA.Parity =  0
   CommA.XonXoff = 0
   CommA.OPEN = 0  'False

   CommB.Port = 7
   CommB.Baud = 9600
   CommB.StopBits = 1
   CommB.DataBits = 8
   CommB.Parity =  0
   CommB.XonXoff = 0
   CommB.OPEN = 0  'False

   BCX_SET_TEXT(hEdt1, STR$(CommA.Port)+CHR$(44)+ STR$(CommA.Baud)+CHR$(44)+  STR$(CommA.Parity) + CHR$(44)+  STR$(CommA.DataBits) + CHR$(44)+ STR$(CommA.StopBits))
   BCX_SET_TEXT(hEdt2, STR$(CommB.Port)+CHR$(44)+ STR$(CommB.Baud)+CHR$(44)+  STR$(CommB.Parity) + CHR$(44)+  STR$(CommB.DataBits) + CHR$(44)+ STR$(CommB.StopBits))
   InitAnchor(Form1)    'Sizing
   CENTER(Form1)
   SHOW(Form1)
END SUB



BEGIN EVENTS
   STATIC commA_Buffer$
   STATIC commB_Buffer$
   STATIC counter

   SELECT CASE CBMSG
      CASE WM_COMMAND
      SELECT CASE CBCTL
         CASE ID_Btn1
         IF NOT CommA.OPEN THEN
            IF LEN(BCX_GET_TEXT$(hEdt1)) THEN
               CALL ParseCommString(BCX_GET_TEXT$(hEdt1), CommA)
            END IF
            IF OpenComm(Form1, CommA.Port, CommA.Baud, CommA.Parity, CommA.DataBits, CommA.StopBits, CommA.XonXoff, 4096, 4096)  THEN
               BCX_SET_TEXT(hBtn1, "Close A")
               CommA.OPEN = TRUE
            END IF
         ELSE
            CommA.OPEN = CloseComm(CommA.Port)
            IF NOT CommA.OPEN THEN BCX_SET_TEXT(hBtn1, "Open A")
         END IF
         CASE ID_Btn2
         IF NOT CommB.OPEN THEN
            IF LEN( BCX_GET_TEXT$(hEdt2)) THEN
               CALL ParseCommString(BCX_GET_TEXT$(hEdt2), CommB)
            END IF
            IF OpenComm(Form1, CommB.Port, CommB.Baud, CommB.Parity, CommB.DataBits, CommB.StopBits, CommB.XonXoff, 4096, 4096)  THEN
               BCX_SET_TEXT(hBtn2, "Close B")
               CommB.OPEN = TRUE
            END IF
         ELSE
            CommB.OPEN = CloseComm(CommB.Port)
            IF NOT CommA.OPEN THEN BCX_SET_TEXT(hBtn2, "Open B")
         END IF
         CASE ID_Btn3
         CloseComm(CommA.Port)
         CloseComm(CommB.Port)
         CALL ExitComms()
         PostQuitMessage(0)
         CASE ID_Btn4
         DIM  WasOpen
         WasOpen = CommA.OPEN
         PRINT "A Open1 = " & STR$(CommA.OPEN) & "  "  & STR$(WasOpen)
         IF CommA.OPEN THEN  CommA.OPEN = CloseComm(CommA.Port)
         PRINT "A OPEN2 = " & STR$(CommA.OPEN) & "  "  & STR$(WasOpen)
         CALL CommSettings(Form1, &CommA.Port, &CommA.Baud, &CommA.Parity, &CommA.DataBits, &CommA.StopBits, &CommA.XonXoff)
         IF GetLastError() THEN PRINT "Error: " & STR$(GetLastError())
         BCX_SET_TEXT(hEdt1, STR$(CommA.Port)+CHR$(44)+ STR$(CommA.Baud)+CHR$(44)+  _
         STR$(CommA.Parity) + CHR$(44)+  STR$(CommA.DataBits) + CHR$(44)+ STR$(CommA.StopBits))
         PRINT "A Open3 = " & STR$(CommA.OPEN) & "  "  & STR$(WasOpen)
         IF WasOpen THEN
            CommA.OPEN = OpenComm(Form1, CommA.Port, CommA.Baud, CommA.Parity, CommA.DataBits, CommA.StopBits, CommA.XonXoff, 4096, 4096)
            IF CommA.OPEN THEN
               BCX_SET_TEXT(hBtn1, "Close A")
            ELSE
               BCX_SET_TEXT(hBtn1, "Open A")
            END IF
         END IF
         CASE ID_Btn5
         DIM  WasOpen
         IF CommB.OPEN THEN  CommB.OPEN = CloseComm(CommB.Port) : WasOpen++
         CALL CommSettings(Form1, &CommB.Port, &CommB.Baud, &CommB.Parity, &CommB.DataBits, &CommB.StopBits, &CommB.XonXoff)
         IF GetLastError() THEN PRINT "Error: " & STR$(GetLastError())
         BCX_SET_TEXT(hEdt1, STR$(CommB.Port)+CHR$(44)+ STR$(CommB.Baud)+CHR$(44)+  _
         STR$(CommB.Parity) + CHR$(44)+  STR$(CommB.DataBits) + CHR$(44)+ STR$(CommB.StopBits))
         IF WasOpen THEN
            CommB.OPEN = OpenComm(Form1, CommB.Port, CommB.Baud, CommB.Parity, CommB.DataBits, CommB.StopBits, CommB.XonXoff, 4096, 4096)
            IF CommB.OPEN THEN
               BCX_SET_TEXT(hBtn2, "Close A")
            ELSE
               BCX_SET_TEXT(hBtn2, "Open A")
            END IF
         END IF
      END SELECT
      CASE WM_RCVDATA
      IF  wParam = CommA.Port THEN
         CommA.rcvbuf$ = RecvCommData$(wParam, lParam)               'ANSI
         'CommA.rcvbuf$ = RecvCommDataW$(wParam, lParam)             'Unicode
         commA_Buffer$ = commA_Buffer$ & TRIM$(CommA.rcvbuf$)
         IF INSTR(commA_Buffer$,"DBT",1,1) THEN
            commA_Buffer$ = RIGHT$(commA_Buffer$, LEN(commA_Buffer$) - INSTRREV(commA_Buffer$, "$"))
            BCX_SET_TEXT(hEdt3, commA_Buffer$ & CRLF$)
            BCX_SET_TEXT(hEdt5, "DBT: " & AddSonar$(commA_Buffer$))
         ELSE
            IF LEN(commA_Buffer$) >600 THEN commA_Buffer$ = MID$(commA_Buffer$, LEN(commA_Buffer$) - INSTRREV(commA_Buffer$, "$"))
            counter++
            BCX_SET_TEXT(hEdt3, commA_Buffer$ & CRLF$)
            BCX_SET_TEXT(hEdt5, AddGPS$(commA_Buffer$) & "counter:     " & STR$(counter)  & CRLF$ )
            IF counter > 1000 THEN counter = 0
         END IF
      ELSEIF wParam = CommB.Port THEN
         CommB.rcvbuf$ = RecvCommData$(wParam, lParam)                  'ANSI
         'CommB.rcvbuf$ = RecvCommDataW$(wParam, lParam)                'Unicode
         commB_Buffer$ = commB_Buffer$ & TRIM$(CommB.rcvbuf$)
         '
         IF INSTR(commB_Buffer$,"DBT",1,1) THEN
            commB_Buffer$ = RIGHT$(commB_Buffer$, LEN(commB_Buffer$) - INSTRREV(commB_Buffer$, "$"))
            BCX_SET_TEXT(hEdt4, commB_Buffer$ & CRLF$)
            BCX_SET_TEXT(hEdt6, "DBT: " & AddSonar$(commB_Buffer$))
         ELSE
            IF LEN(commB_Buffer$) > 600 THEN commB_Buffer$ = RIGHT$(commB_Buffer$, LEN(commB_Buffer$) - INSTRREV(commB_Buffer$, "$"))
            counter++
            IF MOD( counter, 10) = 0 THEN
               BCX_SET_TEXT(hEdt4, commB_Buffer$ & CRLF$)
               BCX_SET_TEXT(hEdt6, AddGPS$(commB_Buffer$) & "counter:     " & STR$(counter)  & CRLF$)
               IF counter > 1000 THEN counter = 0
            END IF
         END IF
      END IF
      CASE WM_SIZE                    'Sizing
      IF hWnd = Form1 THEN
         'Skip if minimized, OS will handle it
         IF wParam  NOT = SIZE_MINIMIZED THEN
            CALL ReSizeForm1()
            UpdateAnchor(Form1)
         END IF
      END IF
      CASE WM_CLOSE
      CloseComm(CommA.Port)
      CloseComm(CommB.Port)
      CALL ExitComms()
      PostQuitMessage(0)
   END SELECT
END EVENTS



FUNCTION AddSonar$(buf$)
   FUNCTION = STR$(DecodeSonar(buf$) )
END FUNCTION



FUNCTION AddGPS$(buf$)
   DIM sRet$
   'Print "In Add GPS"
   BCX_SET_TEXT(hEdt6, "")
   CALL DecodeGPS(buf$)
   sRet$ = "Northing:    " & STR$(ROUND(LastGPS.Lat,9))  & CRLF$
   sRet$ = sRet$ & "Easting: " &  STR$(ROUND(LastGPS.Lon,9))  & CRLF$
   sRet$ = sRet$ & "Alt:     " & STR$(ROUND(LastGPS.Alt,3))  & CRLF$
   sRet$ = sRet$ & "Differential:     " & STR$(LastGPS.Differential)  & CRLF$
   FUNCTION = sRet$
END FUNCTION



SUB ParseCommString(comm$, commtype AS BCX_COMM_PORT)
   commtype.Port = VAL(Parse$(comm$,CHR$(44),1))
   commtype.Baud = VAL(Parse$(comm$,CHR$(44),2))
   IF Parse$(comm$,CHR$(44),3) = "N" THEN             'No Parity
      commtype.Parity = 0
   ELSEIF Parse$(comm$,CHR$(44),3) = "O" THEN         'Odd Parity
      commtype.Parity = 1
   ELSEIF Parse$(comm$,CHR$(44),3) = "E" THEN          'Even Parity
      commtype.Parity = 2
   ELSEIF Parse$(comm$,CHR$(44),3) = "M" THEN          'Mark Parity
      commtype.Parity = 3
   ELSEIF Parse$(comm$,CHR$(44),3) = "S" THEN          'Space Parity
      commtype.Parity = 4
   ELSE
      commtype.Parity = VAL(Parse$(comm$,CHR$(44),3))
   END IF
   commtype.DataBits = VAL(Parse$(comm$,CHR$(44),4))
   commtype.StopBits = VAL(Parse$(comm$,CHR$(44),5))
END SUB



FUNCTION ParseCount OPTIONAL(a$, b$ = ",", iCase% = 0)  AS INTEGER
   FUNCTION = 1 + TALLY(a$,b$)
END FUNCTION



FUNCTION Parse$ OPTIONAL(a$, b$ = ",", field = 1, iCase% = 0)
   FUNCTION = STRTOKEN$(a$, b$, field)
END FUNCTION

DECLARE SUB SendData LIB "CommCtrlBcx.dll" ALIAS "SendData"(cParentHwnd AS HWND, port, out AS LPCSTR, L)
DECLARE SUB SendDataW LIB "CommCtrlBcx.dll" ALIAS "SendDataW"(cParentHwnd AS HWND, port, out AS LPWSTR, L)
DECLARE FUNCTION OpenComm LIB "CommCtrlBcx.dll" ALIAS "OpenComm"(cParentHwnd AS HWND, port, baudrate, parity, databits, stopbits, hs, inpbuff, outbuff) AS BOOL
DECLARE FUNCTION CloseComm LIB "CommCtrlBcx.dll" ALIAS "CloseComm"(port) AS BOOL
DECLARE SUB ExitComms LIB "CommCtrlBcx.dll" ALIAS "ExitComms"()
DECLARE FUNCTION RecvCommData LIB "CommCtrlBcx.dll" ALIAS "RecvCommData"(port, NBytes) AS LPSTR
DECLARE FUNCTION RecvCommDataW LIB "CommCtrlBcx.dll" ALIAS "RecvCommDataW"(port, NBytes) AS LPWSTR
DECLARE FUNCTION CommSettings LIB "CommCtrlBcx.dll" ALIAS "CommSettings" _
                (hParent AS HWND, BYREF port, BYREF baudrate, BYREF parity, BYREF databits, BYREF stopbits, BYREF hs) AS INTEGER


FUNCTION DDMMtoDDec(DM AS STRING) AS DOUBLE 'EXPORT
   DIM Angle AS DOUBLE
   DIM Deg   AS DOUBLE
   Angle = (VAL(DM)/100) + 0.00001
   Deg = FIX(Angle)
   Angle = Angle - Deg
   Angle = Angle * 100 / 60
   FUNCTION = Angle + Deg
END FUNCTION


SUB ReSizeForm1()              'Sizing
   'Now resize the controls
   'Anchor Options:
   'AnchorLeft | AnchorRight | AnchorTop | AnchorBottom | AnchorHCenter | AnchorVCenter
   MoveAnchorControl(hStc1, AnchorLeft | AnchorHCenter | AnchorTop)
   MoveAnchorControl(hStc2, AnchorRight | AnchorHCenter | AnchorTop)
   MoveAnchorControl(hEdt1, AnchorLeft | AnchorHCenter | AnchorTop)
   MoveAnchorControl(hEdt2, AnchorRight | AnchorHCenter | AnchorTop)
   MoveAnchorControl(hEdt3, AnchorLeft | AnchorHCenter | AnchorTop | AnchorBottom)
   MoveAnchorControl(hEdt4, AnchorRight | AnchorHCenter | AnchorTop | AnchorBottom)
   MoveAnchorControl(hEdt5, AnchorLeft | AnchorHCenter | AnchorBottom)
   MoveAnchorControl(hEdt6, AnchorRight | AnchorHCenter | AnchorBottom)
   MoveAnchorControl(hBtn1, AnchorLeft | AnchorBottom)
   MoveAnchorControl(hBtn4, AnchorLeft | AnchorBottom)
   MoveAnchorControl(hBtn2, AnchorRight | AnchorBottom)
   MoveAnchorControl(hBtn5, AnchorRight | AnchorBottom)
   MoveAnchorControl(hBtn3, AnchorRight | AnchorBottom)
END SUB


'Wayne Haldorf rewrote this for me, Thanks
FUNCTION Format$ OPTIONAL(x AS DOUBLE, hi=1, lo=0, comma= 0, zeros = 1)
   'hi is the minimum number of integer digits, pad with 0
   'lo is the minimum number of fractional digits, pad with 0
   DIM a$, b$, minus
   DIM c$, d
   IF x < ABS(x) THEN minus = 1
   x = ABS(x) + 0.000000000000000000000001
   x = ROUND(x,lo)
   b$ = "#." & STRING$(lo,35)
   a$ = TRIM$(USING$(b$,x))
   IF lo > 0 THEN
      c$ = STRING$(MAX(1 + hi - INSTR(a$,"."),0),48) + a$
   ELSE
      c$ = RIGHT$(STRING$(MIN(hi,LEN(a$)),48)+a$,MAX(hi,LEN(a$)))
   END IF
   IF zeros  THEN
      WHILE c[d] = 48
         c[d] = 32
         d++
      WEND
   END IF
   IF minus THEN
      IF (c[0] = 48)  OR (c[0] = 32)THEN
         c[0] = 45
      ELSE
         c$ = CHR$(45) & c$
      END IF
   END IF
   IF comma = 0 THEN
      REMOVE CHR$(44) FROM c$
   END IF
   FUNCTION = c$
END FUNCTION



