// *************************************************
//      Made with BCX BASIC To C/C++ Translator
//            Version 7.8.5 (04/12/2022)
// *************************************************
//    Translated for compiling with a C Compiler
// *************************************************
#define _CRT_SECURE_NO_DEPRECATE

#include <windows.h>    // WinApi
#include <windowsx.h>   // WinApi
#include <commctrl.h>   // WinApi
#include <commdlg.h>    // WinApi
#include <direct.h>     // WinApi
#include <mmsystem.h>   // WinApi
#include <oaidl.h>      // WinApi
#include <objbase.h>    // WinApi
#include <ocidl.h>      // WinApi
#include <ole2.h>       // WinApi
#include <oleauto.h>    // WinApi
#include <olectl.h>     // WinApi
#include <richedit.h>   // WinApi
#include <shellapi.h>   // WinApi
#include <shlobj.h>     // WinApi
#include <urlmon.h>     // WinApi
#include <wchar.h>      // WinApi
#include <wctype.h>     // WinApi
#include <tchar.h>      // WinApi
#include <unknwn.h>     // WinApi
#include <wininet.h>    // WinApi
#include <winsock.h>    // WinApi
#include <winuser.h>    // WinApi
#include <stdbool.h>    // ISO StdLib
#include <ctype.h>      // ISO StdLib
#include <math.h>       // ISO StdLib
#include <setjmp.h>     // ISO StdLib
#include <stdarg.h>     // ISO StdLib
#include <stddef.h>     // ISO StdLib
#include <stdio.h>      // ISO StdLib
#include <stdlib.h>     // ISO StdLib
#include <string.h>     // ISO StdLib
#include <time.h>       // ISO StdLib
#include <process.h>    // ISO StdLib
#include <inttypes.h>   // ISO StdLib
#include <fcntl.h>      // POSIX
#include <io.h>         // WinNT POSIX subset
#include <conio.h>      // Primitive i/o


// *************************************************
//            System Defined Constants
// *************************************************

#define BCXSTRSIZE 2048

// *************************************************
//             User Defined Constants
// *************************************************

#define GPSDATA_CLASS struct _GPSDATA*
#define ANCHOR_CLASS struct _ANCHOR*
#define AnchorLeft 1
#define AnchorRight 2
#define AnchorTop 4
#define AnchorBottom 8
#define AnchorHCenter 16
#define AnchorVCenter 32
#define Stc1_Style WS_CHILD|WS_VISIBLE|WS_TABSTOP|SS_NOTIFY
#define Stc1_ExtStyle WS_EX_STATICEDGE
#define Stc2_Style WS_CHILD|WS_VISIBLE|WS_TABSTOP|SS_NOTIFY
#define Stc2_ExtStyle WS_EX_STATICEDGE
#define Edt1_Style WS_CHILD|WS_VISIBLE|WS_TABSTOP|ES_MULTILINE|ES_AUTOVSCROLL|ES_AUTOHSCROLL|ES_WANTRETURN
#define Edt1_ExtStyle WS_EX_STATICEDGE
#define Edt2_Style WS_CHILD|WS_VISIBLE|WS_TABSTOP|ES_MULTILINE|ES_AUTOVSCROLL|ES_AUTOHSCROLL|ES_WANTRETURN
#define Edt2_ExtStyle WS_EX_STATICEDGE
#define Edt3_Style WS_CHILD|WS_VISIBLE|WS_TABSTOP|ES_MULTILINE|ES_AUTOVSCROLL|ES_WANTRETURN
#define Edt3_ExtStyle WS_EX_STATICEDGE
#define Edt4_Style WS_CHILD|WS_VISIBLE|WS_TABSTOP|ES_MULTILINE|ES_AUTOVSCROLL|ES_WANTRETURN
#define Edt4_ExtStyle WS_EX_STATICEDGE
#define Btn1_Style WS_CHILD|WS_VISIBLE|WS_TABSTOP
#define Btn1_ExtStyle WS_EX_STATICEDGE
#define Btn2_Style WS_CHILD|WS_VISIBLE|WS_TABSTOP
#define Btn2_ExtStyle WS_EX_STATICEDGE
#define Btn3_Style WS_CHILD|WS_VISIBLE|WS_TABSTOP
#define Btn3_ExtStyle WS_EX_STATICEDGE
#define BCX_COMM_PORT_CLASS struct _BCX_COMM_PORT*
#define WM_RCVDATA WM_USER+ 50
#define WM_SENTDATA WM_USER+ 51
#define WM_COMERROR WM_USER+ 52
#define WM_MODSTATUS WM_USER+ 53

// *************************************************
//                  Compiler Defines
// *************************************************

#if defined (__cplusplus)
  #define overloaded
  #define C_EXPORT EXTERN_C __declspec(dllexport)
  #define C_IMPORT EXTERN_C __declspec(dllimport)
#else
  #define C_EXPORT __declspec(dllexport)
  #define C_IMPORT __declspec(dllimport)
#endif

// *************************************************
//                   Microsoft VC++
// *************************************************

#ifndef DECLSPEC_UUID
  #if (_MSC_VER >= 1100) && defined (__cplusplus)
    #define DECLSPEC_UUID(x)  __declspec(uuid(x))
  #else
    #define DECLSPEC_UUID(x)
  #endif
#endif
#if (_MSC_VER >= 1900)            // earlier versions untested
   #include <intrin.h>
      #ifndef _rdtsc
         #define _rdtsc __rdtsc   // MSVC uses 2 underscores
      #endif
   #pragma warning(disable: 4018) // signed/unsigned mismatch warnings
   #pragma warning(disable: 4100) // unreferenced argument warnings
   #pragma warning(disable: 4244) // conversion from type1 to type2 warnings
   #pragma warning(disable: 4267) // conversion from type1 to type2 warnings
   #pragma warning(disable: 4305) // truncation from double to float warnings
   #pragma warning(disable: 4800) // forcing value to bool warnings
   #pragma warning(disable: 4838) // conversion from type1 to type2 warnings
#endif

// *************************************************
//                  GCC and CLANG
// *************************************************

#if defined (__GNUC__) || defined (__clang__)
   #ifndef __BCPLUSPLUS__
      #include <x86intrin.h>
   #endif
   #pragma GCC diagnostic ignored "-Wwrite-strings"
   #pragma GCC diagnostic ignored "-Wunused-parameter"
   #pragma GCC diagnostic ignored "-Wunknown-pragmas"
   #pragma GCC diagnostic ignored "-Wdangling-else"
   #pragma GCC diagnostic ignored "-Wdeprecated"
#endif

// *************************************************
//                  Embarcadero C++
// *************************************************

#if defined (__BCPLUSPLUS__)
      #if  defined (_clang__)
            #include <mmintrin.h>
      #endif
      #define _kbhit kbhit
      #ifndef _rdtsc
        #define _rdtsc __rdtsc  // Uses 2 underscores
      #endif
#endif

// *************************************************
//                    Open Watcom
// *************************************************

#if defined (__WATCOM_CPLUSPLUS__)
  #define _fcloseall fcloseall
#endif

// *************************************************
//                     Lcc-Win32
// *************************************************

#if defined( __LCC__)
  #define _fseeki64  fseeki64
  #define _stricmp   stricmp
  #define _strnicmp  strnicmp
  #define _itoa      itoa
  #define _ltoa      ltoa
  #include <intrinsics.h>
  #include <malloc.h>  // for _msize
  #if defined( __windows_h__ )
      #define COMPILE_MULTIMON_STUBS
      #include <multimon.h>
      #include <iehelper.h>
      #include <exdisp.h>
   #endif
#endif

// *************************************************
//                     Pelles C
// *************************************************

#if defined (__POCC__)
   #include <intrin.h>
   #pragma pack_stack(off)        // Pelle's fix for a v10 optimization bug
   #pragma warn(disable: 2006)    // Non-portable conversion int to const char*
   #pragma warn(disable: 2007)    // Non-portable inline code
   #pragma warn(disable: 2115)    // Initialized but not used warnings
   #pragma warn(disable: 2118)    // Unreferenced argument warnings
   #pragma warn(disable: 2134)    // Possible infinite loop
   #pragma warn(disable: 2154)    // Buggy unreachable code warning using sizeof
   #pragma warn(disable: 2197)    // Unsigned long int not a std bit-field type
   #pragma warn(disable: 2215)    // Conversion from type1 to type2 warnings
   #pragma warn(disable: 2218)    // Unreferenced parameter
   #pragma warn(disable: 2230)    // Incomplete struct declarations (vbs support)
   #pragma warn(disable: 2235)    // Not all control paths return a value
   #pragma warn(disable: 2241)    // Function marked for deprecation
   #pragma warn(disable: 2248)    // Non-portable use of extension
   #pragma warn(disable: 2251)    // Types with different signedness
   #pragma warn(disable: 2804)    // Consider changing type to size_t warnings
   #pragma warn(disable: 2805)    // Possible anti-aliasing violation warnings
   #pragma warn(disable: 2810)    // Potential realloc warnings
#endif

// *************************************************
// Instruct Linker to Search Object/Import Libraries
// *************************************************

#if !defined(__GNUC__)
   #if !(defined(__BCPLUSPLUS__) && defined(_WIN64))
      #if !defined( __LCC__ )
    #pragma comment(lib,"kernel32.lib")
    #pragma comment(lib,"user32.lib")
    #pragma comment(lib,"gdi32.lib")
    #pragma comment(lib,"comctl32.lib")
    #pragma comment(lib,"advapi32.lib")
    #pragma comment(lib,"winspool.lib")
    #pragma comment(lib,"shell32.lib")
    #pragma comment(lib,"ole32.lib")
    #pragma comment(lib,"oleaut32.lib")
    #pragma comment(lib,"uuid.lib")
    #pragma comment(lib,"odbc32.lib")
    #pragma comment(lib,"odbccp32.lib")
    #pragma comment(lib,"winmm.lib")
    #pragma comment(lib,"comdlg32.lib")
    #pragma comment(lib,"imagehlp.lib")
    #pragma comment(lib,"version.lib")
    #pragma comment(lib,"wininet.lib")
    #pragma comment(lib,"urlmon.lib")
  #else
    #pragma lib <winspool.lib>
    #pragma lib <shell32.lib>
    #pragma lib <ole32.lib>
    #pragma lib <oleaut32.lib>
    #pragma lib <uuid.lib>
    #pragma lib <odbc32.lib>
    #pragma lib <odbccp32.lib>
    #pragma lib <winmm.lib>
    #pragma lib <imagehlp.lib>
    #pragma lib <version.lib>
    #pragma lib <wininet.lib>
    #pragma lib <urlmon.lib>
     #endif
  #endif
#endif

// *************************************************
//           User's GLOBAL Enumerations
// *************************************************

enum
  {
    ID_Stc1,
    ID_Stc2,
    ID_Edt1,
    ID_Edt2,
    ID_Edt3,
    ID_Edt4,
    ID_Edt5,
    ID_Edt6,
    ID_Btn1,
    ID_Btn2,
    ID_Btn3,
    ID_Btn4,
    ID_Btn5
  };


// *************************************************
//          User Defined Types And Unions
// *************************************************

typedef struct _GPSData
{
  double   Lat;
  double   Lon;
  double   Alt;
  double   Time;
  float    HDOP;
  float    VDOP;
  int      SVS;
  int      Differential;
}GPSData, *LPGPSDATA;


typedef struct _anchor
{
  int     IsSubForm;
  int     XMin;
  int     YMin;
  RECT     PrevRC;
}anchor, *LPANCHOR;


typedef struct _BCX_COMM_PORT
{
  int      Baud;
  int      Port;
  int      Parity;
  int      StopBits;
  int      DataBits;
  int      XonXoff;
  BOOL     OPEN;
  char    rcvbuf[BCXSTRSIZE];
  char    sendbuf[BCXSTRSIZE];
}BCX_COMM_PORT, *LPBCX_COMM_PORT;

typedef void (__stdcall *BCXFPROT1)(HWND,int,LPCSTR,int);
typedef void (__stdcall *BCXFPROT2)(HWND,int,LPWSTR,int);
typedef BOOL (__stdcall *BCXFPROT3)(HWND,int,int,int,int,int,int,int,int);
typedef BOOL (__stdcall *BCXFPROT4)(int);
typedef void (__stdcall *BCXFPROT5)(void);
typedef LPSTR (__stdcall *BCXFPROT6)(int,int);
typedef LPWSTR (__stdcall *BCXFPROT7)(int,int);
typedef int (__stdcall *BCXFPROT8)(HWND,int*,int*,int*,int*,int*,int*);

// *************************************************
//               Standard Prototypes
// *************************************************

void    BCX_SetMetric (LPCTSTR);
void    BCX_RegWnd (LPCTSTR, WNDPROC);
void    BCX_InitGUI (void);
int     Cint (double);
HWND    BCX_Form (LPCTSTR, int=0, int=0, int=250, int=150, int=-1, int=0);
HWND    BCX_Edit (LPCTSTR, HWND, int, int, int, int, int, int=0, int=-1);
HWND    BCX_Button (LPCTSTR, HWND, int=0, int=0, int=0, int=0, int=0, int=0, int=-1);
HWND    BCX_Label (LPCTSTR, HWND, int=0, int=0, int=0, int=0, int=0, int=0, int=0);
char*   BCX_Get_Text (HWND);
int     BCX_Set_Text (HWND, LPCTSTR);
void    Center (HWND, HWND=0, HWND=0);
char*   BCX_TmpStr (size_t);
char*   Using (LPCTSTR, long double);
char*   chr (unsigned char,unsigned char=0,unsigned char=0,unsigned char=0,unsigned char=0,unsigned char=0,unsigned char=0,unsigned char=0,unsigned char=0,unsigned char=0);
char*   mid (LPCTSTR, int, int=-1);
char*   trim (LPCTSTR);
char*   left (LPCTSTR, int);
char*   right (LPCTSTR, int);
char*   stringx (int, int);
char*   extract (LPCTSTR, LPCTSTR);
char*   replace (LPCTSTR, LPCTSTR, LPCTSTR);
char*   str (double, int=0);
char*   StrToken (LPCTSTR, LPCTSTR, int);
char*   RemoveStr (LPCTSTR, LPCTSTR);
SIZE*   GetTextSize (LPCTSTR, HWND=0, HFONT=0);
char*   join (int, ... );
int     InstrRev (LPCTSTR, LPCTSTR, int=0, int=0);
int     instr (LPCTSTR, LPCTSTR, int=0, int=0);
char*   _stristr_(LPCTSTR, LPCTSTR);
int     tally (LPCTSTR, LPCTSTR, int = 0);
double  Round (double, int);
double  MAX (double, double);
double  MIN (double, double);
unsigned char*  MakeLCaseTbl (void);
unsigned char*  MakeUCaseTbl (void);
void*   CreateArr (void*, int, int, int, size_t *);
void    DestroyArr (void**, int, int);

// *************************************************
//                System Variables
// *************************************************

static char    CR  [2]={13,0};    // Carr Rtn
static char    CRLF[3]={13,10,0}; // Carr Rtn & Line Feed
static unsigned char*  LowCase;
static unsigned char*  UprCase;


// *************************************************
//            User's Global Variables
// *************************************************

static BCXFPROT1 SendData;
static BCXFPROT2 SendDataW;
static BCXFPROT3 OpenComm;
static BCXFPROT4 CloseComm;
static BCXFPROT5 ExitComms;
static BCXFPROT6 RecvCommData;
static BCXFPROT7 RecvCommDataW;
static BCXFPROT8 CommSettings;
static HFONT   BcxFont;
static float   BCX_ScaleX;
static float   BCX_ScaleY;
static HINSTANCE BCX_hInstance;
static HWND    BCX_hwndMDIClient;
static WNDCLASSEX BCX_WndClass;
static BOOL    BCX_GUI_Init;
static char    BCX_ClassName[BCXSTRSIZE];
static GPSData LastGPS;
static HWND    Form1;
static HWND    hStc1;
static HWND    hStc2;
static HWND    hEdt1;
static HWND    hEdt2;
static HWND    hEdt3;
static HWND    hEdt4;
static HWND    hEdt5;
static HWND    hEdt6;
static HWND    hBtn1;
static HWND    hBtn2;
static HWND    hBtn3;
static HWND    hBtn4;
static HWND    hBtn5;
static BCX_COMM_PORT CommA;
static BCX_COMM_PORT CommB;

// *************************************************
//               Standard Macros
// *************************************************

#define DefFont ((BcxFont!=0)?BcxFont:(HFONT)SNDMSG(hWnd, WM_GETFONT, 0, 0))
#define DefaultFont ((DefFont==0)?GetStockObject(DEFAULT_GUI_FONT):DefFont)
#define Show(Window)RedrawWindow(Window,0,0,0);ShowWindow(Window,SW_SHOW);
#define VAL(a)(double)atof((a))
#define FIX(a)(int)((a))
#define CDBL(a)(double)((a))

// *************************************************
//               User's Prototypes
// *************************************************

float   DecodeSonar (char*);
ULONG   DecodeGPS (char*);
int     FastLexer (char***  ,char*,char*  = "",char*  = "",int= 0);
RECT    MoveAnchorControl (HWND,int);
void    InitAnchor (HWND,int= 0);
void    UpdateAnchor (HWND);
RECT    GetScaledRect (HWND);
void    FormLoad (void);
LRESULT CALLBACK WndProc (HWND,UINT,WPARAM,LPARAM);
char*   AddSonar (char*);
char*   AddGPS (char*);
void    ParseCommString (char*,BCX_COMM_PORT);
int     ParseCount (char*,char*  = ",",int= 0);
char    *Parse (char*,char*  = ",",int= 1,int= 0);
double  DDMMtoDDec (char *);
void    ReSizeForm1 (void);
char    *Format (double,int= 1,int= 0,int= 0,int= 1);

// *************************************************
//                 Runtime Functions
// *************************************************

char *BCX_TmpStr (size_t iBytes) {
  static int   StrCnt;
  static char *StrFunc[2048];
  StrCnt = (StrCnt + 1) & (2047);
  if (StrFunc[StrCnt])
    {
      free (StrFunc[StrCnt]);
      StrFunc[StrCnt] = NULL;
    }
  StrFunc[StrCnt] = (char*)calloc(iBytes+1, sizeof(char));
  return StrFunc[StrCnt];
}


int Cint (double Arg_A) {
  return (Arg_A >= 0 ? (int)(Arg_A + 0.5) : (int)(Arg_A - 0.5));
}


char *left (LPCTSTR S, int length) {
  size_t tmplen = strlen(S);
  if (length < 1) return BCX_TmpStr(1);
  if (length < (int)tmplen) tmplen = length;
  char *strtmp = BCX_TmpStr(tmplen);
  return (char*)memcpy(strtmp, S, tmplen);
}


char *right (LPCTSTR S, int length) {
  size_t tmplen = strlen(S);
  char *BCX_RetStr = BCX_TmpStr(tmplen);
  tmplen -= length;
  if (tmplen < 1) tmplen = 0;
  return strcpy (BCX_RetStr, &S[tmplen]);
}


char *mid (LPCTSTR S, int start, int length) {
  char *strtmp;
  int tmplen = (int)strlen(S);
  if (start > tmplen||start < 1) return BCX_TmpStr(1);
  if (length < 0 || length > (tmplen-start) + 1)
    length = (tmplen-start) + 1;
  strtmp = BCX_TmpStr(length);
  return (char*)memcpy(strtmp, &S[start - 1], length);
}


char *trim (LPCTSTR S) {
  if (0 == S[0]) return (char*)S;
  while(*S == 32 || (*S >= 9 && *S <= 13)) S++;
  size_t i = strlen(S);
  while( i > 0 && (S[i-1] == 32 || (S[i-1] >= 9 && S[i-1] <= 13))) i--;
  char *strtmp = BCX_TmpStr(i);
  return (char*)memcpy(strtmp, S, i);
}


char *extract (LPCTSTR strSrc, LPCTSTR strPattern) {
  LPCTSTR szMatch;
  char *strtmp = BCX_TmpStr(strlen(strSrc));
  if (*strPattern != 0)
    {
      szMatch = strstr(strSrc, strPattern);
      if (szMatch) return (char*)memcpy(strtmp, strSrc, szMatch-strSrc);
    }
  return strcpy(strtmp, strSrc);
}


char *replace (LPCTSTR szMain, LPCTSTR szFind, LPCTSTR szRepl) {
  size_t LenPat, LenRep, iTmp, iChange;
  char *strtmp, *cp_p, *cp_q, *cp_r;
  if (!szFind || !*szFind)
   {
     strtmp = BCX_TmpStr(strlen(szMain));
     if (!strtmp) return NULL;
     return strcpy(strtmp, (char*)szMain);
   }
  LenRep = strlen(szRepl);
  LenPat = strlen(szFind);
  for (iTmp = 0, cp_p = (char*)szMain;
      (cp_q = strstr(cp_p, (char*)szFind))!=0;
       cp_p = cp_q+LenPat)
    iTmp += (int)(cp_q - cp_p) + LenRep;
    iTmp += strlen(cp_p);
    strtmp = BCX_TmpStr(iTmp);
    if (!strtmp) return NULL;
    for (cp_r = strtmp, cp_p=(char*)szMain;
        (cp_q=strstr(cp_p,(char*)szFind))!=0;
         cp_p = cp_q+LenPat)
      {
        iChange = (int)(cp_q-cp_p);
        memcpy(cp_r, cp_p, iChange); cp_r += iChange;
        strcpy(cp_r, szRepl); cp_r += LenRep;
      }
  strcpy(cp_r, cp_p);
  return strtmp;
}


char *RemoveStr (LPCTSTR strSrc, LPCTSTR RemoveMe) {
  char *strtmp, *pp, *dd;
  int  tmplen;
  strtmp = dd = BCX_TmpStr(strlen(strSrc));
  if (!RemoveMe || !*RemoveMe) return strcpy(strtmp, strSrc);
  pp = strstr((char*)strSrc, (char*)RemoveMe); tmplen = (int)strlen(RemoveMe);
  while (pp)
   {
     memcpy (dd, (char*)strSrc, pp - strSrc);
     dd+= (pp - strSrc);
     strSrc = pp + tmplen;
     pp = strstr((char*)strSrc,(char*)RemoveMe);
   }
  strcpy (dd, (char*)strSrc);
  return strtmp;
}


char *str(double d_, int nospc) {
  char *strtmp = BCX_TmpStr(64);
  if (nospc)
     snprintf(strtmp, 64, "%.15G", d_);
  else
     snprintf(strtmp, 64, "% .15G", d_);
  return strtmp;
}


char *stringx (int count_, int a_) {
  if (count_<1) return BCX_TmpStr(1);
  char *strtmp = BCX_TmpStr(count_);
  return (char*)memset(strtmp, a_, count_);
}


char *chr
     (
       unsigned char a_,unsigned char b_,
       unsigned char c_,unsigned char d_,
       unsigned char e_,unsigned char f_,
       unsigned char g_,unsigned char h_,
       unsigned char i_,unsigned char j_
     ) {
  char *strtmp = BCX_TmpStr(11);
  strtmp[0]  = a_;
  strtmp[1]  = b_;
  strtmp[2]  = c_;
  strtmp[3]  = d_;
  strtmp[4]  = e_;
  strtmp[5]  = f_;
  strtmp[6]  = g_;
  strtmp[7]  = h_;
  strtmp[8]  = i_;
  strtmp[9]  = j_;
  strtmp[10] = 0;
  return strtmp;
}


char *join(int n, ...) {
  int ii = n, tmplen = 0;
  char *s_;
  char *strtmp;
  va_list marker;
  va_start(marker, n); // Initialize variable arguments
  while(ii-- > 0)
  {
    s_ = va_arg(marker, char *);
       if (s_) tmplen += (int)strlen(s_);
  }
  strtmp = BCX_TmpStr(tmplen);
  va_end(marker); // Reset variable arguments
  ii = n;
  va_start(marker, n); // Initialize variable arguments
  while(ii-- > 0)
  {
    s_ = va_arg(marker, char *);
    if (s_) strcat(strtmp, s_);
  }
  va_end(marker); // Reset variable arguments
  return strtmp;
}


char *Using (LPCTSTR Mask, long double Num) {
  int Spaces = 0;
  int CntDec = 0;
  int Decimals = 0;
  int Dollar = 0;
  char *BCX_RetStr = BCX_TmpStr(256);
  char  Buf_1 [256] = {0};
  LPCTSTR p = Mask;
  char *cp_r;
  int  len;
  while (*p)
  {
    if (*p == 36) Dollar++;
    if (*p == 32) Spaces++;
    if ((*p == 32 || *p == 35) && CntDec) Decimals++;
    if (*p == 46) CntDec = 1;
    if (*p == 94) // ^ used for sci notation
       {
         char    Tmp[64]={0};
         sprintf(Tmp,"%.15E",(double)Num);
         while(instr(Tmp,"0E")){
           strcpy(Tmp,replace(Tmp,"0E","E"));
         }
         while(instr(Tmp,"E+00")){
           strcpy(Tmp,replace(Tmp,"E+00","E+0"));
         }
         while(instr(Tmp,"E-0")){
           strcpy(Tmp,replace(Tmp,"E-00","E-0"));
         }
         strcpy(BCX_RetStr,Tmp);
         return BCX_RetStr;
       }
    p++;
  }
  sprintf(Buf_1, "%1.*Lf", Decimals, Num);
  len = (int)strlen(Buf_1)-Decimals-(Decimals > 0 ? 1 : 0);
  cp_r = BCX_RetStr+Dollar+Spaces;
  p = Buf_1;
  while (*p)
   {
     *cp_r++ = *p++;
     if (--len > 2 && *(p-1) != '-' && len % 3 == 0)
       {
         *cp_r++ = ',';
       }
   }
  if (Dollar && Num >= 0) BCX_RetStr[Spaces]=36;
  if (Dollar && Num <  0)
     {
       BCX_RetStr[Spaces+1]=36;
       BCX_RetStr[Spaces]=45;
     }
  if (Spaces) memset(BCX_RetStr, 32, Spaces);
  return BCX_RetStr;
}


int instr(LPCTSTR Haystack, LPCTSTR Needle, int offset, int sensflag) {
  LPCTSTR s;
  if (!Haystack || !Needle || ! *Needle || offset > (int)strlen(Haystack)) return 0;
  if (sensflag)
    s = _stristr_(offset > 0 ? Haystack + offset-1 : Haystack, Needle);
  else
    s = strstr(offset > 0 ? Haystack + offset-1 : Haystack, Needle);
  return s ? (int)(s-Haystack)+1 : 0;
}


int InstrRev (LPCTSTR Haystack, LPCTSTR Needle, int offset, int sens) {
  int sl, pl, ox;
  int (*cmp)(LPCTSTR , LPCTSTR , size_t );
  if (!Haystack || !Needle)  return 0;
  sl  = (int)strlen(Haystack); pl  = (int)strlen(Needle);
  if (offset > sl || 0 == sl || 0 == pl || (ox = sl - pl) < 0)
    return 0;
  if (offset <= 0)  
    offset = ox ;
  else if (offset >= pl)
    offset = offset - pl ;
  else
    return 0;
  cmp = (sens ? _strnicmp : strncmp);
  do { if (cmp(Haystack + offset , Needle, pl) == 0)
       return offset+1;
     } while (offset--);
  return 0;
}


unsigned char* MakeLCaseTbl (void) {
  static unsigned char tbl[257];
  int ii; for (ii = 0; ii < 256; ii++)
  tbl[ii] = (unsigned char) ii;
  tbl[0] = 1;
  tbl[256] = 0;
  CharLowerA((char *)tbl);
  tbl[0] = 0;
  return tbl;
}


unsigned char* MakeUCaseTbl (void) {
  static unsigned char tbl[257];
  int ii; for (ii = 0; ii < 256; ii++)
  tbl[ii] = (unsigned char) ii;
  tbl[0] = 1;
  tbl[256] = 0;
  CharUpperA((char *)tbl);
  tbl[0] = 0;
  return tbl;
}


char *_stristr_(LPCTSTR Haystack, LPCTSTR Needle) {
  int mi=-1;
  while(Needle[++mi])
   {
     if (Haystack[mi]==0) return 0;
     if (UprCase[(unsigned char)Haystack[mi]]!=UprCase[(unsigned char)Needle[mi]])
       { Haystack++; mi=-1; }
   }
  return (char*)Haystack;
}


double Round (double n, int d) {
  return (floor((n)*pow(10.0f, (d))+0.5f)/pow(10.0f, (d)));
}


int tally (LPCTSTR Haystack, LPCTSTR Needle, int sensflag) {
  if (!*Needle) return 0;
  if (!*Haystack) return 0;
  size_t mlen = strlen(Needle);
  int iCount = 0;
  LPCTSTR p = (0 == sensflag ? strstr(Haystack, Needle) : _stristr_(Haystack, Needle));
  while (p)
  {
    iCount++;
    p+=mlen;
    p = ( 0 == sensflag ? strstr(p, Needle) : _stristr_(p, Needle));
  }
  return iCount;
}


double MAX (double dbl_a, double dbl_b) {
  return  dbl_a > dbl_b ? dbl_a : dbl_b;
}


double MIN (double dbl_a, double dbl_b) {
  return  dbl_a < dbl_b ? dbl_a : dbl_b;
}


void *CreateArr(void *dynavar, int elem_size, int update, int num_dims, size_t *args ) {
  size_t s, s1, s2;
  void **vp;
  size_t *marker;
  marker = args;
  s = *marker++;
  s2 = s + 2;
  if (num_dims == 1)
  {
    if (update && dynavar)
        dynavar = realloc(dynavar, s2 * elem_size);
    else
        dynavar = calloc(s2, elem_size);
    return dynavar;
  }
  else if (update && dynavar)
  {
    s1 = 0;
    vp = (void**)dynavar;
    while(*vp && s1 <= s)
    {
        vp++;
        s1++;
    }
    if (s1 > s)
    {
      vp--;
      DestroyArr(vp, num_dims, 0);
    }
    dynavar = realloc(dynavar, s2 * sizeof(int *));
    s1 = 0;
    vp = (void**)dynavar;
    while(*vp && s1 <= s)
    {
      vp++;
      s1++;
    }
    while(s1 < s2)
    {
      *(((void **)vp)) = NULL;
      vp++;
      s1++;
    }
  }
  else
    dynavar = calloc(s2 * sizeof(int *), 1);
    vp = (void**)dynavar;
    if (--num_dims > 0)
    {
      for(s1 = 0; s1 < s; s1++)
      {
          vp[s1] = CreateArr(vp[s1], elem_size, update, num_dims, marker);
      }
    }
  return dynavar;
}


void DestroyArr (void** dynavar,int num_dims, int top_free) {
  int ii = 0;
  static int s = 0;
  if (num_dims == 1)
    {
      free(dynavar);
      dynavar = NULL;
      return;
    }
  s++;
  num_dims--;
  while(dynavar[ii])
     {
    DestroyArr((void**)dynavar[ii], num_dims, top_free);
    if (num_dims > 1)
         free(dynavar[ii]);
    dynavar[ii++]=NULL;
     }
  s--;
  if ( 0 == s && top_free )
    free(dynavar);
    dynavar = NULL;
}


void Center (HWND hwnd, HWND Xhwnd, HWND Yhwnd) {
  RECT rect, rectP;
  int  x, y, width, height;
  int  screenwidth, screenheight;
  HMONITOR  hMonitor={0};
  MONITORINFO  MonitorInfo={0};
  
  GetWindowRect((HWND)hwnd, &rect);
  width=rect.right-rect.left;
  height=rect.bottom-rect.top;
  if(GetSystemMetrics(SM_CMONITORS)==1) {
      hMonitor=MonitorFromRect( &rect,MONITOR_DEFAULTTOPRIMARY);
    }
  else
    {
      hMonitor=MonitorFromRect( &rect,MONITOR_DEFAULTTONEAREST);
    }
  MonitorInfo.cbSize=sizeof(MONITORINFO);
  GetMonitorInfo(hMonitor, &MonitorInfo);
  if(Xhwnd==NULL) {
      rect.left=MonitorInfo.rcWork.left+((MonitorInfo.rcWork.right-MonitorInfo.rcWork.left-width)/2);
      rect.top=MonitorInfo.rcWork.top+((MonitorInfo.rcWork.bottom-MonitorInfo.rcWork.top-height)/2);
      rect.right=rect.left+width;
      rect.bottom=rect.top+height;
      SetWindowPos(hwnd,NULL,rect.left,rect.top,0,0,SWP_NOSIZE|SWP_NOZORDER|SWP_NOACTIVATE);
      return;
    }
  GetWindowRect(hwnd, &rect);
  GetWindowRect(Xhwnd, &rectP);
  width=rect.right-rect.left;
  x=((rectP.right-rectP.left)-width)*0.5+rectP.left;
  if(Yhwnd==NULL) {
      height=rect.bottom-rect.top;
      y=((rectP.bottom-rectP.top)-height)*0.5+rectP.top;
    }
  else
    {
      GetWindowRect(Yhwnd, &rectP);;
      height=rect.bottom-rect.top;;
      y=((rectP.bottom-rectP.top)-height)*0.5+rectP.top;;
    }
  screenwidth=MonitorInfo.rcWork.right;
  screenheight=MonitorInfo.rcWork.bottom;
	if(x<MonitorInfo.rcWork.left) {
    x=MonitorInfo.rcWork.left+(width/2);
  }
  if(y<MonitorInfo.rcWork.top) {
      y=MonitorInfo.rcWork.top+(height/2);
    }
  if(((x+width>screenwidth))) {
      x=screenwidth-width;;
    }
  if(((y+height>screenheight))) {
      y=screenheight-height;;
    }
  MoveWindow (hwnd, x, y, width, height, FALSE);
}


HWND BCX_Form (LPCTSTR Caption, int X, int Y, int W, int H, int Style, int Exstyle) {
  if (Style == -1) Style = WS_MINIMIZEBOX|WS_SIZEBOX|WS_CAPTION|WS_MAXIMIZEBOX|WS_POPUP|WS_SYSMENU;
  
  HWND A = CreateWindowEx(Exstyle, BCX_ClassName, Caption, Style, X*BCX_ScaleX, Y*BCX_ScaleY,
         BCX_ScaleX*(4+W), BCX_ScaleY*(12+H), NULL,(HMENU)(UINT_PTR)NULL, BCX_hInstance, NULL);
           
  SendMessage (A,(UINT_PTR) WM_SETFONT, (WPARAM)((BcxFont==0) ? GetStockObject
              (DEFAULT_GUI_FONT):BcxFont), (LPARAM) MAKELPARAM(FALSE, 0));
  return A;
}


HWND BCX_Button(LPCTSTR Text, HWND hWnd, int id, int X, int Y, int W, int H, int Style, int Exstyle) {
  if (!Style)
      Style = WS_CHILD | WS_VISIBLE | BS_MULTILINE | BS_PUSHBUTTON | WS_TABSTOP;
  if (Exstyle == -1)
      Exstyle = WS_EX_STATICEDGE;
  HWND A = CreateWindowEx(Exstyle,"button", Text, Style,
           X*BCX_ScaleX, Y*BCX_ScaleY, W*BCX_ScaleX, H*BCX_ScaleY,
           hWnd,(HMENU)(UINT_PTR)id, BCX_hInstance, NULL);
  SendMessage(A, (UINT_PTR)WM_SETFONT, (WPARAM)DefaultFont, (LPARAM)MAKELPARAM(FALSE, 0));
  if (W==0)
    {
      SIZE* size = GetTextSize(Text, A);
      MoveWindow(A, X*BCX_ScaleX, Y*BCX_ScaleY, size->cx+24, size->cy+12, TRUE);
    }
  return A;
}


HWND BCX_Edit(LPCTSTR Text, HWND hWnd, int id, int X, int Y, int W, int H, int Style, int Exstyle) { 
  HWND  A;
  if (!Style)
    {
      Style = WS_CHILD | WS_VISIBLE | ES_WANTRETURN |
              WS_VSCROLL | ES_MULTILINE | ES_AUTOVSCROLL | ES_AUTOHSCROLL;
    }
  if (Exstyle==-1)
      Exstyle = WS_EX_CLIENTEDGE;
  A = CreateWindowEx(Exstyle,"edit", Text, Style,
      X*BCX_ScaleX, Y*BCX_ScaleY, W*BCX_ScaleX, H*BCX_ScaleY,
      hWnd, (HMENU)(UINT_PTR)id, BCX_hInstance, NULL);
  SendMessage(A, (UINT_PTR)WM_SETFONT, (WPARAM)DefaultFont, (LPARAM)MAKELPARAM(FALSE, 0));
  return A;
}


HWND BCX_Label(LPCTSTR Text, HWND hWnd, int id, int X, int Y, int W, int H, int Style, int Exstyle) {
  if (!Style)
      Style = WS_CHILD | SS_NOTIFY | SS_LEFT | WS_VISIBLE;
  HWND A = CreateWindowEx(Exstyle,"static",Text, Style,
           X*BCX_ScaleX, Y*BCX_ScaleY, W*BCX_ScaleX, H*BCX_ScaleY,
           hWnd, (HMENU)(UINT_PTR)id, BCX_hInstance, NULL);
  SendMessage(A, (UINT_PTR)WM_SETFONT, (WPARAM)DefaultFont, (LPARAM)MAKELPARAM(FALSE, 0));
  if (W==0)
    {
      SIZE*  size = GetTextSize(Text, A);
      MoveWindow(A, X*BCX_ScaleX, Y*BCX_ScaleY, size->cx, size->cy, TRUE);
   }
  return A;
}


SIZE* GetTextSize (LPCTSTR Text, HWND hWnd, HFONT fnt) {
  HDC  hdc = GetDC(hWnd);
  if (!fnt) fnt=(HFONT)SendMessage(hWnd, WM_GETFONT, 0, 0);
  HFONT sobj=(HFONT)SelectObject(hdc, fnt);
  static SIZE sz;
  GetTextExtentPoint32(hdc, (char*)Text, strlen(Text), &sz);
  SelectObject(hdc, sobj);
  ReleaseDC(hWnd, hdc);
  return (&sz);
}


char *BCX_Get_Text (HWND hWnd) {
  int tmpint;
  tmpint = 1 + GetWindowTextLength(hWnd);
  char *strtmp = BCX_TmpStr(tmpint);
  GetWindowText(hWnd,strtmp,tmpint);
  return strtmp;
}


int BCX_Set_Text (HWND hWnd, LPCTSTR Text) {
  return SetWindowText(hWnd,Text);
}


char *StrToken (LPCTSTR Source, LPCTSTR TokenChar, int n) {
  char *BCX_RetStr = NULL;
  char *RetVal = NULL;
  LPCTSTR Copy = NULL;
  int   Posn = 0;
  int   Find = 0;
  int LenSrc = (int)strlen(Source);
  Copy = Source;
  if (tally(Source,TokenChar)==0)
    {
      BCX_RetStr=BCX_TmpStr(1);
      return BCX_RetStr;
    }
  if (n==1)
    {
      BCX_RetStr = BCX_TmpStr(LenSrc);
      strcpy(BCX_RetStr,(char*)extract(Source,TokenChar));
      return BCX_RetStr;
    }
  if (n>tally(Source,TokenChar)+1)
    {
      BCX_RetStr=BCX_TmpStr(1);
      return BCX_RetStr;
    }
  while(*Copy)
    {
      if (*Copy==TokenChar[0]) Find++;
      if (Find==n) break;
      Copy++;
      Posn++;
    }
  if (n==tally(Source,TokenChar)+1)
    {
      Posn=LenSrc;
      Copy=Source+Posn;
      while(*Copy && Source[Posn]!=TokenChar[0])
        {
          Posn--;
          Copy--;
        }
    }
  RetVal = (char*)calloc(LenSrc+1,sizeof(char));
  strcpy(RetVal,(char*)mid(Source,1,Posn));
  strcpy(RetVal,(char*)mid(RetVal,InstrRev(RetVal,TokenChar)));
  BCX_RetStr=BCX_TmpStr(LenSrc);
  strcpy(BCX_RetStr,(char*)RemoveStr(RetVal,(char*)TokenChar));
  if (RetVal)free(RetVal);
  return BCX_RetStr;
}


void BCX_SetMetric (LPCTSTR metric) {
  if (!BCX_GUI_Init)
      BCX_InitGUI();
  if (_stricmp(metric,"PIXELS")==0)
    {
      BCX_ScaleX = 1;
      BCX_ScaleY = 1;
    }
   else if (_stricmp((char*)metric,"DPI")==0)
     {
       HDC  hDc = GetDC(0);
       BCX_ScaleX = ( GetDeviceCaps( hDc, LOGPIXELSX) / 96.0f);
       BCX_ScaleY = ( GetDeviceCaps( hDc, LOGPIXELSY) / 96.0f);
       ReleaseDC(0, hDc);
     }
  else
    {
      RECT  rc = {0,0,4,8};
      MapDialogRect(NULL,&rc);
      BCX_ScaleX = rc.right/2;
      BCX_ScaleY = rc.bottom/4;
    }
}


void BCX_RegWnd (LPCTSTR classname, WNDPROC Form_WndProc) {
  if (classname[0]==0)
    {
      MessageBox (GetActiveWindow(),
      "Empty String For BCX_ClassName NOT Allowed",
      "Empty ClassName",0);
      fflush(stdout);
      ExitProcess(1);
    }
  if (GetClassInfoEx( BCX_hInstance, classname, &BCX_WndClass)!=0)
    {
      if (!Form_WndProc)
          UnregisterClass(classname,BCX_hInstance);
      return;
    }
  if (!BCX_GUI_Init)
      BCX_InitGUI();
  if (BCX_ScaleX == 0 && BCX_ScaleY == 0)
      BCX_SetMetric("Pixels");
  strcpy(BCX_ClassName,classname);
  BCX_WndClass.lpfnWndProc = Form_WndProc;
  BCX_WndClass.hInstance = BCX_hInstance;
  BCX_WndClass.lpszClassName = classname;
  RegisterClassEx(&BCX_WndClass);
}


void BCX_InitGUI (void) {
  INITCOMMONCONTROLSEX  iccex;
  if (BCX_GUI_Init)
      return;
  BCX_ScaleX = 1;
  BCX_ScaleY = 1;
  BCX_hInstance = GetModuleHandle(NULL);
  BCX_hwndMDIClient = NULL;
  BCX_WndClass.cbSize = sizeof(BCX_WndClass);
  BCX_WndClass.style = CS_HREDRAW | CS_VREDRAW | CS_OWNDC | CS_DBLCLKS;
  BCX_WndClass.cbClsExtra = 0;
  BCX_WndClass.cbWndExtra = 0;
  BCX_WndClass.hIcon =  LoadIcon(NULL,IDI_WINLOGO);;
  BCX_WndClass.hCursor = LoadCursor(NULL, IDC_ARROW);
  BCX_WndClass.hbrBackground = (HBRUSH)(COLOR_BTNFACE+1);
  BCX_WndClass.lpszMenuName = NULL;
  BCX_WndClass.hIconSm = NULL;
  iccex.dwSize = sizeof(INITCOMMONCONTROLSEX);
  iccex.dwICC=ICC_LISTVIEW_CLASSES | ICC_TREEVIEW_CLASSES |
              ICC_BAR_CLASSES | ICC_TAB_CLASSES | ICC_UPDOWN_CLASS |
              ICC_PROGRESS_CLASS | ICC_USEREX_CLASSES | ICC_DATE_CLASSES;
  InitCommonControlsEx(&iccex);
  OleInitialize(0);
  CoInitialize(0);
  BCX_GUI_Init = TRUE;
}


// *************************************************
//            User's Subs and Functions
// *************************************************

float DecodeSonar (char* RecvString)
{
  char  **h=0;
  {
  size_t dimensions[2] = {(size_t)1, (size_t)BCXSTRSIZE};
  h= (char**)CreateArr (h,sizeof(char),0,2, dimensions);
  }
  char  **lines=0;
  {
  size_t dimensions[2] = {(size_t)1, (size_t)BCXSTRSIZE};
  lines= (char**)CreateArr (lines,sizeof(char),0,2, dimensions);
  }
  int     NoOfLines={0};
  int     MyData={0};
  int     LastSDDLine={0};
  float    WaterDepth={0};
  int     i={0};
  NoOfLines=FastLexer( &lines,RecvString,CR,"",1);
  for(i=1; i<=(NoOfLines); i+=1)
    {
      if(instr(lines[i],"DBT")){
          MyData=FastLexer( &h,lines[i],",","",1);
          WaterDepth=VAL(h[2]);
        }
    }
  if (h) { DestroyArr((void **)h, 2, 1); h=NULL; }
  if (lines) { DestroyArr((void **)lines, 2, 1); lines=NULL; }
  return WaterDepth;
}


ULONG DecodeGPS (char* RecvString)
{
  char  **h=0;
  {
  size_t dimensions[2] = {(size_t)1, (size_t)BCXSTRSIZE};
  h= (char**)CreateArr (h,sizeof(char),0,2, dimensions);
  }
  char  **lines=0;
  {
  size_t dimensions[2] = {(size_t)1, (size_t)BCXSTRSIZE};
  lines= (char**)CreateArr (lines,sizeof(char),0,2, dimensions);
  }
  int     NoOfLines={0};
  int     MyData={0};
  int     i={0};
  int      North={0};
  SetLastError(0);
  NoOfLines=FastLexer( &lines,RecvString,"$","",1);
  if(NoOfLines==0 ){
      if (h) { DestroyArr((void **)h, 2, 1); h=NULL; }
      if (lines) { DestroyArr((void **)lines, 2, 1); lines=NULL; }
      return 0;
    }
  for(i=1; i<=NoOfLines; i+=1)
    {
      MyData=FastLexer( &h,lines[i],",","",1);
      if(MyData<10 ){
          continue;
        }
      if(instr(h[1],"PASHR")){
          if(VAL(h[1])==1 ){
              LastGPS.Differential=TRUE;
            }
          else
            {
              LastGPS.Differential=FALSE;
            }
          LastGPS.SVS=VAL(h[2]);
          LastGPS.Time=VAL(h[3]);
          LastGPS.Lat=VAL(h[4]);
          if(instr(h[5],"S")){
              LastGPS.Lat=LastGPS.Lat*-1;
            }
          LastGPS.Lon=VAL(h[6]);
          if(instr(h[7],"W")){
              LastGPS.Lon=LastGPS.Lon*-1;
            }
          LastGPS.Alt=VAL(h[8]);
          LastGPS.HDOP=VAL(h[14]);
          LastGPS.VDOP=VAL(h[15]);
          goto ENDFUNCT;
        }
      if(instr(h[1],"GPGGA")){
          LastGPS.Time=VAL(h[2]);
          LastGPS.Lat=DDMMtoDDec(h[3]);
          if(instr(h[3],"S")){
              LastGPS.Lat=LastGPS.Lat*-1;
            }
          LastGPS.Lon=DDMMtoDDec(h[5]);
          if(instr(h[6],"W")){
              LastGPS.Lon=LastGPS.Lon*-1;
            }
          LastGPS.Differential=VAL(h[7]);
          LastGPS.SVS=VAL(h[8]);
          LastGPS.HDOP=VAL(h[9]);
          LastGPS.Alt=(VAL(h[10])*3.281);
          goto ENDFUNCT;
        }
    }

ENDFUNCT:;
  if (h) { DestroyArr((void **)h, 2, 1); h=NULL; }
  if (lines) { DestroyArr((void **)lines, 2, 1); lines=NULL; }
  return GetLastError();
}


int FastLexer (char*** sStkOut,char* sArg,char* sDelim1,char* sDelim2,int iMinLen)
{
  int     iCNT1=0;
  int     iCNT2=0;
  PCHAR    psD1;
  PCHAR    psD2;
  int     iNdx=1;
  char  **szW=0;
  {
  size_t dimensions[2] = {(size_t)1, (size_t)1};
  szW= (char**)CreateArr (szW,sizeof(char),0,2, dimensions);
  }
  PCHAR*   sStk;
  int     fl_Fields=1;
  int     fl_MaxFieldLen=0;
  if (szW) { DestroyArr((void **)szW, 2, 1); szW=NULL; }
  if (szW) { DestroyArr((void **)szW, 2, 1); szW=NULL; }
  if(iMinLen ){
      while(sArg[iCNT1]){
          if(sArg[iCNT1]==34 ){
              if(iCNT2 ){
                  fl_Fields++;
                  if(fl_MaxFieldLen<iCNT2 ){
                      fl_MaxFieldLen=iCNT2;
                    }
                  iCNT2=0;
                }
              while(sArg[++iCNT1]!=34){
                  iCNT2++;
                  if(sArg[iCNT1]==0 ){
                      goto EXFIELDCNT;
                    }
                  if(sArg[iCNT1]==10||sArg[iCNT1]==13 ){
                      sArg[iCNT1]=34;
                      goto L1003;
                    }
                }
L1003:;
              fl_Fields++;
              if(fl_MaxFieldLen<iCNT2 ){
                  fl_MaxFieldLen=iCNT2;
                }
              iCNT2=0;
              goto FIELDCNT;
            }
          psD1=sDelim1;
          while(*psD1){
              if(*(psD1++)==sArg[iCNT1]){
                  if(iCNT2 ){
                      fl_Fields++;
                      if(fl_MaxFieldLen<iCNT2 ){
                          fl_MaxFieldLen=iCNT2;
                        }
                      iCNT2=0;
                    }
                  goto FIELDCNT;
                }
            }
          psD2=sDelim2;
          while(*psD2){
              if(*(psD2++)==sArg[iCNT1]){
                  if(iCNT2 ){
                      fl_Fields++;
                    }
                  fl_Fields++;
                  if(fl_MaxFieldLen<iCNT2 ){
                      fl_MaxFieldLen=iCNT2;
                    }
                  iCNT2=0;
                  goto FIELDCNT;
                }
            }
          iCNT2++;

FIELDCNT:;
          iCNT1++;
        }
      if(fl_MaxFieldLen<iCNT2 ){
          fl_MaxFieldLen=iCNT2;
        }

EXFIELDCNT:;
      fl_MaxFieldLen+=2;
      iCNT1=0;
      iCNT2=0;
      szW=*sStkOut;
      if (szW) { DestroyArr((void **)szW, 2, 1); szW=NULL; }
      szW=NULL;
      if(iMinLen ){
          if(iMinLen>fl_MaxFieldLen ){
              fl_MaxFieldLen=iMinLen;
            }
        }
      if (szW) { DestroyArr((void **)szW, 2, 1); szW=NULL; }
      {
      size_t dimensions[2] = {(size_t)fl_Fields+2, (size_t)fl_MaxFieldLen};
      szW= (char**)CreateArr (szW, sizeof(char), 0, 2, dimensions);
      }
      *sStkOut=szW;
      sStk=*sStkOut;
      szW=NULL;
    }
  else
    {
      sStk=*sStkOut;
    }
  while(sArg[iCNT1]){
      if(sArg[iCNT1]==34 ){
          if(iCNT2 ){
              sStk[iNdx++][iCNT2]=0;
              iCNT2=0;
            }
          sStk[iNdx][0]=34;
          while(sArg[++iCNT1]!=34){
              sStk[iNdx][++iCNT2]=sArg[iCNT1];
              if(sArg[iCNT1]==0 ){
                  goto EX;
                }
              if(sArg[iCNT1]==10||sArg[iCNT1]==13 ){
                  sArg[iCNT1]=34;
                  goto L1007;
                }
            }
L1007:;
          sStk[iNdx][++iCNT2]=sArg[iCNT1];
          sStk[iNdx++][++iCNT2]=0;
          iCNT2=0;
          goto AGAIN;
        }
      psD1=sDelim1;
      while(*psD1){
          if(*(psD1++)==sArg[iCNT1]){
              if(iCNT2 ){
                  sStk[iNdx++][iCNT2]=0;
                  iCNT2=0;
                }
              goto AGAIN;
            }
        }
      psD2=sDelim2;
      while(*psD2){
          if(*(psD2++)==sArg[iCNT1]){
              if(iCNT2 ){
                  sStk[iNdx++][iCNT2]=0;
                }
              sStk[iNdx][0]=sArg[iCNT1];
              sStk[iNdx++][1]=0;
              iCNT2=0;
              goto AGAIN;
            }
        }
      sStk[iNdx][iCNT2++]=sArg[iCNT1];

AGAIN:;
      iCNT1++;
    }
  sStk[iNdx][iCNT2]=0;
  if(iCNT2==0 ){
      iNdx--;
    }

EX:;
  if (szW) { DestroyArr((void **)szW, 2, 1); szW=NULL; }
  return iNdx;
}


RECT MoveAnchorControl (HWND hWnd,int anchor)
{
  RECT     newRC;
  RECT     ctrlrc;
  RECT     prc;
  double   scalefactor;
  HWND     hParent;
  LPANCHOR  pa;
  hParent=GetParent(hWnd);
  prc=GetScaledRect(hParent);
  pa=(LPANCHOR)GetProp(hParent,(LPCSTR)"Anchor");
  if(!pa ){
      return prc;
    }
  ctrlrc=GetScaledRect(hWnd);
  if(prc.right<pa->XMin ){
      prc.right=pa->XMin;
    }
  if(prc.bottom<pa->YMin ){
      prc.bottom=pa->YMin;
    }
  if(pa->IsSubForm ){
      ctrlrc.left=MAX(0,ctrlrc.left-prc.left);
      ctrlrc.top=MAX(0,ctrlrc.top-prc.top);
    }
  else
    {
      ctrlrc.left=MAX(0,ctrlrc.left-prc.left-GetSystemMetrics(SM_CXSIZEFRAME));
      ctrlrc.top=MAX(0,ctrlrc.top-prc.top-GetSystemMetrics(SM_CYCAPTION)-GetSystemMetrics(SM_CYSIZEFRAME));
    }
  if(GetMenu(hParent)){
      ctrlrc.top=ctrlrc.top-(GetSystemMetrics(SM_CYMENUSIZE)+1);
    }
  newRC=ctrlrc;
  scalefactor=CDBL(prc.right-(2*GetSystemMetrics(SM_CXSIZEFRAME)))/CDBL(pa->PrevRC.right-(2*GetSystemMetrics(SM_CXSIZEFRAME)));
  if((anchor&(AnchorLeft+AnchorRight+AnchorHCenter))==AnchorRight ){
      newRC.left=prc.right-(pa->PrevRC.right-ctrlrc.left);
      goto L1010;
    }
  if((anchor&(AnchorLeft+AnchorRight+AnchorHCenter))==AnchorLeft+AnchorRight ){
      newRC.right=prc.right-(pa->PrevRC.right-ctrlrc.right);
      goto L1010;
    }
  if((anchor&(AnchorLeft+AnchorRight+AnchorHCenter))==AnchorHCenter ){
      newRC.left=ctrlrc.left-((pa->PrevRC.right-prc.right)/2);
      goto L1010;
    }
  if((anchor&(AnchorLeft+AnchorRight+AnchorHCenter))==AnchorRight+AnchorHCenter ){
      newRC.right=Cint(CDBL(ctrlrc.right)*scalefactor);
      newRC.left=prc.right-(pa->PrevRC.right-ctrlrc.left);
      newRC.left=newRC.left+ctrlrc.right-newRC.right;
      goto L1010;
    }
  if((anchor&(AnchorLeft+AnchorRight+AnchorHCenter))==AnchorLeft+AnchorHCenter ){
      newRC.right=Cint(CDBL(ctrlrc.right)*scalefactor);
      goto L1010;
    }
  if((anchor&(AnchorLeft+AnchorRight+AnchorHCenter))==AnchorLeft+AnchorRight+AnchorHCenter ){
      newRC.right=Cint(CDBL(ctrlrc.right)*scalefactor);
      newRC.left=Cint(CDBL(ctrlrc.left)*scalefactor);
    }
L1010:;
  scalefactor=CDBL(prc.bottom)/CDBL(pa->PrevRC.bottom);
  if((anchor&(AnchorTop+AnchorBottom+AnchorVCenter))==AnchorBottom ){
      newRC.top=prc.bottom-(pa->PrevRC.bottom-ctrlrc.top);
      goto L1011;
    }
  if((anchor&(AnchorTop+AnchorBottom+AnchorVCenter))==AnchorTop+AnchorBottom ){
      newRC.bottom=prc.bottom-(pa->PrevRC.bottom-ctrlrc.bottom);
      goto L1011;
    }
  if((anchor&(AnchorTop+AnchorBottom+AnchorVCenter))==AnchorVCenter ){
      newRC.top=ctrlrc.top-((pa->PrevRC.bottom-prc.bottom)/2);
      goto L1011;
    }
  if((anchor&(AnchorTop+AnchorBottom+AnchorVCenter))==AnchorBottom+AnchorVCenter ){
      newRC.bottom=Cint(CDBL(ctrlrc.bottom)*scalefactor);
      newRC.top=prc.bottom-(pa->PrevRC.bottom-ctrlrc.top);
      newRC.top=newRC.top+ctrlrc.bottom-newRC.bottom;
      goto L1011;
    }
  if((anchor&(AnchorTop+AnchorBottom+AnchorVCenter))==AnchorTop+AnchorVCenter ){
      newRC.bottom=Cint(CDBL(ctrlrc.bottom)*scalefactor);
      goto L1011;
    }
  if((anchor&(AnchorTop+AnchorBottom+AnchorVCenter))==(AnchorTop+AnchorBottom+AnchorVCenter)){
      newRC.bottom=Cint(CDBL(ctrlrc.bottom)*scalefactor);
      newRC.top=Cint(CDBL(ctrlrc.top)*scalefactor);
    }
L1011:;
  MoveWindow(hWnd,newRC.left,newRC.top,newRC.right,newRC.bottom,0);
  return newRC;
}


void InitAnchor (HWND hWnd,int IsSubForm)
{
  LPANCHOR  pa;
  HWND*    tmphWnd={0};
  int     i;
  int     cnt;
  pa=malloc(sizeof(*pa));
  if(IsSubForm==2 ){
      tmphWnd=(HWND*)GetWindowLongPtr(hWnd,GWLP_USERDATA);
      pa->PrevRC=GetScaledRect(tmphWnd[0]);
    }
  else
    {
      pa->PrevRC=GetScaledRect(hWnd);
    }
  pa->XMin=pa->PrevRC.right;
  pa->YMin=pa->PrevRC.bottom;
  pa->IsSubForm=IsSubForm;
  if(IsSubForm==2 ){
      cnt=TabCtrl_GetItemCount(hWnd)-1;
      for(i=0; i<=cnt; i+=1)
        {
          SetProp(tmphWnd[i],"Anchor",(HANDLE)pa);
        }
    }
  SetProp(hWnd,"Anchor",(HANDLE)pa);
}


void UpdateAnchor (HWND hWnd)
{
  LPANCHOR  pa;
  HWND*    tmphWnd={0};
  pa=(LPANCHOR)GetProp(hWnd,(LPCSTR)"Anchor");
  if(pa ){
      if(pa->IsSubForm==2 ){
          tmphWnd=(HWND*)GetWindowLongPtr(hWnd,GWLP_USERDATA);
          pa->PrevRC=GetScaledRect(tmphWnd[0]);
        }
      else
        {
          pa->PrevRC=GetScaledRect(hWnd);
        }
      if(pa->PrevRC.right<pa->XMin ){
          pa->PrevRC.right=pa->XMin;
        }
      if(pa->PrevRC.bottom<pa->YMin ){
          pa->PrevRC.bottom=pa->YMin;
        }
    }
}


RECT GetScaledRect (HWND hWnd)
{
  RECT     tmp3RC={0};
  GetWindowRect(hWnd, &tmp3RC);
  tmp3RC.right=(tmp3RC.right-tmp3RC.left);
  tmp3RC.bottom=(tmp3RC.bottom-tmp3RC.top);
  return tmp3RC;
}


void FormLoad (void)
{
  HFONT    hFont={0};
  Form1=BCX_Form("Test Comm Ports",0,0,662,425);
  hStc1=BCX_Label("Comm A",Form1,ID_Stc1,10,10,310,20,Stc1_Style,Stc1_ExtStyle);
  hStc2=BCX_Label("Comm B",Form1,ID_Stc2,335,10,310,20,Stc2_Style,Stc2_ExtStyle);
  hEdt1=BCX_Edit("Edit",Form1,ID_Edt1,10,30,310,20,Edt1_Style,Edt1_ExtStyle);
  hEdt2=BCX_Edit("Edit",Form1,ID_Edt2,335,30,310,20,Edt2_Style,Edt2_ExtStyle);
  hEdt3=BCX_Edit("CommA Data1",Form1,ID_Edt3,10,50,310,200,Edt3_Style,Edt3_ExtStyle);
  hEdt4=BCX_Edit("CommB Data2",Form1,ID_Edt4,335,50,310,300,Edt4_Style,Edt4_ExtStyle);
  hEdt5=BCX_Edit("CommA Data1",Form1,ID_Edt5,10,250,310,100,Edt3_Style,Edt3_ExtStyle);
  hEdt6=BCX_Edit("CommB Data2",Form1,ID_Edt6,335,250,310,100,Edt4_Style,Edt4_ExtStyle);
  hBtn1=BCX_Button("Open A",Form1,ID_Btn1,20,360,100,30,Btn1_Style,Btn1_ExtStyle);
  hBtn2=BCX_Button("Open B",Form1,ID_Btn2,300,360,100,30,Btn2_Style,Btn2_ExtStyle);
  hBtn3=BCX_Button("END ALL",Form1,ID_Btn3,540,360,100,30,Btn3_Style,Btn3_ExtStyle);
  hBtn4=BCX_Button("Config A",Form1,ID_Btn4,140,360,100,30,Btn3_Style,Btn3_ExtStyle);
  hBtn5=BCX_Button("Config B",Form1,ID_Btn5,420,360,100,30,Btn3_Style,Btn3_ExtStyle);
  CommA.Port=1;
  CommA.Baud=9600;
  CommA.StopBits=1;
  CommA.DataBits=8;
  CommA.Parity=0;
  CommA.XonXoff=0;
  CommA.OPEN=0;
  CommB.Port=7;
  CommB.Baud=9600;
  CommB.StopBits=1;
  CommB.DataBits=8;
  CommB.Parity=0;
  CommB.XonXoff=0;
  CommB.OPEN=0;
  BCX_Set_Text(hEdt1,join(9,str(CommA.Port),chr(44),str(CommA.Baud),chr(44),str(CommA.Parity),chr(44),str(CommA.DataBits),chr(44),str(CommA.StopBits)));
  BCX_Set_Text(hEdt2,join(9,str(CommB.Port),chr(44),str(CommB.Baud),chr(44),str(CommB.Parity),chr(44),str(CommB.DataBits),chr(44),str(CommB.StopBits)));
  InitAnchor(Form1);
  Center(Form1);
  Show(Form1);
}


LRESULT CALLBACK WndProc (HWND hWnd,UINT Msg,WPARAM wParam,LPARAM lParam)
{
  static char    commA_Buffer[BCXSTRSIZE];
  static char    commB_Buffer[BCXSTRSIZE];
  static int     counter;
  if(Msg==WM_COMMAND ){
      if(LOWORD(wParam)==ID_Btn1 ){
          if(!CommA.OPEN ){
              if((int)strlen(BCX_Get_Text(hEdt1))){
                  ParseCommString(BCX_Get_Text(hEdt1),CommA);
                }
              if(OpenComm(Form1,CommA.Port,CommA.Baud,CommA.Parity,CommA.DataBits,CommA.StopBits,CommA.XonXoff,4096,4096)){
                  BCX_Set_Text(hBtn1,"Close A");
                  CommA.OPEN=TRUE;
                }
            }
          else
            {
              CommA.OPEN=CloseComm(CommA.Port);
              if(!CommA.OPEN ){
                  BCX_Set_Text(hBtn1,"Open A");
                }
            }
          goto L1014;
        }
      if(LOWORD(wParam)==ID_Btn2 ){
          if(!CommB.OPEN ){
              if((int)strlen(BCX_Get_Text(hEdt2))){
                  ParseCommString(BCX_Get_Text(hEdt2),CommB);
                }
              if(OpenComm(Form1,CommB.Port,CommB.Baud,CommB.Parity,CommB.DataBits,CommB.StopBits,CommB.XonXoff,4096,4096)){
                  BCX_Set_Text(hBtn2,"Close B");
                  CommB.OPEN=TRUE;
                }
            }
          else
            {
              CommB.OPEN=CloseComm(CommB.Port);
              if(!CommA.OPEN ){
                  BCX_Set_Text(hBtn2,"Open B");
                }
            }
          goto L1014;
        }
      if(LOWORD(wParam)==ID_Btn3 ){
          CloseComm(CommA.Port);
          CloseComm(CommB.Port);
          ExitComms();
          PostQuitMessage(0);
          goto L1014;
        }
      if(LOWORD(wParam)==ID_Btn4 ){
          int     WasOpen={0};
          WasOpen=CommA.OPEN;
          printf("%s%s%s%s\n","A Open1 = ",str(CommA.OPEN),"  ",str(WasOpen));
          if(CommA.OPEN ){
              CommA.OPEN=CloseComm(CommA.Port);
            }
          printf("%s%s%s%s\n","A OPEN2 = ",str(CommA.OPEN),"  ",str(WasOpen));
          CommSettings(Form1, &CommA.Port, &CommA.Baud, &CommA.Parity, &CommA.DataBits, &CommA.StopBits, &CommA.XonXoff);
          if(GetLastError()){
              printf("%s%s\n","Error: ",str(GetLastError()));
            }
          BCX_Set_Text(hEdt1,join(9,str(CommA.Port),chr(44),str(CommA.Baud),chr(44),str(CommA.Parity),chr(44),str(CommA.DataBits),chr(44),str(CommA.StopBits)));
          printf("%s%s%s%s\n","A Open3 = ",str(CommA.OPEN),"  ",str(WasOpen));
          if(WasOpen ){
              CommA.OPEN=OpenComm(Form1,CommA.Port,CommA.Baud,CommA.Parity,CommA.DataBits,CommA.StopBits,CommA.XonXoff,4096,4096);
              if(CommA.OPEN ){
                  BCX_Set_Text(hBtn1,"Close A");
                }
              else
                {
                  BCX_Set_Text(hBtn1,"Open A");
                }
            }
          goto L1014;
        }
      if(LOWORD(wParam)==ID_Btn5 ){
          int     WasOpen={0};
          if(CommB.OPEN ){
              CommB.OPEN=CloseComm(CommB.Port);
              WasOpen++;
            }
          CommSettings(Form1, &CommB.Port, &CommB.Baud, &CommB.Parity, &CommB.DataBits, &CommB.StopBits, &CommB.XonXoff);
          if(GetLastError()){
              printf("%s%s\n","Error: ",str(GetLastError()));
            }
          BCX_Set_Text(hEdt1,join(9,str(CommB.Port),chr(44),str(CommB.Baud),chr(44),str(CommB.Parity),chr(44),str(CommB.DataBits),chr(44),str(CommB.StopBits)));
          if(WasOpen ){
              CommB.OPEN=OpenComm(Form1,CommB.Port,CommB.Baud,CommB.Parity,CommB.DataBits,CommB.StopBits,CommB.XonXoff,4096,4096);
              if(CommB.OPEN ){
                  BCX_Set_Text(hBtn2,"Close A");
                }
              else
                {
                  BCX_Set_Text(hBtn2,"Open A");
                }
            }
        }
L1014:;
      goto L1013;
    }
  if(Msg==WM_RCVDATA ){
      if(wParam==CommA.Port ){
          strcpy(CommA.rcvbuf,RecvCommData(wParam,lParam));
          strcat(commA_Buffer,trim(CommA.rcvbuf));
          if(instr(commA_Buffer,"DBT",1,1)){
              strcpy(commA_Buffer,right(commA_Buffer,(int)strlen(commA_Buffer)-InstrRev(commA_Buffer,"$")));
              BCX_Set_Text(hEdt3,join(2,commA_Buffer,CRLF));
              BCX_Set_Text(hEdt5,join(2,"DBT: ",AddSonar(commA_Buffer)));
            }
          else
            {
              if((int)strlen(commA_Buffer)>600 ){
                  strcpy(commA_Buffer,mid(commA_Buffer,(int)strlen(commA_Buffer)-InstrRev(commA_Buffer,"$")));
                }
              counter++;
              BCX_Set_Text(hEdt3,join(2,commA_Buffer,CRLF));
              BCX_Set_Text(hEdt5,join(4,AddGPS(commA_Buffer),"counter:     ",str(counter),CRLF));
              if(counter>1000 ){
                  counter=0;
                }
            }
        }
      else if(wParam==CommB.Port ){
          strcpy(CommB.rcvbuf,RecvCommData(wParam,lParam));
          strcat(commB_Buffer,trim(CommB.rcvbuf));
          if(instr(commB_Buffer,"DBT",1,1)){
              strcpy(commB_Buffer,right(commB_Buffer,(int)strlen(commB_Buffer)-InstrRev(commB_Buffer,"$")));
              BCX_Set_Text(hEdt4,join(2,commB_Buffer,CRLF));
              BCX_Set_Text(hEdt6,join(2,"DBT: ",AddSonar(commB_Buffer)));
            }
          else
            {
              if((int)strlen(commB_Buffer)>600 ){
                  strcpy(commB_Buffer,right(commB_Buffer,(int)strlen(commB_Buffer)-InstrRev(commB_Buffer,"$")));
                }
              counter++;
              if(fmod(counter,10)==0 ){
                  BCX_Set_Text(hEdt4,join(2,commB_Buffer,CRLF));
                  BCX_Set_Text(hEdt6,join(4,AddGPS(commB_Buffer),"counter:     ",str(counter),CRLF));
                  if(counter>1000 ){
                      counter=0;
                    }
                }
            }
        }
      goto L1013;
    }
  if(Msg==WM_SIZE ){
      if(hWnd==Form1 ){
          if(wParam!=SIZE_MINIMIZED ){
              ReSizeForm1();
              UpdateAnchor(Form1);
            }
        }
      goto L1013;
    }
  if(Msg==WM_CLOSE ){
      CloseComm(CommA.Port);
      CloseComm(CommB.Port);
      ExitComms();
      PostQuitMessage(0);
    }
L1013:;
  if(Msg==WM_DESTROY)
    {
       OleUninitialize();
       CoUninitialize();
       PostQuitMessage(0);
       return EXIT_SUCCESS;
    }
 return DefWindowProc(hWnd,Msg,wParam,lParam); // endevents
}


char * AddSonar (char* buf)
{
  char *BCX_RetStr={0};
  BCX_RetStr=str(DecodeSonar(buf));
  return BCX_RetStr;
}


char * AddGPS (char* buf)
{
  char *BCX_RetStr={0};
  char    sRet[BCXSTRSIZE]={0};
  BCX_Set_Text(hEdt6,"");
  DecodeGPS(buf);
  strcpy(sRet, join(3,"Northing:    ",str(Round(LastGPS.Lat,9)),CRLF));
  strcpy(sRet, join(4,sRet,"Easting: ",str(Round(LastGPS.Lon,9)),CRLF));
  strcpy(sRet, join(4,sRet,"Alt:     ",str(Round(LastGPS.Alt,3)),CRLF));
  strcpy(sRet, join(4,sRet,"Differential:     ",str(LastGPS.Differential),CRLF));
  BCX_RetStr = BCX_TmpStr(strlen(sRet));
  strcpy(BCX_RetStr,sRet);
  return BCX_RetStr;
}


void ParseCommString (char* comm,BCX_COMM_PORT commtype)
{
  commtype.Port=VAL(Parse(comm,chr(44),1));
  commtype.Baud=VAL(Parse(comm,chr(44),2));
  if(strcmp(Parse(comm,chr(44),3),"N")==0){
      commtype.Parity=0;
    }
  else if(strcmp(Parse(comm,chr(44),3),"O")==0){
      commtype.Parity=1;
    }
  else if(strcmp(Parse(comm,chr(44),3),"E")==0){
      commtype.Parity=2;
    }
  else if(strcmp(Parse(comm,chr(44),3),"M")==0){
      commtype.Parity=3;
    }
  else if(strcmp(Parse(comm,chr(44),3),"S")==0){
      commtype.Parity=4;
    }
  else
    {
      commtype.Parity=VAL(Parse(comm,chr(44),3));
    }
  commtype.DataBits=VAL(Parse(comm,chr(44),4));
  commtype.StopBits=VAL(Parse(comm,chr(44),5));
}


int ParseCount (char* a,char* b,int iCase)
{
  return 1+tally(a,b);
}


char *Parse (char* a,char* b,int field,int iCase)
{
  char *BCX_RetStr={0};
  BCX_RetStr = BCX_TmpStr(strlen(StrToken(a,b,field)));
  strcpy(BCX_RetStr,StrToken(a,b,field));
  return BCX_RetStr;
}


double DDMMtoDDec (char *DM)
{
  double   Angle={0};
  double   Deg={0};
  Angle=(VAL(DM)/100)+0.00001;
  Deg=FIX(Angle);
  Angle-=Deg;
  Angle=Angle*100/60;
  return Angle+Deg;
}


void ReSizeForm1 (void)
{
  MoveAnchorControl(hStc1,AnchorLeft|AnchorHCenter|AnchorTop);
  MoveAnchorControl(hStc2,AnchorRight|AnchorHCenter|AnchorTop);
  MoveAnchorControl(hEdt1,AnchorLeft|AnchorHCenter|AnchorTop);
  MoveAnchorControl(hEdt2,AnchorRight|AnchorHCenter|AnchorTop);
  MoveAnchorControl(hEdt3,AnchorLeft|AnchorHCenter|AnchorTop|AnchorBottom);
  MoveAnchorControl(hEdt4,AnchorRight|AnchorHCenter|AnchorTop|AnchorBottom);
  MoveAnchorControl(hEdt5,AnchorLeft|AnchorHCenter|AnchorBottom);
  MoveAnchorControl(hEdt6,AnchorRight|AnchorHCenter|AnchorBottom);
  MoveAnchorControl(hBtn1,AnchorLeft|AnchorBottom);
  MoveAnchorControl(hBtn4,AnchorLeft|AnchorBottom);
  MoveAnchorControl(hBtn2,AnchorRight|AnchorBottom);
  MoveAnchorControl(hBtn5,AnchorRight|AnchorBottom);
  MoveAnchorControl(hBtn3,AnchorRight|AnchorBottom);
}


char *Format (double x,int hi,int lo,int comma,int zeros)
{
  char *BCX_RetStr={0};
  char    a[BCXSTRSIZE]={0};
  char    b[BCXSTRSIZE]={0};
  int     minus={0};
  char    c[BCXSTRSIZE]={0};
  int     d={0};
  if(x<fabs(x)){
      minus=1;
    }
  x=fabs(x)+0.000000000000000000000001;
  x=Round(x,lo);
  strcpy(b, join(2,"#.",stringx(lo,35)));
  strcpy(a,trim(Using(b,x)));
  if(lo>0 ){
      strcpy(c, join(2,stringx(MAX(1+hi-instr(a,"."),0),48),a));
    }
  else
    {
      strcpy(c,right(join(2,stringx(MIN(hi,(int)strlen(a)),48),a),MAX(hi,(int)strlen(a))));
    }
  if(zeros ){
      while(c[d]==48){
          c[d]=32;
          d++;
        }
    }
  if(minus ){
      if((c[0]==48)||( c[0]==32)){
          c[0]=45;
        }
      else
        {
          strcpy(c, join(2,chr(45),c));
        }
    }
  if(comma==0 ){
      strcpy(c,RemoveStr(c,chr(44)));
    }
  BCX_RetStr = BCX_TmpStr(strlen(c));
  strcpy(BCX_RetStr,c);
  return BCX_RetStr;
}


  
  int WINAPI WinMain(HINSTANCE hInst,HINSTANCE hPrev,LPSTR CmdLine,int CmdShow) {
  MSG  Msg;
  LowCase = (unsigned char*)calloc(257,1), LowCase = MakeLCaseTbl();

  UprCase = (unsigned char*)calloc(257,1), UprCase = MakeUCaseTbl();

  
  // **********[ DLL Declarations ]**********
  
  HMODULE  H_COMMCTRLBCX = LoadLibrary("CommCtrlBcx.dll");
  SendData=(BCXFPROT1)GetProcAddress(H_COMMCTRLBCX, "SendData");
  SendDataW=(BCXFPROT2)GetProcAddress(H_COMMCTRLBCX, "SendDataW");
  OpenComm=(BCXFPROT3)GetProcAddress(H_COMMCTRLBCX, "OpenComm");
  CloseComm=(BCXFPROT4)GetProcAddress(H_COMMCTRLBCX, "CloseComm");
  ExitComms=(BCXFPROT5)GetProcAddress(H_COMMCTRLBCX, "ExitComms");
  RecvCommData=(BCXFPROT6)GetProcAddress(H_COMMCTRLBCX, "RecvCommData");
  RecvCommDataW=(BCXFPROT7)GetProcAddress(H_COMMCTRLBCX, "RecvCommDataW");
  CommSettings=(BCXFPROT8)GetProcAddress(H_COMMCTRLBCX, "CommSettings");
  
  // ****************************************
  
    strcpy(BCX_ClassName,"Test Comm Ports");
    BCX_SetMetric("pixels");
    BCX_InitGUI();
    BCX_hInstance       =  hInst;
    BCX_WndClass.hIcon  =  LoadIcon(NULL,IDI_WINLOGO);
    BCX_RegWnd( BCX_ClassName, WndProc );
  
    // ******************************************
                    FormLoad();
    // ******************************************
   while(GetMessage(&Msg,NULL,0,0))
     {
      HWND hActiveWindow = GetActiveWindow();
      if(!IsWindow(hActiveWindow) || !IsDialogMessage(hActiveWindow,&Msg))
        {
          TranslateMessage(&Msg);
          DispatchMessage(&Msg);
        }
      }
   return Msg.wParam;
  }
  
