'Author :  Mike Henning
'Changed by: Ian Casey   , added some things
'Description: This is an attempt at a comm port ctrl dll
'Date: April 6 2008
'FileName: "CommCtrlBcx.bas"
'Note: I'm using Mike Henning's serial library to do this
'I did test the receive part on 2 comm ports and it works great.


'Callable Subs & Functions




$DLL STDCALL

 
'$HEADER
'static HFONT   BcxFont;
'static float   BCX_ScaleX;
'static float   BCX_ScaleY;
'$HEADER
$INCLUDE "commSettings.bas"

'***********************************************
'*    BCX GUI Serial Communications Library    *
'*    Version 6.08.21                          *
'*    Written by Mike Henning                  *
'***********************************************

$HEADER
#if !defined(_MT)
#error _beginthreadex requires a multithreaded C run-time library. Check that that appropriate compiler switch is specified.
#endif
$HEADER

CONST BCX_MYTHREAD(A,B) = (HANDLE)_beginthreadex(0,0,(UINT (__stdcall*)(void*))A,(void *)B, 0, &T_ID)
CONST BCX_MYTHREADEND   =  _endthreadex(0); return 0

CONST WM_RCVDATA           = WM_USER + 50
CONST WM_SENTDATA          = WM_USER + 51
CONST WM_COMERROR          = WM_USER + 52
CONST WM_MODSTATUS         = WM_USER + 53

CONST DTR_ON   (A) = EscapeCommFunction(hComm[A], SETDTR)
CONST DTR_OFF  (A) = EscapeCommFunction(hComm[A], CLRDTR)
CONST RTS_ON   (A) = EscapeCommFunction(hComm[A], SETRTS)
CONST RTS_OFF  (A) = EscapeCommFunction(hComm[A], CLRRTS)
CONST XON      (A) = EscapeCommFunction(hComm[A], SETXON)
CONST XOFF     (A) = EscapeCommFunction(hComm[A], SETXOFF)
CONST BREAK_ON (A) = EscapeCommFunction(hComm[A], SETBREAK)
CONST BREAK_OFF(A) = EscapeCommFunction(hComm[A], CLRBREAK)

GLOBAL cMainHwnd     AS HWND
GLOBAL hComm[33]     AS HANDLE
GLOBAL threadcomm[33] AS HANDLE

GLOBAL T_ID AS UINT
GLOBAL ThreadReadState[33]  AS BOOL
GLOBAL ThreadWriteState[33] AS BOOL
GLOBAL wricom          AS CRITICAL_SECTION
GLOBAL readcom         AS CRITICAL_SECTION
GLOBAL protect_comstat AS CRITICAL_SECTION

GLOBAL ReadBufCount
GLOBAL WriteBufCount


FUNCTION OpenComm (cParentHwnd as HWND, port, baudrate, parity, databits, _
   stopbits, hs, inpbuff, outbuff) AS BOOL  EXPORT
   if port = 0 then port = 1
   if baudrate = 0 then baudrate = 9600
   if parity > 4 then parity=NOPARITY
   if databits = 0 then databits = 8
   if stopbits = 0 then stopbits = ONESTOPBIT
   if inpbuff = 0 then inpbuff = 4096
   if outbuff = 0 then outbuff = 4096
   If NOT cParentHwnd then
      cMainHwnd = GetActiveWindow()
   else
      cMainHwnd = cParentHwnd
   end if

   DIM AUTO cto AS COMMTIMEOUTS
   DIM AUTO PortDCB AS DCB
   DIM RAW comport$
   SetLastError(0)


   'comport$ = "COM" + LTRIM$(STR$(port))
   comport$ = "\\.\COM" + LTRIM$(STR$(port))
   hComm[port] = CreateFile(comport$,GENERIC_READ OR GENERIC_WRITE,0,NULL,OPEN_EXISTING,FILE_FLAG_OVERLAPPED,NULL)
   IF hComm[port] = INVALID_HANDLE_VALUE THEN
      Msgbox "CreateFile Failed in OpenComm on COM: " & STR$(port)
      FUNCTION = FALSE
   END IF

   SetupComm(hComm[port],inpbuff,outbuff)

   InitializeCriticalSection(&wricom)
   InitializeCriticalSection(&readcom)
   InitializeCriticalSection(&protect_comstat)

   GLOBAL WrBufQue$   * 1
   GLOBAL WrBuff      * 1
   GLOBAL ReadBuffer$ * 1

   cto.ReadIntervalTimeout         = 20 'MAXDWORD
   cto.ReadTotalTimeoutMultiplier  = 10
   cto.ReadTotalTimeoutConstant    = 10
   cto.WriteTotalTimeoutMultiplier = 10
   cto.WriteTotalTimeoutConstant   = 10

   SetCommTimeouts(hComm[port], &cto)

   PortDCB.DCBlength = SIZEOF (PortDCB)
   GetCommState (hComm[port], &PortDCB)
   WITH PortDCB
      .BaudRate          = baudrate               'Setup the DCB structure settings.
      .fBinary           = TRUE                   'must be true in win32
      .fParity           = TRUE                   'Parity checking is off
      .fOutxDsrFlow      = FALSE                  'DSR output flow control
      .fDtrControl       = DTR_CONTROL_DISABLE    'DTR flow control type
      .fDsrSensitivity   = FALSE                  'DSR sensitivity
      .fTXContinueOnXoff = TRUE                   'XOFF continues Tx
      .fErrorChar        = 0                      'error replacement
      .fNull             = FALSE                  'No null stripping
      .fAbortOnError     = FALSE                  'abort reads/writes on error
      .ByteSize          = databits               'number of bits/byte, 4-8
      .Parity            = parity                 'EVENPARITY, MARKPARITY, NOPARITY, ODDPARITY
      .StopBits          = stopbits-1             'ONESTOPBIT=0, ONE5STOPBITS=1, TWOSTOPBITS=2
   END WITH

   IF hs>1 THEN
      PortDCB.fOutxCtsFlow = TRUE                   'CTS output flow control
      PortDCB.fRtsControl  = RTS_CONTROL_HANDSHAKE  'RTS flow control
   ELSE
      PortDCB.fOutxCtsFlow = FALSE                  'CTS output flow control
      PortDCB.fRtsControl  = RTS_CONTROL_ENABLE     'RTS flow control
   END IF

   IF hs=1 OR hs=3 THEN
      PortDCB.fOutX = TRUE                          'XON/XOFF out flow control
      PortDCB.fInX  = TRUE                          'XON/XOFF in flow control
   ELSE
      PortDCB.fOutX = FALSE                         'XON/XOFF out flow control
      PortDCB.fInX  = FALSE                         'XON/XOFF in flow control
   END IF


   IF NOT SetCommState(hComm[port], &PortDCB)   THEN           'Set comm state based on DCB
       Msgbox "SetCommState Failed in OpenComm on COM: " & STR$(port)
   END IF
   PurgeComm(hComm[port],PURGE_RXCLEAR|PURGE_TXCLEAR)

   ThreadReadState[port] = TRUE
   threadcomm[port] = BCX_MYTHREAD(ReadThread,port) ', WRCVDATA)
   IF GetLastError() Then  PRINT "ERROR: " & Str$(GetLastError())
   FUNCTION = TRUE
END FUNCTION


FUNCTION CloseComm(port) AS INTEGER  EXPORT
   Dim nRet , failed
   IF hComm[port] THEN
      ThreadReadState[port] = 0
      sleep(1)
      nRet = PurgeComm(hComm[port],PURGE_RXABORT|PURGE_TXABORT| PURGE_RXCLEAR | PURGE_TXCLEAR)
      IF NOT nRet THEN  PRINT "Close PurgeComm failed Port" & STR$(port) & "    "&  STR$(nRet)    & "      " & STR$(GetLastError())
      IF threadcomm[port] THEN
         nRet = WaitForSingleObject(threadcomm[port],3000)
         IF  nRet = 0 THEN 'success
           nRet = CloseHandle(threadcomm[port])
           threadcomm[port] = 0
         ELSE
             failed++
             PRINT "Close thread failed Port" & STR$(port) & "    "&  STR$(nRet)    & "      " & STR$(GetLastError())
         END IF
      END IF
      IF threadcomm[port+16] THEN
         nRet = WaitForSingleObject(threadcomm[port+16],3000)
         IF  nRet = 0 THEN 'sucess
           nRet = CloseHandle(threadcomm[port+16])
           IF NOT nRet THEN print "Close handle failed + 16 " & STR$(port+16)
           threadcomm[port+16] = 0
         ELSE
             failed++
             PRINT "Close thread +16 failed Port" & STR$(port) & "    "&  STR$(nRet)    & "      " & STR$(GetLastError())
         END IF
      END IF
      IF NOT failed THEN
        CloseHandle(hComm[port])
        hComm[port]=0
        FUNCTION = 0
      END IF
   END IF
   FUNCTION = 1     'Failed port is still open
END FUNCTION

SUB ExitComms () EXPORT
  DeleteCriticalSection(&wricom)
  DeleteCriticalSection(&readcom)
  DeleteCriticalSection(&protect_comstat)

  IF WrBufQue$ THEN FREE(WrBufQue$)
  IF WrBuff$   THEN FREE(WrBuff$)
  IF ReadBuffer$ THEN FREE ReadBuffer$
END SUB

'L = Length of out(string)
SUB SendData (cParentHwnd as HWND, port, out AS LPCSTR, L) EXPORT

   IF NOT L THEN L = LEN(out$)

   EnterCriticalSection(&wricom)
   REDIM PRESERVE WrBufQue$ * L + WriteBufCount
   IF WrBufQue = NULL THEN
      MSGBOX "Write Que allocation error"
      EXIT SUB
   END IF
   POKE(&WrBufQue$[WriteBufCount],out,L)
   INCR WriteBufCount, L

   IF ThreadWriteState[port] THEN
      LeaveCriticalSection(&wricom)
      EXIT SUB
   END IF
   IF threadcomm[port+16] THEN CloseHandle(threadcomm[port+16]) 'Keep old handles cleared out

   ThreadWriteState[port] = TRUE
   LeaveCriticalSection(&wricom)
   threadcomm[port+16] = BCX_MYTHREAD(XmitDataThread, port)
END SUB


FUNCTION RecvCommData (port, NBytes) AS LPSTR EXPORT
   STATIC rccv AS LPSTR

   EnterCriticalSection(&readcom)
   REDIM PRESERVE rccv$ * ReadBufCount + 1

   IF ReadBufCount > NBytes THEN
      POKE(rccv$,ReadBuffer$,NBytes)
      rccv[NBytes] = 0
      DECR ReadBufCount, NBytes
      POKE(ReadBuffer$,&ReadBuffer$[NBytes],ReadBufCount)
   ELSE
      POKE(rccv$,ReadBuffer$,ReadBufCount)
      rccv[ReadBufCount] = 0
      ReadBufCount = 0
      REDIM ReadBuffer$ * 1
   END IF
   LeaveCriticalSection(&readcom)
   PurgeComm(hComm[port],PURGE_RXCLEAR|PURGE_TXCLEAR)
   FUNCTION = rccv
END FUNCTION


FUNCTION ReadThread(port) AS UINT STDMETHODCALLTYPE

   DIM RAW nofchar
   DIM RAW cstatus AS COMSTAT
   GLOBAL gcomstat AS COMSTAT
   DIM RAW comerr  AS DWORD
   DIM RAW cbChars AS ULONG
   DIM RAW modstat AS DWORD
   DIM RAW premodstat AS DWORD
   'DIM RAW rcvbuf = NULL AS LPSTR
   DIM DYNAMIC rcvbuf[1] AS CHAR
   Dim szOverLapped as OVERLAPPED

   premodstat = MAXDWORD

   WHILE ThreadReadState[port]

      ClearCommError(hComm[port],&comerr,&cstatus)
      IF comerr THEN PostMessage(cMainHwnd,WM_COMERROR,port,comerr)

      EnterCriticalSection(&protect_comstat)
      gcomstat = cstatus
      LeaveCriticalSection(&protect_comstat)

      GetCommModemStatus(hComm[port],&modstat)
      IF modstat <> premodstat THEN
         premodstat = modstat
         PostMessage(cMainHwnd,WM_MODSTATUS,port,modstat)
      END IF

      nofchar=cstatus.cbInQue
      IF nofchar THEN

         rcvbuf = (LPSTR)realloc(rcvbuf, nofchar+1)
         memset(rcvbuf, 0, nofchar+1)
         ReadFile(hComm[port], rcvbuf$ ,nofchar, &cbChars, &szOverLapped)

         EnterCriticalSection(&readcom)
         ReadBuffer = (LPSTR)realloc(ReadBuffer, ReadBufCount + cbChars + 1)
         IF ReadBuffer = NULL THEN
            MessageBox (cMainHwnd,"Read buffer allocation error!","",0)
         END IF
         POKE(&ReadBuffer[ReadBufCount],rcvbuf,cbChars)
         INCR ReadBufCount, cbChars

         SendNotifyMessage(cMainHwnd,WM_RCVDATA,port,cbChars)
         LeaveCriticalSection(&readcom)
      END IF

      SLEEP(1)
   WEND
   rcvbuf$ = ""
   IF ReadBuffer$ THEN FREE ReadBuffer$
   IF rcvbuf$     THEN FREE rcvbuf$
   BCX_MYTHREADEND


END FUNCTION


FUNCTION XmitDataThread(port) AS UINT STDMETHODCALLTYPE
   DIM RAW cbChars AS ULONG
   DIM RAW tptr AS CHAR PTR
   DIM RAW tmpcount
   DIM szOverLapped AS OVERLAPPED
   DIM RAW CharsWritten AS ULONG
   CharsWritten = WriteBufCount
   EnterCriticalSection(&wricom)
   WHILE WriteBufCount <> 0
      tptr     = WrBufQue
      WrBufQue = WrBuff
      WrBuff   = tptr
      tmpcount = WriteBufCount
      WriteBufCount = 0
      REDIM WrBufQue$ * 1

      LeaveCriticalSection(&wricom)
      IF NOT WriteFile(hComm[port], WrBuff, tmpcount, &cbChars, &szOverLapped) THEN
         IF GetLastError() = ERROR_IO_PENDING THEN
              GetOverlappedResult(hComm[port], &szOverLapped,&cbChars, TRUE)
         ELSE
         MessageBox (cMainHwnd,"Com write error! - " + HEX$(GetLastError()),"",MB_ICONWARNING)
         END IF
      END IF
      EnterCriticalSection(&wricom)
   WEND
   SendNotifyMessage(cMainHwnd,WM_SENTDATA,port,CharsWritten)
   REDIM WrBuff$ * 1
   ThreadWriteState[port] = FALSE
   LeaveCriticalSection(&wricom)
   BCX_MYTHREADEND
END FUNCTION


FUNCTION ComStatus(port,st$)  EXPORT
   DIM t
   DIM RAW tt$
   tt$ = UCASE$(st$)

   EnterCriticalSection(&protect_comstat)
   SELECT CASE tt$
      CASE "CTS"
      t = gcomstat.fCtsHold
      CASE "DSR"
      t = gcomstat.fDsrHold
      CASE "CD"
      t = gcomstat.fRlsdHold
      CASE "XOFFRCV"
      t = gcomstat.fXoffHold
      CASE "XOFFSENT"
      t = gcomstat.fXoffSent
      CASE "EOF"
      t = gcomstat.fEof
      CASE "CTX"
      t = gcomstat.fTxim
      CASE "RCVBUFF"
      t = gcomstat.cbInQue
   END SELECT
   LeaveCriticalSection(&protect_comstat)
   FUNCTION = t
END FUNCTION


SUB SendDataW (cParentHwnd as HWND, port, out AS LPWSTR, L) EXPORT
    SendData (cParentHwnd, port, WIDETOANSI$(out), L)
END SUB

FUNCTION RecvCommDataW (port, NBytes) AS LPWSTR EXPORT
    FUNCTION = ANSITOWIDE(RecvCommData (port, NBytes))
END FUNCTION




