// *************************************************
//      Made with BCX BASIC To C/C++ Translator
//            Version 7.8.5 (04/12/2022)
// *************************************************
//    Translated for compiling with a C Compiler
// *************************************************
#define _CRT_SECURE_NO_DEPRECATE

#include <windows.h>    // WinApi
#include <windowsx.h>   // WinApi
#include <commctrl.h>   // WinApi
#include <commdlg.h>    // WinApi
#include <direct.h>     // WinApi
#include <mmsystem.h>   // WinApi
#include <oaidl.h>      // WinApi
#include <objbase.h>    // WinApi
#include <ocidl.h>      // WinApi
#include <ole2.h>       // WinApi
#include <oleauto.h>    // WinApi
#include <olectl.h>     // WinApi
#include <richedit.h>   // WinApi
#include <shellapi.h>   // WinApi
#include <shlobj.h>     // WinApi
#include <urlmon.h>     // WinApi
#include <wchar.h>      // WinApi
#include <wctype.h>     // WinApi
#include <tchar.h>      // WinApi
#include <unknwn.h>     // WinApi
#include <wininet.h>    // WinApi
#include <winsock.h>    // WinApi
#include <winuser.h>    // WinApi
#include <stdbool.h>    // ISO StdLib
#include <ctype.h>      // ISO StdLib
#include <math.h>       // ISO StdLib
#include <setjmp.h>     // ISO StdLib
#include <stdarg.h>     // ISO StdLib
#include <stddef.h>     // ISO StdLib
#include <stdio.h>      // ISO StdLib
#include <stdlib.h>     // ISO StdLib
#include <string.h>     // ISO StdLib
#include <time.h>       // ISO StdLib
#include <process.h>    // ISO StdLib
#include <inttypes.h>   // ISO StdLib
#include <fcntl.h>      // POSIX
#include <io.h>         // WinNT POSIX subset
#include <conio.h>      // Primitive i/o


// *************************************************
//            System Defined Constants
// *************************************************

#define BCXSTRSIZE 2048

// *************************************************
//             User Defined Constants
// *************************************************

#define commSet_Stc1_Style WS_TABSTOP|WS_VISIBLE|WS_CHILD|SS_NOTIFY
#define commSet_Stc1_ExtStyle 0
#define commSet_Stc2_Style WS_TABSTOP|WS_VISIBLE|WS_CHILD|SS_NOTIFY
#define commSet_Stc2_ExtStyle 0
#define commSet_Stc3_Style WS_TABSTOP|WS_VISIBLE|WS_CHILD|SS_NOTIFY
#define commSet_Stc3_ExtStyle 0
#define commSet_Stc4_Style WS_TABSTOP|WS_VISIBLE|WS_CHILD|SS_NOTIFY
#define commSet_Stc4_ExtStyle 0
#define commSet_Stc5_Style WS_TABSTOP|WS_VISIBLE|WS_CHILD|SS_NOTIFY
#define commSet_Stc5_ExtStyle 0
#define commSet_Stc6_Style WS_TABSTOP|WS_VISIBLE|WS_CHILD|SS_NOTIFY
#define commSet_Stc6_ExtStyle 0
#define commSet_Cmb1_Style WS_TABSTOP|WS_VISIBLE|WS_CHILD|CBS_HASSTRINGS|WS_VSCROLL|CBS_DROPDOWN
#define commSet_Cmb1_ExtStyle 0
#define commSet_Btn1_Style WS_TABSTOP|WS_VISIBLE|WS_CHILD
#define commSet_Btn1_ExtStyle WS_EX_STATICEDGE
#define commSet_Btn2_Style WS_TABSTOP|WS_VISIBLE|WS_CHILD
#define commSet_Btn2_ExtStyle WS_EX_STATICEDGE
#define BCX_COMM_PORT_CLASS struct _BCX_COMM_PORT*
static HFONT   BcxFont;
#define BCX_MYTHREAD(A,B) (HANDLE)_beginthreadex(0, 0,(UINT(__stdcall*)(void*))A,(void*)B, 0, &T_ID)
#define BCX_MYTHREADEND _endthreadex(0);return 0
#define WM_RCVDATA WM_USER+ 50
#define WM_SENTDATA WM_USER+ 51
#define WM_COMERROR WM_USER+ 52
#define WM_MODSTATUS WM_USER+ 53
#define DTR_ON(A) EscapeCommFunction(hComm[A],SETDTR)
#define DTR_OFF(A) EscapeCommFunction(hComm[A],CLRDTR)
#define RTS_ON(A) EscapeCommFunction(hComm[A],SETRTS)
#define RTS_OFF(A) EscapeCommFunction(hComm[A],CLRRTS)
#define XON(A) EscapeCommFunction(hComm[A],SETXON)
#define XOFF(A) EscapeCommFunction(hComm[A],SETXOFF)
#define BREAK_ON(A) EscapeCommFunction(hComm[A],SETBREAK)
#define BREAK_OFF(A) EscapeCommFunction(hComm[A],CLRBREAK)

// *************************************************
//                  Compiler Defines
// *************************************************

#if defined (__cplusplus)
  #define overloaded
  #define C_EXPORT EXTERN_C __declspec(dllexport)
  #define C_IMPORT EXTERN_C __declspec(dllimport)
#else
  #define C_EXPORT __declspec(dllexport)
  #define C_IMPORT __declspec(dllimport)
#endif

// *************************************************
//                   Microsoft VC++
// *************************************************

#ifndef DECLSPEC_UUID
  #if (_MSC_VER >= 1100) && defined (__cplusplus)
    #define DECLSPEC_UUID(x)  __declspec(uuid(x))
  #else
    #define DECLSPEC_UUID(x)
  #endif
#endif
#if (_MSC_VER >= 1900)            // earlier versions untested
   #include <intrin.h>
      #ifndef _rdtsc
         #define _rdtsc __rdtsc   // MSVC uses 2 underscores
      #endif
   #pragma warning(disable: 4018) // signed/unsigned mismatch warnings
   #pragma warning(disable: 4100) // unreferenced argument warnings
   #pragma warning(disable: 4244) // conversion from type1 to type2 warnings
   #pragma warning(disable: 4267) // conversion from type1 to type2 warnings
   #pragma warning(disable: 4305) // truncation from double to float warnings
   #pragma warning(disable: 4800) // forcing value to bool warnings
   #pragma warning(disable: 4838) // conversion from type1 to type2 warnings
#endif

// *************************************************
//                  GCC and CLANG
// *************************************************

#if defined (__GNUC__) || defined (__clang__)
   #ifndef __BCPLUSPLUS__
      #include <x86intrin.h>
   #endif
   #pragma GCC diagnostic ignored "-Wwrite-strings"
   #pragma GCC diagnostic ignored "-Wunused-parameter"
   #pragma GCC diagnostic ignored "-Wunknown-pragmas"
   #pragma GCC diagnostic ignored "-Wdangling-else"
   #pragma GCC diagnostic ignored "-Wdeprecated"
#endif

// *************************************************
//                  Embarcadero C++
// *************************************************

#if defined (__BCPLUSPLUS__)
      #if  defined (_clang__)
            #include <mmintrin.h>
      #endif
      #define _kbhit kbhit
      #ifndef _rdtsc
        #define _rdtsc __rdtsc  // Uses 2 underscores
      #endif
#endif

// *************************************************
//                    Open Watcom
// *************************************************

#if defined (__WATCOM_CPLUSPLUS__)
  #define _fcloseall fcloseall
#endif

// *************************************************
//                     Lcc-Win32
// *************************************************

#if defined( __LCC__)
  #define _fseeki64  fseeki64
  #define _stricmp   stricmp
  #define _strnicmp  strnicmp
  #define _itoa      itoa
  #define _ltoa      ltoa
  #include <intrinsics.h>
  #include <malloc.h>  // for _msize
  #if defined( __windows_h__ )
      #define COMPILE_MULTIMON_STUBS
      #include <multimon.h>
      #include <iehelper.h>
      #include <exdisp.h>
   #endif
#endif

// *************************************************
//                     Pelles C
// *************************************************

#if defined (__POCC__)
   #include <intrin.h>
   #pragma pack_stack(off)        // Pelle's fix for a v10 optimization bug
   #pragma warn(disable: 2006)    // Non-portable conversion int to const char*
   #pragma warn(disable: 2007)    // Non-portable inline code
   #pragma warn(disable: 2115)    // Initialized but not used warnings
   #pragma warn(disable: 2118)    // Unreferenced argument warnings
   #pragma warn(disable: 2134)    // Possible infinite loop
   #pragma warn(disable: 2154)    // Buggy unreachable code warning using sizeof
   #pragma warn(disable: 2197)    // Unsigned long int not a std bit-field type
   #pragma warn(disable: 2215)    // Conversion from type1 to type2 warnings
   #pragma warn(disable: 2218)    // Unreferenced parameter
   #pragma warn(disable: 2230)    // Incomplete struct declarations (vbs support)
   #pragma warn(disable: 2235)    // Not all control paths return a value
   #pragma warn(disable: 2241)    // Function marked for deprecation
   #pragma warn(disable: 2248)    // Non-portable use of extension
   #pragma warn(disable: 2251)    // Types with different signedness
   #pragma warn(disable: 2804)    // Consider changing type to size_t warnings
   #pragma warn(disable: 2805)    // Possible anti-aliasing violation warnings
   #pragma warn(disable: 2810)    // Potential realloc warnings
#endif
// *************************************************

#if !defined(_MT)
#error _beginthreadex requires a multithreaded C run-time library. Check that that appropriate compiler switch is specified.
#endif


// *************************************************
// Instruct Linker to Search Object/Import Libraries
// *************************************************

#if !defined(__GNUC__)
   #if !(defined(__BCPLUSPLUS__) && defined(_WIN64))
      #if !defined( __LCC__ )
    #pragma comment(lib,"kernel32.lib")
    #pragma comment(lib,"user32.lib")
    #pragma comment(lib,"gdi32.lib")
    #pragma comment(lib,"comctl32.lib")
    #pragma comment(lib,"advapi32.lib")
    #pragma comment(lib,"winspool.lib")
    #pragma comment(lib,"shell32.lib")
    #pragma comment(lib,"ole32.lib")
    #pragma comment(lib,"oleaut32.lib")
    #pragma comment(lib,"uuid.lib")
    #pragma comment(lib,"odbc32.lib")
    #pragma comment(lib,"odbccp32.lib")
    #pragma comment(lib,"winmm.lib")
    #pragma comment(lib,"comdlg32.lib")
    #pragma comment(lib,"imagehlp.lib")
    #pragma comment(lib,"version.lib")
    #pragma comment(lib,"wininet.lib")
    #pragma comment(lib,"urlmon.lib")
  #else
    #pragma lib <winspool.lib>
    #pragma lib <shell32.lib>
    #pragma lib <ole32.lib>
    #pragma lib <oleaut32.lib>
    #pragma lib <uuid.lib>
    #pragma lib <odbc32.lib>
    #pragma lib <odbccp32.lib>
    #pragma lib <winmm.lib>
    #pragma lib <imagehlp.lib>
    #pragma lib <version.lib>
    #pragma lib <wininet.lib>
    #pragma lib <urlmon.lib>
     #endif
  #endif
#endif

// *************************************************
//           User's GLOBAL Enumerations
// *************************************************

enum
  {
    ID_commSet_Stc1,
    ID_commSet_Stc2,
    ID_commSet_Stc3,
    ID_commSet_Stc4,
    ID_commSet_Stc5,
    ID_commSet_Stc6,
    ID_commSet_Cmb1,
    ID_commSet_Cmb2,
    ID_commSet_Cmb3,
    ID_commSet_Cmb4,
    ID_commSet_Cmb5,
    ID_commSet_Cmb6,
    ID_commSet_Btn1,
    ID_commSet_Btn2
  };


// *************************************************
//          User Defined Types And Unions
// *************************************************

typedef struct _BCX_COMM_PORT
{
  int      Baud;
  int      Port;
  int      Parity;
  int      StopBits;
  int      DataBits;
  int      XonXoff;
  BOOL     Open;
  char    rcvbuf[BCXSTRSIZE];
  int     sendbuff;
}BCX_COMM_PORT, *LPBCX_COMM_PORT;


// *************************************************
//               Standard Prototypes
// *************************************************

INT_PTR BCX_MDialog (DLGPROC, LPCTSTR, HWND, int=0, int=0, int=250, int=150, int=0, int=0, LPCTSTR =0, int=0);
void    SetDialogScale (HWND, BOOL);
HWND    BCX_Form (LPCTSTR, int=0, int=0, int=250, int=150, int=-1, int=0);
HWND    BCX_Button (LPCTSTR, HWND, int=0, int=0, int=0, int=0, int=0, int=0, int=-1);
HWND    BCX_Label (LPCTSTR, HWND, int=0, int=0, int=0, int=0, int=0, int=0, int=0);
HWND    BCX_Combobox (LPCTSTR, HWND, int, int, int, int, int, int=0, int=-1);
char*   BCX_TmpStr (size_t);
char*   ucase (LPCTSTR);
char*   ltrim (LPCTSTR, char=32);
char*   str (double, int=0);
char*   hex (int);
SIZE*   GetTextSize (LPCTSTR, HWND=0, HFONT=0);
char*   join (int, ... );
void*   CreateArr (void*, int, int, int, size_t *);
void    DestroyArr (void**, int, int);
//<---UNICODE AWARE
char*   WideToAnsi (BSTR, UINT = CP_ACP, DWORD = 0);
//>---UNICODE AWARE

//<---UNICODE AWARE
LPOLESTR AnsiToWide (LPCSTR, UINT = CP_ACP, DWORD = MB_PRECOMPOSED);
//>---UNICODE AWARE


// *************************************************
//                System Variables
// *************************************************



// *************************************************
//            User's Global Variables
// *************************************************

static HINSTANCE BCX_hInstance;
static HWND    FormCOMMSET;
static HWND    hcommSet_Stc1;
static HWND    hcommSet_Stc2;
static HWND    hcommSet_Stc3;
static HWND    hcommSet_Stc4;
static HWND    hcommSet_Stc5;
static HWND    hcommSet_Stc6;
static HWND    hcommSet_Cmb1;
static HWND    hcommSet_Cmb2;
static HWND    hcommSet_Cmb3;
static HWND    hcommSet_Cmb4;
static HWND    hcommSet_Cmb5;
static HWND    hcommSet_Cmb6;
static HWND    hcommSet_Btn1;
static HWND    hcommSet_Btn2;
static BCX_COMM_PORT CommSet;
static HFONT   BcxFont;
static float   BCX_ScaleX;
static float   BCX_ScaleY;
static char    BCX_ClassName[BCXSTRSIZE];
static HWND    cMainHwnd;
static UINT    T_ID;
static CRITICAL_SECTION wricom;
static CRITICAL_SECTION readcom;
static CRITICAL_SECTION protect_comstat;
static int     ReadBufCount;
static int     WriteBufCount;
static char    *WrBufQue;
static char    *WrBuff;
static char    *ReadBuffer;
static COMSTAT gcomstat;
static HANDLE  hComm[33];
static HANDLE  threadcomm[33];
static BOOL    ThreadReadState[33];
static BOOL    ThreadWriteState[33];

// *************************************************
//               Standard Macros
// *************************************************

#define DefFont ((BcxFont!=0)?BcxFont:(HFONT)SNDMSG(hWnd, WM_GETFONT, 0, 0))
#define DefaultFont ((DefFont==0)?GetStockObject(DEFAULT_GUI_FONT):DefFont)
#define Show(Window)RedrawWindow(Window,0,0,0);ShowWindow(Window,SW_SHOW);
#define VAL(a)(double)atof((a))

// *************************************************
//               User's Prototypes
// *************************************************

C_EXPORT int __stdcall CommSettings (HWND,int* ,int* ,int* ,int* ,int* ,int*);
int     FormCOMMSET_Create (HWND);
INT_PTR CALLBACK Ev_FormCOMMSET (HWND,UINT,WPARAM,LPARAM);
void    frmDummy (void);
void    ComboBoxAdd (HANDLE,char*);
int     CbSelectString (HWND,int,char*);
int     CbSetCurSel (HWND,int);
char*   CbGetLbText (HWND,int);
int     CbGetCurSel (HWND);
void    GetcbosValues (void);
void    LoadcboPorts (HWND);
void    LoadcboBauds (HWND);
void    LoadcboParity (HWND);
void    LoadcboDataBits (HWND);
void    LoadcboStopBits (HWND);
void    LoadcboFlow (HWND);
C_EXPORT BOOL __stdcall OpenComm (HWND,int,int,int,int,int,int,int,int);
C_EXPORT int __stdcall CloseComm (int);
C_EXPORT void __stdcall ExitComms (void);
C_EXPORT void __stdcall SendData (HWND,int,LPCSTR,int);
C_EXPORT LPSTR __stdcall RecvCommData (int,int);
UINT    STDMETHODCALLTYPE ReadThread (int);
UINT    STDMETHODCALLTYPE XmitDataThread (int);
C_EXPORT int __stdcall ComStatus (int,char*);
C_EXPORT void __stdcall SendDataW (HWND,int,LPWSTR,int);
C_EXPORT LPWSTR __stdcall RecvCommDataW (int,int);

// *************************************************
//                 Runtime Functions
// *************************************************

char *BCX_TmpStr (size_t iBytes) {
  static int   StrCnt;
  static char *StrFunc[2048];
  StrCnt = (StrCnt + 1) & (2047);
  if (StrFunc[StrCnt])
    {
      free (StrFunc[StrCnt]);
      StrFunc[StrCnt] = NULL;
    }
  StrFunc[StrCnt] = (char*)calloc(iBytes+1, sizeof(char));
  return StrFunc[StrCnt];
}


char *ltrim (LPCTSTR S, char c) {
  if (0 == S[0]) return (char*) S;
  while(*S==32 || (*S >= 9 && *S <= 13) || *S == c) S++;
  char *strtmp = BCX_TmpStr(strlen(S));
  return strcpy(strtmp, S);
}


char *ucase (LPCTSTR szStr) {
  char *strtmp = BCX_TmpStr(strlen(szStr));
  return CharUpperA(strcpy(strtmp, szStr));
}


char *str(double d_, int nospc) {
  char *strtmp = BCX_TmpStr(64);
  if (nospc)
     snprintf(strtmp, 64, "%.15G", d_);
  else
     snprintf(strtmp, 64, "% .15G", d_);
  return strtmp;
}


char *hex (int a) {
  char *strtmp = BCX_TmpStr(32);
  sprintf(strtmp,"%X", a);
  return strtmp;
}


char *join(int n, ...) {
  int ii = n, tmplen = 0;
  char *s_;
  char *strtmp;
  va_list marker;
  va_start(marker, n); // Initialize variable arguments
  while(ii-- > 0)
  {
    s_ = va_arg(marker, char *);
       if (s_) tmplen += (int)strlen(s_);
  }
  strtmp = BCX_TmpStr(tmplen);
  va_end(marker); // Reset variable arguments
  ii = n;
  va_start(marker, n); // Initialize variable arguments
  while(ii-- > 0)
  {
    s_ = va_arg(marker, char *);
    if (s_) strcat(strtmp, s_);
  }
  va_end(marker); // Reset variable arguments
  return strtmp;
}


void *CreateArr(void *dynavar, int elem_size, int update, int num_dims, size_t *args ) {
  size_t s, s1, s2;
  void **vp;
  size_t *marker;
  marker = args;
  s = *marker++;
  s2 = s + 2;
  if (num_dims == 1)
  {
    if (update && dynavar)
        dynavar = realloc(dynavar, s2 * elem_size);
    else
        dynavar = calloc(s2, elem_size);
    return dynavar;
  }
  else if (update && dynavar)
  {
    s1 = 0;
    vp = (void**)dynavar;
    while(*vp && s1 <= s)
    {
        vp++;
        s1++;
    }
    if (s1 > s)
    {
      vp--;
      DestroyArr(vp, num_dims, 0);
    }
    dynavar = realloc(dynavar, s2 * sizeof(int *));
    s1 = 0;
    vp = (void**)dynavar;
    while(*vp && s1 <= s)
    {
      vp++;
      s1++;
    }
    while(s1 < s2)
    {
      *(((void **)vp)) = NULL;
      vp++;
      s1++;
    }
  }
  else
    dynavar = calloc(s2 * sizeof(int *), 1);
    vp = (void**)dynavar;
    if (--num_dims > 0)
    {
      for(s1 = 0; s1 < s; s1++)
      {
          vp[s1] = CreateArr(vp[s1], elem_size, update, num_dims, marker);
      }
    }
  return dynavar;
}


void DestroyArr (void** dynavar,int num_dims, int top_free) {
  int ii = 0;
  static int s = 0;
  if (num_dims == 1)
    {
      free(dynavar);
      dynavar = NULL;
      return;
    }
  s++;
  num_dims--;
  while(dynavar[ii])
     {
    DestroyArr((void**)dynavar[ii], num_dims, top_free);
    if (num_dims > 1)
         free(dynavar[ii]);
    dynavar[ii++]=NULL;
     }
  s--;
  if ( 0 == s && top_free )
    free(dynavar);
    dynavar = NULL;
}


INT_PTR BCX_MDialog (DLGPROC DPro, LPCTSTR title, HWND hWnd, int X, int Y, int W, int H, int Style, int Exstyle, LPCTSTR fntface, int fsz) {
  LPDLGTEMPLATE  lpdt;
  LPWORD  lpw;
  LPVOID tc = calloc(1024, 1);
  lpdt=(LPDLGTEMPLATE)tc;
  if (!Style)
   {
     lpdt->style = WS_POPUP|WS_SYSMENU|DS_MODALFRAME|WS_CAPTION;
     if (fsz) lpdt->style = lpdt->style|DS_SETFONT;
   }else{
     lpdt->style = Style;
   }
  lpdt->dwExtendedStyle = Exstyle;
  lpdt->cdit = 0;
  lpdt->x  = X;  lpdt->y  = Y;
  lpdt->cx = W;  lpdt->cy = H;
  
  lpw=(LPWORD)(lpdt+1);
  *lpw++=0; *lpw++=0;
  lpw+=MultiByteToWideChar(CP_ACP, 0, title, -1, (LPWSTR)lpw, 2*(int)strlen(title)+1);
  if (fsz) { *lpw++ = fsz;
  MultiByteToWideChar(CP_ACP, 0, fntface, -1, (LPWSTR)lpw, 2*(int)strlen(fntface)+1); }
  INT_PTR ret = DialogBoxIndirect(BCX_hInstance, (LPDLGTEMPLATE)tc, hWnd, (DLGPROC)DPro);
  free(tc);
  tc = NULL;
  SetDialogScale(0, 1);  //restore previous scale
  return ret;
}


void SetDialogScale (HWND hdlg, BOOL Restor) {
 static float BaseX, BaseY;
 if (Restor && BaseX)
  {
    BCX_ScaleX = BaseX;
    BCX_ScaleY = BaseY;
    BaseX = BaseY = 0;
    return;
  }
 if (!BaseX) { BaseX = BCX_ScaleX; BaseY = BCX_ScaleY; }
 BaseX = BCX_ScaleX; BaseY = BCX_ScaleY;  
 RECT rc = {0, 0, 4, 8};
 MapDialogRect (hdlg, &rc);
 BCX_ScaleX = (float)rc.right/4;
 BCX_ScaleY = (float)rc.bottom/8;
}


HWND BCX_Form (LPCTSTR Caption, int X, int Y, int W, int H, int Style, int Exstyle) {
  if (Style == -1) Style = WS_MINIMIZEBOX|WS_SIZEBOX|WS_CAPTION|WS_MAXIMIZEBOX|WS_POPUP|WS_SYSMENU;
  
  HWND A = CreateWindowEx(Exstyle, BCX_ClassName, Caption, Style, X*BCX_ScaleX, Y*BCX_ScaleY,
         BCX_ScaleX*(4+W), BCX_ScaleY*(12+H), NULL,(HMENU)(UINT_PTR)NULL, BCX_hInstance, NULL);
           
  SendMessage (A,(UINT_PTR) WM_SETFONT, (WPARAM)((BcxFont==0) ? GetStockObject
              (DEFAULT_GUI_FONT):BcxFont), (LPARAM) MAKELPARAM(FALSE, 0));
  return A;
}


HWND BCX_Button(LPCTSTR Text, HWND hWnd, int id, int X, int Y, int W, int H, int Style, int Exstyle) {
  if (!Style)
      Style = WS_CHILD | WS_VISIBLE | BS_MULTILINE | BS_PUSHBUTTON | WS_TABSTOP;
  if (Exstyle == -1)
      Exstyle = WS_EX_STATICEDGE;
  HWND A = CreateWindowEx(Exstyle,"button", Text, Style,
           X*BCX_ScaleX, Y*BCX_ScaleY, W*BCX_ScaleX, H*BCX_ScaleY,
           hWnd,(HMENU)(UINT_PTR)id, BCX_hInstance, NULL);
  SendMessage(A, (UINT_PTR)WM_SETFONT, (WPARAM)DefaultFont, (LPARAM)MAKELPARAM(FALSE, 0));
  if (W==0)
    {
      SIZE* size = GetTextSize(Text, A);
      MoveWindow(A, X*BCX_ScaleX, Y*BCX_ScaleY, size->cx+24, size->cy+12, TRUE);
    }
  return A;
}


HWND BCX_Label(LPCTSTR Text, HWND hWnd, int id, int X, int Y, int W, int H, int Style, int Exstyle) {
  if (!Style)
      Style = WS_CHILD | SS_NOTIFY | SS_LEFT | WS_VISIBLE;
  HWND A = CreateWindowEx(Exstyle,"static",Text, Style,
           X*BCX_ScaleX, Y*BCX_ScaleY, W*BCX_ScaleX, H*BCX_ScaleY,
           hWnd, (HMENU)(UINT_PTR)id, BCX_hInstance, NULL);
  SendMessage(A, (UINT_PTR)WM_SETFONT, (WPARAM)DefaultFont, (LPARAM)MAKELPARAM(FALSE, 0));
  if (W==0)
    {
      SIZE*  size = GetTextSize(Text, A);
      MoveWindow(A, X*BCX_ScaleX, Y*BCX_ScaleY, size->cx, size->cy, TRUE);
   }
  return A;
}


HWND BCX_Combobox(LPCTSTR Text, HWND hWnd, int id, int X, int Y, int W, int H, int Style, int Exstyle) {
  HWND  A;
  if (!Style)
      Style = WS_CHILD | WS_VISIBLE | CBS_DROPDOWN | CBS_SORT | WS_VSCROLL | WS_TABSTOP;
  if (Exstyle == -1)
      Exstyle = WS_EX_CLIENTEDGE;
  A = CreateWindowEx(Exstyle,"Combobox", NULL,Style,
      X*BCX_ScaleX, Y*BCX_ScaleY, W*BCX_ScaleX, H*BCX_ScaleY,
      hWnd, (HMENU)(UINT_PTR)id, BCX_hInstance, NULL);
  SendMessage(A, (UINT_PTR)WM_SETFONT, (WPARAM)DefaultFont, (LPARAM)MAKELPARAM(FALSE, 0));
  return A;
}


SIZE* GetTextSize (LPCTSTR Text, HWND hWnd, HFONT fnt) {
  HDC  hdc = GetDC(hWnd);
  if (!fnt) fnt=(HFONT)SendMessage(hWnd, WM_GETFONT, 0, 0);
  HFONT sobj=(HFONT)SelectObject(hdc, fnt);
  static SIZE sz;
  GetTextExtentPoint32(hdc, (char*)Text, strlen(Text), &sz);
  SelectObject(hdc, sobj);
  ReleaseDC(hWnd, hdc);
  return (&sz);
}


//<---UNICODE AWARE
char* WideToAnsi (BSTR WideStr, UINT CodePage, DWORD dwFlags) {
  char *BCX_RetStr = {0};
  UINT uLen;
  uLen = WideCharToMultiByte(CodePage, dwFlags, WideStr,-1,0,0,0,0);
  BCX_RetStr = (char*)BCX_TmpStr(uLen);
  WideCharToMultiByte(CodePage, dwFlags, WideStr, -1, BCX_RetStr,uLen,0,0);
  return BCX_RetStr;
}
//>---UNICODE AWARE

//<---UNICODE AWARE
LPOLESTR AnsiToWide (LPCSTR AnsiStr, UINT CodePage,DWORD dwFlags) {
  UINT uLen;
  BSTR WideStr;
  uLen=MultiByteToWideChar(CodePage,dwFlags,AnsiStr,-1,0,0);
  if (uLen<=1) return (BSTR) BCX_TmpStr(2);
  WideStr = (BSTR) BCX_TmpStr(2*uLen);
  MultiByteToWideChar(CodePage,dwFlags,AnsiStr,uLen,WideStr,uLen);
  return WideStr;
}
//>---UNICODE AWARE

// *************************************************
//            User's Subs and Functions
// *************************************************

C_EXPORT int __stdcall CommSettings (HWND hParent,int* port,int* baudrate,int* parity,int* databits,int* stopbits,int* hs)
{
  CommSet.Baud=(*baudrate);
  CommSet.Port=(*port);
  CommSet.Parity=(*parity);
  CommSet.StopBits=(*stopbits);
  CommSet.DataBits=(*databits);
  CommSet.XonXoff=(*hs);
  FormCOMMSET_Create(hParent);
  (*baudrate)=CommSet.Baud;
  (*port)=CommSet.Port;
  (*parity)=CommSet.Parity;
  (*stopbits)=CommSet.StopBits;
  (*databits)=CommSet.DataBits;
  (*hs)=CommSet.XonXoff;
  return GetLastError();
}


int FormCOMMSET_Create (HWND hParent)
{
  BCX_MDialog ((DLGPROC) Ev_FormCOMMSET,"Configure Serial Port",hParent,68,54,114,132);
  return 0;
}


INT_PTR CALLBACK Ev_FormCOMMSET (HWND hWnd,UINT Msg,WPARAM wParam,LPARAM lParam)
{
  HFONT    hFont={0};
  if(Msg==WM_INITDIALOG ){
      SetDialogScale(hWnd,0);
      FormCOMMSET=hWnd;
      hcommSet_Stc1=BCX_Label("Ports",FormCOMMSET,ID_commSet_Stc1,4,4,24,8,commSet_Stc1_Style,commSet_Stc1_ExtStyle);
      hcommSet_Stc2=BCX_Label("Baud Rate",FormCOMMSET,ID_commSet_Stc2,4,20,36,8,commSet_Stc2_Style,commSet_Stc2_ExtStyle);
      hcommSet_Stc3=BCX_Label("Parity",FormCOMMSET,ID_commSet_Stc3,4,36,36,8,commSet_Stc3_Style,commSet_Stc3_ExtStyle);
      hcommSet_Stc4=BCX_Label("Data Bits",FormCOMMSET,ID_commSet_Stc4,4,52,36,8,commSet_Stc4_Style,commSet_Stc4_ExtStyle);
      hcommSet_Stc5=BCX_Label("Stop Bits",FormCOMMSET,ID_commSet_Stc5,4,68,36,8,commSet_Stc5_Style,commSet_Stc5_ExtStyle);
      hcommSet_Stc6=BCX_Label("Flow Control",FormCOMMSET,ID_commSet_Stc6,4,84,36,8,commSet_Stc6_Style,commSet_Stc6_ExtStyle);
      hcommSet_Cmb1=BCX_Combobox("",FormCOMMSET,ID_commSet_Cmb1,44,4,60,80,commSet_Cmb1_Style,commSet_Cmb1_ExtStyle);
      hcommSet_Cmb2=BCX_Combobox("",FormCOMMSET,ID_commSet_Cmb2,44,20,60,80,commSet_Cmb1_Style,commSet_Cmb1_ExtStyle);
      hcommSet_Cmb3=BCX_Combobox("",FormCOMMSET,ID_commSet_Cmb3,44,36,60,80,commSet_Cmb1_Style,commSet_Cmb1_ExtStyle);
      hcommSet_Cmb4=BCX_Combobox("",FormCOMMSET,ID_commSet_Cmb4,44,52,60,80,commSet_Cmb1_Style,commSet_Cmb1_ExtStyle);
      hcommSet_Cmb5=BCX_Combobox("",FormCOMMSET,ID_commSet_Cmb5,44,68,60,80,commSet_Cmb1_Style,commSet_Cmb1_ExtStyle);
      hcommSet_Cmb6=BCX_Combobox("",FormCOMMSET,ID_commSet_Cmb6,44,84,60,80,commSet_Cmb1_Style,commSet_Cmb1_ExtStyle);
      hcommSet_Btn1=BCX_Button("Save/Exit",FormCOMMSET,ID_commSet_Btn1,4,100,48,16,commSet_Btn1_Style,commSet_Btn1_ExtStyle);
      hcommSet_Btn2=BCX_Button("Cancel",FormCOMMSET,ID_commSet_Btn2,56,100,48,16,commSet_Btn2_Style,commSet_Btn2_ExtStyle);
      LoadcboPorts(hcommSet_Cmb1);
      LoadcboBauds(hcommSet_Cmb2);
      LoadcboParity(hcommSet_Cmb3);
      LoadcboDataBits(hcommSet_Cmb4);
      LoadcboStopBits(hcommSet_Cmb5);
      LoadcboFlow(hcommSet_Cmb6);
      Show(FormCOMMSET);
      goto L1000;
    }
  if(Msg==WM_COMMAND ){
      if(LOWORD(wParam)==ID_commSet_Cmb1 ){
          goto L1001;
        }
      if(LOWORD(wParam)==ID_commSet_Cmb2 ){
          goto L1001;
        }
      if(LOWORD(wParam)==ID_commSet_Cmb3 ){
          goto L1001;
        }
      if(LOWORD(wParam)==ID_commSet_Cmb4 ){
          goto L1001;
        }
      if(LOWORD(wParam)==ID_commSet_Cmb5 ){
          goto L1001;
        }
      if(LOWORD(wParam)==ID_commSet_Cmb6 ){
          goto L1001;
        }
      if(LOWORD(wParam)==ID_commSet_Btn1 ){
          GetcbosValues();
          EndDialog(hWnd,0);
          goto L1001;
        }
      if(LOWORD(wParam)==ID_commSet_Btn2 ){
          EndDialog(hWnd,0);
        }
L1001:;
    }
L1000:;
  if(Msg==WM_CLOSE) EndDialog(hWnd,0);
  return EXIT_SUCCESS;
}


void frmDummy (void)
{
  HWND     a={0};
  a=BCX_Form("My Form",0,0,100,100,WS_CAPTION|WS_SYSMENU);
}


void ComboBoxAdd (HANDLE hWnd,char* A)
{
  SendMessage(hWnd,(UINT)CB_ADDSTRING,(WPARAM)0,(LPARAM)A);
}


int CbSelectString (HWND hComboBox,int Index,char* Text)
{
  return SendMessage(hComboBox,(UINT)CB_SELECTSTRING,(WPARAM)Index,(LPARAM)Text);
}


int CbSetCurSel (HWND hComboBox,int Index)
{
  return SendMessage(hComboBox,(UINT)CB_SETCURSEL,(WPARAM)Index,(LPARAM)0);
}


char * CbGetLbText (HWND hComboBox,int Index)
{
  char *BCX_RetStr={0};
  char    zText[BCXSTRSIZE]={0};
  if(Index<0 ){
      Index=CbGetCurSel(hComboBox);
    }
  SendMessage(hComboBox,(UINT)CB_GETLBTEXT,(WPARAM)Index,(LPARAM)zText);
  BCX_RetStr = BCX_TmpStr(strlen(zText));
  strcpy(BCX_RetStr,zText);
  return BCX_RetStr;
}


int CbGetCurSel (HWND hComboBox)
{
  return SendMessage(hComboBox,(UINT)CB_GETCURSEL,(WPARAM)0,(LPARAM)0);
}


void GetcbosValues (void)
{
  CommSet.Port=VAL(CbGetLbText(hcommSet_Cmb1,-1));
  CommSet.Baud=VAL(CbGetLbText(hcommSet_Cmb2,-1));
  CommSet.Parity=CbGetCurSel(hcommSet_Cmb3);
  CommSet.DataBits=VAL(CbGetLbText(hcommSet_Cmb4,-1));
  CommSet.StopBits=VAL(CbGetLbText(hcommSet_Cmb5,-1));
  CommSet.XonXoff=CbGetCurSel(hcommSet_Cmb6);
}


void LoadcboPorts (HWND hWnd)
{
  ComboBoxAdd(hWnd,"None");
    {int i;
  for(i=1; i<=32; i+=1)
    {
      ComboBoxAdd(hWnd,str(i));
    }
    }
  CbSelectString(hWnd,0,str(CommSet.Port));
}


void LoadcboBauds (HWND hWnd)
{
  ComboBoxAdd(hWnd," 300 ");
  ComboBoxAdd(hWnd," 600 ");
  ComboBoxAdd(hWnd," 1200 ");
  ComboBoxAdd(hWnd," 2400 ");
  ComboBoxAdd(hWnd," 9600 ");
  ComboBoxAdd(hWnd," 14400 ");
  ComboBoxAdd(hWnd," 19200 ");
  ComboBoxAdd(hWnd," 28800 ");
  ComboBoxAdd(hWnd," 38400 ");
  ComboBoxAdd(hWnd," 57600 ");
  ComboBoxAdd(hWnd," 115200 ");
  ComboBoxAdd(hWnd," 230400 ");
  ComboBoxAdd(hWnd," 460800 ");
  ComboBoxAdd(hWnd," 921600 ");
  CbSelectString(hWnd,1,str(CommSet.Baud));
}


void LoadcboParity (HWND hWnd)
{
  ComboBoxAdd(hWnd," None ");
  ComboBoxAdd(hWnd," Odd ");
  ComboBoxAdd(hWnd," Even ");
  ComboBoxAdd(hWnd," Mark ");
  ComboBoxAdd(hWnd," Space ");
  CbSetCurSel(hWnd,CommSet.Parity);
}


void LoadcboDataBits (HWND hWnd)
{
  ComboBoxAdd(hWnd," 5 ");
  ComboBoxAdd(hWnd," 6 ");
  ComboBoxAdd(hWnd," 7 ");
  ComboBoxAdd(hWnd," 8 ");
  CbSelectString(hWnd,1,str(CommSet.DataBits));
}


void LoadcboStopBits (HWND hWnd)
{
  ComboBoxAdd(hWnd," 1 ");
  ComboBoxAdd(hWnd," 1.5 ");
  ComboBoxAdd(hWnd," 2 ");
  CbSelectString(hWnd,1,str(CommSet.StopBits));
}


void LoadcboFlow (HWND hWnd)
{
  ComboBoxAdd(hWnd," None ");
  ComboBoxAdd(hWnd," Hardware ");
  ComboBoxAdd(hWnd," Xon / Xoff ");
  CbSetCurSel(hWnd,CommSet.XonXoff);
}


C_EXPORT BOOL __stdcall OpenComm (HWND cParentHwnd,int port,int baudrate,int parity,int databits,int stopbits,int hs,int inpbuff,int outbuff)
{
  if(port==0 ){
      port=1;
    }
  if(baudrate==0 ){
      baudrate=9600;
    }
  if(parity>4 ){
      parity=NOPARITY;
    }
  if(databits==0 ){
      databits=8;
    }
  if(stopbits==0 ){
      stopbits=ONESTOPBIT;
    }
  if(inpbuff==0 ){
      inpbuff=4096;
    }
  if(outbuff==0 ){
      outbuff=4096;
    }
  if(!cParentHwnd ){
      cMainHwnd=GetActiveWindow();
    }
  else
    {
      cMainHwnd=cParentHwnd;
    }
    COMMTIMEOUTS  cto={0};
    DCB      PortDCB={0};
  char    comport[BCXSTRSIZE];
  SetLastError(0);
  strcpy(comport, join(2,"\\\\.\\COM",ltrim(str(port))));
  hComm[port]=CreateFile(comport,GENERIC_READ|GENERIC_WRITE,0,NULL,OPEN_EXISTING,FILE_FLAG_OVERLAPPED,NULL);
  if(hComm[port]==INVALID_HANDLE_VALUE ){
      MessageBox (GetActiveWindow(),join(2,"CreateFile Failed in OpenComm on COM: ",str(port)),"",0 );
      return FALSE;
    }
  SetupComm(hComm[port],inpbuff,outbuff);
  InitializeCriticalSection( &wricom);
  InitializeCriticalSection( &readcom);
  InitializeCriticalSection( &protect_comstat);
  WrBufQue=(char*)calloc(1 ,1);
  WrBuff=(char*)calloc(1 ,1);
  ReadBuffer=(char*)calloc(1 ,1);
  cto.ReadIntervalTimeout=20;
  cto.ReadTotalTimeoutMultiplier=10;
  cto.ReadTotalTimeoutConstant=10;
  cto.WriteTotalTimeoutMultiplier=10;
  cto.WriteTotalTimeoutConstant=10;
  SetCommTimeouts(hComm[port], &cto);
  PortDCB.DCBlength=sizeof(PortDCB);
  GetCommState(hComm[port], &PortDCB);
  PortDCB.BaudRate=baudrate;
  PortDCB.fBinary=TRUE;
  PortDCB.fParity=TRUE;
  PortDCB.fOutxDsrFlow=FALSE;
  PortDCB.fDtrControl=DTR_CONTROL_DISABLE;
  PortDCB.fDsrSensitivity=FALSE;
  PortDCB.fTXContinueOnXoff=TRUE;
  PortDCB.fErrorChar=0;
  PortDCB.fNull=FALSE;
  PortDCB.fAbortOnError=FALSE;
  PortDCB.ByteSize=databits;
  PortDCB.Parity=parity;
  PortDCB.StopBits=stopbits-1;
  if(hs>1 ){
      PortDCB.fOutxCtsFlow=TRUE;
      PortDCB.fRtsControl=RTS_CONTROL_HANDSHAKE;
    }
  else
    {
      PortDCB.fOutxCtsFlow=FALSE;
      PortDCB.fRtsControl=RTS_CONTROL_ENABLE;
    }
  if(hs==1||hs==3 ){
      PortDCB.fOutX=TRUE;
      PortDCB.fInX=TRUE;
    }
  else
    {
      PortDCB.fOutX=FALSE;
      PortDCB.fInX=FALSE;
    }
  if(!SetCommState(hComm[port], &PortDCB)){
      MessageBox (GetActiveWindow(),join(2,"SetCommState Failed in OpenComm on COM: ",str(port)),"",0 );
    }
  PurgeComm(hComm[port],PURGE_RXCLEAR|PURGE_TXCLEAR);
  ThreadReadState[port]=TRUE;
  threadcomm[port]=BCX_MYTHREAD(ReadThread,port);
  if(GetLastError()){
      printf("%s%s\n","ERROR: ",str(GetLastError()));
    }
  return TRUE;
}


C_EXPORT int __stdcall CloseComm (int port)
{
  int     nRet={0};
  int     failed={0};
  if(hComm[port]){
      ThreadReadState[port]=0;
      Sleep(1);
      nRet=PurgeComm(hComm[port],PURGE_RXABORT|PURGE_TXABORT|PURGE_RXCLEAR|PURGE_TXCLEAR);
      if(!nRet ){
          printf("%s%s%s%s%s%s\n","Close PurgeComm failed Port",str(port),"    ",str(nRet),"      ",str(GetLastError()));
        }
      if(threadcomm[port]){
          nRet=WaitForSingleObject(threadcomm[port],3000);
          if(nRet==0 ){
              nRet=CloseHandle(threadcomm[port]);
              threadcomm[port]=0;
            }
          else
            {
              failed++;
              printf("%s%s%s%s%s%s\n","Close thread failed Port",str(port),"    ",str(nRet),"      ",str(GetLastError()));
            }
        }
      if(threadcomm[port+16]){
          nRet=WaitForSingleObject(threadcomm[port+16],3000);
          if(nRet==0 ){
              nRet=CloseHandle(threadcomm[port+16]);
              if(!nRet ){
                  printf("%s%s\n","Close handle failed + 16 ",str(port+16));
                }
              threadcomm[port+16]=0;
            }
          else
            {
              failed++;
              printf("%s%s%s%s%s%s\n","Close thread +16 failed Port",str(port),"    ",str(nRet),"      ",str(GetLastError()));
            }
        }
      if(!failed ){
          CloseHandle(hComm[port]);
          hComm[port]=0;
          return 0;
        }
    }
  return 1;
}


C_EXPORT void __stdcall ExitComms (void)
{
  DeleteCriticalSection( &wricom);
  DeleteCriticalSection( &readcom);
  DeleteCriticalSection( &protect_comstat);
  if(WrBufQue ){
      free(WrBufQue), WrBufQue=NULL;
    }
  if(WrBuff ){
      free(WrBuff), WrBuff=NULL;
    }
  if(ReadBuffer ){
      free(ReadBuffer), ReadBuffer=NULL;
    }
}


C_EXPORT void __stdcall SendData (HWND cParentHwnd,int port,LPCSTR out,int L)
{
  if(!L ){
      L=(int)strlen(out);
    }
  EnterCriticalSection( &wricom);
  WrBufQue=(char*)realloc(WrBufQue,L+WriteBufCount );
  if(strcmp(WrBufQue,NULL)==0){
      MessageBox (GetActiveWindow(),"Write Que allocation error","",0 );
      return;
    }
  memmove( &WrBufQue[WriteBufCount],out,L);
  WriteBufCount+=(L);
  if(ThreadWriteState[port]){
      LeaveCriticalSection( &wricom);
      return;
    }
  if(threadcomm[port+16]){
      CloseHandle(threadcomm[port+16]);
    }
  ThreadWriteState[port]=TRUE;
  LeaveCriticalSection( &wricom);
  threadcomm[port+16]=BCX_MYTHREAD(XmitDataThread,port);
}


C_EXPORT LPSTR __stdcall RecvCommData (int port,int NBytes)
{
  static LPSTR    rccv;
  EnterCriticalSection( &readcom);
  rccv=(char*)realloc(rccv,ReadBufCount+1 );
  if(ReadBufCount>NBytes ){
      memmove(rccv,ReadBuffer,NBytes);
      rccv[NBytes]=0;
      ReadBufCount-=(NBytes);
      memmove(ReadBuffer, &ReadBuffer[NBytes],ReadBufCount);
    }
  else
    {
      memmove(rccv,ReadBuffer,ReadBufCount);
      rccv[ReadBufCount]=0;
      ReadBufCount=0;
      free(ReadBuffer);
      ReadBuffer=(char*)calloc(1 ,1);
    }
  LeaveCriticalSection( &readcom);
  PurgeComm(hComm[port],PURGE_RXCLEAR|PURGE_TXCLEAR);
  return rccv;
}


UINT STDMETHODCALLTYPE ReadThread (int port)
{
  int     nofchar;
  COMSTAT  cstatus;
  DWORD    comerr;
  ULONG    cbChars;
  DWORD    modstat;
  DWORD    premodstat;
  char  *rcvbuf=0;
  {
  size_t dimensions[1] = {(size_t)1};
  rcvbuf= (char*)CreateArr (rcvbuf,sizeof(char),0,1, dimensions);
  }
  OVERLAPPED  szOverLapped={0};
  premodstat=MAXDWORD;
  while(ThreadReadState[port]){
      ClearCommError(hComm[port], &comerr, &cstatus);
      if(comerr ){
          PostMessage(cMainHwnd,WM_COMERROR,port,comerr);
        }
      EnterCriticalSection( &protect_comstat);
      gcomstat=cstatus;
      LeaveCriticalSection( &protect_comstat);
      GetCommModemStatus(hComm[port], &modstat);
      if(modstat!=premodstat ){
          premodstat=modstat;
          PostMessage(cMainHwnd,WM_MODSTATUS,port,modstat);
        }
      nofchar=cstatus.cbInQue;
      if(nofchar ){
          rcvbuf=(LPSTR)realloc(rcvbuf,nofchar+1);
          memset(rcvbuf,0,nofchar+1);
          ReadFile(hComm[port],rcvbuf,nofchar, &cbChars, &szOverLapped);
          EnterCriticalSection( &readcom);
          ReadBuffer=(LPSTR)realloc(ReadBuffer,ReadBufCount+cbChars+1);
          if(strcmp(ReadBuffer,NULL)==0){
              MessageBox(cMainHwnd,"Read buffer allocation error!","",0);
            }
          memmove( &ReadBuffer[ReadBufCount],rcvbuf,cbChars);
          ReadBufCount+=(cbChars);
          SendNotifyMessage(cMainHwnd,WM_RCVDATA,port,cbChars);
          LeaveCriticalSection( &readcom);
        }
      Sleep(1);
    }
  *rcvbuf=0;
  if(ReadBuffer ){
      free(ReadBuffer), ReadBuffer=NULL;
    }
  if(rcvbuf ){
      free(rcvbuf), rcvbuf=NULL;
    }
  BCX_MYTHREADEND;
}


UINT STDMETHODCALLTYPE XmitDataThread (int port)
{
  ULONG    cbChars;
  char*    tptr;
  int     tmpcount;
  OVERLAPPED  szOverLapped={0};
  ULONG    CharsWritten;
  CharsWritten=WriteBufCount;
  EnterCriticalSection( &wricom);
  while(WriteBufCount!=0){
      tptr=WrBufQue;
      WrBufQue=WrBuff;
      WrBuff=tptr;
      tmpcount=WriteBufCount;
      WriteBufCount=0;
      free(WrBufQue);
      WrBufQue=(char*)calloc(1 ,1);
      LeaveCriticalSection( &wricom);
      if(!WriteFile(hComm[port],WrBuff,tmpcount, &cbChars, &szOverLapped)){
          if(GetLastError()==ERROR_IO_PENDING ){
              GetOverlappedResult(hComm[port], &szOverLapped, &cbChars,TRUE);
            }
          else
            {
              MessageBox(cMainHwnd,join(2,"Com write error! - ",hex(GetLastError())),"",MB_ICONWARNING);
            }
        }
      EnterCriticalSection( &wricom);
    }
  SendNotifyMessage(cMainHwnd,WM_SENTDATA,port,CharsWritten);
  free(WrBuff);
  WrBuff=(char*)calloc(1 ,1);
  ThreadWriteState[port]=FALSE;
  LeaveCriticalSection( &wricom);
  BCX_MYTHREADEND;
}


C_EXPORT int __stdcall ComStatus (int port,char* st)
{
  int     t={0};
  char    tt[BCXSTRSIZE];
  strcpy(tt,ucase(st));
  EnterCriticalSection( &protect_comstat);
  if(strcmp(tt,"CTS")==0){
      t=gcomstat.fCtsHold;
      goto L1005;
    }
  if(strcmp(tt,"DSR")==0){
      t=gcomstat.fDsrHold;
      goto L1005;
    }
  if(strcmp(tt,"CD")==0){
      t=gcomstat.fRlsdHold;
      goto L1005;
    }
  if(strcmp(tt,"XOFFRCV")==0){
      t=gcomstat.fXoffHold;
      goto L1005;
    }
  if(strcmp(tt,"XOFFSENT")==0){
      t=gcomstat.fXoffSent;
      goto L1005;
    }
  if(strcmp(tt,"EOF")==0){
      t=gcomstat.fEof;
      goto L1005;
    }
  if(strcmp(tt,"CTX")==0){
      t=gcomstat.fTxim;
      goto L1005;
    }
  if(strcmp(tt,"RCVBUFF")==0){
      t=gcomstat.cbInQue;
    }
L1005:;
  LeaveCriticalSection( &protect_comstat);
  return t;
}


C_EXPORT void __stdcall SendDataW (HWND cParentHwnd,int port,LPWSTR out,int L)
{
  SendData(cParentHwnd,port,WideToAnsi(out),L);
}


C_EXPORT LPWSTR __stdcall RecvCommDataW (int port,int NBytes)
{
  return AnsiToWide(RecvCommData(port,NBytes));
}



// *************************************************
//                  Main Program
// *************************************************

  
  __declspec(dllexport) BOOL WINAPI DllMain (HINSTANCE hInst, DWORD Reason, LPVOID Reserved)
{
    switch (Reason)
    {
      case DLL_PROCESS_ATTACH:
        BCX_hInstance = hInst;
        break;
      case DLL_PROCESS_DETACH:
        break;
      case DLL_THREAD_ATTACH:
        break;
      case DLL_THREAD_DETACH:
        break;
     }
   return TRUE;
  }
  
  
