'This file :
'$INCLUDE "Decode_SerialPorts.inc"

TYPE GPSData
   Lat as Double
   Lon as Double
   Alt as Double
   Time as Double
   HDOP as single
   VDOP as single
   SVS as integer
   Differential as integer
   
END TYPE

Global LastGPS as GPSData

FUNCTION DecodeSonar(RecvString$) as single
  DYNAMIC h$[1]
  DYNAMIC lines$[1]
  Dim NoOfLines, MyData , LastSDDLine, WaterDepth As SINGLE, i

  NoOfLines = FastLexer(&lines, RecvString$, CR$,"", 1)
  For i = 1 to (NoOfLines)
    IF INSTR(lines$[i],"DBT") then 
      MyData = FastLexer(&h$, lines$[i], ",","", 1)
      WaterDepth = VAL(h$[2])
    END IF
  Next i
    'FREE h$
    'FREE lines$
  FUNCTION = WaterDepth
END FUNCTION


FUNCTION DecodeGPS(RecvString$) as ulong 'single 'BOOL
  DYNAMIC h$[1]
  DYNAMIC lines$[1]
  Dim NoOfLines, MyData,i ', LastGPSLine
  Dim North as integer
  'FUNCTION = 0
  SetLastError(0)

    NoOfLines = FastLexer(&lines, RecvString$, "$","", 1)
    'NoOfLines = DSPLIT(lines, RecvString$, CR$)
    'RecvString$ = lines$[NoOfLines]
    If NoOfLines = 0 then Function = 0
    For i = 1 to NoOfLines 'to 1 STEP -1
      MyData = FastLexer(&h$, lines$[i], ",","", 1)
      If MyData < 10 then
        iterate
      END IF
      IF INSTR(h$[1],"PASHR") then
        IF VAL(h$[1]) = 1 then LastGPS.Differential = TRUE else LastGPS.Differential = False
        LastGPS.SVS = VAL(h$[2])
        LastGPS.Time = VAL(h$[3])
        LastGPS.Lat = VAL(h$[4])
        'IF VAL(h$[2]) then LastGPS.Differential = TRUE else LastGPS.Differential = False
        If INSTR(h$[5] ,"S") then LastGPS.Lat  = LastGPS.Lat  * -1
        LastGPS.Lon = VAL(h$[6])
        If INSTR(h$[7] ,"W") then LastGPS.Lon  = LastGPS.Lon  * -1
        LastGPS.Alt = VAL(h$[8])
        LastGPS.HDOP = VAL(h$[14])
        LastGPS.VDOP = VAL(h$[15])
        GOTO EndFunct
        'Function = GetLastError() 'VAL(h$[1])
      END IF
      'IF INSTR(lines$[i],"GPGGA") then
      IF INSTR(h$[1],"GPGGA") then
        LastGPS.Time = VAL(h$[2])
        LastGPS.Lat = DDMMtoDDec(h$[3])
        If INSTR(h$[3] ,"S") then LastGPS.Lat = LastGPS.Lat  * -1
        LastGPS.Lon = DDMMtoDDec(h$[5])
        If INSTR(h$[6] ,"W") then LastGPS.Lon = LastGPS.Lon  * -1
        LastGPS.Differential = VAL(h$[7])
        LastGPS.SVS = VAL(h$[8])
        LastGPS.HDOP = VAL(h$[9])
        LastGPS.Alt = (VAL(h$[10]) * 3.281) '+ (VAL(h$[12]) * 3.281)
        'PRINT "Got LastGPS: " & STR$(LastGPS.Lat)
        GOTO EndFunct
        'Function = GetLastError() 'LastGPS.Alt  'VAL(h$[2])
      END IF
    Next i
EndFunct:

    'REDIM h$[0]
    'REDIM lines$[0]
    'FREE h$
    'dim tmp$', i
    'FOR i = 1 to 2048
    '   tmp$ = str$(1)
    'NEXT
  FUNCTION = GetLastError()
END FUNCTION

$INCLUDE "FastLexer.inc"
