'*************************************************************
'sStkOut$ is a Dynamic string array passed to the function
'this will be redimensioned if iMinLen is not 0.
'sStkOut$ will contain the strings.
'sArg$ is string to parse
'sDelim1$ = delimiters to be removed
'sDelim2$ = delimiters to keep
'iMinLen Values:
' 0 - Do not resize the sStkOut$ array, default
' 1 - redimension the sStkOut$ array to minimum needed
' other - redimension the sStkOut$ array to minimum needed , minimum string
' length not to be shorter than this value
'Returns the number of cells in the redimmed array
'
'by Wayne Halsdorf 2008
'*************************************************************
FUNCTION FastLexer OPTIONAL (sStkOut AS CHAR PTR PTR PTR,sArg$, sDelim1$ ="", sDelim2$ = "", iMinLen = 0) AS integer

  RAW iCNT1=0
  RAW iCNT2=0
  RAW psD1 AS PCHAR
  RAW psD2 AS PCHAR
  RAW iNdx=1
  DYNAMIC szW[1][1] AS CHAR
  RAW sStk AS PCHAR PTR
  RAW fl_Fields = 1
  RAW  fl_MaxFieldLen = 0
  FREE  szW
  FREE  (szW)
  ' do pseudo lex to get field count and resize the array
  IF iMinLen then


    WHILE sArg[iCNT1]
      IF sArg[iCNT1] = 34 THEN ' quotes - string literals
        IF iCNT2 THEN
          fl_Fields++
          IF fl_MaxFieldLen < iCNT2 THEN fl_MaxFieldLen = iCNT2
          iCNT2 = 0
        END IF

        WHILE sArg[++iCNT1] <> 34
          iCNT2++
          IF sArg[iCNT1] = 0 THEN GOTO exfieldcnt
          IF sArg[iCNT1] = 10 OR sArg[iCNT1] = 13 THEN
             sArg[iCNT1] = 34 : EXIT WHILE
          END IF
        WEND

        fl_Fields++
        IF fl_MaxFieldLen < iCNT2 THEN fl_MaxFieldLen = iCNT2
        iCNT2 = 0
        GOTO fieldcnt
      END IF
      psD1 = sDelim1

      WHILE *psD1           'check for delim1 arguments
        IF *(psD1++) = sArg[iCNT1] THEN
          IF iCNT2 THEN
            fl_Fields++
            IF fl_MaxFieldLen < iCNT2 THEN fl_MaxFieldLen = iCNT2
            iCNT2 = 0
          END IF
          GOTO fieldcnt
        END IF
      WEND

      psD2 = sDelim2

      WHILE *psD2           'check for delim2 arguments
        IF *(psD2++) = sArg[iCNT1] THEN
          IF iCNT2 THEN fl_Fields++
          fl_Fields++
          IF fl_MaxFieldLen < iCNT2 THEN fl_MaxFieldLen = iCNT2
          iCNT2 = 0
          GOTO fieldcnt
        END IF
      WEND

      iCNT2++


fieldcnt:
      INCR iCNT1
    WEND

    'IF iCNT2 = 0 THEN DECR fl_Fields
    IF fl_MaxFieldLen < iCNT2 THEN fl_MaxFieldLen = iCNT2


exfieldcnt:
    fl_MaxFieldLen += 2
    iCNT1 = 0   ' Reset counters
    iCNT2 = 0

    'resize the array
    szW = *sStkOut
    FREE szW
    szW = NULL
    ' String length will be minimum unless iMinLen is greater than fl_MaxFieldLen
    IF iMinLen THEN
      ' No smaller than iMinLen
      IF iMinLen > fl_MaxFieldLen THEN
        fl_MaxFieldLen = iMinLen '+256
      END IF
    END IF
    REDIM szW[fl_Fields+2][fl_MaxFieldLen] ' we need extra 2 fl_Fields
    *sStkOut = szW
    sStk = *sStkOut
    szW = NULL
  ELSE
    sStk = *sStkOut
  END IF 'iMinLen

  'the real fastlexer function
  WHILE sArg[iCNT1]

    IF sArg[iCNT1] = 34 THEN ' quotes - string literals
      IF iCNT2 THEN sStk[iNdx++][iCNT2]=0 : iCNT2=0
      sStk[iNdx][0] = 34

      WHILE sArg[++iCNT1] <> 34
        sStk[iNdx][++iCNT2] = sArg[iCNT1]
        IF sArg[iCNT1] = 0 THEN GOTO ex 'clean-up dynamic array before exit
        IF sArg[iCNT1] = 10 OR sArg[iCNT1] = 13 THEN
          sArg[iCNT1] = 34 : EXIT WHILE
        END IF
      WEND

      sStk[iNdx][++iCNT2] = sArg[iCNT1]
      sStk[iNdx++][++iCNT2]=0
      iCNT2=0
      GOTO again
    END IF
    psD1 = sDelim1

    WHILE *psD1           'check for delim1 arguments
      IF *(psD1++) = sArg[iCNT1] THEN
        IF iCNT2 THEN sStk[iNdx++][iCNT2]=0 : iCNT2=0
        GOTO again
      END IF
    WEND

    psD2 = sDelim2

    WHILE *psD2           'check for delim2 arguments
      IF *(psD2++) = sArg[iCNT1] THEN
        IF iCNT2 THEN sStk[iNdx++][iCNT2]=0
        sStk[iNdx][0] = sArg[iCNT1]
        sStk[iNdx++][1]=0 : iCNT2 = 0
        GOTO again
      END IF
    WEND

    sStk[iNdx][iCNT2++]=sArg[iCNT1]


again:
    INCR iCNT1
  WEND

  sStk[iNdx][iCNT2]=0
  IF iCNT2 = 0 THEN DECR iNdx

ex:

  FUNCTION = iNdx

END FUNCTION