'ORIGINAL BY: IDC  May 2007
'FEB 2009: Mike Henning helped me rewrite this.
'Mike added InitAnchor & UpdateAnchor
'Thanks Mike

'Notes: the MoveAnchorControl function is only expected to be called through
' the WM_SIZE event. 
'To use MoveAnchorControl function you will need to call 
'InitAnchor(myForm) for the form and for any sub form like 
'a tab control in your FormLoad code.
'also see the Events loop: 
'UpdateAnchor(Form1) needs to be called after each size event

'MoveAnchorControl Parameters
'hWnd          - Control handle
'anchor        - a combination of the Constants below
'Horizontal : AnchorLeft | AnchorRight | AnchorHCenter 
'Vertical   : AnchorTop | AnchorBottom | AnchorVCenter

'AnchorLeft  will just left justify the ctrl
'AnchorRight will just right justify the ctrl
'AnchorLeft | AnchorRight will left justify the Left side of the ctrl and 
'right justify the right side of the ctrl

'AnchorHCenter will justify toward the center proportionally to page size
'AnchorHCenter | AnchorLeft will left justify to the left and grow the width
'AnchorHCenter | AnchorRight will right justify to the right and grow the width
'AnchorHCenter | AnchorLeft | AnchorRight will scale the ctrls position and width
'
' Similar results for vertical sizes are obtained by using:
'AnchorTop AnchorBottom & AnchorVCenter parameters

'NOTES: AnchorLeft &  AnchorTop will NOT do anything by themselves
'      Make the original form the smallest size you want the user to use,
'      InitAnchor will stop controls sizing smaller than the original
'      IsSubForm - optional, use 2 if control parent is a Tab page. default = false

TYPE anchor
   IsSubForm
   XMin
   YMin
   PrevRC AS RECT
END TYPE

CONST AnchorLeft = 1
CONST AnchorRight = 2
CONST AnchorTop = 4
CONST AnchorBottom = 8
CONST AnchorHCenter = 16     'this is left/right
CONST AnchorVCenter = 32     'this is up/down

FUNCTION MoveAnchorControl(hWnd AS HWND, anchor AS integer) AS RECT
   DIM RAW newRC AS RECT
   DIM RAW ctrlrc AS RECT
   DIM RAW prc AS RECT
   DIM RAW scalefactor AS DOUBLE
   DIM RAW hParent AS HWND
   DIM RAW pa AS LPANCHOR
   hParent = GetParent(hWnd)
   prc = GetScaledRect(hParent)

   pa = (LPANCHOR)GetProp(hParent,(LPCSTR)"Anchor")
   IF NOT pa THEN FUNCTION = prc

   ctrlrc = GetScaledRect(hWnd)
   IF prc.right < pa->XMin THEN prc.right = pa->XMin
   IF prc.bottom < pa->YMin THEN prc.bottom = pa->YMin

   IF pa->IsSubForm THEN
      ctrlrc.left = MAX(0, ctrlrc.left - prc.left)
      ctrlrc.top = MAX(0, ctrlrc.top - prc.top)
   ELSE
      ctrlrc.left = MAX(0, ctrlrc.left - prc.left - GetSystemMetrics(SM_CXSIZEFRAME))
      ctrlrc.top = MAX(0, ctrlrc.top - prc.top - GetSystemMetrics(SM_CYCAPTION) - GetSystemMetrics(SM_CYSIZEFRAME))
   END IF
   'This checks for a menu, and subtracts the Menu size if required
   IF GetMenu(hParent) THEN
      ctrlrc.top = ctrlrc.top - (GetSystemMetrics(SM_CYMENUSIZE)+1)
   END IF

   '****************************************
      
   newRC = ctrlrc
   scalefactor = CDBL(prc.right - (2 * GetSystemMetrics(SM_CXSIZEFRAME)))/ CDBL(pa->PrevRC.right - (2 * GetSystemMetrics(SM_CXSIZEFRAME)))

   SELECT CASE (anchor BAND (AnchorLeft + AnchorRight + AnchorHCenter))
      '--------------------
      CASE AnchorRight
      '--------------------
      newRC.left = prc.right - (pa->PrevRC.right - ctrlrc.left)
      '--------------------
      CASE AnchorLeft + AnchorRight
      '--------------------
      newRC.right = prc.right - (pa->PrevRC.right - ctrlrc.right)
      '--------------------
      CASE AnchorHCenter
      '--------------------
      newRC.left = ctrlrc.left - ((pa->PrevRC.right - prc.right)/2)
      '--------------------
      CASE AnchorRight + AnchorHCenter
      '--------------------
      newRC.right = CINT(CDBL(ctrlrc.right) * scalefactor)
      newRC.left = prc.right - (pa->PrevRC.right - ctrlrc.left)
      newRC.left = newRC.left + ctrlrc.right - newRC.right
      '--------------------
      CASE AnchorLeft + AnchorHCenter
      '--------------------
      newRC.right = CINT(CDBL(ctrlrc.right) * scalefactor)
      '--------------------
      CASE AnchorLeft + AnchorRight + AnchorHCenter
      '--------------------      
      newRC.right = CINT(CDBL(ctrlrc.right) * scalefactor)
      newRC.left = CINT(CDBL(ctrlrc.left) * scalefactor)
   END SELECT

   scalefactor = CDBL(prc.bottom )/ CDBL(pa->PrevRC.bottom)
   SELECT CASE (anchor BAND (AnchorTop + AnchorBottom + AnchorVCenter))
      '--------------------
      CASE AnchorBottom
      '--------------------
      newRC.top = prc.bottom - (pa->PrevRC.bottom - ctrlrc.top)
      '--------------------
      CASE AnchorTop + AnchorBottom
      '--------------------
      newRC.bottom = prc.bottom - (pa->PrevRC.bottom - ctrlrc.bottom)
      '--------------------
      CASE AnchorVCenter
      '--------------------
      newRC.top = ctrlrc.top - ((pa->PrevRC.bottom - prc.bottom)/2)
      '--------------------
      CASE AnchorBottom + AnchorVCenter
      '--------------------
      newRC.bottom = CINT(CDBL(ctrlrc.bottom) * scalefactor)
      newRC.top = prc.bottom - (pa->PrevRC.bottom - ctrlrc.top)
      newRC.top = newRC.top + ctrlrc.bottom - newRC.bottom
       '--------------------
      CASE AnchorTop + AnchorVCenter
      '--------------------
      newRC.bottom = CINT(CDBL(ctrlrc.bottom ) * scalefactor)
      '--------------------
      CASE (AnchorTop + AnchorBottom + AnchorVCenter)
      '--------------------
      newRC.bottom = CINT(CDBL(ctrlrc.bottom) * scalefactor)
      newRC.top = CINT(CDBL(ctrlrc.top) * scalefactor)

   END SELECT
   'Move/resize the window using API
   CALL MoveWindow(hWnd, newRC.left, newRC.top, newRC.right, newRC.bottom, 0)
   FUNCTION = newRC
END FUNCTION

'IsSubForm 0 for normal form, 2 for tabbed control
SUB InitAnchor OPTIONAL(hWnd AS HWND, IsSubForm=0)
   DIM RAW pa AS LPANCHOR
   DIM tmphWnd AS HWND PTR
   DIM RAW i, cnt

   pa = malloc(SIZEOF(*pa))

   IF IsSubForm = 2 THEN
      tmphWnd = (HWND*)GetWindowLong(hWnd, GWL_USERDATA)
      pa->PrevRC = GetScaledRect(tmphWnd[0])
   ELSE
      pa->PrevRC = GetScaledRect(hWnd)
   END IF

   pa->XMin = pa->PrevRC.right 
   pa->YMin = pa->PrevRC.bottom
   pa->IsSubForm = IsSubForm

   IF IsSubForm = 2 THEN
      cnt = TabCtrl_GetItemCount(hWnd) -1
      FOR i = 0 TO cnt
         SetProp(tmphWnd[i],"Anchor",(HANDLE)pa)
      NEXT i
   END IF
   SetProp(hWnd,"Anchor",(HANDLE)pa)
END SUB


SUB UpdateAnchor (hWnd AS HWND)
   DIM RAW pa AS LPANCHOR
   DIM tmphWnd AS HWND PTR

   pa = (LPANCHOR)GetProp(hWnd,(LPCSTR)"Anchor")
   IF pa THEN
      IF pa->IsSubForm = 2 THEN
         tmphWnd = (HWND*)GetWindowLong(hWnd, GWL_USERDATA)
         pa->PrevRC = GetScaledRect(tmphWnd[0])
      ELSE
         pa->PrevRC = GetScaledRect(hWnd)
      END IF

      IF pa->PrevRC.right < pa->XMin THEN pa->PrevRC.right = pa->XMin
      IF pa->PrevRC.bottom < pa->YMin THEN pa->PrevRC.bottom = pa->YMin
   END IF
END SUB

'This function will call the GetWindowRect
' and then convert right/bottom to width/height respectively
FUNCTION GetScaledRect(hWnd AS HWND) AS RECT
   DIM tmp3RC AS RECT
   GetWindowRect (hWnd, &tmp3RC)
   tmp3RC.right = (tmp3RC.right - tmp3RC.left)
   tmp3RC.bottom = (tmp3RC.bottom - tmp3RC.top)
   FUNCTION = tmp3RC
END FUNCTION

