
'Created with BMFD by Mike Henning

'This is a Modal dialog form, CALL it from your main form, it will NOT run by itself
'TO make this a modeless dialog change BCX_MDialog TO BCX_Dialog and,
'BEGIN MODAL DIALOG TO BEGIN DIALOG

'Also be sure there are no naming conflicts with existing controls and control ID numbers

'See BCX Help file on BCX_MDialog & BCX_Dialog functions


CONST commSet_Stc1_Style    = WS_TABSTOP|WS_VISIBLE|WS_CHILD|SS_NOTIFY
CONST commSet_Stc1_ExtStyle = 0
CONST commSet_Stc2_Style    = WS_TABSTOP|WS_VISIBLE|WS_CHILD|SS_NOTIFY
CONST commSet_Stc2_ExtStyle = 0
CONST commSet_Stc3_Style    = WS_TABSTOP|WS_VISIBLE|WS_CHILD|SS_NOTIFY
CONST commSet_Stc3_ExtStyle = 0
CONST commSet_Stc4_Style    = WS_TABSTOP|WS_VISIBLE|WS_CHILD|SS_NOTIFY
CONST commSet_Stc4_ExtStyle = 0
CONST commSet_Stc5_Style    = WS_TABSTOP|WS_VISIBLE|WS_CHILD|SS_NOTIFY
CONST commSet_Stc5_ExtStyle = 0
CONST commSet_Stc6_Style    = WS_TABSTOP|WS_VISIBLE|WS_CHILD|SS_NOTIFY
CONST commSet_Stc6_ExtStyle = 0

CONST commSet_Cmb1_Style    = WS_TABSTOP|WS_VISIBLE|WS_CHILD|CBS_HASSTRINGS|WS_VSCROLL|CBS_DROPDOWN
CONST commSet_Cmb1_ExtStyle = 0
CONST commSet_Btn1_Style    = WS_TABSTOP|WS_VISIBLE|WS_CHILD
CONST commSet_Btn1_ExtStyle = WS_EX_STATICEDGE
CONST commSet_Btn2_Style    = WS_TABSTOP|WS_VISIBLE|WS_CHILD
CONST commSet_Btn2_ExtStyle = WS_EX_STATICEDGE

ENUM
   ID_commSet_Stc1
   ID_commSet_Stc2
   ID_commSet_Stc3
   ID_commSet_Stc4
   ID_commSet_Stc5
   ID_commSet_Stc6
   ID_commSet_Cmb1
   ID_commSet_Cmb2
   ID_commSet_Cmb3
   ID_commSet_Cmb4
   ID_commSet_Cmb5
   ID_commSet_Cmb6
   ID_commSet_Btn1
   ID_commSet_Btn2
END ENUM

GLOBAL FormCOMMSET AS HWND

GLOBAL hcommSet_Stc1 AS CONTROL
GLOBAL hcommSet_Stc2 AS CONTROL
GLOBAL hcommSet_Stc3 AS CONTROL
GLOBAL hcommSet_Stc4 AS CONTROL
GLOBAL hcommSet_Stc5 AS CONTROL
GLOBAL hcommSet_Stc6 AS CONTROL
GLOBAL hcommSet_Cmb1 AS CONTROL
GLOBAL hcommSet_Cmb2 AS CONTROL
GLOBAL hcommSet_Cmb3 AS CONTROL
GLOBAL hcommSet_Cmb4 AS CONTROL
GLOBAL hcommSet_Cmb5 AS CONTROL
GLOBAL hcommSet_Cmb6 AS CONTROL
GLOBAL hcommSet_Btn1 AS CONTROL
GLOBAL hcommSet_Btn2 AS CONTROL


Type BCX_COMM_PORT
     Baud AS Integer
     Port AS Integer
     Parity AS Integer
     StopBits AS Integer
     DataBits AS Integer
     XonXoff as Integer
     Open AS BOOL
     rcvbuf$  ' AS STRING * 4096
     sendbuff ' AS STRING * 4096
End Type

GLOBAL CommSet AS BCX_COMM_PORT

FUNCTION CommSettings(hParent AS HWND, BYREF port, BYREF baudrate, BYREF parity, BYREF databits, BYREF stopbits, BYREF hs) AS INTEGER EXPORT

     CommSet.Baud            = baudrate
     CommSet.Port            = port
     CommSet.Parity          = parity
     CommSet.StopBits        = stopbits
     CommSet.DataBits        = databits
     CommSet.XonXoff         = hs

    CALL FormCOMMSET_Create(hParent)

     baudrate        = CommSet.Baud
     port            = CommSet.Port
     parity          = CommSet.Parity
     stopbits        = CommSet.StopBits
     databits        = CommSet.DataBits
     hs              = CommSet.XonXoff

    FUNCTION = GetLastError()
END FUNCTION

FUNCTION FormCOMMSET_Create( hParent AS HWND) AS INTEGER
	BCX_MDialog(Ev_FormCOMMSET,"Configure Serial Port", hParent,  68,  54,  114,  132)
	FUNCTION = 0
END FUNCTION


BEGIN MODAL DIALOG AS Ev_FormCOMMSET
 DIM hFont AS HFONT
 SELECT CASE CBMSG
 CASE WM_INITDIALOG
   FormCOMMSET = hWnd
   hcommSet_Stc1 = BCX_LABEL("Ports",FormCOMMSET,ID_commSet_Stc1, 4, 4, 24, 8, commSet_Stc1_Style, commSet_Stc1_ExtStyle)
   hcommSet_Stc2 = BCX_LABEL("Baud Rate",FormCOMMSET,ID_commSet_Stc2, 4, 20, 36, 8, commSet_Stc2_Style, commSet_Stc2_ExtStyle)
   hcommSet_Stc3 = BCX_LABEL("Parity",FormCOMMSET,ID_commSet_Stc3, 4, 36, 36, 8, commSet_Stc3_Style, commSet_Stc3_ExtStyle)
   hcommSet_Stc4 = BCX_LABEL("Data Bits",FormCOMMSET,ID_commSet_Stc4, 4, 52, 36, 8, commSet_Stc4_Style, commSet_Stc4_ExtStyle)
   hcommSet_Stc5 = BCX_LABEL("Stop Bits",FormCOMMSET,ID_commSet_Stc5, 4, 68, 36, 8, commSet_Stc5_Style, commSet_Stc5_ExtStyle)
   hcommSet_Stc6 = BCX_LABEL("Flow Control",FormCOMMSET,ID_commSet_Stc6, 4, 84, 36, 8, commSet_Stc6_Style, commSet_Stc6_ExtStyle)
   hcommSet_Cmb1 = BCX_COMBOBOX("",FormCOMMSET,ID_commSet_Cmb1, 44, 4, 60, 80, commSet_Cmb1_Style, commSet_Cmb1_ExtStyle)
   hcommSet_Cmb2 = BCX_COMBOBOX("",FormCOMMSET,ID_commSet_Cmb2, 44, 20, 60, 80, commSet_Cmb1_Style, commSet_Cmb1_ExtStyle)
   hcommSet_Cmb3 = BCX_COMBOBOX("",FormCOMMSET,ID_commSet_Cmb3, 44, 36, 60, 80, commSet_Cmb1_Style, commSet_Cmb1_ExtStyle)
   hcommSet_Cmb4 = BCX_COMBOBOX("",FormCOMMSET,ID_commSet_Cmb4, 44, 52, 60, 80, commSet_Cmb1_Style, commSet_Cmb1_ExtStyle)
   hcommSet_Cmb5 = BCX_COMBOBOX("",FormCOMMSET,ID_commSet_Cmb5, 44, 68, 60, 80, commSet_Cmb1_Style, commSet_Cmb1_ExtStyle)
   hcommSet_Cmb6 = BCX_COMBOBOX("",FormCOMMSET,ID_commSet_Cmb6, 44, 84, 60, 80, commSet_Cmb1_Style, commSet_Cmb1_ExtStyle)
   hcommSet_Btn1 = BCX_BUTTON("Save/Exit",FormCOMMSET,ID_commSet_Btn1, 4, 100, 48, 16, commSet_Btn1_Style, commSet_Btn1_ExtStyle)
   hcommSet_Btn2 = BCX_BUTTON("Cancel",FormCOMMSET,ID_commSet_Btn2, 56, 100, 48, 16, commSet_Btn2_Style, commSet_Btn2_ExtStyle)
   LoadcboPorts(hcommSet_Cmb1)
   LoadcboBauds(hcommSet_Cmb2)
   LoadcboParity(hcommSet_Cmb3)
   LoadcboDataBits(hcommSet_Cmb4)
   LoadcboStopBits(hcommSet_Cmb5)
   LoadcboFlow(hcommSet_Cmb6)
   Show(FormCOMMSET)
 CASE WM_COMMAND
      SELECT CASE CBCTL
          CASE ID_commSet_Cmb1
          CASE ID_commSet_Cmb2
          CASE ID_commSet_Cmb3
          CASE ID_commSet_Cmb4
          CASE ID_commSet_Cmb5
          CASE ID_commSet_Cmb6
          CASE ID_commSet_Btn1
               CALL GetcbosValues()
               CLOSEDIALOG
          CASE ID_commSet_Btn2
               CLOSEDIALOG
      END SELECT
 END SELECT
END DIALOG

'workaround from Ljubisa's msg dated 2-20-2007
'Add a dummy form function to force BCX to emit some declarations
Sub frmDummy()
Dim a as HWND
a = BCX_FORM("My Form", 0, 0, 100, 100, WS_CAPTION | WS_SYSMENU)
End Sub


!static HFONT   BcxFont;


Sub ComboBoxAdd ( hWnd As HANDLE, A$ )
  SendMessage (hWnd,CB_ADDSTRING,0,A$)
End Sub

FUNCTION CbSelectString(hComboBox AS HWND, Index, Text$)
FUNCTION = SendMessage(hComboBox, CB_SELECTSTRING, Index, Text$)
END FUNCTION

FUNCTION CbSetCurSel(hComboBox AS HWND, Index )
FUNCTION = SendMessage(hComboBox, CB_SETCURSEL, Index, 0)
END FUNCTION

FUNCTION CbGetLbText$ (hComboBox AS HWND, Index)
   LOCAL zText$
   IF Index < 0 THEN
   Index = CbGetCurSel(hComboBox)
   END IF
   SendMessage (hComboBox, CB_GETLBTEXT, Index, zText$)
   FUNCTION = zText$
END FUNCTION

FUNCTION CbGetCurSel(hComboBox AS HWND)
   FUNCTION = SendMessage(hComboBox, CB_GETCURSEL, 0, 0)
END FUNCTION

SUB GetcbosValues()
    CommSet.Port = VAL(CbGetLbText$(hcommSet_Cmb1,-1))
    CommSet.Baud = VAL(CbGetLbText$(hcommSet_Cmb2,-1))
    CommSet.Parity = CbGetCurSel(hcommSet_Cmb3)
    CommSet.DataBits = VAL(CbGetLbText$(hcommSet_Cmb4,-1))
    CommSet.StopBits = VAL(CbGetLbText$(hcommSet_Cmb5,-1))
    CommSet.XonXoff = CbGetCurSel(hcommSet_Cmb6)
END SUB

SUB LoadcboPorts(hWnd AS HWND)
    ComboBoxAdd  (hWnd, "None")
    For INTEGER i = 1 to 32
       ComboBoxAdd  (hWnd, STR$(i))
    NEXT i
    CbSelectString (hWnd, 0, STR$(CommSet.Port))
END SUB

SUB LoadcboBauds(hWnd AS HWND)
    ComboBoxAdd  (hWnd,  " 300 ")
    ComboBoxAdd  (hWnd,  " 600 ")
    ComboBoxAdd  (hWnd,  " 1200 ")
    ComboBoxAdd  (hWnd,  " 2400 ")
    ComboBoxAdd  (hWnd,  " 9600 ")
    ComboBoxAdd  (hWnd,  " 14400 ")
    ComboBoxAdd  (hWnd,  " 19200 ")
    ComboBoxAdd  (hWnd,  " 28800 ")
    ComboBoxAdd  (hWnd,  " 38400 ")
    ComboBoxAdd  (hWnd,  " 57600 ")
    ComboBoxAdd  (hWnd,  " 115200 ")
    ComboBoxAdd  (hWnd,  " 230400 ")
    ComboBoxAdd  (hWnd,  " 460800 ")
    ComboBoxAdd  (hWnd,  " 921600 ")
    CbSelectString (hWnd, 1, STR$(CommSet.Baud))

END SUB

SUB LoadcboParity(hWnd AS HWND)
    ComboBoxAdd  (hWnd,  " None ")
    ComboBoxAdd  (hWnd,  " Odd ")
    ComboBoxAdd  (hWnd,  " Even ")
    ComboBoxAdd  (hWnd,  " Mark ")
    ComboBoxAdd  (hWnd,  " Space ")
    CbSetCurSel(hWnd, CommSet.Parity)
END SUB

SUB LoadcboDataBits(hWnd AS HWND)
    ComboBoxAdd  (hWnd,  " 5 ")
    ComboBoxAdd  (hWnd,  " 6 ")
    ComboBoxAdd  (hWnd,  " 7 ")
    ComboBoxAdd  (hWnd,  " 8 ")
    'CbSelectString (hWnd, 1, "8")
    CbSelectString (hWnd, 1, STR$(CommSet.DataBits))
END SUB

SUB LoadcboStopBits(hWnd AS HWND)
    ComboBoxAdd  (hWnd,  " 1 ")
    ComboBoxAdd  (hWnd,  " 1.5 ")
    ComboBoxAdd  (hWnd,  " 2 ")
    CbSelectString (hWnd, 1, STR$(CommSet.StopBits))
END SUB

SUB LoadcboFlow(hWnd AS HWND)
    ComboBoxAdd  (hWnd,  " None ")
    ComboBoxAdd  (hWnd,  " Hardware ")
    ComboBoxAdd  (hWnd,  " Xon / Xoff ")
    CbSetCurSel(hWnd, CommSet.XonXoff)
END SUB

