'KetilO (C) 2003
'ketil.olsen@jm-data.no

'---------------------------------------
' Custom Grid Control
' Ported to BCX by Mike Henning 12/2008 - 2009
' Version 1.54
'---------------------------------------

$INCLUDE "raConstData.inc"
$INCLUDE "raDataManagement.inc"
$INCLUDE "raSort.inc"
$INCLUDE "HotKeySupport.inc"

CONST MAXBUFFSIZE = 4096

FUNCTION raShowHide(hLst AS HWND,fShow AS DWORD) AS HWND

   DIM RAW curcol, currow, cursel

   IF fShow THEN
      curcol = SendMessage(hLst,GM_GETCURCOL,0,0)
      currow = SendMessage(hLst,GM_GETCURROW,0,0)
      FUNCTION = (HWND)SendMessage(hLst,GM_ENTEREDIT,curcol,currow)
   ELSE
      cursel = SendMessage(hLst,GM_GETCURSEL,0,0)
      FUNCTION = (HWND)SendMessage(hLst,GM_ENDEDIT,cursel,TRUE)
   END IF
END SUB


'dtadd  dq 24*60*60*1000*1000*1000*1000*100
CALLBACK FUNCTION DateTimeProc
   DIM RAW  hDC   AS HDC
   DIM RAW  rect  AS RECT
   DIM RAW  stime AS SYSTEMTIME
   DIM RAW  ft    AS ULARGE_INTEGER

   SELECT CASE CBMSG

      '********************
      CASE WM_NCPAINT
      '********************
      GetWindowRect(CBHWND,&rect)
      rect.right   -= rect.left
      rect.left     = 0
      rect.bottom  -= rect.top
      rect.top      = 0
      hDC = GetWindowDC(CBHWND)
      FrameRect(hDC,&rect, (HBRUSH)GetStockObject(BLACK_BRUSH))
      INCR rect.left
      INCR rect.top
      DECR rect.right
      DECR rect.bottom
      DIM RAW hbrush AS HBRUSH
      hbrush = CreateSolidBrush(GetSysColor(COLOR_WINDOW))
      FrameRect(hDC,&rect,hbrush)
      DeleteObject(hbrush)
      ReleaseDC(CBHWND,hDC)
      EXIT FUNCTION

      '********************
      CASE WM_KEYDOWN
      '********************
      IF CBWPARAM = VK_RETURN THEN
         ShowWindow(CBHWND,SW_HIDE)
         EXIT FUNCTION
      ELSEIF CBWPARAM = VK_ESCAPE THEN
         fCancelEdit = TRUE
         ShowWindow(CBHWND,SW_HIDE)
         fCancelEdit = FALSE
         EXIT FUNCTION
      END IF

      '********************
      CASE WM_CHAR
      '********************
      IF CBWPARAM = ASC("+") THEN
         SendMessage(CBHWND,DTM_GETSYSTEMTIME,0,&stime)
         SystemTimeToFileTime(&stime, (FILETIME*)&ft)
         ft.QuadPart += SYSTICK_2_DAYS
         FileTimeToSystemTime((FILETIME*)&ft, &stime)
         SendMessage(CBHWND,DTM_SETSYSTEMTIME,0,&stime)
         EXIT FUNCTION
      ELSEIF CBWPARAM = ASC("-") THEN
         SendMessage(CBHWND,DTM_GETSYSTEMTIME,0,&stime)
         SystemTimeToFileTime(&stime, (FILETIME*)&ft)
         ft.QuadPart -= SYSTICK_2_DAYS
         FileTimeToSystemTime((FILETIME*)&ft, &stime)
         SendMessage(CBHWND,DTM_SETSYSTEMTIME,0,&stime)
         EXIT FUNCTION
      ELSEIF CBWPARAM = ASC("T") OR CBWPARAM = ASC("t") THEN
         GetSystemTime(&stime)
         SendMessage(CBHWND,DTM_SETSYSTEMTIME,0,&stime)
         EXIT FUNCTION
      END IF

      '********************
      CASE WM_SHOWWINDOW
      '********************
      IF (NOT CBWPARAM) AND (NOT fCancelEdit) THEN
         fCancelEdit = TRUE
         CALL raUpdate(CBHWND)
         fCancelEdit = FALSE
      END IF

      '********************
      CASE WM_GETDLGCODE
      '********************
      FUNCTION = DLGC_CODE
   END SELECT

   DIM RAW oldhWnd AS WNDPROC
   oldhWnd = (WNDPROC)GetWindowLong(CBHWND,GWL_USERDATA)
   FUNCTION = CallWindowProc(oldhWnd,CBHWND,CBMSG,CBWPARAM,CBLPARAM)
END FUNCTION
' DateTimeProc endp

CALLBACK FUNCTION LstProc
   DIM RAW pt AS POINT

   SELECT CASE CBMSG

      '********************
      CASE WM_KEYDOWN 'WM_CHAR
      '********************
      IF CBWPARAM = VK_RETURN THEN
         fCancelEdit = FALSE
         ShowWindow(CBHWND,SW_HIDE)
         EXIT FUNCTION
      ELSEIF CBWPARAM = VK_ESCAPE THEN
         fCancelEdit = TRUE
         ShowWindow(CBHWND,SW_HIDE)
         fCancelEdit = FALSE
         EXIT FUNCTION
      END IF

      '********************
      CASE WM_LBUTTONDOWN
      '********************
      fCancelEdit = FALSE
      ShowWindow(CBHWND,SW_HIDE)
      EXIT FUNCTION

      '********************
      CASE WM_MOUSEMOVE
      '********************
      DIM RAW cursel, sel
      cursel = SendMessage(CBHWND,LB_GETCURSEL,0,0)
      GetCursorPos(&pt)
      sel = LBItemFromPt(CBHWND,pt,TRUE)
      IF sel <> cursel THEN
         SendMessage(CBHWND,LB_SETCURSEL,sel,0)
      END IF
      EXIT FUNCTION

      '********************
      CASE WM_ACTIVATE
      '********************
      STATIC hfocus AS HWND
      IF LOWORD(CBWPARAM) <> WA_INACTIVE THEN
         hfocus = (HWND)CBLPARAM
         SendMessage(hfocus,WM_NCACTIVATE,TRUE,0)
      ELSEIF CBLPARAM <> (dword)hfocus THEN
         SendMessage(hfocus,WM_NCACTIVATE,FALSE,0)
      END IF

      '********************
      CASE WM_SHOWWINDOW
      '********************
      IF (NOT CBWPARAM) AND (NOT fCancelEdit) THEN
         fCancelEdit = TRUE
         DIM RAW ghWnd AS HWND, pGrid AS LPGRID, plp AS LPVOID
         DIM RAW tmprowcol
         ghWnd = (HWND)GetWindowLong(CBHWND, GWL_USERDATA)
         plp   = (LPVOID)GetWindowLong(ghWnd, 0)
         pGrid = (LPGRID) GlobalLock(plp)
         tmprowcol = (*pGrid).edtrowcol
         ncol  = (*pGrid).col
         nrow  = (*pGrid).row
         GlobalUnlock(plp)
         SendMessage(ghWnd,GM_ENDEDIT,tmprowcol,FALSE)
         fCancelEdit = FALSE
      END IF

      '********************
      CASE WM_KILLFOCUS
      '********************
      ShowWindow(CBHWND,SW_HIDE)

      '********************
      CASE WM_SETFOCUS
      '********************
      fCancelEdit = TRUE

      '********************
      CASE WM_GETDLGCODE
      '********************
      FUNCTION = DLGC_CODE
   END SELECT

   FUNCTION = CallWindowProc(lplstproc,CBHWND,CBMSG,CBWPARAM,CBLPARAM)
END FUNCTION
' LstProc endp

CALLBACK FUNCTION HotProc
   DIM RAW  hDC AS HDC
   DIM RAW  rect AS RECT

   SELECT CASE CBMSG

      '********************
      CASE WM_NCPAINT
      '********************
      GetWindowRect(CBHWND,&rect)
      rect.right -= rect.left
      rect.left = 0
      rect.bottom -= rect.top
      rect.top = 0
      hDC = GetWindowDC(CBHWND)
      FrameRect(hDC,&rect, (HBRUSH)GetStockObject(BLACK_BRUSH))
      INCR rect.left
      INCR rect.top
      DECR rect.right
      DECR rect.bottom

      DIM RAW hbrush AS HBRUSH
      hbrush = CreateSolidBrush(GetSysColor(COLOR_WINDOW))
      FrameRect(hDC,&rect,hbrush)
      DeleteObject(hbrush)
      ReleaseDC(CBHWND,hDC)
      EXIT FUNCTION

      '********************
      CASE WM_KEYDOWN
      '********************
      IF CBWPARAM = VK_RETURN THEN
         ShowWindow(CBHWND,SW_HIDE)
         EXIT FUNCTION
      ELSEIF CBWPARAM = VK_ESCAPE THEN
         fCancelEdit = TRUE
         ShowWindow(CBHWND,SW_HIDE)
         fCancelEdit = FALSE
         EXIT FUNCTION
      END IF

      '********************
      CASE WM_SHOWWINDOW
      '********************
      IF (NOT CBWPARAM) AND (NOT fCancelEdit) THEN
         fCancelEdit = TRUE
         CALL raUpdate(CBHWND)
         fCancelEdit = FALSE
      END IF

      '********************
      CASE WM_GETDLGCODE
      '********************
      FUNCTION = DLGC_CODE
   END SELECT

   DIM RAW oldhWnd AS WNDPROC
   oldhWnd = (WNDPROC)GetWindowLong(CBHWND,GWL_USERDATA)

   FUNCTION = CallWindowProc(oldhWnd,CBHWND,CBMSG,CBWPARAM,CBLPARAM)
END FUNCTION
' HotProc endp


CALLBACK FUNCTION EdtTextProc

   SELECT CASE CBMSG

      '********************
      CASE WM_CHAR
      '********************
      IF CBWPARAM = VK_RETURN AND ( NOT (GetWindowLong(CBHWND, GWL_STYLE) BAND ES_MULTILINE)) THEN
         ShowWindow(CBHWND,SW_HIDE)
         EXIT FUNCTION
      ELSEIF CBWPARAM = VK_ESCAPE THEN
         fCancelEdit = TRUE
         ShowWindow(CBHWND,SW_HIDE)
         fCancelEdit = FALSE
         EXIT FUNCTION
      END IF

      '********************
      CASE WM_SHOWWINDOW
      '********************
      IF (NOT CBWPARAM) AND (NOT fCancelEdit) THEN
         fCancelEdit = TRUE
         CALL raUpdate(CBHWND)
         fCancelEdit = FALSE
      END IF

      '********************
      CASE WM_GETDLGCODE
      '********************
      FUNCTION = DLGC_CODE
   END SELECT

   DIM RAW oldhWnd AS WNDPROC
   oldhWnd = (WNDPROC)GetWindowLong(CBHWND,GWL_USERDATA)

   FUNCTION = CallWindowProc(oldhWnd,CBHWND,CBMSG,CBWPARAM,CBLPARAM)
END FUNCTION
' 'EdtTextProc endp


SUB raUpdate(hWin AS HWND)
   DIM RAW id, hWnd AS HWND
   id   = GetWindowLong(hWin,GWL_ID)
   hWnd = GetParent(GetParent(hWin))
   SendMessage(hWnd,GM_ENDEDIT,id,FALSE)
END SUB

SUB raSetScroll(hWin AS HWND, pGrid AS LPGRID, BYREF sinf AS SCROLLINFO)
   DIM RAW rect AS RECT
   DIM RAW tmp

   GetClientRect(hWin,&rect)
   IF rect.right AND rect.bottom THEN
      tmp = rect.bottom - (*pGrid).hdrht
      IF tmp < 0 THEN tmp = 0

      sinf.cbSize = SIZEOF (sinf)
      sinf.fMask = SIF_ALL
      tmp = tmp / (*pGrid).rowht
      tmp = tmp * (*pGrid).rowht
      sinf.nPage = tmp
      sinf.nMin = 0

      tmp = (*pGrid).rows
      IF tmp THEN
         DECR   tmp
      END IF
      tmp = (tmp + 1) * (*pGrid).rowht
      sinf.nMax = tmp - 1
      sinf.nPos = (*pGrid).toprow * (*pGrid).rowht
      SetScrollInfo(hWin,SB_VERT,&sinf,TRUE)

      sinf.nPage = rect.right
      sinf.nMax = (*pGrid).ccx
      sinf.nPos = (*pGrid).sbx
      SetScrollInfo(hWin,SB_HORZ,&sinf,TRUE)
   END IF
END SUB


FUNCTION ExpandItemMem(hWin AS HWND, pGrid AS LPGRID) AS LPGRID
   DIM RAW itemsize, tmp, hLst AS HWND, isize

   itemsize = ((*pGrid).rows + 1) * 4
   itemsize += (*pGrid).rpitemdata

   IF itemsize > (*pGrid).itemmemsize THEN
      hLst  = (*pGrid).hlst
      isize = (*pGrid).itemmemsize
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(hWin,0))
      tmp = (INT)GlobalReAlloc( _
      (LPVOID)GetWindowLong(hWin,0),isize + MEM_SIZE,GMEM_MOVEABLE)

      IF tmp THEN
         SetWindowLong(hLst,0,tmp)
         SetWindowLong(hWin,0,tmp)
         'CALL GetMem
         pGrid = (LPGRID)GlobalLock((LPVOID)tmp)
         (*pGrid).itemmemsize += MEM_SIZE
      END IF
   END IF
   FUNCTION = pGrid
END FUNCTION


CALLBACK FUNCTION EdtLongProc

   SELECT CASE CBMSG

      '********************
      CASE WM_CHAR
      '********************
      IF CBWPARAM = VK_RETURN THEN
         ShowWindow(CBHWND,SW_HIDE)
         EXIT FUNCTION
      ELSEIF CBWPARAM = VK_ESCAPE THEN
         fCancelEdit = TRUE
         ShowWindow(CBHWND,SW_HIDE)
         fCancelEdit = FALSE
         EXIT FUNCTION
      ELSEIF (CBWPARAM < ASC("0") OR CBWPARAM > ASC("9")) AND (CBWPARAM <> ASC("-")) AND (CBWPARAM <> 8) THEN
         MessageBeep(MB_OK)
         EXIT FUNCTION
      END IF

      '********************
      CASE WM_SHOWWINDOW
      '********************
      IF (NOT CBWPARAM) AND (NOT fCancelEdit) THEN
         fCancelEdit = TRUE
         CALL raUpdate(CBHWND)
         fCancelEdit = FALSE
      END IF

      '********************
      CASE WM_GETDLGCODE
      '********************
      FUNCTION = DLGC_CODE
   END SELECT

   DIM RAW oldhWnd AS WNDPROC
   oldhWnd = (WNDPROC)GetWindowLong(CBHWND,GWL_USERDATA)

   FUNCTION = CallWindowProc(oldhWnd ,CBHWND,CBMSG,CBWPARAM,CBLPARAM)
END FUNCTION


CALLBACK FUNCTION EdtDoubleProc

   SELECT CASE CBMSG

      '********************
      CASE WM_CHAR
      '********************
      IF CBWPARAM = VK_RETURN THEN
         ShowWindow(CBHWND,SW_HIDE)
         EXIT FUNCTION
      ELSEIF CBWPARAM = VK_ESCAPE THEN
         fCancelEdit = TRUE
         ShowWindow(CBHWND,SW_HIDE)
         fCancelEdit = FALSE
         EXIT FUNCTION
      ELSEIF (CBWPARAM < ASC("0") OR CBWPARAM > ASC("9")) AND (CBWPARAM <> ASC(".")) AND (CBWPARAM <> ASC("-")) AND (CBWPARAM <> 8) THEN
         MessageBeep(MB_OK)
         EXIT FUNCTION
      END IF

      '********************
      CASE WM_SHOWWINDOW
      '********************
      IF (NOT CBWPARAM) AND (NOT fCancelEdit) THEN
         fCancelEdit = TRUE
         CALL raUpdate(CBHWND)
         fCancelEdit = FALSE
      END IF

      '********************
      CASE WM_GETDLGCODE
      '********************
      FUNCTION = DLGC_CODE
   END SELECT

   DIM RAW oldhWnd AS WNDPROC
   oldhWnd = (WNDPROC)GetWindowLong(CBHWND,GWL_USERDATA)

   FUNCTION = CallWindowProc(oldhWnd ,CBHWND,CBMSG,CBWPARAM,CBLPARAM)
END FUNCTION

'--------------------------------------------------------------------------------

CALLBACK FUNCTION GridHdrProc

   DIM RAW  rect AS RECT
   DIM RAW  gn   AS GRIDNOTIFY
   DIM RAW  pCol AS LPCOLUMN
   DIM RAW  pGrid AS LPGRID
   DIM RAW  colcnt
   DIM RAW  tmp

   STATIC  nSizeMin
   STATIC  nSizeOfs
   STATIC  nSizeCol
   STATIC  fSize


   SELECT CASE CBMSG

      '*********************
      CASE WM_RBUTTONUP
      '*********************
      DIM RAW pt AS POINT
      DIM RAW ColClicked
      DIM RAW ItemSelected

      pGrid = (LPGRID) GlobalLock((LPVOID)GetWindowLong(GetParent(CBHWND),0))

      ColClicked = LOWORD(CBLPARAM)
      tmp        = HIWORD(CBLPARAM)
      IF raRowColumnClicked(pGrid, &ColClicked, &tmp) <> -1 THEN

         pCol = (LPCOLUMN)((LPBYTE)pGrid + (ColClicked * SIZEOF(COLUMN)) + SIZEOF(GRID))

         IF (*pCol).hdrmenu THEN
            GetCursorPos(&pt)       ' get mouse screen coordinates
            ItemSelected = TrackPopupMenuEx((*pCol).hdrmenu, _
            TPM_LEFTALIGN OR TPM_RIGHTBUTTON OR TPM_RETURNCMD, pt.x, pt.y, CBHWND, NULL)

            IF ItemSelected AND (ColClicked >= 0) THEN
               gn.nmhdr.hwndFrom = (*pGrid).hgrd
               gn.nmhdr.idFrom   = (*pGrid).nid
               gn.nmhdr.code     = GN_HEADERMENU
               gn.col            = ColClicked
               gn.row            = -1
               gn.hwnd           = CBHWND
               gn.lpdata         = &ItemSelected
               gn.fcancel        = 0
               SendMessage((*pGrid).hpar,WM_NOTIFY,(*pGrid).nid,&gn)
            END IF
         END IF
      END IF
      GlobalUnlock((LPVOID)GetWindowLong(GetParent(CBHWND),0))
      EXIT FUNCTION

      '********************
      CASE WM_MOUSEMOVE
      '********************
      pGrid = (LPGRID) GlobalLock((LPVOID)GetWindowLong(GetParent(CBHWND),0))
      'CALL GetMem
      IF NOT ((*pGrid).style BAND STYLE_NOCOLSIZE) THEN
         IF fSize < 2 THEN
            IF NOT (CBWPARAM BAND (MK_LBUTTON BOR MK_RBUTTON)) THEN
               fSize = 0
               colcnt = (*pGrid).cols
               WHILE colcnt
                  DECR colcnt
                  pCol = (LPCOLUMN)((LPBYTE)pGrid + (colcnt * SIZEOF(COLUMN)) + SIZEOF(GRID))
                  IF (*pCol).colwt THEN
                     nSizeMin  = (*pCol).colxp
                     rect.left = nSizeMin + (*pCol).colwt
                     nSizeOfs  = LOWORD(CBLPARAM) - rect.left
                     IF ((LOWORD(CBLPARAM)-2) <= rect.left) AND ((LOWORD(CBLPARAM)+4) >= rect.left) THEN
                        nSizeCol = colcnt
                        SetCursor((*pGrid).hcur)
                        fSize = 1
                        EXIT WHILE
                     END IF
                  END IF
               WEND
            END IF
         ELSE
            GetClientRect(GetParent(CBHWND),&rect)
            DIM RAW xpos = LOWORD(CBLPARAM) - nSizeOfs
            IF xpos < nSizeMin THEN
               xpos = nSizeMin
            END IF
            xpos -= (*pGrid).sbx
            MoveWindow((*pGrid).hsize,xpos,0,2,rect.bottom,TRUE)
            ShowWindow((*pGrid).hsize,SW_SHOW)
         END IF
      END IF
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(GetParent(CBHWND),0))
      EXIT FUNCTION

      '********************
      CASE WM_LBUTTONDOWN
      '********************
      pGrid = (LPGRID) GlobalLock((LPVOID)GetWindowLong(GetParent(CBHWND),0))
      'CALL GetMem
      IF NOT ((*pGrid).style BAND STYLE_NOCOLSIZE) THEN
         IF fSize = 1 THEN
            raShowHide((*pGrid).hgrd,FALSE)
            fSize = 2
            SetCursor((*pGrid).hcur)
            SendMessage(CBHWND,WM_MOUSEMOVE,CBWPARAM,CBLPARAM)
         ELSE
            pCol = (LPCOLUMN)((LPBYTE) pGrid + SIZEOF(GRID))
            colcnt = 0
            WHILE colcnt < (*pGrid).cols
               IF LOWORD(CBLPARAM) < ((*pCol).colxp + (*pCol).colwt) THEN
                  (*pCol).hdrflag = (*pCol).hdrflag BOR HEADERCLICKED
                  InvalidateRect((*pGrid).hhdr,NULL,TRUE)
                  UpdateWindow((*pGrid).hhdr)
                  EXIT WHILE
               END IF
               INCR colcnt
               pCol = (LPCOLUMN)((LPBYTE)pCol + SIZEOF(COLUMN))
            WEND
         END IF
         SetCapture(CBHWND)
      END IF
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(GetParent(CBHWND),0))
      EXIT FUNCTION

      '********************
      CASE WM_LBUTTONUP
      '********************
      pGrid = (LPGRID) GlobalLock((LPVOID)GetWindowLong(GetParent(CBHWND),0))
      'CALL GetMem
      IF NOT ((*pGrid).style BAND STYLE_NOCOLSIZE) THEN
         IF fSize THEN
            fSize = 0
            pCol = (LPCOLUMN)((LPBYTE) pGrid + SIZEOF(GRID) + (nSizeCol * SIZEOF(COLUMN)))
            tmp = LOWORD(CBLPARAM) - nSizeOfs
            IF tmp <= nSizeMin THEN
               tmp = nSizeMin + 1
            END IF
            tmp -= nSizeMin
            (*pCol).colwt = tmp
            tmp = (*pCol).colxp
            colcnt = nSizeCol
            WHILE colcnt < (*pGrid).cols
               (*pCol).colxp = tmp
               tmp += (*pCol).colwt
               (*pGrid).ccx = tmp
               pCol = (LPCOLUMN)((LPBYTE)pCol + SIZEOF(COLUMN))
               INCR colcnt
            WEND
            ShowWindow((*pGrid).hsize,SW_HIDE)
            SendMessage((*pGrid).hgrd,WM_SIZE,0,0)
            InvalidateRect((*pGrid).hhdr,NULL,TRUE)
            UpdateWindow((*pGrid).hhdr)
            InvalidateRect((*pGrid).hlst,NULL,TRUE)
            UpdateWindow((*pGrid).hlst)
         ELSE
            pCol = (LPCOLUMN)((LPBYTE)pGrid + SIZEOF(GRID))
            colcnt = 0
            WHILE colcnt < (*pGrid).cols
               IF (*pCol).hdrflag BAND HEADERCLICKED THEN
                  (*pCol).hdrflag = (*pCol).hdrflag BAND (~HEADERCLICKED)
                  gn.nmhdr.hwndFrom = (*pGrid).hgrd
                  gn.nmhdr.idFrom   = (*pGrid).nid
                  gn.nmhdr.code     = GN_HEADERCLICK
                  gn.col            = colcnt
                  gn.row            = -1
                  gn.hwnd           = CBHWND
                  gn.lpdata         = 0
                  gn.fcancel        = 0
                  InvalidateRect((*pGrid).hhdr,NULL,TRUE)
                  UpdateWindow((*pGrid).hhdr)
                  SendMessage((*pGrid).hpar,WM_NOTIFY,(*pGrid).nid,&gn)
                  EXIT WHILE
               END IF
               INCR colcnt
               pCol = (LPCOLUMN)((LPBYTE)pCol + SIZEOF(COLUMN))
            WEND
         END IF
         ReleaseCapture()
      END IF
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(GetParent(CBHWND),0))
      EXIT FUNCTION

      '********************
      CASE WM_LBUTTONDBLCLK
      '********************
      ReleaseCapture()
      EXIT FUNCTION

   END SELECT

   DIM RAW oldhWnd AS WNDPROC
   oldhWnd = (WNDPROC)GetWindowLong(CBHWND,GWL_USERDATA)

   FUNCTION = CallWindowProc(oldhWnd,CBHWND,CBMSG,CBWPARAM,CBLPARAM)
END FUNCTION


SUB raGetItemRect(pGrid AS GRID PTR,nRow AS DWORD,lpRect AS RECT PTR)

   IF nRow < (*pGrid).rows THEN
      GetClientRect((*pGrid).hlst,lpRect)
      (*lpRect).left += (*pGrid).sbx
      (*lpRect).right += (*pGrid).sbx
      nRow -= (*pGrid).toprow
      (*lpRect).top = nRow * (*pGrid).rowht
      (*lpRect).bottom = (*lpRect).top + (*pGrid).rowht
   ELSE
      SetRectEmpty(lpRect)
   END IF

END SUB


'-------------------------------------------------------------------
' Client mouse position is passed in xpos and ypos
' Row and Column are returned in ypos and xpos
' Function returns: IsButtonZone = LOWORD
'                   Column type  = HIWORD
'                   -1 if it's an invalid position
'-------------------------------------------------------------------
FUNCTION raRowColumnClicked(pGrid AS LPGRID, BYREF xpos, BYREF ypos)

   DIM RAW pCol AS LPCOLUMN, row, col
   DIM RAW InButtonZone = FALSE
   DIM RAW ctype = 0

   col = (*pGrid).cols
   WHILE col
      DECR col
      pCol = (LPCOLUMN)((LPBYTE)pGrid + (col * SIZEOF(COLUMN)) + SIZEOF(GRID))

      IF (*pCol).colwt THEN
         IF (xpos > (*pCol).colxp) AND (xpos < (*pCol).colxp + (*pCol).colwt) THEN
            IF ((*pCol).colxp + (*pCol).colwt) < (xpos + (*pGrid).rowht) THEN
               InButtonZone = TRUE
            END IF
            ctype = (*pCol).ctype
            EXIT WHILE
         END IF
      END IF
   WEND

   IF col < (*pGrid).cols THEN
      row = (ypos / (*pGrid).rowht) + (*pGrid).toprow
      IF row < (*pGrid).rows THEN
         xpos = col
         ypos = row
         FUNCTION = MAKELONG(InButtonZone, ctype)
      END IF
   END IF

   FUNCTION = -1
END FUNCTION


'SUB SetItem(pGrid AS GRID PTR,nRow AS DWORD,dwItem AS DWORD)
'
'   DIM RAW pdata AS DWORD PTR
'
'   IF nRow < (*pGrid).rows THEN
'      pdata = (dword*)pGrid + (*pGrid).rpitemdata
'      *(pdata + nRow*4) = dwItem
'   END IF
'
'END SUB
' SetItem endp

FUNCTION raGetItem(pGrid AS GRID PTR,nRow AS DWORD)

   DIM RAW pdata AS DWORD PTR

   IF nRow < (*pGrid).rows THEN
      pdata = (dword*)((LPBYTE)pGrid + (*pGrid).rpitemdata)
      FUNCTION = *(dword*)((LPBYTE)pdata+nRow*4)
   END IF
   FUNCTION = LB_ERR

END FUNCTION


FUNCTION raInsertItem(pGrid AS GRID PTR,nRow AS DWORD,dwItem AS DWORD)
   DIM RAW rect AS RECT
   DIM RAW pdata AS DWORD PTR
   DIM RAW rowidx, tmp

   rowidx = (*pGrid).rows
   pdata = (dword*)((LPBYTE)pGrid + (*pGrid).rpitemdata)

   WHILE rowidx > nRow
      DECR rowidx
      *(dword*)((LPBYTE)pdata+rowidx*4+4) = *(dword*)((LPBYTE)pdata+rowidx*4)
   WEND
   *(dword*)((LPBYTE)pdata+rowidx*4) = dwItem
   INCR (*pGrid).rows
   GetClientRect((*pGrid).hlst,&rect)
   tmp = rect.bottom
   raGetItemRect(pGrid,nRow,&rect)
   rect.bottom = tmp
   InvalidateRect((*pGrid).hlst,&rect,TRUE)

   FUNCTION = nRow
END FUNCTION


FUNCTION raDeleteItem(pGrid AS GRID PTR,nRow AS DWORD)
   DIM RAW  rect AS RECT, tmp
   DIM RAW pdata AS DWORD PTR

   'mov ecx,nRow
   IF nRow < (*pGrid).rows THEN
      GetClientRect((*pGrid).hlst,&rect)
      'mov eax,nRow
      IF nRow <> (*pGrid).toprow THEN
         tmp =  rect.bottom
         raGetItemRect(pGrid,nRow,&rect)
         rect.bottom = tmp
      END IF
      pdata =  (dword*)((LPBYTE)pGrid + (*pGrid).rpitemdata)
      WHILE nRow < (*pGrid).rows
         *(dword*)((LPBYTE)pdata+nRow*4) =  *(dword*)((LPBYTE)pdata+nRow*4+4)
         INCR nRow
      WEND
      DECR (*pGrid).rows
      InvalidateRect((*pGrid).hlst,&rect,TRUE)
      FUNCTION = (*pGrid).rows
   ELSE
      FUNCTION = LB_ERR
   END IF

END FUNCTION


CALLBACK FUNCTION RAListProc

   DIM RAW ps   AS PAINTSTRUCT
   DIM RAW dis  AS DRAWITEMSTRUCT
   DIM RAW hPar AS HWND
   DIM RAW rect AS RECT
   DIM RAW buffer[MAXBUFFSIZE] AS CHAR
   DIM RAW ftmp AS DWORD

   DIM RAW pGrid AS LPGRID
   DIM RAW pCol  AS LPCOLUMN
   DIM RAW exitvalue
   DIM RAW flag
   DIM RAW tmp
   DIM RAW colcnt

   '   IF (CBMSG >= WM_MOUSEFIRST) AND (CBMSG <= WM_MOUSELAST) THEN
   '      CBMSG = PostMessage(GetParent(CBHWND),CBMSG,CBWPARAM,CBLPARAM)
   '   END IF
   SELECT CASE CBMSG

      '********************
      CASE WM_DRAWITEM
      '********************

      DIM RAW esi AS LPDRAWITEMSTRUCT
      esi = (LPDRAWITEMSTRUCT)CBLPARAM
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      'Draw Combobox items
      IF (*esi).itemID <> LB_ERR THEN
         SetBkMode((*esi).hDC,TRANSPARENT)
         tmp = GetWindowLong((*esi).hwndItem,GWL_ID)
         pCol = (LPCOLUMN)((LPBYTE) pGrid + SIZEOF(GRID) + (LOWORD(tmp) * SIZEOF(COLUMN)))

         IF NOT ((*esi).itemState BAND ODS_SELECTED) THEN
            SetTextColor((*esi).hDC,(*pGrid).coltext)
            FillRect((*esi).hDC,&(*esi).rcItem,(*pGrid).hbrback)
         ELSE
            SetTextColor((*esi).hDC, GetSysColor(COLOR_HIGHLIGHTTEXT))
            FillRect((*esi).hDC,&(*esi).rcItem, (HBRUSH)(COLOR_HIGHLIGHT+1))
            IF (*pCol).himl THEN
               CopyRect(&rect,&(*esi).rcItem)
               rect.right = 18
               FillRect((*esi).hDC,&rect,(*pGrid).hbrback)
            END IF
         END IF

         IF (*pCol).himl THEN
            CopyRect(&rect,&(*esi).rcItem)
            (*esi).rcItem.left += 18
            INCR rect.left
            rect.right = rect.left + 16
            DIM RAW rgn AS HRGN
            rgn = CreateRectRgn(rect.left,rect.top,rect.right,rect.bottom)
            SelectClipRgn((*esi).hDC, rgn)
            DeleteObject(rgn)
            ImageList_Draw((*pCol).himl,(*esi).itemData,(*esi).hDC,rect.left,rect.top,ILD_NORMAL)
            SelectClipRgn((*esi).hDC,NULL)
         END IF

         *buffer = 0
         SendMessage((*esi).hwndItem,LB_GETTEXT,(*esi).itemID, buffer)
         TextOut((*esi).hDC,(*esi).rcItem.left + 2,(*esi).rcItem.top + 1,buffer, LEN(buffer))
         SetTextColor((*esi).hDC,0)
      END IF

      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))

      '********************
      CASE WM_CTLCOLORLISTBOX
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))
      exitvalue = (integer)(*pGrid).hbrback
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      FUNCTION = exitvalue

      '********************
      CASE WM_PAINT
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      flag = ODS_SELECTED

      IF GetFocus() = CBHWND THEN
         flag = ODS_FOCUS BOR ODS_SELECTED
      END IF

      BeginPaint(CBHWND,&ps)
      GetClientRect((*pGrid).hgrd,&rect)

      rect.bottom -= (*pGrid).hdrht
      tmp = -((*pGrid).toprow - (*pGrid).rows)
      tmp = tmp * (*pGrid).rowht
      rect.right += (*pGrid).sbx

      IF (((*pGrid).ccx + 1) < rect.right) OR (tmp < rect.bottom) THEN
         IF ((*pGrid).ccx + 1) < rect.right THEN
            rect.left = ((*pGrid).ccx + 1)
            FillRect(ps.hdc,&rect,(*pGrid).hbrback)
            rect.right = rect.left
         END IF
         IF tmp < rect.bottom THEN
            rect.top = tmp
            rect.left = 0
            FillRect(ps.hdc,&rect,(*pGrid).hbrback)
         END IF
      END IF

      hPar = GetParent(CBHWND)
      DIM RAW rowcnt, row
      rowcnt = ps.rcPaint.top / (*pGrid).rowht
      row    = (rowcnt + (*pGrid).toprow)
      rowcnt = rowcnt * (*pGrid).rowht

      WHILE rowcnt < ps.rcPaint.bottom

         IF row < (*pGrid).rows THEN
            dis.rcItem.top    = rowcnt
            dis.rcItem.bottom = rowcnt + (*pGrid).rowht
            'mov    eax,ps.rcPaint.left
            dis.rcItem.left  = 0'eax
            dis.rcItem.right = ps.rcPaint.right
            dis.hDC          = ps.hdc
            dis.CtlType      = ODT_LISTBOX
            dis.CtlID        = 0
            dis.itemID       = row
            dis.itemData     = *(dword*)((LPBYTE)pGrid + SIZEOF(GRID) + _
            ((*pGrid).cols * SIZEOF(COLUMN)) + (row * 4))
            dis.hwndItem     = CBHWND
            dis.itemAction   = ODA_DRAWENTIRE
            dis.itemState    = 0

            IF row = (*pGrid).row THEN
               dis.itemState = flag
            END IF

            SendMessage(hPar,WM_DRAWITEM,0,&dis)
         END IF

         rowcnt += (*pGrid).rowht
         INCR row
      WEND
      EndPaint(CBHWND,&ps)
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      EXIT FUNCTION

      '********************
      CASE WM_ERASEBKGND
      '********************
      'EXIT FUNCTION
      FUNCTION = 1

      '********************
      CASE WM_KEYDOWN
      '********************
      tmp = HIWORD(CBLPARAM) BAND 0x3FF

      IF (CBWPARAM = 0x27) AND (tmp = 0x14D OR tmp = 0x4D) THEN
         'Right
         'CALL  GetMem
         pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))
         tmp = (*pGrid).col

         again1:
         INCR   tmp
         IF tmp < (*pGrid).cols THEN

            pCol = (LPCOLUMN)((LPBYTE)pGrid + (tmp * SIZEOF(COLUMN)) + SIZEOF(GRID))
            IF NOT (*pCol).colwt THEN GOTO again1

            SendMessage((*pGrid).hgrd,GM_SETCURSEL,tmp,(*pGrid).row)
            GOTO  UpdateLastRowCol
         ELSE
            '**RC Added to wrap around to next row on last column
            IF (*pGrid).row < (*pGrid).rows-1 THEN						'**RC TODO: Do the same for left key
               SendMessage((*pGrid).hgrd,GM_SETCURSEL,0,(*pGrid).row+1)
               GOTO  UpdateLastRowCol
            ENDIF
         END IF
         GOTO   Ex
      ELSEIF (CBWPARAM = 0x25) AND (tmp = 0x14B OR tmp = 0x4B) THEN
         'Left
         'CALL  GetMem
         pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

         tmp = (*pGrid).col
         '@@:
         again2:
         IF tmp THEN
            DECR tmp

            pCol = (LPCOLUMN)((LPBYTE)pGrid + (tmp * SIZEOF(COLUMN)) + SIZEOF(GRID))
            IF NOT (*pCol).colwt THEN
               'jmp   @b
               GOTO again2
            END IF
            SendMessage((*pGrid).hgrd,GM_SETCURSEL,tmp,(*pGrid).row)
            GOTO  UpdateLastRowCol
         ELSE
            IF (*pGrid).row > 0 THEN
               SendMessage((*pGrid).hgrd,GM_SETCURSEL,(*pGrid).cols-1,(*pGrid).row-1)
               GOTO  UpdateLastRowCol
            END IF
         END IF
         GOTO   Ex
      ELSEIF (CBWPARAM = 0x28) AND (tmp = 0x150 OR tmp = 0x50) THEN
         'Down
         'CALL  GetMem
         pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))
         tmp = (*pGrid).row + 1

         IF tmp < (*pGrid).rows THEN
            SendMessage((*pGrid).hgrd,GM_SETCURSEL,(*pGrid).col,tmp)
            GOTO  UpdateLastRowCol
         END IF
         GOTO   Ex
      ELSEIF (CBWPARAM = 0x26) AND (tmp = 0x148 OR tmp = 0x48) THEN
         'Up
         'CALL  GetMem
         pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))
         tmp = (*pGrid).row
         IF tmp THEN
            DECR tmp
            SendMessage((*pGrid).hgrd,GM_SETCURSEL,(*pGrid).col,tmp)
            GOTO  UpdateLastRowCol
         END IF
         GOTO   Ex
      ELSEIF (CBWPARAM = 0x21) AND (tmp = 0x149 OR tmp = 0x49) THEN
         'PgUp
         'CALL  GetMem
         pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

         IF (*pGrid).row THEN
            GetClientRect(CBHWND,&rect)
            tmp = rect.bottom / (*pGrid).rowht
            tmp = (*pGrid).row - tmp
            IF tmp < 0 THEN
               tmp = 0
            END IF
            SendMessage((*pGrid).hgrd,GM_SETCURSEL,(*pGrid).col,tmp)
            GOTO  UpdateLastRowCol
         END IF
         GOTO   Ex
      ELSEIF (CBWPARAM = 0x22) AND (tmp = 0x151 OR tmp = 0x51) THEN
         'PgDn
         'CALL  GetMem
         pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

         GetClientRect(CBHWND,&rect)
         tmp = rect.bottom / (*pGrid).rowht
         tmp = tmp + (*pGrid).row

         IF tmp >= (*pGrid).rows THEN
            tmp = (*pGrid).rows - 1
         END IF
         SendMessage((*pGrid).hgrd,GM_SETCURSEL,(*pGrid).col,tmp)
         GOTO UpdateLastRowCol
         'jmp   Ex
      ELSEIF (CBWPARAM = 0x24) AND (tmp = 0x147 OR tmp = 0x47) THEN
         'Home
         'CALL  GetMem
         pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

         SendMessage((*pGrid).hgrd,GM_SETCURSEL,(*pGrid).col,0)
         GOTO UpdateLastRowCol
         'jmp   Ex
      ELSEIF (CBWPARAM = 0x23) AND (tmp = 0x14F OR tmp = 0x4F) THEN
         'End
         'CALL  GetMem
         pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

         tmp = (*pGrid).rows - 1
         SendMessage((*pGrid).hgrd,GM_SETCURSEL,(*pGrid).col,tmp)
         GOTO UpdateLastRowCol
         'jmp   Ex
      END IF

      '********************
      CASE WM_CHAR
      '********************
      'CALL GetMem
      DIM RAW thWnd AS HWND
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      IF CBWPARAM = VK_TAB THEN
         '         RAW keystate
         '         keystate = GetAsyncKeyState(VK_SHIFT)
         '         PostMessage((*pGrid).hpar, WM_NEXTDLGCTL, keystate, 0)
         SetFocus((*pGrid).hpar)
         PostMessage((*pGrid).hpar, CBMSG, CBWPARAM,CBLPARAM)

      ELSE
         thWnd = raShowHide((*pGrid).hgrd,TRUE)
         IF (CBWPARAM <> VK_RETURN) AND thWnd THEN ' check me
            SendMessage(thWnd,WM_CHAR,CBWPARAM,CBLPARAM)
         END IF
      END IF
      GOTO Ex

      '********************
      CASE WM_LBUTTONDOWN, WM_RBUTTONDOWN
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      SetFocus(CBHWND)
      SetCapture(CBHWND)

      DIM RAW xpos  = LOWORD(CBLPARAM)
      DIM RAW ypos  = HIWORD(CBLPARAM)
      DIM RAW ctype = 0

      fonbtn = FALSE
      fsame  = TRUE

      tmp = raRowColumnClicked(pGrid, &xpos, &ypos)

      IF tmp <> -1 THEN
         ctype = HIWORD(tmp)
         IF LOWORD(tmp) THEN 'In the button zone
            IF ctype = TYPE_COMBOBOX OR ctype = TYPE_BUTTON OR ctype = TYPE_EDITBUTTON THEN
               fonbtn = ctype
            END IF
         END IF

         IF (xpos <> ncol) OR (ypos <> nrow) THEN
            fsame = FALSE
            fonbtn = FALSE
         END IF
         ncol = xpos
         nrow = ypos
         '----------------------------------------
         ' Initialize block selection
         '----------------------------------------
         IF CBMSG = WM_LBUTTONDOWN THEN
            IF CBWPARAM BAND MK_CONTROL THEN
               ' (xySP) is used to hold the starting position of a selection block
               GLOBAL xySP
               xySP = MAKECOLROW(ncol, nrow)
               (*pGrid).XYBlkSelStart = xySP
               (*pGrid).XYBlkSelEnd   = (*pGrid).XYBlkSelStart
            ELSE
               (*pGrid).XYBlkSelStart = MAKECOLROW(-1, -1)
               (*pGrid).XYBlkSelEnd   = 0
            END IF
            InvalidateRect(CBHWND,0,TRUE)
         END IF
         '----------------------------------------

         ' We must still send message again to simulate button clicks
         ' even though its the same row/column.
         SendMessage((*pGrid).hgrd,GM_SETCURSEL,ncol,nrow)

         IF (ctype = TYPE_CHECKBOX) AND fsame THEN
            raShowHide((*pGrid).hgrd, TRUE)
         END IF
      END IF

      GOTO Ex

      '********************
      CASE WM_LBUTTONUP, WM_RBUTTONUP
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      IF GetCapture() = CBHWND THEN
         ReleaseCapture()
         IF fonbtn AND fsame THEN
            IF fonbtn = TYPE_COMBOBOX THEN
               ncol = -1
               nrow = -1
            END IF
            fsame = FALSE
            raShowHide((*pGrid).hgrd,TRUE)
            fonbtn = FALSE
         END IF

         pCol = (LPCOLUMN)((LPBYTE) pGrid + ((*pGrid).col * SIZEOF(COLUMN)) + SIZEOF(GRID))
         DIM RAW gn AS GRIDNOTIFY
         DIM RAW ItemSelected

         IF (WM_RBUTTONUP = CBMSG) AND (*pCol).cellmenu THEN
            DIM RAW pt AS POINT

            GetCursorPos(&pt)       ' get mouse screen coordinates
            ItemSelected = TrackPopupMenuEx((*pCol).cellmenu, _
            TPM_LEFTALIGN OR TPM_RIGHTBUTTON OR TPM_RETURNCMD, pt.x, pt.y, CBHWND, NULL)

            IF ItemSelected THEN
               gn.nmhdr.hwndFrom = (*pGrid).hgrd
               gn.nmhdr.idFrom   = (*pGrid).nid
               gn.nmhdr.code     = GN_CELLMENU
               gn.col            = (*pGrid).col
               gn.row            = (*pGrid).row
               gn.hwnd           = CBHWND
               gn.lpdata         = &ItemSelected
               gn.fcancel        = 0
               SendMessage((*pGrid).hpar,WM_NOTIFY,(*pGrid).nid,&gn)
            END IF
         ELSEIF (WM_LBUTTONUP = CBMSG) AND (CBWPARAM BAND MK_CONTROL) THEN
            gn.nmhdr.hwndFrom = (*pGrid).hgrd
            gn.nmhdr.idFrom   = (*pGrid).nid
            gn.nmhdr.code     = GN_BLOCKSELECT
            gn.col            = GETCOL((*pGrid).XYBlkSelStart)
            gn.row            = GETROW((*pGrid).XYBlkSelStart)
            gn.hwnd           = CBHWND
            gn.lpdata         = &(*pGrid).XYBlkSelEnd
            gn.fcancel        = 0
            SendMessage((*pGrid).hpar,WM_NOTIFY,(*pGrid).nid,&gn)
         END IF
      END IF

      GOTO Ex

      '********************
      CASE WM_MOUSEMOVE
      '********************
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      '-------------------------------------------------------------------
      'Added GetCursorPos to overcome the 16 bit position limitation
      'passed by WM_MOUSEMOVE.
      '-------------------------------------------------------------------
      DIM RAW pt AS POINT, rc AS RECT

      GetCursorPos(&pt)
      ScreenToClient(CBHWND, &pt)
      GetClientRect(GetParent(CBHWND), &rc)

      IF GetCapture() = CBHWND THEN
         IF CBWPARAM BAND MK_CONTROL THEN

            '-------------------------------------------------------------------
            ' Allow the screen to scroll during cell selection
            '-------------------------------------------------------------------
            IF pt.y < 0 THEN
               SendMessage((*pGrid).hgrd,WM_VSCROLL,SB_LINEUP,0)
               GOTO Ex
            ELSEIF pt.y > rc.bottom THEN
               SendMessage((*pGrid).hgrd,WM_VSCROLL,SB_LINEDOWN,0)
               GOTO Ex
            END IF

            IF pt.x < (*pGrid).sbx THEN
               SendMessage((*pGrid).hgrd,WM_HSCROLL,SB_LINEUP,0)
               GOTO Ex
            ELSEIF pt.x > rc.right + (*pGrid).sbx THEN
               SendMessage((*pGrid).hgrd,WM_HSCROLL,SB_LINEDOWN,0)
               GOTO Ex
            END IF
            '-------------------------------------------------------------------

            DIM RAW xpos  = pt.x
            DIM RAW ypos  = pt.y

            tmp = raRowColumnClicked(pGrid, &xpos, &ypos)
            IF tmp <> -1 THEN
               DIM RAW ecol, erow
               DIM RAW stcol = GETCOL(xySP)
               DIM RAW strow = GETROW(xySP)

               IF xpos < stcol THEN ecol = stcol : stcol = xpos ELSE ecol = xpos
               IF ypos < strow THEN erow = strow : strow = ypos ELSE erow = ypos
               (*pGrid).XYBlkSelStart = MAKECOLROW(stcol, strow)
               (*pGrid).XYBlkSelEnd   = MAKECOLROW(ecol, erow)
               InvalidateRect(CBHWND,0,TRUE)
            END IF
         END IF
      END IF

      GOTO Ex

      '********************
      CASE WM_LBUTTONDBLCLK
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      pCol = (LPCOLUMN)((LPBYTE) pGrid + ((*pGrid).col * SIZEOF(COLUMN)) + SIZEOF(GRID))

      IF (*pCol).ctype <> TYPE_COMBOBOX THEN
         raShowHide((*pGrid).hgrd,TRUE)
      ELSE
         pCol = (LPCOLUMN)((LPBYTE) pGrid + SIZEOF(GRID))
         ftmp   = 0
         tmp    = 0
         colcnt = 0
         DIM RAW xpos = LOWORD(CBLPARAM)
         WHILE colcnt < (*pGrid).cols
            tmp += (*pCol).colwt
            IF (xpos >= (*pCol).colxp) AND (xpos <= tmp) THEN
               IF (*pCol).ctype = TYPE_COMBOBOX OR (*pCol).ctype = TYPE_BUTTON OR (*pCol).ctype = TYPE_EDITBUTTON THEN
                  xpos += (*pGrid).rowht
                  IF xpos >= tmp THEN
                     ftmp = (*pCol).ctype
                  END IF
               END IF
               EXIT WHILE
            END IF
            pCol = (LPCOLUMN)((LPBYTE)pCol + SIZEOF(COLUMN))
            INCR colcnt
         WEND

         IF ftmp THEN
            SetCapture(CBHWND)
         ELSE
            raShowHide((*pGrid).hgrd,TRUE)
         END IF
      END IF
      GOTO Ex

      '********************
      CASE WM_SETFOCUS
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      IF (*pGrid).hedt THEN
         ShowWindow((*pGrid).hedt,SW_HIDE)
         (*pGrid).hedt = 0
      END IF
      raGetItemRect(pGrid,(*pGrid).row,&rect)
      InvalidateRect(CBHWND,&rect,TRUE)
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))

      '********************
      CASE WM_KILLFOCUS
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      raGetItemRect(pGrid,(*pGrid).row,&rect)
      InvalidateRect(CBHWND,&rect,TRUE)
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))

      '      '********************
      '      CASE WM_MOUSEWHEEL
      '      '********************
      '      SendMessage(GetParent(CBHWND),CBMSG,CBWPARAM,CBLPARAM)
      '      EXIT FUNCTION

      '********************
      CASE WM_GETDLGCODE
      '********************
      FUNCTION = DLGC_CODE

   END SELECT
   FUNCTION = DefWindowProc(CBHWND,CBMSG,CBWPARAM,CBLPARAM)

   UpdateLastRowCol:
   ncol = (*pGrid).col
   nrow = (*pGrid).row

   Ex:
   GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
   EXIT FUNCTION

END FUNCTION
' RAListProc endp

CALLBACK FUNCTION RAGridProc
   DIM RAW  mDC   AS HDC
   DIM RAW  rect  AS RECT
   DIM RAW  rect1 AS RECT
   DIM RAW  rect2 AS RECT
   DIM RAW  buffer[MAXBUFFSIZE] AS CHAR
   DIM RAW  value  AS DWORD
   DIM RAW  dvalue AS DOUBLE
   DIM RAW  sinf   AS SCROLLINFO
   DIM RAW  curcol AS DWORD
   DIM RAW  gn     AS GRIDNOTIFY
   DIM RAW  stime AS SYSTEMTIME
   DIM RAW  ft    AS ULARGE_INTEGER
   DIM RAW  dis   AS DRAWITEMSTRUCT
   DIM RAW  fCol  AS DWORD
   DIM RAW  rowcolor AS ROWCOLOR
   DIM RAW  pDis AS DRAWITEMSTRUCT PTR

   DIM RAW pDword = (dword*)buffer AS DWORD PTR

   DIM RAW  flag
   DIM RAW  tmp
   DIM RAW  exitvalue
   DIM RAW  pGrid AS LPGRID
   DIM RAW  pCol  AS LPCOLUMN

   DIM RAW kd AS STRING * 64   '**RC Added for HotKey Decoding

   SELECT CASE CBMSG

      '********************
      CASE WM_DRAWITEM
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      'Make sure style is updated
      (*pGrid).style = GetWindowLong(CBHWND,GWL_STYLE)

      pDis = (LPDRAWITEMSTRUCT) CBLPARAM

      DIM RAW hObj1 AS HGDIOBJ, hObj2 AS HGDIOBJ, hObj3 AS HGDIOBJ
      DIM RAW hbmp AS HBITMAP

      IF (*pDis).hwndItem = (*pGrid).hlst THEN
         IF (*pDis).itemID <> LB_ERR THEN
            raGridGetRowColor(pGrid,(*pDis).itemData, &rowcolor)
            (*pDis).rcItem.right = (*pGrid).ccx + 1
            CopyRect(&rect2,&(*pDis).rcItem)
            mDC   = CreateCompatibleDC((*pDis).hDC)
            hObj1 = SelectObject(mDC,(*pGrid).hfont)

            rect2.right  -= rect2.left
            rect2.bottom -= rect2.top
            rect2.left    = 0
            rect2.top     = 0

            hbmp  = CreateCompatibleBitmap((*pDis).hDC,rect2.right,rect2.bottom)
            hObj2 = SelectObject(mDC,hbmp)
            hObj3 = SelectObject(mDC,(*pGrid).hpengrd)

            tmp = (*pDis).itemID + 1
            tmp -= (*pGrid).rows

            IF NOT ((*pGrid).style BAND STYLE_GRIDFRAME) THEN
               DECR   tmp
            END IF

            IF ((*pGrid).style BAND STYLE_HGRIDLINES) OR NOT tmp THEN
               DECR rect2.bottom
               MoveToEx(mDC,rect2.left,rect2.bottom,NULL)
               LineTo(mDC,rect2.right,rect2.bottom)
            END IF

            SetBkMode(mDC, TRANSPARENT)
            flag = ((*pGrid).style BAND STYLE_NOSEL) XOR STYLE_NOSEL

            IF flag THEN
               flag = ODS_SELECTED
            END IF

            DIM RAW hBrush AS HBRUSH

            IF NOT ((*pDis).itemState BAND flag) THEN
               tmp = rowcolor.textcolor
               IF tmp = -1 THEN
                  tmp = (*pGrid).coltext
               END IF
               SetTextColor(mDC,tmp)
               IF rowcolor.backcolor = -1 THEN
                  FillRect(mDC,&rect2,(*pGrid).hbrback)
               ELSE
                  hBrush = CreateSolidBrush(rowcolor.backcolor)
                  FillRect(mDC,&rect2,hBrush)
                  DeleteObject(hBrush)
               END IF
            ELSE
               SetTextColor(mDC, GetSysColor(COLOR_HIGHLIGHTTEXT))

               IF (*pGrid).colhilite THEN
                  hBrush = CreateSolidBrush((*pGrid).colhilite)
                  FillRect(mDC,&rect2,hBrush)
                  DeleteObject(hBrush)
               ELSE
                  FillRect(mDC, &rect2, (HBRUSH)(COLOR_HIGHLIGHT+1))
               END IF
            END IF


            pCol = (LPCOLUMN)((LPBYTE)pGrid + SIZEOF(GRID))
            DIM RAW txtclr = GetTextColor(mDC) AS COLORREF

            curcol = 0
            WHILE curcol < (*pGrid).cols
               IF (*pCol).colwt THEN
                  rect2.left  = (*pCol).colxp
                  rect2.right = rect2.left + (*pCol).colwt
                  *pDword = 0

                  '----------------------------------------------------------------
                  'Block Selection
                  '----------------------------------------------------------------
                  IF (curcol >= GETCOL((*pGrid).XYBlkSelStart)) AND (curcol <= GETCOL((*pGrid).XYBlkSelEnd)) THEN
                     IF ((*pDis).itemID >= GETROW((*pGrid).XYBlkSelStart)) AND ((*pDis).itemID <= GETROW((*pGrid).XYBlkSelEnd)) THEN
                        FillRect(mDC, &rect2, (HBRUSH)(COLOR_HIGHLIGHT+1))
                        SetTextColor(mDC, GetSysColor(COLOR_HIGHLIGHTTEXT))
                        GOTO SkipColorColumn
                     END IF
                  END IF

                  '----------------------------------------------------------------
                  'Color columns
                  '----------------------------------------------------------------
                  IF (*pCol).ColumnColor.backcolor <> -1 THEN
                     hBrush = CreateSolidBrush((*pCol).ColumnColor.backcolor)
                     FillRect(mDC, &rect2, hBrush)
                     DeleteObject(hBrush)
                  END IF
                  IF (*pCol).ColumnColor.textcolor <> -1 THEN
                     SetTextColor(mDC, (*pCol).ColumnColor.textcolor)
                  ELSE
                     SetTextColor(mDC, txtclr)
                  END IF
                  '----------------------------------------------------------------

                  SkipColorColumn:

                  SELECT CASE (*pCol).ctype

                     '********************
                     CASE TYPE_EDITTEXT
                     '********************
                     raGridGetCellData(pGrid,(*pDis).itemData,curcol, (LPBYTE)buffer)

                     CALL raDrawItemText(pCol, mDC, buffer, &rect2)
                     CALL raDrawItemLine(pGrid, mDC, curcol, &rect2)

                     '********************
                     CASE TYPE_EDITLONG
                     '********************
                     raGridGetCellData(pGrid,(*pDis).itemData,curcol,(LPBYTE)&value)
                     ltoa(value, buffer,10)

                     IF (*pCol).lpszformat THEN
                        'Format:
                        DIM RAW buf1 AS LPSTR, buf2 AS LPSTR
                        DIM RAW len1, len2
                        DIM RAW al AS UCHAR

                        buf1 = &buffer[MAXBUFFSIZE-64]
                        buf2 = &buffer[MAXBUFFSIZE-66]
                        raGridGetText(pGrid,(*pCol).rpszformat,buf1)

                        *(buf2 + 1) = 0
                        len1 = LEN(buf1)
                        len2 = LEN(buffer)

                        WHILE len2 AND len1
                           al = *(buffer + len2 - 1)
                           IF al <> ASC("-") THEN
                              DECR len1
                              al = *(buf1 + len1)
                              IF al = ASC("#") THEN
                                 DECR len2
                                 al = *(buffer + len2)
                              END IF
                           ELSE
                              len2 = 0
                           END IF
                           *buf2 = al
                           DECR buf2
                        WEND
                        strcpy(buffer, buf2 + 1)
                     END IF

                     CALL raDrawItemText(pCol, mDC, buffer, &rect2)
                     CALL raDrawItemLine(pGrid, mDC, curcol, &rect2)

                     '********************
                     CASE TYPE_EDITDOUBLE
                     '********************
                     raGridGetCellData(pGrid,(*pDis).itemData,curcol,(LPBYTE)&dvalue)

                     IF (*pCol).lpszformat THEN
                        'Format:
                        raGridGetText(pGrid,(*pCol).rpszformat,&buffer[MAXBUFFSIZE-64])
                        buffer$ = USING$(&buffer[MAXBUFFSIZE-64], dvalue)
                     ELSE
                        buffer$ = STR$(dvalue)
                     END IF

                     CALL raDrawItemText(pCol, mDC, buffer, &rect2)
                     CALL raDrawItemLine(pGrid, mDC, curcol, &rect2)

                     '********************
                     CASE TYPE_CHECKBOX
                     '********************
                     raGridGetCellData(pGrid,(*pDis).itemData,curcol,(LPBYTE)&value)
                     CopyRect(&rect,&rect2)
                     tmp = rect.bottom - rect.top
                     tmp -= 13
                     tmp = tmp >> 1

                     rect.top += tmp
                     rect.bottom = rect.top + 13
                     IF (*pCol).calign = GA_ALIGN_LEFT THEN
                        INCR tmp
                        rect.left += tmp
                        rect.right = rect.left + 13
                        'ELSEIF (*pCol).calign = GA_ALIGN_CENTER THEN
                     ELSEIF (*pCol).calign = GA_ALIGN_RIGHT THEN
                        rect.left = rect.right - tmp
                        rect.left -= 13
                     END IF
                     IF value THEN
                        flag = DFCS_BUTTONCHECK BOR DFCS_FLAT BOR DFCS_CHECKED
                     ELSE
                        flag = DFCS_BUTTONCHECK BOR DFCS_FLAT
                     END IF
                     DrawFrameControl(mDC,&rect,DFC_BUTTON,flag)
                     CALL raDrawItemLine(pGrid, mDC, curcol, &rect2)

                     '********************
                     CASE TYPE_COMBOBOX
                     '********************
                     raGridGetCellData(pGrid,(*pDis).itemData,curcol,(LPBYTE)&value)
                     CALL raDrawItemLine(pGrid, mDC, curcol, &rect2)
                     IF curcol = (*pGrid).col THEN
                        CopyRect(&rect,&rect2)
                        rect.left = rect.right - 17
                        'test [esi].itemState,ODS_SELECTED
                        IF (*pDis).itemState BAND ODS_SELECTED THEN
                           rect2.right -= 17
                           flag = DFCS_SCROLLDOWN
                           IF fonbtn AND fsame THEN
                              flag = flag BOR DFCS_PUSHED
                           END IF
                           DrawFrameControl(mDC,&rect,DFC_SCROLL,flag)
                        END IF
                     END IF
                     *buffer = 0
                     DIM RAW idx = 0, lbdata
                     DO
                        lbdata = SendMessage((*pCol).edthwnd,LB_GETITEMDATA,idx,0)
                        IF lbdata = value OR lbdata = LB_ERR THEN EXIT DO
                        INCR idx
                     LOOP
                     IF lbdata <> LB_ERR THEN
                        SendMessage((*pCol).edthwnd,LB_GETTEXT,idx,buffer)
                        IF (*pCol).himl THEN
                           CopyRect(&rect,&rect2)
                           rect.left += 2
                           rect.right = rect.left + 16
                           DIM RAW rgn AS HRGN
                           rgn = CreateRectRgn(rect.left,rect.top,rect.right,rect.bottom)
                           SelectClipRgn(mDC,rgn)
                           DeleteObject(rgn)
                           ImageList_GetIconSize((*pCol).himl, (INT*)&rect.right, (INT*)&rect.bottom)
                           rect2.left += 19
                           tmp = rect2.bottom - rect2.top
                           tmp -= rect.bottom
                           tmp = tmp >> 1
                           rect.top += tmp
                           ImageList_Draw((*pCol).himl,value,mDC,rect.left,rect.top,ILD_NORMAL)
                           SelectClipRgn(mDC,NULL)
                        END IF
                        CALL raDrawItemText(pCol, mDC, buffer, &rect2)
                     END IF

                     '********************
                     CASE TYPE_HOTKEY
                     '********************
                     raGridGetCellData(pGrid,(*pDis).itemData,curcol,(LPBYTE)&value)
                     ' **RC made this a Function in HotKeySupport.inc as it is missing Many possible key translations
                     kd$ = HotKeyString(value,(*pCol).lParam)
                     lstrcat(buffer,  kd$)
                     CALL raDrawItemText(pCol, mDC, buffer, &rect2)
                     CALL raDrawItemLine(pGrid, mDC, curcol, &rect2)

                     '********************
                     CASE TYPE_BUTTON, TYPE_EDITBUTTON
                     '********************
                     raGridGetCellData(pGrid,(*pDis).itemData, curcol, (LPBYTE)buffer)
                     CALL raDrawItemLine(pGrid, mDC, curcol, &rect2)

                     IF (*pDis).itemState BAND ODS_SELECTED THEN
                        IF curcol = (*pGrid).col THEN
                           CopyRect(&rect,&rect2)
                           rect2.right -= 17
                           rect.left = rect.right - 17
                           flag = DFCS_BUTTONPUSH
                           IF fonbtn AND fsame THEN
                              flag = flag BOR DFCS_PUSHED
                           END IF
                           DIM RAW tclr AS COLORREF, fobj AS HGDIOBJ
                           DrawFrameControl(mDC,&rect,DFC_BUTTON,flag)
                           tclr = SetTextColor(mDC,0)
                           fobj = SelectObject(mDC, GetStockObject(SYSTEM_FONT))
                           strcpy((LPSTR)&value,"...")
                           TextOut(mDC,rect.left+2,0,(LPSTR)&value,3)
                           SelectObject(mDC,fobj)
                           SetTextColor(mDC,tclr)
                        END IF
                     END IF
                     CALL raDrawItemText(pCol, mDC, buffer, &rect2)

                     '********************
                     CASE TYPE_IMAGE
                     '********************
                     raGridGetCellData(pGrid,(*pDis).itemData,curcol,(LPBYTE)&value)
                     CALL raDrawItemLine(pGrid, mDC, curcol, &rect2)
                     DIM RAW rgn AS HRGN
                     IF (*pCol).himl THEN
                        CopyRect(&rect,&rect2)
                        rgn = CreateRectRgn(rect.left,rect.top,rect.right,rect.bottom)
                        SelectClipRgn(mDC,rgn)
                        DeleteObject(rgn)
                        ImageList_GetIconSize((*pCol).himl, (INT*)&rect.right, (INT*)&rect.bottom)
                        IF (*pCol).calign = GA_ALIGN_LEFT THEN
                        ELSEIF (*pCol).calign = GA_ALIGN_CENTER THEN
                           tmp = rect2.right - rect2.left
                           tmp -= rect.right
                           tmp >>= 1
                           rect.left += tmp
                        ELSE
                           rect.left = rect2.right - rect.right
                        END IF
                        tmp = rect2.bottom - rect2.top
                        tmp -= rect.bottom
                        tmp >>= 1
                        rect.top += tmp
                        ImageList_Draw((*pCol).himl,value,mDC,rect.left,rect.top,ILD_NORMAL)
                        SelectClipRgn(mDC,NULL)
                     END IF

                     '********************
                     CASE TYPE_DATE
                     '********************
                     raGridGetCellData(pGrid,(*pDis).itemData,curcol,(LPBYTE)&value)
                     'Days since 01.01.1601
                     'Convert to number of 100 nano seconds since 01.01.1601
                     ft.QuadPart = value * SYSTICK_2_DAYS
                     FileTimeToSystemTime((FILETIME*)&ft,&stime)

                     IF (*pCol).lpszformat THEN
                        raGridGetText(pGrid,(*pCol).rpszformat,&buffer[MAXBUFFSIZE-64])
                        GetDateFormat(0,0,&stime,&buffer[MAXBUFFSIZE-64],buffer,SIZEOF(buffer))
                     ELSE
                        GetDateFormat(0,0,&stime,0,buffer,SIZEOF(buffer))
                     END IF

                     CALL raDrawItemText(pCol, mDC, buffer, &rect2)
                     CALL raDrawItemLine(pGrid, mDC, curcol, &rect2)

                     '********************
                     CASE TYPE_TIME
                     '********************
                     raGridGetCellData(pGrid,(*pDis).itemData,curcol,(LPBYTE)&value)
                     stime.wYear      = 2000
                     stime.wMonth     = 1
                     stime.wDayOfWeek = 6
                     stime.wDay       = 1
                     stime.wSecond    = IMOD(value, 60)
                     value            = value / 60
                     stime.wMinute    = IMOD(value, 60)
                     stime.wHour      = value / 60
                     stime.wMilliseconds = 0

                     IF (*pCol).lpszformat THEN
                        raGridGetText(pGrid,(*pCol).rpszformat,&buffer[MAXBUFFSIZE-64])
                        GetTimeFormat(0,0,&stime,&buffer[MAXBUFFSIZE-64],buffer,SIZEOF(buffer))
                     ELSE
                        GetTimeFormat(0,0,&stime,0,buffer,SIZEOF(buffer))
                     END IF

                     CALL raDrawItemText(pCol, mDC, buffer, &rect2)
                     CALL raDrawItemLine(pGrid, mDC, curcol, &rect2)

                     '********************
                     CASE TYPE_USER
                     '********************
                     raGridGetCellData(pGrid,(*pDis).itemData,curcol,(LPBYTE)buffer)
                     'GOSUB SetNotify
                     gn.nmhdr.hwndFrom = CBHWND
                     gn.nmhdr.idFrom   = (*pGrid).nid
                     gn.nmhdr.code     = GN_USERCONVERT
                     gn.hwnd           = (*pGrid).hedt
                     gn.col            = curcol
                     gn.row            = (*pDis).itemID
                     gn.fcancel        = FALSE
                     gn.lpdata         = buffer
                     SendMessage((*pGrid).hpar,WM_NOTIFY,gn.nmhdr.idFrom,&gn)

                     CALL raDrawItemLine(pGrid, mDC, curcol, &rect2)

                     IF NOT gn.fcancel THEN
                        CALL raDrawItemText(pCol, mDC, buffer, &rect2)
                     ELSE
                        dis.CtlID = (*pGrid).nid
                        'Win98 strips off high word fron itemID so col must be stored in CtlType
                        dis.itemID     = (*pDis).itemID
                        dis.CtlType    = curcol
                        dis.itemAction = ODA_DRAWENTIRE
                        dis.itemState  = 0
                        dis.hwndItem   = (*pGrid).hgrd
                        dis.hDC        = mDC
                        CopyRect(&dis.rcItem,&rect2)
                        INCR dis.rcItem.left
                        dis.itemData = (dword)buffer
                        SendMessage((*pGrid).hpar,WM_DRAWITEM,(*pGrid).nid,&dis)
                     END IF
                  END SELECT
                  'mov    ecx,curcol
                  IF curcol = (*pGrid).col THEN
                     flag = ((*pGrid).style BAND STYLE_NOFOCUS) XOR STYLE_NOFOCUS

                     IF flag THEN
                        flag = ODS_FOCUS
                        IF ((*pGrid).style BAND STYLE_NOSEL) THEN
                           flag = flag BOR ODS_SELECTED
                        END IF
                     END IF

                     IF (*pDis).itemState BAND flag THEN
                        tmp = GetTextColor(mDC)
                        SetTextColor(mDC,0)
                        CopyRect(&rect,&rect2)

                        IF (*pGrid).col THEN
                           INCR rect.left
                        END IF
                        DrawFocusRect(mDC,&rect)

                        IF (*pDis).itemState BAND ODS_FOCUS THEN
                           INCR rect.left
                           INCR rect.top
                           DECR rect.right
                           DECR rect.bottom
                           DrawFocusRect(mDC,&rect)
                        END IF
                        SetTextColor(mDC,tmp)
                     END IF
                  END IF
               END IF
               pCol = (LPCOLUMN)((LPBYTE)pCol + SIZEOF(COLUMN))
               INCR curcol
            WEND

            BitBlt((*pDis).hDC,(*pDis).rcItem.left,(*pDis).rcItem.top, _
            (*pDis).rcItem.right-(*pDis).rcItem.left, _
            1 + ((*pDis).rcItem.bottom -(*pDis).rcItem.top),mDC,0,0,SRCCOPY)
            'Restore pen
            SelectObject(mDC,hObj3)
            'Restore bitmap
            hObj2 = SelectObject(mDC,hObj2)
            'Delete bitmap
            DeleteObject(hObj2)
            'Restore font
            SelectObject(mDC,hObj1)
            DeleteDC(mDC)
         END IF
      ELSEIF (*pDis).hwndItem = (*pGrid).hhdr THEN
         SetTextColor((*pDis).hDC, GetSysColor(COLOR_WINDOWTEXT))
         SetBkColor((*pDis).hDC, GetSysColor(COLOR_BTNFACE))
         ExtTextOut((*pDis).hDC,0,0,ETO_OPAQUE,&(*pDis).rcItem,NULL,0,NULL)

         pCol = (LPCOLUMN)((LPBYTE) pGrid + SIZEOF(GRID))

         fCol = 0
         DIM RAW colcnt = 0
         WHILE colcnt < (*pGrid).cols

            IF (*pCol).colwt THEN
               tmp = (*pCol).colxp
               IF fCol THEN
                  INCR tmp
               END IF
               (*pDis).rcItem.left = tmp
               tmp += (*pCol).colwt
               IF NOT fCol THEN
                  INCR tmp
               END IF
               INCR fCol
               (*pDis).rcItem.right = tmp

               IF (*pCol).hdrflag BAND HEADERCLICKED THEN
                  flag = EDGE_SUNKEN
               ELSE
                  flag = EDGE_RAISED
               END IF

               DrawEdge((*pDis).hDC,&(*pDis).rcItem,flag,BF_RECT)
               (*pDis).rcItem.top   += 2
               (*pDis).rcItem.left  += 3
               (*pDis).rcItem.right -= 3

               IF (*pCol).lpszhdrtext THEN
                  SendMessage(CBHWND,GM_GETHDRTEXT, colcnt, buffer)
                  IF (*pCol).halign = GA_ALIGN_LEFT THEN
                     flag = DT_LEFT BOR DT_NOPREFIX
                  ELSEIF (*pCol).halign = GA_ALIGN_CENTER THEN
                     flag = DT_CENTER BOR DT_NOPREFIX
                  ELSE
                     flag = DT_RIGHT BOR DT_NOPREFIX
                  END IF

                  IF (*pCol).hdrflag BAND HEADERCLICKED THEN
                     INCR   (*pDis).rcItem.left
                     INCR   (*pDis).rcItem.top
                     INCR   (*pDis).rcItem.right
                     DrawText((*pDis).hDC,buffer,LEN(buffer),&(*pDis).rcItem,flag)
                     DECR   (*pDis).rcItem.left
                     DECR   (*pDis).rcItem.top
                     DECR   (*pDis).rcItem.right
                  ELSE
                     DrawText((*pDis).hDC,buffer,LEN(buffer),&(*pDis).rcItem,flag)
                  END IF
               END IF
               (*pDis).rcItem.top -= 2
            END IF

            pCol = (LPCOLUMN)((LPBYTE)pCol + SIZEOF(COLUMN))
            INCR colcnt
            (*pDis).rcItem.left = (*pDis).rcItem.right + 3
         WEND
         (*pDis).rcItem.right = 9999
         DrawEdge((*pDis).hDC,&(*pDis).rcItem,EDGE_RAISED,BF_RECT)
      END IF

      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      'EXIT FUNCTION
      FUNCTION = 1

      '********************
      CASE WM_ERASEBKGND
      '********************
      FUNCTION = 1

      '********************
      CASE WM_CTLCOLORLISTBOX
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))
      exitvalue = (integer)(*pGrid).hbrback
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      FUNCTION = exitvalue

      '********************
      CASE WM_SIZE
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      GetClientRect(CBHWND,&rect)
      rect.right = 8192
      rect.left -= (*pGrid).sbx
      MoveWindow((*pGrid).hhdr,rect.left,0,rect.right,(*pGrid).hdrht,TRUE)
      MoveWindow((*pGrid).hlst,rect.left,(*pGrid).hdrht,rect.right,rect.bottom - (*pGrid).hdrht,TRUE)
      raSetScroll(CBHWND, pGrid, &sinf)
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))

      '********************
      CASE WM_DESTROY
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      DestroyWindow((*pGrid).hsize)
      DestroyWindow((*pGrid).hhdr)
      DestroyWindow((*pGrid).hlst)
      'DestroyCursor((*pGrid).hcur)
      IF (*pGrid).hbrback <> (HBRUSH)(COLOR_WINDOW+1) THEN
         DeleteObject((*pGrid).hbrback)
      END IF
      DeleteObject((*pGrid).hpengrd)
      IF (*pGrid).hmem THEN
         GlobalFree((*pGrid).hmem)
      END IF
      IF (*pGrid).hmem THEN
         GlobalFree((*pGrid).hmem)
      END IF
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      GlobalFree((LPVOID)GetWindowLong(CBHWND,0))
      SetWindowLong(CBHWND,0,0)

      '********************
      CASE WM_CREATE
      '********************
      DIM RAW tptr AS LPBYTE

      tptr = (LPBYTE)GlobalAlloc(GMEM_MOVEABLE BOR GMEM_ZEROINIT, MEM_SIZE)

      SetWindowLong(CBHWND, 0, (long)tptr)
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      (*pGrid).itemmemsize = MEM_SIZE
      (*pGrid).hdrht       = 18
      (*pGrid).rowht       = 18
      (*pGrid).cols        = 0
      (*pGrid).rows        = 0
      (*pGrid).hpar        = GetParent(CBHWND)
      (*pGrid).hgrd        = CBHWND
      (*pGrid).nid         = GetWindowLong(CBHWND, GWL_ID)
      (*pGrid).style       = GetWindowLong(CBHWND, GWL_STYLE)
      (*pGrid).hsize       = CreateWindowEx(0, szStaticClass,NULL,WS_CHILD OR WS_CLIPCHILDREN OR WS_CLIPSIBLINGS OR SS_BLACKRECT,0,0,0,0,CBHWND,NULL,BCX_HINSTANCE,0)
      (*pGrid).hhdr        = CreateWindowEx(0, szStaticClass,NULL,WS_VISIBLE OR WS_CHILD OR WS_CLIPCHILDREN OR WS_CLIPSIBLINGS OR SS_OWNERDRAW OR SS_NOTIFY,0,0,0,0,CBHWND,NULL,BCX_HINSTANCE,0)
      tmp = (INT)SetWindowLong((*pGrid).hhdr,GWL_WNDPROC, (long)GridHdrProc)
      SetWindowLong((*pGrid).hhdr,GWL_USERDATA, tmp)
      (*pGrid).hlst        = CreateWindowEx(0, szRAListClass,NULL,WS_VISIBLE OR WS_CHILD OR WS_CLIPCHILDREN OR WS_CLIPSIBLINGS OR LBS_NOINTEGRALHEIGHT OR LBS_OWNERDRAWFIXED OR LBS_NOTIFY,0,0,0,0,CBHWND,NULL,BCX_HINSTANCE,0)
      SetWindowLong((*pGrid).hlst, 0, (long)tptr)
      '(*pGrid).hcur    = LoadCursor(BCX_HINSTANCE,(LPCTSTR)IDC_VSIZE)
      (*pGrid).hcur          = LoadCursor(NULL   , IDC_SIZEWE)
      (*pGrid).colback       = GetSysColor(COLOR_WINDOW)
      (*pGrid).hbrback       = (HBRUSH)(COLOR_WINDOW+1)
      (*pGrid).colgrid       = 0x0C0C0C0
      (*pGrid).hpengrd       = CreatePen(PS_SOLID, 1, 0x0C0C0C0)
      (*pGrid).coltext       = GetSysColor(COLOR_WINDOWTEXT)
      (*pGrid).toprow        = 0
      (*pGrid).rpitemdata    = SIZEOF(GRID)
      (*pGrid).XYBlkSelStart = MAKECOLROW(-1, -1)


      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      EXIT FUNCTION

      '********************
      CASE WM_SETFONT
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      (*pGrid).hfont = (HFONT)CBWPARAM
      SendMessage((*pGrid).hhdr,WM_SETFONT,CBWPARAM,FALSE)
      SendMessage((*pGrid).hlst,WM_SETFONT,CBWPARAM,FALSE)
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))

      '********************
      CASE WM_GETFONT
      '********************
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))
      exitvalue = (DWORD)(*pGrid).hfont
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))

      FUNCTION = exitvalue

      '********************
      CASE WM_SETFOCUS
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))
      SetFocus((*pGrid).hlst)
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))

      '********************
      CASE WM_MOUSEWHEEL
      '********************
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))
      IF (INT)CBWPARAM < 0 THEN
         'Right
         IF (INT)CBWPARAM BAND MK_SHIFT THEN					      '**RC ADDED to allow horizontal scrolling
            SendMessage((*pGrid).hlst,WM_KEYDOWN,0x27,0x4D0000)
         ELSEIF (INT)CBWPARAM BAND MK_CONTROL THEN					'**RC ADDED to allow horizontal scrolling
            SendMessage(CBHWND,WM_VSCROLL,SB_PAGEDOWN,0)
         ELSE
            SendMessage(CBHWND,WM_VSCROLL,SB_LINEDOWN,0)
            SendMessage(CBHWND,WM_VSCROLL,SB_LINEDOWN,0)
            SendMessage(CBHWND,WM_VSCROLL,SB_LINEDOWN,0)
         END IF
      ELSE
         IF (INT)CBWPARAM BAND MK_SHIFT THEN					      '**RC ADDED
            'Left
            SendMessage((*pGrid).hlst,WM_KEYDOWN,0x25,0x4B0000)
         ELSEIF (INT)CBWPARAM BAND MK_CONTROL THEN					'**RC ADDED to allow horizontal scrolling
            SendMessage(CBHWND,WM_VSCROLL,SB_PAGEUP,0)
         ELSE
            SendMessage(CBHWND,WM_VSCROLL,SB_LINEUP,0)
            SendMessage(CBHWND,WM_VSCROLL,SB_LINEUP,0)
            SendMessage(CBHWND,WM_VSCROLL,SB_LINEUP,0)
         END IF
      END IF
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      EXIT FUNCTION

      '********************
      CASE WM_VSCROLL
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      fCancelEdit=1												'**RC ADDED to cancel edits if scrolling
      IF IsWindowVisible((*pGrid).hedt) THEN
         ShowWindow((*pGrid).hedt,SW_HIDE)
      END IF

      sinf.cbSize = SIZEOF(sinf)
      sinf.fMask  = SIF_ALL
      GetScrollInfo(CBHWND,SB_VERT,&sinf)

      DIM RAW nPos = (*pGrid).rowht * (*pGrid).toprow

      SELECT CASE LOWORD(CBWPARAM)

         '********************
         CASE SB_THUMBTRACK, SB_THUMBPOSITION
         '********************
         nPos = sinf.nTrackPos

         '********************
         CASE SB_LINEDOWN
         '********************
         nPos += (*pGrid).rowht
         tmp = (sinf.nMax - sinf.nPage) + 1
         IF nPos > tmp THEN
            nPos = tmp
         END IF

         '********************
         CASE SB_LINEUP
         '********************
         nPos -= (*pGrid).rowht
         IF nPos < 0 THEN nPos = 0

         '********************
         CASE SB_PAGEDOWN
         '********************
         nPos += sinf.nPage
         tmp = (sinf.nMax - sinf.nPage) + 1
         IF nPos > tmp THEN
            nPos = tmp
         END IF

         '********************
         CASE SB_PAGEUP
         '********************
         nPos -= sinf.nPage
         IF nPos < 0 THEN nPos = 0

         '********************
         CASE SB_BOTTOM
         '********************
         nPos = (sinf.nMax - sinf.nPage) + 1

         '********************
         CASE SB_TOP
         '********************
         nPos = 0

      END SELECT

      IF nPos <> sinf.nPos THEN
         sinf.nPos = nPos
         (*pGrid).toprow = nPos / (*pGrid).rowht
         InvalidateRect((*pGrid).hlst,NULL,TRUE)
         raSetScroll(CBHWND, pGrid, &sinf)
      END IF
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))

      '********************
      CASE WM_HSCROLL
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      sinf.cbSize = SIZEOF(sinf)
      sinf.fMask  = SIF_ALL
      GetScrollInfo(CBHWND,SB_HORZ,&sinf)
      DIM RAW nPos = (*pGrid).sbx

      SELECT CASE LOWORD(CBWPARAM)

         '********************
         CASE SB_THUMBTRACK, SB_THUMBPOSITION
         '********************
         nPos = sinf.nTrackPos

         '********************
         CASE SB_LINEDOWN
         '********************
         nPos += 5
         tmp = (sinf.nMax - sinf.nPage) + 1

         IF nPos > tmp THEN
            nPos = tmp
         END IF

         '********************
         CASE SB_LINEUP
         '********************
         nPos -= 5
         IF nPos < 0 THEN nPos = 0

         '********************
         CASE SB_PAGEDOWN
         '********************
         nPos += sinf.nPage
         tmp = (sinf.nMax - sinf.nPage) + 1
         IF nPos > tmp THEN
            nPos = tmp
         END IF

         '********************
         CASE SB_PAGEUP
         '********************
         nPos -= sinf.nPage
         IF nPos < 0 THEN nPos = 0

         '********************
         CASE SB_BOTTOM
         '********************
         nPos = (sinf.nMax - sinf.nPage) + 1

         '********************
         CASE SB_TOP
         '********************
         nPos = 0

      END SELECT

      sinf.nPos = nPos
      tmp = (*pGrid).sbx - nPos
      (*pGrid).sbx = nPos
      ScrollWindow(CBHWND,tmp,0,NULL,NULL)
      raSetScroll(CBHWND, pGrid, &sinf)
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))

      '********************
      CASE GM_ADDCOL
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      IF NOT (*pGrid).hmem THEN

         DIM RAW pCol1 AS LPCOLUMN
         pCol1 = (LPCOLUMN)((LPBYTE) pGrid + (*pGrid).rpitemdata)

         'Copy user column struct to internal memory
         *pCol1 = *(LPCOLUMN)CBLPARAM

         'If no Column colors were specified then set them to -1
         IF NOT (*pCol1).pColumnColor THEN
            (*pCol1).ColumnColor.backcolor = -1
            (*pCol1).ColumnColor.textcolor = -1
         ELSE
            (*pCol1).ColumnColor = *(*(LPCOLUMN)CBLPARAM).pColumnColor
         END IF

         SELECT CASE (*pCol1).ctype

            '********************
            CASE TYPE_EDITTEXT
            '********************
            '**RC Added the Style to be modified via the lParam
            '	it is simply ored with the rest of the styles
            '
            (*pCol1).edthwnd = CreateWindowEx(0,szEditClass,NULL, _
            WS_CHILD OR WS_BORDER OR WS_CLIPCHILDREN OR WS_CLIPSIBLINGS OR ES_AUTOHSCROLL OR (*pCol1).lParam,0,0,0,0,(*pGrid).hlst,NULL,BCX_HINSTANCE,0)
            tmp = (INT)SetWindowLong((*pCol1).edthwnd,GWL_WNDPROC, (long)EdtTextProc)
            SetWindowLong((*pCol1).edthwnd,GWL_USERDATA, tmp)

            IF NOT (*pCol1).ctextmax OR ((*pCol1).ctextmax > MAXBUFFSIZE-1) THEN
               (*pCol1).ctextmax = MAXBUFFSIZE-1
            END IF
            SendMessage((*pCol1).edthwnd,EM_LIMITTEXT,(*pCol1).ctextmax,0)

            '********************
            CASE TYPE_EDITLONG
            '********************
            (*pCol1).edthwnd = CreateWindowEx(0, szEditClass,NULL,WS_CHILD OR WS_BORDER OR WS_CLIPCHILDREN OR WS_CLIPSIBLINGS OR ES_AUTOHSCROLL OR ES_RIGHT,0,0,0,0,(*pGrid).hlst,NULL,BCX_HINSTANCE,0)
            tmp = (INT)SetWindowLong((*pCol1).edthwnd,GWL_WNDPROC, (long)EdtLongProc)
            SetWindowLong((*pCol1).edthwnd,GWL_USERDATA, tmp)
            'mov    eax,(*pCol).ctextmax
            IF NOT (*pCol1).ctextmax OR (*pCol1).ctextmax > 11 THEN
               (*pCol1).ctextmax = 11
            END IF
            SendMessage((*pCol1).edthwnd,EM_LIMITTEXT,(*pCol1).ctextmax,0)

            '********************
            CASE TYPE_EDITDOUBLE
            '********************
            (*pCol1).edthwnd = CreateWindowEx(0, szEditClass,NULL,WS_CHILD OR WS_BORDER OR WS_CLIPCHILDREN OR WS_CLIPSIBLINGS OR ES_AUTOHSCROLL OR ES_RIGHT,0,0,0,0,(*pGrid).hlst,NULL,BCX_HINSTANCE,0)
            tmp = (INT)SetWindowLong((*pCol1).edthwnd, GWL_WNDPROC, (long)EdtDoubleProc)
            SetWindowLong((*pCol1).edthwnd,GWL_USERDATA, tmp)
            'mov    eax,(*pCol).ctextmax
            IF NOT (*pCol1).ctextmax  OR (*pCol1).ctextmax > 32 THEN
               (*pCol1).ctextmax = 32
            END IF
            SendMessage((*pCol1).edthwnd,EM_LIMITTEXT,(*pCol1).ctextmax,0)

            '********************
            CASE TYPE_COMBOBOX
            '********************
            '(*pCol1).himl = (*pCol2).himl
            (*pCol1).edthwnd = CreateWindowEx(0, szListBoxClass,NULL,WS_CHILD OR WS_BORDER OR WS_VSCROLL OR WS_CLIPCHILDREN OR WS_CLIPSIBLINGS OR LBS_HASSTRINGS OR LBS_SORT OR LBS_OWNERDRAWFIXED,0,0,0,0,(*pGrid).hlst,NULL,BCX_HINSTANCE,0)
            lplstproc = SetWindowLong((*pCol1).edthwnd,GWL_WNDPROC, (long)LstProc)
            SetWindowLong((*pCol1).edthwnd,GWL_USERDATA, (long)(*pGrid).hgrd)
            SetParent((*pCol1).edthwnd, GetDesktopWindow())
            SetWindowLong((*pCol1).edthwnd,GWL_STYLE,WS_POPUP OR WS_BORDER OR WS_VSCROLL OR WS_CLIPCHILDREN OR WS_CLIPSIBLINGS OR LBS_HASSTRINGS OR LBS_SORT OR LBS_OWNERDRAWFIXED)

            '********************
            CASE TYPE_HOTKEY
            '********************
            (*pCol1).edthwnd = CreateWindowEx(0, szHotKeyClass,NULL,WS_CHILD OR WS_CLIPCHILDREN OR WS_CLIPSIBLINGS,0,0,0,0,(*pGrid).hlst,NULL,BCX_HINSTANCE,0)
            tmp = (INT)SetWindowLong((*pCol1).edthwnd,GWL_WNDPROC, (long)HotProc)
            SetWindowLong((*pCol1).edthwnd,GWL_USERDATA, tmp)

            '********************
            CASE TYPE_BUTTON
            '********************
            (*pCol1).edthwnd = 0

            '********************
            CASE TYPE_EDITBUTTON
            '********************
            (*pCol1).edthwnd = CreateWindowEx(0, szEditClass,NULL, _
            WS_CHILD OR WS_BORDER OR WS_CLIPCHILDREN OR WS_CLIPSIBLINGS OR ES_AUTOHSCROLL OR (*pCol1).lParam,0,0,0,0,(*pGrid).hlst,NULL,BCX_HINSTANCE,0)
            tmp = (INT)SetWindowLong((*pCol1).edthwnd,GWL_WNDPROC, (long)EdtTextProc)
            SetWindowLong((*pCol1).edthwnd,GWL_USERDATA, tmp)

            IF NOT (*pCol1).ctextmax OR (*pCol1).ctextmax > MAXBUFFSIZE-1 THEN
               (*pCol1).ctextmax = MAXBUFFSIZE-1
            END IF
            SendMessage((*pCol1).edthwnd,EM_LIMITTEXT,(*pCol1).ctextmax,0)

            '********************
            CASE TYPE_IMAGE
            '********************
            '(*pCol1).himl = (*pCol2).himl
            EXIT SELECT

            '********************
            CASE TYPE_DATE
            '********************
            (*pCol1).edthwnd = CreateWindowEx(0, szDateTimeClass,NULL,WS_CHILD OR WS_CLIPCHILDREN OR WS_CLIPSIBLINGS,0,0,0,0,(*pGrid).hlst,NULL,BCX_HINSTANCE,0)
            tmp = (INT)SetWindowLong((*pCol1).edthwnd,GWL_WNDPROC, (long)DateTimeProc)
            SetWindowLong((*pCol1).edthwnd,GWL_USERDATA, tmp)

            '********************
            CASE TYPE_TIME
            '********************
            (*pCol1).edthwnd = CreateWindowEx(0, szDateTimeClass,NULL,WS_CHILD OR WS_CLIPCHILDREN OR WS_CLIPSIBLINGS OR DTS_TIMEFORMAT OR DTS_UPDOWN,0,0,0,0,(*pGrid).hlst,NULL,BCX_HINSTANCE,0)
            tmp = (INT)SetWindowLong((*pCol1).edthwnd,GWL_WNDPROC, (long)DateTimeProc)
            SetWindowLong((*pCol1).edthwnd,GWL_USERDATA, tmp)

            '********************
            CASE TYPE_USER
            '********************
            IF ((*pCol1).edthwnd = (HWND)TRUE) AND ((*pCol1).ctextmax = 0) THEN
               (*pCol1).edthwnd = CreateWindowEx(0,szEditClass,NULL, _
               WS_CHILD OR WS_BORDER OR WS_CLIPCHILDREN OR WS_CLIPSIBLINGS OR ES_AUTOHSCROLL OR (*pCol1).lParam,0,0,0,0,(*pGrid).hlst,NULL,BCX_HINSTANCE,0)

               tmp = (INT)SetWindowLong((*pCol1).edthwnd,GWL_WNDPROC, (long)EdtTextProc)
               SetWindowLong((*pCol1).edthwnd,GWL_USERDATA, tmp)

               SendMessage((*pCol1).edthwnd,EM_LIMITTEXT,MAXBUFFSIZE-1,0)
            ELSEIF (*pCol1).edthwnd THEN
               SetParent((*pCol1).edthwnd,(*pGrid).hlst)
            END IF

         END SELECT

         IF (*pCol1).edthwnd THEN
            DIM RAW fnt AS DWORD
            fnt = SendMessage((*pGrid).hlst,WM_GETFONT,0,0)
            SendMessage((*pCol1).edthwnd,WM_SETFONT,fnt,FALSE)
         END IF

         (*pCol1).colxp = (*pGrid).ccx
         (*pGrid).ccx += (*pCol1).colwt
         DIM RAW cols = (*pGrid).cols
         INCR (*pGrid).cols
         (*pGrid).rpitemdata += SIZEOF(COLUMN)

         IF (*pCol1).lpszhdrtext THEN
            SendMessage(CBHWND,GM_SETHDRTEXT,cols,(*pCol1).lpszhdrtext)
         END IF

         IF (*pCol1).lpszformat THEN
            SendMessage(CBHWND,GM_SETCOLFORMAT,cols,(*pCol1).lpszformat)
         END IF
         SendMessage(CBHWND,WM_SIZE,0,0)
         exitvalue = cols
      ELSE
         '** Error, data in grid
         exitvalue = LB_ERR
      END IF
      'CALL RelMem

      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      FUNCTION = exitvalue

      '********************
      CASE GM_ADDROW
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      IF (*pGrid).rows < RAGRID_MAXROWS THEN
         pGrid = ExpandItemMem(CBHWND, pGrid)
         IF pGrid THEN
            tmp = raGridAddRowData(pGrid,(LPBYTE)CBLPARAM)
            exitvalue = raInsertItem(pGrid, (*pGrid).rows, tmp)
            raSetScroll(CBHWND, pGrid, &sinf)
         ELSE
            exitvalue = LB_ERR
         END IF
      ELSE
         exitvalue = LB_ERR
      END IF
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      FUNCTION = exitvalue

      '********************
      CASE GM_INSROW
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      IF (*pGrid).rows < RAGRID_MAXROWS THEN
         pGrid = ExpandItemMem(CBHWND, pGrid)
         'IF eax THEN   ' check me
         IF pGrid THEN
            tmp = raGridAddRowData(pGrid,(LPBYTE)CBLPARAM)
            exitvalue = raInsertItem(pGrid, CBWPARAM, tmp)
         ELSE
            exitvalue = LB_ERR
         END IF
      ELSE
         exitvalue = LB_ERR
      END IF
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      FUNCTION = exitvalue

      '********************
      CASE GM_DELROW
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      IF (*pGrid).rows THEN
         raDeleteItem(pGrid, CBWPARAM)
      END IF
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      EXIT FUNCTION

      '********************
      CASE GM_MOVEROW
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      IF (CBWPARAM < (*pGrid).rows) AND (CBLPARAM < (*pGrid).rows) THEN
         tmp = raGetItem(pGrid, CBWPARAM)
         raDeleteItem(pGrid, CBWPARAM)
         raInsertItem(pGrid, CBLPARAM,tmp)
      END IF
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      EXIT FUNCTION

      '********************
      CASE GM_COMBOADDSTRING
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      'mov    eax,CBWPARAM
      IF CBWPARAM < (*pGrid).cols THEN
         pCol = (LPCOLUMN)((LPBYTE) pGrid + (SIZEOF(COLUMN) * CBWPARAM) + SIZEOF(GRID))
         IF (*pCol).ctype = TYPE_COMBOBOX THEN
            DIM RAW cnt, idx
            cnt = SendMessage((*pCol).edthwnd,LB_GETCOUNT,0,0)
            idx = SendMessage((*pCol).edthwnd,LB_ADDSTRING,0,CBLPARAM)
            SendMessage((*pCol).edthwnd,LB_SETITEMDATA,idx,cnt)
         END IF
      END IF
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      EXIT FUNCTION

      '********************
      CASE GM_COMBOCLEAR
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      IF CBWPARAM < (*pGrid).cols THEN
         pCol = (LPCOLUMN)((LPBYTE) pGrid + (SIZEOF(COLUMN) * CBWPARAM) + SIZEOF(GRID))
         IF (*pCol).ctype = TYPE_COMBOBOX THEN
            SendMessage((*pCol).edthwnd,LB_RESETCONTENT,0,0)
            InvalidateRect((*pGrid).hlst,NULL,TRUE)
         END IF
      END IF
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      EXIT FUNCTION

      '********************
      CASE GM_GETCURSEL
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      exitvalue = MAKECOLROW((*pGrid).col, (*pGrid).row)
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      FUNCTION = exitvalue

      '********************
      CASE GM_SETCURSEL
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      IF (CBWPARAM < (*pGrid).cols) AND (CBLPARAM < (*pGrid).rows) THEN

         'GOSUB SetNotify
         gn.nmhdr.hwndFrom = CBHWND
         gn.nmhdr.idFrom   = (*pGrid).nid
         gn.nmhdr.code     = GN_BEFORESELCHANGE
         gn.hwnd           = (*pGrid).hedt
         gn.col            = CBWPARAM
         gn.row            = CBLPARAM
         gn.fcancel        = FALSE
         gn.lpdata         = 0
         SendMessage((*pGrid).hpar,WM_NOTIFY,gn.nmhdr.idFrom,&gn)

         IF NOT gn.fcancel THEN
            IF (gn.row < (*pGrid).rows) AND (gn.col < (*pGrid).cols) THEN
               raGetItemRect(pGrid,(*pGrid).row,&rect)
               InvalidateRect((*pGrid).hlst,&rect,TRUE)

               (*pGrid).col = gn.col
               (*pGrid).row = gn.row

               raGetItemRect(pGrid,gn.row,&rect)
               InvalidateRect((*pGrid).hlst,&rect,TRUE)

               SendMessage(CBHWND,GM_SCROLLCELL,0,0)
            END IF

            'GOSUB SetNotify
            gn.nmhdr.hwndFrom = CBHWND
            gn.nmhdr.idFrom   = (*pGrid).nid
            gn.nmhdr.code     = GN_AFTERSELCHANGE
            gn.hwnd           = (*pGrid).hedt
            gn.col            = (*pGrid).col
            gn.row            = (*pGrid).row
            gn.fcancel        = FALSE
            gn.lpdata         = 0
            SendMessage((*pGrid).hpar,WM_NOTIFY,gn.nmhdr.idFrom,&gn)
            exitvalue = 1
         ELSE
            exitvalue = 0
         END IF
      ELSE
         exitvalue = 0
      END IF
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      FUNCTION = exitvalue

      '********************
      CASE GM_GETCURCOL
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))
      exitvalue = (*pGrid).col
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      FUNCTION = exitvalue

      '********************
      CASE GM_SETCURCOL
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))
      exitvalue = SendMessage(CBHWND,GM_SETCURSEL,CBWPARAM,(*pGrid).row)
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      FUNCTION = exitvalue

      '********************
      CASE GM_GETCURROW
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))
      exitvalue = (*pGrid).row
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      FUNCTION = exitvalue

      '********************
      CASE GM_SETCURROW
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))
      exitvalue = SendMessage(CBHWND,GM_SETCURSEL,(*pGrid).col,CBWPARAM)
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      FUNCTION = exitvalue

      '********************
      CASE GM_GETCOLCOUNT
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))
      exitvalue = (*pGrid).cols
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      FUNCTION = exitvalue

      '********************
      CASE GM_GETROWCOUNT
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))
      exitvalue = (*pGrid).rows
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      FUNCTION = exitvalue

      '********************
      CASE GM_GETCELLDATA
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      tmp = raGetItem(pGrid, GETROW(CBWPARAM))
      exitvalue = raGridGetCellData(pGrid, tmp, GETCOL(CBWPARAM), (LPBYTE)CBLPARAM)
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      FUNCTION = exitvalue

      '********************
      CASE GM_SETCELLDATA
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      'GOSUB SetNotify
      gn.nmhdr.hwndFrom = CBHWND
      gn.nmhdr.idFrom   = (*pGrid).nid
      gn.nmhdr.code     = GN_BEFOREUPDATE
      gn.hwnd           = (*pGrid).hedt
      gn.col            = (*pGrid).col
      gn.row            = (*pGrid).row
      gn.fcancel        = FALSE
      gn.lpdata         = (LPVOID)CBLPARAM
      SendMessage((*pGrid).hpar,WM_NOTIFY,gn.nmhdr.idFrom,&gn)

      IF NOT gn.fcancel THEN
         tmp = raGetItem(pGrid, GETROW(CBWPARAM))
         raGridSetCellData(pGrid, tmp, GETCOL(CBWPARAM), (LPBYTE)CBLPARAM)
         raGetItemRect(pGrid, GETROW(CBWPARAM), &rect)
         InvalidateRect((*pGrid).hlst,&rect,TRUE)

         gn.nmhdr.code = GN_AFTERUPDATE
         SendMessage((*pGrid).hpar,WM_NOTIFY,gn.nmhdr.idFrom,&gn)
      END IF
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      EXIT FUNCTION

      '********************
      CASE GM_GETCELLRECT
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      rect.left   = 0
      rect.top    = 0
      rect.right  = 0
      rect.bottom = 0

      tmp = GETCOL(CBWPARAM)
      IF tmp < (*pGrid).cols THEN
         pCol = (LPCOLUMN)((LPBYTE) pGrid + SIZEOF(GRID) + (tmp * SIZEOF(COLUMN)))
         IF GETROW(CBWPARAM) < (*pGrid).rows THEN
            raGetItemRect(pGrid,GETROW(CBWPARAM),&rect)
            rect.left = (*pCol).colxp - (*pGrid).sbx
            rect.right= rect.left + (*pCol).colwt
         END IF
      END IF
      CopyRect((LPRECT)CBLPARAM,&rect)
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      EXIT FUNCTION

      '********************
      CASE GM_SCROLLCELL
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      GetClientRect((*pGrid).hlst,&rect1)
      IF rect1.right AND rect1.bottom THEN
         SendMessage(CBHWND, GM_GETCELLRECT, MAKECOLROW((*pGrid).col,(*pGrid).row), &rect)
         IF rect.top < 0 THEN
            (*pGrid).toprow = (*pGrid).row
            InvalidateRect((*pGrid).hlst,NULL,TRUE)
         ELSE
            tmp = rect.bottom
            IF tmp > rect1.bottom THEN
               tmp -= rect1.bottom
               tmp = tmp / (*pGrid).rowht
               INCR tmp
               (*pGrid).toprow += tmp
               InvalidateRect((*pGrid).hlst,NULL,TRUE)
            END IF
         END IF
         IF rect.left < 0 THEN
            (*pGrid).sbx += rect.left
            ScrollWindow(CBHWND,-rect.left,0,NULL,NULL)
         ELSE
            GetClientRect(CBHWND,&rect1)
            tmp = rect.right
            IF rect.right > rect1.right THEN
               tmp -= rect1.right

               IF rect.left < (tmp + (*pGrid).sbx) THEN
                  tmp = rect.left
                  (*pGrid).sbx += rect.left
               ELSE
                  (*pGrid).sbx += tmp
               END IF

               ScrollWindow(CBHWND,-tmp,0,NULL,NULL)
            END IF
         END IF
         raSetScroll(CBHWND, pGrid, &sinf)
      ELSE
         (*pGrid).toprow = 0
         InvalidateRect((*pGrid).hlst,NULL,TRUE)
      END IF
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      EXIT FUNCTION

      '********************
      CASE GM_GETBACKCOLOR
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))
      exitvalue = (*pGrid).colback
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      FUNCTION = exitvalue

      '********************
      CASE GM_SETBACKCOLOR
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))
      IF (*pGrid).hbrback <> (HBRUSH)(COLOR_WINDOW+1) THEN
         DeleteObject((*pGrid).hbrback)
      END IF
      (*pGrid).colback = CBWPARAM
      (*pGrid).hbrback = CreateSolidBrush(CBWPARAM)
      InvalidateRect((*pGrid).hlst,NULL,TRUE)
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      EXIT FUNCTION

      '********************
      CASE GM_GETGRIDCOLOR
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))
      exitvalue = (*pGrid).colgrid
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      FUNCTION = exitvalue

      '********************
      CASE GM_SETGRIDCOLOR
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))
      DeleteObject((*pGrid).hpengrd)
      (*pGrid).colgrid = CBWPARAM
      (*pGrid).hpengrd = CreatePen(PS_SOLID,1,CBWPARAM)
      InvalidateRect((*pGrid).hlst,NULL,TRUE)
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      EXIT FUNCTION

      '********************
      CASE GM_GETTEXTCOLOR
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))
      exitvalue = (*pGrid).coltext
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      FUNCTION = exitvalue

      '********************
      CASE GM_SETTEXTCOLOR
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))
      (*pGrid).coltext = CBWPARAM
      InvalidateRect((*pGrid).hlst,NULL,TRUE)
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      EXIT FUNCTION

      '********************
      CASE GM_SETROWHIGHLIGHTCLR
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))
      (*pGrid).style = GetWindowLong(CBHWND,GWL_STYLE)
      IF NOT CBWPARAM THEN
         (*pGrid).style = (*pGrid).style BOR STYLE_NOSEL
      ELSE
         (*pGrid).colhilite = CBWPARAM
         (*pGrid).style = (*pGrid).style BAND (~STYLE_NOSEL)
      END IF
      SetWindowLong(CBHWND, GWL_STYLE, (*pGrid).style )
      InvalidateRect((*pGrid).hlst,NULL,TRUE)
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      EXIT FUNCTION

      '********************
      CASE GM_GETCOLUMNCOLOR
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      IF CBWPARAM < (*pGrid).cols THEN
         pCol = (LPCOLUMN)((LPBYTE)pGrid + SIZEOF(GRID) + (CBWPARAM * SIZEOF(COLUMN)))

         IF CBLPARAM THEN
            *(LPCOLUMNCOLOR)CBLPARAM = (*pCol).ColumnColor
         END IF
      END IF
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      EXIT FUNCTION

      '********************
      CASE GM_SETCOLUMNCOLOR
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      IF CBWPARAM < (*pGrid).cols THEN
         pCol = (LPCOLUMN)((LPBYTE)pGrid + SIZEOF(GRID) + (CBWPARAM * SIZEOF(COLUMN)))

         IF CBLPARAM THEN
            (*pCol).ColumnColor = *(LPCOLUMNCOLOR)CBLPARAM
         ELSE
            (*pCol).ColumnColor.backcolor = -1
            (*pCol).ColumnColor.textcolor = -1
         END IF
         InvalidateRect((*pGrid).hlst,NULL,TRUE)
      END IF
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      EXIT FUNCTION

      '********************
      CASE GM_ENTEREDIT
      '********************

      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      fCancelEdit = FALSE
      IF (*pGrid).hedt THEN
         ShowWindow((*pGrid).hedt,SW_HIDE)
         (*pGrid).hedt = 0
      END IF

      IF (*pGrid).rows THEN
         DIM RAW  xypos
         fCancelEdit = FALSE
         SendMessage(CBHWND,GM_SETCURSEL,CBWPARAM,CBLPARAM)
         xypos = MAKECOLROW((*pGrid).col, (*pGrid).row)
         SendMessage(CBHWND,GM_GETCELLDATA,xypos,buffer)
         SendMessage(CBHWND,GM_GETCELLRECT,xypos,&rect)

         pCol = (LPCOLUMN)((LPBYTE) pGrid + (SIZEOF(COLUMN) * (*pGrid).col) + SIZEOF(GRID))
         'GOSUB SetNotify
         gn.nmhdr.hwndFrom = CBHWND
         gn.nmhdr.idFrom   = (*pGrid).nid
         gn.nmhdr.code     = GN_BEFOREEDIT
         gn.hwnd           = (*pCol).edthwnd
         gn.col            = (*pGrid).col
         gn.row            = (*pGrid).row
         gn.fcancel        = FALSE
         gn.lpdata         = buffer
         SendMessage((*pGrid).hpar,WM_NOTIFY,gn.nmhdr.idFrom,&gn)
         exitvalue = 0

         IF NOT gn.fcancel THEN
            IF ((*pCol).edthwnd) AND (((*pCol).ctype <> TYPE_EDITBUTTON) OR NOT fonbtn) THEN
               DIM RAW width, rowhgt
               (*pGrid).edtrowcol = xypos
               SetWindowLong((*pCol).edthwnd, GWL_ID, xypos)
               SendMessage((*pCol).edthwnd,WM_SETFONT,(*pGrid).hfont,FALSE)
               GetClientRect((*pGrid).hlst,&rect1)
               DECR rect.top
               width  = (*pCol).colwt + 1
               rowhgt = (*pGrid).rowht + 1

               SELECT CASE (*pCol).ctype

                  '********************
                  CASE TYPE_EDITTEXT
                  '********************
                  IF GetWindowLong((*pCol).edthwnd, GWL_STYLE) BAND ES_MULTILINE THEN rowhgt*=4
                  MoveWindow((*pCol).edthwnd,(*pCol).colxp,rect.top,width,rowhgt,TRUE)
                  SendMessage((*pCol).edthwnd,WM_SETTEXT,0,buffer)
                  SendMessage((*pCol).edthwnd,EM_SETSEL,0,-1)

                  '********************
                  CASE TYPE_EDITBUTTON
                  '********************
                  MoveWindow((*pCol).edthwnd,(*pCol).colxp,rect.top,width - (*pGrid).rowht,rowhgt,TRUE)
                  SendMessage((*pCol).edthwnd,WM_SETTEXT,0, buffer)
                  SendMessage((*pCol).edthwnd,EM_SETSEL,0,-1)

                  '********************
                  CASE TYPE_EDITLONG
                  '********************
                  MoveWindow((*pCol).edthwnd,(*pCol).colxp,rect.top,width,rowhgt,TRUE)
                  value = *pDword
                  ltoa(value, buffer,10)
                  SendMessage((*pCol).edthwnd,WM_SETTEXT,0, buffer)
                  SendMessage((*pCol).edthwnd,EM_SETSEL,0,-1)

                  '********************
                  CASE TYPE_EDITDOUBLE
                  '********************
                  MoveWindow((*pCol).edthwnd,(*pCol).colxp,rect.top,width,rowhgt,TRUE)
                  SendMessage((*pCol).edthwnd,WM_SETTEXT,0, STR$((*(double*)buffer)))
                  SendMessage((*pCol).edthwnd,EM_SETSEL,0,-1)

                  '********************
                  CASE TYPE_COMBOBOX
                  '********************
                  DIM RAW cnt, retval, idx = 0

                  rect.left = (*pCol).colxp
                  rect.top += rowhgt + 1
                  GetClientRect(GetDesktopWindow(),&rect1)
                  ScreenToClient((*pGrid).hgrd, (LPPOINT)&rect1.right)
                  cnt    = SendMessage((*pCol).edthwnd,LB_GETCOUNT,0,0)
                  rowhgt = SendMessage((*pCol).edthwnd,LB_GETITEMHEIGHT,0,0)
                  IF cnt > 10 THEN
                     cnt = 10
                  ELSEIF NOT cnt THEN
                     cnt = 1
                  END IF
                  rowhgt = (rowhgt * cnt) + 2

                  IF (rowhgt + rect.top + (*pGrid).rowht + 1) > rect1.bottom THEN
                     rect.top -= rowhgt
                     rect.top -= ((*pGrid).rowht + 1)
                  END IF

                  ClientToScreen((*pGrid).hlst, (LPPOINT)&rect)
                  MoveWindow((*pCol).edthwnd,rect.left,rect.top,width,rowhgt,TRUE)

                  WHILE TRUE
                     retval = SendMessage((*pCol).edthwnd,LB_GETITEMDATA,idx,0)
                     IF retval = *(DWORD*)buffer OR retval = LB_ERR THEN EXIT WHILE
                     INCR idx
                  WEND
                  IF retval <> LB_ERR THEN
                     SendMessage((*pCol).edthwnd,LB_SETCURSEL,idx,0)
                  END IF

                  '********************
                  CASE TYPE_HOTKEY
                  '********************
                  MoveWindow((*pCol).edthwnd,(*pCol).colxp,rect.top,width,rowhgt,TRUE)
                  SendMessage((*pCol).edthwnd,HKM_SETHOTKEY,*pDword,0)

                  '********************
                  CASE TYPE_DATE
                  '********************
                  MoveWindow((*pCol).edthwnd,(*pCol).colxp,rect.top,width,rowhgt,TRUE)
                  'Days since 01.01.1601
                  'Convert to number of 100 nano seconds since 01.01.1601
                  ft.QuadPart = (*pDword) * SYSTICK_2_DAYS
                  FileTimeToSystemTime((FILETIME*)&ft,&stime)
                  SendMessage((*pCol).edthwnd,DTM_SETSYSTEMTIME,0,&stime)

                  '********************
                  CASE TYPE_TIME
                  '********************
                  MoveWindow((*pCol).edthwnd,(*pCol).colxp,rect.top,width,rowhgt,TRUE)
                  DIM RAW seconds AS DWORD
                  seconds = *pDword
                  stime.wYear      = 2000
                  stime.wMonth     = 1
                  stime.wDayOfWeek = 6
                  stime.wDay       = 1
                  stime.wSecond    = IMOD(seconds, 60)
                  seconds          = seconds / 60
                  stime.wMinute    = IMOD(seconds, 60)
                  stime.wHour      = seconds / 60
                  stime.wMilliseconds = 0

                  SendMessage((*pCol).edthwnd,DTM_SETSYSTEMTIME,0,&stime)

                  '********************
                  CASE TYPE_USER
                  '********************
                  MoveWindow((*pCol).edthwnd,(*pCol).colxp,rect.top,width,rowhgt,TRUE)
                  'Added for user string types
                  IF (*pCol).ctextmax = 0 THEN
                     IF GetWindowLong((*pCol).edthwnd, GWL_STYLE) BAND ES_MULTILINE THEN rowhgt*=4
                     SendMessage((*pCol).edthwnd,WM_SETTEXT,0,buffer)
                     SendMessage((*pCol).edthwnd,EM_SETSEL,0,-1)
                  END IF


               END SELECT

               ShowWindow((*pCol).edthwnd,SW_SHOW)
               SetFocus((*pCol).edthwnd)
               exitvalue = (integer)(*pCol).edthwnd

            ELSE

               SELECT CASE (*pCol).ctype

                  '********************
                  CASE TYPE_CHECKBOX
                  '********************
                  'GOSUB SetNotify
                  gn.nmhdr.hwndFrom = CBHWND
                  gn.nmhdr.idFrom   =       (*pGrid).nid
                  gn.nmhdr.code     = GN_CHECKCLICK
                  gn.hwnd           = (*pGrid).hedt
                  gn.col            = GETCOL(xypos)
                  gn.row            = GETROW(xypos)
                  gn.fcancel        = FALSE
                  gn.lpdata         = buffer
                  SendMessage((*pGrid).hpar,WM_NOTIFY,gn.nmhdr.idFrom,&gn)

                  IF NOT gn.fcancel THEN
                     SendMessage(CBHWND,GM_ENDEDIT,xypos,FALSE)
                     InvalidateRect((*pGrid).hlst,&rect,TRUE)
                  END IF

                  '********************
                  CASE TYPE_IMAGE
                  '********************
                  'GOSUB SetNotify
                  gn.nmhdr.hwndFrom = CBHWND
                  gn.nmhdr.idFrom   = (*pGrid).nid
                  gn.nmhdr.code     = GN_IMAGECLICK
                  gn.col            = GETCOL(xypos)
                  gn.row            = GETROW(xypos)
                  gn.fcancel        = FALSE
                  gn.hwnd           = (HWND)(*pCol).himl ' check me
                  gn.lpdata         = buffer
                  SendMessage((*pGrid).hpar,WM_NOTIFY,gn.nmhdr.idFrom,&gn)

                  '********************
                  CASE TYPE_BUTTON, TYPE_EDITBUTTON
                  '********************
                  'GOSUB SetNotify
                  gn.nmhdr.hwndFrom = CBHWND
                  gn.nmhdr.idFrom   = (*pGrid).nid
                  gn.nmhdr.code     = GN_BUTTONCLICK
                  gn.hwnd           = (*pGrid).hedt
                  gn.col            = GETCOL(xypos)
                  gn.row            = GETROW(xypos)
                  gn.fcancel        = FALSE
                  gn.lpdata         = buffer
                  SendMessage((*pGrid).hpar,WM_NOTIFY,gn.nmhdr.idFrom,&gn)

                  IF NOT gn.fcancel THEN
                     (*pGrid).hedt = (HWND)-1
                     (*pGrid).lpdata = (LPBYTE)buffer
                     SendMessage(CBHWND,GM_ENDEDIT,xypos,FALSE)
                     InvalidateRect((*pGrid).hlst,&rect,TRUE)
                  END IF

               END SELECT
               exitvalue = 0

            END IF
         END IF
      END IF
      (*pGrid).hedt = (HWND)exitvalue
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      FUNCTION = exitvalue

      '********************
      CASE GM_ENDEDIT
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))
      pCol = (LPCOLUMN)((LPBYTE) pGrid + (GETCOL(CBWPARAM) * SIZEOF(COLUMN)) + SIZEOF(GRID))
      *pDword = 0

      IF ((*pCol).edthwnd = (*pGrid).hedt) OR ((*pGrid).hedt = (HWND)-1) THEN
         IF NOT CBLPARAM THEN
            IF (*pGrid).hedt AND (*pGrid).hedt <> (HWND)-1 THEN

               SELECT CASE (*pCol).ctype

                  '********************
                  CASE TYPE_EDITTEXT, TYPE_EDITBUTTON
                  '********************
                  SendMessage((*pGrid).hedt,WM_GETTEXT,SIZEOF(buffer),buffer)

                  '********************
                  CASE TYPE_EDITLONG
                  '********************
                  SendMessage((*pGrid).hedt,WM_GETTEXT,SIZEOF(buffer),buffer)
                  value = VAL(buffer)
                  *pDword = value

                  '********************
                  CASE TYPE_EDITDOUBLE
                  '********************
                  SendMessage((*pGrid).hedt,WM_GETTEXT,SIZEOF(buffer),buffer)
                  dvalue = VAL(buffer)
                  *((double*)buffer) = dvalue

                  '********************
                  CASE TYPE_COMBOBOX
                  '********************
                  DIM RAW cursel
                  cursel = SendMessage((*pGrid).hedt,LB_GETCURSEL,0,0)
                  *pDword = SendMessage((*pGrid).hedt,LB_GETITEMDATA,cursel,0)

                  '********************
                  CASE TYPE_HOTKEY
                  '********************
                  *pDword = SendMessage((*pGrid).hedt,HKM_GETHOTKEY,0,0)

                  '********************
                  CASE TYPE_DATE
                  '********************
                  SendMessage((*pGrid).hedt,DTM_GETSYSTEMTIME,0,&stime)
                  SystemTimeToFileTime(&stime, (FILETIME*)&ft)
                  'Convert to days since 01.01.1601
                  ft.QuadPart /= SYSTICK_2_DAYS
                  *pDword = ft.LowPart

                  '********************
                  CASE TYPE_TIME
                  '********************
                  SendMessage((*pGrid).hedt,DTM_GETSYSTEMTIME,0,&stime)
                  DIM RAW seconds AS DWORD
                  seconds = (stime.wHour * 60) + stime.wMinute
                  seconds = (seconds * 60) + stime.wSecond
                  *pDword = seconds

                  '********************
                  CASE TYPE_USER
                  '********************
                  'Added for use with user string types
                  IF NOT (*pCol).ctextmax THEN
                     SendMessage((*pGrid).hedt,WM_GETTEXT,SIZEOF(buffer),buffer)
                  END IF

               END SELECT

            ELSE

               IF (*pCol).ctype = TYPE_CHECKBOX THEN
                  SendMessage(CBHWND,GM_GETCELLDATA,CBWPARAM,buffer)
                  *pDword = (*pDword BAND 1) XOR 1
               ELSEIF (*pCol).ctype = TYPE_BUTTON OR (*pCol).ctype = TYPE_EDITBUTTON THEN
                  strcpy(buffer, (LPSTR)(*pGrid).lpdata)
               END IF
            END IF

            'GOSUB SetNotify
            gn.nmhdr.hwndFrom = CBHWND
            gn.nmhdr.idFrom   = (*pGrid).nid
            gn.nmhdr.code     = GN_AFTEREDIT
            gn.hwnd           = (*pCol).edthwnd
            gn.col            = GETCOL(CBWPARAM)
            gn.row            = GETROW(CBWPARAM)
            gn.fcancel        = FALSE
            gn.lpdata         = buffer
            SendMessage((*pGrid).hpar,WM_NOTIFY,gn.nmhdr.idFrom,&gn)

            IF NOT gn.fcancel THEN
               SendMessage(CBHWND,GM_SETCELLDATA,CBWPARAM, buffer)
               IF (*pGrid).hedt THEN
                  ShowWindow((*pGrid).hedt,SW_HIDE)
                  (*pGrid).hedt = 0
               END IF
            END IF
         ELSE
            fCancelEdit = TRUE
            IF (*pGrid).hedt THEN
               ShowWindow((*pGrid).hedt,SW_HIDE)
               (*pGrid).hedt = 0
            END IF
            fCancelEdit = FALSE
         END IF
      END IF
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      EXIT FUNCTION

      '********************
      CASE GM_GETCOLWIDTH
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      'mov    eax,CBWPARAM
      IF CBWPARAM < (*pGrid).cols THEN
         pCol = (LPCOLUMN)((LPBYTE) pGrid + ( SIZEOF(COLUMN) * CBWPARAM) + SIZEOF(GRID))
         exitvalue = (*pCol).colwt
      ELSE
         exitvalue = 0
      END IF
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      FUNCTION = exitvalue

      '********************
      CASE GM_AUTOSETCOLWIDTH
      '********************
      DIM RAW s AS SIZE, i, ii, szmax = 0
      DIM RAW pbuf AS LPSTR

      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))
      pCol = (LPCOLUMN)((LPBYTE) pGrid + ( SIZEOF(COLUMN) * CBWPARAM) + SIZEOF(GRID))

      SELECT CASE (*pCol).ctype

         CASE TYPE_EDITTEXT, TYPE_EDITBUTTON, TYPE_BUTTON
         FOR i = 0 TO (*pGrid).rows - 1
            tmp = raGetItem(pGrid, i)
            raGridGetCellData(pGrid, tmp, CBWPARAM, (LPBYTE)buffer)
            pbuf = buffer
            DO
               ii = INCHR(pbuf$, LF$)
               IF ii THEN pbuf[ii-1] = 0
               s = *GETTEXTSIZE(pbuf, CBHWND)
               IF s.cx > szmax THEN szmax = s.cx
               pbuf = pbuf + ii
            LOOP WHILE ii
         NEXT i

         CASE TYPE_EDITLONG
         DIM RAW number
         FOR i = 0 TO (*pGrid).rows - 1
            tmp = raGetItem(pGrid, i)
            raGridGetCellData(pGrid, tmp, CBWPARAM, (LPBYTE)&number)
            IF number < 0 THEN number = -number
            IF number > szmax THEN szmax = number
         NEXT i
         s = *GETTEXTSIZE(STRING$(LEN(STR$(-szmax)), ASC("0")), CBHWND)
         szmax = s.cx

         CASE TYPE_EDITDOUBLE
         DIM RAW szmaxd# = 0
         FOR i = 0 TO (*pGrid).rows - 1
            tmp = raGetItem(pGrid, i)
            raGridGetCellData(pGrid, tmp, CBWPARAM, (LPBYTE)&dvalue)
            IF dvalue < 0 THEN dvalue = -dvalue
            IF dvalue > szmaxd THEN szmaxd = dvalue
         NEXT i

         IF (*pCol).lpszformat THEN
            'Format:
            raGridGetText(pGrid,(*pCol).rpszformat,&buffer[MAXBUFFSIZE-64])
            buffer$ = USING$(&buffer[MAXBUFFSIZE-64], -szmaxd)
         ELSE
            buffer$ = STR$(-szmaxd)
         END IF
         s = *GETTEXTSIZE(buffer$, CBHWND)
         szmax = s.cx
         CASE ELSE
         'Catch all the others for now and just use the header text
         'for the size until myself or someone else finishes them.
         IF CBLPARAM THEN szmax = 8
      END SELECT

      IF szmax THEN
         szmax += 8          '**RC 1/2/09 Add padding up front
         '**RC 1/3 Account for Header text width if lParam <> 0 ******************
         IF CBLPARAM THEN
            IF (*pCol).lpszhdrtext THEN
               pbuf = buffer
               raGridGetText(pGrid,(*pCol).rpszhdrtext, pbuf)
               s = *GETTEXTSIZE(pbuf, (*pGrid).hhdr, (*pGrid).hfont)
               ii = s.cx
               ii+=8    'add padding
               IF ii > szmax THEN
                  szmax = ii
               ENDIF
            END IF
         END IF
         SNDMSG(CBHWND, GM_SETCOLWIDTH, CBWPARAM, szmax)
      END IF
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      EXIT FUNCTION

      '********************
      CASE GM_SETCOLWIDTH
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      IF CBWPARAM < (*pGrid).cols THEN
         pCol = (LPCOLUMN)((LPBYTE) pGrid + ( SIZEOF(COLUMN) * CBWPARAM) + SIZEOF(GRID))
         (*pCol).colwt = CBLPARAM
         tmp = (*pCol).colxp

         WHILE CBWPARAM < (*pGrid).cols
            (*pCol).colxp = tmp
            tmp += (*pCol).colwt
            pCol = (LPCOLUMN)((LPBYTE)pCol + SIZEOF(COLUMN))
            INCR CBWPARAM
         WEND
         (*pGrid).ccx = tmp
         SendMessage(CBHWND,WM_SIZE,0,0)
         InvalidateRect((*pGrid).hhdr,NULL,TRUE)
         InvalidateRect((*pGrid).hlst,NULL,TRUE)
      END IF
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      EXIT FUNCTION

      '********************
      CASE GM_GETHDRHEIGHT
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))
      exitvalue = (*pGrid).hdrht
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      FUNCTION = exitvalue

      '********************
      CASE GM_SETHDRHEIGHT
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))
      (*pGrid).hdrht = CBLPARAM
      SendMessage(CBHWND,WM_SIZE,0,0)
      InvalidateRect((*pGrid).hhdr,NULL,TRUE)
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      EXIT FUNCTION

      '********************
      CASE GM_GETROWHEIGHT
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))
      exitvalue = (*pGrid).rowht
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      FUNCTION = exitvalue

      '********************
      CASE GM_SETROWHEIGHT
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      IF CBLPARAM THEN
         (*pGrid).rowht = CBLPARAM
         SendMessage(CBHWND,WM_SIZE,0,0)
         InvalidateRect((*pGrid).hlst,NULL,TRUE)
      END IF
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      EXIT FUNCTION

      '********************
      CASE GM_RESETCONTENT
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      DIM RAW pdata AS LPSTR, psave AS LPSTR
      pdata = (LPSTR)GlobalAlloc(GMEM_FIXED BOR GMEM_ZEROINIT,1024*32)
      psave = pdata
      DIM RAW colcnt = 0
      WHILE colcnt < (*pGrid).cols
         pCol = (LPCOLUMN)((LPBYTE) pGrid + SIZEOF(GRID) + (colcnt * SIZEOF(COLUMN)))

         IF (*pCol).lpszhdrtext THEN
            raGridGetText(pGrid,(*pCol).rpszhdrtext,pdata)
            pdata = pdata + LEN(pdata) + 1
         END IF

         IF (*pCol).lpszformat THEN
            raGridGetText(pGrid,(*pCol).rpszformat,pdata)
            pdata = pdata + LEN(pdata) + 1
         END IF
         INCR colcnt
      WEND
      raShowHide((*pGrid).hgrd,FALSE)
      IF (*pGrid).hmem THEN
         GlobalFree((*pGrid).hmem)
         IF (*pGrid).hstr THEN
            GlobalFree((*pGrid).hstr)
         END IF
         (*pGrid).toprow    = 0
         (*pGrid).hmem      = 0
         (*pGrid).rpmemfree = 0
         (*pGrid).memsize   = 0
         (*pGrid).col       = 0
         (*pGrid).row       = 0
         (*pGrid).rows      = 0
         (*pGrid).hstr      = 0
         (*pGrid).rpstrfree = 0
         (*pGrid).strsize   = 0
      END IF

      colcnt = 0
      pdata = psave
      WHILE colcnt < (*pGrid).cols
         pCol = (LPCOLUMN)((LPBYTE) pGrid + SIZEOF(GRID) + (colcnt * SIZEOF(COLUMN)))
         IF (*pCol).lpszhdrtext THEN
            (*pCol).rpszhdrtext = raGridAddText(pGrid,pdata)
            pdata = pdata + LEN(pdata) + 1
         END IF

         IF (*pCol).lpszformat THEN
            (*pCol).rpszformat = raGridAddText(pGrid,pdata)
            pdata = pdata + LEN(pdata) + 1
         END IF
         INCR colcnt
      WEND
      SendMessage(CBHWND,WM_SIZE,0,0)
      InvalidateRect((*pGrid).hlst,NULL,TRUE)
      GlobalFree(psave)
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      EXIT FUNCTION

      '********************
      CASE GM_GETBLOCKSELECT
      '********************
      DIM RAW RetVal = 0
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      IF (CBWPARAM) AND (CBLPARAM) THEN
         IF GETROW((*pGrid).XYBlkSelStart) <= GETROW((*pGrid).XYBlkSelEnd) THEN
            *(DWORD*)CBWPARAM = (*pGrid).XYBlkSelStart
            *(DWORD*)CBLPARAM = (*pGrid).XYBlkSelEnd
            RetVal = 1
         END IF
      END IF
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      FUNCTION = RetVal

      '********************
      CASE GM_COLUMNSORT
      '********************
      DIM AUTO GS AS GRIDSORT
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      raShowHide((*pGrid).hgrd,FALSE)

      GS.Column  = CBWPARAM
      GS.SortDir = CBLPARAM

      IF (*pGrid).rows > 1 THEN
         IF GS.Column < (*pGrid).cols THEN
            raGridSortColumn(pGrid, &GS)
            InvalidateRect((*pGrid).hlst,NULL,TRUE)
         END IF
      END IF
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      EXIT FUNCTION

      '********************
      CASE GM_COLUMNSORTEX
      '********************
      DIM RAW pGS = (LPGRIDSORT)CBWPARAM AS LPGRIDSORT
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      raShowHide((*pGrid).hgrd,FALSE)

      IF (*pGrid).rows > 1 THEN
         IF pGS->Column < (*pGrid).cols THEN
            raGridSortColumn(pGrid, pGS)
            InvalidateRect((*pGrid).hlst,NULL,TRUE)
         END IF
      END IF
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      EXIT FUNCTION

      '********************
      CASE GM_GETHDRTEXT
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      IF CBWPARAM < (*pGrid).cols THEN
         pCol = (LPCOLUMN)((LPBYTE) pGrid + SIZEOF(GRID) + (CBWPARAM * SIZEOF(COLUMN)))

         IF (*pCol).lpszhdrtext THEN
            raGridGetText(pGrid,(*pCol).rpszhdrtext, (LPSTR)CBLPARAM)
         END IF
         exitvalue = (HRESULT)(*pCol).lpszhdrtext
      ELSE
         exitvalue = 0
      END IF
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      FUNCTION = exitvalue

      '********************
      CASE GM_SETHDRTEXT
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      IF CBWPARAM < (*pGrid).cols THEN
         pCol = (LPCOLUMN)((LPBYTE)pGrid + SIZEOF(GRID) + (CBWPARAM * SIZEOF(COLUMN)))

         (*pCol).lpszhdrtext = 0
         IF CBLPARAM THEN
            (*pCol).rpszhdrtext = raGridAddText(pGrid, (LPSTR)CBLPARAM)
         END IF
         InvalidateRect((*pGrid).hhdr,NULL,TRUE)
      END IF
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      EXIT FUNCTION

      '********************
      CASE GM_GETCOLFORMAT
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      IF CBWPARAM < (*pGrid).cols THEN
         pCol = (LPCOLUMN)((LPBYTE)pGrid + SIZEOF(GRID) + (CBWPARAM * SIZEOF(COLUMN)))
         IF (*pCol).lpszformat THEN
            raGridGetText(pGrid,(*pCol).rpszformat, (LPSTR)CBLPARAM)
         END IF
      ELSE
         exitvalue = 0
      END IF
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      FUNCTION = exitvalue

      '********************
      CASE GM_SETCOLFORMAT
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      IF CBWPARAM < (*pGrid).cols THEN
         pCol = (LPCOLUMN)((LPBYTE)pGrid + SIZEOF(GRID) + (CBWPARAM * SIZEOF(COLUMN)))
         (*pCol).lpszformat = 0
         IF CBLPARAM THEN
            (*pCol).rpszformat = raGridAddText(pGrid, (LPSTR)CBLPARAM)
         END IF
         InvalidateRect((*pGrid).hlst,NULL,TRUE)
      END IF
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      EXIT FUNCTION

      '********************
      CASE GM_CELLCONVERT
      '********************
      *((LPSTR)CBLPARAM) = 0
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      IF GETCOL(CBWPARAM) < (*pGrid).cols THEN
         pCol = (LPCOLUMN)((LPBYTE)pGrid + SIZEOF(GRID) + (GETCOL(CBWPARAM) * SIZEOF(COLUMN)))

         IF (*pCol).ctype = TYPE_EDITTEXT OR (*pCol).ctype = TYPE_BUTTON OR (*pCol).ctype = TYPE_EDITBUTTON THEN
            SendMessage(CBHWND,GM_GETCELLDATA,CBWPARAM,CBLPARAM)
         ELSEIF (*pCol).ctype = TYPE_EDITLONG OR (*pCol).ctype = TYPE_IMAGE THEN
            SendMessage(CBHWND,GM_GETCELLDATA,CBWPARAM,&value)
            ltoa(value,(LPSTR)CBLPARAM, 10)
         ELSEIF (*pCol).ctype = TYPE_EDITDOUBLE THEN
            SendMessage(CBHWND,GM_GETCELLDATA,CBWPARAM,&dvalue)
            strcpy((LPSTR)CBLPARAM, STR$(dvalue))
         ELSEIF (*pCol).ctype = TYPE_CHECKBOX THEN
            SendMessage(CBHWND,GM_GETCELLDATA,CBWPARAM,&value)
            IF value THEN
               'mov   eax,'seY'
               strcpy((LPSTR)CBLPARAM, "Yes")
            ELSE
               'mov   eax,'oN'
               strcpy((LPSTR)CBLPARAM, "No")
            END IF
         ELSEIF (*pCol).ctype = TYPE_COMBOBOX THEN
            SendMessage(CBHWND,GM_GETCELLDATA,CBWPARAM,&value)
            DIM RAW idx = 0
            WHILE TRUE
               tmp = SendMessage((*pCol).edthwnd,LB_GETITEMDATA,idx,0)
               IF tmp = value OR tmp = LB_ERR THEN EXIT WHILE
               INCR idx
            WEND
            IF tmp <> LB_ERR THEN
               SendMessage((*pCol).edthwnd,LB_GETTEXT,idx,CBLPARAM)
            END IF
         ELSEIF (*pCol).ctype = TYPE_HOTKEY THEN
            SendMessage(CBHWND,GM_GETCELLDATA,CBWPARAM,&value)
            kd$ = HotKeyString(value,(*pCol).lParam)
            lstrcat((LPSTR)CBLPARAM,  kd$)
         ELSEIF (*pCol).ctype = TYPE_DATE THEN
            SendMessage(CBHWND,GM_GETCELLDATA,CBWPARAM,&value)
            'Days since 01.01.1601
            'Convert to number of 100 nano seconds since 01.01.1601
            ft.QuadPart = value * SYSTICK_2_DAYS
            FileTimeToSystemTime((FILETIME*)&ft,&stime)

            IF (*pCol).lpszformat THEN
               raGridGetText(pGrid,(*pCol).rpszformat,&buffer[MAXBUFFSIZE-64])
               GetDateFormat(0,0,&stime,&buffer[MAXBUFFSIZE-64],buffer,SIZEOF(buffer))
            ELSE
               GetDateFormat(0,0,&stime,0, buffer, SIZEOF(buffer))
            END IF
            strcpy((LPSTR)CBLPARAM,buffer)
         ELSEIF (*pCol).ctype = TYPE_TIME THEN
            SendMessage(CBHWND,GM_GETCELLDATA,CBWPARAM,&value)

            stime.wYear      = 2000
            stime.wMonth     = 1
            stime.wDayOfWeek = 6
            stime.wDay       = 1
            stime.wSecond    = IMOD(value, 60)
            value = value / 60
            stime.wMinute    = IMOD(value, 60)
            stime.wHour      = value / 60
            stime.wMilliseconds = 0

            IF (*pCol).lpszformat THEN
               raGridGetText(pGrid,(*pCol).rpszformat,&buffer[MAXBUFFSIZE-64])
               GetTimeFormat(0,0,&stime,&buffer[MAXBUFFSIZE-64],buffer,SIZEOF(buffer))
            ELSE
               GetTimeFormat(0,0,&stime,0,buffer,SIZEOF(buffer))
            END IF
            strcpy((LPSTR)CBLPARAM, buffer)
         ELSEIF (*pCol).ctype = TYPE_USER THEN
            SendMessage(CBHWND,GM_GETCELLDATA, CBWPARAM, buffer)

            'GOSUB SetNotify
            gn.nmhdr.hwndFrom = CBHWND
            gn.nmhdr.idFrom   = (*pGrid).nid
            gn.nmhdr.code     = GN_USERCONVERT
            gn.hwnd           = (*pGrid).hedt
            gn.col            = GETCOL(CBWPARAM)
            gn.row            = GETROW(CBWPARAM)
            gn.fcancel        = FALSE
            gn.lpdata         = buffer
            SendMessage((*pGrid).hpar,WM_NOTIFY,gn.nmhdr.idFrom,&gn)

            IF NOT gn.fcancel THEN
               strcpy((LPSTR)CBLPARAM, buffer)
            END IF
         END IF
      END IF
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      EXIT FUNCTION

      '********************
      CASE GM_RESETCOLUMNS
      '********************
      SendMessage(CBHWND,GM_RESETCONTENT,0,0)
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      pCol = (LPCOLUMN)((LPBYTE) pGrid + SIZEOF(GRID))
      DIM RAW colcnt = (*pGrid).cols
      WHILE colcnt
         IF (*pCol).edthwnd THEN
            DestroyWindow((*pCol).edthwnd)
         END IF
         pCol = (LPCOLUMN)((LPBYTE)pCol + SIZEOF(COLUMN))
         DECR colcnt
      WEND

      (*pGrid).cols = 0
      (*pGrid).ccx = 0
      (*pGrid).sbx = 0
      (*pGrid).rpitemdata = SIZEOF(GRID)
      SendMessage(CBHWND,WM_SIZE,0,0)
      InvalidateRect((*pGrid).hhdr,NULL,TRUE)
      InvalidateRect((*pGrid).hlst,NULL,TRUE)
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      EXIT FUNCTION

      '********************
      CASE GM_GETROWCOLOR
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))
      tmp = raGetItem(pGrid, CBWPARAM)
      raGridGetRowColor(pGrid,tmp,(LPROWCOLOR)CBLPARAM)
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      EXIT FUNCTION

      '********************
      CASE GM_SETROWCOLOR
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))
      IF CBWPARAM < (*pGrid).rows THEN
         tmp = raGetItem(pGrid, CBWPARAM)
         IF NOT CBLPARAM THEN
            DIM RAW rowclr = {-1,-1} AS ROWCOLOR
            raGridSetRowColor(pGrid, tmp, &rowclr)
         ELSE
            raGridSetRowColor(pGrid, tmp,(LPROWCOLOR)CBLPARAM)
         END IF
      END IF
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      EXIT FUNCTION

      '********************
      CASE GM_GETCOLDATA
      '********************
      'CALL GetMem
      pGrid = (LPGRID)GlobalLock((LPVOID)GetWindowLong(CBHWND,0))

      IF CBWPARAM < (*pGrid).cols THEN
         pCol = (LPCOLUMN)((LPBYTE)pGrid + (SIZEOF(COLUMN) * CBWPARAM) + SIZEOF(GRID))
         memcpy((LPVOID)CBLPARAM, pCol, SIZEOF(COLUMN))
         exitvalue = 0
      ELSE
         exitvalue = -1
      END IF
      'CALL RelMem
      GlobalUnlock((LPVOID)GetWindowLong(CBHWND,0))
      FUNCTION = exitvalue

      '********************
      CASE WM_USER+9999
      '********************
      DIM RAW col AS COLUMN
      col.colwt      = 100
      col.lpszhdrtext = szToolTip
      col.halign     = 0
      col.calign     = 0
      col.ctype      = 0
      col.ctextmax   = 31
      col.lpszformat = 0
      col.himl       = 0
      col.hdrflag    = 0
      col.colxp      = 0
      col.edthwnd    = 0
      SendMessage(CBHWND,GM_ADDCOL,0,&col)
      value = (dword)szToolTip
      SendMessage(CBHWND,GM_ADDROW,0,value)
   END SELECT

   FUNCTION = DefWindowProc(CBHWND,CBMSG,CBWPARAM,CBLPARAM)
END FUNCTION
' RAGridProc endp


SUB raDrawItemText(pCol AS LPCOLUMN, mDC AS HDC, buff$, BYREF rect2 AS RECT)
   DIM RAW temp

   rect2.left  += 3
   rect2.top   += 2
   rect2.right -= 3
   temp = (*pCol).calign
   IF temp = GA_ALIGN_LEFT THEN
      temp = DT_LEFT OR DT_NOPREFIX
   ELSEIF temp = GA_ALIGN_CENTER THEN
      temp = DT_CENTER OR DT_NOPREFIX
   ELSE
      temp = DT_RIGHT OR DT_NOPREFIX
   END IF
   DrawText(mDC, buff, LEN(buff), &rect2, temp)
   rect2.left  -= 3
   rect2.top   -= 2
   rect2.right += 3

END SUB


SUB raDrawItemLine(pGrid AS LPGRID, mDC AS HDC, curcol, BYREF rect2 AS RECT)
   DIM RAW tmpcol
   tmpcol = curcol + 1
   tmpcol -= (*pGrid).cols

   IF  NOT ((*pGrid).style BAND STYLE_GRIDFRAME) THEN
      DECR tmpcol
   END IF

   IF ((*pGrid).style BAND STYLE_VGRIDLINES) OR NOT tmpcol THEN
      MoveToEx(mDC,rect2.right,rect2.top,NULL)
      LineTo(mDC,rect2.right,rect2.bottom)
   END IF

END SUB


'--------------------------------------------------------------------------------
'Create a windowclass for the user control
'--------------------------------------------------------------------------------

FUNCTION BCX_raGrid OPTIONAL( hWnd AS HWND, Id, _
   xPos, yPos, width, height, style=0, exstyle=0) AS HWND

   STATIC wc AS WNDCLASSEX

   IF NOT wc.cbSize THEN

      wc.cbSize        = SIZEOF(WNDCLASSEX)
      wc.style         = CS_HREDRAW OR CS_VREDRAW
      wc.lpfnWndProc   = RAGridProc
      wc.cbClsExtra    = 0
      wc.cbWndExtra    = 4 'Holds memory handle
      wc.hInstance     = BCX_HINSTANCE
      wc.hbrBackground = NULL
      wc.lpszMenuName  = NULL
      wc.lpszClassName = szRAGridClass
      wc.hIcon         = NULL
      wc.hIconSm       = NULL
      wc.hCursor       = LoadCursor(NULL, IDC_ARROW)
      RegisterClassEx(&wc)

      wc.style         = CS_HREDRAW OR CS_VREDRAW OR CS_DBLCLKS
      wc.lpfnWndProc   = RAListProc
      wc.lpszClassName = szRAListClass
      RegisterClassEx(&wc)
   END IF

   IF NOT style THEN
      style = WS_CHILD|WS_VISIBLE|STYLE_HGRIDLINES|STYLE_VGRIDLINES|STYLE_NOSEL|WS_TABSTOP
   END IF

   FUNCTION = CreateWindowEx (exstyle, "RAGrid", "", style, _
   xPos * BCX_SCALEX, yPos * BCX_SCALEY, width * BCX_SCALEX, height * BCX_SCALEX, _
   hWnd, Id, BCX_HINSTANCE, NULL)

END FUNCTION
