'----------------------------------------------------------
' Bcx Mini Form Designer
' Version 1.3 by Mike Henning 2007
'
' Feel free to expand on or utilize any portion
' of the source code.
'
' Adapted from DL's BIDE
'----------------------------------------------------------



MDIGUI NOMAIN, PIXELS, ICON, 102

'BCX_RESOURCE 1 24 "xptheme.xml"

GLOBAL hwndFrame     AS HWND
GLOBAL Form1         AS HWND
GLOBAL hPropCtrl     AS HWND
GLOBAL GriphWnd      AS HWND
GLOBAL toolbox2      AS HWND
GLOBAL hStatus       AS HWND
GLOBAL hToolbar      AS HWND
GLOBAL hCodegen      AS HWND
GLOBAL hCGEdit       AS HWND
GLOBAL MainMenu      AS HMENU
GLOBAL FileMenu      AS HMENU
GLOBAL OptMenu       AS HMENU
GLOBAL CWinMenu      AS HMENU
GLOBAL HelpMenu      AS HMENU

GLOBAL hSizePosStat  AS HWND
GLOBAL GridState     = TRUE
GLOBAL SnapState     = TRUE
GLOBAL SetZorderFlag = FALSE
GLOBAL Version$

GLOBAL MyPlugin[20] AS PLUGIN_INTERFACE
GLOBAL iCount AS Integer    'How many
GLOBAL g_IniFileName$
GLOBAL g_FileSaved
GLOBAL g_LastFileName$

GLOBAL CurIdx                   ' Control currently selected
GLOBAL ControlIndex             ' Number of controls stored
GLOBAL hctl[128] AS CONTROLS    ' Holds our controls - Starts with index of 1
GLOBAL cType                    ' Current control type enabled in the toolbox
GLOBAL NumCopiedControls
GLOBAL SnapSize AS INTEGER

GLOBAL VarInfo AS VARINFO



CONST MoveWindowTo(HW,X,Y)  = SetWindowPos(HW,0,X,Y,0,0,SWP_NOSIZE|SWP_NOACTIVATE|SWP_NOZORDER)
CONST SizeWindow(HW,W,H)    = SetWindowPos(HW,0,0,0,W,H,SWP_NOMOVE|SWP_NOACTIVATE|SWP_NOZORDER)
CONST GetImageListFile(F,W) = ImageList_LoadImage(NULL, F, W, 0, RGB(248, 232, 208), _
IMAGE_BITMAP, LR_CREATEDIBSECTION|LR_LOADFROMFILE)
CONST GetImageListRes(F,W) = ImageList_LoadImage(BCX_HINSTANCE, MAKEINTRESOURCE(F), W, 0, RGB(248, 232, 208), _
IMAGE_BITMAP, LR_CREATEDIBSECTION)

CONST  IDM_NEW       =  1001
CONST  IDM_LOAD      =  1002
CONST  IDM_SAVE      =  1003
CONST  IDM_CGEN      =  1004
CONST  IDM_SNAP      =  1005
CONST  IDM_GRID      =  1006
CONST  IDM_DEL       =  1007
CONST  IDM_SIZE      =  1008
CONST  IDM_ALIGN     =  1009

CONST  IDM_SAVEFILE  =  1010
CONST  IDM_HSTATUS   =  1011
CONST  IDM_HPROPERTY =  1012
CONST  IDM_EXIT      =  1013

CONST  IDM_ALEFT     =  1014
CONST  IDM_ARIGHT    =  1015
CONST  IDM_ATOP      =  1016
CONST  IDM_ABOTTOM   =  1017
CONST  IDM_CTRVERT   =  1018
CONST  IDM_CTRHORZ   =  1019

CONST  IDM_LASTFILE  =  1050
CONST  IDM_TEMPFILE  =  1051

CONST  IDM_CASCADE   =  2001
CONST  IDM_TILEH     =  2002
CONST  IDM_TILEV     =  2003
CONST  IDM_ARRANGE   =  2004
CONST  IDM_RESTORE   =  2005
CONST  IDM_MINWIN    =  2006
CONST  IDM_CLOSE     =  2007
CONST  IDM_HTOOL     =  2008
CONST  IDM_VIEWZ     =  2009
CONST  IDM_SAVEZ     =  2010
CONST  IDM_SNAPS     =  2011  'IDC

CONST  IDM_ABOUT     =  3001

'--------------------------------------------
' Toolset icons - in order of icons in image
'--------------------------------------------
ENUM
   IDC_TB1 =  5000
   IDC_SEL
   IDC_TST
   IDC_USR
   IDC_STC
   IDC_FRM
   IDC_PIC
   IDC_BTN
   IDC_CHK
   IDC_RAD
   IDC_GRP
   IDC_CMB
   IDC_LST
   IDC_EDT
   IDC_HSL
   IDC_VSL
   IDC_ANI
   IDC_RIH
   IDC_PRG
   IDC_UPD
   IDC_LVW
   IDC_TRV
   IDC_TRK
   IDC_BMP
   IDC_ICO
   IDC_DAT
   IDC_CAL
   IDC_IPA
   IDC_GRD
   IDC_INP
   IDC_NUL2
END ENUM

CONST MaxToolTypes = 30

'-----------------------------------------------------
' Macro to convert our command ids to a zero offset.
' This just makes it a little easier on the eyes.
'-----------------------------------------------------
CONST TBZ(A) = (A - IDC_SEL)

'-----------------------------------------------------
' Order that we actually want the TB icons to display
'-----------------------------------------------------
SET TB1Idx[]
   TBZ(IDC_SEL), TBZ(IDC_TST), TBZ(IDC_STC),
   TBZ(IDC_FRM), TBZ(IDC_GRP), TBZ(IDC_BTN),
   TBZ(IDC_BMP), TBZ(IDC_ICO), TBZ(IDC_CHK),
   TBZ(IDC_RAD), TBZ(IDC_RIH), TBZ(IDC_EDT),
   TBZ(IDC_INP), TBZ(IDC_HSL), TBZ(IDC_VSL),
   TBZ(IDC_PIC), TBZ(IDC_ANI), TBZ(IDC_PRG),
   TBZ(IDC_UPD), TBZ(IDC_TRK), TBZ(IDC_DAT),
   TBZ(IDC_CAL), TBZ(IDC_IPA), TBZ(IDC_TRV),
   TBZ(IDC_CMB), TBZ(IDC_LST), TBZ(IDC_LVW),
   TBZ(IDC_GRD), TBZ(IDC_USR), TBZ(IDC_NUL2)
END SET


TYPE ctrlFont
   Font_name[128] AS char
   Font_charset
   Font_weight
   Font_size
   Font_underline
   Font_italic
   Font_strikethrough
   hFnt AS HFONT
END TYPE

TYPE CONTROLS
   hWnd     AS HWND
   rect     AS RECT
   ctype
   disabled
   selected
   zorder
   Group
   UseColor AS BOOL
   forecolor
   backcolor
   font AS ctrlFont
END TYPE


TYPE CTRLCOPY
   CtrlClone AS CONTROLS
   sty       AS DWORD
   extsty    AS DWORD
   caption$
END TYPE


TYPE VARINFO
   DIM curidx AS INTEGER PTR
   DIM controlindex AS INTEGER PTR
   DIM holdctl AS CONTROLS PTR
   DIM copy AS CTRLCOPY PTR
   DIM ControlDesc AS CHAR PTR PTR
   DIM ControlTypes AS CHAR PTR PTR
   DIM Forms AS HWND PTR
   DIM hEdit AS HWND PTR
   FUNCTION EStyleConst() AS CHAR PTR
   FUNCTION GetStyleConst(hwndTarget AS HWND ,hwndStyleList ,hwndExStyleList ,fAllStyles AS BOOL ) AS CHAR PTR
   FUNCTION EEnums() AS CHAR PTR
   FUNCTION EHandles() AS CHAR PTR
   SUB Zorder()' AS SUB
   SUB Savit() 'AS SUB
   SUB SaveBCXCode()
   SUB LoadForm(filename$)
   'Sub ImportBas()
   DIM plgn_ScaleX AS SINGLE PTR
   DIM plgn_ScaleY AS SINGLE PTR
   'FUNCTION AddMenu() AS INTEGER PTR
END TYPE


TYPE FunctionList
   sFuncName$[100] AS CHAR
   FUNCTION PluginFunction(info AS VARINFO PTR) AS Integer
END TYPE


TYPE PluginMenuInfo
   MF AS INTEGER
   PI AS INTEGER
   SL[20] AS CHAR
END TYPE

TYPE PLUGIN_INTERFACE
   sName$[100] AS CHAR
   SUB MakeMenu(i AS HMENU PTR, PID AS INTEGER)
   PlugInMenu AS HMENU
   FunctionCount AS INTEGER
   Flist AS FunctionList PTR PTR
END TYPE

CONST PluginOffset = 20000

$INCLUDE "StyleInfo.inc"
$INCLUDE "PropDialog.inc"
$INCLUDE "BMFD_Ini_File_code.inc"
$INCLUDE "AddColors.inc"
$INCLUDE "Zorder.bas"
$INCLUDE "raGridAdd.inc"

' #########################################################################

FUNCTION WINMAIN
   GLOBAL DYNAMIC CopyControl[1] AS CTRLCOPY  ' Holds copied controls

   DIM RAW rc AS RECT
   DIM IsNewVersion

   g_IniFileName$ = APPEXEPATH$ & "BMFD.ini"
   BMFD_Get_Ini(g_IniFileName$)
   IF VAL(REMOVE$(Version$, CHR$(46))) < 10309 THEN IsNewVersion = true
   Version$      = "1.03.10"
   g_FileSaved = 1
   CALL InitVarInfo()
   CALL LoadPlugins()

   hwndFrame = BCX_FrameWnd( "BMFD", FrameWndProc, "Bcx Mini Form Designer " & Version$, MakeMenu(), 3)
   BCX_MDICLASS( MDIChildWndProc, "MdiChildWndClass")
   BCX_MDICLASS( CodeChildWndProc, "CodeChildWndProc")

   CALL RegisterDragWnd()

   SetRect(&rc, 119,36,695,620)   'Set Default window size & position
   GetWindowFromIni(g_IniFileName$,"Main",hwndFrame,"Window", &rc)
   SHOW(hwndFrame)

   SetClassLong(hwndFrame, GCL_STYLE, CS_OWNDC)

   GetWindowRect(hwndFrame, &rc)
   toolbox2 = BCX_DIALOG(ToolbarControls ,"Controls", hwndFrame, _
   4, 16, 47, 137, WS_POPUPWINDOW|WS_VISIBLE|WS_CAPTION, WS_EX_TOOLWINDOW)
   MoveWindow(toolbox2, 16, rc.top, 101, 340, 1)
   SetRect(&rc, 12,36,113,364)          'Set Default window size & position
   IF NOT IsNewVersion THEN
      GetWindowFromIni(g_IniFileName$,"Controls",toolbox2,"Window", &rc)
   END IF

   Form1 = BCX_MDICHILD("Form1", "MdiChildWndClass")
   SetRect(&rc, 0,0,500,400)              'Set Default window size & position
   GetWindowFromIni(g_IniFileName$,"Form1",Form1,"Window", &rc)

   hPropCtrl = BCX_DIALOG(PropControl, "Control Properties", hwndFrame, _
   260, 0, 117, 195, WS_POPUPWINDOW|WS_VISIBLE|WS_CAPTION, WS_EX_TOOLWINDOW)
   SetRect(&rc, 700,36,945,450)        'Set Default window size & position
   IF NOT IsNewVersion THEN
      GetWindowFromIni(g_IniFileName$,"Properties",hPropCtrl,"Window", &rc)
   END IF

   DIM RAW buf$
   buf$ = REMOVE$(COMMAND$,DQ$)
   IF EXIST(buf$) THEN LoadForm(buf$)

   FUNCTION = BCX_MDI_MsgPump()
END FUNCTION



' #########################################################################

BEGIN MDIEVENTS FrameWndProc

   STATIC rc AS RECT
   STATIC tHeight
   STATIC sHeight

   SELECT CASE CBMSG


      CASE WM_COMMAND
      SELECT CASE wParam

         CASE IDM_NEW
         CALL NewForm

         CASE IDM_SAVE
         CALL SaveForm

         CASE IDM_LOAD
         'Call NewForm to delete the controls on the old form and see if user wants to save
         IF NewForm() <> IDCANCEL THEN
            CALL LoadForm("")
         END IF

         CASE IDM_SAVEFILE
         IF NOT hCodegen THEN
            ' create code generator window
            hCodegen = BCX_MDICHILD("Code Generator", "CodeChildWndProc")
         END IF
         CALL AutoSaveBak()
         CALL CreateFormCode()
         CALL SaveFile
         CALL Saved_OK()

         CASE IDM_LASTFILE
         IF NewForm() <> IDCANCEL THEN
            CALL LoadForm(TRIM$(GetMenuText$(FileMenu, IDM_LASTFILE)))
         END IF

         CASE IDM_TEMPFILE
         IF NewForm() <> IDCANCEL THEN
            CALL LoadForm(TRIM$(GetMenuText$(FileMenu, IDM_TEMPFILE)))
            RemoveMenu(FileMenu, IDM_TEMPFILE, MF_BYCOMMAND)
         END IF

         CASE IDM_GRID
         GridState = NOT GridState
         IF Form1 THEN REFRESH(Form1)

         CASE IDM_SNAP
         SnapState = NOT SnapState
         IF Form1 THEN REFRESH(Form1)

         CASE IDM_DEL
         CALL DeleteControls


         CASE IDM_VIEWZ
         IF SetZorderFlag THEN
            CheckMenuItem(OptMenu, IDM_VIEWZ, MF_BYCOMMAND | MF_UNCHECKED)
            Refresh(Form1)
         ELSE
            CheckMenuItem(OptMenu, IDM_VIEWZ, MF_BYCOMMAND | MF_CHECKED)
            BCX_MDIALOG(ZOrderDialog,"Order Controls - ZOrder", hwndFrame,  74,  48,  174,  132)
            '            CALL SetZorder
            '            cnum = 0
            '            EnumChildWindows(Form1, EnumChildProc, 3)
         END IF

         SetZorderFlag = NOT SetZorderFlag


         CASE IDM_SAVEZ
         cnum = 0
         EnumChildWindows(Form1, EnumChildProc, 4)
         QSORTIDX 0, ControlIndex+1, hctl.zorder, 1

         CASE IDM_SNAPS          'IDC
         DIM OldSnap
         OldSnap = SnapSize
         SnapSize = CINT(VAL(INPUTBOX$("Set Background Grid", "Set Grid Width", STR$(SnapSize))))
         IF SnapSize < 2  THEN SnapSize = OldSnap
         IF Form1 THEN REFRESH(Form1)

         CASE IDM_HTOOL
         IF IsWindowVisible(hToolbar) THEN
            ShowWindow(hToolbar, SW_HIDE)
            CheckMenuItem(CWinMenu, IDM_HTOOL, MF_BYCOMMAND | MF_CHECKED)
            SendMessage(hwndFrame, WM_SIZE, 0, 0)
         ELSE
            ShowWindow(hToolbar, SW_SHOW)
            CheckMenuItem(CWinMenu, IDM_HTOOL, MF_BYCOMMAND | MF_UNCHECKED)
            SendMessage(hwndFrame, WM_SIZE, 0, 0)
         END IF

         CASE IDM_HSTATUS
         IF IsWindowVisible(hStatus) THEN
            ShowWindow(hStatus, SW_HIDE)
            CheckMenuItem(CWinMenu, IDM_HSTATUS, MF_BYCOMMAND | MF_CHECKED)
            SendMessage(hwndFrame, WM_SIZE, 0, 0)
         ELSE
            ShowWindow(hStatus, SW_SHOW)
            CheckMenuItem(CWinMenu, IDM_HSTATUS, MF_BYCOMMAND | MF_UNCHECKED)
            SendMessage(hwndFrame, WM_SIZE, 0, 0)
         END IF

         CASE IDM_HPROPERTY
         IF IsWindowVisible(hPropCtrl) THEN
            HIDE(hPropCtrl)
            CheckMenuItem(CWinMenu, IDM_HPROPERTY, MF_BYCOMMAND | MF_CHECKED)
         ELSE
            SHOW(hPropCtrl)
            CheckMenuItem(CWinMenu, IDM_HPROPERTY, MF_BYCOMMAND | MF_UNCHECKED)
         END IF

         CASE IDM_SIZE
         CALL SizeControls
         g_FileSaved = 0

         CASE IDM_ALEFT TO IDM_CTRHORZ
         CALL AlignControls(CBCTL - IDM_ALEFT)

         CASE IDM_EXIT
         SendMessage(hwndFrame, WM_SYSCOMMAND, SC_CLOSE, NULL)

         CASE IDM_CGEN
         IF NOT hCodegen THEN
            ' create code generator window
            hCodegen = BCX_MDICHILD("Code Generator", "CodeChildWndProc")
         ELSE
            SNDMSG(BCX_hwndMDIClient,WM_MDIACTIVATE,hCodegen,0)
         END IF
         CALL CreateFormCode()

         CASE IDM_CASCADE
         SendMessage(BCX_hwndMDIClient, WM_MDICASCADE, 0, 0)

         CASE IDM_TILEH
         SendMessage(BCX_hwndMDIClient, WM_MDITILE, MDITILE_HORIZONTAL, 0)

         CASE IDM_TILEV
         SendMessage(BCX_hwndMDIClient, WM_MDITILE, MDITILE_VERTICAL, 0)

         CASE IDM_ARRANGE
         SendMessage(BCX_hwndMDIClient, WM_MDIICONARRANGE, 0, 0)

         CASE IDM_RESTORE
         EnumChildWindows(BCX_hwndMDIClient, EnumChildProc, 0)

         CASE IDM_MINWIN
         EnumChildWindows(BCX_hwndMDIClient, EnumChildProc, 1)

         CASE IDM_CLOSE
         EnumChildWindows(BCX_hwndMDIClient, EnumChildProc, 2)

         CASE IDM_ABOUT
         BCX_MDIALOG(AboutBox,"About", hWnd, 10, 10, 150, 200)

         CASE ELSE
         IF wParam > PluginOffset AND wParam < (PluginOffset+1000*iCount) THEN
            CALL HandlePlugin(wParam)
         END IF
      END SELECT

      '---------------------------
      CASE WM_NOTIFY
      '---------------------------
      DIM RAW pnmh = (LPNMHDR)lParam AS LPNMHDR

      IF pnmh->code = TTN_NEEDTEXT THEN
         DIM RAW lpToolTipText = (LPTOOLTIPTEXT)lParam AS LPTOOLTIPTEXT

         SELECT CASE lpToolTipText->hdr.idFrom
            CASE IDM_NEW  : lpToolTipText->lpszText = "New form"
            CASE IDM_LOAD : lpToolTipText->lpszText = "Load form"
            CASE IDM_SAVE : lpToolTipText->lpszText = "Save form/Bas file"
            CASE IDM_CGEN : lpToolTipText->lpszText = "Generate BCX form code"
            CASE IDM_SNAP : lpToolTipText->lpszText = "Snap to grid"
            CASE IDM_GRID : lpToolTipText->lpszText = "Toggle grid on/off"
            CASE IDM_DEL  : lpToolTipText->lpszText = "Delete control(s)"
            CASE IDM_SIZE : lpToolTipText->lpszText = "Size all controls the same"
            CASE IDM_ALIGN: lpToolTipText->lpszText = "Align controls"
         END SELECT
      ELSEIF pnmh->code = TBN_DROPDOWN THEN
         DIM RAW tbrc AS RECT
         DIM RAW id = ((LPNMTOOLBAR)lParam)->iItem
         SNDMSG( pnmh->hwndFrom, TB_GETRECT, id, &tbrc)
         MapWindowPoints(pnmh->hwndFrom, 0, (LPPOINT)&tbrc,2)
         STATIC TBMenu1 AS HMENU
         STATIC TBMenu2 AS HMENU

         IF NOT TBMenu1 THEN
            TBMenu1 = CreatePopupMenu()
            InsertMenu (TBMenu1, 0, MF_STRING, IDM_SAVE,     "Save &Form")
            InsertMenu (TBMenu1, 0, MF_STRING, IDM_SAVEFILE, "Save &Bas file")
         END IF
         IF NOT TBMenu2 THEN
            TBMenu2 = CreatePopupMenu()
            InsertMenu (TBMenu2, 0, MF_STRING, IDM_ALEFT,   "Align &Left")
            InsertMenu (TBMenu2, 0, MF_STRING, IDM_ARIGHT,  "Align &Right")
            InsertMenu (TBMenu2, 0, MF_STRING, IDM_ATOP,    "Align &Top")
            InsertMenu (TBMenu2, 0, MF_STRING, IDM_ABOTTOM, "Align &Bottom")
            InsertMenu (TBMenu2, 0, MF_STRING, IDM_CTRVERT, "Center &Vertical")
            InsertMenu (TBMenu2, 0, MF_STRING, IDM_CTRHORZ, "Center &Horizontal")
         END IF

         IF id = IDM_SAVE THEN
            TrackPopupMenu(TBMenu1,  _
            TPM_LEFTALIGN | TPM_RIGHTBUTTON, tbrc.left, tbrc.bottom,0,hWnd,Null)
         ELSEIF id = IDM_ALIGN THEN
            TrackPopupMenu(TBMenu2,  _
            TPM_LEFTALIGN | TPM_RIGHTBUTTON, tbrc.left, tbrc.bottom,0,hWnd,Null)
         END IF

         FUNCTION = TBDDRET_DEFAULT 'TBDDRET_NODEFAULT 'TBDDRET_TREATPRESSED
      END IF


      CASE WM_CREATE
      DIM RAW styles[] = {0,0,BTNS_WHOLEDROPDOWN,0,TBSTYLE_CHECK,TBSTYLE_CHECK,0,0,BTNS_WHOLEDROPDOWN}
      '      hToolbar = BCX_TOOLBAR(hWnd, IDM_NEW-1, 9, "-1|2|3|4||5|6||7||8|9|", styles, BCX_LOADBMP("tb6.bmp",0,1),0,24,24, _
      hToolbar = BCX_TOOLBAR(hWnd, IDM_NEW-1, 9, "-1|2|3|4||5|6||7||8|9|", styles, BCX_LOADBMP("",111,1),0,24,24, _
      WS_CHILD | WS_VISIBLE | WS_BORDER | CCS_NODIVIDER | TBSTYLE_FLAT | TBSTYLE_TOOLTIPS)         '"tb6.bmp"
      IF GridState THEN SNDMSG(hToolbar, TB_CHECKBUTTON, IDM_GRID, MAKELONG(TRUE,0))
      IF SnapState THEN SNDMSG(hToolbar, TB_CHECKBUTTON, IDM_SNAP, MAKELONG(TRUE,0))

      hStatus = CreateStatusWindow(WS_VISIBLE | WS_CHILD | SBS_SIZEGRIP, NULL, hWnd, 0)

      hSizePosStat = BCX_BITMAP(0,hToolbar,0,330,4)
      MODSTYLE(hSizePosStat,WS_EX_STATICEDGE,0,TRUE)

      SET_BCX_BITMAP2(hSizePosStat, BCX_LOADBMP("",110,1), 0)         '"PosSize.bmp"


      CASE WM_SIZE
      SendMessage(hToolbar, TB_AUTOSIZE, 0, 0)
      MoveWindowTo(hSizePosStat, 330, 4)
      MoveWindow(hStatus, 0, 0, 0, 0, TRUE)

      IF IsWindowVisible(hToolbar) THEN
         GetWindowRect(hToolbar, &rc)
         rc.bottom = rc.bottom - rc.top
         tHeight = rc.bottom
      ELSE
         tHeight = 0
      END IF

      IF IsWindowVisible(hStatus) THEN
         GetWindowRect(hStatus, &rc)
         rc.bottom = rc.bottom - rc.top
         sHeight = rc.bottom
      ELSE
         sHeight = 0
      END IF

      GetClientRect(hWnd, &rc)
      sHeight = (rc.bottom - tHeight) - sHeight

      MoveWindow(BCX_hwndMDIClient, 0, tHeight, rc.right, sHeight, TRUE)
      FUNCTION = 0

      CASE WM_CLOSE

      IF g_FileSaved = 0 THEN
         DIM RAW nRet
         nRet = MSGBOX("Do you want to save this session", "SAVE SESSION", MB_YESNOCANCEL)
         IF nRet = IDCANCEL THEN
            FUNCTION = 0
         ELSEIF nRet = IDYES THEN
            CALL SaveForm()
         END IF
      END IF
      'Save the windows position and sizes
      PutWindowToIni(g_IniFileName$,"Main",hwndFrame,"Window")
      PutWindowToIni(g_IniFileName$,"Form1",Form1,"Window")
      PutWindowToIni(g_IniFileName$,"Properties",hPropCtrl,"Window")
      PutWindowToIni(g_IniFileName$,"Controls",toolbox2,"Window")
      BMFD_Put_Ini(g_IniFileName$)

   END SELECT

END MDIEVENTS MAIN

' #########################################################################
'
'
' #########################################################################

BEGIN MDICHILDEVENTS MDIChildWndProc

   STATIC fDragging
   STATIC fDrawing
   STATIC fSizing
   STATIC SizeDir

   STATIC xStart
   STATIC yStart
   STATIC hdc   AS HDC
   STATIC newrc AS RECT

   SELECT CASE CBMSG

      CASE WM_ERASEBKGND
      IF cType <> -1 AND GridState THEN
         FUNCTION = SetGridBackground(hWnd,(HDC)wParam, SnapSize)
      END IF


      CASE WM_CONTEXTMENU
      IF cType = -1 THEN EXIT SELECT

      STATIC hCpyMenu AS HMENU
      DIM RAW temp = cType
      DIM RAW MenuId
      DIM RAW pt AS POINT,cpt AS POINT

      GetCursorPos(&pt)
      cpt = pt
      ScreenToClient(hWnd, &cpt)
      DIM RAW hit = CtrlSelHitTest(cpt)


      IF NOT hCpyMenu THEN
         hCpyMenu = CreatePopupMenu()
         InsertMenu (hCpyMenu, 0, MF_STRING,  2000, "Copy Control(s)")
         InsertMenu (hCpyMenu, 0, MF_STRING,  2001, "Paste Control(s)")
         InsertMenu (hCpyMenu, 0, MF_STRING,  2002, "Delete Control(s)")
         InsertMenu (hCpyMenu, 0, MF_STRING,  2003, "Size Control To Text")
         InsertMenu (hCpyMenu, 0, MF_SEPARATOR, 2004, "")
         InsertMenu (hCpyMenu, 0, MF_STRING,  2005, "Set Main Selection")
      END IF

      IF hit > 0 THEN
         EnableMenuItem(hCpyMenu,2000,MF_ENABLED)
         EnableMenuItem(hCpyMenu,2002,MF_ENABLED)
         EnableMenuItem(hCpyMenu,2003,MF_ENABLED)
         IF hit <> CurIdx THEN
            EnableMenuItem(hCpyMenu,2005,MF_ENABLED)
         ELSE
            EnableMenuItem(hCpyMenu,2005,MF_GRAYED)
         END IF
      ELSE
         EnableMenuItem(hCpyMenu,2000,MF_GRAYED)
         EnableMenuItem(hCpyMenu,2002,MF_GRAYED)
         EnableMenuItem(hCpyMenu,2003,MF_GRAYED)
         EnableMenuItem(hCpyMenu,2005,MF_GRAYED)
      END IF

      IF NumCopiedControls > 0 THEN
         EnableMenuItem(hCpyMenu,2001,MF_ENABLED)
      ELSE
         EnableMenuItem(hCpyMenu,2001,MF_GRAYED)
      END IF

      MenuId = TrackPopupMenu(hCpyMenu, TPM_NONOTIFY | TPM_RETURNCMD |  _
      TPM_LEFTALIGN | TPM_RIGHTBUTTON, pt.x,pt.y,0,hWnd,Null)

      SELECT CASE MenuId
         CASE 2000
         DIM RAW i, ii = 0

         NumCopiedControls = NumCtrlsSelected()
         REDIM CopyControl[NumCopiedControls]

         FOR i = 1 TO ControlIndex
            IF hctl[i].selected THEN
               CopyControl[ii].CtrlClone = hctl[i]
               CopyControl[ii].sty       = GetWindowLong(hctl[i].hWnd, GWL_STYLE)
               CopyControl[ii].extsty    = GetWindowLong(hctl[i].hWnd, GWL_EXSTYLE)
               CopyControl[ii].caption$  = BCX_GET_TEXT$(hctl[i].hWnd)
               INCR ii
            END IF
         NEXT

         CASE 2001
         DIM RAW i, ii, OffsetX, OffsetY

         CurIdx = 0
         CALL ResetSelections

         OffsetX = -(CopyControl[0].CtrlClone.rect.left - cpt.x)
         OffsetY = -(CopyControl[0].CtrlClone.rect.top - cpt.y)

         FOR i = 0 TO NumCopiedControls - 1
            ii = ++ControlIndex
            ClearCntrlType(ii)

            cType    = CopyControl[i].CtrlClone.ctype
            hctl[ii] = CopyControl[i].CtrlClone

            OffsetRect(&hctl[ii].rect, OffsetX, OffsetY)

            hctl[ii].hWnd = CreateControlEx(Form1, &hctl[ii].rect, _
            CopyControl[i].sty, CopyControl[i].extsty, CopyControl[i].caption$)

            IF hctl[ii].font.Font_name$ > "" THEN
               DIM RAW tmphFnt AS HFONT
               tmphFnt = hctl[ii].font.hFnt
               hctl[ii].font.hFnt = BCX_SET_FONT( hctl[ii].font.Font_name$, _
               hctl[ii].font.Font_size, hctl[ii].font.Font_weight, _
               hctl[ii].font.Font_italic, hctl[ii].font.Font_underline, _
               hctl[ii].font.Font_strikethrough )
               SNDMSG(hctl[ii].hWnd, WM_SETFONT, hctl[ii].font.hFnt, TRUE)
               IF tmphFnt THEN DeleteObject(tmphFnt)
            END IF
         NEXT

         CurIdx = ControlIndex
         CALL UpdateGrips
         CALL DrawSelGripHandles

         UpdatePropDialog(hctl[CurIdx].hWnd)
         cType = temp

         CASE 2002
         CALL DeleteControls

         CASE 2003
         DIM RAW size AS SIZE PTR

         'This will need to be customized for individual control types
         size=GETTEXTSIZE(BCX_GET_TEXT$(hctl[CurIdx].hWnd), hctl[CurIdx].hWnd)
         SELECT CASE hctl[CurIdx].ctype
            CASE 3   : size->cx += 24 : size->cy +=12
            CASE 4,5 : size->cx += 24
            CASE ELSE : size->cx += 2 : size->cy +=2
         END SELECT

         SizeWindow(hctl[CurIdx].hWnd, size->cx, size->cy)
         hctl[CurIdx].rect.right  = hctl[CurIdx].rect.left + size->cx
         hctl[CurIdx].rect.bottom = hctl[CurIdx].rect.top  + size->cy

         CALL UpdateGrips
         CALL DrawSelGripHandles
         UpdatePropDialog(hctl[CurIdx].hWnd)


         CASE 2005
         IF hit THEN
            CurIdx = hit
            SHOW(GriphWnd)
            CALL UpdateGrips
            CALL DrawSelGripHandles
            UpdatePropDialog(hctl[CurIdx].hWnd)
         END IF
      END SELECT

      'CASE WM_KEYUP

      CASE WM_KEYDOWN
      IF cType = -1 OR fDragging THEN EXIT SELECT

      IF CurIdx > 0 THEN
         DIM RAW ShiftKeyState = GetAsyncKeyState(VK_SHIFT)>>1

         IF ShiftKeyState <> 0 THEN    ' Sizing added by DW
            SELECT CASE wParam
               CASE VK_UP    : DECR hctl[CurIdx].rect.bottom
               CASE VK_DOWN  : INCR hctl[CurIdx].rect.bottom
               CASE VK_LEFT  : DECR hctl[CurIdx].rect.right
               CASE VK_RIGHT : INCR hctl[CurIdx].rect.right
               CASE ELSE     : EXIT FUNCTION
            END SELECT

            SizeWindow(hctl[CurIdx].hWnd, hctl[CurIdx].rect.right-hctl[CurIdx].rect.left, hctl[CurIdx].rect.bottom-hctl[CurIdx].rect.top)

         ELSE                         ' Moving

            SELECT CASE wParam
               CASE VK_UP     : MoveControls( 0,-1)
               CASE VK_DOWN   : MoveControls( 0, 1)
               CASE VK_LEFT   : MoveControls(-1, 0)
               CASE VK_RIGHT  : MoveControls( 1, 0)
               CASE VK_DELETE : CALL DeleteControls : EXIT FUNCTION
               CASE ELSE      : EXIT FUNCTION
            END SELECT

         END IF
         CALL UpdateGrips
         CALL DrawSelGripHandles

      END IF


      CASE WM_LBUTTONDOWN
      IF cType = -1 THEN EXIT SELECT

      DIM RAW CtrlKeyState
      DIM RAW HitIdx, tmpHit
      DIM RAW pt AS POINT
      DIM RAW HitIsAFrame = FALSE

      CtrlKeyState  = GetAsyncKeyState(VK_CONTROL) >> 1

      GetCursorPos(&pt)
      ScreenToClient(hWnd, &pt)
      xStart = pt.x
      yStart = pt.y

      HitIdx = tmpHit = CtrlHitTest(1, pt)

      IF HitIdx THEN

         WHILE hctl[tmpHit].ctype = 2 OR hctl[tmpHit].ctype = 10
            HitIdx = tmpHit
            HitIsAFrame = TRUE
            tmpHit = CtrlHitTest(HitIdx+1, pt)
         WEND

         IF CtrlKeyState <> 0 AND CurIdx <> 0 THEN
            IF HitIsAFrame THEN
               tmpHit = CtrlHitTest(HitIdx+1, pt)
               IF tmpHit THEN
                  HitIdx = tmpHit
               END IF
            END IF
            IF CurIdx <> HitIdx THEN
               hctl[HitIdx].selected = NOT hctl[HitIdx].selected
               CALL DrawSelGripHandles
            END IF
            EXIT SELECT
         END IF

         'The current hit is a group box or frame
         'so give precedence to covered controls
         IF HitIsAFrame THEN
            tmpHit = CtrlHitTest(HitIdx+1, pt)
            IF hctl[HitIdx].selected = 0 OR cType <> 0 OR tmpHit <> 0 THEN
               IF NOT SetZorderFlag OR (SetZorderFlag AND tmpHit <> 0) THEN
                  HitIdx = tmpHit
               END IF
            END IF
         END IF
      END IF

      IF HitIdx = 0 THEN
         CurIdx = 0
         CALL ResetSelections
         HIDE(GriphWnd)
         fDrawing = TRUE

      ELSE

         IF SetZorderFlag THEN
            SetWindowPos(hctl[HitIdx].hWnd,HWND_BOTTOM,0,0,0,0,SWP_NOACTIVATE|SWP_NOOWNERZORDER|SWP_NOMOVE|SWP_NOSIZE)
            EXIT FUNCTION

         ELSEIF NOT hctl[HitIdx].selected THEN

            CurIdx = HitIdx
            CALL ResetSelections
            SHOW(GriphWnd)
            CALL UpdateGrips
            UpdatePropDialog(hctl[CurIdx].hWnd)
            EXIT SELECT

         ELSE

            fSizing = TRUE
            SizeDir = GripHitTest(CurIdx, pt)

            SELECT CASE SizeDir
               CASE 0 : SetCursor(LoadCursor(NULL, IDC_SIZENWSE))  'Top-Left
               CASE 1 : SetCursor(LoadCursor(NULL, IDC_SIZEWE))    'Left
               CASE 2 : SetCursor(LoadCursor(NULL, IDC_SIZENESW))  'Bottom-Left
               CASE 3 : SetCursor(LoadCursor(NULL, IDC_SIZENS))    'Top
               CASE 4 : SetCursor(LoadCursor(NULL, IDC_SIZENS))    'Bottom
               CASE 5 : SetCursor(LoadCursor(NULL, IDC_SIZENESW))  'Top-Right
               CASE 6 : SetCursor(LoadCursor(NULL, IDC_SIZEWE))    'Right
               CASE 7 : SetCursor(LoadCursor(NULL, IDC_SIZENWSE))  'Bottom-Right
               CASE ELSE
               fDragging = TRUE : fSizing = FALSE
               SetCursor(LoadCursor(0,IDC_SIZEALL))
               SetWindowPos(hctl[CurIdx].hWnd,HWND_BOTTOM,0,0,0,0,SWP_NOACTIVATE|SWP_NOOWNERZORDER|SWP_NOMOVE|SWP_NOSIZE)

            END SELECT
         END IF
      END IF

      DIM RAW rcClip AS RECT
      GetClientRect(hWnd, &rcClip)
      MapWindowPoints(hWnd,0,(LPPOINT)&rcClip,2)
      ClipCursor(&rcClip)
      SetCapture(hWnd)


      CASE WM_MOUSEMOVE
      IF cType = -1 THEN EXIT SELECT

      DIM RAW ptt AS POINT
      GetCursorPos(&ptt)
      ScreenToClient(hWnd,&ptt)

      IF NOT fDrawing AND NOT fDragging AND NOT fSizing THEN
         IF PtInRect(&hctl[CurIdx].rect, ptt) THEN

            DIM RAW hit = GripHitTest(CurIdx, ptt)

            SELECT CASE hit
               CASE 0 : SetCursor(LoadCursor(NULL, IDC_SIZENWSE))  'Top-Left
               CASE 1 : SetCursor(LoadCursor(NULL, IDC_SIZEWE))    'Left
               CASE 2 : SetCursor(LoadCursor(NULL, IDC_SIZENESW))  'Bottom-Left
               CASE 3 : SetCursor(LoadCursor(NULL, IDC_SIZENS))    'Top
               CASE 4 : SetCursor(LoadCursor(NULL, IDC_SIZENS))    'Bottom
               CASE 5 : SetCursor(LoadCursor(NULL, IDC_SIZENESW))  'Top-Right
               CASE 6 : SetCursor(LoadCursor(NULL, IDC_SIZEWE))    'Right
               CASE 7 : SetCursor(LoadCursor(NULL, IDC_SIZENWSE))  'Bottom-Right
            END SELECT
         ELSE
            SetCursor(LoadCursor(NULL, IDC_ARROW))
         END IF
      END IF


      IF fDrawing THEN

         hdc = GetDC(hWnd)
         SetROP2(hdc, R2_NOTXORPEN)
         DrawFocusRect(hdc, &newrc)

         IF xStart > ptt.x THEN
            newrc.left  = ptt.x
            newrc.right = xStart
         ELSE                       ' going right
            newrc.left  = xStart
            newrc.right = ptt.x
         END IF

         IF yStart < ptt.y THEN
            newrc.bottom = ptt.y
            newrc.top    = yStart
         ELSE                      ' going right
            newrc.bottom = yStart
            newrc.top    = ptt.y
         END IF

         DrawFocusRect(hdc, &newrc)
         ReleaseDC(hWnd, hdc)

         UpdateSizePosStatus(&newrc)

      ELSEIF fDragging THEN
         MoveControls(-(xStart-ptt.x), -(yStart-ptt.y))
         xStart = ptt.x
         yStart = ptt.y
         CALL UpdateGrips

      ELSEIF fSizing THEN
         IF (SizeDir = 3 OR SizeDir = 0 OR SizeDir = 5) AND (ptt.y < hctl[CurIdx].rect.bottom) THEN hctl[CurIdx].rect.top = ptt.y
         IF (SizeDir = 4 OR SizeDir = 2 OR SizeDir = 7) AND (ptt.y > hctl[CurIdx].rect.top) THEN hctl[CurIdx].rect.bottom = ptt.y
         IF (SizeDir = 1 OR SizeDir = 0 OR SizeDir = 2) AND (ptt.x < hctl[CurIdx].rect.right) THEN hctl[CurIdx].rect.left = ptt.x
         IF (SizeDir = 6 OR SizeDir = 7 OR SizeDir = 5) AND (ptt.x > hctl[CurIdx].rect.left) THEN hctl[CurIdx].rect.right = ptt.x
         CALL SnapCtrlsToGrid(hctl[CurIdx].hWnd,&hctl[CurIdx].rect )   'IDC Snap
         SetWindowPos(hctl[CurIdx].hWnd,0,hctl[CurIdx].rect.left,hctl[CurIdx].rect.top, _
         hctl[CurIdx].rect.right - hctl[CurIdx].rect.left, _
         hctl[CurIdx].rect.bottom - hctl[CurIdx].rect.top, SWP_NOZORDER|SWP_NOACTIVATE)
         CALL UpdateGrips

      END IF


      CASE WM_LBUTTONUP

      IF cType = -1 THEN EXIT SELECT

      IF fDrawing  THEN
         '---------------------------------------------------
         ' Avoid making accidental controls too small to see
         '---------------------------------------------------
         IF cType > 0 AND (newrc.bottom - newrc.top > 8) AND (newrc.right - newrc.left > 8) THEN

            DIM RAW hctrl = CreateControlEx(hWnd, &newrc) AS HWND
            ' Retrieve new dimensions since some controls will snap to a new position
            CurIdx = ++ControlIndex
            ClearCntrlType(CurIdx)

            GetWindowRect(hctrl,&hctl[CurIdx].rect)
            CALL SnapCtrlsToGrid(hctrl,&hctl[CurIdx].rect )   'IDC Snap
            MapWindowPoints(0,hWnd,(LPPOINT)&hctl[CurIdx].rect,2)
            hctl[CurIdx].hWnd   = hctrl
            hctl[CurIdx].ctype  = cType

            SHOW(GriphWnd)
            CALL UpdateGrips
            CALL ResetSelections
         ELSE
            IF cType = 0 THEN
               IF IsRectEmpty(&newrc) THEN InflateRect(&newrc, 1, 1)
               SelectGrpControls(&newrc)
               SHOW(GriphWnd)
               CALL UpdateGrips
            END IF

            UpdateSizePosStatus(&hctl[0].rect)
         END IF

         SetRectEmpty(&newrc)
         DrawFocusRect(hdc, &newrc)

         InvalidateRect(hWnd,0,TRUE)
         UpdateWindow(hWnd)
      END IF

      IF SetZorderFlag THEN
         cnum = 0
         EnumChildWindows(hWnd, EnumChildProc, 3)

      ELSEIF fDragging OR fDrawing OR fSizing THEN
         fDragging = fSizing = fDrawing = FALSE
         ClipCursor(0)
         ReleaseCapture()
         CALL SnapCtrlsToGrid(hctl[CurIdx].hWnd,&hctl[CurIdx].rect )   'IDC Snap
         UpdatePropDialog(hctl[CurIdx].hWnd)
         CALL DrawSelGripHandles

         EXIT SELECT
      END IF

      FUNCTION = 0

      CASE WM_CTLCOLORSTATIC, WM_CTLCOLOREDIT, WM_CTLCOLORLISTBOX
      IF (HWND)CBLPARAM =  hctl[CurIdx].hWnd THEN
         IF hctl[CurIdx].UseColor THEN
            FUNCTION =  BCX_SETCOLOR(hctl[CurIdx].forecolor,hctl[CurIdx].backcolor) ',0,(INT)hctl[CurIdx].hWnd)
         END IF
      ELSE
         FOR INTEGER i = 1 TO ControlIndex
            IF  (HWND)CBLPARAM = hctl[i].hWnd THEN
               IF hctl[i].UseColor THEN
                  FUNCTION =  BCX_SETCOLOR(hctl[i].forecolor,hctl[i].backcolor)
               END IF
            END IF
         NEXT i
      END IF
      'CASE WM_CTLCOLORDLG

      CASE WM_CLOSE
      EXIT FUNCTION

      CASE WM_CREATE
      SetClassLong(hWnd,GCL_HBRBACKGROUND,(DWORD)(COLOR_BTNFACE+1))

   END SELECT

END MDICHILDEVENTS


' #########################################################################
'   abstract:   handles code generator messages
'   usage   :   CodegenProc(hWindow, wMsg, wParam, lParam)
' #########################################################################

BEGIN MDICHILDEVENTS CodeChildWndProc

   SELECT CASE CBMSG
      CASE WM_CREATE
      hCGEdit = BCX_RICHEDIT("", hWnd, 3000, 0,0,10,10, 0, WS_EX_STATICEDGE)
      BCX_SET_FONT hCGEdit, "Courier New", 10

      CASE WM_SIZE
      DIM RAW rc AS RECT
      GetClientRect(hWnd, &rc)
      MoveWindow(hCGEdit, 0, 0, rc.right - rc.left, rc.bottom - rc.top, TRUE)

      CASE WM_MDIACTIVATE
      IF hWnd = (HWND)lParam THEN SHOW(hWnd)

      CASE WM_CLOSE
      ShowWindow(hWnd, SW_HIDE)
      SNDMSG(BCX_hwndMDIClient,WM_MDIACTIVATE,Form1,0)
      FUNCTION = 0
   END SELECT

END MDICHILDEVENTS


' #########################################################################

BEGIN DIALOG AS ToolbarControls
   STATIC tb AS HWND

   SELECT CASE CBMSG
      CASE WM_INITDIALOG

      DIM RAW styles[MaxToolTypes]
      FOR integer i = 0 TO 29 : styles[i] = TBSTYLE_CHECKGROUP : NEXT

      tb = BCX_TOOLBAR(hWnd, IDC_TB1, MaxToolTypes, "", styles, GetImageListRes(113, 24) _
      ,TB1Idx,24,24,WS_CHILD | WS_VISIBLE | TBSTYLE_WRAPABLE | TBSTYLE_TOOLTIPS)

      SNDMSG(tb, TB_CHECKBUTTON, IDC_SEL, MAKELONG(TRUE,0))

      CASE WM_SIZE
      SendMessage (tb,Msg,wParam,lParam)

      '---------------------------
      CASE WM_NOTIFY
      '---------------------------
      DIM RAW pnmh = (LPNMHDR)lParam AS LPNMHDR

      IF pnmh->code = TTN_NEEDTEXT THEN
         DIM RAW lpToolTipText = (LPTOOLTIPTEXT)lParam AS LPTOOLTIPTEXT

         SELECT CASE lpToolTipText->hdr.idFrom
            CASE IDC_TST : lpToolTipText->lpszText = "Test"
            CASE IDC_SEL : lpToolTipText->lpszText = "Select"
            CASE IDC_EDT : lpToolTipText->lpszText = "Edit"
            CASE IDC_GRP : lpToolTipText->lpszText = "Group box"
            CASE IDC_BTN : lpToolTipText->lpszText = "Button"
            CASE IDC_CHK : lpToolTipText->lpszText = "Checkbox"
            CASE IDC_RAD : lpToolTipText->lpszText = "Radio button"
            CASE IDC_CMB : lpToolTipText->lpszText = "Combobox"
            CASE IDC_LST : lpToolTipText->lpszText = "Listbox"
            CASE IDC_HSL : lpToolTipText->lpszText = "Horz Scrollbar"
            CASE IDC_VSL : lpToolTipText->lpszText = "Vert Scrollbar"
            CASE IDC_FRM : lpToolTipText->lpszText = "Frame"
            CASE IDC_ICO : lpToolTipText->lpszText = "Button w/Icon"
            CASE IDC_STC : lpToolTipText->lpszText = "Text"
            CASE IDC_ANI : lpToolTipText->lpszText = "Animation"
            CASE IDC_RIH : lpToolTipText->lpszText = "RichEdit"
            CASE IDC_PRG : lpToolTipText->lpszText = "Progress Bar"
            CASE IDC_UPD : lpToolTipText->lpszText = "Up/Down"
            CASE IDC_LVW : lpToolTipText->lpszText = "Listview"
            CASE IDC_TRV : lpToolTipText->lpszText = "Treeview"
            CASE IDC_TRK : lpToolTipText->lpszText = "Slider"
            CASE IDC_BMP : lpToolTipText->lpszText = "Button w/Bmp"
            CASE IDC_DAT : lpToolTipText->lpszText = "Date/Time"
            CASE IDC_CAL : lpToolTipText->lpszText = "Calendar"
            CASE IDC_IPA : lpToolTipText->lpszText = "IP Address"
            CASE IDC_USR : lpToolTipText->lpszText = "User defined"
            CASE IDC_PIC : lpToolTipText->lpszText = "Picture"
            CASE IDC_GRD : lpToolTipText->lpszText = "RA_Grid"
            CASE IDC_INP : lpToolTipText->lpszText = "Input"
            CASE IDC_NUL2 : lpToolTipText->lpszText = "Not used"

         END SELECT
      END IF

      CASE WM_COMMAND
      STATIC LastcType
      DIM RAW i

      SELECT CASE CBCTL
         LastcType = cType

         CASE IDC_TST
         cType = -1
         FOR i = 1 TO ControlIndex
            IF NOT IsWindowEnabled(hctl[i].hWnd) THEN
               hctl[i].disabled = TRUE
               EnableWindow(hctl[i].hWnd, TRUE)
            END IF
         NEXT i
         CurIdx = 0
         CALL ResetSelections
         HIDE(GriphWnd)
         REFRESH(Form1)
         UpdateSizePosStatus(&hctl[0].rect)

         CASE IDC_SEL : cType = 0
         CASE IDC_EDT : cType = 1
         CASE IDC_GRP : cType = 2
         CASE IDC_BTN : cType = 3
         CASE IDC_CHK : cType = 4
         CASE IDC_RAD : cType = 5
         CASE IDC_CMB : cType = 6
         CASE IDC_LST : cType = 7
         CASE IDC_HSL : cType = 8
         CASE IDC_VSL : cType = 9
         CASE IDC_FRM : cType = 10
         CASE IDC_PIC : cType = 11
         CASE IDC_STC : cType = 12
         CASE IDC_ANI : cType = 13
         CASE IDC_RIH : cType = 14
         CASE IDC_PRG : cType = 15
         CASE IDC_UPD : cType = 16
         CASE IDC_LVW : cType = 17
         CASE IDC_TRV : cType = 18
         CASE IDC_TRK : cType = 19
         CASE IDC_BMP : cType = 20
         CASE IDC_DAT : cType = 21
         CASE IDC_CAL : cType = 22
         CASE IDC_IPA : cType = 23
         CASE IDC_USR : cType = 24
         CASE IDC_ICO : cType = 25
         CASE IDC_GRD : cType = 26
         CASE IDC_INP : cType = 27
      END SELECT

      IF LastcType = -1 AND cType <> -1 THEN
         FOR i = 1 TO ControlIndex
            IF hctl[i].disabled THEN
               EnableWindow(hctl[i].hWnd, False)
            END IF
         NEXT i
         CurIdx = 1
         CALL UpdateGrips
         SHOW(GriphWnd)
         REFRESH(Form1)
      END IF

      CASE WM_CLOSE
      ShowWindow(toolbox2, SW_HIDE)
      FUNCTION = 0
   END SELECT
END DIALOG



BEGIN MODAL DIALOG AS AboutBox
   SELECT CASE CBMSG
      CASE WM_INITDIALOG
      CenterWindow(hWnd)
      FUNCTION = TRUE

      CASE WM_PAINT
      DIM RAW ps AS PAINTSTRUCT, bm AS HBITMAP
      'bm = BCX_LOADBMP("splash.bmp")
      bm = BCX_LOADBMP("",114 )'"splash.bmp")
      BeginPaint(hWnd,&ps)
      DRAWTRANSBMP(0,bm,RGB(255,255,255),10,10,ps.hdc)
      GPrint(ps.hdc, 25, 90,  "Version 1.3 (c) 2007-2009")
      GPrint(ps.hdc, 25, 110, "by Mike Henning")
      GPrint(ps.hdc, 60, 145, "     Credits:")
      GPrint(ps.hdc, 60, 165, "     * Dindo Liboon (BIDE)")
      GPrint(ps.hdc, 60, 185, "     * Andreas Guenther")
      GPrint(ps.hdc, 60, 205, "     * James Brown")
      GPrint(ps.hdc, 60, 225, "     * Doyle Whisenant")
      GPrint(ps.hdc, 60, 245, "     * Kevin Diggins")
      GPrint(ps.hdc, 60, 265, "     * Vic McClung")
      GPrint(ps.hdc, 60, 285, "     * Jules Marchildon")
      GPrint(ps.hdc, 60, 305, " ")
      GPrint(ps.hdc, 60, 325, "     Added to by Ian Casey")
      GPrint(ps.hdc, 60, 345, "     and Wayne Halsdorf")
      EndPaint(hWnd,&ps)
      DeleteObject(bm)
      FUNCTION = 0

      CASE WM_ERASEBKGND
      DIM RAW rc AS RECT
      GetClientRect(hWnd,&rc)
      Gradient((HDC)wParam,&rc,RGB(247, 236, 219),RGB(184, 130, 92))
      FUNCTION = 1

   END SELECT
END DIALOG




' #########################################################################
'   abstract:   handles run-time controls
'   usage   :   ButtonProc(hControl, wMsg, wParam, lParam)
' #########################################################################

CALLBACK FUNCTION ControlCbk()

   DIM RAW OldProc AS WNDPROC
   OldProc = (WNDPROC)GetProp(hWnd, "Wprc")

   SELECT CASE CBMSG

      CASE WM_LBUTTONDOWN, WM_LBUTTONUP, WM_MOUSEMOVE, WM_CONTEXTMENU

      IF cType <> -1 THEN
         PostMessage(GetParent(hWnd), Msg, wParam, lParam)
         FUNCTION = 0
      END IF

      CASE WM_LBUTTONDBLCLK, WM_RBUTTONDBLCLK
      IF cType <> -1 THEN FUNCTION = 0


      CASE WM_DESTROY
      SetWindowLong(hWnd, GWL_WNDPROC, (DWORD) RemoveProp(hWnd, "Wprc"))

   END SELECT

   FUNCTION = CallWindowProc(OldProc, hWnd, Msg, wParam, lParam)
END FUNCTION



' #########################################################################
'   abstract:   repositions any window to the center of the screen
'   usage   :   CenterWindow(hParent)
' #########################################################################

SUB CenterWindow(hWnd AS HWND)
   DIM RAW wRect AS RECT
   DIM RAW x     AS DWORD
   DIM RAW y     AS DWORD

   GetWindowRect(hWnd, &wRect)
   x = (GetSystemMetrics(SM_CXSCREEN) - (wRect.right - wRect.left)) / 2
   y = (GetSystemMetrics(SM_CYSCREEN) - (wRect.bottom - wRect.top + _
   GetSystemMetrics(SM_CYCAPTION))) / 2
   MoveWindowTo(hWnd, x, y)
END SUB

' #########################################################################
'   abstract:   creates default menu for mdi parent
'   usage   :   ApplyMenu(hParent)
' #########################################################################

FUNCTION MakeMenu() AS HMENU
   ' create menu handles
   DIM i
   DIM tmpFile$
   MainMenu = CreateMenu()
   FileMenu = CreateMenu()
   OptMenu  = CreateMenu()
   CWinMenu = CreateMenu()
   HelpMenu = CreateMenu()

   ' create file menu
   AppendMenu(FileMenu, MF_STRING, IDM_NEW,     "&New Form")
   AppendMenu(FileMenu, MF_STRING, IDM_SAVE,    "&Save Form")
   AppendMenu(FileMenu, MF_STRING, IDM_LOAD,    "&Load Form")
   AppendMenu(FileMenu, MF_SEPARATOR, 0, "")
   AppendMenu(FileMenu, MF_STRING, IDM_SAVEFILE, "S&ave BAS File")
   AppendMenu(FileMenu, MF_SEPARATOR, 0, "")
   IF EXIST(g_LastFileName$) THEN
      AppendMenu(FileMenu, MF_STRING, IDM_LASTFILE, g_LastFileName$)
      AppendMenu(FileMenu, MF_SEPARATOR, 0, "")
   END IF
   tmpFile$ = ReadIniString$(g_IniFileName$, "Main", "LastTmpName")
   IF EXIST(tmpFile$) THEN
      AppendMenu(FileMenu, MF_STRING, IDM_TEMPFILE, tmpFile$)
      AppendMenu(FileMenu, MF_SEPARATOR, 0, "")
   END IF
   AppendMenu(FileMenu, MF_STRING, IDM_EXIT,     "E&xit")

   ' create options menu
   AppendMenu(OptMenu, MF_STRING, IDM_VIEWZ,     "&View/Set Zorder")
   AppendMenu(OptMenu, MF_STRING, IDM_SAVEZ,     "&Save Zorder")
   AppendMenu(OptMenu, MF_SEPARATOR, 0, "")
   AppendMenu(OptMenu, MF_STRING, IDM_SNAPS, "Set Grid Size")  'IDC


   ' create window menu
   AppendMenu(CWinMenu, MF_STRING, IDM_HTOOL,     "Hide &Toolbar")
   AppendMenu(CWinMenu, MF_STRING, IDM_HSTATUS,   "Hide &Statusbar")
   AppendMenu(CWinMenu, MF_STRING, IDM_HPROPERTY, "Hide &Property Dialog")
   'AppendMenu(CWinMenu, MF_SEPARATOR, 0, "")

   ' create help window
   AppendMenu(HelpMenu, MF_STRING,IDM_ABOUT,   "&About")

   ' attach menus to menubar
   InsertMenu(MainMenu, 0, MF_POPUP, FileMenu, "&File")
   InsertMenu(MainMenu, 1, MF_POPUP, OptMenu,  "&Options")
   InsertMenu(MainMenu, 2, MF_POPUP, CWinMenu, "&Window")

   IF iCount THEN
      i = 0
      WHILE i < iCount
         InsertMenu(MainMenu, i+4, MF_POPUP, MyPlugin[i].PlugInMenu, MyPlugin[i].sName$)
         i++
      WEND
   END IF
   'insert help menu after Plugins
   InsertMenu(MainMenu, 3, MF_POPUP, HelpMenu, "&Help")

   FUNCTION = MainMenu
END FUNCTION


' #########################################################################
'   abstract:   controls what can be done with child mdi windows
'   usage   :   EnumChildProc(hWindow, lParam)
' #########################################################################

FUNCTION EnumChildProc( hwnd AS HWND, lParam AS LPARAM ) AS BOOL CALLBACK

   ' protect our custom parent and children windows
   IF hwnd = hCodegen OR GetParent(hwnd) = hCodegen OR hwnd = GriphWnd THEN
      FUNCTION = TRUE
   END IF

   SELECT CASE lParam
      CASE 0
      ShowWindow(hwnd, SW_RESTORE)

      CASE 1
      ShowWindow(hwnd, SW_MINIMIZE)

      CASE 2
      SendMessage(BCX_hwndMDIClient, WM_MDIDESTROY, hwnd, 0)

      '********************
      CASE 3
      '********************
      GLOBAL cnum
      DIM RAW i

      FOR i = 1 TO ControlIndex
         IF hwnd = hctl[i].hWnd THEN
            DIM RAW hdc = GetWindowDC(hwnd) AS HDC
            BCX_CIRCLE(0,10,10,9,RGB(255,0,0),true,hdc)
            GPrint(hdc,1,2, STR$(++cnum))
            ReleaseDC(hwnd,hdc)
            EXIT FOR
         END IF
      NEXT

      '********************
      CASE 4
      '********************
      DIM RAW i
      'INCR cnum
      FOR i = 1 TO ControlIndex
         IF hwnd = hctl[i].hWnd THEN
            hctl[i].zorder = ++cnum
            EXIT FOR
         END IF
      NEXT

   END SELECT

   FUNCTION = TRUE
END FUNCTION



SUB DeleteControls()
   DIM RAW i, ii

   FOR i = 1 TO ControlIndex
      IF hctl[i].selected THEN
         DestroyWindow(hctl[i].hWnd)
         DECR ControlIndex
         FOR ii = i TO ControlIndex : hctl[ii] = hctl[ii+1] : NEXT ii
         DECR i
      END IF
   NEXT

   CurIdx = 0
   HIDE(GriphWnd)
   UpdateSizePosStatus(&hctl[0].rect)

END SUB



' #########################################################################
'   abstract:   creates a control at run-time
'   usage   :   CreateControlEx(hParent)
' #########################################################################

FUNCTION CreateControlEx OPTIONAL( hwndOwner AS HWND, BYREF rc AS RECT, Sty AS DWORD=-1, ExtSty AS DWORD=-1, Caption$ = 0 ) AS HWND

   DIM RAW hCtl = NULL AS HWND
   DIM RAW xStyle AS DWORD
   DIM RAW cStyle AS DWORD
   DIM RAW cClass AS LPSTR
   DIM RAW cText  AS LPSTR
   DIM RAW pSty AS DWORD PTR, pXSty AS DWORD PTR
   DIM RAW pszCap AS LPSTR PTR
   STATIC id = 10000

   pSty   = &Sty
   pXSty  = &ExtSty
   pszCap = &Caption

   IF Sty     = -1   THEN pSty   = &cStyle
   IF ExtSty  = -1   THEN pXSty  = &xStyle
   IF Caption = NULL THEN pszCap = &cText

   SELECT CASE cType
      CASE 0, -1
      ' do nothing
      FUNCTION = 0
      CASE 1
      xStyle = WS_EX_STATICEDGE
      cStyle = WS_VSCROLL | WS_HSCROLL | ES_AUTOHSCROLL | _
      ES_AUTOVSCROLL | ES_MULTILINE | ES_WANTRETURN | WS_DISABLED
      cClass = "edit"
      cText  = "Edit"
      CASE 2
      xStyle = 0
      cStyle = BS_GROUPBOX|WS_GROUP
      cClass = "button"
      cText  = "Group"
      CASE 3
      xStyle = WS_EX_STATICEDGE
      cStyle = BS_PUSHBUTTON
      cClass = "button"
      cText  = "Button"
      CASE 4
      xStyle = 0
      cStyle = BS_AUTOCHECKBOX
      cClass = "button"
      cText  = "Check"
      CASE 5
      xStyle = 0
      cStyle = BS_AUTORADIOBUTTON
      cClass = "button"
      cText  = "Radio"
      CASE 6
      xStyle = 0
      cStyle = WS_VSCROLL | CBS_DROPDOWN | CBS_SORT | WS_DISABLED
      cClass = "combobox"
      cText  = "Combo"
      CASE 7
      xStyle = WS_EX_STATICEDGE
      cStyle = WS_VSCROLL | LBS_STANDARD | WS_DISABLED | LBS_NOINTEGRALHEIGHT
      cClass = "listbox"
      cText  = "List"
      CASE 8
      xStyle = 0
      cStyle = SBS_HORZ
      cClass = "scrollbar"
      cText  = "HScroll"
      CASE 9
      xStyle = 0
      cStyle = SBS_VERT
      cClass = "scrollbar"
      cText  = "VScroll"
      CASE 10
      xStyle = WS_EX_STATICEDGE
      cStyle = SS_BLACKFRAME | SS_NOTIFY
      cClass = "static"
      cText  = "Frame"
      CASE 11
      xStyle = WS_EX_STATICEDGE
      cStyle = SS_BITMAP | SS_NOTIFY
      cClass = "static"
      cText  = NULL
      CASE 12
      xStyle = WS_EX_STATICEDGE
      cStyle = SS_NOTIFY
      cClass = "static"
      cText  = "Label"
      CASE 13
      xStyle = WS_EX_STATICEDGE
      cStyle = ACS_AUTOPLAY | ACS_TRANSPARENT
      cClass = "SysAnimate32"
      cText  = NULL
      CASE 14
      xStyle = WS_EX_STATICEDGE
      cStyle = WS_HSCROLL | WS_VSCROLL | ES_MULTILINE | _
      ES_AUTOVSCROLL | ES_AUTOHSCROLL  | ES_WANTRETURN | WS_DISABLED
      cClass = RICHEDIT_CLASS
      cText  = "RichEdit"
      LOADLIBRARY("RICHED20.DLL")
      CASE 15
      xStyle = WS_EX_STATICEDGE
      cStyle = 0
      cClass = "msctls_progress32"
      cText  = NULL
      CASE 16
      xStyle = WS_EX_STATICEDGE
      cStyle = SS_NOTIFY
      cClass = "msctls_updown32"
      cText  = NULL
      CASE 17
      xStyle = WS_EX_STATICEDGE
      cStyle = 0
      cClass = "SysListView32"
      cText  = NULL
      CASE 18
      xStyle = WS_EX_STATICEDGE
      cStyle = 0
      cClass = WC_TREEVIEW
      cText  = NULL
      CASE 19
      xStyle = 0
      cStyle = TBS_AUTOTICKS
      cClass = "msctls_trackbar32"
      cText  = NULL
      CASE 20
      xStyle = WS_EX_STATICEDGE
      cStyle = BS_BITMAP
      cClass = "button"
      cText  = NULL
      CASE 21
      xStyle = WS_EX_STATICEDGE
      cStyle = DTS_LONGDATEFORMAT
      cClass = "SysDateTimePick32"
      cText  = NULL
      CASE 22
      xStyle = WS_EX_STATICEDGE
      cStyle = 0
      cClass = "SysMonthCal32"
      cText  = NULL
      CASE 23
      xStyle = WS_EX_STATICEDGE
      cStyle = WS_DISABLED
      cClass = "SysIPAddress32"
      cText  = "0.0.0.0"
      CASE 24 'User defined control
      xStyle = WS_EX_STATICEDGE
      cStyle = SS_NOTIFY
      cClass = "static"
      cText  = "Label"
      CASE 25
      xStyle = WS_EX_STATICEDGE
      cStyle = BS_ICON
      cClass = "button"
      cText  = NULL
      CASE 26 'RA_Grid control
      xStyle = WS_EX_STATICEDGE
      cStyle = WS_DISABLED | STYLE_NOSEL
      cClass = "RAGrid"
      cText  = "raGrid"
      CASE 27 'BCX_INPUT
      xStyle = WS_EX_STATICEDGE
      cStyle = WS_DISABLED | ES_LEFT | ES_AUTOHSCROLL
      cClass = "edit"
      cText  = "input"

   END SELECT

   IF cType = 26 THEN
      hCtl = BCX_raGrid (hwndOwner, id++, rc.left, rc.top, rc.right - rc.left, rc.bottom - rc.top, WS_CHILD | WS_VISIBLE | WS_TABSTOP | *pSty,*pXSty)
   ELSE
      hCtl = CreateWindowEx(*pXSty, cClass, *pszCap, _
      WS_CHILD | WS_VISIBLE | WS_TABSTOP | *pSty, _
      rc.left, rc.top, rc.right - rc.left, rc.bottom - rc.top, _
      hwndOwner, id++, BCX_HINSTANCE, NULL)
   END IF

   IF GriphWnd = NULL THEN
      GriphWnd = CreateWindowEx(0, "DragHandles", "", WS_CHILD | WS_VISIBLE, _
      rc.left, rc.top, rc.right - rc.left, rc.bottom - rc.top, _
      hwndOwner, 20000, BCX_HINSTANCE, NULL)
   END IF

   SendMessage(hCtl, WM_SETFONT, GetStockObject(DEFAULT_GUI_FONT), MAKELPARAM(FALSE,0))
   SetProp(hCtl, "Wprc",(HANDLE)GetWindowLong(hCtl, GWL_WNDPROC))
   SetWindowLong(hCtl, GWL_WNDPROC,(DWORD)ControlCbk)

   SELECT CASE cType
      CASE 6
      SendMessage(hCtl, CB_ADDSTRING, 0, "For")
      SendMessage(hCtl, CB_ADDSTRING, 0, "your")
      SendMessage(hCtl, CB_ADDSTRING, 0, "enjoyment")
      SendMessage(hCtl, CB_ADDSTRING, 0, "I")
      SendMessage(hCtl, CB_ADDSTRING, 0, "added")
      SendMessage(hCtl, CB_ADDSTRING, 0, "some")
      SendMessage(hCtl, CB_ADDSTRING, 0, "combobox")
      SendMessage(hCtl, CB_ADDSTRING, 0, "strings")

      CASE 7
      SendMessage(hCtl, LB_ADDSTRING, 0, "For")
      SendMessage(hCtl, LB_ADDSTRING, 0, "your")
      SendMessage(hCtl, LB_ADDSTRING, 0, "enjoyment")
      SendMessage(hCtl, LB_ADDSTRING, 0, "I")
      SendMessage(hCtl, LB_ADDSTRING, 0, "added")
      SendMessage(hCtl, LB_ADDSTRING, 0, "some")
      SendMessage(hCtl, LB_ADDSTRING, 0, "listbox")
      SendMessage(hCtl, LB_ADDSTRING, 0, "strings")

      CASE 11
      STATIC hBmp AS HBITMAP
      'IF NOT hBmp THEN hBmp = BCX_LOADBMP("Pic.bmp")
      IF NOT hBmp THEN hBmp = BCX_LOADBMP("", 112) '"Pic.bmp")
      SendMessage(hCtl,STM_SETIMAGE,IMAGE_BITMAP,hBmp)

      CASE 20
      STATIC hBmp AS HBITMAP
      'IF NOT hBmp THEN hBmp = BCX_LOADBMP("BtnBmp.bmp")
      IF NOT hBmp THEN hBmp = BCX_LOADBMP("", 115) '"BtnBmp.bmp")
      SendMessage(hCtl,BM_SETIMAGE,IMAGE_BITMAP,hBmp)

      CASE 22
      DIM RAW CalRc AS RECT
      MonthCal_GetMinReqRect(hCtl, &CalRc)
      SizeWindow(hCtl, CalRc.right, CalRc.bottom)

      CASE 25
      STATIC hIcon AS HICON
      IF NOT hIcon THEN
         'hIcon = (HICON)LoadImage(0,"BtnIcn.ico",IMAGE_ICON,0,0,LR_LOADFROMFILE)
         hIcon = LoadIcon(BCX_HINSTANCE, MAKEINTRESOURCE(103))
      END IF
      SendMessage(hCtl,BM_SETIMAGE,IMAGE_ICON,hIcon)

      CASE 26         'BCX_RA_Grid
      GridSetup(hCtl)
      REPEAT 8 : SNDMSG(hCtl, GM_ADDROW, 0, 0) : END REPEAT

   END SELECT

   g_FileSaved = 0
   FUNCTION = hCtl
END FUNCTION



' #########################################################################


SUB DrawGripHandles(hCtl AS HWND, hdc AS HDC)
   DIM RAW rrc AS RECT
   DIM RAW RectHandle[8] AS RECT

   GetWindowRect(hCtl,&rrc)
   MapWindowPoints(0,hCtl,(LPPOINT)&rrc,2)

   RectHandle[0].left   = rrc.left
   RectHandle[0].top    = rrc.top
   RectHandle[0].right  = rrc.left + 6
   RectHandle[0].bottom = rrc.top  + 6

   RectHandle[1].left   = rrc.left
   RectHandle[1].top    = (rrc.bottom + rrc.top)/2 - 3
   RectHandle[1].right  = rrc.left + 6
   RectHandle[1].bottom = (rrc.bottom + rrc.top)/2 + 3

   RectHandle[2].left   = rrc.left
   RectHandle[2].top    = rrc.bottom - 6
   RectHandle[2].right  = rrc.left   + 6
   RectHandle[2].bottom = rrc.bottom

   RectHandle[3].left   = (rrc.right + rrc.left)/2 - 3
   RectHandle[3].top    = rrc.top
   RectHandle[3].right  = (rrc.right + rrc.left)/2 + 3
   RectHandle[3].bottom = rrc.top + 6

   RectHandle[4].left   = (rrc.right + rrc.left)/2 - 3
   RectHandle[4].top    = rrc.bottom - 6
   RectHandle[4].right  = (rrc.right + rrc.left)/2 + 3
   RectHandle[4].bottom = rrc.bottom

   RectHandle[5].left   = rrc.right - 6
   RectHandle[5].top    = rrc.top
   RectHandle[5].right  = rrc.right
   RectHandle[5].bottom = rrc.top + 6

   RectHandle[6].left   = rrc.right - 6
   RectHandle[6].top    = (rrc.bottom + rrc.top)/2 - 3
   RectHandle[6].right  = rrc.right
   RectHandle[6].bottom = (rrc.bottom + rrc.top)/2 + 3

   RectHandle[7].left   = rrc.right  - 6
   RectHandle[7].top    = rrc.bottom - 6
   RectHandle[7].right  = rrc.right
   RectHandle[7].bottom = rrc.bottom

   STATIC hNewBrush AS HBRUSH
   IF NOT hNewBrush THEN hNewBrush = CreateSolidBrush(QBCOLOR(9))

   FOR integer i = 0 TO 7
      FillRect(hdc, &RectHandle[i], hNewBrush)
   NEXT i

END SUB



SUB DrawSelGripHandles()
   DIM RAW rrc AS RECT
   DIM RAW RectHandle[8] AS RECT
   DIM RAW hdc AS HDC
   DIM RAW i, ii

   FOR i = 1 TO ControlIndex
      RedrawWindow(Form1,&hctl[i].rect,NULL,RDW_INVALIDATE|RDW_ERASE|RDW_UPDATENOW|RDW_ALLCHILDREN)
   NEXT

   FOR i = 1 TO ControlIndex

      IF NOT hctl[i].selected OR CurIdx = i THEN ITERATE

      rrc = hctl[i].rect
      MapWindowPoints(Form1, hctl[i].hWnd,(LPPOINT)&rrc,2)
      hdc = GetWindowDC(hctl[i].hWnd)


      RectHandle[0].left   = rrc.left
      RectHandle[0].top    = rrc.top
      RectHandle[0].right  = rrc.left + 6
      RectHandle[0].bottom = rrc.top  + 6

      RectHandle[1].left   = rrc.left
      RectHandle[1].top    = (rrc.bottom + rrc.top)/2 - 3
      RectHandle[1].right  = rrc.left + 6
      RectHandle[1].bottom = (rrc.bottom + rrc.top)/2 + 3

      RectHandle[2].left   = rrc.left
      RectHandle[2].top    = rrc.bottom - 6
      RectHandle[2].right  = rrc.left   + 6
      RectHandle[2].bottom = rrc.bottom

      RectHandle[3].left   = (rrc.right + rrc.left)/2 - 3
      RectHandle[3].top    = rrc.top
      RectHandle[3].right  = (rrc.right + rrc.left)/2 + 3
      RectHandle[3].bottom = rrc.top + 6

      RectHandle[4].left   = (rrc.right + rrc.left)/2 - 3
      RectHandle[4].top    = rrc.bottom - 6
      RectHandle[4].right  = (rrc.right + rrc.left)/2 + 3
      RectHandle[4].bottom = rrc.bottom

      RectHandle[5].left   = rrc.right - 6
      RectHandle[5].top    = rrc.top
      RectHandle[5].right  = rrc.right
      RectHandle[5].bottom = rrc.top + 6

      RectHandle[6].left   = rrc.right - 6
      RectHandle[6].top    = (rrc.bottom + rrc.top)/2 - 3
      RectHandle[6].right  = rrc.right
      RectHandle[6].bottom = (rrc.bottom + rrc.top)/2 + 3

      RectHandle[7].left   = rrc.right  - 6
      RectHandle[7].top    = rrc.bottom - 6
      RectHandle[7].right  = rrc.right
      RectHandle[7].bottom = rrc.bottom

      STATIC hNewBrush AS HBRUSH
      IF NOT hNewBrush THEN hNewBrush = CreateSolidBrush(QBCOLOR(9))

      FOR ii = 0 TO 7
         FrameRect(hdc, &RectHandle[ii], hNewBrush)
      NEXT ii
      ReleaseDC(hctl[i].hWnd, hdc)
   NEXT i

END SUB


FUNCTION CtrlSelHitTest(pt AS POINT)
   DIM RAW tmpHit = 0, Hit = 0

   DO
      tmpHit = CtrlHitTest(tmpHit+1, pt)
      IF NOT tmpHit THEN EXIT DO

      IF hctl[tmpHit].selected THEN
         Hit = tmpHit
         IF hctl[tmpHit].ctype <> 2 AND hctl[tmpHit].ctype <> 10 THEN
            FUNCTION = tmpHit
         END IF
      END IF
   LOOP

   FUNCTION = Hit
END FUNCTION


FUNCTION CtrlHitTest(Index, pt AS POINT)

   FOR Index = Index TO ControlIndex
      IF PtInRect(&hctl[Index].rect, pt) THEN
         FUNCTION = Index
      END IF
   NEXT Index

   FUNCTION = 0
END FUNCTION



FUNCTION GripHitTest(Index, pt AS POINT)
   DIM RAW rcGrip = CalcGripHandles(&hctl[Index].rect) AS LPRECT
   FOR integer i = 0 TO 7
      IF PtInRect(&rcGrip[i], pt) THEN
         FUNCTION = i
      END IF
   NEXT i
   FUNCTION = -1
END FUNCTION


FUNCTION CalcGripHandles(BYREF rrc AS RECT) AS LPRECT

   STATIC RectHandle[8] AS RECT

   RectHandle[0].left   = rrc.left
   RectHandle[0].top    = rrc.top
   RectHandle[0].right  = rrc.left + 6
   RectHandle[0].bottom = rrc.top  + 6

   RectHandle[1].left   = rrc.left
   RectHandle[1].top    = (rrc.bottom + rrc.top)/2 - 3
   RectHandle[1].right  = rrc.left + 6
   RectHandle[1].bottom = (rrc.bottom + rrc.top)/2 + 3

   RectHandle[2].left   = rrc.left
   RectHandle[2].top    = rrc.bottom - 6
   RectHandle[2].right  = rrc.left   + 6
   RectHandle[2].bottom = rrc.bottom

   RectHandle[3].left   = (rrc.right + rrc.left)/2 - 3
   RectHandle[3].top    = rrc.top
   RectHandle[3].right  = (rrc.right + rrc.left)/2 + 3
   RectHandle[3].bottom = rrc.top + 6

   RectHandle[4].left   = (rrc.right + rrc.left)/2 - 3
   RectHandle[4].top    = rrc.bottom - 6
   RectHandle[4].right  = (rrc.right + rrc.left)/2 + 3
   RectHandle[4].bottom = rrc.bottom

   RectHandle[5].left   = rrc.right - 6
   RectHandle[5].top    = rrc.top
   RectHandle[5].right  = rrc.right
   RectHandle[5].bottom = rrc.top + 6

   RectHandle[6].left   = rrc.right - 6
   RectHandle[6].top    = (rrc.bottom + rrc.top)/2 - 3
   RectHandle[6].right  = rrc.right
   RectHandle[6].bottom = (rrc.bottom + rrc.top)/2 + 3

   RectHandle[7].left   = rrc.right  - 6
   RectHandle[7].top    = rrc.bottom - 6
   RectHandle[7].right  = rrc.right
   RectHandle[7].bottom = rrc.bottom

   FUNCTION = RectHandle
END FUNCTION

FUNCTION RegisterDragWnd() AS BOOL
   STATIC wc AS WNDCLASS

   ' register the DragWindow
   wc.style         = 0
   wc.lpfnWndProc   = DwndProc
   wc.cbClsExtra    = 0
   wc.cbWndExtra    = 4
   wc.hInstance     = BCX_HINSTANCE
   wc.hbrBackground = (HBRUSH)NULL
   wc.lpszMenuName  = NULL
   wc.lpszClassName = "DragHandles"
   wc.hIcon         = LoadIcon( NULL,IDI_WINLOGO )
   wc.hCursor       = LoadCursor(NULL, IDC_ARROW)

   FUNCTION = RegisterClass(&wc)
END FUNCTION

CALLBACK FUNCTION DwndProc()  ' Generic SubClass procedure for the DragWindow.

   SELECT CASE CBMSG

      CASE WM_PAINT
      DIM RAW ps AS PAINTSTRUCT
      BeginPaint(hWnd,&ps)
      DrawGripHandles(hWnd, ps.hdc)
      EndPaint(hWnd,&ps)

      UpdateSizePosStatus(&hctl[CurIdx].rect)
      FUNCTION = 0

      CASE WM_LBUTTONDOWN, WM_LBUTTONUP, WM_MOUSEMOVE
      PostMessage(GetParent(hWnd), Msg, wParam, lParam)

   END SELECT

END FUNCTION

SUB UpdateGrips()
   DIM RAW rcc AS RECT
   GetWindowRect(hctl[CurIdx].hWnd,&rcc)
   MapWindowPoints(0, Form1,(LPPOINT)&rcc,2)
   SetWindowPos(GriphWnd, hctl[CurIdx].hWnd,rcc.left,rcc.top,rcc.right-rcc.left,rcc.bottom-rcc.top,SWP_NOACTIVATE)
   RedrawWindow(Form1,&rcc,NULL,RDW_INVALIDATE|RDW_ERASE|RDW_UPDATENOW|RDW_ALLCHILDREN)
END SUB


FUNCTION NumCtrlsSelected()
   DIM RAW i, count = 0
   FOR i = 1 TO ControlIndex
      IF hctl[i].selected THEN INCR count
   NEXT i
   FUNCTION = count
END FUNCTION


SUB ResetSelections()
   FOR integer i = 1 TO ControlIndex
      hctl[i].selected = FALSE
   NEXT i
   IF CurIdx THEN hctl[CurIdx].selected = TRUE
   CALL DrawSelGripHandles
END SUB


SUB SelectGrpControls(BYREF rcSel AS RECT)
   DIM RAW i, rcDestRect AS RECT, SmallestRectIdx = 0
   DIM RAW AssignedCurIdx = 0 AS BOOL
   DIM RAW NumControlsFound = 0

   FOR i = 1 TO ControlIndex
      IF IntersectRect(&rcDestRect, &rcSel, &hctl[i].rect) <> 0 THEN

         IF hctl[i].ctype = 2 OR hctl[i].ctype = 10 THEN
            IF SmallestRectIdx THEN
               SubtractRect(&rcDestRect, &hctl[i].rect, &hctl[SmallestRectIdx].rect)
               IF IsRectEmpty(&rcDestRect) THEN SmallestRectIdx = i
            ELSE
               SmallestRectIdx = i
            END IF
            ITERATE
         END IF
         INCR NumControlsFound
      END IF
   NEXT i

   IF SmallestRectIdx > 0 AND  NumControlsFound = 0 THEN
      CurIdx = SmallestRectIdx
      hctl[CurIdx].selected = TRUE
      EXIT SUB
   END IF

   FOR i = 1 TO ControlIndex
      '      msgbox "Top =" + STR$(rcSel.top) + " Left =" + STR$(rcSel.left) + _
      '      "Right =" + STR$(rcSel.right) + " Bottom =" + STR$(rcSel.bottom)
      IF IntersectRect(&rcDestRect, &rcSel, &hctl[i].rect) <> 0 THEN
         IF hctl[i].ctype = 2 OR hctl[i].ctype = 10 THEN
            'If Group is within a frame don't include the frame.
            IF EqualRect(&rcDestRect, &rcSel) THEN ITERATE
         END IF
         hctl[i].selected = TRUE
         IF NOT AssignedCurIdx THEN CurIdx = i : AssignedCurIdx = TRUE
      END IF

   NEXT i
END SUB


SUB MoveControls(Xoffset, Yoffset)
   DIM RAW i
   DIM RAW hd AS HDWP

   hd = BeginDeferWindowPos(NumCtrlsSelected())
   IF hd <> NULL THEN
      FOR i = 1 TO ControlIndex
         IF hctl[i].selected THEN
            OffsetRect(&hctl[i].rect, Xoffset, Yoffset)
            hd = DeferWindowPos(hd, hctl[i].hWnd, 0 ,hctl[i].rect.left,hctl[i].rect.top,0,0,SWP_NOSIZE|SWP_NOACTIVATE|SWP_NOZORDER)
         END IF
      NEXT i
      EndDeferWindowPos(hd)
   END IF
   g_FileSaved = 0
END SUB

SUB AlignControls(AlignTo)
   DIM RAW i
   IF CurIdx = 0 THEN EXIT SUB

   FOR i = 1 TO ControlIndex

      IF hctl[i].selected AND i <> CurIdx THEN

         SELECT CASE AlignTo
            CASE 0  'left
            OffsetRect(&hctl[i].rect, -(hctl[i].rect.left-hctl[CurIdx].rect.left), 0)

            CASE 1  'right
            OffsetRect(&hctl[i].rect, -(hctl[i].rect.right-hctl[CurIdx].rect.right), 0)

            CASE 2  'top
            OffsetRect(&hctl[i].rect, 0, -(hctl[i].rect.top-hctl[CurIdx].rect.top))

            CASE 3  'bottom
            OffsetRect(&hctl[i].rect, 0, -(hctl[i].rect.bottom-hctl[CurIdx].rect.bottom))

            CASE 4  'vert center
            DIM RAW W1 = hctl[i].rect.right - hctl[i].rect.left
            DIM RAW W2 = hctl[CurIdx].rect.right - hctl[CurIdx].rect.left
            W2 = (W2-W1) * 0.5
            OffsetRect(&hctl[i].rect, -((hctl[i].rect.left-hctl[CurIdx].rect.left) - W2), 0)

            CASE 5  'horz center
            DIM RAW H1 = hctl[i].rect.bottom - hctl[i].rect.top
            DIM RAW H2 = hctl[CurIdx].rect.bottom - hctl[CurIdx].rect.top
            H2 = (H2-H1) * 0.5
            OffsetRect(&hctl[i].rect, 0, -((hctl[i].rect.top-hctl[CurIdx].rect.top) - H2))
         END SELECT

         MoveWindowTo(hctl[i].hWnd, hctl[i].rect.left, hctl[i].rect.top)
      END IF

   NEXT i
   g_FileSaved = 0
END SUB

SUB SizeControls()
   IF CurIdx = 0 THEN EXIT SUB

   DIM RAW i
   DIM RAW W = hctl[CurIdx].rect.right  - hctl[CurIdx].rect.left
   DIM RAW H = hctl[CurIdx].rect.bottom - hctl[CurIdx].rect.top

   FOR i = 1 TO ControlIndex
      IF hctl[i].selected AND i <> CurIdx THEN
         hctl[i].rect.right  = hctl[i].rect.left + W
         hctl[i].rect.bottom = hctl[i].rect.top  + H
         SizeWindow(hctl[i].hWnd, W, H)
      END IF
   NEXT i
   g_FileSaved = 0
END SUB

SUB SetZorder()
   DIM RAW i

   QSORTIDX 0, ControlIndex+1, hctl.zorder, 1

   FOR i = 1 TO ControlIndex
      SetWindowPos(hctl[i].hWnd,HWND_BOTTOM,0,0,0,0,SWP_NOACTIVATE|SWP_NOOWNERZORDER|SWP_NOMOVE|SWP_NOSIZE)
   NEXT
END SUB

FUNCTION SetGridBackground(hWnd AS HWND, ScrHdc AS HDC, GridSize)
   STATIC hb AS HBRUSH
   STATIC OrigBrush AS HBRUSH
   STATIC PrevGridSize
   DIM RAW rc AS RECT

   IF PrevGridSize = GridSize AND hb <> NULL THEN
      GetClientRect(hWnd, &rc)
      FillRect(ScrHdc, &rc, hb)
      FUNCTION = 1
   END IF

   PrevGridSize = GridSize

   IF NOT OrigBrush THEN
      OrigBrush = (HBRUSH)GetClassLong(hWnd,GCL_HBRBACKGROUND)
   END IF

   IF hb THEN DeleteObject(hb)

   DIM RAW hdc = CreateCompatibleDC(NULL) AS HDC
   DIM RAW hbm = CreateCompatibleBitmap(ScrHdc ,GridSize, GridSize) AS HBITMAP
   SelectObject(hdc,hbm)
   SetRect(&rc,0,0,GridSize,GridSize)
   FillRect(hdc, &rc, OrigBrush)
   SetPixel(hdc,GridSize-1,GridSize-1,RGB(0,0,0))
   hb = CreatePatternBrush(hbm)
   DeleteObject(hbm)
   DeleteDC(hdc)

   GetClientRect(hWnd, &rc)
   FillRect(ScrHdc, &rc, hb)

   FUNCTION = 1
END FUNCTION


SUB UpdateSizePosStatus(BYREF rc AS RECT)
   STATIC SizePosBmp AS HBITMAP  '"PosSize.bmp"
   IF NOT SizePosBmp THEN SizePosBmp = BCX_LOADBMP("", 110, 1)

   DIM RAW hdc = StartDraw(hSizePosStat) AS HDC
   BCX_PUT(0,SizePosBmp,0,0,200,24,SRCCOPY,hdc)
   GPrint(hdc,24,4,STR$(rc.left) + "," + STR$(rc.top))
   GPrint(hdc,120,4,STR$(rc.right-rc.left) + "," + STR$(rc.bottom-rc.top))
   EndDraw(hSizePosStat,hdc)
   g_FileSaved = 0
END SUB

SUB LoadForm(filename$)
   DIM RAW i, fname$
   DIM RAW W, H
   DIM RAW Style, ExtStyle, caption$

   IF NewForm() = IDCANCEL THEN EXIT SUB

   IF NOT EXIST(filename$) THEN
      fname$ = GETFILENAME$("Load Form","Form Files (*.bmf)|*.bmf",0,Form1)
      IF NOT *fname$ THEN EXIT SUB
      IF fname$ <> TRIM$(GetMenuText$(FileMenu, IDM_LASTFILE)) THEN
         'reset the menu Last file to the new last file string
         CALL SetMenuText(FileMenu, IDM_LASTFILE, g_LastFileName$)
      END IF
   ELSE
      fname$ = filename$
   END IF
   IF UCASE$(BCXSPLITPATH$(fname$,16)) <>  ".TMP" THEN
      g_LastFileName$ = fname$
   END IF
   IF NOT EXIST(fname$) THEN EXIT SUB
   ControlIndex = ReadIniInt(fname$ , "FORM1", TRIM$("Controls"), 0)
   IF NOT ControlIndex THEN      'Possibly old style form
      CALL LoadOldForm(fname$)
      EXIT SUB
   END IF
   W = ReadIniInt(fname$, "FORM1", "Width", 100)
   H = ReadIniInt(fname$, "FORM1", "Height", 100)
   SizeWindow(Form1, W, H)

   BCX_SET_TEXT (Form1, BCXSPLITPATH$(fname$,8)) ' Add the File name to the loaded form

   FOR i = 1 TO ControlIndex
      hctl[i].ctype = ReadIniInt(fname$ , "CONTROL" & TRIM$(STR$(i)),"Type#", 0)
      hctl[i].rect.left = ReadIniInt(fname$ , "CONTROL" & TRIM$(STR$(i)), "Left", 1)
      hctl[i].rect.top = ReadIniInt(fname$ , "CONTROL" & TRIM$(STR$(i)), "Top", 1)
      hctl[i].rect.right = hctl[i].rect.left + ReadIniInt(fname$ , "CONTROL" & TRIM$(STR$(i)), "Width", 100)
      hctl[i].rect.bottom = hctl[i].rect.top + ReadIniInt(fname$ , "CONTROL" & TRIM$(STR$(i)), "Height",100)
      Style = ReadIniInt(fname$ , "CONTROL" & TRIM$(STR$(i)),"Style", 0)
      ExtStyle = ReadIniInt(fname$ , "CONTROL" & TRIM$(STR$(i)),"Ext_Style", 0)
      caption$ = ReadIniString$(fname$, "CONTROL" & TRIM$(STR$(i)),"Text")

      cType = hctl[i].ctype
      hctl[i].hWnd = CreateControlEx(Form1, &hctl[i].rect, Style, ExtStyle, caption$)

      hctl[i].backcolor  = -1
      caption$ = ReadIniString$(fname$, "CONTROL" & TRIM$(STR$(i)),"Color")
      IF LEN(caption$) THEN
         hctl[i].forecolor  = VAL(STRTOKEN$(caption$,CHR$(44), 1))
         hctl[i].backcolor  = VAL(STRTOKEN$(caption$,CHR$(44), 2))
         IF (hctl[i].forecolor) OR (hctl[i].backcolor <> -1)  THEN
             hctl[i].UseColor   = TRUE
         END IF
      END IF
      caption$ = ReadIniString$(fname$, "CONTROL" & TRIM$(STR$(i)),"Font")
      IF LEN(caption$) THEN
         IF LEN (STRTOKEN$(caption$, CHR$(44), 1)) THEN
         hctl[i].font.Font_name$         = STRTOKEN$(caption$, CHR$(44), 1)
         hctl[i].font.Font_size          = VAL(STRTOKEN$(caption$, CHR$(44), 2))
         hctl[i].font.Font_italic        = VAL(STRTOKEN$(caption$, CHR$(44), 3))
         hctl[i].font.Font_underline     = VAL(STRTOKEN$(caption$, CHR$(44), 4))
         hctl[i].font.Font_strikethrough = VAL(STRTOKEN$(caption$, CHR$(44), 5))
         hctl[i].font.Font_weight        = VAL(STRTOKEN$(caption$, CHR$(44), 6))
         END IF
      END IF
      IF LEN(hctl[i].font.Font_name$ ) THEN
         hctl[i].font.hFnt = BCX_SET_FONT( hctl[i].font.Font_name$, _
         hctl[i].font.Font_size, hctl[i].font.Font_weight, _
         hctl[i].font.Font_italic, hctl[i].font.Font_underline, _
         hctl[i].font.Font_strikethrough )
         SNDMSG(hctl[i].hWnd, WM_SETFONT, hctl[i].font.hFnt, TRUE)
      END IF
      hctl[i].zorder = i
   NEXT
   cType = CurIdx = 0
   SNDMSG(GetDlgItem(toolbox2,IDC_SEL-1), TB_CHECKBUTTON, IDC_SEL, MAKELONG(TRUE,0))
   HIDE(GriphWnd)
   REFRESH(Form1)
   g_FileSaved = 1
END SUB

'Old style form
SUB LoadOldForm(filename$)
   '6/15/08 DW & IDC changed this to properly load .bmf files
   DIM RAW i, fname$
   DIM RAW W, H
   DIM RAW Style, ExtStyle, caption$

   OPEN filename$ FOR INPUT AS FP1

   FINPUT FP1, W, H
   SizeWindow(Form1, W, H)
   BCX_SET_TEXT (Form1, BCXSPLITPATH$(fname$,8)) ' Add the File name to the loaded form
   FINPUT FP1, ControlIndex

   FOR i = 1 TO ControlIndex
      FINPUT FP1, hctl[i].ctype
      FINPUT FP1, hctl[i].rect.left, hctl[i].rect.top, hctl[i].rect.right, hctl[i].rect.bottom
      FINPUT FP1, Style
      FINPUT FP1, ExtStyle
      LINE INPUT FP1, caption$
      hctl[i].backcolor  = -1
      IF INSTR(caption$, "COLOR,",1,1) THEN
         hctl[i].forecolor  = VAL(STRTOKEN$(caption$,CHR$(44), 2))
         hctl[i].backcolor  = VAL(STRTOKEN$(caption$,CHR$(44), 3))
         IF (hctl[i].forecolor) OR (hctl[i].backcolor <> -1)  THEN
             hctl[i].UseColor   = TRUE
         END IF
         LINE INPUT FP1, caption$
      END IF
      IF INSTR(caption$, "FONT,",1) THEN
         hctl[i].font.Font_name$         = STRTOKEN$(caption$, CHR$(44), 2)
         hctl[i].font.Font_size          = VAL(STRTOKEN$(caption$, CHR$(44), 3))
         hctl[i].font.Font_italic        = VAL(STRTOKEN$(caption$, CHR$(44), 4))
         hctl[i].font.Font_underline     = VAL(STRTOKEN$(caption$, CHR$(44), 5))
         hctl[i].font.Font_strikethrough = VAL(STRTOKEN$(caption$, CHR$(44), 6))
         hctl[i].font.Font_weight        = VAL(STRTOKEN$(caption$, CHR$(44), 7))
         LINE INPUT FP1, caption$
      END IF
      cType = hctl[i].ctype
      hctl[i].hWnd = CreateControlEx(Form1, &hctl[i].rect, Style, ExtStyle, caption$)
      IF LEN(hctl[i].font.Font_name$ ) THEN
         hctl[i].font.hFnt = BCX_SET_FONT( hctl[i].font.Font_name$, _
         hctl[i].font.Font_size, hctl[i].font.Font_weight, _
         hctl[i].font.Font_italic, hctl[i].font.Font_underline, _
         hctl[i].font.Font_strikethrough )
         SNDMSG(hctl[i].hWnd, WM_SETFONT, hctl[i].font.hFnt, TRUE)
      END IF
      hctl[i].zorder = i
   NEXT
   CLOSE FP1

   cType = CurIdx = 0
   SNDMSG(GetDlgItem(toolbox2,IDC_SEL-1), TB_CHECKBUTTON, IDC_SEL, MAKELONG(TRUE,0))
   HIDE(GriphWnd)
   REFRESH(Form1)
   g_FileSaved = 1
END SUB

SUB SaveForm()
   DIM RAW filename$, MyMsg$, MsgRet, i
   DIM RAW rc AS RECT
   ' Set the current name as the default file name
   filename$ = BCX_GET_TEXT$(Form1) + ".bmf"
   filename$ = GETFILENAME$("Save Form", "Form Files (*.bmf)|*.bmf", 1, Form1, 0, "", filename$)
   IF NOT *filename$ THEN EXIT SUB
   filename$ = Check4Ext$(filename$,"bmf")
   IF EXIST(filename$) THEN
      MyMsg$ = "This file already exists. Save anyway?"
      MsgRet = MSGBOX(MyMsg$, "Save source file", MB_YESNO BOR MB_ICONQUESTION)
      IF MsgRet = IDNO THEN EXIT SUB
   END IF
   IF filename$ <> TRIM$(GetMenuText$(FileMenu, IDM_LASTFILE)) THEN
      'reset the menu Last file to the new last file string
      CALL SetMenuText(FileMenu, IDM_LASTFILE, g_LastFileName$)
   END IF

   'We are writing the whole file so Kill existing file
   KILL filename$
   g_LastFileName$ = filename$
   SaveBMF(filename$)
   g_FileSaved = 1 'TRUE
END SUB

SUB SaveBMF(filename$)
   DIM RAW MyMsg$, i
   DIM RAW rc AS RECT
   GetWindowRect(Form1,&rc)
   WritePrivateProfileString("FORM1", "Width" ,STR$(rc.right-rc.left), filename$)
   WritePrivateProfileString("FORM1", "Height" ,STR$(rc.bottom-rc.top), filename$)
   WritePrivateProfileString("FORM1", "Controls" , STR$(ControlIndex), filename$)
   FOR i = 1 TO ControlIndex
      WritePrivateProfileString("CONTROL" & TRIM$(STR$(i)), "Type#" ,STR$(hctl[i].ctype), filename$)
      WritePrivateProfileString("CONTROL" & TRIM$(STR$(i)), "Left" ,STR$(hctl[i].rect.left) ,filename$)
      WritePrivateProfileString("CONTROL" & TRIM$(STR$(i)), "Top" ,STR$(hctl[i].rect.top) ,filename$)
      WritePrivateProfileString("CONTROL" & TRIM$(STR$(i)), "Width" ,STR$(hctl[i].rect.right-hctl[i].rect.left) ,filename$)
      WritePrivateProfileString("CONTROL" & TRIM$(STR$(i)), "Height" ,STR$(hctl[i].rect.bottom-hctl[i].rect.top) ,filename$)
      WritePrivateProfileString("CONTROL" & TRIM$(STR$(i)), "Style" ,STR$(GetWindowLong(hctl[i].hWnd, GWL_STYLE)),filename$)
      WritePrivateProfileString("CONTROL" & TRIM$(STR$(i)), "Ext_Style" ,STR$(GetWindowLong(hctl[i].hWnd, GWL_EXSTYLE)),filename$)
      WritePrivateProfileString("CONTROL" & TRIM$(STR$(i)), "Color", STR$(hctl[i].forecolor) & "," &  STR$(hctl[i].backcolor), filename$)

      MyMsg$  = hctl[i].font.Font_name$ & "," & _
      STR$(hctl[i].font.Font_size) & "," & STR$(hctl[i].font.Font_italic) & ","  &  _
      STR$(hctl[i].font.Font_underline) & ","  &  STR$(hctl[i].font.Font_strikethrough ) & "," & _
      STR$(hctl[i].font.Font_weight)

      WritePrivateProfileString("CONTROL" & TRIM$(STR$(i)), "Font", MyMsg$ , filename$)
      WritePrivateProfileString("CONTROL" & TRIM$(STR$(i)), "Text", BCX_GET_TEXT$(hctl[i].hWnd), filename$)
   NEXT
END SUB

FUNCTION NewForm()

   DIM RAW MsgRet
   DIM RAW MyMsg$

   IF ControlIndex > 0 THEN
      IF NOT g_FileSaved THEN
         MyMsg$ = "Would you like to save the current form first?"
         MsgRet = MSGBOX(MyMsg$, "New Form:", MB_YESNOCANCEL)' BOR MB_ICONQUESTION)
         IF MsgRet = IDYES THEN
            CALL SaveForm
         ELSEIF MsgRet = IDCANCEL THEN
            FUNCTION = IDCANCEL
         END IF
      END IF
      FOR integer i = 1 TO ControlIndex
         DestroyWindow(hctl[i].hWnd)
         IF hctl[i].font.hFnt THEN
            DeleteObject(hctl[i].font.hFnt)
         END IF
         CALL ClearCntrlType(i)
      NEXT i
      ControlIndex = CurIdx = 0
   END IF

   IF GriphWnd THEN HIDE(GriphWnd)
   IF hCodegen THEN HIDE(hCodegen)
   UpdateSizePosStatus(&hctl[0].rect)
   BCX_SET_TEXT (Form1, "Form1")
   g_FileSaved = True

   FUNCTION = IDYES
END FUNCTION

SUB ClearCntrlType(idx)
   WITH hctl[idx]
      '.hWnd  = NULL
      .rect.top    = 0
      .rect.left   = 0
      .rect.right  = 0
      .rect.bottom = 0
      .ctype       = 0
      .disabled    = 0
      .selected    = 0
      .Group       = 0
      .zorder      = 0
      .UseColor    = 0
      .forecolor   = 0
      .backcolor   = -1
      .font.Font_name$ = ""
      .font.Font_size  = 0
      .font.hFnt       = 0
   END WITH
END SUB


SUB SaveFile
   DIM RAW filename$
   DIM RAW MsgRet
   DIM RAW MyMsg$
   DIM RAW tLen AS DWORD
   MyMsg$ = BCXSPLITPATH$(g_LastFileName$,6)
   filename$ = GETFILENAME$("Save Basic File","BAS Files(*.bas)|*.bas",1,Form1,0,MyMsg$)
   IF NOT *filename$ THEN EXIT SUB
   filename$ = Check4Ext$(filename$,"bas")     'IDC

   tLen = Edit_GetTextLength(hCGEdit)
   Print "Dim len: " & str$(tLen)
   DIM szText$ * tLen + 1
   szText$ = BCX_GET_TEXT$(hCGEdit)
   tLen = LEN(szText$)
   Print "string len: " & str$(tLen)
   IF EXIST(filename$) THEN
      MyMsg$ = "This file already exists. Save anyway?"
      MsgRet = MSGBOX(MyMsg$, "Save source file", MB_YESNO BOR MB_ICONQUESTION)
      IF MsgRet = IDNO THEN EXIT SUB
   END IF

   IF LEN(szText$) THEN
      OPEN filename$ FOR BINARY NEW AS FP1
      PUT$ FP1, szText$, tLen
      CLOSE FP1
   END IF

   g_FileSaved = 1
END SUB


SUB AutoSaveBak()
   DIM tmpname$
   tmpname$ = TEMPFILENAME$(TEMPDIR$, "BMF")
   WritePrivateProfileString( "Main", "LastTmpName", tmpname$, g_IniFileName$)
   CALL SaveBMF(tmpname$)
END SUB


SUB Saved_OK()
   DIM tmpname$
   tmpname$ = ReadIniString$(g_IniFileName$, "Main", "LastTmpName")
   PRINT  tmpname$
   KILL tmpname$
   WritePrivateProfileString( "Main", "LastTmpName", "", g_IniFileName$)
END SUB


SUB GPrint (hdc AS HDC, x, y, Text$)
   DIM RAW PrevBkMode
   PrevBkMode = SetBkMode(hdc, TRANSPARENT)
   TextOut(hdc, x, y, Text, LEN(Text))
   SetBkMode(hdc, PrevBkMode)
END SUB


FUNCTION Gradient(hdc AS HDC, BYREF rc AS RECT, Clr1 AS COLORREF, Clr2 AS COLORREF)

   DIM RAW r  = GETRVALUE(Clr1) AS BYTE
   DIM RAW g  = GETGVALUE(Clr1) AS BYTE
   DIM RAW b  = GETBVALUE(Clr1) AS BYTE
   DIM RAW r2 = GETRVALUE(Clr2) AS BYTE
   DIM RAW g2 = GETGVALUE(Clr2) AS BYTE
   DIM RAW b2 = GETBVALUE(Clr2) AS BYTE
   DIM RAW sr!, sg!, sb!
   DIM RAW height = 1 + (rc.bottom-rc.top)

   sr = ABS(r-r2)/height
   sg = ABS(g-g2)/height
   sb = ABS(b-b2)/height

   IF r2 < r THEN sr = -sr
   IF g2 < g THEN sg = -sg
   IF b2 < b THEN sb = -sb

   FOR INTEGER i = 0 TO height - 1
      r2=r+sr*i
      g2=g+sg*i
      b2=b+sb*i
      BCX_LINE(0,rc.left,rc.top+i,rc.right,rc.top+i,RGB(r2, g2, b2),hdc)
   NEXT

   FUNCTION = TRUE
END FUNCTION

SET ControlType[] AS PCHAR
   "BCX_EDIT(%CAP%,%HWND%,%ID%,%X%,%Y%,%W%,%H%, %STY%, %EXTSTY%)",            ' cType = 1
   "BCX_GROUP(%CAP%,%HWND%,%ID%,%X%,%Y%,%W%,%H%, %STY%, %EXTSTY%)",           ' cType = 2
   "BCX_BUTTON(%CAP%,%HWND%,%ID%,%X%,%Y%,%W%,%H%, %STY%, %EXTSTY%)",          ' cType = 3
   "BCX_CHECKBOX(%CAP%,%HWND%,%ID%,%X%,%Y%,%W%,%H%, %STY%, %EXTSTY%)",        ' cType = 4
   "BCX_RADIO(%CAP%,%HWND%,%ID%,%X%,%Y%,%W%,%H%, %STY%, %EXTSTY%)",           ' cType = 5
   "BCX_COMBOBOX(%CAP%,%HWND%,%ID%,%X%,%Y%,%W%,%H%, %STY%, %EXTSTY%)",        ' cType = 6
   "BCX_LISTBOX(%CAP%,%HWND%,%ID%,%X%,%Y%,%W%,%H%, %STY%, %EXTSTY%)",         ' cType = 7
   "BCX_CONTROL(%CLASS%,%HWND%,%CAP%,%ID%,%X%,%Y%,%W%,%H%, %STY%, %EXTSTY%)", ' cType = 8
   "BCX_CONTROL(%CLASS%,%HWND%,%CAP%,%ID%,%X%,%Y%,%W%,%H%, %STY%, %EXTSTY%)", ' cType = 9
   "BCX_WHITERECT(%CAP%,%HWND%,%ID%,%X%,%Y%,%W%,%H%, %STY%, %EXTSTY%)",       ' cType = 10
   "BCX_BITMAP(%CAP%,%HWND%,%ID%,%X%,%Y%,%W%,%H%, 0, %STY%, %EXTSTY%)",       ' cType = 11
   "BCX_LABEL(%CAP%,%HWND%,%ID%,%X%,%Y%,%W%,%H%, %STY%, %EXTSTY%)",           ' cType = 12
   "BCX_CONTROL(%CLASS%,%HWND%,%CAP%,%ID%,%X%,%Y%,%W%,%H%, %STY%, %EXTSTY%)", ' cType = 13
   "BCX_RICHEDIT(%CAP%,%HWND%,%ID%,%X%,%Y%,%W%,%H%, %STY%, %EXTSTY%)",        ' cType = 14
   "BCX_PROGRESSBAR(%CAP%,%HWND%,%ID%,%X%,%Y%,%W%,%H%, %STY%, %EXTSTY%)",     ' cType = 15
   "BCX_UPDOWN(%HWND%,%X%,%Y%,%W%,%H%,%LO%,%HI%,%START%)",                    ' cType = 16
   "BCX_LISTVIEW(%CAP%,%HWND%,%ID%,%X%,%Y%,%W%,%H%,%STY%,%EXTSTY%,%NUMCOLS%)", ' cType = 17
   "BCX_TREEVIEW(%CAP%,%HWND%,%ID%,%X%,%Y%,%W%,%H%, %STY%, %EXTSTY%)",        ' cType = 18
   "BCX_SLIDER(%CAP%,%HWND%,%ID%,%X%,%Y%,%W%,%H%, 0, %STY%, %EXTSTY%)",       ' cType = 19
   "BCX_BMPBUTTON(%CAP%,%HWND%,%ID%,%X%,%Y%,%W%,%H%, 0, %STY%, %EXTSTY%)",    ' cType = 20
   "BCX_DATEPICK(%CAP%,%HWND%,%ID%,%X%,%Y%,%W%,%H%, %STY%, %EXTSTY%)",        ' cType = 21
   "BCX_CONTROL(%CLASS%,%HWND%,%CAP%,%ID%,%X%,%Y%,%W%,%H%, %STY%, %EXTSTY%)", ' cType = 22
   "BCX_CONTROL(%CLASS%,%HWND%,%CAP%,%ID%,%X%,%Y%,%W%,%H%, %STY%, %EXTSTY%)", ' cType = 23
   "BCX_CONTROL(%CLASS%,%HWND%,%CAP%,%ID%,%X%,%Y%,%W%,%H%, %STY%, %EXTSTY%)", ' cType = 24
   "BCX_CONTROL(%CLASS%,%HWND%,%CAP%,%ID%,%X%,%Y%,%W%,%H%, %STY%, %EXTSTY%)", ' cType = 25
   "BCX_raGrid(%HWND%,%ID%,%X%,%Y%,%W%,%H%, %STY%, %EXTSTY%)",                ' cType = 26
   "BCX_INPUT(%CAP%,%HWND%,%ID%,%X%,%Y%,%W%,%H%, %STY%, %EXTSTY%)"            ' cType = 27

END SET



SET ControlDescID[] AS PCHAR
   "Edt",
   "Grp",
   "Btn",
   "Chk",
   "Rad",
   "Cmb",
   "Lst",
   "Hsl",
   "Vsl",
   "Frm",
   "Pic",
   "Stc",
   "Ani",
   "Rih",
   "Prg",
   "Upd",
   "Lvw",
   "Trv",
   "Trk",
   "Bmp",
   "Dat",
   "Cal",
   "Ipa",
   "Usr",
   "Ico",
   "Grd",
   "Inp",
   ""
END SET


SUB CreateFormCode()
   DIM RAW dwExStyle$
   DIM RAW lpClassName$
   DIM RAW lpWindowName$
   DIM RAW dwStyle$
   DIM RAW x$
   DIM RAW y$
   DIM RAW nWidth$
   DIM RAW nHeight$
   DIM RAW hMenu$
   DIM RAW lpTemp$
   DIM RAW rc AS RECT
   DIM TempCtrl$ * 100000
   DIM RAW i , addGridCode = 0
   DIM GridCode$ * 10000

   DIM AUTO Styleidx[MaxToolTypes], ctype

   CALL SetZorder
   

   dim scale!
   scale = VAL(INPUTBOX$("Scale Controls", "Enter scale value", "1.0"))
 

   SendMessage(hCGEdit, WM_SETTEXT, 0, "")

   GetWindowRect(Form1,&rc)
   TempCtrl$ = "GUI " + ENC$("Form1") + ",PIXELS" + CRLF$ + CRLF$

   TempCtrl$ = TempCtrl$ + EmitStyleConst$() + CRLF$ + EmitEnums$() + CRLF$ + EmitHandles$() + CRLF$
   TempCtrl$ = TempCtrl$ + CtrlColorGlobals$() 'vi)

   TempCtrl$ = TempCtrl$ + "SUB FORMLOAD()" + CRLF$
   'TempCtrl$ = TempCtrl$ + "   DIM hFont AS HFONT" + CRLF$
   TempCtrl$ = TempCtrl$ + "   Form1 = BCX_FORM(" + ENC$("Form1") + ", 0, 0," + STR$(rc.right-rc.left) + "," + STR$(rc.bottom-rc.top)+ ")" + CRLF$

   FOR i = 1 TO ControlIndex

      ctype = hctl[i].ctype - 1
      INCR Styleidx[ctype]


      ' extended window style
      dwExStyle$ = ControlDescID$[ctype] + LTRIM$(STR$(Styleidx[ctype])) + "_ExtStyle"

      ' registered class name
      GetClassName(hctl[i].hWnd, lpClassName$, 2048)

      ' window name
      GetWindowText(hctl[i].hWnd, lpWindowName$, 2048)

      ' window style
      dwStyle$ = ControlDescID$[ctype] + LTRIM$(STR$(Styleidx[ctype])) + "_Style"

      ' horizontal position of window
      x$ = STR$(CINT((float)hctl[i].rect.left / scale))

      ' vertical position of window
      y$ = STR$(CINT((float)hctl[i].rect.top / scale))

      ' window width
      nWidth$ = STR$(CINT(((float)hctl[i].rect.right-hctl[i].rect.left) / scale))

      ' window height
      nHeight$ = STR$(CINT(((float)hctl[i].rect.bottom-hctl[i].rect.top) / scale))

      hMenu$ = "ID_" + ControlDescID$[ctype] + LTRIM$(STR$(Styleidx[ctype]))
      'STR$(GetWindowLong(hctl[i].hWnd, GWL_ID))

      lpTemp$ = "   h" + ControlDescID$[ctype] + LTRIM$(STR$(Styleidx[ctype])) + " = " _
      + ControlType[ctype]
      lpTemp$ = REPLACE$(lpTemp$, "%HWND%", "Form1")
      lpTemp$ = REPLACE$(lpTemp$, "%ID%", hMenu$)
      lpTemp$ = REPLACE$(lpTemp$, "%EXTSTY%", dwExStyle$)
      lpTemp$ = REPLACE$(lpTemp$, "%CLASS%", ENC$(lpClassName$))
      lpTemp$ = REPLACE$(lpTemp$, "%CAP%",   ENC$(lpWindowName$))
      lpTemp$ = REPLACE$(lpTemp$, "%STY%", dwStyle$)
      lpTemp$ = REPLACE$(lpTemp$, "%X%", x$)
      lpTemp$ = REPLACE$(lpTemp$, "%Y%", y$)
      lpTemp$ = REPLACE$(lpTemp$, "%W%", nWidth$)
      lpTemp$ = REPLACE$(lpTemp$, "%H%", nHeight$)
      TempCtrl$ = TempCtrl$ + lpTemp$ + CRLF$

      IF LEN(hctl[i].font.Font_name$) THEN
         TempCtrl$ = TempCtrl$ & "   " & _
         AddFontCode$ ("h" + ControlDescID$[ctype] + LTRIM$(STR$(Styleidx[ctype])),hctl[i]) _
         & CRLF$
      END IF
      'Add Color Code
      IF hctl[i].UseColor  THEN
         TempCtrl$ = TempCtrl$ & "   " & ControlDescID$[ctype] + LTRIM$(STR$(Styleidx[ctype])) & "_FC = "  & STR$(hctl[i].forecolor) & _
         " : " & ControlDescID$[ctype] + LTRIM$(STR$(Styleidx[ctype])) & "_BC = "  & STR$(hctl[i].backcolor) & CRLF$
      END IF
      IF ctype = 25 THEN
         addGridCode++
         GridCode$ = GridCode$ + Save_Blank_GridSetup$(ControlDescID$[ctype]+ LTRIM$(STR$(Styleidx[ctype])))
         TempCtrl$ = TempCtrl$ & "   CALL GridSetup" + ControlDescID$[ctype]+ LTRIM$(STR$(Styleidx[ctype]))+"(h" & ControlDescID$[ctype] +  LTRIM$(STR$(Styleidx[ctype])) +")"  + CRLF$
      END IF
   NEXT i

   TempCtrl$ = TempCtrl$ + "   CENTER(Form1)" + CRLF$
   TempCtrl$ = TempCtrl$ + "   SHOW(Form1)" + CRLF$
   TempCtrl$ = TempCtrl$ + "END SUB" + CRLF$ + CRLF$

   'Add the Events Loop
   TempCtrl$ = TempCtrl$ + "BEGIN EVENTS"+ CRLF$
   TempCtrl$ = TempCtrl$ + " SELECT CASE CBMSG" & CRLF$

   'Add Color Event if neccessary
   lpTemp$ = CtrlColorEvents$()
   IF LEN(lpTemp$) THEN
      TempCtrl$ = TempCtrl$ + "    CASE WM_CTLCOLORSTATIC, WM_CTLCOLOREDIT,WM_CTLCOLORLISTBOX" & CRLF$
      TempCtrl$ = TempCtrl$ + "      SELECT CASE (HWND)CBLPARAM" & CRLF$'

      'Add Color events
      TempCtrl$ = TempCtrl$ + lpTemp$ & CRLF$

      TempCtrl$ = TempCtrl$ + "      END SELECT" & CRLF$
   END IF ' color Events
   TempCtrl$ = TempCtrl$ + "   CASE WM_COMMAND" & CRLF$
   TempCtrl$ = TempCtrl$ + "      SELECT CASE CBCTL" & CRLF$

   'Add control Events
   TempCtrl$ = TempCtrl$ + CtrlEvents$(EmitEnums$())

   TempCtrl$ = TempCtrl$ + "      END SELECT" & CRLF$
   TempCtrl$ = TempCtrl$ + " END SELECT" & CRLF$
   TempCtrl$ = TempCtrl$ + "END EVENTS" + CRLF$

   IF addGridCode THEN   ' it's RAGrid   remember ctype = ctype-1 above
      'If the user has an BCXLIB folder look in there
      IF EXIST (ENVIRON$("BCXLIB")  & "\BCXraGrid.inc")  THEN
         TempCtrl$ = "$INCLUDE " + "<BCXraGrid.inc>"+ CRLF$ + CRLF$ + TempCtrl$ + CRLF$
         TempCtrl$ = "'Using BCXLIB Path" + CRLF$ + TempCtrl$ + CRLF$
      ELSE  'now up to the user to add to app folder or set the path
         TempCtrl$ = "$INCLUDE " + ENC$("BCXraGrid.inc")+ CRLF$ + CRLF$ + TempCtrl$ + CRLF$
         TempCtrl$ = "'raGrid files pathed to current folder " + CRLF$ + TempCtrl$
      END IF
      TempCtrl$ = TempCtrl$ +  GridCode$
   END IF

   SendMessage(hCGEdit, WM_SETTEXT, 0, TempCtrl$)
   'g_FileSaved = 1  ' We don't want this here !!!
END SUB

FUNCTION AddFontCode$(lpWindowName$,  tCtrl AS CONTROLS)
   DIM RAW fontcode$

   fontcode$ = "BCX_SET_FONT(" & lpWindowName$ & "," &  ENC$(TRIM$(tCtrl.font.Font_name$)) & "," & STR$(tCtrl.font.Font_size) & ","
   fontcode$ = fontcode$ & STR$(tCtrl.font.Font_weight) & "," & STR$(tCtrl.font.Font_italic) & ","
   fontcode$ = fontcode$ & STR$(tCtrl.font.Font_underline) & "," & STR$(tCtrl.font.Font_strikethrough) & ")"
   FUNCTION = fontcode$
END FUNCTION

FUNCTION EmitStyleConst$()

   DIM RAW i, ctype
   DIM AUTO Styleidx[MaxToolTypes]
   DIM styles$ * 50000
   DIM RAW TmpStyle$

   FOR i = 1 TO ControlIndex

      ctype = hctl[i].ctype - 1
      INCR Styleidx[ctype]

      ' window style
      styles$ = styles$ + "CONST " + ControlDescID$[ctype] + LTRIM$(STR$(Styleidx[ctype])) + "_Style    = "
      styles$ = styles$ + FillStyleLists$(hctl[i].hWnd, 1, 0, FALSE) + CRLF$

      ' extended window style
      styles$ = styles$ + "CONST " + ControlDescID$[ctype] + LTRIM$(STR$(Styleidx[ctype])) + "_ExtStyle = "
      TmpStyle$ = FillStyleLists$(hctl[i].hWnd, 0, 1, FALSE)
      IF TmpStyle$ = "" THEN TmpStyle$ = "0"

      styles$ = styles$ + TmpStyle$ + CRLF$

   NEXT i

   FUNCTION = styles$
END FUNCTION



FUNCTION EmitEnums$()

   DIM RAW i, ctype
   DIM AUTO Styleidx[MaxToolTypes]
   DIM styles$ * 50000

   IF NOT ControlIndex THEN FUNCTION = ""

   styles$ = "ENUM" + CRLF$

   FOR i = 1 TO ControlIndex

      ctype = hctl[i].ctype - 1
      INCR Styleidx[ctype]

      styles$ = styles$ + "   ID_" + ControlDescID$[ctype] + LTRIM$(STR$(Styleidx[ctype])) + CRLF$
   NEXT i

   FUNCTION = styles$ + "END ENUM" + CRLF$
END FUNCTION


FUNCTION EmitHandles$()

   DIM RAW i, ctype
   DIM AUTO Styleidx[MaxToolTypes]
   DIM styles$ * 50000

   styles$ = "GLOBAL Form1 AS HWND" + CRLF$

   FOR i = 1 TO ControlIndex

      ctype = hctl[i].ctype - 1
      INCR Styleidx[ctype]

      styles$ = styles$ + "GLOBAL h" + ControlDescID$[ctype] + LTRIM$(STR$(Styleidx[ctype])) + " AS CONTROL" + CRLF$
   NEXT i

   FUNCTION = styles$
END FUNCTION


SUB InitVarInfo()
   VarInfo.curidx        = &CurIdx
   VarInfo.controlindex  = &ControlIndex
   VarInfo.holdctl       = hctl
   VarInfo.copy          = CopyControl
   VarInfo.ControlDesc   = ControlDescID;
   VarInfo.ControlTypes  = ControlType;
   VarInfo.Forms         = &Form1
   VarInfo.hEdit         = &hCGEdit
   VarInfo.EStyleConst   = EmitStyleConst;
   VarInfo.GetStyleConst = FillStyleLists;
   VarInfo.EEnums        = EmitEnums;
   VarInfo.EHandles      = EmitHandles;
   VarInfo.Zorder        = SetZorder
   VarInfo.Savit         = SaveFile
   VarInfo.SaveBCXCode   = CreateFormCode
   VarInfo.LoadForm      = LoadForm
   VarInfo.plgn_ScaleX   = &(BCX_SCALEX)
   VarInfo.plgn_ScaleY   = &(BCX_SCALEY)
END SUB

SUB LoadPlugins()
   DIM RAW sTemp$
   DIM RAW tmpPath$
   DIM RAW hPlugin AS HMODULE
   DIM AUTO MI AS PluginMenuInfo
   DIM FUNCTION hDllExport() AS LPPLUGIN_INTERFACE
   iCount = 0
   
   tmpPath$ = CURDIR$
   CHDIR APPEXEPATH$
   sTemp$ = FINDFIRST$("BMFD*.dll")
   'Check to see If there are any plugins in the array

   'Now we must loop thru all plugins and load the appropriate ones.
   'start
   DO WHILE sTemp$ <> ""
      hPlugin = LOADLIBRARY(sTemp$)

      IF hPlugin <> 0 THEN
         hDllExport = (hDllExport_TYPE)GetProcAddress(hPlugin, "GetMyPluginInterface")
         IF hDllExport THEN
            MyPlugin[iCount] = *hDllExport()
            MyPlugin[iCount].PlugInMenu = CreateMenu()
            MyPlugin[iCount].MakeMenu(&(MyPlugin[iCount].PlugInMenu),PluginOffset+iCount*1000)
            iCount++
         END IF
      END IF
      sTemp$ = FINDNEXT$
   LOOP
   CHDIR tmpPath$
END SUB

SUB HandlePlugin(MSGID)
   DIM I
   DIM P
   I = MSGID - PluginOffset
   P = I / 1000
   I = I - P * 1000
   IF NOT hCodegen THEN
      ' create code generator window
      hCodegen = BCX_MDICHILD("Code Generator", "CodeChildWndProc")
   END IF
   CALL AutoSaveBak()
   MyPlugin[P].Flist[I-1]->PluginFunction(&VarInfo)
   CALL Saved_OK()
   REFRESH(Form1)
END SUB

$COMMENT
' Functions not being used
' #########################################################################
'   abstract:   creates tooltip for any control
'   usage   :   MakeTooltip(hControl, "Tip Information", hInstance)
' #########################################################################

FUNCTION MakeTooltip(     _
   hwndOwner AS HWND,     _
   lpszText  AS LPSTR,    _
   hInst     AS HINSTANCE _
   ) AS BOOL

   DIM RAW  hwndTT AS HWND
   DIM AUTO ti     AS TOOLINFO
   DIM RAW  uid=0  AS WPARAM
   DIM RAW  rect   AS RECT

   ' create a tooltip window
   hwndTT = CreateWindowEx(WS_EX_TOPMOST, TOOLTIPS_CLASS, NULL,      _
   WS_POPUP | TTS_NOPREFIX | TTS_ALWAYSTIP, CW_USEDEFAULT,           _
   CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, hwndOwner, NULL, hInst, NULL)

   IF NOT hwndTT THEN
      FUNCTION = FALSE
   END IF

   SetWindowPos(hwndTT, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_NOACTIVATE)

   ' get coordinates of the main client area
   GetClientRect (hwndOwner, &rect)

   ' initialize members of the toolinfo structure
   ti.cbSize      = SIZEOF(TOOLINFO)
   ti.uFlags      = TTF_SUBCLASS
   ti.hwnd        = hwndOwner
   ti.hinst       = hInst
   ti.uId         = uid
   ti.lpszText    = lpszText

   ' tooltip control will cover the whole window
   ti.rect.left   = rect.left
   ti.rect.top    = rect.top
   ti.rect.right  = rect.right
   ti.rect.bottom = rect.bottom

   ' send an addtool message to the tooltip control window
   FUNCTION = SendMessage(hwndTT, TTM_ADDTOOL, 0, (LPTOOLINFO) &ti)
END FUNCTION


' #########################################################################
'   abstract:   creates rebar frame
'   usage   :   MakeRebar(hParent, hInstance)
' #########################################################################

FUNCTION MakeRebar( hwndOwner AS HWND, hInst AS HINSTANCE ) AS HWND

   DIM RAW  hwndRB AS HWND
   DIM AUTO rbi    AS REBARINFO

   hwndRB = CreateWindowEx(WS_EX_TOOLWINDOW, REBARCLASSNAME, NULL,   _
   WS_BORDER | WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN |             _
   WS_CLIPSIBLINGS | RBS_VARHEIGHT | RBS_AUTOSIZE |                  _
   RBS_BANDBORDERS | CCS_ADJUSTABLE | CCS_TOP | CCS_NODIVIDER, 0, 0, _
   0, 0, hwndOwner, NULL, hInst, NULL)

   IF NOT hwndRB THEN
      FUNCTION = NULL
   END IF

   ' initialize and send the rebarinfo structure
   rbi.cbSize = SIZEOF(REBARINFO)
   rbi.fMask  = 0
   rbi.himl   = (HIMAGELIST) NULL
   SendMessage(hwndRB, RB_SETBARINFO, 0, &rbi)

   FUNCTION = hwndRB
END FUNCTION

' #########################################################################
'   abstract:   adds a band to a rebar
'   usage   :   RebarAddBand(hParent, hControl, "Title of Band")
' #########################################################################

FUNCTION RebarAddBand(  _
   hwndOwner AS HWND,  _
   hwndChild AS HWND,  _
   lpTitle   AS LPSTR _
   ) AS BOOL

   DIM AUTO rbBand AS REBARBANDINFO

   ' initialize structure members that both bands will share
   rbBand.cbSize  = SIZEOF(REBARBANDINFO)
   rbBand.fMask   = RBBIM_TEXT | RBBIM_STYLE | RBBIM_CHILD | RBBIM_CHILDSIZE | RBBIM_SIZE
   rbBand.fStyle  = RBBS_CHILDEDGE | RBBS_GRIPPERALWAYS

   ' set values unique to the band
   rbBand.lpText     = lpTitle
   rbBand.cch        = 2
   rbBand.hwndChild  = hwndChild
   rbBand.cxMinChild = 0
   rbBand.cyMinChild = 0
   rbBand.cx         = 200

   ' add the band to rebar
   FUNCTION = SendMessage(hwndOwner, RB_INSERTBAND, -1, &rbBand)
END FUNCTION

' #########################################################################
'   abstract:   creates toolbar
'   usage   :   MakeToolbar(hParent, hInstance)
' #########################################################################

FUNCTION MakeToolbar( hwndOwner AS HWND, hInst AS HINSTANCE ) AS HWND

   DIM RAW hwndTB AS HWND

   hwndTB = CreateWindow(TOOLBARCLASSNAME, NULL, WS_CHILD | CCS_TOP |  _
   TBSTYLE_LIST | CCS_ADJUSTABLE | TBSTYLE_WRAPABLE | TBSTYLE_FLAT |   _
   WS_VISIBLE, 0, 0, 0, 0, hwndOwner, NULL, BCX_HINSTANCE, NULL)

   IF NOT hwndTB THEN
      FUNCTION = NULL
   END IF

   FUNCTION = hwndTB
END FUNCTION

' #########################################################################
'   abstract:   adds buttons to toolbar
'   usage   :   ToolbarAddButton(hParent, idCommand, hInstance)
' #########################################################################

SUB ToolbarAddButton(    _
   hwndOwner AS HWND,    _
   idCommand AS INTEGER, _
   lpTitle   AS LPSTR,   _
   dwStyle   AS BYTE)

   DIM AUTO tbb AS TBBUTTON

   ' send the TB_BUTTONSTRUCTSIZE message, which is required for
   ' backward compatibility
   SendMessage(hwndOwner, TB_BUTTONSTRUCTSIZE, SIZEOF(TBBUTTON), 0)

   ' fill the TBBUTTON array with button information, and add the
   ' buttons to the toolbar
   tbb.idCommand = idCommand
   tbb.fsState   = TBSTATE_ENABLED
   tbb.fsStyle   = dwStyle
   tbb.dwData    = 0
   tbb.iString   = SendMessage(hwndOwner, TB_ADDSTRING, 0, (LPARAM)      _
   lpTitle)
   tbb.iBitmap   = -2

   SendMessage(hwndOwner, TB_SETBUTTONSIZE, 0, MAKELONG(16, 16))
   SendMessage(hwndOwner, TB_ADDBUTTONS, 1, (LPTBBUTTON) &tbb)
END SUB
$COMMENT


SUB SnapCtrlsToGrid(hWnd AS HWND, BYREF ctrlRect AS RECT) 'IDC Dec '07
   'Used to snap the control size and position to the grid
   IF SnapState THEN          'IDC snap
      ctrlRect.top    = CINT((double)ctrlRect.top/SnapSize)    * SnapSize
      ctrlRect.left   = CINT((double)ctrlRect.left/SnapSize)   * SnapSize
      ctrlRect.bottom = CINT((double)ctrlRect.bottom/SnapSize) * SnapSize
      ctrlRect.right  = CINT((double)ctrlRect.right/SnapSize)  * SnapSize
   END IF
   g_FileSaved = 0
END SUB

FUNCTION Check4Ext$ OPTIONAL(FileName$, FileExt$ = "bas")
   'IDC changed this 6/15/08 to add correct file extension
   FileName$ = BCXSPLITPATH$(FileName$, FDRV | FPATH | FNAME)
   FUNCTION = FileName$ & "." & FileExt$
END FUNCTION


FUNCTION GetMenuText$(hMenu AS HMENU, ID AS INT)
   DIM menuInfo AS MENUITEMINFO
   DIM tmp$ ' as string Ptr
   menuInfo.cbSize     = SIZEOF(MENUITEMINFO)
   menuInfo.fMask      = MIIM_DATA | MIIM_TYPE
   menuInfo.fType      = MFT_STRING
   menuInfo.dwTypeData = tmp
   menuInfo.cch        = SIZEOF(tmp$)
   GetMenuItemInfo(hMenu, ID, 0, &menuInfo)
   FUNCTION = tmp$
END FUNCTION


SUB SetMenuText( hMenu AS HMENU, ID AS INT, NewText$)
   DIM menuInfo AS MENUITEMINFO
   menuInfo.cbSize     = SIZEOF(MENUITEMINFO)
   menuInfo.fMask      = MIIM_DATA | MIIM_TYPE
   menuInfo.fType      = MFT_STRING
   menuInfo.wID        = ID
   menuInfo.dwTypeData = NewText$
   menuInfo.cch        = LEN(NewText$)
   SetMenuItemInfo(hMenu, ID, FALSE, &menuInfo)
END SUB


SUB GetDialogScale (hdlg as HWND, BYREF Xscale!, BYREF Yscale!)
 DIM RAW rc = {0, 0, 4, 8} AS RECT

 MapDialogRect (hdlg, &rc)
 Xscale = (float)rc.right/4.0
 Yscale = (float)rc.bottom/8.0
END SUB
