'BMFD_Ini_File_code.inc
'Added by Ian Casey Dec 15 2007

Function BMFD_Get_Ini(IniFile$)
   GridState = ReadIniInt(IniFile$, "Main", "GridState", true)
   SnapState = ReadIniInt(IniFile$, "Main", "SnapState", true)
   SnapSize  = ReadIniInt(IniFile$, "Main", "SnapSize", 8)
   SetZorderFlag  = ReadIniInt(IniFile$, "Main", "Zorder", FALSE)
   g_LastFileName$ = ReadIniString$(IniFile$, "Main", "LastFileName")
   Version$ =  ReadIniString$(IniFile$, "Main", "Version")
   Function = GetLastError()
End Function

Function BMFD_Put_Ini(IniFile$)
  WritePrivateProfileString( "Main", "GridState", str$(GridState), IniFile$)
  WritePrivateProfileString( "Main", "SnapState", str$(SnapState), IniFile$)
  WritePrivateProfileString( "Main", "SnapSize", str$(SnapSize), IniFile$)
  WritePrivateProfileString( "Main", "Zorder", str$(SetZorderFlag), IniFile$)
  WritePrivateProfileString( "Main", "LastFileName", g_LastFileName$, IniFile$)
  WritePrivateProfileString( "Main", "Version", Version$, IniFile$)
  Function = GetLastError()
End Function

'##########################################################
'###   Reads the screen coordinates of a form from an ini file
'### Usage: WindowState = GetWindowFromIni(INFileName$, "Screen", Form1, "MAIN FORM", &DefaultRect)
'### OR:    ShowWindow (Form1, GetWindowFromIni(INFileName$, "Screen", Form1, "MAIN FORM", &DefaultRect ))
'### By: IDC  April 2006
'##########################################################
FUNCTION GetWindowFromIni(IniFile$, Header$, ctrlname as HWND, KeyName$, ByRef rc As RECT) As Integer
  Dim AUTO WP as WINDOWPLACEMENT
    WP.length = sizeof(WINDOWPLACEMENT)
    WP.showCmd = ReadIniInt(IniFile$, Header$, KeyName$ & ".state", SW_SHOWNORMAL)
    WP.rcNormalPosition.left   = ReadIniInt(IniFile$, Header$, KeyName$ & ".left", rc.left)
    WP.rcNormalPosition.top    = ReadIniInt(IniFile$, Header$, KeyName$ & ".top", rc.top)
    WP.rcNormalPosition.right  = ReadIniInt(IniFile$, Header$, KeyName$ & ".right", rc.right)
    WP.rcNormalPosition.bottom = ReadIniInt(IniFile$, Header$, KeyName$ & ".bottom", rc.bottom)
    SetWindowPlacement (ctrlname, &WP)
    FUNCTION = WP.showCmd
END FUNCTION

'##########################################################
'###   Writes the screen coordinates of a form to an ini file
'### Usage: Call PutWindowToIni(INFileName$, Form1, "MAP")
'### By: IDC  April 2006
'##########################################################
SUB PutWindowToIni(IniFile$, Header$, ctrlname as HWND, KeyName$)
  Dim WP as WINDOWPLACEMENT
    WP.length = sizeof(WINDOWPLACEMENT)
    GetWindowPlacement(ctrlname,&WP)
    WritePrivateProfileString( Header$, KeyName$ & ".state", Str$(WP.showCmd), IniFile$)
    WritePrivateProfileString( Header$, KeyName$ & ".left", Str$(WP.rcNormalPosition.left), IniFile$)
    WritePrivateProfileString( Header$, KeyName$ & ".top", Str$(WP.rcNormalPosition.top), IniFile$)
    WritePrivateProfileString( Header$, KeyName$ & ".right", Str$(WP.rcNormalPosition.right), IniFile$)
    WritePrivateProfileString( Header$, KeyName$ & ".bottom", Str$(WP.rcNormalPosition.bottom), IniFile$)
END SUB

'##########################################################
'###   Reads an ini string from ini file
'##########################################################
function ReadIniString$(IniFile$, Header$, Key$ )
dim Buffer$
  Buffer$ = space$(2048)
  GetPrivateProfileString( Header$, Key$, "", Buffer$, 2048, IniFile$ )
  function = trim$(Buffer$)
end function

'##########################################################
'###   Reads an integer from ini file
'##########################################################
function ReadIniInt(IniFile$, Header$, Key$, Default as LONG ) as UINT
  function = GetPrivateProfileInt( Header$, Key$, Default, IniFile$ )
end function
