'Simple plugin interface
$DLL

$include "SaveAsMDIForms.inc"
$include "AddThisMenu.inc"
'$include "Bas2Bmfd.bas"


TYPE ctrlFont
 Font_name[128] as char
 Font_charset
 Font_weight
 Font_size
 Font_underline
 Font_italic
 Font_strikethrough
 hFont AS HFONT
END TYPE

TYPE CONTROLS
   hWnd     AS HWND
   rect     AS RECT
   ctype
   disabled
   selected
   zorder
   Group
   UseColor AS BOOL
   forecolor
   backcolor
   font as ctrlFont
END TYPE

TYPE CTRLCOPY
   CtrlClone AS CONTROLS
   sty       AS DWORD
   extsty    AS DWORD
   caption$
END TYPE

TYPE VARINFO
  DIM curidx AS INTEGER PTR
  DIM controlindex AS INTEGER PTR
  DIM holdctl AS CONTROLS PTR
  DIM copy AS CTRLCOPY PTR
  DIM ControlDesc AS CHAR PTR PTR
  DIM ControlTypes AS CHAR PTR PTR
  DIM Forms AS HWND PTR
  DIM hEdit AS HWND PTR
  FUNCTION EStyleConst() AS  CHAR PTR
  FUNCTION GetStyleConst(hwndTarget AS HWND ,hwndStyleList ,hwndExStyleList ,fAllStyles AS BOOL ) AS CHAR PTR
  FUNCTION EEnums() AS CHAR PTR
  FUNCTION EHandles() AS CHAR PTR
  SUB Zorder()' AS SUB
  SUB Savit() 'AS SUB
  SUB SaveBCXCode()
  SUB LoadForm(filename$)
  DIM plgn_ScaleX AS SINGLE PTR
  DIM plgn_ScaleY AS SINGLE PTR
  'FUNCTION AddMenu() AS INTEGER PTR
END TYPE

'******************************************

TYPE FunctionList
  sFuncName$[100] AS CHAR
  Function PluginFunction(vi AS VARINFO PTR) As Integer
END TYPE

TYPE PluginMenuInfo
  MF AS INTEGER
  PI AS INTEGER
  SL[20] AS CHAR
END TYPE

Type PLUGIN_INTERFACE
  sName$[100] As CHAR
  SUB MakeMenu(i AS HMENU PTR, PID AS INTEGER)
  PlugInMenu AS HMENU
  FunctionCount AS INTEGER
  Flist AS FunctionList PTR PTR
End Type

Global MyPlugin As PLUGIN_INTERFACE
Global formName as STRING
Global SaveModal as INTEGER
GLOBAL SaveMDIClient as INTEGER
GLOBAL SaveMDIChild as INTEGER
GLOBAL MenuCode$     'to add Menu Code to the output
GLOBAL g_MenuMakePath$

CONST MaxToolTypes = 30

'CONST PIDM_0 = 0
CONST PIDM_1 = 1
CONST PIDM_2 = 2
CONST PIDM_3 = 3
CONST PIDM_4 = 4
CONST PIDM_5 = 5
CONST PIDM_6 = 6
CONST PIDM_7 = 7
CONST PIDM_8 = 8
CONST PIDM_9 = 9
CONST PIDM_10 = 10

'Export the structure
Function GetMyPluginInterface As LPPLUGIN_INTERFACE EXPORT
  DIM i
  MyPlugin.sName$ = "Import/Export"
  MyPlugin.MakeMenu = MakePluginMenu
  MyPlugin.FunctionCount = 7
  MyPlugin.Flist = calloc(MyPlugin.FunctionCount,sizeof(FunctionList PTR))
  FOR i = 0 TO MyPlugin.FunctionCount-1
    MyPlugin.Flist[i] = calloc(1,sizeof(FunctionList))
  NEXT
  MyPlugin.Flist[0]->PluginFunction = Create_BCX_Form_Code '
  MyPlugin.Flist[0]->sFuncName$ = "BCX Form Code"
  MyPlugin.Flist[2]->PluginFunction = Create_OOP_Form_Code '
  MyPlugin.Flist[2]->sFuncName$ = "OOP"
  MyPlugin.Flist[3]->PluginFunction = Create_OOP_Modal_Form_Code '
  MyPlugin.Flist[3]->sFuncName$ = "OOP MODAL"
  MyPlugin.Flist[1]->PluginFunction = CreateModalFormCode '
  MyPlugin.Flist[1]->sFuncName$ = "BCX MODAL CODE"
  MyPlugin.Flist[4]->PluginFunction = Create_MDIParent_Form_Code '
  MyPlugin.Flist[4]->sFuncName$ = "BCX MDI CLIENT CODE"
  MyPlugin.Flist[5]->PluginFunction = Create_MDIChild_Form_Code '
  MyPlugin.Flist[5]->sFuncName$ = "BCX MDI CHILD CODE"
  MyPlugin.Flist[6]->PluginFunction = RunMenuMaker
  MyPlugin.Flist[6]->sFuncName$ = "Run Menu Maker"
  If Exist(APPEXEPATH$ & "Bas2Bmfd.exe") Then
     MyPlugin.Flist[MyPlugin.FunctionCount] = calloc(1,sizeof(FunctionList))
     MyPlugin.Flist[MyPlugin.FunctionCount]->PluginFunction = RunBas2Bmfd
     MyPlugin.Flist[MyPlugin.FunctionCount]->sFuncName$ = "Import Bas file"
     MyPlugin.FunctionCount++
  End If
  Function = &MyPlugin
End Function


SUB MakePluginMenu(i AS HMENU PTR, PID AS INTEGER)
  'AppendMenu(*i, MF_STRING, 0,    " ")
  AppendMenu(*i, MF_STRING, PID+PIDM_1,    "&Create BCX Code")
  AppendMenu(*i, MF_STRING, PID+PIDM_2,    "&Create BCX Modal Code")
  AppendMenu(*i, MF_STRING, PID+PIDM_3,    "&Create OOP Code")
  AppendMenu(*i, MF_STRING, PID+PIDM_4,    "&Create Modal OOP Code")
  AppendMenu(*i, MF_STRING, PID+PIDM_5,    "&Create BCX MDI Parent Code")
  AppendMenu(*i, MF_STRING, PID+PIDM_6,    "&Create BCX MDI Child Code")
  AppendMenu(*i, MF_STRING, PID+PIDM_7,    "&Run MakeMenu.exe")
  If Exist(APPEXEPATH$ & "Bas2Bmfd.exe") Then  
    AppendMenu(*i, MF_STRING, PID+PIDM_8,    "&Import Bas file")
  End If
END SUB

FUNCTION GetPrepend$()
  Dim temp$
  temp$ = INPUTBOX$("Add Form Identifier - like 'abt' for about", "Prepended to all control names: ", "")
  Print "PrePend: " & temp$
  Function = temp$
END FUNCTION

FUNCTION SetPrepend$(txt2$, AddThis$)
   DIM i
   DIM temp$
   DO
    temp$ = AddThis$ & "_" & ControlDescID[i]
    IF ControlDescID[i] <> "Cal" THEN
      txt2$ = REPLACE$(txt2$, ControlDescID[i], temp$)
    END IF
    i++
   LOOP WHILE ISPTR(ControlDescID[i+1])
   FUNCTION = txt2$
END FUNCTION

Global Modal_XScale as single
Global Modal_YScale as single

Function XScale$(a AS INTEGER) 'AS INTEGER
   Function = str$(CINT((a * Modal_XScale)/2))
End Function

Function YScale$(a AS INTEGER)
   Function = str$(CINT((a * Modal_YScale)/2))
End Function


FUNCTION Create_BCX_Form_Code(vi AS VARINFO PTR)
'  Call vi->SaveBCXCode()

   DIM RAW dwExStyle$
   DIM RAW lpClassName$
   DIM RAW lpWindowName$
   DIM RAW dwStyle$
   DIM RAW x$
   DIM RAW y$
   DIM RAW nWidth$
   DIM RAW nHeight$
   DIM RAW hMenu$
   DIM RAW lpTemp$
   DIM RAW rc AS RECT
   DIM TempCtrl$ * 100000
   DIM GridCode$ * 10000
   DIM RAW i
   GLOBAL addGridCode
   Dim myStyle
   Dim PreP$
   DIM AUTO Styleidx[MaxToolTypes], ctype
   addGridCode = 0

   CALL vi->Zorder()
   Modal_XScale = (*(vi->plgn_ScaleX)*2)
   Modal_YScale = (*(vi->plgn_ScaleY)*2)

   SendMessage(*(vi->hEdit), WM_SETTEXT, 0, "")

   ShowWindow(*(vi->hEdit), SW_SHOW)
   GetWindowRect(*(vi->Forms),&rc)
   TempCtrl$ = "GUI " + ENC$("Form1") + ",PIXELS" + CRLF$ + CRLF$
   'Add Styles, enums and declares
   TempCtrl$ = TempCtrl$ + vi->EStyleConst() + CRLF$ + vi->EEnums() + CRLF$ + vi->EHandles() + CRLF$

   TempCtrl$ = TempCtrl$ + AddCtrlColorGlobals$(vi)

   TempCtrl$ = TempCtrl$ + "SUB FORMLOAD()" + CRLF$
   TempCtrl$ = TempCtrl$ + "  DIM hFont AS HFONT" + CRLF$
   TempCtrl$ = TempCtrl$ + "   Form1 = BCX_FORM(" + ENC$("Form1") + ", 0, 0," + STR$(rc.right-rc.left) + "," + STR$(rc.bottom-rc.top)+ ")" + CRLF$

   FOR i = 1 TO *(vi->controlindex)

      ctype = vi->holdctl[i].ctype - 1
      INCR Styleidx[ctype]
      myStyle = Styleidx[ctype]
     ' extended window style
      dwExStyle$ = vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle)) + "_ExtStyle"

      ' registered class name
      GetClassName(vi->holdctl[i].hWnd, lpClassName$, 2048)

      ' window name
      GetWindowText(vi->holdctl[i].hWnd, lpWindowName$, 2048)

      ' window style
      dwStyle$ = vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle)) + "_Style"

      ' horizontal position of window
      x$ = XScale$(vi->holdctl[i].rect.left)

      ' vertical position of window
      y$ = YScale$(vi->holdctl[i].rect.top)

      ' window width
      nWidth$ = XScale$(vi->holdctl[i].rect.right-(vi->holdctl[i].rect.left))

      ' window height
      nHeight$ = YScale$(vi->holdctl[i].rect.bottom-(vi->holdctl[i].rect.top))

      hMenu$ = "ID_" + vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle))

      lpTemp$ = "   h" + vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle)) + " = " + vi->ControlTypes$[ctype]

      lpTemp$ = REPLACE$(lpTemp$, "%HWND%", "Form1")
      lpTemp$ = REPLACE$(lpTemp$, "%ID%", hMenu$)
      lpTemp$ = REPLACE$(lpTemp$, "%EXTSTY%", dwExStyle$)
      lpTemp$ = REPLACE$(lpTemp$, "%CLASS%", ENC$(lpClassName$))
      lpTemp$ = REPLACE$(lpTemp$, "%CAP%",   ENC$(lpWindowName$))
      lpTemp$ = REPLACE$(lpTemp$, "%STY%", dwStyle$)
      lpTemp$ = REPLACE$(lpTemp$, "%X%", x$)
      lpTemp$ = REPLACE$(lpTemp$, "%Y%", y$)
      lpTemp$ = REPLACE$(lpTemp$, "%W%", nWidth$)
      lpTemp$ = REPLACE$(lpTemp$, "%H%", nHeight$)
      TempCtrl$ = TempCtrl$ + lpTemp$ + CRLF$

      If len(vi->holdctl[i].font.Font_name$) then
         TempCtrl$ = TempCtrl$ & "   " & _
         AddFontCode$ (" h" + vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle)),vi->holdctl[i]) _
         & crlf$                                               'str$(i) &
      End If
      IF vi->holdctl[i].UseColor  THEN
         TempCtrl$ = TempCtrl$ & "   " & vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle)) & "_FC = "  & str$(vi->holdctl[i].forecolor) & _
         " : " & vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle)) & "_BC = "  & str$(vi->holdctl[i].backcolor) & CRLF$
      END IF
      IF ctype = 25 then
         addGridCode++
         GridCode$ = GridCode$ + Save_Blank_GridSetup$(vi->ControlDesc$[ctype] + LTRIM$(STR$(Styleidx[ctype])))
         TempCtrl$ = TempCtrl$ & "   CALL GridSetup"+ vi->ControlDesc$[ctype]+ LTRIM$(STR$(Styleidx[ctype]))+"(h" & vi->ControlDesc$[ctype] +  LTRIM$(STR$(myStyle)) +")"  + CRLF$
      END IF
   NEXT i
   If MenuCode$ <> "" then
      TempCtrl$ = TempCtrl$ + "   'Add Our Menu" + CRLF$
      TempCtrl$ = TempCtrl$ + "   AddMenu(Form1)" + CRLF$ + CRLF$
   End If
   TempCtrl$ = TempCtrl$ + "   CENTER(Form1)" + CRLF$
   TempCtrl$ = TempCtrl$ + "   SHOW(Form1)" + CRLF$
   TempCtrl$ = TempCtrl$ + "END SUB" + CRLF$ + CRLF$
   TempCtrl$ = TempCtrl$ + "BEGIN EVENTS"+ CRLF$
   TempCtrl$ = TempCtrl$ + " SELECT CASE CBMSG" & CRLF$
   
   lpTemp$ = AddCtrlColorEvents$(vi,0)
   
   IF LEN(lpTemp$) THEN   
     TempCtrl$ = TempCtrl$ + "    CASE WM_CTLCOLORSTATIC, WM_CTLCOLORBTN, WM_CTLCOLOREDIT,WM_CTLCOLORLISTBOX, WM_CTLCOLORSCROLLBAR" & CRLF$
     TempCtrl$ = TempCtrl$ + "      SELECT CASE (HWND)CBLPARAM" & CRLF$''
  
     'Add Color events
     TempCtrl$ = TempCtrl$ + lpTemp$ & CRLF$  'AddCtrlColorEvents$(vi,0) '
     TempCtrl$ = TempCtrl$ + "      END SELECT" & CRLF$
   END IF
   
   TempCtrl$ = TempCtrl$ + "   CASE WM_COMMAND" & CRLF$
   TempCtrl$ = TempCtrl$ + "      SELECT CASE CBCTL" & CRLF$

   'Add control Events
   TempCtrl$ = TempCtrl$ + AddCtrlEvents$(vi->EEnums())
   'Add menu Events
   TempCtrl$ = TempCtrl$ + AddMenuEvents(MenuCode$) & CRLF$

   TempCtrl$ = TempCtrl$ + "      END SELECT" & CRLF$
   TempCtrl$ = TempCtrl$ + " END SELECT" & CRLF$
   TempCtrl$ = TempCtrl$ + "END EVENTS" + CRLF$

   TempCtrl$ = TempCtrl$ & MenuCode$

   IF addGridCode THEN   ' it's RAGrid   remember ctype = ctype-1 above
        'If the user has an BCXLIB folder look in there
        IF EXIST (ENVIRON$("BCXLIB")  & "BCXraGrid.inc")  THEN           
           TempCtrl$ = "$INCLUDE " + "<BCXraGrid.inc>"+ CRLF$ + CRLF$ + TempCtrl$ + CRLF$
           TempCtrl$ = "'Using BCXLIB Path" + CRLF$ + TempCtrl$ + CRLF$
        ELSE  'now up to the user to add to app folder or set the path
        TempCtrl$ = "$INCLUDE " + ENC$("BCXraGrid.inc")+ CRLF$ + CRLF$ + TempCtrl$ + CRLF$
           TempCtrl$ = "'raGrid files pathed to current folder " + CRLF$ + TempCtrl$
        END IF 
        TempCtrl$ = TempCtrl$ +  GridCode$
   END IF
   If len(PreP$) <> 0 then
      TempCtrl$ = SetPrepend$(TempCtrl$,PreP$)
   End If

   SendMessage(*(vi->hEdit), WM_SETTEXT, 0, TempCtrl$)
   Call vi->Savit()
   FUNCTION = GetLastError()
END FUNCTION

FUNCTION CreateModalFormCode(vi AS VARINFO PTR)

   DIM RAW dwExStyle$
   DIM RAW lpClassName$
   DIM RAW lpWindowName$
   DIM RAW dwStyle$
   DIM RAW x$
   DIM RAW y$
   DIM RAW nWidth$
   DIM RAW nHeight$
   DIM RAW hMenu$
   DIM RAW lpTemp$
   DIM RAW rc AS RECT
   DIM TempCtrl$ * 100000
   Dim LaterCode$ * 100000
   Dim firstcode$ * 10000
   Dim GridCode$ * 10000
   Dim addtypecontrol
   Dim myStyle
   Dim tempStyle$
   DIM RAW i
   'DIM addGridCode
   DIM PreP$

   DIM AUTO Styleidx[MaxToolTypes], ctype

   addGridCode = 0

   PreP$ = trim$(GetPrepend$())
   CALL vi->Zorder()
   Modal_XScale = *(vi->plgn_ScaleX)
   Modal_YScale = *(vi->plgn_ScaleY)

   ShowWindow(*(vi->hEdit), SW_SHOW)
   GetWindowRect(*(vi->Forms),&rc)
   TempCtrl$ = "'Created with BMFD by Mike Henning" & crlf$ & crlf$
   TempCtrl$ = TempCtrl$ & "'This is a Modal dialog form, call it from your main form, it will NOT run by itself"  + CRLF$
   TempCtrl$ = TempCtrl$ + "'To make this a modeless dialog change BCX_MDialog to BCX_Dialog and," & crlf$
   TempCtrl$ = TempCtrl$ + "'BEGIN MODAL DIALOG to BEGIN DIALOG" & crlf$ & crlf$
   TempCtrl$ = TempCtrl$ + "'Also be sure there are no naming conflicts with existing controls and control ID numbers" + CRLF$ + CRLF$
   TempCtrl$ = TempCtrl$ + "'See BCX Help file on BCX_MDialog & BCX_Dialog functions" & crlf$ & crlf$

   TempCtrl$ = TempCtrl$ + vi->EStyleConst() + CRLF$ + vi->EEnums() + CRLF$ + vi->EHandles() + CRLF$

   formName = "FormXYZ"

   'Add The Globals for controls that use colors
   TempCtrl$ = TempCtrl$ + AddCtrlColorGlobals$(vi)

   TempCtrl$ = TempCtrl$ & "Function FormXYZ_Create( hParent as HWND) as integer" & crlf$
   TempCtrl$ = TempCtrl$ & chr$(9) & "BCX_MDialog(Ev_FormXYZ," & ENC$("FormXYZ Title")& _
      ", hParent, " & _
      XScale$(rc.left) & ", " & YScale$(rc.top) & ", " & XScale$((rc.right- rc.left)) & ", " & _
      YScale$((rc.bottom - rc.top)) & ") "  & crlf$

   TempCtrl$ = TempCtrl$ & chr$(9) & "FUNCTION = 0" & crlf$
   TempCtrl$ = TempCtrl$ & "END FUNCTION" & crlf$
   TempCtrl$ = TempCtrl$ &   crlf$ & crlf$
   TempCtrl$ = TempCtrl$ + "BEGIN MODAL DIALOG AS Ev_FormXYZ" + CRLF$
   TempCtrl$ = TempCtrl$ + " DIM hFont AS HFONT" + CRLF$
   TempCtrl$ = TempCtrl$ + " SELECT CASE CBMSG" & CRLF$
   TempCtrl$ = TempCtrl$ + " CASE WM_INITDIALOG" & CRLF$
   TempCtrl$ = TempCtrl$ + "   FormXYZ = hWnd" & CRLF$

   FOR i = 1 TO *(vi->controlindex)

      ctype = vi->holdctl[i].ctype - 1
      INCR Styleidx[ctype]
      myStyle = Styleidx[ctype]
     ' extended window style
      dwExStyle$ = vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle)) + "_ExtStyle"

      ' registered class name
      GetClassName(vi->holdctl[i].hWnd, lpClassName$, 2048)

      ' window name
      GetWindowText(vi->holdctl[i].hWnd, lpWindowName$, 2048)

      ' window style
      dwStyle$ = vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle)) + "_Style"
      
      ' horizontal position of window
      x$ = XScale$(vi->holdctl[i].rect.left)

      ' vertical position of window
      y$ = YScale$(vi->holdctl[i].rect.top)

      ' window width
      nWidth$ = XScale$(vi->holdctl[i].rect.right-(vi->holdctl[i].rect.left))

      ' window height
      nHeight$ = YScale$(vi->holdctl[i].rect.bottom-(vi->holdctl[i].rect.top))

      hMenu$ = "ID_" + vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle))

      lpTemp$ = "   h" + vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle)) + " = " + vi->ControlTypes$[ctype]

      lpTemp$ = REPLACE$(lpTemp$, "%HWND%", "Form1")
      lpTemp$ = REPLACE$(lpTemp$, "%ID%", hMenu$)
      lpTemp$ = REPLACE$(lpTemp$, "%EXTSTY%", dwExStyle$)
      lpTemp$ = REPLACE$(lpTemp$, "%CLASS%", ENC$(lpClassName$))
      lpTemp$ = REPLACE$(lpTemp$, "%CAP%",   ENC$(lpWindowName$))
      lpTemp$ = REPLACE$(lpTemp$, "%STY%", dwStyle$)
      lpTemp$ = REPLACE$(lpTemp$, "%X%", x$)
      lpTemp$ = REPLACE$(lpTemp$, "%Y%", y$)
      lpTemp$ = REPLACE$(lpTemp$, "%W%", nWidth$)
      lpTemp$ = REPLACE$(lpTemp$, "%H%", nHeight$)
      TempCtrl$ = TempCtrl$ + lpTemp$ + CRLF$

      If len(vi->holdctl[i].font.Font_name$) then
         TempCtrl$ = TempCtrl$ & "   " & _
         AddFontCode$ ("h" + vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle)),vi->holdctl[i]) _
         & crlf$
      End If
      'IF (vi->holdctl[i].forecolor) OR (vi->holdctl[i].backcolor)  THEN
      IF vi->holdctl[i].UseColor THEN
         TempCtrl$ = TempCtrl$ & "   " & vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle)) & "_FC = "  & str$(vi->holdctl[i].forecolor) & _
         " : " & vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle)) & "_BC = "  & str$(vi->holdctl[i].backcolor) & CRLF$
      END IF
      IF ctype = 25 then
         addGridCode++
         GridCode$ = GridCode$ + Save_Blank_GridSetup$(vi->ControlDesc$[ctype] + LTRIM$(STR$(Styleidx[ctype])))
         TempCtrl$ = TempCtrl$ & "   CALL GridSetup"+ vi->ControlDesc$[ctype]+ LTRIM$(STR$(Styleidx[ctype]))+"(h" & vi->ControlDesc$[ctype] +  LTRIM$(STR$(myStyle)) +")"  + CRLF$
      END IF

   NEXT i
   If MenuCode$ <> "" then
      TempCtrl$ = TempCtrl$ + "   'Add Our Menu" + CRLF$
      TempCtrl$ = TempCtrl$ + "   AddMenu(" & formName & ")" + CRLF$ + CRLF$
   End If

   TempCtrl$ = firstcode$ & crlf$ & TempCtrl$ + "    Show(" & formName & ")" & CRLF$

   lpTemp$ = AddCtrlColorEvents$(vi,0)
   IF LEN(lpTemp$) THEN
     TempCtrl$ = TempCtrl$ + "    CASE WM_CTLCOLORSTATIC, WM_CTLCOLORBTN, WM_CTLCOLOREDIT,WM_CTLCOLORLISTBOX, WM_CTLCOLORSCROLLBAR" & CRLF$
     TempCtrl$ = TempCtrl$ + "      SELECT CASE (HWND)CBLPARAM" & CRLF$
  
     'Add Color events
     TempCtrl$ = TempCtrl$ + lpTemp$ & CRLF$ 'AddCtrlColorEvents$(vi,0)
     TempCtrl$ = TempCtrl$ + "      END SELECT" & CRLF$
   END IF

   TempCtrl$ = TempCtrl$ + " CASE WM_COMMAND"  & CRLF$
   TempCtrl$ = TempCtrl$ + "      SELECT CASE CBCTL" & CRLF$

   'Add control Events
   TempCtrl$ = TempCtrl$ + AddCtrlEvents$(vi->EEnums())
   'Add menu Events
   TempCtrl$ = TempCtrl$ + AddMenuEvents(MenuCode$) & CRLF$

   TempCtrl$ = TempCtrl$ + "      END SELECT" & CRLF$


   TempCtrl$ = TempCtrl$ + " END SELECT"  & CRLF$
   TempCtrl$ = TempCtrl$ + "END DIALOG" + CRLF$ & CRLF$
   
   TempCtrl$ = TempCtrl$ & MenuCode$
   
   IF addGridCode THEN   ' it's RAGrid   remember ctype = ctype-1 above
        'If the user has an BCXLIB folder look in there
        IF EXIST (ENVIRON$("BCXLIB")  & "BCXraGrid.inc")  THEN           
           TempCtrl$ = "$INCLUDE " + "<BCXraGrid.inc>"+ CRLF$ + CRLF$ + TempCtrl$ + CRLF$
           TempCtrl$ = "'Using BCXLIB Path" + CRLF$ + TempCtrl$ + CRLF$
        ELSE  'now up to the user to add to app folder or set the path
        TempCtrl$ = "$INCLUDE " + ENC$("BCXraGrid.inc")+ CRLF$ + CRLF$ + TempCtrl$ + CRLF$
           TempCtrl$ = "'raGrid files pathed to current folder " + CRLF$ + TempCtrl$
       END IF 
        TempCtrl$ = TempCtrl$ +  GridCode$
   END IF

   REPLACE "Form1" WITH "FormXYZ" IN TempCtrl$
   If len(PreP$) <> 0 then
      TempCtrl$ = SetPrepend$(TempCtrl$,PreP$)    'Prepend a string to all controls
      TempCtrl$ = REPLACE$(TempCtrl$,"FormXYZ","Form" & PreP$)  'Change FormXYZ to user name
   End If
   
   SendMessage(*(vi->hEdit), WM_SETTEXT, 0, TempCtrl$)
   Call vi->Savit()
   FUNCTION = GetLastError()
END FUNCTION

FUNCTION Create_OOP_Modal_Form_Code(vi AS VARINFO PTR) AS INTEGER
   DIM RAW rc AS RECT
   DIM TempCtrl$ * 100000
   Dim LaterCode$ * 100000
   Dim GridCode$ * 10000
   DIM RAW i
   'DIM addGridCode
   DIM RAW lpTemp$

   DIM PreP$

   DIM AUTO Styleidx[MaxToolTypes], ctype
   Dim addtypecontrol

   addGridCode = 0
   ShowWindow(*(vi->hEdit), SW_SHOW)
   GetWindowRect(*(vi->Forms),&rc)
   Modal_XScale = *(vi->plgn_ScaleX)
   Modal_YScale = *(vi->plgn_ScaleY)
   
   SaveModal = TRUE
   
   PreP$ = GetPrepend$()
   TempCtrl$ = "'Created with BMFD by Mike Henning" & crlf$ & crlf$
   TempCtrl$ = TempCtrl$ & "'This is a OOP type Modal dialog form, call it from your main form, it will NOT run by itself"  + CRLF$
   TempCtrl$ = TempCtrl$ + "'To make this a modeless dialog change BCX_MDialog to BCX_Dialog and," & crlf$
   TempCtrl$ = TempCtrl$ + "'BEGIN MODAL DIALOG to BEGIN DIALOG" & crlf$ & crlf$
   TempCtrl$ = TempCtrl$ + "'Also be sure there are no naming conflicts with existing controls and control ID numbers" + CRLF$ + CRLF$
   TempCtrl$ = TempCtrl$ + "'See BCX Help file on BCX_MDialog & BCX_Dialog functions" & crlf$ & crlf$
   TempCtrl$ = TempCtrl$ + "'See $INCLUDES at end of this file if you get functions or varibles not found errors" & crlf$
   TempCtrl$ = TempCtrl$ + "'I assumed if you are using OOP Code for this Dialog you are using OOP code "
   TempCtrl$ = TempCtrl$ + crlf$ & "'for the rest of your code, but I did add the Includes just in case" & crlf$ & _
   "'Plugin by Wayne H & IDC" & crlf$ & crlf$
   formName = "FormXYZ"
   TempCtrl$ = TempCtrl$ + "Function FormXYZ_Create( hParent as HWND) as integer" & crlf$
   TempCtrl$ = TempCtrl$ & chr$(9) & "BCX_MDialog(Ev_FormXYZ," & ENC$("FormXYZ Title")& _
      ", hParent, " & _
      XScale$(rc.left) & ", " & YScale$(rc.top) & ", " & XScale$((rc.right-rc.left)) & ", " & _
      YScale$((rc.bottom - rc.top)) & ") "  & crlf$

   TempCtrl$ = TempCtrl$ & chr$(9) & "FUNCTION = 0" & crlf$
   TempCtrl$ = TempCtrl$ & "END FUNCTION" & crlf$
   TempCtrl$ = TempCtrl$ &   crlf$ & crlf$
   'Call the_Form_Code("FormXYZ", rc, TempCtrl$, LaterCode$) 'NOT NEEDED in modal forms
   TempCtrl$ = TempCtrl$ + "BEGIN MODAL DIALOG AS Ev_FormXYZ" + CRLF$
   TempCtrl$ = TempCtrl$ + " GLOBAL FormXYZ AS HWND" + CRLF$
   TempCtrl$ = TempCtrl$ + " SELECT CASE CBMSG" & CRLF$

   lpTemp$ = AddCtrlColorEvents$(vi,1)
   IF LEN(lpTemp$) THEN
     TempCtrl$ = TempCtrl$ + "    CASE WM_CTLCOLORSTATIC, WM_CTLCOLORBTN, WM_CTLCOLOREDIT,WM_CTLCOLORLISTBOX, WM_CTLCOLORSCROLLBAR" & CRLF$
     TempCtrl$ = TempCtrl$ + "      SELECT CASE (HWND)CBLPARAM" & CRLF$
  
     'Add Color events
     TempCtrl$ = TempCtrl$ + lpTemp$ & CRLF$ 'AddCtrlColorEvents$(vi,1)
  
     TempCtrl$ = TempCtrl$ + "      END SELECT" & CRLF$
   END IF

   TempCtrl$ = TempCtrl$ + " CASE WM_INITDIALOG" & CRLF$
   TempCtrl$ = TempCtrl$ + "   FormXYZ = hWnd" & CRLF$

   FOR i = 1 TO *(vi->controlindex)
      ctype = vi->holdctl[i].ctype - 1
      INCR Styleidx[ctype]
       addtypecontrol = Add_OOP_Control(TempCtrl$, LaterCode$, i, addtypecontrol, ctype, Styleidx[ctype],vi)
   NEXT i
   If MenuCode$ <> "" then
      TempCtrl$ = TempCtrl$ + "   'Add Our Menu" + CRLF$
      TempCtrl$ = TempCtrl$ + "   AddMenu(" & formName & ")" + CRLF$ + CRLF$   
   End If
   TempCtrl$ = TempCtrl$ + "    Show(" & formName & ")" & CRLF$

   CALL Add_OOP_End_Code(TempCtrl$, LaterCode$, addtypecontrol)
   TempCtrl$ = TempCtrl$ + " CASE WM_COMMAND"  & CRLF$
   TempCtrl$ = TempCtrl$ + "      SELECT CASE CBCTL" & CRLF$

   'Add control Events
   TempCtrl$ = TempCtrl$ + AddOOPCtrlEvents$(vi->EEnums())
   'Add menu Events
   TempCtrl$ = TempCtrl$ + AddMenuEvents(MenuCode$) & CRLF$

   TempCtrl$ = TempCtrl$ + "      END SELECT" & CRLF$
   
   TempCtrl$ = TempCtrl$ + " END SELECT"  & CRLF$
   TempCtrl$ = TempCtrl$ + "END DIALOG" + CRLF$ & CRLF$

   TempCtrl$ = TempCtrl$ & MenuCode$

   TempCtrl$ = TempCtrl$ + LaterCode$

   REPLACE "Form1" WITH "FormXYZ" IN TempCtrl$
   If len(PreP$) <> 0 then
      TempCtrl$ = SetPrepend$(TempCtrl$,PreP$)
   End If

   SendMessage(*(vi->hEdit), WM_SETTEXT, 0, TempCtrl$)
   Call vi->Savit()
   FUNCTION = 0
END FUNCTION

FUNCTION Create_OOP_Form_Code(vi AS VARINFO PTR) AS INTEGER


   DIM RAW rc AS RECT
   DIM TempCtrl$ * 100000
   Dim LaterCode$ * 100000
   Dim GridCode$ * 10000
   DIM RAW i
   'DIM addGridCode
   DIM RAW lpTemp$
   addGridCode = 0
   
   formName = "Form1"
   DIM AUTO Styleidx[MaxToolTypes], ctype
   Dim addtypecontrol
   SaveModal = FALSE
   ShowWindow(*(vi->hEdit), SW_SHOW)
   GetWindowRect(*(vi->Forms),&rc)
   
   TempCtrl$ = "'Created with BMFD by Mike Henning" & crlf$
   TempCtrl$ = TempCtrl$ & "'Plugin by Wayne H & IDC" & crlf$ & crlf$
   TempCtrl$ = TempCtrl$ & "GUI " + ENC$(formName) + ",PIXELS" + CRLF$ + CRLF$
   'TempCtrl$ = TempCtrl$ & "DIM g_foreColor, g_bkColor" + CRLF$ + CRLF$
   Call Start_OOP_Form_Code(formName, rc, TempCtrl$, LaterCode$)

   FOR i = 1 TO *(vi->controlindex)
      ctype = vi->holdctl[i].ctype - 1
      INCR Styleidx[ctype]
       addtypecontrol = Add_OOP_Control(TempCtrl$, LaterCode$, i, addtypecontrol, ctype, Styleidx[ctype],vi)
   NEXT i
   If MenuCode$ <> "" then
      TempCtrl$ = TempCtrl$ + "   'Add Our Menu" + CRLF$
      TempCtrl$ = TempCtrl$ + "   AddMenu(" & formName & ")" + CRLF$ + CRLF$
   End If
   
   CALL Add_OOP_End_Code(TempCtrl$, LaterCode$, addtypecontrol)
   TempCtrl$ = TempCtrl$ + "END SUB" + CRLF$ + CRLF$
   TempCtrl$ = TempCtrl$ + "BEGIN EVENTS"+ CRLF$
   TempCtrl$ = TempCtrl$ + "  SELECT CASE CBMSG" & CRLF$
   
   lpTemp$ = AddCtrlColorEvents$(vi,1)
   IF LEN(lpTemp$) THEN
     TempCtrl$ = TempCtrl$ + "    CASE WM_CTLCOLORSTATIC, WM_CTLCOLORBTN, WM_CTLCOLOREDIT,WM_CTLCOLORLISTBOX, WM_CTLCOLORSCROLLBAR" & CRLF$
     TempCtrl$ = TempCtrl$ + "      SELECT CASE (HWND)CBLPARAM" & CRLF$
     'Add Color events
     TempCtrl$ = TempCtrl$ + lpTemp$ & CRLF$ 'AddCtrlColorEvents$(vi,1)
  
     TempCtrl$ = TempCtrl$ + "      END SELECT" & CRLF$
   END IF
   TempCtrl$ = TempCtrl$ +  CRLF$
   TempCtrl$ = TempCtrl$ + "    CASE WM_COMMAND"  & CRLF$
   TempCtrl$ = TempCtrl$ + "      SELECT CASE CBCTL" & CRLF$

   'Add control Events
   TempCtrl$ = TempCtrl$ + AddOOPCtrlEvents$(vi->EEnums())
   'Add menu Events
   TempCtrl$ = TempCtrl$ + AddMenuEvents(MenuCode$) & CRLF$

   TempCtrl$ = TempCtrl$ + "      END SELECT" & CRLF$

   TempCtrl$ = TempCtrl$ + "    CASE WM_CLOSE"  & CRLF$
   TempCtrl$ = TempCtrl$ + "       PostQuitMessage(0)"  & CRLF$
   TempCtrl$ = TempCtrl$ + "    CASE WM_DESTROY"  & CRLF$
   TempCtrl$ = TempCtrl$ + "       PostQuitMessage(0) "  & CRLF$
   TempCtrl$ = TempCtrl$ + "  END SELECT"  & CRLF$
   TempCtrl$ = TempCtrl$ + "END EVENTS" + CRLF$ & CRLF$

   'TempCtrl$ = TempCtrl$ & MenuCode$

   TempCtrl$ = TempCtrl$ + LaterCode$
   SendMessage(*(vi->hEdit), WM_SETTEXT, 0, TempCtrl$)
   Call vi->Savit()
   FUNCTION = 0
END FUNCTION

SUB Start_OOP_Form_Code(Formname AS STRING, rc AS RECT, TempCtrl$, LaterCode$)

      TempCtrl$ = TempCtrl$ + "SUB FORMLOAD()" + CRLF$
      TempCtrl$ = TempCtrl$ + "   CALL SetupForm1()" & CRLF$
      Call the_Form_Code(Formname , rc, TempCtrl$, LaterCode$)

END SUB

SUB the_Form_Code(Formname AS STRING, rc AS RECT, TempCtrl$, LaterCode$)
      LaterCode$ = "Sub Setup" & formName & "()" + CRLF$
      LaterCode$ = LaterCode$ & "  GLOBAL " & Formname & " AS OOP_FORM" + CRLF$
      LaterCode$ = LaterCode$ & "  " & Formname$ & ".CtrlType$ = " & ENC$("form") + CRLF$
      LaterCode$ = LaterCode$ & "  " & Formname$ & ".ID = 100" + CRLF$
      LaterCode$ = LaterCode$ & "  InitFrm(&" & Formname$ & ")" + CRLF$
      LaterCode$ = LaterCode$ & "  " & Formname$ & ".rc.left = " & STR$(rc.left) + CRLF$
      LaterCode$ = LaterCode$ & "  " & Formname$ & ".rc.top = " & str$(rc.top) + CRLF$ ' 150
      LaterCode$ = LaterCode$ & "  " & Formname$ & ".rc.right = " & STR$(rc.right-rc.left) + CRLF$
      LaterCode$ = LaterCode$ & "  " & Formname$ & ".rc.bottom =  " & STR$(rc.bottom-rc.top) + CRLF$
      LaterCode$ = LaterCode$ & "  " & Formname$ & ".Style = 0" + CRLF$'WS_MINIMIZEBOX | WS_SIZEBOX | WS_CAPTION | WS_MAXIMIZEBOX | WS_POPUP | WS_SYSMENU" + CRLF$
      LaterCode$ = LaterCode$ & "  " & Formname$ & ".StyleEx = 0 " + CRLF$
      LaterCode$ = LaterCode$ & "  " & Formname$ & ".fontsize = 10" + CRLF$
      LaterCode$ = LaterCode$ & "  " & Formname$ & ".Font(&Form1, " & ENC$("Tahoma") & ")" + CRLF$
      LaterCode$ = LaterCode$ & "  " & Formname$ & ".Caption$ = " & ENC$("Semi-OOP Form Type Demo" ) + CRLF$
      LaterCode$ = LaterCode$ & "  " & Formname$ & ".CreateFrm(&" & Formname$ & ")" + CRLF$ 'create form
      LaterCode$ = LaterCode$ & "END SUB" & crlf$ & crlf$
END SUB

FUNCTION Add_OOP_Control(TempCtrl$, LaterCode$, i as integer, _
         addtypecontrol as integer, ctype as integer, styleidx as integer, _
         vi AS VARINFO PTR) AS INTEGER

   Dim myTemp$ * 8192
   DIM RAW dwExStyle$
   DIM RAW lpClassName$
   DIM RAW lpWindowName$
   DIM RAW dwStyle$
   DIM RAW x$
   DIM RAW y$
   DIM RAW nWidth$
   DIM RAW nHeight$
   DIM RAW hMenu$
   DIM AUTO lpTemp$
   DIM RAW fontCode$
     ' extended window style
      dwExStyle$ = vi->ControlDesc$[ctype] + LTRIM$(STR$(styleidx)) + "_ExtStyle"

      ' registered class name
      GetClassName(vi->holdctl[i].hWnd, lpClassName$, 2048)

      ' window name
      GetWindowText(vi->holdctl[i].hWnd, lpWindowName$, 2048)

      ' window style
      dwStyle$ = vi->ControlDesc$[ctype] + LTRIM$(STR$(styleidx)) + "_Style"

      ' horizontal position of window
      IF SaveModal then 
        x$ = XScale$(vi->holdctl[i].rect.left)
      Else
        x$ = STR$(vi->holdctl[i].rect.left)
      END IF

      ' vertical position of window
      IF SaveModal then 
        y$ = YScale$(vi->holdctl[i].rect.top)
      Else
        y$ = STR$(vi->holdctl[i].rect.top)
      END IF

      ' window width
      IF SaveModal then 
        nWidth$ = XScale$((vi->holdctl[i].rect.right-(vi->holdctl[i].rect.left)))
      Else
        nWidth$ = STR$(vi->holdctl[i].rect.right-vi->holdctl[i].rect.left)
      END IF

      ' window height
      IF SaveModal then 
        nHeight$ = YScale$((vi->holdctl[i].rect.bottom-(vi->holdctl[i].rect.top)))
      Else
        nHeight$ = STR$(vi->holdctl[i].rect.bottom-vi->holdctl[i].rect.top)
      END IF

      hMenu$ = "ID_" + vi->ControlDesc$[ctype] + LTRIM$(STR$(styleidx))

      lpTemp$ = lpTemp$ + "   h" + vi->ControlDesc$[ctype] + LTRIM$(STR$(styleidx)) + " = " + vi->ControlTypes$[ctype]

      dwExStyle$ = vi->ControlDesc$[ctype] + LTRIM$(STR$(styleidx))
      myTemp$ = "Sub Setup" & dwExStyle$  & Crlf$
      myTemp$ = myTemp$ &  "  GLOBAL " & dwExStyle$ & " AS OOP_CONTROL" & Crlf$
      myTemp$ = myTemp$ &  "  DIM hFont AS HFONT" & Crlf$
      'myTemp$ = myTemp$ &  "  " & dwExStyle$ & ".hWnd = h" + dwExStyle$ & crlf$
      myTemp$ = myTemp$ &  "  " & dwExStyle$ & ".hParent = " & formName 
      IF NOT SaveModal then
        myTemp$ = myTemp$& ".hWnd"  & Crlf$
      ELSE
        myTemp$ = myTemp$  & Crlf$
      END IF
      myTemp$ = myTemp$ &  "  " & dwExStyle$ & ".ID = " & str$(i + 100) & Crlf$
      myTemp$ = myTemp$ &  "  " & dwExStyle$ & ".CtrlType$ = " & ENC$(lpClassName$) & Crlf$
      myTemp$ = myTemp$ &  "  " & "InitCtrl(&" & dwExStyle$ & ")" & Crlf$
      IF lpClassName$ = "ComboBox" then REPLACE  "InitCtrl" WITH "InitCombo" IN myTemp$
      IF lpClassName$ = "ListBox" then REPLACE  "InitCtrl" WITH "InitListbox" IN myTemp$
      IF lpClassName$ = "SysListView32" then REPLACE  "InitCtrl" WITH "InitListView" IN myTemp$
      IF lpClassName$ = "SysTreeView32" then REPLACE  "InitCtrl" WITH "InitTreeView" IN myTemp$
      IF lpClassName$ = "msctls_progress32" then REPLACE  "InitCtrl" WITH "InitProgressBar" IN myTemp$
      IF lpClassName$ = "msctls_updown32" then REPLACE  "InitCtrl" WITH "InitUpDown" IN myTemp$
      IF lpClassName$ = "msctls_trackbar32" then REPLACE  "InitCtrl" WITH "InitSlider" IN myTemp$
      IF lpClassName$ = "RAGrid" then REPLACE  "InitCtrl" WITH "InitBCX_raGrid" IN myTemp$

      '        myTemp$ = myTemp$ &  "***Class***: " &  lpClassName$ +  "   " & ControlDescID$[ctype] & Crlf$ & Crlf$
      myTemp$ = myTemp$ &  "  " & dwExStyle$ & ".Caption$ = " & ENC$(lpWindowName$) & Crlf$
      myTemp$ = myTemp$ &  "  " & dwExStyle$ & ".rc.left = " & x$ & Crlf$
      myTemp$ = myTemp$ &  "  " & dwExStyle$ & ".rc.top = " & y$ & Crlf$
      myTemp$ = myTemp$ &  "  " & dwExStyle$ & ".rc.right = " & nWidth$ & Crlf$
      myTemp$ = myTemp$ &  "  " & dwExStyle$ & ".rc.bottom = " & nHeight$ & Crlf$
      IF vi->holdctl[i].backcolor Then
         myTemp$ = myTemp$ & dwExStyle$ & ".BackgroundRGBColor = " & str$(vi->holdctl[i].backcolor) & Crlf$
      End If
      IF vi->holdctl[i].forecolor Then
         myTemp$ = myTemp$ & dwExStyle$ & ".ForegroundRGBColor = " &  str$(vi->holdctl[i].forecolor) & Crlf$
      End If
      'myTemp$ = myTemp$ &  "  " & dwExStyle$ & ".font" & Crlf$

      'Add font
      fontCode$ = ""
      If len(vi->holdctl[i].font.Font_name$) then
         fontCode$ = AddFontCode$ ( vi->ControlDesc$[ctype] + _
         LTRIM$(STR$(styleidx)) & ".hWnd",vi->holdctl[i]) _
         & crlf$
      End If

      Dim tempstyles$
      'tempstyles$ =vi->FillStyleLists$(vi->holdctl[i].hWnd, 1, 0, FALSE)
      tempstyles$ =vi->GetStyleConst(vi->holdctl[i].hWnd, 1, 0, FALSE)
      'GetStyleConst
      'tempstyles$ = "0" 'str$(vi->copy.sty)
      If len(tempstyles$) = 0 then
      tempstyles$ = "0"
      ELSEIF ControlDescID$[ctype] = "Upd" then
       tempstyles$ = tempstyles$ & " | UDS_WRAP OR UDS_ARROWKEYS | UDS_ALIGNRIGHT | UDS_SETBUDDYINT"
      END If
      myTemp$ = myTemp$ &  "  " & dwExStyle$ & ".Style = " & tempstyles$ & CRLF$
      'tempstyles$ =FillStyleLists$(vi->holdctl[i].hWnd, 0, 1, FALSE)
      tempstyles$ = vi->GetStyleConst(vi->holdctl[i].hWnd, 0, 1, FALSE)
      'tempstyles$ = "0" 'vi->copy->extsty
      If len(tempstyles$) = 0 then tempstyles$ = "0"
      myTemp$ = myTemp$ &  "  " & dwExStyle$ & ".StyleEx = " & tempstyles$ + CRLF$

      SELECT CASE trim$(UCASE$(lpClassName$)) 'ControlDescID$[ctype]
      CASE "BUTTON", "STATIC", "EDIT", "CHECK", "RADIO"
         addtypecontrol= addtypecontrol BOR 2
         If lpClassName$ = "Check" then REPLACE "Button" WITH "Check" IN myTemp$
         If lpClassName$ = "Radio" then REPLACE "Button" WITH "Radio" IN myTemp$
         LaterCode$ = LaterCode$ & myTemp$ &  "  " & dwExStyle$ & ".CreateCtrl(&" & dwExStyle$ & ")"& Crlf$
         LaterCode$ = LaterCode$ & fontCode$ & "END SUB" & crlf$ & crlf$  
         TempCtrl$ = TempCtrl$ + "   CALL Setup" & dwExStyle$ & "()" + CRLF$
      Case "LISTBOX", "COMBOBOX"
         'LaterCode$ = LaterCode$ & myTemp$
         IF lpClassName$ = "ComboBox" then
            addtypecontrol= addtypecontrol BOR 4
            REPLACE "OOP_CONTROL" WITH "OOP_COMBO" IN myTemp$ 
         ELSE
            addtypecontrol= addtypecontrol BOR 8
            REPLACE "OOP_CONTROL" WITH "OOP_LISTBOX"  IN myTemp$
         END IF
         LaterCode$ = LaterCode$ & myTemp$ &  "  " & dwExStyle$ & ".CreateCtrl(&" & dwExStyle$ & ")"& Crlf$
         LaterCode$ = LaterCode$ & fontCode$ & "END SUB" & crlf$ & crlf$
         TempCtrl$ = TempCtrl$ + "   CALL Setup" & dwExStyle$ & "()" + CRLF$
      Case "SYSLISTVIEW32"
         addtypecontrol= addtypecontrol BOR 16
         REPLACE "OOP_CONTROL" WITH "OOP_LISTVIEW" IN myTemp$
         LaterCode$ = LaterCode$ & myTemp$ &  "  " & dwExStyle$ & ".CreateCtrl(&" & dwExStyle$ & ")"& Crlf$
         LaterCode$ = LaterCode$ & fontCode$ & "END SUB" & crlf$ & crlf$
         TempCtrl$ = TempCtrl$ + "   CALL Setup" & dwExStyle$ & "()" + CRLF$
      Case "SYSTREEVIEW32"
         addtypecontrol= addtypecontrol BOR 32
         REPLACE "OOP_CONTROL" WITH "OOP_TREEVIEW" IN myTemp$
         LaterCode$ = LaterCode$ & myTemp$ &  "  " & dwExStyle$ & ".CreateCtrl(&" & dwExStyle$ & ")"& Crlf$
         LaterCode$ = LaterCode$ & fontCode$ & "END SUB" & crlf$ & crlf$
         TempCtrl$ = TempCtrl$ + "   CALL Setup" & dwExStyle$ & "()" + CRLF$
      Case "MSCTLS_PROGRESS32"
         addtypecontrol= addtypecontrol BOR 64
         REPLACE "OOP_CONTROL" WITH "OOP_PROGRESS" IN myTemp$
         LaterCode$ = LaterCode$ & myTemp$ &  "  " & dwExStyle$ & ".CreateCtrl(&" & dwExStyle$ & ")"& Crlf$
         LaterCode$ = LaterCode$ & fontCode$ & "END SUB" & crlf$ & crlf$
         TempCtrl$ = TempCtrl$ + "   CALL Setup" & dwExStyle$ & "()" + CRLF$                   
      Case "MSCTLS_UPDOWN32"
         addtypecontrol= addtypecontrol BOR 128
         REPLACE "OOP_CONTROL" WITH "OOP_UPDOWN" IN myTemp$
         LaterCode$ = LaterCode$ & myTemp$ &  "  " & dwExStyle$ & ".CreateCtrl(&" & dwExStyle$ & ")"& Crlf$
         LaterCode$ = LaterCode$ & fontCode$ & "END SUB" & crlf$ & crlf$
         TempCtrl$ = TempCtrl$ + "   CALL Setup" & dwExStyle$ & "()" + CRLF$
      Case "MSCTLS_TRACKBAR32"
         addtypecontrol= addtypecontrol BOR 256
         REPLACE "OOP_CONTROL" WITH "OOP_SLIDER" IN myTemp$
         LaterCode$ = LaterCode$ & myTemp$ &  "  " & dwExStyle$ & ".CreateCtrl(&" & dwExStyle$ & ")"& Crlf$
         LaterCode$ = LaterCode$ & fontCode$ & "END SUB" & crlf$ & crlf$
         TempCtrl$ = TempCtrl$ + "   CALL Setup" & dwExStyle$ & "()" + CRLF$
      Case "RAGRID"
         addtypecontrol= addtypecontrol BOR 512
         REPLACE "OOP_CONTROL" WITH "OOP_RAGRID" IN myTemp$
         LaterCode$ = LaterCode$ & myTemp$ &  "  " & dwExStyle$ & ".CreateCtrl(&" & dwExStyle$ & ")"& Crlf$
         LaterCode$ = LaterCode$ & fontCode$ & "END SUB" & crlf$ & crlf$
         TempCtrl$ = TempCtrl$ + "   CALL Setup" & dwExStyle$ & "()" + CRLF$
      CASE ELSE
        TempCtrl$ = TempCtrl$ & Crlf$ & "Dim h" & dwExStyle$ & " AS HWND" & Crlf$
        TempCtrl$ = TempCtrl$ & "CONST " & hMenu$ & "  = " & str$(100+i) & Crlf$
        TempCtrl$ = TempCtrl$ & "Dim " & dwStyle$ & Crlf$
        'TempCtrl$ = TempCtrl$ & "Dim " & ControlDescID$[ctype] + LTRIM$(STR$(Styleidx[ctype])) + "_Style" & Crlf$
        TempCtrl$ = TempCtrl$ & ControlDescID$[ctype] + LTRIM$(STR$(styleidx)) + "_Style = "
        TempCtrl$ = TempCtrl$ & vi->GetStyleConst(vi->holdctl[i].hWnd, 1, 0, FALSE)  & CRLF$

        TempCtrl$ = TempCtrl$ & "Dim " & ControlDescID$[ctype] + LTRIM$(STR$(styleidx)) + "_ExtStyle" & Crlf$
        TempCtrl$ = TempCtrl$ & ControlDescID$[ctype] + LTRIM$(STR$(styleidx)) + "_ExtStyle = "
        TempCtrl$ = TempCtrl$ & vi->GetStyleConst(vi->holdctl[i].hWnd, 0, 1, FALSE)  & CRLF$  & CRLF$
        'TempCtrl$ = TempCtrl$ & str$(i + 100) & Crlf$
        lpTemp$ = "   h" + ControlDescID$[ctype] + LTRIM$(STR$(styleidx)) + " = " + lpClassName$'ControlType$[ctype]
        lpTemp$ = REPLACE$(lpTemp$, "%HWND%", "Form1.hWnd")
        lpTemp$ = REPLACE$(lpTemp$, "%ID%", hMenu$)
        lpTemp$ = REPLACE$(lpTemp$, "%EXTSTY%", ControlDescID$[ctype] + LTRIM$(STR$(styleidx)) + "_ExtStyle")
        lpTemp$ = REPLACE$(lpTemp$, "%CLASS%", ENC$(lpClassName$))
        lpTemp$ = REPLACE$(lpTemp$, "%CAP%",   ENC$(lpWindowName$))
        lpTemp$ = REPLACE$(lpTemp$, "%STY%", dwStyle$)
        lpTemp$ = REPLACE$(lpTemp$, "%X%", x$)
        lpTemp$ = REPLACE$(lpTemp$, "%Y%", y$)
        lpTemp$ = REPLACE$(lpTemp$, "%W%", nWidth$)
        lpTemp$ = REPLACE$(lpTemp$, "%H%", nHeight$)
        TempCtrl$ = TempCtrl$ + lpTemp$ + CRLF$
      End SELECT

     FUNCTION = addtypecontrol
END Function

SUB Add_OOP_End_Code(TempCtrl$, LaterCode$, addtypecontrol) 'as STRING
   Dim BCX_Inc_Path$
   LaterCode$ = LaterCode$ & "'Rem these includes out if they have already been added elsewhere" & crlf$ 
   LaterCode$ = LaterCode$ & "'or add them if needed" & crlf$ & crlf$
   BCX_Inc_Path$ = ENVIRON$("BCXLIB") 'BCXPATH$ & "INCLUDES\"
     IF ! EXIST(BCX_Inc_Path$) then
         LaterCode$ = LaterCode$ & "'BCX\Bin\INCLUDES  FOLDER NOT FOUND"
     END IF
     IF (addtypecontrol BAND 4) then
       If Exist(BCX_Inc_Path$ & "OOP_COMBO.INC") then
          LaterCode$ = LaterCode$ & "$INCLUDE <OOP_COMBO.INC>" & crlf$
       ELSE
          LaterCode$ = LaterCode$ & "$INCLUDE " & ENC$("OOP_COMBO.INC") & crlf$       
       END IF
     END IF
     IF (addtypecontrol BAND 8) then
       If Exist(BCX_Inc_Path$ & "OOP_LISTBOX.INC") then
          LaterCode$ = LaterCode$ & "$INCLUDE <OOP_LISTBOX.INC>" & crlf$
       ELSE
          LaterCode$ = LaterCode$ & "$INCLUDE " & ENC$("OOP_LISTBOX.INC") & crlf$       
       END IF 
     END IF
     IF (addtypecontrol BAND 16) then
       If Exist(BCX_Inc_Path$ & "OOP_LISTVIEW.INC") then
          LaterCode$ = LaterCode$ & "$INCLUDE <OOP_LISTVIEW.INC>" & crlf$
       ELSE
          LaterCode$ = LaterCode$ & "$INCLUDE " & ENC$("OOP_LISTVIEW.INC") & crlf$
       END IF
     END IF         
     IF (addtypecontrol BAND 32) then
       If Exist(BCX_Inc_Path$ & "OOP_TREEVIEW.INC") then
          LaterCode$ = LaterCode$ & "$INCLUDE " & ENC$(BCX_Inc_Path$ & "OOP_TREEVIEW.INC") & crlf$
       ELSE
          LaterCode$ = LaterCode$ & "$INCLUDE " & ENC$("OOP_TREEVIEW.INC") & crlf$       
       END IF
     END IF         
     IF (addtypecontrol BAND 64) then
       If Exist(BCX_Inc_Path$ & "OOP_PROGRESS.INC") then
          LaterCode$ = LaterCode$ & "$INCLUDE <OOP_PROGRESS.INC>" & crlf$
       ELSE
          LaterCode$ = LaterCode$ & "$INCLUDE " & ENC$("OOP_PROGRESS.INC") & crlf$       
       END IF
     END IF
     IF (addtypecontrol BAND 128) then
       If Exist(BCX_Inc_Path$ & "OOP_UPDOWN.INC") then
          LaterCode$ = LaterCode$ & "$INCLUDE <OOP_UPDOWN.INC>" & crlf$
       ELSE
          LaterCode$ = LaterCode$ & "$INCLUDE " & ENC$("OOP_UPDOWN.INC") & crlf$       
       END IF
     END IF
     IF (addtypecontrol BAND 256) then
       If Exist(BCX_Inc_Path$ & "OOP_SLIDER.INC") then
          LaterCode$ = LaterCode$ & "$INCLUDE <OOP_SLIDER.INC>" & crlf$
       ELSE
          LaterCode$ = LaterCode$ & "$INCLUDE " & ENC$("OOP_SLIDER.INC") & crlf$       
       END IF
     END IF
     IF (addtypecontrol BAND 512) then
       If Exist(BCX_Inc_Path$ & "OOP_RA_GRID.INC") then
          LaterCode$ = LaterCode$ & "$INCLUDE <OOP_RA_GRID.INC>" & crlf$
       ELSE
          LaterCode$ = LaterCode$ & "$INCLUDE " & ENC$("OOP_RA_GRID.INC") & crlf$
       END IF
     END IF
     If Exist(BCX_Inc_Path$ & "OOP_FORM.INC") then
        LaterCode$ = LaterCode$ & "$INCLUDE <OOP_FORM.INC>" & crlf$
     ELSE
        LaterCode$ = LaterCode$ & "$INCLUDE " & ENC$("OOP_FORM.INC") & crlf$       
     END IF
'     LaterCode$ = LaterCode$ & "$INCLUDE " & ENC$("OOP_FORM.INC") & crlf$
     If Exist(BCX_Inc_Path$ & "OOP_COMMON_CTRLS.INC") then
        LaterCode$ = LaterCode$ & "$INCLUDE <OOP_COMMON_CTRLS.INC>" & crlf$
     ELSE
        LaterCode$ = LaterCode$ & "$INCLUDE " & ENC$("OOP_COMMON_CTRLS.INC") & crlf$       
     END IF
'     LaterCode$ = LaterCode$ & "$INCLUDE " & ENC$("OOPCommonFunctions.INC") & crlf$
     If Exist(BCX_Inc_Path$ & "OOPCommonFunctions.INC") then
        LaterCode$ = LaterCode$ & "$INCLUDE <OOPCommonFunctions.INC>" & crlf$
     ELSE
        LaterCode$ = LaterCode$ & "$INCLUDE " & ENC$("OOPCommonFunctions.INC") & crlf$       
     END IF
'     LaterCode$ = LaterCode$ & "$INCLUDE " & ENC$("OOPCommonFunctions.INC") & crlf$ 
     TempCtrl$ = "CONST EXTENDS(x) = struct _##x" & crlf$ & crlf$ & TempCtrl$  
     IF NOT SaveModal then 
       TempCtrl$ = TempCtrl$ + "   Form1.CentShow(&Form1) " + CRLF$
     ELSE  
       REPLACE "$INCLUDE" WITH "'$INCLUDE" IN LaterCode$
     End If
'FUNCTION = ""
END SUB ' FUNCTION
'$COMMENT
SET ControlDescID[] AS PCHAR
   "Edt",
   "Grp",
   "Btn",
   "Chk",
   "Rad",
   "Cmb",
   "Lst",
   "Hsl",
   "Vsl",
   "Frm",
   "Pic",
   "Stc",
   "Ani",
   "Rih",
   "Prg",
   "Upd",
   "Lvw",
   "Trv",
   "Trk",
   "Bmp",
   "Dat",
   "Cal",
   "Ipa",
   "Usr",
   "Ico",
   "Grd",
   "Inp"
END SET

Function AddCtrlEvents$(enumcode$)
  DIM RAW ctrltxt$, lines, idx
  Dim strNew$, LINE$
  ctrltxt$ = enumcode$
  lines = ParseCount(ctrltxt$, crlf$)
  For idx = 1 to lines
     LINE$ = Parse(ctrltxt$,crlf$, idx)
     IF LEN(TRIM$(LINE$)) = 0 then ITERATE
     IF NOT Instr(UCASE$(LINE$),"ENUM") THEN'

         strNew$ = strNew$ & "          " & "CASE " & TRIM$(LINE$) & crlf$
     END IF
  Next i
  Function = strNew$
End Function

Function AddOOPCtrlEvents$(enumcode$)
  DIM RAW ctrltxt$, lines, idx
  Dim strNew$, LINE$
  ctrltxt$ = enumcode$
  lines = ParseCount(ctrltxt$, crlf$)
  For idx = 1 to lines
     LINE$ = Parse(ctrltxt$,crlf$, idx)
     IF LEN(TRIM$(LINE$)) = 0 then ITERATE
     IF NOT Instr(UCASE$(LINE$),"ENUM") THEN
       If Instr(UCASE$(LINE$),"ID_")  then
         strNew$ = strNew$ & "          " & "CASE " & REMOVE$(TRIM$(LINE$),"ID_" ) & ".ID" & crlf$
       End If
     END IF
  Next i
  Function = strNew$
End Function

Function AddCtrlColorEvents$ OPTIONAL(vi AS VARINFO PTR, UseOOP = 0)
  Dim strNew$, i
  DIM AUTO Styleidx[MaxToolTypes], ctype
  DIM myStyle
  Dim nameS$
  strNew$ = "" '& crlf$
  FOR i = 1 TO *(vi->controlindex)
      ctype = vi->holdctl[i].ctype - 1
      INCR Styleidx[ctype]
      myStyle = Styleidx[ctype]
      
      'IF (vi->holdctl[i].forecolor) OR (vi->holdctl[i].backcolor)  THEN
      IF vi->holdctl[i].UseColor THEN
         nameS$ =  vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle))
         IF UseOOP  = 0 THEN
            strNew$ = strNew$ & "        " & "CASE  h" & nameS$ & crlf$
            strNew$ = strNew$ & "           " & "FUNCTION = BCX_SETCOLOR(" & nameS$ & "_FC, " & nameS$ & "_BC)"  & crlf$
         ELSE
            strNew$ = strNew$ & "        " & "CASE " & nameS$ & ".hWnd" & crlf$
            strNew$ = strNew$ & "           " & "FUNCTION = BCX_SETCOLOR(" & nameS$ & _
                 ".ForegroundRGBColor," & nameS$ & ".BackgroundRGBColor)" & crlf$
         END IF
      END IF
  NEXT i
  Function = strNew$  
End Function


Function AddCtrlColorGlobals$ (vi AS VARINFO PTR)
  Dim strNew$, i
  DIM AUTO Styleidx[MaxToolTypes], ctype
  DIM myStyle
  FOR i = 1 TO *(vi->controlindex)
      ctype = vi->holdctl[i].ctype - 1
      INCR Styleidx[ctype]
      myStyle = Styleidx[ctype]
      'IF (vi->holdctl[i].forecolor) OR (vi->holdctl[i].backcolor)  THEN
      IF vi->holdctl[i].UseColor THEN
          strNew$ = strNew$ & "GLOBAL " & vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle)) & "_FC   "  & crlf$
          strNew$ = strNew$ & "GLOBAL " & vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle)) & "_BC   "  & crlf$
      END IF
  NEXT i
  Function = strNew$ & crlf$
End Function



Function AddFontCode$(lpWindowName$,  tCtrl as CONTROLS)
   Dim fontcode$
   Dim ctrlName$
   fontcode$ = "BCX_SET_FONT(" & lpWindowName$ & "," &  enc$(trim$(tCtrl.font.Font_name$)) & "," & str$(tCtrl.font.Font_size) & ","
   fontcode$ = fontcode$ & str$(tCtrl.font.Font_weight) & "," & str$(tCtrl.font.Font_italic) & ","
   fontcode$ = fontcode$ & str$(tCtrl.font.Font_underline) & "," & str$(tCtrl.font.Font_strikethrough) & ")"
   Function = fontcode$
End Function

'$include "DebugPrintFile.inc"

FUNCTION Save_Blank_GridSetup$( hGrid$)' AS HWND )
   Dim grdText$
   grdText$ = "SUB GridSetup"+ hGrid$ + "( hGrid AS HWND )"  & CRLF$
   grdText$ = grdText$ + "  DIM AUTO col AS COLUMN"  & CRLF$
   grdText$ = grdText$ + "  col.colwt       = 100"  & CRLF$
   grdText$ = grdText$ + "  col.lpszhdrtext = " & ENC$("EditText")  & CRLF$
   grdText$ = grdText$ + "  col.halign      = GA_ALIGN_CENTER"  & CRLF$
   grdText$ = grdText$ + "  col.calign      = GA_ALIGN_LEFT"  & CRLF$
   grdText$ = grdText$ + "  col.ctype       = TYPE_EDITTEXT"  & CRLF$
   grdText$ = grdText$ + "  col.ctextmax    = 0"  & CRLF$
   grdText$ = grdText$ + "  col.lpszformat  = 0"  & CRLF$
   grdText$ = grdText$ + "  col.himl        = 0"  & CRLF$
   grdText$ = grdText$ + "  col.hdrflag     = 0"  & CRLF$
   grdText$ = grdText$ + "  col.hdrmenu     = 0"  & CRLF$
   grdText$ = grdText$ + "  col.cellmenu    = 0"  & CRLF$
   grdText$ = grdText$ + "  col.lParam      = ES_MULTILINE BOR ES_AUTOVSCROLL"  & CRLF$
   grdText$ = grdText$ + "  SendMessage(hGrid, GM_ADDCOL, 0, &col)"  & CRLF$
   grdText$ = grdText$ + "END SUB"  & CRLF$   & CRLF$
   FUNCTION = grdText$
END FUNCTION
