'Simple plugin interface
$DLL

$INCLUDE "SaveAsMDIForms.inc"
$INCLUDE "AddThisMenu.inc"
'$INCLUDE "Bas2Bmfd.bas"


TYPE ctrlFont
 Font_name[128] AS CHAR
 Font_charset
 Font_weight
 Font_size
 Font_underline
 Font_italic
 Font_strikethrough
 hFont AS HFONT
END TYPE

TYPE CONTROLS
   hWnd     AS HWND
   rect     AS RECT
   ctype
   disabled
   selected
   zorder
   Group
   UseColor AS BOOL
   forecolor
   backcolor
   font AS ctrlFont
END TYPE

TYPE CTRLCOPY
   CtrlClone  AS CONTROLS
   sty        AS DWORD
   extsty     AS DWORD
   caption$
END TYPE

TYPE VARINFO
  DIM curidx AS INTEGER PTR
  DIM controlindex AS INTEGER PTR
  DIM holdctl AS CONTROLS PTR
  DIM copy AS CTRLCOPY PTR
  DIM ControlDesc AS CHAR PTR PTR
  DIM ControlTypes AS CHAR PTR PTR
  DIM Forms AS HWND PTR
  DIM hEdit AS HWND PTR
  FUNCTION EStyleConst() AS  CHAR PTR
  FUNCTION GetStyleConst(hwndTarget AS HWND ,hwndStyleList ,hwndExStyleList ,fAllStyles AS BOOL ) AS CHAR PTR
  FUNCTION EEnums() AS CHAR PTR
  FUNCTION EHandles() AS CHAR PTR
  SUB Zorder()' AS SUB
  SUB Savit() 'AS SUB
  SUB SaveBCXCode()
  SUB LoadForm(filename$)
  DIM plgn_ScaleX AS SINGLE PTR
  DIM plgn_ScaleY AS SINGLE PTR
  'FUNCTION AddMenu() AS INTEGER PTR
END TYPE

'******************************************

TYPE FunctionList
  sFuncName$[100] AS CHAR
  FUNCTION PluginFunction(vi AS VARINFO PTR) AS INTEGER
END TYPE

TYPE PluginMenuInfo
  MF AS INTEGER
  PI AS INTEGER
  SL[20] AS CHAR
END TYPE

Type PLUGIN_INTERFACE
  sName$[100] AS CHAR
  SUB MakeMenu(i AS HMENU PTR, PID AS INTEGER)
  PlugInMenu AS HMENU
  FunctionCount AS INTEGER
  Flist AS FunctionList PTR PTR
END Type

GLOBAL MyPlugin AS PLUGIN_INTERFACE
GLOBAL formName AS STRING
GLOBAL SaveModal AS INTEGER
GLOBAL SaveMDIClient AS INTEGER
GLOBAL SaveMDIChild AS INTEGER
GLOBAL MenuCode$     'TO add Menu Code TO the output
GLOBAL g_MenuMakePath$

CONST MaxToolTypes = 30

'CONST PIDM_0 = 0
CONST PIDM_1 = 1
CONST PIDM_2 = 2
CONST PIDM_3 = 3
CONST PIDM_4 = 4
CONST PIDM_5 = 5
CONST PIDM_6 = 6
CONST PIDM_7 = 7
CONST PIDM_8 = 8
CONST PIDM_9 = 9
CONST PIDM_10 = 10

'Export the structure
FUNCTION GetMyPluginInterface AS LPPLUGIN_INTERFACE EXPORT
  DIM i
  MyPlugin.sName$ = "Import/Export2"
  MyPlugin.MakeMenu = MakePluginMenu
  MyPlugin.FunctionCount = 7
  MyPlugin.Flist = calloc(MyPlugin.FunctionCount,SIZEOF(FunctionList PTR))
  FOR i = 0 TO MyPlugin.FunctionCount-1
    MyPlugin.Flist[i] = calloc(1,SIZEOF(FunctionList))
  NEXT
  MyPlugin.Flist[0]->PluginFunction = Create_BCX_Form_Code '
  MyPlugin.Flist[0]->sFuncName$ = "BCX Form Code"
  MyPlugin.Flist[1]->PluginFunction = CreateModalFormCode '
  MyPlugin.Flist[1]->sFuncName$ = "BCX MODAL CODE"
  MyPlugin.Flist[2]->PluginFunction = Create_OOP_Form_Code '
  MyPlugin.Flist[2]->sFuncName$ = "OOP"
  MyPlugin.Flist[3]->PluginFunction = Create_OOP_Modal_Form_Code '
  MyPlugin.Flist[3]->sFuncName$ = "OOP MODAL"
  MyPlugin.Flist[4]->PluginFunction = Create_MDIParent_Form_Code '
  MyPlugin.Flist[4]->sFuncName$ = "BCX MDI CLIENT CODE"
  MyPlugin.Flist[5]->PluginFunction = Create_MDIChild_Form_Code '
  MyPlugin.Flist[5]->sFuncName$ = "BCX MDI CHILD CODE"
  MyPlugin.Flist[6]->PluginFunction = RunMenuMaker
  MyPlugin.Flist[6]->sFuncName$ = "Run Menu Maker"
  IF EXIST(APPEXEPATH$ & "Bas2Bmfd.exe") THEN
     MyPlugin.Flist[MyPlugin.FunctionCount] = calloc(1,SIZEOF(FunctionList))
     MyPlugin.Flist[MyPlugin.FunctionCount]->PluginFunction = RunBas2Bmfd
     MyPlugin.Flist[MyPlugin.FunctionCount]->sFuncName$ = "Import Bas file"
     MyPlugin.FunctionCount++
  END IF
  FUNCTION = &MyPlugin
END FUNCTION


SUB MakePluginMenu(i AS HMENU PTR, PID AS INTEGER)
  'AppendMenu(*i, MF_STRING, 0,    " ")
  AppendMenu(*i, MF_STRING, PID+PIDM_1,    "&Create BCX Code")
  AppendMenu(*i, MF_STRING, PID+PIDM_2,    "&Create BCX Dialog Code")
  AppendMenu(*i, MF_STRING, PID+PIDM_3,    "&Create OOP Code")
  AppendMenu(*i, MF_STRING, PID+PIDM_4,    "&Create OOP Dialog Code")
  AppendMenu(*i, MF_STRING, PID+PIDM_5,    "&Create BCX MDI Parent Code")
  AppendMenu(*i, MF_STRING, PID+PIDM_6,    "&Create BCX MDI Child Code")
  AppendMenu(*i, MF_STRING, PID+PIDM_7,    "&Run MakeMenu.exe")
  IF EXIST(APPEXEPATH$ & "Bas2Bmfd.exe") THEN
    AppendMenu(*i, MF_STRING, PID+PIDM_8,    "&Import Bas file")
  END IF
END SUB

FUNCTION GetPrepend$()
  DIM temp$
  temp$ = INPUTBOX$("Add Form Identifier - like 'abt' FOR about", "Prepended TO all control names: ", "")
  'Print "PrePend: " & temp$
  FUNCTION = temp$
END FUNCTION

FUNCTION SetPrepend$(txt2$, AddThis$)
   DIM i
   DIM temp$
   DO
    temp$ = AddThis$ & "_" & ControlDescID[i]
    IF ControlDescID[i] <> "Cal" THEN
      txt2$ = REPLACE$(txt2$, ControlDescID[i], temp$)
    END IF
    i++
   LOOP WHILE ISPTR(ControlDescID[i+1])
   FUNCTION = txt2$
END FUNCTION

GLOBAL Modal_XScale AS single
GLOBAL Modal_YScale AS single

FUNCTION XScale$(a AS INTEGER) 'AS INTEGER
   FUNCTION = STR$(CINT((a * Modal_XScale)/2))
END FUNCTION

FUNCTION YScale$(a AS INTEGER)
   FUNCTION = STR$(CINT((a * Modal_YScale)/2))
END FUNCTION


FUNCTION Create_BCX_Form_Code(vi AS VARINFO PTR)
'  CALL vi->SaveBCXCode()

   DIM RAW dwExStyle$
   DIM RAW lpClassName$
   DIM RAW lpWindowName$
   DIM RAW dwStyle$
   DIM RAW x$
   DIM RAW y$
   DIM RAW nWidth$
   DIM RAW nHeight$
   DIM RAW hMenu$
   DIM RAW lpTemp$
   DIM RAW rc AS RECT
   DIM TempCtrl$ * 100000
   DIM GridCode$ * 10000
   DIM RAW i
   GLOBAL addGridCode
   DIM myStyle
   DIM PreP$
   DIM AUTO Styleidx[MaxToolTypes], ctype
   addGridCode = 0

   'CALL vi->Zorder()
   Modal_XScale = (*(vi->plgn_ScaleX)*2)
   Modal_YScale = (*(vi->plgn_ScaleY)*2)

   SendMessage(*(vi->hEdit), WM_SETTEXT, 0, "")
   ShowWindow(*(vi->hEdit), SW_SHOW)
   GetWindowRect(*(vi->Forms),&rc)

   TempCtrl$ = "GUI " + ENC$("Form1") + ",PIXELS" + CRLF$ + CRLF$

   'Add Styles, enums and declares
   TempCtrl$ = TempCtrl$ + vi->EStyleConst() + CRLF$ + vi->EEnums() + CRLF$ + vi->EHandles() + CRLF$
   TempCtrl$ = TempCtrl$ + AddCtrlColorGlobals$(vi)
   TempCtrl$ = TempCtrl$ + "SUB FORMLOAD()" + CRLF$
   TempCtrl$ = TempCtrl$ + "  DIM hFont AS HFONT" + CRLF$
   TempCtrl$ = TempCtrl$ + "   Form1 = BCX_FORM(" + ENC$("Form1") + ", 0, 0," + STR$(rc.right-rc.left) + "," + STR$(rc.bottom-rc.top)+ ")" + CRLF$

   FOR i = 1 TO *(vi->controlindex)
      ctype = vi->holdctl[i].ctype - 1
      INCR Styleidx[ctype]
      myStyle = Styleidx[ctype]
     ' extended window style
      dwExStyle$ = vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle)) + "_ExtStyle"

      ' registered class name
      GetClassName(vi->holdctl[i].hWnd, lpClassName$, 2048)

      ' window name
      GetWindowText(vi->holdctl[i].hWnd, lpWindowName$, 2048)

      ' window style
      dwStyle$ = vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle)) + "_Style"

      ' horizontal position of window
      x$ = XScale$(vi->holdctl[i].rect.left)

      ' vertical position of window
      y$ = YScale$(vi->holdctl[i].rect.top)

      ' window width
      nWidth$ = XScale$(vi->holdctl[i].rect.right-(vi->holdctl[i].rect.left))

      ' window height
      nHeight$ = YScale$(vi->holdctl[i].rect.bottom-(vi->holdctl[i].rect.top))

      hMenu$ = "ID_" + vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle))

      lpTemp$ = "   h" + vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle)) + " = " + vi->ControlTypes$[ctype]

      lpTemp$ = REPLACE$(lpTemp$, "%HWND%", "Form1")
      lpTemp$ = REPLACE$(lpTemp$, "%ID%", hMenu$)
      lpTemp$ = REPLACE$(lpTemp$, "%EXTSTY%", dwExStyle$)
      lpTemp$ = REPLACE$(lpTemp$, "%CLASS%", ENC$(lpClassName$))
      lpTemp$ = REPLACE$(lpTemp$, "%CAP%",   ENC$(lpWindowName$))
      lpTemp$ = REPLACE$(lpTemp$, "%STY%", dwStyle$)
      lpTemp$ = REPLACE$(lpTemp$, "%X%", x$)
      lpTemp$ = REPLACE$(lpTemp$, "%Y%", y$)
      lpTemp$ = REPLACE$(lpTemp$, "%W%", nWidth$)
      lpTemp$ = REPLACE$(lpTemp$, "%H%", nHeight$)
      TempCtrl$ = TempCtrl$ + lpTemp$ + CRLF$
      IF LEN(vi->holdctl[i].font.Font_name$) THEN
         TempCtrl$ = TempCtrl$ & "   " & _
         AddFontCode$ (" h" + vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle)),vi->holdctl[i]) _
         & CRLF$                                               'STR$(i) &
      END IF
      IF vi->holdctl[i].UseColor THEN
         TempCtrl$ = TempCtrl$ + "   " + vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle)) + "_FC = "  + STR$(vi->holdctl[i].forecolor) + _
         " : " + vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle)) + "_BC = "  + STR$(vi->holdctl[i].backcolor) + CRLF$
      END IF
      IF ctype = 25 THEN
         addGridCode++
         GridCode$ = GridCode$ + Save_Blank_GridSetup$(vi->ControlDesc$[ctype] + LTRIM$(STR$(Styleidx[ctype])))
         TempCtrl$ = TempCtrl$ + "   CALL GridSetup"+ vi->ControlDesc$[ctype]+ LTRIM$(STR$(Styleidx[ctype]))+"(h" & vi->ControlDesc$[ctype] +  LTRIM$(STR$(myStyle)) +")"  + CRLF$
      END IF
   NEXT i
   IF MenuCode$ <> "" THEN
      TempCtrl$ = TempCtrl$ + "   'Add Our Menu" + CRLF$
      TempCtrl$ = TempCtrl$ + "   AddMenu(Form1)" + CRLF$ + CRLF$
   END IF
   TempCtrl$ = TempCtrl$ + "   CENTER(Form1)" + CRLF$
   TempCtrl$ = TempCtrl$ + "   SHOW(Form1)" + CRLF$
   TempCtrl$ = TempCtrl$ + "END SUB" + CRLF$ + CRLF$
   TempCtrl$ = TempCtrl$ + "BEGIN EVENTS"+ CRLF$
   TempCtrl$ = TempCtrl$ + " SELECT CASE CBMSG" & CRLF$
   
   lpTemp$ = AddCtrlColorEvents$(vi,0)
   
   IF LEN(lpTemp$) THEN   
     TempCtrl$ = TempCtrl$ + "    CASE WM_CTLCOLORSTATIC, WM_CTLCOLORBTN, WM_CTLCOLOREDIT,WM_CTLCOLORLISTBOX, WM_CTLCOLORSCROLLBAR" & CRLF$
     TempCtrl$ = TempCtrl$ + "      SELECT CASE (HWND)CBLPARAM" & CRLF$''
  
     'Add Color events
     TempCtrl$ = TempCtrl$ + lpTemp$ & CRLF$  'AddCtrlColorEvents$(vi,0) '
     TempCtrl$ = TempCtrl$ + "      END SELECT" & CRLF$
   END IF
   
   TempCtrl$ = TempCtrl$ + "   CASE WM_COMMAND" & CRLF$
   TempCtrl$ = TempCtrl$ + "      SELECT CASE CBCTL" & CRLF$

   'Add control Events
   TempCtrl$ = TempCtrl$ + AddCtrlEvents$(vi->EEnums())
   'Add menu Events
   TempCtrl$ = TempCtrl$ + AddMenuEvents(MenuCode$) & CRLF$

   TempCtrl$ = TempCtrl$ + "      END SELECT" & CRLF$
   TempCtrl$ = TempCtrl$ + " END SELECT" & CRLF$
   TempCtrl$ = TempCtrl$ + "END EVENTS" + CRLF$

   TempCtrl$ = TempCtrl$ & MenuCode$

   IF addGridCode THEN   ' it's RAGrid   remember ctype = ctype-1 above
        'IF the user has an BCXLIB folder look in there
        IF EXIST (ENVIRON$("BCXLIB")  + "BCXraGrid.inc")  THEN
           TempCtrl$ = "$INCLUDE " + "<BCXraGrid.inc>"+ CRLF$ + CRLF$ + TempCtrl$ + CRLF$
           TempCtrl$ = "'Using BCXLIB Path" + CRLF$ + TempCtrl$ + CRLF$
        ELSE  'now up TO the user TO add TO app folder or set the path
           TempCtrl$ = "$INCLUDE " + ENC$("BCXraGrid.inc")+ CRLF$ + CRLF$ + TempCtrl$ + CRLF$
           TempCtrl$ = "'raGrid files pathed TO current folder " + CRLF$ + TempCtrl$
        END IF 
        TempCtrl$ = TempCtrl$ +  GridCode$
   END IF
   IF LEN(PreP$) <> 0 THEN
      TempCtrl$ = SetPrepend$(TempCtrl$,PreP$)
   END IF

   SendMessage(*(vi->hEdit), WM_SETTEXT, 0, TempCtrl$)
   CALL vi->Savit()
   FUNCTION = GetLastError()
END FUNCTION

FUNCTION CreateModalFormCode(vi AS VARINFO PTR)

   DIM RAW dwExStyle$
   DIM RAW lpClassName$
   DIM RAW lpWindowName$
   DIM RAW dwStyle$
   DIM RAW x$
   DIM RAW y$
   DIM RAW nWidth$
   DIM RAW nHeight$
   DIM RAW hMenu$
   DIM RAW lpTemp$
   DIM RAW rc AS RECT
   DIM TempCtrl$ * 100000
   DIM LaterCode$ * 100000
   DIM firstcode$ * 100000
   DIM GridCode$ * 100000
   DIM addtypecontrol
   DIM myStyle
   DIM tempStyle$
   DIM RAW i
   DIM PreP$
   DIM AUTO Styleidx[MaxToolTypes], ctype
   
   addGridCode = 0

   PreP$ = TRIM$(GetPrepend$())
   CALL vi->Zorder()
   Modal_XScale = *(vi->plgn_ScaleX)
   Modal_YScale = *(vi->plgn_ScaleY)

   ShowWindow(*(vi->hEdit), SW_SHOW)
   GetWindowRect(*(vi->Forms),&rc)
   TempCtrl$ = "'Created with BMFD by Mike Henning" + CRLF$ + CRLF$
   TempCtrl$ = TempCtrl$ + "'This is a Modal dialog form, CALL it from your main form, it will NOT run by itself"  + CRLF$
   TempCtrl$ = TempCtrl$ + "'TO make this a modeless dialog change BCX_MDialog TO BCX_Dialog and," + CRLF$
   TempCtrl$ = TempCtrl$ + "'BEGIN MODAL DIALOG TO BEGIN DIALOG" + CRLF$ + CRLF$
   TempCtrl$ = TempCtrl$ + "'Also be sure there are no naming conflicts with existing controls and control ID numbers" + CRLF$ + CRLF$
   TempCtrl$ = TempCtrl$ + "'See BCX Help file on BCX_MDialog & BCX_Dialog functions" + CRLF$ + CRLF$

   TempCtrl$ = TempCtrl$ + vi->EStyleConst() + CRLF$ + vi->EEnums() + CRLF$ + vi->EHandles() + CRLF$

   formName = "FormXYZ"

   'Add The Globals FOR controls that use colors
   TempCtrl$ = TempCtrl$ + AddCtrlColorGlobals$(vi)

   TempCtrl$ = TempCtrl$ + "FUNCTION FormXYZ_Create( hParent AS HWND) AS INTEGER" & CRLF$
   TempCtrl$ = TempCtrl$ + chr$(9) + "BCX_MDialog(Ev_FormXYZ," + ENC$("FormXYZ Title")+ _
      ", hParent, " + _
      XScale$(rc.left) + ", " + YScale$(rc.top) + ", " + XScale$((rc.right- rc.left)) + ", " + _
      YScale$((rc.bottom - rc.top)) + ") "  & CRLF$

   TempCtrl$ = TempCtrl$ + chr$(9) + "FUNCTION = 0" & CRLF$
   TempCtrl$ = TempCtrl$ + "END FUNCTION" + CRLF$
   TempCtrl$ = TempCtrl$ +   CRLF$ + CRLF$
   TempCtrl$ = TempCtrl$ + "BEGIN MODAL DIALOG AS Ev_FormXYZ" + CRLF$
   TempCtrl$ = TempCtrl$ + " DIM hFont AS HFONT" + CRLF$
   TempCtrl$ = TempCtrl$ + " SELECT CASE CBMSG" + CRLF$
   TempCtrl$ = TempCtrl$ + " CASE WM_INITDIALOG" + CRLF$
   TempCtrl$ = TempCtrl$ + "   FormXYZ = hWnd" + CRLF$

   FOR i = 1 TO *(vi->controlindex)
      ctype = vi->holdctl[i].ctype - 1
      INCR Styleidx[ctype]
      myStyle = Styleidx[ctype]

     ' extended window style
      'dwExStyle$ = vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle)) + "_ExtStyle"
      dwExStyle$ = vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle)) + "_ExtStyle"

      ' registered class name
      GetClassName(vi->holdctl[i].hWnd, lpClassName$, 2048)

      ' window name
      GetWindowText(vi->holdctl[i].hWnd, lpWindowName$, 2048)

      ' window style
      dwStyle$ = vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle)) + "_Style"

      ' horizontal position of window
      x$ = XScale$(vi->holdctl[i].rect.left)

      ' vertical position of window
      y$ = YScale$(vi->holdctl[i].rect.top)

      ' window width
      nWidth$ = XScale$(vi->holdctl[i].rect.right-(vi->holdctl[i].rect.left))

      ' window height
      nHeight$ = YScale$(vi->holdctl[i].rect.bottom-(vi->holdctl[i].rect.top))

      hMenu$ = "ID_" + vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle))

      lpTemp$ = "   h" + vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle)) + " = " + vi->ControlTypes$[ctype]

      lpTemp$ = REPLACE$(lpTemp$, "%HWND%", "Form1")
      lpTemp$ = REPLACE$(lpTemp$, "%ID%", hMenu$)
      lpTemp$ = REPLACE$(lpTemp$, "%EXTSTY%", dwExStyle$)
      lpTemp$ = REPLACE$(lpTemp$, "%CLASS%", ENC$(lpClassName$))
      lpTemp$ = REPLACE$(lpTemp$, "%CAP%",   ENC$(lpWindowName$))
      lpTemp$ = REPLACE$(lpTemp$, "%STY%", dwStyle$)
      lpTemp$ = REPLACE$(lpTemp$, "%X%", x$)
      lpTemp$ = REPLACE$(lpTemp$, "%Y%", y$)
      lpTemp$ = REPLACE$(lpTemp$, "%W%", nWidth$)
      lpTemp$ = REPLACE$(lpTemp$, "%H%", nHeight$)
      TempCtrl$ = TempCtrl$ + lpTemp$ + CRLF$

      IF LEN(vi->holdctl[i].font.Font_name$) THEN
         TempCtrl$ = TempCtrl$ + "   " + _
         AddFontCode$ ("h" + vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle)),vi->holdctl[i]) _
         + CRLF$
      END IF

      IF vi->holdctl[i].UseColor THEN
         TempCtrl$ = TempCtrl$ + "   " + vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle)) + "_FC = "  & STR$(vi->holdctl[i].forecolor) + _
         " : " + vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle)) + "_BC = "  + STR$(vi->holdctl[i].backcolor) + CRLF$
      END IF

      IF ctype = 25 THEN
         addGridCode++
         GridCode$ = GridCode$ + Save_Blank_GridSetup$(vi->ControlDesc$[ctype] + LTRIM$(STR$(Styleidx[ctype])))
         TempCtrl$ = TempCtrl$ & "   CALL GridSetup"+ vi->ControlDesc$[ctype]+ LTRIM$(STR$(Styleidx[ctype]))+"(h" & vi->ControlDesc$[ctype] +  LTRIM$(STR$(myStyle)) +")"  + CRLF$
      END IF

   NEXT i

   IF MenuCode$ <> "" THEN
      TempCtrl$ = TempCtrl$ + "   'Add Our Menu" + CRLF$
      TempCtrl$ = TempCtrl$ + "   AddMenu(" & formName & ")" + CRLF$ + CRLF$
   END IF

   TempCtrl$ = firstcode$ + CRLF$ & TempCtrl$ + "    Show(" & formName & ")" + CRLF$

   lpTemp$ = AddCtrlColorEvents$(vi,0)
   IF LEN(lpTemp$) THEN
     TempCtrl$ = TempCtrl$ + "    CASE WM_CTLCOLORSTATIC, WM_CTLCOLORBTN, WM_CTLCOLOREDIT,WM_CTLCOLORLISTBOX, WM_CTLCOLORSCROLLBAR" + CRLF$
     TempCtrl$ = TempCtrl$ + "      SELECT CASE (HWND)CBLPARAM" + CRLF$
  
     'Add Color events
     TempCtrl$ = TempCtrl$ + lpTemp$ & CRLF$ 'AddCtrlColorEvents$(vi,0)
     TempCtrl$ = TempCtrl$ + "      END SELECT" & CRLF$
   END IF

   TempCtrl$ = TempCtrl$ + " CASE WM_COMMAND"  & CRLF$
   TempCtrl$ = TempCtrl$ + "      SELECT CASE CBCTL" & CRLF$

   'Add control Events
   TempCtrl$ = TempCtrl$ + AddCtrlEvents$(vi->EEnums())
   'Add menu Events
   TempCtrl$ = TempCtrl$ + AddMenuEvents(MenuCode$) & CRLF$

   TempCtrl$ = TempCtrl$ + "      END SELECT" & CRLF$

   TempCtrl$ = TempCtrl$ + " END SELECT"  & CRLF$
   TempCtrl$ = TempCtrl$ + "END DIALOG" + CRLF$ & CRLF$

   TempCtrl$ = TempCtrl$ + MenuCode$

   IF addGridCode THEN   ' it's RAGrid   remember ctype = ctype-1 above
        'IF the user has an BCXLIB folder look in there
        IF EXIST (ENVIRON$("BCXLIB")  & "BCXraGrid.inc")  THEN           
           TempCtrl$ = "$INCLUDE " + "<BCXraGrid.inc>"+ CRLF$ + CRLF$ + TempCtrl$ + CRLF$
           TempCtrl$ = "'Using BCXLIB Path" + CRLF$ + TempCtrl$ + CRLF$
        ELSE  'now up TO the user TO add TO app folder or set the path
           TempCtrl$ = "$INCLUDE " + ENC$("BCXraGrid.inc")+ CRLF$ + CRLF$ + TempCtrl$ + CRLF$
           TempCtrl$ = "'raGrid files pathed TO current folder " + CRLF$ + TempCtrl$
       END IF 
       TempCtrl$ = TempCtrl$ +  GridCode$
   END IF

   REPLACE "Form1" WITH "FormXYZ" IN TempCtrl$
   IF LEN(PreP$) <> 0 THEN
      TempCtrl$ = SetPrepend$(TempCtrl$,PreP$)    'Prepend a string TO all controls
      TempCtrl$ = REPLACE$(TempCtrl$,"FormXYZ","Form" & PreP$)  'Change FormXYZ TO user name
   END IF

   SendMessage(*(vi->hEdit), WM_SETTEXT, 0, TempCtrl$)
   CALL vi->Savit()
   FUNCTION = GetLastError()
END FUNCTION


FUNCTION Create_OOP_Modal_Form_Code(vi AS VARINFO PTR) AS INTEGER
   DIM RAW rc AS RECT
   DIM TempCtrl$ * 100000
   DIM LaterCode$ * 100000
   DIM GridCode$ * 10000
   DIM RAW i
   DIM RAW lpTemp$

   DIM PreP$

   DIM AUTO Styleidx[MaxToolTypes], ctype
   DIM addtypecontrol

   addGridCode = 0

   ShowWindow(*(vi->hEdit), SW_SHOW)
   GetWindowRect(*(vi->Forms),&rc)
   Modal_XScale = *(vi->plgn_ScaleX)
   Modal_YScale = *(vi->plgn_ScaleY)
   
   SaveModal = TRUE
   
   PreP$ = GetPrepend$()
   TempCtrl$ = "'Created with BMFD by Mike Henning" + CRLF$ + CRLF$
   TempCtrl$ = TempCtrl$ & "'This is a OOP type Modal dialog form, CALL it from your main form, it will NOT run by itself"  + CRLF$
   TempCtrl$ = TempCtrl$ + "'TO make this a modeless dialog change BCX_MDialog TO BCX_Dialog and," + CRLF$
   TempCtrl$ = TempCtrl$ + "'BEGIN MODAL DIALOG TO BEGIN DIALOG" + CRLF$ + CRLF$
   TempCtrl$ = TempCtrl$ + "'Also be sure there are no naming conflicts with existing controls and control ID numbers" + CRLF$ + CRLF$
   TempCtrl$ = TempCtrl$ + "'See BCX Help file on BCX_MDialog & BCX_Dialog functions" + CRLF$ + CRLF$
   TempCtrl$ = TempCtrl$ + "'See $INCLUDES at END of this file IF you get functions or varibles not found errors" + CRLF$
   TempCtrl$ = TempCtrl$ + "'I assumed IF you are using OOP Code FOR this Dialog you are using OOP code "
   TempCtrl$ = TempCtrl$ + CRLF$ + "'FOR the rest of your code, but I did add the Includes just in case" & CRLF$ + _
   "'Plugin by Wayne H & IDC" + CRLF$ + CRLF$
   formName = "FormXYZ"
   TempCtrl$ = TempCtrl$ + "FUNCTION FormXYZ_Create( hParent AS HWND) AS INTEGER" + CRLF$
   TempCtrl$ = TempCtrl$ + chr$(9) + "BCX_MDialog(Ev_FormXYZ," + ENC$("FormXYZ Title")& _
      ", hParent, " + _
      XScale$(rc.left) + ", " + YScale$(rc.top) + ", " & XScale$((rc.right-rc.left)) + ", " + _
      YScale$((rc.bottom - rc.top)) + ") "  + CRLF$

   TempCtrl$ = TempCtrl$ + chr$(9) + "FUNCTION = 0" + CRLF$
   TempCtrl$ = TempCtrl$ + "END FUNCTION" + CRLF$
   TempCtrl$ = TempCtrl$ +   CRLF$ + CRLF$
   'CALL the_Form_Code("FormXYZ", rc, TempCtrl$, LaterCode$) 'NOT NEEDED in modal forms
   TempCtrl$ = TempCtrl$ + "BEGIN MODAL DIALOG AS Ev_FormXYZ" + CRLF$
   TempCtrl$ = TempCtrl$ + " GLOBAL FormXYZ AS HWND" + CRLF$
   TempCtrl$ = TempCtrl$ + " SELECT CASE CBMSG" & CRLF$

   lpTemp$ = AddCtrlColorEvents$(vi,1)
   IF LEN(lpTemp$) THEN
     TempCtrl$ = TempCtrl$ + "    CASE WM_CTLCOLORSTATIC, WM_CTLCOLORBTN, WM_CTLCOLOREDIT,WM_CTLCOLORLISTBOX, WM_CTLCOLORSCROLLBAR" + CRLF$
     TempCtrl$ = TempCtrl$ + "      SELECT CASE (HWND)CBLPARAM" + CRLF$
  
     'Add Color events
     TempCtrl$ = TempCtrl$ + lpTemp$ + CRLF$ 'AddCtrlColorEvents$(vi,1)
  
     TempCtrl$ = TempCtrl$ + "      END SELECT" + CRLF$
   END IF

   TempCtrl$ = TempCtrl$ + " CASE WM_INITDIALOG" + CRLF$
   TempCtrl$ = TempCtrl$ + "   FormXYZ = hWnd" + CRLF$

   FOR i = 1 TO *(vi->controlindex)
      ctype = vi->holdctl[i].ctype - 1
      INCR Styleidx[ctype]
       addtypecontrol = Add_OOP_Control(TempCtrl$, LaterCode$, i, addtypecontrol, ctype, Styleidx[ctype],vi)
   NEXT i
   IF MenuCode$ <> "" THEN
      TempCtrl$ = TempCtrl$ + "   'Add Our Menu" + CRLF$
      TempCtrl$ = TempCtrl$ + "   AddMenu(" & formName & ")" + CRLF$ + CRLF$
   END IF
   TempCtrl$ = TempCtrl$ + "    Show(" & formName & ")" + CRLF$

   CALL Add_OOP_End_Code(TempCtrl$, LaterCode$, addtypecontrol)
   TempCtrl$ = TempCtrl$ + " CASE WM_COMMAND"  + CRLF$
   TempCtrl$ = TempCtrl$ + "      SELECT CASE CBCTL" + CRLF$

   'Add control Events
   TempCtrl$ = TempCtrl$ + AddOOPCtrlEvents$(vi->EEnums())
   'Add menu Events
   TempCtrl$ = TempCtrl$ + AddMenuEvents(MenuCode$) + CRLF$

   TempCtrl$ = TempCtrl$ + "      END SELECT" + CRLF$
   
   TempCtrl$ = TempCtrl$ + " END SELECT"  + CRLF$
   TempCtrl$ = TempCtrl$ + "END DIALOG" + CRLF$ + CRLF$

   TempCtrl$ = TempCtrl$ + MenuCode$

   TempCtrl$ = TempCtrl$ + LaterCode$

   REPLACE "Form1" WITH "FormXYZ" IN TempCtrl$
   IF LEN(PreP$) <> 0 THEN
      TempCtrl$ = SetPrepend$(TempCtrl$,PreP$)
   END IF

   SendMessage(*(vi->hEdit), WM_SETTEXT, 0, TempCtrl$)
   CALL vi->Savit()
   FUNCTION = 0
END FUNCTION


FUNCTION Create_OOP_Form_Code(vi AS VARINFO PTR) AS INTEGER


   DIM RAW rc AS RECT
   DIM TempCtrl$ * 100000
   DIM LaterCode$ * 100000
   DIM GridCode$ * 10000
   DIM RAW i
   DIM RAW lpTemp$
   addGridCode = 0
   
   formName = "Form1"
   DIM AUTO Styleidx[MaxToolTypes], ctype
   DIM addtypecontrol
   SaveModal = FALSE
   ShowWindow(*(vi->hEdit), SW_SHOW)
   GetWindowRect(*(vi->Forms),&rc)

   TempCtrl$ = "'Created with BMFD by Mike Henning" + CRLF$
   TempCtrl$ = TempCtrl$ + "'Plugin by Wayne H & IDC" & CRLF$ + CRLF$
   TempCtrl$ = TempCtrl$ + "GUI " + ENC$(formName) + ",PIXELS" + CRLF$ + CRLF$
   CALL Start_OOP_Form_Code(formName, rc, TempCtrl$, LaterCode$)

   FOR i = 1 TO *(vi->controlindex)
      ctype = vi->holdctl[i].ctype - 1
      INCR Styleidx[ctype]
       addtypecontrol = Add_OOP_Control(TempCtrl$, LaterCode$, i, addtypecontrol, ctype, Styleidx[ctype],vi)
   NEXT i
   IF MenuCode$ <> "" THEN
      TempCtrl$ = TempCtrl$ + "   'Add Our Menu" + CRLF$
      TempCtrl$ = TempCtrl$ + "   AddMenu(" + formName + ")" + CRLF$ + CRLF$
   END IF

   CALL Add_OOP_End_Code(TempCtrl$, LaterCode$, addtypecontrol)
   TempCtrl$ = TempCtrl$ + "END SUB" + CRLF$ + CRLF$
   TempCtrl$ = TempCtrl$ + "BEGIN EVENTS" + CRLF$
   TempCtrl$ = TempCtrl$ + "  SELECT CASE CBMSG" + CRLF$
   
   lpTemp$ = AddCtrlColorEvents$(vi,1)
   IF LEN(lpTemp$) THEN
     TempCtrl$ = TempCtrl$ + "    CASE WM_CTLCOLORSTATIC, WM_CTLCOLORBTN, WM_CTLCOLOREDIT,WM_CTLCOLORLISTBOX, WM_CTLCOLORSCROLLBAR" + CRLF$
     TempCtrl$ = TempCtrl$ + "      SELECT CASE (HWND)CBLPARAM" + CRLF$
     'Add Color events
     TempCtrl$ = TempCtrl$ + lpTemp$ + CRLF$ 'AddCtrlColorEvents$(vi,1)
  
     TempCtrl$ = TempCtrl$ + "      END SELECT" + CRLF$
   END IF
   TempCtrl$ = TempCtrl$ +  CRLF$
   TempCtrl$ = TempCtrl$ + "    CASE WM_COMMAND"  + CRLF$
   TempCtrl$ = TempCtrl$ + "      SELECT CASE CBCTL" + CRLF$

   'Add control Events
   TempCtrl$ = TempCtrl$ + AddOOPCtrlEvents$(vi->EEnums())
   'Add menu Events
   TempCtrl$ = TempCtrl$ + AddMenuEvents(MenuCode$) & CRLF$

   TempCtrl$ = TempCtrl$ + "      END SELECT" + CRLF$

   TempCtrl$ = TempCtrl$ + "    CASE WM_CLOSE"  + CRLF$
   TempCtrl$ = TempCtrl$ + "       PostQuitMessage(0)"  + CRLF$
   TempCtrl$ = TempCtrl$ + "    CASE WM_DESTROY"  + CRLF$
   TempCtrl$ = TempCtrl$ + "       PostQuitMessage(0) "  + CRLF$
   TempCtrl$ = TempCtrl$ + "  END SELECT"  + CRLF$
   TempCtrl$ = TempCtrl$ + "END EVENTS" + CRLF$ + CRLF$

   'TempCtrl$ = TempCtrl$ & MenuCode$

   TempCtrl$ = TempCtrl$ + LaterCode$
   SendMessage(*(vi->hEdit), WM_SETTEXT, 0, TempCtrl$)
   CALL vi->Savit()
   FUNCTION = 0
END FUNCTION


SUB Start_OOP_Form_Code(Formname AS STRING, rc AS RECT, TempCtrl$, LaterCode$)

      TempCtrl$ = TempCtrl$ + "SUB FORMLOAD()" + CRLF$
      TempCtrl$ = TempCtrl$ + "   CALL SetupForm1()" & CRLF$
      CALL the_Form_Code(Formname , rc, TempCtrl$, LaterCode$)

END SUB


SUB the_Form_Code(Formname AS STRING, rc AS RECT, TempCtrl$, LaterCode$)
      LaterCode$ = "Sub Setup" & formName & "()" + CRLF$
      LaterCode$ = LaterCode$ & "  GLOBAL " & Formname + " AS OOP_FORM" + CRLF$
      LaterCode$ = LaterCode$ & "  " & Formname$ & ".CtrlType$ = " + ENC$("form") + CRLF$
      LaterCode$ = LaterCode$ & "  " & Formname$ & ".ID = 100" + CRLF$
      LaterCode$ = LaterCode$ & "  InitFrm(&" & Formname$ & ")" + CRLF$
      'LaterCode$ = LaterCode$ & "  " & Formname$ & ".rc.left = " & STR$(rc.left)  + CRLF$
      'LaterCode$ = LaterCode$ & "  " & Formname$ & ".rc.top = " & STR$(rc.top) + CRLF$ ' 150
      'LaterCode$ = LaterCode$ & "  " & Formname$ & ".rc.right = " & STR$(rc.right-rc.left) + CRLF$
      'LaterCode$ = LaterCode$ & "  " & Formname$ & ".rc.bottom =  " & STR$(rc.bottom-rc.top) + CRLF$
      LaterCode$ = LaterCode$ + "  " + Formname$ + ".Style = 0" + CRLF$'WS_MINIMIZEBOX | WS_SIZEBOX | WS_CAPTION | WS_MAXIMIZEBOX | WS_POPUP | WS_SYSMENU" + CRLF$
      LaterCode$ = LaterCode$ + "  " + Formname$ + ".StyleEx = 0 " + CRLF$
      LaterCode$ = LaterCode$ + "  " + Formname$ + ".fontsize = 10" + CRLF$
      LaterCode$ = LaterCode$ + "  " & Formname$ + ".Font(&Form1, " & ENC$("Tahoma") & ")" + CRLF$
      LaterCode$ = LaterCode$ + "  " + Formname$ + ".CreateFrm(&" + Formname$ + ", "  & STR$(rc.left)  + ", " + _
      STR$(rc.top) + ", " + STR$(rc.right-rc.left) + ", " + STR$(rc.bottom-rc.top) + ")" + CRLF$ 'create form
      LaterCode$ = LaterCode$ + "  " + Formname$ + ".Text(&" + Formname$ + ", " + ENC$("Semi-OOP Form Type Demo" ) + ")" + CRLF$
      LaterCode$ = LaterCode$ + "END SUB" + CRLF$ + CRLF$
END SUB


FUNCTION Add_OOP_Control(TempCtrl$, LaterCode$, i AS INTEGER, _
         addtypecontrol AS INTEGER, ctype AS INTEGER, styleidx AS INTEGER, _
         vi AS VARINFO PTR) AS INTEGER

   DIM myTemp$ * 8192
   DIM RAW dwExStyle$
   DIM RAW lpClassName$
   DIM RAW lpWindowName$
   DIM RAW dwStyle$
   DIM RAW x$
   DIM RAW y$
   DIM RAW nWidth$
   DIM RAW nHeight$
   DIM RAW hMenu$
   DIM AUTO lpTemp$
   DIM RAW fontCode$
   DIM RAW rc_code$
   DIM RAW Caption$
     ' extended window style
      dwExStyle$ = vi->ControlDesc$[ctype] + LTRIM$(STR$(styleidx)) + "_ExtStyle"

      ' registered class name
      GetClassName(vi->holdctl[i].hWnd, lpClassName$, 2048)

      ' window name
      GetWindowText(vi->holdctl[i].hWnd, lpWindowName$, 2048)

      ' window style
      dwStyle$ = vi->ControlDesc$[ctype] + LTRIM$(STR$(styleidx)) + "_Style"

      ' horizontal position of window
      IF SaveModal THEN
        x$ = XScale$(vi->holdctl[i].rect.left)
      Else
        x$ = STR$(vi->holdctl[i].rect.left)
      END IF

      ' vertical position of window
      IF SaveModal THEN 
        y$ = YScale$(vi->holdctl[i].rect.top)
      Else
        y$ = STR$(vi->holdctl[i].rect.top)
      END IF

      ' window width
      IF SaveModal THEN 
        nWidth$ = XScale$((vi->holdctl[i].rect.right-(vi->holdctl[i].rect.left)))
      Else
        nWidth$ = STR$(vi->holdctl[i].rect.right-vi->holdctl[i].rect.left)
      END IF

      ' window height
      IF SaveModal THEN 
        nHeight$ = YScale$((vi->holdctl[i].rect.bottom-(vi->holdctl[i].rect.top)))
      Else
        nHeight$ = STR$(vi->holdctl[i].rect.bottom-vi->holdctl[i].rect.top)
      END IF

      hMenu$ = "ID_" + vi->ControlDesc$[ctype] + LTRIM$(STR$(styleidx))

      lpTemp$ = lpTemp$ + "   h" + vi->ControlDesc$[ctype] + LTRIM$(STR$(styleidx)) + " = " + vi->ControlTypes$[ctype]

      dwExStyle$ = vi->ControlDesc$[ctype] + LTRIM$(STR$(styleidx))
      myTemp$ = "Sub Setup" & dwExStyle$  + CRLF$
      myTemp$ = myTemp$ +  "  GLOBAL " + dwExStyle$ + " AS OOP_CONTROL" + CRLF$
      myTemp$ = myTemp$ +  "  DIM hFont AS HFONT" + CRLF$
      myTemp$ = myTemp$ +  "  " + dwExStyle$ + ".hParent = " & formName
      IF NOT SaveModal THEN
        myTemp$ = myTemp$ + ".hWnd"  + CRLF$
      ELSE
        myTemp$ = myTemp$  + CRLF$
      END IF
      myTemp$ = myTemp$ +  "  " & dwExStyle$ + ".ID = " + STR$(i + 100) + CRLF$
      myTemp$ = myTemp$ +  "  " + dwExStyle$ + ".CtrlType$ = " + ENC$(lpClassName$) + CRLF$
      myTemp$ = myTemp$ +  "  " + "InitCtrl(&" + dwExStyle$ + ")" + CRLF$
      IF lpClassName$ = "ComboBox" THEN REPLACE  "InitCtrl" WITH "InitCombo" IN myTemp$
      IF lpClassName$ = "ListBox" THEN REPLACE  "InitCtrl" WITH "InitListbox" IN myTemp$
      IF lpClassName$ = "SysListView32" THEN REPLACE  "InitCtrl" WITH "InitListView" IN myTemp$
      IF lpClassName$ = "SysTreeView32" THEN REPLACE  "InitCtrl" WITH "InitTreeView" IN myTemp$
      IF lpClassName$ = "msctls_progress32" THEN REPLACE  "InitCtrl" WITH "InitProgressBar" IN myTemp$
      IF lpClassName$ = "msctls_updown32" THEN REPLACE  "InitCtrl" WITH "InitUpDown" IN myTemp$
      IF lpClassName$ = "msctls_trackbar32" THEN REPLACE  "InitCtrl" WITH "InitSlider" IN myTemp$
      IF lpClassName$ = "RAGrid" THEN REPLACE  "InitCtrl" WITH "InitBCX_raGrid" IN myTemp$

      rc_code$ = ", " + x$ + ", " + y$ + ", " + nWidth$ + ", " + nHeight$
      Caption$ =  "  " + dwExStyle$ + ".Text(&" + dwExStyle$ + ", " + ENC$(lpWindowName$) + ")" + CRLF$
      IF vi->holdctl[i].backcolor THEN
         myTemp$ = myTemp$ + "  " + dwExStyle$ + ".BackgroundRGBColor = " + STR$(vi->holdctl[i].backcolor) + CRLF$
      END IF
      IF vi->holdctl[i].forecolor THEN
         myTemp$ = myTemp$ + "  " + dwExStyle$ + ".ForegroundRGBColor = " +  STR$(vi->holdctl[i].forecolor) + CRLF$
      END IF

      'Add font
      fontCode$ = ""
      IF LEN(vi->holdctl[i].font.Font_name$) THEN
         fontCode$ = AddFontCode$ ( vi->ControlDesc$[ctype] + _
         LTRIM$(STR$(styleidx)) + ".hWnd",vi->holdctl[i]) _
         & CRLF$
      END IF

      DIM tempstyles$
      tempstyles$ =vi->GetStyleConst(vi->holdctl[i].hWnd, 1, 0, FALSE)
      'GetStyleConst
      IF LEN(tempstyles$) = 0 THEN
      tempstyles$ = "0"
      ELSEIF ControlDescID$[ctype] = "Upd" THEN
       tempstyles$ = tempstyles$ + " | UDS_WRAP OR UDS_ARROWKEYS | UDS_ALIGNRIGHT | UDS_SETBUDDYINT"
      END IF
      myTemp$ = myTemp$ +  "  " + dwExStyle$ + ".Style = " & tempstyles$ + CRLF$
      tempstyles$ = vi->GetStyleConst(vi->holdctl[i].hWnd, 0, 1, FALSE)
      IF LEN(tempstyles$) = 0 THEN tempstyles$ = "0"
      myTemp$ = myTemp$ +  "  " + dwExStyle$ + ".StyleEx = " + tempstyles$ + CRLF$

      SELECT CASE TRIM$(UCASE$(lpClassName$)) 'ControlDescID$[ctype]
      CASE "BUTTON", "STATIC", "EDIT", "CHECK", "RADIO"
         addtypecontrol= addtypecontrol BOR 2
         IF lpClassName$ = "Check" THEN REPLACE "Button" WITH "Check" IN myTemp$
         IF lpClassName$ = "Radio" THEN REPLACE "Button" WITH "Radio" IN myTemp$
         LaterCode$ = LaterCode$ + myTemp$ +  "  " + dwExStyle$ + ".CreateCtrl(&" + dwExStyle$& rc_code$  + ")" + CRLF$
         LaterCode$ = LaterCode$ + Caption$
         LaterCode$ = LaterCode$ + fontCode$ + "END SUB" + CRLF$ + CRLF$
         TempCtrl$ = TempCtrl$ + "   CALL Setup" + dwExStyle$ & "()" + CRLF$
      Case "LISTBOX", "COMBOBOX"
         IF lpClassName$ = "ComboBox" THEN
            addtypecontrol= addtypecontrol BOR 4
            REPLACE "OOP_CONTROL" WITH "OOP_COMBO" IN myTemp$
         ELSE
            addtypecontrol= addtypecontrol BOR 8
            REPLACE "OOP_CONTROL" WITH "OOP_LISTBOX"  IN myTemp$
         END IF
         LaterCode$ = LaterCode$ + myTemp$ +  "  " + dwExStyle$ + ".CreateCtrl(&" + dwExStyle$ + rc_code$ + ")" + CRLF$
         LaterCode$ = LaterCode$ & Caption$
         LaterCode$ = LaterCode$ & fontCode$ & "END SUB" & CRLF$ & CRLF$
         TempCtrl$ = TempCtrl$ + "   CALL Setup" & dwExStyle$ & "()" + CRLF$
      Case "SYSLISTVIEW32"
         addtypecontrol= addtypecontrol BOR 16
         REPLACE "OOP_CONTROL" WITH "OOP_LISTVIEW" IN myTemp$
         LaterCode$ = LaterCode$ + myTemp$ +  "  " + dwExStyle$ + ".CreateCtrl(&" + dwExStyle$ + rc_code$ + ")" + CRLF$
         LaterCode$ = LaterCode$ + Caption$
         LaterCode$ = LaterCode$ + fontCode$ + "END SUB" + CRLF$ + CRLF$
         TempCtrl$ = TempCtrl$ + "   CALL Setup" + dwExStyle$ & "()" + CRLF$
      Case "SYSTREEVIEW32"
         addtypecontrol= addtypecontrol BOR 32
         REPLACE "OOP_CONTROL" WITH "OOP_TREEVIEW" IN myTemp$
         LaterCode$ = LaterCode$ + myTemp$ +  "  " + dwExStyle$ + ".CreateCtrl(&" + dwExStyle$ + rc_code$ + ")" + CRLF$
         LaterCode$ = LaterCode$ + Caption$
         LaterCode$ = LaterCode$ + fontCode$ & "END SUB" + CRLF$ + CRLF$
         TempCtrl$ = TempCtrl$ + "   CALL Setup" + dwExStyle$ + "()" + CRLF$
      Case "MSCTLS_PROGRESS32"
         addtypecontrol= addtypecontrol BOR 64
         REPLACE "OOP_CONTROL" WITH "OOP_PROGRESS" IN myTemp$
         LaterCode$ = LaterCode$ + myTemp$ +  "  " + dwExStyle$ + ".CreateCtrl(&" + dwExStyle$ + rc_code$ + ")" + CRLF$
         LaterCode$ = LaterCode$ + Caption$
         LaterCode$ = LaterCode$ + fontCode$ + "END SUB" + CRLF$ + CRLF$
         TempCtrl$ = TempCtrl$ + "   CALL Setup" + dwExStyle$ + "()" + CRLF$
      Case "MSCTLS_UPDOWN32"
         addtypecontrol= addtypecontrol BOR 128
         REPLACE "OOP_CONTROL" WITH "OOP_UPDOWN" IN myTemp$
         LaterCode$ = LaterCode$ & myTemp$ &  "  " & dwExStyle$ & ".CreateCtrl(&" & dwExStyle$ & rc_code$ & ")"& CRLF$
         LaterCode$ = LaterCode$ & Caption$
         LaterCode$ = LaterCode$ & fontCode$ & "END SUB" & CRLF$ & CRLF$
         TempCtrl$ = TempCtrl$ + "   CALL Setup" & dwExStyle$ & "()" + CRLF$
      Case "MSCTLS_TRACKBAR32"
         addtypecontrol= addtypecontrol BOR 256
         REPLACE "OOP_CONTROL" WITH "OOP_SLIDER" IN myTemp$
         LaterCode$ = LaterCode$ & myTemp$ &  "  " & dwExStyle$ & ".CreateCtrl(&" & dwExStyle$ & rc_code$ & ")"& CRLF$
         LaterCode$ = LaterCode$ & Caption$
         LaterCode$ = LaterCode$ & fontCode$ & "END SUB" & CRLF$ & CRLF$
         TempCtrl$ = TempCtrl$ + "   CALL Setup" & dwExStyle$ & "()" + CRLF$
      Case "RAGRID"
         addtypecontrol= addtypecontrol BOR 512
         REPLACE "OOP_CONTROL" WITH "OOP_RAGRID" IN myTemp$
         LaterCode$ = LaterCode$ & myTemp$ &  "  " & dwExStyle$ & ".CreateCtrl(&" & dwExStyle$ & rc_code$ & ")"& CRLF$
         LaterCode$ = LaterCode$ & Caption$
         LaterCode$ = LaterCode$ & fontCode$ & "END SUB" & CRLF$ & CRLF$
         TempCtrl$ = TempCtrl$ + "   CALL Setup" & dwExStyle$ & "()" + CRLF$
      CASE ELSE
        TempCtrl$ = TempCtrl$ & CRLF$ & "DIM h" & dwExStyle$ & " AS HWND" & CRLF$
        TempCtrl$ = TempCtrl$ & "CONST " & hMenu$ & "  = " & STR$(100+i) & CRLF$
        TempCtrl$ = TempCtrl$ & "DIM " & dwStyle$ & CRLF$
        TempCtrl$ = TempCtrl$ & ControlDescID$[ctype] + LTRIM$(STR$(styleidx)) + "_Style = "
        TempCtrl$ = TempCtrl$ & vi->GetStyleConst(vi->holdctl[i].hWnd, 1, 0, FALSE)  & CRLF$

        TempCtrl$ = TempCtrl$ & "DIM " & ControlDescID$[ctype] + LTRIM$(STR$(styleidx)) + "_ExtStyle" & CRLF$
        TempCtrl$ = TempCtrl$ & ControlDescID$[ctype] + LTRIM$(STR$(styleidx)) + "_ExtStyle = "
        TempCtrl$ = TempCtrl$ & vi->GetStyleConst(vi->holdctl[i].hWnd, 0, 1, FALSE)  & CRLF$  & CRLF$
        lpTemp$ = "   h" + ControlDescID$[ctype] + LTRIM$(STR$(styleidx)) + " = " + lpClassName$'ControlType$[ctype]
        lpTemp$ = REPLACE$(lpTemp$, "%HWND%", "Form1.hWnd")
        lpTemp$ = REPLACE$(lpTemp$, "%ID%", hMenu$)
        lpTemp$ = REPLACE$(lpTemp$, "%EXTSTY%", ControlDescID$[ctype] + LTRIM$(STR$(styleidx)) + "_ExtStyle")
        lpTemp$ = REPLACE$(lpTemp$, "%CLASS%", ENC$(lpClassName$))
        lpTemp$ = REPLACE$(lpTemp$, "%CAP%",   ENC$(lpWindowName$))
        lpTemp$ = REPLACE$(lpTemp$, "%STY%", dwStyle$)
        lpTemp$ = REPLACE$(lpTemp$, "%X%", x$)
        lpTemp$ = REPLACE$(lpTemp$, "%Y%", y$)
        lpTemp$ = REPLACE$(lpTemp$, "%W%", nWidth$)
        lpTemp$ = REPLACE$(lpTemp$, "%H%", nHeight$)
        TempCtrl$ = TempCtrl$ + lpTemp$ + CRLF$
      END SELECT

     FUNCTION = addtypecontrol
END FUNCTION


SUB Add_OOP_End_Code(TempCtrl$, LaterCode$, addtypecontrol) 'AS STRING
   DIM BCX_Inc_Path$
   LaterCode$ = LaterCode$ & "'Rem these includes out IF they have already been added elsewhere" & CRLF$ 
   LaterCode$ = LaterCode$ & "'or add them IF needed" & CRLF$ & CRLF$
   BCX_Inc_Path$ = ENVIRON$("BCXLIB") 'BCXPATH$ & "INCLUDES\"
     IF ! EXIST(BCX_Inc_Path$) THEN
         LaterCode$ = LaterCode$ & "'BCX\Bin\INCLUDES  FOLDER NOT FOUND"
     END IF
     IF (addtypecontrol BAND 4) THEN
       IF EXIST(BCX_Inc_Path$ & "OOP_COMBO.INC") THEN
          LaterCode$ = LaterCode$ & "$INCLUDE <OOP_COMBO.INC>" & CRLF$
       ELSE
          LaterCode$ = LaterCode$ & "$INCLUDE " & ENC$("OOP_COMBO.INC") & CRLF$       
       END IF
     END IF
     IF (addtypecontrol BAND 8) THEN
       IF EXIST(BCX_Inc_Path$ & "OOP_LISTBOX.INC") THEN
          LaterCode$ = LaterCode$ & "$INCLUDE <OOP_LISTBOX.INC>" & CRLF$
       ELSE
          LaterCode$ = LaterCode$ & "$INCLUDE " & ENC$("OOP_LISTBOX.INC") & CRLF$
       END IF 
     END IF
     IF (addtypecontrol BAND 16) THEN
       IF EXIST(BCX_Inc_Path$ & "OOP_LISTVIEW.INC") THEN
          LaterCode$ = LaterCode$ & "$INCLUDE <OOP_LISTVIEW.INC>" & CRLF$
       ELSE
          LaterCode$ = LaterCode$ & "$INCLUDE " & ENC$("OOP_LISTVIEW.INC") & CRLF$
       END IF
     END IF         
     IF (addtypecontrol BAND 32) THEN
       IF EXIST(BCX_Inc_Path$ & "OOP_TREEVIEW.INC") THEN
          LaterCode$ = LaterCode$ & "$INCLUDE " & ENC$(BCX_Inc_Path$ & "OOP_TREEVIEW.INC") & CRLF$
       ELSE
          LaterCode$ = LaterCode$ & "$INCLUDE " & ENC$("OOP_TREEVIEW.INC") & CRLF$       
       END IF
     END IF         
     IF (addtypecontrol BAND 64) THEN
       IF EXIST(BCX_Inc_Path$ & "OOP_PROGRESS.INC") THEN
          LaterCode$ = LaterCode$ & "$INCLUDE <OOP_PROGRESS.INC>" & CRLF$
       ELSE
          LaterCode$ = LaterCode$ & "$INCLUDE " & ENC$("OOP_PROGRESS.INC") & CRLF$
       END IF
     END IF
     IF (addtypecontrol BAND 128) THEN
       IF EXIST(BCX_Inc_Path$ & "OOP_UPDOWN.INC") THEN
          LaterCode$ = LaterCode$ & "$INCLUDE <OOP_UPDOWN.INC>" & CRLF$
       ELSE
          LaterCode$ = LaterCode$ & "$INCLUDE " & ENC$("OOP_UPDOWN.INC") & CRLF$
       END IF
     END IF
     IF (addtypecontrol BAND 256) THEN
       IF EXIST(BCX_Inc_Path$ & "OOP_SLIDER.INC") THEN
          LaterCode$ = LaterCode$ & "$INCLUDE <OOP_SLIDER.INC>" & CRLF$
       ELSE
          LaterCode$ = LaterCode$ & "$INCLUDE " & ENC$("OOP_SLIDER.INC") & CRLF$
       END IF
     END IF
     IF (addtypecontrol BAND 512) THEN
       IF EXIST(BCX_Inc_Path$ & "OOP_RA_GRID.INC") THEN
          LaterCode$ = LaterCode$ & "$INCLUDE <OOP_RA_GRID.INC>" & CRLF$
       ELSE
          LaterCode$ = LaterCode$ & "$INCLUDE " & ENC$("OOP_RA_GRID.INC") & CRLF$
       END IF
     END IF
     IF EXIST(BCX_Inc_Path$ & "OOP_FORM.INC") THEN
        LaterCode$ = LaterCode$ & "$INCLUDE <OOP_FORM.INC>" & CRLF$
     ELSE
        LaterCode$ = LaterCode$ & "$INCLUDE " & ENC$("OOP_FORM.INC") & CRLF$       
     END IF
     IF EXIST(BCX_Inc_Path$ & "OOP_COMMON_CTRLS.INC") THEN
        LaterCode$ = LaterCode$ & "$INCLUDE <OOP_COMMON_CTRLS.INC>" & CRLF$
     ELSE
        LaterCode$ = LaterCode$ & "$INCLUDE " & ENC$("OOP_COMMON_CTRLS.INC") & CRLF$       
     END IF
     IF EXIST(BCX_Inc_Path$ & "OOPCommonFunctions.INC") THEN
        LaterCode$ = LaterCode$ & "$INCLUDE <OOPCommonFunctions.INC>" & CRLF$
     ELSE
        LaterCode$ = LaterCode$ & "$INCLUDE " & ENC$("OOPCommonFunctions.INC") & CRLF$       
     END IF
     TempCtrl$ = "CONST EXTENDS(x) = struct _##x" & CRLF$ & CRLF$ & TempCtrl$
     IF NOT SaveModal THEN
       TempCtrl$ = TempCtrl$ + "   Form1.CentShow(&Form1) " + CRLF$
     ELSE  
       REPLACE "$INCLUDE" WITH "'$INCLUDE" IN LaterCode$
     END IF
END SUB 


SET ControlDescID[] AS PCHAR
   "Edt",
   "Grp",
   "Btn",
   "Chk",
   "Rad",
   "Cmb",
   "Lst",
   "Hsl",
   "Vsl",
   "Frm",
   "Pic",
   "Stc",
   "Ani",
   "Rih",
   "Prg",
   "Upd",
   "Lvw",
   "Trv",
   "Trk",
   "Bmp",
   "Dat",
   "Cal",
   "Ipa",
   "Usr",
   "Ico",
   "Grd",
   "Inp"
END SET


FUNCTION AddCtrlEvents$(enumcode$)
  DIM RAW ctrltxt$, lines, idx
  DIM strNew$, LINE$
  ctrltxt$ = enumcode$
  lines = ParseCount(ctrltxt$, CRLF$)
  FOR idx = 1 TO lines
     LINE$ = Parse(ctrltxt$,CRLF$, idx)
     IF LEN(TRIM$(LINE$)) = 0 THEN ITERATE
     IF NOT Instr(UCASE$(LINE$),"ENUM") THEN'
         strNew$ = strNew$ & "          " & "CASE " & TRIM$(LINE$) & CRLF$
     END IF
  NEXT i
  FUNCTION = strNew$
END FUNCTION


FUNCTION AddOOPCtrlEvents$(enumcode$)
  DIM RAW ctrltxt$, lines, idx
  DIM strNew$, LINE$
  ctrltxt$ = enumcode$
  lines = ParseCount(ctrltxt$, CRLF$)
  FOR idx = 1 TO lines
     LINE$ = Parse(ctrltxt$,CRLF$, idx)
     IF LEN(TRIM$(LINE$)) = 0 THEN ITERATE
     IF NOT Instr(UCASE$(LINE$),"ENUM") THEN
       IF Instr(UCASE$(LINE$),"ID_")  THEN
         strNew$ = strNew$ & "          " & "CASE " & REMOVE$(TRIM$(LINE$),"ID_" ) & ".ID" & CRLF$
       END IF
     END IF
  NEXT i
  FUNCTION = strNew$
END FUNCTION


FUNCTION AddCtrlColorEvents$ OPTIONAL(vi AS VARINFO PTR, UseOOP = 0)
  DIM strNew$, i
  DIM AUTO Styleidx[MaxToolTypes], ctype
  DIM myStyle
  DIM nameS$
  strNew$ = "" '& CRLF$
  FOR i = 1 TO *(vi->controlindex)
      ctype = vi->holdctl[i].ctype - 1
      INCR Styleidx[ctype]
      myStyle = Styleidx[ctype]

      IF vi->holdctl[i].UseColor THEN
         nameS$ =  vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle))
         IF UseOOP  = 0 THEN
            strNew$ = strNew$ & "        " & "CASE  h" & nameS$ & CRLF$
            strNew$ = strNew$ & "           " & "FUNCTION = BCX_SETCOLOR(" & nameS$ & "_FC, " & nameS$ & "_BC)"  & CRLF$
         ELSE
            strNew$ = strNew$ & "        " & "CASE " & nameS$ & ".hWnd" & CRLF$
            strNew$ = strNew$ & "           " & "FUNCTION = BCX_SETCOLOR(" & nameS$ & _
                 ".ForegroundRGBColor," & nameS$ & ".BackgroundRGBColor)" & CRLF$
         END IF
      END IF
  NEXT i
  FUNCTION = strNew$
END FUNCTION


FUNCTION AddCtrlColorGlobals$ (vi AS VARINFO PTR)
  DIM strNew$, i
  DIM AUTO Styleidx[MaxToolTypes], ctype
  DIM myStyle
  FOR i = 1 TO *(vi->controlindex)
      ctype = vi->holdctl[i].ctype - 1
      INCR Styleidx[ctype]
      myStyle = Styleidx[ctype]
      IF vi->holdctl[i].UseColor THEN
          strNew$ = strNew$ & "GLOBAL " & vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle)) & "_FC   "  & CRLF$
          strNew$ = strNew$ & "GLOBAL " & vi->ControlDesc$[ctype] + LTRIM$(STR$(myStyle)) & "_BC   "  & CRLF$
      END IF
  NEXT i
  FUNCTION = strNew$ & CRLF$
END FUNCTION


FUNCTION AddFontCode$(lpWindowName$,  tCtrl AS CONTROLS)
   DIM fontcode$
   DIM ctrlName$
   fontcode$ = "BCX_SET_FONT(" & lpWindowName$ & "," &  ENC$(TRIM$(tCtrl.font.Font_name$)) & "," & STR$(tCtrl.font.Font_size) & ","
   fontcode$ = fontcode$ & STR$(tCtrl.font.Font_weight) & "," & STR$(tCtrl.font.Font_italic) & ","
   fontcode$ = fontcode$ & STR$(tCtrl.font.Font_underline) & "," & STR$(tCtrl.font.Font_strikethrough) & ")"
   FUNCTION = fontcode$
END FUNCTION


FUNCTION Save_Blank_GridSetup$( hGrid$)' AS HWND )
   DIM grdText$
   grdText$ = "SUB GridSetup"+ hGrid$ + "( hGrid AS HWND )"  & CRLF$
   grdText$ = grdText$ + "  DIM AUTO col AS COLUMN"  & CRLF$
   grdText$ = grdText$ + "  col.colwt       = 100"  & CRLF$
   grdText$ = grdText$ + "  col.lpszhdrtext = " & ENC$("EditText")  & CRLF$
   grdText$ = grdText$ + "  col.halign      = GA_ALIGN_CENTER"  & CRLF$
   grdText$ = grdText$ + "  col.calign      = GA_ALIGN_LEFT"  & CRLF$
   grdText$ = grdText$ + "  col.ctype       = TYPE_EDITTEXT"  & CRLF$
   grdText$ = grdText$ + "  col.ctextmax    = 0"  & CRLF$
   grdText$ = grdText$ + "  col.lpszformat  = 0"  & CRLF$
   grdText$ = grdText$ + "  col.himl        = 0"  & CRLF$
   grdText$ = grdText$ + "  col.hdrflag     = 0"  & CRLF$
   grdText$ = grdText$ + "  col.hdrmenu     = 0"  & CRLF$
   grdText$ = grdText$ + "  col.cellmenu    = 0"  & CRLF$
   grdText$ = grdText$ + "  col.lParam      = ES_MULTILINE BOR ES_AUTOVSCROLL"  & CRLF$
   grdText$ = grdText$ + "  SendMessage(hGrid, GM_ADDCOL, 0, &col)"  & CRLF$
   grdText$ = grdText$ + "END SUB"  & CRLF$   & CRLF$
   FUNCTION = grdText$
END FUNCTION
