
FUNCTION HotKeyString(value, flagBlank) AS STRING
   'This translation is only valid for a US keyboard for a PC
   'This translates what the HotKey control will display for the
   'hot key value, no validation is done to determine if the value is valid
   '
   'The flagBlank when <>0 will return a null string for values that do not
   'translate into a key press combination that only has Modifier Keys,
   '	i.e Ctrl and/or Shift and/or Alt keys.
   'Set the lParam value for the TYPE_HOTKEY column to non zero.
   '
   'Tested with comctl32.dll version 5.82.2900.2982  Your results may vary!

   DIM RAW A$ * 128
   DIM RAW keycode
   DIM RAW keymodifier
   DIM RAW bExtkey AS BOOL

   keymodifier = HIBYTE(value)	'Key modifier Shift Ctl Alt Keys
   keycode 	= LOBYTE(value)	'Virtual Key Code

   IF (value = 0) OR (value = 0x800) THEN			'Handle Null values
      A$ = "None"
   ELSE

      'test value,HOTKEYF_CONTROL
      IF keymodifier BAND HOTKEYF_CONTROL THEN
         A$ = "Ctrl + "
      END IF

      'test value,HOTKEYF_SHIFT
      IF keymodifier BAND HOTKEYF_SHIFT THEN
         A$ = A$ + "Shift + "
      END IF

      'test value,HOTKEYF_ALT
      IF keymodifier BAND HOTKEYF_ALT THEN
         A$ = A$ + "Alt + "
      END IF

      bExtkey = keymodifier BAND HOTKEYF_EXT	'Flag if Extended Key Code


      SELECT CASE keycode
         'CASE 0 : A$ = "None"

         CASE ASC("A") TO ASC("Z")	:A$ = A$ + CHR$(keycode)			'Letters A thru Z

         CASE ASC("0") TO ASC("9")	:A$ = A$ + CHR$(keycode)			'Numbers 0 thru 9

         CASE VK_F1 TO VK_F12									'Function Keys F1 thru F12
         IF NOT bExtkey THEN
            A$ = A$ + "F" + TRIM$(STR$(keycode - VK_F1 + 1))
         END IF

         CASE VK_NUMPAD0 TO VK_NUMPAD9							'Number Pad 0 thru 9
         IF NOT bExtkey THEN
            A$ = A$ + "Num " + STR$(keycode - VK_NUMPAD0)
         ELSE
            SELECT CASE (keycode - VK_NUMPAD0)
               CASE 0 : A$ = A$ + "Insert"
               CASE 1 : A$ = A$ + "End"
               CASE 2 : A$ = A$ + "Down"
               CASE 3 : A$ = A$ + "Page Down"
               CASE 4 : A$ = A$ + "Left"
               ''CASE 5 : A$ = A$ + ""
               CASE 6 : A$ = A$ + "Right"
               CASE 7 : A$ = A$ + "Home"
               CASE 8 : A$ = A$ + "Up"
               CASE 9 : A$ = A$ + "Page Up"
            END SELECT
         ENDIF

         CASE VK_CANCEL, VK_SCROLL						'Pause/Break Key 	'0x03 or  '0x91
         IF bExtkey THEN
            A$ = A$ + "Break"
         ELSE
            A$ = A$ + "Scroll Lock"
         ENDIF


         CASE VK_BACK									'0x08
         IF bExtkey THEN
            A$ = A$ + CHR$(8)
         ELSE
            A$ = A$ + "Backspace"
         ENDIF

         CASE VK_TAB										'0x09
         IF bExtkey THEN
            A$ = A$ + CHR$(8)
         ELSE
            A$ = A$ + "Tab"
         ENDIF

         CASE VK_CLEAR									'0x0C
         IF NOT bExtkey THEN A$ = A$ + "Num 5"

         CASE VK_RETURN									'0x0D
         IF bExtkey THEN
            A$ = A$ + "Num Enter"
         ELSE
            A$ = A$ + "Enter"
         END IF

         CASE VK_SHIFT									'0x10
         IF NOT bExtkey THEN A$ = A$ + "Shift"

         CASE VK_CONTROL									'0x11
         IF bExtkey THEN
            A$ = A$ + "Right Ctrl"
         ELSE
            A$ = A$ + "Ctrl"
         END IF

         CASE VK_MENU									'0x12
         IF bExtkey THEN
            A$ = A$ + "Right Alt"
         ELSE
            A$ = A$ + "Alt"
         END IF

         CASE VK_CAPITAL									'0x14
         IF NOT bExtkey THEN A$ = A$ + "Caps Lock"

         CASE VK_ESCAPE									'0x1B
         IF bExtkey THEN
            A$ = A$ + CHR$(0x1B)
         ELSE
            A$ = A$ + "Esc"
         ENDIF

         CASE VK_SPACE									'0x20
         IF NOT bExtkey THEN A$ = A$ + "Space"

         CASE VK_PRIOR
         IF bExtkey THEN
            A$ = A$ + "Page Up"
         ELSE
            A$ = A$ + "Num 9"
         END IF

         CASE VK_NEXT
         IF bExtkey THEN
            A$ = A$ + "Page Down"
         ELSE
            A$ = A$ + "Num 3"
         END IF

         CASE VK_END
         IF bExtkey THEN
            A$ = A$ + "End"
         ELSE
            A$ = A$ + "Num 1"
         END IF

         CASE VK_HOME
         IF bExtkey THEN
            A$ = A$ + "Home"
         ELSE
            A$ = A$ + "Num 7"
         END IF

         CASE VK_LEFT
         IF bExtkey THEN
            A$ = A$ + "Left"
         ELSE
            A$ = A$ + "Num 4"
         END IF

         CASE VK_UP
         IF bExtkey THEN
            A$ = A$ + "Up"
         ELSE
            A$ = A$ + "Num 8"
         END IF

         CASE VK_RIGHT
         IF bExtkey THEN
            A$ = A$ + "Right"
         ELSE
            A$ = A$ + "Num 6"
         END IF

         CASE VK_DOWN					'0x28
         IF bExtkey THEN
            A$ = A$ + "Down"
         ELSE
            A$ = A$ + "Num 2"
         END IF

         CASE VK_SNAPSHOT				'0x2C
         IF bExtkey THEN
            A$ = A$ + "<00>"
         ELSE
            A$ = A$ + "Sys Req"
         END IF

         CASE VK_INSERT
         IF bExtkey THEN
            A$ = A$ + "Insert"
         ELSE
            A$ = A$ + "Num 0"
         END IF

         CASE VK_DELETE					'0x2E
         IF bExtkey THEN
            A$ = A$ + "Delete"
         ELSE
            A$ = A$ + "Num Del"
         END IF

         CASE VK_LWIN, VK_OEM_FINISH						'0x5B 0xF1
         IF bExtkey THEN A$ = A$ + "Left Windows"

         CASE VK_RWIN										'0x5C
         IF bExtkey THEN A$ = A$ + "Right Windows"

         CASE VK_APPS, VK_EREOF							'0x5D 0xF9
         IF bExtkey THEN A$ = A$ + "Application"

         CASE VK_MULTIPLY								'0x6A
         IF bExtkey THEN
            A$ = A$ + "Prnt Scrn"
         ELSE
            A$ = A$ + "Num *"
         END IF

         CASE VK_ADD
         IF bExtkey THEN
            A$ = A$ + "+"
         ELSE
            A$ = A$ + "Num +"
         END IF

         ''CASE VK_SEPARATOR	: A$ = A$ + "Num -"

         CASE VK_SUBTRACT
         IF bExtkey THEN
            A$ = A$ + "-"
         ELSE
            A$ = A$ + "Num -"
         END IF

         CASE VK_DECIMAL
         IF bExtkey THEN
            A$ = A$ + "Delete"
         ELSE
            A$ = A$ + "Num Del"
         END IF

         CASE VK_DIVIDE, VK_OEM_2		'0x6F 0xBF
         IF bExtkey THEN
            A$ = A$ + "Num /"
         ELSE
            A$ = A$ + "/"
         END IF

         CASE VK_NUMLOCK					'0x90
         IF bExtkey THEN
            A$ = A$ + "Num Lock"
         ELSE
            A$ = A$ + "Pause"
         END IF

         CASE VK_LSHIFT								'0xA0
         IF NOT bExtkey THEN A$ = A$ + "Shift"

         CASE VK_RSHIFT
         IF NOT bExtkey THEN A$ = A$ + "Right Shift"

         CASE VK_LCONTROL, VK_RCONTROL				'0xA2 0xA3
         IF bExtkey THEN
            A$ = A$ + "Right Ctrl"
         ELSE
            A$ = A$ + "Ctrl"
         END IF

         CASE VK_LMENU, VK_RMENU						'0xA4 0xA5
         IF bExtkey THEN
            A$ = A$ + "Right Alt"
         ELSE
            A$ = A$ + "Alt"
         END IF

         CASE VK_BROWSER_HOME		: A$ = A$ + "M"
         CASE VK_VOLUME_MUTE			: A$ = A$ + "D"
         CASE VK_VOLUME_DOWN			: A$ = A$ + "C"
         CASE VK_VOLUME_UP 			: A$ = A$ + "B"				'0xAF
         CASE VK_MEDIA_NEXT_TRACK 	: A$ = A$ + "P"
         CASE VK_MEDIA_PREV_TRACK 	: A$ = A$ + "Q"
         CASE VK_MEDIA_STOP 		 	: A$ = A$ + "J"
         CASE VK_MEDIA_PLAY_PAUSE 	: A$ = A$ + "G"
         CASE VK_LAUNCH_APP2	 		: A$ = A$ + "F"

         CASE 0xC2
         IF NOT bExtkey THEN A$ = A$ + "F15"

         ''CASE VK_SELECT	: A$ = A$ + "SELECT"
         ''CASE VK_PRINT	: A$ = A$ + "PRINT"
         ''CASE VK_EXECUTE	: A$ = A$ + "EXEC"
         ''CASE VK_HELP	: A$ = A$ + "HELP"

         CASE VK_OEM_1		: A$ = A$ + ";"				'0xBA
         CASE VK_OEM_PLUS	: A$ = A$ + "="
         CASE VK_OEM_COMMA	: A$ = A$ + ","
         CASE VK_OEM_MINUS	: A$ = A$ + "-"
         CASE VK_OEM_PERIOD	: A$ = A$ + "."


         CASE VK_OEM_3		: A$ = A$ + "`"
         CASE VK_OEM_4		: A$ = A$ + "["
         CASE VK_OEM_6		: A$ = A$ + "]"
         CASE VK_OEM_5		: A$ = A$ + "\"
         CASE VK_OEM_7		: A$ = A$ + "'"

         CASE VK_OEM_102						'0xE2
         IF bExtkey THEN
            A$ = A$ + "Help"
         ELSE
            A$ = A$ + "\"
         ENDIF

         CASE ELSE
         IF flagBlank <> 0 THEN
            A$ = NUL$
         END IF
      END SELECT
   END IF
   FUNCTION = A$
   '******************************************************************
   '  NOTES
   '******************************************************************
   ' VK_ESCAPE, VK_SPACE, and VK_TAB are invalid hot keys
   '
   ' Need to compile with WIN32_WINNT >= 0x0500
   '  otherwise will have to define these somewhere in the program
   '#define VK_BROWSER_HOME  0xAC
   '#define VK_VOLUME_MUTE  0xAD
   '#define VK_VOLUME_DOWN  0xAE
   '#define VK_VOLUME_UP  0xAF
   '#define VK_MEDIA_NEXT_TRACK  0xB0
   '#define VK_MEDIA_PREV_TRACK  0xB1
   '#define VK_MEDIA_STOP  0xB2
   '#define VK_MEDIA_PLAY_PAUSE  0xB3
   '#define VK_LAUNCH_APP2  0xB7
   '#define VK_EREOF  0xF9
   '

END FUNCTION
