
CONST RAGRID_MAXROWS = (1024 * 1024)
CONST MEM_SIZE       = (128 * 1024)
CONST SYSTICK_2_DAYS = ((ULONGLONG)(24*60*60) * (1000*1000*10))

'-----------------------------------------------------------------------------
' Scheme for 256 columns x 16,777,216 rows
'-----------------------------------------------------------------------------
'CONST MAKECOLROW(COL, ROW) = ((DWORD)((ROW << 8) & 0xFFFFFF00) | (COL & 0xFF))
'CONST GETROW(ROW)          = ((ROW >> 8) & 0xFFFFFF)
'CONST GETCOL(COL)          = (COL & 0xFF)
'-----------------------------------------------------------------------------
' Scheme for 4,096 columns x 1,048,576 rows
'-----------------------------------------------------------------------------
CONST MAKECOLROW(COL, ROW) = ((DWORD)((ROW << 12) & 0xFFFFF000) | (COL & 0xFFF))
CONST GETROW(ROW)          = ((ROW >> 12) & 0xFFFFF)
CONST GETCOL(COL)          = (COL & 0xFFF)
'-----------------------------------------------------------------------------
' Scheme for 65,536 columns x 65,536 rows
'-----------------------------------------------------------------------------
'CONST MAKECOLROW = MAKELONG
'CONST GETROW     = HIWORD
'CONST GETCOL     = LOWORD

CONST DLGC_CODE = DLGC_WANTCHARS|DLGC_WANTALLKEYS

'color structure
TYPE ROWCOLOR
   backcolor AS COLORREF
   textcolor AS COLORREF
END TYPE

'color structure
TYPE COLUMNCOLOR
   backcolor AS COLORREF
   textcolor AS COLORREF
END TYPE


' Grid structure
TYPE GRID
   col                      ' Current column.
   row                      ' Current row.
   cols                     ' Number of columns.
   rows                     ' Number of rows.
   hdrht                    ' Header height.
   rowht                    ' Row height.
   ccx                      ' Sum of column widths.
   sbx                      ' Horizontal scroll position.
   hpar      AS HWND        ' Handle of parent.
   hgrd      AS HWND        ' Handle of grid.
   nid                      ' ID of grid.
   hhdr      AS HWND        ' Handle of header.
   hlst      AS HWND        ' Handle of grid listbox.
   hsize     AS HWND        ' Handle of sizing bar.
   hfont     AS HFONT       ' Handle of font
   style     AS DWORD       ' Grid style.
   hcur      AS HCURSOR     ' Handle of resize cursor
   colback   AS COLORREF    ' Back color
   colgrid   AS COLORREF    ' Grid color
   coltext   AS COLORREF    ' Text color
   colhilite AS COLORREF    ' Highlight color
   hbrback   AS HBRUSH      ' Back brush
   hpengrd   AS HPEN        ' Grid pen
   hedt      AS HWND        ' Handle of current edit control
   edtrowcol                ' Row & Column of edit
   hmem      AS LPVOID      ' Handle of data memory.
   rpmemfree                ' Relative pointer to next free.
   memsize                  ' Memory size.
   hstr      AS LPSTR       ' Handle of string memory.
   rpstrfree                ' Relative pointer to next free.
   strsize                  ' Memory size.
   lpdata    AS LPBYTE      ' Button cell data
   toprow                   ' The actual row number of the first row displayed
   itemmemsize
   rpitemdata
   XYBlkSelStart
   XYBlkSelEnd
END TYPE


'Column structure
TYPE COLUMN
   colwt       AS Long        'Column width.
   UNION
      lpszhdrtext AS LPSTR    'Pointer to header text.
      rpszhdrtext AS long     'Rel Pointer to header text.
   END UNION
   halign      AS Long        'Header text alignment.
   calign      AS Long        'Column text alignment.
   ctype       AS Long        'Column data type.
   ctextmax    AS Long        'Max text length for TYPE_EDITTEXT and TYPE_EDITLONG.
   UNION
      lpszformat  AS LPSTR    'Pointer to format string for TYPE_EDITLONG.
      rpszformat  AS Long     'Rel Pointer to format string for TYPE_EDITLONG.
   END UNION
   himl        AS HIMAGELIST  'Handle of image list. For the image columns and combobox only.
   hdrflag     AS DWORD       'Header flags.
   colxp       AS Long        'Column position.       Internally used.
   edthwnd     AS HWND        'Column control handle. Internally used.
   hdrmenu     AS HMENU       'User menu for each column header
   cellmenu    AS HMENU       'User menu for each column cell
   UNION
      pColumnColor AS LPCOLUMNCOLOR
      ColumnColor  AS COLUMNCOLOR
   END UNION
   lParam      AS Long        'User defined 32 bit value.
END TYPE

'Header flags
ENUM
   HEADERCLICKED   = 1
   HEADERSORTDIR   = 2
END ENUM




'Notifications structure
TYPE GRIDNOTIFY
   nmhdr   AS NMHDR
   col
   row
   hwnd    AS HWND
   lpdata  AS LPVOID
   fcancel AS BOOL
END TYPE

TYPE GRIDSORT
   Column
   SortDir
   FromRow
   ToRow
END TYPE

'Notification messages
ENUM
   GN_HEADERCLICK  = 1      'User left clicked header
   GN_HEADERMENU            'User right clicked header (context menu select)
   GN_BUTTONCLICK           'Sent when user clicks the button in a button cell
   GN_CELLMENU
   GN_CHECKCLICK            'Sent when user double clicks the checkbox in a checkbox cell
   GN_IMAGECLICK            'Sent when user double clicks the image in an image cell
   GN_BLOCKSELECT           'Sent when a user selects a block of text [ctrl + mouse]
   GN_BEFORESELCHANGE       'Sent when user request a selection change
   GN_AFTERSELCHANGE        'Sent after a selection change
   GN_BEFOREEDIT            'Sent before the cell edit control shows
   GN_AFTEREDIT             'Sent when the cell edit control is about to close
   GN_BEFOREUPDATE          'Sent before a cell updates grid data
   GN_AFTERUPDATE           'Sent after grid data has been updated
   GN_USERCONVERT           'Sent when user cell needs to be converted.
END ENUM


'----------------------------------------------------------------------------------------
' Grid WM_NOTIFY Helpers added by Kevin Diggins
' Renamed to GNV_XXXX to remind us that they are intended within the WM_NOTIFY handler
' GNV means "Grid Notification VALUE"
'----------------------------------------------------------------------------------------
! #define CREATE_GRID_NOTIFY_DEVICE LPGRIDNOTIFY pnmh =(LPGRIDNOTIFY)lParam;
! #define GNV_RAGRID      (pnmh ->nmhdr.hwndFrom)
! #define GNV_GRIDMSG     (pnmh ->nmhdr.code)
! #define GNV_GRIDCOLUMN  (pnmh->col)
! #define GNV_GRIDROW     (pnmh->row)
! #define GNV_DATALONG    (*(long*)pnmh->lpdata)
! #define GNV_DATADOUBLE  (*(double*)pnmh->lpdata)
! #define GNV_CELLTEXT    ((LPSTR)pnmh->lpdata)
! #define GNV_GRIDCBCTL   GNV_DATALONG

CONST GETDATALONG(pbuffer)   = (*(long*)pbuffer)
CONST GETDATADOUBLE(pbuffer) = (*(double*)pbuffer)


'Messages
ENUM
   GM_ADDCOL = WM_USER + 1   'wParam = 0,          lParam = lpCOLUMN
   GM_ADDROW                 'wParam = 0,          lParam = lpROWDATA (can be NULL)
   GM_INSROW                 'wParam = nRow,       lParam = lpROWDATA (can be NULL)
   GM_DELROW                 'wParam = nRow,       lParam = 0
   GM_MOVEROW                'wParam = nFromRow,   lParam = nToRow
   GM_COMBOADDSTRING         'wParam = nCol,       lParam = lpszString
   GM_COMBOCLEAR             'wParam = nCol,       lParam = 0
   GM_GETCURSEL              'wParam = 0,          lParam = 0
   GM_SETCURSEL              'wParam = nCol,       lParam = nRow
   GM_GETCURCOL              'wParam = 0,          lParam = 0
   GM_SETCURCOL              'wParam = nCol,       lParam = 0
   GM_GETCURROW              'wParam = 0,          lParam = 0
   GM_SETCURROW              'wParam = nRow,       lParam = 0
   GM_GETCOLCOUNT            'wParam = 0,          lParam = 0
   GM_GETROWCOUNT            'wParam = 0,          lParam = 0
   GM_GETCELLDATA            'wParam = nColRow,    lParam = lpData
   GM_SETCELLDATA            'wParam = nColRow,    lParam = lpData
   GM_GETCELLRECT            'wParam = nColRow,    lParam = lpRECT
   GM_SCROLLCELL             'wParam = 0,          lParam = 0
   GM_GETBACKCOLOR           'wParam = 0,          lParam = 0
   GM_SETBACKCOLOR           'wParam = nColor,     lParam = 0
   GM_GETGRIDCOLOR           'wParam = 0,          lParam = 0
   GM_SETGRIDCOLOR           'wParam = nColor,     lParam = 0
   GM_GETTEXTCOLOR           'wParam = 0,          lParam = 0
   GM_SETTEXTCOLOR           'wParam = nColor,     lParam = 0
   GM_ENTEREDIT              'wParam = nCol,       lParam = nRow
   GM_ENDEDIT                'wParam = nColRow,    lParam = fCancel
   GM_GETCOLWIDTH            'wParam = nCol,       lParam = 0
   GM_SETCOLWIDTH            'wParam = nCol,       lParam = nWidth
   GM_GETHDRHEIGHT           'wParam = 0,          lParam = 0
   GM_SETHDRHEIGHT           'wParam = 0,          lParam = nHeight
   GM_GETROWHEIGHT           'wParam = 0,          lParam = 0
   GM_SETROWHEIGHT           'wParam = 0,          lParam = nHeight
   GM_RESETCONTENT           'wParam = 0,          lParam = 0
   GM_COLUMNSORT             'wParam = nCol,       lParam = 0-Ascending, 1-Descending, 2-Invert
   GM_COLUMNSORTEX           'wParam = lpGRIDSORT, lParam = 0
   GM_GETBLOCKSELECT         'wParam = pFromColRow,lParam = pToColRow
   GM_GETHDRTEXT             'wParam = nCol,       lParam = lpBuffer
   GM_SETHDRTEXT             'wParam = nCol,       lParam = lpszText
   GM_GETCOLFORMAT           'wParam = nCol,       lParam = lpBuffer
   GM_SETCOLFORMAT           'wParam = nCol,       lParam = lpszText
   GM_CELLCONVERT            'wParam = nColRow,    lParam = lpBuffer
   GM_RESETCOLUMNS           'wParam = 0,          lParam = 0
   GM_GETROWCOLOR            'wParam = nRow,       lParam = lpROWCOLOR
   GM_SETROWCOLOR            'wParam = nRow,       lParam = lpROWCOLOR
   GM_GETCOLDATA             'wParam = nCol,       lParam = lpCOLUMN
   GM_SETROWHIGHLIGHTCLR     'wParam = nColor,     lParam = 0
   GM_AUTOSETCOLWIDTH        'wParam = nCol,       lParam = 0
   GM_GETCOLUMNCOLOR         'wParam = nCol,       lParam = lpCOLUMNCOLOR
   GM_SETCOLUMNCOLOR         'wParam = nCol,       lParam = lpCOLUMNCOLOR
END ENUM                                           
                                                   
'Column alignment                                  
ENUM                                               
   GA_ALIGN_LEFT   = 0                             
   GA_ALIGN_CENTER                                 
   GA_ALIGN_RIGHT                                  
END ENUM                                           
                                                   
'Column types                                      
ENUM                                               
   TYPE_EDITTEXT = 0   'String                   
   TYPE_EDITLONG       'Long
   TYPE_EDITDOUBLE     'Double
   TYPE_CHECKBOX       'Long
   TYPE_COMBOBOX       'Long
   TYPE_HOTKEY         'Long
   TYPE_BUTTON         'String
   TYPE_IMAGE          'Long
   TYPE_DATE           'Long
   TYPE_TIME           'Long
   TYPE_USER           '0=String, 1 to 512 bytes binary data
   TYPE_EDITBUTTON     'String
END ENUM

'Window styles
CONST STYLE_NOSEL      = 0x01
CONST STYLE_NOFOCUS    = 0x02
CONST STYLE_HGRIDLINES = 0x04
CONST STYLE_VGRIDLINES = 0x08
CONST STYLE_GRIDFRAME  = 0x10
CONST STYLE_NOCOLSIZE  = 0x20

CONST ODT_GRID = 6

'Column sorting
ENUM
   SORT_ASCENDING  = 0
   SORT_DESCENDING
   SORT_INVERT
END ENUM


CONST szStaticClass     = "Static"
CONST szListBoxClass    = "ListBox"
CONST szRAListClass     = "RAList"
CONST szEditClass       = "Edit"
CONST szHotKeyClass     = "msctls_hotkey32"
CONST szButtonClass     = "Button"
CONST szDateTimeClass   = "SysDateTimePick32"
CONST szRAGridClass     = "RAGrid"

CONST szToolTip     = "RAGrid control"

' Hotkey text
CONST szCtrl        = "Ctrl + "
CONST szShift       = "Shift + "
CONST szAlt         = "Alt + "

' Cancel edit update
GLOBAL fCancelEdit
GLOBAL ncol
GLOBAL nrow
GLOBAL fsame
GLOBAL fonbtn
GLOBAL lplstproc AS WNDPROC

