

FUNCTION raExpandMem( hMem1 AS LPVOID, nSize AS DWORD) AS HGLOBAL
   DIM RAW	hMem2 AS LPVOID
   DIM RAW LE

   hMem2 = GlobalReAlloc(hMem1, nSize + MEM_SIZE, GMEM_MOVEABLE|GMEM_ZEROINIT)
   IF hMem2 = NULL THEN
      LE = GetLastError()
      MSGBOX "Memory allocation failed!", HEX$(LE)
   END IF

   FUNCTION = hMem2
END FUNCTION


SUB raGridGetText(hMem AS GRID PTR,rpData AS DWORD,lpData AS LPSTR)

   DIM RAW pdata AS LPSTR

   IF rpData THEN
      pdata = (LPSTR)GlobalLock((*hMem).hstr)
      pdata += rpData
      strcpy(lpData, pdata)
      GlobalUnlock((*hMem).hstr)
   ELSE
      *lpData = 0
   END IF
END SUB


SUB raGridGetFixed(hMem AS GRID PTR,rpData AS DWORD,lpData AS LPBYTE,length AS DWORD)

   DIM RAW pdata AS LPBYTE

   IF rpData THEN
      pdata = (LPBYTE)GlobalLock((*hMem).hstr)
      pdata += rpData
      CopyMemory(lpData, pdata, length)
      GlobalUnlock((*hMem).hstr)
   ELSE
      ZeroMemory(lpData, length)
   END IF

END SUB


'returns relative pointer to strfree
FUNCTION raGridAddText(hMem AS GRID PTR,lpData AS LPSTR)
   DIM RAW	length AS DWORD, retval = 0

   IF lpData THEN
      length = LEN(lpData) + 1
      IF NOT (*hMem).hstr THEN
         (*hMem).hstr = (LPSTR)GlobalAlloc(GMEM_MOVEABLE BOR GMEM_ZEROINIT,MEM_SIZE)
         (*hMem).rpstrfree = 4
         (*hMem).strsize = MEM_SIZE
      END IF
      retval = (*hMem).rpstrfree
      IF (retval + length) > (*hMem).strsize THEN
         (*hMem).hstr = (LPSTR)raExpandMem((*hMem).hstr,(*hMem).strsize)
         (*hMem).strsize += MEM_SIZE
      END IF
      DIM RAW tmpstr AS LPSTR
      tmpstr = (LPSTR)GlobalLock((*hMem).hstr)
      tmpstr = tmpstr + (*hMem).rpstrfree
      strcpy(tmpstr, (LPSTR)lpData)
      (*hMem).rpstrfree += length
      GlobalUnlock((*hMem).hstr)
   END IF
   FUNCTION = retval

END FUNCTION


'returns relative pointer to strfree
FUNCTION raGridAddFixed(hMem AS GRID PTR,lpData AS LPBYTE,length AS DWORD)
   DIM RAW retval, pdata AS LPBYTE

   IF NOT (*hMem).hstr THEN
      (*hMem).hstr = (LPSTR)GlobalAlloc(GMEM_MOVEABLE BOR GMEM_ZEROINIT,MEM_SIZE)
      (*hMem).rpstrfree = 4
      (*hMem).strsize = MEM_SIZE
   END IF
   retval = (*hMem).rpstrfree

   IF (retval + length) > (*hMem).strsize THEN
      (*hMem).hstr = (LPSTR)raExpandMem((*hMem).hstr,(*hMem).strsize)
      (*hMem).strsize += MEM_SIZE
   END IF
   pdata = (LPBYTE)GlobalLock((*hMem).hstr)
   pdata += (*hMem).rpstrfree

   CopyMemory(pdata, lpData, length)
   (*hMem).rpstrfree += length
   GlobalUnlock((*hMem).hstr)

   FUNCTION = retval
END FUNCTION


SUB raGridAddPtr(hMem AS GRID PTR,nData AS DWORD)

   DIM RAW pdata AS dword PTR

   IF NOT (*hMem).hmem THEN
      (*hMem).hmem = GlobalAlloc(GMEM_MOVEABLE BOR GMEM_ZEROINIT, MEM_SIZE)
      (*hMem).rpmemfree = 0
      (*hMem).memsize = MEM_SIZE
   END IF

   IF ((*hMem).rpmemfree + 4) >(*hMem).memsize THEN
      (*hMem).hmem = raExpandMem((*hMem).hmem,(*hMem).memsize)
      (*hMem).memsize += MEM_SIZE
   END IF
   pdata = (dword*)GlobalLock((*hMem).hmem)
   pdata = (dword*)((LPBYTE)pdata + (*hMem).rpmemfree)
   *pdata = nData
   (*hMem).rpmemfree += 4
   GlobalUnlock((*hMem).hmem)

END SUB


'returns relative pointer to memfree
FUNCTION raGridAddRowData(hMem AS GRID PTR, lpData AS LPBYTE)
   DIM RAW retval = (*hMem).rpmemfree
   DIM RAW DataSize
   DIM RAW ctype, colcnt
   DIM RAW pCol AS LPCOLUMN
   DIM RAW nret

   pCol = (LPCOLUMN)((LPBYTE) hMem + SIZEOF(GRID))
   raGridAddPtr(hMem,-1)
   raGridAddPtr(hMem,-1)
   colcnt = 0

   WHILE colcnt < (*hMem).cols
      DataSize = 4
      ctype    = (*pCol).ctype
      IF ctype = TYPE_EDITTEXT OR ctype = TYPE_BUTTON OR ctype = TYPE_EDITBUTTON THEN
         nret = 0
         IF lpData THEN
            nret = raGridAddText(hMem, (LPSTR)(*(dword*)lpData))
         END IF
      ELSEIF ctype = TYPE_USER THEN

         IF NOT (*pCol).ctextmax THEN
            IF lpData THEN
               nret = raGridAddText(hMem, (LPSTR)(*(dword*)lpData))
            END IF
         ELSE
            IF lpData THEN
               nret = raGridAddFixed(hMem, (LPBYTE)((dword*)lpData), (*pCol).ctextmax)
            ELSE
               nret = 0
            END IF
         END IF
      ELSEIF ctype = TYPE_EDITDOUBLE THEN
         nret = 0
         IF lpData THEN
            nret = raGridAddFixed(hMem,(LPBYTE)((double*)lpData),SIZEOF(double))
            DataSize = SIZEOF(double)
         END IF

      ELSE
         nret = 0
         IF lpData THEN
            nret = raGridAddFixed(hMem,(LPBYTE)((dword*)lpData),4)
         END IF
      END IF

      raGridAddPtr(hMem, nret)
      IF lpData THEN lpData += DataSize

      pCol = (LPCOLUMN)((LPBYTE)pCol + SIZEOF(COLUMN))
      INCR colcnt
   WEND

   FUNCTION = retval
END FUNCTION


' returns column type
FUNCTION raGridGetCellData(hMem AS GRID PTR,rpData AS DWORD,nCol AS DWORD,lpData AS LPBYTE)
   DIM RAW pCol AS LPCOLUMN
   DIM RAW ctype
   DIM RAW pDword AS DWORD PTR

   pDword = (dword*)GlobalLock((*hMem).hmem)
   pDword = (dword*)((LPBYTE)pDword + rpData)
   pDword = (dword*)((LPBYTE)pDword + nCol*4 + 2*4)

   pCol = (LPCOLUMN)((LPBYTE) hMem + SIZEOF(GRID) + (nCol * SIZEOF(COLUMN)))

   ctype = (*pCol).ctype

   IF ctype = TYPE_EDITTEXT OR ctype = TYPE_BUTTON OR ctype = TYPE_EDITBUTTON THEN
      raGridGetText(hMem, *pDword, (LPSTR)lpData)
   ELSEIF ctype = TYPE_USER THEN
      IF NOT (*pCol).ctextmax THEN
         raGridGetText(hMem, *pDword, (LPSTR)lpData)
      ELSE
         raGridGetFixed(hMem, *pDword, lpData, (*pCol).ctextmax)
      END IF
   ELSEIF ctype = TYPE_EDITDOUBLE THEN
      raGridGetFixed(hMem, *pDword, lpData, SIZEOF(double))
   ELSE
      raGridGetFixed(hMem, *pDword, lpData, 4)
   END IF

   GlobalUnlock((*hMem).hmem)

   FUNCTION = ctype
END FUNCTION


SUB raGridGetRowColor(hMem AS GRID PTR,rpData AS DWORD,lpROWCOLOR AS ROWCOLOR PTR)

   DIM RAW rc AS ROWCOLOR PTR

   rc = (LPROWCOLOR)GlobalLock((*hMem).hmem)
   rc = (LPROWCOLOR)((LPBYTE)rc + rpData)
   (*lpROWCOLOR).backcolor = (*rc).backcolor
   (*lpROWCOLOR).textcolor = (*rc).textcolor
   GlobalUnlock((*hMem).hmem)

END SUB


SUB raGridSetRowColor(hMem AS GRID PTR,rpData AS DWORD,lpROWCOLOR AS ROWCOLOR PTR)

   DIM RAW rc AS ROWCOLOR PTR

   rc = (LPROWCOLOR)GlobalLock((*hMem).hmem)
   rc = (LPROWCOLOR)((LPBYTE)rc + rpData)
   (*rc).backcolor = (*lpROWCOLOR).backcolor
   (*rc).textcolor = (*lpROWCOLOR).textcolor
   GlobalUnlock((*hMem).hmem)

END SUB


SUB raGridSetCellData(hMem AS GRID PTR,rpData AS DWORD,nCol AS DWORD,lpData AS LPBYTE)
   DIM RAW length AS DWORD, length2 AS DWORD
   DIM RAW pDword AS DWORD PTR
   DIM RAW pCol AS LPCOLUMN
   DIM RAW DataSize


   pDword = (dword*)GlobalLock((*hMem).hmem)
   pDword = (dword*)((LPBYTE)pDword + rpData)
   pDword = (dword*)((LPBYTE)pDword + nCol*4 + 2*4)

   pCol = (LPCOLUMN)((LPBYTE) hMem + SIZEOF(GRID) + (nCol * SIZEOF(COLUMN)))

   IF (*pCol).ctype = TYPE_EDITTEXT OR (*pCol).ctype = TYPE_BUTTON OR (*pCol).ctype = TYPE_EDITBUTTON THEN
      GOTO	UpdateText
   ELSEIF (*pCol).ctype = TYPE_USER THEN
      IF NOT (*pCol).ctextmax THEN
         GOTO	UpdateText
      ELSE
         DataSize = (*pCol).ctextmax
         GOTO	UpdateFixed
      END IF
   ELSEIF (*pCol).ctype = TYPE_EDITDOUBLE THEN
      DataSize = SIZEOF(double)
      GOTO	UpdateFixed
   ELSE
      DataSize = SIZEOF(long)
      GOTO	UpdateFixed
   END IF


   UpdateText:
   IF lpData THEN
      length = LEN((LPSTR)lpData) + 1

      IF (length + (*hMem).rpstrfree) > (*hMem).strsize THEN
         (*hMem).hstr = (LPSTR)raExpandMem((*hMem).hstr,(*hMem).strsize)
         (*hMem).strsize += MEM_SIZE
      END IF
      DIM RAW tstr AS LPSTR
      tstr = (LPSTR)GlobalLock((*hMem).hstr)
      length2 = *pDword
      IF length2 THEN
         length2 = strlen(tstr + length2) + 1
      END IF
      IF length2 >= length THEN
         tstr += *pDword
         strcpy(tstr,(LPSTR)lpData)
      ELSE
         *pDword = (*hMem).rpstrfree
         tstr = tstr + (*hMem).rpstrfree
         (*hMem).rpstrfree += length
         strcpy(tstr,(LPSTR)lpData)
      END IF

      GlobalUnlock((*hMem).hstr)
   ELSE
      *pDword = 0
   END IF

   GlobalUnlock((*hMem).hmem)
   EXIT SUB


   UpdateFixed:
   DIM RAW tmp AS dword, tstr AS LPSTR

   IF lpData THEN
      tmp = *pDword
      IF NOT tmp THEN
         tmp = (*hMem).rpstrfree
         *pDword = tmp
         tmp += DataSize
         (*hMem).rpstrfree = tmp
         IF tmp > (*hMem).strsize THEN
            (*hMem).hstr = (LPSTR)raExpandMem((*hMem).hstr,(*hMem).strsize)
            (*hMem).strsize += MEM_SIZE
         END IF
      END IF

      tstr = (LPSTR)GlobalLock((*hMem).hstr)
      tstr = tstr + *pDword

      IF lpData THEN
         memcpy(tstr, lpData, DataSize)
      ELSE
         ZeroMemory(tstr, DataSize)
      END IF
      GlobalUnlock((*hMem).hstr)
   ELSE
      *pDword = 0
   END IF

   GlobalUnlock((*hMem).hmem)

END SUB



SUB raGridSortColumn (pGrid AS LPGRID, BYREF pGrdSort AS GRIDSORT)

   DIM RAW lpLBMem AS DWORD PTR
   DIM RAW pCol AS LPCOLUMN
   DIM RAW fStr, count


   pCol  = (LPCOLUMN)((LPBYTE)pGrid + SIZEOF(GRID) + (pGrdSort.Column * SIZEOF(COLUMN)))

   fStr = 0
   SELECT CASE (*pCol).ctype

      CASE TYPE_EDITTEXT, TYPE_BUTTON, TYPE_EDITBUTTON
      fStr = -1
      
      CASE TYPE_EDITDOUBLE
      fStr = -2
      
      CASE TYPE_USER
      IF NOT (*pCol).lParam THEN EXIT SUB
      fpUserSort = (fpUserSort_TYPE)(*pCol).lParam

      IF (*pCol).ctextmax THEN
         fStr = (*pCol).ctextmax
      ELSE
         fStr = -1
      END IF

   END SELECT

   IF pGrdSort.SortDir = SORT_ASCENDING THEN
      (*pCol).hdrflag = (*pCol).hdrflag BAND (~HEADERSORTDIR)
      pGrdSort.SortDir = 0
   ELSEIF pGrdSort.SortDir = SORT_DESCENDING THEN
      (*pCol).hdrflag = (*pCol).hdrflag BOR HEADERSORTDIR
      pGrdSort.SortDir = 1
   ELSE
      'Sort invert
      (*pCol).hdrflag = (*pCol).hdrflag XOR HEADERSORTDIR
      pGrdSort.SortDir = (*pCol).hdrflag BAND HEADERSORTDIR
   END IF

   lpLBMem  = (DWORD*)((LPBYTE)pGrid + (*pGrid).rpitemdata)
   '-----------------------------
   'These 2 variables are global
   '-----------------------------
   lpQStr   = (LPSTR) GlobalLock((*pGrid).hstr)
   lpQMem   = (DWORD*)GlobalLock((*pGrid).hmem)
   lpQMem   = (DWORD*)((LPBYTE)lpQMem + (pGrdSort.Column * 4) + (2 * 4))

   IF NOT pGrdSort.ToRow THEN
      count = (*pGrid).rows
   ELSE
      count = (pGrdSort.ToRow - pGrdSort.FromRow) + 1
      lpLBMem = lpLBMem + pGrdSort.FromRow
   END IF

   raGridSort(lpLBMem, count, fStr, pGrdSort.SortDir)

   GlobalUnlock((*pGrid).hmem)
   GlobalUnlock((*pGrid).hstr)


END SUB
