GUI "Form1",PIXELS

CONST Lvw1_Style = WS_CHILD|WS_VISIBLE|WS_CLIPCHILDREN|WS_TABSTOP| _
   LVS_REPORT|LVS_SINGLESEL|LVS_SHOWSELALWAYS |LVS_EDITLABELS' _
CONST Lvw1_ExtStyle = WS_EX_CLIENTEDGE | LVS_EX_GRIDLINES '| LVS_EX_TWOCLICKACTIVATE
CONST Edit1_Style    = WS_CHILD|WS_VISIBLE|ES_WANTRETURN |ES_MULTILINE |ES_AUTOVSCROLL       'WS_TABSTOP
CONST Edit1_ExtStyle = WS_EX_STATICEDGE


ENUM
   ID_Lvw1
   ID_Edit1
END ENUM

GLOBAL Form1 AS HWND
GLOBAL hLvw1 AS CONTROL
GLOBAL hEdit1 AS CONTROL

SUB FORMLOAD()
   Dim myTimer as DOUBLE
   
   Form1 = BCX_FORM("Form1", 100, 200, 556, 372)
   hLvw1 = BCX_LISTVIEW("",Form1,ID_Lvw1, 0, 0, 550, 275,Lvw1_Style,Lvw1_ExtStyle,1) '%NUMCOLS%)
   hEdit1 = BCX_EDIT("",Form1,ID_Edit1, 0,0,0,0,Edit1_Style, Edit1_ExtStyle)
   HIDE(hEdit1)
   Call LOADFILE2LV(hLvw1, "test1.txt")
   CENTER(Form1)
   SHOW(Form1)
END SUB

BEGIN EVENTS
Dim pNmLV AS LPNM_LISTVIEW
Dim buffer$
Dim subitemRect as RECT
Dim ParentRect as RECT
GLOBAL EditCol as INT
GLOBAL EditRow as INT


 SELECT CASE CBMSG

  CASE WM_COMMAND
   IF CBCTL = ID_Edit1 then
      If CBCTLMSG  = EN_UPDATE  then   'EN_CHANGE
         buffer$ = BCX_GET_TEXT$(hEdit1)
         LvSetItemText(hLvw1, EditRow, EditCol, TRIM$( buffer$))
         If Instr(buffer$, crlf$) then       ' OR Instr(buffer$, tab$)       '
           EditCol++
           IF EditCol >= ColCount(hLvw1) then
             EditCol = 1
             EditRow++
             If EditRow >= LvGetCount(hLvw1) then          'it's a new row so add it
                 LvAddItem(hLvw1,EditRow,str$(EditRow+1))
             End If
           End If
           MoveLV_Editbox(hLvw1, hEdit1, EditRow, EditRow)
         End If
      End If
   END IF

  CASE WM_NOTIFY
    pNmLV = (NM_LISTVIEW*)lParam'LPNMHDR
    IF pNmLV->hdr.hwndFrom = hLvw1 THEN  'message from LV control
      IF pNmLV->hdr.code = NM_DBLCLK OR pNmLV->hdr.code = NM_RETURN THEN
         IF pNmLV->iItem > -1 then
           EditCol = pNmLV->iSubItem
           EditRow = pNmLV->iItem
           MoveLV_Editbox(hLvw1, hEdit1, EditRow, EditRow)
         END IF
      ELSEIF pNmLV->hdr.code = NM_CLICK THEN
        HIDE(hEdit1)
      END IF
      EXIT FUNCTION
    END IF

  END SELECT
END EVENTS

FUNCTION MoveLV_Editbox(hLV AS HWND, hEdit AS HWND, row, col)
   Dim subitemRect as RECT
   Dim buffer$
   ListView_GetItemText( hLV, EditRow, EditCol, buffer$, SIZEOF(buffer$) )
   subitemRect = GetLVRect(hLV, EditRow, EditCol)
   Call SetLVEditbox(hEdit, subitemRect, trim$(buffer$))
END FUNCTION

FUNCTION ColCount(hwnd AS HWND) AS INTEGER
  DIM RAW hHeader AS HWND
  hHeader = ListView_GetHeader(hwnd)
  IF hHeader = NULL THEN FUNCTION = 0
  FUNCTION = Header_GetItemCount(hHeader)
END FUNCTION

FUNCTION GetLVRect(hWnd AS HWND, row, col) as RECT
     Dim subitemRect AS RECT
     ListView_GetSubItemRect( hLvw1, row, col, LVIR_LABEL, &subitemRect)
     Function =  subitemRect
END FUNCTION

FUNCTION SetLVEditbox(hWnd AS HWND, subitemRect as RECT, txt$)
   MoveWindow(hWnd,subitemRect.left+GetSystemMetrics(SM_CXSIZEFRAME), _
      subitemRect.top+GetSystemMetrics(SM_CYSIZEFRAME), _
      subitemRect.right - subitemRect.left, _
      subitemRect.bottom - subitemRect.top,1)
   BCX_SET_TEXT(hWnd,txt$)
   SendMessage(hWnd, EM_SETSEL, Len(txt$),Len(txt$))
   SHOW(hWnd)
   SetFocus(hWnd)
   Function = 0
END FUNCTION

'Load a comma deliminated file to the listview
FUNCTION LOADFILE2LV(hLV as HWND, FileName$)
Dim Buffer$
Dim MaxCols
Dim Rows
Dim i, j
Dim items$
Dim colNames$[20]

   If Exist(FileName) Then
      Open FileName$ FOR INPUT AS hFP1
      LINE INPUT hFP1, Buffer$
      MaxCols = PARSECOUNT(Buffer$)
      '1st line is the listview headers
      For i = 1 to MaxCols +1
         colNames$[i] = PARSE$(Buffer$, chr(44), i)
      Next i
   Else
      Function = 0
   End If
   LvClear(hLV)
   Dim Width
   Width = (525/(MaxCols-1)) -1   'listview width - 25(col 0 width)
   For i = 0 to MaxCols -1
      If i = 0 then
        LvSetColWidth(hLV,i,25)
      Else
        LvAddCol(hLV,i,colNames$[i+1],Width )
      End If
   Next i
   i = 0
   While not EOF(hFP1)
      LINE INPUT hFP1, Buffer$
      For j = 0 to MaxCols -1
        items$ = PARSE$(Buffer$,chr$(44), j+1)
        IF j = 0 then
          LvAddItem(hLV,i,str$(i+1))'str$(i))  'Add a line
        else
           ListView_SetItemText(hLvw1, i, j, (LPSTR)items$)
        end IF
      Next j
      i++
   Wend
   SendMessage( hLV, WM_SETREDRAW, TRUE, 0 ) 
END FUNCTION


' AUTHOR: Andreas Guenther
'   DESC: Insert a new Item to a ListView.
' SYNTAX: NewIndex% = LvAddItem(hlistview, 5, "Some text")
'  NOTES: Returns the Index of the new Item or -1 if failed.
'
FUNCTION LvAddItem(hwnd AS HWND, idx%, stxt$) AS INTEGER
  DIM lvItem AS LV_ITEM

  lvItem.mask       = LVIF_TEXT
  lvItem.cchTextMax = 255
  lvItem.pszText    = stxt$
  lvItem.iItem      = idx%
  lvItem.iSubItem   = 0
 FUNCTION = ListView_InsertItem(hwnd, &lvItem)
END SUB

' AUTHOR: Andreas Guenther
'   DESC: Set the Text of a specified Item or SubItem in a Listview.
' SYNTAX: LvSetItemText(hlistview, 10, 0, "a changed text")
'  NOTES: The Item/SubItem must exist.
'         To set the text of a Item, <subidx%> must be 0. 
'         For SubItems it is important that the first Column starts with 1.
'
SUB LvSetItemText(hwnd AS HWND, idx%, subidx%, stxt$)
  ListView_SetItemText(hwnd, idx%, subidx%, (LPSTR)stxt$)
END SUB

' AUTHOR: Andreas Guenther
'   DESC: Clearout all Items in a Listview.
' SYNTAX: LvClear(hlistview)
'
SUB LvClear(hwnd AS HWND)
  ListView_DeleteAllItems(hwnd)
END SUB

' AUTHOR: Andreas Guenther
'   DESC: Inserts a new column in a Listview control.
' SYNTAX: inewcol% = LvAddCol(hlistview, 2, "sometext")
'  NOTES: Returns the index of the new column if successful,
'         or -1 otherwise.
'         This is the easiest possible implementation to 
'         add new columns.
'         Text is always aligned left.
'         The columnwidth is determined from the inserted text.
'         No support for Images.
'
FUNCTION LvAddCol Optional (hwnd AS HWND, icol%, stxt$, Width = 200)
  DIM lvc     AS LV_COLUMN
  DIM RAW sz  AS SIZE
  DIM RAW hdc AS HDC

  sz.cx = Width '100
  hdc = GetDC(hwnd)
  lvc.mask = LVCF_TEXT | LVCF_FMT | LVCF_WIDTH
  lvc.fmt  = LVCFMT_LEFT
  lvc.pszText = stxt$
  lvc.cx   = sz.cx
 FUNCTION = ListView_InsertColumn(hwnd, icol%, &lvc)
END FUNCTION

' AUTHOR: Andreas Guenther
'   DESC: Get the Text of a specified Item or SubItem from a Listview.
' SYNTAX: stxt$ = LvGetItemText$(hlistview, 3, 0)
'  NOTES: To get the text of a Item, <subidx%> must be 0. 
'         For SubItems it is important that the first Column starts with 1.
'
FUNCTION LvGetItemText$(hwnd AS HWND, idx%, subidx%)
  DIM retstr$
  ListView_GetItemText(hwnd, idx%, subidx%, (LPSTR) retstr$, 255)
 FUNCTION = retstr$
END FUNCTION

' AUTHOR: Andreas Guenther
'   DESC: Retrieves the number of items in a Listview control.
' SYNTAX: icount% = LvGetCount(hlistview)
'  NOTES: Returns the number of items.
'
FUNCTION LvGetCount(hwnd AS HWND) AS INTEGER
 FUNCTION = ListView_GetItemCount(hwnd)
END FUNCTION

' AUTHOR: Andreas Guenther
'   DESC: Used to change the width of a column in report view
'         or the width of all columns in listview mode.
' SYNTAX: bresult = LvSetColWidth(hlistview, 3, 200)
'  NOTES: Returns TRUE if successful or FALSE otherwise.
'
FUNCTION LvSetColWidth(hwnd AS HWND, icol%, width%) AS BOOL
 FUNCTION = ListView_SetColumnWidth(hwnd, icol%, width%)
END FUNCTION

FUNCTION PARSE$ OPTIONAL( s$, d$ = ",", cnt% =1 )
FUNCTION = STRTOKEN$(s$, d$, cnt)
End FUNCTION


FUNCTION PARSECOUNT OPTIONAL(InString$, delimiter$ = ",") as INTEGER
FUNCTION = 1+ TALLY(InString$, delimiter$ )
END FUNCTION

